import { constant, curried } from './function';
export function applyFirst(F) {
    return (fa, fb) => F.ap(F.map(fa, constant), fb);
}
export function applySecond(F) {
    return (fa, fb) => F.ap(F.map(fa, () => (b) => b), fb);
}
export function liftA2(F) {
    return f => fa => fb => F.ap(F.map(fa, f), fb);
}
export function liftA3(F) {
    return f => fa => fb => fc => F.ap(F.ap(F.map(fa, f), fb), fc);
}
export function liftA4(F) {
    return f => fa => fb => fc => fd => F.ap(F.ap(F.ap(F.map(fa, f), fb), fc), fd);
}
export function getSemigroup(F, S) {
    const f = (a) => (b) => S.concat(a, b);
    return () => ({
        concat: (x, y) => F.ap(F.map(x, f), y)
    });
}
const tupleConstructors = {};
export function sequenceT(F) {
    return (...args) => {
        const len = args.length;
        let f = tupleConstructors[len];
        if (!Boolean(f)) {
            f = tupleConstructors[len] = curried((...args) => args, len - 1, []);
        }
        let r = F.map(args[0], f);
        for (let i = 1; i < len; i++) {
            r = F.ap(r, args[i]);
        }
        return r;
    };
}
export function sequenceS(F) {
    return r => {
        const keys = Object.keys(r);
        const fst = keys[0];
        const others = keys.slice(1);
        let fr = F.map(r[fst], a => ({ [fst]: a }));
        for (const key of others) {
            fr = F.ap(F.map(fr, r => (a) => {
                r[key] = a;
                return r;
            }), r[key]);
        }
        return fr;
    };
}
