"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var axis_utils_1 = require("../../lib/axes/axis_utils");
var specs_1 = require("../../lib/series/specs");
var Axis = /** @class */ (function (_super) {
    __extends(Axis, _super);
    function Axis() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderTickLabel = function (tick, i) {
            var _a = _this.props.axisSpec, tickSize = _a.tickSize, tickPadding = _a.tickPadding, position = _a.position;
            var textProps = {};
            if (axis_utils_1.isVertical(position)) {
                textProps.y = tick.position;
                textProps.textAnchor = position === 'left' ? 'end' : 'start';
                textProps.x = position === 'left' ? 0 : tickSize + tickPadding;
                textProps.dominantBaseline = 'middle';
            }
            else {
                textProps.y = position === 'top' ? 0 : tickSize + tickPadding;
                textProps.x = tick.position;
                textProps.textAnchor = 'middle';
                textProps.dominantBaseline = 'hanging';
            }
            // const transform = `translate(${textProps.x}, ${textProps.y})`;
            return (react_1.default.createElement("text", __assign({ className: "euiSeriesChartAxis_tickLabel", key: "tick-" + i }, textProps), tick.label));
        };
        _this.renderTickLine = function (tick, i) {
            var _a = _this.props, _b = _a.axisSpec, tickSize = _b.tickSize, tickPadding = _b.tickPadding, position = _b.position, maxLabelBboxHeight = _a.axisTicksDimensions.maxLabelBboxHeight;
            var lineProps = {};
            if (axis_utils_1.isVertical(position)) {
                lineProps.x1 = position === 'left' ? tickPadding : 0;
                lineProps.x2 = position === 'left' ? tickSize + tickPadding : tickSize;
                lineProps.y1 = tick.position;
                lineProps.y2 = tick.position;
            }
            else {
                lineProps.x1 = tick.position;
                lineProps.x2 = tick.position;
                lineProps.y1 = position === 'top' ? maxLabelBboxHeight + tickPadding : 0;
                lineProps.y2 = position === 'top' ? maxLabelBboxHeight + tickPadding + tickSize : tickSize;
            }
            return react_1.default.createElement("line", __assign({ className: "euiSeriesChartAxis_tickLine", key: "tick-" + i }, lineProps));
        };
        _this.renderAxis = function () {
            var _a = _this.props, ticks = _a.ticks, axisPosition = _a.axisPosition;
            var translation = "translate(" + axisPosition.left + " " + axisPosition.top + ")";
            return (react_1.default.createElement("g", { className: "euiSeriesChartAxis", transform: translation },
                react_1.default.createElement("g", { className: "euiSeriesChartAxis_lineGroup" }, _this.renderLine()),
                react_1.default.createElement("g", { className: "euiSeriesChartAxis_ticksGroup" }, ticks.map(_this.renderTickLine)),
                react_1.default.createElement("g", { className: "euiSeriesChartAxis_tickLabelsGroup" }, ticks.filter(function (tick) { return tick.label !== null; }).map(_this.renderTickLabel)),
                _this.renderAxisTitle()));
        };
        _this.renderLine = function () {
            var _a = _this.props, _b = _a.axisSpec, tickSize = _b.tickSize, tickPadding = _b.tickPadding, position = _b.position, axisPosition = _a.axisPosition, axisTicksDimensions = _a.axisTicksDimensions;
            var lineProps = {};
            if (orientation === 'vertical') {
                lineProps.x1 = position === 'left' ? tickSize + tickPadding : 0;
                lineProps.x2 = position === 'left' ? tickSize + tickPadding : 0;
                lineProps.y1 = 0;
                lineProps.y2 = axisPosition.height;
            }
            else {
                lineProps.x1 = 0;
                lineProps.x2 = axisPosition.width;
                lineProps.y1 =
                    position === 'top' ? axisTicksDimensions.maxLabelBboxHeight + tickSize + tickPadding : 0;
                lineProps.y2 =
                    position === 'top' ? axisTicksDimensions.maxLabelBboxHeight + tickSize + tickPadding : 0;
            }
            return react_1.default.createElement("line", __assign({ className: "euiSeriesChartAxis_line" }, lineProps));
        };
        return _this;
    }
    Axis.prototype.render = function () {
        return this.renderAxis();
    };
    Axis.prototype.renderAxisTitle = function () {
        var _a = this.props.axisSpec, title = _a.title, position = _a.position;
        if (!title) {
            return null;
        }
        if (axis_utils_1.isHorizontal(position)) {
            return this.renderHoriziontalAxisTitle();
        }
        return this.renderVerticalAxisTitle();
    };
    Axis.prototype.renderVerticalAxisTitle = function () {
        var _a = this.props, height = _a.axisPosition.height, _b = _a.axisSpec, title = _b.title, position = _b.position, tickSize = _b.tickSize, tickPadding = _b.tickPadding, maxLabelBboxWidth = _a.axisTicksDimensions.maxLabelBboxWidth, chartMargins = _a.chartTheme.chartMargins;
        var top = height / 2;
        var left = position === specs_1.Position.Left
            ? -(maxLabelBboxWidth + chartMargins.left / 2)
            : tickSize + tickPadding + maxLabelBboxWidth + +chartMargins.right / 2;
        var translate = "translate(" + left + " " + top + ") rotate(-90)";
        return (react_1.default.createElement("g", { className: "euiSeriesChartAxis_axisTitle" },
            react_1.default.createElement("text", { textAnchor: "middle", dominantBaseline: "middle", transform: translate }, title)));
    };
    Axis.prototype.renderHoriziontalAxisTitle = function () {
        var _a = this.props, width = _a.axisPosition.width, _b = _a.axisSpec, title = _b.title, position = _b.position, tickSize = _b.tickSize, tickPadding = _b.tickPadding, maxLabelBboxHeight = _a.axisTicksDimensions.maxLabelBboxHeight, chartMargins = _a.chartTheme.chartMargins;
        var top = position === specs_1.Position.Top
            ? -chartMargins.top / 2
            : maxLabelBboxHeight + tickPadding + tickSize + chartMargins.bottom / 2;
        var left = width / 2;
        var translate = "translate(" + left + " " + top + " )";
        return (react_1.default.createElement("g", { className: "euiSeriesChartAxis_axisTitle" },
            react_1.default.createElement("text", { textAnchor: "middle", dominantBaseline: "middle", transform: translate }, title)));
    };
    return Axis;
}(react_1.default.PureComponent));
exports.Axis = Axis;
//# sourceMappingURL=axis.js.map