"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var axis_utils_1 = require("../../lib/axes/axis_utils");
var specs_1 = require("../../lib/series/specs");
var Axis = /** @class */ (function (_super) {
    __extends(Axis, _super);
    function Axis() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderTickLabel = function (tick, i) {
            var _a = _this.props.chartTheme.axes.tickLabelStyle, padding = _a.padding, labelStyle = __rest(_a, ["padding"]);
            var _b = _this.props, _c = _b.axisSpec, tickSize = _c.tickSize, tickPadding = _c.tickPadding, position = _c.position, axisTicksDimensions = _b.axisTicksDimensions, debug = _b.debug;
            var tickLabelRotation = _this.props.axisSpec.tickLabelRotation || 0;
            var tickLabelProps = axis_utils_1.getTickLabelProps(tickLabelRotation, tickSize, tickPadding, tick.position, position, axisTicksDimensions);
            var maxLabelTextWidth = axisTicksDimensions.maxLabelTextWidth, maxLabelTextHeight = axisTicksDimensions.maxLabelTextHeight;
            var centeredRectProps = axis_utils_1.centerRotationOrigin(axisTicksDimensions, {
                x: tickLabelProps.x,
                y: tickLabelProps.y,
            });
            var textProps = __assign({ width: maxLabelTextWidth, height: maxLabelTextHeight, rotation: tickLabelRotation }, tickLabelProps, centeredRectProps);
            return (react_1.default.createElement(react_konva_1.Group, { key: "tick-" + i },
                debug && react_1.default.createElement(react_konva_1.Rect, __assign({}, textProps, { stroke: "black", strokeWidth: 1, fill: "violet" })),
                react_1.default.createElement(react_konva_1.Text, __assign({}, textProps, labelStyle, { text: tick.label }))));
        };
        _this.renderTickLine = function (tick, i) {
            var _a = _this.props, _b = _a.axisSpec, tickSize = _b.tickSize, tickPadding = _b.tickPadding, position = _b.position, maxLabelBboxHeight = _a.axisTicksDimensions.maxLabelBboxHeight, tickLineStyle = _a.chartTheme.axes.tickLineStyle;
            var lineProps = axis_utils_1.isVertical(position)
                ? axis_utils_1.getVerticalAxisTickLineProps(position, tickPadding, tickSize, tick.position)
                : axis_utils_1.getHorizontalAxisTickLineProps(position, tickPadding, tickSize, tick.position, maxLabelBboxHeight);
            return react_1.default.createElement(react_konva_1.Line, __assign({ key: "tick-" + i, points: lineProps }, tickLineStyle));
        };
        _this.renderAxis = function () {
            var _a = _this.props, ticks = _a.ticks, axisPosition = _a.axisPosition;
            return (react_1.default.createElement(react_konva_1.Group, { x: axisPosition.left, y: axisPosition.top },
                react_1.default.createElement(react_konva_1.Group, { key: "lines" }, _this.renderAxisLine()),
                react_1.default.createElement(react_konva_1.Group, { key: "tick-lines" }, ticks.map(_this.renderTickLine)),
                react_1.default.createElement(react_konva_1.Group, { key: "ticks" }, ticks.filter(function (tick) { return tick.label !== null; }).map(_this.renderTickLabel)),
                _this.renderAxisTitle()));
        };
        _this.renderAxisLine = function () {
            var _a = _this.props, _b = _a.axisSpec, tickSize = _b.tickSize, tickPadding = _b.tickPadding, position = _b.position, axisPosition = _a.axisPosition, axisTicksDimensions = _a.axisTicksDimensions, axisLineStyle = _a.chartTheme.axes.axisLineStyle;
            var lineProps = [];
            if (axis_utils_1.isVertical(position)) {
                lineProps[0] = position === specs_1.Position.Left ? tickSize + tickPadding : 0;
                lineProps[2] = position === specs_1.Position.Left ? tickSize + tickPadding : 0;
                lineProps[1] = 0;
                lineProps[3] = axisPosition.height;
            }
            else {
                lineProps[0] = 0;
                lineProps[2] = axisPosition.width;
                lineProps[1] =
                    position === specs_1.Position.Top
                        ? axisTicksDimensions.maxLabelBboxHeight + tickSize + tickPadding
                        : 0;
                lineProps[3] =
                    position === specs_1.Position.Top
                        ? axisTicksDimensions.maxLabelBboxHeight + tickSize + tickPadding
                        : 0;
            }
            return react_1.default.createElement(react_konva_1.Line, __assign({ points: lineProps }, axisLineStyle));
        };
        return _this;
    }
    Axis.prototype.render = function () {
        return this.renderAxis();
    };
    Axis.prototype.renderAxisTitle = function () {
        var _a = this.props.axisSpec, title = _a.title, position = _a.position;
        if (!title) {
            return null;
        }
        if (axis_utils_1.isHorizontal(position)) {
            return this.renderHorizontalAxisTitle();
        }
        return this.renderVerticalAxisTitle();
    };
    Axis.prototype.renderVerticalAxisTitle = function () {
        var _a = this.props, height = _a.axisPosition.height, _b = _a.axisSpec, title = _b.title, position = _b.position, tickSize = _b.tickSize, tickPadding = _b.tickPadding, maxLabelBboxWidth = _a.axisTicksDimensions.maxLabelBboxWidth, axisTitleStyle = _a.chartTheme.axes.axisTitleStyle, debug = _a.debug;
        if (!title) {
            return null;
        }
        var padding = axisTitleStyle.padding, titleStyle = __rest(axisTitleStyle, ["padding"]);
        var top = height;
        var left = position === specs_1.Position.Left
            ? -(maxLabelBboxWidth + titleStyle.fontSize + padding)
            : tickSize + tickPadding + maxLabelBboxWidth + padding;
        return (react_1.default.createElement(react_konva_1.Group, null,
            debug && (react_1.default.createElement(react_konva_1.Rect, { x: left, y: top, width: height, height: titleStyle.fontSize, fill: "violet", stroke: "black", strokeWidth: 1, rotation: -90 })),
            react_1.default.createElement(react_konva_1.Text, __assign({ align: "center", x: left, y: top, text: title, width: height, rotation: -90 }, titleStyle))));
    };
    Axis.prototype.renderHorizontalAxisTitle = function () {
        var _a = this.props, _b = _a.axisPosition, width = _b.width, height = _b.height, _c = _a.axisSpec, title = _c.title, position = _c.position, tickSize = _c.tickSize, tickPadding = _c.tickPadding, maxLabelBboxHeight = _a.axisTicksDimensions.maxLabelBboxHeight, _d = _a.chartTheme.axes.axisTitleStyle, padding = _d.padding, titleStyle = __rest(_d, ["padding"]), debug = _a.debug;
        if (!title) {
            return;
        }
        var top = position === specs_1.Position.Top
            ? -maxLabelBboxHeight - padding
            : maxLabelBboxHeight + tickPadding + tickSize + padding;
        var left = 0;
        return (react_1.default.createElement(react_konva_1.Group, null,
            debug && (react_1.default.createElement(react_konva_1.Rect, { x: left, y: top, width: width, height: titleStyle.fontSize, stroke: "black", strokeWidth: 1, fill: "violet" })),
            react_1.default.createElement(react_konva_1.Text, __assign({ align: "center", x: left, y: top, width: width, height: height, text: title }, titleStyle))));
    };
    return Axis;
}(react_1.default.PureComponent));
exports.Axis = Axis;
//# sourceMappingURL=axis.js.map