"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var eui_1 = require("@elastic/eui");
var classnames_1 = __importDefault(require("classnames"));
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var LegendElementComponent = /** @class */ (function (_super) {
    __extends(LegendElementComponent, _super);
    function LegendElementComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.closeColorPicker = function () {
            _this.setState({
                isColorPickerOpen: false,
            });
        };
        _this.toggleColorPicker = function () {
            _this.setState({
                isColorPickerOpen: !_this.state.isColorPickerOpen,
            });
        };
        _this.onLegendTitleClick = function (legendItemKey) { return function () {
            _this.props.chartStore.onLegendItemClick(legendItemKey);
        }; };
        _this.onLegendItemPanelClose = function () {
            // tslint:disable-next-line:no-console
            console.log('close');
        };
        _this.onColorPickerChange = function (legendItemKey) { return function (color) {
            _this.props.chartStore.setSeriesColor(legendItemKey, color);
        }; };
        _this.renderPlusButton = function () {
            return (react_1.default.createElement(eui_1.EuiButtonIcon, { onClick: _this.props.chartStore.onLegendItemPlusClick, iconType: "plusInCircle", "aria-label": "minus" }));
        };
        _this.renderMinusButton = function () {
            return (react_1.default.createElement(eui_1.EuiButtonIcon, { onClick: _this.props.chartStore.onLegendItemMinusClick, iconType: "minusInCircle", "aria-label": "minus" }));
        };
        _this.onVisibilityClick = function (legendItemKey) { return function (event) {
            if (event.shiftKey) {
                _this.props.chartStore.toggleSingleSeries(legendItemKey);
            }
            else {
                _this.props.chartStore.toggleSeriesVisibility(legendItemKey);
            }
        }; };
        _this.renderVisibilityButton = function (legendItemKey, isSeriesVisible) {
            if (isSeriesVisible === void 0) { isSeriesVisible = true; }
            var iconType = isSeriesVisible ? 'eye' : 'eyeClosed';
            return (react_1.default.createElement(eui_1.EuiButtonIcon, { onClick: _this.onVisibilityClick(legendItemKey), iconType: iconType, "aria-label": "toggle visibility" }));
        };
        _this.state = {
            isColorPickerOpen: false,
        };
        return _this;
    }
    LegendElementComponent.prototype.renderDisplayValue = function (displayValue, show) {
        if (!show) {
            return;
        }
        return (react_1.default.createElement(eui_1.EuiText, { size: "xs", className: "eui-textTruncate elasticChartsLegendListItem__displayValue", title: displayValue }, displayValue));
    };
    LegendElementComponent.prototype.render = function () {
        var _a, _b;
        var legendItemKey = this.props.legendItemKey;
        var _c = this.props, color = _c.color, label = _c.label, isSeriesVisible = _c.isSeriesVisible, displayValue = _c.displayValue;
        var _d = this.props, className = _d.className, onMouseEnter = _d.onMouseEnter, onMouseLeave = _d.onMouseLeave;
        var onTitleClick = this.onLegendTitleClick(legendItemKey);
        var showLegendDisplayValue = this.props.chartStore.showLegendDisplayValue.get();
        var isSelected = legendItemKey === this.props.chartStore.selectedLegendItemKey.get();
        var titleClassNames = classnames_1.default('eui-textTruncate', 'elasticChartsLegendListItem__title', (_a = {},
            _a['elasticChartsLegendListItem__title--selected'] = isSelected,
            _a['elasticChartsLegendListItem__title--hasDisplayValue'] = this.props.chartStore.showLegendDisplayValue.get(),
            _a));
        var colorDotProps = {
            color: color,
            onClick: this.toggleColorPicker,
        };
        var colorDot = react_1.default.createElement(eui_1.EuiIcon, __assign({ type: "dot" }, colorDotProps));
        var displayValueClassNames = classnames_1.default('elasticChartsLegendListItem__displayValue', (_b = {},
            _b['elasticChartsLegendListItem__displayValue--hidden'] = !isSeriesVisible,
            _b));
        return (react_1.default.createElement(eui_1.EuiFlexGroup, { className: classnames_1.default(className, 'euiIEFlexWrapFix'), onMouseEnter: onMouseEnter, onMouseLeave: onMouseLeave, gutterSize: "xs", alignItems: "center", justifyContent: "spaceBetween", responsive: false },
            react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                react_1.default.createElement(eui_1.EuiPopover, { id: "legendItemColorPicker", button: colorDot, isOpen: this.state.isColorPickerOpen, closePopover: this.closeColorPicker, panelPaddingSize: "s", anchorPosition: "downCenter" },
                    react_1.default.createElement(eui_1.EuiContextMenuPanel, null,
                        react_1.default.createElement(eui_1.EuiColorPicker, { onChange: this.onColorPickerChange(legendItemKey), color: color })))),
            react_1.default.createElement(eui_1.EuiFlexItem, { grow: false }, this.renderVisibilityButton(legendItemKey, isSeriesVisible)),
            react_1.default.createElement(eui_1.EuiFlexItem, { onClick: onTitleClick, grow: true },
                react_1.default.createElement(eui_1.EuiPopover, { id: "contentPanel", button: react_1.default.createElement(eui_1.EuiText, { size: "xs", className: titleClassNames }, label), isOpen: isSelected, closePopover: this.onLegendItemPanelClose, panelPaddingSize: "s", anchorPosition: "downCenter" },
                    react_1.default.createElement(eui_1.EuiContextMenuPanel, null,
                        react_1.default.createElement(eui_1.EuiFlexGroup, { gutterSize: "xs", alignItems: "center", responsive: false },
                            react_1.default.createElement(eui_1.EuiFlexItem, null, this.renderPlusButton()),
                            react_1.default.createElement(eui_1.EuiFlexItem, null, this.renderMinusButton()))))),
            react_1.default.createElement(eui_1.EuiFlexItem, { grow: true, className: displayValueClassNames }, this.renderDisplayValue(displayValue, showLegendDisplayValue))));
    };
    LegendElementComponent.displayName = 'LegendElement';
    return LegendElementComponent;
}(react_1.default.Component));
exports.LegendElement = mobx_react_1.inject('chartStore')(mobx_react_1.observer(LegendElementComponent));
//# sourceMappingURL=legend_element.js.map