/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterGraphML;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.UIExporterGraphMLPanel;
import org.openide.util.NbBundle;

public class UIExporterGraphML
implements ExporterUI {
    private UIExporterGraphMLPanel panel;
    private ExporterGraphML exporterGraphML;
    private ExporterGraphMLSettings settings = new ExporterGraphMLSettings();

    public void setup(Exporter exporter) {
        this.exporterGraphML = (ExporterGraphML)exporter;
        this.settings.load(this.exporterGraphML);
        this.panel.setup(this.exporterGraphML);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterGraphML);
            this.settings.save(this.exporterGraphML);
        }
        this.panel = null;
        this.exporterGraphML = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterGraphMLPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterGraphML;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterGraphML.class, (String)"UIExporterGraphML.name");
    }

    private static class ExporterGraphMLSettings {
        private boolean normalize = false;
        private boolean exportColors = true;
        private boolean exportPosition = true;
        private boolean exportSize = true;
        private boolean exportAttributes = true;
        private boolean exportHierarchy = false;

        private ExporterGraphMLSettings() {
        }

        private void save(ExporterGraphML exporterGraphML) {
            this.normalize = exporterGraphML.isNormalize();
            this.exportColors = exporterGraphML.isExportColors();
            this.exportPosition = exporterGraphML.isExportPosition();
            this.exportSize = exporterGraphML.isExportSize();
            this.exportAttributes = exporterGraphML.isExportAttributes();
        }

        private void load(ExporterGraphML exporterGraphML) {
            exporterGraphML.setNormalize(this.normalize);
            exporterGraphML.setExportColors(this.exportColors);
            exporterGraphML.setExportAttributes(this.exportAttributes);
            exporterGraphML.setExportPosition(this.exportPosition);
            exporterGraphML.setExportSize(this.exportSize);
        }
    }
}

