#############################################################################
##
#W  residueclassorbitlengths.g        GAP4 Package `RCWA'         Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of lengths
##  of short residue class orbits.
##
##  The list 'shortresidueclassorbitlengths' below satisfies
##
##    shortresidueclassorbitlengths[i] =
##        List(ShortResidueClassOrbits(grps[First(conjugacyclasses,
##                                                cl->i in cl)[1]],960,128),
##             Length);
##
##  for all i in [1..52394] such that grps[i] is infinite, and
##
##    shortresidueclassorbitlengths[i] = orbitlengths[i]
##
##  for all i in [1..52394] such that grps[i] is finite.
##
#############################################################################

local  shortresidueclassorbitlengthsset, shortresidueclassorbitlengthspos;

shortresidueclassorbitlengthsset :=
[[],[1],[1,1],[1,1,1],[1,1,1,1],[1,1,1,1,1,1],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,
   2,2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,
   4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,8,8,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,
   2,2,3,3,3,3,4,4],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,
   2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,
   4,5,5,5,5,5,5,5,5,5,5,5,5],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,
   3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,
   5,5,5,5,5,5,5,5,5,5,5,5],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,
   3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,5,6,6,
   7,7,8,9,10,11,11,11,12,16],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,
   3,3,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,7,10,11,11,
   12,12,13,14,14,14,15,16,17,20],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,
   3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,5,5,5,
   5,5,5,5,5,6,6,6,6,9,10,10,10,11,11,11,11,11,13,14,
   14,14,17],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,
   3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,
   5,5,5,6,6,6,6,7,7,7,8,8,8,8,9,9,9,9,9,9,17],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,
   3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,
   5,5,5,6,6,6,6,7,7,8,9,9,10,10,10,11,15],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,
   3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,
   7,7,7,7,7,8,8,8,8,8,9,9,9,9,9,10,10,10,10,11,11,
   12,14],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,
   3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,
   7,7,7,7,7,8,8,8,8,8,9,9,9,9,9,9,10,10,10,11,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,
   5,5,7,7,8,8,8,8,10,10,11,11,11,11,12,12,13,13],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,
   5,5,7,8,9,9,10,10,10,10,11,11,13,13,14,14],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,
   5,5,6,6,6,6,6,7,7,7,7,8,9,9,9,9,9,10,10,10,11,11,
   11,11,11,11,12,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,
   6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,8,8,9,9,9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   3,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,
   6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,
   8,8,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   3,3,3,3,3,3,4,4,4,4,5,5,5,5,6,6,7,7,7,7,7,7,8,8,
   8,8,8,8,8,8,9,9,9,9,10,10,10,10,10,10,12,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   3,3,3,3,3,3,4,4,4,4,5,5,5,5,6,6,7,7,7,7,7,7,8,8,
   8,8,8,8,8,8,9,9,9,9,10,10,10,10,10,12,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   3,3,3,3,4,4,4,4,6,6,7,7,7,8,8,8,9,9,9,10,10,10,
   11,11,11,11,12,12,12,14,15],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   3,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,
   7,7,7,7,8,8,8,9,9,10,10,11,12,13,13,13,17],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
   4,6,6,6],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,
   5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,
   7,7,7,7,7,7,7,7,7,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,
   5,5,5,5,5,6,7,7,7,7,8,8,8,8,8,9,9,9,10,10,10,11,
   11,12,13,18],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,
   5,5,5,5,5,6,7,7,7,7,8,8,8,8,9,10,10,11,12,12,13],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,6,7,
   7,7,7,7,8,8,8,8,8,9,9,10,10,10,10,10,11,11,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,3,3,3,3,4,4,4,4,4,4,6,6,6,6,7,7,7,7,7,7,8,8,8,
   8,8,8,8,8,8,9,9,9,10,10,10,10,10,10,12,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,
   6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,
   6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,10,
   10,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,4,4,4,4,4,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,
   8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,
   7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,
   9,9,9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,
   3,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,
   7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,
   8,8,8,8,8,8,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,
   5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,8,
   9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   3,3,3,3,3,3,4,4,4,4,5,5,5,6,6,6,6,6,6,7,7,7,7,7,
   7,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   3,3,3,3,4,4,4,6,6,6,6,7,8,8,9,9,9,9,10,10,10,10,
   11,11,11,11,11,11,11,11,12,12,12,13],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,
   6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,
   7,7,8,8,8,8,8,8,9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   3,3,4,4,4,4,4,4,5,5,6,6,6,6,6,7,7,7,7,7,7,7,7,7,
   7,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,
   10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   3,3,4,4,4,4,4,4,5,5,6,6,6,6,6,7,7,7,7,7,7,7,7,7,
   7,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,
   10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   3,3,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,
   6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
   7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   3,3,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,
   6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
   7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   3,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,
   7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   4,4,4,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
   4,5,5,6],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,
   5,5,5,5,5,5,5,6,6,6,6,7,7,7,8,8,8,9,9,9,9,9,9,9,
   9,9,10,10,10,10,10,10,11,11,12,12,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,
   8,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,4,4,4,
   4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,
   8,8,8,8,9,9,9,9,9,9,10,10,11,11,12,12,13,14],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,
   3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,6,
   6,6,7,7,7,7,7,7,7,7,8,8,9,9,9,9,9,9,9,9,9,9,9,9,
   10,10,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,
   3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,6,
   6,6,7,7,7,7,7,7,7,8,8,9,9,9,9,9,9,9,9,9,9,9,9,
   10,10,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,
   3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,
   6,6,6,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,
   10,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,
   3,3,3,4,4,4,4,4,4,4,4,6,6,8,8,8,8,8,8,9,9,9,9,9,
   9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,11,11],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,
   3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,
   5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,11,12,12,12,
   13,13,14],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,
   3,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,
   6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,
   9,10,10,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,
   3,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,
   6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,
   10,10,10,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,
   4,4,4,4,4,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,
   7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,9,9,9,9,9,9,9,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,5,5,
   7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,4,4,4,6,6,
   10],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,
   3,3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,
   7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,
   3,3,4,4,4,4,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,
   7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,9,9,10,
   10],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,
   3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,
   6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,
   7,7,7,7,7,7,7,7,7,8,8,8,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,
   4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,6,6,6,6,
   6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,
   10,10,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,
   4,4,4,4],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,
   4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
   5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,
   7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,4,4,
   4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,7,7,7,7,7,
   7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,
   9],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,
   6,6,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,4,4,5,5,7,7 
  ],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,4,9,9,
   10],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,
   3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,6,6,
   6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
   7,7,7,7,10,10,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,
   3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,
   6,6,6,6,6,6,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
   8,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,
   4,4,4,4],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,
   4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,
   6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,
   9,9,9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,
   5,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,6,6,
   10],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,
   4,5,5,5,5],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,6,6,8 
  ],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,4,5,5,5,5,
   7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,
   4,4,4,4],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,
   4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,
   6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
   7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,
   7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,5,5,
   6,6],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,
   4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,
   5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,
   7,7,7,7,7,7,7,7,7,7,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,
   5,5,6,6,7,7,7,7,8,8,9,9,9,9,10,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,
   7,7,9,9,9,9,10,10,10,10,12,12,12,12,16,16,17,17],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,
   7,7,9,9,9,9,11,11,11,11,11,11,11,11,16,16,17,17],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,4,4,
   5,5],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,5,5,
   6,6,7,7,8,8,8,9,9,10,10,11,11,13,15,16,16,18],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,8,9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,5,5,6,6,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,6,6,6,8,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,4,4,8,8,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,6,6,6,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,5,5,5,
   5,5,5,7,7,7,7,7,7,9,9,9,9,9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,5,5,6,8 
  ],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,
   4,5,5,5,5,6,6,7,7,7,7,8,8,8,9,9,9,9,10,10,10,10,
   11,13,13,14,14],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,5,5,
   6,6,7,7,7,7,7,7,7,8,8,8,8,9,9,9,9,9,10,10,11,11,
   11,11,12,12,12,12,12,12,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,5,5,
   5,7,7,7,7,9,9,9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,5,5,
   6,6,6,6,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,11,
   11,11,12,12,12,12,13,13,14],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,5,5,5,
   6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,9,10,10,11,11,
   11,11,11,11,11,11,12,12,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,5,5,5,
   7,7,7,7,9,9,9,9,11,14,21,30],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,4,5,5,
   6,6,6,6,6,6,7,7,7,8,8,9,9,9,9,9,9,9,9,9,10,10,11,
   11,11,11,12,12,12,12,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,7,7,
   9,9,10,13,13,13,19,21,21],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,6,12],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,8,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,6,6,8,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,6,6,6,6,8],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,5,5,6,6,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,4,5,5,6,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,5,5,6,6,6,6],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,4,4,5,5,8 
  ],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,5,5,
   5,5,5,5,6,7,7,7,7,7,7,9,9,9,9,9,9,10,14,18,22],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,4,6,6 
  ],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,
   5,5,6],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,6,6,
   6,6,7,7,8,8,9,9,9,9,11,11,11,11],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,5,5,5,5,6,
   7,7,7,7,7,7,9,9,9,9,9,9,10,12,12,13,13,15,15,15,15,
   18,24],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,7,7,7,7],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,5,5,5,5,5,5,
   7,7,7,7,9,9,9,9,12,15,15,18,21,21,22,24],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,5,5,5,7,
   7,7,7,8,9,9,10,10,11,13,13,14,14,14,16,16,20],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,5,6,6,8,
   8,8,10,10,10,10,11,11,12,12,13,13,14,14,14,14,14,14,
   18,18],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,6,6,6,6,
   7,7,8,8,9,9,10,10,11,11,11,11,13,13],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,6,6,6,6,
   8,8,9,9,11,11,11,11,11,13,13,17,19,19,20,23],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,5,5,7,7,
   7,7,7,7,8,9,9,9,9,10,10,11,11,12,13,13,13,13,14,15,
   15,19,19],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,5,5,7,7,
   9,9,10,11,12,12,13,13,13,13,14,14,18,19,19,20],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,6,6,6,6,
   8,8,9,9,11,11,11,11,11,14,14,16,19,19,20,21],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,6,6,7,7,
   7,7,8,8,8,9,9,11,11,11,12,12,14,14,14,16,16,16,16,
   16,16,16,16,17],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,6,6,7,7,
   8,8,8,8,9,9,10,10,11,11,11,11,12,12,12,12,13,13,13,
   13,14,14,16,16,19,19],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,6,6,7,7,
   8,8,10,10,10,10,11,11,12,12,12,12,13,13,13,13,13,13,
   14,14,14,14,14,14,15,15],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,5,5,5,5,5,5,7,7,
   9,9,10,10,13,13,13,13,13,13,13,13,18,18,18,18],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,4,4,6,6,7,
   7,8,9,9,9,9,9,10,10,10,11,11,12,12,12,12,13,13,13,
   14,21,21],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,4,5,5,10],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,4,7,7,10,10,
   10,10,12,12,12,12,12,12,12,12,13,13,18,18,18,18],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,5,6,6,6,6,
   7,7,7,8,9,9,9,9,9,11,11,11,11,11,12,13,13,14,15,15,
   16,16,18,18],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,5,6,6,7,7,
   7,7,7,8,9,9,9,10,10,11,11,11,12,12,12,13,13,14,15,
   15,17,17,18,18],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,5,6,6,7,7,
   7,7,7,9,9,9,10,10,11,11,12,13,13,13,13,15,15,15,15,
   15,15,15,15,15],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,5,5,7,7,9,10,
   10,10,11,11,12,12,12,12,13,13,13,13,16,17,17,18],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,4,4,4,4,6,6 
  ],[1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,5,5,5,
   5,5,5,7,7,7,7,7,7,9,9,9,9,9,9],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,4,4,5,5 
  ],[1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,5,5,6,
   6,6,6,7,7,8,8,9,9,9,9,11,11,11,11],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,5,5,5,5,7,7,
   7,7,7,7,8,9,9,9,9,10,11,11,12,13,13,14,15,15,16],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,5,5,5,5,5,7,7,
   7,7,7,7,9,9,9,9,9,11,11,11,13,13,13,15,15,15,15,17],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,4,4,4,4,6,6,6,6,7,
   7,8,8,9,9,10,10,11,11,11,11,13,13],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,4,4,4,6,6,6,6,7,7,
   7,8,8,9,9,10,10,10,10,11,11,11,11,13,13,13,13,13,13,
   13],[1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,4,4,5,5,7,7,
   7,7,7,7,7,7,7,7,9,9,10,10,10,10,13,13,13,13,13,13,
   13,13,13,13,13,13,13,13,13,13],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,4,4,5,6,6,6,6,7,7,
   8,8,8,9,9,10,10,11,11,11,11,11,11,13,13,13,13,14,14,
   14],[1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,4,5,5,5,6,6,
   7,7,7,7,7,7,8,8,9,9,9,10,11,11,11,12,12,12,12,12,
   13,13,13,13,14,14,14,14,15,15],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,5,5,5,5,7,7,7,7,7,
   7,7,7,7,7,9,9,11,11,11,11,13,13,13,13,13,13,13,13,
   13,13,13,13,13,13,13,13],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,4,4,6,6,7,7,7,7,
   7,9,9,9,10,10,10,10,10,11,11,12,12,12,12,13,13,13,13,
   13],[1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,4,6,6,6,6,
   7,7,7,7,7,7,9,9,10,10,10,10,11,11,11,11,12,12,12,12,
   12,12,12,12,13,13,13,13,13,13],
 [1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,5,6,6,6,6,7,7,7,
   7,7,7,9,10,10,10,10,11,11,11,11,11,12,12,12,12,12,12,
   12,12,13,13,13,13,13,13],[1,1,1,1,1,1,1,1,1,2,2],
 [1,1,1,1,1,1,1,1,1,2,2,2],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,4,
   6,8,10],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,6,
   10,14,18,22],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,4,4,
   4,5,6,6,6,6,8,8,8,8,10,10,10,10,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,4,4,
   4,5,6,6,6,8,8,8,9,10,10,11,12,14,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,4,4,
   4,5,5,6,6,7,7,8,8,9,9,10,10,11,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,4,6,
   8,8,10,10,10,12,14,14,18,22],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,
   4,5,5,5,5,5,6,6,6,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,
   4,5,5,5,5,6,6,6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,
   5,5,5,6,6,6,6,7,7,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,
   9,10,10,11,16,17,17,18,23,24,24,25,30],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,4,4,4,
   4,5,5,5,6,6,6,7,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,4,5,9,
   9,10,10,10,10,10,11,11,11,11,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,4,6,6,
   8,8,10,10,10,10,12,12,12,12,14,14],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,4,6,8,
   10,12,14,16,18,20,22],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,5,5,6,
   7,11,11,11,12,15,15,15,16,19,19,19,20],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,6,6,6,
   7,9,9,10,11,14,14,15,16,19,19,20,21],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,4,5,5,6,
   7,8,8,9,10,11,11,12,13,14,14,15,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,
   4,5,5,5,5,6,6,6,6,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,
   4,4,5,5,5,5,5,6,6,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,5,
   5,6,6,6,7,8,9,9,10],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,
   5,5,6,6,6,7,7,9,10],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,7,
   9,12,14,17,19,22,24],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,4,5,8,
   9,12,13,16,17,20,21],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,5,5,5,
   7,7,7,8,9,9,10,11,11,11,13,14,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,5,5,6,
   6,7,8,8,9,9,10,11,11,12,12,14,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,5,5,5,6,
   7,8,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,5,5,6,6,
   6,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,
   4,4,4,4,4,5,5,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,4,
   4,4,4,4,4,5,5,5,5],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,
   4,4,4,4,5,5,5,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,5,7,
   8,12,13,17,18,22,23],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,
   4,4,4,4,5,5,5,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,
   5,8,8,9,9,9,10],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,5,7,
   9,11,13,15,17,19,21],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,
   5,6,6,6,6,7,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,4,6,7,
   7,8,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,5,5,5,
   6,7,7,7,8,9,9,9,10,11,11,11,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,4,4,5,6,
   7,7,7,10,10,13,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,4,5,5,6,
   6,6,7,7,7,8,8,9,10],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,5,5,5,6,
   6,8,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,5,6,6,6,
   7,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,4,4,4,5,5,
   6,7,7,7,8,8,8,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,4,5,5,5,6,
   6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,4,10,10,14,
   14,18,18,22,22],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,
   4,4,4,4,4,4,5,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,4,4,
   4,4,4,4,4,4,4,5,5],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,
   4,4,4,5,5,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,
   6,6,7,7,7,8,12,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,5,7,
   8,11,12,15,16,19,20],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,6,7,
   7,8,9,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,5,5,5,
   6,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,5,6,6,
   6,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,5,6,
   6,6,6,7,7,7,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,6,7,
   7,7,8,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,6,8,8,9,
   10],[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,
   5,5,5,6,6,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,
   6,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,
   5,6,6,7,7,8,11,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,5,5,
   6,7,7,10,10,13,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,5,5,5,
   5,6,6,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,5,5,6,
   6,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,5,6,6,
   7,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,5,5,6,
   8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,5,6,6,
   7,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,6,7,9,
   11],[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,
   7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,7,9,13,15,
   19,21,25,27],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,4,4,4,5,5,
   5,5,6,6,6,7,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,5,5,7,7,9,9,
   11,11,13,13,15,15,17,17,19,19],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,4,4,4,5,6,8,9,9,
   10,12,13,15,17,21,27],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,4,4,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,4,4,6,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,4,4,5,5,6,6,8,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,4,5,5,5,6,8,11,11]
  ,[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,4,5,6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,5,5,5,6,6,7,7,8,
   11,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,5,5,5,
   5,5,5,6,6,6,6,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,
   4,4,5,5,5,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,4,5,
   5,5,6,6,6,6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,5,6,
   6,7,8,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,5,5,5,
   7,7,7,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,5,5,6,6,
   6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,5,5,6,6,
   7,10],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,4,5,
   5,5,5,6,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,
   6,6,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,6,
   6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,5,5,5,
   6,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,5,6,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,6,9,10,11,
   12,13,14,14,15,15,16,17,17,18,18,19],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,5,6,8,8,9,10,
   11],[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,
   5,5,5,5,6,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,4,5,5,
   5,5,6,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,4,5,5,
   5,5,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,6,8,8,8,
   8,10,10,13,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,5,6,7,8,9,
   10,11,12,13,14,15,16,17,18,19],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,6,7,7,7,8,
   9,10,10,11,12,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,4,4,5,5,
   5,5,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,6,6,7,7,9,9,
   10,10,12,12,13,13,15,15,16,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,5],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,5,5],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,4,4,4,4,5,5,6,7,8,
   9,11,15,17,21,23],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,4,4,4,5,5,6,7,7,7,7,
   10,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,2,4,5,5,6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,
   4,5,5,5,6,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,
   4,5,5,6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,5,5,
   5,7,7,10,10,13,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,6,6,
   6,6,8,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,
   4,5,5,5,5,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,
   5,5,5,5,5,6,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,
   5,5,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,
   5,6,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,6,6,
   6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,6,6,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,7,12,17,
   17,19,19,21,22,22,24,24,26,27,27,29,29,29,29,31,31,32,
   34,34,36,37,39,39,41],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,4,5,5,
   5,5,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,7,8,12,
   16,17,21,22,26,31],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,5,7,12,12,
   13,17,22,32,35,37,40,45,47,50,55,65],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,5,7,12,17,
   17,20,22,22,25,27,27,28,30,32,33,35,37,38,38,43,48],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,6,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,6,7,8,8,
   10,11,12,12,14,15,16,16,18,19],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,7,9,9,10,
   11,14,14,16,17,17,21,24],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,7,9,10,11,
   12,13,13,14,15,15,16,16,17,17,18,19],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,6,6,6,6,8,8,
   8,8,10,10,10,10,12,12,12,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,6,6,6,7,7,7,8,
   9,9,10,10,11,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,6,6,6,7,
   7,9,10],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,6,6,7,7,
   8,9,10,11,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,6,6,7,8,8,10,
   10,10,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,6,6,8,8,8,8,
   8,9,10],[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,5],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,5,6,6,7,7,9,11,
   11,12,18,18,19,20,20,21],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,5,7,8,8,9,9,9,
   9,10,11,11,12,13,13,14,15,15,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,8,10,15,16,17,19]
  ,[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,5,5],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,5,5,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,5,5,7,13,16,17,20],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,5,6,6,15,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,5,6,7,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,6,8,8,10,11,11,17],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,6,7,7,7,
   9,9,9,10,11,11,12,13,15,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,7,7,9,11,
   11,12,18,18,19,20,20,21],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,6,6,7,8,9,
   9,10,11,12,12,13,14,15,15,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,6,6,7,9,11,
   12,12,13,13,14,15,15,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,6,6,8,8,9,
   9,10,10,12,12,12,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,6,7,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,6,6,7,8,10,10],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,6,6,9,10,12,13,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,5,5,6,7,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,5,5,6,7,10,12,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,5,6,6,7,8,15,16,19],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,7,8,8,9,10,10,11,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,4,5,6,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,4,5,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,5,5],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,5,6,8,10,13,14],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,5,7,9,10,12,16,18],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,6,6,8,11,13,13,17],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,7,7,8,9,10,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,5,5,6,6,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,5,5,6,8,10,10,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,5,6,6,9,9,9,10,14],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,6,6,7,9,9,10,11,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,4,4,5,6,6,7,8,8,8,
   8,8,9,9,10,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,5,6,6,7,8,9,12,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,
   4,4,4,5,6,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,4,4,4,4,4,
   4,4,4,4,5,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,
   5,7,7,10,10,13,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,4,4,6,8,12,14,
   18,20,24,26],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,4,4,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,
   5,5,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,
   5,6,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,5,5,8,11,
   14],[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,5,
   6,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,5,7,8,11,11,
   13,13,13,14,15,16,16,19,19,19,22,22,32,33,35,37,38,41]
  ,[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,7,7,7,9,
   10,10,10,12,12,13,13,15,16,16,17,18,18,22,26,34,42],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,5,5,5,6,6,6,6,
   7,7,7,8,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,4,5,5,5],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,4,6,6,6,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,6,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,5,6,6,7,7,
   8,8,9,9,10,10,11,11,12,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,5,6,6,7,10,
   11,15,15,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,5,9,10,11,
   11,16,17,17,18,24,25],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,6,6,7,9,9,10,
   10,13,13,13,14,14,17,17,18,18,19,21,21,22,25,31],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,13,14,18,19],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,5,13,16,16,20],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,6,11,18,19],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,6,10,11,14,20,21]
  ,[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,5,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,5,5,5,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,6,6,11,11,
   11,12,15,15,20,20],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,7,7,7,7,
   7,7,8,8,9,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,6,6,7,8,10,
   10,10,11,12,15,15,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,5,7,7,
   7,11,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,5,7,9,9,9,
   9,10,10,11,11,11,11,12,12,12,14],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,9,10,10,11,
   11,11,12,13,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,6,6,6,7,8,8,
   10,10,12,12,14,14,16,16,18,18,20,20,22,22,26,26,30,30]
  ,[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,5,5,6,7,7,
   7,7,8,9,11,12,14,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,5,5,6,7,7,9,
   9,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,5,6,6,7,8,10,
   10,10,11,11,12,12,13,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,6,6,6,6,7,7,
   9,9,10,10,10,10],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,6,6,6,6,7,7,
   7,7,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,6,6,8,8,8,9,
   10,10,10,11,11,11,12,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,6,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,6,7,7,7,14,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,6,7,9,10,14],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,5,6,7,8,8,9,12,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,5,5,6,7,7,8,
   8,8,8,10,10,13,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,5,6,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,6,6,6,6,7,7,
   8,8,11,11,11,12,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,6,8,8,18,18],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,6,6,7,8,
   9,9,10,10,12,12,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,6,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,5,5,7,7,7,11,
   11,12,12,12,13,14,14,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,6,7,9,12,17,20],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,7,7,7,13,15],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,7,8,9,10,12,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,7,9,9,10,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,6,7,8,8,10,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,6,8,8,10,10,11,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,7,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,5,5,7,8,9,10,13,16],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,6,6,7,8,9,9,11,12],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,6,6,7,8,9,12,15,18],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,4],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,4,4,4,5,5,5,6,6,6,
   7,7,7,8,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,4,4,4,5,5,5,6,6,7,8 
  ],[1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,4,4,6,7,8,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,5,6,7,7,10,10,19,20],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,5,6,7,9,10,10,10,18],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,6,6,7,7,8,8,9,13],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,4,5,6,6,6],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,4,5,6,6,7,9,9],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,4,5,6,7,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,2,3,5],
 [1,1,1,1,1,1,1,1,1,2,2,2,4,4,4,4,4,8,8,8,9,11],
 [1,1,1,1,1,1,1,1,1,2,2,2,4,4,4,4,5,5,5,6,6,6,6,7,
   7,7,8,9,9,10,10],[1,1,1,1,1,1,1,1,1,2,2,3,3,3],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,5,5,5,5,5,
   7,7,7,7,8,10,10,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,5,5,5,5,5,
   7,7,8,14,14,15,19,20,21],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,5,5,5,5,5,
   8,10,10,12,13,14,21,21,25],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,4,4,4,4,5],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,4,4,5,5,6,8],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,4,4,5,5,6,6,6,
   6,7,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,4,4,4,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,4,4,5,6,6,7,
   9,9],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,4,4,6,10,10,
   20,20,30,30],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,4,5,5,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,5,5,5,5,9,9,
   10,11,15,15,19,19],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,5,5,6,6],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,5,5,6,6,6,7,
   7,8],[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,13,14,
   18,25,26],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,4,4,5,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,
   6,7,7,7,7,7,7,8,8,9,9,9,9,10,10,13,16,16,19],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,
   6,7,7,7,7,7,8,8,9,9,9,9,10,10,10,10,10,13,13,13,13]
  ,[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,5,5,5,5,
   6,6,7,7,7,9,13,13],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,6,6,6,6,8,
   10,10,10,12,13,15,15,18,18,20],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,6,6,6,6,9,
   12,12,19,19],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,6,6,7,7,8,
   10,12,12,12,12,14,14,14,16,18],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,7,8,10,10,
   10,13,14,14,14,14,16,16,18,19,33],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,5,5,5,5,6,6,
   6,6,7,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,5,5,6,6,6,6,
   6,7,7,7,7,8,8,8,8,9,9,9,9,9,10,10,10,10,11,11,11,
   12,12,12,12,13,13],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,5,5,6,6,6,7,
   7,7],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,5,5,5,7,7,
   7,7,7,9,9,10,11,12,13,15,17],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,5,5,6,6,6,
   6,7,7,9,9,9,9,9,10,11,11,12,12,12,12,13,13,13,13,14,
   14,16],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,5,5,6,6,7,
   7,7,7,8,9,9,10,10,10,11,11,11,11,12,12,13,13,13,13,
   13,13,15],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,5,6,6,6,7,
   7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,11,11,11,11,11,
   12,12,12,12,12,12],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,5,6,6,7,7,
   9,9],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,7,7,8,9,9,9,
   9,10,10,10,10,14,14],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,5,5,5,5,6,6,6,6,
   6,7,7,7,7,8,8,8,8,9,9,9,9,9,10,10,11,11,11,11,11,
   11,11,11,11,12,12],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,5,5,5,6,7,7,7,8,
   9,10,10,10,11,12,13,13,13,13,14,15,16,16,16,16,19,19,
   22],[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,5,5,5,5,5,5,
   6,6,7,7,8,8,9,9,10,10,11,12,13,16,27],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,5,5,7,7,9,9],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,4,4,5,5,5,6,
   7,8,10,11,13,14,16],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,4,5,5,5,5],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,4,5,5,6,6,6,
   7,7,7,8,8,9],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,4,5,6,6,7,7,
   7,10],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,5,5,6,6],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,5,5,5,8,8,8,9,
   10,12,12,13],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,5,5,5,8,9,10,10,
   13,14,14,15,18,19],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,5,6,7,7,8,8,
   8,10,10,12],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,6,7,7,8,8,9,
   9,10,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,6,7,8,8,8,9,
   9,9,9,10],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,8,8,9,16,17],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,6,7,7,12,12,16],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,5,5,5,5,6,7],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,4,5,6,6,7,
   7,7],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,5,5,5,6,6,
   7,7],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,5,5,6,6,6,
   6,7,7,8,8,9,9,9,9,9,10,10,11,11,12,12,14,14,14,17,
   17,19],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,5,5,6,6,6,6,
   6,6,7,7,7,8,8,9,9,9,9,9,9,9,9,10,10,10,11,11,11,
   11,12,12,12,12,13],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,5,5,6,6,6,8,9,
   11,11,15,15,20,20],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,5,6,6,6,7,9,9,
   9,9,10,10],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,5,5,5,7,11],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,5,5,6,7,8,9,9,9,
   9,10,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,6,6,6,8,8,9,10,11,
   11,11,13,13,18,19,21,21],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,5,5,5,6,6,8,9,
   9,9,11,11,15,15],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,6,6,9,9,11,13],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,7,7,7,9,9,10,10,
   10,13,13,13,13],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,7,7,9,9],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,6,7,9,10,16,20,23,
   27,30,34,41],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,6,8,9,16,21,22,23,
   28,29,30,33,35,36,36,40,43,43,45,48,50,55,60],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,6,6,9,9,10,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,6,7,7,7,7,8,9,14],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,15,15,15,15],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,5,5,6,6,6,8,8,9,10,11,
   11,11,13,13,18,18,21,21],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,5,5,7,10,10,12,12,13,
   13,13,14,16,16,17,17,17,18,20],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,4,7],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,5,8,8,8,10,10,10,11,11,
   11,12,12,13,14,14,14,14,15,16,16,16,17,18],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,8,10,10,13,15,15,15,18],
 [1,1,1,1,1,1,1,1,1,2,2,3,3,9,11,11,15,17,20,20],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,4,4,4,4,4,5,6,6,7,
   9,9,9,10,10,11,12],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,4,4,4,5,5,5,6],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,4,4,5,5,5,5,6,6,7,
   7,8,8,8,8,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,4,5,5],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,4,5,6,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,5,7,9,11,12,12],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,5,7,10,12,14,17,18,
   24,25,26,27,27,29],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,6,6,7,7,11,11,12,14],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,6,9,9,10,13,16,16,17,
   20,23,23,24,27,30,30,31,34,38,41],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,7,8,10,11,12,15,16,
   16,17,18,19,24,26],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,5,5,5,6,7,7,9,12,16],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,5,5,6,7,7,7,8],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,5,5,6,7,8,11,12,12,14],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,4,5,6,6,7,7,7],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,5,5,6,7,8,8,12,17,19,25,
   26,29,30,38,39,42,43,51,52,55,65],
 [1,1,1,1,1,1,1,1,1,2,2,3,4,5,6,6,6,6,7,8,8,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,4,6,6,7,9,9,9,9,
   9,10,10,11,11,12,12,14,14,14,14],
 [1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,7,9,10,11,11,12,12,
   13,15,17,17,17,18,18,18,19],
 [1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,14,14,14,14],
 [1,1,1,1,1,1,1,1,1,2,2,4,4,4,6,6,6,6,9,9,9,9,10,11,
   11,11,11,13,15,15,15,18,19,20],
 [1,1,1,1,1,1,1,1,1,2,2,4,4,4,7,7,9,9,10,10,11,11,11,
   11,12,12,13,13,15,15,15,15,16,16,17,17],
 [1,1,1,1,1,1,1,1,1,2,2,4,4,5,5,5,5,5,5,6,6,6,6,6,
   7,10,10,11],
 [1,1,1,1,1,1,1,1,1,2,2,4,4,5,5,6,8,8,9,11,19,22],
 [1,1,1,1,1,1,1,1,1,2,2,4,4,5,6,6,7,7,9,9,10,10,10,
   11,11,12,12,13,15,15,15,18,18,20],
 [1,1,1,1,1,1,1,1,1,2,2,4,4,9,11,11,14,16,19,20],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,3,3,4,4,4,4,5,5,
   5,5,6,6,6,6,7,7,8,8,17],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,3,3,4,4,4,4,5,5,
   5,5,6,6,6,6,7,7,9,9],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,3,3,5,5,5,5,5,5,
   7,7,7,7,13,13,13,13,14,14,14,14,15,15,16,16],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,3,3,5,5,5,5,5,7,
   7,7,7,8,11],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,4,4,4,4,5,5,5,6,7 
  ],[1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,4,4,4,5,6,6,
   6,6,7,8],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,4,4,4,4,6,6,
   6,6,7,7,7,7,10,10],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,4,4,5,5,5,5,
   7,7,7,7,7,7,9,9],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,4,4,5,6,6,6,
   6,7,7,11,12,12,14,15,15],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,4,4,6,6,6,6,
   7,7,10,10,12,12,12,12,12,12,14,14,15],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,4,4,6,6,6,6,
   9,10,10,15,15,23,27],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,5,5,5,5,5,5,
   7,7,8,9,9,11,11,12,12,12,12,12,12,15],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,5,5,5,5,7,7,
   7,7,9,9,9,9,10,10,12,12],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,5,5,5,5,7,7,
   7,7,10,10,12,12,15],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,6,6,6,6,6,8,
   8,8,8,8,8,10,10,10,12,12,12,12],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,6,6,6,6,7,10,
   12,12,15,17,17,20,25,26,28,31],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,7,7,7,9,9,9,9 
  ],[1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,8,10,10,
   10,12,12,12,12,13,13,14,14,14,15,15,18,20,21],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,5,5,5,5,5,5,6,6,
   7,7,7,7,8,8,9,9,10,10],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,5,5,5,5,5,5,7,7,
   7,7,7,7,10,10,12,12,13,13,15,15],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,6,6,6,6,6,6,6,6,
   8,8,8,8,8,8,8,10,10,10,11,12,12,12,12],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,6,6,6,6,8,8,8,8,
   8,8,8,8,10,10,10,10,10,10,13,13,13,14,14,15,15,15,19]
  ,[1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,6,6,7,7,8,8,9,
   9,10,10,11,11,13,13,19,19,21,21],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,4,4,4,4,4,4,4,4,5,5,5,
   5,5,5,6],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,4,4,4,5,6,6,6,7,7,7,8,
   9,10,10,10],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,4,4,5,5,5,5,5,6,6,7,8,
   9,9,12,12,16,16],
 [1,1,1,1,1,1,1,1,1,2,3,3,3,4,4,5,6,6,6,6,7,7,7,8,
   8,9,9,9],
 [1,1,1,1,1,1,1,1,1,2,3,3,4,5,5,6,6,8,11,14,17,18,18,
   21,21,22,22,25,27,28,31,34],
 [1,1,1,1,1,1,1,1,1,2,3,3,4,5,6,7,8,12,12,13,14,15,
   17,19,20,22,25,25,31],
 [1,1,1,1,1,1,1,1,1,2,3,3,4,5,6,9,11],
 [1,1,1,1,1,1,1,1,1,2,3,3,4,5,6,9,12,12,13,13,16,17,
   18,18,18,20,21,24,24,24,24,30],
 [1,1,1,1,1,1,1,1,1,2,3,3,4,6,8,9,11],
 [1,1,1,1,1,1,1,1,1,2,3,3,4,6,9,11,14,14,15,18,28],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,4,4,4,5,5,5,5,6,6,7,8,
   8,8,9,9],[1,1,1,1,1,1,1,1,1,2,3,4,4,4,4,6,7,8,8 
  ],[1,1,1,1,1,1,1,1,1,2,3,4,4,4,5,5,5,5,5,5,6,6,
   6,6,7,12,12,14],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,4,5,7,8,13,15,18,28],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,5,5,6,6,7,8,10],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,5,5,6,8],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,5,6,7,8,9,11,14,17,18,21,
   23,24,25,26,27],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,5,6,7,9,11,11,12,13,13,
   18,24,24,29,35],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,5,6,7,11,12,15],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,5,6,8,9,10],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,5,7,8,10],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,5,7,11,12,14,15],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,5,7,13,15,18,22,22,26],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,6,6,9,9,9,11,12,12,15,15,
   18,18,18,18,19,25,25,32],
 [1,1,1,1,1,1,1,1,1,2,3,4,4,8],
 [1,1,1,1,1,1,1,1,1,2,3,4,5,5,5,6,8,9],
 [1,1,1,1,1,1,1,1,1,2,3,4,5,5,5,7,8,8,8,10,10,13,20,
   20,22,22,22,24,32,34,34,36],
 [1,1,1,1,1,1,1,1,1,2,3,4,5,5,9,10,11,12,12,12,12,12,
   13,13,15,16],
 [1,1,1,1,1,1,1,1,1,2,3,4,5,6,7,7,8,8,9,10,10,10,11,
   13,13,15,18],[1,1,1,1,1,1,1,1,1,2,3,4,5,7],
 [1,1,1,1,1,1,1,1,1,2,3,4,5,7,14,14,15,16,17,18,19],
 [1,1,1,1,1,1,1,1,1,2,3,4,6,7,8,9,12,12,12,14,14],
 [1,1,1,1,1,1,1,1,1,2,3,4,8,10,10,11,12,12,13,13,18],
 [1,1,1,1,1,1,1,1,1,2,4,4,4,4,4,4,4,4,7,7,7,7,7,9,
   9,11,11,12,14,14,14,17],
 [1,1,1,1,1,1,1,1,1,2,4,4,4,4,4,4,6,6,6,6,6,6,7,9,
   9,9,10,11,11,11,12,12],
 [1,1,1,1,1,1,1,1,1,2,4,4,4,4,5,5,6,6,6,6,6,6,6,6,
   6,6,7,7,7,7,8,8,9,9,9,9,10,12,12,14,14,21,21,21,21]
  ,[1,1,1,1,1,1,1,1,1,2,4,4,4,5,5,5,5,6,6,7,8,10,14 
  ],[1,1,1,1,1,1,1,1,1,2,4,4,4,5,5,6,6,6,6,7,7,7,
   11],[1,1,1,1,1,1,1,1,1,2,4,4,4,5,5,6,6,8,8,10,10 
  ],[1,1,1,1,1,1,1,1,1,2,4,4,5,5,8,13,16,17,17,19,24 
  ],[1,1,1,1,1,1,1,1,1,2,4,4,5,6,6,8,8,8,11,11,14,
   16,18,25,30,32],
 [1,1,1,1,1,1,1,1,1,2,4,7,8,8,8,9,10,11,14,14,18],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,4,4,5,5,5,5,6,
   6,7,7,11,11,11,11,11,11,11,11,13,13,13,13,13,13,13,
   13,19,19,19,19],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,5,5,5,5,5,7,7,
   8,8,8,8,8,10,10,10,10,11,11,11,11,11,11,11,13,13,13,
   13,16,16,16,20],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,
   7,7,7,7,7,7,8,10,10,11],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,4,4,5,6,6,6,6,
   7,7,7,7,8,9,10,10,11],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,4,4,6,6,6,6,6,
   6,6,6,6,6,8,8,9,9,9,10,10,11,11,12,12,13,13,13,13,
   13,13,16,16,17,17],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,4,4,6,6,6,6,6,
   6,7,7,8,9,9,10,10,10,12,13,14,16,16,16,17,20,20],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,4,4,6,6,6,6,6,
   6,9,9,10,10,10,10,10,10,10,10,12,12,12,12,13,13,13,
   13,16,16,16,16],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,5,5,5,5,5,5,6,
   6,6,6,7,7,7,7,7,7,8,10,10,10,11],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,6,6,6,6,6,6,8,
   8,8,8,8,8,10,10,10,11,12,12,12,12,12,13,14,14,15,15,
   15,16,19],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,5,5,5,5,5,5,7,7,7,
   7,7,7,7,7,7,7,7,7,9,9,9,9,10,11,12,12,13,13,13,13,
   15,15,16,21],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,5,5,5,5,5,5,7,7,7,
   7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,13,13,13,
   13,13,13,14,14,14,14],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,5,5,6,6,6,6,7,7,8,
   8,9,9,9,9,11,11,11,11],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,6,6,6,6,6,6,6,6,6,
   8,8,8,8,8,8,8,8,8,8,8,8,10,10,10,10,10,10,11,11,11,
   12,12,12,13,13,14,16],
 [1,1,1,1,1,1,1,1,1,3,3,3,3,4,5,5,5,5,7,7,7,7,7,7,
   8,9,9,9,9,10,11,11,12,13,13,14,14,15,15,16],
 [1,1,1,1,1,1,1,1,1,3,3,4,4,4,4,6,6,6,6,7,7,8,8,9,
   9,10,10,11,11,11,11,13,13],
 [1,1,1,1,1,1,1,1,1,3,3,4,4,4,6,6,6,6,7,7,7,8,8,9,
   9,10,10,10,10,11,11,11,11,13,13,13,13,13,13,13],
 [1,1,1,1,1,1,1,1,1,3,3,4,4,5,5,7,7,7,7,7,7,7,7,7,
   7,9,9,10,10,10,10,13,13,13,13,13,13,13,13,13,13,13,
   13,13,13,13,13],
 [1,1,1,1,1,1,1,1,1,3,3,4,4,5,6,6,6,6,7,7,8,8,8,9,
   9,10,10,11,11,11,11,11,11,13,13,13,13,14,14,14],
 [1,1,1,1,1,1,1,1,1,3,3,4,5,5,5,6,6,7,7,7,7,7,7,8,
   8,9,9,9,10,11,11,11,12,12,12,12,12,13,13,13,13,14,14,
   14,14,15,15],[1,1,1,1,1,1,1,1,1,3,4,4,5,5],
 [1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,
   6,7,7,7,7,7,9,9,9,9,9,9,10,10,10,10,12,12,12,12,12,
   12,12,12,15,15],
 [1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,6,6,6,6,7,7,7,
   7,7,7,7,7,9,9,9,9,9,9,10,10,10,10,10,12,12,13,18,
   18,18],
 [1,1,1,1,1,1,1,1,1,4,4,4,4,4,6,6,7,7,7,7,7,9,9,9,
   10,10,10,10,10,11,11,12,12,12,12,13,13,13,13,13],
 [1,1,1,1,1,1,1,1,1,4,4,4,4,6,6,6,6,7,7,7,7,7,7,9,
   9,10,10,10,10,11,11,11,11,12,12,12,12,12,12,12,12,13,
   13,13,13,13,13],
 [1,1,1,1,1,1,1,1,1,4,4,4,5,6,6,6,6,7,7,7,7,7,7,9,
   10,10,10,10,11,11,11,11,11,12,12,12,12,12,12,12,12,13,
   13,13,13,13,13],[1,1,1,1,1,1,2],
 [1,1,1,1,1,1,2,2],[1,1,1,1,1,1,2,2,2],
 [1,1,1,1,1,1,2,2,2,2,2],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,3,5,6,7,9,
   10,11,13,16,19],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,3,7,8,9,11,
   13,13,15,18,18,19,23,23,23,28],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,4,5,5,7,7,
   7,9,9,11,11,11,13,13,15,19,23],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,4,6,7,8,9,
   11,11,13,14,15,15,19,20,26,32],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,5,5,7,7,8,
   9,9,11,11,13,13,15,19,25,31],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,5,6,7,7,7,
   9,9,11,11,11,13,13,15,19,23],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,4,4,5,9,9,17,
   17,25,25],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,5,5,5,6,6,6,
   6,7],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,7,
   7,8,8,10,10,10,10,13,13,16,16],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,4,4,4,6,6,6,
   6,8,8,9,9,10,10,12,12,15,15],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,4,4,6,6,7,7,
   9,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,4,4,4,4,5,5,5,
   5,5,6,8,9,11],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,4,4,4,4,5,5,5,
   5,6,6,7],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,4,4,5,7,8,8,8,
   9,9,9,10,12,13,13,13,14,14,14,15,18,19],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,5,5,6,6,
   6,6,6,7,9,9,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,8,
   8,9,9,9,10,10,16,17],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,6,6,
   6,7,7,7,7,8],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,5,7,7,
   8,8,8,9,10,11,15,16],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,5,5,5,5,
   6,6,6,7,8,8,9],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,5,5,5,5,6,
   6,6,6,8,8,9,10,11],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,5,5,5,
   6,6,6,7,7,8,8,8],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,5,6,6,
   7,7,9,11,12],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,5,5,
   6,6,6,7,7,8,8,8],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,
   6,6,7,7,7,7,8],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,4,4,5,5,5,5,
   6,6,6,7,7,7,8],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,4,4,5,5,6,6,
   8,9],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,4,4,6,6,7,9,
   10,10,11,13],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,4,4,4,5,5,5,
   5,5,6,6],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,4,4,4,5,5,5,
   5,6,6,7,8,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,4,5,7,7,7,8,
   8,8,8,9,11,11,11,12,12,12,12,13,15,16],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,4,5,7,7,8,9,
   11,11,12,12,15,16],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,5,5,5,5,6,8,
   8,9,9,9,10,10,10,11],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,
   5,5,6,6,7],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,
   5,5,5,5,6],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,4,4,
   5,5,5,5,6],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,5,6,8,8,9,11,11,
   12,12,19],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,5,6,8,8,9,11,12,
   14,16,17],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,6,
   7,7,7,7,7,7,10,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,4,4,4,6,6,7,7,
   7,7,7,7,8,8],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,6,6,7,7,10,10,11,
   11,14,14,15,15,18,18,19,19],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,7,9,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,4,4,4,4,5,5,5,5,
   6,6,7,9,9,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,4,4,5,5,5,5,6,6,
   6,6,7,7,10,10,11,11,11,11,12,12,16,16],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,4,5,8,8,12,14,16,
   16,21,22],[1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,6,7,7,9 
  ],[1,1,1,1,1,1,2,2,2,2,2,2,2,3,4,4,4,4,4,4,4,5,
   5,5,5,5,5,6],[1,1,1,1,1,1,2,2,2,2,2,2,2,3,7],
 [1,1,1,1,1,1,2,2,2,2,2,2,2,5,5],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,5,5],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,
   5,5,6,6,6,7,7],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,5,6,6,
   6,6,7,7,7,7,8,9,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,
   6,7,7,8,8,9,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,
   5,6,6,6,6,6,7,8,9],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,6,
   6,7,7,8,8,8,9],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,6,7,8,9,10,12,
   13,14,15,16,18,18,19,20,21,22,24,26,30,36],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,4,4,4,
   5,5,5,5,6],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,4,4,5,
   5,5,5,6,7,9,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,4,5,5,
   5,5,6,6,7,8,9],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,
   6,6,6,6,7,7,8,10,11],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,5,5,6,8,10,10,
   11,11,12,13,13,14,14,17],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,5,5,
   5,6,6,7,7,7,8],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,5,6,
   6,6,6,9,9,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,6,6,6,
   6,7,7,7,7,7,10,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,5,6,6,6,6,
   6,6,6,6,11,11,11,11,11,11,11,11,16,16],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,6,6,6,6,6,
   6,6,6,7,7,7,7,9,9,10],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,7,7,7,8,10,10,
   11,12,13,13,15,16,19,20],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,6,6,10,10,13,14,
   16,18],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,6,8,9,10,10,11,
   12,13,13,15,24,25],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,5,6,6,8,8,9,
   10,10,11,11,11,11,11,12,12,14,14,15,17,17,18],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,5,7,7,9],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,4,4,4,4,4,4,5,5,
   5,5,5,6],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,4,4,4,4,5,5,6,6,
   6,6,6,7,7,7],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,4,4,5,6,6,6,6,6,
   6,7,7,8],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,4,4,8,12,17,18,20,
   21,24,24,27,28],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,5,5,5,7],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,8,8,8,9,10,11,11,
   11,12,12,14,14,14,15,15,15,18,18,19],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,5,6,6,6,6,7,7,8,8,
   9,9,9,10],[1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,6,6,10]
  ,[1,1,1,1,1,1,2,2,2,2,2,2,3,3,5,5,7,7,7],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,5,6,7,7,8,8,9,9,10,10,
   11,12,12,12,13,13,13,14,14,14,15,15,16,16],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,3,5,6,7,7,8,9,9,9,10,10,
   10,11,13,14,15,15,16,16,17,17,18],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,4,5],
 [1,1,1,1,1,1,2,2,2,2,2,2,3,4,5,5,5,5,8,8,8,9,11,12,
   12,12,15,15,15,16,18,19],
 [1,1,1,1,1,1,2,2,2,2,2,2,4,4,4],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,4,5,5,5,6,6,
   6,6,7,7,7,7,8,8,8,8,9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,5,6,7,7,8,9,10,
   11,11,12,13,14,15,19,23],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,5,7,8,9,9,10,11,
   12,15,16,20,21,27,33,39],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,6,6,
   6,6,7,7,7,7,8,8,9,9,10,10,14,15,15,16,16],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,6,6,
   6,6,7,7,11,12,12,13,13,14,14,14,15,15,15,15,16,16,16,
   16,17,17,19,20,20,22,23,23,23,24,24,25,25,26,26,26,27,
   27],[1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,6,
   6,7,7,8,8,9,9,11,12,12,13,13,16,17,17,18,18,26,27,
   27,28,28,30,31,31,31,36],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,5,5,6,6,6,6,
   6,6,7,7,7,7,8,8,9,9,10,10,12,13,13,17,18,18,22,23,
   23,25,26,26,26,26,27,27,30],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,6,6,6,6,7,7,
   8,8,9,9,9,10,10,14,14,15,15,15,15,17,18,18,18,18,19,
   19,19,19,20,20,20,20,20,20,21,21,22,23,23,23,23,24,24,
   39,39],[1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,6,7]
  ,[1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,5,6,6,7,7,8,9,
   10,11,12,13,13,15,19,25,31],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,5,6,6,6,6,7,7,7,7,
   8,8,12,13,13,17,17,18,18,18,18,18,18,19,19,19,19,20,
   20,22,23,23,24,25,25,27,28,28,28,28,29,29,29,29,29,44]
  ,[1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,5,6,7,7,11,13],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,5,5,6,7,8,8,8,
   9,10,11,12,15],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,6],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,6,10,11,12,12,12,
   12,12,13,14,14],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,6,11,16,22],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,7,8,9,9,13,18,18 
  ],[1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,7,8,9,11,11,
   13,15,15,17,19,19,21,23,23],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,6,6,7,7,8,9,10,11,
   11,12,13,14,15,19,23],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,7,7,8,12,13,14,17],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,5,5,6,6,7,7,8,8,
   8,8,9,9,10,10,11,11,11,11,11,11,12,12,12,12],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,5,6,6,6,7,7,7,8,
   8,10,11,13,14,14,14,14,15,15],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,5,6,6,7,7,8,8,8,
   9,10,10,11,11,11,12,13,13,14,14,14,17,20],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,6,6,7,8,8,9,9,9,
   10,10,10,10,11,11,11,11,11,12,12],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,6,6,7,8,8,9,9,9,
   10,10,12,13,13,14,15,16,18,19,20,21],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,6,6,7,8,8,10,10,
   10,11,11,11,11,11,12,12,12,12],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,3,6,6,6,6,6,6,6,6,7,7,
   7,7],[1,1,1,1,1,1,2,2,2,2,2,3,3,4,4],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,5,5,5,6,6,8,9,
   9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,5,5,6,6,9,9,10,
   10],[1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,6,6,9,9,
   12,12],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,6,6,10,10,11,11],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,5,5,5,6,6,6,6,7,7,
   9,10,10,11,11,11,12,12,12,12,13,13,14,14,16,17,17,17,
   18,18,18,18,18,19,19,19,19,23,24,24,24,26,43],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,5,5,7,8],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,5,6,6,6,6,8,8,9,9,
   10,10,12,12,12,12,15,15],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,6,6,8],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,6,7,7,9,10,11],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,10,10,10,10,11,11,11,
   11,11,11,11,11],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,6,6,8,8,10],
 [1,1,1,1,1,1,2,2,2,2,2,3,3,8],
 [1,1,1,1,1,1,2,2,2,2,2,3,4,4,4,4,5,5,5,5,6,6,6,6,
   7,7],
 [1,1,1,1,1,1,2,2,2,2,2,3,4,4,4,5,6,7,9,10,11,22,23,
   28,29,34,35],
 [1,1,1,1,1,1,2,2,2,2,2,3,4,4,5,5,5,6,7],
 [1,1,1,1,1,1,2,2,2,2,2,3,4,7],
 [1,1,1,1,1,1,2,2,2,2,2,3,5,6],
 [1,1,1,1,1,1,2,2,2,2,3],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,4,
   4,5,5,5,5,5,6],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,5],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,5,5,6,6,7,7,
   8,8,9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,5,5,11,12,12,
   13,13,14,14,15,15,16,16,17,18,18,19,19,20,20,21,21,22,
   23,23,23,24,24,24,24,25,25,28,28,29],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,5,6,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,
   5,5,5,5,5,7,8],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,
   5,5,5,5,6,7,8],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,5,6,
   6,7,7,8,8,8,9,9,9,9,10,10,11,11,12,12,13,13,14,14,
   15,16,16,17,17,18,18,19,19,20,20,26,27,27,28,28,29,29]
  ,[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,5,
   6,6,7,7,8,8,8,9,9,9,9,10,10,11,11,12,12,13,13,14,
   14,15,16,16,17,17,18,18,19,19,20,20,31,32,32],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,5,6,
   6,7,7,8,8,9,9,10,11,11,12,12,13,13,14,14,14,15,15,
   15,15,15,16,16,16,16,17,17,17,17,18,18,19,20,20,20,21,
   21],[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,5,5,5,
   6,6,6,10,10,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,5,5,5,6,7,8,
   8,9,9,10,10,13,13,15,15],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,5,5,6,6],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,5,5,6,6,9,
   10,11,11,11,12,12,12,13,13,14,14,15,16,16,16,19,20,20,
   24],[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,5,5,
   7,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,5,5,7,7,7,
   9,9,11,11,13,14,15,15,15,18,19,23],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,5,5,7,7,8,
   9,10,10,10,11,11,11,12,13,14,14,14,16,17,20],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,6,6,7,7,8,
   8,8,9,9,9,9,9,9,10,10,10,10,11,11,14,16,17,17,17,17,
   18,18,19,19,19,20,20,20,20,21,21,25,27,28,28,30,32,33,
   33,33,33,34,34,35,36,36],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,6,6,7,7,8,
   8,8,9,9,9,9,9,9,10,10,10,10,11,11,22,24,25,25,25,25,
   26,26,27,28,28,30,32,33,33],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,6,6,7,7,8,
   8,8,9,9,10,10,10,10,16,17,17,18,18,19,19,22,23,23,24,
   24,25,25,28,29,29,30,30,34,35,37,37,43],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,6,6,7,7,8,
   8,9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,5,5,6,6,7,8,8,
   9,9,11,11,11,12,12,13,13],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,5,11,12,15,23],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,6,6,7,7,7,8,8,8,
   9,9,10,10,11],[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,4,6],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,
   7,7,8,8,9,10,11,11,11,14,15,19],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,10,12,12,
   16],[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,6,6,
   6,6,7,7,8,8,8,9],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,5,5,5,6,6,6,7,
   7,7,7,8,8,8,8,8,8,9,9,9,10,11,13],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,5,5,6,6,6,6,6,
   6,7,7,7,8,9],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,5,5,6,6,8,8,8,
   10,10,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,5,6,6,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,6,6,6,6,7,7,7,
   8,9,9,10],[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,5,6,6,7,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,5,6,6,7,7,
   8,8,9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,5,6,6,7,7,
   8,8,9,9,10,10,10,11,11,12,12,13,13,14,14,15,16,16,16,
   16,17,17,18,18,19,19,20,21,21,21,21,21,22,22,22,22,23,
   23,23,23,24,24,25,26,26,26,26,27,27,27,27],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,5,6,6,22,23,
   33],[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,5,7,
   7,7,7,9,9,9,9,11,11,11,11,13,13,13,13],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,5,7,7,9,10,
   10,11,11,11,12,12,12,12,13,13,13,13,13,14,14,14,14,14,
   14,15,15,15,15,15,16,16,16,16,16,16,17,17,17,17,17,18,
   18,19,19,19,20,21],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,6,6,6,6,7,
   7,8,8,9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,6,6,7,7,7,
   7,8,8,9,9,9,9,10,10,13,29,29,33,35,35,37,37],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,6,6,7,7,7,
   8,8,8,8,8,8,9,9,9,9,10,10,10,10,11,12,14,15,15,15,
   15,16,16,18,18,19,19,19,19,20,20,21,21,22,23,25,26,26,
   32,33,33,46,47,47],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,6,6,7,7,7,
   8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,
   11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,13,13,13,
   13,13,13,13,13,14,14,14,14,14,14,14,15,15],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,6,6,7,7,7,
   8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,13,14,15,16,
   16,16,17,17,18,18,20,21,21,22,22,23,23,30,31,31],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,6,6,7,7,7,
   8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,13,14,15,16,
   16,16,17,17,18,18,23,24,24],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,5,6,6,7,7,7,
   8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,13,14,15,16,
   16,16,17,17,18,18,25,25,26,26,26,26],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,6,6],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,6,6,7,7,8,8,
   9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,6,6,7,7,8,10,
   10,11,14,14,14,15,15,15,16,20,20,21],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,9,12,17],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,6,6,7,7,8,8,9,9 
  ],[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,6,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,6,8,9,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,8,11,12,15],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,6,6,6],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,8,8,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,9,9,9,9,10,10,10,
   10,11,11,11,11,11,11,12,12,12,12,13,13,18,18,20,20,24,
   24,24,24,24,24,25,25,25,25,26,26,28,28,28,28,29,29,50,
   50,54,54,54,54,55,55,58,58,62,62,110,110,114,114],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,5,6,8,8],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,6,7,7,7,8,8,10,10,
   11,15,16],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,4,4,5,5,5,5,6,
   6,7,7,8,8,9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,4,4,5,5,6,6,7,
   7,8,8],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,4,5,6,6,7,7,7,
   7,7,8,8],[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,5 
  ],[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,5,5,5,6,
   6,7,7,8,8,9,9,9,10,10,10,10,11,11],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,5,5,5,6,6,7,
   7,8,8,9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,5,6,6,7,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,5,6,6,7,7,7,
   8,8,9,9,9,10,10,11,11,12,13,13,14,14],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,5,9,10,10,10,
   10,11,11],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,6,6,6,6,9,9,
   9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,5,5,5,5,6,6,6,
   6,7,7,8,8,8,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,5,5,5,6,6,6,6,
   6,7,8,8,8,9,9,9,10,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,5,6,6,7,7,8,8,
   9,9,9,10,10,10,11],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,5,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,6,6,6,7,8,8,8,
   8,8,9,9],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,6,7,7,7,8,8,10,10,
   11,12,12,12,14,15,16,19,20,24],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,6,7,8,8],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,7,7,8,10,11],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,5,5,6,6,6,6,6,
   7,8,8,9,9,9,10,10,13,13,14],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,5,5,6,6,6,7,8,
   8,8,9,11,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,5,5,6,6,6,8,8,
   9,11,11,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,5,6,6,6,7,7,8,
   8,9,10,10,11],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,6,7,7,8,8,8,8,
   8,8,9,9,9,9,9,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,7,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,6,8,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,6,8,10,10,14],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,7,8,10,11,12,14,15,
   17,18,18,18,21,23],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,8,9,11,12,17,18,18,
   18,19,19,20,21,25,25,26,26,26],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,9,9,11,11,12,12,12,
   12,13,13,15,15,16,16],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,5,5,5,5,6,7,8,8,9,9,
   9,10,14,15],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,5,5,6,7,8,10,14],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,6,6,7,7,8,8,9,9,9,10,
   10,10,11,11,12,13,15,16,16,17,18,18,21,22,22],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,4,6,7,7,7,7,7,8,8,8,8,
   10,11,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,5,5,5,5,9,9,9,9,10,10,
   10,10,13,13,13,13,17,17,17,17],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,5,5,6,8,8,8,8,8,8,8,8,
   8,8,9,9,9,9,9,9,9,9,9,9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,3,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,4,4,4,4,4,4,4,4,
   5,5,5,7,7,8],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,4,4,5,5,5,5,6,6],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,5,5,5,5,6,6,8,8,
   9,9,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,5,5,5,6,6,6,6,6,
   7,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,5,5,5,6,6,7,7,7,
   7,9,9],[1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,5],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,5,5,6,6,6,6,6,
   7,8,8,9],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,5,5,6,6,6,6,7,
   7,8,8,9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,5,5,6,6,7,7,7,
   8,8,8,8,9,9,10,10,10,10,11,11,11,11,11,11,12,12,13,
   13,14,14,14,14,14,14,14,15,15,15,15,16],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,6,6,6,7,7,7,7,
   7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,
   11,11,11,11,12,12,12,12,12,12,13,13,13,13,14,14,14,14,
   14],[1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,6,6,6,7,
   7,8,8,12,13,13,14,14,14,14,15,15,15,15,15,15,16,16,
   16,16,16,16,16,17,17,17,18,18,19,19,19,19,20,20,22,24]
  ,[1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,6,7,7,7,7,8,
   8,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,
   11,11,11,11,12,12,12,13,13,13,13,13,13,14,14,14,14,16,
   19,19,20,20,20,20,20,20,20,20,21,21,21,21,35],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,6,7,10,11,12,13,
   15,16,17,18,18,23,24,25,33],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,6,6,10,10,11],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,7,7,8,10,11,12,13,
   15,15,16,16,18,19,19,22],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,6,6,8,9,11,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,5,5,6,6,6,6,7,
   7,8,8,9,11,12,12,13,13,14,14,15,20,21],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,5,6,6,7,7,8,8,
   9,9,10,10],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,5,6,6,8,8,8,9,
   9,10,10,12,13,13,14,14,15],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,6,6,6,6,6,6,7,
   7,7,7,8,8,9,9,10,10,10,11,11,11,11,12,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,6,6,6,6,7,7,7,
   7,8,8,9,9,9,10,10,10,10,11,11,13,14,14,15,15,17,18,
   18],[1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,6,7,10,12 
  ],[1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,7,8,9,9,11,
   11,11,12,12,14,14,14,15,18,19,19,20,22,22,23],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,7,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,6,6,7,7,7,8,8,8,8,
   9,9,9,9,10,10,11,11,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,6,7,8,8,9,9],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,6,6,6,7,8,8,9],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,4,8,8,8,8],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,5,6,6,7,8,9,9,10,10,
   11,11,12,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,5,6,7,7,8,8,9,9,10,
   10,10,10,11,12,14],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,6,6,6,6,7,7,7,7,7,
   7,8,9,9,10,10,10,11,11,12,14,17,18,22,23],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,6,7,7],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,6,7,7,7,8,8],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,7,7,8,8,8,8,8,8,8,
   9,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,13,13,14,
   14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,16,16,16,
   16,16,17,17,19,19,22,23,23,23,23,24,24,24,24,30],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,7,7,8,8,8,8,8,8,9,
   9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,13,13,14,
   14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,16,16,16,
   16,16,17,17,19,19,22,23,23,23,23,24,24,24,24],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,7,7,8,8,8,8,8,8,9,
   9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,13,13,14,
   14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,16,16,16,
   16,16,17,17,19,19,22,23,23,23,23,24,24,24,24,30],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,8,9,9],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,5,6,7,7,7,8,11,12],
 [1,1,1,1,1,1,2,2,2,2,3,3,4,6],
 [1,1,1,1,1,1,2,2,2,2,3,3,5,5,6,6],
 [1,1,1,1,1,1,2,2,2,2,3,3,5,5,7,7,11,13,13,17,19,19,
   23,25,25],
 [1,1,1,1,1,1,2,2,2,2,3,3,5,5,7,8,8,10,10,12,13,13,
   15,15,17,18,18,20,20,22],
 [1,1,1,1,1,1,2,2,2,2,3,3,5,6],
 [1,1,1,1,1,1,2,2,2,2,3,3,5,6,6,6,6,7,7,9,10,10,10,
   10,11,11,13,14,14,14,14,15,15,17,18,18],
 [1,1,1,1,1,1,2,2,2,2,3,3,5,6,6,7,8,8,8,9,9],
 [1,1,1,1,1,1,2,2,2,2,3,4],
 [1,1,1,1,1,1,2,2,2,2,3,4,4,4,4,5,5,5,5,5,5,6,6,6,
   7,7,7,8],
 [1,1,1,1,1,1,2,2,2,2,3,4,4,4,5,5,5,6,6,7],
 [1,1,1,1,1,1,2,2,2,2,3,4,4,5],
 [1,1,1,1,1,1,2,2,2,2,3,4,4,7,7,9,9,11,12,12,16,16,
   18,18,18,19,19,20,20,20,21,21,22,22,23,24,25,25,25,25,
   27,27],
 [1,1,1,1,1,1,2,2,2,2,3,4,4,7,8,8,8,8,8,9,9,9,9,9,
   9,10,10,10,11,11,11,11,12,12,12,12,13,13,14,15,15,15,
   15,16,16,16,16,17,17,17,18,18,18,18,19,19,19,19,20,20,
   24,25,25,26,27,27,27,27,28,28,28,28,29,29],
 [1,1,1,1,1,1,2,2,2,2,3,4,4,7,8,8,8,8,9,9,9,9,10,10,
   14,15,15,15,15,16,16,16,16,16,17,17,17,17,18,19,19,19,
   19,20,20,20,20,21,21,21,23,24,24],
 [1,1,1,1,1,1,2,2,2,2,3,4,5,5,5,5,5,6,6,6,6,6,6,7,
   7,7,7,7,8,8,8,8,8,9,9,10],
 [1,1,1,1,1,1,2,2,2,2,3,5],
 [1,1,1,1,1,1,2,2,2,2,3,5,5,5,7,7,9,10,11,11,12,12,
   14,15],
 [1,1,1,1,1,1,2,2,2,2,3,5,5,6,7,7,8,8,9,9,9,9,10,11,
   11],[1,1,1,1,1,1,2,2,2,2,3,5,6],
 [1,1,1,1,1,1,2,2,2,2,4,4,5,5,5,5,6,6,6,6,7,7,7,7,
   7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,11,12,12,
   12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,
   14,14,14,14,21,22,22,22,22,23,23,28],
 [1,1,1,1,1,1,2,2,2,2,4,4,5,6,6,6,6,6,7,7,7,7,8,8,
   8,9,9,9,9,9,10],
 [1,1,1,1,1,1,2,2,2,2,4,4,6,7,7,9,9],
 [1,1,1,1,1,1,2,2,2,2,5,5,10,11,11,12,12,13,14,14,15,
   15,16,17,17,18,18,18,18,19,20,20,21,21,22,23,23,24,24,
   24,24,25,26,26,27,27,28,31,39,42],
 [1,1,1,1,1,1,2,2,2,2,5,6,6,8,9,9,10,10,11,12,12,12,
   13,13,13,13,13,13,14,14,14,15,16,16,16,16,16,16,17,17,
   17,18,20,20,21,21,22,23],
 [1,1,1,1,1,1,2,2,2,2,5,6,6,8,9,9,10,11,11,11,11,11,
   12,12,12,12,12,12,13,13,13,14,14,14,14,14,15,15,15,15,
   16,16,16,16,17,17,19,20,20,20,21,21],
 [1,1,1,1,1,1,2,2,2,3,3,3],
 [1,1,1,1,1,1,2,2,2,3,3,3,3],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,4,4,4,5,5,5,5,6,6,
   13,14,14,18,19,19,19,19,19,20,20,20,20,21,21,24,25,25,
   25,25,25,25,26,26,26,26],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,4,4,4,5,5,5,5,6,6,
   13,14,14,18,19,19,19,19,19,20,20,20,20,21,21,24,25,25,
   25,25,25,26,26,26,26],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,6,6,
   7,7,9],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,5,6,6,7,7,9,10,
   10,11,14,15],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,5,5,5],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,4,4,4,5,5],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,5,6,7,
   7,8],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,4,5,5,5,6,6,7,7,
   8,9,10],[1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,4,6,6],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,5,5,5,5,6,6,11,12,
   12,12,12,13,13,16,17,17,17,17,18,18,20,21,21,21,21,21,
   22,22,22,22,22,22,25,27],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,5,5,5,6,6,6,7,7,
   7,9],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,5,5,5,6,7,7,8,8,
   8,9,10,11],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,6,6,7,7,8],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,6,7,8,8,10,12],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,5,6,6,7,7,7],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,5,7],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,5,7,7,7,8,9],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,6,6],
 [1,1,1,1,1,1,2,2,2,3,3,3,3,6],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,4,4,4,4,7,7,7,7,
   10,10,10,10,13,13,13,13],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,4,4,4,5,5,5,5,6,
   6,7],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,4,4,5,5,5,5,6,6,
   6,7],[1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,4,6],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,5,5,5,5,6,6,6,
   6,7,7,8],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,6,6,6,6,6,7,7,
   7,7],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,7,7,7,7,8,
   8,8,8,8,8,9,9,9,9,9,9,10,11,11,11,11,11,12,12,12,
   13,13,13,13,13,13],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,6,6,6,6,6,7,7,8,
   8,8,8,8,8,8,9,9,9,9,9,10,11,11,11,11,11,11,11,12,
   12,13,13,13,13,13],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,6,7,7,7,12],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,6,6],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,6,6,7,7,7,9],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,5,5,5,5,5,6,7,7,7,
   7,7,8,8,9,9,9,9,9,10,10,11,11,11,11,11,13,14,14,14],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,5,5,5,6,6,7,8,8,9,
   10,10,12,13],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,6,7,7],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,4,6,6,6,7,8,8,8],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,5],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,5,5,5,6,7,7,7,7,7,
   7,8,8,8,9,9,9,9,9,9,10,10,11,11,11,11,11,11,12,12,
   12,13,13,13,14,14],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,5,6,6,6,7,10],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,5,6,7,7,8,9,9,9],
 [1,1,1,1,1,1,2,2,2,3,3,3,4,6,6,6,6,8,10,10,11],
 [1,1,1,1,1,1,2,2,2,3,3,3,6,8,9],
 [1,1,1,1,1,1,2,2,2,3,3,3,7,7,8],
 [1,1,1,1,1,1,2,2,2,3,3,3,8,9],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,4,4,4,4,5,5,5,7,7,
   8,8,8,9],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,4,6,7,7,7,12],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,5,5,5,5,6,7,8],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,5,5,5,6,6,8,9],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,5,5,6,6,6,7,8,9,10,
   11,12],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,5,6,6,6,6,8,9,
   12,14],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,6,6,6,6,7,7,7,
   7,7,8,8,9,9,9,9,9,9,9,10,10,10,11,11,11,11,11,12,
   12,12,12,13,13,13],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,6,6,6,7,8,8,9,
   9,10,10,11],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,6,6,8],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,6,8,9,12],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,6,6,7,8,8,10],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,8,8,8,9,11,11],
 [1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,6,6,7,7,8,10],
 [1,1,1,1,1,1,2,2,2,3,3,4,5],
 [1,1,1,1,1,1,2,2,2,3,3,4,5,5,5,6,6,6,6,7,7],
 [1,1,1,1,1,1,2,2,2,3,3,4,5,6,6,6,6,7,9,10,10,10,10,
   10,11,11,12,12,16],
 [1,1,1,1,1,1,2,2,2,3,3,4,10,15,16],
 [1,1,1,1,1,1,2,2,2,3,3,5,6,6,6],
 [1,1,1,1,1,1,2,2,2,3,3,5,6,12],
 [1,1,1,1,1,1,2,2,2,3,3,5,7,11],
 [1,1,1,1,1,1,2,2,2,3,3,5,9],
 [1,1,1,1,1,1,2,2,2,3,3,5,9,12],
 [1,1,1,1,1,1,2,2,2,3,3,5,10,11],
 [1,1,1,1,1,1,2,2,2,3,3,5,11,12],
 [1,1,1,1,1,1,2,2,2,3,3,6,7],
 [1,1,1,1,1,1,2,2,2,3,3,6,9],
 [1,1,1,1,1,1,2,2,2,3,3,8,8,9],
 [1,1,1,1,1,1,2,2,2,3,3,8,9,10],
 [1,1,1,1,1,1,2,2,2,3,3,9,11],
 [1,1,1,1,1,1,2,2,2,3,4,4,5,5,5,5,6,7,7,7,9],
 [1,1,1,1,1,1,2,2,2,3,4,4,5,6,6],
 [1,1,1,1,1,1,2,2,2,3,4,4,8,8,11],
 [1,1,1,1,1,1,2,2,2,3,4,4,9,10],
 [1,1,1,1,1,1,2,2,2,3,4,4,9,15,16],
 [1,1,1,1,1,1,2,2,2,3,4,5],
 [1,1,1,1,1,1,2,2,2,3,4,5,5,5,6],
 [1,1,1,1,1,1,2,2,2,3,4,5,5,6,6,6,7],
 [1,1,1,1,1,1,2,2,2,3,4,5,5,7,8],
 [1,1,1,1,1,1,2,2,2,3,4,5,6,7,9,10,10,12,13,13,15,15,
   16,18,18,22,25],[1,1,1,1,1,1,2,2,2,3,4,5,8],
 [1,1,1,1,1,1,2,2,2,3,4,6,7],
 [1,1,1,1,1,1,2,2,2,3,4,6,8,11],
 [1,1,1,1,1,1,2,2,2,3,4,7,7,11],
 [1,1,1,1,1,1,2,2,2,3,4,8,8,9],
 [1,1,1,1,1,1,2,2,2,3,4,9,10,10,15,16],
 [1,1,1,1,1,1,2,2,2,3,4,12],
 [1,1,1,1,1,1,2,2,2,3,4,12,27,30],
 [1,1,1,1,1,1,2,2,2,3,5],
 [1,1,1,1,1,1,2,2,2,3,5,5,5,7,7],
 [1,1,1,1,1,1,2,2,2,3,5,5,6,6,7,7,9,9,9,10,11,14,18,
   18,21,21,22],[1,1,1,1,1,1,2,2,2,3,5,6,6],
 [1,1,1,1,1,1,2,2,2,3,5,6,7,9,10,10,13,14,14,16,17,18,
   18,19,20,22],[1,1,1,1,1,1,2,2,2,3,5,7,7,10],
 [1,1,1,1,1,1,2,2,2,3,5,7,8,9],
 [1,1,1,1,1,1,2,2,2,3,6,6,7,7],
 [1,1,1,1,1,1,2,2,2,4,4],
 [1,1,1,1,1,1,2,2,2,4,4,4,5,6,7,7,7,8,8,8,9,9,9,10,
   10,10,11,12,12,13,14],
 [1,1,1,1,1,1,2,2,2,4,4,5,5,5,5,5,5,10],
 [1,1,1,1,1,1,2,2,2,4,4,5,7,8],
 [1,1,1,1,1,1,2,2,2,4,4,8,9,9,14],
 [1,1,1,1,1,1,2,2,2,4,5,5,6],
 [1,1,1,1,1,1,2,2,2,4,5,5,6,7,8,9,10,11,14,15,18,18,
   20,21,23,24],
 [1,1,1,1,1,1,2,2,2,4,5,6,7,9,10,10,11,13,13,14,14,15,
   17,18,18],[1,1,1,1,1,1,2,2,2,4,6,6,10,11,11],
 [1,1,1,1,1,1,2,2,3],[1,1,1,1,1,1,2,2,3,3],
 [1,1,1,1,1,1,2,2,3,3,3],
 [1,1,1,1,1,1,2,2,3,3,3,3,3,3,4,4,4,6,8],
 [1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,4,5,6,6],
 [1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,6,7,8],
 [1,1,1,1,1,1,2,2,3,3,3,3,3,5],
 [1,1,1,1,1,1,2,2,3,3,3,3,4],
 [1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4],
 [1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,5],
 [1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,5,5,5,5],
 [1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,
   10,10],
 [1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,6,6,7,7,10,11,12,
   13,15,15,17,17,18,21,21,24,24],
 [1,1,1,1,1,1,2,2,3,3,3,3,4,5,5,6,6,6,7,7,7,7,7,8,
   8,9,9,9,9,9,9,9,9,10,10,11,11],
 [1,1,1,1,1,1,2,2,3,3,3,3,5,5,7,7,7,9,9,19,20,20,21,
   21,23,23,23,25,25,25,25,35,36,36,39],
 [1,1,1,1,1,1,2,2,3,3,3,3,5,8,9],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,4],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,8,
   8,11,12],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,5,5,5,5,6,6,7,7,7,
   8,8,8,8,9,9,9,9,10,10,10,11,11,12,12,13,14,14,14,15,
   15,15,15,16,16,16,17,17,18,19,19,20,20,21,22,22,25,26,
   26],[1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,5,5,5,5,6,6,
   7,7,8,12,12,12,16,16,16,18,18,18,20],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,5,5,6,6,6,6,7,7,12,
   13,13,15,15,16,17,17,18,18,19,19,21,25,26,27,27,29,29,
   30,31,31,32,32,35,35],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,5,5,6,6,6,7,7,7,7,
   10,11,11,11,12,12,12,12,13,13,14,14,14,14,15,15,15,15,
   15,15,18,18,19,19,19,19,19,20,20,23,24,24,27,28,28],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,5,5,6,6,6,7,7,7,7,
   10,11,11,14,15,15,15,15,16,16,16,16,16,16,16,16,17,17,
   17,17,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,
   20,20,22,23,23],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,4,5,5,5,6,6,7,7,7,8,10,
   10,11,11,13,14,15,16,18,18,19,20,22],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,4,5,5,5,8],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,4,5,5,6,7],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,6,6,7,8,8,8],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,6,6,7,8,8,8,9,9,9,
   9,10,10,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,
   16,16,16,16,17,17,17,17,19,20,20,21,21,25,26,26,31,32,
   32],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,7,7,7,8,10,10,10,10,
   10,11,11,12,12,12,12,12,13,13,13,14,15,15,16],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,5,6,6,6,6,6,7,7,7,7,7,
   7,8,8,8,8,9,9,9,9,10,10,11,12,12,12,12,12,12,13,13,
   13,13,13,13,13,13,14,14,14,14,15,15,15,16,16,16,16,17,
   17,18,18,18,19,19,19,20,20,22,23,23,25,26,26],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,5,6,6,6,6,6,7,7,7,7,7,
   7,8,8,8,8,9,9,9,9,10,10,11,12,12,12,12,12,12,13,13,
   13,13,13,13,13,14,14,14,14,15,15,15,16,16,16,16,17,17,
   18,18,18,19,19,19,20,20,31,32,32],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,5,7,8],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,6,6],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,6,7],
 [1,1,1,1,1,1,2,2,3,3,3,4,4,7,8],
 [1,1,1,1,1,1,2,2,3,3,3,4,5],
 [1,1,1,1,1,1,2,2,3,3,3,4,5,5,6],
 [1,1,1,1,1,1,2,2,3,3,3,4,5,5,6,7,9,15,15],
 [1,1,1,1,1,1,2,2,3,3,3,4,5,5,7,8],
 [1,1,1,1,1,1,2,2,3,3,3,4,5,6],
 [1,1,1,1,1,1,2,2,3,3,3,4,5,6,6,6,6,7,7,7,7,8,8,8,
   8,9,10,10,10,11,11,11,12,13,14,15,15],
 [1,1,1,1,1,1,2,2,3,3,3,4,5,6,7,8],
 [1,1,1,1,1,1,2,2,3,3,3,4,5,7,7,8,9,13,13],
 [1,1,1,1,1,1,2,2,3,3,3,4,6,7],
 [1,1,1,1,1,1,2,2,3,3,3,4,7],
 [1,1,1,1,1,1,2,2,3,3,3,4,7,7],
 [1,1,1,1,1,1,2,2,3,3,3,4,8,9],
 [1,1,1,1,1,1,2,2,3,3,3,4,8,12],
 [1,1,1,1,1,1,2,2,3,3,3,4,10,11],
 [1,1,1,1,1,1,2,2,3,3,3,4,10,17,18,20,21],
 [1,1,1,1,1,1,2,2,3,3,3,4,11,12,12],
 [1,1,1,1,1,1,2,2,3,3,3,4,15,16,17,17,18],
 [1,1,1,1,1,1,2,2,3,3,3,5,6,7],
 [1,1,1,1,1,1,2,2,3,3,3,5,7,8],
 [1,1,1,1,1,1,2,2,3,3,3,6],
 [1,1,1,1,1,1,2,2,3,3,3,6,9,9,9,12,15,21,21,24,24,30,
   30],[1,1,1,1,1,1,2,2,3,3,4],
 [1,1,1,1,1,1,2,2,3,3,4,4],
 [1,1,1,1,1,1,2,2,3,3,4,4,4],
 [1,1,1,1,1,1,2,2,3,3,4,4,4,4,5,5,5,5,13,17,20,22,26,
   29],[1,1,1,1,1,1,2,2,3,3,4,4,4,5,5],
 [1,1,1,1,1,1,2,2,3,3,4,4,4,5,6],
 [1,1,1,1,1,1,2,2,3,3,4,4,4,5,6,6,6,6,6,7,8],
 [1,1,1,1,1,1,2,2,3,3,4,4,4,5,6,7,7,8,9,9,10,10,11,
   13,13,14,15],[1,1,1,1,1,1,2,2,3,3,4,4,5],
 [1,1,1,1,1,1,2,2,3,3,4,4,5,5,5,8,8,9,9,9,12,12,13,
   13,13,13,13,13,16,16],
 [1,1,1,1,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10]
  ,[1,1,1,1,1,1,2,2,3,3,4,4,5,5,6,7,7],
 [1,1,1,1,1,1,2,2,3,3,4,4,5,7],
 [1,1,1,1,1,1,2,2,3,3,4,4,5,8,10],
 [1,1,1,1,1,1,2,2,3,3,4,4,5,9],
 [1,1,1,1,1,1,2,2,3,3,4,4,6],
 [1,1,1,1,1,1,2,2,3,3,4,4,6,7],
 [1,1,1,1,1,1,2,2,3,3,4,4,6,8],
 [1,1,1,1,1,1,2,2,3,3,4,4,7,7],
 [1,1,1,1,1,1,2,2,3,3,4,5,5],
 [1,1,1,1,1,1,2,2,3,3,4,5,5,5,5,5,5,6,6,6,6,6,7,8,
   8,8,8,8,8,9,9,9,9,9,9,9,10],
 [1,1,1,1,1,1,2,2,3,3,4,5,5,5,9,10],
 [1,1,1,1,1,1,2,2,3,3,4,5,5,7,7],
 [1,1,1,1,1,1,2,2,3,3,4,5,5,8],
 [1,1,1,1,1,1,2,2,3,3,4,5,5,9],
 [1,1,1,1,1,1,2,2,3,3,4,5,6],
 [1,1,1,1,1,1,2,2,3,3,4,5,6,6],
 [1,1,1,1,1,1,2,2,3,3,4,5,6,6,7,8,10,12,13],
 [1,1,1,1,1,1,2,2,3,3,4,5,6,7],
 [1,1,1,1,1,1,2,2,3,3,4,5,6,8,8,10,10,11,11],
 [1,1,1,1,1,1,2,2,3,3,4,5,6,8,8,11,14,16,18,19,21,23,
   25],[1,1,1,1,1,1,2,2,3,3,4,5,6,8,9,9,11,12],
 [1,1,1,1,1,1,2,2,3,3,4,5,7,8],
 [1,1,1,1,1,1,2,2,3,3,4,5,8,9],
 [1,1,1,1,1,1,2,2,3,3,4,5,8,9,11,11,12,13,14,14,15,15,
   16,17,17,18,19],[1,1,1,1,1,1,2,2,3,3,4,5,9,10],
 [1,1,1,1,1,1,2,2,3,3,4,5,11,12,16,17],
 [1,1,1,1,1,1,2,2,3,3,4,6],
 [1,1,1,1,1,1,2,2,3,3,4,6,7,7],
 [1,1,1,1,1,1,2,2,3,3,4,6,8,8,9,15],
 [1,1,1,1,1,1,2,2,3,3,4,7,7,9,10,14,15],
 [1,1,1,1,1,1,2,2,3,3,4,7,12,12,15],
 [1,1,1,1,1,1,2,2,3,3,4,8,10],
 [1,1,1,1,1,1,2,2,3,3,5,5,5,6,6,6,6,7,7,8,9,9,9,9,
   11,12,12,12,12,14,15,15,21,24,24,24,27,27],
 [1,1,1,1,1,1,2,2,3,3,5,5,6,6,7,7],
 [1,1,1,1,1,1,2,2,3,3,5,5,6,7],
 [1,1,1,1,1,1,2,2,3,3,5,5,6,9],
 [1,1,1,1,1,1,2,2,3,3,5,5,8,9],
 [1,1,1,1,1,1,2,2,3,3,5,6,6],
 [1,1,1,1,1,1,2,2,3,3,5,6,6,7,8,16,17],
 [1,1,1,1,1,1,2,2,3,3,5,10],
 [1,1,1,1,1,1,2,2,3,3,6,6,6,10],
 [1,1,1,1,1,1,2,2,3,3,6,6,6,12],
 [1,1,1,1,1,1,2,2,3,3,6,7,7,8],
 [1,1,1,1,1,1,2,2,3,3,6,7,7,8,9,9,9,9,10,10,10,11,11,
   11,11,11,12,12,12,12,12,12,12,13,13,13,13,13,13,14,14,
   14,14,14,14,15,15,15,15,15,15,15,15,15,15,16,16,16,16,
   16,17,17,17,17,18],
 [1,1,1,1,1,1,2,2,3,3,6,12,22,26],
 [1,1,1,1,1,1,2,2,3,3,7,8,8,9,11,12],
 [1,1,1,1,1,1,2,2,3,3,9,12,13,13,14,26],
 [1,1,1,1,1,1,2,2,3,3,12],[1,1,1,1,1,1,2,2,3,4],
 [1,1,1,1,1,1,2,2,3,4,4,4,4,4,4,4,5,5,5],
 [1,1,1,1,1,1,2,2,3,4,4,4,4,4,4,4,5,5,6],
 [1,1,1,1,1,1,2,2,3,4,4,4,4,4,5],
 [1,1,1,1,1,1,2,2,3,4,4,4,4,5,5,5,5,5,5,7,8,8,9,9,
   10,11,12,12,13,13,14,14,15,15,15,15,15,16,16,16,16,16,
   16,17,17,17,18,18,18,18,18,19,19,19,19,19,19,19,21,29,
   30,30,30,30,31,31,31,31,35,36,36],
 [1,1,1,1,1,1,2,2,3,4,4,4,4,7,7,8,9,9,9,9,9,10,10,
   10,10,12,12,12,12,14,14,15,15,15,15,15,15,15,15,17,17,
   17,17,19,19,20,20,20,20,20,20,20,20,21,22,22,22,22,22,
   22,22,22,24,24,25,25,26,27,27,27],
 [1,1,1,1,1,1,2,2,3,4,4,4,4,7,8,8,8,8,8,9,9,9,9,9,
   9,9,9,11,12,12,12,12,12,13,13,13,13,13,13,13,13,14,
   14,14,14,15,16,16,16,16,16,17,17,17,17,17,17,17,17,18,
   18,18,18,19,20,20,20,20,21,21,21,21,21,21,24,25,25,25,
   26,26],
 [1,1,1,1,1,1,2,2,3,4,4,4,4,7,8,8,8,8,9,9,9,9,11,12,
   12,12,12,13,13,13,13,15,15,16,16,16,16,16,16,16,16,17,
   17,17,17,19,19,19,20,20,20,20,20,20,20,21,21],
 [1,1,1,1,1,1,2,2,3,4,4,4,5],
 [1,1,1,1,1,1,2,2,3,4,4,4,6,6],
 [1,1,1,1,1,1,2,2,3,4,4,4,6,7],
 [1,1,1,1,1,1,2,2,3,4,4,5,5,6,6,6,6,6,7,7,8,8,8,8,
   8,9,10,10,10,10,10,11,12,12,13,13,14,14,15,17],
 [1,1,1,1,1,1,2,2,3,4,4,5,5,7,7,8,8,10,10,11,11,13,
   13,14,14,16,16],
 [1,1,1,1,1,1,2,2,3,4,4,5,5,7,7,9,10,12],
 [1,1,1,1,1,1,2,2,3,4,4,5,5,8],
 [1,1,1,1,1,1,2,2,3,4,4,5,5,8,12],
 [1,1,1,1,1,1,2,2,3,4,4,5,6,6],
 [1,1,1,1,1,1,2,2,3,4,4,5,6,7,13,15],
 [1,1,1,1,1,1,2,2,3,4,4,5,6,8],
 [1,1,1,1,1,1,2,2,3,4,4,5,6,9],
 [1,1,1,1,1,1,2,2,3,4,4,5,7,7,7,8,9,10],
 [1,1,1,1,1,1,2,2,3,4,4,5,7,8],
 [1,1,1,1,1,1,2,2,3,4,4,5,7,8,9,9,10,10,11,12,13,14,
   14,15,15,16,19,20,20,21,24,26],
 [1,1,1,1,1,1,2,2,3,4,4,5,8,8,9],
 [1,1,1,1,1,1,2,2,3,4,4,9,10],
 [1,1,1,1,1,1,2,2,3,4,4,10,12,14,14,15,15],
 [1,1,1,1,1,1,2,2,3,4,4,12,18,19,20,26,26,27,27,28,34,
   34,34,35,35,35,36],[1,1,1,1,1,1,2,2,3,4,5],
 [1,1,1,1,1,1,2,2,3,4,5,5,5,6,6,7,9,14,15,15,16,16,
   18,19,19,20,20,20,24,26],
 [1,1,1,1,1,1,2,2,3,4,5,5,5,6,6,8],
 [1,1,1,1,1,1,2,2,3,4,5,5,6],
 [1,1,1,1,1,1,2,2,3,4,5,5,6,6],
 [1,1,1,1,1,1,2,2,3,4,5,5,6,6,6,7],
 [1,1,1,1,1,1,2,2,3,4,5,5,6,6,8,9],
 [1,1,1,1,1,1,2,2,3,4,5,5,7,9,9,15,16],
 [1,1,1,1,1,1,2,2,3,4,5,6,6,7,7],
 [1,1,1,1,1,1,2,2,3,4,5,6,6,7,7,8,9,9,10],
 [1,1,1,1,1,1,2,2,3,4,5,6,8,9,10,12],
 [1,1,1,1,1,1,2,2,3,4,5,6,8,10,13,16],
 [1,1,1,1,1,1,2,2,3,4,5,6,9,10],
 [1,1,1,1,1,1,2,2,3,4,5,6,12,16,20,23],
 [1,1,1,1,1,1,2,2,3,4,5,7,10,12,16,20,21],
 [1,1,1,1,1,1,2,2,3,4,5,8,9],
 [1,1,1,1,1,1,2,2,3,4,6,9],
 [1,1,1,1,1,1,2,2,3,4,7,8,8,12],
 [1,1,1,1,1,1,2,2,3,4,7,9,10],
 [1,1,1,1,1,1,2,2,3,4,7,9,10,20,24,24],
 [1,1,1,1,1,1,2,2,3,5],
 [1,1,1,1,1,1,2,2,3,5,5,5,7,7,8,16,17],
 [1,1,1,1,1,1,2,2,3,5,5,6,6,7,8],
 [1,1,1,1,1,1,2,2,3,5,5,6,8,9],
 [1,1,1,1,1,1,2,2,3,5,6],
 [1,1,1,1,1,1,2,2,3,5,6,6,6,10,12],
 [1,1,1,1,1,1,2,2,3,5,6,6,7,7,8,14],
 [1,1,1,1,1,1,2,2,3,5,6,6,9,9,11,14,16,18,19],
 [1,1,1,1,1,1,2,2,3,5,6,7,8,9,9,10],
 [1,1,1,1,1,1,2,2,3,5,6,8,8,9,10,10],
 [1,1,1,1,1,1,2,2,3,5,7,9],
 [1,1,1,1,1,1,2,2,3,5,7,10,12,17],
 [1,1,1,1,1,1,2,2,3,5,8,9,10,15],
 [1,1,1,1,1,1,2,2,3,6,6],
 [1,1,1,1,1,1,2,2,3,6,6,6,6,9,9,12,12,12,12,12,12,12,
   12,15,15,15,15],
 [1,1,1,1,1,1,2,2,3,6,6,6,9,9,9,9,9,12,12,12,12,12,
   12,12,15,15,15,15,15,15,15,15,15],
 [1,1,1,1,1,1,2,2,3,6,8,8],
 [1,1,1,1,1,1,2,2,3,6,8,10,12,15,18,26],
 [1,1,1,1,1,1,2,2,3,6,9],
 [1,1,1,1,1,1,2,2,4,4,4,4,5,6,7,7,7,9,9],
 [1,1,1,1,1,1,2,2,4,4,4,4,6,6,7,7],
 [1,1,1,1,1,1,2,2,4,4,4,5,6,7],
 [1,1,1,1,1,1,2,2,4,4,5,5,5,5,6,6,10],
 [1,1,1,1,1,1,2,2,4,4,5,7],
 [1,1,1,1,1,1,2,2,4,5,5,5,5,6,6,7,8,8,8,8,9,9,9,10,
   10,10,10,10,11,11,11,11,11,11,12,12,12,13,13,13,13,13,
   13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,
   15,16,17],[1,1,1,1,1,1,2,2,4,5,5,5,6,7,13,14],
 [1,1,1,1,1,1,2,2,4,5,5,6,8,9,10],
 [1,1,1,1,1,1,2,2,4,5,5,6,9,10,12,12,13,13,13,13,13,
   14,14,14,17,17,17,18,18,18,20,20,20,20],
 [1,1,1,1,1,1,2,2,4,5,5,10,11,16],
 [1,1,1,1,1,1,2,2,4,5,6,6],
 [1,1,1,1,1,1,2,2,4,5,6,9,9],
 [1,1,1,1,1,1,2,2,4,5,8,8,10,11],
 [1,1,1,1,1,1,2,2,4,5,8,8,10,12,16,18],
 [1,1,1,1,1,1,2,2,4,6,7,8,8,9],
 [1,1,1,1,1,1,2,2,5,5,5,8,10,13],
 [1,1,1,1,1,1,2,2,5,5,6,7,8,11],
 [1,1,1,1,1,1,2,2,5,6,6,6,7,7],
 [1,1,1,1,1,1,2,2,6,6,6],[1,1,1,1,1,1,2,3],
 [1,1,1,1,1,1,2,3,3,3],
 [1,1,1,1,1,1,2,3,3,3,3,3,3,3,4,4,4,4,4,5],
 [1,1,1,1,1,1,2,3,3,3,3,3,4,4,4,4,4,5,6],
 [1,1,1,1,1,1,2,3,3,3,3,3,4,4,4,9,10],
 [1,1,1,1,1,1,2,3,3,3,3,3,4,5,7],
 [1,1,1,1,1,1,2,3,3,3,3,4,4],
 [1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,4,6,8],
 [1,1,1,1,1,1,2,3,3,3,3,4,4,4,5,11,12,14,15],
 [1,1,1,1,1,1,2,3,3,3,3,4,4,4,6],
 [1,1,1,1,1,1,2,3,3,3,3,4,4,5,6,8,9,9,10],
 [1,1,1,1,1,1,2,3,3,3,3,4,9,10],
 [1,1,1,1,1,1,2,3,3,3,3,5,5,7,7,9,9,11,11],
 [1,1,1,1,1,1,2,3,3,3,4,4,5,6,6,8,8,9,9],
 [1,1,1,1,1,1,2,3,3,3,4,4,6,6],
 [1,1,1,1,1,1,2,3,3,3,4,5,5,6],
 [1,1,1,1,1,1,2,3,3,3,4,5,5,10,11,11,12],
 [1,1,1,1,1,1,2,3,3,3,4,5,6,14,15,19,19],
 [1,1,1,1,1,1,2,3,3,3,4,5,7,8],
 [1,1,1,1,1,1,2,3,3,3,4,5,9,13,14,16,19],
 [1,1,1,1,1,1,2,3,3,3,4,6,7,7,7,9,10,11,11,12,13,15,
   15,15,16,19,19],[1,1,1,1,1,1,2,3,3,4],
 [1,1,1,1,1,1,2,3,3,4,4],[1,1,1,1,1,1,2,3,3,4,4,4],
 [1,1,1,1,1,1,2,3,3,4,4,4,5,8],
 [1,1,1,1,1,1,2,3,3,4,4,4,11,11,16],
 [1,1,1,1,1,1,2,3,3,4,4,5],
 [1,1,1,1,1,1,2,3,3,4,4,5,5,5],
 [1,1,1,1,1,1,2,3,3,4,4,5,5,6],
 [1,1,1,1,1,1,2,3,3,4,4,5,5,7,7,9,9,11,11],
 [1,1,1,1,1,1,2,3,3,4,4,5,6,7,7,8,9,10,12,13,15,15,
   17,18,21],[1,1,1,1,1,1,2,3,3,4,4,5,11,11,15],
 [1,1,1,1,1,1,2,3,3,4,4,6],
 [1,1,1,1,1,1,2,3,3,4,4,7,7,10,11,14],
 [1,1,1,1,1,1,2,3,3,4,4,10,12,14,15],
 [1,1,1,1,1,1,2,3,3,4,5,5,6,9,10,10,11],
 [1,1,1,1,1,1,2,3,3,4,5,6,6,7,8,8,8,9,9,10,11,11,11,
   12,13,13,15,16,17,17,18,19,19,21,26],
 [1,1,1,1,1,1,2,3,3,4,5,6,7,10,10],
 [1,1,1,1,1,1,2,3,3,4,5,10],[1,1,1,1,1,1,2,3,3,4,6]
  ,[1,1,1,1,1,1,2,3,3,4,7],[1,1,1,1,1,1,2,3,3,5,5]
  ,[1,1,1,1,1,1,2,3,3,5,5,6,7,7,9,9,11,11],
 [1,1,1,1,1,1,2,3,3,5,6,7,7,7,8,8,9,9,9,9,10,10,12,
   13,13,14,14,15,15,15,16,16,17,18,18,19,19,20,20,20,21,
   21],[1,1,1,1,1,1,2,3,3,7,9,9,13,18,20,22,22,23,26,
   28,31,33,36,44],[1,1,1,1,1,1,2,3,3,7,9,10],
 [1,1,1,1,1,1,2,3,3,11,11,12],[1,1,1,1,1,1,2,3,4,4],
 [1,1,1,1,1,1,2,3,4,4,4],[1,1,1,1,1,1,2,3,4,4,4,4],
 [1,1,1,1,1,1,2,3,4,4,4,5,5,5],
 [1,1,1,1,1,1,2,3,4,4,4,6,7,7,7,9,10,10,10,12,13,13,
   13,15,16,16,16],[1,1,1,1,1,1,2,3,4,4,6],
 [1,1,1,1,1,1,2,3,4,4,6,6],[1,1,1,1,1,1,2,3,4,4,8],
 [1,1,1,1,1,1,2,3,4,5,5,5,6,7,8,12,13],
 [1,1,1,1,1,1,2,3,4,5,5,5,7,7,8,8,9,10,11,11,13,13,
   14,14,14,14,16,17,18],
 [1,1,1,1,1,1,2,3,4,5,5,5,7,9,10],
 [1,1,1,1,1,1,2,3,4,5,6,7,9,10],
 [1,1,1,1,1,1,2,3,4,6,6,6,6,7,7,7,7,7,7,8,8],
 [1,1,1,1,1,1,2,3,4,6,6,7],
 [1,1,1,1,1,1,2,3,4,6,6,8,8,11,12,13,13,26],
 [1,1,1,1,1,1,2,3,5,5,6,6,6,6,10,13],
 [1,1,1,1,1,1,2,3,5,5,6,6,6,7,7,8,9,10,10,11,11,12,
   12,12,13,13,13,14,14,14,14,15,15,15,16,17,24,25],
 [1,1,1,1,1,1,2,3,6],[1,1,1,1,1,1,2,3,7,7],
 [1,1,1,1,1,1,2,3,7,9],
 [1,1,1,1,1,1,2,3,8,11,12,15,16,16,16,24],
 [1,1,1,1,1,1,2,3,10,10],[1,1,1,1,1,1,2,4],
 [1,1,1,1,1,1,2,4,4,4,4,14,14,14,14,24,24,24,24],
 [1,1,1,1,1,1,2,4,4,4,6,7,7,10,10],
 [1,1,1,1,1,1,2,4,4,4,7],
 [1,1,1,1,1,1,2,4,4,5,5,6,6,10,12],
 [1,1,1,1,1,1,2,4,4,5,5,7,7,8],
 [1,1,1,1,1,1,2,4,4,5,6],
 [1,1,1,1,1,1,2,4,4,5,6,7,7,8,15],
 [1,1,1,1,1,1,2,4,4,5,6,9,14],
 [1,1,1,1,1,1,2,4,4,5,8,9,11,16],
 [1,1,1,1,1,1,2,4,4,6,7,7,8,8,12],
 [1,1,1,1,1,1,2,4,4,7,9,11,11,12,14,14,16,18,18,19,21,
   21,23,28,30,30,36,39,41],[1,1,1,1,1,1,2,4,5,5,10],
 [1,1,1,1,1,1,2,4,5,6],
 [1,1,1,1,1,1,2,4,5,6,6,6,7,8,9,9,10],
 [1,1,1,1,1,1,2,4,5,6,8,9,10,14],
 [1,1,1,1,1,1,2,4,5,10,11],[1,1,1,1,1,1,2,4,6,7],
 [1,1,1,1,1,1,2,4,6,7,9],[1,1,1,1,1,1,2,4,6,9,10],
 [1,1,1,1,1,1,2,4,6,10,11],[1,1,1,1,1,1,2,4,10,10],
 [1,1,1,1,1,1,2,5,5,5],[1,1,1,1,1,1,2,5,5,5,9],
 [1,1,1,1,1,1,2,5,5,6],[1,1,1,1,1,1,2,5,5,9,10],
 [1,1,1,1,1,1,2,5,6,8,10],[1,1,1,1,1,1,2,5,6,9,9],
 [1,1,1,1,1,1,2,5,6,9,10],[1,1,1,1,1,1,2,5,6,10,10],
 [1,1,1,1,1,1,2,5,7,9,9],[1,1,1,1,1,1,2,5,9,10],
 [1,1,1,1,1,1,2,6,9,9],
 [1,1,1,1,1,1,2,7,7,9,9,10,10],
 [1,1,1,1,1,1,3,3,3,3,3,3,4,5,5,6,8,8],
 [1,1,1,1,1,1,3,3,3,3,3,3,4,5,5,8,9,14,14,15],
 [1,1,1,1,1,1,3,3,3,3,4],[1,1,1,1,1,1,3,3,3,3,4,4],
 [1,1,1,1,1,1,3,3,3,3,4,4,4,5,5,14,15,15],
 [1,1,1,1,1,1,3,3,3,3,4,4,5,5,6,6,7,12,12,13],
 [1,1,1,1,1,1,3,3,3,3,4,4,5,5,7,7,9,9,11,11],
 [1,1,1,1,1,1,3,3,3,3,4,5,5,5,5,7,7,7,7,9,9,9,9,11,
   11,11,11],
 [1,1,1,1,1,1,3,3,3,3,5,5,5,5,7,7,7,7,9,9,9,9,11,11,
   11,11],[1,1,1,1,1,1,3,3,3,3,5,5,7,7,9,9,11,11],
 [1,1,1,1,1,1,3,3,3,4,4,4,5,7,7,8,8,8,9],
 [1,1,1,1,1,1,3,3,3,4,4,5,5,6,7,7,8,9,9],
 [1,1,1,1,1,1,3,3,4],[1,1,1,1,1,1,3,3,4,4,4],
 [1,1,1,1,1,1,3,3,4,4,4,4,4,5,5,5,6,7,9],
 [1,1,1,1,1,1,3,3,4,4,4,4,5,5,5,5,6,7,8],
 [1,1,1,1,1,1,3,3,4,4,4,4,6,9],
 [1,1,1,1,1,1,3,3,4,4,4,5],
 [1,1,1,1,1,1,3,3,4,4,4,5,5],
 [1,1,1,1,1,1,3,3,4,4,4,5,5,6,6,7,7],
 [1,1,1,1,1,1,3,3,4,4,4,5,8],
 [1,1,1,1,1,1,3,3,4,4,4,7,7,8],
 [1,1,1,1,1,1,3,3,4,4,4,7,7,11,11,12],
 [1,1,1,1,1,1,3,3,4,4,5],
 [1,1,1,1,1,1,3,3,4,4,5,6,6,7],
 [1,1,1,1,1,1,3,3,4,4,5,6,6,10,10,11],
 [1,1,1,1,1,1,3,3,4,4,5,9,10],
 [1,1,1,1,1,1,3,3,4,4,5,10],
 [1,1,1,1,1,1,3,3,4,4,6,6,7,9,10],
 [1,1,1,1,1,1,3,3,4,4,6,6,8,8,9],
 [1,1,1,1,1,1,3,3,4,4,8,8,9],
 [1,1,1,1,1,1,3,3,4,4,8,8,13,13,27,32,32,41,46,46,46,
   55,60,60,69],
 [1,1,1,1,1,1,3,3,4,4,8,8,13,17,17,22,23,26,26,27,27,
   32,32,33,37,37,42,42,43,53],
 [1,1,1,1,1,1,3,3,4,4,8,11,11,12,14,14,15,15,16,17,17,
   18,18,19,19,20],[1,1,1,1,1,1,3,3,4,4,10,10,20],
 [1,1,1,1,1,1,3,3,4,5,5,6,6,7,7,9,9,9,11,11,11,11,14]
  ,[1,1,1,1,1,1,3,3,4,5,5,6,6,7,7,9,9,11,11,12,12,
   13,15,15,21,21,22],[1,1,1,1,1,1,3,3,4,5,10,10,11],
 [1,1,1,1,1,1,3,3,4,6,6,9,11,11,12,14,16,18,19,21,21,
   22,24,25,28,30,40],
 [1,1,1,1,1,1,3,3,4,6,6,9,11,11,14,19,19,19,19],
 [1,1,1,1,1,1,3,3,4,6,6,14,16,16,21,23,23,24,28,31,31,
   35],[1,1,1,1,1,1,3,3,4,6,6,17,19,19,27,37,47,57],
 [1,1,1,1,1,1,3,3,4,6,7,8,8],
 [1,1,1,1,1,1,3,3,4,7,8,8,8,9,13,13,14],
 [1,1,1,1,1,1,3,3,4,7,9,10,11,11,12,13,15,16,17,17,18,
   19,19,19,19,20,20,20,22,24,24,25],
 [1,1,1,1,1,1,3,3,4,8,11],[1,1,1,1,1,1,3,3,5],
 [1,1,1,1,1,1,3,3,5,5,7,7,9,9,11,11],
 [1,1,1,1,1,1,3,3,5,5,10,11,11],
 [1,1,1,1,1,1,3,3,5,5,11],[1,1,1,1,1,1,3,3,5,8],
 [1,1,1,1,1,1,3,3,6,6,6,6,10,10,13,13,13,13,15,15,15,
   15,17,17,19,19,22,22,22,22,24,24,24,24],
 [1,1,1,1,1,1,3,3,6,6,8,8,8,8,8,8,8,8,11,11,13,13,13,
   13,13,13,13,13,13,13,15,15,15,15,15,15,15,15,18,18,20,
   20],[1,1,1,1,1,1,3,3,6,6,14,19,27,32,42,47,52,55,
   57,62],
 [1,1,1,1,1,1,3,3,6,8,8,11,11,13,13,13,13,16,16,16,18,
   18,21,21,21,26],
 [1,1,1,1,1,1,3,3,7,7,12,13,14,14,15],
 [1,1,1,1,1,1,3,3,9,11,11,16,16,17,17,19,19,19,19,20,
   20,22,22,22],[1,1,1,1,1,1,3,4,4],
 [1,1,1,1,1,1,3,4,4,4],[1,1,1,1,1,1,3,4,4,4,4],
 [1,1,1,1,1,1,3,4,4,4,4,4,4,5,5,5,5,8,8],
 [1,1,1,1,1,1,3,4,4,4,4,4,4,7,7,8,8,8,8],
 [1,1,1,1,1,1,3,4,4,4,4,5,5,6,6,7,7,7,8],
 [1,1,1,1,1,1,3,4,4,4,4,7,7,7,7,10,10,10,10,13,13,13,
   13,16,16,16,16],[1,1,1,1,1,1,3,4,4,4,5,5,11,12],
 [1,1,1,1,1,1,3,4,4,4,5,10,10,20,21,24],
 [1,1,1,1,1,1,3,4,4,5],
 [1,1,1,1,1,1,3,4,4,5,5,5,5,7,7,8,10],
 [1,1,1,1,1,1,3,4,4,5,5,5,12,19],
 [1,1,1,1,1,1,3,4,4,5,5,5,15,16,16,26],
 [1,1,1,1,1,1,3,4,4,5,5,6,6,8,9,11,12,12,14,14,15,15,
   15,16,16,17,17,18,18],
 [1,1,1,1,1,1,3,4,4,5,7,7,7,8,8,9,10],
 [1,1,1,1,1,1,3,4,4,5,7,8],[1,1,1,1,1,1,3,4,4,5,10]
  ,[1,1,1,1,1,1,3,4,4,6],[1,1,1,1,1,1,3,4,4,7,7],
 [1,1,1,1,1,1,3,4,4,7,8,8,12,14,15,16,19,19,20],
 [1,1,1,1,1,1,3,4,4,8],[1,1,1,1,1,1,3,4,4,8,9],
 [1,1,1,1,1,1,3,4,4,10,12,12],[1,1,1,1,1,1,3,4,5],
 [1,1,1,1,1,1,3,4,5,5,7,8,9,16],
 [1,1,1,1,1,1,3,4,5,5,14,16,17,17],
 [1,1,1,1,1,1,3,4,5,7],[1,1,1,1,1,1,3,4,5,7,8],
 [1,1,1,1,1,1,3,4,5,8,10],
 [1,1,1,1,1,1,3,4,5,9,11,12],[1,1,1,1,1,1,3,4,5,11],
 [1,1,1,1,1,1,3,4,5,11,12,12,14,15,16,17],
 [1,1,1,1,1,1,3,4,5,14,16,17,18,19,19,20],
 [1,1,1,1,1,1,3,4,7],[1,1,1,1,1,1,3,4,9,12],
 [1,1,1,1,1,1,3,5,5,7,7],
 [1,1,1,1,1,1,3,6,6,7,7,8,8,8,8,9,9,9,9,9,9,10,10,
   11,11,12,12,12,12,13,13,14,14,15,15,15,15,16,16],
 [1,1,1,1,1,1,3,7,7],[1,1,1,1,1,1,4],
 [1,1,1,1,1,1,4,4,4,4,4,4,6,7,7,7,7,9,9],
 [1,1,1,1,1,1,4,4,4,7],[1,1,1,1,1,1,4,4,4,7,9],
 [1,1,1,1,1,1,4,4,5,5,6,6,8,9,9,10,10,10,10,11,11,11,
   11,12,12,12,12,12,12,13,13,13,13,14,14,14,15,15,16],
 [1,1,1,1,1,1,4,4,5,6,6,7,8,8,15,15,16],
 [1,1,1,1,1,1,4,4,5,6,7],[1,1,1,1,1,1,4,4,5,8,9],
 [1,1,1,1,1,1,4,4,6,6,6,6,9,9,9,11,11,11,11,12,14,14,
   14,14,17,17,17,20,20,22,22,25,25],
 [1,1,1,1,1,1,4,4,9],[1,1,1,1,1,1,4,5,5],
 [1,1,1,1,1,1,4,5,5,5,6,7,8,13,19,19],
 [1,1,1,1,1,1,4,5,5,6,6,13,13],
 [1,1,1,1,1,1,4,5,5,8,8,9,10,11,11,14],
 [1,1,1,1,1,1,4,5,5,9,9],
 [1,1,1,1,1,1,4,5,6,6,8,8,13,14,17,17,18],
 [1,1,1,1,1,1,4,5,7,8,9,9,13,13,14],
 [1,1,1,1,1,1,4,5,8,8,8,9,9,12],
 [1,1,1,1,1,1,4,6,6,6,6,9,11,11,11,11,14,14,14,14,14,
   17,20,20,20,20],
 [1,1,1,1,1,1,4,6,6,6,7,7,8,8,15,15,16],
 [1,1,1,1,1,1,4,6,6,6,8,9,11],
 [1,1,1,1,1,1,4,6,6,14,16,16,19,21,21,24,24,26,26,26,
   26,29,29,29],
 [1,1,1,1,1,1,4,8,8,9,10,10,10,10,12,12,13],
 [1,1,1,1,1,1,5,5,5,5,9,9,12],
 [1,1,1,1,1,1,5,5,5,5,9,9,13,13,20],
 [1,1,1,1,1,1,5,5,5,5,9,9,17,17,20],
 [1,1,1,1,1,1,5,5,5,6,7,7],[1,1,1,1,1,1,5,5,6,7],
 [1,1,1,1,1,1,5,5,8],[1,1,1,1,1,1,5,5,8,10,11,12],
 [1,1,1,1,1,1,5,6,10,11,11,12,12,12],
 [1,1,1,1,1,1,5,7,9,10,10,11,15,16,19],
 [1,1,1,1,1,1,6,6,7,12,12,12],
 [1,1,1,1,1,1,6,8,8,9,11,11,12,13,14,14,15,15,15,16,16,
   17,17,18,18,18,18,19,20],
 [1,1,1,1,1,1,6,8,8,10,10,11,11,12,13,13,14],
 [1,1,1,1,1,1,6,9,10,10,13],
 [1,1,1,1,1,1,7,7,14,19,21,21,24,27,27,28,29,32,32,33,
   34,35,35,37,37,39,41,41,41,41,42],
 [1,1,1,1,1,1,7,10,11,11,12,12,13,15,15,16,18,18,18,20,
   21,22,22,23,23,23,23,24,24,26,27,27,29,31,31,33,33],
 [1,1,1,1,2],[1,1,1,1,2,3,3,3,5],
 [1,1,1,1,2,3,3,4,4],[1,1,1,1,2,3,3,4,4,6],
 [1,1,1,1,2,3,4],[1,1,1,1,2,3,4,4,9],
 [1,1,1,1,2,3,4,7],[1,1,1,1,2,3,5,6],
 [1,1,1,1,2,3,5,10],[1,1,1,1,2,3,7],
 [1,1,1,1,2,3,7,10],[1,1,1,1,2,4,4],
 [1,1,1,1,2,4,4,6,6],[1,1,1,1,2,4,5],
 [1,1,1,1,2,4,6],[1,1,1,1,2,4,7,8],
 [1,1,1,1,2,4,7,10],[1,1,1,1,2,4,7,10,11],
 [1,1,1,1,2,6,7,8],[1,1,1,1,2,7,7],
 [1,1,1,1,3,3,4,4,4,4],[1,1,1,1,3,3,5,5],
 [1,1,1,1,3,4,4,4,7],[1,1,1,1,3,4,4,5],
 [1,1,1,1,3,4,4,5,6],[1,1,1,1,3,4,5,8],
 [1,1,1,1,3,5,7,7],[1,1,1,1,4],
 [1,1,1,1,4,4,4,4,6],[1,1,1,1,4,4,5,7,8],
 [1,1,1,1,4,4,5,8],
 [1,1,1,1,4,4,6,6,8,8,10,10,12,12,14,14],
 [1,1,1,1,4,4,7,8],[1,1,1,1,4,4,8],
 [1,1,1,1,4,5,8,8,9],[1,1,1,1,5,5,8,9,9],
 [1,1,1,2],[1,1,1,2,2],[1,1,1,2,2,2,2,2,2],
 [1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,8,8,
   9,9,11,11,12,12,14,14,15,15],
 [1,1,1,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,6,6,6,6,
   6,6,6,6,8,8,8,8,8,8,8,8,10,10,10,10,10,10,10,10],
 [1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,5,5,6,6,6,7,
   7,8,8,9,9,10],
 [1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,5,5,6,
   6,6,6,6,8,8,8,8,10,10,10,10],
 [1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,5,5,6,
   6,6,6,7,7,7,8,8,9,9,9,10],
 [1,1,1,2,2,2,2,2,2,2,2,3,3,4],
 [1,1,1,2,2,2,2,2,2,2,3,3,3,4,4,4,4,4,5,5,5,5,5,6,
   6,6,6,7],[1,1,1,2,2,2,2,2,2,2,4,4],
 [1,1,1,2,2,2,2,2,2,2,4,4,4,4,6,10],
 [1,1,1,2,2,2,2,2,2,2,6,6],
 [1,1,1,2,2,2,2,2,2,3,3,3,3],
 [1,1,1,2,2,2,2,2,2,3,3,3,3,5,5,6,6,7,7],
 [1,1,1,2,2,2,2,2,2,3,3,3,4,4,5,6,7],
 [1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,6,8,9,10,11,13,14,15,
   16,18,19,20,21,23,24],[1,1,1,2,2,2,2,2,2,3,3,4],
 [1,1,1,2,2,2,2,2,2,3,3,4,4],
 [1,1,1,2,2,2,2,2,2,3,3,4,4,4,5],
 [1,1,1,2,2,2,2,2,2,3,3,4,4,4,6,6],
 [1,1,1,2,2,2,2,2,2,3,3,4,5,5,6],
 [1,1,1,2,2,2,2,2,2,3,3,4,5,7,7,9],
 [1,1,1,2,2,2,2,2,2,3,3,4,6,6,7],
 [1,1,1,2,2,2,2,2,2,3,3,5,6,7,7,8],
 [1,1,1,2,2,2,2,2,2,3,3,5,6,7,7,8,10,10,11],
 [1,1,1,2,2,2,2,2,2,3,3,6],
 [1,1,1,2,2,2,2,2,2,3,3,6,6,6,7,7,7,9,10],
 [1,1,1,2,2,2,2,2,2,3,3,6,7,7,8,9],
 [1,1,1,2,2,2,2,2,2,3,4,4,4,4,5,6,6,6,6,8,8,8,8,10,
   10,10,10],[1,1,1,2,2,2,2,2,2,3,4,4,4,4,5,6,6,7,9 
  ],[1,1,1,2,2,2,2,2,2,3,4,4,4,5,5],
 [1,1,1,2,2,2,2,2,2,3,4,5,6,6,7,7,8,9,10],
 [1,1,1,2,2,2,2,2,2,3,4,5,6,7,8,9],
 [1,1,1,2,2,2,2,2,2,3,4,6,6,6,9,10],
 [1,1,1,2,2,2,2,2,2,4,4,4,4,4,4,6,6],
 [1,1,1,2,2,2,2,2,2,4,4,4,4,4,4,6,6,6,6,8,8,8,8,10,
   10,10,10],[1,1,1,2,2,2,2,2,2,4,4,6],
 [1,1,1,2,2,2,2,2,2,4,6],[1,1,1,2,2,2,2,2,2,5,5],
 [1,1,1,2,2,2,2,2,3,3],
 [1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,5,7],
 [1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,5,5,6,8],
 [1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,5,5,6,7],
 [1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,5,6,7,7],
 [1,1,1,2,2,2,2,2,3,3,3,3,4,5,5,6,6,6,6],
 [1,1,1,2,2,2,2,2,3,3,3,3,8,8,8,10,10,12,12,12,12,14,
   14,14,14,16,16],
 [1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,5,5],
 [1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,5,5,5,6],
 [1,1,1,2,2,2,2,2,3,3,4],
 [1,1,1,2,2,2,2,2,3,3,4,4,4,4,4,6,6,6,6,8,8,8,8,10,
   10,10,10],[1,1,1,2,2,2,2,2,3,3,4,4,4,4,4,6,6,6,8 
  ],[1,1,1,2,2,2,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,
   10,10,11,11,12,12,13,13],
 [1,1,1,2,2,2,2,2,3,3,4,5,5,7,7,9,9,10,10,11,11,12,
   12,14,14],
 [1,1,1,2,2,2,2,2,3,3,4,6,6,6,6,6,7,7,7,7,7,7,8,8],
 [1,1,1,2,2,2,2,2,3,3,4,6,6,10],
 [1,1,1,2,2,2,2,2,3,3,5,5,6,6,7,7,8,8,9,9,10,10,11,
   11,12,12],[1,1,1,2,2,2,2,2,3,4,5],
 [1,1,1,2,2,2,2,2,3,4,5,5],
 [1,1,1,2,2,2,2,2,3,4,5,5,5,6,6,6,6,7,7,8,8,8,8,10],
 [1,1,1,2,2,2,2,2,3,4,5,6],[1,1,1,2,2,2,2,2,3,5],
 [1,1,1,2,2,2,2,2,3,5,5,6,7,7,7,8,8,9,9,9,9,10,10,
   10,11,11,11,11,11,12,12,12,12],
 [1,1,1,2,2,2,2,2,3,5,9],[1,1,1,2,2,2,2,2,4,4,4,4],
 [1,1,1,2,2,2,2,2,4,4,4,5],[1,1,1,2,2,2,2,2,4,4,6],
 [1,1,1,2,2,2,2,2,4,4,9],[1,1,1,2,2,2,2,2,4,5,5],
 [1,1,1,2,2,2,2,2,4,7,9],[1,1,1,2,2,2,2,2,5,6,7],
 [1,1,1,2,2,2,2,2,5,7],[1,1,1,2,2,2,2,2,6,6],
 [1,1,1,2,2,2,2,3,3,3],
 [1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,5,5,5,9],
 [1,1,1,2,2,2,2,3,3,3,3,4],
 [1,1,1,2,2,2,2,3,3,3,3,4,5,6,6,7,7,8,9,9,9,10,11,12 
  ],[1,1,1,2,2,2,2,3,3,3,3,4,5,7,8],
 [1,1,1,2,2,2,2,3,3,3,3,4,6,7,8,12,13],
 [1,1,1,2,2,2,2,3,3,3,3,5,5,5,5,7,7,7,7,9,9,9,9,11,
   11,11,11],
 [1,1,1,2,2,2,2,3,3,3,3,5,5,7,7,8,8,10,10,11,11,13,
   13,14,14,16,16,17,17],
 [1,1,1,2,2,2,2,3,3,3,3,5,6,6,12],
 [1,1,1,2,2,2,2,3,3,3,3,5,6,8,8,9,10],
 [1,1,1,2,2,2,2,3,3,3,3,5,7,7,12],
 [1,1,1,2,2,2,2,3,3,3,3,6,6,6,11],
 [1,1,1,2,2,2,2,3,3,3,3,8,9,10],
 [1,1,1,2,2,2,2,3,3,3,4,4],
 [1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,5,5,5,7],
 [1,1,1,2,2,2,2,3,3,3,4,4,5],
 [1,1,1,2,2,2,2,3,3,3,4,4,5,5,6,6,7,8],
 [1,1,1,2,2,2,2,3,3,3,4,4,8,8,9,11,11],
 [1,1,1,2,2,2,2,3,3,3,4,5,5,5,6,6,6,7],
 [1,1,1,2,2,2,2,3,3,3,4,5,6,6,7,8],
 [1,1,1,2,2,2,2,3,3,3,4,5,6,6,7,12,13],
 [1,1,1,2,2,2,2,3,3,3,4,7,8,9],
 [1,1,1,2,2,2,2,3,3,3,4,8,9,9],
 [1,1,1,2,2,2,2,3,3,3,5,7,8,8],
 [1,1,1,2,2,2,2,3,3,3,5,14,14,15],
 [1,1,1,2,2,2,2,3,3,3,6,6,7,13],
 [1,1,1,2,2,2,2,3,3,4],[1,1,1,2,2,2,2,3,3,4,4],
 [1,1,1,2,2,2,2,3,3,4,4,4],
 [1,1,1,2,2,2,2,3,3,4,4,4,5,5,5,6,6,6,6,6,7,7,7,8,
   8,9],[1,1,1,2,2,2,2,3,3,4,4,5],
 [1,1,1,2,2,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,
   11,11,12,12],[1,1,1,2,2,2,2,3,3,4,4,5,6],
 [1,1,1,2,2,2,2,3,3,4,4,6,7,7],
 [1,1,1,2,2,2,2,3,3,4,4,7,8,8],
 [1,1,1,2,2,2,2,3,3,4,6],
 [1,1,1,2,2,2,2,3,3,4,6,6,12],
 [1,1,1,2,2,2,2,3,3,4,8],[1,1,1,2,2,2,2,3,3,5,5],
 [1,1,1,2,2,2,2,3,3,5,5,5],
 [1,1,1,2,2,2,2,3,3,5,5,5,5,6,6,6,6,6,6,6,6],
 [1,1,1,2,2,2,2,3,3,5,5,5,6],
 [1,1,1,2,2,2,2,3,3,5,5,6,6,6,7],
 [1,1,1,2,2,2,2,3,3,5,5,8],
 [1,1,1,2,2,2,2,3,3,5,6,6,7,7,8],
 [1,1,1,2,2,2,2,3,3,5,6,6,7,11],
 [1,1,1,2,2,2,2,3,3,5,6,8,8,10],
 [1,1,1,2,2,2,2,3,3,5,7,8,8,9],
 [1,1,1,2,2,2,2,3,3,5,7,13],[1,1,1,2,2,2,2,3,3,6,8]
  ,[1,1,1,2,2,2,2,3,3,6,8,8,8,11],
 [1,1,1,2,2,2,2,3,3,7,7,7,8,10],
 [1,1,1,2,2,2,2,3,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,9],
 [1,1,1,2,2,2,2,3,4,4,4,5],
 [1,1,1,2,2,2,2,3,4,4,4,5,5],
 [1,1,1,2,2,2,2,3,4,4,4,7],
 [1,1,1,2,2,2,2,3,4,5,5,5,6,6,7],
 [1,1,1,2,2,2,2,3,4,5,6,6],
 [1,1,1,2,2,2,2,3,4,5,6,8,8,9],
 [1,1,1,2,2,2,2,3,4,5,7,7,7,10],
 [1,1,1,2,2,2,2,3,4,5,8],[1,1,1,2,2,2,2,3,4,6],
 [1,1,1,2,2,2,2,3,4,6,6,6,7,9],
 [1,1,1,2,2,2,2,3,4,6,7],[1,1,1,2,2,2,2,3,4,6,8],
 [1,1,1,2,2,2,2,3,4,7],[1,1,1,2,2,2,2,3,4,7,8],
 [1,1,1,2,2,2,2,3,5,5,5,6,6,7],
 [1,1,1,2,2,2,2,3,5,6],
 [1,1,1,2,2,2,2,3,5,6,8,8,8,9],
 [1,1,1,2,2,2,2,3,5,7,7,7,8,8],
 [1,1,1,2,2,2,2,4,4,4,4],[1,1,1,2,2,2,2,4,4,4,6,6],
 [1,1,1,2,2,2,2,4,4,5],[1,1,1,2,2,2,2,4,4,6],
 [1,1,1,2,2,2,2,4,4,8,11,13,14],
 [1,1,1,2,2,2,2,4,5,5],
 [1,1,1,2,2,2,2,4,5,5,5,6,6,6],
 [1,1,1,2,2,2,2,4,5,5,7,7,7,8],
 [1,1,1,2,2,2,2,4,5,6,6],
 [1,1,1,2,2,2,2,4,5,6,6,6,7,7],
 [1,1,1,2,2,2,2,4,5,6,10],
 [1,1,1,2,2,2,2,4,5,10,14,18,21,22],
 [1,1,1,2,2,2,2,4,5,13,15,16],
 [1,1,1,2,2,2,2,5,5,6,8,9,9],
 [1,1,1,2,2,2,2,5,6,6,8],[1,1,1,2,2,2,2,5,6,17,18],
 [1,1,1,2,2,2,2,9,12],[1,1,1,2,2,2,2,10,18,21],
 [1,1,1,2,2,2,3,3],
 [1,1,1,2,2,2,3,3,3,3,3,4,4,5,5,5,6,6,6],
 [1,1,1,2,2,2,3,3,3,3,3,6],
 [1,1,1,2,2,2,3,3,3,3,4,4,4,4,4,6],
 [1,1,1,2,2,2,3,3,3,3,4,4,4,4,5,5],
 [1,1,1,2,2,2,3,3,3,3,4,4,4,4,6,6],
 [1,1,1,2,2,2,3,3,3,3,4,4,5,6,7],
 [1,1,1,2,2,2,3,3,3,3,4,4,6,6,6],
 [1,1,1,2,2,2,3,3,3,3,4,5],
 [1,1,1,2,2,2,3,3,3,4,4,4,4,4,5,5,5,5,6,7,7,7,8,8],
 [1,1,1,2,2,2,3,3,3,4,4,4,4,4,5,5,5,7,7,8,9,10],
 [1,1,1,2,2,2,3,3,3,4,4,4,4,5,5],
 [1,1,1,2,2,2,3,3,3,4,4,4,4,5,5,6,6,6,6],
 [1,1,1,2,2,2,3,3,3,4,4,4,4,6,8,11,13],
 [1,1,1,2,2,2,3,3,3,4,4,4,4,7,7,10,13],
 [1,1,1,2,2,2,3,3,3,4,4,4,5,5,6,7],
 [1,1,1,2,2,2,3,3,3,4,4,4,5,5,7],
 [1,1,1,2,2,2,3,3,3,4,4,4,7,7,7,8,11],
 [1,1,1,2,2,2,3,3,3,4,4,5,7,7,7,7,10],
 [1,1,1,2,2,2,3,3,3,4,5,5,5,5,6,7,8,8,9,10,11,11,12,
   13,14,14,15,16,17],[1,1,1,2,2,2,3,3,3,4,5,5,5,7],
 [1,1,1,2,2,2,3,3,3,4,5,5,6,6,7,8,10],
 [1,1,1,2,2,2,3,3,3,4,8],
 [1,1,1,2,2,2,3,3,3,5,5,6,6,6,7,8],
 [1,1,1,2,2,2,3,3,3,5,5,6,6,7,8,8],
 [1,1,1,2,2,2,3,3,4,4],[1,1,1,2,2,2,3,3,4,4,4],
 [1,1,1,2,2,2,3,3,4,4,4,4,4,4,5,6,7,7,8],
 [1,1,1,2,2,2,3,3,4,4,4,4,4,5,7,8],
 [1,1,1,2,2,2,3,3,4,4,4,4,5,5,6],
 [1,1,1,2,2,2,3,3,4,4,4,4,5,6,7],
 [1,1,1,2,2,2,3,3,4,4,4,5,5,5,6],
 [1,1,1,2,2,2,3,3,4,4,5,5,6,6,6,10,11],
 [1,1,1,2,2,2,3,3,4,4,5,5,6,6,7,10,10],
 [1,1,1,2,2,2,3,3,4,4,6],[1,1,1,2,2,2,3,3,4,6],
 [1,1,1,2,2,2,3,3,4,6,6],[1,1,1,2,2,2,3,4,4],
 [1,1,1,2,2,2,3,4,4,4],
 [1,1,1,2,2,2,3,4,4,4,4,4,4,4,5,5,5,7,7,8,8,10,10,
   11,11,13,13,14,14,17],
 [1,1,1,2,2,2,3,4,4,4,4,5,7,7,8,8],
 [1,1,1,2,2,2,3,4,4,4,5],[1,1,1,2,2,2,3,4,4,5],
 [1,1,1,2,2,2,3,4,4,5,5],[1,1,1,2,2,2,3,4,4,5,6],
 [1,1,1,2,2,2,3,4,4,5,6,12,14],
 [1,1,1,2,2,2,3,4,6,7,7],[1,1,1,2,2,2,3,4,7,15],
 [1,1,1,2,2,2,3,5,6],[1,1,1,2,2,2,3,5,11,11],
 [1,1,1,2,2,2,3,8,8],[1,1,1,2,2,2,3,8,10,11],
 [1,1,1,2,2,2,4,4,4,4],[1,1,1,2,2,2,4,4,5,6,7,10],
 [1,1,1,2,2,2,4,5,5,6,8,8],
 [1,1,1,2,2,2,4,5,8,9,10,14,16],
 [1,1,1,2,2,2,4,6,6,10],[1,1,1,2,2,2,4,6,7,9,11],
 [1,1,1,2,2,2,4,9,9,10,13,14,14],
 [1,1,1,2,2,2,5,6,8,8],[1,1,1,2,2,2,6,10,10],
 [1,1,1,2,2,3,3],[1,1,1,2,2,3,3,3],
 [1,1,1,2,2,3,3,3,3,3,3,4,4],
 [1,1,1,2,2,3,3,3,3,3,3,4,4,4,4,4,4],
 [1,1,1,2,2,3,3,3,3,3,4,4,9,10,16,17,23,24,30,31],
 [1,1,1,2,2,3,3,3,3,4],[1,1,1,2,2,3,3,3,3,4,4],
 [1,1,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4],
 [1,1,1,2,2,3,3,3,3,4,4,4,4,5,8],
 [1,1,1,2,2,3,3,3,3,4,4,5,5,6,7],
 [1,1,1,2,2,3,3,3,3,4,5,5],
 [1,1,1,2,2,3,3,3,3,4,5,5,5,7],
 [1,1,1,2,2,3,3,3,3,4,7,7,8,8,10,10,11,11,13,13,14,14,
   16,16,17,17],[1,1,1,2,2,3,3,3,3,5],
 [1,1,1,2,2,3,3,3,3,5,6,6,9],[1,1,1,2,2,3,3,3,4],
 [1,1,1,2,2,3,3,3,4,4,4],
 [1,1,1,2,2,3,3,3,4,4,4,4,4,5,7],
 [1,1,1,2,2,3,3,3,4,4,4,8,9,9,9,10,10],
 [1,1,1,2,2,3,3,3,4,4,5,5,5,5,5,6,8,8,8,8,8,9,11,12,
   14,15],[1,1,1,2,2,3,3,3,4,4,5,6],
 [1,1,1,2,2,3,3,3,4,4,6,7,7,8],
 [1,1,1,2,2,3,3,3,4,5],[1,1,1,2,2,3,3,3,4,5,5],
 [1,1,1,2,2,3,3,3,4,5,5,7,7,8],
 [1,1,1,2,2,3,3,3,4,5,5,7,8,8,8,8,9,9,11,11,12,12,14,
   14,15,15],[1,1,1,2,2,3,3,3,4,5,6,6,8],
 [1,1,1,2,2,3,3,3,4,5,9,10,13,19],
 [1,1,1,2,2,3,3,3,4,5,10],
 [1,1,1,2,2,3,3,3,4,5,10,12,13,16],
 [1,1,1,2,2,3,3,3,4,6,7],
 [1,1,1,2,2,3,3,3,4,6,8,9,11,12,14,15,17,20],
 [1,1,1,2,2,3,3,3,4,7,8],[1,1,1,2,2,3,3,3,4,7,10],
 [1,1,1,2,2,3,3,3,4,8,11,16,17,18],
 [1,1,1,2,2,3,3,3,5],
 [1,1,1,2,2,3,3,3,5,6,7,9,10,12,13,15,16,19],
 [1,1,1,2,2,3,3,3,5,6,7,9,12,13,14,15,27,28,30,31,34,
   38,39,42,50],
 [1,1,1,2,2,3,3,3,5,6,7,9,12,15,16,17,19,20,22,23,24,
   25,26,27,28,31,32,33,36,41],
 [1,1,1,2,2,3,3,3,5,6,9],
 [1,1,1,2,2,3,3,3,5,8,9,11,12,14,14,17,18,20,20,23,24,
   26,26,29,30,32,36],[1,1,1,2,2,3,3,3,6,7,7,9],
 [1,1,1,2,2,3,3,3,6,8,9,9,11,12,12,13,14,15,15,15,16,
   17,18,18,18,19,20,21,21,21,23,23,24,25,26,28,30],
 [1,1,1,2,2,3,3,3,6,9,10,11,12,14,16,16,17,19,21,21,22,
   24,26,26,27,31,32],[1,1,1,2,2,3,3,3,6,10],
 [1,1,1,2,2,3,3,4],[1,1,1,2,2,3,3,4,4],
 [1,1,1,2,2,3,3,4,4,4],[1,1,1,2,2,3,3,4,4,4,4],
 [1,1,1,2,2,3,3,4,4,4,4,5,5,9],
 [1,1,1,2,2,3,3,4,4,4,5],[1,1,1,2,2,3,3,4,4,4,5,6],
 [1,1,1,2,2,3,3,4,4,4,6],
 [1,1,1,2,2,3,3,4,4,4,6,6,8],[1,1,1,2,2,3,3,4,4,5],
 [1,1,1,2,2,3,3,4,4,5,5],
 [1,1,1,2,2,3,3,4,4,5,5,5,5,5,7,8],
 [1,1,1,2,2,3,3,4,4,5,5,5,5,7],
 [1,1,1,2,2,3,3,4,4,5,5,6,6,7],
 [1,1,1,2,2,3,3,4,4,5,5,8,8,8],
 [1,1,1,2,2,3,3,4,4,5,6],
 [1,1,1,2,2,3,3,4,4,5,7,7,13],
 [1,1,1,2,2,3,3,4,4,5,8,9,10],
 [1,1,1,2,2,3,3,4,4,5,8,10,11,16],
 [1,1,1,2,2,3,3,4,4,5,9,9,15,17],
 [1,1,1,2,2,3,3,4,4,5,9,10,12,14],
 [1,1,1,2,2,3,3,4,4,5,10],[1,1,1,2,2,3,3,4,4,6],
 [1,1,1,2,2,3,3,4,4,6,7],[1,1,1,2,2,3,3,4,4,6,8,9],
 [1,1,1,2,2,3,3,4,4,6,10],[1,1,1,2,2,3,3,4,4,8,9],
 [1,1,1,2,2,3,3,4,5],[1,1,1,2,2,3,3,4,5,5],
 [1,1,1,2,2,3,3,4,5,5,5],[1,1,1,2,2,3,3,4,5,5,6],
 [1,1,1,2,2,3,3,4,5,5,6,6],
 [1,1,1,2,2,3,3,4,5,5,6,6,6],
 [1,1,1,2,2,3,3,4,5,5,6,7,8,11,13],
 [1,1,1,2,2,3,3,4,5,6],[1,1,1,2,2,3,3,4,5,6,6],
 [1,1,1,2,2,3,3,4,5,6,6,6,7,13,13],
 [1,1,1,2,2,3,3,4,5,6,7],[1,1,1,2,2,3,3,4,5,6,8],
 [1,1,1,2,2,3,3,4,5,6,9,11,13,15,17,19,21,23,27],
 [1,1,1,2,2,3,3,4,5,7,7,9,10,10,11,11,12],
 [1,1,1,2,2,3,3,4,5,7,8],[1,1,1,2,2,3,3,4,5,8],
 [1,1,1,2,2,3,3,4,5,8,9,9,11,13],
 [1,1,1,2,2,3,3,4,6],[1,1,1,2,2,3,3,4,6,6,7],
 [1,1,1,2,2,3,3,4,6,6,8],[1,1,1,2,2,3,3,4,6,7],
 [1,1,1,2,2,3,3,4,6,7,8],
 [1,1,1,2,2,3,3,4,6,7,8,8,9,10,10,11,11],
 [1,1,1,2,2,3,3,4,6,7,12,16,17,17,18,24,28,29],
 [1,1,1,2,2,3,3,4,6,9],[1,1,1,2,2,3,3,4,7,9,10],
 [1,1,1,2,2,3,3,4,7,10],[1,1,1,2,2,3,3,4,8,9],
 [1,1,1,2,2,3,3,4,8,10,10,11,12,13],
 [1,1,1,2,2,3,3,4,9,9],
 [1,1,1,2,2,3,3,4,9,9,11,17,18,25,26,33,34,41,42,50],
 [1,1,1,2,2,3,3,4,9,10],[1,1,1,2,2,3,3,4,9,10,11],
 [1,1,1,2,2,3,3,4,9,10,11,13,14,16],
 [1,1,1,2,2,3,3,4,11,11],[1,1,1,2,2,3,3,5,5],
 [1,1,1,2,2,3,3,5,5,5,5,5,6,8],
 [1,1,1,2,2,3,3,5,5,6,6],[1,1,1,2,2,3,3,5,5,6,7],
 [1,1,1,2,2,3,3,5,6,6,7],[1,1,1,2,2,3,3,5,6,11,12],
 [1,1,1,2,2,3,3,5,8],[1,1,1,2,2,3,3,5,8,8],
 [1,1,1,2,2,3,3,6,6,7],[1,1,1,2,2,3,3,6,7],
 [1,1,1,2,2,3,3,6,7,7,9,9],[1,1,1,2,2,3,3,6,11,12],
 [1,1,1,2,2,3,3,8,10,11,12],
 [1,1,1,2,2,3,3,10,12,13,14,17,20,22,22,24,27,29,29,31,
   34,36,36,38,41,43,43,50],
 [1,1,1,2,2,3,3,10,13,14,15,17,19,21,21,24,26,28,28,31,
   33,35,35,38,40,42,42,49],
 [1,1,1,2,2,3,3,12,12,13,13,14,15,15,15],
 [1,1,1,2,2,3,4],[1,1,1,2,2,3,4,4],
 [1,1,1,2,2,3,4,4,4,4,4,5,5,5,6,7],
 [1,1,1,2,2,3,4,4,4,4,5,5,5,5,6,7,7],
 [1,1,1,2,2,3,4,4,4,5],
 [1,1,1,2,2,3,4,4,4,5,5,5,5,8],
 [1,1,1,2,2,3,4,4,4,5,5,5,6,6,6,8],
 [1,1,1,2,2,3,4,4,4,5,5,5,6,7],
 [1,1,1,2,2,3,4,4,4,5,6,7],[1,1,1,2,2,3,4,4,5],
 [1,1,1,2,2,3,4,4,5,5],[1,1,1,2,2,3,4,4,5,5,8],
 [1,1,1,2,2,3,4,4,5,6,7,10,12,12],
 [1,1,1,2,2,3,4,4,5,6,8],[1,1,1,2,2,3,4,4,5,9,10],
 [1,1,1,2,2,3,4,4,6,6,7,9,11,13],
 [1,1,1,2,2,3,4,4,6,7],[1,1,1,2,2,3,4,4,6,7,7],
 [1,1,1,2,2,3,4,4,6,7,7,11,12,12,24,25,25,32],
 [1,1,1,2,2,3,4,4,6,7,7,14,15,15,19,20,20,22,24],
 [1,1,1,2,2,3,4,4,6,7,8,9],[1,1,1,2,2,3,4,4,6,8,9],
 [1,1,1,2,2,3,4,4,6,8,9,9,10,11],
 [1,1,1,2,2,3,4,4,6,10,11],
 [1,1,1,2,2,3,4,4,6,10,11,12,12,15],
 [1,1,1,2,2,3,4,4,7],
 [1,1,1,2,2,3,4,4,7,8,9,10,11,18],
 [1,1,1,2,2,3,4,4,8,8],[1,1,1,2,2,3,4,4,8,8,11],
 [1,1,1,2,2,3,4,4,8,9,9,11,12,12,13,14,14,14,15,15,16,
   16,17],[1,1,1,2,2,3,4,4,8,10,11,11,11,15],
 [1,1,1,2,2,3,4,5,5,5,5,5,6,6,6,6,8,8,9,9,9,9],
 [1,1,1,2,2,3,4,5,5,6,6],
 [1,1,1,2,2,3,4,5,5,6,7,7,7,8,9],
 [1,1,1,2,2,3,4,5,5,6,9,11,13,15,17,19,21,23,27],
 [1,1,1,2,2,3,4,5,5,6,9,13],[1,1,1,2,2,3,4,5,5,7,8]
  ,[1,1,1,2,2,3,4,5,5,8],
 [1,1,1,2,2,3,4,5,5,9,9,21,22],
 [1,1,1,2,2,3,4,5,5,9,10],
 [1,1,1,2,2,3,4,5,5,9,12,13,30,31],
 [1,1,1,2,2,3,4,5,6],
 [1,1,1,2,2,3,4,5,6,6,6,7,8,8,8],
 [1,1,1,2,2,3,4,5,6,6,7,7,10],
 [1,1,1,2,2,3,4,5,6,6,7,9,10,12],
 [1,1,1,2,2,3,4,5,6,7],[1,1,1,2,2,3,4,5,6,7,7],
 [1,1,1,2,2,3,4,5,6,7,9,10,11,18,19],
 [1,1,1,2,2,3,4,5,6,8,9],[1,1,1,2,2,3,4,5,6,9],
 [1,1,1,2,2,3,4,5,6,9,10,13],[1,1,1,2,2,3,4,5,7],
 [1,1,1,2,2,3,4,5,7,9],[1,1,1,2,2,3,4,5,7,11,13,14],
 [1,1,1,2,2,3,4,5,7,13,17,21,22],
 [1,1,1,2,2,3,4,5,8,9],
 [1,1,1,2,2,3,4,5,8,11,14,16,22,24,29,31,36,38,43,45],
 [1,1,1,2,2,3,4,5,9,10],[1,1,1,2,2,3,4,6],
 [1,1,1,2,2,3,4,6,6],[1,1,1,2,2,3,4,6,6,6],
 [1,1,1,2,2,3,4,6,6,7,8,8,10,11],
 [1,1,1,2,2,3,4,6,7,8,8,9,10,16],
 [1,1,1,2,2,3,4,6,8,9],[1,1,1,2,2,3,4,6,10],
 [1,1,1,2,2,3,4,6,11,11],[1,1,1,2,2,3,4,7,7,11],
 [1,1,1,2,2,3,4,7,8,9,10],[1,1,1,2,2,3,4,7,9],
 [1,1,1,2,2,3,4,7,9,10,11],[1,1,1,2,2,3,4,7,10],
 [1,1,1,2,2,3,4,8,8,8,8,8,9,10],
 [1,1,1,2,2,3,5,5,5,6,6,8],[1,1,1,2,2,3,5,5,5,6,7],
 [1,1,1,2,2,3,5,5,5,7,7],[1,1,1,2,2,3,5,5,6,6],
 [1,1,1,2,2,3,5,5,6,8],[1,1,1,2,2,3,5,5,6,8,11],
 [1,1,1,2,2,3,5,5,8,9,10],[1,1,1,2,2,3,5,6],
 [1,1,1,2,2,3,5,6,6,7],[1,1,1,2,2,3,5,6,6,7,11,12],
 [1,1,1,2,2,3,5,6,6,8,8,9,10,12,12],
 [1,1,1,2,2,3,5,6,7,7,7,7,11,12],
 [1,1,1,2,2,3,5,6,7,7,10,11],
 [1,1,1,2,2,3,5,6,7,9,9,11,11],
 [1,1,1,2,2,3,5,6,8,9,10],[1,1,1,2,2,3,5,6,9],
 [1,1,1,2,2,3,5,7,8,8,9,9,9,10],
 [1,1,1,2,2,3,5,7,8,9],[1,1,1,2,2,3,5,7,8,10,13,16],
 [1,1,1,2,2,3,5,7,8,10,15,18],
 [1,1,1,2,2,3,5,7,8,11,12,15],
 [1,1,1,2,2,3,5,7,10,10,11],[1,1,1,2,2,3,5,7,10,11],
 [1,1,1,2,2,3,5,7,10,11,12,15],
 [1,1,1,2,2,3,5,8,11,12,13,14,17,19,19,21,24,26,26,28,
   31,33,33,35,38,40,40,47],
 [1,1,1,2,2,3,5,9,10,10,11,11,12,13],
 [1,1,1,2,2,3,6,6,7,7,12],
 [1,1,1,2,2,3,6,6,7,12,12,13,19],
 [1,1,1,2,2,3,6,6,9,13,23,27],
 [1,1,1,2,2,3,6,7,8,9,10,16],[1,1,1,2,2,3,6,7,8,10],
 [1,1,1,2,2,4,4,4,4,4,4,5,5,7],
 [1,1,1,2,2,4,4,4,5,5,6],[1,1,1,2,2,4,4,4,6,6,7,7],
 [1,1,1,2,2,4,4,5,5,5,6],[1,1,1,2,2,4,4,5,5,7,8],
 [1,1,1,2,2,4,4,5,6,7,8],[1,1,1,2,2,4,4,6,6,8],
 [1,1,1,2,2,4,4,6,7,8,10,11,12],[1,1,1,2,2,4,4,7,8],
 [1,1,1,2,2,4,4,7,13,14,15,16,18],
 [1,1,1,2,2,4,5,5,6],[1,1,1,2,2,4,5,5,6,7],
 [1,1,1,2,2,4,5,5,6,7,7,7,8,8,8,9,9,9,9,10,10,10,10,
   10,10,11,11,11,11,11,12],
 [1,1,1,2,2,4,5,5,6,7,7,7,8,8,8,9,9,9,9,10,10,10,10,
   10,11,11,11,11,11,12],[1,1,1,2,2,4,5,5,6,7,12],
 [1,1,1,2,2,4,5,5,8,11,19,21],[1,1,1,2,2,4,5,6,6,6],
 [1,1,1,2,2,4,5,6,6,7,7,8,9,10],
 [1,1,1,2,2,4,5,6,7,7,8],[1,1,1,2,2,4,5,6,7,7,9,12]
  ,[1,1,1,2,2,4,5,9,10],[1,1,1,2,2,4,5,11,12],
 [1,1,1,2,2,4,6,6,12],[1,1,1,2,2,4,6,6,18,18,29,30],
 [1,1,1,2,2,4,8,8,8],[1,1,1,2,2,5,5,5,6],
 [1,1,1,2,2,5,5,5,6,7,10,11],[1,1,1,2,2,6,6,7,10,11]
  ,[1,1,1,2,2,6,7],[1,1,1,2,2,6,10,11],
 [1,1,1,2,3],[1,1,1,2,3,3,3,3,3,5,5],
 [1,1,1,2,3,3,3,3,4,4,5,5],
 [1,1,1,2,3,3,3,3,4,4,5,5,10],
 [1,1,1,2,3,3,3,3,4,4,6,6,7,7,9,9,10,10,12,12,13,13,
   15,15,16,16],[1,1,1,2,3,3,3,3,4,4,9,9],
 [1,1,1,2,3,3,3,3,5,5,6,6,6],
 [1,1,1,2,3,3,3,4,4,4,5,6,6,7,8,9,9,10,11,12,12,13,
   14,15,15,16],[1,1,1,2,3,3,3,4,4,5,5,6,7,10,14,15],
 [1,1,1,2,3,3,3,4,4,5,5,6,7,11,13,14],
 [1,1,1,2,3,3,3,4,4,5,6,6,6,7,7,7,7,8,9,11,12,14,15],
 [1,1,1,2,3,3,3,4,4,5,6,6,6,7,7,7,8,9,9,9,10,10],
 [1,1,1,2,3,3,3,4,4,5,8],
 [1,1,1,2,3,3,3,4,4,6,6,7,7,7,8,10,11],
 [1,1,1,2,3,3,3,4,5,5,8],
 [1,1,1,2,3,3,3,4,5,5,9,9,13,13,13,17,17,21,21,21,29,
   37,45,53],
 [1,1,1,2,3,3,3,4,5,6,6,7,8,9,9,10,11,12,12,13,14,15,
   15,16,17,19,20],[1,1,1,2,3,3,3,4,5,6,7,8,8,10,15],
 [1,1,1,2,3,3,3,4,5,9],[1,1,1,2,3,3,3,4,6,6],
 [1,1,1,2,3,3,3,4,6,6,7],[1,1,1,2,3,3,3,5,5,8],
 [1,1,1,2,3,3,3,6],[1,1,1,2,3,3,4,4],
 [1,1,1,2,3,3,4,4,4,5,5,5,6,8,9],
 [1,1,1,2,3,3,4,4,4,5,5,6,6,7,8],
 [1,1,1,2,3,3,4,4,4,5,7],[1,1,1,2,3,3,4,4,5,5,7],
 [1,1,1,2,3,3,4,4,5,5,12],[1,1,1,2,3,3,4,4,5,6,6],
 [1,1,1,2,3,3,4,4,5,8],[1,1,1,2,3,3,4,4,8,10],
 [1,1,1,2,3,3,4,5,5,5],[1,1,1,2,3,3,4,5,5,6],
 [1,1,1,2,3,3,4,5,5,6,7,8,10,10],
 [1,1,1,2,3,3,4,5,5,6,7,14],[1,1,1,2,3,3,4,5,5,7,7]
  ,[1,1,1,2,3,3,4,5,6,9,10],[1,1,1,2,3,3,4,5,7,9],
 [1,1,1,2,3,3,4,6,7,7],[1,1,1,2,3,3,4,6,7,8],
 [1,1,1,2,3,3,4,7,7,7,7,8,8,11,11,11,11,11,11,11,11,
   12,12,12,12],[1,1,1,2,3,3,5,5,6,10,11,11,12,13],
 [1,1,1,2,3,3,5,5,7,7,9,9,11,11,13,13],
 [1,1,1,2,3,3,5,6],[1,1,1,2,3,3,5,6,6,7],
 [1,1,1,2,3,3,5,6,8,12,13,14,15,18,19],
 [1,1,1,2,3,3,5,7,7],[1,1,1,2,3,3,5,8,9],
 [1,1,1,2,3,3,5,9,9,10,10,11,13,13,14,14,18,18],
 [1,1,1,2,3,3,6,6,7,7],[1,1,1,2,3,3,6,6,7,10,11,12],
 [1,1,1,2,3,3,6,7,7,8],[1,1,1,2,3,3,8,9,10,11],
 [1,1,1,2,3,3,9],[1,1,1,2,3,4],
 [1,1,1,2,3,4,4,4,5,5,6,8,10,10],
 [1,1,1,2,3,4,4,4,6],
 [1,1,1,2,3,4,4,4,8,8,11,11,11,11],
 [1,1,1,2,3,4,4,4,10],[1,1,1,2,3,4,4,5],
 [1,1,1,2,3,4,4,5,5],
 [1,1,1,2,3,4,4,5,5,5,6,9,12,12],
 [1,1,1,2,3,4,4,5,5,6],[1,1,1,2,3,4,4,5,5,6,7],
 [1,1,1,2,3,4,4,5,7,7,8,8,9,14],
 [1,1,1,2,3,4,4,7,8],[1,1,1,2,3,4,5,5,6,6],
 [1,1,1,2,3,4,5,5,6,6,6,7,9],
 [1,1,1,2,3,4,5,6,6,6,7,7,8,11],
 [1,1,1,2,3,4,6,6,6,7,9,15],[1,1,1,2,3,4,6,6,7,7,8]
  ,[1,1,1,2,3,4,7,7,7,7,8,8,9,11],
 [1,1,1,2,3,5,5,5,5,6],[1,1,1,2,3,5,5,6,6],
 [1,1,1,2,3,5,5,6,6,7,8,10,15,20],
 [1,1,1,2,3,5,6,6,8,9],[1,1,1,2,3,5,6,7,7,8],
 [1,1,1,2,3,5,6,7,9,9,9,12,21],
 [1,1,1,2,3,5,7,8,11,14],[1,1,1,2,3,6,6],
 [1,1,1,2,3,6,8,11],[1,1,1,2,3,12],
 [1,1,1,2,4,4,4,4,5,5,7,7,7,7,7,7,7,7,8,8,8,8,10,10,
   10,10,10,10,10,10,10,10,10,10,10,10,10,10],
 [1,1,1,2,4,4,4,5,5,6],
 [1,1,1,2,4,4,4,5,5,6,7,8,8,8],
 [1,1,1,2,4,4,5,5,5,5,6,6],[1,1,1,2,4,4,5,5,7],
 [1,1,1,2,4,4,12],[1,1,1,2,4,5,5,5,6],
 [1,1,1,2,4,5,5,7,11,12,13,16],
 [1,1,1,2,4,5,6,6,6,6,7,8,8,11],[1,1,1,2,4,8,8],
 [1,1,1,2,4,16],[1,1,1,2,5,5,6,6,6,6,6,6,7,7],
 [1,1,1,2,5,5,6,6,7,7],[1,1,1,2,5,5,6,6,7,7,13,17],
 [1,1,1,2,5,6,6,7,9],[1,1,1,2,5,6,6,9],
 [1,1,1,2,6,6,6,12],[1,1,1,2,6,6,18],[1,1,1,2,6,9],
 [1,1,1,2,7],[1,1,1,2,8,8,10,10,12,12,14,14,16,16],
 [1,1,1,2,10],[1,1,1,3],[1,1,1,3,3],[1,1,1,3,3,3],
 [1,1,1,3,3,3,3,3,3,4,4,4,4,5,5,10],
 [1,1,1,3,3,3,3,4],[1,1,1,3,3,3,3,4,4,4,5],
 [1,1,1,3,3,3,3,4,4,5,5,5,5,7,7,7,7,7,7,9,9,9,9,10,
   10,11,11,11,11,13,13,16,16],
 [1,1,1,3,3,3,3,4,4,5,5,6,6,6,6,7,7,8,8,9,9,9,9,11,
   11,11,11,11,11,13,13,14,14],
 [1,1,1,3,3,3,3,4,4,8,10],
 [1,1,1,3,3,3,3,4,5,11,12,16,16,17],
 [1,1,1,3,3,3,3,4,5,11,12,20,21,28,29,36,37,44,45],
 [1,1,1,3,3,3,3,5,5,5,5,7,7,7,7,9,9,9,9,11,11,11,11],
 [1,1,1,3,3,3,3,5,5,7,7,9,9,11,11],
 [1,1,1,3,3,3,3,7,8,8,9,12,13],[1,1,1,3,3,3,4,4],
 [1,1,1,3,3,3,5,5,6,7],[1,1,1,3,3,3,5,5,6,8,9],
 [1,1,1,3,3,3,6,6,8,11,11],[1,1,1,3,3,3,8],
 [1,1,1,3,3,4],[1,1,1,3,3,4,4,4,4,4,5,6],
 [1,1,1,3,3,4,4,4,4,5,6],
 [1,1,1,3,3,4,4,4,5,5,6,10,10],
 [1,1,1,3,3,4,4,4,5,7,8],
 [1,1,1,3,3,4,4,4,5,10,11,16,16,18],
 [1,1,1,3,3,4,4,4,5,10,11,19,20,26,27,33,34,40,41],
 [1,1,1,3,3,4,4,4,5,10,13,17,18,24,25,31,32,38,39],
 [1,1,1,3,3,4,4,4,5,11,12,14,14,16],
 [1,1,1,3,3,4,4,4,6,7,8],
 [1,1,1,3,3,4,4,4,6,10,11,15,15,19,19,23,23,27,27],
 [1,1,1,3,3,4,4,4,11,11,12,12,13,14],
 [1,1,1,3,3,4,4,5,5,7,7,7,9,9,9,9,11,11],
 [1,1,1,3,3,4,4,5,5,7,7,9,9,10,11,11,12,12,18,20,20],
 [1,1,1,3,3,4,4,5,5,7,7,9,9,11,11],
 [1,1,1,3,3,4,4,5,5,7,7,9,9,11,11,12,12,13,13,27,27,
   28,28],
 [1,1,1,3,3,4,4,5,5,7,7,9,9,11,11,15,15,16,16,24,24,
   25,25,26,26,27,27,27,27,28,28],
 [1,1,1,3,3,4,4,5,5,7,8],[1,1,1,3,3,4,4,6,6],
 [1,1,1,3,3,4,4,6,6,6,6,8,8,9,9,10,11,11,11,11,12,12,
   13,13,14,14],
 [1,1,1,3,3,4,4,6,6,6,6,8,8,9,9,11,11,11,11,13,13,14,
   14],[1,1,1,3,3,4,4,6,6,7],[1,1,1,3,3,4,4,7,7,8]
  ,[1,1,1,3,3,4,4,7,7,12],
 [1,1,1,3,3,4,4,7,8,9,9,13,15,16],
 [1,1,1,3,3,4,4,10,10],[1,1,1,3,3,4,4,10,10,11],
 [1,1,1,3,3,4,4,13,17,17,19,21,21,25,25,27,27,29,29,31,
   31,32,36,36,37,38],
 [1,1,1,3,3,4,4,17,17,17,17,21,23,23,27,28,28,31,31],
 [1,1,1,3,3,4,5,5,6,6,7,7,9,9,11,11],
 [1,1,1,3,3,4,5,5,7,7,9,9,11,11],
 [1,1,1,3,3,4,5,5,7,7,9,9,11,11,11,11],
 [1,1,1,3,3,4,5,5,7,7,9,9,11,11,11,14,21,24],
 [1,1,1,3,3,4,5,6],[1,1,1,3,3,4,5,6,6,10],
 [1,1,1,3,3,4,5,6,8],[1,1,1,3,3,4,5,6,8,13],
 [1,1,1,3,3,4,5,9,9],[1,1,1,3,3,4,6,6,7,8,8],
 [1,1,1,3,3,4,6,6,8,8],[1,1,1,3,3,4,6,7,7,10,11],
 [1,1,1,3,3,4,6,7,8,8,9,9,10,11],
 [1,1,1,3,3,4,6,7,8,9,10,10,10,14,14,18,18,22,22],
 [1,1,1,3,3,4,6,13,15,17],[1,1,1,3,3,4,7],
 [1,1,1,3,3,4,7,7,7,7,16],
 [1,1,1,3,3,4,7,7,9,9,10,13],
 [1,1,1,3,3,4,7,8,9,12,12,13],[1,1,1,3,3,4,7,9],
 [1,1,1,3,3,4,8,9,9,10,10],[1,1,1,3,3,4,9,10],
 [1,1,1,3,3,4,11,13,13,14,14,17,17,18],
 [1,1,1,3,3,4,15,26,27,27,29,29],
 [1,1,1,3,3,5,5,5,5,7,7,9,9,11,11,15,15,16,16,23,23,
   24,24,25,25,26,26,26,26,27,27],
 [1,1,1,3,3,5,5,6,6,7,7,9,9,11,11],
 [1,1,1,3,3,5,5,6,10,10,10,11,11,12],
 [1,1,1,3,3,5,5,7,7,9,9,11,11],
 [1,1,1,3,3,5,5,8,8,10],[1,1,1,3,3,5,6],
 [1,1,1,3,3,5,6,7,7,8,10,17],
 [1,1,1,3,3,5,6,9,11,14,16,17,17,18],
 [1,1,1,3,3,6,6,8,8,10,10,11,11,11,11,13,13,15,15,16,
   16,17,17,18,18],
 [1,1,1,3,3,6,6,10,11,11,12,12,15,17,17,17,17,21,25,29],
 [1,1,1,3,3,8,8],[1,1,1,3,4],[1,1,1,3,4,4],
 [1,1,1,3,4,4,5,5],[1,1,1,3,4,4,6],
 [1,1,1,3,4,4,6,6],[1,1,1,3,4,4,6,7,8,9,10],
 [1,1,1,3,4,4,6,10,11],[1,1,1,3,4,4,12],
 [1,1,1,3,4,5],[1,1,1,3,4,5,5,6,8,11],
 [1,1,1,3,4,5,5,8,8,9],[1,1,1,3,4,6],
 [1,1,1,3,4,6,7,9,10,12,13,15,16,18,19],
 [1,1,1,3,4,6,8],[1,1,1,3,4,7,9,12],
 [1,1,1,3,4,7,10,10,17],[1,1,1,3,4,7,12],
 [1,1,1,3,4,8,13],[1,1,1,3,4,9],[1,1,1,3,4,10],
 [1,1,1,3,5,5,7,7,9,9,11,11,13,13,15],
 [1,1,1,3,5,5,7,11,11,13,21,21,23,47,47,49,63,63],
 [1,1,1,3,5,5,7,11,11,13,27,27,29,37,37,39,43,43,47,47],
 [1,1,1,3,5,5,7,15,15,17,21,21,23,25,25,27,27,27,29,31,
   31,31,31,33,33],[1,1,1,3,5,6],
 [1,1,1,3,5,6,6,6,8,12,16,17,26,27],
 [1,1,1,3,5,6,6,7,8,9,9],[1,1,1,3,5,7,7],
 [1,1,1,3,6],[1,1,1,3,6,6,7,9],
 [1,1,1,3,6,8,9,10,10,11,15,17],[1,1,1,3,7,7],
 [1,1,1,3,7,7,9,11,11,13,13,13,15,15,15,17,17,17,17,17,
   19,19,19,19,19,19,21,21,21,21,21,21,21,23,23],
 [1,1,1,3,7,7,9,11,11,13,13,13,15,15,15,17,17,17,17,17,
   19,19,19,19,19,19,21,21,21,21,21,21,23,23],
 [1,1,1,3,7,8,9,10,11,11,11],[1,1,1,3,7,9,20,21],
 [1,1,1,3,7,10],[1,1,1,3,8],[1,1,1,3,9],
 [1,1,1,3,12,12,14],[1,1,1,4],[1,1,1,4,4,4,4,5],
 [1,1,1,4,4,4,4,6,7,7,8,8,10,10,13,13,16,16],
 [1,1,1,4,4,4,4,7,7,7,7,10],[1,1,1,4,4,5,5,6],
 [1,1,1,4,4,5,6,7,7,7,8,13,13,14],
 [1,1,1,4,4,5,6,7,7,8,8,12,12,13],
 [1,1,1,4,4,6,6,8,8,10,10,12,12,14,14],
 [1,1,1,4,4,6,6,10,10,10,10,10,11,11],
 [1,1,1,4,4,6,6,10,12,12,12,12,18,18,19,19,19,19,20,20,
   20,20,20,20,20,20,25,25,30,30,30,30],
 [1,1,1,4,4,6,7],[1,1,1,4,4,6,7,7,8,8,8,8,8,10],
 [1,1,1,4,4,6,7,9,9,9,9,11,16,18,20,20,20,20,21,25,26,
   27,27,27,27,29,30,31],[1,1,1,4,4,6,9],
 [1,1,1,4,4,7,7],
 [1,1,1,4,4,7,7,10,10,13,13,16,16,19,19],
 [1,1,1,4,4,9],
 [1,1,1,4,4,11,14,14,16,16,21,21,21,24,24,26,26,26,26,41 
  ],[1,1,1,4,5],[1,1,1,4,5,5,5,5],
 [1,1,1,4,5,5,10],[1,1,1,4,5,6,6,7,9,9,10,10,10,18],
 [1,1,1,4,5,8,9,16],[1,1,1,4,6,6],
 [1,1,1,4,6,6,6,6,7,9,10,10,10,11],
 [1,1,1,4,6,6,7,8,10,10,11,11,14,19],[1,1,1,4,6,6,8],
 [1,1,1,4,6,6,9],
 [1,1,1,4,6,6,11,11,14,14,16,16,16,16,20,20,20,20,23,23,
   26,26,26,26,29,29,29,29,30,30,35,35,36,36,40,40,46,46,
   51,51],[1,1,1,4,6,7],[1,1,1,4,6,8,8,16],
 [1,1,1,4,7,7,8,8,9,9,9,9,14,16],[1,1,1,4,7,10],
 [1,1,1,4,7,10,13,16,19],[1,1,1,4,7,22],
 [1,1,1,4,8,19,26,30,33,37],
 [1,1,1,4,11,12,18,19,25,26,32,33,39,40,47],
 [1,1,1,4,11,15,18,19,22,22,23,25,26],
 [1,1,1,4,12,17,20,22,25,25,27,28,30],
 [1,1,1,4,12,17,22,28,28,33],[1,1,1,4,13,17],
 [1,1,1,4,13,18,33],
 [1,1,1,4,14,14,15,17,17,17,19,19,20,22,22,23],
 [1,1,1,4,15,20,23,23],[1,1,1,4,16,19],[1,1,1,5],
 [1,1,1,5,5],[1,1,1,5,5,5,9],
 [1,1,1,5,5,6,10,11,11,12,12,13,13,13,13,14,14,16,16,17,
   18,18,18,18,19,19,19,19,19,20,20,20,20,21,21,21,21,26]
  ,[1,1,1,5,5,9,9,13,13,17,17,21,21,25,25],
 [1,1,1,5,6,6,7,7,9,9,10,10,14,17],[1,1,1,5,7],
 [1,1,1,5,8],[1,1,1,5,11,17,23,29,35,41],[1,1,1,6],
 [1,1,1,6,6],[1,1,1,6,6,10,11,14,14,15],
 [1,1,1,6,6,14,14,17,17,20,20,22,22,23,23],
 [1,1,1,6,9,9],[1,1,1,6,11,11,16,16,16,16],
 [1,1,1,8,8,8,9,9],
 [1,1,1,8,8,11,11,14,14,17,17,20,20,23,23],
 [1,1,1,9,9,14,14,32,34],[1,1,1,9,9,14,19,29],
 [1,1,1,10],[1,1,1,13,13],[1,1,2],[1,1,2,2],
 [1,1,2,2,2],[1,1,2,2,2,2,2],[1,1,2,2,2,2,2,2,6],
 [1,1,2,2,2,2,3,3,4],[1,1,2,2,2,2,3,3,4,4],
 [1,1,2,2,2,2,3,3,4,4,4],[1,1,2,2,2,2,3,3,6],
 [1,1,2,2,2,2,3,4,5],[1,1,2,2,2,2,3,7],
 [1,1,2,2,2,3,3,4,4],
 [1,1,2,2,2,3,3,4,4,4,5,5,6,6,6,7,7,8,10,12,14],
 [1,1,2,2,2,3,3,4,4,4,5,5,6,6,6,7,7,9,9,10,10,11,11],
 [1,1,2,2,2,3,3,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10]
  ,[1,1,2,2,2,3,3,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,
   9,9],[1,1,2,2,2,3,3,6],[1,1,2,2,2,3,4,4,5],
 [1,1,2,2,2,4],[1,1,2,2,2,4,4],[1,1,2,2,2,4,4,4],
 [1,1,2,2,2,4,4,4,4],[1,1,2,2,2,4,4,6],
 [1,1,2,2,2,4,4,6,8],[1,1,2,2,2,4,4,8],
 [1,1,2,2,2,4,6],[1,1,2,2,2,5,7],[1,1,2,2,2,6,6],
 [1,1,2,2,3,3],
 [1,1,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,
   8,8],[1,1,2,2,3,3,4,4],[1,1,2,2,3,3,4,4,4],
 [1,1,2,2,3,3,4,5],[1,1,2,2,3,3,4,5,7],
 [1,1,2,2,3,3,4,6],[1,1,2,2,3,3,4,6,8],
 [1,1,2,2,3,3,4,8],
 [1,1,2,2,3,3,5,5,7,7,9,9,11,11,13,13],
 [1,1,2,2,3,3,5,6],[1,1,2,2,3,3,6],
 [1,1,2,2,3,3,8],[1,1,2,2,3,4],
 [1,1,2,2,3,4,4,4,6],[1,1,2,2,3,4,4,5],
 [1,1,2,2,3,4,4,5,5],[1,1,2,2,3,4,4,6],
 [1,1,2,2,3,4,4,6,7],[1,1,2,2,3,4,4,7],
 [1,1,2,2,3,4,5],[1,1,2,2,3,4,5,6],
 [1,1,2,2,3,5,6],[1,1,2,2,4,4,4,4,10],
 [1,1,2,2,4,4,4,5,5,7,7,7,8,8,10,10,10,13,16,19,22],
 [1,1,2,2,4,4,4,5,5,7,7,7,8,8,10,10,11,12,13,13,14,15,
   16,16],
 [1,1,2,2,4,4,4,5,5,7,7,8,8,8,9,10,10,10,10,11,12,13,
   13,14,15],[1,1,2,2,4,4,5,5],
 [1,1,2,2,4,4,5,5,5,6,7,7,7,7,8,8,8,9,10,10,10,10,11,
   12,13,13],[1,1,2,2,4,4,7,7,12,15,15,17,20,20,20,22]
  ,[1,1,2,2,4,4,7,9,9,10,12,12,12,13,14,14,15,15,15,
   15,16],[1,1,2,2,4,4,8],[1,1,2,2,4,5],
 [1,1,2,2,4,5,5],
 [1,1,2,2,4,5,5,6,7,7,7,8,8,8,9,9,9,9,10,10,10,10,10,
   10,11,11,11,11,11,12],
 [1,1,2,2,4,5,5,8,9,9,15,16,16,33,34,34,44,45],
 [1,1,2,2,4,5,5,8,9,9,19,20,20,26,27,27,30,31,33,34],
 [1,1,2,2,4,5,5,11,12,12,15,16,16,18,19,19,19,20,20,22,
   22,23,23,23,24],
 [1,1,2,2,4,5,7,8,10,11,13,14,16,17,19],
 [1,1,2,2,5,5],
 [1,1,2,2,5,6,6,8,9,9,9,10,10,11,12,12,12,12,13,13,13,
   13,13,14,14,15,15,15,15,15,16,16,16,17,18],
 [1,1,2,2,5,7,7],[1,1,2,2,6],[1,1,2,3],
 [1,1,2,3,3],[1,1,2,3,3,3,5,5,9],[1,1,2,3,3,3,7],
 [1,1,2,3,3,4],[1,1,2,3,3,4,4,4,8],
 [1,1,2,3,3,4,4,5,6,7,7,7,8,9,9,10,10,13,15,19,21],
 [1,1,2,3,3,4,4,5,6,7,7,7,8,9,10,10,11,11,12,12,14,14,
   15,15],
 [1,1,2,3,3,4,4,5,6,7,7,8,8,8,9,10,10,10,10,11,11,13,
   13,14,14],[1,1,2,3,3,4,6],[1,1,2,3,3,5],
 [1,1,2,3,3,5,5,7,7,9,9,11,11,13,13],[1,1,2,3,3,6],
 [1,1,2,3,4,4],
 [1,1,2,3,4,4,4,5,5,6,7,7,7,8,8,9,10,11,14,14,14,16,
   16],[1,1,2,3,4,4,4,5,5,6,7,7,7,8,8,9,12,12,13,13,
   14,14],
 [1,1,2,3,4,4,4,5,5,6,7,7,7,8,9,9,10,10,15,15,18],
 [1,1,2,3,4,4,4,5,5,6,7,7,7,8,10,10,11,11,12,12,13,13,
   15,15,15,15],[1,1,2,3,4,4,5,5],
 [1,1,2,3,4,4,5,5,5,6,6,6,7,7,8,8,8,9,9,9,10,10,11,
   11,12,12],
 [1,1,2,3,4,4,5,5,6,6,7,7,7,8,8,9,9,10,10,11,12],
 [1,1,2,3,4,4,5,5,6,6,7,7,7,8,8,9,9,10,11,12,13],
 [1,1,2,3,4,4,5,5,6,6,7,7,7,8,8,9,9,10,11,12,13,13],
 [1,1,2,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,12,12],
 [1,1,2,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,12,13],
 [1,1,2,3,4,4,5,6,6,6,7,7,7,7,7,7,8,8,9,9,9,9,9,10,
   10],[1,1,2,3,4,4,6,6,9],[1,1,2,3,4,5,5],
 [1,1,2,3,4,5,5,6,6,6,7,7,7,7,8,8,8,8,8,9,9,9,9,9,
   10],[1,1,2,3,4,5,6,7,8,9,10,11,12,13,14],
 [1,1,2,3,4,7],[1,1,2,3,5],[1,1,2,3,6,9,12,15,18],
 [1,1,2,3,6,11,11,16,16,16,16],
 [1,1,2,3,6,15,21,24,27,30],
 [1,1,2,3,7,7,11,11,11,11,15,15,15,15,15,15,15],
 [1,1,2,3,7,7,11,11,11,11,15,15,15,15,15,15,15,15],
 [1,1,2,3,8],[1,1,2,3,9,11,15,17,21,23,27,29,33,35,41]
  ,[1,1,2,3,9,12,15,15,18,18,18,21,21],[1,1,2,4],
 [1,1,2,4,4],[1,1,2,4,4,5],[1,1,2,4,4,5,5],
 [1,1,2,4,4,5,6,6,7],
 [1,1,2,4,4,7,7,10,10,13,13,16,16,19,19],
 [1,1,2,4,5,7,8,10,11,13,14,16,17,19,20],
 [1,1,2,4,6,8,10,12,14],[1,1,2,4,7],
 [1,1,2,4,7,15,20,23,25,28],[1,1,2,4,8],
 [1,1,2,4,9,9,14,14,19,19,24,24,29,29,34],
 [1,1,2,4,9,12,14,15,17,17,18,19,20],
 [1,1,2,4,9,13,17,21,25,29],[1,1,2,4,9,15,21,27,33,39]
  ,[1,1,2,5],[1,1,2,5,5,6],
 [1,1,2,5,5,7,7,9,9,11,11,13,13,15,15],[1,1,2,5,6],
 [1,1,2,5,7],[1,1,2,5,8],[1,1,2,5,9,13,17,21,25,29],
 [1,1,2,5,9,20,27,31,34,38],
 [1,1,2,5,11,26,35,41,44,50],
 [1,1,2,5,12,16,19,20,23,23,24,26,27],
 [1,1,2,5,14,20,23,26,29,29,32,32,35],[1,1,2,6],
 [1,1,2,6,6],[1,1,2,6,7,8,9,10,11,12,13,14,15,16,17],
 [1,1,2,6,7,9,10,12,13,15,16,18,19,21,22],
 [1,1,2,6,9,10,12,13,13,14,15,16,16,16,17,18],
 [1,1,2,8],[1,1,3],[1,1,3,3,3,4],[1,1,3,3,3,5],
 [1,1,3,3,3,6,6,9,9,12,12,15,15,18,18],[1,1,3,3,4],
 [1,1,3,3,4,4],[1,1,3,3,4,4,4],
 [1,1,3,3,4,4,5,5,6,6,7,7,8,8,10,10],
 [1,1,3,3,4,4,5,6],
 [1,1,3,3,4,4,6,6,7,7,9,9,10,10,12,12],
 [1,1,3,3,4,5,5,7,7,9,9,10,10,11,11,12,12,13,13,14,14,
   16,16,18,18],
 [1,1,3,3,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,
   14,14,16,16],[1,1,3,3,5,5,7,7,8],[1,1,3,3,7],
 [1,1,3,4],[1,1,3,4,4],
 [1,1,3,4,4,4,4,6,6,7,7,7,7,7,7,7,7,9,9,9,9,10,10,
   10,10,10,10,10,10,10,10,10,10,10,10,10,10],
 [1,1,3,4,4,5],[1,1,3,4,4,6],
 [1,1,3,4,5,6,6,7,7,8,8,8,9,9,9,10],[1,1,3,4,6],
 [1,1,3,4,9,9,14,14,14,14],[1,1,3,5],[1,1,3,5,5],
 [1,1,3,5,7,9,9,11,11,13,13,15,15,17,19,21,27,27],
 [1,1,3,5,7,9,9,11,11,13,13,15,15,17,23,23],
 [1,1,3,5,7,9,11,11,13,13,13,15,15,15,25],[1,1,3,6],
 [1,1,3,6,6,9,9,9,9,12,12,12,12,12,12,12,12],
 [1,1,3,6,7],[1,1,3,7],[1,1,3,7,8],[1,1,3,7,14],
 [1,1,3,8],[1,1,4],[1,1,4,4],
 [1,1,4,4,4,4,7,7,7,7,10,10,10,10,13,13],[1,1,4,4,5],
 [1,1,4,4,7,7,10,10],
 [1,1,4,4,7,7,10,10,13,13,16,16,19,19],[1,1,4,5],
 [1,1,4,5,6],[1,1,4,5,6,9,10],[1,1,4,5,7],
 [1,1,4,5,7,8,9],
 [1,1,4,5,7,8,10,11,13,14,16,17,19,20,23],[1,1,4,5,8],
 [1,1,4,6,8],[1,1,4,6,9],[1,1,4,7,7],
 [1,1,4,7,7,8,8,9,9,10,10,11,11,12,12],
 [1,1,4,7,7,10,10,10,10,13,13,13,13,13,13,16,16],
 [1,1,4,7,8],[1,1,4,7,16,22,25,28,31,31,34],
 [1,1,4,9],[1,1,4,9,10],
 [1,1,4,10,13,16,16,19,19,19,22,22],[1,1,5],
 [1,1,5,5],[1,1,5,5,6,6,7,7,8,8,9,9,10,10,11,11],
 [1,1,5,5,6,6,10,10,11,11,15,15,16,16,20,20],
 [1,1,5,5,7,7,9,9,11,11,13,13,15,15],
 [1,1,5,5,7,11,13,13,17,17,19,19,19,19],[1,1,5,6],
 [1,1,5,8],[1,1,5,8,9],[1,1,5,9],[1,1,5,9,9],
 [1,1,5,9,9,13,13,13,13,17,17,17,17,17,17,17,17],
 [1,1,5,10],[1,1,5,11,17,23,29,35,41],[1,1,6],
 [1,1,6,6,6,6,11,11,16,16,16,16,26,26,36,36],
 [1,1,6,6,6,11,11,11,11,11,11,16,16,16,16,16,16,21,21,
   21,21],[1,1,6,12,12,14,14,16,16,18,18,20,20],
 [1,1,7,7],[1,1,7,8],[1,1,7,11,15,19,23,27,31,35],
 [1,1,8],[1,1,8,8,10,10,12,12,14,14,16,16,18,18],
 [1,1,8,8,11,11,14,14,17,17,20,20,23,23],[1,1,8,9],
 [1,1,8,10,11,11,12,14,15,15,16,18,19,19,22],
 [1,1,9,12],[1,2],[1,2,2],[1,2,2,2,2,3,3,3,4],
 [1,2,2,2,2,3,3,4,4,4,4,4,4,4,4,5,5,5,5,6,6,6,6,6,
   6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7],
 [1,2,2,2,2,6],[1,2,2,2,3],[1,2,2,2,3,3],
 [1,2,2,2,3,3,5,6],[1,2,2,2,3,5],
 [1,2,2,2,3,5,5,6],[1,2,2,2,4,4,4,6],
 [1,2,2,2,4,5],[1,2,2,2,8],[1,2,2,3],
 [1,2,2,3,3,3,4,4],
 [1,2,2,3,3,3,4,4,5,5,5,6,6,7,7,7,8,9,11,13,15],
 [1,2,2,3,3,3,4,4,5,5,5,6,6,7,7,7,8,10,10,11,11,12,12 
  ],[1,2,2,3,3,3,4,4,5,5,5,6,6,7,7,8,8,8,9,9,10,10,
   11,11],
 [1,2,2,3,3,3,4,4,5,5,6,6,6,6,7,7,7,7,8,8,8,9,9,10,
   10],[1,2,2,3,3,3,4,5],[1,2,2,3,3,4],
 [1,2,2,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,
   9,9],[1,2,2,3,3,6],[1,2,2,3,3,6,6],
 [1,2,2,3,4],[1,2,2,3,4,4],[1,2,2,3,4,5],
 [1,2,2,3,4,5,6,7,8,9,10,11,12,13,14],[1,2,2,3,5],
 [1,2,2,3,5,5,6,10,10,11,18,18,19,39,39,40,52,52],
 [1,2,2,3,5,5,6,10,10,11,23,23,24,31,31,32,36,36,39,39],
 [1,2,2,3,5,5,6,13,13,14,18,18,19,21,21,22,23,23,24,26,
   26,26,26,28,28],[1,2,2,3,5,8,10,11,13,13,15,18,20],
 [1,2,2,3,7],
 [1,2,2,3,7,7,8,10,10,11,12,12,13,13,13,14,15,15,15,15,
   16,16,16,16,17,17,17,18,18,18,18,18,18,19,19],
 [1,2,2,4],[1,2,2,4,4],
 [1,2,2,4,4,5,5,7,7,8,8,10,10,11,11,13,13],
 [1,2,2,4,4,6,6,8,8,10,10,12,12,14,14],[1,2,2,4,5],
 [1,2,2,4,5,5],[1,2,2,4,5,5,10,11,11],
 [1,2,2,4,5,5,10,11,11,22,23,23],[1,2,2,4,6],
 [1,2,2,4,7],[1,2,2,4,7,8,9,11],[1,2,2,5],
 [1,2,2,5,5],[1,2,2,5,5,8,8,11,11,14,14,17,17,20,20],
 [1,2,2,5,6,7,8,8,9,10,11,11,12,13,14],
 [1,2,2,5,6,7,8,9,9,10,10,11,11,12,13,13,15,16,17,18],
 [1,2,2,5,7],
 [1,2,2,5,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,17,
   17,20],
 [1,2,2,5,7,8,8,9,10,10,10,11,11,11,12,13,13,13,14,14,
   14,15,16,17],[1,2,2,5,7,10],[1,2,2,6,7],
 [1,2,2,6,7,8,11],[1,2,2,7],[1,2,2,10],[1,2,3],
 [1,2,3,3,3],[1,2,3,3,4],[1,2,3,3,4,4],
 [1,2,3,3,4,4,4,4],
 [1,2,3,3,4,4,5,5,6,6,7,7,8,8,9,10],
 [1,2,3,3,4,5,6,7,7,8,9,10,11,11,12,13,14,15,19,23,27],
 [1,2,3,3,4,5,6,7,7,8,9,10,11,11,12,13,14,15,21,21,23,
   23],
 [1,2,3,3,4,5,6,7,7,8,9,10,11,11,12,13,14,17,17,19,19,
   21,21],
 [1,2,3,3,4,5,6,7,7,8,9,10,11,12,13,13,13,14,15,15,17,
   17,19,19],
 [1,2,3,3,4,5,6,7,8,9,9,9,10,11,11,11,12,13,13,13,14,
   15,15,17,17],[1,2,3,3,4,5,7],[1,2,3,3,5,6,6],
 [1,2,3,3,5,6,6,8],[1,2,3,3,6],
 [1,2,3,3,6,6,7,9,9,10,10,10,10,13,13,13,13],
 [1,2,3,3,7,7,8],[1,2,3,4],[1,2,3,4,4],
 [1,2,3,4,4,5,6],
 [1,2,3,4,4,5,7,7,8,12,12,13,25,25,26,33],
 [1,2,3,4,4,5,7,7,8,15,15,16,20,20,21,23,25],
 [1,2,3,4,4,5,9,9,10,12,12,13,14,14,15,15,15,16,17,17,
   18],[1,2,3,4,5],[1,2,3,4,5,5],
 [1,2,3,4,5,5,5,6,7,7,7,8,9,9,9,10,11,11,11,12,13,13,
   13,14,15,15],[1,2,3,4,5,6],[1,2,3,4,5,6,7,8,9],
 [1,2,3,4,5,6,7,8,9,10,11,12,13,14],[1,2,3,4,5,7,7],
 [1,2,3,4,5,7,10],[1,2,3,4,6],[1,2,3,4,6,6,7],
 [1,2,3,4,6,7,8],[1,2,3,4,6,7,9,10,12,13,15,16,18,19]
  ,[1,2,3,5],[1,2,3,5,5],
 [1,2,3,5,5,7,7,8,8,10,10,11,11,13,13],[1,2,3,5,6],
 [1,2,3,5,7,12,12,14,17,17,19,19,19,21],
 [1,2,3,5,8,9,10,12,13,13,14,14,15,16,17,17,17,18,18,18,
   19],[1,2,3,5,11,16,17,22,23,37],
 [1,2,3,5,12,13,14],[1,2,3,6],
 [1,2,3,6,6,7,9,9,10,10,10,11,12,12,13,13,13,13,13,14,
   14,14,14,15],[1,2,4],[1,2,4,4],[1,2,4,4,4],
 [1,2,4,4,5],[1,2,4,4,5,5,7,7,8,8,10,10,11,11,13,14],
 [1,2,4,4,5,6,6,7],[1,2,4,4,5,6,6,7,7],
 [1,2,4,4,5,6,6,7,7,7,8,8,8,9,9,9,9,9,10,10,10,10,11]
  ,[1,2,4,4,5,6,7],[1,2,4,4,5,7,8,9],
 [1,2,4,4,5,8,8],[1,2,4,4,6],
 [1,2,4,4,6,6,7,8,8,9,9,9,9,11,11,11,11],
 [1,2,4,4,6,6,8,8,10,10,12,12,14,14,16],[1,2,4,5],
 [1,2,4,5,5],[1,2,4,5,5,6,6,8,8,9,9,11,11,12,12],
 [1,2,4,5,7,8,8,9,10,11,11,11,12,12,14,14,15,16,18,18,
   19,19],
 [1,2,4,5,7,8,8,9,10,11,11,11,12,12,14,14,15,16,19,20,
   22],[1,2,4,5,7,8,8,9,10,11,11,11,12,12,14,14,15,16,
   22,23],
 [1,2,4,5,7,8,10,11,11,12,14,14,15,15,15,16,18,19,20],
 [1,2,4,5,7,8,10,11,11,12,14,14,15,15,15,16,18,19,20,21,
   22],[1,2,4,5,7,8,10,11,13,14,16,17,19,20],
 [1,2,4,5,7,8,10,11,14,15,17,18,19],[1,2,4,6],
 [1,2,4,6,8],[1,2,4,6,9],[1,2,4,6,10],[1,2,4,8],
 [1,2,4,8,8,12,12,12,12,16,16,16,16,16,16,16,16],
 [1,2,4,8,12,16,20,24,28],
 [1,2,4,9,9,14,14,14,14,19,19,19,19,19,19,19,19],
 [1,2,4,10],[1,2,4,11,11],[1,2,5],[1,2,5,5],
 [1,2,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,8,8,8,11,11,11,
   11,11,11,11,11,11,11,11,11,11,11,11,11],
 [1,2,5,5,6,6,6,7],
 [1,2,5,5,8,8,8,8,11,11,11,11,11,11,11,11],[1,2,5,6],
 [1,2,5,6,7,9,10,13,14,15,17,18,21,22,23,25,26,31,39,47,
   55],[1,2,5,6,7,9,10,13,14,17,18,19,19,21,22,23,23,
   25,26,27,27,31,31,35,35],
 [1,2,5,6,8,9,9,10,12,12,13,13,13,14,15,15,16,16,19,20,
   26,26,32,33,42],
 [1,2,5,6,8,9,9,10,12,12,13,13,13,14,15,15,16,16,19,20,
   32,33,42],
 [1,2,5,6,8,9,9,10,12,12,13,13,13,14,15,16,18,19,22,25,
   26,36],
 [1,2,5,6,8,9,9,10,12,12,13,13,13,14,15,16,19,19,20,20,
   22,22,29],
 [1,2,5,6,9,10,11,11,13,14,15,15,17,18,19,19,21,22,23,
   23,25,26,27,27,31,31],
 [1,2,5,6,9,10,12,13,13,14,15,16,16,16,17,17,18,19,23,24 
  ],[1,2,5,6,9,10,12,13,13,14,15,16,16,16,17,17,18,19,
   30],[1,2,5,6,9,10,13,14],[1,2,5,7],[1,2,5,7,10],
 [1,2,5,9],[1,2,5,10,11],[1,2,5,10,23,31,36,39,44],
 [1,2,5,13,18,21,23,26,26,28,29,31],[1,2,5,15,20,37],
 [1,2,6],[1,2,6,6],
 [1,2,6,6,7,7,10,10,11,11,14,14,15,15],
 [1,2,6,6,8,8,8,8,10,10,10,10,12,12],
 [1,2,6,6,8,8,10,10,12,12,14,14,16,16],
 [1,2,6,15,20,24,25,29,29,30,33,34],[1,2,7],
 [1,2,7,7,8],[1,2,7,8],
 [1,2,7,10,12,13,15,15,16,17,18,18,18,19,20],
 [1,2,7,11,12,15,16,16,17,19,20,20,20,21,23],[1,2,8],
 [1,2,8,8,10,10,12,12,14,14,16,16],[1,2,9],
 [1,2,10,10,12,12,14,14,16,16,18,18],[1,3],[1,3,3],
 [1,3,3,4],[1,3,3,4,4],[1,3,3,4,4,4],
 [1,3,3,4,4,4,5,6],[1,3,3,4,4,5],
 [1,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11],
 [1,3,3,4,4,7,8],
 [1,3,3,4,5,5,6,6,6,7,7,7,8,8,8,8,8,9,9,9,9,9,9,10,
   10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,
   12,12,12,12,12,12,12,12,12,13,13],
 [1,3,3,4,5,5,6,6,6,7,7,7,8,8,8,8,8,9,9,9,9,9,9,10,
   10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,
   12,12,12,12,12,12,12,12,13,13],[1,3,3,4,5,6,7],
 [1,3,3,5],
 [1,3,3,5,5,5,5,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,
   9,9,9,9,9,9,9],
 [1,3,3,5,5,6,7,7,9,9,10,11,11,13,13,14,15,18,22,26,30]
  ,[1,3,3,5,5,6,7,7,9,9,11,11,12,12,13,13,14,14,15,16,
   16,18,18,20,20],
 [1,3,3,5,5,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,
   15,16,16,18,18],[1,3,3,5,5,7,7,9,9,11,11,13,13,15],
 [1,3,3,5,5,7,7,9,9,11,11,13,13,15,15],[1,3,3,5,7],
 [1,3,3,5,9],[1,3,3,6,9],[1,3,3,7],[1,3,3,8],
 [1,3,4],[1,3,4,4],[1,3,4,4,5,5,5,6],
 [1,3,4,4,5,6,6],
 [1,3,4,4,5,6,6,6,7,7,7,8,8,8,8,9,9,9,9,9,10,10,10,
   11,11,11,12,12,12,13],[1,3,4,4,8],[1,3,4,5],
 [1,3,4,5,5],
 [1,3,4,5,5,6,7,8,9,9,10,11,12,13,14,15,15,16,17,17,19,
   19,21,21],
 [1,3,4,5,5,6,7,8,9,10,11,11,11,12,13,13,13,14,15,15,
   16,17,17,19,19],
 [1,3,4,5,6,7,7,7,8,9,9,9,10,11,11,11,12,13,13,13,14,
   15,15,16,17,17],[1,3,4,5,9],
 [1,3,4,5,9,18,23,27,28,32],
 [1,3,4,5,10,14,15,18,19,19,20,22,23],
 [1,3,4,6,6,7,7,9,9,9,9,10,10,10,10,12,12,12,12,12,12,
   12,12],
 [1,3,4,6,7,7,9,10,12,13,13,15,16,18,19,19,21,25,31,37,
   43],
 [1,3,4,6,7,7,9,10,12,13,15,16,16,16,18,19,19,19,21,22,
   22,25,25,28,28],
 [1,3,4,6,7,8,9,9,10,11,12,14,14,15,17,20],
 [1,3,4,6,7,8,9,9,10,11,12,14,22],[1,3,4,6,7,9,10],
 [1,3,4,6,7,9,10,10,10,12,13,13,13,15,16,16,16,18,19,19,
   19,21,22,22,25,25],
 [1,3,4,6,7,9,10,11,11,12,12,14,14,14,24,25],
 [1,3,4,6,7,9,10,12,13,15,16,18,19,21],[1,3,4,6,9],
 [1,3,4,6,10,11,12,15,16,16,17,17,18,20,21,21,22],
 [1,3,4,7],
 [1,3,4,7,8,9,10,11,12,12,13,13,14,14,15,15,15,16,16,17,
   17,17,18,19],[1,3,5],[1,3,5,5,8],[1,3,5,6],
 [1,3,5,6,8],[1,3,5,7],[1,3,5,7,8],
 [1,3,5,7,9,11,13,15],[1,3,5,7,9,11,13,15,17,19],
 [1,3,5,8],[1,3,5,10],[1,3,6],
 [1,3,6,6,7,7,8,8,9,9,10,10,11,11,12],[1,3,6,7],
 [1,3,6,8],[1,3,6,8,9],[1,3,6,10,21,28,32,35,39],
 [1,3,6,13,17,20,21,24,24,25,27,28],
 [1,3,6,14,19,22,24,27,27,29,30,32],[1,3,6,19,26,49],
 [1,3,7],[1,3,7,7,8],[1,3,7,8],
 [1,3,7,9,11,13,15,17,19,21],
 [1,3,7,10,11,13,14,14,15,16,17,17,17,18,19],[1,3,8],
 [1,3,8,11,13,14,16,16,17,18,19,19,19,20,21],
 [1,3,9,9,11,11,13,13,15,15,17,17],[1,4],
 [1,4,4,4,4,5,5,6,6,6,6,7,7,8,8,8,8,9,9],
 [1,4,4,4,4,6,6,6,6,8,8,8,8,10,10],[1,4,4,4,7],
 [1,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11],[1,4,4,5,6],
 [1,4,4,6,6,8,8,10,10,12,12,14,14],[1,4,4,7],
 [1,4,4,7,7,7,7,10,10,10,10,10,10,10,10],
 [1,4,4,7,7,10,10,13,13,16,16,19,19,22,22],
 [1,4,4,8,8,12,12,16,16],[1,4,4,8,10],[1,4,4,10,10],
 [1,4,5],[1,4,5,5],[1,4,5,6,7],[1,4,5,7],
 [1,4,5,7,8,10,11,13,14,16,17,19,20],
 [1,4,5,7,8,10,11,13,14,16,17,19,20,23],[1,4,5,7,10],
 [1,4,5,10,11],[1,4,6],[1,4,6,6],
 [1,4,6,6,6,6,8,8,8,8,10,10,10,10],
 [1,4,6,7,8,9,9,10,10,11,11,11,12,12,12,12,13,13,13,13,
   13,14,14],[1,4,6,8,10,12,14,16,18,20,22,24,26],
 [1,4,7],[1,4,7,7,10,10,10,10,13,13,13,13,13,13,13,13],
 [1,4,7,8],[1,4,7,10,13,16,19],[1,4,8],
 [1,4,8,11,11,12,12,13,13,14,14,15,15,16],
 [1,4,8,12,16,20,24,28,32],
 [1,4,8,13,13,14,14,17,17,18,18,21,21,22],[1,4,9],
 [1,4,9,9,10,10,11,11,12,12,13,13,14,14,15],[1,4,10],
 [1,4,10,10,14],[1,4,11,15,19,23,27,31,35],
 [1,4,33,33,46,46,49,49,59,59,62,62,65,65,72,72,75,75,78,
   78,81,81],[1,5],[1,5,5],[1,5,5,6],
 [1,5,5,7,7,9,9,11,11,13,13,15,15],
 [1,5,5,8,8,11,11,14,14,17,17,20,20],[1,5,6],
 [1,5,6,7,7,8,8,9,9,10,10,11,12,13,14],
 [1,5,6,7,8,9,10,11,12,13,14,15,16,17,18],[1,5,6,9],
 [1,5,7],[1,5,7,7],
 [1,5,7,8,10,11,13,14,16,17,19,20,22],[1,5,7,9],
 [1,5,7,10,10,12],[1,5,8,8,8,8,11,11,11,11,14,14,14,17 
  ],[1,5,8,11,14,17,20,23,26],[1,5,9],[1,5,11],
 [1,6],[1,6,6],
 [1,6,6,7,7,9,9,10,10,12,12,13,13,15,15],
 [1,6,6,8,8,10,10,12,12,14,14,16,16,18],[1,6,6,8,10],
 [1,6,7],[1,6,7,7],[1,6,12],
 [1,6,12,12,14,14,16,16,18,18,20,20],
 [1,6,12,18,24,30,36,42],
 [1,6,13,19,19,21,21,23,23,25,25,27,27],
 [1,6,15,15,17,17,19,19,21,21,23,23,25,25],[1,7,7],
 [1,7,8,10,10],[1,7,8,11,14,15,18,19,22,23,26,27,30,34]
  ,[1,7,9],[1,7,10,11,12,15,16,19,20,23,24,27,28,32],
 [1,8],[1,8,8,10,10,12,12,14,14,16,16,18,18],[1,8,9],
 [1,8,11],[1,8,14,31,42,48,53,59],
 [1,8,19,25,30,31,36,36,37,41,42],[1,9],[1,9,9],
 [1,9,9,12,12,15,15,18,18,21,21,24,24],[1,9,10],
 [1,9,21,21,26,26,31,31,36,36,41,41,46,46],[1,10],
 [1,10,10],[1,11,11,14,14,17,17,20,20,23,23,26,26],
 [1,11,14,16,19,21,24,26,29,31,34,36,39,41],[1,12],
 [1,12,12,17,17,18,18,22,22,23,23,24,24,27,27,28,28,29,
   29,30,30,32,32,33,33,34,34,35,35,36,36],[2],[2,2],
 [2,2,2],[2,2,2,2,2,2],[2,2,2,2,2,2,2,2,2,4,4,4],
 [2,2,2,2,2,2,3,3,4,4],[2,2,2,2,2,2,3,3,4,4,4],
 [2,2,2,2,2,2,3,3,4,4,4,7],
 [2,2,2,2,2,2,3,3,4,4,6,7,7,7,10,10,13,13,16,16],
 [2,2,2,2,2,2,3,3,4,4,7],
 [2,2,2,2,2,2,3,3,4,4,7,7,8,9,10,10,11,13,13,16,16],
 [2,2,2,2,2,2,3,3,4,4,8,9,11,12,13,14,16,17,18,19,21,
   22,23,24,26,27],[2,2,2,2,2,2,3,3,4,6,6,9,9,11],
 [2,2,2,2,2,2,3,3,4,7,7,7,10],
 [2,2,2,2,2,2,3,3,5,5,6],
 [2,2,2,2,2,2,3,3,5,6,8,11,11,15],
 [2,2,2,2,2,2,3,4,4,4,5,5],[2,2,2,2,2,2,3,4,4,5],
 [2,2,2,2,2,2,3,4,4,5,5,5,6,8,9,11],
 [2,2,2,2,2,2,3,4,4,5,6,7,7,8],
 [2,2,2,2,2,2,3,4,4,5,8,9,9,10,13,14,14,15,18,19,19,
   20,23,24,24,25],[2,2,2,2,2,2,3,4,5,5,5,6],
 [2,2,2,2,2,2,3,4,5,8,9,12,12,13],
 [2,2,2,2,2,2,3,4,5,9,9,11,11,12],
 [2,2,2,2,2,2,3,4,6,7,7,7,8],
 [2,2,2,2,2,2,3,4,7,7,8,9,10,10],
 [2,2,2,2,2,2,3,4,9,9,10,10,11,11],
 [2,2,2,2,2,2,3,6,6,6,7,7,7,9],[2,2,2,2,2,2,4,4],
 [2,2,2,2,2,2,4,4,4,4,4,4,6,6,6,6,6,6,8,8,8,8,8,8,
   10,10,10,10,10,10],
 [2,2,2,2,2,2,4,4,4,4,6,6,6,6,6,8,8,8,8,8,8,10,10,
   10,10,10,12,12,12,14,14,14,16,16,16,16,18],
 [2,2,2,2,2,2,4,4,6,6,6,6,8,8,8,8,8,8,8,8,8,8,10,10,
   12,12,12,12,14,14,14,14,14,14,14,14,14,14,14,14,14,14,
   14,14],[2,2,2,2,2,2,6,6,6],
 [2,2,2,2,2,3,4,4,4,5,5,6,7,7,7,8],
 [2,2,2,2,2,3,4,4,4,5,6,7,7,9,10,10],
 [2,2,2,2,2,3,4,4,5,7,7,7,8,14],
 [2,2,2,2,2,3,4,5,5,6,6,6,7,11],
 [2,2,2,2,2,3,4,5,6,6,6,7,7,12],
 [2,2,2,2,2,4,4,4,5,5,5],
 [2,2,2,2,2,4,4,4,5,5,5,5,6,6,7,7],
 [2,2,2,2,2,4,4,4,5,5,6],
 [2,2,2,2,2,4,4,4,5,5,6,7,7,7,8,8],
 [2,2,2,2,2,4,4,5,5,5,6],[2,2,2,2,2,4,4,6],
 [2,2,2,2,2,4,4,6,6,8,10],[2,2,2,2,2,4,6],
 [2,2,2,2,3,3],[2,2,2,2,3,3,4,4],
 [2,2,2,2,3,3,4,5,7,7,10,10,13,13,16,16],
 [2,2,2,2,3,3,6,6,15,18,18,21,21,23,26,26,31,39],
 [2,2,2,2,3,3,6,9,9,12,12,12,15,15,15,15,17,18,18,20,
   20,22,27],[2,2,2,2,3,4,4,4,4,4,5,5,7,7,8],
 [2,2,2,2,3,4,4,4,4,5,5,5,8],
 [2,2,2,2,3,4,4,4,5,6,7,7,8,8],
 [2,2,2,2,3,4,4,5,5,6],
 [2,2,2,2,3,4,4,5,6,7,7,7,9,10],[2,2,2,2,3,4,5,5],
 [2,2,2,2,3,4,5,5,5,6],[2,2,2,2,3,5,5,6],
 [2,2,2,2,3,5,5,6,6,8,11,11,13],
 [2,2,2,2,3,5,5,6,7,10,11,12,13,15,16,17,18,22,23],
 [2,2,2,2,3,5,5,7,7,10,11,11,12,15,16,16,17,21,22],
 [2,2,2,2,3,5,5,10,11,11],
 [2,2,2,2,3,6,7,7,7,10,10,11,11,11,12],
 [2,2,2,2,3,6,7,8,8,9,9,10,10,10,11],
 [2,2,2,2,3,7,7,7,8,8,9,9,10],[2,2,2,2,3,7,7,10],
 [2,2,2,2,3,7,8,8],[2,2,2,2,3,7,8,10,10,11],
 [2,2,2,2,4],[2,2,2,2,4,4],[2,2,2,2,4,4,4],
 [2,2,2,2,4,4,4,4],[2,2,2,2,4,4,4,4,4,5,5,5,7,7],
 [2,2,2,2,4,4,4,4,5,5,7,8,8,9],
 [2,2,2,2,4,4,4,5,5,5,5,6,6,6,7,7],
 [2,2,2,2,4,4,4,5,5,6,6,7,7,7,7,7,8,8],
 [2,2,2,2,4,4,4,6,6,8,8],[2,2,2,2,4,4,5,5,6,6],
 [2,2,2,2,4,4,6,6,8,8,8,8,10,10],[2,2,2,2,4,4,8],
 [2,2,2,2,4,5,5,5,5,6],[2,2,2,2,4,6],
 [2,2,2,2,4,6,6],[2,2,2,2,4,6,6,8],[2,2,2,2,4,8],
 [2,2,2,2,5,5,6,7,8,8],[2,2,2,2,6,6],
 [2,2,2,2,6,6,6],[2,2,2,2,8,8,8,8,24,24,24,24],
 [2,2,2,3,3,3],[2,2,2,3,3,3,3,5,5,6,6],
 [2,2,2,3,3,3,3,5,8,9],[2,2,2,3,3,3,5,6,6,8],
 [2,2,2,3,3,4,5,5],[2,2,2,3,3,5,6],[2,2,2,3,4],
 [2,2,2,3,4,5,5,7],[2,2,2,3,5,5,6,6],
 [2,2,2,4,4,4],[2,2,2,4,4,4,4,4,4],
 [2,2,2,4,4,4,4,6],[2,2,2,4,4,4,6],
 [2,2,2,4,4,4,6,6],[2,2,2,4,4,6],
 [2,2,2,4,4,6,6,6],
 [2,2,2,4,4,6,6,8,8,8,8,10,10,10,10,12,12,12,12,14,14,
   14,14,16,16],[2,2,2,4,4,6,10],[2,2,2,4,6,6],
 [2,2,2,4,6,6,8],[2,2,2,4,6,8,10],[2,2,2,6],
 [2,2,3],[2,2,3,3],[2,2,3,3,3],[2,2,3,3,3,3,4,5],
 [2,2,3,3,3,3,5,6,8,9,14],[2,2,3,3,3,4],
 [2,2,3,3,3,4,4,5],[2,2,3,3,3,5,5,6,6],
 [2,2,3,3,3,5,6],[2,2,3,3,4],[2,2,3,3,4,4,4,5],
 [2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9],
 [2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10],
 [2,2,3,3,4,6,8],[2,2,3,3,5,6,8,9,9],
 [2,2,3,3,5,6,8,9,14,15,15],
 [2,2,3,3,5,6,11,12,14,15,15],[2,2,3,3,6],
 [2,2,3,3,7,7,8],[2,2,3,4],[2,2,3,4,4],
 [2,2,3,4,4,4,4,8,8,8,8,9,11,11,12],
 [2,2,3,4,4,4,5,7,7,8,8,8,11,11,12],
 [2,2,3,4,4,4,5,7,7,8,8,10,10,11,11,13,13,14,14,16,16,
   17,17],[2,2,3,4,4,5],
 [2,2,3,4,4,5,5,7,7,7,7,10,10,10,10,13,13,13,13,16,16,
   16,16],[2,2,3,4,4,5,5,10],[2,2,3,4,4,5,6],
 [2,2,3,4,5,7,7,8],[2,2,3,4,8],[2,2,3,5,5],
 [2,2,3,5,5,6],[2,2,3,5,6],[2,2,3,5,6,7,8],
 [2,2,3,5,6,8,8,9,9],[2,2,3,5,7,14],[2,2,3,5,8],
 [2,2,3,5,9],[2,2,3,5,11,11],[2,2,3,6,6,7,8,8,10],
 [2,2,3,7,9,10],[2,2,3,7,11],[2,2,3,8,8],
 [2,2,3,8,10],[2,2,3,8,10,11],[2,2,4],[2,2,4,4],
 [2,2,4,4,4],[2,2,4,4,4,4],[2,2,4,4,4,4,4],
 [2,2,4,4,4,4,4,4],
 [2,2,4,4,4,4,6,6,6,6,8,8,8,8,10,10,10,10,12,12,12,12,
   14,14,14,14],[2,2,4,4,4,6,6,8,8,10,10],
 [2,2,4,4,4,6,6,8,12],[2,2,4,4,5,5,5,5,5,6,7,7,8],
 [2,2,4,4,5,5,5,8],
 [2,2,4,4,5,5,7,7,8,8,10,10,11,11,13,13],
 [2,2,4,4,5,6,6,8,8,9,10,10,12,12,13,14,14,17,21,25,29]
  ,[2,2,4,4,5,6,6,8,8,9,10,10,12,12,13,14,14,19,19,21,
   21,23,23],
 [2,2,4,4,5,6,6,8,8,9,10,10,12,12,14,14,15,15,17,17,19,
   19,21,21],
 [2,2,4,4,5,6,6,8,8,10,10,11,11,12,12,13,13,14,14,15,
   15,17,17,19,19],[2,2,4,4,6],
 [2,2,4,4,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,
   14,15,15,17,17],[2,2,4,4,6,6,8,8,10,10],
 [2,2,4,4,6,6,8,8,10,10,12,12,14,14],[2,2,4,4,8],
 [2,2,4,5],
 [2,2,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9],
 [2,2,4,5,5,5,5,8,8,9],[2,2,4,5,6],[2,2,4,6],
 [2,2,4,6,6,8,12,14,16,16,16,18,20,22,24,26,32],
 [2,2,4,6,6,10],[2,2,4,6,8],
 [2,2,4,6,8,8,8,10,10,12,14,14,14,16,16,16,20,22,22,26,
   28,30],[2,2,4,8],[2,2,5],
 [2,2,5,5,5,8,8,11,11,11,14,14,17,17,17,20,20,23,29,35,
   41],
 [2,2,5,5,5,8,8,11,11,14,14,14,14,17,17,17,17,20,20,20,
   20,23,23,26,26],[2,2,5,5,6],
 [2,2,5,5,8,8,8,8,11,11,11,11,14,14,14,14,17,17,17,17,
   20,20,20,20,23,23],
 [2,2,5,5,8,8,11,11,14,14,17,17,20,20],
 [2,2,5,5,10,13,13,15,18,18,18,20,21,21,23,23,26],
 [2,2,5,5,11,17,17,23,23,23,23,29],[2,2,5,6,6],
 [2,2,5,6,8,8],
 [2,2,5,7,7,8,10,10,10,11,12,12,13,13,13,13,14,15,15,15,
   15,15,16,17,17],
 [2,2,5,8,8,11,11,11,11,14,14,14,14,14,17],[2,2,6],
 [2,2,6,6],
 [2,2,6,8,8,10,12,12,12,14,14,14,16,16,16,16,18],
 [2,2,6,8,8,10,12,14,14,14,14,16,16,16,18,18,18],
 [2,2,8],[2,2,10,16],[2,3],[2,3,3],[2,3,3,3],
 [2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8 
  ],[2,3,3,3,3,5,5,6,6,8,8],[2,3,3,4],
 [2,3,3,4,4,4,5,5,6,6,7,7,7,7,8,8,8,8,9,9,10,10],
 [2,3,3,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9],
 [2,3,3,4,5],
 [2,3,3,4,5,5,5,6,6,6,7,7,7,7,8,8,8,8,8,8,9,9,9,9,
   9,10,10,10,11],[2,3,3,4,5,5,8],[2,3,3,4,7,8],
 [2,3,3,5],[2,3,3,5,6],[2,3,3,5,6,10,11],
 [2,3,3,6],[2,3,3,6,6],[2,3,4],[2,3,4,4],
 [2,3,4,4,5],
 [2,3,4,4,5,6,7,8,8,9,10,11,12,12,13,14,15,16,20,24,28]
  ,[2,3,4,4,5,6,7,8,8,9,10,11,12,13,14,14,14,15,16,16,
   18,18,20,20],
 [2,3,4,4,5,6,7,8,9,10,10,10,11,12,12,12,13,14,14,14,
   15,16,16,18,18],
 [2,3,4,5,6,6,6,7,8,8,8,9,10,10,10,11,12,12,12,13,14,
   14,14,15,16,16],[2,3,4,5,6,7,8,9,10,11,12,13,14,15]
  ,[2,3,4,5,6,7,8,9,10,11,12,13,14,15,16],
 [2,3,4,5,11],[2,3,4,6],[2,3,4,8],
 [2,3,4,8,8,12,12,12,12,16,16,16,16,16,16,16,16],
 [2,3,5],[2,3,5,5],[2,3,5,5,5,8,12],[2,3,5,5,6,6],
 [2,3,5,5,8,8,11,11,14,14,17,17,20],[2,3,5,5,10],
 [2,3,5,6],[2,3,5,6,6],
 [2,3,5,6,8,9,11,12,14,15,17,18,20,21],[2,3,5,7,8],
 [2,3,5,7,10,11],[2,3,5,8],[2,3,6],[2,3,7],
 [2,3,7,7,8,8],[2,3,7,8],[2,3,7,10],[2,3,8],
 [2,4],[2,4,4],[2,4,4,4],
 [2,4,4,4,4,6,6,6,6,8,8,8,8,10,10],
 [2,4,4,5,5,6,6,8,8],[2,4,4,6],[2,4,4,6,6,8],
 [2,4,4,6,6,8,8,10,10,12,12,14,14],[2,4,4,7,7],
 [2,4,5],[2,4,5,5],[2,4,5,5,5,9],[2,4,5,6],
 [2,4,5,6,6,7],[2,4,5,6,8,9],[2,4,6],[2,4,6,6],
 [2,4,6,6,6,6,8,8,8,8,10,10,10,12],[2,4,6,6,12],
 [2,4,6,8,10,12,14,16,18],[2,4,7],[2,4,7,7,10],
 [2,4,8],[2,4,8,8,8],[2,5],[2,5,5,5,5,6,6,6,12],
 [2,5,5,5,5,9,9],[2,5,5,5,6],[2,5,5,5,8],
 [2,5,5,5,8,9],[2,5,5,6],[2,5,5,6,6,6,8,9,9],
 [2,5,5,6,6,7,7,8,8,9,9,10,10,11,11],[2,5,5,6,7,8],
 [2,5,5,7],[2,5,5,8,8,11,11,14,14,17,17,20,20],
 [2,5,6],[2,5,6,6],[2,5,6,6,11,12,12],
 [2,5,6,6,11,12,12,23,24,24],[2,5,6,9],[2,5,7],
 [2,5,7,8],[2,5,8],
 [2,5,8,8,11,11,11,11,14,14,14,14,14,14,17,17],
 [2,5,8,9],[2,5,8,17,23,26,29,32,32,35],[2,5,10],
 [2,5,11,14,17,17,20,20,20,23,23],[2,6],[2,6,6],
 [2,6,6,7,7,8,8,9,9,10,10,11,11,12,12],[2,6,6,16],
 [2,6,7],[2,6,7,8],[2,6,12],[2,7,7,9],[2,8],
 [2,8,8],[2,8,8,10,10,12,12,14,14,16,16,18,18],
 [2,8,8,14,14,20,20,26,26],[2,8,11],[2,8,14],
 [2,9,9,11,11,13,13,15,15,17,17,19,19],[2,10],[3],
 [3,3],[3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,
   8,8,8],[3,3,3,4],[3,3,3,4,4],[3,3,3,6],
 [3,3,4],[3,3,4,4],[3,3,4,4,4,5],
 [3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10],[3,3,4,5],
 [3,3,5],[3,3,5,5],[3,3,5,6],[3,3,6],[3,3,6,6,8],
 [3,3,6,6,9,9,12,12,15,15,18,18,21,21],
 [3,3,7,7,11,11,15,15,19,19],[3,3,9],[3,4],[3,4,4],
 [3,4,4,5],[3,4,5],
 [3,4,5,6,7,8,9,10,11,12,13,14,15,16],[3,4,6],
 [3,4,7,7],[3,4,7,8],[3,4,8],
 [3,4,9,9,14,14,14,14,19,19,19,19,19,19,19,19],[3,5],
 [3,5,5],[3,5,5,5,5,7,7,7,7,9,9,9,9,11,11],
 [3,5,5,6],
 [3,5,5,7,7,7,9,9,11,11,11,13,13,15,15,17,17,19,19,21,
   21],[3,5,5,7,7,7,9,9,11,11,13,13,13,13,15,15,15,15,
   17,17,19,19],
 [3,5,5,7,7,9,9,9,9,11,11,11,11,13,13,13,13,15,15,15,
   15,17,17],[3,5,5,7,7,9,9,11,11,13,13,15,15,17],
 [3,5,6],[3,5,6,8],[3,5,6,9,12],[3,5,7],
 [3,5,8,8],[3,5,8,11,14,17,20,23,26],
 [3,5,9,13,17,21,25,29],[3,6],[3,6,6],
 [3,6,6,9,9,9,9,12,12,12,12,12,12,12,12],[3,6,7],
 [3,6,8,10,12,14,16,18,20],
 [3,6,14,19,22,24,27,27,29,30,32],[3,7],
 [3,7,7,9,9,11,11,13,13,15,15,17,17],[3,7,8],
 [3,7,10],[3,7,12],
 [3,8,11,13,14,16,16,17,18,19,19,19,20,21,21,22],[3,9],
 [3,12],[4],[4,4],[4,4,4],[4,4,4,4],[4,4,4,4,8],
 [4,4,4,4,8,12],[4,4,4,5,7],[4,4,4,8],
 [4,4,4,8,8,8,12],[4,4,5],[4,4,5,5,7],
 [4,4,5,6,7,7,8,9,10,10,11,12,13,13,14],[4,4,6],
 [4,4,6,6,6,6,8,8,8,8,10,10,10,10,12,12,12,12,14,14,14,
   14,16,16],[4,4,6,6,8,8,10,10,12,12,14,14,16,16],
 [4,4,7,7,10,10,13,13,16,16,19,19,22,22],[4,4,12],
 [4,5],[4,5,5],[4,5,5,6,6],
 [4,5,5,6,6,7,7,8,8,9,9,10,10,11,12],[4,5,5,7],
 [4,5,5,8],[4,5,5,9],[4,5,6],[4,5,6,7],
 [4,5,6,8],[4,5,7,8],
 [4,5,7,8,10,11,13,14,16,17,19,20,22,23],[4,5,11],
 [4,6],[4,6,7],
 [4,6,7,8,9,9,10,10,11,11,11,12,12,12,12,13,13,13,13,13,
   14,14],[4,6,8,10,12,14,16,18,20],[4,6,12],[4,7],
 [4,8],[4,8,8],[4,8,12,16,20,24,28,32],[4,9],
 [4,9,13,17,21,25,29,33],[4,9,15,21,27,33,39,45],
 [4,10,10,12,12,14,14,16,16,18,18],[4,12,12],
 [4,12,28,28],[4,16],[5],[5,5],
 [5,5,5,5,8,8,8,8,11,11,11,11,14,14],
 [5,5,5,5,8,8,8,8,11,11,11,11,14,14,14,14],[5,5,6],
 [5,5,6,6,7,7,8,8,9,9,10,10,11,11,12],[5,5,7],
 [5,5,10],[5,5,10,10,15,15,20,20,25,25,30,30,35,35],
 [5,5,11,17,17,23,23,23,23,29,29,29,29,29,35],[5,6],
 [5,7],[5,7,7],[5,7,8,10,11,13,14,16,17,19,20,22,25],
 [5,7,10],[5,7,13],[5,8],[5,8,10],
 [5,9,13,17,21,25,29,33],[6],[6,6],[6,6,6,12],
 [6,6,8,8,10,10,12,12,14,14,16,16],
 [6,6,8,8,10,10,12,12,14,14,16,16,18,18],
 [6,6,9,9,12,12,15,15,18,18,21,21],
 [6,6,16,16,26,26,36,36],[6,6,18],
 [6,7,8,9,10,11,12,13,14,15,16,17,19],[6,7,10],[6,8],
 [6,9],[6,9,9],[6,11],[6,24],[7,8],[7,8,10],
 [7,9],[7,9,11],[7,9,12,14,17,19,22,24,27,29,32,34],
 [7,10,12,13,15,15,16,17,18,18,18,19,20,20,20,22],[8],
 [8,8],[8,10],[8,16,24,32,40,48,56],[9],[10],
 [11,11,14,14,17,17,20,20,23,23,26,26],[12],
 [12,12,16,16,20,20,24,24,28,28,32,32],[20],[30]];

shortresidueclassorbitlengthspos :=
[3265,3265,2981,3236,3236,1,2981,3236,1,3236,1,1,2926,2926,
 3083,2926,3083,3095,2926,3083,3095,3028,3077,3265,3265,3077,
 3265,3265,1,1,3077,3077,3265,1,3265,1,1,1,1,1,3077,3077,1,
 3077,1,3265,1,3265,2823,2823,3286,3286,1,1,1,3268,2823,2823,
 3268,2823,2823,3268,2823,2823,2823,2823,3268,3265,2981,3236,
 3236,1,2981,3236,1,3236,1,1,2926,2926,3083,2926,3083,3095,
 2926,3083,3095,3028,3077,3077,3077,3077,3077,3077,2823,2823,
 3265,3265,3265,3286,3265,1,1,1,1,1,3077,3265,1,3265,1,3265,
 3286,3265,1,1,1,1,1,1,1,2823,2823,2823,2823,3268,2823,2823,
 3268,3268,3268,2823,2823,3266,3293,3293,1,3266,3293,1,3293,1,
 1,3267,3267,3272,3267,3272,3279,3267,3272,3279,3296,3265,3265,
 3265,3265,3265,3265,1,1,3265,3265,3265,1,3265,1,1,1,1,1,
 3265,3265,1,3265,1,3265,1,3265,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,3200,3200,1,2824,3200,1,3200,1,1,2851,2851,
 2983,2851,2983,2983,2851,2983,2983,2910,2826,2981,2981,2826,
 2981,2981,2824,2824,2981,2981,2981,3203,2981,3203,3203,2824,1,
 1,2826,2981,2824,2981,1,2981,3203,2981,2824,2824,3203,3203,1,
 1,1,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,
 2999,3200,1,3200,3200,1,3200,1,1,3207,3207,3216,3207,3216,
 3245,3207,3216,3245,3295,3202,3236,3236,3202,3236,3236,1,1,
 3236,3236,3293,1,3293,1,1,1,1,1,3202,3236,1,3236,1,3293,1,
 3293,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3200,
 3200,1,3200,1,1,3207,3207,3216,3207,3216,3245,3207,3216,3245,
 3295,3202,3236,3236,3202,3236,3236,1,1,3236,3236,3293,1,3293,
 1,1,1,1,1,3202,3236,1,3236,1,3293,1,3293,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3200,
 1,3200,1,1,2851,2851,2983,2851,2983,2983,2851,2983,2983,2910,
 2826,2981,2981,2826,2981,2981,2824,2824,2981,2981,2981,3203,
 2981,3203,3203,2824,1,1,2826,2981,2824,2981,1,2981,3203,2981,
 2824,2824,3203,3203,1,1,1,2999,2999,2999,2999,2999,2999,2999,
 2999,2999,2999,2999,2999,1,3200,1,1,3207,3207,3216,3207,3216,
 3245,3207,3216,3245,3295,3202,3236,3236,3202,3236,3236,1,1,
 3236,3236,3293,1,3293,1,1,1,1,1,3202,3236,1,3236,1,3293,1,
 3293,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,3207,3207,3216,3207,3216,3245,3207,3216,3245,
 3295,3202,3236,3236,3202,3236,3236,1,1,3236,3236,3293,1,3293,
 1,1,1,1,1,3202,3236,1,3236,1,3293,1,3293,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3078,
 3078,3023,3230,3230,3023,3134,3134,3134,2827,2926,2926,2827,
 2926,2926,2825,2825,2926,2926,2932,3204,2932,3208,3208,2825,1,
 1,2827,2926,2825,2926,1,2932,3204,2932,2825,2825,3205,3205,1,
 1,1,2852,2853,2853,2852,2854,2854,2853,2854,2854,2854,2854,
 2853,3078,3078,3078,3078,3023,3230,3230,3134,2827,2926,2926,
 2827,2926,2926,2825,2825,2926,2926,2932,3208,2932,3205,3205,
 2825,1,1,2827,2926,2825,2926,1,2932,3208,2932,2825,2825,3205,
 3205,1,1,1,2853,2852,2852,2853,2853,2853,2852,2854,2853,2854,
 2853,2852,3230,3230,3230,3134,3291,3291,3291,2923,3083,3083,
 2923,3083,3083,2823,2823,3083,3083,3129,3286,3129,3200,3200,
 2823,1,1,2923,3083,2823,3083,1,3129,3286,3129,2823,2823,3287,
 3287,1,1,1,3025,3025,3025,3025,3026,3026,3025,2998,3026,2998,
 3026,3025,3078,3230,3078,3078,3078,3134,2827,2926,2926,2827,
 2926,2926,2825,2825,2926,2926,2932,3205,2932,3205,3205,2825,1,
 1,2827,2926,2825,2926,1,2932,3205,2932,2825,2825,3208,3208,1,
 1,1,2854,2853,2853,2854,2852,2852,2853,2853,2852,2853,2852,
 2853,3230,3230,3230,3230,3291,2923,3083,3083,2923,3083,3083,
 2823,2823,3083,3083,3129,3200,3129,3287,3287,2823,1,1,2923,
 3083,2823,3083,1,3129,3200,3129,2823,2823,3200,3200,1,1,1,
 3026,3025,3025,3026,3025,3025,3025,3026,3025,3026,3025,3025,
 3134,3291,3291,3134,2923,3095,3095,2923,3095,3095,2823,2823,
 3095,3095,3100,3244,3100,1,1,2823,1,1,2923,3095,2823,3095,1,
 3100,3244,3100,2823,2823,1,1,1,1,1,3006,2987,2987,3006,3006,
 3006,2987,3009,3006,3009,3006,2987,3078,3230,3134,2827,2926,
 2926,2827,2926,2926,2825,2825,2926,2926,2932,3205,2932,3208,
 3208,2825,1,1,2827,2926,2825,2926,1,2932,3205,2932,2825,2825,
 3204,3204,1,1,1,2854,2854,2854,2854,2853,2853,2854,2852,2853,
 2852,2853,2854,3230,3291,2923,3083,3083,2923,3083,3083,2823,
 2823,3083,3083,3129,3287,3129,3200,3200,2823,1,1,2923,3083,
 2823,3083,1,3129,3287,3129,2823,2823,3286,3286,1,1,1,2998,
 3026,3026,2998,3025,3025,3026,3025,3025,3025,3025,3026,3134,
 2923,3095,3095,2923,3095,3095,2823,2823,3095,3095,3100,1,3100,
 1,1,2823,1,1,2923,3095,2823,3095,1,3100,1,3100,2823,2823,
 3244,3244,1,1,1,3009,3006,3006,3009,2987,2987,3006,3006,2987,
 3006,2987,3006,2855,3028,3028,2855,3028,3028,2824,2824,3028,
 3028,3007,3243,3007,3201,3201,2824,1,1,2855,3028,2824,3028,1,
 3007,3243,3007,2824,2824,3243,3243,1,1,1,2912,2902,2902,2912,
 2902,2902,2902,2912,2902,2912,2902,2902,3077,3077,2825,3077,
 3077,2823,2823,3077,3077,3077,3201,3077,3201,3201,2823,1,1,
 2825,3077,2823,3077,1,3077,3201,3077,2823,2823,3201,3201,1,1,
 1,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,
 3077,3077,3077,3077,2823,2823,3265,3265,3265,3286,3265,1,1,1,
 1,1,3077,3265,1,3265,1,3265,3286,3265,1,1,1,1,1,1,1,2823,
 2823,2823,2823,3268,2823,2823,3268,3268,3268,2823,2823,3077,
 3077,3077,2823,2823,3265,3265,3265,3286,3265,1,1,1,1,1,3077,
 3265,1,3265,1,3265,3286,3265,1,1,1,1,1,1,1,2823,2823,2823,
 2823,3268,2823,2823,3268,3268,3268,2823,2823,3077,3077,2823,
 2823,3077,3077,3077,3201,3077,3201,3201,2823,1,1,2825,3077,
 2823,3077,1,3077,3201,3077,2823,2823,3201,3201,1,1,1,2999,
 2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,3077,
 2823,2823,3265,3265,3265,3286,3265,1,1,1,1,1,3077,3265,1,
 3265,1,3265,3286,3265,1,1,1,1,1,1,1,2823,2823,2823,2823,
 3268,2823,2823,3268,3268,3268,2823,2823,2823,2823,3265,3265,
 3265,3286,3265,1,1,1,1,1,3077,3265,1,3265,1,3265,3286,3265,
 1,1,1,1,1,1,1,2823,2823,2823,2823,3268,2823,2823,3268,3268,
 3268,2823,2823,2823,1,1,1,1,1,1,1,1,1,1,2823,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,2823,2823,2823,2823,1,2823,2823,1,1,1,
 2823,2823,1,1,1,1,1,1,1,1,1,1,2823,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,2823,2823,2823,2823,1,2823,2823,1,1,1,2823,2823,
 3077,3265,1,3265,1,1,1,1,1,3077,3077,1,3077,1,3265,1,3265,
 2823,2823,3286,3286,1,1,1,3268,2823,2823,3268,2823,2823,3268,
 2823,2823,2823,2823,3268,3265,1,3265,1,1,1,1,1,3077,3077,1,
 3077,1,3265,1,3265,2823,2823,3286,3286,1,1,1,3268,2823,2823,
 3268,2823,2823,3268,2823,2823,2823,2823,3268,1,3077,3286,3286,
 2823,1,1,3077,3265,2823,3265,1,3077,1,3077,1,1,1,1,1,1,1,
 3126,3242,3242,3126,3126,3242,3126,3126,3126,3126,3242,3126,1,
 1,1,1,1,1,3201,1,1,1,1,1,3201,1,1,1,1,1,1,1,1,3200,
 3289,3289,3200,1,3200,3294,1,1,1,3200,3294,3286,3286,2823,1,
 1,3077,3265,2823,3265,1,3077,1,3077,1,1,1,1,1,1,1,3126,
 3242,3242,3126,3126,3242,3126,3126,3126,3126,3242,3126,3201,1,
 1,1,3201,1,1,1,1,3286,1,3286,1,1,1,1,1,1,1,3289,1,1,
 3289,3200,1,3200,3289,3200,3289,1,3200,1,1,1,3201,1,1,1,1,
 3286,1,3286,1,1,1,1,1,1,1,3289,1,1,3289,3200,1,3200,3289,
 3200,3289,1,3200,1,1,2823,1,2823,1,1,2823,1,2823,1,1,1,1,
 1,1,1,2823,1,1,2823,2823,1,2823,2823,2823,2823,1,2823,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,3077,2823,3077,1,3077,3201,3077,2823,2823,3201,3201,1,
 1,1,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,
 2999,1,3077,1,3265,1,3265,2823,2823,3286,3286,1,1,1,3268,
 2823,2823,3268,2823,2823,3268,2823,2823,2823,2823,3268,1,1,
 2823,1,2823,1,1,1,1,1,1,1,2823,1,1,2823,2823,1,2823,2823,
 2823,2823,1,2823,1,3265,1,3265,2823,2823,3286,3286,1,1,1,
 3268,2823,2823,3268,2823,2823,3268,2823,2823,2823,2823,3268,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3077,1,
 1,1,1,1,1,1,3126,3242,3242,3126,3126,3242,3126,3126,3126,
 3126,3242,3126,1,1,1,1,1,1,1,1,3200,3289,3289,3200,1,3200,
 3294,1,1,1,3200,3294,1,1,1,1,1,1,1,3126,3242,3242,3126,
 3126,3242,3126,3126,3126,3126,3242,3126,2823,1,1,1,1,1,1,
 2823,2823,1,2823,2823,1,2823,2823,2823,2823,1,1,1,1,1,1,1,
 2823,2823,1,2823,2823,1,2823,2823,2823,2823,1,3201,1,1,1,1,
 3200,3200,1,3294,3289,1,3200,3294,3200,3289,1,1,1,1,1,3200,
 3200,1,3294,3289,1,3200,3294,3200,3289,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,2823,2823,2999,3126,1,1,1,3126,1,1,1,2999,
 2823,2823,1,1,1,2823,1,1,1,2823,2823,1,1,1,2823,1,1,1,
 3126,1,1,1,3126,1,1,1,1,1,1,2999,1,1,1,2823,2823,1,2823,
 2999,2823,3126,1,3126,2823,2999,1,2999,2823,3126,1,1,1,2823,
 3126,2823,3142,3156,3156,3198,1,3156,3198,1,3293,1,1,3147,
 3147,3187,3147,3187,3276,3147,3187,3276,3199,3143,3143,3143,
 3265,3265,3265,1,1,3143,3265,3265,1,3265,1,1,1,1,1,3143,
 3143,1,3265,1,3265,1,3265,1,1,1,1,1,1,1,3142,3270,3270,
 3270,3142,3270,3142,3270,3270,3142,3270,3270,3156,3156,3198,1,
 3156,3198,1,3293,1,1,3147,3147,3187,3147,3187,3276,3147,3187,
 3276,3199,3143,3143,3143,3265,3265,3265,1,1,3143,3265,3265,1,
 3265,1,1,1,1,1,3143,3143,1,3265,1,3265,1,3265,1,1,1,1,1,
 1,1,3142,3270,3270,3270,3142,3270,3142,3270,3270,3142,3270,
 3270,2665,2665,2,2981,2757,3274,2757,3196,2,650,650,1015,650,
 1015,998,650,1015,998,869,2278,2665,2665,2501,2451,2451,2654,
 3,2278,2501,2451,3,2451,3,2654,3,2,2,2501,2501,2753,2981,
 3029,2665,2753,2665,2824,2824,3154,3154,2,3180,2,2454,2250,
 2570,2454,2250,2603,2670,2962,2570,2603,2962,2670,2665,2,2665,
 2665,3196,3027,2,2823,650,650,1015,650,1015,998,650,1015,998,
 869,2278,2501,2501,2665,2451,2451,2654,3,2278,2665,2451,3,
 2451,3,2654,3,2,2,2665,2665,2654,2934,3180,2534,2654,2534,
 3154,3154,2824,2824,2,3029,2,2603,2670,2570,2250,2454,2454,
 2250,2570,2962,2670,2962,2603,2,2757,3236,2,2757,1,1,2064,
 2064,2083,2064,2083,2187,2064,2083,2187,2125,2655,2723,2723,
 2723,2817,2817,2,2,2655,2723,2817,2,2817,2,2,2,2,2,3164,
 3164,3212,3202,3250,3164,3212,3164,3280,3280,3246,3246,1,1,1,
 2,2,2731,2782,2782,2,2,3209,3209,2677,2743,2677,2823,1,1,
 3029,1,1,1478,1477,1478,1478,1478,1979,1478,1478,1902,1478,
 2477,2,2,2,2477,2477,2,2477,2477,2,2477,2477,2477,2477,2,
 2477,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2477,2477,2,2,
 2,2477,2477,1,1,2823,3142,2823,2665,2,2757,2,2823,650,650,
 1015,650,1015,998,650,1015,998,869,2278,2665,2665,2501,2451,
 2451,2753,3,2278,2501,2451,3,2451,3,2753,3,2,2,2501,2501,
 2654,2981,3029,2665,2654,2665,2824,2824,3154,3154,2,3180,2,
 2670,2603,2962,2670,2603,2250,2454,2570,2962,2250,2570,2454,1,
 2757,2,2,2064,2064,2083,2064,2083,2187,2064,2083,2187,2125,
 2655,3164,3164,3164,2752,2752,3212,2,2655,3164,2752,2,2752,2,
 3212,2,1,1,2723,2723,2,3202,1,2817,2,2817,3246,3246,3246,
 3246,2,3250,2,2677,2677,3209,2,2,2782,2782,2731,2743,2,3209,
 2,2,1,1,2170,2169,2061,2138,2240,2182,2076,2183,4,2061,2706,
 2653,2653,2,2,2,2,2,2706,2,2,2,2,2,2,2,2,2,1,1,3189,1,
 1,1,3189,1,1,1,1,1,1,1,1,2653,2,3283,3284,3285,2,2810,1,
 1,2,2,2,1,2,892,892,1000,892,1000,724,892,1000,724,1004,
 2320,2651,2651,2757,2392,2392,2767,2250,2320,2757,2392,2250,
 2392,2250,2767,2250,2,2,2757,2757,2767,2934,3229,2651,2767,
 2651,3195,3195,3135,3135,2,3029,2,2250,2427,3040,2477,2477,
 2477,2477,3040,2652,2427,2652,2250,1,2138,2076,2183,2140,2179,
 2181,2170,2248,4,2168,2706,1,1,1,2,2,3189,2,2706,1,2,2,2,
 2,3189,2,1,1,2653,2653,2,1,1,2,2,2,1,1,1,1,2,1,2,3285,
 3284,1,2,2811,2,2,2,3283,2653,1,2,1478,1478,1478,1478,1477,
 1823,1478,1478,1823,1477,2477,1,1,1,2477,2477,1,2477,2477,1,
 2477,2477,2477,2477,1,2477,1,1,2,2,2,1,1,2,2,2,1,1,1,1,
 2,1,2,2,2,1,2477,2477,2823,2823,3142,2,2477,1,2477,2331,
 2331,2497,2430,2430,2497,2550,2369,2369,1490,1647,1647,1647,
 2188,2188,2128,4,1490,1647,2188,4,2188,4,2128,4,4,4,1647,
 1647,2148,2895,2939,1661,2148,1661,2913,2913,2918,2918,4,3033,
 4,928,947,1486,928,923,924,933,1482,1482,924,1482,947,2331,
 2331,2331,2524,2497,2430,2430,2559,1490,1647,1647,1647,2188,
 2188,2063,4,1490,1647,2188,4,2188,4,2063,4,4,4,1647,1647,
 2148,2895,2942,1661,2148,1661,2921,2921,2918,2918,4,2942,4,
 947,928,1480,933,933,947,928,1482,1486,923,1486,928,2430,2745,
 2430,2550,2457,2631,2457,1706,1988,1988,1988,2204,2204,2162,4,
 1706,1988,2204,4,2204,4,2162,4,4,4,1988,1988,2172,2925,2969,
 2003,2172,2003,3110,3110,3060,3060,4,2952,4,1261,1261,1678,
 1235,1241,1268,1235,1531,1602,1248,1602,1261,2331,2430,2331,
 2331,2524,2559,1490,1647,1647,1647,2188,2188,2128,4,1490,1647,
 2188,4,2188,4,2128,4,4,4,1647,1647,2128,2895,3033,1661,2128,
 1661,2918,2918,2921,2921,4,2939,4,924,933,1486,923,928,928,
 947,1486,1480,933,1480,933,2430,2430,2745,2430,2656,1706,1988,
 1988,1988,2204,2204,2162,4,1706,1988,2204,4,2204,4,2162,4,4,
 4,1988,1988,2197,2925,2952,2003,2197,2003,3069,3069,3069,3069,
 4,2969,4,1268,1235,1678,1241,1235,1261,1261,1602,1678,1241,
 1678,1235,2369,2631,2520,2369,1691,2045,2045,2045,2044,2044,
 2175,1477,1691,2045,2044,1477,2044,1477,2175,1477,4,4,2045,
 2045,2175,2894,2974,2030,2175,2030,3064,3064,3105,3105,4,2974,
 4,992,990,1529,1003,1003,992,990,1648,1579,1002,1579,990,2331,
 2430,2369,1490,1647,1647,1647,2188,2188,2148,4,1490,1647,2188,
 4,2188,4,2148,4,4,4,1647,1647,2063,2895,2942,1661,2063,1661,
 2918,2918,2913,2913,4,2939,4,923,923,1482,924,947,933,924,
 1480,1486,928,1486,923,2430,2457,1706,1988,1988,1988,2204,2204,
 2197,4,1706,1988,2204,4,2204,4,2197,4,4,4,1988,1988,2162,
 2925,2952,2003,2162,2003,3060,3060,3110,3110,4,3102,4,1248,
 1241,1602,1248,1261,1235,1268,1678,1678,1235,1678,1241,2369,
 1691,2045,2045,2045,2044,2044,2213,1477,1691,2045,2044,1477,
 2044,1477,2213,1477,4,4,2045,2045,2213,2894,3081,2030,2213,
 2030,3105,3105,3064,3064,4,2948,4,979,1003,1579,1002,990,990,
 992,1579,1529,1003,1529,1003,1621,1910,1910,1910,2210,2210,
 2172,4,1621,1910,2210,4,2210,4,2172,4,4,4,1910,1910,2180,
 2931,2937,1787,2180,1787,2965,2965,2965,2965,4,2952,4,1142,
 1068,1493,1194,1068,1148,1148,1536,1493,1194,1493,1068,2536,
 2536,2536,2731,2731,2654,2,2478,2536,2731,2,2731,2,2654,2,2,
 2,2536,2536,2654,2825,3030,2536,2654,2536,3029,3029,3029,3029,
 2,3030,2,2350,2350,2483,2350,2350,2350,2350,2483,2483,2350,
 2483,2350,2536,2771,2771,2771,2,2,2536,2771,2771,2,2771,2,2,
 2,2,2,3143,3143,3161,3077,3171,3077,3161,3077,3171,3171,2823,
 2823,1,1,1,2477,2774,2603,2603,2670,2774,2477,3047,3047,2670,
 2603,2603,2771,2771,2771,2,2,2536,2771,2771,2,2771,2,2,2,2,
 2,3143,3143,3161,3077,3171,3077,3161,3077,3171,3171,2823,2823,
 1,1,1,2477,2774,2603,2603,2670,2774,2477,3047,3047,2670,2603,
 2603,2771,2771,2,2,2536,2536,2771,2,2771,2,2,2,2,2,3077,
 3077,3161,3077,3171,3143,3161,3143,2823,2823,3171,3171,1,1,1,
 2774,2477,2603,2670,2603,2477,2774,3047,3047,2603,2603,2670,
 2731,2789,2,2731,2771,2731,2,2731,2,2789,2,2,2,2771,2771,
 2789,3077,3126,2771,2789,2771,3246,3246,3246,3246,2,3126,2,
 2450,2450,2616,3,3,2450,2450,2605,2605,3,2616,3,2789,2,2731,
 2771,2731,2,2731,2,2789,2,2,2,2771,2771,2789,3077,3126,2771,
 2789,2771,3246,3246,3246,3246,2,3126,2,2450,2450,2616,3,3,
 2450,2450,2605,2605,3,2616,3,2,2654,2,2789,2,2789,2,2653,2,
 2,2,3161,3161,3200,3200,3247,3161,3200,3161,1,1,1,1,1,1,1,
 2798,2653,2739,2699,2699,2798,2653,3163,3163,2699,2739,2699,2,
 2,2,2,2,2,2,2,2,2,2,2,2,2823,2823,2,2,2,1,1,1,1,2,
 2823,2,3,3,2477,3,3,3,3,2477,2477,3,2477,3,2536,2731,2,
 2731,2,2654,2,2,2,2536,2536,2654,2825,3030,2536,2654,2536,
 3029,3029,3029,3029,2,3030,2,2350,2350,2483,2350,2350,2350,
 2350,2483,2483,2350,2483,2350,2771,2,2771,2,2,2,2,2,3077,
 3077,3161,3077,3171,3143,3161,3143,2823,2823,3171,3171,1,1,1,
 2774,2477,2603,2670,2603,2477,2774,3047,3047,2603,2603,2670,2,
 2731,2,2789,2,2,2,2771,2771,2789,3077,3126,2771,2789,2771,
 3246,3246,3246,3246,2,3126,2,2450,2450,2616,3,3,2450,2450,
 2605,2605,3,2616,3,2,2,2,2,2,2,2,2,2,2823,2823,2,2,2,1,
 1,1,1,2,2823,2,3,3,2477,3,3,3,3,2477,2477,3,2477,3,2,
 2789,2,2,2,2771,2771,2789,3077,3126,2771,2789,2771,3246,3246,
 3246,3246,2,3126,2,2450,2450,2616,3,3,2450,2450,2605,2605,3,
 2616,3,2,2,2,2,2,2,2,2823,2823,2,2,2,1,1,1,1,2,2823,2,
 3,3,2477,3,3,3,3,2477,2477,3,2477,3,2,2,2,3161,3161,3200,
 3200,3247,3161,3200,3161,1,1,1,1,1,1,1,2798,2653,2739,2699,
 2699,2798,2653,3163,3163,2699,2739,2699,2,2,2,2,2,2823,2823,
 2,2,2,1,1,1,1,2,2823,2,3,3,2477,3,3,3,3,2477,2477,3,
 2477,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,
 2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,
 2,2,2,1,1,2,2,2,2536,2,3077,1,2771,2,2771,2823,2823,3171,
 3171,2,3171,2,2670,2603,3047,2774,2477,2603,2670,2603,2603,
 2477,3047,2774,2,3077,1,2771,2,2771,2823,2823,3171,3171,2,
 3171,2,2670,2603,3047,2774,2477,2603,2670,2603,2603,2477,3047,
 2774,3200,1,2,2653,2,1,1,1,1,2,3247,2,2699,2699,3163,2653,
 2798,2699,2699,2739,2739,2653,3163,2814,1,3077,3200,3077,3126,
 3126,3126,3126,1,1,1,2999,2999,2999,2999,2999,2999,2999,2999,
 2999,2999,2999,2999,1,1,1,1,1,1,1,1,1,1,3067,3067,3177,
 3114,3029,3067,3067,1,1,3029,3176,3116,2,2536,3171,3171,2823,
 2823,2,3171,2,2603,2670,3041,2615,2730,2670,2603,2603,2603,
 2730,3041,2615,2,1,1,1,1,2,3247,2,2699,2699,3163,2653,2798,
 2699,2699,2739,2739,2653,3163,2814,3171,3171,2823,2823,2,3171,
 2,2603,2670,3041,2615,2730,2670,2603,2603,2603,2730,3041,2615,
 3029,3246,3246,1,1,1,3185,3123,3117,3185,3125,3121,3178,3029,
 3117,3121,3029,3178,3246,3246,1,1,1,3185,3123,3117,3185,3125,
 3121,3178,3029,3117,3121,3029,3178,3029,1,1,1,3125,3193,3029,
 3121,3178,3178,3121,3029,3117,3185,3117,3125,1,1,1,3125,3193,
 3029,3121,3178,3178,3121,3029,3117,3185,3117,3125,1,2,2,2,1,
 2,2,2,2,2,2,2,1,2,1,3029,3114,1,3067,3067,3115,3029,3175,
 3177,3067,1,3067,2,2,1,2,2,2,2,2,2,2,1,2,2450,2558,2454,
 2419,2,2,3053,2603,2419,2527,2250,2530,2417,2250,2,2,3053,
 2603,2427,2556,2418,2603,2603,2558,2530,3035,3036,3053,3209,
 3053,3,2419,2250,2527,2557,2,3053,2,2454,2417,2558,2530,2,
 3053,2,2450,2603,3053,2250,2530,2417,2603,3053,2419,2558,2454,
 3209,2530,3036,2557,2556,3036,2529,2603,3,2603,3156,3156,3198,
 1,3156,3198,1,3293,1,1,3147,3147,3187,3147,3187,3276,3147,
 3187,3276,3199,3143,3143,3143,3265,3265,3265,1,1,3143,3265,
 3265,1,3265,1,1,1,1,1,3143,3143,1,3265,1,3265,1,3265,1,1,
 1,1,1,1,1,3142,3270,3270,3270,3142,3270,3142,3270,3270,3142,
 3270,3270,2665,2665,2,2981,2757,2823,2757,2823,2,650,650,1015,
 650,1015,998,650,1015,998,869,2501,2278,2501,2501,2501,2981,
 2824,2824,2665,2451,2451,3154,2665,2753,3,2654,3180,2,2278,
 2665,3,2451,2,2451,3154,2665,3,2753,3,2654,2,2,3029,2250,
 2570,2250,2570,2454,2962,2603,2670,2454,2670,2603,2962,2665,2,
 2665,2665,2823,3027,2,3196,650,650,1015,650,1015,998,650,1015,
 998,869,2665,2278,2665,2665,2665,2934,3154,3154,2501,2451,2451,
 2824,2534,2654,3,2654,3029,2,2278,2501,3,2451,2,2451,2824,
 2534,3,2654,3,2654,2,2,3180,2670,2962,2454,2570,2250,2570,
 2454,2250,2603,2603,2670,2962,2,2757,3236,2,2757,1,1,2064,
 2064,2083,2064,2083,2187,2064,2083,2187,2125,2723,2655,2723,
 3164,3164,3202,3246,3246,3164,2752,2752,3246,2817,3212,2,2,
 3250,2,2655,3164,2,2752,2,2752,3246,2817,2,3212,2,2,1,1,1,
 2,3209,2782,2731,2782,3209,2,2,2,2677,2677,2743,3196,1,1,1,
 1,1,2170,2140,2248,2076,2179,4,2138,2183,2181,2168,2653,2706,
 2653,1,1,1,1,1,1,2,2,1,2,3189,2,2,1,2,2706,1,2,2,2,2,
 1,2,2,3189,2,2,1,1,1,2653,1,2,2,2,1,2811,2,2,3285,3284,
 3283,2665,2,2757,2,3274,650,650,1015,650,1015,998,650,1015,
 998,869,2501,2278,2501,2501,2501,2981,2824,2824,2665,2451,2451,
 3154,2665,2654,3,2753,3180,2,2278,2665,3,2451,2,2451,3154,
 2665,3,2654,3,2753,2,2,3029,2603,2962,2603,2962,2670,2570,
 2250,2454,2670,2454,2250,2570,1,2757,2,2,2064,2064,2083,2064,
 2083,2187,2064,2083,2187,2125,3164,2655,3164,2723,2723,3202,
 3280,3280,2723,2817,2817,3246,3164,2,2,3212,1,1,2655,2723,2,
 2817,1,2817,3246,3164,2,2,2,3212,2,2,3250,2677,2743,2,3209,
 2,2731,2782,2782,2677,2,2,3209,2,1,1,1478,1478,1478,1478,
 1477,1823,1478,1478,1823,1477,2,2477,2,1,1,1,1,1,1,2477,
 2477,1,2,1,2477,2,1,2,2477,1,2477,2477,2,2477,1,2,2477,1,
 2477,2,1,1,1,2477,1,2823,3142,2823,1,2477,2477,2477,2,2,2,
 3029,2,892,892,1000,892,1000,724,892,1000,724,1004,2757,2320,
 2757,2757,2757,2934,3195,3195,2651,2392,2392,3135,2651,2767,
 2250,2767,3029,2,2320,2651,2250,2392,2,2392,3135,2651,2250,
 2767,2250,2767,2,2,3229,2427,2652,2477,3040,2477,3040,2477,
 2477,2250,2250,2427,2652,1,1478,1478,1478,1477,1478,1902,1478,
 1478,1979,1478,1,2477,1,2,2,1,1,1,2,2477,2477,1,1,2,2477,
 1,1,1,2477,2,2477,2477,1,2477,1,1,2477,2,2477,1,2,2,1,
 2823,3142,2477,1,2477,2,2,2,2823,2477,2477,1,2076,2138,2183,
 2169,2240,4,2170,2061,2182,2061,1,2706,1,2,2,1,1,1,2653,2,
 2,1,1,2,2,3189,1,1,2706,2653,2,2,1,2,1,1,2,2,2,3189,2,
 2,1,2,2,2,1,2810,3283,3285,3284,2,2653,2,1,2331,2331,2497,
 2430,2430,2497,2550,2369,2369,1647,1490,1647,1647,1647,2895,
 2918,2918,1647,2188,2188,2913,1661,2148,4,2063,2939,4,1490,
 1647,4,2188,4,2188,2913,1661,4,2148,4,2063,4,4,2942,928,
 1486,933,1480,924,1482,947,924,923,923,923,1486,2331,2331,
 2331,2524,2497,2430,2430,2559,1647,1490,1647,1647,1647,2895,
 2918,2918,1647,2188,2188,2921,1661,2128,4,2128,2939,4,1490,
 1647,4,2188,4,2188,2921,1661,4,2128,4,2128,4,4,3033,933,
 1480,928,1486,947,1486,928,923,933,924,933,1480,2430,2745,
 2430,2550,2457,2631,2457,1988,1706,1988,1988,1988,2925,3060,
 3060,1988,2204,2204,3110,2003,2197,4,2162,3102,4,1706,1988,4,
 2204,4,2204,3110,2003,4,2197,4,2162,4,4,2952,1235,1678,1235,
 1678,1268,1602,1261,1248,1241,1248,1241,1678,2331,2430,2331,
 2331,2524,2559,1647,1490,1647,1647,1647,2895,2921,2921,1647,
 2188,2188,2918,1661,2063,4,2148,2942,4,1490,1647,4,2188,4,
 2188,2918,1661,4,2063,4,2148,4,4,2942,923,1486,947,1482,928,
 1480,933,933,928,947,928,1486,2430,2430,2745,2430,2656,1988,
 1706,1988,1988,1988,2925,3069,3069,1988,2204,2204,3069,2003,
 2162,4,2197,2969,4,1706,1988,4,2204,4,2204,3069,2003,4,2162,
 4,2197,4,4,2952,1241,1678,1261,1602,1261,1678,1235,1241,1235,
 1268,1235,1678,2369,2631,2520,2369,2045,1691,2045,2045,2045,
 2894,3105,3105,2045,2044,2044,3064,2030,2213,1477,2213,2948,4,
 1691,2045,1477,2044,4,2044,3064,2030,1477,2213,1477,2213,4,4,
 3081,1003,1529,990,1579,992,1579,990,1002,1003,979,1003,1529,
 2331,2430,2369,1647,1490,1647,1647,1647,2895,2913,2913,1647,
 2188,2188,2918,1661,2128,4,2148,3033,4,1490,1647,4,2188,4,
 2188,2918,1661,4,2128,4,2148,4,4,2939,924,1482,924,1482,933,
 1486,923,928,947,928,947,1482,2430,2457,1988,1706,1988,1988,
 1988,2925,3110,3110,1988,2204,2204,3060,2003,2162,4,2172,2952,
 4,1706,1988,4,2204,4,2204,3060,2003,4,2162,4,2172,4,4,2969,
 1248,1602,1268,1531,1235,1678,1241,1235,1261,1261,1261,1602,
 2369,2045,1691,2045,2045,2045,2894,3064,3064,2045,2044,2044,
 3105,2030,2175,1477,2175,2974,4,1691,2045,1477,2044,4,2044,
 3105,2030,1477,2175,1477,2175,4,4,2974,1002,1579,992,1648,990,
 1529,1003,1003,990,992,990,1579,1910,1621,1910,1910,1910,2931,
 2965,2965,1910,2210,2210,2965,1787,2172,4,2180,2952,4,1621,
 1910,4,2210,4,2210,2965,1787,4,2172,4,2180,4,4,2937,1194,
 1493,1148,1536,1148,1493,1068,1194,1068,1142,1068,1493,2536,
 2536,3077,3077,3077,2823,2823,3143,2771,2771,3171,2771,3161,2,
 2,3171,2,2536,3143,2,2771,2,2771,3171,2771,2,3161,2,2,1,1,
 1,2477,3047,2603,2603,2670,3047,2477,2774,2774,2670,2603,2603,
 2536,2536,2536,2825,3029,3029,2536,2731,2731,3029,2536,2654,2,
 2654,3030,2,2478,2536,2,2731,2,2731,3029,2536,2,2654,2,2654,
 2,2,3030,2350,2483,2350,2483,2350,2483,2350,2350,2350,2350,
 2350,2483,3077,3077,3077,2823,2823,3143,2771,2771,3171,2771,
 3161,2,2,3171,2,2536,3143,2,2771,2,2771,3171,2771,2,3161,2,
 2,1,1,1,2477,3047,2603,2603,2670,3047,2477,2774,2774,2670,
 2603,2603,2536,3077,2823,2823,2771,2771,2771,3171,3143,2,2,
 3161,1,1,2536,2771,2,2771,1,2771,3171,3143,2,2,2,3161,2,2,
 3171,2603,2603,2477,3047,2774,2603,2603,2670,2670,2774,2477,
 3047,3077,2823,2823,2771,2771,2771,3171,3143,2,2,3161,1,1,
 2536,2771,2,2771,1,2771,3171,3143,2,2,2,3161,2,2,3171,2603,
 2603,2477,3047,2774,2603,2603,2670,2670,2774,2477,3047,3126,
 3126,3077,3077,3077,3126,3077,3200,2823,3200,1,1,2825,3077,
 2823,3077,1,3077,3126,3077,2823,3200,2823,3200,1,1,1,2999,
 2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,3029,
 3171,3246,3246,3246,3171,1,1,1,1,1,3029,3171,1,3246,1,3246,
 3246,3171,1,1,1,1,1,1,1,3121,3029,3121,3029,3178,3117,3125,
 3185,3178,3185,3123,3117,3171,3246,3246,3246,3171,1,1,1,1,1,
 3029,3171,1,3246,1,3246,3246,3171,1,1,1,1,1,1,1,3121,3029,
 3121,3029,3178,3117,3125,3185,3178,3185,3123,3117,2771,2771,
 2823,3077,2,2,3161,1,1,2536,2536,2,2771,1,2771,2823,3077,2,
 2,2,3161,2,2,3171,2670,2603,2774,3047,2477,2603,2670,2603,
 2603,2477,2774,3047,2731,3246,2771,2789,2,2789,3126,2,2731,
 2771,2,2731,2,2731,3246,2771,2,2789,2,2789,2,2,3126,3,2616,
 2450,2605,2450,2616,3,3,3,2450,2450,2605,3246,2771,2789,2,
 2789,3126,2,2731,2771,2,2731,2,2731,3246,2771,2,2789,2,2789,
 2,2,3126,3,2616,2450,2605,2450,2616,3,3,3,2450,2450,2605,
 2823,1,1,1,1,1,3029,2823,1,3246,1,3246,3029,2823,1,1,1,1,
 1,1,1,3185,3117,3178,3029,3121,3029,3178,3121,3125,3125,3193,
 3117,3161,2,2,3171,2,2536,3077,2,2771,2,2771,2823,2536,2,
 3161,2,2,1,1,1,2730,3041,2670,2603,2603,3041,2730,2615,2615,
 2603,2670,2603,2,3200,1,1,2654,2,2,2789,1,2789,1,3161,2,
 2653,2,3200,2,2,3247,2699,2739,2798,3163,2653,2739,2699,2699,
 2699,2798,2653,3163,2,2823,2,2,2,2,2,2,2,1,2,2,2,2,2,2,
 2,2823,3,2477,3,2477,3,2477,3,3,3,3,3,2477,3247,2,2654,
 3161,2,2789,2,2789,1,2,2,3200,2,2653,1,1,1,2653,3163,2699,
 2739,2699,3163,2798,2653,2814,2699,2699,2739,1,3030,1,2823,
 3126,1,3126,1,3171,2823,1,2823,3247,1,1,1,3067,1,3115,3175,
 3029,1,3067,3067,3067,3029,3114,3177,2,1,2,2,2,2,1,2,2,1,
 2,2,1,1,1,2,1,2,2,2,1,2,2,2,2,2,2,2536,2,2731,2,2731,
 3029,2536,2,2654,2,2654,2,2,3030,2350,2483,2350,2483,2350,
 2483,2350,2350,2350,2350,2350,2483,2,2771,1,2771,2823,3077,2,
 2,2,3161,2,2,3171,2670,2603,2774,3047,2477,2603,2670,2603,
 2603,2477,2774,3047,2,2,2,1,2,2,2,2,2,2,2,2823,3,2477,3,
 2477,3,2477,3,3,3,3,3,2477,2,2731,3246,2771,2,2789,2,2789,
 2,2,3126,3,2616,2450,2605,2450,2616,3,3,3,2450,2450,2605,2,
 1,2,2,1,2,2,1,1,1,2,1,2,2,2,1,2,2,2,2,2,2,3246,2771,
 2,2789,2,2789,2,2,3126,3,2616,2450,2605,2450,2616,3,3,3,
 2450,2450,2605,2823,1,1,1,1,1,1,1,3185,3117,3178,3029,3121,
 3029,3178,3121,3125,3125,3193,3117,2,3161,2,2,1,1,1,2730,
 3041,2670,2603,2603,3041,2730,2615,2615,2603,2670,2603,2,2,2,
 2,2,2823,3,2477,3,2477,3,2477,3,3,3,3,3,2477,2,3200,2,2,
 3247,2699,2739,2798,3163,2653,2739,2699,2699,2699,2798,2653,
 3163,2,2,2,2823,3,2477,3,2477,3,2477,3,3,3,3,3,2477,1,1,
 1,2653,3163,2699,2739,2699,3163,2798,2653,2814,2699,2699,2739,
 2,1,2,2,2,1,2,2,2,2,2,2,2,1,1,2,2,2,1,2,2,2,2,2,2,
 2,1,3029,3176,3067,1,3067,3177,3029,3114,3116,3067,3067,1,
 2603,2250,2530,2419,3053,2,2,3,2419,2427,2556,2530,3036,2558,
 3209,3053,3053,2603,2527,2556,3036,2603,2450,2558,2454,2419,
 2417,2,2,3053,2603,3035,2558,2527,2557,3053,3053,3209,2530,
 2417,2250,2454,2,2,3053,2603,2603,3053,2558,2530,3036,3,2,
 2419,2250,2530,2,2454,2417,2557,2250,2418,2529,2450,2603,2603,
 2728,2728,2,3266,2757,1,2757,1,2,1308,1308,1327,1308,1327,
 1276,1308,1327,1276,1342,2665,2665,2655,2752,2776,2752,3,2731,
 2665,2776,3092,2804,2776,3263,3257,3257,2,2823,2665,2655,3263,
 2752,2,2776,3,2752,2804,3,2731,3,2823,2,2,2748,3,3,3,2748,
 2756,3063,2756,3,3063,2756,2756,2728,2,2728,2728,1,3141,2,1,
 1308,1308,1327,1308,1327,1276,1308,1327,1276,1342,2665,2665,
 2655,2817,2757,2817,3,2731,2665,2757,3202,2731,2757,3257,3257,
 3257,2,3200,2665,2655,3257,2817,2,2757,3,2817,2731,3,2731,3,
 3200,2,2,3063,2756,3,3,2748,3,2748,3,2756,3063,2756,2756,
 2788,2757,2981,2788,2757,3186,3186,1759,1759,1497,1759,1497,
 1634,1759,1497,1634,1753,3059,3059,2512,2752,3046,2752,2,3153,
 2649,2638,3023,2,2638,3076,3029,3029,2796,3099,2649,2512,3076,
 2752,2796,3046,2,2752,2,2,3153,2,3132,3183,3183,3071,2761,
 2680,2680,2645,2761,3071,2761,2761,2645,2680,2680,1,3186,3186,
 1,1,1,2061,2247,2153,2061,2137,2161,2061,2077,2144,2214,3142,
 3142,2704,2,3217,2,2,3230,2,2806,3236,2,2806,3142,1,1,2,
 3200,2,2704,3142,2,2,3217,2,2,2,2,3230,2,1,1,1,3170,2,2,
 2,2,2,3170,2,2,1,1,1,2728,2,2757,2,1,1308,1308,1327,1308,
 1327,1276,1308,1327,1276,1342,2665,2665,2655,2752,2776,2752,3,
 2804,2665,2776,3092,2731,2776,3257,3263,3263,2,2823,2665,2655,
 3257,2752,2,2776,3,2752,2731,3,2804,3,2823,2,2,3063,2756,
 2756,2756,3063,3,2748,3,2756,2748,3,3,3186,2757,2788,2788,
 1759,1759,1497,1759,1497,1634,1759,1497,1634,1753,2649,2649,
 2512,2752,2638,2752,2,2,3059,3046,3023,3153,3046,3029,3076,
 3076,3183,3132,3059,2512,3029,2752,3183,2638,2,2752,3153,2,2,
 2,3099,2796,2796,2645,2680,2761,2761,3071,2680,2645,2680,2680,
 3071,2761,2761,2,1,1,2061,2246,2154,2061,2116,2152,2061,2077,
 2152,2206,3142,3142,2704,2,3290,2,2,1,2,2806,3236,2,2806,
 3142,1,1,2,3200,2,2704,3142,2,2,3290,2,2,2,2,1,2,1,1,1,
 3170,2,1,1,1,2,3170,2,2,2,2,2,1,2,1278,1278,1189,1278,
 1189,860,1278,1189,860,1307,2776,2776,2362,2362,2776,2362,2250,
 2801,2776,2776,3202,2801,2776,3253,3253,3253,2,3237,2776,2362,
 3253,2362,2,2776,2250,2362,2801,2250,2801,2250,3237,2,2,2774,
 3,2477,2477,3062,2477,3062,2477,3,2774,3,3,3186,2061,2061,
 2077,2247,2137,2144,2061,2153,2161,2214,2,2,2704,2,2806,2,2,
 2,3142,3217,3236,3230,3217,1,3142,3142,1,1,3142,2704,1,2,1,
 2806,2,2,3230,2,2,2,3200,2,2,1,1,2,2,3170,2,2,2,1,3170,
 2,2,2061,2061,2077,2246,2116,2152,2061,2154,2152,2206,2,2,
 2704,2,2806,2,2,2,3142,3290,3236,1,3290,1,3142,3142,1,1,
 3142,2704,1,2,1,2806,2,2,1,2,2,2,3200,2,2,2,2,2,2,3170,
 1,1,1,2,3170,2,2,2416,2416,2676,2369,2369,2676,2583,2447,
 2447,1957,1957,1706,2204,2043,2204,4,2207,1957,2043,2984,2151,
 2043,3073,3068,3068,2061,2930,1957,1706,3073,2204,2061,2043,4,
 2204,2151,4,2207,4,2930,2238,2238,1557,1407,1378,1378,1658,
 1401,1719,1401,1407,1658,1407,1407,2416,2416,2416,2609,2676,
 2369,2369,2702,1957,1957,1706,2204,2043,2204,4,2207,1957,2043,
 2984,2160,2043,3106,3068,3068,2061,2933,1957,1706,3106,2204,
 2061,2043,4,2204,2160,4,2207,4,2933,2238,2238,1719,1378,1378,
 1378,1719,1407,1557,1407,1378,1658,1378,1378,2369,2497,2369,
 2583,2331,2510,2331,1682,1682,1490,2203,1641,2203,4,2063,1682,
 1641,2866,2128,1641,2921,2913,2913,2120,2867,1682,1490,2921,
 2203,2120,1641,4,2203,2128,4,2063,4,2867,2078,2078,1564,1323,
 1368,1368,1521,1322,1564,1322,1323,1491,1323,1323,2416,2369,
 2416,2416,2609,2702,1957,1957,1706,2204,2043,2204,4,2160,1957,
 2043,2984,2207,2043,3068,3106,3106,2238,2933,1957,1706,3068,
 2204,2238,2043,4,2204,2207,4,2160,4,2933,2061,2061,1658,1378,
 1407,1407,1557,1378,1719,1378,1378,1719,1378,1378,2369,2369,
 2497,2369,2550,1682,1682,1490,2203,1641,2203,4,2148,1682,1641,
 2866,2148,1641,2918,2918,2918,2149,2900,1682,1490,2918,2203,
 2149,1641,4,2203,2148,4,2148,4,2900,2149,2149,1521,1368,1323,
 1323,1564,1323,1564,1323,1368,1521,1368,1368,2447,2510,2535,
 2447,1934,1934,1549,2048,1891,2048,1477,2163,1934,1891,2868,
 2163,1891,2976,2978,2978,2144,2906,1934,1549,2976,2048,2144,
 1891,1477,2048,2163,1477,2163,1477,2906,2144,2144,1553,1063,
 1063,1063,1553,1146,1523,1146,1063,1649,1063,1063,2416,2369,
 2447,1957,1957,1706,2204,2043,2204,4,2151,1957,2043,2984,2207,
 2043,3068,3073,3073,2238,2930,1957,1706,3068,2204,2238,2043,4,
 2204,2207,4,2151,4,2930,2061,2061,1658,1407,1401,1401,1719,
 1378,1658,1378,1407,1557,1407,1407,2369,2331,1682,1682,1490,
 2203,1641,2203,4,2128,1682,1641,2866,2063,1641,2913,2921,2921,
 2078,2867,1682,1490,2913,2203,2078,1641,4,2203,2063,4,2128,4,
 2867,2120,2120,1491,1323,1322,1322,1564,1368,1521,1368,1323,
 1564,1323,1323,2447,1934,1934,1549,2048,1891,2048,1477,2163,
 1934,1891,2868,2163,1891,2978,2976,2976,2144,2906,1934,1549,
 2978,2048,2144,1891,1477,2048,2163,1477,2163,1477,2906,2144,
 2144,1649,1063,1146,1146,1523,1063,1553,1063,1063,1553,1063,
 1063,2015,2015,1706,2242,1975,2242,4,2162,2015,1975,2984,2162,
 1975,3091,3091,3091,2159,2988,2015,1706,3091,2242,2159,1975,4,
 2242,2162,4,2162,4,2988,2159,2159,1829,1375,1420,1420,1679,
 1420,1679,1420,1375,1829,1375,1375,2536,2536,2771,2771,2771,2,
 2,3143,3077,3077,3161,3077,3171,2823,2823,3192,2823,3143,2536,
 3171,2771,3192,2771,2,2771,3161,2,2,2,3201,2,2,2477,2416,
 2775,2775,3145,2416,2477,2416,2416,3145,2775,2775,2536,2771,
 2771,2771,2,2,3143,3077,3077,3161,3077,3171,2823,2823,3192,
 2823,3143,2536,3171,2771,3192,2771,2,2771,3161,2,2,2,3201,2,
 2,2477,2416,2775,2775,3145,2416,2477,2416,2416,3145,2775,2775,
 2731,2536,2731,2,2654,2536,2536,2825,2654,2536,3029,3029,3029,
 2714,2980,2536,2478,3029,2731,2714,2536,2,2731,2654,2,2654,2,
 2980,2714,2714,2278,2408,2408,2408,2278,2408,2278,2408,2408,
 2278,2408,2408,2771,2731,2,2789,2771,2771,3077,2789,2771,3246,
 3246,3246,2,3126,2771,2731,3246,2731,2,2771,2,2731,2789,2,
 2789,2,3126,2,2,2616,3,3,3,2616,3,2616,3,3,2616,3,3,2771,
 2,2,3077,3143,3077,3161,3143,2823,3171,3171,3236,3236,3077,
 2536,2823,2771,3236,2536,2,2771,3161,2,2,2,3126,2812,2812,
 2745,2745,2780,2780,3086,2745,2745,2745,2745,3086,2780,2780,2,
 2789,2771,2771,3077,2789,2771,3246,3246,3246,2,3126,2771,2731,
 3246,2731,2,2771,2,2731,2789,2,2789,2,3126,2,2,2616,3,3,3,
 2616,3,2616,3,3,2616,3,3,2,2,2,2823,2,2,1,1,1,2,2823,2,
 2,1,2,2,2,2,2,2,2,2,2,2823,2,2,2477,3,3,3,2477,3,2477,
 3,3,2477,3,3,3161,3161,3200,3200,3161,1,1,1,3239,3200,3161,
 2654,1,2789,3239,2,2,2789,3200,2,2653,2,3230,2,2,2758,2753,
 2,2,3202,2753,2758,2753,2753,3172,2813,2813,2771,3077,2,2771,
 2823,3171,3171,2,3201,2536,2536,2823,2771,2,3077,2,2771,2,2,
 3161,2,2823,3192,3192,3145,2775,2416,2416,2477,2775,3145,2775,
 2775,2477,2416,2416,3077,2,2536,3171,2823,2823,2812,3126,2771,
 2536,3171,2771,2812,3143,2,2771,2,2,3161,2,3236,3236,3236,
 3086,2780,2745,2745,2745,2780,3086,2780,2780,2745,2745,2745,
 3200,3077,3126,3126,3126,3230,2823,3077,2825,3126,3077,3230,
 3077,2823,3077,3200,2823,3200,2823,2823,3230,3230,3084,3079,
 3079,3079,3084,3079,3084,3079,3079,3084,3079,3079,2,1,1,1,2,
 3230,2,2654,1,2789,2,3161,2,2789,2653,2,3200,2,3200,3239,
 3239,3172,2813,2753,2753,2758,2,3202,2,2813,2758,2753,2753,
 3171,2823,2823,2812,3126,2771,2536,3171,2771,2812,3143,2,2771,
 2,2,3161,2,3236,3236,3236,3086,2780,2745,2745,2745,2780,3086,
 2780,2780,2745,2745,2745,3246,3246,3292,3275,2823,3029,3029,
 3246,3292,2823,1,3246,1,1,1,1,2823,3282,3282,3174,3248,3252,
 3252,2823,3248,3174,3248,3248,2823,3252,3252,3029,3282,2823,
 3171,3029,3246,3246,3282,3171,1,3246,1,1,1,1,3275,3292,3292,
 2823,3252,3248,3248,3174,3252,2823,3252,3252,3174,3248,3248,
 3282,2823,3171,3029,3246,3246,3282,3171,1,3246,1,1,1,1,3275,
 3292,3292,2823,3252,3248,3248,3174,3252,2823,3252,3252,3174,
 3248,3248,3236,2,2714,3292,2,2714,3236,2,2,2,2,3239,2,1,1,
 1,3167,2,2,2,2,2,3167,2,2,2,2,2,3201,2980,3275,3126,3236,
 3236,2823,3126,3230,2823,3200,2823,1,1,1,2823,3093,2823,2823,
 3213,3093,2823,3093,3093,3213,2823,2823,2536,2823,2771,2,3077,
 2,2771,2,2,3161,2,2823,3192,3192,3145,2775,2416,2416,2477,
 2775,3145,2775,2775,2477,2416,2416,3029,2731,2714,2536,2,2731,
 2654,2,2654,2,2980,2714,2714,2278,2408,2408,2408,2278,2408,
 2278,2408,2408,2278,2408,2408,3246,3292,2823,1,3246,1,1,1,1,
 2823,3282,3282,3174,3248,3252,3252,2823,3248,3174,3248,3248,
 2823,3252,3252,2,2771,2,2731,2789,2,2789,2,3126,2,2,2616,3,
 3,3,2616,3,2616,3,3,2616,3,3,3236,2,2,2,2,3239,2,1,1,1,
 3167,2,2,2,2,2,3167,2,2,2,2,2,2,2771,3161,2,2,2,3126,
 2812,2812,2745,2745,2780,2780,3086,2745,2745,2745,2745,3086,
 2780,2780,2,2,2,2,2,2823,2,2,2477,3,3,3,2477,3,2477,3,3,
 2477,3,3,2789,2,2789,2,3126,2,2,2616,3,3,3,2616,3,2616,3,
 3,2616,3,3,2,3200,2,3200,3239,3239,3172,2813,2753,2753,2758,
 2,3202,2,2813,2758,2753,2753,2,2,2823,2,2,2477,3,3,3,2477,
 3,2477,3,3,2477,3,3,2,3230,2,2,2758,2753,2,2,3202,2753,
 2758,2753,2753,3172,2813,2813,2823,2,2,2477,3,3,3,2477,3,
 2477,3,3,2477,3,3,3236,3236,3213,2823,3093,3093,2823,2823,
 3213,2823,2823,2823,3093,3093,2714,2,2,2,2,3167,2,2,2,2,
 3167,2,2,2,2,2,2,3167,2,2,2,2,3167,2,2,2745,2617,2617,
 3144,3060,3071,3060,2745,3144,2617,2617,3,3,2617,2761,3060,
 2761,2408,2617,3,3,2408,2745,3,2617,3,3,3060,2761,2761,2745,
 3,2617,3,3,3060,2761,2761,2617,3144,2617,2617,3071,3060,3060,
 2745,2408,2761,2617,3,3,2745,3060,3144,2617,2617,2761,2617,3,
 3,2617,3,3,2745,2745,2408,2653,2,3200,3200,3246,3200,1,1,
 2075,2075,2147,2075,2147,2200,2075,2147,2200,2038,2397,2397,
 2714,2397,2408,2752,3,2581,2397,2714,2752,3,2812,2581,3,3,3,
 3,2397,2408,2747,2752,3,2579,2581,2423,3,2747,2581,3,1,1,1,
 2432,2432,2,2,2,2432,2432,2432,2432,3162,3162,3162,2,3200,
 3200,3246,3200,1,1,2075,2075,2147,2075,2147,2200,2075,2147,
 2200,2038,2397,2397,2714,2397,2408,2752,3,2581,2397,2714,2752,
 3,2812,2581,3,3,3,3,2397,2408,2747,2752,3,2579,2581,2423,3,
 2747,2581,3,1,1,1,2432,2432,2,2,2,2432,2432,2432,2432,3162,
 3162,3162,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1477,3,3,2,3,
 2,3,3,2477,3,2,3,3,2,2477,3,3,3,3,3,2,2,3,3,2477,2477,
 3,3,2,2477,3,1,1,1,3,3,2,2,2,3,3,3,3,1,1,1,3200,1,
 3200,1,1,2851,2851,2983,2851,2983,2983,2851,2983,2983,2910,
 2826,2981,2981,2826,2981,2981,2824,2824,2981,2981,2981,3203,
 2981,3203,3203,2824,1,1,2826,2981,2824,2981,1,2981,3203,2981,
 2824,2824,3203,3203,1,1,1,2999,2999,2999,2999,2999,2999,2999,
 2999,2999,2999,2999,2999,1,2653,3246,2,2147,2147,2124,2147,
 2124,2138,2147,2124,2138,2057,2397,2752,2408,2397,2714,2397,
 2536,2464,2752,2408,2423,2738,2579,2427,2738,2536,1,1,2397,
 2714,2427,2397,1,2812,2427,2752,2712,2427,2427,2738,3,3,3,2,
 2,2432,2432,2432,3162,3162,3162,2,2432,2432,2432,1,1,1,2940,
 2953,2977,2968,3104,3004,2966,2973,2971,3055,3037,2935,3060,
 3037,3029,2935,3029,3030,3107,3060,3089,3119,3056,3168,2823,
 3217,1,1,2936,3122,3019,3070,1,3120,3107,3057,3029,3261,3139,
 3225,1,1,1,3022,3022,3016,3016,3016,3173,3173,3159,3018,1,1,
 1,3246,2,2147,2147,2124,2147,2124,2138,2147,2124,2138,2057,
 2397,2752,2408,2397,2714,2397,2536,2464,2752,2408,2423,2738,
 2579,2427,2738,2536,1,1,2397,2714,2427,2397,1,2812,2427,2752,
 2712,2427,2427,2738,3,3,3,2,2,2432,2432,2432,3162,3162,3162,
 2,2432,2432,2432,1,2953,2940,2977,3039,2973,2970,2966,3020,
 3090,2976,3037,2935,3029,3037,3060,2935,3030,3029,3070,3122,
 3057,2823,3120,3223,2972,3262,1,1,2936,3060,3029,3107,1,3056,
 3131,3089,3019,3227,2823,3246,1,1,1,3016,3016,3022,3022,3018,
 1,1,1,3016,3159,3173,3173,4,4,4,4,4,4,4,4,4,1477,3,3,2,
 3,2,3,2477,3,3,2,3,2,2477,3,2,2477,1,1,3,2,3,3,1,2,3,
 3,2,3,3,2,3,3,3,2,2,3,3,3,1,1,1,2,3,3,3,1443,1443,
 2255,1464,1464,2255,2280,1447,1447,8,81,739,8,739,89,249,200,
 81,739,78,416,676,421,433,200,1309,598,8,739,230,89,598,676,
 412,60,233,233,512,413,1061,1313,598,425,461,432,425,437,625,
 633,619,440,625,619,635,1443,1443,1443,2270,2255,1464,1464,
 2260,8,81,739,8,739,89,200,249,81,739,78,433,676,512,413,
 224,1332,1006,8,739,233,89,1061,676,421,60,230,232,423,511,
 598,1311,1226,432,425,425,461,432,633,610,625,461,619,635,
 610,1464,2399,1464,2280,1474,2330,1474,81,141,1208,81,1208,
 139,374,374,141,1208,106,567,1072,468,473,394,1419,598,81,
 1208,403,139,598,1072,495,92,403,494,486,464,598,1331,598,
 586,594,586,594,587,805,917,712,595,712,836,941,1443,1464,
 1443,1443,2270,2260,8,81,739,8,739,89,224,229,81,739,78,413,
 676,423,511,228,1311,598,8,739,232,89,1226,676,512,60,262,
 231,458,459,1006,1332,1061,437,432,461,440,425,610,635,633,
 425,635,610,633,1464,1464,2399,1464,2290,81,141,1208,81,1208,
 139,394,402,141,1208,106,473,1072,486,464,485,1331,597,81,
 1208,494,139,598,1072,468,92,399,400,474,489,597,1331,598,
 587,586,594,595,586,917,941,805,594,836,941,917,1447,2330,
 2290,1447,74,133,1029,74,1029,97,307,383,133,1029,69,378,930,
 493,385,317,1356,598,74,1029,313,97,1006,930,386,80,314,321,
 392,497,1061,1437,1226,499,469,469,479,499,798,720,919,479,
 904,839,720,1443,1464,1447,8,81,739,8,739,89,228,228,81,739,
 78,511,676,458,459,229,1313,1061,8,739,231,89,598,676,423,
 60,231,262,412,416,598,1309,598,440,437,440,437,461,635,619,
 610,432,610,633,625,1464,1474,81,141,1208,81,1208,139,485,
 390,141,1208,106,464,1072,474,489,390,1331,598,81,1208,400,
 139,598,1072,486,92,404,404,566,492,598,1419,598,588,587,595,
 588,594,941,836,917,586,941,917,805,1447,74,133,1029,74,1029,
 97,317,293,133,1029,69,385,930,392,497,295,1437,1061,74,1029,
 321,97,1226,930,493,80,393,318,371,389,598,1356,1006,501,499,
 479,476,469,720,839,798,469,839,720,798,27,91,972,27,972,94,
 248,258,91,972,77,345,679,352,350,290,1230,1061,27,972,298,
 94,988,679,362,61,259,259,340,353,1061,1230,988,500,443,470,
 475,443,641,646,680,470,671,646,641,2011,2011,2253,2011,2011,
 2322,1477,2278,2278,2011,2334,2011,2394,2394,1477,2659,3,2253,
 2278,2317,2278,2490,2011,2334,2011,2488,2488,2398,2398,2490,
 2659,3,1472,1999,1999,1472,1999,2479,2287,2479,1999,2479,2479,
 2287,2011,2011,2011,2362,2250,2250,2655,2202,2202,2559,2352,
 2434,4,2321,2705,3,2278,2655,2388,2202,2478,2202,2559,2352,
 2388,2434,4,2321,2478,3,2478,5,2156,5,2156,2191,2487,2366,
 2496,2191,2496,2366,2487,2011,2362,2011,1477,2251,2655,2202,
 2352,2379,2202,2584,2433,2433,2393,2250,2278,2655,2567,2202,
 2250,2352,2379,2202,2388,2434,2321,4,2823,2,2,2156,2156,3,3,
 2737,2316,2316,2339,2191,3031,2582,2582,2011,2011,1477,2322,
 2011,2011,2268,2394,2268,2398,2398,2482,3,2490,2253,2011,2488,
 2011,2490,2268,2394,2268,2317,1477,2334,2334,2490,3,2490,1999,
 1472,1472,1999,1999,2287,2479,2479,1999,2479,2287,2479,2011,
 2251,1477,2202,2655,2202,2413,2352,4,2434,2321,2,2,2278,2202,
 2388,2655,2823,2202,2413,2352,2567,2445,2445,2567,2250,2393,
 2250,3,3,2156,2156,2191,2582,2582,3031,2737,2339,2316,2316,
 1477,1477,2202,2655,2352,2239,2202,2433,2584,2433,3,2478,2278,
 2202,2567,2655,2478,2352,2239,2202,2567,2445,2567,2445,2478,
 2705,3,2156,5,2156,5,2191,2366,2487,2496,2191,2496,2487,2366,
 2250,2321,2433,2523,2433,2415,2477,2654,2677,3,2581,2482,2321,
 3005,2433,2581,2523,2433,2415,2620,3,2536,3,2825,2760,2654,
 2353,1477,2216,2217,2368,2250,2512,2560,2368,2913,2539,2539,
 2428,2553,2407,2407,2321,3,2706,3,2753,2654,2482,2428,2620,
 2553,2825,2407,2407,2321,3005,2716,2731,2477,2581,2653,3,2216,
 2217,2353,1477,2368,2539,2539,2913,2368,2560,2531,2250,2011,
 2202,4,2202,4,2321,2428,3,2478,2011,2011,2434,2362,2478,2352,
 2434,2352,2250,2250,2559,2559,3,2705,2478,2191,5,2156,2191,5,
 2366,2496,2487,2156,2366,2487,2496,2202,2433,2202,2321,4,2428,
 2393,2250,2011,2362,2434,2011,2250,2352,2584,2352,1477,2381,
 2379,2379,2,2,2823,2191,2156,3,2737,3,2316,2339,2316,2156,
 2582,2582,3031,2407,2011,2235,2235,1477,2736,3,2011,2352,1477,
 2352,2490,2011,2490,2268,2424,2521,2424,2532,3,2736,2490,1468,
 2059,2059,1956,1468,2491,2378,2486,1956,2378,2491,2486,4,3,
 2477,3,3,2536,2398,2434,2684,2584,2536,2490,2398,2321,2804,
 2718,3008,2477,2,3219,2,2372,2237,2375,1477,4,2427,2589,2597,
 2373,2732,2945,2679,2369,2369,1477,2440,2361,2011,2352,2321,
 2352,2361,2268,2321,2011,2424,2521,2532,2424,2653,3092,2653,
 1956,2059,2650,2427,2427,2348,2319,2319,1956,2571,2954,2571,
 2398,2433,2822,2654,2334,2445,2445,2567,2825,2406,2700,2510,
 2536,2753,2700,3008,3,2784,2581,2237,4,2373,2375,1477,2660,
 2658,2920,2362,2437,2590,2554,2433,2805,3,2334,2567,2445,2445,
 2536,2406,3008,2510,3,2684,3,2477,2,2,2935,2237,2373,4,2375,
 1477,2597,2427,2565,2362,2679,2732,2945,2759,3,2322,2553,2321,
 2553,2581,2251,2536,2321,2716,3005,2477,2654,2654,3079,2654,
 1477,2368,2368,2216,2217,2560,2250,2531,2353,2539,2913,2539,2,
 2659,2,3210,2705,2,3092,2793,2736,2653,2,3098,2802,1,1,1,
 2749,3,3,3,3,3,2708,2708,2749,1,1,1,2490,2823,2,2478,2653,
 2653,2825,2490,2536,2935,2654,2536,1,1,1,3,2477,2251,2251,
 2251,2653,3,2653,2477,1,1,1,2011,1477,2011,3,2011,2398,2011,
 1477,2317,2394,2394,3,2659,2490,1999,1999,1999,1999,1472,2479,
 2479,2287,1472,2287,2479,2479,2445,2011,2,2202,4,2202,2381,
 1477,2413,2413,2250,2393,2250,2737,3,2156,2191,2156,2582,3031,
 2582,3,2316,2316,2339,2445,2,1477,2753,2321,3,2634,3,2718,3,
 2751,2536,1477,2382,2382,2359,2221,2941,2618,2640,2225,2250,
 2568,2490,3,2202,2433,2202,1477,1477,2239,2239,2478,3,2478,
 2191,2156,5,2191,2156,2487,2496,2366,5,2487,2366,2496,2653,
 2654,3,3,2,2654,3,1,1,1,2477,2477,2251,2251,2251,2653,2653,
 3,3,1,1,1,2407,2011,2422,2380,4,2422,2361,2440,2361,2427,
 2650,2059,1956,1956,2954,2571,2571,2427,2319,2348,2319,4,2717,
 3,2700,3,2581,2752,3,2372,2237,2375,1477,2373,2658,2920,2660,
 4,2590,2554,2435,2422,2380,2422,4,2490,2736,3,1956,2059,2059,
 1468,1956,2491,2486,2378,1468,2486,2491,2378,2250,2424,2424,2,
 2,2935,2382,2359,1477,2382,2184,2533,2552,2250,2219,2640,2618,
 2941,2445,2445,2536,3,2536,2382,2225,2221,2382,2352,2640,2941,
 2618,1477,2533,2250,2568,2398,2581,3,2581,4,2362,1477,2373,
 2390,2920,2660,2658,2245,2566,2437,2590,2935,2,2,2373,2362,
 1477,4,2390,2565,2597,2427,2245,2945,2679,2732,2,2653,2251,
 2251,2477,2477,3,1,1,1,2251,3,2653,2653,2,3,3,3,2749,2749,
 1,1,1,3,2708,3,2708,2251,2251,2477,3,2477,1,1,1,2251,2653,
 2653,3,3,5,1472,1468,2564,2432,2564,2427,2312,2312,2308,1472,
 5,5,2432,2564,2564,3,2312,2308,2312,3,3,2308,2312,2312,5,
 2564,2432,2564,2427,2312,2308,2312,1468,2564,2564,2432,2312,
 2312,2308,1472,2432,2564,2564,2582,2582,2564,3032,2999,3032,
 2571,2564,3032,3032,2999,2432,2999,3032,3032,2308,2312,2312,
 2582,2571,2582,2,3200,3200,3246,3200,1,1,2075,2075,2147,2075,
 2147,2200,2075,2147,2200,2038,2397,2397,2714,2397,2408,2752,3,
 2581,2397,2714,2752,3,2812,2581,3,3,3,3,2397,2408,2747,2752,
 3,2579,2581,2423,3,2747,2581,3,1,1,1,2432,2432,2,2,2,2432,
 2432,2432,2432,3162,3162,3162,1,1,1,1,1,1,4,4,4,4,4,4,4,
 4,4,1477,3,3,2,3,2,3,3,2477,3,2,3,3,2,2477,3,3,3,3,3,
 2,2,3,3,2477,2477,3,3,2,2477,3,1,1,1,3,3,2,2,2,3,3,3,
 3,1,1,1,2653,1,3200,2,3246,2075,2075,2147,2075,2147,2200,
 2075,2147,2200,2038,2397,2397,2408,2397,2714,2752,2747,3,2397,
 2408,2752,2581,2579,3,2581,2747,1,1,2397,2714,3,2752,1,2812,
 3,2423,2581,3,3,2581,3,3,3,3162,3162,2432,2432,2432,2,2,2,
 3162,2432,2432,2432,1,3200,2,3246,2075,2075,2147,2075,2147,
 2200,2075,2147,2200,2038,2397,2397,2408,2397,2714,2752,2747,3,
 2397,2408,2752,2581,2579,3,2581,2747,1,1,2397,2714,3,2752,1,
 2812,3,2423,2581,3,3,2581,3,3,3,3162,3162,2432,2432,2432,2,
 2,2,3162,2432,2432,2432,1,1,1,2966,2968,2973,2953,3104,2971,
 2940,2977,3004,3055,3070,2936,3060,3107,3122,2935,3119,3107,
 3037,3060,3070,3029,3056,3262,3029,3225,1,1,2935,3029,2972,
 3089,1,3120,3030,3074,2823,3246,2823,3217,1,1,1,3159,3173,
 3016,3016,3016,3022,3018,3022,3173,1,1,1,1,1,2894,2894,2927,
 2894,2927,2894,2894,2927,2894,2927,2981,2892,2981,2981,2981,
 2892,3082,3082,2892,2981,2934,2980,2981,2980,2980,3082,1,1,
 2981,2981,3082,2892,1,2981,2980,2934,3082,3082,2980,2980,1,1,
 1,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,2999,
 1,4,4,4,4,4,4,4,4,4,1477,3,3,2,3,2,3,2,3,3,2,3,2477,
 2477,3,2477,2,1,1,3,2,3,3,1,2,3,3,2477,3,3,2477,3,3,3,
 1,1,3,3,3,2,2,2,1,3,3,3,2940,2953,2977,2968,3104,3004,
 2966,2973,2971,3055,2935,3037,3029,3107,3060,3089,3246,2823,
 2936,3122,3070,2823,3120,3029,3262,2972,1,1,3070,3060,3225,
 2935,1,3056,3217,3074,3107,3119,3029,3030,1,1,1,1,1,3022,
 3022,3018,3016,3016,3016,1,3159,3173,3173,1443,1443,2255,1464,
 1464,2255,2280,1447,1447,81,8,739,81,739,78,511,423,8,739,
 89,228,676,229,224,413,598,1311,81,739,459,78,1309,676,228,
 50,412,416,249,200,1333,1226,1311,610,635,461,425,440,437,
 432,440,619,619,625,633,1443,1443,1443,2270,2255,1464,1464,
 2260,81,8,739,81,739,78,413,512,8,739,89,224,676,249,200,
 433,1006,1332,81,739,416,78,1333,676,229,50,421,433,200,249,
 1309,598,1313,633,610,425,432,461,432,425,437,635,625,633,
 610,1464,2399,1464,2280,1474,2330,1474,141,81,1208,141,1208,
 106,464,486,81,1208,139,485,1072,402,394,473,597,1331,141,
 1208,492,106,1408,1072,390,119,495,567,374,374,1408,598,1331,
 917,941,594,586,595,587,586,588,836,712,805,917,1443,1464,
 1443,1443,2270,2260,81,8,739,81,739,78,433,421,8,739,89,200,
 676,200,249,416,598,1309,81,739,433,78,1313,676,249,50,512,
 413,224,229,1332,1006,1333,625,633,432,437,425,425,461,432,
 610,633,610,635,1464,1464,2399,1464,2290,141,81,1208,141,1208,
 106,473,468,81,1208,139,394,1072,374,374,567,598,1419,141,
 1208,567,106,1351,1072,402,119,468,473,394,402,1419,598,1351,
 805,917,586,587,594,586,594,587,941,805,917,941,1447,2330,
 2290,1447,133,74,1029,133,1029,69,385,493,74,1029,97,317,930,
 383,307,378,598,1356,133,1029,387,69,1334,930,293,108,386,
 378,307,383,1338,598,1422,798,720,469,499,479,499,469,501,
 839,919,798,720,1443,1464,1447,81,8,739,81,739,78,416,412,8,
 739,89,249,676,224,229,459,1226,1333,81,739,413,78,1311,676,
 200,50,423,511,228,228,1311,598,1309,619,625,437,440,432,461,
 440,425,633,610,635,619,1464,1474,141,81,1208,141,1208,106,
 567,495,81,1208,139,374,1072,394,402,492,598,1408,141,1208,
 473,106,1331,1072,374,119,486,464,485,390,1331,597,1408,712,
 805,587,588,586,594,595,586,917,917,941,836,1447,133,74,1029,
 133,1029,69,378,386,74,1029,97,307,930,307,383,387,598,1338,
 133,1029,378,69,1422,930,383,108,493,385,317,293,1356,598,
 1334,919,798,499,501,469,469,479,499,720,798,720,839,91,27,
 972,91,972,77,345,362,27,972,94,248,679,260,260,422,988,
 1236,91,972,422,77,1230,679,258,71,362,345,248,258,1236,988,
 1230,680,641,443,500,470,443,470,500,646,680,641,646,2011,
 2011,2655,2202,2202,2321,4,2278,2655,2202,2428,2202,2428,2321,
 4,2478,3,2655,2655,2321,2320,2705,2058,2321,2058,2559,2559,
 2250,2250,2734,2478,3,2366,2496,2156,5,2191,2191,5,2156,2487,
 2496,2487,2366,2011,2011,2011,2268,2398,2398,2253,2011,2011,
 2482,2268,2322,1477,2394,2490,3,2278,2278,2334,2011,2659,2011,
 2482,2268,2394,2394,1477,2322,2659,3,2659,2287,2479,1472,1999,
 1999,1999,1472,1999,2479,2479,2287,2479,2202,2655,2202,4,2321,
 2278,2202,2655,2428,2202,2553,2433,2433,2250,2393,2655,2655,
 2567,2058,2393,2320,2321,2058,2413,2413,2251,1477,3202,2,2,
 2316,2339,3,3,2737,2191,2156,2156,2316,3031,2582,2582,2011,
 2202,4,2434,2011,2011,2362,2321,2352,2250,2250,2559,3,2705,
 2655,2202,2559,2202,2734,2352,2428,2397,2434,4,2321,2428,2705,
 3,2734,2487,2366,5,2191,2156,5,2156,2191,2496,2487,2366,2496,
 2202,2434,4,2011,2362,2011,2321,2352,1477,2251,2413,2,2,2655,
 2202,2379,2352,3202,2202,2428,2397,2584,2433,2433,2553,2393,
 2250,2442,2582,2582,2156,2191,2156,3,3,2737,3031,2316,2316,
 2339,2235,2235,2011,2352,2352,1477,2011,2407,2523,2407,3,2736,
 2320,2058,2532,2320,2724,2320,1477,2058,2490,2407,2523,2407,
 2724,2490,3,2491,2378,2059,1468,1956,1468,2059,1956,2486,2486,
 2491,2378,2398,2394,2433,2584,2433,2369,2706,2654,2477,3,2805,
 2559,2413,2980,2407,2802,2490,2407,2358,2688,3,2477,3,3219,2,
 2,2597,2427,4,1477,2375,2237,2373,2372,2589,2945,2732,2679,
 2394,2584,2433,2433,2369,3,2477,3,2654,2822,2559,2413,2477,
 2490,3098,2407,2407,2358,3000,2688,2731,2536,2752,2581,3,2660,
 2658,2373,1477,2375,2237,4,2372,2920,2566,2587,2435,2011,2011,
 1477,2011,1477,2322,2334,3,2659,2011,2011,2394,2268,2659,2268,
 2322,2268,2398,2398,2482,2482,3,2490,2659,2479,2287,1999,1999,
 1472,1472,1999,1999,2479,2287,2479,2479,2011,2433,2202,2251,
 1477,2379,2250,2393,2202,2655,2413,2202,2442,2352,2553,2397,4,
 2434,2321,2428,2,2,3202,2316,2316,3,2737,3,2156,2156,2191,
 2339,2582,2582,3031,2433,2202,1477,1477,2239,2478,3,2202,2655,
 2239,2352,2734,2202,2553,2397,2433,2584,2433,2553,3,2478,2734,
 2366,2487,2156,2191,5,2156,5,2191,2496,2366,2487,2496,1477,3,
 2677,3,3,2759,2250,2251,2706,2523,2653,2523,2250,2387,2731,
 2477,2980,2677,2760,2825,2753,2560,2250,2368,2217,2216,1477,
 2368,2353,2512,2539,2913,2539,2321,2415,4,2361,2440,2058,2320,
 2422,2320,2425,2320,2251,2058,2407,2490,2523,2407,2765,2824,
 2765,2348,2319,2650,2427,2427,1956,2059,1956,2319,2571,2954,
 2571,2250,2407,2654,2753,2321,2433,2433,2523,3079,2415,2677,
 2553,2477,2654,2677,2980,3,2581,2759,2539,2539,2353,2368,1477,
 2216,2217,2368,2913,2250,2512,2562,2433,2581,3,2428,2553,2407,
 2407,2759,2321,2980,2553,3,2706,3,2677,2753,2654,3079,2250,
 2512,2216,2368,2217,2353,1477,2368,2562,2539,2539,2913,2536,3,
 2321,2567,2468,2532,2803,2422,2477,2468,2477,2980,2706,2654,2,
 2935,2,2427,2589,2375,4,1477,2372,2237,2370,2573,2679,2945,
 2732,2,2478,2,2935,2490,2,2824,2654,2478,2581,2,2825,2581,1,
 1,1,2653,3,2251,2251,2251,3,2477,2477,2653,1,1,1,2734,3202,
 2,2724,2765,2765,3079,2682,2752,3219,2760,2653,1,1,1,3,2708,
 3,3,3,2749,3,2749,2708,1,1,1,2011,4,2202,3,2202,2250,2058,
 4,2321,2428,2321,3,2478,2705,2496,2487,2191,2156,5,2156,2191,
 5,2366,2366,2496,2487,2433,2202,2,2202,1477,2058,2321,4,2428,
 2321,2393,2250,2393,3031,2582,2191,2156,2156,3,2737,3,2582,
 2316,2339,2316,2407,2,4,2654,2468,3,2477,3,2477,3,2536,2803,
 2679,2945,2372,2370,2237,2375,1477,4,2732,2427,2589,2573,3,
 2011,2407,2058,2235,2235,1477,1477,2736,3,2724,2486,2491,1468,
 1956,2059,2059,1956,1468,2378,2491,2378,2486,2765,2760,3,3,2,
 2753,3,1,1,1,2708,2708,3,3,3,2749,2749,3,3,1,1,1,2407,
 2058,2369,2369,1477,2251,2440,2361,2425,2571,2954,1956,1956,
 2059,2650,2427,2427,2571,2348,2319,2319,1477,2536,3,2677,3,
 2653,2581,3,2913,2539,2368,1477,2353,2217,2368,2216,2539,2512,
 2562,2250,2358,2358,2387,1477,2682,2478,3,2484,2484,2164,5,
 2164,2164,2164,5,2251,2484,2484,2251,2398,2433,2407,2822,2654,
 3098,2566,2587,2237,2372,4,2373,2375,1477,2435,2660,2658,2920,
 2433,2407,2805,3,2802,2945,2732,2237,2372,2373,4,2375,1477,
 2679,2597,2427,2589,2250,2759,3,2653,2539,2913,1477,2353,2368,
 2368,2216,2217,2539,2560,2250,2512,3079,2654,2760,2512,2562,
 2217,2216,2368,2368,2353,1477,2250,2913,2539,2539,2,2765,1,1,
 2749,2749,3,3,3,3,1,3,2708,2708,2,1,1,3,2477,2477,2251,
 2251,2251,1,2653,3,2653,1,1,2749,3,2749,3,3,3,1,2708,2708,
 3,2582,2308,2312,2312,2564,2432,2564,2571,3032,3002,3032,2312,
 2312,2308,2432,2564,2564,2582,3002,3032,3032,3,3,5,1472,1468,
 2312,2564,2432,2564,2427,1468,5,5,2307,2564,2564,2432,1472,5,
 5,2312,2432,2564,2564,3,3,2564,2308,2312,2312,2427,2564,2312,
 2308,2312,2432,2312,2312,2307,3032,3032,3002,2582,2571,2582,
 3246,3265,3265,3246,1,1,2236,2230,2204,2236,2204,2249,2224,
 2231,2229,2048,2427,2450,2761,2450,2773,2450,3,2596,2427,2761,
 2450,3,2821,2596,3,3,3,3,2474,2773,2789,2427,3,2609,2613,
 2450,3,2815,2633,2450,1,1,1,2461,2461,2,2,2,2461,2461,2461,
 2461,3218,3218,3218,3200,2,2653,1,1,2147,2147,2124,2147,2124,
 2138,2147,2124,2138,2057,2397,2752,2714,2397,2408,2397,2427,
 2712,2752,2714,2423,2427,2812,2738,2427,2427,3,3,2397,2408,
 2536,2397,3,2579,2738,2752,2464,2536,2738,2427,1,1,1,2432,
 2432,3162,3162,3162,2432,2432,2432,2432,2,2,2,3265,3200,3265,
 3265,2983,2983,2851,2983,2851,2908,2983,2851,2908,2983,2981,
 2981,2980,2981,2980,2981,3078,3093,2981,2980,2981,3078,3126,
 3078,3078,3078,3126,3126,2981,2980,3078,2981,3126,3126,3078,
 2981,3093,3078,3078,3078,3126,3126,3126,3078,3078,3078,3078,
 3078,3078,3078,3078,3078,3078,3078,3078,2,1,1,2236,2202,2231,
 2202,2204,2184,2236,2231,2184,2049,2474,2427,2761,2450,2773,
 2427,2450,2771,2450,2761,2450,2450,2821,2818,3,3,3,3,2427,
 2773,2596,2450,3,2609,2771,2450,3,2613,2789,3,1,1,1,2461,
 2461,3218,3218,3218,2461,2461,2461,2461,2,2,2,1,1,2147,2147,
 2124,2147,2124,2138,2147,2124,2138,2057,2397,2752,2714,2397,
 2408,2397,2427,2712,2752,2714,2423,2427,2812,2738,2427,2427,3,
 3,2397,2408,2536,2397,3,2579,2738,2752,2464,2536,2738,2427,1,
 1,1,2432,2432,3162,3162,3162,2432,2432,2432,2432,2,2,2,3142,
 3142,3142,3147,3277,3160,3186,3142,3187,3186,3276,3142,3142,
 3186,3266,3186,3142,1,3142,3142,3186,3266,1,3290,1,3142,3142,
 1,1,3142,3186,1,3142,1,3186,3276,3266,3266,3276,3142,1,1,1,
 1,1,1,3188,3188,3188,1,1,1,1,3188,3188,3188,3142,3142,3147,
 3277,3160,3186,3142,3187,3186,3276,3142,3142,3186,3266,3186,
 3142,1,3142,3142,3186,3266,1,3290,1,3142,3142,1,1,3142,3186,
 1,3142,1,3186,3276,3266,3266,3276,3142,1,1,1,1,1,1,3188,
 3188,3188,1,1,1,1,3188,3188,3188,2410,2410,2399,2351,2351,
 2399,2499,2436,2436,1207,1207,1962,1207,1707,1212,1412,1669,
 1207,1962,1212,1412,2244,1672,1398,1398,1428,1413,1207,1707,
 1671,1212,1428,1644,1656,1209,1430,1657,1825,1398,3066,3108,
 3066,1371,1404,1966,1960,1963,1404,1371,1371,1371,1967,1967,
 1963,2410,2410,2410,2657,2399,2351,2351,2574,1207,1207,1962,
 1207,1707,1212,1398,1825,1207,1962,1212,1398,2244,1825,1398,
 1398,1426,1426,1207,1707,1657,1212,1417,1644,1672,1209,1435,
 1653,1669,1412,3030,3066,3108,1371,1371,1960,1966,1966,1371,
 1371,1404,1404,1967,1963,1960,2351,2481,2351,2499,2334,2503,
 2334,809,809,1622,809,1494,788,1226,1518,809,1622,788,1226,
 2055,1519,1206,1206,1286,1286,809,1494,1522,788,1286,1577,1522,
 791,1283,1551,1518,1226,2916,2915,2915,1257,1245,1655,1655,
 1645,1245,1257,1245,1245,1646,1645,1655,2410,2351,2410,2410,
 2657,2574,1207,1207,1962,1207,1707,1212,1398,1672,1207,1962,
 1212,1398,2244,1669,1412,1412,1413,1428,1207,1707,1653,1212,
 1427,1644,1825,1209,1433,1670,1652,1402,3030,3030,3066,1404,
 1371,1966,1963,1960,1371,1404,1371,1371,1963,1960,1963,2351,
 2351,2481,2351,2489,809,809,1622,809,1494,788,1206,1519,809,
 1622,788,1206,2055,1518,1226,1226,1286,1286,809,1494,1551,788,
 1297,1577,1519,791,1289,1520,1520,1252,2914,2916,2915,1245,
 1257,1655,1645,1655,1257,1245,1245,1245,1645,1655,1655,2436,
 2503,2657,2436,1030,1030,1777,1030,1583,1008,1365,1660,1030,
 1777,1008,1365,2244,1660,1365,1365,1431,1431,1030,1583,1559,
 1008,1403,1668,1567,1010,1415,1554,1569,1388,2943,2951,2950,
 1341,1341,1702,1704,1704,1341,1341,1379,1379,1854,1725,1712,
 2410,2351,2436,1207,1207,1962,1207,1707,1212,1412,1656,1207,
 1962,1212,1412,2244,1652,1402,1402,1427,1417,1207,1707,1670,
 1212,1413,1644,1669,1209,1429,1826,1656,1412,3066,3030,3030,
 1371,1404,1963,1963,1966,1404,1371,1371,1371,1960,1963,1967,
 2351,2334,809,809,1622,809,1494,788,1226,1522,809,1622,788,
 1226,2055,1520,1252,1252,1297,1286,809,1494,1520,788,1297,1577,
 1518,791,1282,1518,1551,1252,2916,2914,2916,1245,1245,1645,
 1646,1655,1245,1245,1257,1257,1655,1655,1645,2436,1030,1030,
 1777,1030,1583,1008,1365,1567,1030,1777,1008,1365,2244,1569,
 1388,1388,1403,1431,1030,1583,1554,1008,1438,1668,1660,1010,
 1423,1570,1555,1354,2937,2937,2949,1379,1341,1704,1718,1702,
 1341,1379,1341,1341,1725,1712,1725,1149,1149,1932,1149,1747,
 1152,1205,1662,1149,1932,1152,1205,2056,1663,1274,1274,1295,
 1306,1149,1747,1756,1152,1305,1577,1662,1105,1274,1659,1659,
 1205,3103,3061,3043,1291,1270,1895,1900,1895,1270,1291,1291,
 1291,1900,1895,1895,2704,2704,2655,2362,2362,2653,2477,2655,
 2387,2806,2653,2806,2683,3,3,2745,2,2655,2936,2683,2655,2745,
 2362,2981,2362,2790,3034,2731,2731,3157,3153,2823,2,2678,2396,
 2366,2401,2678,2,2678,2678,2396,2401,2366,2704,2362,2362,2655,
 2731,2731,2655,2704,2704,2731,2471,2683,3,3,2745,2,2655,2936,
 2683,2362,2745,2362,3034,2655,2776,2981,2477,2653,3153,2823,
 3153,2,2678,2366,2396,2401,2678,2,2678,2678,2396,2366,2401,
 2704,2512,2704,3,2352,2387,2789,2387,3,2789,2320,2393,2393,
 2761,2761,2387,2512,2320,2704,2761,2512,2352,2704,3,2352,2352,
 3,3126,3171,3171,2714,2714,2704,2704,2387,2714,2714,2714,2714,
 2387,2704,2704,2362,2704,3,2683,2704,2704,2655,3,2471,2731,
 2731,2731,2,2745,2655,2362,3034,2362,2745,2936,2683,2655,2776,
 2477,2981,2653,3157,2823,3157,2678,2,2366,2401,2396,2,2678,
 2678,2678,2401,2366,2396,2362,2731,2477,2362,2512,2362,2731,
 2638,2477,2731,2731,2789,2789,2936,3029,3031,2936,3077,3029,
 3031,2936,3086,3047,3047,3029,3045,3045,3045,2731,2731,2540,
 2540,2540,2731,2731,3029,3029,2540,2540,2540,3,2616,2806,2387,
 2655,3,2806,2731,2731,2731,2,2745,2655,2362,3034,2655,2745,
 2936,2616,2362,2790,2731,3034,2731,3153,3157,2823,2678,2,2401,
 2366,2396,2,2678,2678,2678,2401,2396,2366,2731,3,2393,2731,
 2393,3,2,2,2,3,2771,2731,2731,3077,2731,2771,3029,2731,2653,
 2,2,3077,2,1,1,1,2731,3,2431,2393,2431,3,2731,2731,2731,
 2431,2431,2393,2683,2320,2731,2731,2649,2,2,2,2795,2,3034,
 3031,3152,3034,3087,3047,3047,2981,3127,3152,3153,3077,3186,
 3186,2823,2758,2745,2559,2478,2569,2745,2758,3047,3047,2664,
 2664,2591,2704,2362,3,2806,2477,2653,2653,2,2745,2362,2362,
 2981,2655,2745,2936,2683,2655,2235,2235,3034,2731,2823,3157,
 3153,2678,2,2396,2401,2366,2,2678,2678,2678,2366,2401,2396,
 2704,2393,2789,2352,3,3,2761,2761,2704,2512,2352,2704,2761,
 2512,2320,2387,3,2352,2352,3,3171,3171,3126,2714,2714,2704,
 2387,2704,2714,2714,2714,2714,2704,2704,2387,2731,2806,2616,3,
 3,2745,2,2362,2936,2616,2655,2745,2362,3034,2655,2235,3034,
 2235,2731,2823,3153,3157,2,2678,2401,2396,2366,2678,2,2678,
 2678,2366,2396,2401,3,2,2,2,3,2771,2731,2731,3077,2731,2771,
 3029,2731,2653,2,2,3077,2,1,1,1,2731,3,2431,2393,2431,3,
 2731,2731,2731,2431,2431,2393,2649,3,3,2821,2821,2806,2638,
 2649,2471,2821,2638,2649,2806,3,2649,2649,3,3286,3286,3286,
 2812,2812,2471,2806,2806,2812,2812,2812,2812,2806,2471,2806,
 2731,2731,2,2795,2981,3047,3047,3034,3087,3031,3152,3034,3118,
 3212,3152,3077,2823,3181,3181,2745,2758,2559,2569,2478,2758,
 2745,3047,3047,2591,2661,2661,2393,2771,3,2653,3029,2731,2731,
 2771,2731,3077,2731,2,3077,2,2,1,1,1,3,2731,2431,2431,2393,
 2731,3,2731,2731,2393,2431,2431,2771,3,2653,3029,2731,2731,
 2771,2731,3077,2731,2,3077,2,2,1,1,1,3,2731,2431,2431,2393,
 2731,3,2731,2731,2393,2431,2431,2789,2745,2789,3087,2745,2789,
 3077,2795,2745,2808,2,3087,2771,1,1,1,2771,2,3,3,3,2,2771,
 2771,2771,3,3,3,2745,3077,2795,2745,2789,2789,3087,2745,2808,
 3087,2,2771,1,1,1,2,2771,3,3,3,2771,2,2771,2771,3,3,3,
 2362,2477,2704,2,2362,2731,2806,3,2683,2683,3,2823,3153,3157,
 2678,2678,2401,2396,2366,2678,2678,2,2,2366,2396,2401,3047,
 2362,2789,3029,2477,2362,2752,2477,3031,2731,3045,3045,3045,
 3029,2731,2540,2540,2540,2731,3029,2731,2731,2540,2540,2540,
 2731,2,2477,3212,2731,2,3152,2,2,2823,3186,3186,2745,3047,
 2661,2661,2591,3047,2745,2758,2758,2478,2559,2569,2,2362,2731,
 2704,3,2616,2616,3,3153,2823,3153,2678,2678,2366,2396,2401,
 2678,2678,2,2,2396,2366,2401,2789,2,2,3,2795,2795,3,1,1,1,
 2771,2771,3,3,3,2771,2771,2,2,3,3,3,3047,2362,2752,3031,
 2477,2731,3045,3045,3045,2731,3029,2500,2500,2500,3029,2731,
 2731,2731,2500,2500,2500,2477,2,2,3152,2,3186,3186,2823,3047,
 2745,2569,2478,2559,2745,3047,2758,2758,2661,2661,2591,3,2683,
 2683,3,3157,3153,2823,2678,2678,2396,2366,2401,2678,2678,2,2,
 2396,2401,2366,2235,2235,3,3255,3254,3271,2794,2794,2453,2466,
 2455,2794,2794,3,3,2455,2453,2465,3047,2731,3186,2823,3181,
 3047,2758,2591,2661,2664,2758,3047,2745,2745,2559,2478,2559,
 2731,3181,2823,3186,2758,3047,2478,2559,2559,3047,2758,2745,
 2745,2664,2591,2661,1,1,1,2731,2731,2393,2431,2431,2731,2731,
 3,3,2431,2393,2431,3171,3286,1,1,3256,3142,2823,1,1,1,1,
 2823,3142,3256,3171,1,1,2823,3142,3256,1,1,1,1,3142,2823,
 3256,1,1,3142,2823,3256,1,1,1,1,3142,3256,2823,2731,2409,
 2409,2409,2731,2653,2731,2731,2409,2409,2409,2409,2409,2409,
 2653,2731,2731,2731,2409,2409,2409,2704,2704,2409,2409,2409,
 2409,3148,3078,3148,2806,2409,2409,2409,2409,3148,3148,3078,
 2409,2409,2409,2409,3078,3148,3148,2731,2731,2731,2409,2409,
 2409,2731,2731,2409,2409,2409,2653,2409,2409,2409,2409,2409,
 2409,2704,2806,2704,1,1,3246,1,1,2966,3039,3020,2940,2973,
 3090,2953,2977,2970,2976,2936,3070,3060,3037,3122,3107,3227,
 3019,2935,3060,3057,2823,3056,2972,3223,3029,1,1,3037,3029,
 3262,2935,1,3120,3246,3089,3029,3030,2823,3131,1,1,1,3159,
 3173,1,1,1,3022,3018,3022,3173,3016,3016,3016,3142,1,1,1,
 3142,3277,3187,3142,3160,3186,3142,3147,3186,3276,3142,3142,
 3186,3266,3186,3142,3276,3266,3142,3186,3266,3142,3186,3142,1,
 1,1,1,3142,3186,3142,3142,1,3290,1,3266,3142,1,1,3276,1,1,
 1,3188,3188,1,1,1,3188,3188,3188,3188,1,1,1,1,1,1,3142,
 3277,3187,3142,3160,3186,3142,3147,3186,3276,3142,3142,3186,
 3266,3186,3142,3276,3266,3142,3186,3266,3142,3186,3142,1,1,1,
 1,3142,3186,3142,3142,1,3290,1,3266,3142,1,1,3276,1,1,1,
 3188,3188,1,1,1,3188,3188,3188,3188,1,1,1,1,1,2964,3088,
 2979,3014,2936,3039,2975,2967,2953,2978,2935,3089,3060,3107,
 3029,3037,3226,2935,2935,3060,3074,3029,3056,2935,3222,3029,1,
 1,3070,3122,3217,2936,1,3120,3281,3070,3075,3138,3138,3075,1,
 1,1,3022,3022,1,1,1,3173,3173,3159,3018,3016,3016,3016,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,2376,2376,2477,2250,2250,2709,2675,2361,
 2361,878,1014,1860,1082,1807,1076,1372,1496,832,1898,1203,1005,
 1893,1508,1321,598,1355,1360,1153,1814,2069,878,1316,1614,1813,
 1036,1114,1896,1686,1098,1,1,1,764,834,4,4,4,770,816,747,
 835,2870,2879,2880,2376,2376,2376,2477,2677,2458,2458,2553,
 1021,1215,1991,1215,2050,1260,1410,1666,1021,1991,1260,1205,
 2006,1666,1410,1205,1340,1340,1218,2018,2121,1062,1424,1684,
 1922,1239,1266,1973,1685,1237,1,1,1,1070,1024,4,4,4,1070,
 1024,1045,1131,2957,2989,2958,2250,2639,2250,2746,2369,2673,
 2369,886,1155,1859,1173,1726,1137,1395,1500,886,1859,1048,598,
 1912,1510,1376,1005,1364,1316,1192,1726,2118,886,1343,1692,
 1754,1052,1164,1941,1631,1113,1,1,1,885,814,4,4,4,754,814,
 744,754,2869,2869,2890,2376,2250,2250,2250,2709,2646,832,1082,
 1898,1014,1807,1203,1321,1508,878,1860,1076,598,1893,1496,1372,
 1005,1360,1355,1014,1715,2113,878,1348,1629,2051,1086,1102,
 1710,1637,1180,1,1,1,770,816,4,4,4,764,834,891,748,2904,
 2871,2877,2250,2250,2706,2250,2631,886,1173,1859,1155,1726,
 1048,1376,1510,886,1859,1137,1005,1912,1500,1395,598,1316,1364,
 1100,1726,2139,886,1346,1692,1873,1074,1118,1924,1636,1160,1,
 1,1,754,814,4,4,4,885,814,807,885,2881,2909,2890,2448,2682,
 2677,2448,1062,1288,2007,1288,1961,1213,1389,1650,1062,2007,
 1213,1227,1984,1650,1389,1227,1436,1436,1240,1990,2174,1013,
 1339,1933,1935,1221,1224,2046,1697,1222,1,1,1,1033,1028,4,4,
 4,1033,1028,1064,1017,2989,2956,2960,2250,2250,2448,875,1088,
 1876,1047,1894,1161,1384,1509,889,1861,1101,598,1918,1504,1328,
 1005,1440,1314,1046,1817,2127,731,1316,1625,1772,1093,1059,
 1741,1633,1165,1,1,1,783,823,4,4,4,847,837,785,824,2873,
 2888,2886,2458,2369,731,1117,1897,1157,1711,1099,1416,1511,731,
 1897,1143,1005,1889,1505,1335,598,1316,1344,1094,1711,2074,731,
 1317,1693,1909,1073,1007,1925,1696,1166,1,1,1,743,808,4,4,4,
 830,808,818,830,2890,2885,2891,2361,889,1145,1913,1168,1714,
 1042,1326,1502,889,1914,1090,1171,1858,1502,1434,1171,1355,
 1316,1110,1734,2123,872,1439,1694,2037,1054,1184,1923,1638,
 1116,1,1,1,863,845,4,4,4,745,822,783,773,2883,2872,2887,
 600,973,1695,973,1851,985,1228,1499,600,1695,973,599,1699,
 1501,1253,599,1217,1275,974,1851,2150,600,1234,1532,1761,957,
 986,1887,1598,987,1,1,1,717,716,1477,1477,1477,715,716,723,
 715,2889,2889,2889,2250,2250,2677,2477,2477,2677,2477,2477,
 2427,2250,2477,2250,2478,2427,2250,2710,3,2677,3143,2653,2477,
 2710,2477,3029,2477,2714,3171,2477,2477,1,1,1,2251,2563,3,3,
 3,2563,2251,2563,2563,3030,3030,2824,2250,2772,2772,2706,2430,
 2430,2677,2456,2456,2653,2420,2595,3,3,2763,3,2706,3164,2655,
 2477,2729,2477,3029,2477,2725,3189,2477,2477,1,1,1,2391,2735,
 3,3,3,2711,2385,2576,2580,3152,3112,3111,2456,2704,2456,3,
 2553,2427,2789,2420,3,2789,2523,3,3,2472,2393,2420,2704,2653,
 2250,2393,2512,2553,2250,2426,2723,2523,2250,1,1,1,2357,2452,
 2,2,2,2452,2357,2357,2357,3161,3101,3101,2772,2456,3,2595,
 2250,2250,2706,3,2420,2430,2430,2653,3,2763,2477,2477,3256,
 2477,2721,3113,2794,2706,2477,2477,3130,2725,1,1,1,2711,2385,
 3,3,3,2391,2735,2580,2575,3111,3112,3152,2477,2780,2477,2477,
 2704,2477,2477,2387,2477,2780,2477,2,2,3164,3217,3256,3143,
 3214,3217,3230,3164,3169,3236,3236,3169,1,1,1,2619,2619,2,2,
 2,2619,2619,3151,3151,2823,3172,2823,2469,2595,2250,2420,2477,
 2250,2250,2477,2712,2477,3,2729,2706,2772,3182,2677,2792,3113,
 2794,2772,2713,2787,3130,2787,1,1,1,2580,2391,3,3,3,2385,
 2575,2711,2735,3111,3152,3112,2430,2427,3,2712,3,2426,2738,2,
 2653,3,2820,2,2,3212,2,2,2823,2,2,2,2,2823,2,1,1,1,2778,
 2427,3,3,3,2470,2690,2,2,3221,3249,3221,2478,2523,2477,2477,
 2523,2477,2738,2477,2740,2755,3001,3078,3212,2935,3054,3162,
 3162,3034,3010,3097,3230,3044,1,1,1,2588,2514,2477,2477,2477,
 2514,2588,2947,2947,2824,3065,3065,2250,2477,2250,2250,2477,
 2677,2477,3,2710,2477,2477,3161,2477,2710,3077,2731,2677,2477,
 2477,3101,2714,1,1,1,2563,2251,3,3,3,2251,2563,2563,2563,
 2824,3030,3030,2456,3,2789,2553,3,3,2393,2472,2250,2387,2794,
 2250,2393,2638,2644,2420,2250,2477,2644,2426,1,1,1,2452,2357,
 2,2,2,2357,2452,2357,2356,3101,3101,3161,2477,2250,2595,2469,
 2250,2729,3,2752,3164,2794,2677,2763,2752,3097,2706,2447,3235,
 2447,2713,1,1,1,2385,2575,3,3,3,2580,2391,2735,2715,3112,
 3152,3111,2250,2477,2653,2477,3,2653,2,2,3142,2,2,2823,2,2,
 2,2,2823,2,1,1,1,2536,2250,3,3,3,2250,2536,2,2,2823,3143,
 2823,2523,2426,2250,2426,2426,2456,2704,2723,2427,2467,2638,
 2644,2456,2462,2780,2644,2462,1,1,1,2354,2354,2,2,2,2354,
 2354,2443,2443,3101,3161,3101,2430,2477,2755,2740,3034,3164,
 3164,2935,3054,3059,3156,3001,3044,3189,3072,3010,1,1,1,2514,
 2588,2477,2477,2477,2588,2514,2947,2947,3065,3065,2824,3,2820,
 3,2,3224,2,2,2,2,2823,2,2,1,2,2,1,1,1,2470,2690,3,3,3,
 2778,2427,2,2,3221,3249,3221,2653,3,2,3142,2,2,2,2,2823,2,
 2,1,2,2,1,1,1,2250,2536,3,3,3,2536,2250,2,2,2823,3143,
 2823,2,2729,2,3241,2710,2,3136,2819,2792,2653,2,3140,2800,1,
 1,1,2755,3,3,3,3,3,2729,2729,2755,1,1,1,2763,3214,2,2710,
 2731,2731,3077,2721,2769,3240,2731,2714,1,1,1,3,2729,3,3,3,
 2755,3,2755,2721,1,1,1,2477,2,2250,3,2752,2,2456,2250,2352,
 2757,2457,1,1,1,2711,2576,3,3,3,2580,2735,2391,2383,3112,
 3111,3152,3164,2477,2,3217,2,2772,2477,2477,3230,2780,1,1,1,
 3151,2619,2,2,2,2619,3151,2619,2619,2823,2823,3172,2,2,2,1,
 2,2,1,2,2,1,1,1,2727,3211,2,2,2,3184,2720,2,2,3200,3259,
 3258,3,2477,2,2250,2250,2477,2477,2250,1,1,1,2563,2563,3,3,
 3,2563,2563,2251,2251,3030,2824,3030,2731,2,3,3,2,2731,3,1,
 1,1,2729,2721,3,3,3,2755,2755,3,3,1,1,1,3162,2477,2761,
 3235,2477,2477,1,1,1,2610,3109,2477,2477,2477,3109,2610,2610,
 2610,3166,3124,3124,2,2,2,3164,2,1,1,1,3058,2791,2477,2477,
 2477,2791,3058,2,2,3200,3260,3260,2457,2780,2477,2250,1,1,1,
 2576,2711,3,3,3,2735,2580,2391,2385,3152,3111,3112,2477,2447,
 2462,1,1,1,2726,2571,3,3,3,2536,2762,2250,2384,3137,3133,
 3155,3236,2787,1,1,1,3190,2615,2,2,2,2477,3220,2647,2635,
 2823,2823,3182,2477,1,1,1,2581,3128,2477,2477,2477,3128,2614,
 2612,2612,3189,2823,2823,1,1,1,2578,2726,3,3,3,2766,2536,
 2250,2386,3155,3133,3137,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 2619,3,3,3,2666,2461,2666,2610,3038,3038,3021,3,3,3,2461,
 2666,2666,2619,3017,3038,3038,2,2,3,3,3,3,1,1,1,2,3,3,3,
 3,1,1,1,3,3,3,3,1,1,1,2619,2619,2666,3021,3038,3038,2610,
 2666,3038,3038,3021,2461,3038,3021,3038,3038,3021,3038,3101,
 3101,3101,1,3200,2,3246,2075,2075,2147,2075,2147,2200,2075,
 2147,2200,2038,2397,2397,2408,2397,2714,2752,2747,3,2397,2408,
 2752,2581,2579,3,2581,2747,1,1,2397,2714,3,2752,1,2812,3,
 2423,2581,3,3,2581,3,3,3,3162,3162,2432,2432,2432,2,2,2,
 3162,2432,2432,2432,2,1,1,4,4,4,4,4,4,4,4,4,1477,3,3,2,
 3,2,3,3,2,3,2,3,3,2,2,3,3,3,3,3,2,2477,3,3,2477,2,3,
 3,2477,2,3,1,1,1,3,3,1,1,1,3,3,3,3,2,2,2,1,1,2147,
 2147,2124,2147,2124,2138,2147,2124,2138,2057,2397,2752,2714,
 2397,2408,2397,2427,2712,2752,2714,2423,2427,2812,2738,2427,
 2427,3,3,2397,2408,2536,2397,3,2579,2738,2752,2464,2536,2738,
 2427,1,1,1,2432,2432,3162,3162,3162,2432,2432,2432,2432,2,2,
 2,1,4,4,4,4,4,4,4,4,4,1477,3,3,2,3,2,3,2,3,3,2,3,
 2477,2477,3,2477,2,1,1,3,2,3,3,1,2,3,3,2477,3,3,2477,3,
 3,3,1,1,3,3,3,2,2,2,1,3,3,3,2966,2968,2973,2953,3104,
 2971,2940,2977,3004,3055,2936,3107,3122,3037,3060,3070,3261,
 3029,2935,3029,3089,3139,3120,2823,3168,3019,1,1,3037,3060,
 3217,2935,1,3056,3225,3057,3030,3029,3119,3107,1,1,1,1,1,
 3173,3159,3173,3016,3016,3016,1,3022,3022,3018,1443,1443,2255,
 1464,1464,2255,2280,1447,1447,8,81,739,8,739,89,262,231,81,
 739,78,412,676,459,458,231,1309,598,8,739,229,89,598,676,
 416,60,228,228,511,423,1061,1313,598,610,633,635,610,619,440,
 461,437,625,440,437,432,1443,1443,1443,2270,2255,1464,1464,
 2260,8,81,739,8,739,89,231,262,81,739,78,458,676,511,423,
 232,1332,1006,8,739,228,89,1061,676,459,60,229,224,413,512,
 598,1311,1226,635,610,610,633,635,461,425,440,633,437,432,
 425,1464,2399,1464,2280,1474,2330,1474,81,141,1208,81,1208,
 139,404,404,141,1208,106,566,1072,489,474,400,1419,598,81,
 1208,390,139,598,1072,492,92,390,485,464,486,598,1331,598,
 941,917,941,917,836,595,594,588,805,588,587,586,1443,1464,
 1443,1443,2270,2260,8,81,739,8,739,89,232,230,81,739,78,423,
 676,413,512,233,1311,598,8,739,224,89,1226,676,511,60,249,
 200,433,421,1006,1332,1061,619,635,633,625,610,425,432,461,
 610,432,425,461,1464,1464,2399,1464,2290,81,141,1208,81,1208,
 139,400,399,141,1208,106,474,1072,464,486,494,1331,597,81,
 1208,485,139,598,1072,489,92,402,394,473,468,597,1331,598,
 836,941,917,805,941,594,586,595,917,587,586,594,1447,2330,
 2290,1447,74,133,1029,74,1029,97,318,393,133,1029,69,371,930,
 497,392,321,1356,598,74,1029,295,97,1006,930,389,80,293,317,
 385,493,1061,1437,1226,839,720,720,798,839,479,469,476,798,
 501,499,469,1443,1464,1447,8,81,739,8,739,89,233,233,81,739,
 78,512,676,433,421,230,1313,1061,8,739,200,89,598,676,413,
 60,200,249,416,412,598,1309,598,625,619,625,619,633,432,437,
 425,635,425,461,440,1464,1474,81,141,1208,81,1208,139,494,
 403,141,1208,106,486,1072,473,468,403,1331,598,81,1208,394,
 139,598,1072,464,92,374,374,567,495,598,1419,598,712,836,805,
 712,917,586,587,594,941,586,594,595,1447,74,133,1029,74,1029,
 97,321,314,133,1029,69,392,930,385,493,313,1437,1061,74,1029,
 317,97,1226,930,497,80,383,307,378,386,598,1356,1006,904,839,
 798,919,720,469,499,479,720,499,469,479,27,91,972,27,972,94,
 259,259,91,972,77,340,679,350,352,298,1230,1061,27,972,290,
 94,988,679,353,61,258,248,345,362,1061,1230,988,671,646,641,
 680,646,470,443,475,641,500,443,470,2011,2011,2253,2011,2011,
 2317,1477,2278,2278,2011,2394,2011,2334,2334,1477,2659,3,2253,
 2278,2322,2278,2490,2011,2394,2011,2482,2482,2398,2398,2490,
 2659,3,2287,2479,2479,2287,2479,1999,1472,1999,2479,1999,1999,
 1472,2011,2011,2011,2362,2250,2250,2655,2202,2202,2559,2352,
 2321,4,2434,2705,3,2278,2655,2428,2202,2478,2202,2559,2352,
 2428,2321,4,2434,2478,3,2478,2366,2487,2366,2487,2496,2156,5,
 2191,2496,2191,5,2156,2011,2362,2011,1477,2381,2655,2202,2352,
 2413,2202,2567,2445,2445,2393,2250,2278,2655,2553,2202,2250,
 2352,2413,2202,2428,2321,2434,4,2823,2,2,2316,2316,2582,2582,
 3031,2156,2156,2191,2339,2737,3,3,2011,2011,1477,2317,2011,
 2011,2268,2334,2268,2398,2398,2488,3,2490,2253,2011,2482,2011,
 2490,2268,2334,2268,2322,1477,2394,2394,2490,3,2490,2479,2287,
 2287,2479,2479,1472,1999,1999,2479,1999,1472,1999,2011,2381,
 1477,2202,2655,2202,2379,2352,4,2321,2434,2,2,2278,2202,2428,
 2655,2823,2202,2379,2352,2553,2433,2433,2584,2250,2393,2250,
 2582,2582,2316,2316,2339,3,3,2737,3031,2191,2156,2156,1477,
 1477,2202,2655,2352,2239,2202,2445,2567,2445,3,2478,2278,2202,
 2553,2655,2478,2352,2239,2202,2553,2433,2584,2433,2478,2705,3,
 2487,2366,2487,2366,2496,5,2156,2191,2496,2191,2156,5,2250,
 2434,2445,2521,2445,2380,2684,2753,2634,3,2536,2488,2434,3005,
 2445,2536,2521,2445,2380,2716,3,2718,3,2935,2,2,2533,2250,
 2640,2618,2941,2221,2352,2382,2568,2382,2225,1477,2388,2567,
 2424,2424,2422,3,2536,3,2,2,2488,2388,2716,2567,2935,2424,
 2424,2422,3005,2620,2804,2717,2536,2653,3,2640,2618,2533,2250,
 2552,1477,2184,2382,2941,2382,2359,2219,2011,2202,4,2202,4,
 2434,2388,3,2478,2011,2011,2321,2362,2478,2352,2321,2352,2250,
 2250,2559,2559,3,2705,2478,2496,2366,2487,2496,2366,5,2191,
 2156,2487,5,2156,2191,2202,2445,2202,2434,4,2388,2393,2250,
 2011,2362,2321,2011,2250,2352,2567,2352,1477,2251,2413,2413,2,
 2,2823,2339,2316,2582,3031,2582,2156,2191,2156,2316,3,3,2737,
 2424,2011,2235,2235,1477,2736,3,2011,2352,1477,2352,2490,2011,
 2532,2268,2407,2523,2407,2490,3,2736,2490,2378,2491,2491,2486,
 2378,2059,1468,1956,2486,1468,2059,1956,4,3,2700,3,3,2581,
 2398,2321,2477,2567,2581,2532,2398,2422,2731,2536,3008,2700,
 2654,3098,2654,2566,2437,2920,2658,2660,1477,2390,2373,2590,4,
 2362,2245,2406,2406,1477,2440,2361,2011,2352,2251,2352,2361,
 2268,2422,2011,2407,2523,2490,2407,2653,3092,2653,2319,2348,
 2954,2571,2571,2059,1956,1956,2319,2427,2650,2427,2398,2445,2,
 2,2394,2433,2433,2584,2935,2369,2477,2510,2706,2654,2477,3008,
 3,2805,2536,2679,2732,2597,2565,2427,4,1477,2375,2945,2237,
 2373,2362,2445,2784,3,2394,2584,2433,2433,2581,2369,3008,2510,
 3,2477,3,2700,2654,2822,2825,2437,2590,2660,2920,2658,2373,
 1477,2375,2554,2237,4,2362,2751,3,2317,2567,2321,2567,2536,
 2321,2718,2321,2620,3005,2684,2753,2,3210,2,2250,2568,2941,
 2640,2618,2382,2221,2359,2490,1477,2382,2225,2,2659,2,3079,
 2705,2,3092,2,2736,2653,2760,3219,2752,1,1,1,2708,3,1,1,1,
 3,2749,2749,2708,3,3,3,2490,2823,2654,2478,2653,2653,2935,
 2490,2581,2825,2,2581,1,1,1,3,2653,1,1,1,2477,3,2477,2653,
 2251,2251,2251,2011,1477,2011,3,2011,2398,2011,1477,2322,2334,
 2334,3,2659,2490,2479,2479,2479,2479,2287,1999,1999,1472,2287,
 1472,1999,1999,2433,2011,2,2202,4,2202,2251,1477,2379,2379,
 2250,2393,2250,3031,2582,2316,2339,2316,3,2737,3,2582,2156,
 2156,2191,2433,2654,1477,2654,2321,3,2677,3,2536,3,2759,2581,
 2539,2913,2560,2531,2250,2368,2217,2216,2539,1477,2368,2353,3,
 2202,2445,2202,1477,1477,2239,2239,2478,3,2478,2496,2487,2366,
 2496,2487,2156,2191,5,2366,2156,5,2191,2653,2,3,3,2654,2,3,
 1,1,1,2653,2653,1,1,1,2477,2477,3,3,2251,2251,2251,2424,
 2011,2321,2415,4,2321,2361,2440,2361,2571,2954,2348,2319,2319,
 2650,2427,2427,2571,1956,2059,1956,4,2477,3,2477,3,2536,2802,
 3,2945,2679,2565,2427,2597,1477,2390,4,2732,2373,2362,2245,
 2321,2415,2321,4,2490,2736,3,2486,2491,2491,2378,2486,2059,
 1956,1468,2378,1956,2059,1468,2250,2407,2407,2654,2753,2825,
 2560,2531,2539,2913,2539,2353,2368,1477,2250,2216,2217,2368,
 2433,2433,2581,3,2581,2913,2539,2250,2560,2512,2216,2368,2217,
 2539,2353,1477,2368,2398,2536,3,2536,2732,2945,2427,2597,2589,
 2375,4,1477,2679,2372,2237,2373,2825,2793,2654,2590,2554,2658,
 2660,2920,2375,2373,1477,2435,2372,2237,4,2,2653,1,1,2653,
 2653,3,2251,2251,2251,1,3,2477,2477,2,1,1,3,2708,2708,3,3,
 3,1,2749,3,2749,1,1,2653,3,2653,2251,2251,2251,1,2477,2477,
 3,2582,3032,2999,3032,2564,2432,2564,2571,2312,2312,2308,2999,
 3032,3032,2432,2564,2564,2582,2312,2308,2312,2582,2582,2308,
 2312,2312,3032,2564,2432,2564,2571,2312,2308,2312,3032,2564,
 2564,2432,2312,2312,2308,2999,2432,2564,2564,3,3,2564,5,1472,
 5,2427,2564,1468,5,1472,2432,1472,5,1468,2308,2312,2312,3,
 2427,3,1,1,1,3142,3277,3187,3142,3160,3186,3142,3147,3186,
 3276,3142,3142,3186,3266,3186,3142,3276,3266,3142,3186,3266,
 3142,3186,3142,1,1,1,1,3142,3186,3142,3142,1,3290,1,3266,
 3142,1,1,3276,1,1,1,3188,3188,1,1,1,3188,3188,3188,3188,1,
 1,1,3246,2,2147,2147,2124,2147,2124,2138,2147,2124,2138,2057,
 2397,2752,2408,2397,2714,2397,2536,2464,2752,2408,2423,2738,
 2579,2427,2738,2536,1,1,2397,2714,2427,2397,1,2812,2427,2752,
 2712,2427,2427,2738,3,3,3,2,2,2432,2432,2432,3162,3162,3162,
 2,2432,2432,2432,3265,2224,2236,2231,2230,2204,2229,2236,2204,
 2249,2048,2474,2427,2773,2450,2761,2427,2815,3,2450,2773,2450,
 2633,2609,3,2596,2789,1,1,2427,2761,3,2450,1,2821,2450,2450,
 2596,3,3,2613,3,3,3,3218,3218,2461,2461,2461,2,2,2,3218,
 2461,2461,2461,2236,2202,2231,2202,2204,2184,2236,2231,2184,
 2049,2427,2450,2773,2450,2761,2450,2613,3,2427,2773,2450,2789,
 2609,3,2818,2596,1,1,2474,2761,3,2427,1,2821,3,2450,2771,
 2450,2450,2771,3,3,3,2,2,2461,2461,2461,3218,3218,3218,2,
 2461,2461,2461,2410,2410,2399,2351,2351,2399,2499,2436,2436,
 1207,1207,1707,1207,1962,1212,1826,1429,1207,1707,1212,1656,
 1644,1402,1652,1670,3030,3066,1207,1962,1402,1212,3030,2244,
 1412,1209,1656,1412,1412,1669,1417,1427,1413,1960,1963,1404,
 1371,1371,1963,1966,1963,1967,1371,1404,1371,2410,2410,2410,
 2657,2399,2351,2351,2574,1207,1207,1707,1207,1962,1212,1670,
 1433,1207,1707,1212,1652,1644,1412,1669,1653,3030,3030,1207,
 1962,1412,1212,3066,2244,1402,1209,1672,1398,1398,1825,1428,
 1413,1427,1963,1960,1371,1371,1404,1966,1960,1963,1963,1404,
 1371,1371,2351,2481,2351,2499,2334,2503,2334,809,809,1494,809,
 1622,788,1518,1282,809,1494,788,1551,1577,1252,1520,1520,2914,
 2916,809,1622,1252,788,2916,2055,1252,791,1522,1226,1226,1518,
 1286,1297,1297,1655,1655,1245,1257,1245,1645,1655,1646,1645,
 1245,1245,1257,2410,2351,2410,2410,2657,2574,1207,1207,1707,
 1207,1962,1212,1653,1435,1207,1707,1212,1669,1644,1398,1825,
 1657,3066,3030,1207,1962,1398,1212,3108,2244,1412,1209,1825,
 1398,1398,1672,1426,1426,1417,1967,1963,1371,1404,1371,1960,
 1966,1966,1960,1371,1371,1404,2351,2351,2481,2351,2489,809,809,
 1494,809,1622,788,1520,1289,809,1494,788,1520,1577,1226,1518,
 1551,2916,2914,809,1622,1226,788,2915,2055,1252,791,1519,1206,
 1206,1519,1286,1286,1297,1645,1655,1257,1245,1245,1655,1655,
 1645,1655,1245,1257,1245,2436,2503,2657,2436,1030,1030,1583,
 1030,1777,1008,1570,1423,1030,1583,1008,1555,1668,1388,1569,
 1554,2937,2937,1030,1777,1388,1008,2949,2244,1354,1010,1567,
 1365,1365,1660,1431,1403,1438,1725,1712,1341,1341,1379,1704,
 1702,1718,1725,1379,1341,1341,2410,2351,2436,1207,1207,1707,
 1207,1962,1212,1657,1430,1207,1707,1212,1825,1644,1398,1672,
 1671,3108,3066,1207,1962,1398,1212,3066,2244,1398,1209,1669,
 1412,1412,1656,1413,1428,1428,1967,1967,1404,1371,1371,1966,
 1963,1960,1963,1371,1404,1371,2351,2334,809,809,1494,809,1622,
 788,1551,1283,809,1494,788,1518,1577,1206,1519,1522,2915,2916,
 809,1622,1206,788,2915,2055,1226,791,1518,1226,1226,1522,1286,
 1286,1286,1646,1645,1245,1245,1257,1655,1645,1655,1655,1257,
 1245,1245,2436,1030,1030,1583,1030,1777,1008,1554,1415,1030,
 1583,1008,1569,1668,1365,1660,1559,2951,2943,1030,1777,1365,
 1008,2950,2244,1388,1010,1660,1365,1365,1567,1431,1431,1403,
 1854,1725,1341,1379,1341,1702,1704,1704,1712,1341,1341,1379,
 1149,1149,1747,1149,1932,1152,1659,1274,1149,1747,1152,1659,
 1577,1274,1663,1756,3061,3103,1149,1932,1274,1152,3043,2056,
 1205,1105,1662,1205,1205,1662,1306,1295,1305,1900,1895,1270,
 1291,1291,1895,1895,1900,1895,1291,1270,1291,2362,2362,2655,
 2704,2704,2683,3,2655,2936,2362,2683,2362,2653,2981,2477,3153,
 2823,2655,2387,2653,2655,3157,2806,3,2806,3034,2731,2731,2731,
 2745,2745,2,2366,2396,2678,2,2678,2401,2366,2396,2401,2678,
 2678,2,2362,2704,2704,2655,2235,2235,2655,2362,2362,3034,2936,
 2653,2477,2981,3157,2823,2655,2387,2653,2806,3153,2806,2731,
 2655,2683,3,3,2683,2745,2,2745,2366,2401,2,2678,2678,2396,
 2366,2401,2396,2678,2,2678,2362,2512,2362,2477,2752,2936,3029,
 2936,3031,3029,3029,3047,3047,3045,3045,2936,2512,3029,2362,
 3045,2638,2731,2362,3031,2731,2731,2477,3077,2789,2789,2540,
 2540,2731,2731,3029,2540,2540,2540,2540,3029,2731,2731,2704,
 2362,2477,2776,2362,2362,2655,2981,2936,2731,2731,3034,2823,
 3157,2655,2704,2731,2704,3157,2471,2653,2655,2683,3,3,2683,
 2745,2,2745,2401,2366,2,2678,2678,2366,2396,2401,2396,2678,2,
 2678,2704,2352,3,2704,2512,2704,2352,2512,3,2352,2352,3171,
 3171,2387,2789,3,2387,3126,2789,3,2387,2320,2393,2393,2320,
 2761,2761,2761,2704,2704,2714,2714,2714,2704,2704,2387,2387,
 2714,2714,2714,2616,3,2362,2936,2655,2616,2362,2731,3034,2731,
 2823,3153,2655,2704,2731,2655,3153,2471,3,2704,3034,2731,2731,
 2731,2745,2745,2,2396,2366,2678,2,2678,2366,2401,2396,2401,
 2678,2678,2,2235,2981,3047,3034,3047,3031,3077,3212,3152,2823,
 3186,3034,2352,3077,2731,3181,2649,2731,2683,3152,2,2,2,3087,
 2,2795,2559,2478,2758,2745,3047,2591,2664,2661,2559,3047,2758,
 2745,2776,3086,2235,2235,2752,2,3118,2,3254,3255,2790,3,2,
 2790,3271,3,3,3,3127,2,2,2,2808,2808,3,2455,2453,2794,3,
 2794,2453,2455,2466,2465,2794,2794,3,2362,2704,2477,2362,3,
 2683,2683,2823,3153,2704,2704,3,2655,3153,2471,2653,2655,2731,
 2731,2731,3034,2,2745,2745,2396,2366,2678,2678,2,2366,2401,
 2396,2401,2,2678,2678,2362,3047,3029,2731,2477,3031,3045,3045,
 2362,2512,2731,2362,3045,2638,3029,2936,2477,2731,2731,3031,
 2789,2789,3077,2540,2540,2731,3029,2731,2540,2540,2540,2540,
 2731,2731,3029,2235,2362,3,2616,2616,3153,2823,2806,2387,3,
 2655,3157,2806,2731,2655,2731,2731,2731,3034,2,2745,2745,2366,
 2396,2678,2678,2,2401,2366,2396,2401,2,2678,2678,2477,2,3152,
 2,2823,3181,2731,2352,2,3034,3186,2649,2731,2683,3153,3077,
 3077,3152,2,3087,2795,2664,2591,3047,2745,2758,2478,2559,2559,
 2661,2758,3047,2745,2731,3031,2477,3045,3045,2362,2512,2731,
 2936,3045,2638,2731,2362,3047,3029,3029,3047,2789,3077,2789,
 2500,2500,3029,2731,2731,2500,2500,2500,2500,2731,3029,2731,
 2731,2731,1,1,3,2393,2393,2731,1,3,2,2731,2,2,2,3077,3,
 2771,2771,2393,2431,2731,2731,3,2431,2393,2431,2431,3,2731,
 2731,3047,3181,2823,2683,2320,2731,2731,3181,2649,3077,3034,2,
 2,2,3152,2795,2,3087,2591,2661,2758,3047,2745,2559,2478,2569,
 2661,2745,2758,3047,3186,2823,2683,2320,2731,3034,3186,2649,2,
 2731,3152,3077,3077,3212,2795,3087,2,2478,2559,3047,2758,2745,
 2661,2591,2661,2569,2745,3047,2758,3171,3153,3171,1,3157,3171,
 3286,1,3153,3186,1,1,3186,1,1,1,3142,2823,1,1,1,2823,3256,
 3142,3256,1,1,1,3157,3126,1,3153,3286,3286,1,3157,3186,1,1,
 3186,1,1,1,2823,3142,1,1,1,3256,2823,3142,3256,1,1,1,2704,
 3,2362,2823,2806,2731,2362,2477,2653,2653,2981,2,2745,2745,
 2396,2401,2678,2678,2,2396,2401,2366,2366,2,2678,2678,2393,
 2704,3171,2789,3,2704,2352,3,3,2352,2761,2761,2761,2387,2704,
 2714,2714,2714,2704,2387,2704,2704,2714,2714,2714,2731,1,3,2,
 2731,2,2,2,3077,3,2771,2771,2393,2431,2731,2731,3,2431,2393,
 2431,2431,3,2731,2731,2823,2806,2731,2362,2616,3,3,2616,2745,
 2,2745,2401,2396,2,2678,2678,2401,2396,2366,2366,2678,2,2678,
 3286,1,2823,2823,1,1,2823,1,1,1,3142,3256,1,1,1,3142,3256,
 2823,2823,1,1,1,3,2806,2649,3,3,2649,2821,2821,2821,2806,
 2471,2812,2812,2812,2471,2806,2806,2806,2812,2812,2812,3,3077,
 2,2,2,2771,2771,3,2431,2393,2731,3,2731,2393,2431,2431,2431,
 2731,2731,3,2981,2653,2653,2477,2745,2745,2,2396,2401,2678,2,
 2678,2396,2401,2366,2366,2678,2678,2,2731,2731,3047,2,2795,
 3087,2664,2664,2745,3047,2758,2559,2569,2478,2591,2758,2745,
 3047,2393,2731,2771,3,2771,2431,2431,3,2731,2731,2431,2431,
 2393,2393,2731,3,2731,2731,2771,3,2771,2431,2431,3,2731,2731,
 2431,2431,2393,2393,2731,3,2731,3087,2795,2,2661,2661,2745,
 2758,3047,2569,2559,2478,2591,3047,2745,2758,2789,2789,3,3,
 2771,2771,2,3,3,3,3,2,2771,2771,2789,3,3,2,2771,2771,3,3,
 3,3,2771,2,2771,3,3,2771,2,2771,3,3,3,3,2771,2771,2,2704,
 2409,2409,2409,3148,3078,3148,2806,2409,2409,2409,2409,2409,
 2409,3078,3148,3148,2704,2409,2409,2409,2731,2731,2409,2409,
 2409,2409,2731,2653,2731,2731,2409,2409,2409,2409,2731,2731,
 2653,2409,2409,2409,2409,2653,2731,2731,2704,2704,3148,2409,
 2409,2409,2806,3148,2409,2409,2409,3078,2409,2409,2409,2409,
 2409,2409,2731,2731,2731,1,1,4,4,4,4,4,4,4,4,4,1477,3,3,
 2,3,2,3,3,2,3,2,3,3,2,2,3,3,3,3,3,2,2477,3,3,2477,2,
 3,3,2477,2,3,1,1,1,3,3,1,1,1,3,3,3,3,2,2,2,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,2250,2250,2709,2250,2250,2477,2675,2250,2250,
 1014,878,1860,1014,1715,878,1102,1710,1153,1899,1144,1114,1881,
 2069,598,1374,1316,1355,832,1814,1508,1170,1355,1635,1896,1044,
 1005,1813,1955,1392,1,1,1,764,891,2904,2871,2870,747,887,770,
 762,4,4,4,2250,2460,2460,2709,2709,2376,2376,2632,1047,889,
 1861,1046,1817,731,1059,1741,1156,1877,1154,1174,1915,2104,598,
 1390,1355,1349,875,1911,1509,1092,1314,1632,1905,1056,1005,
 1863,1953,1432,1,1,1,847,785,2873,2888,2882,829,746,783,855,
 4,4,4,2376,2706,2376,2675,2457,2745,2457,1157,731,1897,1094,
 1711,731,1007,1925,1175,1897,1097,1199,1889,2126,1005,1377,
 1421,1347,731,1711,1511,1135,1344,1693,1908,1055,598,2026,1936,
 1325,1,1,1,830,818,2890,2885,2881,806,818,743,806,4,4,4,
 2460,2376,2250,2250,2709,2632,1088,875,1876,1156,1911,731,1174,
 1905,1046,1877,1092,1059,1901,2127,1005,1397,1316,1361,889,
 1817,1504,1154,1440,1632,1741,1043,598,1772,1949,1335,1,1,1,
 783,829,2882,2884,2873,785,855,847,746,4,4,4,2250,2250,2706,
 2250,2520,1262,1061,1992,1267,1959,1061,1243,2052,1267,1992,
 1242,1243,2008,2115,1205,1382,1352,1355,1061,1959,1667,1242,
 1411,1928,2052,1238,1205,1945,2054,1414,1,1,1,1018,1081,3003,
 2963,3003,1081,1081,1018,1081,4,4,4,2250,2745,2477,2250,1197,
 878,1881,1159,1774,832,1111,1946,1080,1824,1014,1108,1898,2173,
 1120,1386,1359,1355,878,1780,1498,1079,1315,1676,1902,1086,
 1120,1848,1823,1394,1,1,1,766,761,2871,2870,2879,770,749,888,
 835,4,4,4,2250,2250,2250,1082,832,1898,1153,1814,878,1114,
 1896,1014,1899,1170,1102,1824,2113,1005,1380,1348,1355,878,
 1715,1496,1144,1360,1635,1710,1036,598,2051,1947,1399,1,1,1,
 770,747,2870,2879,2904,891,762,764,887,4,4,4,2376,2457,1117,
 731,1897,1175,1711,731,1199,1908,1094,1897,1135,1007,1889,2074,
 598,1396,1317,1347,731,1711,1505,1097,1316,1693,1925,1073,1005,
 1909,1954,1373,1,1,1,743,806,2881,2869,2890,818,806,830,818,
 4,4,4,2250,1162,878,1893,1080,1780,832,1108,1902,1159,1824,
 1079,1111,1899,2130,1120,1387,1355,1355,878,1774,1498,1014,
 1362,1676,1946,1086,1120,1745,1832,1324,1,1,1,888,770,2879,
 2901,2871,761,835,766,749,4,4,4,1176,996,1948,1172,2042,996,
 1195,2035,1172,1948,1193,1195,1950,2178,598,1252,1285,1247,996,
 2042,1654,1193,1249,1586,2035,1158,598,1732,2053,1272,1,1,1,
 997,956,2961,2990,2961,956,956,997,956,1477,1477,1477,2250,
 2250,2477,2477,2477,2477,2477,2706,2420,2456,2725,2456,2655,3,
 3,2729,3,2677,3164,2595,2706,2763,2752,3189,2752,2653,3029,
 2808,2808,1,1,1,2391,2580,3111,3112,3152,2576,2383,2711,2735,
 3,3,3,2250,2477,2477,2477,2477,2477,2677,2250,2250,2714,2427,
 2653,2250,2427,2710,3,2477,3143,2478,2477,2710,2477,3171,2677,
 2477,3029,2477,2677,1,1,1,2251,2563,2824,3030,3030,2563,2251,
 2563,2563,3,3,3,2250,2387,2250,2250,2477,2420,2789,2420,2426,
 2789,2653,3,3,2393,2393,2427,2704,2523,2456,2472,2638,2723,
 2456,3,2553,2794,3,1,1,1,2357,2357,3101,3101,3161,2357,2356,
 2452,2452,2,2,2,2477,2250,2250,2352,2456,2456,2706,2457,2420,
 2,2,2,3,2721,2677,2772,3001,2772,2763,3113,2780,2706,2,2,
 3266,2,1,1,1,2580,2391,3112,3111,3152,2385,2575,2711,2735,3,
 3,3,2477,2477,2477,2772,2704,2772,2780,2704,2,2,2,2,2,3143,
 3217,3078,3164,3214,3217,3256,3164,3142,3280,3280,3224,1,1,1,
 2619,2619,2823,2823,3172,2619,2619,3151,3151,2,2,2,2250,2477,
 2250,2427,2677,2250,2250,2,2,2,3,2710,2477,2477,2935,2677,
 2710,3077,2477,2477,2,2,3217,2,1,1,1,2563,2251,3030,2824,
 3030,2251,2563,2563,2563,3,3,3,2477,2457,2462,2713,2462,2426,
 2,2,2,3,2722,2714,2780,3010,2787,2769,3124,2787,2725,2,2,
 3278,2,1,1,1,2536,2250,3137,3133,3155,2386,2577,2726,2777,3,
 3,3,2780,2780,2787,2787,2723,2,2,2,2,2,3171,3256,3097,3256,
 3240,3262,3262,3189,1,1,1,1,1,1,1,2477,2647,2823,2823,3182,
 2636,2637,3190,3220,2,2,2,2456,2772,2250,2250,2,2,2,3,2792,
 2477,2477,3034,2706,2729,3113,2352,2477,2,2,3231,2,1,1,1,
 2711,2385,3152,3111,3112,2391,2735,2580,2575,3,3,3,2250,2462,
 2789,2723,2250,2426,2472,2393,2250,2704,2523,2250,2393,2512,
 2780,2420,2250,2644,2477,2426,1,1,1,2357,2452,3101,3161,3101,
 2452,2357,2357,2357,2,2,2,2787,2456,2794,2250,2469,2792,3,
 2477,3164,2595,2477,2721,2477,3256,2706,2477,3097,2477,2712,1,
 1,1,2391,2735,3111,3152,3112,2711,2385,2576,2580,3,3,3,2250,
 2,2,2,3,2799,2477,2477,3044,2713,2653,3124,2477,2477,2,2,
 3234,2,1,1,1,2726,2386,3155,3133,3137,2250,2777,2536,2577,3,
 3,3,2794,3,3,2426,2467,2250,2387,2553,2420,2426,2638,2477,
 2250,3,2644,2757,3,1,1,1,2443,2354,3161,3101,3101,2354,2443,
 2354,2354,2,2,2,2,2,2,2,3161,3164,3164,3182,3241,3235,1,
 3235,3142,1,3288,3288,1,1,1,2727,2,3258,3259,3200,2,2719,
 3184,3211,2,2,2,3,2,3,2477,3142,2477,2477,2653,2477,1,2653,
 2477,2823,2477,2653,1,1,1,2250,2,2823,3143,2823,2,2250,2536,
 2536,3,3,3,2,3,2677,3224,2430,2712,2752,2761,1,2430,2653,
 2823,2809,2,1,1,1,2427,2,3221,3249,3221,2,2475,2690,2764,3,
 3,3,2,2710,2,3054,2763,2,3136,2,2729,2,2,3264,2,1,1,1,
 2729,3,1,1,1,3,2755,2755,2729,3,3,3,2710,3214,2740,2729,
 2731,2731,3273,2763,2653,3077,2,2816,1,1,1,3,2755,1,1,1,
 2721,3,2729,2755,3,3,3,2477,2477,2250,3,2477,2477,2250,2250,
 2731,2477,2427,1,1,1,2563,2563,3030,3030,2824,2563,2563,2251,
 2251,3,3,3,3164,2772,2,3217,2477,2477,2,2,3266,2,1,1,1,
 3151,2619,3172,2823,2823,2619,3151,2619,2619,2,2,2,2477,2755,
 2477,3189,2430,2477,3156,2477,2738,1,1,1,2514,2947,2824,3065,
 3065,2947,2514,2588,2588,2477,2477,2477,3,2477,2787,2456,2250,
 2794,2595,2469,1,1,1,2576,2711,3112,3152,3111,2735,2580,2391,
 2385,3,3,3,2731,2,3,3,2819,2,3,1,1,1,2755,2755,1,1,1,
 2729,2721,3,3,3,3,3,3262,2752,2477,3192,2477,2761,1,1,1,
 2610,3109,3124,3166,3124,3109,2610,2610,2610,2477,2477,2477,
 2477,2,2,3278,2,1,1,1,3190,2636,3182,2823,2823,2647,3220,
 2477,2637,2,2,2,3,2794,2794,3,1,1,1,2735,2580,3152,3112,
 3111,2575,2715,2385,2391,3,3,3,2,2477,3,1,1,1,2536,2,2823,
 3143,2823,2,2536,2250,2250,3,3,3,3280,2,1,1,1,3058,2,3260,
 3260,3200,2,3058,2791,2791,2477,2477,2477,2808,1,1,1,2477,
 3233,2823,3194,2823,3251,2477,2648,2643,2,2,2,1,1,1,2689,2,
 3221,3249,3221,2,2778,2427,2470,3,3,3,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,2619,3021,3038,3038,2666,2461,2666,2610,3,3,3,
 3038,3021,3038,2461,2666,2666,2619,3,3,3,3101,3101,3038,3021,
 3038,3038,1,1,1,3101,3017,3038,3038,3038,1,1,1,3038,3038,
 3021,3021,1,1,1,2619,2619,2666,3,3,3,2610,2666,3,3,3,2461,
 3,3,3,3,3,3,2,2,2,1,2975,3014,2967,3088,2936,2953,2964,
 2979,3039,2978,3070,2935,3122,3107,3060,2936,3138,3075,3089,
 3029,3074,3138,3120,3222,2935,3217,1,1,2935,3060,3029,3037,1,
 3056,3075,3070,2935,3226,3029,3281,1,1,1,3016,3016,3173,3159,
 3173,1,1,1,3016,3022,3022,3018,4,4,4,4,4,4,4,4,4,1477,3,
 3,2,3,2,3,2477,3,3,2,3,2,2477,3,2,2477,1,1,3,2,3,3,1,
 2,3,3,2,3,3,2,3,3,3,2,2,3,3,3,1,1,1,2,3,3,3,1474,
 1474,2311,1448,1448,2311,2330,1464,1464,116,70,1029,116,1029,
 74,455,354,70,1029,109,327,864,323,325,370,598,1350,116,1029,
 373,74,1320,864,327,107,372,351,406,316,1345,1226,1350,469,
 477,904,720,879,768,918,879,505,505,466,502,1474,1474,1474,
 2266,2311,1448,1448,2276,116,70,1029,116,1029,74,370,454,70,
 1029,109,325,864,406,316,398,1006,1425,116,1029,351,74,1345,
 864,323,107,391,398,316,406,1320,598,1418,502,469,720,918,
 904,918,720,768,477,466,502,469,1448,2657,1448,2330,1460,2280,
 1460,113,111,1009,113,1009,48,306,308,111,1009,93,401,977,
 324,309,310,597,1337,113,1009,294,48,1310,977,320,115,300,
 388,315,315,1310,598,1331,589,596,726,714,678,667,714,640,
 590,585,583,589,1474,1448,1474,1474,2266,2276,116,70,1029,116,
 1029,74,398,391,70,1029,109,316,864,316,406,351,598,1320,116,
 1029,398,74,1418,864,406,107,454,370,325,323,1425,1006,1345,
 466,502,918,768,720,720,904,918,469,502,469,477,1448,1448,
 2657,1448,2311,113,111,1009,113,1009,48,310,311,111,1009,93,
 309,977,315,315,388,598,1363,113,1009,388,48,1336,977,324,
 115,311,310,309,324,1363,598,1336,583,589,714,667,726,714,
 726,667,596,583,589,596,1464,2280,2255,1464,83,76,736,83,736,
 8,208,240,76,736,47,220,694,240,219,211,598,1311,83,736,221,
 8,1329,694,207,84,219,211,219,240,1330,598,1312,435,424,609,
 624,615,624,609,634,436,460,435,424,1474,1448,1464,116,70,
 1029,116,1029,74,351,372,70,1029,109,406,864,325,323,373,
 1226,1345,116,1029,370,74,1350,864,316,107,354,455,327,327,
 1350,598,1320,505,466,768,879,918,904,879,720,502,469,477,
 505,1448,1460,113,111,1009,113,1009,48,388,300,111,1009,93,
 315,977,309,324,294,598,1310,113,1009,310,48,1331,977,315,
 115,308,306,401,320,1337,597,1310,585,583,667,640,714,726,
 678,714,589,589,596,590,1464,83,76,736,83,736,8,211,219,76,
 736,47,219,694,219,240,221,598,1330,83,736,211,8,1312,694,
 240,84,240,208,220,207,1311,598,1329,460,435,624,634,609,609,
 615,624,424,435,424,436,112,79,1169,112,1169,66,296,312,79,
 1169,95,299,721,319,319,384,988,1284,112,1169,384,66,1281,
 721,297,110,312,296,299,297,1284,988,1281,480,506,728,819,
 719,728,719,819,481,480,506,481,2202,2202,2655,2011,2011,2413,
 1477,2320,2655,2058,2251,2058,2251,2413,1477,2478,3,2655,2655,
 2413,2278,2734,2202,2413,2202,2567,2567,1474,1474,2705,2478,3,
 5,2156,2496,2366,2487,2487,2366,2496,2191,2156,2191,5,2202,
 2202,2202,2268,2712,2712,2320,2058,2058,2528,2320,2369,1477,
 2369,2490,3,2320,2352,2321,2011,2724,2011,2528,2352,2251,2369,
 1477,2369,2724,3,2736,1468,2059,2378,2491,2486,2491,2378,2486,
 1956,1956,1468,2059,2011,2655,2011,1477,2413,2352,2202,2397,
 2379,2202,2567,1474,1474,2250,2442,2655,2362,2567,2011,2393,
 2352,2381,2011,2379,2251,2413,1477,3202,2,2,2191,2156,2582,
 2582,3031,2316,2339,2316,2156,2737,3,3,2202,2011,1477,2379,
 2202,2202,2397,2413,2352,1474,1474,2567,3,2734,2655,2011,2567,
 2011,2705,2352,2251,2362,2379,1477,2413,2251,2734,3,2705,2191,
 5,2366,2487,2496,2366,2496,2487,2156,2191,5,2156,2011,2379,
 1477,2058,2655,2058,2381,2320,1477,2413,2251,2,2,2655,2202,
 2413,2278,3202,2202,2379,2655,2567,1474,1474,2567,2393,2250,
 2393,3,3,2339,2316,2316,2582,2582,3031,2737,2156,2191,2156,
 2616,2616,2011,2278,2268,2616,2011,2333,2485,2333,3,2659,2278,
 2011,2485,2253,2659,2268,2616,2011,2485,2333,2485,2333,2659,
 2490,3,1999,1472,2479,2287,2479,2287,2479,2479,1999,1999,1999,
 1472,2712,2369,1474,2559,1474,2406,2608,2767,2674,3,2742,2567,
 2251,3010,2333,2713,2528,2333,2381,2608,2250,2674,2250,3085,
 2654,2768,2389,1477,2551,2549,2917,2371,2548,2522,2360,2374,
 2228,2202,2251,2567,2388,2388,2321,2250,2674,2250,2,2,2567,
 2379,2674,2485,3206,2712,2712,2413,3024,2608,2801,2674,2653,
 2536,3,2218,1477,2555,2250,2509,2586,2593,2938,2374,2360,2374,
 2220,2202,2058,1477,2011,1477,2369,2321,3,2724,2202,2202,2369,
 2268,2736,2320,2369,2352,2712,2712,2528,2528,3,2490,2724,1956,
 1468,2491,2486,2378,2378,2486,2491,2059,1468,2059,1956,2058,
 1474,2202,2413,1477,2413,2250,2393,2011,2655,2251,2011,2393,
 2320,2567,2655,1477,2379,2381,2379,2,2,3202,2156,2191,2582,
 3031,2582,2339,2316,2316,2156,3,3,2737,2388,2058,2060,2060,
 2060,2478,3,2058,2397,2060,2268,2682,2058,2559,2397,2388,2559,
 2388,2559,3,2478,2682,5,2164,2484,2484,2251,2484,2251,2484,
 2164,5,2164,2164,1477,2250,2608,2250,3,2653,1474,2413,2608,
 2485,2750,2528,1474,2379,2801,2674,3024,2608,2,2935,2,2355,
 2220,2938,2586,2593,2250,2526,2555,2374,2228,2374,1477,2321,
 2369,1477,2361,2425,2202,2352,2369,2268,2440,2320,2406,2202,
 2712,2528,2528,2712,2765,2824,2765,1956,1956,2954,2571,2571,
 2319,2319,2348,2059,2427,2650,2427,1474,2333,2,2,2413,1474,
 1474,2485,3206,2369,2608,2567,2674,2767,2608,3010,3,2536,2653,
 1477,2228,2555,2509,2250,2593,2586,2938,2374,2220,2374,2360,
 1474,2536,3,2251,2567,2333,2333,2653,2321,3010,2567,2250,2608,
 2250,2608,2,2,3206,2220,2374,2593,2938,2586,2555,2250,2509,
 2360,1477,2228,2374,2581,3,2413,2567,1474,2485,2742,2369,2674,
 1474,2674,3010,2608,2767,2768,2825,2770,1477,2360,2917,2551,
 2549,2522,2371,2547,2374,2220,2374,2228,2,2478,2,2825,2490,2,
 2824,2,2478,2536,2654,2935,2536,1,1,1,2477,3,1,1,1,3,2653,
 2653,2477,2251,2251,2251,2705,3202,2768,2659,2765,2765,3206,
 2734,2653,3085,2,2750,1,1,1,3,2749,1,1,1,2708,3,2708,2749,
 3,3,3,2202,1477,2011,3,2058,1474,2202,1477,2413,2251,2413,3,
 2478,2734,2156,2191,2487,2496,2366,2496,2487,2366,5,5,2156,
 2191,1474,2011,2,2202,1477,2011,2413,1477,2379,2381,2442,2250,
 2393,2737,3,2316,2316,2339,2582,3031,2582,3,2191,2156,2156,
 2333,2770,1477,2767,1474,2250,2674,2250,2674,3,2581,2742,2220,
 2374,2522,2547,2371,2917,2549,2551,2228,1477,2360,2374,3,2011,
 2333,2011,2616,2616,2616,2616,2659,3,2659,1999,1999,2287,2479,
 2479,2479,2479,2287,1472,1999,1472,1999,2765,2,3,3,2768,2,3,
 1,1,1,2749,2749,1,1,1,2708,2708,3,3,3,3,3,2712,2202,2321,
 2406,1477,2406,2425,2361,2440,2427,2650,2319,2348,2319,2954,
 2571,2571,2427,1956,1956,2059,1477,2674,2250,2608,2250,2750,
 2536,3,2389,1477,2509,2250,2555,2586,2938,2593,2228,2374,2360,
 2202,2413,2381,2379,1477,2734,2478,3,2191,2156,2487,2366,2496,
 2487,2496,2366,5,2191,2156,5,2712,2388,2712,2,2,3206,2360,
 2374,2586,2938,2593,2555,2509,2250,2220,2218,1477,2374,1474,
 2333,2742,3,2713,2374,2228,2371,2522,2548,2551,2917,2549,2202,
 2389,1477,2360,1474,2653,3,2750,2228,2374,2250,2555,2526,2938,
 2593,2586,1477,2355,2220,2374,3206,2,2,2374,2360,2586,2593,
 2938,2509,2555,2250,2202,2389,1477,2228,2,2765,3,3,2708,2708,
 3,1,1,1,3,3,2749,2749,2,2251,2251,3,2653,2653,1,1,1,2251,
 2477,3,2477,3,3,2708,3,2708,1,1,1,3,2749,2749,3,3,2312,
 2312,2307,2564,2432,2564,2427,5,1468,5,2312,2308,2312,2432,
 2564,2564,3,1468,5,1472,2582,2582,3032,3032,3002,2308,2564,
 2432,2564,2571,3002,3032,3032,2312,2564,2564,2432,3032,3002,
 3032,2312,2432,2564,2564,2582,2582,2564,2312,2312,2308,2571,
 2564,2307,2312,2312,2432,2312,2308,2312,5,1472,5,3,2427,3,
 3142,3142,3147,3277,3160,3186,3142,3187,3186,3276,3142,3142,
 3186,3266,3186,3142,1,3142,3142,3186,3266,1,3290,1,3142,3142,
 1,1,3142,3186,1,3142,1,3186,3276,3266,3266,3276,3142,1,1,1,
 1,1,1,3188,3188,3188,1,1,1,1,3188,3188,3188,2250,2250,2677,
 2250,2250,2709,2746,2448,2448,1046,889,1817,1047,1861,731,1741,
 1059,1088,1894,1101,1633,1625,1328,1504,2127,1,1,875,1876,
 1005,1161,1,1918,1165,1093,1509,1384,598,1772,1314,1440,1316,
 2873,2888,847,785,837,4,4,4,2886,783,823,824,2250,2376,2376,
 2709,2477,2250,2250,2646,1014,878,1715,1014,1860,878,1710,1102,
 1082,1807,1076,1637,1629,1372,1496,2113,1,1,832,1898,1005,
 1203,1,1893,1180,1086,1508,1321,598,2051,1355,1360,1348,2904,
 2871,764,891,834,4,4,4,2877,770,816,748,2458,2706,2458,2675,
 2369,2682,2369,1094,731,1711,1157,1897,731,1925,1007,1117,1711,
 1143,1696,1693,1335,1505,2074,1,1,731,1897,598,1099,1,1889,
 1166,1073,1511,1416,1005,1909,1344,1316,1317,2890,2885,830,818,
 808,4,4,4,2891,743,808,830,2376,2458,2376,2376,2477,2553,
 1218,1021,2018,1215,1991,1062,1973,1266,1215,2050,1260,1685,
 1684,1410,1666,2121,1,1,1021,1991,1205,1260,1,2006,1237,1239,
 1666,1410,1205,1922,1340,1340,1424,2957,2989,1070,1045,1024,4,
 4,4,2958,1070,1024,1131,2250,2250,2639,2250,2631,1100,886,
 1726,1155,1859,886,1924,1118,1173,1726,1137,1636,1692,1395,
 1500,2139,1,1,886,1859,598,1048,1,1912,1160,1074,1510,1376,
 1005,1873,1364,1316,1346,2881,2909,885,807,814,4,4,4,2890,
 754,814,885,2361,2673,2677,2361,1110,889,1734,1168,1914,872,
 1923,1184,1145,1714,1090,1638,1694,1434,1502,2123,1,1,889,
 1913,1171,1042,1,1858,1116,1054,1502,1326,1171,2037,1316,1355,
 1439,2883,2872,745,783,822,4,4,4,2887,863,845,773,2376,2250,
 2361,1153,832,1814,1082,1898,878,1896,1114,1014,1807,1203,1686,
 1614,1321,1508,2069,1,1,878,1860,598,1076,1,1893,1098,1036,
 1496,1372,1005,1813,1360,1355,1316,2870,2879,770,747,816,4,4,
 4,2880,764,834,835,2250,2369,1192,886,1726,1173,1859,886,1941,
 1164,1155,1726,1048,1631,1692,1376,1510,2118,1,1,886,1859,
 1005,1137,1,1912,1113,1052,1500,1395,598,1754,1316,1364,1343,
 2869,2869,754,744,814,4,4,4,2890,885,814,754,2448,1240,1062,
 1990,1288,2007,1013,2046,1224,1288,1961,1213,1697,1933,1389,
 1650,2174,1,1,1062,2007,1227,1213,1,1984,1222,1221,1650,1389,
 1227,1935,1436,1436,1339,2989,2956,1033,1064,1028,4,4,4,2960,
 1033,1028,1017,974,600,1851,973,1695,600,1887,986,973,1851,
 973,1598,1532,1253,1501,2150,1,1,600,1695,599,985,1,1699,987,
 957,1499,1228,599,1761,1275,1217,1234,2889,2889,715,723,716,
 1477,1477,1477,2889,717,716,715,2477,2477,2477,2250,2250,2352,
 2250,2706,3164,2752,2757,2752,2,3034,2,1,1,2677,2420,2,2706,
 1,2456,2457,2456,3001,2,2,2,2763,2729,3,3112,3111,2580,2391,
 2735,3,3,3,3152,2711,2576,2383,2477,2250,2250,2477,2477,2477,
 2677,2477,2477,3101,3077,2677,2477,3161,1,1,2477,2427,2477,
 2250,1,2250,2714,2677,2478,2427,2250,2731,2710,3,2710,2824,
 3030,2251,2563,2563,3,3,3,3030,2563,2251,2563,2477,2387,2477,
 2477,2477,3164,3217,3164,3230,3217,3224,3164,3164,1,1,3143,
 2704,3142,2772,1,2704,2780,2772,3078,2,2,2,3214,2,2,2823,
 2823,2619,2619,3151,2,2,2,3172,3151,2619,2619,2250,2477,2477,
 2477,2772,2772,2706,3130,3113,2430,2430,3256,1,1,2677,2456,
 2653,2456,1,2420,2725,2706,2595,3,3,2794,2763,3,2721,3111,
 3112,2391,2580,2735,3,3,3,3152,2711,2385,2575,2250,2477,2250,
 2456,2704,2456,2644,2638,3,2553,2794,1,1,2427,2789,3,2420,1,
 2789,2426,2420,2523,3,3,2644,2472,2393,2393,3101,3101,2357,
 2357,2452,2,2,2,3161,2452,2357,2356,2477,2250,2477,3143,2677,
 2477,2477,2,2935,2,1,1,2477,2250,2,2677,1,2427,2250,2250,
 2935,2,2,2,2710,2710,3,3030,2824,2563,2251,2563,3,3,3,3030,
 2563,2563,2251,2477,3189,3236,3235,3236,3235,1,3189,1,1,1,
 3171,2723,1,2787,1,2780,2787,2780,3097,2,2,2,3240,2,2,2823,
 2823,2477,2647,3220,2,2,2,3182,3190,2615,2635,2725,3169,2447,
 2447,2761,2,3044,2,1,1,2714,2426,2,2713,1,2462,2462,2457,
 3010,2,2,2,2769,2653,3,3137,3133,2536,2250,2762,3,3,3,3155,
 2726,2571,2384,2772,2456,2477,2477,3,2595,2655,1,1,2250,2250,
 3,2706,1,2420,2477,2477,2430,2430,2653,3029,3,2763,2729,3152,
 3112,2711,2576,2385,3,3,3,3111,2391,2735,2580,2477,3236,3217,
 2780,2477,3256,1,1,2477,2704,2477,2477,1,2387,3169,3164,2477,
 2780,2477,3230,2,2,3214,2823,3172,2619,3151,2619,2,2,2,2823,
 2619,2619,3151,2447,2752,2469,2595,2794,1,1,2250,2420,2250,
 2477,1,2250,2713,2706,2477,2712,2477,3097,3,2729,2763,3112,
 3152,2580,2735,2391,3,3,3,3111,2385,2575,2715,2477,2,3072,2,
 1,1,2477,2523,2,3130,1,2644,2477,2477,3230,2823,2823,3164,
 2731,3140,2731,3189,2823,3128,2612,2614,2477,2477,2477,2823,
 2581,3128,2612,2,3059,2,1,1,2477,2512,2,3113,1,2638,2477,
 2477,3162,2823,2823,3162,2731,3136,2731,3166,3124,3109,2610,
 2610,2477,2477,2477,3124,2610,3109,2610,2430,2,1,1,2427,3,3,
 2712,1,2426,2,2,2738,2,2653,2823,3,2820,2,3221,3249,2778,2,
 2427,3,3,3,3221,2470,2690,2,3164,1,1,2478,2523,2477,2477,1,
 2523,3010,3001,2477,2738,2477,3156,2740,2755,3054,3065,3065,
 2588,2947,2514,2477,2477,2477,2824,2514,2588,2947,1,1,2653,
 2653,2,3182,1,2723,2,2,3212,3212,3142,1,2,3241,2,3200,3259,
 3184,2,2720,2,2,2,3258,2727,3211,2,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2250,2250,
 2477,1,2250,2477,2477,2477,2677,2477,3029,3,2710,2710,3030,
 3030,2563,2563,2251,3,3,3,2824,2251,2563,2563,3,2456,1,2789,
 2250,2250,2553,3,3,2553,2393,2472,2393,3161,3101,2452,2357,
 2357,2,2,2,3101,2357,2452,2357,2477,1,2250,2,2,2477,2653,
 2477,2823,3,2653,2,2823,3143,2536,2,2250,3,3,3,2823,2250,
 2536,2,1,2250,2787,2772,2595,2469,2250,2794,2729,3,2792,3111,
 3152,2385,2711,2575,3,3,3,3112,2580,2391,2735,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2462,2456,2523,2426,
 2250,2644,2426,2426,2467,3101,3161,2354,2443,2354,2,2,2,3101,
 2354,2354,2443,2250,3044,2,2,2,2714,2800,3,3155,3133,2766,
 2250,2536,3,3,3,3137,2578,2726,2386,3034,2,2,2,2721,2792,3,
 3152,3111,2735,2391,2580,3,3,3,3112,2576,2711,2385,2430,2477,
 3162,2755,2740,3054,2824,3065,2514,2947,2588,2477,2477,2477,
 3065,2588,2514,2947,3,2,2820,3,2,3221,3249,2470,2,2690,3,3,
 3,3221,2778,2427,2,2,2653,3,2,2823,3143,2250,2,2536,3,3,3,
 2823,2536,2250,2,3077,2819,2,3200,3260,2791,2,3058,2477,2477,
 2477,3260,3058,2791,2,2,2731,1,1,2755,2755,3,3,3,3,1,3,
 2729,2721,2,1,1,3,2729,2729,3,3,3,1,2755,3,2755,1,1,2755,
 3,2755,3,3,3,1,2729,2721,3,3101,3021,3038,3038,1,1,1,3101,
 3038,3017,3038,3038,3021,3038,1,1,1,3101,3038,3038,3021,2619,
 2619,3,3,3,3038,2666,2461,2666,2610,3,3,3,3038,2666,2666,
 2461,3,3,3,3021,2461,2666,2666,2,2,1,3,3,3,2,1,3,3,3,1,
 3,3,3,3021,3038,3038,2619,2610,2619,2250,2250,2709,2250,2250,
 2477,2675,2250,2250,878,1014,1715,1153,1899,1144,2051,598,832,
 1814,1170,1947,1635,1005,2113,1496,1,1,1082,1898,1380,878,1,
 1824,1399,1036,1896,1114,1102,1710,1355,1348,1360,4,4,891,764,
 762,2870,2904,2879,4,770,747,887,2250,2460,2460,2709,2709,
 2376,2376,2632,889,1046,1817,1156,1877,1154,1772,598,875,1911,
 1092,1949,1632,1005,2127,1504,1,1,1088,1876,1397,731,1,1901,
 1335,1043,1905,1174,1059,1741,1361,1316,1440,4,4,785,847,855,
 2882,2873,2884,4,783,829,746,2376,2706,2376,2675,2457,2745,
 2457,731,1094,1711,1175,1897,1097,1909,1005,731,1711,1135,1954,
 1693,598,2074,1505,1,1,1117,1897,1396,731,1,1889,1373,1073,
 1908,1199,1007,1925,1347,1317,1316,4,4,818,830,806,2881,2890,
 2869,4,743,806,818,2460,2376,2250,2250,2709,2632,875,1156,
 1911,1046,1877,1092,1863,1005,889,1817,1154,1953,1632,598,2104,
 1509,1,1,1047,1861,1390,731,1,1915,1432,1056,1741,1059,1174,
 1905,1349,1355,1314,4,4,829,783,746,2873,2882,2888,4,847,785,
 855,2250,2250,2706,2250,2520,1061,1267,1959,1267,1992,1242,
 1945,1205,1061,1959,1242,2054,1928,1205,2115,1667,1,1,1262,
 1992,1382,1061,1,2008,1414,1238,2052,1243,1243,2052,1355,1352,
 1411,4,4,1081,1018,1081,3003,3003,2963,4,1018,1081,1081,2250,
 2745,2477,2250,878,1159,1774,1080,1824,1014,1745,1120,878,1780,
 1079,1832,1676,1120,2130,1498,1,1,1162,1893,1387,832,1,1899,
 1324,1086,1902,1108,1111,1946,1355,1355,1362,4,4,761,766,835,
 2879,2871,2901,4,888,770,749,2250,2250,2250,832,1153,1814,
 1014,1899,1170,1813,1005,878,1715,1144,1955,1635,598,2069,1508,
 1,1,1014,1860,1374,878,1,1881,1392,1044,1710,1102,1114,1896,
 1355,1316,1355,4,4,747,770,887,2904,2870,2871,4,764,891,762,
 2376,2457,731,1175,1711,1094,1897,1135,2026,598,731,1711,1097,
 1936,1693,1005,2126,1511,1,1,1157,1897,1377,731,1,1889,1325,
 1055,1925,1007,1199,1908,1347,1421,1344,4,4,806,743,818,2890,
 2881,2885,4,830,818,806,2250,878,1080,1780,1159,1824,1079,
 1848,1120,878,1774,1014,1823,1676,1120,2173,1498,1,1,1197,
 1881,1386,832,1,1898,1394,1086,1946,1111,1108,1902,1355,1359,
 1315,4,4,770,888,749,2871,2879,2870,4,766,761,835,996,1172,
 2042,1172,1948,1193,1732,598,996,2042,1193,2053,1586,598,2178,
 1654,1,1,1176,1948,1252,996,1,1950,1272,1158,2035,1195,1195,
 2035,1247,1285,1249,1477,1477,956,997,956,2961,2961,2990,1477,
 997,956,956,2477,2477,2677,2250,2250,2731,2250,2477,3143,2477,
 2477,2477,2477,3161,2477,1,1,2677,2427,2677,2477,1,2250,2427,
 2250,3171,2714,2477,2477,2710,2710,3,3,3,2563,2251,2563,3030,
 2824,3030,3,2563,2563,2251,2477,2456,2456,2706,2,2,2677,2772,
 2772,3231,3113,2,2,3034,1,1,2706,2420,2,2250,1,2250,2,2477,
 2780,2457,2250,2352,2792,3,2729,3,3,2391,2580,2735,3152,3112,
 3111,3,2711,2385,2575,2772,2704,2772,2,2,3143,3217,3164,3266,
 3217,3142,3164,3164,1,1,3164,2704,3224,2477,1,2387,2,2477,
 3256,2780,2477,2477,3214,2,2,2,2,2619,2619,3151,3172,2823,
 2823,2,3151,2619,2619,2456,2772,2,2,2477,2477,2706,3266,3113,
 2,2,3001,1,1,2477,2250,2,2250,1,2420,2,2706,2352,2250,2457,
 2780,2721,3,2763,3,3,2385,2711,2575,3112,3152,3111,3,2580,
 2391,2735,2250,2644,2250,2250,2704,2250,2477,2512,2250,2723,
 2523,1,1,2420,2789,2426,2427,1,2789,2426,2420,2780,2462,2462,
 2780,2393,2472,2393,2,2,2452,2357,2357,3101,3101,3161,2,2357,
 2452,2357,2794,2250,2477,3164,2477,2595,2477,2477,3182,2477,1,
 1,2706,2456,2712,2677,1,2420,2469,2456,3256,2787,2713,2787,
 2729,2763,3,3,3,2735,2391,2580,3112,3111,3152,3,2576,2711,
 2385,2,3029,3280,3097,3280,3192,2823,1,3156,1,1,3029,2553,
 2823,2,1,2644,2,2794,1,2,2,2,3077,2,2819,2477,2477,2,2791,
 3058,3260,3200,3260,2477,3058,2,2791,2477,3142,2477,2477,2477,
 2477,3142,2477,1,1,2653,3,2653,2,1,3,3,3,1,2,2,2,2653,2,
 3,3,3,2,2250,2536,2823,2823,3143,3,2536,2,2250,2477,2250,
 2477,2477,2250,2653,2478,1,1,2250,2250,2427,2477,1,2427,2677,
 2677,2477,2477,2714,3171,3,2710,2710,3,3,2563,2563,2251,2824,
 3030,3030,3,2251,2563,2563,2772,3280,3217,2,2,3078,1,1,2477,
 2387,2,2477,1,2704,3224,3164,2477,2477,2780,3256,2,2,3214,2,
 2,2619,3151,2619,2823,3172,2823,2,2619,2619,3151,2477,2477,
 2250,2794,2595,1,1,2456,2420,2469,2677,1,2456,2712,2706,2787,
 2713,2787,3256,3,2792,2721,3,3,2711,2576,2385,3111,3112,3152,
 3,2391,2735,2580,2477,2477,3288,2477,1,1,2808,2794,2809,3217,
 1,2757,2808,2794,1,3278,3234,3278,2,3264,2,2,2,3251,2648,
 2477,2823,2823,3194,2,2477,3233,2643,2477,3235,2477,1,1,2752,
 2638,2761,3077,1,2638,2761,2752,3262,3124,3124,3262,2731,3136,
 2731,2477,2477,3109,2610,2610,3124,3124,3166,2477,2610,3109,
 2610,2,2477,1,1,3,3,3,2,1,3,2653,2653,2,2,2,1,3,2,2653,
 3,3,2,2536,2250,2823,2823,3143,3,2250,2,2536,3164,1,1,2655,
 2653,2,2,1,2794,3288,3235,2,2,2,1,2,2,3241,2,2,2,3184,
 2719,3258,3200,3259,2,2727,2,3211,1,1,2595,2523,2430,2935,1,
 2553,2738,2430,3097,3010,3044,3189,2740,3054,2755,2477,2477,
 2947,2588,2514,2824,3065,3065,2477,2514,2947,2588,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 2250,3,2477,1,2456,2808,2752,2477,2477,2725,3189,3,2729,2763,
 3,3,2576,2711,2383,3111,3152,3112,3,2391,2580,2735,3,2250,1,
 2789,3,2456,2477,2250,2426,2723,2393,2393,2472,2,2,2357,2452,
 2356,3101,3161,3101,2,2357,2357,2452,2,1,3,2,2430,2,2,2,1,
 3,2,2752,3,3,2,2690,2475,3221,3221,3249,3,2427,2,2764,1,
 2250,2,2477,2477,2250,2250,2477,2710,3,2710,3,3,2251,2563,
 2563,3030,3030,2824,3,2563,2251,2563,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,3,2250,2723,2426,2250,2477,2467,
 2426,2426,2,2,2354,2354,2443,3161,3101,3101,2,2443,2354,2354,
 3,1,2,2,2,2816,2,3,3,3,2,2427,2778,3221,3221,3249,3,2689,
 2,2470,3189,2725,2477,2477,2763,2729,3,3,3,2575,2385,2715,
 3152,3111,3112,3,2735,2580,2391,2477,2787,3262,2,2,3240,2,2,
 2636,3190,2637,2823,3182,2823,2,2477,2647,3220,2462,2787,2722,
 3,2769,3,3,2386,2726,2577,3137,3155,3133,3,2536,2250,2777,
 2477,2799,3,2653,3,3,2250,2536,2777,3155,3137,3133,3,2726,
 2386,2577,3273,2,2,2,2,2647,2477,3220,3182,2823,2823,2,3190,
 2636,2637,2,2731,3,3,2721,2729,3,1,1,1,3,3,2755,2755,2,3,
 3,3,2755,2755,1,1,1,3,2729,3,2729,3,3,2729,3,2721,1,1,1,
 3,2755,2755,3,2,3,3,3,1,1,1,2,3,3,3,3,3,3,1,1,1,2,3,
 3,3,2619,2619,3038,3038,3017,3,2666,2461,2666,2610,3038,3021,
 3038,3,2666,2666,2461,3021,3038,3038,3,2461,2666,2666,3101,
 3101,1,3021,3038,3038,3101,1,3038,3038,3021,1,3038,3021,3038,
 3,3,3,2619,2610,2619,2653,2731,2731,2731,3029,2731,2731,2731,
 1211,1211,1461,1211,1461,1469,1454,1454,1211,1461,1469,1470,
 1446,1458,1456,1456,1476,1454,1211,1461,1454,1469,1454,1446,
 1454,1119,1454,1470,1454,1454,1454,1441,1441,1256,1256,1256,
 1256,1370,1370,1256,1181,1370,1181,1370,1256,2731,2731,2731,
 3029,2731,2731,2731,1211,1211,1461,1211,1461,1469,1454,1454,
 1211,1461,1469,1470,1446,1458,1456,1456,1476,1454,1211,1461,
 1454,1469,1454,1446,1454,1119,1454,1470,1454,1454,1454,1441,
 1441,1256,1256,1256,1256,1370,1370,1256,1181,1370,1181,1370,
 1256,2731,2731,3029,3029,3029,3029,1485,1485,2257,1485,2257,
 2281,2292,2272,1485,2257,2281,2282,2257,2272,2292,2282,2405,
 2405,1485,2257,2296,2281,2397,2257,2285,1489,2285,2282,2292,
 2272,2405,2397,2250,1483,1481,1481,1483,1483,1483,1481,1484,
 1483,1484,1483,1481,2653,2731,3029,2731,2731,1461,1461,1444,
 1461,1444,1245,1466,1455,1461,1444,1245,1457,1465,1450,1452,
 1445,1441,1441,1461,1444,1459,1245,1441,1465,1449,1185,1449,
 1457,1466,1455,1441,1475,1454,1182,1256,1256,1182,1369,1369,
 1256,1370,1369,1370,1369,1256,2731,3029,2731,2731,1461,1461,
 1444,1461,1444,1245,1466,1455,1461,1444,1245,1457,1465,1450,
 1452,1445,1441,1441,1461,1444,1459,1245,1441,1465,1449,1185,
 1449,1457,1466,1455,1441,1475,1454,1182,1256,1256,1182,1369,
 1369,1256,1370,1369,1370,1369,1256,3029,2731,2731,1485,1485,
 2257,1485,2257,2281,2285,2282,1485,2257,2281,2285,2257,2296,
 2296,2272,2397,2250,1485,2257,2272,2281,2405,2257,2282,1489,
 2282,2285,2285,2282,2250,2397,2405,1483,1484,1484,1483,1484,
 1484,1484,1483,1484,1483,1484,1484,2731,2731,1495,1495,2256,
 1495,2256,2281,2273,2293,1495,2256,2281,2284,2271,2283,2294,
 2293,2323,2364,1495,2256,2283,2281,2323,2271,2284,1514,2284,
 2284,2273,2293,2364,2301,2364,1513,1524,1524,1513,1528,1528,
 1524,1528,1528,1528,1528,1524,2653,1444,1444,1463,1444,1463,
 2659,1452,1445,1444,1463,2659,1445,1444,1459,1467,1452,1441,
 1441,1444,1463,1449,2659,1475,1444,1471,1185,1471,1445,1452,
 1445,1441,1454,1441,1225,1318,1318,1225,1060,1060,1318,1319,
 1060,1319,1060,1318,1444,1444,1463,1444,1463,2659,1452,1445,
 1444,1463,2659,1445,1444,1459,1467,1452,1441,1441,1444,1463,
 1449,2659,1475,1444,1471,1185,1471,1445,1452,1445,1441,1454,
 1441,1225,1318,1318,1225,1060,1060,1318,1319,1060,1319,1060,
 1318,2491,2491,642,1254,1254,1039,597,1490,757,1231,1720,1231,
 1720,1038,597,1561,6,642,757,971,713,1594,478,1037,478,1537,
 1537,1244,1244,1565,1709,6,98,202,185,98,173,174,101,166,164,
 174,166,104,2491,2491,2491,713,1244,1244,642,1254,1254,1537,
 713,971,597,1011,1594,6,1490,757,1720,1231,1561,1231,1537,648,
 1720,1037,597,897,1604,6,1565,98,185,101,159,174,166,104,174,
 173,173,99,187,1254,940,1254,597,1001,757,2185,1706,1078,2185,
 1683,1391,1391,1179,1163,757,1706,1683,1259,1179,871,1790,1259,
 1078,1790,1150,597,2922,2207,2207,257,446,1132,1132,1640,396,
 364,396,357,1640,1186,1186,2491,1254,597,897,2491,2491,713,
 1037,713,1258,1258,1526,6,1591,642,1254,1542,1254,1606,713,
 1720,1503,976,597,1210,1716,1565,6,1604,159,101,104,160,166,
 99,187,173,174,164,102,201,1254,1150,597,1254,940,1254,1790,
 1665,597,982,1722,2061,2061,757,2185,1136,1706,2928,2185,1078,
 831,1683,1406,1406,1664,1190,1246,1190,1132,1132,364,301,396,
 1186,1186,1640,1640,357,303,444,1301,1296,1231,1706,1706,1293,
 1231,2152,1683,2152,6,1603,713,1259,1675,1706,1601,916,1293,
 1259,1675,2145,1748,2145,1605,1830,6,180,136,269,121,214,128,
 265,214,209,209,204,130,1244,1210,1406,1748,1406,1233,2033,
 2128,2040,6,1952,1578,1983,2925,2194,1853,1673,2194,1968,1931,
 4,2004,4,2863,2136,2062,708,408,565,441,660,556,944,929,901,
 652,515,484,1716,1664,2145,2145,1713,4,1700,4,2129,2141,1526,
 1128,1827,1677,2836,1366,1366,1012,2905,1912,2207,1864,1768,
 2031,6,508,343,815,328,767,355,525,622,617,760,702,544,2491,
 1254,597,1231,597,938,1716,6,1565,2491,2491,1066,713,1560,713,
 976,648,1206,1206,1578,1526,6,1709,1565,160,104,187,160,99,
 102,201,164,166,102,164,202,1254,1406,2185,963,597,1128,1177,
 1147,1254,940,1929,1254,1201,1665,1683,831,597,960,1983,1128,
 2207,2207,2922,301,364,1186,1556,1186,303,444,357,396,1132,
 1132,1703,2145,1231,1300,1287,1296,1609,6,1231,1706,1300,1706,
 1628,1231,1675,725,2194,1675,2194,1677,6,1830,1605,121,269,
 265,179,128,204,130,209,214,132,225,266,597,4,1916,4,6,1836,
 1206,960,1735,1675,1822,1610,1206,964,2151,1819,2925,1745,2072,
 2897,2105,703,558,653,339,510,328,921,711,700,517,616,379,
 1855,1151,597,1198,1196,478,871,939,916,1120,725,969,478,1366,
 1610,1673,1366,2062,2924,2062,227,287,1643,1095,1095,253,286,
 223,223,1140,1568,1140,1258,2152,2073,2103,1066,1400,1400,1675,
 2838,1084,1812,1544,1735,2148,1846,2893,6,2034,1769,349,526,
 795,695,395,518,377,618,632,534,727,943,1391,1919,6,1751,
 1675,2171,2171,1805,1811,2911,1540,4,1776,4,1700,2117,2080,
 2829,535,827,529,605,366,709,395,756,861,369,521,658,1868,6,
 897,1664,1226,1677,1870,975,1701,1226,1912,2905,1878,2063,2065,
 2875,2141,328,903,657,508,332,760,568,702,698,355,622,523,
 2061,1560,2061,2838,1620,2061,2907,2065,1595,1822,2080,2858,
 1833,1,1,1,1742,6,893,780,777,6,1865,1794,1743,832,771,895,
 1604,2922,2065,1589,2155,2155,2832,1565,1843,2828,2062,1715,1,
 1,1,6,1786,874,779,832,1773,6,1807,1773,853,832,876,2491,
 597,1254,6,1231,1206,478,597,976,1958,1011,6,1717,1591,160,
 187,201,159,102,164,202,102,99,99,173,185,1400,1254,2061,
 2185,597,1259,960,597,1255,1722,1163,1263,1147,1556,1186,444,
 301,303,1132,1703,1132,1186,303,357,446,2171,2073,597,2148,
 1226,4,1812,4,1902,6,2047,1797,349,662,946,675,534,618,407,
 518,527,395,817,828,6,1231,2194,1259,1290,1290,1298,1296,1593,
 6,1589,179,265,130,179,204,225,266,132,128,225,132,270,2155,
 2080,6,6,2065,2215,6,1,1,1,1742,1781,857,772,832,1794,1781,
 6,6,777,832,856,1366,478,1783,1089,597,975,1183,1265,1167,
 1095,1643,286,199,253,1568,1140,1140,1095,261,261,247,597,
 1819,4,2016,4,1857,2019,6,602,375,905,328,711,360,655,510,
 517,700,825,557,1012,1728,1096,597,1550,1749,6,156,203,203,
 96,165,175,188,103,100,167,176,105,1206,2194,1366,2111,2208,
 2828,703,862,375,602,517,711,905,328,546,510,360,655,1406,
 2145,1804,6,1843,602,564,558,703,700,510,653,360,381,711,328,
 921,1244,1940,6,1921,514,737,408,708,901,660,565,438,447,929,
 556,944,2844,2101,2109,668,906,343,508,617,767,815,328,541,
 622,355,525,2207,2062,742,799,1771,1731,6,797,804,784,787,6,
 1767,1771,2207,1016,1124,6,1972,1965,1032,1104,1027,1034,1969,
 6,1981,779,852,1775,6,1807,853,852,832,850,1773,1807,6,1132,
 32,7,16,1539,1371,1539,1095,16,11,31,65,34,59,1404,1707,
 1651,1186,46,55,72,1132,1186,59,65,52,58,1651,1404,1707,1095,
 16,32,11,13,1539,1539,1371,20,58,28,20,1371,1590,1651,1186,
 1132,1590,28,20,58,1140,1651,52,59,65,1371,20,37,54,35,29,
 51,1132,1140,1186,2731,2731,2731,3029,2731,2731,2731,1211,1211,
 1461,1211,1461,1469,1454,1454,1211,1461,1469,1470,1446,1458,
 1456,1456,1476,1454,1211,1461,1454,1469,1454,1446,1454,1119,
 1454,1470,1454,1454,1454,1441,1441,1256,1256,1256,1256,1370,
 1370,1256,1181,1370,1181,1370,1256,2653,2731,2731,2731,2731,
 3029,1211,1211,1461,1211,1461,1469,1456,1458,1211,1461,1469,
 1456,1446,1454,1454,1470,1454,1476,1211,1461,1470,1469,1441,
 1446,1458,1119,1458,1456,1456,1458,1476,1454,1441,1370,1256,
 1256,1370,1256,1256,1256,1370,1256,1370,1256,1256,2731,2731,
 2731,2731,3029,1211,1211,1461,1211,1461,1469,1456,1458,1211,
 1461,1469,1456,1446,1454,1454,1470,1454,1476,1211,1461,1470,
 1469,1441,1446,1458,1119,1458,1456,1456,1458,1476,1454,1441,
 1370,1256,1256,1370,1256,1256,1256,1370,1256,1370,1256,1256,
 3029,3029,3029,3029,713,713,1665,713,1665,2258,2289,2274,713,
 1665,2258,2305,1665,2274,2289,2305,2405,2405,713,1665,2299,
 2258,2405,1665,478,1543,478,2305,2289,2274,2405,2405,2250,1484,
 1481,1481,1484,1484,1484,1481,1484,1484,1484,1484,1481,2731,
 2731,3029,1485,1485,2257,1485,2257,2281,2282,2285,1485,2257,
 2281,2292,2257,2292,2272,2296,2397,2405,1485,2257,2282,2281,
 2250,2257,2272,1489,2272,2292,2282,2285,2405,2405,2397,1484,
 1483,1483,1484,1481,1481,1483,1483,1481,1483,1481,1483,2653,
 2731,1461,1461,1444,1461,1444,1245,1445,1473,1461,1444,1245,
 1452,1465,1466,1455,1451,1441,1441,1461,1444,1457,1245,1454,
 1465,1450,1185,1450,1452,1445,1473,1441,1441,1475,1264,1182,
 1182,1264,1256,1256,1182,1369,1256,1369,1256,1182,2731,1461,
 1461,1444,1461,1444,1245,1445,1473,1461,1444,1245,1452,1465,
 1466,1455,1451,1441,1441,1461,1444,1457,1245,1454,1465,1450,
 1185,1450,1452,1445,1473,1441,1441,1475,1264,1182,1182,1264,
 1256,1256,1182,1369,1256,1369,1256,1182,1495,1495,2267,1495,
 2267,2281,2269,2292,1495,2267,2281,2284,2256,2285,2284,2285,
 2365,2347,1495,2267,2292,2281,2324,2256,2294,1514,2294,2284,
 2269,2292,2347,2309,2326,1488,1506,1506,1488,1492,1492,1506,
 1507,1492,1507,1492,1506,2491,2491,642,1254,1254,897,597,1490,
 757,1231,1751,1231,1958,1011,597,1606,6,642,757,976,713,1565,
 478,1066,478,1542,1535,1244,1244,1606,1565,6,104,160,159,101,
 201,202,98,164,187,173,185,98,2491,2491,2491,713,1244,1244,
 642,1254,1254,1535,713,1039,597,1038,1560,6,1490,757,1720,
 1231,1604,1231,1542,648,1720,1038,597,1039,1561,6,1709,101,
 159,98,185,202,185,98,173,201,174,101,159,1254,940,1254,597,
 1150,757,2185,1706,1134,2185,1748,1391,1391,1201,1177,757,1706,
 1683,1259,1190,871,1929,1259,1136,1770,1001,597,2928,2207,2207,
 364,301,1132,1132,1703,446,257,357,444,1640,1132,1132,2491,
 1254,597,1039,2491,2491,713,1038,713,1244,1244,1535,6,1560,
 642,1254,1537,1254,1565,713,1720,1503,971,597,1011,1958,1594,
 6,1717,185,98,98,202,185,101,159,174,202,166,104,160,1254,
 1001,597,1254,940,1254,1770,1665,597,1001,1770,2061,2061,757,
 2185,1078,1706,2922,2185,1136,831,1683,1391,1391,1748,1179,
 1163,1263,1132,1132,257,446,446,1132,1132,1640,1703,396,364,
 301,1296,1301,1231,1706,1706,1290,1231,2198,1677,2198,6,1620,
 713,1259,1675,1706,1605,916,1300,1259,1675,2198,1677,2198,1601,
 1593,6,269,121,180,136,270,136,180,209,266,214,269,121,1244,
 1011,1391,1677,1391,1069,1878,2063,1700,6,1802,1526,1722,2905,
 2152,1768,1576,2152,1705,1827,4,1864,4,2836,2109,2101,815,328,
 508,343,657,568,668,760,903,622,523,336,1958,1748,2198,2198,
 1970,4,1878,4,2234,2212,1578,1255,1931,1748,2863,1381,1381,
 1216,2925,2027,2207,2004,1853,1921,6,565,441,708,408,1022,482,
 514,652,738,929,948,553,2491,1254,597,1231,597,897,1751,6,
 1606,2491,2491,1037,713,1591,713,971,648,1258,1258,1526,1578,
 6,1591,1717,202,98,159,201,101,104,160,166,185,99,187,160,
 1254,1391,2185,1150,597,1134,1177,1201,1254,940,1790,1254,1147,
 1665,1683,831,597,982,1722,1255,2061,2061,2985,446,257,1132,
 1703,1132,364,301,396,446,1186,1186,1556,2198,1231,1301,1296,
 1290,1620,6,1231,1706,1293,1706,1589,1231,1675,725,2152,1683,
 2152,1748,6,1603,1828,136,180,180,270,136,269,121,214,270,
 128,265,179,597,4,1700,4,6,1920,1258,982,1776,1683,1875,1599,
 1258,896,2160,1888,2892,1944,2109,2837,2205,945,535,605,358,
 529,395,688,709,827,521,658,338,1970,1069,597,1120,1120,478,
 871,969,916,1167,725,939,478,1381,1599,1576,1381,2158,2893,
 2158,287,227,1533,1187,1187,287,227,223,247,1095,1643,1095,
 1244,2198,2212,2234,1210,1406,1406,1748,2865,1233,1846,1587,
 2033,2128,2040,2984,6,1952,2014,482,514,708,1022,408,565,441,
 660,737,556,944,811,1391,1802,6,1716,1664,2145,2145,1754,1713,
 2893,1517,4,1700,4,2040,2129,2141,2875,568,668,508,657,343,
 815,328,767,906,355,525,601,1920,6,938,1675,1226,1683,1793,
 975,1806,1226,1700,2892,1700,2128,2065,2829,2080,395,688,605,
 529,358,945,535,705,849,369,659,507,2061,1594,2061,2840,1609,
 2061,2907,2102,1575,1879,2142,2847,1869,1,1,1,1856,6,752,883,
 758,6,1738,1785,1778,793,802,753,1561,2928,2065,1628,2155,
 2155,2849,1550,1885,2848,2072,1872,1,1,1,6,1738,752,758,883,
 1856,6,1740,1856,750,882,734,2491,597,1254,6,1231,1258,478,
 597,938,1716,1210,6,1565,1709,201,159,160,187,104,187,160,99,
 101,102,201,159,1406,1254,2061,2185,597,1259,963,597,1128,
 1983,1177,1147,1263,1703,1132,301,444,364,1186,1556,1186,1132,
 303,444,301,2145,2111,597,2148,1226,4,1916,4,2000,6,1836,
 2002,375,602,703,862,558,653,339,510,564,328,921,656,6,1231,
 2152,1259,1300,1287,1296,1298,1609,6,1828,270,180,121,266,269,
 265,179,128,136,204,130,179,2155,2134,6,6,2098,2114,6,1,1,
 1,1771,1731,742,799,776,1760,1731,6,6,784,796,741,1381,478,
 1855,1151,597,1103,1198,1196,1251,1187,1533,227,247,287,1643,
 1095,1095,1187,253,286,199,597,1818,4,1902,4,1792,1789,6,662,
 349,695,395,795,377,604,518,526,727,943,537,1053,1739,896,
 597,1574,1580,6,188,161,161,105,188,203,156,100,105,165,203,
 96,1258,2152,1381,2073,2103,2876,946,675,349,662,526,795,695,
 395,547,518,377,604,1391,2198,1919,6,2028,659,507,535,945,
 827,529,605,366,359,709,395,688,1244,1868,6,2031,525,601,328,
 815,903,657,508,332,397,760,568,668,2860,2062,2136,944,811,
 441,565,738,1022,708,408,570,652,482,514,2061,2158,857,772,
 1742,1781,6,893,780,777,894,6,1865,1742,2207,852,775,6,1775,
 1786,874,779,832,876,1773,6,1736,1104,1023,1972,6,1980,1127,
 1016,1025,1125,1969,1980,6,1132,32,65,75,1707,1371,1651,1187,
 52,68,31,7,34,32,1371,1479,1539,1132,11,31,9,1132,1132,32,
 7,16,34,1539,1371,1479,1187,75,32,46,73,1651,1707,1371,65,
 34,59,65,1404,1707,1581,1132,1186,1707,59,65,34,1095,1581,16,
 32,7,1404,20,58,13,55,72,26,1186,1095,1132,2731,2653,2731,
 2731,3029,2731,1461,1461,1444,1461,1444,1245,1452,1450,1461,
 1444,1245,1445,1465,1455,1466,1457,1441,1441,1461,1444,1451,
 1245,1475,1465,1473,1185,1473,1445,1452,1450,1441,1441,1454,
 1369,1256,1256,1369,1182,1182,1256,1264,1182,1264,1182,1256,
 2731,3029,3029,3029,3029,2257,2257,2255,2257,2255,2281,2282,
 2272,2257,2255,2281,2285,2290,2272,2282,2285,2300,2300,2257,
 2255,2292,2281,2300,2290,2296,1541,2296,2285,2282,2272,2300,
 2300,2277,2281,1691,1691,2281,2281,2281,1691,1747,2281,1747,
 2281,1691,2731,2731,3029,2731,1461,1461,1444,1461,1444,1245,
 1452,1450,1461,1444,1245,1445,1465,1455,1466,1457,1441,1441,
 1461,1444,1451,1245,1475,1465,1473,1185,1473,1445,1452,1450,
 1441,1441,1454,1369,1256,1256,1369,1182,1182,1256,1264,1182,
 1264,1182,1256,2731,3029,2731,1495,1495,2256,1495,2256,2281,
 2284,2284,1495,2256,2281,2273,2271,2294,2283,2283,2301,2364,
 1495,2256,2293,2281,2364,2271,2293,1514,2293,2273,2284,2284,
 2364,2323,2323,1528,1528,1528,1528,1524,1524,1528,1513,1524,
 1513,1524,1528,2731,2653,1469,1469,1442,1469,1442,1453,1454,
 1456,1469,1442,1453,1454,1462,1454,1454,1470,2613,1474,1469,
 1442,1470,1453,2613,1462,1456,1204,1456,1454,1454,1456,1474,
 2613,2613,1291,1405,1405,1291,1405,1405,1405,1291,1405,1291,
 1405,1405,2731,940,940,2261,940,2261,2259,2275,2298,940,2261,
 2259,2295,2284,2305,2299,2288,2347,2324,940,2261,2286,2259,
 2326,2284,2297,1621,2297,2295,2275,2298,2324,2309,2365,1512,
 1528,1528,1512,1527,1527,1528,1525,1527,1525,1527,1528,1469,
 1469,1442,1469,1442,1453,1454,1456,1469,1442,1453,1454,1462,
 1454,1454,1470,2613,1474,1469,1442,1470,1453,2613,1462,1456,
 1204,1456,1454,1454,1456,1474,2613,2613,1291,1405,1405,1291,
 1405,1405,1405,1291,1405,1291,1405,1405,1254,1254,1706,1231,
 1231,1076,597,1706,713,1277,1985,1277,1834,981,597,1758,597,
 1706,713,1138,916,1573,559,975,559,1675,1748,1365,1365,1607,
 1607,597,151,334,331,145,237,256,145,198,243,198,252,151,
 1254,1254,1254,1665,1365,1365,1706,1231,1231,1748,1665,1151,
 597,981,1757,597,1706,713,1791,1277,1584,1277,1675,871,1791,
 1188,597,1076,1584,597,1607,145,331,145,331,256,252,151,198,
 237,198,148,335,1231,1490,1231,597,1011,713,1978,683,1020,
 1978,1542,1206,1206,1083,978,713,1490,1535,1231,978,757,1751,
 1231,937,1958,1011,597,2868,2079,2079,415,415,1367,1367,1534,
 337,415,280,337,1516,1331,1331,1254,1231,597,1076,1254,1254,
 1665,1188,1665,1393,1393,1683,597,1627,1706,1231,1675,1231,
 1607,1665,1791,1588,1138,597,980,1747,1573,597,1617,331,145,
 151,334,252,148,335,198,256,198,153,331,1231,1011,597,1231,
 1490,1231,1958,757,597,1065,1720,2124,2124,713,1978,937,683,
 2868,1978,937,649,1535,1244,1244,1526,978,989,989,1367,1367,
 415,415,337,1331,1331,1516,1534,280,337,415,1287,1287,1277,
 683,1585,1302,1277,2157,1613,2157,597,1617,916,1231,1616,1588,
 1596,881,1303,1231,1616,2145,1623,2145,1596,1617,597,272,146,
 272,146,205,142,276,178,218,178,215,152,1365,980,1244,1623,
 1244,991,1902,2162,1912,597,1866,1664,1716,2892,2145,1839,1664,
 2145,1705,1700,4,1864,4,2842,2093,2089,920,155,575,448,628,
 549,949,699,838,608,579,483,1747,1526,2145,2145,1722,4,1745,
 4,2084,2072,1664,897,1700,1611,2842,1271,1271,965,2892,1878,
 2063,1864,1839,1792,597,575,448,920,155,759,420,574,608,626,
 699,880,545,1254,1231,597,1277,597,1058,1810,597,1607,1254,
 1254,975,1665,1627,1665,1138,871,1409,1409,1664,1664,597,1572,
 1573,334,151,335,331,148,153,331,198,252,150,243,334,1231,
 1244,1978,1123,597,958,1083,978,1231,1490,1751,1231,978,757,
 1535,649,597,1214,1716,897,2147,2147,2868,415,415,1331,2256,
 1331,337,415,280,337,1331,1331,2256,2145,1277,1291,1299,1296,
 1720,597,1277,683,1303,1585,1563,1277,1616,725,2145,1680,2145,
 1611,597,1571,1563,146,272,276,268,142,215,152,178,205,144,
 213,273,597,4,1871,4,597,1840,1409,1214,1944,1680,1844,1748,
 1409,1223,2128,2022,2922,2023,2193,2864,2082,1067,569,833,542,
 578,154,1121,865,950,581,673,540,1927,959,597,1114,994,559,
 757,1085,881,994,1706,1085,559,1271,1748,1664,1271,2163,2927,
 2163,382,382,2281,1405,1405,322,382,263,322,1391,1681,1391,
 1393,2157,2232,2122,999,1258,1258,1613,2846,962,1700,1546,1837,
 2197,1779,2893,597,1723,1729,503,582,934,955,155,584,467,607,
 627,539,821,951,1206,1998,597,1810,1537,2143,2143,1727,1782,
 2911,1547,4,2016,4,1912,2071,2067,2833,551,952,592,664,449,
 858,155,697,854,417,576,663,1989,597,1058,1537,1353,1599,1755,
 1075,1916,1353,1776,2925,1745,2162,2070,2833,2067,155,927,664,
 592,450,846,551,701,786,417,629,577,2124,1757,2124,2899,1720,
 2124,2983,2190,1721,1993,2094,2874,2020,1,1,1,2029,597,1191,
 1191,1115,597,2017,1996,2001,1071,1115,1191,1584,2868,2066,
 1563,2147,2147,2843,1552,1755,2856,2068,1762,1,1,1,597,1903,
 844,890,784,1816,597,1715,1735,784,784,844,1254,597,1231,597,
 1277,1409,559,597,1229,1747,980,597,1573,1572,331,335,331,335,
 153,243,334,150,148,150,237,331,1258,1231,2124,1978,597,1231,
 1041,597,897,1716,978,989,989,2256,1331,415,415,337,1331,2256,
 1331,1331,280,337,415,2143,2096,597,2172,1353,4,2009,4,1700,
 597,1750,1764,463,666,935,970,562,630,462,572,573,155,790,
 925,597,1277,2145,1231,1304,1302,1287,1287,1562,597,1608,268,
 276,152,273,215,213,273,144,142,182,149,268,2147,2108,597,
 597,2195,2081,597,1,1,1,1801,1942,890,844,843,1886,1850,597,
 597,784,843,890,1271,559,1766,1109,597,1076,994,983,983,1405,
 2281,382,382,322,1681,1391,1391,1405,263,322,382,597,1890,4,
 1700,4,1906,1849,597,666,463,942,155,813,465,665,572,580,722,
 877,560,968,1976,1040,597,1597,1597,597,239,239,239,147,189,
 189,239,140,143,169,196,147,1409,2145,1271,2096,2091,2834,935,
 970,463,666,580,813,942,155,552,572,465,665,1244,2145,1788,
 597,1943,833,593,569,1067,950,578,833,531,532,865,154,1121,
 1365,1752,597,1792,574,672,155,920,838,628,575,418,445,699,
 549,949,2831,2089,2093,949,926,448,575,626,759,920,155,538,
 608,420,574,2147,2163,890,844,1801,1942,597,784,844,784,784,
 597,1735,1903,2079,841,868,597,1882,1799,840,868,769,840,1715,
 597,1903,868,841,1882,597,1746,842,841,769,842,1715,1903,597,
 1367,85,82,67,2267,1257,1618,1405,45,67,85,82,85,64,1245,
 2281,1618,1331,44,64,82,1367,1331,64,82,45,64,1618,1245,2281,
 1405,67,85,44,67,1618,2267,1257,38,64,21,38,1245,1618,1674,
 1331,1331,1618,21,38,64,1391,1674,45,64,82,1245,10,21,45,21,
 38,64,1331,1391,1331,2731,2731,2731,2731,3029,1211,1211,1461,
 1211,1461,1469,1456,1458,1211,1461,1469,1456,1446,1454,1454,
 1470,1454,1476,1211,1461,1470,1469,1441,1446,1458,1119,1458,
 1456,1456,1458,1476,1454,1441,1370,1256,1256,1370,1256,1256,
 1256,1370,1256,1370,1256,1256,2731,2731,3029,2731,1461,1461,
 1444,1461,1444,1245,1452,1450,1461,1444,1245,1445,1465,1455,
 1466,1457,1441,1441,1461,1444,1451,1245,1475,1465,1473,1185,
 1473,1445,1452,1450,1441,1441,1454,1369,1256,1256,1369,1182,
 1182,1256,1264,1182,1264,1182,1256,2653,2731,2731,1211,1211,
 1461,1211,1461,1469,1470,1454,1211,1461,1469,1454,1446,1456,
 1458,1454,1441,1454,1211,1461,1456,1469,1441,1446,1454,1119,
 1454,1454,1470,1454,1454,1476,1454,1181,1370,1370,1181,1256,
 1256,1370,1256,1256,1256,1256,1370,2731,2731,1211,1211,1461,
 1211,1461,1469,1470,1454,1211,1461,1469,1454,1446,1456,1458,
 1454,1441,1454,1211,1461,1456,1469,1441,1446,1454,1119,1454,
 1454,1470,1454,1454,1476,1454,1181,1370,1370,1181,1256,1256,
 1370,1256,1256,1256,1256,1370,3029,713,713,1665,713,1665,2258,
 2305,478,713,1665,2258,2289,1665,2289,2274,2299,2405,2405,713,
 1665,2305,2258,2250,1665,2274,1543,2274,2289,2305,478,2405,
 2405,2405,1484,1484,1484,1484,1481,1481,1484,1484,1481,1484,
 1481,1484,1495,1495,2267,1495,2267,2281,2284,2294,1495,2267,
 2281,2269,2256,2284,2285,2292,2309,2347,1495,2267,2285,2281,
 2326,2256,2292,1514,2292,2269,2284,2294,2347,2365,2324,1507,
 1492,1492,1507,1506,1506,1492,1488,1506,1488,1506,1492,2491,
 2491,642,1254,1254,938,597,1490,757,1231,1716,1231,1716,1210,
 597,1565,6,642,757,938,713,1709,478,1210,478,1578,1526,1258,
 1258,1561,1594,6,102,201,187,99,160,160,104,187,159,201,159,
 101,2491,2491,2491,713,1258,1258,642,1254,1254,1526,713,897,
 597,1037,1591,6,1490,757,1751,1231,1717,1231,1578,648,1958,
 1011,597,971,1606,6,1591,99,187,104,166,160,159,101,201,160,
 202,98,185,1254,940,1254,597,963,757,2185,1706,1128,2185,1664,
 1406,1406,1147,1177,757,1706,1675,1259,1263,871,1983,1259,1255,
 1722,982,597,2928,2061,2061,303,444,1186,1186,1556,301,364,
 444,301,1703,1132,1132,2491,1254,597,971,2491,2491,713,1011,
 713,1244,1244,1537,6,1594,642,1254,1535,1254,1717,713,1958,
 1503,1039,597,1038,1720,1560,6,1565,166,104,101,174,159,98,
 185,202,160,185,98,202,1254,982,597,1254,940,1254,1722,1665,
 597,1150,1790,2061,2061,757,2185,1134,1706,2985,2185,1255,831,
 1748,1391,1391,1683,1201,1177,1147,1186,1186,364,396,301,1132,
 1132,1703,1556,446,257,446,1287,1300,1231,1706,1706,1296,1231,
 2145,1748,2145,6,1609,713,1259,1683,1706,1828,916,1298,1259,
 1748,2152,1683,2152,1628,1609,6,204,130,265,128,179,121,269,
 266,179,270,180,136,1258,1038,1391,1683,1391,1151,1700,2128,
 1916,6,1919,1535,1770,2892,2198,2028,1599,2198,1739,2027,4,
 1888,4,2848,2142,2098,709,395,529,366,605,535,827,945,688,
 659,507,359,1720,1683,2152,2152,1855,4,2033,4,2103,2073,1542,
 1136,1700,1675,2876,1381,1381,1053,2925,1827,2160,1818,1885,
 1879,6,518,377,795,395,695,349,526,662,604,946,675,547,2491,
 1254,597,1231,597,1039,1720,6,1561,2491,2491,1038,713,1709,
 713,1039,648,1244,1244,1535,1542,6,1560,1604,174,101,185,173,
 98,98,202,185,159,101,159,201,1254,1391,2185,1001,597,1078,
 1163,1179,1254,940,1770,1254,1263,1665,1748,831,597,1001,1770,
 1136,2061,2061,2922,396,364,1132,1640,1132,257,446,446,301,
 1132,1132,1703,2152,1231,1296,1301,1293,1603,6,1231,1706,1290,
 1706,1828,1231,1748,725,2198,1677,2198,1675,6,1620,1589,128,
 265,269,214,121,180,136,270,179,136,180,270,597,4,2040,4,6,
 1868,1244,1001,1700,1677,2031,1576,1244,896,2207,1864,2892,
 1902,2072,2847,2114,760,568,657,332,508,328,903,815,668,525,
 601,397,1713,1233,597,1196,1198,478,871,975,916,1251,725,1103,
 478,1381,1576,1599,1381,2155,2907,2155,253,286,1643,1095,1095,
 227,287,247,199,1187,1533,1187,1244,2145,2141,2129,1011,1391,
 1391,1677,2875,1069,2040,1517,1878,2063,1700,2893,6,1802,1754,
 355,525,815,767,328,508,343,657,601,568,668,906,1406,1952,6,
 1958,1748,2198,2198,2014,1970,2984,1587,4,1878,4,1846,2234,
 2212,2865,556,944,565,660,441,708,408,1022,811,482,514,737,
 1836,6,976,1683,1226,1675,2002,969,2000,1226,1931,2905,1776,
 2148,2065,2840,2111,328,921,653,510,339,703,558,862,656,375,
 602,564,2061,1565,2207,2829,1593,2207,2893,2062,1580,1921,2109,
 2837,1789,1,1,1,1773,6,874,832,779,6,1786,1775,1736,852,775,
 876,1606,2928,2065,1601,2158,2158,2860,1574,1853,2836,2109,
 1792,1,1,1,6,1865,893,777,780,1742,6,1781,1742,857,772,894,
 2491,597,1254,6,1231,1244,478,597,897,1751,1066,6,1606,1565,
 173,185,202,164,98,159,201,101,98,104,160,187,1391,1254,2207,
 2185,597,1259,1150,597,1134,1929,1177,1201,1190,1640,1132,446,
 357,257,1132,1703,1132,1132,364,301,444,2198,2080,597,2128,
 1226,4,1700,4,1806,6,1920,1793,369,659,945,705,535,605,358,
 529,507,395,688,849,6,1231,2198,1259,1301,1296,1290,1300,1620,
 6,1605,214,269,136,209,180,180,270,136,121,269,121,266,2158,
 2136,6,6,2101,2205,6,1,1,1,1969,1980,1127,1025,1016,1972,
 1980,6,6,1104,1023,1125,1381,478,1970,1069,597,939,1120,1120,
 1167,1095,1643,287,223,227,1533,1187,1187,1095,287,227,247,
 597,2004,4,1944,4,1872,1869,6,652,482,1022,408,708,441,738,
 565,514,944,811,570,1216,1705,896,597,1550,1575,6,165,203,
 203,100,156,161,188,105,96,188,161,105,1244,2198,1381,2212,
 2234,2863,929,948,482,652,514,708,1022,408,553,565,441,738,
 1391,2152,1802,6,1768,622,523,568,760,668,508,657,343,336,
 815,328,903,1258,1920,6,1875,521,658,395,709,688,605,529,358,
 338,945,535,827,2849,2102,2134,727,943,377,518,604,695,795,
 395,537,662,349,526,2061,2155,750,882,1856,1740,6,752,883,
 758,734,6,1738,1856,2061,793,802,6,1785,1738,752,758,883,753,
 1856,6,1778,784,796,1760,6,1731,742,776,799,741,1771,1731,6,
 1186,59,20,16,1539,1404,1651,1095,52,11,55,65,58,32,1371,
 1707,1707,1132,68,31,72,1186,1132,32,65,75,34,1707,1371,1707,
 1095,16,59,46,13,1651,1539,1404,7,34,32,7,1371,1479,1581,
 1132,1132,1479,32,7,34,1187,1581,75,32,65,1371,65,34,73,31,
 9,26,1132,1187,1132,2731,3029,2731,2731,1461,1461,1444,1461,
 1444,1245,1466,1455,1461,1444,1245,1457,1465,1450,1452,1445,
 1441,1441,1461,1444,1459,1245,1441,1465,1449,1185,1449,1457,
 1466,1455,1441,1475,1454,1182,1256,1256,1182,1369,1369,1256,
 1370,1369,1370,1369,1256,2731,2653,2731,1461,1461,1444,1461,
 1444,1245,1457,1449,1461,1444,1245,1466,1465,1452,1450,1459,
 1475,1441,1461,1444,1445,1245,1454,1465,1455,1185,1455,1466,
 1457,1449,1441,1441,1441,1370,1369,1369,1370,1256,1256,1369,
 1182,1256,1182,1256,1369,2731,3029,2257,2257,2255,2257,2255,
 2281,2285,2296,2257,2255,2281,2282,2290,2282,2272,2292,2300,
 2300,2257,2255,2285,2281,2277,2290,2272,1541,2272,2282,2285,
 2296,2300,2300,2300,1747,2281,2281,1747,1691,1691,2281,2281,
 1691,2281,1691,2281,2731,1461,1461,1444,1461,1444,1245,1457,
 1449,1461,1444,1245,1466,1465,1452,1450,1459,1475,1441,1461,
 1444,1445,1245,1454,1465,1455,1185,1455,1466,1457,1449,1441,
 1441,1441,1370,1369,1369,1370,1256,1256,1369,1182,1256,1182,
 1256,1369,1578,1578,2266,1578,2266,2281,2284,2283,1578,2266,
 2281,2284,2270,2293,2293,2273,2300,2277,1578,2266,2273,2281,
 2300,2270,2283,1541,2283,2284,2284,2283,2277,2300,2300,1681,
 1674,1674,1681,1674,1674,1674,1681,1674,1681,1674,1674,1254,
 1254,1706,1231,1231,1058,597,1706,713,1277,1810,1277,1747,980,
 597,1607,597,1706,713,1229,916,1607,559,999,559,1683,1683,
 1393,1393,1758,1573,597,153,331,335,148,331,334,151,243,335,
 237,331,145,1254,1254,1254,1665,1393,1393,1706,1231,1231,1683,
 1665,1076,597,1188,1627,597,1706,713,1985,1277,1617,1277,1683,
 871,1834,981,597,1151,1758,597,1572,148,335,151,252,334,331,
 145,237,331,256,145,331,1231,1490,1231,597,1123,713,1978,683,
 958,1978,1526,1244,1244,978,1083,713,1490,1578,1231,989,757,
 1720,1231,958,1720,1065,597,2894,2147,2147,337,415,1331,1331,
 2256,415,415,337,415,1534,1367,1367,1254,1231,597,1151,1254,
 1254,1665,981,1665,1365,1365,1748,597,1757,1706,1231,1748,1231,
 1573,1665,1834,1588,1151,597,981,1834,1757,597,1573,252,151,
 145,256,331,145,331,256,334,252,151,334,1231,1065,597,1231,
 1490,1231,1720,757,597,1011,1958,2124,2124,713,1978,1020,683,
 2868,1978,958,649,1542,1206,1206,1542,1083,978,989,1331,1331,
 415,337,415,1367,1367,1534,2256,337,415,415,1299,1291,1277,
 683,1585,1296,1277,2145,1623,2145,597,1720,916,1231,1673,1588,
 1563,881,1294,1231,1576,2157,1613,2157,1724,1562,597,215,152,
 276,142,268,146,272,218,273,205,272,146,1393,981,1206,1613,
 1206,959,1745,2162,1871,597,1998,1683,1720,2925,2157,1763,1683,
 2157,1733,1735,4,1892,4,2898,2100,2087,858,155,592,449,664,
 551,952,846,927,629,577,452,1834,1542,2157,2157,1927,4,1902,
 4,2122,2232,1683,958,2032,1576,2845,1273,1273,954,2903,1735,
 2148,1862,2025,1752,597,584,467,934,155,955,503,582,631,674,
 859,936,548,1254,1231,597,1277,597,1076,1985,597,1758,1254,
 1254,1188,1665,1572,1665,1151,871,1393,1393,1683,1683,597,1627,
 1617,256,145,331,237,145,151,334,252,331,148,335,331,1231,
 1206,1978,1011,597,1020,978,1083,1231,1490,1958,1231,989,757,
 1542,649,597,1065,1720,958,2124,2124,2868,337,415,1367,1534,
 1367,415,415,337,415,1331,1331,2256,2157,1277,1287,1287,1302,
 1617,597,1277,683,1302,1585,1608,1277,1576,725,2157,1613,2157,
 1576,597,1617,1608,142,276,272,205,146,272,146,205,268,142,
 276,268,597,4,1912,4,597,1989,1393,1065,2016,1613,1750,1683,
 1393,1012,2148,1892,2903,1701,2100,2841,2088,846,551,664,450,
 592,155,927,858,952,576,663,453,1722,991,597,994,1114,559,
 757,1233,881,983,1706,1130,559,1273,1683,1683,1273,2213,2927,
 2213,322,382,2281,1405,1405,382,382,322,382,1405,2281,1405,
 1365,2145,2072,2084,980,1244,1244,1623,2842,991,1779,1538,1902,
 2162,1912,2893,597,1866,1792,420,574,920,759,155,575,448,628,
 672,549,949,926,1244,1866,597,1747,1526,2145,2145,1792,1722,
 2893,1538,4,1745,4,1779,2084,2072,2842,549,949,575,628,448,
 920,155,759,926,420,574,672,1840,597,1229,1578,1383,1673,1943,
 1233,1846,1383,2032,2925,2016,2197,2090,2857,2107,154,1121,833,
 578,542,1067,569,931,1122,533,833,593,2124,1573,2147,2857,
 1562,2147,2927,2135,1552,1752,2100,2841,1765,1,1,1,1816,597,
 844,784,890,597,1903,1799,1850,843,890,844,1758,2894,2090,
 1724,2213,2213,2878,1721,2025,2898,2100,2021,1,1,1,597,2017,
 1191,1115,1191,2029,597,1994,2017,1115,1191,1191,1254,597,1231,
 597,1277,1393,559,597,1058,1810,999,597,1607,1607,237,331,334,
 243,151,335,331,148,145,153,331,335,1244,1231,2147,1978,597,
 1231,1123,597,958,1720,1083,978,989,1534,1367,415,337,415,
 1331,2256,1331,1367,337,415,415,2145,2107,597,2197,1383,4,
 1871,4,1846,597,1840,1943,533,833,1067,931,569,833,542,578,
 593,154,1121,1122,597,1277,2157,1231,1291,1299,1296,1294,1720,
 597,1563,205,272,146,218,272,276,268,142,146,215,152,273,
 2213,2133,597,597,2087,2088,597,1,1,1,1886,1801,866,840,841,
 1814,1903,597,597,842,841,867,1273,559,1927,959,597,1130,1114,
 994,983,1405,2281,382,322,382,2281,1405,1405,1405,322,382,382,
 597,1862,4,1701,4,2021,1765,597,631,503,955,155,934,467,674,
 584,582,821,951,571,954,1733,1012,597,1721,1552,597,189,239,
 239,143,239,239,239,143,147,189,239,147,1393,2157,1273,2232,
 2122,2845,859,936,503,631,582,934,955,155,548,584,467,674,
 1206,2157,1998,597,1763,629,577,551,846,952,592,664,449,452,
 858,155,927,1393,1989,597,1750,576,663,155,858,927,664,592,
 450,453,846,551,952,2878,2135,2133,821,951,467,584,674,955,
 934,155,571,631,503,582,2124,2213,1115,1191,2029,1994,597,
 1191,1191,1115,1191,597,2017,2017,2147,843,890,597,1799,1903,
 844,890,784,844,1816,597,1850,842,841,1814,597,1903,866,841,
 840,867,1886,1801,597,1331,64,38,67,2267,1245,2256,1405,41,
 67,64,82,64,85,1257,2281,2267,1367,67,85,82,1331,1367,85,82,
 67,85,2267,1257,2281,1405,67,64,41,67,2256,2267,1245,82,85,
 64,82,1245,2281,2281,1367,1331,2281,64,82,85,1405,2281,67,85,
 82,1245,38,64,67,64,82,85,1331,1405,1367,2731,2731,2653,1444,
 1444,1463,1444,1463,2659,1445,1471,1444,1463,2659,1452,1444,
 1467,1459,1449,1454,1441,1444,1463,1452,2659,1441,1444,1445,
 1185,1445,1452,1445,1471,1441,1441,1475,1319,1060,1060,1319,
 1318,1318,1060,1225,1318,1225,1318,1060,3029,2731,940,940,2261,
 940,2261,2259,2295,2297,940,2261,2259,2275,2284,2299,2305,2286,
 2309,2324,940,2261,2288,2259,2365,2284,2298,1621,2298,2275,
 2295,2297,2324,2347,2326,1525,1527,1527,1525,1528,1528,1527,
 1512,1528,1512,1528,1527,2731,2281,2281,2281,2281,2281,2254,
 2300,2300,2281,2281,2254,2300,2281,2300,2300,2277,2405,2250,
 2281,2281,2277,2254,2397,2281,2300,1691,2300,2300,2300,2300,
 2250,2405,2397,1484,1483,1483,1484,1483,1483,1483,1484,1483,
 1484,1483,1483,1444,1444,1463,1444,1463,2659,1445,1471,1444,
 1463,2659,1452,1444,1467,1459,1449,1454,1441,1444,1463,1452,
 2659,1441,1444,1445,1185,1445,1452,1445,1471,1441,1441,1475,
 1319,1060,1060,1319,1318,1318,1060,1225,1318,1225,1318,1060,
 2185,2185,1706,1245,1245,1087,597,1691,932,1257,1688,1257,1951,
 1087,597,1593,6,1706,932,1087,757,1630,591,1087,591,1674,1674,
 1405,1405,1593,1630,6,122,172,192,137,197,194,121,329,234,
 250,236,121,2185,2185,2185,757,1405,1405,1706,1245,1245,1674,
 1706,1232,597,1129,1603,6,1691,932,1698,1257,1600,1257,1674,
 1588,1688,1129,597,1232,1589,6,1926,137,192,121,236,194,236,
 121,250,197,241,137,192,1245,1585,1245,597,1220,932,2146,713,
 1077,2146,1681,1385,1385,1167,1196,932,1549,1615,1245,1120,932,
 1690,1245,1077,1639,1077,597,2893,2158,2158,431,246,1091,1091,
 1566,283,346,368,285,1642,1091,1091,2185,1245,597,1232,2185,
 2185,757,1129,1706,1405,1405,1674,6,1603,1706,1245,1674,1245,
 1619,1706,1688,1549,1087,597,1087,1951,1605,6,1808,236,121,
 121,194,236,137,192,241,194,330,122,172,1245,1077,597,1245,
 1585,1245,1639,1624,597,1077,1639,2062,2062,932,2146,1057,713,
 2907,2146,1077,730,1615,1385,1385,1681,1183,1200,1250,1091,
 1091,346,283,283,1091,1091,1642,1566,367,431,246,1297,1286,
 1257,713,1487,1286,1257,2010,1534,2010,6,1565,757,1245,1534,
 1487,1592,757,1297,1245,1534,2010,1534,2010,1582,1592,6,163,
 86,158,87,163,87,158,183,162,184,163,86,1405,1087,1385,1534,
 1385,1087,1883,2175,1744,6,1831,1674,1687,2910,1978,1821,1674,
 1978,1639,1796,1477,1796,1477,2832,2080,2192,763,264,409,292,
 621,487,704,710,661,651,410,277,1951,1681,2010,2010,1951,1477,
 1883,1477,2062,2062,2281,1220,1815,1577,2859,1405,1405,1219,
 2927,1986,2163,1977,1904,1838,6,439,363,774,328,707,365,442,
 732,654,851,909,490,2185,1245,597,1257,597,1087,1688,6,1593,
 2185,2185,1087,757,1612,1706,1087,1588,1385,1385,1674,2281,6,
 1612,1808,194,121,192,197,137,122,172,330,236,135,234,172,
 1245,1385,2146,1220,597,1077,1196,1167,1245,1585,1690,1245,
 1120,1624,1615,730,597,1077,1687,1220,2155,2155,2924,283,346,
 1091,1566,1091,431,246,367,283,1133,1133,1530,2010,1257,1286,
 1297,1286,1565,6,1257,713,1286,1487,1558,1257,1534,685,1978,
 1534,1978,1577,6,1558,1708,87,158,158,163,87,163,86,184,163,
 90,162,158,597,1477,1744,1477,6,1715,1385,1077,1796,1534,1835,
 1674,1385,1050,2163,1796,2908,1815,2119,2835,2106,677,472,603,
 291,429,264,636,900,810,426,620,278,1951,1087,597,1163,1163,
 591,932,1129,757,1202,1706,1087,591,1405,1674,1674,1405,2207,
 2928,2207,254,226,1556,1132,1132,254,226,414,341,1132,1640,
 1132,1405,2010,2062,2062,1232,1391,1391,1577,2859,1232,1883,
 1626,1974,2213,1974,2983,6,1838,1971,365,442,774,707,328,439,
 363,732,654,504,909,684,1385,1831,6,1689,1618,2036,2036,1730,
 1688,2910,1548,1477,1796,1477,1974,2101,2110,2896,487,704,409,
 621,292,763,264,706,682,305,428,606,1715,6,1129,1618,1358,
 1534,1884,1087,1744,1358,1744,2908,1796,2213,2065,2850,2201,
 264,636,603,429,291,677,472,908,765,326,623,411,2062,1605,
 2155,2839,1582,2155,2922,2105,1550,1831,2112,2830,1907,1,1,1,
 1807,6,779,850,832,6,1736,1775,1773,852,832,775,1589,2893,
 2065,1565,2061,2061,2830,1580,1803,2839,2110,1930,1,1,1,6,
 1736,779,832,850,1807,6,1786,1807,873,853,779,2185,597,1245,
 6,1257,1385,591,597,1129,1689,1232,6,1619,1926,197,192,172,
 234,122,234,172,135,137,129,197,192,1391,1245,2155,2146,597,
 1245,1077,597,1077,1917,1196,1120,1250,1566,1091,246,285,431,
 1133,1530,1133,1091,530,285,246,2036,2072,597,2175,1358,1477,
 1796,1477,1986,6,1795,2041,274,603,645,810,491,623,279,430,
 434,264,670,687,6,1257,1978,1245,1297,1286,1297,1286,1582,6,
 1708,163,158,86,162,163,162,158,90,87,184,88,158,2061,2132,
 6,6,2131,2065,6,1,1,1,1740,1738,734,751,803,1785,1737,6,6,
 884,792,753,1405,591,1689,1087,597,1232,1147,1178,1279,1132,
 1556,226,341,254,1640,1132,1132,1132,281,255,284,597,1796,
 1477,1796,1477,1836,1820,6,621,275,637,264,763,304,606,498,
 427,922,681,471,1050,1639,1050,597,1580,1550,6,190,157,157,
 118,190,170,168,125,118,235,171,114,1385,1978,1405,2072,2065,
 2896,669,704,275,621,427,763,637,264,488,498,304,606,1385,
 2010,1770,6,2005,623,411,472,677,810,429,603,288,282,900,264,
 636,1405,1784,6,2012,428,606,264,763,661,621,409,289,302,710,
 487,704,2861,2209,2136,909,684,363,439,654,707,774,328,496,
 732,365,442,2155,2207,787,740,1731,1767,6,801,735,799,800,6,
 1772,1731,2158,832,781,6,1794,1743,778,782,856,771,1781,6,
 1742,1026,1016,1972,6,1964,1019,1023,1126,1035,1980,1965,6,
 1091,14,30,22,1581,1341,1651,1132,49,36,17,9,12,14,1341,
 1479,1581,1091,33,17,7,1091,1091,14,9,25,12,1581,1341,1479,
 1132,22,14,57,37,1651,1581,1341,30,12,56,30,1379,1590,1539,
 1091,1133,1590,56,30,12,1132,1539,25,14,9,1379,72,40,34,53,
 19,15,1133,1132,1091,2731,2731,1211,1211,1461,1211,1461,1469,
 1470,1454,1211,1461,1469,1454,1446,1456,1458,1454,1441,1454,
 1211,1461,1456,1469,1441,1446,1454,1119,1454,1454,1470,1454,
 1454,1476,1454,1181,1370,1370,1181,1256,1256,1370,1256,1256,
 1256,1256,1370,2731,1461,1461,1444,1461,1444,1245,1457,1449,
 1461,1444,1245,1466,1465,1452,1450,1459,1475,1441,1461,1444,
 1445,1245,1454,1465,1455,1185,1455,1466,1457,1449,1441,1441,
 1441,1370,1369,1369,1370,1256,1256,1369,1182,1256,1182,1256,
 1369,1444,1444,1463,1444,1463,2659,1445,1471,1444,1463,2659,
 1452,1444,1467,1459,1449,1454,1441,1444,1463,1452,2659,1441,
 1444,1445,1185,1445,1452,1445,1471,1441,1441,1475,1319,1060,
 1060,1319,1318,1318,1060,1225,1318,1225,1318,1060,2491,2491,
 642,1254,1254,976,597,1490,757,1231,1958,1231,1751,1066,597,
 1717,6,642,757,897,713,1591,478,1011,478,1526,1578,1206,1206,
 1604,1560,6,99,173,164,102,202,201,102,159,185,160,187,99,
 2491,2491,2491,713,1206,1206,642,1254,1254,1578,713,938,597,
 1066,1709,6,1490,757,1716,1231,1565,1231,1526,648,1716,1210,
 597,976,1565,6,1560,102,164,102,164,201,187,99,160,202,160,
 104,166,1254,940,1254,597,960,757,2185,1706,1255,2185,1675,
 1400,1400,1263,1163,757,1706,1664,1259,1147,871,1722,1259,1128,
 1983,960,597,2922,2061,2061,303,357,1132,1132,1703,444,303,
 301,446,1556,1186,1186,2491,1254,597,976,2491,2491,713,1210,
 713,1258,1258,1542,6,1565,642,1254,1526,1254,1604,713,1716,
 1503,897,597,1037,1720,1591,6,1606,164,102,99,173,187,104,
 166,160,201,159,101,174,1254,960,597,1254,940,1254,1983,1665,
 597,963,1929,2207,2207,757,2185,1128,1706,2922,2185,1128,831,
 1664,1406,1406,1683,1147,1177,1201,1132,1132,303,357,444,1186,
 1186,1556,1703,301,364,396,1290,1290,1231,1706,1706,1298,1231,
 2171,1675,2171,6,1593,713,1259,1677,1706,1589,916,1296,1259,
 1677,2194,1675,2194,1589,1620,6,225,132,225,132,266,130,204,
 179,270,179,265,128,1206,1037,1406,1675,1406,1089,1776,2148,
 1812,6,1804,1537,1790,2905,2145,1843,1610,2145,1728,1912,4,
 1819,4,2828,2080,2065,711,328,510,360,653,558,700,703,921,
 602,564,381,1720,1683,2194,2194,1783,4,1735,4,2208,2111,1537,
 1078,1912,1675,2828,1366,1366,1012,2905,1931,2151,1819,1843,
 1822,6,510,360,711,328,905,375,517,602,655,703,862,546,2491,
 1254,597,1231,597,971,1720,6,1604,2491,2491,1011,713,1565,713,
 897,648,1244,1244,1537,1537,6,1594,1561,173,99,166,174,104,
 101,174,159,187,98,185,173,1254,1406,2185,982,597,1136,1246,
 1190,1254,940,1722,1254,1190,1665,1664,831,597,1150,1790,1078,
 2061,2061,2928,357,303,1186,1640,1186,364,396,301,444,1132,
 1132,1640,2194,1231,1287,1300,1300,1830,6,1231,1706,1296,1706,
 1605,1231,1677,725,2145,1748,2145,1675,6,1609,1628,132,225,
 204,209,130,265,128,179,266,121,269,214,597,4,1846,4,6,1940,
 1244,1150,1878,1748,1921,1673,1244,1096,2207,2004,2925,2016,
 2062,2858,2215,929,556,660,438,565,408,901,708,944,514,737,
 447,1811,1084,597,1265,1183,478,871,975,916,1167,725,975,478,
 1366,1673,1610,1366,2155,2907,2155,261,261,1568,1140,1140,286,
 253,199,247,1095,1643,1095,1258,2171,2080,2117,1038,1391,1391,
 1683,2829,1151,1700,1540,1700,2128,1916,2911,6,1919,1805,369,
 521,709,756,395,529,366,605,658,535,827,861,1400,2034,6,1720,
 1683,2152,2152,1769,1855,2893,1544,4,2033,4,1812,2103,2073,
 2838,534,727,518,618,377,795,395,695,943,349,526,632,2047,6,
 971,1683,1226,1675,1797,939,1902,1226,1827,2925,1735,2148,2065,
 2838,2073,395,817,618,518,407,946,534,675,828,349,662,527,
 2207,1709,2207,2875,1830,2207,2924,2101,1749,2031,2136,2897,
 2019,1,1,1,1969,6,1032,1027,1104,6,1965,1972,1981,1016,1124,
 1034,1565,2922,2065,1605,2062,2062,2844,1550,1768,2863,2072,
 1857,1,1,1,6,1767,797,784,804,1771,6,1731,1771,742,799,787,
 2491,597,1254,6,1231,1244,478,597,1039,1720,1037,6,1561,1594,
 174,166,174,166,101,185,173,98,104,98,202,164,1391,1254,2207,
 2185,597,1259,1001,597,1078,1790,1163,1179,1179,1640,1186,396,
 396,364,1132,1640,1132,1186,257,446,357,2152,2141,597,2063,
 1226,4,2040,4,1701,6,1868,1870,355,622,760,702,568,657,332,
 508,523,328,903,698,6,1231,2145,1259,1296,1301,1293,1293,1603,
 6,1601,209,204,128,214,265,269,214,121,130,180,136,209,2062,
 2109,6,6,2062,2105,6,1,1,1,1773,1807,853,832,852,1775,1807,
 6,6,779,852,850,1366,478,1713,1233,597,969,1196,1198,1120,
 1140,1568,253,223,286,1643,1095,1095,1140,227,287,223,597,
 1864,4,1745,4,1715,1833,6,622,355,767,328,815,343,617,508,
 525,668,906,541,1012,1968,964,597,1565,1595,6,167,176,175,
 103,188,203,165,96,105,156,203,100,1244,2145,1366,2141,2129,
 2836,760,702,355,622,525,815,767,328,544,508,343,617,1406,
 2194,1952,6,1853,652,515,556,929,944,565,660,441,484,708,408,
 901,1206,1836,6,1822,517,616,328,711,921,653,510,339,379,703,
 558,700,2832,2065,2080,700,825,360,510,655,905,711,328,557,
 602,375,517,2061,2155,853,832,1773,1807,6,874,832,779,876,6,
 1786,1773,2061,832,771,6,1794,1865,893,777,780,895,1742,6,
 1743,777,832,1794,6,1781,857,832,772,856,1742,1781,6,1132,28,
 20,52,1651,1371,1539,1140,16,46,35,20,37,59,1404,1590,1539,
 1186,11,55,29,1132,1186,59,20,16,58,1539,1404,1590,1140,52,
 28,11,54,1539,1651,1371,65,58,32,65,1371,1707,1651,1186,1132,
 1707,32,65,58,1095,1651,16,59,20,1371,7,34,13,31,72,51,
 1132,1095,1186,2731,1461,1461,1444,1461,1444,1245,1445,1473,
 1461,1444,1245,1452,1465,1466,1455,1451,1441,1441,1461,1444,
 1457,1245,1454,1465,1450,1185,1450,1452,1445,1473,1441,1441,
 1475,1264,1182,1182,1264,1256,1256,1182,1369,1256,1369,1256,
 1182,1469,1469,1442,1469,1442,1453,1454,1456,1469,1442,1453,
 1454,1462,1454,1454,1470,2613,1474,1469,1442,1470,1453,2613,
 1462,1456,1204,1456,1454,1454,1456,1474,2613,2613,1291,1405,
 1405,1291,1405,1405,1405,1291,1405,1291,1405,1405,1254,1254,
 1706,1231,1231,1229,597,1706,713,1277,1747,1277,1810,999,597,
 1573,597,1706,713,1058,916,1572,559,980,559,1664,1664,1409,
 1409,1584,1757,597,150,237,243,150,334,331,153,335,331,331,
 335,148,1254,1254,1254,1665,1409,1409,1706,1231,1231,1664,1665,
 1058,597,975,1572,597,1706,713,1810,1277,1573,1277,1664,871,
 1747,980,597,1138,1607,597,1627,150,243,153,198,331,335,148,
 331,334,334,151,252,1231,1490,1231,597,1041,713,1978,683,897,
 1978,1537,1258,1258,989,978,713,1490,1537,1231,989,757,1716,
 1231,897,1716,1214,597,2868,2124,2124,280,337,1331,1331,2256,
 415,337,415,415,2256,1331,1331,1254,1231,597,1138,1254,1254,
 1665,980,1665,1393,1393,1675,597,1573,1706,1231,1683,1231,1617,
 1665,1747,1588,1076,597,1188,1791,1627,597,1607,198,153,148,
 198,335,151,252,334,331,331,145,256,1231,1214,597,1231,1490,
 1231,1716,757,597,1123,1751,2147,2147,713,1978,958,683,2868,
 1978,897,649,1526,1244,1244,1535,978,1083,978,1331,1331,337,
 280,415,1331,1331,2256,2256,415,415,337,1302,1304,1277,683,
 1585,1287,1277,2143,1613,2143,597,1562,916,1231,1599,1588,1608,
 881,1287,1231,1611,2145,1680,2145,1563,1720,597,182,149,213,
 144,273,152,215,273,268,268,276,142,1409,1188,1244,1680,1244,
 1109,2016,2197,2009,597,1788,1748,1958,2925,2145,1943,1748,
 2145,1976,1878,4,2022,4,2856,2094,2195,865,154,578,531,833,
 569,950,1067,1121,833,593,532,1791,1535,2145,2145,1766,4,1837,
 4,2091,2096,1675,937,1776,1616,2834,1271,1271,968,2892,1700,
 2128,1890,1755,1993,597,572,465,813,155,942,463,580,666,665,
 935,970,552,1254,1231,597,1277,597,1151,1791,597,1584,1254,
 1254,981,1665,1607,1665,1076,871,1365,1365,1748,1675,597,1757,
 1584,198,148,252,198,151,145,256,331,335,145,331,237,1231,
 1244,1978,1065,597,937,989,978,1231,1490,1720,1231,989,757,
 1526,649,597,1011,1958,937,2124,2124,2868,280,337,1331,1516,
 1331,415,337,415,415,1367,1367,1534,2145,1277,1299,1291,1303,
 1571,597,1277,683,1296,1585,1563,1277,1611,725,2145,1623,2145,
 1616,597,1720,1563,144,213,215,178,152,276,142,268,273,146,
 272,205,597,4,1779,4,597,1752,1365,1011,1745,1623,1792,1664,
 1365,1040,2063,1864,2922,1700,2068,2874,2081,699,549,628,418,
 575,155,838,920,949,574,672,445,1782,962,597,983,994,559,757,
 1075,881,983,1706,1076,559,1271,1664,1748,1271,2147,2983,2147,
 263,322,1681,1391,1391,382,322,382,382,1405,2281,1405,1393,
 2143,2067,2071,981,1206,1206,1613,2833,959,1912,1547,1745,2162,
 1871,2911,597,1998,1727,417,576,858,697,155,592,449,664,663,
 551,952,854,1258,1723,597,1834,1542,2157,2157,1729,1927,2893,
 1546,4,1902,4,1700,2122,2232,2846,539,821,584,607,467,934,
 155,955,951,503,582,627,1750,597,1138,1535,1353,1616,1764,
 1085,1700,1353,1700,2892,1944,2172,2066,2899,2096,155,790,630,
 572,462,935,562,970,925,463,666,573,2147,1607,2079,2833,1617,
 2079,2927,2089,1597,1792,2093,2864,1849,1,1,1,1715,597,840,
 769,868,597,1799,1882,1903,841,868,840,1607,2868,2070,1596,
 2163,2163,2831,1597,1839,2842,2193,1906,1,1,1,597,1735,784,
 784,844,1801,597,1942,1903,890,844,784,1254,597,1231,597,1277,
 1365,559,597,1076,1985,975,597,1758,1573,198,252,256,198,145,
 331,237,145,151,151,334,243,1206,1231,2079,1978,597,1231,1011,
 597,1020,1751,978,1083,978,1516,1331,337,280,415,1367,1534,
 1367,1331,415,415,337,2157,2067,597,2162,1353,4,1912,4,1916,
 597,1989,1755,417,629,846,701,551,664,450,592,577,155,927,
 786,597,1277,2145,1231,1287,1287,1302,1303,1617,597,1596,178,
 215,142,178,276,272,205,146,152,272,146,218,2163,2093,597,
 597,2089,2082,597,1,1,1,1715,1903,842,769,841,1882,1746,597,
 597,868,841,842,1271,559,1722,991,597,1085,994,1114,994,1391,
 1681,322,263,382,2281,1405,1405,1391,382,382,322,597,1864,4,
 2023,4,1762,2020,597,608,420,759,155,920,448,626,575,574,949,
 926,538,965,1705,1223,597,1552,1721,597,169,196,189,140,239,
 239,189,147,147,239,239,143,1365,2145,1271,2072,2084,2842,699,
 880,420,608,574,920,759,155,545,575,448,626,1244,2145,1866,
 597,1839,608,579,549,699,949,575,628,448,483,920,155,838,
 1409,1840,597,1844,581,673,154,865,1121,833,578,542,540,1067,
 569,950,2843,2190,2108,722,877,465,572,665,942,813,155,560,
 666,463,580,2124,2147,784,784,1816,1715,597,844,784,890,844,
 597,1903,1735,2124,1071,1115,597,1996,2017,1191,1115,1191,1191,
 2029,597,2001,784,843,1886,597,1850,890,843,844,890,1801,1942,
 597,1331,21,10,45,1618,1245,1618,1391,45,44,21,38,21,64,
 1245,1618,2267,1331,67,64,38,1331,1331,64,38,67,64,2267,1245,
 1618,1391,45,21,44,45,1618,1618,1245,82,64,85,82,1257,2281,
 1674,1331,1367,2281,85,82,64,1405,1674,67,64,38,1257,82,85,
 67,85,82,64,1367,1405,1331,1444,1444,1463,1444,1463,2659,1452,
 1445,1444,1463,2659,1445,1444,1459,1467,1452,1441,1441,1444,
 1463,1449,2659,1475,1444,1471,1185,1471,1445,1452,1445,1441,
 1454,1441,1225,1318,1318,1225,1060,1060,1318,1319,1060,1319,
 1060,1318,2185,2185,1706,1245,1245,1129,597,1691,932,1257,1689,
 1257,1689,1232,597,1619,6,1706,932,1129,757,1926,591,1232,591,
 2281,1674,1385,1385,1589,1605,6,129,197,234,135,172,172,122,
 234,192,197,192,137,2185,2185,2185,757,1385,1385,1706,1245,
 1245,1674,1706,1087,597,1087,1612,6,1691,932,1688,1257,1808,
 1257,2281,1588,1951,1087,597,1087,1593,6,1612,135,234,122,330,
 172,192,137,197,172,194,121,236,1245,1585,1245,597,1077,932,
 2146,713,1077,2146,1618,1391,1391,1120,1196,932,1549,1618,1245,
 1250,932,1917,1245,1220,1687,1077,597,2893,2155,2155,530,285,
 1133,1133,1530,246,431,285,246,1566,1091,1091,2185,1245,597,
 1087,2185,2185,757,1087,1706,1405,1405,1674,6,1605,1706,1245,
 1674,1245,1808,1706,1951,1549,1232,597,1129,1688,1603,6,1619,
 330,122,137,241,192,121,236,194,172,236,121,194,1245,1077,
 597,1245,1585,1245,1687,1624,597,1220,1690,2155,2155,932,2146,
 1077,713,2924,2146,1220,730,1681,1385,1385,1615,1167,1196,1120,
 1133,1133,431,367,246,1091,1091,1566,1530,283,346,283,1286,
 1297,1257,713,1487,1297,1257,2036,1577,2036,6,1582,757,1245,
 1534,1487,1708,757,1286,1245,1577,1978,1534,1978,1565,1582,6,
 184,88,162,90,158,86,163,162,158,163,158,87,1385,1129,1385,
 1534,1385,1087,1796,2213,1796,6,1770,1674,1639,2908,2010,2005,
 1674,2010,1639,1986,1477,1796,1477,2839,2112,2131,900,264,429,
 288,603,472,810,677,636,623,411,282,1688,1615,1978,1978,1689,
 1477,1974,1477,2065,2072,1674,1077,1744,1534,2896,1405,1405,
 1050,2927,1796,2163,1796,1803,1831,6,498,304,763,264,637,275,
 427,621,606,669,704,488,2185,1245,597,1257,597,1232,1698,6,
 1589,2185,2185,1129,757,1926,1706,1232,1588,1405,1405,1674,
 1674,6,1603,1600,241,137,236,250,121,121,194,236,192,137,192,
 197,1245,1385,2146,1077,597,1057,1200,1183,1245,1585,1639,1245,
 1250,1624,1681,730,597,1077,1639,1077,2062,2062,2907,367,431,
 1091,1642,1091,346,283,283,246,1091,1091,1566,1978,1257,1297,
 1286,1286,1558,6,1257,713,1286,1487,1708,1257,1577,685,2010,
 1534,2010,1534,6,1565,1558,90,162,163,184,86,158,87,163,158,
 87,158,163,597,1477,1974,1477,6,1784,1405,1077,1796,1534,2012,
 1674,1405,1050,2163,1796,2908,1796,2110,2830,2065,710,487,621,
 289,409,264,661,763,704,428,606,302,1688,1232,597,1178,1147,
 591,932,1087,757,1279,1706,1232,591,1405,1674,1674,1405,2061,
 2922,2061,281,255,1640,1132,1132,226,254,341,284,1132,1556,
 1132,1405,2036,2110,2101,1087,1385,1385,1534,2896,1087,1974,
 1548,1883,2175,1744,2910,6,1831,1730,305,428,763,706,264,409,
 292,621,606,487,704,682,1391,1838,6,1951,1681,2010,2010,1971,
 1951,2983,1626,1477,1883,1477,1883,2062,2062,2859,504,909,439,
 732,363,774,328,707,684,365,442,654,1795,6,1087,1615,1358,
 1534,2041,1129,1986,1358,1815,2910,1796,2175,2065,2839,2072,
 264,670,623,430,279,645,491,810,687,274,603,434,2155,1630,
 2158,2850,1592,2158,2928,2209,1550,1838,2080,2835,1820,1,1,1,
 1781,6,778,856,782,6,1743,1794,1742,832,781,771,1593,2893,
 2065,1582,2207,2207,2861,1580,1904,2832,2119,1836,1,1,1,6,
 1772,801,799,735,1731,6,1767,1731,787,740,800,2185,597,1245,
 6,1257,1405,591,597,1087,1688,1087,6,1593,1630,250,236,194,
 329,121,192,197,137,121,122,172,234,1385,1245,2158,2146,597,
 1245,1220,597,1077,1690,1196,1167,1120,1642,1091,283,368,346,
 1091,1566,1091,1091,431,246,285,2010,2201,597,2213,1358,1477,
 1744,1477,1744,6,1715,1884,326,623,677,908,472,603,291,429,
 411,264,636,765,6,1257,2010,1245,1286,1297,1286,1297,1565,6,
 1592,184,163,87,183,158,158,163,87,86,163,86,162,2207,2136,
 6,6,2192,2106,6,1,1,1,1980,1965,1019,1126,1023,1972,1964,6,
 6,1026,1016,1035,1405,591,1951,1087,597,1087,1163,1163,1202,
 1132,1640,254,414,226,1556,1132,1132,1132,254,226,341,597,
 1977,1477,1815,1477,1930,1907,6,732,365,707,328,774,363,654,
 439,442,909,684,496,1219,1639,1050,597,1580,1550,6,235,171,
 170,125,168,157,190,118,114,190,157,118,1405,2010,1405,2062,
 2062,2859,851,909,365,732,442,774,707,328,490,439,363,654,
 1385,1978,1831,6,1821,651,410,487,710,704,409,621,292,277,
 763,264,661,1385,1715,6,1835,426,620,264,900,636,603,429,291,
 278,677,472,810,2830,2105,2132,922,681,304,498,606,637,763,
 264,471,621,275,427,2062,2061,873,853,1807,1786,6,779,850,
 832,779,6,1736,1807,2155,852,832,6,1775,1736,779,832,850,775,
 1807,6,1773,884,792,1785,6,1737,734,803,751,753,1740,1738,6,
 1133,56,72,25,1581,1379,1651,1132,49,33,53,30,40,14,1341,
 1590,1581,1091,36,17,19,1133,1091,14,30,22,12,1581,1341,1590,
 1132,25,56,57,34,1651,1581,1379,9,12,14,9,1341,1479,1539,
 1091,1091,1479,14,9,12,1132,1539,22,14,30,1341,30,12,37,17,
 7,15,1091,1132,1091,554,554,1588,1280,1280,1069,597,1621,881,
 1231,1713,1231,1811,975,597,1571,597,1588,881,1976,916,1596,
 1231,995,1231,1610,1576,1366,1366,1720,1608,597,127,193,195,
 138,193,191,126,238,195,251,186,117,554,554,554,916,1366,
 1366,1588,1280,1280,1576,683,1141,597,1139,1563,597,1621,881,
 1970,1231,1617,1231,1610,729,1783,975,597,1051,1720,597,1563,
 138,195,126,244,191,186,117,251,193,242,117,186,1280,1706,
 1280,597,1084,881,2036,1665,961,2036,1682,1292,1292,984,1112,
 881,1706,1748,559,993,757,1809,559,966,1747,1049,597,2983,
 2163,2163,456,380,1291,1291,1624,380,380,456,380,2271,1257,
 1257,554,1280,597,1051,554,554,916,975,683,1357,1357,1673,597,
 1724,1588,1280,1673,1280,1562,683,1783,1545,1051,597,975,1783,
 1724,597,1562,244,126,117,242,186,117,186,242,191,244,126,
 191,1280,1049,597,1280,1706,1280,1747,757,597,1106,1982,2200,
 2200,881,2036,1107,1665,2927,2036,966,1545,1683,1269,1269,1683,
 1112,984,993,1291,1291,380,456,380,1257,1257,2271,1624,456,
 380,380,1296,1290,1231,1665,1706,1296,1231,2198,1683,2198,597,
 1757,916,559,1748,1706,1584,713,1293,559,1675,2145,1677,2145,
 1758,1607,597,267,124,212,123,216,134,210,271,206,267,210,
 134,1366,975,1269,1677,1269,897,1700,2172,1878,597,2024,1576,
 1747,2922,2145,1752,1526,2145,1705,1701,4,1864,4,2874,2092,
 2081,902,328,519,344,611,536,812,915,733,647,513,342,1783,
 1683,2145,2145,1720,4,1916,4,2086,2100,1610,966,2000,1675,
 2841,1206,1206,967,2903,1701,2162,1892,1989,1847,597,522,347,
 820,405,794,348,516,643,612,953,755,543,554,1280,597,1231,
 597,1141,1970,597,1720,554,554,1139,916,1563,683,1051,729,
 1366,1366,1576,1610,597,1563,1617,242,117,186,251,117,126,191,
 244,186,138,195,193,1280,1269,2036,1106,597,1107,984,1112,
 1280,1706,1982,1280,993,757,1683,1545,597,1049,1747,966,2200,
 2200,2927,456,380,1257,2271,1257,380,380,456,380,1291,1291,
 1624,2145,1231,1287,1287,1298,1572,597,1231,1665,1298,1706,
 1607,1231,1675,1588,2145,1677,2145,1675,597,1572,1607,123,212,
 210,267,134,210,134,267,216,123,212,216,597,4,1700,4,597,
 2020,1366,1049,2040,1677,1762,1526,1366,1040,2162,1864,2892,
 1912,2186,2842,2097,915,536,611,376,519,328,733,902,812,520,
 613,333,1751,937,597,989,1083,1231,757,1214,713,978,1490,1065,
 1231,1206,1526,1526,1206,2124,2868,2124,245,222,1515,1245,1245,
 222,222,245,222,1245,1515,1245,1357,2198,2095,2189,975,1292,
 1292,1683,2843,937,1776,1538,1916,2172,1700,2911,597,1764,1800,
 356,524,789,914,405,509,361,644,614,555,848,870,1292,1764,
 597,1811,1682,2198,2198,1800,1751,2911,1538,4,1700,4,1776,
 2189,2095,2843,555,848,509,644,361,789,405,914,870,356,524,
 614,1845,597,1976,1748,1383,1748,1844,1214,1931,1383,2000,2922,
 2040,2180,2090,2862,2196,457,912,638,563,419,911,561,1031,910,
 451,639,528,2200,1608,2163,2862,1607,2163,2868,2085,1597,1847,
 2092,2842,1867,1,1,1,1103,597,690,696,689,597,1746,1874,1880,
 692,689,690,1720,2983,2090,1758,2124,2124,2898,1721,1989,2874,
 2186,1998,1,1,1,597,1995,898,907,898,1987,597,2013,1995,907,
 898,899,554,597,1280,597,1231,1366,1231,597,1069,1713,995,597,
 1571,1596,251,186,191,238,126,195,193,138,117,127,193,195,
 1292,1280,2163,2036,597,559,1084,597,961,1809,1112,984,993,
 2271,1257,380,456,380,1291,1624,1291,1257,456,380,380,2198,
 2196,597,2180,1383,4,1878,4,1931,597,1845,1844,451,639,911,
 1031,561,638,419,563,528,457,912,910,597,1231,2145,559,1290,
 1296,1296,1293,1757,597,1584,267,210,134,271,210,212,216,123,
 134,267,124,206,2124,2099,597,597,2081,2097,597,1,1,1,1937,
 1735,686,718,691,1798,1813,597,597,693,691,686,1206,1231,1720,
 897,597,1065,1083,989,978,1245,1515,222,245,222,1515,1245,
 1245,1245,245,222,222,597,1892,4,1912,4,1998,1867,597,643,
 348,794,405,820,347,612,522,516,913,826,550,967,1705,1040,
 597,1721,1597,597,217,177,181,131,181,181,181,131,120,217,
 177,120,1366,2145,1206,2100,2086,2841,953,755,348,643,516,820,
 794,405,543,522,347,612,1269,2145,2024,597,1752,647,513,536,
 915,812,519,611,344,342,902,328,733,1366,2020,597,1762,520,
 613,328,902,733,611,519,376,333,915,536,812,2898,2085,2099,
 913,826,347,522,612,794,820,405,550,643,348,516,2200,2124,
 907,898,1987,2013,597,898,898,907,899,597,1995,1995,2163,692,
 689,597,1874,1746,690,689,696,690,1103,597,1880,693,691,1798,
 597,1813,686,691,718,686,1937,1735,597,1291,42,62,39,1674,
 1291,2281,1245,63,39,43,18,42,24,1270,1618,1674,1257,39,23,
 18,1291,1257,24,18,39,23,1674,1270,1618,1245,39,42,63,39,
 2281,1674,1291,18,23,42,18,1291,1618,1626,1257,1291,1618,42,
 18,23,1245,1626,39,24,18,1291,62,42,39,43,18,23,1291,1245,
 1257,2653,2731,2731,2731,2,2,2536,2731,2731,2581,2731,2581,2,
 2,2615,2,2536,2536,2581,2731,2615,2731,2581,2731,2581,2581,2,
 2,2980,2,2,3,2582,2199,2199,2291,2582,3,2582,2582,2291,2199,
 2199,2731,2731,2731,2,2,2536,2731,2731,2581,2731,2581,2,2,
 2615,2,2536,2536,2581,2731,2615,2731,2581,2731,2581,2581,2,2,
 2980,2,2,3,2582,2199,2199,2291,2582,3,2582,2582,2291,2199,
 2199,2731,2731,2,2,2536,2536,2536,2654,2536,2677,2677,2477,2,
 2,2825,2536,2935,2536,3030,2536,2654,2536,2935,2477,2677,2677,
 3030,2,2,2350,2350,2350,2350,2483,2350,2350,2483,2483,2483,
 2350,2350,2653,2771,2,2731,2536,2731,2771,2731,2,2581,2,2,2,
 2536,2731,2581,2536,2980,2731,2771,2731,3029,2731,2731,2731,
 2615,2615,2,2199,2199,2582,3,2582,2199,2199,2291,2291,2582,
 2582,3,2771,2,2731,2536,2731,2771,2731,2,2581,2,2,2,2536,
 2731,2581,2536,2980,2731,2771,2731,3029,2731,2731,2731,2615,
 2615,2,2199,2199,2582,3,2582,2199,2199,2291,2291,2582,2582,3,
 2,2654,2677,2581,2677,2581,2704,2654,2477,2,2,2935,2654,2980,
 2677,3059,2581,2677,2581,3046,2,2,2,3046,2,2,2438,2393,2412,
 2367,2497,2708,2250,2516,2538,2497,2412,2367,2,2477,2,2,2,2,
 2477,2,2,2,2477,2,2477,2477,2824,2,2,2,2823,2,2,2,2477,
 2477,3,4,4,2250,4,2250,4,4,2251,2251,2250,2250,4,2536,2731,
 2,2731,2,2654,2,2,2,2536,2536,2654,2825,3030,2536,2654,2536,
 3029,3029,3029,3029,2,3030,2,2350,2350,2483,2350,2350,2350,
 2350,2483,2483,2350,2483,2350,2731,2677,2731,2654,2,2,2677,2,
 2536,2825,2654,2536,2677,2536,2935,2536,2477,2935,2677,2677,
 3148,3148,2823,2737,2537,2325,2332,2325,2537,2737,2537,2537,
 2325,2325,2332,2,2653,2771,2771,2,2615,2,2731,2536,2771,2536,
 2615,2731,2581,2731,2731,3029,2731,2731,2,2980,2,2427,2571,
 2291,2199,2199,2571,2427,2571,2571,2199,2291,2199,2,2,2704,2,
 2,2,2677,2654,2704,2935,3059,2581,2677,2581,3161,3143,3077,
 3077,2,3046,2,2250,2708,2497,2367,2412,2393,2438,2538,2516,
 2412,2497,2367,2771,2771,2,2615,2,2731,2536,2771,2536,2615,
 2731,2581,2731,2731,3029,2731,2731,2,2980,2,2427,2571,2291,
 2199,2199,2571,2427,2571,2571,2199,2291,2199,2677,2,2,2,2654,
 2677,2677,2935,3046,2581,2704,2581,3143,3161,3077,3077,2,3059,
 2,2367,2412,2538,2438,2393,2412,2367,2497,2497,2708,2516,2250,
 2,2744,3,2654,2935,2677,2677,2744,2581,2980,2581,2,3046,2,2,
 3153,3158,2823,2463,2656,2402,2366,2395,2559,2250,2559,2656,
 2395,2402,2366,2477,3,2,2477,2,2477,2477,2,2477,2,2,2823,2,
 2,2,2824,2,4,2250,2251,4,4,2250,4,2250,2250,4,2251,4,2,
 3030,3148,3046,3030,3148,2980,3153,2980,3148,3165,3086,3086,1,
 1,1,2525,2,2561,2478,2561,2,2525,2940,2940,2561,2561,2478,2,
 2823,2,2,2,2,2823,2,2,2823,2,2,1,1,1,2,2,3,3,3,2,2,2,
 2,3,3,3,2536,2,2536,2,2731,2677,2731,2477,2935,2677,2677,2,
 3030,2,2350,2483,2483,2350,2350,2483,2350,2350,2350,2350,2483,
 2350,2677,2536,3148,2731,2,2731,2935,2477,2677,2677,2677,2677,
 2,2332,2325,2537,2737,2537,2325,2332,2325,2325,2537,2537,2737,
 2677,2,2,2654,2,2,3046,2,2,2,3059,2,2367,2497,2516,2250,
 2708,2497,2367,2412,2412,2393,2538,2438,2,2731,2677,2731,2581,
 2581,2789,2789,3030,2,2,2350,2483,2350,2350,2483,2483,2350,
 2350,2350,2483,2350,2350,2,3158,2,2,3162,2,2,1,1,1,2525,
 2940,2546,2517,2546,2940,2525,2,2,2542,2545,2519,2,2653,2581,
 2581,2,2,2615,2615,2,2199,2291,2571,2427,2571,2291,2199,2199,
 2199,2571,2571,2427,2,3046,2,2,2,2744,2744,3,2366,2395,2559,
 2250,2559,2395,2366,2402,2402,2656,2656,2473,2581,2581,2,2,
 2615,2615,2,2199,2291,2571,2427,2571,2291,2199,2199,2199,2571,
 2571,2427,3029,2731,2731,3165,3162,2823,2611,2944,2502,2504,
 2541,2937,2594,2478,2592,2541,2502,2504,2731,2731,3148,2,2,
 2504,2541,2592,2611,2944,2541,2504,2502,2502,2937,2478,2594,
 2653,3086,2,2,2449,2559,2393,2444,2554,2554,2444,2393,2441,
 2559,2441,2449,3086,2,2,2449,2559,2393,2444,2554,2554,2444,
 2393,2441,2559,2441,2449,3148,2,2517,2546,2940,2525,2,2545,
 2519,2542,2546,2,2940,2525,2,2478,2561,2,2525,2940,2561,2478,
 2561,2561,2940,2,2525,3,3,2,2,2,3,3,3,3,2,2,2,2199,1852,
 1472,1842,2515,2,2515,2199,1938,1938,5,2262,1852,2265,2678,
 2515,2869,2325,2279,2279,1938,2199,2325,2279,1938,2279,2265,
 2869,2678,2515,2199,1938,5,1938,1842,2515,2515,2,2279,1939,
 2279,2262,2678,2869,2515,2199,2325,2869,2265,2262,1852,2199,
 2515,1842,1852,1472,2678,2262,2265,1842,2279,2279,1939,2325,
 2199,2199,2731,2731,2731,2,2,2536,2731,2731,2581,2731,2581,2,
 2,2615,2,2536,2536,2581,2731,2615,2731,2581,2731,2581,2581,2,
 2,2980,2,2,3,2582,2199,2199,2291,2582,3,2582,2582,2291,2199,
 2199,2653,2731,2,2,2731,2731,2731,2581,2536,2,2,2581,2,2,
 2536,2731,2581,2731,2980,2731,2581,2536,2581,2,2,2581,2615,2,
 2615,2199,2199,3,2582,2582,2199,2199,2291,2291,2582,3,2582,
 2731,2,2,2731,2731,2731,2581,2536,2,2,2581,2,2,2536,2731,
 2581,2731,2980,2731,2581,2536,2581,2,2,2581,2615,2,2615,2199,
 2199,3,2582,2582,2199,2199,2291,2291,2582,3,2582,2789,2789,
 2536,2536,2536,2581,2536,2677,2477,2677,2,2,2825,2536,2935,
 2536,3030,2536,2581,2536,2935,2677,2477,2677,3030,2,2,2350,
 2350,2350,2350,2483,2350,2350,2483,2483,2483,2350,2350,2653,
 2677,2731,2731,2731,2677,2,2,2,2,2,3029,2677,3077,2731,3086,
 2731,2731,2677,3077,2,2,2,3086,2,2,2444,2393,2444,2393,2554,
 2441,2449,2559,2554,2559,2446,2441,2677,2731,2731,2731,2677,2,
 2,2,2,2,3029,2677,3077,2731,3086,2731,2731,2677,3077,2,2,2,
 3086,2,2,2444,2393,2444,2393,2554,2441,2449,2559,2554,2559,
 2446,2441,2731,2731,2477,2536,2,2,2654,2,2,2536,2536,2654,
 2536,3030,2536,2935,2825,2677,2677,2477,2935,2,2,3030,2350,
 2350,2350,2483,2350,2350,2350,2483,2483,2350,2350,2483,2653,
 2731,2731,2771,2,2771,2615,2,2731,2536,2771,2731,2615,2731,
 3029,2536,2,2581,2,2581,2,2,2980,3,2582,2199,2291,2199,2582,
 3,2582,2582,2199,2199,2291,2731,2731,2771,2,2771,2615,2,2731,
 2536,2771,2731,2615,2731,3029,2536,2,2581,2,2581,2,2,2980,3,
 2582,2199,2291,2199,2582,3,2582,2582,2199,2199,2291,2477,2,2,
 2,2,2,3029,2935,3143,3029,3148,3029,3029,2935,3161,3046,2823,
 3046,3165,2823,3162,2611,2592,2504,2502,2541,2478,2594,2937,
 2944,2541,2504,2502,2654,2,2,2677,2,2536,2825,2654,2536,2677,
 2536,2935,2536,2677,2935,2477,2677,3148,2823,3148,2650,2501,
 2332,2325,2325,2501,2650,2501,2501,2325,2332,2325,2,2677,2,2,
 2654,2677,2677,2581,3046,2581,3046,2935,2704,2654,2477,2980,2,
 2,3059,2367,2412,2438,2538,2393,2412,2367,2497,2497,2708,2250,
 2516,2,2477,3,2,2477,2,2,2477,2,2823,2477,2,2477,2,2477,2,
 2,2824,4,2250,4,2251,4,2250,4,2250,2250,4,4,2251,2744,3,
 2654,2935,2677,2581,2744,2581,3046,2677,2704,2980,2477,2654,
 3153,2823,3158,2250,2559,2366,2402,2395,2656,2463,2656,2559,
 2395,2366,2402,2,3030,3148,3046,2980,3148,2980,3162,3030,3059,
 3158,2824,3059,1,1,1,2525,2,2518,2544,2542,2,2525,2940,2940,
 2546,2517,2546,2,2823,2,2,2,2,2823,2,2,2823,2,2,1,1,1,2,
 2,3,3,3,2,2,2,2,3,3,3,2536,2,2731,2,2731,3029,2536,2,
 2654,2,2654,2,2,3030,2350,2483,2350,2483,2350,2483,2350,2350,
 2350,2350,2350,2483,2677,2731,3148,2731,2477,2536,2654,2,2,
 2654,2677,2,2677,2332,2325,2737,2537,2537,2325,2332,2325,2325,
 2537,2737,2537,2,2,2,3161,2677,2,2704,2,2704,2,2,3059,2367,
 2497,2250,2516,2708,2497,2367,2412,2412,2393,2438,2538,2,2653,
 2731,2731,2771,2771,2,2771,2615,2,2615,2199,2291,2427,2571,
 2571,2291,2199,2199,2199,2571,2427,2571,2,3165,2,2,3153,2,2,
 1,1,1,2525,2940,2478,2561,2561,2940,2525,2,2,2561,2478,2561,
 2731,2731,2771,2771,2,2771,2615,2,2615,2199,2291,2427,2571,
 2571,2291,2199,2199,2199,2571,2427,2571,2477,3143,2,2,2,3148,
 2,2,2504,2502,2594,2478,2937,2502,2504,2541,2541,2944,2642,
 2592,2654,2654,2,2,3030,2,2,2350,2483,2350,2350,2483,2483,
 2350,2350,2350,2483,2350,2350,2677,2,2677,2,2,3046,2250,2516,
 2367,2497,2412,2538,2438,2393,2708,2412,2367,2497,2,2677,2744,
 3,2744,2366,2402,2463,2656,2656,2402,2366,2395,2395,2559,2250,
 2559,2,2477,3,2477,4,2251,4,2250,2250,2251,4,4,4,2250,4,
 2250,3046,2,2,2250,2516,2367,2412,2497,2538,2438,2393,2708,
 2497,2367,2412,2,3148,2478,2561,2525,2940,2,2561,2478,2561,
 2561,2,2525,2940,2,3,3,2,2,2,3,3,3,3,2,2,2,2478,2561,
 2525,2,2940,2561,2478,2561,2561,2940,2525,2,2199,5,1938,1938,
 2515,2,2515,2199,1842,1468,1841,1938,2279,2279,2678,2515,2869,
 2325,2265,1841,2265,2199,2199,1852,1472,1842,1939,2515,2,2515,
 2325,2264,1852,2265,2279,2869,2515,2678,2262,1852,2265,2279,
 2678,2515,2869,2199,2325,2869,2279,1938,2279,2199,2515,1938,5,
 1938,2678,2279,1939,2279,2263,1852,2264,2199,2325,2199,2731,
 2653,2,2771,2731,2731,2536,2771,2731,2731,2731,2731,2,2615,
 2536,2731,3029,2731,2615,2536,2771,2731,2581,2,2581,2,2980,2,
 2,2582,3,2199,2199,2291,3,2582,2582,2582,2291,2199,2199,2731,
 2,2,2536,2536,2536,2654,2536,2477,2677,2677,2714,2714,2825,
 2536,2935,2536,2980,2536,2654,2536,2935,2677,2677,2477,2980,
 2714,2714,2408,2408,2408,2408,2278,2408,2408,2278,2278,2278,
 2408,2408,2,2771,2731,2731,2536,2771,2731,2731,2731,2731,2,
 2615,2536,2731,3029,2731,2615,2536,2771,2731,2581,2,2581,2,
 2980,2,2,2582,3,2199,2199,2291,3,2582,2582,2582,2291,2199,
 2199,2,2,2,2477,2,2,2,2,2,3,2477,2477,2,2823,2,2477,2477,
 2,2,2477,2,2477,2,2824,2,2,2250,4,4,4,2251,4,2250,2250,
 2250,2251,4,4,2654,2581,2677,2677,2581,2,2,2,2723,2653,2935,
 2654,3046,2581,3011,2677,2677,2581,2980,2704,2654,2477,3078,2,
 2,2421,2416,2250,2250,2501,2416,2421,2513,2513,2325,2439,2439,
 2731,2536,2,2731,2477,2677,2677,2,2677,2536,2536,2935,2536,
 2677,2825,2654,2536,2677,2677,2935,2477,2823,3148,3148,2537,
 2737,2325,2325,2332,2737,2537,2537,2537,2332,2325,2325,2731,2,
 2653,2581,2,2,2789,2789,2731,2536,2581,2731,2789,2536,2581,
 2731,2,2581,2581,2,3200,3200,3200,2202,2202,2731,2731,2731,
 2202,2202,2202,2202,2731,2731,2731,2677,2731,2581,2789,2789,
 2677,2,2536,2825,2581,2536,2677,2536,2935,2536,2677,2935,2677,
 2477,2823,3148,3148,2737,2537,2325,2325,2332,2537,2737,2537,
 2537,2332,2325,2325,2,2,2,2,3,2420,2677,2654,3046,2581,2420,
 2935,2677,2581,2654,2704,2980,2477,3214,3209,3209,2616,2468,
 2363,2363,2400,3,2678,2678,2616,2400,2363,2363,2581,2,2,2789,
 2789,2731,2536,2581,2731,2789,2536,2581,2731,2,2581,2581,2,
 3200,3200,3200,2202,2202,2731,2731,2731,2202,2202,2202,2202,
 2731,2731,2731,2731,2731,2807,2752,2935,3029,3029,3029,3046,
 2935,3143,3029,3046,3161,3046,2823,2823,3166,3166,2583,2733,
 2554,2554,2478,2733,2583,2937,2937,2567,2567,2567,2653,2456,3,
 2677,3029,2731,2731,2456,2677,3077,2731,2,3077,2,2,3212,3215,
 3215,3,2430,2429,2429,2411,2430,3,2430,2430,2411,2429,2429,
 2456,3,2677,3029,2731,2731,2456,2677,3077,2731,2,3077,2,2,
 3212,3215,3215,3,2430,2429,2429,2411,2430,3,2430,2430,2411,
 2429,2429,2714,2677,2714,3046,2615,2714,2980,2723,2615,2420,
 2653,3011,2477,1,1,1,2572,2,2250,2250,2404,2,2572,2572,2572,
 2404,2250,2250,2677,2980,2752,2615,2714,2714,3011,2615,2420,
 3011,2653,2477,1,1,1,2,2572,2250,2250,2404,2572,2,2572,2572,
 2404,2250,2250,2536,2477,2731,2,2536,2677,2731,2,2654,2654,2,
 2823,3148,3148,2537,2537,2325,2325,2332,2537,2537,2737,2737,
 2332,2325,2325,3029,2731,2714,2536,2,2731,2654,2,2654,2,2980,
 2714,2714,2278,2408,2408,2408,2278,2408,2278,2408,2408,2278,
 2408,2408,2731,2807,2477,3161,2731,2,3143,2,2,2823,3166,3166,
 2583,2937,2567,2567,2567,2937,2583,2733,2733,2478,2554,2554,2,
 2731,2,2653,2771,2771,2771,2,2980,2,2,2582,2582,2199,2199,
 2291,2582,2582,3,3,2291,2199,2199,2714,2653,2,3,2723,2723,3,
 1,1,1,2572,2572,2250,2250,2404,2572,2572,2,2,2404,2250,2250,
 2677,2731,2654,2654,2,2,2980,2714,2714,2408,2278,2579,2579,
 2268,2278,2408,2408,2408,2268,2579,2579,2,2704,2,2704,2,3078,
 2,2,2513,2416,2250,2250,2501,2416,2513,2421,2421,2325,2439,
 2439,2771,2771,2771,2,2980,2,2,2582,2582,2199,2199,2291,2582,
 2582,3,3,2291,2199,2199,2677,2677,2,3214,3209,3209,2616,2616,
 2363,2363,2400,2678,2678,3,2468,2400,2363,2363,2677,2,3078,2,
 2,2513,2421,2439,2439,2325,2421,2513,2416,2416,2501,2250,2250,
 2,3078,2,2,2421,2513,2250,2250,2501,2513,2421,2416,2416,2325,
 2439,2439,2824,2,2,2250,2250,4,4,2251,2250,2250,4,4,2251,4,
 4,3200,3200,2986,2986,3077,3077,2823,2986,2986,2986,2986,2823,
 3077,3077,2653,2,2,2,2,3161,2,2,2,2,3161,2,2,2,2,2,2,
 3161,2,2,2,2,3161,2,2,2408,2039,2039,2279,2513,2714,2513,
 2408,2279,2039,2039,2039,2039,2279,2714,2513,2513,2408,2279,
 2039,2039,2653,2731,2039,2039,2039,2039,3029,2731,2731,2731,
 2039,2039,2039,2039,3029,2731,2731,2279,2279,2279,2279,3029,
 3029,3029,2408,2408,2513,2279,2039,2039,2408,2513,2279,2039,
 2039,2714,2279,2039,2039,2279,2039,2039,2731,2731,2653,2731,2,
 2,2731,2731,2731,2581,2536,2,2,2581,2,2,2536,2731,2581,2731,
 2980,2731,2581,2536,2581,2,2,2581,2615,2,2615,2199,2199,3,
 2582,2582,2199,2199,2291,2291,2582,3,2582,2,2771,2731,2731,
 2536,2771,2731,2731,2731,2731,2,2615,2536,2731,3029,2731,2615,
 2536,2771,2731,2581,2,2581,2,2980,2,2,2582,3,2199,2199,2291,
 3,2582,2582,2582,2291,2199,2199,2,2,2,2477,2,2,2,2,2,3,
 2477,2477,2,2823,2,2477,2477,2,2,2477,2,2477,2,2824,2,2,
 2250,4,4,4,2251,4,2250,2250,2250,2251,4,4,2581,2581,2677,
 2677,2654,2,2,2,2,2,2935,2581,3046,2581,3046,2677,2677,2654,
 2980,2477,2789,2704,3059,2,2,2412,2367,2438,2393,2538,2367,
 2412,2497,2497,2516,2250,2708,2653,2731,2,2731,2,2,2581,2,
 2615,2731,2731,2581,2731,2615,2536,2581,2536,2,2,2581,2581,2,
 2,2980,2582,3,2199,2291,2199,3,2582,2582,2582,2199,2199,2291,
 2731,2,2731,2,2,2581,2,2615,2731,2731,2581,2731,2615,2536,
 2581,2536,2,2,2581,2581,2,2,2980,2582,3,2199,2291,2199,3,
 2582,2582,2582,2199,2199,2291,2677,2536,2789,2789,2581,2,2,
 2536,2536,2581,2536,3030,2536,2935,2825,2677,2477,2677,2935,2,
 2,3030,2350,2350,2350,2483,2350,2350,2350,2483,2483,2350,2350,
 2483,2,2,2,2,3,2744,2677,2581,3046,2581,2744,2935,2677,2654,
 2789,2477,2980,2704,3158,2823,3153,2656,2463,2366,2395,2402,
 2250,2559,2559,2656,2402,2366,2395,2677,2677,2477,2,2677,2536,
 2536,2935,2536,2677,2825,2654,2536,2677,2477,2935,2677,3148,
 2823,3148,2501,2650,2332,2325,2325,2650,2501,2501,2501,2325,
 2332,2325,2653,2731,2,2,2677,2731,2731,2731,3086,2677,3077,
 3029,2,2,2,3077,2,2,3086,2441,2449,2444,2554,2393,2444,2393,
 2554,2559,2441,2449,2559,2731,2,2,2677,2731,2731,2731,3086,
 2677,3077,3029,2,2,2,3077,2,2,3086,2441,2449,2444,2554,2393,
 2444,2393,2554,2559,2441,2449,2559,2,2,2935,3029,3029,3029,
 3148,2935,3143,3029,3046,2823,3046,3161,3162,2823,3165,2478,
 2594,2504,2541,2502,2611,2592,2944,2937,2502,2504,2541,2,2,2,
 2823,2,2,2823,2,2,2,2,2823,2,1,1,1,2,2,3,3,3,2,2,2,2,
 3,3,3,3030,2980,3162,2980,3148,3148,3046,3030,3059,2824,3158,
 3059,1,1,1,2,2525,2518,2542,2544,2525,2,2940,2940,2546,2517,
 2546,2731,2477,2731,2,2536,2677,2536,2,2,2654,2654,2,2,3030,
 2483,2350,2350,2483,2350,2350,2483,2350,2350,2350,2350,2483,
 2731,2653,2,2731,2,2731,2771,2,2771,2771,2615,2,2615,2291,
 2199,3,2582,2582,2199,2291,2199,2199,2582,3,2582,2731,3165,
 2477,3161,3029,2,2,2,3143,2,2,3148,2502,2504,2611,2944,2592,
 2504,2502,2541,2541,2478,2594,2937,2,2731,2,2731,2771,2,2771,
 2771,2615,2,2615,2291,2199,3,2582,2582,2199,2291,2199,2199,
 2582,3,2582,3148,2,2,2,2,3153,2,1,1,1,2940,2525,2517,2546,
 2546,2525,2940,2,2,2542,2518,2544,2677,2536,2654,2,2,2654,
 2677,2,2677,2325,2332,2650,2501,2501,2332,2325,2325,2325,2501,
 2650,2501,2,2704,2,2704,2,3059,2,2,2497,2367,2438,2393,2538,
 2367,2497,2412,2412,2516,2250,2708,2654,2,2654,2,3030,2,2,
 2483,2350,2350,2350,2483,2350,2483,2350,2350,2483,2350,2350,2,
 2677,2677,2,2,3046,2516,2250,2367,2497,2412,2438,2538,2393,
 2708,2412,2367,2497,2,2,2477,3,2477,2251,4,4,2250,2250,4,
 2251,4,4,2250,4,2250,2677,2744,3,2744,2402,2366,2250,2559,
 2559,2366,2402,2395,2395,2656,2463,2656,3046,2,2,2516,2250,
 2367,2412,2497,2438,2538,2393,2708,2497,2367,2412,2,3148,2546,
 2517,2525,2940,2,2518,2544,2542,2546,2,2525,2940,2,3,3,2,2,
 2,3,3,3,3,2,2,2,2542,2518,2525,2,2940,2517,2546,2546,2544,
 2940,2525,2,2199,1852,2262,2264,2515,2678,2869,2325,2279,1938,
 2279,1472,1852,1852,2,2515,2515,2199,1938,5,1938,2199,2199,5,
 1938,1938,1852,2515,2,2515,2325,1938,2279,2279,2264,2869,2515,
 2678,1938,2279,2279,2262,2678,2515,2869,2199,2199,2515,1852,
 1472,1852,2325,2869,2264,1852,2262,2678,2262,1852,2264,2279,
 1938,2279,2199,2325,2199,2771,2,2731,2536,2731,2771,2731,2,
 2581,2,2,2,2536,2731,2581,2536,2980,2731,2771,2731,3029,2731,
 2731,2731,2615,2615,2,2199,2199,2582,3,2582,2199,2199,2291,
 2291,2582,2582,3,2,2581,2677,2581,2677,2654,2477,2789,2704,2,
 2,2935,2581,2980,2677,3078,2581,2677,2654,3046,2,2,2,3011,
 2653,2723,2250,2250,2421,2416,2513,2439,2439,2325,2501,2513,
 2421,2416,2,2477,2,2,2,2,2477,2,2,2,2477,2,2477,2477,2824,
 2,2,2,2823,2,2,2,2477,2477,3,4,4,2250,4,2250,4,4,2251,
 2251,2250,2250,4,2731,2653,2,2731,2,2771,2771,2,2,2731,2731,
 2771,2536,2980,2731,2581,2536,2731,2731,2731,3029,2,2615,2615,
 2199,2199,2582,2582,3,2199,2199,2291,2291,3,2582,2582,2731,
 2677,2536,2,2,2654,2714,2714,2536,2536,2654,2536,2980,2536,
 2935,2825,2477,2677,2677,2935,2714,2714,2980,2408,2408,2408,
 2278,2408,2408,2408,2278,2278,2408,2408,2278,2,2731,2,2771,
 2771,2,2,2731,2731,2771,2536,2980,2731,2581,2536,2731,2731,
 2731,3029,2,2615,2615,2199,2199,2582,2582,3,2199,2199,2291,
 2291,3,2582,2582,2,2,2704,2,2,2,2677,2581,2704,2935,3078,
 2581,2677,2654,3161,3077,3077,3143,2653,3011,2723,2439,2439,
 2513,2416,2421,2250,2250,2501,2325,2421,2513,2416,2,2654,2,
 2714,2714,2536,2536,2654,2825,2980,2536,2654,2536,3029,3029,
 3029,3029,2714,2980,2714,2579,2579,2278,2408,2408,2579,2579,
 2268,2268,2408,2278,2408,2,2,2,2,2,2,2,2477,2824,2,2477,
 2477,2,2,2,2823,3,2477,2477,4,4,2250,2250,4,4,4,2251,2251,
 4,2250,2250,2677,2,2,2654,2581,2677,2677,3078,2581,2980,2935,
 2,2,2,3046,2723,2653,3011,2439,2439,2421,2513,2416,2250,2250,
 2501,2325,2416,2421,2513,2,2,2654,2581,2677,2935,3078,2581,
 2704,2677,3143,3077,3077,3161,2723,3011,2653,2250,2250,2513,
 2421,2416,2439,2439,2325,2501,2416,2513,2421,2653,3148,3200,
 3209,3148,3200,3200,3209,3148,3166,3215,3215,3166,1,1,1,2,2,
 2,2,2,2,2,3161,3161,2,2,2,3148,3200,3209,3148,3200,3200,
 3209,3148,3166,3215,3215,3166,1,1,1,2,2,2,2,2,2,2,3161,
 3161,2,2,2,2731,2,2536,2823,2731,2677,2536,2477,2677,2677,
 2935,2,2677,2677,2325,2325,2537,2537,2737,2325,2325,2332,2332,
 2737,2537,2537,2,2731,3200,2653,2,2731,2581,2,2,2581,2789,
 2789,2789,2731,2731,2202,2202,2202,2731,2731,2731,2731,2202,
 2202,2202,2677,3214,2,2789,2677,2,2,2,3046,3,2420,2420,2363,
 2363,2616,2616,2468,2363,2363,2400,2400,3,2678,2678,2823,2731,
 2677,2536,2581,2789,2789,2581,2677,2,2677,2325,2325,2737,2537,
 2537,2325,2325,2332,2332,2537,2737,2537,3200,3214,2823,2823,
 3212,3212,2823,1,1,1,3077,3077,2986,2986,2986,3077,3077,2823,
 2823,2986,2986,2986,2,2731,2581,2,2,2581,2789,2789,2789,2731,
 2731,2202,2202,2202,2731,2731,2731,2731,2202,2202,2202,2,3046,
 2,2,2,2420,2420,3,2363,2363,2678,3,2678,2363,2363,2400,2400,
 2616,2616,2468,2935,2677,2677,2477,2677,2677,2,2325,2325,2537,
 2737,2537,2325,2325,2332,2332,2537,2537,2737,2731,2731,3029,
 2807,2752,3046,2567,2567,2583,2937,2733,2554,2554,2478,2567,
 2733,2583,2937,2653,2731,2456,3,2456,2429,2429,3,2430,2430,
 2429,2429,2411,2411,2430,3,2430,2731,2456,3,2456,2429,2429,3,
 2430,2430,2429,2429,2411,2411,2430,3,2430,3046,2752,2807,2567,
 2567,2583,2733,2937,2554,2554,2478,2567,2937,2583,2733,2714,
 2714,2250,2250,2572,2572,2,2250,2250,2404,2404,2,2572,2572,
 2714,2250,2250,2,2572,2572,2250,2250,2404,2404,2572,2,2572,
 2250,2250,2572,2,2572,2250,2250,2404,2404,2572,2572,2,2653,
 2039,2039,2039,2731,2731,3029,2731,2039,2039,2039,2039,2039,
 2039,2731,2731,3029,2731,2039,2039,2039,2408,2408,2039,2039,
 2279,2279,2513,2714,2513,2408,2039,2039,2279,2279,2513,2513,
 2714,2039,2039,2279,2279,2714,2513,2513,2653,2731,3029,2039,
 2039,2039,2731,3029,2039,2039,2039,3029,2279,2279,2279,2279,
 2279,2279,2408,2408,2408,2789,2771,2789,2581,2789,2771,2771,
 2789,2771,3,2644,2581,2771,3077,2789,2644,2581,2789,2771,2387,
 2,2387,2,3011,2,2,2379,4,2243,2233,2310,4,2379,2379,2379,
 2310,2243,2233,2771,2581,2789,2789,2771,2,2387,2,2,2,2581,
 2771,2387,2581,3011,2789,2789,2771,3077,2771,2789,2771,2644,
 2644,3,2243,2233,2379,4,2379,2233,2243,2310,2310,2379,2379,4,
 2731,2731,2,2653,2,2581,2,2,2615,2731,2731,2581,2536,2615,
 2536,2771,2731,2731,2731,3029,2731,2,2980,2,2571,2427,2291,
 2199,2199,2427,2571,2571,2571,2199,2291,2199,2536,2789,2731,
 2677,2477,2677,2,2677,2536,2536,2935,2536,2677,2825,2581,2536,
 2477,2677,2935,2677,3148,3148,2823,2537,2737,2325,2332,2325,
 2737,2537,2537,2537,2325,2325,2332,2789,2731,2789,2581,2789,2,
 2,2536,2536,2581,2825,3030,2536,2581,2536,3029,3029,3029,3029,
 2,3030,2,2350,2350,2483,2350,2350,2350,2350,2483,2483,2350,
 2483,2350,2,2,2387,2,3,2644,2789,2771,2387,2581,2644,2581,
 2789,2771,2789,2771,3077,2771,2,3011,2,2379,4,2310,2233,2243,
 4,2379,2379,2379,2243,2310,2233,2,2581,2,2,2615,2731,2731,
 2581,2536,2615,2536,2771,2731,2731,2731,3029,2731,2,2980,2,
 2571,2427,2291,2199,2199,2427,2571,2571,2571,2199,2291,2199,
 2731,2653,2,2,2677,2731,2731,3029,3086,2677,2771,2731,3161,
 3200,3161,3200,2,3086,2,2393,2444,2554,2444,2393,2449,2441,
 2559,2554,2441,2559,2449,2731,2,2,2935,3029,3029,3029,3148,
 2935,3077,3029,2823,3161,2823,3161,3162,3165,2823,2592,2611,
 2541,2504,2502,2594,2478,2937,2944,2502,2541,2504,2,2,2677,
 2731,2731,3029,3086,2677,2771,2731,3161,3200,3161,3200,2,3086,
 2,2393,2444,2554,2444,2393,2449,2441,2559,2554,2441,2559,2449,
 2,2,2,2823,2,2,2823,2,2,2,2,2823,2,1,1,1,2,2,3,3,3,2,
 2,2,2,3,3,3,3030,2980,3162,3030,3148,3148,3011,2980,3148,
 3086,3165,3086,1,1,1,2,2525,2561,2478,2561,2525,2,2940,2940,
 2561,2561,2478,2731,2477,2536,2,2536,2789,2731,2477,2677,2935,
 2677,2,3030,2,2483,2350,2483,2350,2350,2350,2483,2350,2350,
 2350,2483,2350,2731,2731,2,2731,2,2653,2581,2,2581,2,2615,
 2615,2,2291,2199,2582,3,2582,2199,2291,2199,2199,2582,2582,3,
 3029,3165,2477,2789,2731,2823,3161,2823,3161,2,3148,2,2502,
 2504,2944,2611,2592,2504,2502,2541,2541,2478,2937,2594,2,2536,
 2789,2731,2581,2789,2581,2789,3030,2,2,2483,2350,2350,2350,
 2483,2350,2483,2350,2350,2483,2350,2350,3148,2,2,2,2,3162,2,
 1,1,1,2940,2525,2561,2478,2561,2525,2940,2,2,2561,2561,2478,
 2789,2731,2935,2677,2477,2677,2677,2677,2,2325,2332,2501,2650,
 2501,2332,2325,2325,2325,2501,2501,2650,2,2387,2,2387,2,2644,
 2644,3,2310,2233,2379,4,2379,2233,2310,2243,2243,2379,2379,4,
 2581,2,2581,2,2615,2615,2,2291,2199,2582,3,2582,2199,2291,
 2199,2199,2582,2582,3,2731,3029,2731,3165,3162,2823,2944,2611,
 2502,2504,2541,2594,2937,2478,2592,2541,2502,2504,2731,2653,
 3086,2,2,2559,2449,2441,2449,2559,2444,2554,2393,2441,2554,
 2393,2444,2731,3148,2,2,2541,2504,2478,2594,2937,2504,2541,
 2502,2502,2944,2592,2611,3086,2,2,2559,2449,2441,2449,2559,
 2444,2554,2393,2441,2554,2393,2444,3148,2,2561,2478,2940,2525,
 2,2478,2561,2561,2561,2,2940,2525,2,2544,2518,2,2525,2940,
 2517,2546,2546,2542,2940,2,2525,3,3,2,2,2,3,3,3,3,2,2,2,
 2199,2279,1938,2279,2515,2678,2869,2325,2265,2264,1852,1938,5,
 1939,2,2515,2515,2199,1842,1852,1472,2199,2325,1841,2265,2265,
 2279,2869,2678,2515,2199,1468,1841,1842,1938,2515,2515,2,1852,
 2264,2263,2279,2678,2869,2515,2199,2199,2515,1939,1938,5,2325,
 2869,2279,2279,1938,2678,2279,2279,1938,2265,2262,1852,2325,
 2199,2199,2677,2731,2731,2731,2677,2,2,2,2,2,3029,2677,3077,
 2731,3086,2731,2731,2677,3077,2,2,2,3086,2,2,2444,2393,2444,
 2393,2554,2441,2449,2559,2554,2559,2446,2441,2,2581,2,2771,
 2477,2654,2704,3,2744,2581,2581,2980,2677,2744,2935,2677,2654,
 2,2,3046,2,2823,3158,3153,2559,2250,2402,2395,2366,2463,2656,
 2656,2559,2366,2402,2395,2731,2653,2,2,2,2,3,2456,2731,2677,
 3077,2731,2456,3029,2731,2677,2,2,3077,2,3215,3215,3212,2430,
 3,2429,2411,2429,3,2430,2430,2430,2429,2429,2411,2731,2581,
 2387,2789,2387,2,2,3029,2935,3077,3029,3148,3029,3029,2935,
 3161,2823,3161,2823,2823,3165,3162,2594,2478,2541,2502,2504,
 2592,2611,2944,2937,2504,2541,2502,2,2,2,2,3,2456,2731,2677,
 3077,2731,2456,3029,2731,2677,2,2,3077,2,3215,3215,3212,2430,
 3,2429,2411,2429,3,2430,2430,2430,2429,2429,2411,2704,2789,
 2477,3,2420,2581,2654,2980,2677,2420,2935,2677,2581,2,2,3046,
 2,3209,3214,3209,2665,2393,2400,2363,2363,2459,2605,2605,2665,
 2363,2400,2363,2,2771,2,2,3046,3077,3077,3161,3209,3046,3161,
 3143,1,1,1,1,2823,3191,3182,2477,2477,2691,1462,2536,2786,
 2707,3146,3048,2607,2701,2672,2,2,2,3161,3161,3200,3200,3247,
 3161,3200,3161,1,1,1,1,1,1,1,2798,2653,2739,2699,2699,2798,
 2653,3163,3163,2699,2739,2699,2,2,3046,3143,3077,3161,3179,
 3046,3161,3077,1,1,1,1,3224,3232,3228,2653,2653,2681,2585,
 2562,2783,2477,3089,3149,2562,2681,2585,2,2,2,2823,2,2,2823,
 2,2,2,2,2823,2,1,1,1,2,3,3,3,3,3,2,2,2,3,3,3,3148,
 3078,3212,3086,3166,3166,3086,3059,3179,2823,3197,2823,1,1,1,
 2,2581,2625,2627,2687,2632,2,3042,3048,2669,2598,2536,2581,
 2823,2731,2,3029,2731,2581,2,2,3143,2,2823,3165,3162,2937,
 2478,2541,2502,2504,2592,2944,2611,2594,2504,2541,2502,3077,2,
 2,2581,2,2771,2704,2,2704,2,3011,2653,2723,2501,2250,2421,
 2416,2513,2439,2325,2439,2250,2513,2421,2416,3200,3238,2823,
 3200,3077,1,1,1,1,2823,3269,3212,2982,2825,3096,2996,2996,
 2996,2996,3096,3080,2825,3080,2982,2,2731,2653,2,2771,2,2771,
 2,3086,2,2,2554,2393,2444,2393,2554,2441,2559,2449,2444,2559,
 2449,2441,3166,2,2,2,2,3182,2,1,1,1,3048,2581,2630,2622,
 2685,2632,3042,2,2,2667,2602,2536,2731,2581,3143,2,2,2,3046,
 2797,2752,2554,2478,2641,2520,2919,2567,2567,2567,2554,2919,
 2641,2520,2,2771,2,2771,2,3086,2,2,2554,2393,2444,2393,2554,
 2441,2559,2449,2444,2559,2449,2441,2704,2,2704,2,3046,2,2,
 2538,2393,2412,2367,2497,2708,2516,2250,2438,2497,2412,2367,2,
 3161,2,3232,3228,3224,3087,2477,2585,2562,2681,2779,3152,2653,
 2781,2681,2585,2562,2,2,2823,2,2,2477,3,3,3,2477,3,2477,3,
 3,2477,3,3,2,3209,2,2,2691,2536,2477,2477,3048,2607,2703,
 2672,1462,3146,2785,2707,2823,2,2,2477,3,3,3,2477,3,2477,3,
 3,2477,3,3,3215,3209,2997,2825,2991,2959,2823,3015,3051,3049,
 2997,2823,2991,2959,2,2696,2654,2,2671,3214,2,2,2,2696,3158,
 2,2,2697,2654,2,2,3150,2,2,2,2697,3150,2,2,2250,2346,2340,
 2498,2606,2731,2955,2554,2498,2346,2340,2062,2062,2252,3,2581,
 2581,2250,2252,2062,2062,4,2429,2241,2349,2349,2346,2946,2758,
 2754,2363,2166,2318,2318,2340,2940,2754,2745,2302,2498,2498,
 2498,3047,2946,2940,2439,2439,2606,2306,2222,2176,2567,2955,
 2495,2341,2315,2731,2492,2345,2314,2498,2346,2340,2429,2363,4,
 2581,2,2,2771,2,2704,2,2,2,2581,2581,2704,2935,3046,2677,
 2677,2654,3077,3077,3161,3143,2,3059,2,2412,2367,2538,2393,
 2438,2367,2412,2497,2497,2250,2516,2708,2731,2731,2581,2,2,2,
 2752,2807,3029,2935,3143,3029,3046,3029,3029,2935,2823,3046,
 3161,3046,3166,3166,2823,2733,2583,2554,2478,2554,2583,2733,
 2937,2937,2567,2567,2567,2653,2,2,2771,2,2,2,2731,2677,2771,
 3029,3086,2731,2731,2677,3200,3161,3200,3161,2,3086,2,2449,
 2441,2554,2393,2444,2393,2444,2554,2559,2446,2559,2441,2,2,
 2771,2,2,2,2731,2677,2771,3029,3086,2731,2731,2677,3200,3161,
 3200,3161,2,3086,2,2449,2441,2554,2393,2444,2393,2444,2554,
 2559,2446,2559,2441,2,2704,2,2723,2728,2581,2654,2704,2935,
 3011,2677,2677,2581,3077,3143,3161,3077,2,3078,2,2414,2406,
 2501,2250,2250,2406,2414,2505,2505,2439,2325,2439,2,2,2,2,2,
 2,2,2823,2823,2,2,2,1,1,1,1,2,2823,2,3,3,2477,3,3,3,3,
 2477,2477,3,2477,3,2,2,2,3143,3046,3161,3161,3209,3077,3077,
 3046,1,1,1,1,3182,3197,2823,2786,2707,2691,2536,1462,2477,
 2477,3048,3146,2672,2703,2607,2,2,2,2,2,2823,2823,2,2,2,1,
 1,1,1,2,2823,2,3,3,2477,3,3,3,3,2477,2477,3,2477,3,2,
 3162,3209,3224,3162,3209,3212,3212,3153,3212,3228,3239,3182,1,
 1,1,2,2,2697,2654,2692,2,2,3150,3150,2,2,2,3165,3214,3228,
 3165,3215,3215,3215,3158,3238,3232,3200,3191,1,1,1,2,2,2696,
 2654,2694,2671,2,3214,3158,2,2,2,2581,2,3029,2823,2731,2731,
 2581,2823,3046,3161,3046,2,3148,2,2541,2502,2937,2478,2594,
 2502,2541,2504,2504,2611,2944,2592,2,2581,3209,2,2,2771,2980,
 2477,2654,2704,2420,2420,3,2400,2363,2678,3,2678,2363,2400,
 2363,2363,2616,2616,2468,3161,3232,2,2,2,1,1,1,1,2,3179,2,
 2585,2562,3087,2477,2781,2562,2585,2681,2681,2653,3152,2779,
 2823,2731,2731,2581,3077,2387,2789,2387,3148,2,2,2541,2502,
 2594,2478,2937,2502,2541,2504,2504,2944,2611,2592,3215,3215,
 2823,2823,3224,3239,2823,1,1,1,2991,2959,2997,2825,2995,2959,
 2991,2823,2823,3049,3052,3013,2653,2,3077,2,2,2,2456,2456,3,
 2429,2411,2683,2393,2683,2411,2429,2429,2429,2706,2706,2476,2,
 3077,2,2,2,2456,2456,3,2429,2411,2683,2393,2683,2411,2429,
 2429,2429,2706,2706,2476,2980,2704,2789,2477,2744,2744,3,2402,
 2395,2559,2250,2559,2395,2402,2366,2366,2656,2656,2463,3077,
 3200,3077,3238,3212,2823,3096,2996,2982,2825,3080,2982,3080,
 2825,2996,3096,2996,2996,2,2771,3179,2,2,2681,2585,2779,2653,
 3152,2585,2681,2562,2562,3087,2477,2781,2,3230,2,2,2758,2753,
 2,2,3202,2753,2758,2753,2753,3172,2813,2813,3209,2,2,2703,
 2672,2477,2477,3048,1462,2691,2536,2607,3146,2707,2786,3166,2,
 2630,2622,3048,2581,2,2536,2599,2667,2687,2,3042,2632,2,2600,
 2536,2,2581,3048,2622,2628,2687,2667,3042,2,2632,3,3,2,3,2,
 3,3,3,3,2,2,3,4,2346,2062,2338,2741,2758,2946,2429,2349,
 2342,2226,2340,2062,2329,2745,2741,2940,2363,2318,2315,2176,
 2250,2554,2340,2346,2498,2498,2955,2794,2606,2250,2062,2062,
 2252,2252,2581,2581,3,2327,2335,2494,2495,2794,2955,2606,4,
 2363,2940,2315,2318,2165,2429,2946,2343,2349,2241,3047,2492,
 2498,2304,2498,2492,2306,2567,2439,2439,2731,2,2731,2,2,2581,
 2,2615,2731,2731,2581,2731,2615,2536,2581,2536,2,2,2581,2581,
 2,2,2980,2582,3,2199,2291,2199,3,2582,2582,2582,2199,2199,
 2291,2,2731,2,2771,2771,2,2,2731,2731,2771,2536,2980,2731,
 2581,2536,2731,2731,2731,3029,2,2615,2615,2199,2199,2582,2582,
 3,2199,2199,2291,2291,3,2582,2582,2,2,2477,2,3,2477,2,2,
 2477,2477,2477,2477,2,2,2,2,2823,2,2,2824,2,2250,4,2251,4,
 4,4,2250,2250,2250,4,2251,4,2,2581,2,2,2615,2731,2731,2581,
 2536,2615,2536,2771,2731,2731,2731,3029,2731,2,2980,2,2571,
 2427,2291,2199,2199,2427,2571,2571,2571,2199,2291,2199,2,2,2,
 2,2,2,2,2477,2824,2,2477,2477,2,2,2,2823,3,2477,2477,4,4,
 2250,2250,4,4,4,2251,2251,4,2250,2250,2677,2,2,2581,2581,
 2677,2677,3059,2654,2980,2935,2,2,2,3046,2,2,3046,2708,2250,
 2412,2497,2367,2438,2393,2538,2516,2367,2412,2497,2,2,2581,
 2581,2677,2935,3059,2654,2704,2677,3077,3077,3143,3161,2,3046,
 2,2393,2438,2497,2412,2367,2250,2708,2516,2538,2367,2497,2412,
 2,2,2,2823,2,2,2823,2,2,2,2,2823,2,1,1,1,2,2,3,3,3,2,
 2,2,2,3,3,3,2980,2980,3153,3030,3148,3148,3046,3030,3086,
 3086,3165,3148,1,1,1,2,2525,2561,2561,2478,2525,2,2940,2940,
 2478,2561,2561,2653,2,2731,2,2731,2,2731,2,2,2581,2581,2,
 2615,2615,2291,2199,2582,2582,3,2199,2291,2199,2199,3,2582,
 2582,2,2731,2,2731,2,2731,2,2,2581,2581,2,2615,2615,2291,
 2199,2582,2582,3,2199,2291,2199,2199,3,2582,2582,2677,3158,2,
 2654,2677,2,2,2,3046,3,2744,2744,2395,2366,2656,2656,2463,
 2366,2395,2402,2402,2250,2559,2559,2,2536,2677,2536,2789,2789,
 2581,2581,2,2,3030,2483,2350,2350,2483,2350,2350,2483,2350,
 2350,2350,2350,2483,3148,2,2,2,2,3162,2,1,1,1,2940,2525,
 2561,2561,2478,2525,2940,2,2,2478,2561,2561,2677,2536,2677,
 2677,2477,2935,2,2677,2677,2325,2332,2501,2501,2650,2332,2325,
 2325,2325,2650,2501,2501,2,2,2,3046,2,2,3059,2,2497,2367,
 2538,2393,2438,2367,2497,2412,2412,2250,2516,2708,2677,2677,
 2935,2477,2,3030,2,2483,2350,2483,2350,2350,2350,2483,2350,
 2350,2350,2483,2350,2653,2731,2731,2,2,3086,2559,2446,2441,
 2559,2449,2444,2554,2393,2441,2444,2393,2554,2731,2731,2,2,
 3086,2559,2446,2441,2559,2449,2444,2554,2393,2441,2444,2393,
 2554,3029,2,2,3148,2541,2504,2478,2937,2594,2504,2541,2502,
 2502,2611,2592,2944,2823,3162,3165,2944,2642,2502,2541,2504,
 2594,2937,2478,2592,2504,2502,2541,2,2,3,3,2,2,2,3,3,3,3,
 2,2,2,3148,2546,2517,2,2940,2525,2518,2542,2544,2546,2525,2,
 2940,2561,2478,2940,2,2525,2478,2561,2561,2561,2525,2940,2,
 2199,2279,2279,1938,2515,2678,2869,2325,1842,2265,2263,1938,
 1939,5,2,2515,2515,2199,1468,1841,1852,2325,2199,1852,2262,
 2264,2279,2515,2678,2869,2199,1842,2265,2265,2279,2515,2869,
 2678,1472,1852,1852,1938,2,2515,2515,2199,2199,2515,5,1938,
 1939,2325,2869,1938,2279,2279,2678,1938,2279,2279,1841,2265,
 2264,2199,2199,2325,2731,2731,2771,2,2771,2615,2,2731,2536,
 2771,2731,2615,2731,3029,2536,2,2581,2,2581,2,2,2980,3,2582,
 2199,2291,2199,2582,3,2582,2582,2199,2199,2291,2,2,2,2,3,
 2456,2731,2677,3077,2731,2456,3029,2731,2677,2,2,3077,2,3215,
 3215,3212,2430,3,2429,2411,2429,3,2430,2430,2430,2429,2429,
 2411,2581,2,2,2789,2789,2731,2536,2581,2731,2789,2536,2581,
 2731,2,2581,2581,2,3200,3200,3200,2202,2202,2731,2731,2731,
 2202,2202,2202,2202,2731,2731,2731,2,2677,2653,2723,2581,2677,
 2677,2581,3011,2654,3046,2935,2477,2789,2704,2980,2,2,3078,
 2416,2421,2250,2501,2250,2421,2416,2513,2513,2439,2439,2325,2,
 2477,3,2,2477,2,2,2477,2,2823,2477,2,2477,2,2477,2,2,2824,
 4,2250,4,2251,4,2250,4,2250,2250,4,4,2251,2420,3,2581,2935,
 2677,2581,2420,2654,3046,2677,2477,2980,2704,2789,3209,3209,
 3214,3,2678,2363,2400,2363,2616,2468,2616,2678,2363,2363,2400,
 2714,2615,2714,3011,2615,2714,2980,2752,2677,2477,2653,3011,
 2420,1,1,1,2572,2,2250,2404,2250,2,2572,2572,2572,2250,2250,
 2404,2615,2980,2723,2615,2714,2714,3046,2677,2477,3011,2653,
 2420,1,1,1,2,2572,2250,2404,2250,2572,2,2572,2572,2250,2250,
 2404,2731,2,2653,2,2731,2731,2731,2,2771,2771,2771,2,2,2980,
 2582,2582,2199,2291,2199,2582,2582,3,3,2199,2199,2291,2677,
 2731,2714,2536,2477,2536,2,2,2654,2654,2714,2714,2980,2278,
 2408,2408,2278,2408,2408,2278,2408,2408,2408,2408,2278,2,2653,
 2,3161,2677,2,2704,2,2704,2,2,3078,2416,2513,2439,2325,2439,
 2513,2416,2421,2421,2250,2250,2501,2,2731,2731,2731,2,2771,
 2771,2771,2,2,2980,2582,2582,2199,2291,2199,2582,2582,3,3,
 2199,2199,2291,2714,2807,2,3,2723,2723,3,1,1,1,2572,2572,
 2250,2404,2250,2572,2572,2,2,2250,2250,2404,3029,2536,2,2654,
 2,2654,2714,2714,2980,2408,2278,2579,2268,2579,2278,2408,2408,
 2408,2579,2579,2268,2477,2,2,3143,2,3166,3166,2823,2937,2583,
 2554,2478,2554,2583,2937,2733,2733,2567,2567,2567,2,2654,2654,
 2,3148,3148,2823,2537,2537,2325,2332,2325,2537,2537,2737,2737,
 2325,2325,2332,2,2,2,2,2,2824,2250,2250,4,2251,4,2250,2250,
 4,4,4,4,2251,2677,2677,2,2,3078,2513,2421,2439,2325,2439,
 2421,2513,2416,2416,2250,2250,2501,2677,2,2,3078,2421,2513,
 2250,2501,2250,2513,2421,2416,2416,2439,2439,2325,3209,3209,
 3214,2616,2616,2363,2400,2363,2678,2678,3,2468,2363,2363,2400,
 2653,3200,2,2,2,3161,2,2,2,2,2,2,2,3161,3200,2,2,2,3161,
 2,2,2,2,2,2,2,3161,2986,2986,3077,2823,3077,2986,2986,2986,
 2986,3077,3077,2823,2408,2039,2279,2039,2513,2714,2513,2408,
 2039,2039,2279,2039,2279,2039,2714,2513,2513,2408,2039,2039,
 2279,2731,2653,2039,2039,2039,2039,2731,2731,3029,2731,2279,
 2279,2279,2279,3029,3029,3029,2039,2039,2039,2039,2731,2731,
 3029,2408,2408,2513,2039,2039,2279,2408,2513,2039,2039,2279,
 2714,2039,2039,2279,2039,2039,2279,2653,2731,2731,2,2,2771,2,
 2,2,2731,2677,2771,3029,3086,2731,2731,2677,3200,3161,3200,
 3161,2,3086,2,2449,2441,2554,2393,2444,2393,2444,2554,2559,
 2446,2559,2441,2771,2771,2,2615,2,2731,2536,2771,2536,2615,
 2731,2581,2731,2731,3029,2731,2731,2,2980,2,2427,2571,2291,
 2199,2199,2571,2427,2571,2571,2199,2291,2199,2789,2789,2,2,
 2771,2789,2789,2581,3011,2771,2387,2581,2771,2789,2771,3077,3,
 2644,2644,2233,2243,2379,2379,4,2243,2233,2310,2310,4,2379,
 2379,2789,2644,3,2771,2581,2789,2789,2644,2771,3077,2581,2,
 2387,2,2387,2,2,3011,4,2379,2243,2310,2233,2379,4,2379,2379,
 2233,2243,2310,2644,3,2771,2581,2789,2581,2644,2771,2387,2789,
 2771,3077,2771,2789,2,3011,2,4,2379,2310,2243,2233,2379,4,
 2379,2379,2233,2310,2243,2,2980,3148,3011,3030,3148,2980,3162,
 3030,3086,3165,3086,3148,1,1,1,2525,2,2561,2561,2478,2,2525,
 2940,2940,2478,2561,2561,2,2823,2,2,2,2,2823,2,2,2823,2,2,
 1,1,1,2,2,3,3,3,2,2,2,2,3,3,3,2731,2,2731,2,2653,2731,
 2731,2,2581,2,2581,2,2615,2615,2199,2291,2571,2571,2427,2291,
 2199,2199,2199,2427,2571,2571,2789,2536,3148,2731,2477,2536,
 2677,2477,2677,2935,2,2677,2677,2332,2325,2537,2537,2737,2325,
 2332,2325,2325,2737,2537,2537,2789,2,2,2789,2789,2,2387,2,
 2387,3,2644,2644,2233,2310,2379,2379,4,2310,2233,2243,2243,4,
 2379,2379,2,2731,3029,2536,2789,2581,2789,2581,2,2,3030,2350,
 2483,2350,2483,2350,2483,2350,2350,2350,2350,2350,2483,2,3165,
 2,2,3162,2,2,1,1,1,2525,2940,2545,2543,2519,2940,2525,2,2,
 2517,2546,2546,2731,2731,2,2581,2,2581,2,2615,2615,2199,2291,
 2571,2571,2427,2291,2199,2199,2199,2427,2571,2571,2477,3161,
 2823,3161,2823,2,3148,2,2504,2502,2937,2478,2594,2502,2504,
 2541,2541,2642,2944,2592,2677,2935,2677,2477,2,3030,2,2350,
 2483,2483,2350,2350,2483,2350,2350,2350,2350,2483,2350,2731,
 2653,2731,2,2,3086,2446,2559,2393,2554,2444,2554,2444,2393,
 2441,2449,2441,2559,2731,3029,2,2,3148,2504,2541,2592,2944,
 2611,2541,2504,2502,2502,2594,2478,2937,2731,2,2,3086,2446,
 2559,2393,2554,2444,2554,2444,2393,2441,2449,2441,2559,2823,
 3162,3165,2642,2944,2502,2541,2504,2937,2594,2478,2592,2504,
 2502,2541,2,2,3,3,2,2,2,3,3,3,3,2,2,2,3148,2478,2561,2,
 2940,2525,2561,2478,2561,2561,2525,2,2940,2517,2546,2940,2,
 2525,2545,2519,2543,2546,2525,2940,2,2199,1841,1852,1468,2515,
 2,2515,2199,5,1938,1938,2265,2264,1841,2678,2515,2869,2325,
 1938,2279,2279,2325,2199,2279,1938,2279,2264,2515,2678,2869,
 2199,2279,1939,2279,2265,2515,2869,2678,1938,5,1939,1852,2,
 2515,2515,2199,2325,2869,1841,2265,2264,2199,2515,1468,1841,
 1852,2678,1852,2264,2265,1938,2279,2279,2199,2199,2325,2,2477,
 2,3,2477,2,2,2477,2477,2477,2477,2,2,2,2,2823,2,2,2824,2,
 2250,4,2251,4,4,4,2250,2250,2250,4,2251,4,2,2,2,2,2,2,2,
 2823,2823,2,2,2,1,1,1,1,2,2823,2,3,3,2477,3,3,3,3,2477,
 2477,3,2477,3,2,2,2,3077,3046,3161,3161,3179,3143,3077,3046,
 1,1,1,1,3228,3232,3224,2783,2477,2681,2562,2585,2653,2653,
 3149,3089,2585,2681,2562,2,2,2,2,2,2823,2823,2,2,2,1,1,1,
 1,2,2823,2,3,3,2477,3,3,3,3,2477,2477,3,2477,3,2,2,2,
 2823,2,2,2823,2,2,2,2,2823,2,1,1,1,2,3,3,3,3,3,2,2,2,
 3,3,3,3086,3078,3182,3148,3166,3166,3086,3059,3230,3209,3238,
 3179,1,1,1,2,2632,2668,2536,2601,2581,2,3048,3042,2626,2687,
 2622,2,2,2731,2,2731,2653,2,2,2,3077,2,2,3086,2,2559,2441,
 2554,2393,2444,2393,2554,2444,2449,2449,2559,2441,2,2581,2,
 2581,2,2771,2654,2477,2980,2704,2653,3011,2723,2325,2439,2513,
 2416,2421,2250,2501,2250,2439,2421,2513,2416,3161,3197,2,2,2,
 1,1,1,1,2,3209,2,2672,2607,3146,2707,2786,2536,1462,2691,
 2701,2477,3048,2477,2,3029,2731,2581,2789,2387,3077,2387,3165,
 2823,3162,2944,2592,2504,2502,2541,2478,2937,2594,2611,2541,
 2504,2502,3166,2,2,2,2,3212,2,1,1,1,3042,2632,2669,2536,
 2600,2581,3048,2,2,2628,2685,2627,2731,2581,3161,3046,2823,
 3046,2797,3046,2752,2567,2567,2919,2520,2641,2478,2554,2554,
 2567,2641,2919,2520,2,2,2,3077,2,2,3086,2,2559,2441,2554,
 2393,2444,2393,2554,2444,2449,2449,2559,2441,2789,2704,2980,
 2477,2,3046,2,2516,2708,2497,2367,2412,2393,2538,2438,2250,
 2412,2497,2367,2,3200,2,3200,3239,3239,3172,2813,2753,2753,
 2758,2,3202,2,2813,2758,2753,2753,3077,2771,3197,2823,3182,
 3146,2785,2607,2672,2703,2477,3048,2477,2707,2691,2536,1462,
 3077,3238,2823,3212,3094,2996,2825,2982,3080,2825,3080,2982,
 2996,3094,2996,2996,3232,3224,3228,3089,2783,2562,2585,2681,
 2653,3149,2653,2477,2681,2562,2585,3215,2,2,2,3214,2671,2,
 2654,2696,2696,2,2,3158,2,3209,3051,3015,2823,2959,2991,2825,
 2997,2997,3049,2991,2823,2959,2,2,3150,2,2,2654,2697,2697,2,
 2,3150,2,2439,2498,2318,2349,2581,2731,2955,2567,2343,2495,
 2313,2302,2167,2241,3,2606,2606,2439,2227,2306,2176,2363,2429,
 2252,2498,2498,2498,2946,3047,2940,4,2062,2340,2340,2318,2754,
 2940,2745,2062,2346,2346,2349,2758,2946,2754,2250,2250,2581,
 2062,2252,2062,2554,2955,2346,2498,2340,2731,2346,2498,2340,
 2344,2492,2315,2429,4,2363,2677,2,2728,2723,2581,2677,2677,
 2935,3011,2654,2704,2581,3077,3161,3143,3077,2,3078,2,2406,
 2414,2501,2250,2250,2414,2406,2505,2505,2439,2325,2439,2,2420,
 3,2581,2935,2677,2677,2420,2654,2980,2581,2,3046,2,2,3209,
 3214,3209,2459,2605,2400,2363,2363,2665,2393,2665,2605,2363,
 2400,2363,2477,3,2,2477,2,2477,2477,2,2477,2,2,2823,2,2,2,
 2824,2,4,2250,2251,4,4,2250,4,2250,2250,4,2251,4,2714,2615,
 2714,3011,2677,2714,2980,2723,2615,2456,2797,3046,2456,1,1,1,
 2567,2,2403,2377,2377,2,2567,2567,2567,2377,2403,2377,2615,
 2980,2723,2677,2714,2714,3011,2615,2456,3046,2797,2456,1,1,1,
 2,2567,2403,2377,2377,2567,2,2567,2567,2377,2403,2377,2731,2,
 2731,2,2731,2,2653,2,2581,2581,2,2,2980,2,2571,2571,2291,
 2199,2199,2571,2571,2427,2427,2199,2291,2199,2677,2536,2714,
 2536,2,2731,2677,2477,2935,2677,2714,2980,2714,2268,2579,2278,
 2408,2408,2579,2268,2579,2579,2408,2278,2408,2677,2728,2,2789,
 2,2,3046,2,2,2,3078,2,2406,2505,2325,2439,2439,2505,2406,
 2414,2414,2250,2501,2250,2,2536,2677,2731,2789,2581,2581,2789,
 3148,2823,3148,2501,2501,2332,2325,2325,2501,2501,2650,2650,
 2325,2332,2325,2714,2728,2,3,2752,2752,3,1,1,1,2567,2567,
 2403,2377,2377,2567,2567,2,2,2377,2403,2377,2677,2731,2677,
 2935,2477,2677,2714,2980,2714,2579,2268,2268,2579,2579,2268,
 2579,2579,2579,2579,2268,2579,2,2,2,3046,2,2,3078,2,2505,
 2406,2501,2250,2250,2406,2505,2414,2414,2439,2325,2439,2,2581,
 2581,2,2,2980,2,2571,2571,2291,2199,2199,2571,2571,2427,2427,
 2199,2291,2199,2731,2731,2653,3215,3212,3215,2706,2706,2411,
 2429,2429,2683,2683,2393,2476,2429,2411,2429,3029,2731,3166,
 2823,3166,2919,2641,2567,2567,2567,2641,2919,2520,2520,2554,
 2478,2554,2731,3166,2823,3166,2641,2919,2478,2554,2554,2919,
 2641,2520,2520,2567,2567,2567,3215,3212,3215,2706,2706,2411,
 2429,2429,2683,2683,2393,2476,2429,2411,2429,3200,2653,2655,
 2655,3161,2,2,2655,2655,2655,2655,2,3161,2,3200,2929,2929,
 2823,3077,3077,2929,2929,2929,2929,3077,2823,3077,2655,2655,
 3161,2,2,2655,2655,2655,2655,2,3161,2,2579,2265,1997,1997,
 2513,2812,2513,2579,1997,2265,1997,2265,1997,1997,2812,2513,
 2513,2579,1997,2265,1997,2731,2731,2265,2265,2265,2265,3029,
 3029,3029,2653,1997,1997,1997,1997,2731,3029,2731,1997,1997,
 1997,1997,2731,3029,2731,2579,2579,2513,1997,2265,1997,2579,
 2513,1997,2265,1997,2812,1997,2265,1997,1997,2265,1997,2731,
 2653,2731,2731,2,2,2677,2731,2731,2731,3086,2677,3077,3029,2,
 2,2,3077,2,2,3086,2441,2449,2444,2554,2393,2444,2393,2554,
 2559,2441,2449,2559,2,2,2677,2731,2731,3029,3086,2677,2771,
 2731,3161,3200,3161,3200,2,3086,2,2393,2444,2554,2444,2393,
 2449,2441,2559,2554,2441,2559,2449,2,3158,3215,3215,3165,3215,
 3214,3228,3165,3197,1,3232,3269,1,1,1,2671,2,2696,2694,2654,
 2,2,3158,3214,2,2,2,3153,3212,3212,3162,3209,3209,3224,3162,
 3182,1,3228,3212,1,1,1,2,2,2697,2692,2654,2,2,3150,3150,2,
 2,2,2,2,2581,2823,2771,2,2581,2477,2654,2704,2980,3,2744,
 2744,2395,2402,2559,2559,2250,2402,2395,2366,2366,2463,2656,
 2656,2653,2731,3215,2,2,2731,2,2,2,3077,3,2456,2456,2411,
 2429,2430,2430,3,2429,2411,2429,2429,3,2430,2430,2731,3215,2,
 2,2731,2,2,2,3077,3,2456,2456,2411,2429,2430,2430,3,2429,
 2411,2429,2429,3,2430,2430,2823,2581,3161,3029,2387,2789,2387,
 3077,2,2,3148,2502,2541,2594,2937,2478,2541,2502,2504,2504,
 2592,2611,2944,3209,3232,2823,2823,1,3224,2823,1,1,1,2959,
 2991,2997,2994,2825,2991,2959,2823,2823,3012,3052,3051,2,2581,
 2704,2789,2477,2980,3,2420,2420,2363,2400,2665,2665,2393,2400,
 2363,2363,2363,2459,2605,2605,2,1,1,1,1,2,3179,2,2562,2585,
 3149,2653,2653,2585,2562,2681,2681,2477,3089,2783,3046,3161,
 3046,2823,2,3148,2,2502,2541,2937,2594,2478,2541,2502,2504,
 2504,2592,2944,2611,2,2771,3077,2,2,3209,2672,2703,2477,3048,
 2477,2691,1462,2536,2607,2786,2707,3146,2,3200,2,2,3247,2699,
 2739,2798,3163,2653,2739,2699,2699,2699,2798,2653,3163,3077,2,
 2,3179,2585,2681,2653,3149,2653,2681,2585,2562,2562,2783,2477,
 3089,2823,3212,3238,2996,3096,2982,3080,2825,3080,2982,2825,
 2996,2996,2996,3096,2,2,3,3,2,2,3,3,3,3,3,3,2,2,3166,
 2536,2601,2,3048,2581,2625,2627,2687,2667,2632,2,3042,2621,
 2630,3048,2,2581,2598,2536,2669,2686,2632,3042,2,4,2340,2327,
 2062,2741,2745,2940,2363,2176,2314,2318,2346,2335,2062,2758,
 2741,2946,2429,2227,2344,2349,2554,2250,2346,2340,2498,2498,
 2606,2731,2955,2250,2338,2329,2495,2493,2606,2955,2731,2062,
 2062,2252,2252,3,2581,2581,4,2429,2946,2241,2349,2341,2363,
 2940,2166,2318,2315,3047,2302,2498,2495,2306,2492,2498,2439,
 2439,2567,2456,3,2677,3029,2731,2731,2456,2677,3077,2731,2,
 3077,2,2,3212,3215,3215,3,2430,2429,2429,2411,2430,3,2430,
 2430,2411,2429,2429,2,3059,3166,3086,3086,3166,3078,3212,3148,
 2823,3191,2823,3179,1,1,1,2632,2,2625,2687,2627,2,2581,3048,
 3042,2536,2601,2667,2,2823,2,2,2,2,2823,2,2,2823,2,2,1,1,
 1,3,2,3,3,3,2,3,2,2,3,3,3,2581,2,2,2,2771,3077,2581,2,
 2704,2,2704,2,2,3046,2708,2516,2412,2497,2367,2538,2393,2438,
 2250,2367,2412,2497,2731,2731,3166,2581,2823,3029,2,2,2,3143,
 2752,2807,3046,2567,2567,2733,2937,2583,2554,2478,2554,2567,
 2583,2733,2937,2653,2,2,3200,2731,2,2771,2,2771,2,2,3086,
 2441,2559,2449,2559,2441,2554,2393,2444,2449,2393,2444,2554,2,
 2,3200,2731,2,2771,2,2771,2,2,3086,2441,2559,2449,2559,2441,
 2554,2393,2444,2449,2393,2444,2554,2,3238,2,2,3182,2,2,1,1,
 1,2632,3042,2598,2669,2536,3048,2581,2,2,2621,2630,2686,3077,
 2581,2,2704,2,2704,2723,2728,3011,2439,2325,2414,2505,2406,
 2501,2250,2250,2439,2406,2414,2505,2823,1,1,1,1,3212,3269,
 2823,2996,2996,3080,2825,2982,2982,2825,3080,3096,2996,3096,
 2996,2,3143,2,2,3162,3165,2823,2592,2944,2541,2504,2502,2937,
 2478,2594,2611,2502,2541,2504,2,2,2,2,2,2823,3,2477,3,2477,
 3,2477,3,3,3,3,3,2477,2,3161,2,2,3209,2607,2701,2786,3146,
 2707,2691,2536,1462,2672,2477,2477,3048,2,2,2,2823,3,2477,3,
 2477,3,2477,3,3,3,3,3,2477,3224,3228,3232,2477,3089,2585,
 2681,2562,3149,2653,2653,2783,2562,2585,2681,2,3209,2,2,2,
 3150,2,2697,2654,2692,2,2,2,3150,3215,2,2,2,3158,2,2696,
 2654,2694,2,2671,2,3214,3012,3052,2991,2823,2959,2997,2825,
 2994,3051,2959,2991,2823,2439,2241,2302,2166,2606,3,2606,2439,
 2176,2227,2306,2349,2498,2318,2731,2581,2955,2567,2314,2344,
 2492,2429,4,2346,2062,2338,2341,2741,2758,2946,2363,2498,2252,
 2495,2495,2940,2946,3047,2340,2062,2329,2315,2745,2741,2940,
 2250,2554,2955,2340,2346,2498,2250,2581,2062,2062,2252,2731,
 2327,2335,2493,2318,2349,2498,4,2363,2429,2,3059,3166,3086,
 3148,3166,3078,3182,3086,3179,3269,3209,3247,1,1,1,2581,2,
 2668,2601,2536,2,2632,3042,3048,2627,2686,2630,2,2823,2,2,2,
 2,2823,2,2,2823,2,2,1,1,1,3,2,3,3,3,2,3,2,2,3,3,3,
 2581,2,2581,2,2771,2,2,2477,2980,2704,2654,2,3046,2,2393,
 2538,2497,2412,2367,2516,2708,2250,2438,2367,2497,2412,2731,
 3029,3166,2581,2,2731,3046,2823,3046,3161,2752,3046,2807,2478,
 2554,2937,2733,2583,2567,2567,2567,2554,2583,2937,2733,2731,2,
 2,2,2653,2,3077,2,2,2,3086,2,2393,2554,2559,2449,2441,2559,
 2441,2449,2444,2393,2554,2444,2,2581,3161,2731,2387,3077,2387,
 2789,3162,2823,3165,2478,2937,2504,2541,2502,2944,2592,2611,
 2594,2502,2504,2541,2,3197,2,2,3212,2,2,1,1,1,2581,3048,
 2686,2629,2627,3042,2632,2,2,2536,2668,2604,2,2,2704,2980,
 2477,2789,2723,3011,2728,2250,2501,2505,2414,2406,2325,2439,
 2439,2250,2406,2505,2414,2,1,1,1,1,2,3209,2,2536,1462,3048,
 2477,2477,2672,2607,2701,2691,2707,3146,2786,2,3077,2,2,2,
 3086,2,2393,2554,2559,2449,2441,2559,2441,2449,2444,2393,2554,
 2444,3077,2771,2,3228,3224,3232,2653,3152,2562,2681,2585,3087,
 2781,2477,2779,2585,2562,2681,3077,3200,3212,2823,3238,2825,
 3080,2996,3096,2996,3096,2996,2996,2982,2982,2825,3080,2,3182,
 2823,3197,2477,3048,2536,2691,1462,3146,2786,2707,2477,2672,
 2607,2701,1,1,1,2653,3163,2699,2739,2699,3163,2798,2653,2814,
 2699,2699,2739,3209,2,2654,2697,3150,2,2,2,2,2,2693,2,3150,
 2,3215,2825,2997,2823,2991,2959,3052,3012,3051,2992,2959,2823,
 2991,2654,2696,3158,2,2,2,2,2,2695,2671,3214,2,2250,2252,
 2062,2062,2581,3,2581,2250,2062,2252,2062,2498,2346,2340,2731,
 2606,2955,2554,2340,2498,2346,2429,2363,2498,2302,2495,2495,
 2940,3047,2946,4,2349,2241,2342,2337,2741,2946,2758,2318,2167,
 2313,2329,2745,2940,2741,2439,2567,2955,2315,2492,2345,2439,
 2606,2176,2306,2222,2731,2318,2498,2349,2328,2492,2336,2363,4,
 2429,3148,3200,3209,3148,3200,3200,3209,3148,3166,3215,3215,
 3166,1,1,1,2,2,2,2,2,2,2,3161,3161,2,2,2,2,2824,2615,2,
 2980,2,2615,2477,2,3046,2744,1,1,1,2940,2,2561,2561,2478,2,
 2940,2525,2525,2478,2561,2561,3215,2,2653,3200,2,2,2,2,3209,
 2,1,1,1,3161,2,2,2,2,2,3161,2,2,2,2,2,3086,3215,2824,1,
 3086,2823,3232,2823,3209,1,1,1,2959,2823,3052,3051,3012,2823,
 2959,2991,2991,2825,2997,2992,2,2980,2,2615,2644,2,3011,2644,
 1,1,1,2940,2,2517,2546,2546,2,2940,2525,2525,2544,2518,2542,
 3200,2,2,2,2,3209,2,1,1,1,3161,2,2,2,2,2,3161,2,2,2,2,
 2,3212,2980,3078,3214,2824,3078,1,1,1,3077,2823,2929,2929,
 2929,2823,3077,3077,3077,2929,2929,2929,2,2,2,3224,2,1,1,1,
 3150,2,2693,2654,2697,2,3150,2,2,2,2,2,2744,2,3046,2477,1,
 1,1,2940,2,2561,2478,2561,2,2940,2525,2525,2561,2561,2478,2,
 3086,2456,1,1,1,3042,2,2622,2687,2628,2,3048,2581,2632,2600,
 2536,2667,3215,2,1,1,1,3158,2,2,2,2,2,3214,2671,2,2696,
 2654,2696,3086,1,1,1,2991,2823,2825,2997,2997,2823,2991,2959,
 2959,3051,3015,3049,1,1,1,3042,2,2627,2624,2686,2,3048,2581,
 2632,2669,2536,2604,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2662,
 2662,2662,2,2771,3143,3077,2511,2507,2511,3,3,3,2,2,2,2,3,
 3,3,2250,2250,3,2508,2507,2662,1,1,1,2377,3,2511,2511,2662,
 1,1,1,3,2511,2511,2662,1,1,1,2,2,2,3,3,3,3077,3143,2662,
 2662,2662,2771,2662,2662,2662,2511,2508,2511,2250,2377,2250,
 2980,2,2615,2,2,3086,2615,2477,3046,2,2744,1,1,1,2,2940,
 2545,2542,2519,2940,2,2525,2525,2517,2546,2546,3212,2980,3200,
 3200,2824,2980,3078,2824,3214,3078,1,1,1,2823,3077,2986,2986,
 2986,3077,2823,3077,3077,2986,2986,2986,2,2,2,1,2,2,3224,2,
 2,1,1,1,2,3150,2,2,2,3150,2,2,2,2654,2697,2693,2,2,3086,
 2615,2644,3011,2,2644,1,1,1,2,2940,2478,2561,2561,2940,2,
 2525,2525,2561,2478,2561,2653,3215,2,2,3209,2,2,1,1,1,2,
 3161,2655,2655,2655,3161,2,2,2,2655,2655,2655,3215,2,2,3209,
 2,2,1,1,1,2,3161,2655,2655,2655,3161,2,2,2,2655,2655,2655,
 2824,3209,2823,3232,2823,1,1,1,2823,2959,2993,2825,2997,2959,
 2823,2991,2991,3052,3050,3015,2744,3046,2,2477,1,1,1,2,2940,
 2546,2517,2546,2940,2,2525,2525,2543,2545,2519,3086,2,2456,1,
 1,1,2,3042,2536,2667,2599,3048,2,2581,2632,2630,2622,2687,
 3215,3086,1,1,1,2823,2991,3015,3049,3051,2991,2823,2959,2959,
 2997,2825,2997,2,1,1,1,2,3158,2654,2696,2696,3214,2,2671,2,
 2,2,2,1,1,1,2,3042,2536,2602,2669,3048,2,2581,2632,2686,
 2627,2623,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,2,2,2,
 2,3,3,3,2508,2511,2511,2771,2,3143,3077,2662,2662,2662,2250,
 2250,2662,3,2662,2511,1,1,1,2377,2662,3,2662,2508,1,1,1,
 2662,3,2662,2507,1,1,1,2,3077,3143,2508,2511,2506,2,2,3,3,
 3,2771,2511,2508,2511,2662,2662,2663,2250,2377,2250,2,2731,2,
 2731,2,2731,2,2,2581,2581,2,2615,2615,2291,2199,2582,2582,3,
 2199,2291,2199,2199,3,2582,2582,2,2,2,2,2,2,2477,2,2477,3,
 2477,2477,4,2251,2250,2250,4,2251,4,4,4,4,2250,2250,2,2731,
 2731,2731,2,2771,2771,2771,2,2,2980,2582,2582,2199,2291,2199,
 2582,2582,3,3,2199,2199,2291,2,2,2,3,2,2,3,1,1,1,2,2,3,
 3,3,2,2,2,2,3,3,3,2731,2731,2,2581,2,2581,2,2615,2615,
 2199,2291,2571,2571,2427,2291,2199,2199,2199,2427,2571,2571,2,
 2,2,3077,2,2,3086,2,2559,2441,2554,2393,2444,2393,2554,2444,
 2449,2449,2559,2441,2,2581,2581,2,2,2980,2,2571,2571,2291,
 2199,2199,2571,2571,2427,2427,2199,2291,2199,2,2,2,2,2,2824,
 2250,2250,4,2251,4,2250,2250,4,4,4,4,2251,2677,2677,2,2,
 3059,2497,2412,2708,2516,2250,2412,2497,2367,2367,2438,2393,
 2538,2677,2,2,3059,2412,2497,2393,2538,2438,2497,2412,2367,
 2367,2250,2708,2516,2823,3153,3158,2656,2656,2395,2402,2366,
 2559,2559,2250,2473,2366,2395,2402,2,2,3,3,2,2,2,3,3,3,3,
 2,2,2,3148,2561,2561,2,2940,2525,2561,2561,2478,2478,2525,2,
 2940,2542,2545,2940,2,2525,2546,2546,2517,2519,2525,2940,2,
 2325,2265,2262,1842,2869,2678,2515,2199,1938,2279,2279,2262,
 2265,1852,2678,2869,2515,2199,1938,2279,2279,2325,2199,2279,
 2279,1938,1852,2515,2678,2869,2199,2279,2279,1938,1842,2515,
 2869,2678,1938,1939,5,1472,2,2515,2515,2325,2199,2515,1852,
 2262,2265,2199,2515,1842,2265,2262,2,1472,1852,1842,5,1938,
 1939,2199,2199,2325,2731,3215,2,2,2731,2,2,2,3077,3,2456,
 2456,2411,2429,2430,2430,3,2429,2411,2429,2429,3,2430,2430,2,
 2731,2,2731,2771,2,2771,2771,2615,2,2615,2291,2199,3,2582,
 2582,2199,2291,2199,2199,2582,3,2582,3200,2,2,2,2,3209,2,1,
 1,1,3161,2,2,2,2,2,3161,2,2,2,2,2,2,2731,2581,2,2,2581,
 2789,2789,2789,2731,2731,2202,2202,2202,2731,2731,2731,2731,
 2202,2202,2202,2,2477,2,2477,2,2477,2477,3,2251,4,2250,4,
 2250,4,2251,4,4,2250,2250,4,2581,2,2581,2,2615,2615,2,2291,
 2199,2582,3,2582,2199,2291,2199,2199,2582,2582,3,2,2677,2677,
 2653,2723,3011,2325,2439,2416,2513,2421,2250,2501,2250,2439,
 2421,2416,2513,2,2,2477,3,2477,2251,4,4,2250,2250,4,2251,4,
 4,2250,4,2250,2677,2420,3,2420,2400,2363,3,2678,2678,2363,
 2400,2363,2363,2616,2468,2616,3011,2723,2653,2325,2439,2416,
 2421,2513,2250,2501,2250,2439,2513,2416,2421,2714,2714,2404,
 2250,2572,2572,2,2250,2404,2250,2250,2,2572,2572,2714,2404,
 2250,2,2572,2572,2250,2404,2250,2250,2572,2,2572,2404,2250,
 2572,2,2572,2250,2404,2250,2250,2572,2572,2,2731,2279,2279,
 2279,3029,3029,3029,2731,2279,2279,2279,2039,2039,2039,2731,
 3029,2731,2653,2039,2039,2039,2408,2408,2039,2279,2039,2039,
 2513,2714,2513,2408,2039,2279,2039,2039,2513,2513,2714,2039,
 2279,2039,2039,2714,2513,2513,2731,2653,2731,2039,2039,2039,
 2731,3029,2279,2279,2279,2731,2039,2039,2039,2039,2039,2039,
 2408,2408,2408,2,2,3200,2731,2,2771,2,2771,2,2,3086,2441,
 2559,2449,2559,2441,2554,2393,2444,2449,2393,2444,2554,2,1,2,
 2,3228,2,2,1,1,1,2671,3214,2,2,2,3158,2,2,2,2654,2696,
 2695,2,2,2,2477,2,2477,3,2477,2477,4,2251,2250,2250,4,2251,
 4,4,4,4,2250,2250,2,1,1,1,1,2,3247,2,2699,2699,3163,2653,
 2798,2699,2699,2739,2739,2653,3163,2814,2,3077,2,2,2,3086,2,
 2393,2554,2559,2449,2441,2559,2441,2449,2444,2393,2554,2444,2,
 2,2,2,2,2823,3,2477,3,2477,3,2477,3,3,3,3,3,2477,2,3161,
 2,2,3179,2562,2681,2783,3089,2477,2681,2562,2585,2585,2653,
 2653,3149,2,2,2,2823,3,2477,3,2477,3,2477,3,3,3,3,3,2477,
 2823,3182,3197,2707,3146,2672,2701,2607,3048,2477,2477,2786,
 2536,1462,2691,2,2,3,3,2,2,3,3,3,3,3,3,2,2,3166,2627,
 2686,2,3042,2632,2668,2536,2601,2630,2581,2,3048,2536,2668,
 3042,2,2632,2686,2627,2629,2604,2581,3048,2,2363,2315,2318,
 2176,2940,2745,2741,4,2062,2340,2328,2492,2498,2306,3047,2940,
 2946,2429,2252,2498,2492,2567,2439,2498,2318,2349,2345,2581,
 2731,2955,2439,2495,2313,2342,2349,2581,2955,2731,2302,2167,
 2241,2222,3,2606,2606,2363,2429,2946,2252,2498,2495,4,2741,
 2062,2340,2329,2758,2062,2346,2337,2062,2346,2336,2250,2250,
 2554,2,2,2,3,2,2,3,1,1,1,2,2,3,3,3,2,2,2,2,3,3,3,
 2731,2731,2771,2771,2,2771,2615,2,2615,2199,2291,2427,2571,
 2571,2291,2199,2199,2199,2571,2427,2571,2,2771,2,2771,2,3086,
 2,2,2554,2393,2444,2393,2554,2441,2559,2449,2444,2559,2449,
 2441,2771,2771,2771,2,2980,2,2,2582,2582,2199,2199,2291,2582,
 2582,3,3,2291,2199,2199,2789,2789,2789,2,2,3011,2379,2379,
 2233,2310,2243,2379,2379,4,4,2243,2233,2310,2789,2789,2644,3,
 2644,2310,2243,4,2379,2379,2243,2310,2233,2233,2379,4,2379,
 2789,2644,3,2644,2243,2310,4,2379,2379,2310,2243,2233,2233,
 2379,4,2379,3011,2,2,2379,2379,2233,2243,2310,2379,2379,4,4,
 2310,2233,2243,2,3148,2561,2561,2525,2940,2,2561,2561,2478,
 2478,2,2525,2940,2,3,3,2,2,2,3,3,3,3,2,2,2,2561,2561,
 2525,2,2940,2561,2561,2478,2478,2940,2525,2,2325,1939,2279,
 2279,2869,2678,2515,2199,2265,1842,2265,1938,2279,2279,2678,
 2869,2515,2199,2264,1852,2262,2199,2199,1841,1852,1468,5,2515,
 2,2515,2325,2265,2263,1842,1938,2869,2515,2678,2265,2264,1841,
 1938,2678,2515,2869,2325,2199,2515,2279,1938,2279,2199,2515,
 2279,1939,2279,2,1938,5,1938,1852,1472,1852,2199,2325,2199,
 3215,2,2,3209,2,2,1,1,1,2,3161,2655,2655,2655,3161,2,2,2,
 2655,2655,2655,2,2,2,3228,2,1,1,1,3158,2,2698,2654,2696,
 2671,3214,2,2,2,2,2,3,2,2,3,1,1,1,2,2,3,3,3,2,2,2,2,
 3,3,3,2,2,3,1,1,1,2,2,3,3,3,2,2,3,3,3,3,3,3212,2,1,
 1,1,3150,2,2,2,2,2,3150,2,2,2697,2654,2697,2,1,1,1,2,
 3150,2654,2697,2697,3150,2,2,2,2,2,2,1,1,1,2,2,3,3,3,2,
 2,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3077,2508,
 2511,2511,3143,2771,2,2,2662,2662,2662,2511,2508,2506,2771,
 3143,2,2,2662,2662,2662,2250,2250,2662,2662,3,3,1,1,1,2377,
 2662,2662,3,3,1,1,1,2662,2663,3,3,1,1,1,3077,2,2,2511,
 2508,2511,2,2,2508,2511,2507,2,3,3,3,3,3,3,2250,2377,2250,
 2,3077,2,2,2,2456,2456,3,2429,2411,2683,2393,2683,2411,2429,
 2429,2429,2706,2706,2476,2581,2581,2,2,2615,2615,2,2199,2291,
 2571,2427,2571,2291,2199,2199,2199,2571,2571,2427,2677,2,2677,
 2728,2723,3011,2439,2325,2406,2505,2414,2501,2250,2250,2439,
 2414,2406,2505,2,2677,2420,3,2420,2363,2400,2459,2605,2605,
 2400,2363,2363,2363,2665,2393,2665,2,2477,3,2477,4,2251,4,
 2250,2250,2251,4,4,4,2250,4,2250,3011,2723,2728,2439,2325,
 2406,2414,2505,2501,2250,2250,2439,2505,2406,2414,2714,2714,
 2377,2403,2567,2567,2,2403,2377,2377,2377,2,2567,2567,2714,
 2377,2403,2,2567,2567,2403,2377,2377,2377,2567,2,2567,2377,
 2403,2567,2,2567,2403,2377,2377,2377,2567,2567,2,2731,1997,
 1997,1997,3029,2731,2731,2653,1997,1997,1997,2265,2265,2265,
 3029,3029,3029,2731,2265,2265,2265,2579,2579,2265,1997,1997,
 1997,2513,2812,2513,2579,2265,1997,1997,1997,2513,2513,2812,
 2265,1997,1997,1997,2812,2513,2513,2731,2731,3029,2265,2265,
 2265,2653,2731,1997,1997,1997,2731,1997,1997,1997,1997,1997,
 1997,2579,2579,2579,2477,2,2477,2,2477,2477,3,2251,4,2250,4,
 2250,4,2251,4,4,2250,2250,4,2,3161,2,3191,3182,2823,3146,
 2707,1462,2536,2691,2477,3048,2477,2786,2703,2672,2607,2,2,
 2823,2,2,2477,3,3,3,2477,3,2477,3,3,2477,3,3,2,3179,2,2,
 2681,2562,2653,2653,3149,2562,2681,2585,2585,3089,2783,2477,
 2823,2,2,2477,3,3,3,2477,3,2477,3,3,2477,3,3,3166,2,2686,
 2627,3048,2581,2,2536,2669,2602,2623,2,3042,2632,2,2669,2536,
 2,2581,3048,2627,2686,2624,2604,3042,2,2632,3,3,2,3,2,3,3,
 3,3,2,2,3,2363,2494,2252,2498,2940,3047,2946,2429,2495,2498,
 2303,2327,2062,2340,2745,2940,2741,4,2314,2318,2167,2250,2554,
 2329,2495,2338,2335,2955,2731,2606,2250,2062,2252,2062,2062,
 2581,2581,3,2340,2498,2346,2346,2731,2955,2606,2363,4,2741,
 2318,2315,2177,2429,2946,2498,2494,2306,2758,2349,2341,2223,
 2344,2349,2211,2567,2439,2439,2677,2677,2,3158,3153,2823,2656,
 2656,2395,2366,2402,2559,2559,2250,2463,2402,2395,2366,2677,2,
 3059,2,2,2497,2412,2708,2250,2516,2412,2497,2367,2367,2538,
 2393,2438,2,3059,2,2,2412,2497,2393,2438,2538,2497,2412,2367,
 2367,2516,2708,2250,2824,2,2,2250,2250,4,4,2251,2250,2250,4,
 4,2251,4,4,3148,2,2543,2545,2940,2525,2,2546,2546,2517,2519,
 2,2940,2525,2,2561,2561,2,2525,2940,2561,2561,2478,2478,2940,
 2,2525,3,3,2,2,2,3,3,3,3,2,2,2,2325,2264,1852,2265,2869,
 2678,2515,2199,2279,2279,1939,2265,1841,2264,2678,2869,2515,
 2199,2279,2279,1938,2199,2325,2279,2279,1938,1841,2869,2678,
 2515,2199,1938,1938,5,1468,2515,2515,2,2279,2279,1938,1852,
 2678,2869,2515,2325,2199,2515,2264,2265,1841,2199,2515,2265,
 2264,1852,2,1852,1841,1468,1939,1938,5,2325,2199,2199,2731,
 2731,2,2,3086,2559,2446,2441,2559,2449,2444,2554,2393,2441,
 2444,2393,2554,2731,2,2,3086,2446,2559,2393,2554,2444,2554,
 2444,2393,2441,2449,2441,2559,3215,3212,3215,2706,2706,2411,
 2429,2429,2683,2683,2393,2476,2429,2411,2429,2,3215,2,2,2671,
 3214,2,2696,2694,2654,2,2,2,3158,3209,2,2,2,3150,2,2697,
 2692,2654,2,2,2,3150,3049,3052,2959,2823,2991,2997,2995,2825,
 3013,2991,2959,2823,2567,2315,2492,2343,2955,2794,2581,2439,
 2349,2318,2498,2318,2498,2349,2794,2955,2581,2439,2342,2315,
 2492,2363,4,2340,2327,2062,2165,2741,2745,2940,2429,2498,2494,
 2252,2304,2946,2940,3047,2346,2335,2062,2241,2758,2741,2946,
 2554,2250,2606,2346,2340,2498,2250,2606,2338,2329,2495,3,2062,
 2062,2252,2226,2176,2306,4,2429,2363,2731,2456,3,2456,2429,
 2429,3,2430,2430,2429,2429,2411,2411,2430,3,2430,3086,2,2,
 2559,2449,2441,2449,2559,2444,2554,2393,2441,2554,2393,2444,2,
 3166,2669,2598,2632,3042,2,2625,2687,2627,2536,2,2581,3048,2,
 3,3,3,2,2,3,3,3,3,2,3,2,2667,2602,2632,2,3042,2630,2685,
 2622,2536,3048,2581,2,2429,2306,2492,2495,2946,3047,2940,2363,
 2498,2252,2498,2222,2345,2341,2758,2946,2754,4,2346,2062,2346,
 2439,2439,2241,2302,2166,2176,2606,3,2606,2567,2349,2498,2318,
 2314,2955,2581,2731,2349,2498,2318,2315,2731,2581,2955,2429,4,
 2754,2346,2062,2346,2363,2940,2498,2252,2498,2745,2340,2062,
 2340,2340,2062,2340,2250,2554,2250,3086,2,2,2449,2559,2393,
 2444,2554,2554,2444,2393,2441,2559,2441,2449,2,3166,2626,2687,
 2581,3048,2,2668,2601,2536,2622,2,2632,3042,2,3,3,3,2,2,3,
 3,3,3,2,3,2,2628,2685,2581,2,3048,2669,2600,2536,2627,3042,
 2632,2,2429,2062,2346,2346,2946,2758,2754,4,2343,2227,2344,
 2252,2498,2498,3047,2946,2940,2363,2495,2306,2492,2250,2250,
 2252,2062,2062,2062,2581,3,2581,2554,2498,2346,2340,2340,2955,
 2606,2731,2498,2346,2340,2340,2731,2606,2955,2429,2363,2940,
 2498,2302,2498,4,2754,2349,2241,2349,2745,2318,2167,2318,2313,
 2176,2315,2439,2567,2439,3209,3215,3052,3050,2959,2991,2823,
 2993,2997,2825,3015,2823,2959,2991,2,2,2,2,2,3150,2693,2697,
 2654,2,3150,2,2,2,2,2671,2,3214,2698,2696,2654,2,3158,2,2,
 2567,2318,2349,2498,2955,2731,2581,2439,2495,2314,2344,2315,
 2341,2494,2731,2955,2581,2439,2498,2318,2349,4,2363,2329,2340,
 2062,2177,2940,2745,2741,2429,2338,2346,2062,2223,2946,2741,
 2758,2495,2498,2252,2306,3047,2940,2946,2554,2250,2606,2494,
 2327,2335,2250,2606,2498,2340,2346,3,2252,2062,2062,2303,2167,
 2211,2363,2429,4,3200,2,2,2,3161,2,2,2,2,2,2,2,3161,2655,
 2655,3161,2,2,2655,2655,2655,2655,2,3161,2,2250,2508,2511,3,
 1,1,1,2377,3,2662,2662,2511,2508,3,1,1,1,2250,3,2662,2662,
 3077,2,2662,2662,2662,2506,2,2771,3143,2,2662,2662,2662,2511,
 2,3143,2771,3,3,3,3,2,2,2,2250,2250,1,3,2508,2511,2377,1,
 3,2511,2507,1,3,2511,2508,3,2662,2663,2,2,3077,2,2,2,2,
 3161,2,2,2,2,3161,2,2,2250,3,2662,2662,1,1,1,2377,2511,3,
 2511,3,2662,2662,1,1,1,2250,2507,3,2508,2,2,3,3,3,3,2,2,
 2,3077,2507,2511,2511,2662,3143,2,2771,2508,2511,2511,2662,
 2771,2,3143,2250,2250,1,2662,3,2662,2377,1,2662,3,2662,1,
 2662,3,2662,2511,3,2511,2,3077,2,2250,2511,3,2508,1,1,1,
 2377,2662,2662,3,2508,3,2511,1,1,1,2250,2662,2662,3,2,3077,
 2662,2662,2662,2511,3143,2771,2,2,3,3,3,3,2,2,2,2662,2663,
 2662,2507,2771,3143,2,2250,2250,1,2508,2511,3,2377,1,2511,
 2506,3,1,2511,2508,3,2662,2662,3,3077,2,2,2039,2039,2039,
 2731,2731,3029,2731,2039,2039,2039,2039,2039,2480,2409,2480,
 1997,2480,2409,2480,1997,2480,2409,2480,1997,2480,2480,2409,
 2480,2409,2480,1997,2409,2480,2480,2731,3029,3029,2480,2480,
 2480,2731,2731,2409,2409,2409,2731,2480,2480,2480,1997,1997,
 1997,2039,1997,2039,2039,2039,2409,2480,2480,2039,2480,2409,
 2480,1997,2409,2480,2480,2039,2480,2480,2409,2409,2480,2480,
 2039,2409,2480,2480,2731,2731,2731,2409,2409,2409,3029,3029,
 2480,2480,2480,2731,2480,2480,2480,2039,2039,2039,2039,1997,
 2039,2731,2039,2039,2039,2039,3029,2731,2731,2039,2039,2039,
 2039,2731,2731,3029,2039,2039,2480,2480,2409,2480,1997,2480,
 2480,2409,2480,2409,2480,2409,2480,2480,2409,2480,2731,3029,
 2731,1997,1997,1997,1997,2731,3029,2731,2039,2039,2480,2480,
 2480,2409,1997,2480,2480,2480,2409,2409,2480,2480,2409,2480,
 2480,2409,3029,2731,2731,2039,2039,2480,2409,2480,2480,1997,
 2480,2409,2480,2480,2409,2409,2480,2480,2409,2480,2480,2731,
 2731,3029,2731,3029,2039,2039,2039,2731,2039,2039,2039,2480,
 2480,2480,2039,1997,2039,2731,1997,1997,1997,2480,2480,2480,
 2039,1997,2039,2409,2409,2409,2039,1997,2039,2039,1997,2039,
 2731];

return List(shortresidueclassorbitlengthspos,
            i->shortresidueclassorbitlengthsset[i]);

#############################################################################
##
#E  residueclassorbitlengths.g . . . . . . . . . . . . . . . . . .  ends here