/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class ENewObj
extends AExpression {
    private final String type;
    private final List<AExpression> arguments;
    private PainlessConstructor constructor;

    public ENewObj(Location location, String type, List<AExpression> arguments) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        this.actual = locals.getPainlessLookup().canonicalTypeNameToType(this.type);
        if (this.actual == null) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        this.constructor = locals.getPainlessLookup().lookupPainlessConstructor(this.actual, this.arguments.size());
        if (this.constructor == null) {
            throw this.createError(new IllegalArgumentException("constructor [" + PainlessLookupUtility.typeToCanonicalTypeName(this.actual) + ", <init>/" + this.arguments.size() + "] not found"));
        }
        Class[] types = new Class[this.constructor.typeParameters.size()];
        this.constructor.typeParameters.toArray(types);
        if (this.constructor.typeParameters.size() != this.arguments.size()) {
            throw this.createError(new IllegalArgumentException("When calling constructor on type [" + PainlessLookupUtility.typeToCanonicalTypeName(this.actual) + "] expected [" + this.constructor.typeParameters.size() + "] arguments, but found [" + this.arguments.size() + "]."));
        }
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.expected = types[argument];
            expression.internal = true;
            expression.analyze(locals);
            this.arguments.set(argument, expression.cast(locals));
        }
        this.statement = true;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.newInstance(MethodWriter.getType(this.actual));
        if (this.read) {
            writer.dup();
        }
        for (AExpression argument : this.arguments) {
            argument.write(writer, globals);
        }
        writer.invokeConstructor(Type.getType(this.constructor.javaConstructor.getDeclaringClass()), Method.getMethod(this.constructor.javaConstructor));
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.type);
    }
}

