/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.controls;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.panels.AbstractConfigurationPanel;

public class ConfigurationPanelControl
implements IConfigurationPanelContainer,
IMessageProvider {
    private final Map<String, IConfigurationPanel> configurationPanels = new Hashtable<String, IConfigurationPanel>();
    private String message = null;
    private int messageType = 0;
    private boolean isGroup;
    private Composite panel;
    private StackLayout panelLayout;
    private String activeConfigurationPanelKey = null;
    private IConfigurationPanel activeConfigurationPanel = null;
    private final AbstractConfigurationPanel EMPTY_PANEL = new EmptySettingsPanel(this);

    public void dispose() {
        this.EMPTY_PANEL.dispose();
    }

    public ConfigurationPanelControl() {
        this.clear();
        this.setPanelIsGroup(false);
    }

    public void setPanelIsGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public boolean isPanelIsGroup() {
        return this.isGroup;
    }

    public Composite getPanel() {
        return this.panel;
    }

    public String getGroupLabel() {
        return null;
    }

    @Override
    public void validate() {
    }

    public void setupPanel(Composite parent, String[] configurationPanelKeys) {
        Assert.isNotNull((Object)parent);
        if (this.isPanelIsGroup()) {
            this.panel = new Group(parent, 0);
            if (this.getGroupLabel() != null) {
                ((Group)this.panel).setText(this.getGroupLabel());
            }
        } else {
            this.panel = new Composite(parent, 0);
        }
        Assert.isNotNull((Object)this.panel);
        this.panel.setFont(parent.getFont());
        this.panel.setBackground(parent.getBackground());
        this.panelLayout = new StackLayout();
        this.panel.setLayout((Layout)this.panelLayout);
        this.setupConfigurationPanels(this.panel, configurationPanelKeys);
        this.EMPTY_PANEL.setupPanel(this.panel);
    }

    public void clear() {
        this.configurationPanels.clear();
    }

    public String[] getConfigurationPanelIds() {
        return this.configurationPanels.keySet().toArray(new String[this.configurationPanels.keySet().size()]);
    }

    public IConfigurationPanel getConfigurationPanel(String key) {
        IConfigurationPanel panel = key != null ? this.configurationPanels.get(key) : null;
        return panel != null ? panel : this.EMPTY_PANEL;
    }

    public final boolean isEmptyConfigurationPanel(IConfigurationPanel panel) {
        return this.EMPTY_PANEL == panel;
    }

    public void addConfigurationPanel(String key, IConfigurationPanel panel) {
        if (key == null) {
            return;
        }
        if (panel != null) {
            this.configurationPanels.put(key, panel);
        } else {
            this.configurationPanels.remove(key);
        }
    }

    public void setupConfigurationPanels(Composite parent, String[] configurationPanelKeys) {
        Assert.isNotNull((Object)parent);
        if (configurationPanelKeys != null) {
            int i = 0;
            while (i < configurationPanelKeys.length) {
                IConfigurationPanel configPanel = this.getConfigurationPanel(configurationPanelKeys[i]);
                Assert.isNotNull((Object)configPanel);
                configPanel.setupPanel(parent);
                ++i;
            }
        }
    }

    public void showConfigurationPanel(String key) {
        String activeKey = this.getActiveConfigurationPanelKey();
        if (key != null && key.equals(activeKey) && this.activeConfigurationPanel != null) {
            return;
        }
        IConfigurationPanel configPanel = this.getActiveConfigurationPanel();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (configPanel != null) {
            configPanel.extractData(data);
        }
        configPanel = this.getConfigurationPanel(key);
        Assert.isNotNull((Object)configPanel);
        if (configPanel.getControl() != null) {
            this.activeConfigurationPanel = configPanel;
            this.activeConfigurationPanelKey = key;
            this.panelLayout.topControl = configPanel.getControl();
            this.panel.layout();
            if (!data.isEmpty()) {
                configPanel.updateData(data);
            }
            configPanel.activate();
        } else {
            this.activeConfigurationPanelKey = key;
        }
    }

    public IConfigurationPanel getActiveConfigurationPanel() {
        return this.activeConfigurationPanel;
    }

    public String getActiveConfigurationPanelKey() {
        return this.activeConfigurationPanelKey;
    }

    public final IDialogSettings getDialogSettings(IDialogSettings settings) {
        Assert.isNotNull((Object)settings);
        String sectionName = this.getClass().getSimpleName();
        Assert.isNotNull((Object)sectionName);
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public final void restoreWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        this.doRestoreWidgetValues(this.getDialogSettings(settings), idPrefix);
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        for (String panelKey : this.configurationPanels.keySet()) {
            IConfigurationPanel configPanel = this.getConfigurationPanel(panelKey);
            if (configPanel == null || this.isEmptyConfigurationPanel(configPanel)) continue;
            IDialogSettings configPanelSettings = settings.getSection(panelKey);
            if (configPanelSettings == null) {
                configPanelSettings = settings.addNewSection(panelKey);
            }
            configPanel.doRestoreWidgetValues(configPanelSettings, idPrefix);
        }
    }

    public final void saveWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        this.doSaveWidgetValues(this.getDialogSettings(settings), idPrefix);
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        IConfigurationPanel configPanel = this.getActiveConfigurationPanel();
        if (configPanel != null && !this.isEmptyConfigurationPanel(configPanel)) {
            String key = this.getActiveConfigurationPanelKey();
            IDialogSettings configPanelSettings = settings.getSection(key);
            if (configPanelSettings == null) {
                configPanelSettings = settings.addNewSection(key);
            }
            configPanel.doSaveWidgetValues(configPanelSettings, idPrefix);
        }
    }

    public final String getMessage() {
        return this.message;
    }

    public final int getMessageType() {
        return this.messageType;
    }

    @Override
    public final void setMessage(String message, int messageType) {
        this.message = message;
        this.messageType = messageType;
    }

    private static final class EmptySettingsPanel
    extends AbstractConfigurationPanel {
        public EmptySettingsPanel(IConfigurationPanelContainer container) {
            super(container);
        }

        @Override
        public void setupPanel(Composite parent) {
            Composite panel = new Composite(parent, 0);
            panel.setLayout((Layout)new GridLayout());
            panel.setLayoutData((Object)new GridData(4, 4, true, true));
            panel.setBackground(parent.getBackground());
            this.setControl(panel);
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }
}

