/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.viewers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.ContentViewer;

public class ImageViewer
extends ContentViewer {
    protected static final byte CR = 13;
    protected static final byte LF = 10;
    protected ScrolledComposite scroll;
    protected Label messageLabel;
    protected byte[] content;

    public void init(Composite parent) {
        this.scroll = new ScrolledComposite(parent, 768);
        this.messageLabel = new Label((Composite)this.scroll, 0);
        this.messageLabel.setText(Messages.imageViewInvalid);
        this.messageLabel.setFont(parent.getFont());
        this.messageLabel.setSize(this.messageLabel.computeSize(-1, -1));
        this.scroll.setContent((Control)this.messageLabel);
    }

    public void setContent(byte[] b) {
        this.content = b;
        if (b == null || b.length == 0) {
            this.messageLabel.setImage(null);
        } else {
            b = MonitorUIPlugin.unzip(b);
            int trimFront = 0;
            int trimBack = 0;
            int len = b.length - 1;
            while (trimFront < b.length && b[trimFront] == 13 || b[trimFront] == 10) {
                ++trimFront;
            }
            while (trimBack < b.length && b[len - trimBack] == 13 || b[len - trimBack] == 10) {
                ++trimBack;
            }
            if (trimFront + trimBack > 0) {
                if (trimFront + trimBack > b.length) {
                    b = new byte[]{};
                } else {
                    byte[] temp = b;
                    b = new byte[temp.length - trimBack - trimFront];
                    int i = trimFront;
                    while (i < temp.length - trimBack) {
                        b[i - trimFront] = temp[i];
                        ++i;
                    }
                }
            }
            try {
                ImageData imgD = new ImageData((InputStream)new ByteArrayInputStream(b));
                Image img = new Image(null, imgD);
                this.messageLabel.setImage(img);
            }
            catch (Exception exception) {
                this.messageLabel.setImage(null);
                this.messageLabel.setText(Messages.imageViewInvalid);
            }
        }
        this.messageLabel.setSize(this.messageLabel.computeSize(-1, -1));
    }

    public byte[] getContent() {
        return this.content;
    }

    public void dispose() {
        this.scroll.dispose();
        this.scroll = null;
        this.messageLabel = null;
        this.content = null;
    }
}

