/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.remote;

import java.util.Set;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.remote.NewArduinoTargetWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewArduinoTargetWizard
extends Wizard
implements IRemoteUIConnectionWizard,
INewWizard {
    private NewArduinoTargetWizardPage page;
    private IRemoteConnectionWorkingCopy workingCopy;
    private boolean isNewWizard;
    private Shell shell;
    private IRemoteConnectionType connectionType;

    public NewArduinoTargetWizard(Shell shell, IRemoteConnectionType connectionType) {
        this.shell = shell;
        this.connectionType = connectionType;
    }

    public NewArduinoTargetWizard() {
        this.connectionType = Activator.getService(IRemoteServicesManager.class).getConnectionType("org.eclipse.cdt.arduino.core.connectionType");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.isNewWizard = true;
    }

    public void addPages() {
        this.page = new NewArduinoTargetWizardPage();
        if (this.workingCopy != null) {
            this.page.setWorkingCopy(this.workingCopy);
        }
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        if (this.getConnection() == null) {
            return false;
        }
        this.page.performFinish(this.workingCopy);
        if (this.isNewWizard) {
            try {
                this.workingCopy.save();
            }
            catch (RemoteConnectionException e) {
                Activator.log((Exception)((Object)e));
                return false;
            }
        }
        return true;
    }

    public IRemoteConnectionWorkingCopy open() {
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)this);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            return this.getConnection();
        }
        return null;
    }

    public IRemoteConnectionWorkingCopy getConnection() {
        if (this.workingCopy == null) {
            try {
                this.workingCopy = this.connectionType.newConnection(this.page.getConnectionName());
            }
            catch (RemoteConnectionException e) {
                Activator.getDefault().getLog().log(e.getStatus());
                return null;
            }
        }
        return this.workingCopy;
    }

    public void setConnection(IRemoteConnectionWorkingCopy connection) {
        this.workingCopy = connection;
    }

    public void setConnectionName(String name) {
    }

    public void setInvalidConnectionNames(Set<String> names) {
    }
}

