/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.model;

import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemLocationFactory;
import org.eclipse.cdt.codan.core.model.IProblemReporter;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemLocation;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class CodanMarkerGenerator
implements IMarkerGenerator {
    private final String problemId;
    private final IProblemReporter reporter;

    public CodanMarkerGenerator(String problemId) {
        this.problemId = problemId;
        this.reporter = CodanRuntime.getInstance().getProblemReporter();
    }

    public CodanMarkerGenerator(String problemId, IProblemReporter reporter) {
        this.problemId = problemId;
        this.reporter = reporter;
    }

    @Deprecated
    public void addMarker(IResource file, int lineNumber, String description, int severity, String variableName) {
        this.addMarker(new ProblemMarkerInfo(file, lineNumber, description, severity, variableName));
    }

    public void addMarker(ProblemMarkerInfo info) {
        this.reporter.reportProblem(this.getProblemId(info.severity), this.createProblemLocation(info), new Object[]{info.description, info.variableName});
    }

    protected String getProblemId(int severity) {
        return this.problemId;
    }

    protected IProblemLocation createProblemLocation(ProblemMarkerInfo info) {
        IProblemLocationFactory factory = CodanRuntime.getInstance().getProblemLocationFactory();
        if (info.file instanceof IFile) {
            return factory.createProblemLocation((IFile)info.file, info.startChar, info.endChar, info.lineNumber);
        }
        return new CodanProblemLocation(info.file, info.startChar, info.endChar, info.lineNumber);
    }
}

