/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.common.TypeConverter;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.common.XmlRpcNotAuthorizedException;
import org.apache.xmlrpc.metadata.Util;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;

public class ReflectiveXmlRpcHandler
implements XmlRpcHandler {
    private final AbstractReflectiveHandlerMapping mapping;
    private final MethodData[] methods;
    private final Class clazz;
    private final RequestProcessorFactoryFactory.RequestProcessorFactory requestProcessorFactory;

    public ReflectiveXmlRpcHandler(AbstractReflectiveHandlerMapping pMapping, TypeConverterFactory pTypeConverterFactory, Class pClass, RequestProcessorFactoryFactory.RequestProcessorFactory pFactory, Method[] pMethods) {
        this.mapping = pMapping;
        this.clazz = pClass;
        this.methods = new MethodData[pMethods.length];
        this.requestProcessorFactory = pFactory;
        for (int i = 0; i < this.methods.length; ++i) {
            this.methods[i] = new MethodData(pMethods[i], pTypeConverterFactory);
        }
    }

    private Object getInstance(XmlRpcRequest pRequest) throws XmlRpcException {
        return this.requestProcessorFactory.getRequestProcessor(pRequest);
    }

    public Object execute(XmlRpcRequest pRequest) throws XmlRpcException {
        AbstractReflectiveHandlerMapping.AuthenticationHandler authHandler = this.mapping.getAuthenticationHandler();
        if (authHandler != null && !authHandler.isAuthorized(pRequest)) {
            throw new XmlRpcNotAuthorizedException("Not authorized");
        }
        Object[] args = new Object[pRequest.getParameterCount()];
        for (int j = 0; j < args.length; ++j) {
            args[j] = pRequest.getParameter(j);
        }
        Object instance = this.getInstance(pRequest);
        for (int i = 0; i < this.methods.length; ++i) {
            int j;
            MethodData methodData = this.methods[i];
            TypeConverter[] converters = methodData.typeConverters;
            if (args.length != converters.length) continue;
            boolean matching = true;
            for (j = 0; j < args.length; ++j) {
                if (converters[j].isConvertable(args[j])) continue;
                matching = false;
                break;
            }
            if (!matching) continue;
            for (j = 0; j < args.length; ++j) {
                args[j] = converters[j].convert(args[j]);
            }
            return this.invoke(instance, methodData.method, args);
        }
        throw new XmlRpcException("No method matching arguments: " + Util.getSignature(args));
    }

    private Object invoke(Object pInstance, Method pMethod, Object[] pArgs) throws XmlRpcException {
        try {
            return pMethod.invoke(pInstance, pArgs);
        }
        catch (IllegalAccessException e) {
            throw new XmlRpcException("Illegal access to method " + pMethod.getName() + " in class " + this.clazz.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new XmlRpcException("Illegal argument for method " + pMethod.getName() + " in class " + this.clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new XmlRpcException("Failed to invoke method " + pMethod.getName() + " in class " + this.clazz.getName() + ": " + t.getMessage(), t);
        }
    }

    private static class MethodData {
        final Method method;
        final TypeConverter[] typeConverters;

        MethodData(Method pMethod, TypeConverterFactory pTypeConverterFactory) {
            this.method = pMethod;
            Class<?>[] paramClasses = this.method.getParameterTypes();
            this.typeConverters = new TypeConverter[paramClasses.length];
            for (int i = 0; i < paramClasses.length; ++i) {
                this.typeConverters[i] = pTypeConverterFactory.getTypeConverter(paramClasses[i]);
            }
        }
    }
}

