/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.functions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.registry.functions.AggregateFunctionDescriptor;

public class FunctionsRegistry {
    static final String TAG_FUNCTION = "function";
    private static FunctionsRegistry instance = null;
    private final List<AggregateFunctionDescriptor> functions = new ArrayList<AggregateFunctionDescriptor>();

    public static synchronized FunctionsRegistry getInstance() {
        if (instance == null) {
            instance = new FunctionsRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private FunctionsRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.aggregateFunction");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_FUNCTION.equals(ext.getName())) {
                this.functions.add(new AggregateFunctionDescriptor(ext));
            }
            ++n2;
        }
    }

    public void dispose() {
        this.functions.clear();
    }

    public List<AggregateFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    public AggregateFunctionDescriptor getFunction(String id) {
        for (AggregateFunctionDescriptor func : this.functions) {
            if (!func.getId().equals(id)) continue;
            return func;
        }
        return null;
    }
}

