/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.compare.simple;

import java.util.List;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPSettingsSection;

public class CompareObjectsSettings {
    private final List<DBNDatabaseNode> nodes;
    private boolean skipSystemObjects = true;
    private boolean compareLazyProperties = false;
    private boolean compareOnlyStructure = false;
    private boolean compareScripts = false;
    private boolean showOnlyDifferences = false;
    private OutputType outputType = OutputType.BROWSER;
    private String outputFolder;

    public CompareObjectsSettings(List<DBNDatabaseNode> nodes) {
        this.nodes = nodes;
    }

    public List<DBNDatabaseNode> getNodes() {
        return this.nodes;
    }

    public boolean isSkipSystemObjects() {
        return this.skipSystemObjects;
    }

    public void setSkipSystemObjects(boolean skipSystemObjects) {
        this.skipSystemObjects = skipSystemObjects;
    }

    public boolean isCompareLazyProperties() {
        return this.compareLazyProperties;
    }

    public void setCompareLazyProperties(boolean compareLazyProperties) {
        this.compareLazyProperties = compareLazyProperties;
    }

    public boolean isCompareOnlyStructure() {
        return this.compareOnlyStructure;
    }

    public void setCompareOnlyStructure(boolean compareOnlyStructure) {
        this.compareOnlyStructure = compareOnlyStructure;
    }

    public boolean isCompareScripts() {
        return this.compareScripts;
    }

    public void setCompareScripts(boolean compareScripts) {
        this.compareScripts = compareScripts;
    }

    public boolean isShowOnlyDifferences() {
        return this.showOnlyDifferences;
    }

    public void setShowOnlyDifferences(boolean showOnlyDifferences) {
        this.showOnlyDifferences = showOnlyDifferences;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void loadFrom(DBPSettingsSection dialogSettings) {
        if (dialogSettings.get("skipSystem") != null) {
            this.skipSystemObjects = dialogSettings.getBoolean("skipSystem");
        }
        if (dialogSettings.get("compareLazy") != null) {
            this.compareLazyProperties = dialogSettings.getBoolean("compareLazy");
        }
        if (dialogSettings.get("compareStructure") != null) {
            this.compareOnlyStructure = dialogSettings.getBoolean("compareStructure");
        }
        if (dialogSettings.get("showDifference") != null) {
            this.showOnlyDifferences = dialogSettings.getBoolean("showDifference");
        }
        if (dialogSettings.get("compareScripts") != null) {
            this.compareScripts = dialogSettings.getBoolean("compareScripts");
        }
        if (dialogSettings.get("outputType") != null) {
            this.outputType = OutputType.valueOf(dialogSettings.get("outputType"));
        }
        if (dialogSettings.get("outputFolder") != null) {
            this.outputFolder = dialogSettings.get("outputFolder");
        }
    }

    public void saveTo(DBPSettingsSection dialogSettings) {
        dialogSettings.put("skipSystem", this.skipSystemObjects);
        dialogSettings.put("compareLazy", this.compareLazyProperties);
        dialogSettings.put("compareStructure", this.compareOnlyStructure);
        dialogSettings.put("compareScripts", this.compareScripts);
        dialogSettings.put("showDifference", this.showOnlyDifferences);
        dialogSettings.put("outputType", this.outputType.name());
        dialogSettings.put("outputFolder", this.outputFolder);
    }

    public static enum OutputType {
        BROWSER("Open in browser"),
        FILE("Save to file");

        private final String title;

        private OutputType(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

