/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class PostgreToolRefreshMView
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, PostgreMaterializedView.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        }
    }

    static class SQLDialog
    extends TableToolDialog {
        private Button withDataCheck;

        public SQLDialog(IWorkbenchPartSite partSite, List<PostgreMaterializedView> selectedTables) {
            super(partSite, PostgreMessages.tool_refresh_mview_title_table, selectedTables);
        }

        protected void generateObjectCommand(List<String> lines, PostgreObject object) {
            String sql = "REFRESH MATERIALIZED VIEW " + ((PostgreMaterializedView)object).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ";
            sql = this.withDataCheck.getSelection() ? String.valueOf(sql) + "WITH DATA" : String.valueOf(sql) + "WITH NO DATA";
            lines.add(sql);
        }

        protected void createControls(Composite parent) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)PostgreMessages.tool_refresh_mview_group_option, (int)1, (int)0, (int)0);
            optionsGroup.setLayoutData((Object)new GridData(768));
            this.withDataCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)PostgreMessages.tool_refresh_mview_with_data, (String)PostgreMessages.tool_refresh_mview_with_data_tooltip, (boolean)true, (int)0);
            this.withDataCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.createObjectsSelector(parent);
        }
    }
}

