/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import org.jkiss.dbeaver.data.gis.handlers.WKGUtils;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;

public class PostgreGeometryValueHandler
extends JDBCAbstractValueHandler {
    public static final PostgreGeometryValueHandler INSTANCE = new PostgreGeometryValueHandler();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        try {
            Object object = resultSet.getObject(index);
            return this.getValueFromObject(session, type, object, false);
        }
        catch (SQLException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                String wkbValue = resultSet.getString(index);
                return WKGUtils.parseWKB((String)wkbValue);
            }
            throw e;
        }
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value instanceof DBGeometry) {
            value = ((DBGeometry)value).getRawValue();
        }
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof Geometry) {
            statement.setObject(paramIndex, (Object)this.getStringFromGeometry(session, (Geometry)value), 1111);
        } else if (value.getClass().getName().equals("org.postgis.PGgeometry")) {
            statement.setObject(paramIndex, value, 1111);
        } else {
            statement.setObject(paramIndex, (Object)value.toString(), 1111);
        }
    }

    public Class<?> getValueObjectType(DBSTypedObject attribute) {
        return DBGeometry.class;
    }

    public Object getValueFromObject(DBCSession session, DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return new DBGeometry();
        }
        if (object instanceof Geometry) {
            return new DBGeometry((Geometry)object);
        }
        if (object instanceof String) {
            return this.makeGeometryFromWKT(session, (String)object);
        }
        if (object.getClass().getName().equals("org.postgis.PGgeometry")) {
            return this.makeGeometryFromPGGeometry(session, object);
        }
        if (object.getClass().getName().equals("org.postgresql.util.PGobject")) {
            return this.makeGeometryFromWKB(session, CommonUtils.toString((Object)PostgreUtils.extractPGObjectValue(object)));
        }
        return this.makeGeometryFromWKT(session, object.toString());
    }

    private DBGeometry makeGeometryFromWKB(DBCSession session, String hexString) throws DBCException {
        byte[] binaryData = WKBReader.hexToBytes((String)hexString);
        try {
            Geometry geometry = new WKBReader().read(binaryData);
            return new DBGeometry(geometry);
        }
        catch (Exception e) {
            throw new DBCException("Error parsing WKB value", (Throwable)e);
        }
    }

    private DBGeometry makeGeometryFromPGGeometry(DBCSession session, Object value) throws DBCException {
        try {
            String pgString = value.toString();
            return this.makeGeometryFromWKT(session, pgString);
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getDataSource());
        }
    }

    private DBGeometry makeGeometryFromWKT(DBCSession session, String pgString) throws DBCException {
        if (CommonUtils.isEmpty((String)pgString)) {
            return new DBGeometry();
        }
        try {
            int divPos = pgString.indexOf(59);
            if (divPos == -1) {
                return new DBGeometry(pgString);
            }
            String sridString = pgString.substring(0, divPos);
            String wktString = pgString.substring(divPos + 1);
            Geometry geometry = new WKTReader().read(wktString);
            if (sridString.startsWith("SRID=")) {
                geometry.setSRID(CommonUtils.toInt((Object)sridString.substring(5)));
            }
            return new DBGeometry(geometry);
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getDataSource());
        }
    }

    private String getStringFromGeometry(JDBCSession session, Geometry geometry) throws DBCException {
        try {
            Class jtsGeometry = DBUtils.getDriverClass((DBPDataSource)session.getDataSource(), (String)"org.postgis.PGgeometry");
            Object jtsg = jtsGeometry.getConstructor(Geometry.class).newInstance(geometry);
            return (String)BeanUtils.invokeObjectMethod(jtsg, (String)"getValue", null, null);
        }
        catch (Throwable e) {
            throw new DBCException(e, (DBPDataSource)session.getDataSource());
        }
    }
}

