"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryErrorTile extends _react["default"].Component {
  componentDidMount() {
    // eslint-disable-next-line no-console
    console.error('Error encountered in subquery', this.props.error);
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-QueryErrorTile"
    }, _react["default"].createElement("div", {
      className: "github-QueryErrorTile-messages"
    }, this.renderMessages()));
  }

  renderMessages() {
    if (this.props.error.errors) {
      return this.props.error.errors.map((error, index) => {
        return this.renderMessage(error.message, index);
      });
    }

    if (this.props.error.response) {
      return this.renderMessage(this.props.error.responseText, '0');
    }

    return this.renderMessage(this.props.error.toString(), '0');
  }

  renderMessage(body, key) {
    return _react["default"].createElement("p", {
      key: key,
      className: "github-QueryErrorTile-message"
    }, _react["default"].createElement(_octicon["default"], {
      icon: "alert"
    }), body);
  }

}

exports["default"] = QueryErrorTile;

_defineProperty(QueryErrorTile, "propTypes", {
  error: _propTypes["default"].shape({
    response: _propTypes["default"].shape({
      status: _propTypes["default"].number.isRequired
    }),
    responseText: _propTypes["default"].string,
    errors: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      message: _propTypes["default"].string.isRequired
    }))
  }).isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInF1ZXJ5LWVycm9yLXRpbGUuanMiXSwibmFtZXMiOlsiUXVlcnlFcnJvclRpbGUiLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbXBvbmVudERpZE1vdW50IiwiY29uc29sZSIsImVycm9yIiwicHJvcHMiLCJyZW5kZXIiLCJyZW5kZXJNZXNzYWdlcyIsImVycm9ycyIsIm1hcCIsImluZGV4IiwicmVuZGVyTWVzc2FnZSIsIm1lc3NhZ2UiLCJyZXNwb25zZSIsInJlc3BvbnNlVGV4dCIsInRvU3RyaW5nIiwiYm9keSIsImtleSIsIlByb3BUeXBlcyIsInNoYXBlIiwic3RhdHVzIiwibnVtYmVyIiwiaXNSZXF1aXJlZCIsInN0cmluZyIsImFycmF5T2YiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFFQTs7Ozs7O0FBRWUsTUFBTUEsY0FBTixTQUE2QkMsa0JBQU1DLFNBQW5DLENBQTZDO0FBYTFEQyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQjtBQUNBQyxJQUFBQSxPQUFPLENBQUNDLEtBQVIsQ0FBYywrQkFBZCxFQUErQyxLQUFLQyxLQUFMLENBQVdELEtBQTFEO0FBQ0Q7O0FBRURFLEVBQUFBLE1BQU0sR0FBRztBQUNQLFdBQ0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0csS0FBS0MsY0FBTCxFQURILENBREYsQ0FERjtBQU9EOztBQUVEQSxFQUFBQSxjQUFjLEdBQUc7QUFDZixRQUFJLEtBQUtGLEtBQUwsQ0FBV0QsS0FBWCxDQUFpQkksTUFBckIsRUFBNkI7QUFDM0IsYUFBTyxLQUFLSCxLQUFMLENBQVdELEtBQVgsQ0FBaUJJLE1BQWpCLENBQXdCQyxHQUF4QixDQUE0QixDQUFDTCxLQUFELEVBQVFNLEtBQVIsS0FBa0I7QUFDbkQsZUFBTyxLQUFLQyxhQUFMLENBQW1CUCxLQUFLLENBQUNRLE9BQXpCLEVBQWtDRixLQUFsQyxDQUFQO0FBQ0QsT0FGTSxDQUFQO0FBR0Q7O0FBRUQsUUFBSSxLQUFLTCxLQUFMLENBQVdELEtBQVgsQ0FBaUJTLFFBQXJCLEVBQStCO0FBQzdCLGFBQU8sS0FBS0YsYUFBTCxDQUFtQixLQUFLTixLQUFMLENBQVdELEtBQVgsQ0FBaUJVLFlBQXBDLEVBQWtELEdBQWxELENBQVA7QUFDRDs7QUFFRCxXQUFPLEtBQUtILGFBQUwsQ0FBbUIsS0FBS04sS0FBTCxDQUFXRCxLQUFYLENBQWlCVyxRQUFqQixFQUFuQixFQUFnRCxHQUFoRCxDQUFQO0FBQ0Q7O0FBRURKLEVBQUFBLGFBQWEsQ0FBQ0ssSUFBRCxFQUFPQyxHQUFQLEVBQVk7QUFDdkIsV0FDRTtBQUFHLE1BQUEsR0FBRyxFQUFFQSxHQUFSO0FBQWEsTUFBQSxTQUFTLEVBQUM7QUFBdkIsT0FDRSxnQ0FBQyxtQkFBRDtBQUFTLE1BQUEsSUFBSSxFQUFDO0FBQWQsTUFERixFQUVHRCxJQUZILENBREY7QUFNRDs7QUFqRHlEOzs7O2dCQUF2Q2pCLGMsZUFDQTtBQUNqQkssRUFBQUEsS0FBSyxFQUFFYyxzQkFBVUMsS0FBVixDQUFnQjtBQUNyQk4sSUFBQUEsUUFBUSxFQUFFSyxzQkFBVUMsS0FBVixDQUFnQjtBQUN4QkMsTUFBQUEsTUFBTSxFQUFFRixzQkFBVUcsTUFBVixDQUFpQkM7QUFERCxLQUFoQixDQURXO0FBSXJCUixJQUFBQSxZQUFZLEVBQUVJLHNCQUFVSyxNQUpIO0FBS3JCZixJQUFBQSxNQUFNLEVBQUVVLHNCQUFVTSxPQUFWLENBQWtCTixzQkFBVUMsS0FBVixDQUFnQjtBQUN4Q1AsTUFBQUEsT0FBTyxFQUFFTSxzQkFBVUssTUFBVixDQUFpQkQ7QUFEYyxLQUFoQixDQUFsQjtBQUxhLEdBQWhCLEVBUUpBO0FBVGMsQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM4LjIvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5cbmltcG9ydCBPY3RpY29uIGZyb20gJy4uL2F0b20vb2N0aWNvbic7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFF1ZXJ5RXJyb3JUaWxlIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBlcnJvcjogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIHJlc3BvbnNlOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICBzdGF0dXM6IFByb3BUeXBlcy5udW1iZXIuaXNSZXF1aXJlZCxcbiAgICAgIH0pLFxuICAgICAgcmVzcG9uc2VUZXh0OiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgZXJyb3JzOiBQcm9wVHlwZXMuYXJyYXlPZihQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICBtZXNzYWdlOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICB9KSksXG4gICAgfSkuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1jb25zb2xlXG4gICAgY29uc29sZS5lcnJvcignRXJyb3IgZW5jb3VudGVyZWQgaW4gc3VicXVlcnknLCB0aGlzLnByb3BzLmVycm9yKTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItUXVlcnlFcnJvclRpbGVcIj5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItUXVlcnlFcnJvclRpbGUtbWVzc2FnZXNcIj5cbiAgICAgICAgICB7dGhpcy5yZW5kZXJNZXNzYWdlcygpfVxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJNZXNzYWdlcygpIHtcbiAgICBpZiAodGhpcy5wcm9wcy5lcnJvci5lcnJvcnMpIHtcbiAgICAgIHJldHVybiB0aGlzLnByb3BzLmVycm9yLmVycm9ycy5tYXAoKGVycm9yLCBpbmRleCkgPT4ge1xuICAgICAgICByZXR1cm4gdGhpcy5yZW5kZXJNZXNzYWdlKGVycm9yLm1lc3NhZ2UsIGluZGV4KTtcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnByb3BzLmVycm9yLnJlc3BvbnNlKSB7XG4gICAgICByZXR1cm4gdGhpcy5yZW5kZXJNZXNzYWdlKHRoaXMucHJvcHMuZXJyb3IucmVzcG9uc2VUZXh0LCAnMCcpO1xuICAgIH1cblxuICAgIHJldHVybiB0aGlzLnJlbmRlck1lc3NhZ2UodGhpcy5wcm9wcy5lcnJvci50b1N0cmluZygpLCAnMCcpO1xuICB9XG5cbiAgcmVuZGVyTWVzc2FnZShib2R5LCBrZXkpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPHAga2V5PXtrZXl9IGNsYXNzTmFtZT1cImdpdGh1Yi1RdWVyeUVycm9yVGlsZS1tZXNzYWdlXCI+XG4gICAgICAgIDxPY3RpY29uIGljb249XCJhbGVydFwiIC8+XG4gICAgICAgIHtib2R5fVxuICAgICAgPC9wPlxuICAgICk7XG4gIH1cbn1cbiJdfQ==