"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BarePrStatusContextView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _prStatusesView = require("../views/pr-statuses-view");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BarePrStatusContextView extends _react["default"].Component {
  render() {
    const {
      context,
      description,
      state,
      targetUrl
    } = this.props.context;
    const {
      icon,
      style
    } = _prStatusesView.stateToIconAndStyle[state];
    return _react["default"].createElement("li", {
      className: "github-PrStatuses-list-item"
    }, _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-icon"
    }, _react["default"].createElement(_octicon["default"], {
      icon: icon,
      className: style
    })), _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-context"
    }, _react["default"].createElement("strong", null, context), " ", description), _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-details-link"
    }, _react["default"].createElement("a", {
      href: targetUrl
    }, "Details")));
  }

}

exports.BarePrStatusContextView = BarePrStatusContextView;

_defineProperty(BarePrStatusContextView, "propTypes", {
  context: _propTypes["default"].shape({
    context: _propTypes["default"].string.isRequired,
    description: _propTypes["default"].string,
    state: _propTypes["default"].string.isRequired,
    targetUrl: _propTypes["default"].string,
    creator: _propTypes["default"].shape({
      avatarUrl: _propTypes["default"].string.isRequired,
      login: _propTypes["default"].string.isRequired
    })
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BarePrStatusContextView, {
  context: function () {
    const node = require("./__generated__/prStatusContextView_context.graphql");

    if (node.hash && node.hash !== "e729074e494e07b59b4a177416eb7a3c") {
      console.error("The definition of 'prStatusContextView_context' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prStatusContextView_context.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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