"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const ISSUEISH_URL_REGEX = /^(?:https?:\/\/)?github.com\/([^/]+)\/([^/]+)\/(?:issues|pull)\/(\d+)/;

class OpenIssueishDialog extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'accept', 'cancel', 'editorRefs', 'didChangeIssueishUrl');
    this.state = {
      cloneDisabled: false
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.issueishUrlElement) {
      setTimeout(() => this.issueishUrlElement.focus());
    }
  }

  render() {
    return this.renderDialog();
  }

  renderDialog() {
    return _react["default"].createElement("div", {
      className: "github-Dialog github-OpenIssueish modal"
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: ".github-OpenIssueish"
    }, _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.accept
    })), _react["default"].createElement("main", {
      className: "github-DialogInputs"
    }, _react["default"].createElement("label", {
      className: "github-DialogLabel github-IssueishUrl"
    }, "Issue or pull request URL:", _react["default"].createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRefs('issueishUrl'),
      tabIndex: "1"
    })), this.state.error && _react["default"].createElement("span", {
      className: "error"
    }, this.state.error)), _react["default"].createElement("div", {
      className: "github-DialogButtons"
    }, _react["default"].createElement("button", {
      className: "btn github-CancelButton",
      onClick: this.cancel,
      tabIndex: "3"
    }, "Cancel"), _react["default"].createElement("button", {
      className: "btn btn-primary icon icon-git-pull-request",
      onClick: this.accept,
      disabled: this.getIssueishUrl().length === 0,
      tabIndex: "2"
    }, "Open Issue or Pull Request")));
  }

  accept() {
    if (this.getIssueishUrl().length === 0) {
      return;
    }

    const parsed = this.parseUrl();

    if (!parsed) {
      this.setState({
        error: 'That is not a valid issue or pull request URL.'
      });
      return;
    }

    const {
      repoOwner,
      repoName,
      issueishNumber
    } = parsed;
    this.props.didAccept({
      repoOwner,
      repoName,
      issueishNumber
    });
  }

  cancel() {
    this.props.didCancel();
  }

  editorRefs(baseName) {
    const elementName = `${baseName}Element`;
    const modelName = `${baseName}Editor`;
    const subName = `${baseName}Subs`;
    const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;
    return element => {
      if (!element) {
        return;
      }

      this[elementName] = element;
      const editor = element.getModel();

      if (this[modelName] !== editor) {
        this[modelName] = editor;

        if (this[subName]) {
          this[subName].dispose();
          this.subs.remove(this[subName]);
        }

        this[subName] = editor.onDidChange(this[changeMethodName]);
        this.subs.add(this[subName]);
      }
    };
  }

  didChangeIssueishUrl() {
    this.setState({
      error: null
    });
  }

  parseUrl() {
    const url = this.getIssueishUrl();
    const matches = url.match(ISSUEISH_URL_REGEX);

    if (!matches) {
      return false;
    }

    const [_full, repoOwner, repoName, issueishNumber] = matches; // eslint-disable-line no-unused-vars

    return {
      repoOwner,
      repoName,
      issueishNumber
    };
  }

  getIssueishUrl() {
    return this.issueishUrlEditor ? this.issueishUrlEditor.getText() : '';
  }

}

exports["default"] = OpenIssueishDialog;

_defineProperty(OpenIssueishDialog, "propTypes", {
  commandRegistry: _propTypes["default"].object.isRequired,
  didAccept: _propTypes["default"].func,
  didCancel: _propTypes["default"].func
});

_defineProperty(OpenIssueishDialog, "defaultProps", {
  didAccept: () => {},
  didCancel: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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