/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Language;
import processing.app.contrib.ContribProgressBar;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ManagerTabs;
import processing.app.contrib.UpdateContributionTab;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;

public class ManagerFrame {
    static final String ANY_CATEGORY = Language.text("contrib.all");
    static final int AUTHOR_WIDTH = Toolkit.zoom(240);
    static final int STATUS_WIDTH = Toolkit.zoom(66);
    static final String title = "Contribution Manager";
    Base base;
    JFrame frame;
    ManagerTabs tabs;
    ContributionTab librariesTab;
    ContributionTab modesTab;
    ContributionTab toolsTab;
    ContributionTab examplesTab;
    UpdateContributionTab updatesTab;
    static Font SMALL_PLAIN;
    static Font SMALL_BOLD;
    static Font NORMAL_PLAIN;
    static Font NORMAL_BOLD;

    public ManagerFrame(Base base) {
        this.base = base;
        int smallSize = Toolkit.zoom(12);
        int normalSize = Toolkit.zoom(14);
        SMALL_PLAIN = Toolkit.getSansFont(smallSize, 0);
        SMALL_BOLD = Toolkit.getSansFont(smallSize, 1);
        NORMAL_PLAIN = Toolkit.getSansFont(normalSize, 0);
        NORMAL_BOLD = Toolkit.getSansFont(normalSize, 1);
        this.librariesTab = new ContributionTab(this, ContributionType.LIBRARY);
        this.modesTab = new ContributionTab(this, ContributionType.MODE);
        this.toolsTab = new ContributionTab(this, ContributionType.TOOL);
        this.examplesTab = new ContributionTab(this, ContributionType.EXAMPLES);
        this.updatesTab = new UpdateContributionTab(this);
    }

    public void showFrame(ContributionType contributionType) {
        ContributionTab showTab = this.getTab(contributionType);
        if (this.frame == null) {
            this.makeFrame();
            this.tabs.setPanel(showTab);
            this.downloadAndUpdateContributionListing(this.base);
        } else {
            this.tabs.setPanel(showTab);
        }
        this.frame.setVisible(true);
        this.tabs.requestFocusInWindow();
    }

    private void makeFrame() {
        this.frame = new JFrame(title);
        this.frame.setMinimumSize(Toolkit.zoom(750, 500));
        this.tabs = new ManagerTabs(this.base);
        this.makeAndShowTab(false, true);
        this.tabs.addPanel(this.librariesTab, "Libraries");
        this.tabs.addPanel(this.modesTab, "Modes");
        this.tabs.addPanel(this.toolsTab, "Tools");
        this.tabs.addPanel(this.examplesTab, "Examples");
        this.tabs.addPanel(this.updatesTab, "Updates");
        this.frame.setResizable(true);
        Container c = this.frame.getContentPane();
        c.add(this.tabs);
        c.setBackground(this.base.getDefaultMode().getColor("manager.tab.background"));
        this.frame.validate();
        this.frame.repaint();
        Toolkit.setIcon(this.frame);
        this.registerDisposeListeners();
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
    }

    protected void disposeFrame() {
        this.frame.dispose();
    }

    private void registerDisposeListeners() {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ManagerFrame.this.disposeFrame();
            }
        });
        Toolkit.registerWindowCloseKeys(this.frame.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagerFrame.this.disposeFrame();
            }
        });
        this.frame.getContentPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke wc = Toolkit.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    ManagerFrame.this.disposeFrame();
                }
            }
        });
    }

    void downloadAndUpdateContributionListing(Base base) {
        final ContributionTab activeTab = this.getActiveTab();
        ContribProgressBar progress = new ContribProgressBar(activeTab.progressBar){

            @Override
            public void startTask(String name, int maxValue) {
                super.startTask(name, maxValue);
                this.progressBar.setVisible(true);
                this.progressBar.setString(null);
            }

            @Override
            public void setProgress(int value) {
                super.setProgress(value);
                this.progressBar.setValue(value);
            }

            @Override
            public void finishedAction() {
                this.progressBar.setVisible(false);
                activeTab.updateContributionListing();
                activeTab.updateCategoryChooser();
                if (this.error) {
                    this.exception.printStackTrace();
                    ManagerFrame.this.makeAndShowTab(true, false);
                } else {
                    ManagerFrame.this.makeAndShowTab(false, false);
                }
            }
        };
        activeTab.contribListing.downloadAvailableList(base, progress);
    }

    void makeAndShowTab(boolean error, boolean loading) {
        Editor editor = this.base.getActiveEditor();
        this.librariesTab.showFrame(editor, error, loading);
        this.modesTab.showFrame(editor, error, loading);
        this.toolsTab.showFrame(editor, error, loading);
        this.examplesTab.showFrame(editor, error, loading);
        this.updatesTab.showFrame(editor, error, loading);
    }

    protected ContributionTab getTab(ContributionType contributionType) {
        if (contributionType == ContributionType.LIBRARY) {
            return this.librariesTab;
        }
        if (contributionType == ContributionType.MODE) {
            return this.modesTab;
        }
        if (contributionType == ContributionType.TOOL) {
            return this.toolsTab;
        }
        if (contributionType == ContributionType.EXAMPLES) {
            return this.examplesTab;
        }
        return this.updatesTab;
    }

    ContributionTab getActiveTab() {
        return (ContributionTab)this.tabs.getPanel();
    }
}

