S2 = Manifold(2, 'S^2', start_index=1)
polar = S2.chart('th ph'); th, ph = polar[:]
epolar = polar.frame()
ch_basis = S2.automorphism_field()
ch_basis[1,1], ch_basis[2,2] = 1, 1/sin(th)
epolar_ON = epolar.new_frame(ch_basis, 'epolar_ON')
nab = S2.affine_connection('nab')
_ = nab.set_coef(frame=epolar_ON)
t,tmin,tmax,th0,ph0,v_th0,v_ph0 = var('t tmin tmax th0 ph0 v_th0 v_ph0')
p = S2.point((th0, ph0), name='p')
Tp = S2.tangent_space(p)
v = Tp((v_th0, v_ph0), basis=epolar_ON.at(p))
c = S2.integrated_autoparallel_curve(nab, (t, tmin, tmax), v,
                                          chart=polar, name='c')
dict_params={'latit':{tmin:0,tmax:3,th0:pi/4,ph0:0.1,v_th0:0,v_ph0:1},
        'longi':{tmin:0,tmax:3,th0:0.1,ph0:0.1,v_th0:1,v_ph0:0}}
mercator = S2.chart(r'xi:(-oo,oo):\xi ze:(0,2*pi):\zeta')
xi,ze = var('xi ze')
_ = polar.transition_map(mercator, (log(tan(th/2)), ph))
identity = S2.identity_map()
identity.coord_functions(polar, mercator)
graph2D_mercator = Graphics()
for key in dict_params:
    sol = c.solve(solution_key='sol-'+key,
                  parameters_values=dict_params[key])
    interp = c.interpolate(solution_key='sol-'+key,
                           interpolation_key='interp-'+key)
    graph2D_mercator += c.plot_integrated(interpolation_key='interp-'+key,
                                    chart=mercator, thickness=2)
graph2D_mercator_coords = mercator.plot(chart=mercator,
                                        number_values=8, color='yellow')
sphinx_plot(graph2D_mercator + graph2D_mercator_coords)