/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.presentation;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.presentation.CodeStyleBoundedIntegerSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSelectSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSoftMarginsPresentation;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingPresentation {
    @NotNull
    protected String myFieldName;
    @NotNull
    protected String myUiName;
    protected static final Map<SettingsGroup, List<CodeStyleSettingPresentation>> BLANK_LINES_STANDARD_SETTINGS;
    protected static final Map<SettingsGroup, List<CodeStyleSettingPresentation>> SPACING_STANDARD_SETTINGS;
    protected static final Map<SettingsGroup, List<CodeStyleSettingPresentation>> WRAPPING_AND_BRACES_STANDARD_SETTINGS;
    protected static final Map<SettingsGroup, List<CodeStyleSettingPresentation>> INDENT_STANDARD_SETTINGS;

    public CodeStyleSettingPresentation(@NotNull String fieldName, @NotNull String uiName) {
        if (fieldName == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(0);
        }
        if (uiName == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(1);
        }
        this.myFieldName = fieldName;
        this.myUiName = uiName;
    }

    @NotNull
    public String getFieldName() {
        String string = this.myFieldName;
        if (string == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getUiName() {
        String string = this.myUiName;
        if (string == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setUiName(@NotNull String newName) {
        if (newName == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(4);
        }
        this.myUiName = newName;
    }

    @NotNull
    public String getValueUiName(@NotNull Object value) {
        if (value == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(5);
        }
        String string = value.toString();
        if (string == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean equals(Object o) {
        return o instanceof CodeStyleSettingPresentation && ((CodeStyleSettingPresentation)o).getFieldName().equals(this.getFieldName());
    }

    public int hashCode() {
        return this.myFieldName.hashCode();
    }

    protected static void putGroupTop(@NotNull Map<SettingsGroup, List<CodeStyleSettingPresentation>> result2, @NotNull String fieldName, @NotNull String uiName, int[] values, String[] valueUiNames) {
        if (result2 == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(7);
        }
        if (fieldName == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(8);
        }
        if (uiName == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(9);
        }
        result2.put(new SettingsGroup(null), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation(fieldName, uiName, values, valueUiNames)}));
    }

    @NotNull
    public static Map<SettingsGroup, List<CodeStyleSettingPresentation>> getStandardSettings(LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        switch (settingsType) {
            case BLANK_LINES_SETTINGS: {
                Map<SettingsGroup, List<CodeStyleSettingPresentation>> map = BLANK_LINES_STANDARD_SETTINGS;
                if (map == null) {
                    CodeStyleSettingPresentation.$$$reportNull$$$0(10);
                }
                return map;
            }
            case SPACING_SETTINGS: {
                Map<SettingsGroup, List<CodeStyleSettingPresentation>> map = SPACING_STANDARD_SETTINGS;
                if (map == null) {
                    CodeStyleSettingPresentation.$$$reportNull$$$0(11);
                }
                return map;
            }
            case WRAPPING_AND_BRACES_SETTINGS: {
                Map<SettingsGroup, List<CodeStyleSettingPresentation>> map = WRAPPING_AND_BRACES_STANDARD_SETTINGS;
                if (map == null) {
                    CodeStyleSettingPresentation.$$$reportNull$$$0(12);
                }
                return map;
            }
            case INDENT_SETTINGS: {
                Map<SettingsGroup, List<CodeStyleSettingPresentation>> map = INDENT_STANDARD_SETTINGS;
                if (map == null) {
                    CodeStyleSettingPresentation.$$$reportNull$$$0(13);
                }
                return map;
            }
        }
        LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap();
        if (linkedHashMap == null) {
            CodeStyleSettingPresentation.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    static {
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.BLANK_LINES_KEEP), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("KEEP_BLANK_LINES_IN_DECLARATIONS", ApplicationBundle.message("editbox.keep.blanklines.in.declarations", new Object[0])), new CodeStyleSettingPresentation("KEEP_BLANK_LINES_IN_CODE", ApplicationBundle.message("editbox.keep.blanklines.in.code", new Object[0])), new CodeStyleSettingPresentation("KEEP_BLANK_LINES_BEFORE_RBRACE", ApplicationBundle.message("editbox.keep.blanklines.before.rbrace", new Object[0])), new CodeStyleSettingPresentation("KEEP_BLANK_LINES_BETWEEN_PACKAGE_DECLARATION_AND_HEADER", ApplicationBundle.message("editbox.keep.blanklines.between.header.and.package", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.BLANK_LINES), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_PACKAGE", ApplicationBundle.message("editbox.blanklines.before.package.statement", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_PACKAGE", ApplicationBundle.message("editbox.blanklines.after.package.statement", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_IMPORTS", ApplicationBundle.message("editbox.blanklines.before.imports", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_IMPORTS", ApplicationBundle.message("editbox.blanklines.after.imports", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_CLASS", ApplicationBundle.message("editbox.blanklines.around.class", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_CLASS_HEADER", ApplicationBundle.message("editbox.blanklines.after.class.header", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_CLASS_END", ApplicationBundle.message("editbox.blanklines.before.class.end", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER", ApplicationBundle.message("editbox.blanklines.after.anonymous.class.header", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_FIELD_IN_INTERFACE", "Around field in interface:"), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_FIELD", ApplicationBundle.message("editbox.blanklines.around.field", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_METHOD_IN_INTERFACE", "Around method in interface:"), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_METHOD", ApplicationBundle.message("editbox.blanklines.around.method", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_METHOD_BODY", ApplicationBundle.message("editbox.blanklines.before.method.body", new Object[0]))}));
        BLANK_LINES_STANDARD_SETTINGS = Collections.unmodifiableMap(result2);
        result2 = ContainerUtil.newLinkedHashMap();
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_METHOD_PARENTHESES", ApplicationBundle.message("checkbox.spaces.method.declaration.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_METHOD_CALL_PARENTHESES", ApplicationBundle.message("checkbox.spaces.method.call.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_IF_PARENTHESES", ApplicationBundle.message("checkbox.spaces.if.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FOR_PARENTHESES", ApplicationBundle.message("checkbox.spaces.for.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_WHILE_PARENTHESES", ApplicationBundle.message("checkbox.spaces.while.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SWITCH_PARENTHESES", ApplicationBundle.message("checkbox.spaces.switch.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_TRY_PARENTHESES", ApplicationBundle.message("checkbox.spaces.try.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_CATCH_PARENTHESES", ApplicationBundle.message("checkbox.spaces.catch.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SYNCHRONIZED_PARENTHESES", ApplicationBundle.message("checkbox.spaces.synchronized.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ANOTATION_PARAMETER_LIST", ApplicationBundle.message("checkbox.spaces.annotation.parameters", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_AROUND_ASSIGNMENT_OPERATORS", ApplicationBundle.message("checkbox.spaces.assignment.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_LOGICAL_OPERATORS", ApplicationBundle.message("checkbox.spaces.logical.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_EQUALITY_OPERATORS", ApplicationBundle.message("checkbox.spaces.equality.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_RELATIONAL_OPERATORS", ApplicationBundle.message("checkbox.spaces.relational.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_BITWISE_OPERATORS", ApplicationBundle.message("checkbox.spaces.bitwise.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_ADDITIVE_OPERATORS", ApplicationBundle.message("checkbox.spaces.additive.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_MULTIPLICATIVE_OPERATORS", ApplicationBundle.message("checkbox.spaces.multiplicative.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_SHIFT_OPERATORS", ApplicationBundle.message("checkbox.spaces.shift.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_UNARY_OPERATOR", ApplicationBundle.message("checkbox.spaces.around.unary.operator", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_LAMBDA_ARROW", ApplicationBundle.message("checkbox.spaces.around.lambda.arrow", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_METHOD_REF_DBL_COLON", ApplicationBundle.message("checkbox.spaces.around.method.ref.dbl.colon.arrow", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_BEFORE_LEFT_BRACE), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_CLASS_LBRACE", ApplicationBundle.message("checkbox.spaces.class.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_METHOD_LBRACE", ApplicationBundle.message("checkbox.spaces.method.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_IF_LBRACE", ApplicationBundle.message("checkbox.spaces.if.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ELSE_LBRACE", ApplicationBundle.message("checkbox.spaces.else.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FOR_LBRACE", ApplicationBundle.message("checkbox.spaces.for.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_WHILE_LBRACE", ApplicationBundle.message("checkbox.spaces.while.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_DO_LBRACE", ApplicationBundle.message("checkbox.spaces.do.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SWITCH_LBRACE", ApplicationBundle.message("checkbox.spaces.switch.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_TRY_LBRACE", ApplicationBundle.message("checkbox.spaces.try.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_CATCH_LBRACE", ApplicationBundle.message("checkbox.spaces.catch.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FINALLY_LBRACE", ApplicationBundle.message("checkbox.spaces.finally.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SYNCHRONIZED_LBRACE", ApplicationBundle.message("checkbox.spaces.synchronized.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", ApplicationBundle.message("checkbox.spaces.array.initializer.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ANNOTATION_ARRAY_INITIALIZER_LBRACE", ApplicationBundle.message("checkbox.spaces.annotation.array.initializer.left.brace", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_BEFORE_KEYWORD), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_ELSE_KEYWORD", ApplicationBundle.message("checkbox.spaces.else.keyword", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_WHILE_KEYWORD", ApplicationBundle.message("checkbox.spaces.while.keyword", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_CATCH_KEYWORD", ApplicationBundle.message("checkbox.spaces.catch.keyword", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FINALLY_KEYWORD", ApplicationBundle.message("checkbox.spaces.finally.keyword", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_WITHIN), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_WITHIN_BRACES", ApplicationBundle.message("checkbox.spaces.within.braces", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_BRACKETS", ApplicationBundle.message("checkbox.spaces.within.brackets", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", ApplicationBundle.message("checkbox.spaces.within.array.initializer.braces", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES", ApplicationBundle.message("checkbox.spaces.within.empty.array.initializer.braces", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_PARENTHESES", ApplicationBundle.message("checkbox.spaces.within.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_METHOD_PARENTHESES", ApplicationBundle.message("checkbox.spaces.checkbox.spaces.method.declaration.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_EMPTY_METHOD_PARENTHESES", ApplicationBundle.message("checkbox.spaces.checkbox.spaces.empty.method.declaration.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_METHOD_CALL_PARENTHESES", ApplicationBundle.message("checkbox.spaces.checkbox.spaces.method.call.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES", ApplicationBundle.message("checkbox.spaces.checkbox.spaces.empty.method.call.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_IF_PARENTHESES", ApplicationBundle.message("checkbox.spaces.if.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_FOR_PARENTHESES", ApplicationBundle.message("checkbox.spaces.for.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_WHILE_PARENTHESES", ApplicationBundle.message("checkbox.spaces.while.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_SWITCH_PARENTHESES", ApplicationBundle.message("checkbox.spaces.switch.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_TRY_PARENTHESES", ApplicationBundle.message("checkbox.spaces.try.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_CATCH_PARENTHESES", ApplicationBundle.message("checkbox.spaces.catch.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_SYNCHRONIZED_PARENTHESES", ApplicationBundle.message("checkbox.spaces.synchronized.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_CAST_PARENTHESES", ApplicationBundle.message("checkbox.spaces.type.cast.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_ANNOTATION_PARENTHESES", ApplicationBundle.message("checkbox.spaces.annotation.parentheses", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_IN_TERNARY_OPERATOR), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_QUEST", ApplicationBundle.message("checkbox.spaces.before.question", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_QUEST", ApplicationBundle.message("checkbox.spaces.after.question", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_COLON", ApplicationBundle.message("checkbox.spaces.before.colon", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_COLON", ApplicationBundle.message("checkbox.spaces.after.colon", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_WITHIN_TYPE_ARGUMENTS), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS", ApplicationBundle.message("checkbox.spaces.after.comma", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_IN_TYPE_ARGUMENTS), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_TYPE_PARAMETER_LIST", ApplicationBundle.message("checkbox.spaces.before.opening.angle.bracket", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_IN_TYPE_PARAMETERS), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[0]));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.SPACES_OTHER), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_COMMA", ApplicationBundle.message("checkbox.spaces.before.comma", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_COMMA", ApplicationBundle.message("checkbox.spaces.after.comma", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SEMICOLON", ApplicationBundle.message("checkbox.spaces.before.semicolon", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_SEMICOLON", ApplicationBundle.message("checkbox.spaces.after.semicolon", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_TYPE_CAST", ApplicationBundle.message("checkbox.spaces.after.type.cast", new Object[0]))}));
        SPACING_STANDARD_SETTINGS = Collections.unmodifiableMap(result2);
        result2 = ContainerUtil.newLinkedHashMap();
        result2.put(new SettingsGroup(null), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleBoundedIntegerSettingPresentation("RIGHT_MARGIN", ApplicationBundle.message("editbox.right.margin.columns", new Object[0]), 0, 999, -1, ApplicationBundle.message("settings.code.style.default.general", new Object[0])), new CodeStyleSelectSettingPresentation("WRAP_ON_TYPING", ApplicationBundle.message("wrapping.wrap.on.typing", new Object[0]), CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES, CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS), new CodeStyleSoftMarginsPresentation()}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_KEEP), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("KEEP_LINE_BREAKS", ApplicationBundle.message("wrapping.keep.line.breaks", new Object[0])), new CodeStyleSettingPresentation("KEEP_FIRST_COLUMN_COMMENT", ApplicationBundle.message("wrapping.keep.comment.at.first.column", new Object[0])), new CodeStyleSettingPresentation("KEEP_CONTROL_STATEMENT_IN_ONE_LINE", ApplicationBundle.message("checkbox.keep.when.reformatting.control.statement.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.multiple.expressions.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_BLOCKS_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.simple.blocks.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_METHODS_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.simple.methods.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.simple.lambdas.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_CLASSES_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.simple.classes.in.one.line", new Object[0]))}));
        result2.put(new SettingsGroup(null), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("WRAP_LONG_LINES", ApplicationBundle.message("wrapping.long.lines", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_COMMENTS), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("WRAP_COMMENTS", ApplicationBundle.message("wrapping.comments.wrap.at.right.margin", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_BRACES), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation("CLASS_BRACE_STYLE", ApplicationBundle.message("wrapping.brace.placement.class.declaration", new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, CodeStyleSettingsCustomizable.BRACE_PLACEMENT_OPTIONS), new CodeStyleSelectSettingPresentation("METHOD_BRACE_STYLE", ApplicationBundle.message("wrapping.brace.placement.method.declaration", new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, CodeStyleSettingsCustomizable.BRACE_PLACEMENT_OPTIONS), new CodeStyleSelectSettingPresentation("LAMBDA_BRACE_STYLE", ApplicationBundle.message("wrapping.brace.placement.lambda", new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, CodeStyleSettingsCustomizable.BRACE_PLACEMENT_OPTIONS), new CodeStyleSelectSettingPresentation("BRACE_STYLE", ApplicationBundle.message("wrapping.brace.placement.other", new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, CodeStyleSettingsCustomizable.BRACE_PLACEMENT_OPTIONS)}));
        CodeStyleSettingPresentation.putGroupTop(result2, "EXTENDS_LIST_WRAP", CodeStyleSettingsCustomizable.WRAPPING_EXTENDS_LIST, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_EXTENDS_LIST), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_EXTENDS_LIST", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "EXTENDS_KEYWORD_WRAP", CodeStyleSettingsCustomizable.WRAPPING_EXTENDS_KEYWORD, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON, CodeStyleSettingsCustomizable.WRAP_OPTIONS_FOR_SINGLETON);
        CodeStyleSettingPresentation.putGroupTop(result2, "THROWS_LIST_WRAP", CodeStyleSettingsCustomizable.WRAPPING_THROWS_LIST, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_THROWS_LIST), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_THROWS_LIST", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("ALIGN_THROWS_KEYWORD", ApplicationBundle.message("wrapping.align.throws.keyword", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "THROWS_KEYWORD_WRAP", CodeStyleSettingsCustomizable.WRAPPING_THROWS_KEYWORD, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON, CodeStyleSettingsCustomizable.WRAP_OPTIONS_FOR_SINGLETON);
        CodeStyleSettingPresentation.putGroupTop(result2, "METHOD_PARAMETERS_WRAP", CodeStyleSettingsCustomizable.WRAPPING_METHOD_PARAMETERS, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_METHOD_PARAMETERS), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_PARAMETERS", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "CALL_PARAMETERS_WRAP", CodeStyleSettingsCustomizable.WRAPPING_METHOD_ARGUMENTS_WRAPPING, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_METHOD_ARGUMENTS_WRAPPING), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_PARAMETERS_IN_CALLS", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("PREFER_PARAMETERS_WRAP", ApplicationBundle.message("wrapping.take.priority.over.call.chain.wrapping", new Object[0])), new CodeStyleSettingPresentation("CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_METHOD_PARENTHESES), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_METHOD_BRACKETS", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "METHOD_CALL_CHAIN_WRAP", CodeStyleSettingsCustomizable.WRAPPING_CALL_CHAIN, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_CALL_CHAIN), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("WRAP_FIRST_METHOD_IN_CALL_CHAIN", ApplicationBundle.message("wrapping.chained.method.call.first.on.new.line", new Object[0])), new CodeStyleSettingPresentation("ALIGN_MULTILINE_CHAINED_METHODS", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_IF_STATEMENT), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation("IF_BRACE_FORCE", ApplicationBundle.message("wrapping.force.braces", new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, CodeStyleSettingsCustomizable.BRACE_OPTIONS), new CodeStyleSettingPresentation("ELSE_ON_NEW_LINE", ApplicationBundle.message("wrapping.else.on.new.line", new Object[0])), new CodeStyleSettingPresentation("SPECIAL_ELSE_IF_TREATMENT", ApplicationBundle.message("wrapping.special.else.if.braces.treatment", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "FOR_STATEMENT_WRAP", CodeStyleSettingsCustomizable.WRAPPING_FOR_STATEMENT, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_FOR_STATEMENT), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_FOR", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("FOR_STATEMENT_LPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("FOR_STATEMENT_RPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0])), new CodeStyleSelectSettingPresentation("FOR_BRACE_FORCE", ApplicationBundle.message("wrapping.force.braces", new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, CodeStyleSettingsCustomizable.BRACE_OPTIONS)}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_WHILE_STATEMENT), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation("WHILE_BRACE_FORCE", ApplicationBundle.message("wrapping.force.braces", new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, CodeStyleSettingsCustomizable.BRACE_OPTIONS)}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_DOWHILE_STATEMENT), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation("DOWHILE_BRACE_FORCE", ApplicationBundle.message("wrapping.force.braces", new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, CodeStyleSettingsCustomizable.BRACE_OPTIONS), new CodeStyleSettingPresentation("WHILE_ON_NEW_LINE", ApplicationBundle.message("wrapping.while.on.new.line", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_SWITCH_STATEMENT), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("INDENT_CASE_FROM_SWITCH", ApplicationBundle.message("wrapping.indent.case.from.switch", new Object[0])), new CodeStyleSettingPresentation("INDENT_BREAK_FROM_CASE", ApplicationBundle.message("wrapping.indent.break.from.case", new Object[0])), new CodeStyleSettingPresentation("CASE_STATEMENT_ON_NEW_LINE", ApplicationBundle.message("wrapping.case.statements.on.one.line", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "RESOURCE_LIST_WRAP", CodeStyleSettingsCustomizable.WRAPPING_TRY_RESOURCE_LIST, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_TRY_RESOURCE_LIST), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_RESOURCES", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("RESOURCE_LIST_LPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("RESOURCE_LIST_RPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_TRY_STATEMENT), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("CATCH_ON_NEW_LINE", ApplicationBundle.message("wrapping.catch.on.new.line", new Object[0])), new CodeStyleSettingPresentation("FINALLY_ON_NEW_LINE", ApplicationBundle.message("wrapping.finally.on.new.line", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "BINARY_OPERATION_WRAP", CodeStyleSettingsCustomizable.WRAPPING_BINARY_OPERATION, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_BINARY_OPERATION), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_BINARY_OPERATION", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("BINARY_OPERATION_SIGN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.operation.sign.on.next.line", new Object[0])), new CodeStyleSettingPresentation("ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION", ApplicationBundle.message("wrapping.align.parenthesised.when.multiline", new Object[0])), new CodeStyleSettingPresentation("PARENTHESES_EXPRESSION_LPAREN_WRAP", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("PARENTHESES_EXPRESSION_RPAREN_WRAP", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "ASSIGNMENT_WRAP", CodeStyleSettingsCustomizable.WRAPPING_ASSIGNMENT, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_ASSIGNMENT), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_ASSIGNMENT", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.assignment.sign.on.next.line", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_FIELDS_VARIABLES_GROUPS), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_GROUP_FIELD_DECLARATIONS", ApplicationBundle.message("wrapping.align.fields.in.columns", new Object[0])), new CodeStyleSettingPresentation("ALIGN_CONSECUTIVE_VARIABLE_DECLARATIONS", ApplicationBundle.message("wrapping.align.variables.in.columns", new Object[0])), new CodeStyleSettingPresentation("ALIGN_SUBSEQUENT_SIMPLE_METHODS", ApplicationBundle.message("wrapping.align.simple.methods.in.columns", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "TERNARY_OPERATION_WRAP", CodeStyleSettingsCustomizable.WRAPPING_TERNARY_OPERATION, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_TERNARY_OPERATION), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_TERNARY_OPERATION", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("TERNARY_OPERATION_SIGNS_ON_NEXT_LINE", ApplicationBundle.message("wrapping.quest.and.colon.signs.on.next.line", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "ARRAY_INITIALIZER_WRAP", CodeStyleSettingsCustomizable.WRAPPING_ARRAY_INITIALIZER, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_ARRAY_INITIALIZER), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lbrace", new Object[0])), new CodeStyleSettingPresentation("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rbrace.on.new.line", new Object[0]))}));
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_MODIFIER_LIST), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("MODIFIER_LIST_WRAP", ApplicationBundle.message("wrapping.after.modifier.list", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "ASSERT_STATEMENT_WRAP", CodeStyleSettingsCustomizable.WRAPPING_ASSERT_STATEMENT, CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        result2.put(new SettingsGroup(CodeStyleSettingsCustomizable.WRAPPING_ASSERT_STATEMENT), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ASSERT_STATEMENT_COLON_ON_NEXT_LINE", ApplicationBundle.message("wrapping.colon.signs.on.next.line", new Object[0]))}));
        CodeStyleSettingPresentation.putGroupTop(result2, "ENUM_CONSTANTS_WRAP", ApplicationBundle.message("wrapping.enum.constants", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        CodeStyleSettingPresentation.putGroupTop(result2, "CLASS_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.classes.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        CodeStyleSettingPresentation.putGroupTop(result2, "METHOD_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.methods.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        CodeStyleSettingPresentation.putGroupTop(result2, "FIELD_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.fields.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        CodeStyleSettingPresentation.putGroupTop(result2, "PARAMETER_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.parameters.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        CodeStyleSettingPresentation.putGroupTop(result2, "VARIABLE_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.local.variables.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, CodeStyleSettingsCustomizable.WRAP_OPTIONS);
        WRAPPING_AND_BRACES_STANDARD_SETTINGS = Collections.unmodifiableMap(result2);
        result2 = ContainerUtil.newLinkedHashMap();
        result2.put(new SettingsGroup(null), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("INDENT_SIZE", ApplicationBundle.message("editbox.indent.indent", new Object[0]))}));
        result2.put(new SettingsGroup(null), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("CONTINUATION_INDENT_SIZE", ApplicationBundle.message("editbox.indent.continuation.indent", new Object[0]))}));
        result2.put(new SettingsGroup(null), ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("TAB_SIZE", ApplicationBundle.message("editbox.indent.tab.size", new Object[0]))}));
        INDENT_STANDARD_SETTINGS = Collections.unmodifiableMap(result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/presentation/CodeStyleSettingPresentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/presentation/CodeStyleSettingPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueUiName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setUiName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueUiName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putGroupTop";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SettingsGroup {
        @Nullable
        public final String name;

        public SettingsGroup(@Nullable String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o instanceof SettingsGroup) {
                SettingsGroup other = (SettingsGroup)o;
                return this.name != null && this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name == null ? 0 : this.name.hashCode();
        }

        public boolean isNull() {
            return this.name == null;
        }
    }
}

