/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.PythonConfigurationFactoryBase;
import com.jetbrains.python.testing.PyTestLegacyInteropKt;
import com.jetbrains.python.testing.PyTestsSharedKt;
import com.jetbrains.python.testing.doctest.PythonDocTestRunConfiguration;
import com.jetbrains.python.testing.nosetestLegacy.PythonNoseTestRunConfiguration;
import com.jetbrains.python.testing.pytestLegacy.PyTestRunConfiguration;
import com.jetbrains.python.testing.unittestLegacy.PythonUnitTestRunConfiguration;
import icons.PythonIcons;
import org.jetbrains.annotations.NotNull;

public final class PythonTestConfigurationType
extends ConfigurationTypeBase {
    public static final String ID = "tests";
    public final PythonConfigurationFactoryBase PY_DOCTEST_FACTORY = new PythonDocTestConfigurationFactory((ConfigurationType)this);
    public final PythonConfigurationFactoryBase LEGACY_UNITTEST_FACTORY = new PythonLegacyUnitTestConfigurationFactory((ConfigurationType)this);
    public final PythonConfigurationFactoryBase LEGACY_NOSETEST_FACTORY = new PythonLegacyNoseTestConfigurationFactory((ConfigurationType)this);
    public final PythonConfigurationFactoryBase LEGACY_PYTEST_FACTORY = new PythonLegacyPyTestConfigurationFactory((ConfigurationType)this);
    private final NotNullLazyValue<ConfigurationFactory[]> myFactories = NotNullLazyValue.createValue(() -> {
        if (PyTestLegacyInteropKt.isNewTestsModeEnabled()) {
            for (PythonConfigurationFactoryBase factory : PyTestsSharedKt.getFactories()) {
                this.addFactory(factory);
            }
        } else {
            this.addFactory(this.LEGACY_UNITTEST_FACTORY);
            this.addFactory(this.LEGACY_NOSETEST_FACTORY);
            this.addFactory(this.LEGACY_PYTEST_FACTORY);
        }
        this.addFactory(this.PY_DOCTEST_FACTORY);
        return super.getConfigurationFactories();
    });

    public static PythonTestConfigurationType getInstance() {
        return (PythonTestConfigurationType)ConfigurationTypeUtil.findConfigurationType(PythonTestConfigurationType.class);
    }

    public PythonTestConfigurationType() {
        super(ID, PyBundle.message("runcfg.test.display_name", new Object[0]), PyBundle.message("runcfg.test.description", new Object[0]), NotNullLazyValue.createValue(() -> PythonIcons.Python.PythonTests));
    }

    @NotNull
    public ConfigurationFactory[] getConfigurationFactories() {
        ConfigurationFactory[] configurationFactoryArray = (ConfigurationFactory[])this.myFactories.getValue();
        if (configurationFactoryArray == null) {
            PythonTestConfigurationType.$$$reportNull$$$0(0);
        }
        return configurationFactoryArray;
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.tests";
    }

    @NotNull
    public String getTag() {
        if ("pythonTest" == null) {
            PythonTestConfigurationType.$$$reportNull$$$0(1);
        }
        return "pythonTest";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/testing/PythonTestConfigurationType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactories";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PythonLegacyNoseTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonLegacyNoseTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                PythonLegacyNoseTestConfigurationFactory.$$$reportNull$$$0(0);
            }
            PythonNoseTestRunConfiguration pythonNoseTestRunConfiguration = new PythonNoseTestRunConfiguration(project, this);
            if (pythonNoseTestRunConfiguration == null) {
                PythonLegacyNoseTestConfigurationFactory.$$$reportNull$$$0(1);
            }
            return pythonNoseTestRunConfiguration;
        }

        @NotNull
        public String getName() {
            String string = PyBundle.message("runcfg.nosetests.display_name", new Object[0]);
            if (string == null) {
                PythonLegacyNoseTestConfigurationFactory.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/testing/PythonTestConfigurationType$PythonLegacyNoseTestConfigurationFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/testing/PythonTestConfigurationType$PythonLegacyNoseTestConfigurationFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PythonLegacyPyTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonLegacyPyTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                PythonLegacyPyTestConfigurationFactory.$$$reportNull$$$0(0);
            }
            PyTestRunConfiguration pyTestRunConfiguration = new PyTestRunConfiguration(project, this);
            if (pyTestRunConfiguration == null) {
                PythonLegacyPyTestConfigurationFactory.$$$reportNull$$$0(1);
            }
            return pyTestRunConfiguration;
        }

        @NotNull
        public String getName() {
            String string = PyBundle.message("runcfg.pytest.display_name", new Object[0]);
            if (string == null) {
                PythonLegacyPyTestConfigurationFactory.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/testing/PythonTestConfigurationType$PythonLegacyPyTestConfigurationFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/testing/PythonTestConfigurationType$PythonLegacyPyTestConfigurationFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PythonDocTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonDocTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                PythonDocTestConfigurationFactory.$$$reportNull$$$0(0);
            }
            PythonDocTestRunConfiguration pythonDocTestRunConfiguration = new PythonDocTestRunConfiguration(project, this);
            if (pythonDocTestRunConfiguration == null) {
                PythonDocTestConfigurationFactory.$$$reportNull$$$0(1);
            }
            return pythonDocTestRunConfiguration;
        }

        @NotNull
        public String getName() {
            String string = PyBundle.message("runcfg.doctest.display_name", new Object[0]);
            if (string == null) {
                PythonDocTestConfigurationFactory.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/testing/PythonTestConfigurationType$PythonDocTestConfigurationFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/testing/PythonTestConfigurationType$PythonDocTestConfigurationFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PythonLegacyUnitTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonLegacyUnitTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                PythonLegacyUnitTestConfigurationFactory.$$$reportNull$$$0(0);
            }
            PythonUnitTestRunConfiguration pythonUnitTestRunConfiguration = new PythonUnitTestRunConfiguration(project, this);
            if (pythonUnitTestRunConfiguration == null) {
                PythonLegacyUnitTestConfigurationFactory.$$$reportNull$$$0(1);
            }
            return pythonUnitTestRunConfiguration;
        }

        @NotNull
        public String getName() {
            String string = PyBundle.message("runcfg.unittest.display_name", new Object[0]);
            if (string == null) {
                PythonLegacyUnitTestConfigurationFactory.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/testing/PythonTestConfigurationType$PythonLegacyUnitTestConfigurationFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/testing/PythonTestConfigurationType$PythonLegacyUnitTestConfigurationFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

