/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsExecutablePathSelector {
    private final JPanel myMainPanel;
    private final TextFieldWithBrowseButton myPathSelector;
    private final JButton myTestButton;
    private final JBCheckBox myProjectPathCheckbox;
    @Nullable
    private String mySavedPath;
    private String myAutoDetectedPath;

    public VcsExecutablePathSelector(@NotNull Consumer<String> executableTester) {
        if (executableTester == null) {
            VcsExecutablePathSelector.$$$reportNull$$$0(0);
        }
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((int)10, (int)0);
        this.myPathSelector = new TextFieldWithBrowseButton((JTextField)new JBTextField(10));
        this.myPathSelector.addBrowseFolderListener(VcsBundle.getString((String)"executable.select.title"), null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        panel2.addToCenter((Component)this.myPathSelector);
        this.myTestButton = new JButton(VcsBundle.getString((String)"executable.test"));
        this.myTestButton.addActionListener(e -> executableTester.accept((String)ObjectUtils.notNull((Object)this.getCurrentPath(), (Object)this.myAutoDetectedPath)));
        panel2.addToRight((Component)this.myTestButton);
        this.myProjectPathCheckbox = new JBCheckBox(VcsBundle.getString((String)"executable.project.override"));
        this.myProjectPathCheckbox.addActionListener(e -> this.handleProjectOverrideStateChanged());
        this.myMainPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)panel2).withLabel(VcsBundle.getString((String)"executable.select.label"))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myProjectPathCheckbox)).createPanel();
    }

    private void handleProjectOverrideStateChanged() {
        if (this.myProjectPathCheckbox.isSelected()) {
            this.mySavedPath = this.getCurrentPath();
        } else if (!Objects.equals(this.getCurrentPath(), this.mySavedPath)) {
            switch (Messages.showYesNoCancelDialog((Component)this.myMainPanel, (String)VcsBundle.getString((String)"executable.project.override.reset.message"), (String)VcsBundle.getString((String)"executable.project.override.reset.title"), (String)VcsBundle.getString((String)"executable.project.override.reset.globalize"), (String)VcsBundle.getString((String)"executable.project.override.reset.revert"), (String)Messages.CANCEL_BUTTON, null)) {
                case 1: {
                    this.myPathSelector.setText(this.mySavedPath);
                    break;
                }
                case 2: {
                    this.myProjectPathCheckbox.setSelected(true);
                }
            }
        }
    }

    @Nullable
    public String getCurrentPath() {
        return StringUtil.nullize((String)this.myPathSelector.getText().trim());
    }

    public boolean isOverridden() {
        return this.myProjectPathCheckbox.isSelected();
    }

    public void reset(@Nullable String globalPath, boolean pathOverriddenForProject, @Nullable String projectPath, @NotNull String autoDetectedPath) {
        if (autoDetectedPath == null) {
            VcsExecutablePathSelector.$$$reportNull$$$0(1);
        }
        this.myAutoDetectedPath = autoDetectedPath;
        ((JBTextField)this.myPathSelector.getTextField()).getEmptyText().setText("Auto-detected: " + this.myAutoDetectedPath);
        this.myProjectPathCheckbox.setSelected(pathOverriddenForProject);
        if (pathOverriddenForProject) {
            this.mySavedPath = globalPath;
            this.myPathSelector.setText(projectPath);
        } else {
            this.myPathSelector.setText(globalPath);
        }
    }

    public boolean isModified(@Nullable String globalPath, boolean overridden, @Nullable String projectPath) {
        if (this.myProjectPathCheckbox.isSelected() != overridden) {
            return true;
        }
        if (this.myProjectPathCheckbox.isSelected()) {
            return !Objects.equals(this.getCurrentPath(), projectPath);
        }
        return !Objects.equals(this.getCurrentPath(), globalPath);
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            VcsExecutablePathSelector.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableTester";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoDetectedPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/VcsExecutablePathSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/VcsExecutablePathSelector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

