/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class WinIntelliJButtonUI
extends DarculaButtonUI {
    static final float DISABLED_ALPHA_LEVEL = 0.47f;
    private final PropertyChangeListener helpButtonListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof AbstractButton && UIUtil.isHelpButton((Component)((JComponent)source))) {
                ((AbstractButton)source).setOpaque(false);
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        ((AbstractButton)c).setRolloverEnabled(true);
        return new WinIntelliJButtonUI();
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("JButton.buttonType", this.helpButtonListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener("JButton.buttonType", this.helpButtonListener);
        super.uninstallListeners(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        if (UIUtil.isHelpButton((Component)c)) {
            Icon help = LafIconLookup.getIcon((String)"winHelp");
            Insets i = c.getInsets();
            help.paintIcon(c, g, i.left, i.top + (c.getHeight() - help.getIconHeight()) / 2);
        } else if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                Rectangle r = new Rectangle(c.getSize());
                Container parent = c.getParent();
                if (c.isOpaque() && parent != null) {
                    g2.setColor(parent.getBackground());
                    g2.fill(r);
                }
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2));
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                if (!b.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
                }
                g2.setColor(WinIntelliJButtonUI.getBackgroundColor(b));
                g2.fill(r);
                this.paintContents(g2, b);
            }
            finally {
                g2.dispose();
            }
        }
    }

    @Override
    protected void modifyViewRect(AbstractButton b, Rectangle rect) {
        super.modifyViewRect(b, rect);
        rect.y -= JBUI.scale((int)1);
    }

    @Override
    protected int getMinimumHeight() {
        return WinIntelliJTextBorder.MINIMUM_HEIGHT.get();
    }

    @Override
    protected void setupDefaultButton(JButton button) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setColor(UIManager.getColor("Button.disabledText"));
            UIUtilities.drawStringUnderlineCharAt((JComponent)c, (Graphics)g2, (String)text, (int)-1, (int)(textRect.x + this.getTextShiftOffset()), (int)(textRect.y + metrics.getAscent() + this.getTextShiftOffset()));
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected Color getButtonTextColor(AbstractButton button) {
        boolean focusedStyle;
        Color focusedColor = (Color)button.getClientProperty("JButton.focusedTextColor");
        Color textColor = (Color)button.getClientProperty("JButton.textColor");
        boolean bl = focusedStyle = button.hasFocus() || button.getModel().isRollover();
        if (focusedStyle && focusedColor != null) {
            return focusedColor;
        }
        if (!focusedStyle && textColor != null) {
            return textColor;
        }
        return DarculaUIUtil.getButtonTextColor(button);
    }

    private static Color getBackgroundColor(AbstractButton b) {
        ButtonModel bm = b.getModel();
        Color focusedColor = (Color)b.getClientProperty("JButton.focusedBackgroundColor");
        if (bm.isPressed()) {
            return focusedColor != null ? focusedColor : UIManager.getColor("Button.intellij.native.pressedBackgroundColor");
        }
        if (b.hasFocus() || bm.isRollover()) {
            return focusedColor != null ? focusedColor : UIManager.getColor("Button.intellij.native.focusedBackgroundColor");
        }
        Color backgroundColor = (Color)b.getClientProperty("JButton.backgroundColor");
        return backgroundColor != null ? backgroundColor : b.getBackground();
    }
}

