/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.PsiElementsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassAndFileEqualityProvider
implements SEResultsEqualityProvider {
    @Override
    @NotNull
    public SEResultsEqualityProvider.Action compareItems(@NotNull SESearcher.ElementInfo newItemInfo, @NotNull SESearcher.ElementInfo alreadyFoundItemInfo) {
        if (newItemInfo == null) {
            ClassAndFileEqualityProvider.$$$reportNull$$$0(0);
        }
        if (alreadyFoundItemInfo == null) {
            ClassAndFileEqualityProvider.$$$reportNull$$$0(1);
        }
        PsiElement newElementPsi = PsiElementsEqualityProvider.toPsi(newItemInfo.getElement());
        PsiElement alreadyFoundPsi = PsiElementsEqualityProvider.toPsi(alreadyFoundItemInfo.getElement());
        if (newElementPsi == null || alreadyFoundPsi == null) {
            SEResultsEqualityProvider.Action action = SEResultsEqualityProvider.Action.DO_NOTHING;
            if (action == null) {
                ClassAndFileEqualityProvider.$$$reportNull$$$0(2);
            }
            return action;
        }
        if (ClassAndFileEqualityProvider.isClassAndFile(newItemInfo, alreadyFoundItemInfo) && ClassAndFileEqualityProvider.isSameFile(newElementPsi, alreadyFoundPsi)) {
            SEResultsEqualityProvider.Action action = newItemInfo.priority > alreadyFoundItemInfo.priority ? SEResultsEqualityProvider.Action.REPLACE : SEResultsEqualityProvider.Action.SKIP;
            if (action == null) {
                ClassAndFileEqualityProvider.$$$reportNull$$$0(3);
            }
            return action;
        }
        SEResultsEqualityProvider.Action action = SEResultsEqualityProvider.Action.DO_NOTHING;
        if (action == null) {
            ClassAndFileEqualityProvider.$$$reportNull$$$0(4);
        }
        return action;
    }

    private static boolean isClassAndFile(@NotNull SESearcher.ElementInfo newItemInfo, @NotNull SESearcher.ElementInfo alreadyFoundItemInfo) {
        if (newItemInfo == null) {
            ClassAndFileEqualityProvider.$$$reportNull$$$0(5);
        }
        if (alreadyFoundItemInfo == null) {
            ClassAndFileEqualityProvider.$$$reportNull$$$0(6);
        }
        SearchEverywhereContributor<?> c1 = newItemInfo.getContributor();
        SearchEverywhereContributor<?> c2 = alreadyFoundItemInfo.getContributor();
        return c1 instanceof ClassSearchEverywhereContributor && c2 instanceof FileSearchEverywhereContributor || c2 instanceof ClassSearchEverywhereContributor && c1 instanceof FileSearchEverywhereContributor;
    }

    private static boolean isSameFile(@NotNull PsiElement newItem, @NotNull PsiElement alreadyFound) {
        if (newItem == null) {
            ClassAndFileEqualityProvider.$$$reportNull$$$0(7);
        }
        if (alreadyFound == null) {
            ClassAndFileEqualityProvider.$$$reportNull$$$0(8);
        }
        VirtualFile newItemFile = ClassAndFileEqualityProvider.convertToFileIsPossible(newItem);
        VirtualFile foundItemFile = ClassAndFileEqualityProvider.convertToFileIsPossible(alreadyFound);
        return newItemFile != null && newItemFile.equals(foundItemFile);
    }

    @Nullable
    private static VirtualFile convertToFileIsPossible(@NotNull PsiElement element) {
        if (element == null) {
            ClassAndFileEqualityProvider.$$$reportNull$$$0(9);
        }
        if (element instanceof VirtualFile) {
            return (VirtualFile)element;
        }
        if (element instanceof PsiFile) {
            return ((PsiFile)element).getVirtualFile();
        }
        if (element instanceof PsiDirectory) {
            return ((PsiDirectory)element).getVirtualFile();
        }
        if (element instanceof PsiNamedElement) {
            String name = ((PsiNamedElement)element).getName();
            VirtualFile virtualFile = SearchEverywhereClassifier.EP_Manager.getVirtualFile(element);
            if (virtualFile != null && StringUtil.equals((CharSequence)name, (CharSequence)virtualFile.getNameWithoutExtension())) {
                return virtualFile;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItemInfo";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyFoundItemInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ClassAndFileEqualityProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyFound";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ClassAndFileEqualityProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "compareItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareItems";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isClassAndFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSameFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertToFileIsPossible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

