/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Language;
import processing.app.Platform;
import processing.app.ui.Editor;

public class Messages {
    public static void showMessage(String title, String message) {
        if (title == null) {
            title = "Message";
        }
        if (Base.isCommandLine()) {
            System.out.println(String.valueOf(title) + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 1);
        }
    }

    public static void showWarning(String title, String message) {
        Messages.showWarning(title, message, null);
    }

    public static void showWarning(String title, String message, Throwable e) {
        if (title == null) {
            title = "Warning";
        }
        if (Base.isCommandLine()) {
            System.out.println(String.valueOf(title) + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 2);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void showWarningTiered(String title, String primary, String secondary, Throwable e) {
        if (title == null) {
            title = "Warning";
        }
        String message = String.valueOf(primary) + "\n" + secondary;
        if (Base.isCommandLine()) {
            System.out.println(String.valueOf(title) + ": " + message);
        } else if (!Platform.isMacOS()) {
            JOptionPane.showMessageDialog(new JFrame(), "<html><body><b>" + primary + "</b>" + "<br>" + secondary, title, 2);
        } else {
            JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>" + primary + "</b>" + "<p>" + secondary + "</p>", 2);
            JDialog dialog = pane.createDialog(new JFrame(), null);
            dialog.setVisible(true);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void showError(String title, String message, Throwable e) {
        if (title == null) {
            title = "Error";
        }
        if (Base.isCommandLine()) {
            System.err.println(String.valueOf(title) + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 0);
        }
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public static void showTrace(String title, String message, Throwable t, boolean fatal) {
        if (title == null) {
            String string = title = fatal ? "Error" : "Warning";
        }
        if (Base.isCommandLine()) {
            System.err.println(String.valueOf(title) + ": " + message);
            if (t != null) {
                t.printStackTrace();
            }
        } else {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            message = ("<html>" + message + "<br/><font size=2><br/>" + sw + "</html>").replaceAll("\n", "<br/>");
            JOptionPane.showMessageDialog(new Frame(), message, title, fatal ? 0 : 2);
            if (fatal) {
                System.exit(1);
            }
        }
    }

    public static int showYesNoCancelQuestion(Editor editor, String title, String primary, String secondary) {
        if (!Platform.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(null, String.valueOf(primary) + "\n" + secondary, title, 1, 3);
            return result;
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>" + Language.text("save.title") + "</b>" + "<p>" + Language.text("save.hint") + "</p>", 3);
        Object[] options = new String[]{Language.text("save.btn.save"), Language.text("prompt.cancel"), Language.text("save.btn.dont_save")};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", 2);
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 2;
        }
        if (result == options[2]) {
            return 1;
        }
        return -1;
    }

    public static int showYesNoQuestion(Frame editor, String title, String primary, String secondary) {
        if (!Platform.isMacOS()) {
            return JOptionPane.showConfirmDialog(editor, "<html><body><b>" + primary + "</b>" + "<br>" + secondary, title, 0, 3);
        }
        int result = Messages.showCustomQuestion(editor, title, primary, secondary, 0, "Yes", "No");
        if (result == 0) {
            return 0;
        }
        if (result == 1) {
            return 1;
        }
        return -1;
    }

    public static int showCustomQuestion(Frame editor, String title, String primary, String secondary, int highlight, String ... options) {
        if (!Platform.isMacOS()) {
            return JOptionPane.showOptionDialog(editor, "<html><body><b>" + primary + "</b><br>" + secondary, title, -1, 3, null, options, options[highlight]);
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>" + primary + "</b>" + "<p>" + secondary, 3);
        pane.setOptions(options);
        pane.setInitialValue(options[highlight]);
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        int i = 0;
        while (i < options.length) {
            if (result != null && result.equals(options[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void log(Object from, String message) {
        if (Base.DEBUG) {
            System.out.println(String.valueOf(from.getClass().getName()) + ": " + message);
        }
    }

    public static void log(String message) {
        if (Base.DEBUG) {
            System.out.println(message);
        }
    }

    public static void logf(String message, Object ... args) {
        if (Base.DEBUG) {
            System.out.println(String.format(message, args));
        }
    }

    public static void loge(String message, Throwable e) {
        if (Base.DEBUG) {
            if (message != null) {
                System.err.println(message);
            }
            e.printStackTrace();
        }
    }

    public static void loge(String message) {
        if (Base.DEBUG) {
            System.err.println(message);
        }
    }
}

