#!/usr/bin/env node
'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var fs = _interopDefault(require('fs'));
var os = _interopDefault(require('os'));
var path = _interopDefault(require('path'));
var assert = _interopDefault(require('assert'));
var util = _interopDefault(require('util'));
var events = _interopDefault(require('events'));
var thirdParty = require('./third-party');
var thirdParty__default = thirdParty['default'];
var readline = _interopDefault(require('readline'));

var name = "prettier";
var version$1 = "1.18.2";
var description = "Prettier is an opinionated code formatter";
var bin = {
  "prettier": "./bin/prettier.js"
};
var repository = "prettier/prettier";
var homepage = "https://prettier.io";
var author = "James Long";
var license = "MIT";
var main = "./index.js";
var engines = {
  "node": ">=6"
};
var dependencies = {
  "@angular/compiler": "7.2.9",
  "@babel/code-frame": "7.0.0",
  "@babel/parser": "7.2.0",
  "@glimmer/syntax": "0.38.4",
  "@iarna/toml": "2.2.3",
  "@typescript-eslint/typescript-estree": "1.6.0",
  "angular-estree-parser": "1.1.5",
  "angular-html-parser": "1.2.0",
  "camelcase": "4.1.0",
  "chalk": "2.1.0",
  "cjk-regex": "2.0.0",
  "cosmiconfig": "5.0.7",
  "dashify": "0.2.2",
  "dedent": "0.7.0",
  "diff": "3.2.0",
  "editorconfig": "0.15.2",
  "editorconfig-to-prettier": "0.1.1",
  "escape-string-regexp": "1.0.5",
  "esutils": "2.0.2",
  "find-parent-dir": "0.3.0",
  "find-project-root": "1.1.1",
  "flow-parser": "0.84.0",
  "get-stream": "3.0.0",
  "globby": "6.1.0",
  "graphql": "14.2.0",
  "html-element-attributes": "2.0.0",
  "html-styles": "1.0.0",
  "html-tag-names": "1.1.2",
  "ignore": "4.0.6",
  "is-ci": "2.0.0",
  "jest-docblock": "23.2.0",
  "json-stable-stringify": "1.0.1",
  "leven": "2.1.0",
  "lines-and-columns": "1.1.6",
  "linguist-languages": "6.2.1-dev.20180706",
  "lodash.uniqby": "4.7.0",
  "mem": "1.1.0",
  "minimatch": "3.0.4",
  "minimist": "1.2.0",
  "n-readlines": "1.0.0",
  "normalize-path": "3.0.0",
  "parse-srcset": "ikatyang/parse-srcset#54eb9c1cb21db5c62b4d0e275d7249516df6f0ee",
  "postcss-less": "1.1.5",
  "postcss-media-query-parser": "0.2.3",
  "postcss-scss": "2.0.0",
  "postcss-selector-parser": "2.2.3",
  "postcss-values-parser": "1.5.0",
  "regexp-util": "1.2.2",
  "remark-math": "1.0.4",
  "remark-parse": "5.0.0",
  "resolve": "1.5.0",
  "semver": "5.4.1",
  "string-width": "3.0.0",
  "typescript": "3.4.1",
  "unicode-regex": "2.0.0",
  "unified": "6.1.6",
  "vnopts": "1.0.2",
  "yaml": "1.0.2",
  "yaml-unist-parser": "1.0.0"
};
var devDependencies = {
  "@babel/cli": "7.2.0",
  "@babel/core": "7.2.0",
  "@babel/preset-env": "7.2.0",
  "babel-loader": "8.0.4",
  "benchmark": "2.1.4",
  "builtin-modules": "2.0.0",
  "codecov": "codecov/codecov-node#e427d900309adb50746a39a50aa7d80071a5ddd0",
  "cross-env": "5.0.5",
  "eslint": "4.18.2",
  "eslint-config-prettier": "2.9.0",
  "eslint-friendly-formatter": "3.0.0",
  "eslint-plugin-import": "2.9.0",
  "eslint-plugin-prettier": "2.6.0",
  "eslint-plugin-react": "7.7.0",
  "execa": "0.10.0",
  "jest": "23.3.0",
  "jest-junit": "5.0.0",
  "jest-snapshot-serializer-ansi": "1.0.0",
  "jest-snapshot-serializer-raw": "1.1.0",
  "jest-watch-typeahead": "0.1.0",
  "mkdirp": "0.5.1",
  "prettier": "1.18.0",
  "prettylint": "1.0.0",
  "rimraf": "2.6.2",
  "rollup": "0.47.6",
  "rollup-plugin-alias": "1.4.0",
  "rollup-plugin-babel": "4.0.0-beta.4",
  "rollup-plugin-commonjs": "8.2.6",
  "rollup-plugin-json": "2.1.1",
  "rollup-plugin-node-builtins": "2.0.0",
  "rollup-plugin-node-globals": "1.1.0",
  "rollup-plugin-node-resolve": "2.0.0",
  "rollup-plugin-replace": "1.2.1",
  "rollup-plugin-uglify": "3.0.0",
  "shelljs": "0.8.1",
  "snapshot-diff": "0.4.0",
  "strip-ansi": "4.0.0",
  "tempy": "0.2.1",
  "webpack": "3.12.0"
};
var scripts = {
  "prepublishOnly": "echo \"Error: must publish from dist/\" && exit 1",
  "prepare-release": "yarn && yarn build && yarn test:dist",
  "test": "jest",
  "test:dist": "node ./scripts/test-dist.js",
  "test-integration": "jest tests_integration",
  "perf-repeat": "yarn && yarn build && cross-env NODE_ENV=production node ./dist/bin-prettier.js --debug-repeat ${PERF_REPEAT:-1000} --loglevel debug ${PERF_FILE:-./index.js} > /dev/null",
  "perf-repeat-inspect": "yarn && yarn build && cross-env NODE_ENV=production node --inspect-brk ./dist/bin-prettier.js --debug-repeat ${PERF_REPEAT:-1000} --loglevel debug ${PERF_FILE:-./index.js} > /dev/null",
  "perf-benchmark": "yarn && yarn build && cross-env NODE_ENV=production node ./dist/bin-prettier.js --debug-benchmark --loglevel debug ${PERF_FILE:-./index.js} > /dev/null",
  "lint": "cross-env EFF_NO_LINK_RULES=true eslint . --format node_modules/eslint-friendly-formatter",
  "lint-docs": "prettylint {.,docs,website,website/blog}/*.md",
  "lint-dist": "eslint --no-eslintrc --no-ignore --env=browser \"dist/!(bin-prettier|index|third-party).js\"",
  "build": "node --max-old-space-size=2048 ./scripts/build/build.js",
  "build-docs": "node ./scripts/build-docs.js",
  "check-deps": "node ./scripts/check-deps.js"
};
var _package = {
  name: name,
  version: version$1,
  description: description,
  bin: bin,
  repository: repository,
  homepage: homepage,
  author: author,
  license: license,
  main: main,
  engines: engines,
  dependencies: dependencies,
  devDependencies: devDependencies,
  scripts: scripts
};

var _package$1 = Object.freeze({
	name: name,
	version: version$1,
	description: description,
	bin: bin,
	repository: repository,
	homepage: homepage,
	author: author,
	license: license,
	main: main,
	engines: engines,
	dependencies: dependencies,
	devDependencies: devDependencies,
	scripts: scripts,
	default: _package
});

function unwrapExports (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

var base = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports['default'] =
  /*istanbul ignore end*/
  Diff;

  function Diff() {}

  Diff.prototype = {
    /*istanbul ignore start*/

    /*istanbul ignore end*/
    diff: function diff(oldString, newString) {
      /*istanbul ignore start*/
      var
      /*istanbul ignore end*/
      options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];
      var callback = options.callback;

      if (typeof options === 'function') {
        callback = options;
        options = {};
      }

      this.options = options;
      var self = this;

      function done(value) {
        if (callback) {
          setTimeout(function () {
            callback(undefined, value);
          }, 0);
          return true;
        } else {
          return value;
        }
      } // Allow subclasses to massage the input prior to running


      oldString = this.castInput(oldString);
      newString = this.castInput(newString);
      oldString = this.removeEmpty(this.tokenize(oldString));
      newString = this.removeEmpty(this.tokenize(newString));
      var newLen = newString.length,
          oldLen = oldString.length;
      var editLength = 1;
      var maxEditLength = newLen + oldLen;
      var bestPath = [{
        newPos: -1,
        components: []
      }]; // Seed editLength = 0, i.e. the content starts with the same values

      var oldPos = this.extractCommon(bestPath[0], newString, oldString, 0);

      if (bestPath[0].newPos + 1 >= newLen && oldPos + 1 >= oldLen) {
        // Identity per the equality and tokenizer
        return done([{
          value: this.join(newString),
          count: newString.length
        }]);
      } // Main worker method. checks all permutations of a given edit length for acceptance.


      function execEditLength() {
        for (var diagonalPath = -1 * editLength; diagonalPath <= editLength; diagonalPath += 2) {
          var basePath =
          /*istanbul ignore start*/
          void 0;

          var addPath = bestPath[diagonalPath - 1],
              removePath = bestPath[diagonalPath + 1],
              _oldPos = (removePath ? removePath.newPos : 0) - diagonalPath;

          if (addPath) {
            // No one else is going to attempt to use this value, clear it
            bestPath[diagonalPath - 1] = undefined;
          }

          var canAdd = addPath && addPath.newPos + 1 < newLen,
              canRemove = removePath && 0 <= _oldPos && _oldPos < oldLen;

          if (!canAdd && !canRemove) {
            // If this path is a terminal then prune
            bestPath[diagonalPath] = undefined;
            continue;
          } // Select the diagonal that we want to branch from. We select the prior
          // path whose position in the new string is the farthest from the origin
          // and does not pass the bounds of the diff graph


          if (!canAdd || canRemove && addPath.newPos < removePath.newPos) {
            basePath = clonePath(removePath);
            self.pushComponent(basePath.components, undefined, true);
          } else {
            basePath = addPath; // No need to clone, we've pulled it from the list

            basePath.newPos++;
            self.pushComponent(basePath.components, true, undefined);
          }

          _oldPos = self.extractCommon(basePath, newString, oldString, diagonalPath); // If we have hit the end of both strings, then we are done

          if (basePath.newPos + 1 >= newLen && _oldPos + 1 >= oldLen) {
            return done(buildValues(self, basePath.components, newString, oldString, self.useLongestToken));
          } else {
            // Otherwise track this path as a potential candidate and continue.
            bestPath[diagonalPath] = basePath;
          }
        }

        editLength++;
      } // Performs the length of edit iteration. Is a bit fugly as this has to support the
      // sync and async mode which is never fun. Loops over execEditLength until a value
      // is produced.


      if (callback) {
        (function exec() {
          setTimeout(function () {
            // This should not happen, but we want to be safe.

            /* istanbul ignore next */
            if (editLength > maxEditLength) {
              return callback();
            }

            if (!execEditLength()) {
              exec();
            }
          }, 0);
        })();
      } else {
        while (editLength <= maxEditLength) {
          var ret = execEditLength();

          if (ret) {
            return ret;
          }
        }
      }
    },

    /*istanbul ignore start*/

    /*istanbul ignore end*/
    pushComponent: function pushComponent(components, added, removed) {
      var last = components[components.length - 1];

      if (last && last.added === added && last.removed === removed) {
        // We need to clone here as the component clone operation is just
        // as shallow array clone
        components[components.length - 1] = {
          count: last.count + 1,
          added: added,
          removed: removed
        };
      } else {
        components.push({
          count: 1,
          added: added,
          removed: removed
        });
      }
    },

    /*istanbul ignore start*/

    /*istanbul ignore end*/
    extractCommon: function extractCommon(basePath, newString, oldString, diagonalPath) {
      var newLen = newString.length,
          oldLen = oldString.length,
          newPos = basePath.newPos,
          oldPos = newPos - diagonalPath,
          commonCount = 0;

      while (newPos + 1 < newLen && oldPos + 1 < oldLen && this.equals(newString[newPos + 1], oldString[oldPos + 1])) {
        newPos++;
        oldPos++;
        commonCount++;
      }

      if (commonCount) {
        basePath.components.push({
          count: commonCount
        });
      }

      basePath.newPos = newPos;
      return oldPos;
    },

    /*istanbul ignore start*/

    /*istanbul ignore end*/
    equals: function equals(left, right) {
      return left === right;
    },

    /*istanbul ignore start*/

    /*istanbul ignore end*/
    removeEmpty: function removeEmpty(array) {
      var ret = [];

      for (var i = 0; i < array.length; i++) {
        if (array[i]) {
          ret.push(array[i]);
        }
      }

      return ret;
    },

    /*istanbul ignore start*/

    /*istanbul ignore end*/
    castInput: function castInput(value) {
      return value;
    },

    /*istanbul ignore start*/

    /*istanbul ignore end*/
    tokenize: function tokenize(value) {
      return value.split('');
    },

    /*istanbul ignore start*/

    /*istanbul ignore end*/
    join: function join(chars) {
      return chars.join('');
    }
  };

  function buildValues(diff, components, newString, oldString, useLongestToken) {
    var componentPos = 0,
        componentLen = components.length,
        newPos = 0,
        oldPos = 0;

    for (; componentPos < componentLen; componentPos++) {
      var component = components[componentPos];

      if (!component.removed) {
        if (!component.added && useLongestToken) {
          var value = newString.slice(newPos, newPos + component.count);
          value = value.map(function (value, i) {
            var oldValue = oldString[oldPos + i];
            return oldValue.length > value.length ? oldValue : value;
          });
          component.value = diff.join(value);
        } else {
          component.value = diff.join(newString.slice(newPos, newPos + component.count));
        }

        newPos += component.count; // Common case

        if (!component.added) {
          oldPos += component.count;
        }
      } else {
        component.value = diff.join(oldString.slice(oldPos, oldPos + component.count));
        oldPos += component.count; // Reverse add and remove so removes are output first to match common convention
        // The diffing algorithm is tied to add then remove output and this is the simplest
        // route to get the desired output with minimal overhead.

        if (componentPos && components[componentPos - 1].added) {
          var tmp = components[componentPos - 1];
          components[componentPos - 1] = components[componentPos];
          components[componentPos] = tmp;
        }
      }
    } // Special case handle for when one terminal is ignored. For this case we merge the
    // terminal into the prior string and drop the change.


    var lastComponent = components[componentLen - 1];

    if (componentLen > 1 && (lastComponent.added || lastComponent.removed) && diff.equals('', lastComponent.value)) {
      components[componentLen - 2].value += lastComponent.value;
      components.pop();
    }

    return components;
  }

  function clonePath(path$$1) {
    return {
      newPos: path$$1.newPos,
      components: path$$1.components.slice(0)
    };
  }
});
unwrapExports(base);

var character = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.characterDiff = undefined;
  exports.
  /*istanbul ignore end*/
  diffChars = diffChars;
  /*istanbul ignore start*/

  var _base2 = _interopRequireDefault(base);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      'default': obj
    };
  }
  /*istanbul ignore end*/


  var characterDiff =
  /*istanbul ignore start*/
  exports.
  /*istanbul ignore end*/
  characterDiff = new
  /*istanbul ignore start*/
  _base2['default']();

  function diffChars(oldStr, newStr, callback) {
    return characterDiff.diff(oldStr, newStr, callback);
  }
});
unwrapExports(character);

var params = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.
  /*istanbul ignore end*/
  generateOptions = generateOptions;

  function generateOptions(options, defaults) {
    if (typeof options === 'function') {
      defaults.callback = options;
    } else if (options) {
      for (var name in options) {
        /* istanbul ignore else */
        if (options.hasOwnProperty(name)) {
          defaults[name] = options[name];
        }
      }
    }

    return defaults;
  }
});
unwrapExports(params);

var word = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.wordDiff = undefined;
  exports.
  /*istanbul ignore end*/
  diffWords = diffWords;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffWordsWithSpace = diffWordsWithSpace;
  /*istanbul ignore start*/

  var _base2 = _interopRequireDefault(base);
  /*istanbul ignore end*/

  /*istanbul ignore start*/


  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      'default': obj
    };
  }
  /*istanbul ignore end*/
  // Based on https://en.wikipedia.org/wiki/Latin_script_in_Unicode
  //
  // Ranges and exceptions:
  // Latin-1 Supplement, 0080–00FF
  //  - U+00D7  × Multiplication sign
  //  - U+00F7  ÷ Division sign
  // Latin Extended-A, 0100–017F
  // Latin Extended-B, 0180–024F
  // IPA Extensions, 0250–02AF
  // Spacing Modifier Letters, 02B0–02FF
  //  - U+02C7  ˇ &#711;  Caron
  //  - U+02D8  ˘ &#728;  Breve
  //  - U+02D9  ˙ &#729;  Dot Above
  //  - U+02DA  ˚ &#730;  Ring Above
  //  - U+02DB  ˛ &#731;  Ogonek
  //  - U+02DC  ˜ &#732;  Small Tilde
  //  - U+02DD  ˝ &#733;  Double Acute Accent
  // Latin Extended Additional, 1E00–1EFF


  var extendedWordChars = /^[A-Za-z\xC0-\u02C6\u02C8-\u02D7\u02DE-\u02FF\u1E00-\u1EFF]+$/;
  var reWhitespace = /\S/;
  var wordDiff =
  /*istanbul ignore start*/
  exports.
  /*istanbul ignore end*/
  wordDiff = new
  /*istanbul ignore start*/
  _base2['default']();

  wordDiff.equals = function (left, right) {
    return left === right || this.options.ignoreWhitespace && !reWhitespace.test(left) && !reWhitespace.test(right);
  };

  wordDiff.tokenize = function (value) {
    var tokens = value.split(/(\s+|\b)/); // Join the boundary splits that we do not consider to be boundaries. This is primarily the extended Latin character set.

    for (var i = 0; i < tokens.length - 1; i++) {
      // If we have an empty string in the next field and we have only word chars before and after, merge
      if (!tokens[i + 1] && tokens[i + 2] && extendedWordChars.test(tokens[i]) && extendedWordChars.test(tokens[i + 2])) {
        tokens[i] += tokens[i + 2];
        tokens.splice(i + 1, 2);
        i--;
      }
    }

    return tokens;
  };

  function diffWords(oldStr, newStr, callback) {
    var options =
    /*istanbul ignore start*/
    (0, params.generateOptions
    /*istanbul ignore end*/
    )(callback, {
      ignoreWhitespace: true
    });
    return wordDiff.diff(oldStr, newStr, options);
  }

  function diffWordsWithSpace(oldStr, newStr, callback) {
    return wordDiff.diff(oldStr, newStr, callback);
  }
});
unwrapExports(word);

var line = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.lineDiff = undefined;
  exports.
  /*istanbul ignore end*/
  diffLines = diffLines;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffTrimmedLines = diffTrimmedLines;
  /*istanbul ignore start*/

  var _base2 = _interopRequireDefault(base);
  /*istanbul ignore end*/

  /*istanbul ignore start*/


  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      'default': obj
    };
  }
  /*istanbul ignore end*/


  var lineDiff =
  /*istanbul ignore start*/
  exports.
  /*istanbul ignore end*/
  lineDiff = new
  /*istanbul ignore start*/
  _base2['default']();

  lineDiff.tokenize = function (value) {
    var retLines = [],
        linesAndNewlines = value.split(/(\n|\r\n)/); // Ignore the final empty token that occurs if the string ends with a new line

    if (!linesAndNewlines[linesAndNewlines.length - 1]) {
      linesAndNewlines.pop();
    } // Merge the content and line separators into single tokens


    for (var i = 0; i < linesAndNewlines.length; i++) {
      var line = linesAndNewlines[i];

      if (i % 2 && !this.options.newlineIsToken) {
        retLines[retLines.length - 1] += line;
      } else {
        if (this.options.ignoreWhitespace) {
          line = line.trim();
        }

        retLines.push(line);
      }
    }

    return retLines;
  };

  function diffLines(oldStr, newStr, callback) {
    return lineDiff.diff(oldStr, newStr, callback);
  }

  function diffTrimmedLines(oldStr, newStr, callback) {
    var options =
    /*istanbul ignore start*/
    (0, params.generateOptions
    /*istanbul ignore end*/
    )(callback, {
      ignoreWhitespace: true
    });
    return lineDiff.diff(oldStr, newStr, options);
  }
});
unwrapExports(line);

var sentence = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.sentenceDiff = undefined;
  exports.
  /*istanbul ignore end*/
  diffSentences = diffSentences;
  /*istanbul ignore start*/

  var _base2 = _interopRequireDefault(base);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      'default': obj
    };
  }
  /*istanbul ignore end*/


  var sentenceDiff =
  /*istanbul ignore start*/
  exports.
  /*istanbul ignore end*/
  sentenceDiff = new
  /*istanbul ignore start*/
  _base2['default']();

  sentenceDiff.tokenize = function (value) {
    return value.split(/(\S.+?[.!?])(?=\s+|$)/);
  };

  function diffSentences(oldStr, newStr, callback) {
    return sentenceDiff.diff(oldStr, newStr, callback);
  }
});
unwrapExports(sentence);

var css = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.cssDiff = undefined;
  exports.
  /*istanbul ignore end*/
  diffCss = diffCss;
  /*istanbul ignore start*/

  var _base2 = _interopRequireDefault(base);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      'default': obj
    };
  }
  /*istanbul ignore end*/


  var cssDiff =
  /*istanbul ignore start*/
  exports.
  /*istanbul ignore end*/
  cssDiff = new
  /*istanbul ignore start*/
  _base2['default']();

  cssDiff.tokenize = function (value) {
    return value.split(/([{}:;,]|\s+)/);
  };

  function diffCss(oldStr, newStr, callback) {
    return cssDiff.diff(oldStr, newStr, callback);
  }
});
unwrapExports(css);

var json = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.jsonDiff = undefined;

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj;
  };

  exports.
  /*istanbul ignore end*/
  diffJson = diffJson;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  canonicalize = canonicalize;
  /*istanbul ignore start*/

  var _base2 = _interopRequireDefault(base);
  /*istanbul ignore end*/

  /*istanbul ignore start*/


  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      'default': obj
    };
  }
  /*istanbul ignore end*/


  var objectPrototypeToString = Object.prototype.toString;
  var jsonDiff =
  /*istanbul ignore start*/
  exports.
  /*istanbul ignore end*/
  jsonDiff = new
  /*istanbul ignore start*/
  _base2['default'](); // Discriminate between two lines of pretty-printed, serialized JSON where one of them has a
  // dangling comma and the other doesn't. Turns out including the dangling comma yields the nicest output:

  jsonDiff.useLongestToken = true;
  jsonDiff.tokenize =
  /*istanbul ignore start*/
  line.lineDiff.
  /*istanbul ignore end*/
  tokenize;

  jsonDiff.castInput = function (value) {
    /*istanbul ignore start*/
    var
    /*istanbul ignore end*/
    undefinedReplacement = this.options.undefinedReplacement;
    return typeof value === 'string' ? value : JSON.stringify(canonicalize(value), function (k, v) {
      if (typeof v === 'undefined') {
        return undefinedReplacement;
      }

      return v;
    }, '  ');
  };

  jsonDiff.equals = function (left, right) {
    return (
      /*istanbul ignore start*/
      _base2['default'].
      /*istanbul ignore end*/
      prototype.equals(left.replace(/,([\r\n])/g, '$1'), right.replace(/,([\r\n])/g, '$1'))
    );
  };

  function diffJson(oldObj, newObj, options) {
    return jsonDiff.diff(oldObj, newObj, options);
  } // This function handles the presence of circular references by bailing out when encountering an
  // object that is already on the "stack" of items being processed.


  function canonicalize(obj, stack, replacementStack) {
    stack = stack || [];
    replacementStack = replacementStack || [];
    var i =
    /*istanbul ignore start*/
    void 0;

    for (i = 0; i < stack.length; i += 1) {
      if (stack[i] === obj) {
        return replacementStack[i];
      }
    }

    var canonicalizedObj =
    /*istanbul ignore start*/
    void 0;

    if ('[object Array]' === objectPrototypeToString.call(obj)) {
      stack.push(obj);
      canonicalizedObj = new Array(obj.length);
      replacementStack.push(canonicalizedObj);

      for (i = 0; i < obj.length; i += 1) {
        canonicalizedObj[i] = canonicalize(obj[i], stack, replacementStack);
      }

      stack.pop();
      replacementStack.pop();
      return canonicalizedObj;
    }

    if (obj && obj.toJSON) {
      obj = obj.toJSON();
    }

    if (
    /*istanbul ignore start*/
    (typeof
    /*istanbul ignore end*/
    obj === 'undefined' ? 'undefined' : _typeof(obj)) === 'object' && obj !== null) {
      stack.push(obj);
      canonicalizedObj = {};
      replacementStack.push(canonicalizedObj);
      var sortedKeys = [],
          key =
      /*istanbul ignore start*/
      void 0;

      for (key in obj) {
        /* istanbul ignore else */
        if (obj.hasOwnProperty(key)) {
          sortedKeys.push(key);
        }
      }

      sortedKeys.sort();

      for (i = 0; i < sortedKeys.length; i += 1) {
        key = sortedKeys[i];
        canonicalizedObj[key] = canonicalize(obj[key], stack, replacementStack);
      }

      stack.pop();
      replacementStack.pop();
    } else {
      canonicalizedObj = obj;
    }

    return canonicalizedObj;
  }
});
unwrapExports(json);

var array = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.arrayDiff = undefined;
  exports.
  /*istanbul ignore end*/
  diffArrays = diffArrays;
  /*istanbul ignore start*/

  var _base2 = _interopRequireDefault(base);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      'default': obj
    };
  }
  /*istanbul ignore end*/


  var arrayDiff =
  /*istanbul ignore start*/
  exports.
  /*istanbul ignore end*/
  arrayDiff = new
  /*istanbul ignore start*/
  _base2['default']();

  arrayDiff.tokenize = arrayDiff.join = function (value) {
    return value.slice();
  };

  function diffArrays(oldArr, newArr, callback) {
    return arrayDiff.diff(oldArr, newArr, callback);
  }
});
unwrapExports(array);

var parse = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.
  /*istanbul ignore end*/
  parsePatch = parsePatch;

  function parsePatch(uniDiff) {
    /*istanbul ignore start*/
    var
    /*istanbul ignore end*/
    options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    var diffstr = uniDiff.split(/\r\n|[\n\v\f\r\x85]/),
        delimiters = uniDiff.match(/\r\n|[\n\v\f\r\x85]/g) || [],
        list = [],
        i = 0;

    function parseIndex() {
      var index = {};
      list.push(index); // Parse diff metadata

      while (i < diffstr.length) {
        var line = diffstr[i]; // File header found, end parsing diff metadata

        if (/^(\-\-\-|\+\+\+|@@)\s/.test(line)) {
          break;
        } // Diff index


        var header = /^(?:Index:|diff(?: -r \w+)+)\s+(.+?)\s*$/.exec(line);

        if (header) {
          index.index = header[1];
        }

        i++;
      } // Parse file headers if they are defined. Unified diff requires them, but
      // there's no technical issues to have an isolated hunk without file header


      parseFileHeader(index);
      parseFileHeader(index); // Parse hunks

      index.hunks = [];

      while (i < diffstr.length) {
        var _line = diffstr[i];

        if (/^(Index:|diff|\-\-\-|\+\+\+)\s/.test(_line)) {
          break;
        } else if (/^@@/.test(_line)) {
          index.hunks.push(parseHunk());
        } else if (_line && options.strict) {
          // Ignore unexpected content unless in strict mode
          throw new Error('Unknown line ' + (i + 1) + ' ' + JSON.stringify(_line));
        } else {
          i++;
        }
      }
    } // Parses the --- and +++ headers, if none are found, no lines
    // are consumed.


    function parseFileHeader(index) {
      var headerPattern = /^(---|\+\+\+)\s+([\S ]*)(?:\t(.*?)\s*)?$/;
      var fileHeader = headerPattern.exec(diffstr[i]);

      if (fileHeader) {
        var keyPrefix = fileHeader[1] === '---' ? 'old' : 'new';
        index[keyPrefix + 'FileName'] = fileHeader[2];
        index[keyPrefix + 'Header'] = fileHeader[3];
        i++;
      }
    } // Parses a hunk
    // This assumes that we are at the start of a hunk.


    function parseHunk() {
      var chunkHeaderIndex = i,
          chunkHeaderLine = diffstr[i++],
          chunkHeader = chunkHeaderLine.split(/@@ -(\d+)(?:,(\d+))? \+(\d+)(?:,(\d+))? @@/);
      var hunk = {
        oldStart: +chunkHeader[1],
        oldLines: +chunkHeader[2] || 1,
        newStart: +chunkHeader[3],
        newLines: +chunkHeader[4] || 1,
        lines: [],
        linedelimiters: []
      };
      var addCount = 0,
          removeCount = 0;

      for (; i < diffstr.length; i++) {
        // Lines starting with '---' could be mistaken for the "remove line" operation
        // But they could be the header for the next file. Therefore prune such cases out.
        if (diffstr[i].indexOf('--- ') === 0 && i + 2 < diffstr.length && diffstr[i + 1].indexOf('+++ ') === 0 && diffstr[i + 2].indexOf('@@') === 0) {
          break;
        }

        var operation = diffstr[i][0];

        if (operation === '+' || operation === '-' || operation === ' ' || operation === '\\') {
          hunk.lines.push(diffstr[i]);
          hunk.linedelimiters.push(delimiters[i] || '\n');

          if (operation === '+') {
            addCount++;
          } else if (operation === '-') {
            removeCount++;
          } else if (operation === ' ') {
            addCount++;
            removeCount++;
          }
        } else {
          break;
        }
      } // Handle the empty block count case


      if (!addCount && hunk.newLines === 1) {
        hunk.newLines = 0;
      }

      if (!removeCount && hunk.oldLines === 1) {
        hunk.oldLines = 0;
      } // Perform optional sanity checking


      if (options.strict) {
        if (addCount !== hunk.newLines) {
          throw new Error('Added line count did not match for hunk at line ' + (chunkHeaderIndex + 1));
        }

        if (removeCount !== hunk.oldLines) {
          throw new Error('Removed line count did not match for hunk at line ' + (chunkHeaderIndex + 1));
        }
      }

      return hunk;
    }

    while (i < diffstr.length) {
      parseIndex();
    }

    return list;
  }
});
unwrapExports(parse);

var distanceIterator = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  "use strict";

  exports.__esModule = true;

  exports["default"] =
  /*istanbul ignore end*/
  function (start, minLine, maxLine) {
    var wantForward = true,
        backwardExhausted = false,
        forwardExhausted = false,
        localOffset = 1;
    return function iterator() {
      if (wantForward && !forwardExhausted) {
        if (backwardExhausted) {
          localOffset++;
        } else {
          wantForward = false;
        } // Check if trying to fit beyond text length, and if not, check it fits
        // after offset location (or desired location on first iteration)


        if (start + localOffset <= maxLine) {
          return localOffset;
        }

        forwardExhausted = true;
      }

      if (!backwardExhausted) {
        if (!forwardExhausted) {
          wantForward = true;
        } // Check if trying to fit before text beginning, and if not, check it fits
        // before offset location


        if (minLine <= start - localOffset) {
          return -localOffset++;
        }

        backwardExhausted = true;
        return iterator();
      } // We tried to fit hunk before text beginning and beyond text lenght, then
      // hunk can't fit on the text. Return undefined

    };
  };
});
unwrapExports(distanceIterator);

var apply = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.
  /*istanbul ignore end*/
  applyPatch = applyPatch;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  applyPatches = applyPatches;
  /*istanbul ignore start*/

  var _distanceIterator2 = _interopRequireDefault(distanceIterator);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      'default': obj
    };
  }
  /*istanbul ignore end*/


  function applyPatch(source, uniDiff) {
    /*istanbul ignore start*/
    var
    /*istanbul ignore end*/
    options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    if (typeof uniDiff === 'string') {
      uniDiff =
      /*istanbul ignore start*/
      (0, parse.parsePatch
      /*istanbul ignore end*/
      )(uniDiff);
    }

    if (Array.isArray(uniDiff)) {
      if (uniDiff.length > 1) {
        throw new Error('applyPatch only works with a single input.');
      }

      uniDiff = uniDiff[0];
    } // Apply the diff to the input


    var lines = source.split(/\r\n|[\n\v\f\r\x85]/),
        delimiters = source.match(/\r\n|[\n\v\f\r\x85]/g) || [],
        hunks = uniDiff.hunks,
        compareLine = options.compareLine || function (lineNumber, line, operation, patchContent)
    /*istanbul ignore start*/
    {
      return (
        /*istanbul ignore end*/
        line === patchContent
      );
    },
        errorCount = 0,
        fuzzFactor = options.fuzzFactor || 0,
        minLine = 0,
        offset = 0,
        removeEOFNL =
    /*istanbul ignore start*/
    void 0
    /*istanbul ignore end*/
    ,
        addEOFNL =
    /*istanbul ignore start*/
    void 0;
    /**
     * Checks if the hunk exactly fits on the provided location
     */


    function hunkFits(hunk, toPos) {
      for (var j = 0; j < hunk.lines.length; j++) {
        var line = hunk.lines[j],
            operation = line[0],
            content = line.substr(1);

        if (operation === ' ' || operation === '-') {
          // Context sanity check
          if (!compareLine(toPos + 1, lines[toPos], operation, content)) {
            errorCount++;

            if (errorCount > fuzzFactor) {
              return false;
            }
          }

          toPos++;
        }
      }

      return true;
    } // Search best fit offsets for each hunk based on the previous ones


    for (var i = 0; i < hunks.length; i++) {
      var hunk = hunks[i],
          maxLine = lines.length - hunk.oldLines,
          localOffset = 0,
          toPos = offset + hunk.oldStart - 1;
      var iterator =
      /*istanbul ignore start*/
      (0, _distanceIterator2['default']
      /*istanbul ignore end*/
      )(toPos, minLine, maxLine);

      for (; localOffset !== undefined; localOffset = iterator()) {
        if (hunkFits(hunk, toPos + localOffset)) {
          hunk.offset = offset += localOffset;
          break;
        }
      }

      if (localOffset === undefined) {
        return false;
      } // Set lower text limit to end of the current hunk, so next ones don't try
      // to fit over already patched text


      minLine = hunk.offset + hunk.oldStart + hunk.oldLines;
    } // Apply patch hunks


    for (var _i = 0; _i < hunks.length; _i++) {
      var _hunk = hunks[_i],
          _toPos = _hunk.offset + _hunk.newStart - 1;

      if (_hunk.newLines == 0) {
        _toPos++;
      }

      for (var j = 0; j < _hunk.lines.length; j++) {
        var line = _hunk.lines[j],
            operation = line[0],
            content = line.substr(1),
            delimiter = _hunk.linedelimiters[j];

        if (operation === ' ') {
          _toPos++;
        } else if (operation === '-') {
          lines.splice(_toPos, 1);
          delimiters.splice(_toPos, 1);
          /* istanbul ignore else */
        } else if (operation === '+') {
          lines.splice(_toPos, 0, content);
          delimiters.splice(_toPos, 0, delimiter);
          _toPos++;
        } else if (operation === '\\') {
          var previousOperation = _hunk.lines[j - 1] ? _hunk.lines[j - 1][0] : null;

          if (previousOperation === '+') {
            removeEOFNL = true;
          } else if (previousOperation === '-') {
            addEOFNL = true;
          }
        }
      }
    } // Handle EOFNL insertion/removal


    if (removeEOFNL) {
      while (!lines[lines.length - 1]) {
        lines.pop();
        delimiters.pop();
      }
    } else if (addEOFNL) {
      lines.push('');
      delimiters.push('\n');
    }

    for (var _k = 0; _k < lines.length - 1; _k++) {
      lines[_k] = lines[_k] + delimiters[_k];
    }

    return lines.join('');
  } // Wrapper that supports multiple file patches via callbacks.


  function applyPatches(uniDiff, options) {
    if (typeof uniDiff === 'string') {
      uniDiff =
      /*istanbul ignore start*/
      (0, parse.parsePatch
      /*istanbul ignore end*/
      )(uniDiff);
    }

    var currentIndex = 0;

    function processIndex() {
      var index = uniDiff[currentIndex++];

      if (!index) {
        return options.complete();
      }

      options.loadFile(index, function (err, data) {
        if (err) {
          return options.complete(err);
        }

        var updatedContent = applyPatch(data, index, options);
        options.patched(index, updatedContent, function (err) {
          if (err) {
            return options.complete(err);
          }

          processIndex();
        });
      });
    }

    processIndex();
  }
});
unwrapExports(apply);

var create = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.
  /*istanbul ignore end*/
  structuredPatch = structuredPatch;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  createTwoFilesPatch = createTwoFilesPatch;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  createPatch = createPatch;
  /*istanbul ignore start*/

  function _toConsumableArray(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    } else {
      return Array.from(arr);
    }
  }
  /*istanbul ignore end*/


  function structuredPatch(oldFileName, newFileName, oldStr, newStr, oldHeader, newHeader, options) {
    if (!options) {
      options = {};
    }

    if (typeof options.context === 'undefined') {
      options.context = 4;
    }

    var diff =
    /*istanbul ignore start*/
    (0, line.diffLines
    /*istanbul ignore end*/
    )(oldStr, newStr, options);
    diff.push({
      value: '',
      lines: []
    }); // Append an empty value to make cleanup easier

    function contextLines(lines) {
      return lines.map(function (entry) {
        return ' ' + entry;
      });
    }

    var hunks = [];
    var oldRangeStart = 0,
        newRangeStart = 0,
        curRange = [],
        oldLine = 1,
        newLine = 1;
    /*istanbul ignore start*/

    var _loop = function _loop(
    /*istanbul ignore end*/
    i) {
      var current = diff[i],
          lines = current.lines || current.value.replace(/\n$/, '').split('\n');
      current.lines = lines;

      if (current.added || current.removed) {
        /*istanbul ignore start*/
        var _curRange;
        /*istanbul ignore end*/
        // If we have previous context, start with that


        if (!oldRangeStart) {
          var prev = diff[i - 1];
          oldRangeStart = oldLine;
          newRangeStart = newLine;

          if (prev) {
            curRange = options.context > 0 ? contextLines(prev.lines.slice(-options.context)) : [];
            oldRangeStart -= curRange.length;
            newRangeStart -= curRange.length;
          }
        } // Output our changes

        /*istanbul ignore start*/


        (_curRange =
        /*istanbul ignore end*/
        curRange).push.
        /*istanbul ignore start*/
        apply
        /*istanbul ignore end*/
        (
        /*istanbul ignore start*/
        _curRange
        /*istanbul ignore end*/
        ,
        /*istanbul ignore start*/
        _toConsumableArray(
        /*istanbul ignore end*/
        lines.map(function (entry) {
          return (current.added ? '+' : '-') + entry;
        }))); // Track the updated file position


        if (current.added) {
          newLine += lines.length;
        } else {
          oldLine += lines.length;
        }
      } else {
        // Identical context lines. Track line changes
        if (oldRangeStart) {
          // Close out any changes that have been output (or join overlapping)
          if (lines.length <= options.context * 2 && i < diff.length - 2) {
            /*istanbul ignore start*/
            var _curRange2;
            /*istanbul ignore end*/
            // Overlapping

            /*istanbul ignore start*/


            (_curRange2 =
            /*istanbul ignore end*/
            curRange).push.
            /*istanbul ignore start*/
            apply
            /*istanbul ignore end*/
            (
            /*istanbul ignore start*/
            _curRange2
            /*istanbul ignore end*/
            ,
            /*istanbul ignore start*/
            _toConsumableArray(
            /*istanbul ignore end*/
            contextLines(lines)));
          } else {
            /*istanbul ignore start*/
            var _curRange3;
            /*istanbul ignore end*/
            // end the range and output


            var contextSize = Math.min(lines.length, options.context);
            /*istanbul ignore start*/

            (_curRange3 =
            /*istanbul ignore end*/
            curRange).push.
            /*istanbul ignore start*/
            apply
            /*istanbul ignore end*/
            (
            /*istanbul ignore start*/
            _curRange3
            /*istanbul ignore end*/
            ,
            /*istanbul ignore start*/
            _toConsumableArray(
            /*istanbul ignore end*/
            contextLines(lines.slice(0, contextSize))));

            var hunk = {
              oldStart: oldRangeStart,
              oldLines: oldLine - oldRangeStart + contextSize,
              newStart: newRangeStart,
              newLines: newLine - newRangeStart + contextSize,
              lines: curRange
            };

            if (i >= diff.length - 2 && lines.length <= options.context) {
              // EOF is inside this hunk
              var oldEOFNewline = /\n$/.test(oldStr);
              var newEOFNewline = /\n$/.test(newStr);

              if (lines.length == 0 && !oldEOFNewline) {
                // special case: old has no eol and no trailing context; no-nl can end up before adds
                curRange.splice(hunk.oldLines, 0, '\\ No newline at end of file');
              } else if (!oldEOFNewline || !newEOFNewline) {
                curRange.push('\\ No newline at end of file');
              }
            }

            hunks.push(hunk);
            oldRangeStart = 0;
            newRangeStart = 0;
            curRange = [];
          }
        }

        oldLine += lines.length;
        newLine += lines.length;
      }
    };

    for (var i = 0; i < diff.length; i++) {
      /*istanbul ignore start*/
      _loop(
      /*istanbul ignore end*/
      i);
    }

    return {
      oldFileName: oldFileName,
      newFileName: newFileName,
      oldHeader: oldHeader,
      newHeader: newHeader,
      hunks: hunks
    };
  }

  function createTwoFilesPatch(oldFileName, newFileName, oldStr, newStr, oldHeader, newHeader, options) {
    var diff = structuredPatch(oldFileName, newFileName, oldStr, newStr, oldHeader, newHeader, options);
    var ret = [];

    if (oldFileName == newFileName) {
      ret.push('Index: ' + oldFileName);
    }

    ret.push('===================================================================');
    ret.push('--- ' + diff.oldFileName + (typeof diff.oldHeader === 'undefined' ? '' : '\t' + diff.oldHeader));
    ret.push('+++ ' + diff.newFileName + (typeof diff.newHeader === 'undefined' ? '' : '\t' + diff.newHeader));

    for (var i = 0; i < diff.hunks.length; i++) {
      var hunk = diff.hunks[i];
      ret.push('@@ -' + hunk.oldStart + ',' + hunk.oldLines + ' +' + hunk.newStart + ',' + hunk.newLines + ' @@');
      ret.push.apply(ret, hunk.lines);
    }

    return ret.join('\n') + '\n';
  }

  function createPatch(fileName, oldStr, newStr, oldHeader, newHeader, options) {
    return createTwoFilesPatch(fileName, fileName, oldStr, newStr, oldHeader, newHeader, options);
  }
});
unwrapExports(create);

var dmp = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  "use strict";

  exports.__esModule = true;
  exports.
  /*istanbul ignore end*/
  convertChangesToDMP = convertChangesToDMP; // See: http://code.google.com/p/google-diff-match-patch/wiki/API

  function convertChangesToDMP(changes) {
    var ret = [],
        change =
    /*istanbul ignore start*/
    void 0
    /*istanbul ignore end*/
    ,
        operation =
    /*istanbul ignore start*/
    void 0;

    for (var i = 0; i < changes.length; i++) {
      change = changes[i];

      if (change.added) {
        operation = 1;
      } else if (change.removed) {
        operation = -1;
      } else {
        operation = 0;
      }

      ret.push([operation, change.value]);
    }

    return ret;
  }
});
unwrapExports(dmp);

var xml = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.
  /*istanbul ignore end*/
  convertChangesToXML = convertChangesToXML;

  function convertChangesToXML(changes) {
    var ret = [];

    for (var i = 0; i < changes.length; i++) {
      var change = changes[i];

      if (change.added) {
        ret.push('<ins>');
      } else if (change.removed) {
        ret.push('<del>');
      }

      ret.push(escapeHTML(change.value));

      if (change.added) {
        ret.push('</ins>');
      } else if (change.removed) {
        ret.push('</del>');
      }
    }

    return ret.join('');
  }

  function escapeHTML(s) {
    var n = s;
    n = n.replace(/&/g, '&amp;');
    n = n.replace(/</g, '&lt;');
    n = n.replace(/>/g, '&gt;');
    n = n.replace(/"/g, '&quot;');
    return n;
  }
});
unwrapExports(xml);

var lib = createCommonjsModule(function (module, exports) {
  /*istanbul ignore start*/
  'use strict';

  exports.__esModule = true;
  exports.canonicalize = exports.convertChangesToXML = exports.convertChangesToDMP = exports.parsePatch = exports.applyPatches = exports.applyPatch = exports.createPatch = exports.createTwoFilesPatch = exports.structuredPatch = exports.diffArrays = exports.diffJson = exports.diffCss = exports.diffSentences = exports.diffTrimmedLines = exports.diffLines = exports.diffWordsWithSpace = exports.diffWords = exports.diffChars = exports.Diff = undefined;
  /*istanbul ignore end*/

  /*istanbul ignore start*/

  var _base2 = _interopRequireDefault(base);
  /*istanbul ignore end*/

  /*istanbul ignore start*/


  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      'default': obj
    };
  }

  exports.
  /*istanbul ignore end*/
  Diff = _base2['default'];
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffChars = character.diffChars;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffWords = word.diffWords;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffWordsWithSpace = word.diffWordsWithSpace;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffLines = line.diffLines;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffTrimmedLines = line.diffTrimmedLines;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffSentences = sentence.diffSentences;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffCss = css.diffCss;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffJson = json.diffJson;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  diffArrays = array.diffArrays;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  structuredPatch = create.structuredPatch;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  createTwoFilesPatch = create.createTwoFilesPatch;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  createPatch = create.createPatch;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  applyPatch = apply.applyPatch;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  applyPatches = apply.applyPatches;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  parsePatch = parse.parsePatch;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  convertChangesToDMP = dmp.convertChangesToDMP;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  convertChangesToXML = xml.convertChangesToXML;
  /*istanbul ignore start*/

  exports.
  /*istanbul ignore end*/
  canonicalize = json.canonicalize;
  /* See LICENSE file for terms of use */

  /*
   * Text diff implementation.
   *
   * This library supports the following APIS:
   * JsDiff.diffChars: Character by character diff
   * JsDiff.diffWords: Word (as defined by \b regex) diff which ignores whitespace
   * JsDiff.diffLines: Line based diff
   *
   * JsDiff.diffCss: Diff targeted at CSS content
   *
   * These methods are based on the implementation proposed in
   * "An O(ND) Difference Algorithm and its Variations" (Myers, 1986).
   * http://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.4.6927
   */
});
unwrapExports(lib);

/*!
 * normalize-path <https://github.com/jonschlinkert/normalize-path>
 *
 * Copyright (c) 2014-2018, Jon Schlinkert.
 * Released under the MIT License.
 */
var normalizePath = function normalizePath(path$$1, stripTrailing) {
  if (typeof path$$1 !== 'string') {
    throw new TypeError('expected path to be a string');
  }

  if (path$$1 === '\\' || path$$1 === '/') return '/';
  var len = path$$1.length;
  if (len <= 1) return path$$1; // ensure that win32 namespaces has two leading slashes, so that the path is
  // handled properly by the win32 version of path.parse() after being normalized
  // https://msdn.microsoft.com/library/windows/desktop/aa365247(v=vs.85).aspx#namespaces

  var prefix = '';

  if (len > 4 && path$$1[3] === '\\') {
    var ch = path$$1[2];

    if ((ch === '?' || ch === '.') && path$$1.slice(0, 2) === '\\\\') {
      path$$1 = path$$1.slice(2);
      prefix = '//';
    }
  }

  var segs = path$$1.split(/[/\\]+/);

  if (stripTrailing !== false && segs[segs.length - 1] === '') {
    segs.pop();
  }

  return prefix + segs.join('/');
};

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;

  try {
    Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}

function _construct(Parent, args, Class) {
  if (isNativeReflectConstruct()) {
    _construct = Reflect.construct;
  } else {
    _construct = function _construct(Parent, args, Class) {
      var a = [null];
      a.push.apply(a, args);
      var Constructor = Function.bind.apply(Parent, a);
      var instance = new Constructor();
      if (Class) _setPrototypeOf(instance, Class.prototype);
      return instance;
    };
  }

  return _construct.apply(null, arguments);
}

function _isNativeFunction(fn) {
  return Function.toString.call(fn).indexOf("[native code]") !== -1;
}

function _wrapNativeSuper(Class) {
  var _cache = typeof Map === "function" ? new Map() : undefined;

  _wrapNativeSuper = function _wrapNativeSuper(Class) {
    if (Class === null || !_isNativeFunction(Class)) return Class;

    if (typeof Class !== "function") {
      throw new TypeError("Super expression must either be null or a function");
    }

    if (typeof _cache !== "undefined") {
      if (_cache.has(Class)) return _cache.get(Class);

      _cache.set(Class, Wrapper);
    }

    function Wrapper() {
      return _construct(Class, arguments, _getPrototypeOf(this).constructor);
    }

    Wrapper.prototype = Object.create(Class.prototype, {
      constructor: {
        value: Wrapper,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    return _setPrototypeOf(Wrapper, Class);
  };

  return _wrapNativeSuper(Class);
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _possibleConstructorReturn(self, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

function _superPropBase(object, property) {
  while (!Object.prototype.hasOwnProperty.call(object, property)) {
    object = _getPrototypeOf(object);
    if (object === null) break;
  }

  return object;
}

function _get(target, property, receiver) {
  if (typeof Reflect !== "undefined" && Reflect.get) {
    _get = Reflect.get;
  } else {
    _get = function _get(target, property, receiver) {
      var base = _superPropBase(target, property);

      if (!base) return;
      var desc = Object.getOwnPropertyDescriptor(base, property);

      if (desc.get) {
        return desc.get.call(receiver);
      }

      return desc.value;
    };
  }

  return _get(target, property, receiver || target);
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}

function _toArray(arr) {
  return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  }
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

function _iterableToArrayLimit(arr, i) {
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];

  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }

  return (hint === "string" ? String : Number)(input);
}

function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");

  return typeof key === "symbol" ? key : String(key);
}

function _addElementPlacement(element, placements, silent) {
  var keys = placements[element.placement];

  if (!silent && keys.indexOf(element.key) !== -1) {
    throw new TypeError("Duplicated element (" + element.key + ")");
  }

  keys.push(element.key);
}

function _fromElementDescriptor(element) {
  var obj = {
    kind: element.kind,
    key: element.key,
    placement: element.placement,
    descriptor: element.descriptor
  };
  var desc = {
    value: "Descriptor",
    configurable: true
  };
  Object.defineProperty(obj, Symbol.toStringTag, desc);
  if (element.kind === "field") obj.initializer = element.initializer;
  return obj;
}

function _toElementDescriptors(elementObjects) {
  if (elementObjects === undefined) return;
  return _toArray(elementObjects).map(function (elementObject) {
    var element = _toElementDescriptor(elementObject);

    _disallowProperty(elementObject, "finisher", "An element descriptor");

    _disallowProperty(elementObject, "extras", "An element descriptor");

    return element;
  });
}

function _toElementDescriptor(elementObject) {
  var kind = String(elementObject.kind);

  if (kind !== "method" && kind !== "field") {
    throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"');
  }

  var key = _toPropertyKey(elementObject.key);

  var placement = String(elementObject.placement);

  if (placement !== "static" && placement !== "prototype" && placement !== "own") {
    throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"');
  }

  var descriptor = elementObject.descriptor;

  _disallowProperty(elementObject, "elements", "An element descriptor");

  var element = {
    kind: kind,
    key: key,
    placement: placement,
    descriptor: Object.assign({}, descriptor)
  };

  if (kind !== "field") {
    _disallowProperty(elementObject, "initializer", "A method descriptor");
  } else {
    _disallowProperty(descriptor, "get", "The property descriptor of a field descriptor");

    _disallowProperty(descriptor, "set", "The property descriptor of a field descriptor");

    _disallowProperty(descriptor, "value", "The property descriptor of a field descriptor");

    element.initializer = elementObject.initializer;
  }

  return element;
}

function _toElementFinisherExtras(elementObject) {
  var element = _toElementDescriptor(elementObject);

  var finisher = _optionalCallableProperty(elementObject, "finisher");

  var extras = _toElementDescriptors(elementObject.extras);

  return {
    element: element,
    finisher: finisher,
    extras: extras
  };
}

function _fromClassDescriptor(elements) {
  var obj = {
    kind: "class",
    elements: elements.map(_fromElementDescriptor)
  };
  var desc = {
    value: "Descriptor",
    configurable: true
  };
  Object.defineProperty(obj, Symbol.toStringTag, desc);
  return obj;
}

function _toClassDescriptor(obj) {
  var kind = String(obj.kind);

  if (kind !== "class") {
    throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"');
  }

  _disallowProperty(obj, "key", "A class descriptor");

  _disallowProperty(obj, "placement", "A class descriptor");

  _disallowProperty(obj, "descriptor", "A class descriptor");

  _disallowProperty(obj, "initializer", "A class descriptor");

  _disallowProperty(obj, "extras", "A class descriptor");

  var finisher = _optionalCallableProperty(obj, "finisher");

  var elements = _toElementDescriptors(obj.elements);

  return {
    elements: elements,
    finisher: finisher
  };
}

function _disallowProperty(obj, name, objectType) {
  if (obj[name] !== undefined) {
    throw new TypeError(objectType + " can't have a ." + name + " property.");
  }
}

function _optionalCallableProperty(obj, name) {
  var value = obj[name];

  if (value !== undefined && typeof value !== "function") {
    throw new TypeError("Expected '" + name + "' to be a function");
  }

  return value;
}

/**
 * @class
 */


var LineByLine =
/*#__PURE__*/
function () {
  function LineByLine(file, options) {
    _classCallCheck(this, LineByLine);

    options = options || {};
    if (!options.readChunk) options.readChunk = 1024;

    if (!options.newLineCharacter) {
      options.newLineCharacter = 0x0a; //linux line ending
    } else {
      options.newLineCharacter = options.newLineCharacter.charCodeAt(0);
    }

    if (typeof file === 'number') {
      this.fd = file;
    } else {
      this.fd = fs.openSync(file, 'r');
    }

    this.options = options;
    this.newLineCharacter = options.newLineCharacter;
    this.reset();
  }

  _createClass(LineByLine, [{
    key: "_searchInBuffer",
    value: function _searchInBuffer(buffer, hexNeedle) {
      var found = -1;

      for (var i = 0; i <= buffer.length; i++) {
        var b_byte = buffer[i];

        if (b_byte === hexNeedle) {
          found = i;
          break;
        }
      }

      return found;
    }
  }, {
    key: "reset",
    value: function reset() {
      this.eofReached = false;
      this.linesCache = [];
      this.fdPosition = 0;
    }
  }, {
    key: "close",
    value: function close() {
      fs.closeSync(this.fd);
      this.fd = null;
    }
  }, {
    key: "_extractLines",
    value: function _extractLines(buffer) {
      var line;
      var lines = [];
      var bufferPosition = 0;
      var lastNewLineBufferPosition = 0;

      while (true) {
        var bufferPositionValue = buffer[bufferPosition++];

        if (bufferPositionValue === this.newLineCharacter) {
          line = buffer.slice(lastNewLineBufferPosition, bufferPosition);
          lines.push(line);
          lastNewLineBufferPosition = bufferPosition;
        } else if (!bufferPositionValue) {
          break;
        }
      }

      var leftovers = buffer.slice(lastNewLineBufferPosition, bufferPosition);

      if (leftovers.length) {
        lines.push(leftovers);
      }

      return lines;
    }
  }, {
    key: "_readChunk",
    value: function _readChunk(lineLeftovers) {
      var totalBytesRead = 0;
      var bytesRead;
      var buffers = [];

      do {
        var readBuffer = new Buffer(this.options.readChunk);
        bytesRead = fs.readSync(this.fd, readBuffer, 0, this.options.readChunk, this.fdPosition);
        totalBytesRead = totalBytesRead + bytesRead;
        this.fdPosition = this.fdPosition + bytesRead;
        buffers.push(readBuffer);
      } while (bytesRead && this._searchInBuffer(buffers[buffers.length - 1], this.options.newLineCharacter) === -1);

      var bufferData = Buffer.concat(buffers);

      if (bytesRead < this.options.readChunk) {
        this.eofReached = true;
        bufferData = bufferData.slice(0, totalBytesRead);
      }

      if (totalBytesRead) {
        this.linesCache = this._extractLines(bufferData);

        if (lineLeftovers) {
          this.linesCache[0] = Buffer.concat([lineLeftovers, this.linesCache[0]]);
        }
      }

      return totalBytesRead;
    }
  }, {
    key: "next",
    value: function next() {
      if (!this.fd) return false;
      var line = false;

      if (this.eofReached && this.linesCache.length === 0) {
        return line;
      }

      var bytesRead;

      if (!this.linesCache.length) {
        bytesRead = this._readChunk();
      }

      if (this.linesCache.length) {
        line = this.linesCache.shift();
        var lastLineCharacter = line[line.length - 1];

        if (lastLineCharacter !== 0x0a) {
          bytesRead = this._readChunk(line);

          if (bytesRead) {
            line = this.linesCache.shift();
          }
        }
      }

      if (this.eofReached && this.linesCache.length === 0) {
        this.close();
      }

      if (line && line[line.length - 1] === this.newLineCharacter) {
        line = line.slice(0, line.length - 1);
      }

      return line;
    }
  }]);

  return LineByLine;
}();

var readlines = LineByLine;

var ConfigError =
/*#__PURE__*/
function (_Error) {
  _inherits(ConfigError, _Error);

  function ConfigError() {
    _classCallCheck(this, ConfigError);

    return _possibleConstructorReturn(this, _getPrototypeOf(ConfigError).apply(this, arguments));
  }

  return ConfigError;
}(_wrapNativeSuper(Error));

var DebugError =
/*#__PURE__*/
function (_Error2) {
  _inherits(DebugError, _Error2);

  function DebugError() {
    _classCallCheck(this, DebugError);

    return _possibleConstructorReturn(this, _getPrototypeOf(DebugError).apply(this, arguments));
  }

  return DebugError;
}(_wrapNativeSuper(Error));

var UndefinedParserError$1 =
/*#__PURE__*/
function (_Error3) {
  _inherits(UndefinedParserError, _Error3);

  function UndefinedParserError() {
    _classCallCheck(this, UndefinedParserError);

    return _possibleConstructorReturn(this, _getPrototypeOf(UndefinedParserError).apply(this, arguments));
  }

  return UndefinedParserError;
}(_wrapNativeSuper(Error));

var errors = {
  ConfigError,
  DebugError,
  UndefinedParserError: UndefinedParserError$1
};

var semver = createCommonjsModule(function (module, exports) {
  exports = module.exports = SemVer; // The debug function is excluded entirely from the minified version.

  /* nomin */

  var debug;
  /* nomin */

  if (typeof process === 'object' &&
  /* nomin */
  process.env &&
  /* nomin */
  process.env.NODE_DEBUG &&
  /* nomin */
  /\bsemver\b/i.test(process.env.NODE_DEBUG))
    /* nomin */
    debug = function debug() {
      /* nomin */
      var args = Array.prototype.slice.call(arguments, 0);
      /* nomin */

      args.unshift('SEMVER');
      /* nomin */

      console.log.apply(console, args);
      /* nomin */
    };
    /* nomin */
  else
    /* nomin */
    debug = function debug() {}; // Note: this is the semver.org version of the spec that it implements
  // Not necessarily the package version of this code.

  exports.SEMVER_SPEC_VERSION = '2.0.0';
  var MAX_LENGTH = 256;
  var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991; // The actual regexps go on exports.re

  var re = exports.re = [];
  var src = exports.src = [];
  var R = 0; // The following Regular Expressions can be used for tokenizing,
  // validating, and parsing SemVer version strings.
  // ## Numeric Identifier
  // A single `0`, or a non-zero digit followed by zero or more digits.

  var NUMERICIDENTIFIER = R++;
  src[NUMERICIDENTIFIER] = '0|[1-9]\\d*';
  var NUMERICIDENTIFIERLOOSE = R++;
  src[NUMERICIDENTIFIERLOOSE] = '[0-9]+'; // ## Non-numeric Identifier
  // Zero or more digits, followed by a letter or hyphen, and then zero or
  // more letters, digits, or hyphens.

  var NONNUMERICIDENTIFIER = R++;
  src[NONNUMERICIDENTIFIER] = '\\d*[a-zA-Z-][a-zA-Z0-9-]*'; // ## Main Version
  // Three dot-separated numeric identifiers.

  var MAINVERSION = R++;
  src[MAINVERSION] = '(' + src[NUMERICIDENTIFIER] + ')\\.' + '(' + src[NUMERICIDENTIFIER] + ')\\.' + '(' + src[NUMERICIDENTIFIER] + ')';
  var MAINVERSIONLOOSE = R++;
  src[MAINVERSIONLOOSE] = '(' + src[NUMERICIDENTIFIERLOOSE] + ')\\.' + '(' + src[NUMERICIDENTIFIERLOOSE] + ')\\.' + '(' + src[NUMERICIDENTIFIERLOOSE] + ')'; // ## Pre-release Version Identifier
  // A numeric identifier, or a non-numeric identifier.

  var PRERELEASEIDENTIFIER = R++;
  src[PRERELEASEIDENTIFIER] = '(?:' + src[NUMERICIDENTIFIER] + '|' + src[NONNUMERICIDENTIFIER] + ')';
  var PRERELEASEIDENTIFIERLOOSE = R++;
  src[PRERELEASEIDENTIFIERLOOSE] = '(?:' + src[NUMERICIDENTIFIERLOOSE] + '|' + src[NONNUMERICIDENTIFIER] + ')'; // ## Pre-release Version
  // Hyphen, followed by one or more dot-separated pre-release version
  // identifiers.

  var PRERELEASE = R++;
  src[PRERELEASE] = '(?:-(' + src[PRERELEASEIDENTIFIER] + '(?:\\.' + src[PRERELEASEIDENTIFIER] + ')*))';
  var PRERELEASELOOSE = R++;
  src[PRERELEASELOOSE] = '(?:-?(' + src[PRERELEASEIDENTIFIERLOOSE] + '(?:\\.' + src[PRERELEASEIDENTIFIERLOOSE] + ')*))'; // ## Build Metadata Identifier
  // Any combination of digits, letters, or hyphens.

  var BUILDIDENTIFIER = R++;
  src[BUILDIDENTIFIER] = '[0-9A-Za-z-]+'; // ## Build Metadata
  // Plus sign, followed by one or more period-separated build metadata
  // identifiers.

  var BUILD = R++;
  src[BUILD] = '(?:\\+(' + src[BUILDIDENTIFIER] + '(?:\\.' + src[BUILDIDENTIFIER] + ')*))'; // ## Full Version String
  // A main version, followed optionally by a pre-release version and
  // build metadata.
  // Note that the only major, minor, patch, and pre-release sections of
  // the version string are capturing groups.  The build metadata is not a
  // capturing group, because it should not ever be used in version
  // comparison.

  var FULL = R++;
  var FULLPLAIN = 'v?' + src[MAINVERSION] + src[PRERELEASE] + '?' + src[BUILD] + '?';
  src[FULL] = '^' + FULLPLAIN + '$'; // like full, but allows v1.2.3 and =1.2.3, which people do sometimes.
  // also, 1.0.0alpha1 (prerelease without the hyphen) which is pretty
  // common in the npm registry.

  var LOOSEPLAIN = '[v=\\s]*' + src[MAINVERSIONLOOSE] + src[PRERELEASELOOSE] + '?' + src[BUILD] + '?';
  var LOOSE = R++;
  src[LOOSE] = '^' + LOOSEPLAIN + '$';
  var GTLT = R++;
  src[GTLT] = '((?:<|>)?=?)'; // Something like "2.*" or "1.2.x".
  // Note that "x.x" is a valid xRange identifer, meaning "any version"
  // Only the first item is strictly required.

  var XRANGEIDENTIFIERLOOSE = R++;
  src[XRANGEIDENTIFIERLOOSE] = src[NUMERICIDENTIFIERLOOSE] + '|x|X|\\*';
  var XRANGEIDENTIFIER = R++;
  src[XRANGEIDENTIFIER] = src[NUMERICIDENTIFIER] + '|x|X|\\*';
  var XRANGEPLAIN = R++;
  src[XRANGEPLAIN] = '[v=\\s]*(' + src[XRANGEIDENTIFIER] + ')' + '(?:\\.(' + src[XRANGEIDENTIFIER] + ')' + '(?:\\.(' + src[XRANGEIDENTIFIER] + ')' + '(?:' + src[PRERELEASE] + ')?' + src[BUILD] + '?' + ')?)?';
  var XRANGEPLAINLOOSE = R++;
  src[XRANGEPLAINLOOSE] = '[v=\\s]*(' + src[XRANGEIDENTIFIERLOOSE] + ')' + '(?:\\.(' + src[XRANGEIDENTIFIERLOOSE] + ')' + '(?:\\.(' + src[XRANGEIDENTIFIERLOOSE] + ')' + '(?:' + src[PRERELEASELOOSE] + ')?' + src[BUILD] + '?' + ')?)?';
  var XRANGE = R++;
  src[XRANGE] = '^' + src[GTLT] + '\\s*' + src[XRANGEPLAIN] + '$';
  var XRANGELOOSE = R++;
  src[XRANGELOOSE] = '^' + src[GTLT] + '\\s*' + src[XRANGEPLAINLOOSE] + '$'; // Tilde ranges.
  // Meaning is "reasonably at or greater than"

  var LONETILDE = R++;
  src[LONETILDE] = '(?:~>?)';
  var TILDETRIM = R++;
  src[TILDETRIM] = '(\\s*)' + src[LONETILDE] + '\\s+';
  re[TILDETRIM] = new RegExp(src[TILDETRIM], 'g');
  var tildeTrimReplace = '$1~';
  var TILDE = R++;
  src[TILDE] = '^' + src[LONETILDE] + src[XRANGEPLAIN] + '$';
  var TILDELOOSE = R++;
  src[TILDELOOSE] = '^' + src[LONETILDE] + src[XRANGEPLAINLOOSE] + '$'; // Caret ranges.
  // Meaning is "at least and backwards compatible with"

  var LONECARET = R++;
  src[LONECARET] = '(?:\\^)';
  var CARETTRIM = R++;
  src[CARETTRIM] = '(\\s*)' + src[LONECARET] + '\\s+';
  re[CARETTRIM] = new RegExp(src[CARETTRIM], 'g');
  var caretTrimReplace = '$1^';
  var CARET = R++;
  src[CARET] = '^' + src[LONECARET] + src[XRANGEPLAIN] + '$';
  var CARETLOOSE = R++;
  src[CARETLOOSE] = '^' + src[LONECARET] + src[XRANGEPLAINLOOSE] + '$'; // A simple gt/lt/eq thing, or just "" to indicate "any version"

  var COMPARATORLOOSE = R++;
  src[COMPARATORLOOSE] = '^' + src[GTLT] + '\\s*(' + LOOSEPLAIN + ')$|^$';
  var COMPARATOR = R++;
  src[COMPARATOR] = '^' + src[GTLT] + '\\s*(' + FULLPLAIN + ')$|^$'; // An expression to strip any whitespace between the gtlt and the thing
  // it modifies, so that `> 1.2.3` ==> `>1.2.3`

  var COMPARATORTRIM = R++;
  src[COMPARATORTRIM] = '(\\s*)' + src[GTLT] + '\\s*(' + LOOSEPLAIN + '|' + src[XRANGEPLAIN] + ')'; // this one has to use the /g flag

  re[COMPARATORTRIM] = new RegExp(src[COMPARATORTRIM], 'g');
  var comparatorTrimReplace = '$1$2$3'; // Something like `1.2.3 - 1.2.4`
  // Note that these all use the loose form, because they'll be
  // checked against either the strict or loose comparator form
  // later.

  var HYPHENRANGE = R++;
  src[HYPHENRANGE] = '^\\s*(' + src[XRANGEPLAIN] + ')' + '\\s+-\\s+' + '(' + src[XRANGEPLAIN] + ')' + '\\s*$';
  var HYPHENRANGELOOSE = R++;
  src[HYPHENRANGELOOSE] = '^\\s*(' + src[XRANGEPLAINLOOSE] + ')' + '\\s+-\\s+' + '(' + src[XRANGEPLAINLOOSE] + ')' + '\\s*$'; // Star ranges basically just allow anything at all.

  var STAR = R++;
  src[STAR] = '(<|>)?=?\\s*\\*'; // Compile to actual regexp objects.
  // All are flag-free, unless they were created above with a flag.

  for (var i = 0; i < R; i++) {
    debug(i, src[i]);
    if (!re[i]) re[i] = new RegExp(src[i]);
  }

  exports.parse = parse;

  function parse(version, loose) {
    if (version instanceof SemVer) return version;
    if (typeof version !== 'string') return null;
    if (version.length > MAX_LENGTH) return null;
    var r = loose ? re[LOOSE] : re[FULL];
    if (!r.test(version)) return null;

    try {
      return new SemVer(version, loose);
    } catch (er) {
      return null;
    }
  }

  exports.valid = valid;

  function valid(version, loose) {
    var v = parse(version, loose);
    return v ? v.version : null;
  }

  exports.clean = clean;

  function clean(version, loose) {
    var s = parse(version.trim().replace(/^[=v]+/, ''), loose);
    return s ? s.version : null;
  }

  exports.SemVer = SemVer;

  function SemVer(version, loose) {
    if (version instanceof SemVer) {
      if (version.loose === loose) return version;else version = version.version;
    } else if (typeof version !== 'string') {
      throw new TypeError('Invalid Version: ' + version);
    }

    if (version.length > MAX_LENGTH) throw new TypeError('version is longer than ' + MAX_LENGTH + ' characters');
    if (!(this instanceof SemVer)) return new SemVer(version, loose);
    debug('SemVer', version, loose);
    this.loose = loose;
    var m = version.trim().match(loose ? re[LOOSE] : re[FULL]);
    if (!m) throw new TypeError('Invalid Version: ' + version);
    this.raw = version; // these are actually numbers

    this.major = +m[1];
    this.minor = +m[2];
    this.patch = +m[3];
    if (this.major > MAX_SAFE_INTEGER || this.major < 0) throw new TypeError('Invalid major version');
    if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) throw new TypeError('Invalid minor version');
    if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) throw new TypeError('Invalid patch version'); // numberify any prerelease numeric ids

    if (!m[4]) this.prerelease = [];else this.prerelease = m[4].split('.').map(function (id) {
      if (/^[0-9]+$/.test(id)) {
        var num = +id;
        if (num >= 0 && num < MAX_SAFE_INTEGER) return num;
      }

      return id;
    });
    this.build = m[5] ? m[5].split('.') : [];
    this.format();
  }

  SemVer.prototype.format = function () {
    this.version = this.major + '.' + this.minor + '.' + this.patch;
    if (this.prerelease.length) this.version += '-' + this.prerelease.join('.');
    return this.version;
  };

  SemVer.prototype.toString = function () {
    return this.version;
  };

  SemVer.prototype.compare = function (other) {
    debug('SemVer.compare', this.version, this.loose, other);
    if (!(other instanceof SemVer)) other = new SemVer(other, this.loose);
    return this.compareMain(other) || this.comparePre(other);
  };

  SemVer.prototype.compareMain = function (other) {
    if (!(other instanceof SemVer)) other = new SemVer(other, this.loose);
    return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
  };

  SemVer.prototype.comparePre = function (other) {
    if (!(other instanceof SemVer)) other = new SemVer(other, this.loose); // NOT having a prerelease is > having one

    if (this.prerelease.length && !other.prerelease.length) return -1;else if (!this.prerelease.length && other.prerelease.length) return 1;else if (!this.prerelease.length && !other.prerelease.length) return 0;
    var i = 0;

    do {
      var a = this.prerelease[i];
      var b = other.prerelease[i];
      debug('prerelease compare', i, a, b);
      if (a === undefined && b === undefined) return 0;else if (b === undefined) return 1;else if (a === undefined) return -1;else if (a === b) continue;else return compareIdentifiers(a, b);
    } while (++i);
  }; // preminor will bump the version up to the next minor release, and immediately
  // down to pre-release. premajor and prepatch work the same way.


  SemVer.prototype.inc = function (release, identifier) {
    switch (release) {
      case 'premajor':
        this.prerelease.length = 0;
        this.patch = 0;
        this.minor = 0;
        this.major++;
        this.inc('pre', identifier);
        break;

      case 'preminor':
        this.prerelease.length = 0;
        this.patch = 0;
        this.minor++;
        this.inc('pre', identifier);
        break;

      case 'prepatch':
        // If this is already a prerelease, it will bump to the next version
        // drop any prereleases that might already exist, since they are not
        // relevant at this point.
        this.prerelease.length = 0;
        this.inc('patch', identifier);
        this.inc('pre', identifier);
        break;
      // If the input is a non-prerelease version, this acts the same as
      // prepatch.

      case 'prerelease':
        if (this.prerelease.length === 0) this.inc('patch', identifier);
        this.inc('pre', identifier);
        break;

      case 'major':
        // If this is a pre-major version, bump up to the same major version.
        // Otherwise increment major.
        // 1.0.0-5 bumps to 1.0.0
        // 1.1.0 bumps to 2.0.0
        if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) this.major++;
        this.minor = 0;
        this.patch = 0;
        this.prerelease = [];
        break;

      case 'minor':
        // If this is a pre-minor version, bump up to the same minor version.
        // Otherwise increment minor.
        // 1.2.0-5 bumps to 1.2.0
        // 1.2.1 bumps to 1.3.0
        if (this.patch !== 0 || this.prerelease.length === 0) this.minor++;
        this.patch = 0;
        this.prerelease = [];
        break;

      case 'patch':
        // If this is not a pre-release version, it will increment the patch.
        // If it is a pre-release it will bump up to the same patch version.
        // 1.2.0-5 patches to 1.2.0
        // 1.2.0 patches to 1.2.1
        if (this.prerelease.length === 0) this.patch++;
        this.prerelease = [];
        break;
      // This probably shouldn't be used publicly.
      // 1.0.0 "pre" would become 1.0.0-0 which is the wrong direction.

      case 'pre':
        if (this.prerelease.length === 0) this.prerelease = [0];else {
          var i = this.prerelease.length;

          while (--i >= 0) {
            if (typeof this.prerelease[i] === 'number') {
              this.prerelease[i]++;
              i = -2;
            }
          }

          if (i === -1) // didn't increment anything
            this.prerelease.push(0);
        }

        if (identifier) {
          // 1.2.0-beta.1 bumps to 1.2.0-beta.2,
          // 1.2.0-beta.fooblz or 1.2.0-beta bumps to 1.2.0-beta.0
          if (this.prerelease[0] === identifier) {
            if (isNaN(this.prerelease[1])) this.prerelease = [identifier, 0];
          } else this.prerelease = [identifier, 0];
        }

        break;

      default:
        throw new Error('invalid increment argument: ' + release);
    }

    this.format();
    this.raw = this.version;
    return this;
  };

  exports.inc = inc;

  function inc(version, release, loose, identifier) {
    if (typeof loose === 'string') {
      identifier = loose;
      loose = undefined;
    }

    try {
      return new SemVer(version, loose).inc(release, identifier).version;
    } catch (er) {
      return null;
    }
  }

  exports.diff = diff;

  function diff(version1, version2) {
    if (eq(version1, version2)) {
      return null;
    } else {
      var v1 = parse(version1);
      var v2 = parse(version2);

      if (v1.prerelease.length || v2.prerelease.length) {
        for (var key in v1) {
          if (key === 'major' || key === 'minor' || key === 'patch') {
            if (v1[key] !== v2[key]) {
              return 'pre' + key;
            }
          }
        }

        return 'prerelease';
      }

      for (var key in v1) {
        if (key === 'major' || key === 'minor' || key === 'patch') {
          if (v1[key] !== v2[key]) {
            return key;
          }
        }
      }
    }
  }

  exports.compareIdentifiers = compareIdentifiers;
  var numeric = /^[0-9]+$/;

  function compareIdentifiers(a, b) {
    var anum = numeric.test(a);
    var bnum = numeric.test(b);

    if (anum && bnum) {
      a = +a;
      b = +b;
    }

    return anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : a > b ? 1 : 0;
  }

  exports.rcompareIdentifiers = rcompareIdentifiers;

  function rcompareIdentifiers(a, b) {
    return compareIdentifiers(b, a);
  }

  exports.major = major;

  function major(a, loose) {
    return new SemVer(a, loose).major;
  }

  exports.minor = minor;

  function minor(a, loose) {
    return new SemVer(a, loose).minor;
  }

  exports.patch = patch;

  function patch(a, loose) {
    return new SemVer(a, loose).patch;
  }

  exports.compare = compare;

  function compare(a, b, loose) {
    return new SemVer(a, loose).compare(new SemVer(b, loose));
  }

  exports.compareLoose = compareLoose;

  function compareLoose(a, b) {
    return compare(a, b, true);
  }

  exports.rcompare = rcompare;

  function rcompare(a, b, loose) {
    return compare(b, a, loose);
  }

  exports.sort = sort;

  function sort(list, loose) {
    return list.sort(function (a, b) {
      return exports.compare(a, b, loose);
    });
  }

  exports.rsort = rsort;

  function rsort(list, loose) {
    return list.sort(function (a, b) {
      return exports.rcompare(a, b, loose);
    });
  }

  exports.gt = gt;

  function gt(a, b, loose) {
    return compare(a, b, loose) > 0;
  }

  exports.lt = lt;

  function lt(a, b, loose) {
    return compare(a, b, loose) < 0;
  }

  exports.eq = eq;

  function eq(a, b, loose) {
    return compare(a, b, loose) === 0;
  }

  exports.neq = neq;

  function neq(a, b, loose) {
    return compare(a, b, loose) !== 0;
  }

  exports.gte = gte;

  function gte(a, b, loose) {
    return compare(a, b, loose) >= 0;
  }

  exports.lte = lte;

  function lte(a, b, loose) {
    return compare(a, b, loose) <= 0;
  }

  exports.cmp = cmp;

  function cmp(a, op, b, loose) {
    var ret;

    switch (op) {
      case '===':
        if (typeof a === 'object') a = a.version;
        if (typeof b === 'object') b = b.version;
        ret = a === b;
        break;

      case '!==':
        if (typeof a === 'object') a = a.version;
        if (typeof b === 'object') b = b.version;
        ret = a !== b;
        break;

      case '':
      case '=':
      case '==':
        ret = eq(a, b, loose);
        break;

      case '!=':
        ret = neq(a, b, loose);
        break;

      case '>':
        ret = gt(a, b, loose);
        break;

      case '>=':
        ret = gte(a, b, loose);
        break;

      case '<':
        ret = lt(a, b, loose);
        break;

      case '<=':
        ret = lte(a, b, loose);
        break;

      default:
        throw new TypeError('Invalid operator: ' + op);
    }

    return ret;
  }

  exports.Comparator = Comparator;

  function Comparator(comp, loose) {
    if (comp instanceof Comparator) {
      if (comp.loose === loose) return comp;else comp = comp.value;
    }

    if (!(this instanceof Comparator)) return new Comparator(comp, loose);
    debug('comparator', comp, loose);
    this.loose = loose;
    this.parse(comp);
    if (this.semver === ANY) this.value = '';else this.value = this.operator + this.semver.version;
    debug('comp', this);
  }

  var ANY = {};

  Comparator.prototype.parse = function (comp) {
    var r = this.loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
    var m = comp.match(r);
    if (!m) throw new TypeError('Invalid comparator: ' + comp);
    this.operator = m[1];
    if (this.operator === '=') this.operator = ''; // if it literally is just '>' or '' then allow anything.

    if (!m[2]) this.semver = ANY;else this.semver = new SemVer(m[2], this.loose);
  };

  Comparator.prototype.toString = function () {
    return this.value;
  };

  Comparator.prototype.test = function (version) {
    debug('Comparator.test', version, this.loose);
    if (this.semver === ANY) return true;
    if (typeof version === 'string') version = new SemVer(version, this.loose);
    return cmp(version, this.operator, this.semver, this.loose);
  };

  Comparator.prototype.intersects = function (comp, loose) {
    if (!(comp instanceof Comparator)) {
      throw new TypeError('a Comparator is required');
    }

    var rangeTmp;

    if (this.operator === '') {
      rangeTmp = new Range(comp.value, loose);
      return satisfies(this.value, rangeTmp, loose);
    } else if (comp.operator === '') {
      rangeTmp = new Range(this.value, loose);
      return satisfies(comp.semver, rangeTmp, loose);
    }

    var sameDirectionIncreasing = (this.operator === '>=' || this.operator === '>') && (comp.operator === '>=' || comp.operator === '>');
    var sameDirectionDecreasing = (this.operator === '<=' || this.operator === '<') && (comp.operator === '<=' || comp.operator === '<');
    var sameSemVer = this.semver.version === comp.semver.version;
    var differentDirectionsInclusive = (this.operator === '>=' || this.operator === '<=') && (comp.operator === '>=' || comp.operator === '<=');
    var oppositeDirectionsLessThan = cmp(this.semver, '<', comp.semver, loose) && (this.operator === '>=' || this.operator === '>') && (comp.operator === '<=' || comp.operator === '<');
    var oppositeDirectionsGreaterThan = cmp(this.semver, '>', comp.semver, loose) && (this.operator === '<=' || this.operator === '<') && (comp.operator === '>=' || comp.operator === '>');
    return sameDirectionIncreasing || sameDirectionDecreasing || sameSemVer && differentDirectionsInclusive || oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
  };

  exports.Range = Range;

  function Range(range, loose) {
    if (range instanceof Range) {
      if (range.loose === loose) {
        return range;
      } else {
        return new Range(range.raw, loose);
      }
    }

    if (range instanceof Comparator) {
      return new Range(range.value, loose);
    }

    if (!(this instanceof Range)) return new Range(range, loose);
    this.loose = loose; // First, split based on boolean or ||

    this.raw = range;
    this.set = range.split(/\s*\|\|\s*/).map(function (range) {
      return this.parseRange(range.trim());
    }, this).filter(function (c) {
      // throw out any that are not relevant for whatever reason
      return c.length;
    });

    if (!this.set.length) {
      throw new TypeError('Invalid SemVer Range: ' + range);
    }

    this.format();
  }

  Range.prototype.format = function () {
    this.range = this.set.map(function (comps) {
      return comps.join(' ').trim();
    }).join('||').trim();
    return this.range;
  };

  Range.prototype.toString = function () {
    return this.range;
  };

  Range.prototype.parseRange = function (range) {
    var loose = this.loose;
    range = range.trim();
    debug('range', range, loose); // `1.2.3 - 1.2.4` => `>=1.2.3 <=1.2.4`

    var hr = loose ? re[HYPHENRANGELOOSE] : re[HYPHENRANGE];
    range = range.replace(hr, hyphenReplace);
    debug('hyphen replace', range); // `> 1.2.3 < 1.2.5` => `>1.2.3 <1.2.5`

    range = range.replace(re[COMPARATORTRIM], comparatorTrimReplace);
    debug('comparator trim', range, re[COMPARATORTRIM]); // `~ 1.2.3` => `~1.2.3`

    range = range.replace(re[TILDETRIM], tildeTrimReplace); // `^ 1.2.3` => `^1.2.3`

    range = range.replace(re[CARETTRIM], caretTrimReplace); // normalize spaces

    range = range.split(/\s+/).join(' '); // At this point, the range is completely trimmed and
    // ready to be split into comparators.

    var compRe = loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
    var set = range.split(' ').map(function (comp) {
      return parseComparator(comp, loose);
    }).join(' ').split(/\s+/);

    if (this.loose) {
      // in loose mode, throw out any that are not valid comparators
      set = set.filter(function (comp) {
        return !!comp.match(compRe);
      });
    }

    set = set.map(function (comp) {
      return new Comparator(comp, loose);
    });
    return set;
  };

  Range.prototype.intersects = function (range, loose) {
    if (!(range instanceof Range)) {
      throw new TypeError('a Range is required');
    }

    return this.set.some(function (thisComparators) {
      return thisComparators.every(function (thisComparator) {
        return range.set.some(function (rangeComparators) {
          return rangeComparators.every(function (rangeComparator) {
            return thisComparator.intersects(rangeComparator, loose);
          });
        });
      });
    });
  }; // Mostly just for testing and legacy API reasons


  exports.toComparators = toComparators;

  function toComparators(range, loose) {
    return new Range(range, loose).set.map(function (comp) {
      return comp.map(function (c) {
        return c.value;
      }).join(' ').trim().split(' ');
    });
  } // comprised of xranges, tildes, stars, and gtlt's at this point.
  // already replaced the hyphen ranges
  // turn into a set of JUST comparators.


  function parseComparator(comp, loose) {
    debug('comp', comp);
    comp = replaceCarets(comp, loose);
    debug('caret', comp);
    comp = replaceTildes(comp, loose);
    debug('tildes', comp);
    comp = replaceXRanges(comp, loose);
    debug('xrange', comp);
    comp = replaceStars(comp, loose);
    debug('stars', comp);
    return comp;
  }

  function isX(id) {
    return !id || id.toLowerCase() === 'x' || id === '*';
  } // ~, ~> --> * (any, kinda silly)
  // ~2, ~2.x, ~2.x.x, ~>2, ~>2.x ~>2.x.x --> >=2.0.0 <3.0.0
  // ~2.0, ~2.0.x, ~>2.0, ~>2.0.x --> >=2.0.0 <2.1.0
  // ~1.2, ~1.2.x, ~>1.2, ~>1.2.x --> >=1.2.0 <1.3.0
  // ~1.2.3, ~>1.2.3 --> >=1.2.3 <1.3.0
  // ~1.2.0, ~>1.2.0 --> >=1.2.0 <1.3.0


  function replaceTildes(comp, loose) {
    return comp.trim().split(/\s+/).map(function (comp) {
      return replaceTilde(comp, loose);
    }).join(' ');
  }

  function replaceTilde(comp, loose) {
    var r = loose ? re[TILDELOOSE] : re[TILDE];
    return comp.replace(r, function (_, M, m, p, pr) {
      debug('tilde', comp, _, M, m, p, pr);
      var ret;
      if (isX(M)) ret = '';else if (isX(m)) ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';else if (isX(p)) // ~1.2 == >=1.2.0 <1.3.0
        ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';else if (pr) {
        debug('replaceTilde pr', pr);
        if (pr.charAt(0) !== '-') pr = '-' + pr;
        ret = '>=' + M + '.' + m + '.' + p + pr + ' <' + M + '.' + (+m + 1) + '.0';
      } else // ~1.2.3 == >=1.2.3 <1.3.0
        ret = '>=' + M + '.' + m + '.' + p + ' <' + M + '.' + (+m + 1) + '.0';
      debug('tilde return', ret);
      return ret;
    });
  } // ^ --> * (any, kinda silly)
  // ^2, ^2.x, ^2.x.x --> >=2.0.0 <3.0.0
  // ^2.0, ^2.0.x --> >=2.0.0 <3.0.0
  // ^1.2, ^1.2.x --> >=1.2.0 <2.0.0
  // ^1.2.3 --> >=1.2.3 <2.0.0
  // ^1.2.0 --> >=1.2.0 <2.0.0


  function replaceCarets(comp, loose) {
    return comp.trim().split(/\s+/).map(function (comp) {
      return replaceCaret(comp, loose);
    }).join(' ');
  }

  function replaceCaret(comp, loose) {
    debug('caret', comp, loose);
    var r = loose ? re[CARETLOOSE] : re[CARET];
    return comp.replace(r, function (_, M, m, p, pr) {
      debug('caret', comp, _, M, m, p, pr);
      var ret;
      if (isX(M)) ret = '';else if (isX(m)) ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';else if (isX(p)) {
        if (M === '0') ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';else ret = '>=' + M + '.' + m + '.0 <' + (+M + 1) + '.0.0';
      } else if (pr) {
        debug('replaceCaret pr', pr);
        if (pr.charAt(0) !== '-') pr = '-' + pr;

        if (M === '0') {
          if (m === '0') ret = '>=' + M + '.' + m + '.' + p + pr + ' <' + M + '.' + m + '.' + (+p + 1);else ret = '>=' + M + '.' + m + '.' + p + pr + ' <' + M + '.' + (+m + 1) + '.0';
        } else ret = '>=' + M + '.' + m + '.' + p + pr + ' <' + (+M + 1) + '.0.0';
      } else {
        debug('no pr');

        if (M === '0') {
          if (m === '0') ret = '>=' + M + '.' + m + '.' + p + ' <' + M + '.' + m + '.' + (+p + 1);else ret = '>=' + M + '.' + m + '.' + p + ' <' + M + '.' + (+m + 1) + '.0';
        } else ret = '>=' + M + '.' + m + '.' + p + ' <' + (+M + 1) + '.0.0';
      }
      debug('caret return', ret);
      return ret;
    });
  }

  function replaceXRanges(comp, loose) {
    debug('replaceXRanges', comp, loose);
    return comp.split(/\s+/).map(function (comp) {
      return replaceXRange(comp, loose);
    }).join(' ');
  }

  function replaceXRange(comp, loose) {
    comp = comp.trim();
    var r = loose ? re[XRANGELOOSE] : re[XRANGE];
    return comp.replace(r, function (ret, gtlt, M, m, p, pr) {
      debug('xRange', comp, ret, gtlt, M, m, p, pr);
      var xM = isX(M);
      var xm = xM || isX(m);
      var xp = xm || isX(p);
      var anyX = xp;
      if (gtlt === '=' && anyX) gtlt = '';

      if (xM) {
        if (gtlt === '>' || gtlt === '<') {
          // nothing is allowed
          ret = '<0.0.0';
        } else {
          // nothing is forbidden
          ret = '*';
        }
      } else if (gtlt && anyX) {
        // replace X with 0
        if (xm) m = 0;
        if (xp) p = 0;

        if (gtlt === '>') {
          // >1 => >=2.0.0
          // >1.2 => >=1.3.0
          // >1.2.3 => >= 1.2.4
          gtlt = '>=';

          if (xm) {
            M = +M + 1;
            m = 0;
            p = 0;
          } else if (xp) {
            m = +m + 1;
            p = 0;
          }
        } else if (gtlt === '<=') {
          // <=0.7.x is actually <0.8.0, since any 0.7.x should
          // pass.  Similarly, <=7.x is actually <8.0.0, etc.
          gtlt = '<';
          if (xm) M = +M + 1;else m = +m + 1;
        }

        ret = gtlt + M + '.' + m + '.' + p;
      } else if (xm) {
        ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
      } else if (xp) {
        ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
      }

      debug('xRange return', ret);
      return ret;
    });
  } // Because * is AND-ed with everything else in the comparator,
  // and '' means "any version", just remove the *s entirely.


  function replaceStars(comp, loose) {
    debug('replaceStars', comp, loose); // Looseness is ignored here.  star is always as loose as it gets!

    return comp.trim().replace(re[STAR], '');
  } // This function is passed to string.replace(re[HYPHENRANGE])
  // M, m, patch, prerelease, build
  // 1.2 - 3.4.5 => >=1.2.0 <=3.4.5
  // 1.2.3 - 3.4 => >=1.2.0 <3.5.0 Any 3.4.x will do
  // 1.2 - 3.4 => >=1.2.0 <3.5.0


  function hyphenReplace($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) {
    if (isX(fM)) from = '';else if (isX(fm)) from = '>=' + fM + '.0.0';else if (isX(fp)) from = '>=' + fM + '.' + fm + '.0';else from = '>=' + from;
    if (isX(tM)) to = '';else if (isX(tm)) to = '<' + (+tM + 1) + '.0.0';else if (isX(tp)) to = '<' + tM + '.' + (+tm + 1) + '.0';else if (tpr) to = '<=' + tM + '.' + tm + '.' + tp + '-' + tpr;else to = '<=' + to;
    return (from + ' ' + to).trim();
  } // if ANY of the sets match ALL of its comparators, then pass


  Range.prototype.test = function (version) {
    if (!version) return false;
    if (typeof version === 'string') version = new SemVer(version, this.loose);

    for (var i = 0; i < this.set.length; i++) {
      if (testSet(this.set[i], version)) return true;
    }

    return false;
  };

  function testSet(set, version) {
    for (var i = 0; i < set.length; i++) {
      if (!set[i].test(version)) return false;
    }

    if (version.prerelease.length) {
      // Find the set of versions that are allowed to have prereleases
      // For example, ^1.2.3-pr.1 desugars to >=1.2.3-pr.1 <2.0.0
      // That should allow `1.2.3-pr.2` to pass.
      // However, `1.2.4-alpha.notready` should NOT be allowed,
      // even though it's within the range set by the comparators.
      for (var i = 0; i < set.length; i++) {
        debug(set[i].semver);
        if (set[i].semver === ANY) continue;

        if (set[i].semver.prerelease.length > 0) {
          var allowed = set[i].semver;
          if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) return true;
        }
      } // Version has a -pre, but it's not one of the ones we like.


      return false;
    }

    return true;
  }

  exports.satisfies = satisfies;

  function satisfies(version, range, loose) {
    try {
      range = new Range(range, loose);
    } catch (er) {
      return false;
    }

    return range.test(version);
  }

  exports.maxSatisfying = maxSatisfying;

  function maxSatisfying(versions, range, loose) {
    var max = null;
    var maxSV = null;

    try {
      var rangeObj = new Range(range, loose);
    } catch (er) {
      return null;
    }

    versions.forEach(function (v) {
      if (rangeObj.test(v)) {
        // satisfies(v, range, loose)
        if (!max || maxSV.compare(v) === -1) {
          // compare(max, v, true)
          max = v;
          maxSV = new SemVer(max, loose);
        }
      }
    });
    return max;
  }

  exports.minSatisfying = minSatisfying;

  function minSatisfying(versions, range, loose) {
    var min = null;
    var minSV = null;

    try {
      var rangeObj = new Range(range, loose);
    } catch (er) {
      return null;
    }

    versions.forEach(function (v) {
      if (rangeObj.test(v)) {
        // satisfies(v, range, loose)
        if (!min || minSV.compare(v) === 1) {
          // compare(min, v, true)
          min = v;
          minSV = new SemVer(min, loose);
        }
      }
    });
    return min;
  }

  exports.validRange = validRange;

  function validRange(range, loose) {
    try {
      // Return '*' instead of '' so that truthiness works.
      // This will throw if it's invalid anyway
      return new Range(range, loose).range || '*';
    } catch (er) {
      return null;
    }
  } // Determine if version is less than all the versions possible in the range


  exports.ltr = ltr;

  function ltr(version, range, loose) {
    return outside(version, range, '<', loose);
  } // Determine if version is greater than all the versions possible in the range.


  exports.gtr = gtr;

  function gtr(version, range, loose) {
    return outside(version, range, '>', loose);
  }

  exports.outside = outside;

  function outside(version, range, hilo, loose) {
    version = new SemVer(version, loose);
    range = new Range(range, loose);
    var gtfn, ltefn, ltfn, comp, ecomp;

    switch (hilo) {
      case '>':
        gtfn = gt;
        ltefn = lte;
        ltfn = lt;
        comp = '>';
        ecomp = '>=';
        break;

      case '<':
        gtfn = lt;
        ltefn = gte;
        ltfn = gt;
        comp = '<';
        ecomp = '<=';
        break;

      default:
        throw new TypeError('Must provide a hilo val of "<" or ">"');
    } // If it satisifes the range it is not outside


    if (satisfies(version, range, loose)) {
      return false;
    } // From now on, variable terms are as if we're in "gtr" mode.
    // but note that everything is flipped for the "ltr" function.


    for (var i = 0; i < range.set.length; ++i) {
      var comparators = range.set[i];
      var high = null;
      var low = null;
      comparators.forEach(function (comparator) {
        if (comparator.semver === ANY) {
          comparator = new Comparator('>=0.0.0');
        }

        high = high || comparator;
        low = low || comparator;

        if (gtfn(comparator.semver, high.semver, loose)) {
          high = comparator;
        } else if (ltfn(comparator.semver, low.semver, loose)) {
          low = comparator;
        }
      }); // If the edge version comparator has a operator then our version
      // isn't outside it

      if (high.operator === comp || high.operator === ecomp) {
        return false;
      } // If the lowest version comparator has an operator and our version
      // is less than it then it isn't higher than the range


      if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
        return false;
      } else if (low.operator === ecomp && ltfn(version, low.semver)) {
        return false;
      }
    }

    return true;
  }

  exports.prerelease = prerelease;

  function prerelease(version, loose) {
    var parsed = parse(version, loose);
    return parsed && parsed.prerelease.length ? parsed.prerelease : null;
  }

  exports.intersects = intersects;

  function intersects(r1, r2, loose) {
    r1 = new Range(r1, loose);
    r2 = new Range(r2, loose);
    return r1.intersects(r2);
  }
});

var arrayify = function arrayify(object, keyName) {
  return Object.keys(object).reduce(function (array, key) {
    return array.concat(Object.assign({
      [keyName]: key
    }, object[key]));
  }, []);
};

var dedent_1 = createCommonjsModule(function (module) {
  "use strict";

  function dedent(strings) {
    var raw = void 0;

    if (typeof strings === "string") {
      // dedent can be used as a plain function
      raw = [strings];
    } else {
      raw = strings.raw;
    } // first, perform interpolation


    var result = "";

    for (var i = 0; i < raw.length; i++) {
      result += raw[i]. // join lines when there is a suppressed newline
      replace(/\\\n[ \t]*/g, ""). // handle escaped backticks
      replace(/\\`/g, "`");

      if (i < (arguments.length <= 1 ? 0 : arguments.length - 1)) {
        result += arguments.length <= i + 1 ? undefined : arguments[i + 1];
      }
    } // now strip indentation


    var lines = result.split("\n");
    var mindent = null;
    lines.forEach(function (l) {
      var m = l.match(/^(\s+)\S+/);

      if (m) {
        var indent = m[1].length;

        if (!mindent) {
          // this is the first indented line
          mindent = indent;
        } else {
          mindent = Math.min(mindent, indent);
        }
      }
    });

    if (mindent !== null) {
      result = lines.map(function (l) {
        return l[0] === " " ? l.slice(mindent) : l;
      }).join("\n");
    } // dedent eats leading and trailing whitespace too


    result = result.trim(); // handle escaped newlines at the end to ensure they don't get stripped too

    return result.replace(/\\n/g, "\n");
  }

  {
    module.exports = dedent;
  }
});

var CATEGORY_CONFIG = "Config";
var CATEGORY_EDITOR = "Editor";
var CATEGORY_FORMAT = "Format";
var CATEGORY_OTHER = "Other";
var CATEGORY_OUTPUT = "Output";
var CATEGORY_GLOBAL = "Global";
var CATEGORY_SPECIAL = "Special";
/**
 * @typedef {Object} OptionInfo
 * @property {string} since - available since version
 * @property {string} category
 * @property {'int' | 'boolean' | 'choice' | 'path'} type
 * @property {boolean} array - indicate it's an array of the specified type
 * @property {boolean?} deprecated - deprecated since version
 * @property {OptionRedirectInfo?} redirect - redirect deprecated option
 * @property {string} description
 * @property {string?} oppositeDescription - for `false` option
 * @property {OptionValueInfo} default
 * @property {OptionRangeInfo?} range - for type int
 * @property {OptionChoiceInfo?} choices - for type choice
 * @property {(value: any) => boolean} exception
 *
 * @typedef {number | boolean | string} OptionValue
 * @typedef {OptionValue | [{ value: OptionValue[] }] | Array<{ since: string, value: OptionValue}>} OptionValueInfo
 *
 * @typedef {Object} OptionRedirectInfo
 * @property {string} option
 * @property {OptionValue} value
 *
 * @typedef {Object} OptionRangeInfo
 * @property {number} start - recommended range start
 * @property {number} end - recommended range end
 * @property {number} step - recommended range step
 *
 * @typedef {Object} OptionChoiceInfo
 * @property {boolean | string} value - boolean for the option that is originally boolean type
 * @property {string?} description - undefined if redirect
 * @property {string?} since - undefined if available since the first version of the option
 * @property {string?} deprecated - deprecated since version
 * @property {OptionValueInfo?} redirect - redirect deprecated value
 *
 * @property {string?} cliName
 * @property {string?} cliCategory
 * @property {string?} cliDescription
 */

/** @type {{ [name: string]: OptionInfo } */

var options$2 = {
  cursorOffset: {
    since: "1.4.0",
    category: CATEGORY_SPECIAL,
    type: "int",
    default: -1,
    range: {
      start: -1,
      end: Infinity,
      step: 1
    },
    description: dedent_1`
      Print (to stderr) where a cursor at the given position would move to after formatting.
      This option cannot be used with --range-start and --range-end.
    `,
    cliCategory: CATEGORY_EDITOR
  },
  endOfLine: {
    since: "1.15.0",
    category: CATEGORY_GLOBAL,
    type: "choice",
    default: "auto",
    description: "Which end of line characters to apply.",
    choices: [{
      value: "auto",
      description: dedent_1`
          Maintain existing
          (mixed values within one file are normalised by looking at what's used after the first line)
        `
    }, {
      value: "lf",
      description: "Line Feed only (\\n), common on Linux and macOS as well as inside git repos"
    }, {
      value: "crlf",
      description: "Carriage Return + Line Feed characters (\\r\\n), common on Windows"
    }, {
      value: "cr",
      description: "Carriage Return character only (\\r), used very rarely"
    }]
  },
  filepath: {
    since: "1.4.0",
    category: CATEGORY_SPECIAL,
    type: "path",
    description: "Specify the input filepath. This will be used to do parser inference.",
    cliName: "stdin-filepath",
    cliCategory: CATEGORY_OTHER,
    cliDescription: "Path to the file to pretend that stdin comes from."
  },
  insertPragma: {
    since: "1.8.0",
    category: CATEGORY_SPECIAL,
    type: "boolean",
    default: false,
    description: "Insert @format pragma into file's first docblock comment.",
    cliCategory: CATEGORY_OTHER
  },
  parser: {
    since: "0.0.10",
    category: CATEGORY_GLOBAL,
    type: "choice",
    default: [{
      since: "0.0.10",
      value: "babylon"
    }, {
      since: "1.13.0",
      value: undefined
    }],
    description: "Which parser to use.",
    exception: function exception(value) {
      return typeof value === "string" || typeof value === "function";
    },
    choices: [{
      value: "flow",
      description: "Flow"
    }, {
      value: "babylon",
      description: "JavaScript",
      deprecated: "1.16.0",
      redirect: "babel"
    }, {
      value: "babel",
      since: "1.16.0",
      description: "JavaScript"
    }, {
      value: "babel-flow",
      since: "1.16.0",
      description: "Flow"
    }, {
      value: "typescript",
      since: "1.4.0",
      description: "TypeScript"
    }, {
      value: "css",
      since: "1.7.1",
      description: "CSS"
    }, {
      value: "postcss",
      since: "1.4.0",
      description: "CSS/Less/SCSS",
      deprecated: "1.7.1",
      redirect: "css"
    }, {
      value: "less",
      since: "1.7.1",
      description: "Less"
    }, {
      value: "scss",
      since: "1.7.1",
      description: "SCSS"
    }, {
      value: "json",
      since: "1.5.0",
      description: "JSON"
    }, {
      value: "json5",
      since: "1.13.0",
      description: "JSON5"
    }, {
      value: "json-stringify",
      since: "1.13.0",
      description: "JSON.stringify"
    }, {
      value: "graphql",
      since: "1.5.0",
      description: "GraphQL"
    }, {
      value: "markdown",
      since: "1.8.0",
      description: "Markdown"
    }, {
      value: "mdx",
      since: "1.15.0",
      description: "MDX"
    }, {
      value: "vue",
      since: "1.10.0",
      description: "Vue"
    }, {
      value: "yaml",
      since: "1.14.0",
      description: "YAML"
    }, {
      value: "glimmer",
      since: null,
      description: "Handlebars"
    }, {
      value: "html",
      since: "1.15.0",
      description: "HTML"
    }, {
      value: "angular",
      since: "1.15.0",
      description: "Angular"
    }, {
      value: "lwc",
      since: "1.17.0",
      description: "Lightning Web Components"
    }]
  },
  plugins: {
    since: "1.10.0",
    type: "path",
    array: true,
    default: [{
      value: []
    }],
    category: CATEGORY_GLOBAL,
    description: "Add a plugin. Multiple plugins can be passed as separate `--plugin`s.",
    exception: function exception(value) {
      return typeof value === "string" || typeof value === "object";
    },
    cliName: "plugin",
    cliCategory: CATEGORY_CONFIG
  },
  pluginSearchDirs: {
    since: "1.13.0",
    type: "path",
    array: true,
    default: [{
      value: []
    }],
    category: CATEGORY_GLOBAL,
    description: dedent_1`
      Custom directory that contains prettier plugins in node_modules subdirectory.
      Overrides default behavior when plugins are searched relatively to the location of Prettier.
      Multiple values are accepted.
    `,
    exception: function exception(value) {
      return typeof value === "string" || typeof value === "object";
    },
    cliName: "plugin-search-dir",
    cliCategory: CATEGORY_CONFIG
  },
  printWidth: {
    since: "0.0.0",
    category: CATEGORY_GLOBAL,
    type: "int",
    default: 80,
    description: "The line length where Prettier will try wrap.",
    range: {
      start: 0,
      end: Infinity,
      step: 1
    }
  },
  rangeEnd: {
    since: "1.4.0",
    category: CATEGORY_SPECIAL,
    type: "int",
    default: Infinity,
    range: {
      start: 0,
      end: Infinity,
      step: 1
    },
    description: dedent_1`
      Format code ending at a given character offset (exclusive).
      The range will extend forwards to the end of the selected statement.
      This option cannot be used with --cursor-offset.
    `,
    cliCategory: CATEGORY_EDITOR
  },
  rangeStart: {
    since: "1.4.0",
    category: CATEGORY_SPECIAL,
    type: "int",
    default: 0,
    range: {
      start: 0,
      end: Infinity,
      step: 1
    },
    description: dedent_1`
      Format code starting at a given character offset.
      The range will extend backwards to the start of the first line containing the selected statement.
      This option cannot be used with --cursor-offset.
    `,
    cliCategory: CATEGORY_EDITOR
  },
  requirePragma: {
    since: "1.7.0",
    category: CATEGORY_SPECIAL,
    type: "boolean",
    default: false,
    description: dedent_1`
      Require either '@prettier' or '@format' to be present in the file's first docblock comment
      in order for it to be formatted.
    `,
    cliCategory: CATEGORY_OTHER
  },
  tabWidth: {
    type: "int",
    category: CATEGORY_GLOBAL,
    default: 2,
    description: "Number of spaces per indentation level.",
    range: {
      start: 0,
      end: Infinity,
      step: 1
    }
  },
  useFlowParser: {
    since: "0.0.0",
    category: CATEGORY_GLOBAL,
    type: "boolean",
    default: [{
      since: "0.0.0",
      value: false
    }, {
      since: "1.15.0",
      value: undefined
    }],
    deprecated: "0.0.10",
    description: "Use flow parser.",
    redirect: {
      option: "parser",
      value: "flow"
    },
    cliName: "flow-parser"
  },
  useTabs: {
    since: "1.0.0",
    category: CATEGORY_GLOBAL,
    type: "boolean",
    default: false,
    description: "Indent with tabs instead of spaces."
  }
};
var coreOptions$1 = {
  CATEGORY_CONFIG,
  CATEGORY_EDITOR,
  CATEGORY_FORMAT,
  CATEGORY_OTHER,
  CATEGORY_OUTPUT,
  CATEGORY_GLOBAL,
  CATEGORY_SPECIAL,
  options: options$2
};

var require$$0 = ( _package$1 && _package ) || _package$1;

var currentVersion = require$$0.version;
var coreOptions = coreOptions$1.options;

function getSupportInfo$2(version, opts) {
  opts = Object.assign({
    plugins: [],
    showUnreleased: false,
    showDeprecated: false,
    showInternal: false
  }, opts);

  if (!version) {
    // pre-release version is smaller than the normal version in semver,
    // we need to treat it as the normal one so as to test new features.
    version = currentVersion.split("-", 1)[0];
  }

  var plugins = opts.plugins;
  var options = arrayify(Object.assign(plugins.reduce(function (currentOptions, plugin) {
    return Object.assign(currentOptions, plugin.options);
  }, {}), coreOptions), "name").sort(function (a, b) {
    return a.name === b.name ? 0 : a.name < b.name ? -1 : 1;
  }).filter(filterSince).filter(filterDeprecated).map(mapDeprecated).map(mapInternal).map(function (option) {
    var newOption = Object.assign({}, option);

    if (Array.isArray(newOption.default)) {
      newOption.default = newOption.default.length === 1 ? newOption.default[0].value : newOption.default.filter(filterSince).sort(function (info1, info2) {
        return semver.compare(info2.since, info1.since);
      })[0].value;
    }

    if (Array.isArray(newOption.choices)) {
      newOption.choices = newOption.choices.filter(filterSince).filter(filterDeprecated).map(mapDeprecated);
    }

    return newOption;
  }).map(function (option) {
    var filteredPlugins = plugins.filter(function (plugin) {
      return plugin.defaultOptions && plugin.defaultOptions[option.name];
    });
    var pluginDefaults = filteredPlugins.reduce(function (reduced, plugin) {
      reduced[plugin.name] = plugin.defaultOptions[option.name];
      return reduced;
    }, {});
    return Object.assign(option, {
      pluginDefaults
    });
  });
  var usePostCssParser = semver.lt(version, "1.7.1");
  var useBabylonParser = semver.lt(version, "1.16.0");
  var languages = plugins.reduce(function (all, plugin) {
    return all.concat(plugin.languages || []);
  }, []).filter(filterSince).map(function (language) {
    // Prevent breaking changes
    if (language.name === "Markdown") {
      return Object.assign({}, language, {
        parsers: ["markdown"]
      });
    }

    if (language.name === "TypeScript") {
      return Object.assign({}, language, {
        parsers: ["typescript"]
      });
    } // "babylon" was renamed to "babel" in 1.16.0


    if (useBabylonParser && language.parsers.indexOf("babel") !== -1) {
      return Object.assign({}, language, {
        parsers: language.parsers.map(function (parser) {
          return parser === "babel" ? "babylon" : parser;
        })
      });
    }

    if (usePostCssParser && (language.name === "CSS" || language.group === "CSS")) {
      return Object.assign({}, language, {
        parsers: ["postcss"]
      });
    }

    return language;
  });
  return {
    languages,
    options
  };

  function filterSince(object) {
    return opts.showUnreleased || !("since" in object) || object.since && semver.gte(version, object.since);
  }

  function filterDeprecated(object) {
    return opts.showDeprecated || !("deprecated" in object) || object.deprecated && semver.lt(version, object.deprecated);
  }

  function mapDeprecated(object) {
    if (!object.deprecated || opts.showDeprecated) {
      return object;
    }

    var newObject = Object.assign({}, object);
    delete newObject.deprecated;
    delete newObject.redirect;
    return newObject;
  }

  function mapInternal(object) {
    if (opts.showInternal) {
      return object;
    }

    var newObject = Object.assign({}, object);
    delete newObject.cliName;
    delete newObject.cliCategory;
    delete newObject.cliDescription;
    return newObject;
  }
}

var support = {
  getSupportInfo: getSupportInfo$2
};

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

/* global Reflect, Promise */
var _extendStatics = function extendStatics(d, b) {
  _extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) {
      if (b.hasOwnProperty(p)) d[p] = b[p];
    }
  };

  return _extendStatics(d, b);
};

function __extends(d, b) {
  _extendStatics(d, b);

  function __() {
    this.constructor = d;
  }

  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var _assign = function __assign() {
  _assign = Object.assign || function __assign(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
      s = arguments[i];

      for (var p in s) {
        if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
    }

    return t;
  };

  return _assign.apply(this, arguments);
};

function __rest(s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0) t[p[i]] = s[p[i]];
  }
  return t;
}
function __decorate(decorators, target, key, desc) {
  var c = arguments.length,
      r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
      d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) {
    if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  }
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}
function __param(paramIndex, decorator) {
  return function (target, key) {
    decorator(target, key, paramIndex);
  };
}
function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}
function __awaiter(thisArg, _arguments, P, generator) {
  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : new P(function (resolve) {
        resolve(result.value);
      }).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}
function __generator(thisArg, body) {
  var _ = {
    label: 0,
    sent: function sent() {
      if (t[0] & 1) throw t[1];
      return t[1];
    },
    trys: [],
    ops: []
  },
      f,
      y,
      t,
      g;
  return g = {
    next: verb(0),
    "throw": verb(1),
    "return": verb(2)
  }, typeof Symbol === "function" && (g[Symbol.iterator] = function () {
    return this;
  }), g;

  function verb(n) {
    return function (v) {
      return step([n, v]);
    };
  }

  function step(op) {
    if (f) throw new TypeError("Generator is already executing.");

    while (_) {
      try {
        if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
        if (y = 0, t) op = [op[0] & 2, t.value];

        switch (op[0]) {
          case 0:
          case 1:
            t = op;
            break;

          case 4:
            _.label++;
            return {
              value: op[1],
              done: false
            };

          case 5:
            _.label++;
            y = op[1];
            op = [0];
            continue;

          case 7:
            op = _.ops.pop();

            _.trys.pop();

            continue;

          default:
            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
              _ = 0;
              continue;
            }

            if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
              _.label = op[1];
              break;
            }

            if (op[0] === 6 && _.label < t[1]) {
              _.label = t[1];
              t = op;
              break;
            }

            if (t && _.label < t[2]) {
              _.label = t[2];

              _.ops.push(op);

              break;
            }

            if (t[2]) _.ops.pop();

            _.trys.pop();

            continue;
        }

        op = body.call(thisArg, _);
      } catch (e) {
        op = [6, e];
        y = 0;
      } finally {
        f = t = 0;
      }
    }

    if (op[0] & 5) throw op[1];
    return {
      value: op[0] ? op[1] : void 0,
      done: true
    };
  }
}
function __exportStar(m, exports) {
  for (var p in m) {
    if (!exports.hasOwnProperty(p)) exports[p] = m[p];
  }
}
function __values(o) {
  var m = typeof Symbol === "function" && o[Symbol.iterator],
      i = 0;
  if (m) return m.call(o);
  return {
    next: function next() {
      if (o && i >= o.length) o = void 0;
      return {
        value: o && o[i++],
        done: !o
      };
    }
  };
}
function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o),
      r,
      ar = [],
      e;

  try {
    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) {
      ar.push(r.value);
    }
  } catch (error) {
    e = {
      error: error
    };
  } finally {
    try {
      if (r && !r.done && (m = i["return"])) m.call(i);
    } finally {
      if (e) throw e.error;
    }
  }

  return ar;
}
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++) {
    ar = ar.concat(__read(arguments[i]));
  }

  return ar;
}
function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}
function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []),
      i,
      q = [];
  return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () {
    return this;
  }, i;

  function verb(n) {
    if (g[n]) i[n] = function (v) {
      return new Promise(function (a, b) {
        q.push([n, v, a, b]) > 1 || resume(n, v);
      });
    };
  }

  function resume(n, v) {
    try {
      step(g[n](v));
    } catch (e) {
      settle(q[0][3], e);
    }
  }

  function step(r) {
    r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
  }

  function fulfill(value) {
    resume("next", value);
  }

  function reject(value) {
    resume("throw", value);
  }

  function settle(f, v) {
    if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]);
  }
}
function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function (e) {
    throw e;
  }), verb("return"), i[Symbol.iterator] = function () {
    return this;
  }, i;

  function verb(n, f) {
    i[n] = o[n] ? function (v) {
      return (p = !p) ? {
        value: __await(o[n](v)),
        done: n === "return"
      } : f ? f(v) : v;
    } : f;
  }
}
function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator],
      i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () {
    return this;
  }, i);

  function verb(n) {
    i[n] = o[n] && function (v) {
      return new Promise(function (resolve, reject) {
        v = o[n](v), settle(resolve, reject, v.done, v.value);
      });
    };
  }

  function settle(resolve, reject, d, v) {
    Promise.resolve(v).then(function (v) {
      resolve({
        value: v,
        done: d
      });
    }, reject);
  }
}
function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) {
    Object.defineProperty(cooked, "raw", {
      value: raw
    });
  } else {
    cooked.raw = raw;
  }

  return cooked;
}

function __importStar(mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result.default = mod;
  return result;
}
function __importDefault(mod) {
  return mod && mod.__esModule ? mod : {
    default: mod
  };
}

var tslib_1 = Object.freeze({
	__extends: __extends,
	get __assign () { return _assign; },
	__rest: __rest,
	__decorate: __decorate,
	__param: __param,
	__metadata: __metadata,
	__awaiter: __awaiter,
	__generator: __generator,
	__exportStar: __exportStar,
	__values: __values,
	__read: __read,
	__spread: __spread,
	__await: __await,
	__asyncGenerator: __asyncGenerator,
	__asyncDelegator: __asyncDelegator,
	__asyncValues: __asyncValues,
	__makeTemplateObject: __makeTemplateObject,
	__importStar: __importStar,
	__importDefault: __importDefault
});

var api = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.apiDescriptor = {
    key: function key(_key) {
      return /^[$_a-zA-Z][$_a-zA-Z0-9]*$/.test(_key) ? _key : JSON.stringify(_key);
    },

    value(value) {
      if (value === null || typeof value !== 'object') {
        return JSON.stringify(value);
      }

      if (Array.isArray(value)) {
        return `[${value.map(function (subValue) {
          return exports.apiDescriptor.value(subValue);
        }).join(', ')}]`;
      }

      var keys = Object.keys(value);
      return keys.length === 0 ? '{}' : `{ ${keys.map(function (key) {
        return `${exports.apiDescriptor.key(key)}: ${exports.apiDescriptor.value(value[key])}`;
      }).join(', ')} }`;
    },

    pair: function pair(_ref) {
      var key = _ref.key,
          value = _ref.value;
      return exports.apiDescriptor.value({
        [key]: value
      });
    }
  };
});
unwrapExports(api);

var descriptors = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  tslib_1.__exportStar(api, exports);
});
unwrapExports(descriptors);

var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;

var escapeStringRegexp = function escapeStringRegexp(str) {
  if (typeof str !== 'string') {
    throw new TypeError('Expected a string');
  }

  return str.replace(matchOperatorsRe, '\\$&');
};

var colorName = {
  "aliceblue": [240, 248, 255],
  "antiquewhite": [250, 235, 215],
  "aqua": [0, 255, 255],
  "aquamarine": [127, 255, 212],
  "azure": [240, 255, 255],
  "beige": [245, 245, 220],
  "bisque": [255, 228, 196],
  "black": [0, 0, 0],
  "blanchedalmond": [255, 235, 205],
  "blue": [0, 0, 255],
  "blueviolet": [138, 43, 226],
  "brown": [165, 42, 42],
  "burlywood": [222, 184, 135],
  "cadetblue": [95, 158, 160],
  "chartreuse": [127, 255, 0],
  "chocolate": [210, 105, 30],
  "coral": [255, 127, 80],
  "cornflowerblue": [100, 149, 237],
  "cornsilk": [255, 248, 220],
  "crimson": [220, 20, 60],
  "cyan": [0, 255, 255],
  "darkblue": [0, 0, 139],
  "darkcyan": [0, 139, 139],
  "darkgoldenrod": [184, 134, 11],
  "darkgray": [169, 169, 169],
  "darkgreen": [0, 100, 0],
  "darkgrey": [169, 169, 169],
  "darkkhaki": [189, 183, 107],
  "darkmagenta": [139, 0, 139],
  "darkolivegreen": [85, 107, 47],
  "darkorange": [255, 140, 0],
  "darkorchid": [153, 50, 204],
  "darkred": [139, 0, 0],
  "darksalmon": [233, 150, 122],
  "darkseagreen": [143, 188, 143],
  "darkslateblue": [72, 61, 139],
  "darkslategray": [47, 79, 79],
  "darkslategrey": [47, 79, 79],
  "darkturquoise": [0, 206, 209],
  "darkviolet": [148, 0, 211],
  "deeppink": [255, 20, 147],
  "deepskyblue": [0, 191, 255],
  "dimgray": [105, 105, 105],
  "dimgrey": [105, 105, 105],
  "dodgerblue": [30, 144, 255],
  "firebrick": [178, 34, 34],
  "floralwhite": [255, 250, 240],
  "forestgreen": [34, 139, 34],
  "fuchsia": [255, 0, 255],
  "gainsboro": [220, 220, 220],
  "ghostwhite": [248, 248, 255],
  "gold": [255, 215, 0],
  "goldenrod": [218, 165, 32],
  "gray": [128, 128, 128],
  "green": [0, 128, 0],
  "greenyellow": [173, 255, 47],
  "grey": [128, 128, 128],
  "honeydew": [240, 255, 240],
  "hotpink": [255, 105, 180],
  "indianred": [205, 92, 92],
  "indigo": [75, 0, 130],
  "ivory": [255, 255, 240],
  "khaki": [240, 230, 140],
  "lavender": [230, 230, 250],
  "lavenderblush": [255, 240, 245],
  "lawngreen": [124, 252, 0],
  "lemonchiffon": [255, 250, 205],
  "lightblue": [173, 216, 230],
  "lightcoral": [240, 128, 128],
  "lightcyan": [224, 255, 255],
  "lightgoldenrodyellow": [250, 250, 210],
  "lightgray": [211, 211, 211],
  "lightgreen": [144, 238, 144],
  "lightgrey": [211, 211, 211],
  "lightpink": [255, 182, 193],
  "lightsalmon": [255, 160, 122],
  "lightseagreen": [32, 178, 170],
  "lightskyblue": [135, 206, 250],
  "lightslategray": [119, 136, 153],
  "lightslategrey": [119, 136, 153],
  "lightsteelblue": [176, 196, 222],
  "lightyellow": [255, 255, 224],
  "lime": [0, 255, 0],
  "limegreen": [50, 205, 50],
  "linen": [250, 240, 230],
  "magenta": [255, 0, 255],
  "maroon": [128, 0, 0],
  "mediumaquamarine": [102, 205, 170],
  "mediumblue": [0, 0, 205],
  "mediumorchid": [186, 85, 211],
  "mediumpurple": [147, 112, 219],
  "mediumseagreen": [60, 179, 113],
  "mediumslateblue": [123, 104, 238],
  "mediumspringgreen": [0, 250, 154],
  "mediumturquoise": [72, 209, 204],
  "mediumvioletred": [199, 21, 133],
  "midnightblue": [25, 25, 112],
  "mintcream": [245, 255, 250],
  "mistyrose": [255, 228, 225],
  "moccasin": [255, 228, 181],
  "navajowhite": [255, 222, 173],
  "navy": [0, 0, 128],
  "oldlace": [253, 245, 230],
  "olive": [128, 128, 0],
  "olivedrab": [107, 142, 35],
  "orange": [255, 165, 0],
  "orangered": [255, 69, 0],
  "orchid": [218, 112, 214],
  "palegoldenrod": [238, 232, 170],
  "palegreen": [152, 251, 152],
  "paleturquoise": [175, 238, 238],
  "palevioletred": [219, 112, 147],
  "papayawhip": [255, 239, 213],
  "peachpuff": [255, 218, 185],
  "peru": [205, 133, 63],
  "pink": [255, 192, 203],
  "plum": [221, 160, 221],
  "powderblue": [176, 224, 230],
  "purple": [128, 0, 128],
  "rebeccapurple": [102, 51, 153],
  "red": [255, 0, 0],
  "rosybrown": [188, 143, 143],
  "royalblue": [65, 105, 225],
  "saddlebrown": [139, 69, 19],
  "salmon": [250, 128, 114],
  "sandybrown": [244, 164, 96],
  "seagreen": [46, 139, 87],
  "seashell": [255, 245, 238],
  "sienna": [160, 82, 45],
  "silver": [192, 192, 192],
  "skyblue": [135, 206, 235],
  "slateblue": [106, 90, 205],
  "slategray": [112, 128, 144],
  "slategrey": [112, 128, 144],
  "snow": [255, 250, 250],
  "springgreen": [0, 255, 127],
  "steelblue": [70, 130, 180],
  "tan": [210, 180, 140],
  "teal": [0, 128, 128],
  "thistle": [216, 191, 216],
  "tomato": [255, 99, 71],
  "turquoise": [64, 224, 208],
  "violet": [238, 130, 238],
  "wheat": [245, 222, 179],
  "white": [255, 255, 255],
  "whitesmoke": [245, 245, 245],
  "yellow": [255, 255, 0],
  "yellowgreen": [154, 205, 50]
};

var conversions = createCommonjsModule(function (module) {
  /* MIT license */
  // NOTE: conversions should only return primitive values (i.e. arrays, or
  //       values that give correct `typeof` results).
  //       do not use box values types (i.e. Number(), String(), etc.)
  var reverseKeywords = {};

  for (var key in colorName) {
    if (colorName.hasOwnProperty(key)) {
      reverseKeywords[colorName[key]] = key;
    }
  }

  var convert = module.exports = {
    rgb: {
      channels: 3,
      labels: 'rgb'
    },
    hsl: {
      channels: 3,
      labels: 'hsl'
    },
    hsv: {
      channels: 3,
      labels: 'hsv'
    },
    hwb: {
      channels: 3,
      labels: 'hwb'
    },
    cmyk: {
      channels: 4,
      labels: 'cmyk'
    },
    xyz: {
      channels: 3,
      labels: 'xyz'
    },
    lab: {
      channels: 3,
      labels: 'lab'
    },
    lch: {
      channels: 3,
      labels: 'lch'
    },
    hex: {
      channels: 1,
      labels: ['hex']
    },
    keyword: {
      channels: 1,
      labels: ['keyword']
    },
    ansi16: {
      channels: 1,
      labels: ['ansi16']
    },
    ansi256: {
      channels: 1,
      labels: ['ansi256']
    },
    hcg: {
      channels: 3,
      labels: ['h', 'c', 'g']
    },
    apple: {
      channels: 3,
      labels: ['r16', 'g16', 'b16']
    },
    gray: {
      channels: 1,
      labels: ['gray']
    }
  }; // hide .channels and .labels properties

  for (var model in convert) {
    if (convert.hasOwnProperty(model)) {
      if (!('channels' in convert[model])) {
        throw new Error('missing channels property: ' + model);
      }

      if (!('labels' in convert[model])) {
        throw new Error('missing channel labels property: ' + model);
      }

      if (convert[model].labels.length !== convert[model].channels) {
        throw new Error('channel and label counts mismatch: ' + model);
      }

      var channels = convert[model].channels;
      var labels = convert[model].labels;
      delete convert[model].channels;
      delete convert[model].labels;
      Object.defineProperty(convert[model], 'channels', {
        value: channels
      });
      Object.defineProperty(convert[model], 'labels', {
        value: labels
      });
    }
  }

  convert.rgb.hsl = function (rgb) {
    var r = rgb[0] / 255;
    var g = rgb[1] / 255;
    var b = rgb[2] / 255;
    var min = Math.min(r, g, b);
    var max = Math.max(r, g, b);
    var delta = max - min;
    var h;
    var s;
    var l;

    if (max === min) {
      h = 0;
    } else if (r === max) {
      h = (g - b) / delta;
    } else if (g === max) {
      h = 2 + (b - r) / delta;
    } else if (b === max) {
      h = 4 + (r - g) / delta;
    }

    h = Math.min(h * 60, 360);

    if (h < 0) {
      h += 360;
    }

    l = (min + max) / 2;

    if (max === min) {
      s = 0;
    } else if (l <= 0.5) {
      s = delta / (max + min);
    } else {
      s = delta / (2 - max - min);
    }

    return [h, s * 100, l * 100];
  };

  convert.rgb.hsv = function (rgb) {
    var r = rgb[0];
    var g = rgb[1];
    var b = rgb[2];
    var min = Math.min(r, g, b);
    var max = Math.max(r, g, b);
    var delta = max - min;
    var h;
    var s;
    var v;

    if (max === 0) {
      s = 0;
    } else {
      s = delta / max * 1000 / 10;
    }

    if (max === min) {
      h = 0;
    } else if (r === max) {
      h = (g - b) / delta;
    } else if (g === max) {
      h = 2 + (b - r) / delta;
    } else if (b === max) {
      h = 4 + (r - g) / delta;
    }

    h = Math.min(h * 60, 360);

    if (h < 0) {
      h += 360;
    }

    v = max / 255 * 1000 / 10;
    return [h, s, v];
  };

  convert.rgb.hwb = function (rgb) {
    var r = rgb[0];
    var g = rgb[1];
    var b = rgb[2];
    var h = convert.rgb.hsl(rgb)[0];
    var w = 1 / 255 * Math.min(r, Math.min(g, b));
    b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));
    return [h, w * 100, b * 100];
  };

  convert.rgb.cmyk = function (rgb) {
    var r = rgb[0] / 255;
    var g = rgb[1] / 255;
    var b = rgb[2] / 255;
    var c;
    var m;
    var y;
    var k;
    k = Math.min(1 - r, 1 - g, 1 - b);
    c = (1 - r - k) / (1 - k) || 0;
    m = (1 - g - k) / (1 - k) || 0;
    y = (1 - b - k) / (1 - k) || 0;
    return [c * 100, m * 100, y * 100, k * 100];
  };
  /**
   * See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
   * */


  function comparativeDistance(x, y) {
    return Math.pow(x[0] - y[0], 2) + Math.pow(x[1] - y[1], 2) + Math.pow(x[2] - y[2], 2);
  }

  convert.rgb.keyword = function (rgb) {
    var reversed = reverseKeywords[rgb];

    if (reversed) {
      return reversed;
    }

    var currentClosestDistance = Infinity;
    var currentClosestKeyword;

    for (var keyword in colorName) {
      if (colorName.hasOwnProperty(keyword)) {
        var value = colorName[keyword]; // Compute comparative distance

        var distance = comparativeDistance(rgb, value); // Check if its less, if so set as closest

        if (distance < currentClosestDistance) {
          currentClosestDistance = distance;
          currentClosestKeyword = keyword;
        }
      }
    }

    return currentClosestKeyword;
  };

  convert.keyword.rgb = function (keyword) {
    return colorName[keyword];
  };

  convert.rgb.xyz = function (rgb) {
    var r = rgb[0] / 255;
    var g = rgb[1] / 255;
    var b = rgb[2] / 255; // assume sRGB

    r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
    g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
    b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;
    var x = r * 0.4124 + g * 0.3576 + b * 0.1805;
    var y = r * 0.2126 + g * 0.7152 + b * 0.0722;
    var z = r * 0.0193 + g * 0.1192 + b * 0.9505;
    return [x * 100, y * 100, z * 100];
  };

  convert.rgb.lab = function (rgb) {
    var xyz = convert.rgb.xyz(rgb);
    var x = xyz[0];
    var y = xyz[1];
    var z = xyz[2];
    var l;
    var a;
    var b;
    x /= 95.047;
    y /= 100;
    z /= 108.883;
    x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
    y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
    z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
    l = 116 * y - 16;
    a = 500 * (x - y);
    b = 200 * (y - z);
    return [l, a, b];
  };

  convert.hsl.rgb = function (hsl) {
    var h = hsl[0] / 360;
    var s = hsl[1] / 100;
    var l = hsl[2] / 100;
    var t1;
    var t2;
    var t3;
    var rgb;
    var val;

    if (s === 0) {
      val = l * 255;
      return [val, val, val];
    }

    if (l < 0.5) {
      t2 = l * (1 + s);
    } else {
      t2 = l + s - l * s;
    }

    t1 = 2 * l - t2;
    rgb = [0, 0, 0];

    for (var i = 0; i < 3; i++) {
      t3 = h + 1 / 3 * -(i - 1);

      if (t3 < 0) {
        t3++;
      }

      if (t3 > 1) {
        t3--;
      }

      if (6 * t3 < 1) {
        val = t1 + (t2 - t1) * 6 * t3;
      } else if (2 * t3 < 1) {
        val = t2;
      } else if (3 * t3 < 2) {
        val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
      } else {
        val = t1;
      }

      rgb[i] = val * 255;
    }

    return rgb;
  };

  convert.hsl.hsv = function (hsl) {
    var h = hsl[0];
    var s = hsl[1] / 100;
    var l = hsl[2] / 100;
    var smin = s;
    var lmin = Math.max(l, 0.01);
    var sv;
    var v;
    l *= 2;
    s *= l <= 1 ? l : 2 - l;
    smin *= lmin <= 1 ? lmin : 2 - lmin;
    v = (l + s) / 2;
    sv = l === 0 ? 2 * smin / (lmin + smin) : 2 * s / (l + s);
    return [h, sv * 100, v * 100];
  };

  convert.hsv.rgb = function (hsv) {
    var h = hsv[0] / 60;
    var s = hsv[1] / 100;
    var v = hsv[2] / 100;
    var hi = Math.floor(h) % 6;
    var f = h - Math.floor(h);
    var p = 255 * v * (1 - s);
    var q = 255 * v * (1 - s * f);
    var t = 255 * v * (1 - s * (1 - f));
    v *= 255;

    switch (hi) {
      case 0:
        return [v, t, p];

      case 1:
        return [q, v, p];

      case 2:
        return [p, v, t];

      case 3:
        return [p, q, v];

      case 4:
        return [t, p, v];

      case 5:
        return [v, p, q];
    }
  };

  convert.hsv.hsl = function (hsv) {
    var h = hsv[0];
    var s = hsv[1] / 100;
    var v = hsv[2] / 100;
    var vmin = Math.max(v, 0.01);
    var lmin;
    var sl;
    var l;
    l = (2 - s) * v;
    lmin = (2 - s) * vmin;
    sl = s * vmin;
    sl /= lmin <= 1 ? lmin : 2 - lmin;
    sl = sl || 0;
    l /= 2;
    return [h, sl * 100, l * 100];
  }; // http://dev.w3.org/csswg/css-color/#hwb-to-rgb


  convert.hwb.rgb = function (hwb) {
    var h = hwb[0] / 360;
    var wh = hwb[1] / 100;
    var bl = hwb[2] / 100;
    var ratio = wh + bl;
    var i;
    var v;
    var f;
    var n; // wh + bl cant be > 1

    if (ratio > 1) {
      wh /= ratio;
      bl /= ratio;
    }

    i = Math.floor(6 * h);
    v = 1 - bl;
    f = 6 * h - i;

    if ((i & 0x01) !== 0) {
      f = 1 - f;
    }

    n = wh + f * (v - wh); // linear interpolation

    var r;
    var g;
    var b;

    switch (i) {
      default:
      case 6:
      case 0:
        r = v;
        g = n;
        b = wh;
        break;

      case 1:
        r = n;
        g = v;
        b = wh;
        break;

      case 2:
        r = wh;
        g = v;
        b = n;
        break;

      case 3:
        r = wh;
        g = n;
        b = v;
        break;

      case 4:
        r = n;
        g = wh;
        b = v;
        break;

      case 5:
        r = v;
        g = wh;
        b = n;
        break;
    }

    return [r * 255, g * 255, b * 255];
  };

  convert.cmyk.rgb = function (cmyk) {
    var c = cmyk[0] / 100;
    var m = cmyk[1] / 100;
    var y = cmyk[2] / 100;
    var k = cmyk[3] / 100;
    var r;
    var g;
    var b;
    r = 1 - Math.min(1, c * (1 - k) + k);
    g = 1 - Math.min(1, m * (1 - k) + k);
    b = 1 - Math.min(1, y * (1 - k) + k);
    return [r * 255, g * 255, b * 255];
  };

  convert.xyz.rgb = function (xyz) {
    var x = xyz[0] / 100;
    var y = xyz[1] / 100;
    var z = xyz[2] / 100;
    var r;
    var g;
    var b;
    r = x * 3.2406 + y * -1.5372 + z * -0.4986;
    g = x * -0.9689 + y * 1.8758 + z * 0.0415;
    b = x * 0.0557 + y * -0.2040 + z * 1.0570; // assume sRGB

    r = r > 0.0031308 ? 1.055 * Math.pow(r, 1.0 / 2.4) - 0.055 : r * 12.92;
    g = g > 0.0031308 ? 1.055 * Math.pow(g, 1.0 / 2.4) - 0.055 : g * 12.92;
    b = b > 0.0031308 ? 1.055 * Math.pow(b, 1.0 / 2.4) - 0.055 : b * 12.92;
    r = Math.min(Math.max(0, r), 1);
    g = Math.min(Math.max(0, g), 1);
    b = Math.min(Math.max(0, b), 1);
    return [r * 255, g * 255, b * 255];
  };

  convert.xyz.lab = function (xyz) {
    var x = xyz[0];
    var y = xyz[1];
    var z = xyz[2];
    var l;
    var a;
    var b;
    x /= 95.047;
    y /= 100;
    z /= 108.883;
    x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
    y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
    z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
    l = 116 * y - 16;
    a = 500 * (x - y);
    b = 200 * (y - z);
    return [l, a, b];
  };

  convert.lab.xyz = function (lab) {
    var l = lab[0];
    var a = lab[1];
    var b = lab[2];
    var x;
    var y;
    var z;
    y = (l + 16) / 116;
    x = a / 500 + y;
    z = y - b / 200;
    var y2 = Math.pow(y, 3);
    var x2 = Math.pow(x, 3);
    var z2 = Math.pow(z, 3);
    y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
    x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
    z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;
    x *= 95.047;
    y *= 100;
    z *= 108.883;
    return [x, y, z];
  };

  convert.lab.lch = function (lab) {
    var l = lab[0];
    var a = lab[1];
    var b = lab[2];
    var hr;
    var h;
    var c;
    hr = Math.atan2(b, a);
    h = hr * 360 / 2 / Math.PI;

    if (h < 0) {
      h += 360;
    }

    c = Math.sqrt(a * a + b * b);
    return [l, c, h];
  };

  convert.lch.lab = function (lch) {
    var l = lch[0];
    var c = lch[1];
    var h = lch[2];
    var a;
    var b;
    var hr;
    hr = h / 360 * 2 * Math.PI;
    a = c * Math.cos(hr);
    b = c * Math.sin(hr);
    return [l, a, b];
  };

  convert.rgb.ansi16 = function (args) {
    var r = args[0];
    var g = args[1];
    var b = args[2];
    var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2]; // hsv -> ansi16 optimization

    value = Math.round(value / 50);

    if (value === 0) {
      return 30;
    }

    var ansi = 30 + (Math.round(b / 255) << 2 | Math.round(g / 255) << 1 | Math.round(r / 255));

    if (value === 2) {
      ansi += 60;
    }

    return ansi;
  };

  convert.hsv.ansi16 = function (args) {
    // optimization here; we already know the value and don't need to get
    // it converted for us.
    return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
  };

  convert.rgb.ansi256 = function (args) {
    var r = args[0];
    var g = args[1];
    var b = args[2]; // we use the extended greyscale palette here, with the exception of
    // black and white. normal palette only has 4 greyscale shades.

    if (r === g && g === b) {
      if (r < 8) {
        return 16;
      }

      if (r > 248) {
        return 231;
      }

      return Math.round((r - 8) / 247 * 24) + 232;
    }

    var ansi = 16 + 36 * Math.round(r / 255 * 5) + 6 * Math.round(g / 255 * 5) + Math.round(b / 255 * 5);
    return ansi;
  };

  convert.ansi16.rgb = function (args) {
    var color = args % 10; // handle greyscale

    if (color === 0 || color === 7) {
      if (args > 50) {
        color += 3.5;
      }

      color = color / 10.5 * 255;
      return [color, color, color];
    }

    var mult = (~~(args > 50) + 1) * 0.5;
    var r = (color & 1) * mult * 255;
    var g = (color >> 1 & 1) * mult * 255;
    var b = (color >> 2 & 1) * mult * 255;
    return [r, g, b];
  };

  convert.ansi256.rgb = function (args) {
    // handle greyscale
    if (args >= 232) {
      var c = (args - 232) * 10 + 8;
      return [c, c, c];
    }

    args -= 16;
    var rem;
    var r = Math.floor(args / 36) / 5 * 255;
    var g = Math.floor((rem = args % 36) / 6) / 5 * 255;
    var b = rem % 6 / 5 * 255;
    return [r, g, b];
  };

  convert.rgb.hex = function (args) {
    var integer = ((Math.round(args[0]) & 0xFF) << 16) + ((Math.round(args[1]) & 0xFF) << 8) + (Math.round(args[2]) & 0xFF);
    var string = integer.toString(16).toUpperCase();
    return '000000'.substring(string.length) + string;
  };

  convert.hex.rgb = function (args) {
    var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);

    if (!match) {
      return [0, 0, 0];
    }

    var colorString = match[0];

    if (match[0].length === 3) {
      colorString = colorString.split('').map(function (char) {
        return char + char;
      }).join('');
    }

    var integer = parseInt(colorString, 16);
    var r = integer >> 16 & 0xFF;
    var g = integer >> 8 & 0xFF;
    var b = integer & 0xFF;
    return [r, g, b];
  };

  convert.rgb.hcg = function (rgb) {
    var r = rgb[0] / 255;
    var g = rgb[1] / 255;
    var b = rgb[2] / 255;
    var max = Math.max(Math.max(r, g), b);
    var min = Math.min(Math.min(r, g), b);
    var chroma = max - min;
    var grayscale;
    var hue;

    if (chroma < 1) {
      grayscale = min / (1 - chroma);
    } else {
      grayscale = 0;
    }

    if (chroma <= 0) {
      hue = 0;
    } else if (max === r) {
      hue = (g - b) / chroma % 6;
    } else if (max === g) {
      hue = 2 + (b - r) / chroma;
    } else {
      hue = 4 + (r - g) / chroma + 4;
    }

    hue /= 6;
    hue %= 1;
    return [hue * 360, chroma * 100, grayscale * 100];
  };

  convert.hsl.hcg = function (hsl) {
    var s = hsl[1] / 100;
    var l = hsl[2] / 100;
    var c = 1;
    var f = 0;

    if (l < 0.5) {
      c = 2.0 * s * l;
    } else {
      c = 2.0 * s * (1.0 - l);
    }

    if (c < 1.0) {
      f = (l - 0.5 * c) / (1.0 - c);
    }

    return [hsl[0], c * 100, f * 100];
  };

  convert.hsv.hcg = function (hsv) {
    var s = hsv[1] / 100;
    var v = hsv[2] / 100;
    var c = s * v;
    var f = 0;

    if (c < 1.0) {
      f = (v - c) / (1 - c);
    }

    return [hsv[0], c * 100, f * 100];
  };

  convert.hcg.rgb = function (hcg) {
    var h = hcg[0] / 360;
    var c = hcg[1] / 100;
    var g = hcg[2] / 100;

    if (c === 0.0) {
      return [g * 255, g * 255, g * 255];
    }

    var pure = [0, 0, 0];
    var hi = h % 1 * 6;
    var v = hi % 1;
    var w = 1 - v;
    var mg = 0;

    switch (Math.floor(hi)) {
      case 0:
        pure[0] = 1;
        pure[1] = v;
        pure[2] = 0;
        break;

      case 1:
        pure[0] = w;
        pure[1] = 1;
        pure[2] = 0;
        break;

      case 2:
        pure[0] = 0;
        pure[1] = 1;
        pure[2] = v;
        break;

      case 3:
        pure[0] = 0;
        pure[1] = w;
        pure[2] = 1;
        break;

      case 4:
        pure[0] = v;
        pure[1] = 0;
        pure[2] = 1;
        break;

      default:
        pure[0] = 1;
        pure[1] = 0;
        pure[2] = w;
    }

    mg = (1.0 - c) * g;
    return [(c * pure[0] + mg) * 255, (c * pure[1] + mg) * 255, (c * pure[2] + mg) * 255];
  };

  convert.hcg.hsv = function (hcg) {
    var c = hcg[1] / 100;
    var g = hcg[2] / 100;
    var v = c + g * (1.0 - c);
    var f = 0;

    if (v > 0.0) {
      f = c / v;
    }

    return [hcg[0], f * 100, v * 100];
  };

  convert.hcg.hsl = function (hcg) {
    var c = hcg[1] / 100;
    var g = hcg[2] / 100;
    var l = g * (1.0 - c) + 0.5 * c;
    var s = 0;

    if (l > 0.0 && l < 0.5) {
      s = c / (2 * l);
    } else if (l >= 0.5 && l < 1.0) {
      s = c / (2 * (1 - l));
    }

    return [hcg[0], s * 100, l * 100];
  };

  convert.hcg.hwb = function (hcg) {
    var c = hcg[1] / 100;
    var g = hcg[2] / 100;
    var v = c + g * (1.0 - c);
    return [hcg[0], (v - c) * 100, (1 - v) * 100];
  };

  convert.hwb.hcg = function (hwb) {
    var w = hwb[1] / 100;
    var b = hwb[2] / 100;
    var v = 1 - b;
    var c = v - w;
    var g = 0;

    if (c < 1) {
      g = (v - c) / (1 - c);
    }

    return [hwb[0], c * 100, g * 100];
  };

  convert.apple.rgb = function (apple) {
    return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
  };

  convert.rgb.apple = function (rgb) {
    return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
  };

  convert.gray.rgb = function (args) {
    return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
  };

  convert.gray.hsl = convert.gray.hsv = function (args) {
    return [0, 0, args[0]];
  };

  convert.gray.hwb = function (gray) {
    return [0, 100, gray[0]];
  };

  convert.gray.cmyk = function (gray) {
    return [0, 0, 0, gray[0]];
  };

  convert.gray.lab = function (gray) {
    return [gray[0], 0, 0];
  };

  convert.gray.hex = function (gray) {
    var val = Math.round(gray[0] / 100 * 255) & 0xFF;
    var integer = (val << 16) + (val << 8) + val;
    var string = integer.toString(16).toUpperCase();
    return '000000'.substring(string.length) + string;
  };

  convert.rgb.gray = function (rgb) {
    var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
    return [val / 255 * 100];
  };
});

/*
	this function routes a model to all other models.

	all functions that are routed have a property `.conversion` attached
	to the returned synthetic function. This property is an array
	of strings, each with the steps in between the 'from' and 'to'
	color models (inclusive).

	conversions that are not possible simply are not included.
*/
// https://jsperf.com/object-keys-vs-for-in-with-closure/3

var models$1 = Object.keys(conversions);

function buildGraph() {
  var graph = {};

  for (var len = models$1.length, i = 0; i < len; i++) {
    graph[models$1[i]] = {
      // http://jsperf.com/1-vs-infinity
      // micro-opt, but this is simple.
      distance: -1,
      parent: null
    };
  }

  return graph;
} // https://en.wikipedia.org/wiki/Breadth-first_search


function deriveBFS(fromModel) {
  var graph = buildGraph();
  var queue = [fromModel]; // unshift -> queue -> pop

  graph[fromModel].distance = 0;

  while (queue.length) {
    var current = queue.pop();
    var adjacents = Object.keys(conversions[current]);

    for (var len = adjacents.length, i = 0; i < len; i++) {
      var adjacent = adjacents[i];
      var node = graph[adjacent];

      if (node.distance === -1) {
        node.distance = graph[current].distance + 1;
        node.parent = current;
        queue.unshift(adjacent);
      }
    }
  }

  return graph;
}

function link(from, to) {
  return function (args) {
    return to(from(args));
  };
}

function wrapConversion(toModel, graph) {
  var path$$1 = [graph[toModel].parent, toModel];
  var fn = conversions[graph[toModel].parent][toModel];
  var cur = graph[toModel].parent;

  while (graph[cur].parent) {
    path$$1.unshift(graph[cur].parent);
    fn = link(conversions[graph[cur].parent][cur], fn);
    cur = graph[cur].parent;
  }

  fn.conversion = path$$1;
  return fn;
}

var route = function route(fromModel) {
  var graph = deriveBFS(fromModel);
  var conversion = {};
  var models = Object.keys(graph);

  for (var len = models.length, i = 0; i < len; i++) {
    var toModel = models[i];
    var node = graph[toModel];

    if (node.parent === null) {
      // no possible conversion, or this node is the source model.
      continue;
    }

    conversion[toModel] = wrapConversion(toModel, graph);
  }

  return conversion;
};

var convert = {};
var models = Object.keys(conversions);

function wrapRaw(fn) {
  var wrappedFn = function wrappedFn(args) {
    if (args === undefined || args === null) {
      return args;
    }

    if (arguments.length > 1) {
      args = Array.prototype.slice.call(arguments);
    }

    return fn(args);
  }; // preserve .conversion property if there is one


  if ('conversion' in fn) {
    wrappedFn.conversion = fn.conversion;
  }

  return wrappedFn;
}

function wrapRounded(fn) {
  var wrappedFn = function wrappedFn(args) {
    if (args === undefined || args === null) {
      return args;
    }

    if (arguments.length > 1) {
      args = Array.prototype.slice.call(arguments);
    }

    var result = fn(args); // we're assuming the result is an array here.
    // see notice in conversions.js; don't use box types
    // in conversion functions.

    if (typeof result === 'object') {
      for (var len = result.length, i = 0; i < len; i++) {
        result[i] = Math.round(result[i]);
      }
    }

    return result;
  }; // preserve .conversion property if there is one


  if ('conversion' in fn) {
    wrappedFn.conversion = fn.conversion;
  }

  return wrappedFn;
}

models.forEach(function (fromModel) {
  convert[fromModel] = {};
  Object.defineProperty(convert[fromModel], 'channels', {
    value: conversions[fromModel].channels
  });
  Object.defineProperty(convert[fromModel], 'labels', {
    value: conversions[fromModel].labels
  });
  var routes = route(fromModel);
  var routeModels = Object.keys(routes);
  routeModels.forEach(function (toModel) {
    var fn = routes[toModel];
    convert[fromModel][toModel] = wrapRounded(fn);
    convert[fromModel][toModel].raw = wrapRaw(fn);
  });
});
var colorConvert = convert;

var ansiStyles = createCommonjsModule(function (module) {
  'use strict';

  var wrapAnsi16 = function wrapAnsi16(fn, offset) {
    return function () {
      var code = fn.apply(colorConvert, arguments);
      return `\u001B[${code + offset}m`;
    };
  };

  var wrapAnsi256 = function wrapAnsi256(fn, offset) {
    return function () {
      var code = fn.apply(colorConvert, arguments);
      return `\u001B[${38 + offset};5;${code}m`;
    };
  };

  var wrapAnsi16m = function wrapAnsi16m(fn, offset) {
    return function () {
      var rgb = fn.apply(colorConvert, arguments);
      return `\u001B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
    };
  };

  function assembleStyles() {
    var codes = new Map();
    var styles = {
      modifier: {
        reset: [0, 0],
        // 21 isn't widely supported and 22 does the same thing
        bold: [1, 22],
        dim: [2, 22],
        italic: [3, 23],
        underline: [4, 24],
        inverse: [7, 27],
        hidden: [8, 28],
        strikethrough: [9, 29]
      },
      color: {
        black: [30, 39],
        red: [31, 39],
        green: [32, 39],
        yellow: [33, 39],
        blue: [34, 39],
        magenta: [35, 39],
        cyan: [36, 39],
        white: [37, 39],
        gray: [90, 39],
        // Bright color
        redBright: [91, 39],
        greenBright: [92, 39],
        yellowBright: [93, 39],
        blueBright: [94, 39],
        magentaBright: [95, 39],
        cyanBright: [96, 39],
        whiteBright: [97, 39]
      },
      bgColor: {
        bgBlack: [40, 49],
        bgRed: [41, 49],
        bgGreen: [42, 49],
        bgYellow: [43, 49],
        bgBlue: [44, 49],
        bgMagenta: [45, 49],
        bgCyan: [46, 49],
        bgWhite: [47, 49],
        // Bright color
        bgBlackBright: [100, 49],
        bgRedBright: [101, 49],
        bgGreenBright: [102, 49],
        bgYellowBright: [103, 49],
        bgBlueBright: [104, 49],
        bgMagentaBright: [105, 49],
        bgCyanBright: [106, 49],
        bgWhiteBright: [107, 49]
      }
    }; // Fix humans

    styles.color.grey = styles.color.gray;

    var _arr = Object.keys(styles);

    for (var _i = 0; _i < _arr.length; _i++) {
      var groupName = _arr[_i];
      var group = styles[groupName];

      var _arr3 = Object.keys(group);

      for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
        var styleName = _arr3[_i3];
        var style = group[styleName];
        styles[styleName] = {
          open: `\u001B[${style[0]}m`,
          close: `\u001B[${style[1]}m`
        };
        group[styleName] = styles[styleName];
        codes.set(style[0], style[1]);
      }

      Object.defineProperty(styles, groupName, {
        value: group,
        enumerable: false
      });
      Object.defineProperty(styles, 'codes', {
        value: codes,
        enumerable: false
      });
    }

    var ansi2ansi = function ansi2ansi(n) {
      return n;
    };

    var rgb2rgb = function rgb2rgb(r, g, b) {
      return [r, g, b];
    };

    styles.color.close = '\u001B[39m';
    styles.bgColor.close = '\u001B[49m';
    styles.color.ansi = {
      ansi: wrapAnsi16(ansi2ansi, 0)
    };
    styles.color.ansi256 = {
      ansi256: wrapAnsi256(ansi2ansi, 0)
    };
    styles.color.ansi16m = {
      rgb: wrapAnsi16m(rgb2rgb, 0)
    };
    styles.bgColor.ansi = {
      ansi: wrapAnsi16(ansi2ansi, 10)
    };
    styles.bgColor.ansi256 = {
      ansi256: wrapAnsi256(ansi2ansi, 10)
    };
    styles.bgColor.ansi16m = {
      rgb: wrapAnsi16m(rgb2rgb, 10)
    };

    var _arr2 = Object.keys(colorConvert);

    for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
      var key = _arr2[_i2];

      if (typeof colorConvert[key] !== 'object') {
        continue;
      }

      var suite = colorConvert[key];

      if (key === 'ansi16') {
        key = 'ansi';
      }

      if ('ansi16' in suite) {
        styles.color.ansi[key] = wrapAnsi16(suite.ansi16, 0);
        styles.bgColor.ansi[key] = wrapAnsi16(suite.ansi16, 10);
      }

      if ('ansi256' in suite) {
        styles.color.ansi256[key] = wrapAnsi256(suite.ansi256, 0);
        styles.bgColor.ansi256[key] = wrapAnsi256(suite.ansi256, 10);
      }

      if ('rgb' in suite) {
        styles.color.ansi16m[key] = wrapAnsi16m(suite.rgb, 0);
        styles.bgColor.ansi16m[key] = wrapAnsi16m(suite.rgb, 10);
      }
    }

    return styles;
  } // Make the export immutable


  Object.defineProperty(module, 'exports', {
    enumerable: true,
    get: assembleStyles
  });
});

var hasFlag = createCommonjsModule(function (module) {
  'use strict';

  module.exports = function (flag, argv) {
    argv = argv || process.argv;
    var prefix = flag.startsWith('-') ? '' : flag.length === 1 ? '-' : '--';
    var pos = argv.indexOf(prefix + flag);
    var terminatorPos = argv.indexOf('--');
    return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
  };
});

var env = process.env;
var forceColor;

if (hasFlag('no-color') || hasFlag('no-colors') || hasFlag('color=false')) {
  forceColor = false;
} else if (hasFlag('color') || hasFlag('colors') || hasFlag('color=true') || hasFlag('color=always')) {
  forceColor = true;
}

if ('FORCE_COLOR' in env) {
  forceColor = env.FORCE_COLOR.length === 0 || parseInt(env.FORCE_COLOR, 10) !== 0;
}

function translateLevel(level) {
  if (level === 0) {
    return false;
  }

  return {
    level,
    hasBasic: true,
    has256: level >= 2,
    has16m: level >= 3
  };
}

function supportsColor(stream) {
  if (forceColor === false) {
    return 0;
  }

  if (hasFlag('color=16m') || hasFlag('color=full') || hasFlag('color=truecolor')) {
    return 3;
  }

  if (hasFlag('color=256')) {
    return 2;
  }

  if (stream && !stream.isTTY && forceColor !== true) {
    return 0;
  }

  var min = forceColor ? 1 : 0;

  if (process.platform === 'win32') {
    // Node.js 7.5.0 is the first version of Node.js to include a patch to
    // libuv that enables 256 color output on Windows. Anything earlier and it
    // won't work. However, here we target Node.js 8 at minimum as it is an LTS
    // release, and Node.js 7 is not. Windows 10 build 10586 is the first Windows
    // release that supports 256 colors. Windows 10 build 14931 is the first release
    // that supports 16m/TrueColor.
    var osRelease = os.release().split('.');

    if (Number(process.versions.node.split('.')[0]) >= 8 && Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
      return Number(osRelease[2]) >= 14931 ? 3 : 2;
    }

    return 1;
  }

  if ('CI' in env) {
    if (['TRAVIS', 'CIRCLECI', 'APPVEYOR', 'GITLAB_CI'].some(function (sign) {
      return sign in env;
    }) || env.CI_NAME === 'codeship') {
      return 1;
    }

    return min;
  }

  if ('TEAMCITY_VERSION' in env) {
    return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
  }

  if (env.COLORTERM === 'truecolor') {
    return 3;
  }

  if ('TERM_PROGRAM' in env) {
    var version = parseInt((env.TERM_PROGRAM_VERSION || '').split('.')[0], 10);

    switch (env.TERM_PROGRAM) {
      case 'iTerm.app':
        return version >= 3 ? 3 : 2;

      case 'Apple_Terminal':
        return 2;
      // No default
    }
  }

  if (/-256(color)?$/i.test(env.TERM)) {
    return 2;
  }

  if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
    return 1;
  }

  if ('COLORTERM' in env) {
    return 1;
  }

  if (env.TERM === 'dumb') {
    return min;
  }

  return min;
}

function getSupportLevel(stream) {
  var level = supportsColor(stream);
  return translateLevel(level);
}

var supportsColor_1 = {
  supportsColor: getSupportLevel,
  stdout: getSupportLevel(process.stdout),
  stderr: getSupportLevel(process.stderr)
};

var templates = createCommonjsModule(function (module) {
  'use strict';

  var TEMPLATE_REGEX = /(?:\\(u[a-f\d]{4}|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
  var STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
  var STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
  var ESCAPE_REGEX = /\\(u[a-f\d]{4}|x[a-f\d]{2}|.)|([^\\])/gi;
  var ESCAPES = new Map([['n', '\n'], ['r', '\r'], ['t', '\t'], ['b', '\b'], ['f', '\f'], ['v', '\v'], ['0', '\0'], ['\\', '\\'], ['e', '\u001B'], ['a', '\u0007']]);

  function unescape(c) {
    if (c[0] === 'u' && c.length === 5 || c[0] === 'x' && c.length === 3) {
      return String.fromCharCode(parseInt(c.slice(1), 16));
    }

    return ESCAPES.get(c) || c;
  }

  function parseArguments(name, args) {
    var results = [];
    var chunks = args.trim().split(/\s*,\s*/g);
    var matches;
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = chunks[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var chunk = _step.value;

        if (!isNaN(chunk)) {
          results.push(Number(chunk));
        } else if (matches = chunk.match(STRING_REGEX)) {
          results.push(matches[2].replace(ESCAPE_REGEX, function (m, escape, chr) {
            return escape ? unescape(escape) : chr;
          }));
        } else {
          throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return results;
  }

  function parseStyle(style) {
    STYLE_REGEX.lastIndex = 0;
    var results = [];
    var matches;

    while ((matches = STYLE_REGEX.exec(style)) !== null) {
      var name = matches[1];

      if (matches[2]) {
        var args = parseArguments(name, matches[2]);
        results.push([name].concat(args));
      } else {
        results.push([name]);
      }
    }

    return results;
  }

  function buildStyle(chalk, styles) {
    var enabled = {};
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
      for (var _iterator2 = styles[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
        var layer = _step2.value;
        var _iteratorNormalCompletion3 = true;
        var _didIteratorError3 = false;
        var _iteratorError3 = undefined;

        try {
          for (var _iterator3 = layer.styles[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
            var style = _step3.value;
            enabled[style[0]] = layer.inverse ? null : style.slice(1);
          }
        } catch (err) {
          _didIteratorError3 = true;
          _iteratorError3 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
              _iterator3.return();
            }
          } finally {
            if (_didIteratorError3) {
              throw _iteratorError3;
            }
          }
        }
      }
    } catch (err) {
      _didIteratorError2 = true;
      _iteratorError2 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
          _iterator2.return();
        }
      } finally {
        if (_didIteratorError2) {
          throw _iteratorError2;
        }
      }
    }

    var current = chalk;

    var _arr = Object.keys(enabled);

    for (var _i = 0; _i < _arr.length; _i++) {
      var styleName = _arr[_i];

      if (Array.isArray(enabled[styleName])) {
        if (!(styleName in current)) {
          throw new Error(`Unknown Chalk style: ${styleName}`);
        }

        if (enabled[styleName].length > 0) {
          current = current[styleName].apply(current, enabled[styleName]);
        } else {
          current = current[styleName];
        }
      }
    }

    return current;
  }

  module.exports = function (chalk, tmp) {
    var styles = [];
    var chunks = [];
    var chunk = []; // eslint-disable-next-line max-params

    tmp.replace(TEMPLATE_REGEX, function (m, escapeChar, inverse, style, close, chr) {
      if (escapeChar) {
        chunk.push(unescape(escapeChar));
      } else if (style) {
        var str = chunk.join('');
        chunk = [];
        chunks.push(styles.length === 0 ? str : buildStyle(chalk, styles)(str));
        styles.push({
          inverse,
          styles: parseStyle(style)
        });
      } else if (close) {
        if (styles.length === 0) {
          throw new Error('Found extraneous } in Chalk template literal');
        }

        chunks.push(buildStyle(chalk, styles)(chunk.join('')));
        chunk = [];
        styles.pop();
      } else {
        chunk.push(chr);
      }
    });
    chunks.push(chunk.join(''));

    if (styles.length > 0) {
      var errMsg = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? '' : 's'} (\`}\`)`;
      throw new Error(errMsg);
    }

    return chunks.join('');
  };
});

var chalk = createCommonjsModule(function (module) {
  'use strict';

  var stdoutColor = supportsColor_1.stdout;
  var isSimpleWindowsTerm = process.platform === 'win32' && !(process.env.TERM || '').toLowerCase().startsWith('xterm'); // `supportsColor.level` → `ansiStyles.color[name]` mapping

  var levelMapping = ['ansi', 'ansi', 'ansi256', 'ansi16m']; // `color-convert` models to exclude from the Chalk API due to conflicts and such

  var skipModels = new Set(['gray']);
  var styles = Object.create(null);

  function applyOptions(obj, options) {
    options = options || {}; // Detect level if not set manually

    var scLevel = stdoutColor ? stdoutColor.level : 0;
    obj.level = options.level === undefined ? scLevel : options.level;
    obj.enabled = 'enabled' in options ? options.enabled : obj.level > 0;
  }

  function Chalk(options) {
    // We check for this.template here since calling `chalk.constructor()`
    // by itself will have a `this` of a previously constructed chalk object
    if (!this || !(this instanceof Chalk) || this.template) {
      var _chalk = {};
      applyOptions(_chalk, options);

      _chalk.template = function () {
        var args = [].slice.call(arguments);
        return chalkTag.apply(null, [_chalk.template].concat(args));
      };

      Object.setPrototypeOf(_chalk, Chalk.prototype);
      Object.setPrototypeOf(_chalk.template, _chalk);
      _chalk.template.constructor = Chalk;
      return _chalk.template;
    }

    applyOptions(this, options);
  } // Use bright blue on Windows as the normal blue color is illegible


  if (isSimpleWindowsTerm) {
    ansiStyles.blue.open = '\u001B[94m';
  }

  var _arr = Object.keys(ansiStyles);

  var _loop = function _loop() {
    var key = _arr[_i];
    ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), 'g');
    styles[key] = {
      get() {
        var codes = ansiStyles[key];
        return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, key);
      }

    };
  };

  for (var _i = 0; _i < _arr.length; _i++) {
    _loop();
  }

  styles.visible = {
    get() {
      return build.call(this, this._styles || [], true, 'visible');
    }

  };
  ansiStyles.color.closeRe = new RegExp(escapeStringRegexp(ansiStyles.color.close), 'g');

  var _arr2 = Object.keys(ansiStyles.color.ansi);

  var _loop2 = function _loop2() {
    var model = _arr2[_i2];

    if (skipModels.has(model)) {
      return "continue";
    }

    styles[model] = {
      get() {
        var level = this.level;
        return function () {
          var open = ansiStyles.color[levelMapping[level]][model].apply(null, arguments);
          var codes = {
            open,
            close: ansiStyles.color.close,
            closeRe: ansiStyles.color.closeRe
          };
          return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
        };
      }

    };
  };

  for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
    var _ret = _loop2();

    if (_ret === "continue") continue;
  }

  ansiStyles.bgColor.closeRe = new RegExp(escapeStringRegexp(ansiStyles.bgColor.close), 'g');

  var _arr3 = Object.keys(ansiStyles.bgColor.ansi);

  var _loop3 = function _loop3() {
    var model = _arr3[_i3];

    if (skipModels.has(model)) {
      return "continue";
    }

    var bgModel = 'bg' + model[0].toUpperCase() + model.slice(1);
    styles[bgModel] = {
      get() {
        var level = this.level;
        return function () {
          var open = ansiStyles.bgColor[levelMapping[level]][model].apply(null, arguments);
          var codes = {
            open,
            close: ansiStyles.bgColor.close,
            closeRe: ansiStyles.bgColor.closeRe
          };
          return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
        };
      }

    };
  };

  for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
    var _ret2 = _loop3();

    if (_ret2 === "continue") continue;
  }

  var proto = Object.defineProperties(function () {}, styles);

  function build(_styles, _empty, key) {
    var builder = function builder() {
      return applyStyle.apply(builder, arguments);
    };

    builder._styles = _styles;
    builder._empty = _empty;
    var self = this;
    Object.defineProperty(builder, 'level', {
      enumerable: true,

      get() {
        return self.level;
      },

      set(level) {
        self.level = level;
      }

    });
    Object.defineProperty(builder, 'enabled', {
      enumerable: true,

      get() {
        return self.enabled;
      },

      set(enabled) {
        self.enabled = enabled;
      }

    }); // See below for fix regarding invisible grey/dim combination on Windows

    builder.hasGrey = this.hasGrey || key === 'gray' || key === 'grey'; // `__proto__` is used because we must return a function, but there is
    // no way to create a function with a different prototype

    builder.__proto__ = proto; // eslint-disable-line no-proto

    return builder;
  }

  function applyStyle() {
    // Support varags, but simply cast to string in case there's only one arg
    var args = arguments;
    var argsLen = args.length;
    var str = String(arguments[0]);

    if (argsLen === 0) {
      return '';
    }

    if (argsLen > 1) {
      // Don't slice `arguments`, it prevents V8 optimizations
      for (var a = 1; a < argsLen; a++) {
        str += ' ' + args[a];
      }
    }

    if (!this.enabled || this.level <= 0 || !str) {
      return this._empty ? '' : str;
    } // Turns out that on Windows dimmed gray text becomes invisible in cmd.exe,
    // see https://github.com/chalk/chalk/issues/58
    // If we're on Windows and we're dealing with a gray color, temporarily make 'dim' a noop.


    var originalDim = ansiStyles.dim.open;

    if (isSimpleWindowsTerm && this.hasGrey) {
      ansiStyles.dim.open = '';
    }

    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = this._styles.slice().reverse()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var code = _step.value;
        // Replace any instances already present with a re-opening code
        // otherwise only the part of the string until said closing code
        // will be colored, and the rest will simply be 'plain'.
        str = code.open + str.replace(code.closeRe, code.open) + code.close; // Close the styling before a linebreak and reopen
        // after next line to fix a bleed issue on macOS
        // https://github.com/chalk/chalk/pull/92

        str = str.replace(/\r?\n/g, `${code.close}$&${code.open}`);
      } // Reset the original `dim` if we changed it to work around the Windows dimmed gray issue

    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    ansiStyles.dim.open = originalDim;
    return str;
  }

  function chalkTag(chalk, strings) {
    if (!Array.isArray(strings)) {
      // If chalk() was called by itself or with a string,
      // return the string itself as a string.
      return [].slice.call(arguments, 1).join(' ');
    }

    var args = [].slice.call(arguments, 2);
    var parts = [strings.raw[0]];

    for (var i = 1; i < strings.length; i++) {
      parts.push(String(args[i - 1]).replace(/[{}\\]/g, '\\$&'));
      parts.push(String(strings.raw[i]));
    }

    return templates(chalk, parts.join(''));
  }

  Object.defineProperties(Chalk.prototype, styles);
  module.exports = Chalk(); // eslint-disable-line new-cap

  module.exports.supportsColor = stdoutColor;
  module.exports.default = module.exports; // For TypeScript
});

var common = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  exports.commonDeprecatedHandler = function (keyOrPair, redirectTo, _ref) {
    var descriptor = _ref.descriptor;
    var messages = [`${chalk.default.yellow(typeof keyOrPair === 'string' ? descriptor.key(keyOrPair) : descriptor.pair(keyOrPair))} is deprecated`];

    if (redirectTo) {
      messages.push(`we now treat it as ${chalk.default.blue(typeof redirectTo === 'string' ? descriptor.key(redirectTo) : descriptor.pair(redirectTo))}`);
    }

    return messages.join('; ') + '.';
  };
});
unwrapExports(common);

var deprecated = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  tslib_1.__exportStar(common, exports);
});
unwrapExports(deprecated);

var common$2 = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  exports.commonInvalidHandler = function (key, value, utils) {
    return [`Invalid ${chalk.default.red(utils.descriptor.key(key))} value.`, `Expected ${chalk.default.blue(utils.schemas[key].expected(utils))},`, `but received ${chalk.default.red(utils.descriptor.value(value))}.`].join(' ');
  };
});
unwrapExports(common$2);

var invalid = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  tslib_1.__exportStar(common$2, exports);
});
unwrapExports(invalid);

/* eslint-disable no-nested-ternary */
var arr = [];
var charCodeCache = [];

var leven$1 = function leven(a, b) {
  if (a === b) {
    return 0;
  }

  var swap = a; // Swapping the strings if `a` is longer than `b` so we know which one is the
  // shortest & which one is the longest

  if (a.length > b.length) {
    a = b;
    b = swap;
  }

  var aLen = a.length;
  var bLen = b.length;

  if (aLen === 0) {
    return bLen;
  }

  if (bLen === 0) {
    return aLen;
  } // Performing suffix trimming:
  // We can linearly drop suffix common to both strings since they
  // don't increase distance at all
  // Note: `~-` is the bitwise way to perform a `- 1` operation


  while (aLen > 0 && a.charCodeAt(~-aLen) === b.charCodeAt(~-bLen)) {
    aLen--;
    bLen--;
  }

  if (aLen === 0) {
    return bLen;
  } // Performing prefix trimming
  // We can linearly drop prefix common to both strings since they
  // don't increase distance at all


  var start = 0;

  while (start < aLen && a.charCodeAt(start) === b.charCodeAt(start)) {
    start++;
  }

  aLen -= start;
  bLen -= start;

  if (aLen === 0) {
    return bLen;
  }

  var bCharCode;
  var ret;
  var tmp;
  var tmp2;
  var i = 0;
  var j = 0;

  while (i < aLen) {
    charCodeCache[start + i] = a.charCodeAt(start + i);
    arr[i] = ++i;
  }

  while (j < bLen) {
    bCharCode = b.charCodeAt(start + j);
    tmp = j++;
    ret = j;

    for (i = 0; i < aLen; i++) {
      tmp2 = bCharCode === charCodeCache[start + i] ? tmp : tmp + 1;
      tmp = arr[i];
      ret = arr[i] = tmp > ret ? tmp2 > ret ? ret + 1 : tmp2 : tmp2 > tmp ? tmp + 1 : tmp2;
    }
  }

  return ret;
};

var leven_1 = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  exports.levenUnknownHandler = function (key, value, _ref) {
    var descriptor = _ref.descriptor,
        logger = _ref.logger,
        schemas = _ref.schemas;
    var messages = [`Ignored unknown option ${chalk.default.yellow(descriptor.pair({
      key,
      value
    }))}.`];
    var suggestion = Object.keys(schemas).sort().find(function (knownKey) {
      return leven$1(key, knownKey) < 3;
    });

    if (suggestion) {
      messages.push(`Did you mean ${chalk.default.blue(descriptor.key(suggestion))}?`);
    }

    logger.warn(messages.join(' '));
  };
});
unwrapExports(leven_1);

var unknown = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  tslib_1.__exportStar(leven_1, exports);
});
unwrapExports(unknown);

var handlers = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  tslib_1.__exportStar(deprecated, exports);

  tslib_1.__exportStar(invalid, exports);

  tslib_1.__exportStar(unknown, exports);
});
unwrapExports(handlers);

var schema = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  var HANDLER_KEYS = ['default', 'expected', 'validate', 'deprecated', 'forward', 'redirect', 'overlap', 'preprocess', 'postprocess'];

  function createSchema(SchemaConstructor, parameters) {
    var schema = new SchemaConstructor(parameters);
    var subSchema = Object.create(schema);

    for (var _i = 0; _i < HANDLER_KEYS.length; _i++) {
      var handlerKey = HANDLER_KEYS[_i];

      if (handlerKey in parameters) {
        subSchema[handlerKey] = normalizeHandler(parameters[handlerKey], schema, Schema.prototype[handlerKey].length);
      }
    }

    return subSchema;
  }

  exports.createSchema = createSchema;

  var Schema =
  /*#__PURE__*/
  function () {
    function Schema(parameters) {
      _classCallCheck(this, Schema);

      this.name = parameters.name;
    }

    _createClass(Schema, [{
      key: "default",
      value: function _default(_utils) {
        return undefined;
      } // istanbul ignore next: this is actually an abstract method but we need a placeholder to get `function.length`

    }, {
      key: "expected",
      value: function expected(_utils) {
        return 'nothing';
      } // istanbul ignore next: this is actually an abstract method but we need a placeholder to get `function.length`

    }, {
      key: "validate",
      value: function validate(_value, _utils) {
        return false;
      }
    }, {
      key: "deprecated",
      value: function deprecated(_value, _utils) {
        return false;
      }
    }, {
      key: "forward",
      value: function forward(_value, _utils) {
        return undefined;
      }
    }, {
      key: "redirect",
      value: function redirect(_value, _utils) {
        return undefined;
      }
    }, {
      key: "overlap",
      value: function overlap(currentValue, _newValue, _utils) {
        return currentValue;
      }
    }, {
      key: "preprocess",
      value: function preprocess(value, _utils) {
        return value;
      }
    }, {
      key: "postprocess",
      value: function postprocess(value, _utils) {
        return value;
      }
    }], [{
      key: "create",
      value: function create(parameters) {
        // @ts-ignore: https://github.com/Microsoft/TypeScript/issues/5863
        return createSchema(this, parameters);
      }
    }]);

    return Schema;
  }();

  exports.Schema = Schema;

  function normalizeHandler(handler, superSchema, handlerArgumentsLength) {
    return typeof handler === 'function' ? function () {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return handler.apply(void 0, _toConsumableArray(args.slice(0, handlerArgumentsLength - 1)).concat([superSchema], _toConsumableArray(args.slice(handlerArgumentsLength - 1))));
    } : function () {
      return handler;
    };
  }
});
unwrapExports(schema);

var alias = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var AliasSchema =
  /*#__PURE__*/
  function (_schema_1$Schema) {
    _inherits(AliasSchema, _schema_1$Schema);

    function AliasSchema(parameters) {
      var _this;

      _classCallCheck(this, AliasSchema);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(AliasSchema).call(this, parameters));
      _this._sourceName = parameters.sourceName;
      return _this;
    }

    _createClass(AliasSchema, [{
      key: "expected",
      value: function expected(utils) {
        return utils.schemas[this._sourceName].expected(utils);
      }
    }, {
      key: "validate",
      value: function validate(value, utils) {
        return utils.schemas[this._sourceName].validate(value, utils);
      }
    }, {
      key: "redirect",
      value: function redirect(_value, _utils) {
        return this._sourceName;
      }
    }]);

    return AliasSchema;
  }(schema.Schema);

  exports.AliasSchema = AliasSchema;
});
unwrapExports(alias);

var any = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var AnySchema =
  /*#__PURE__*/
  function (_schema_1$Schema) {
    _inherits(AnySchema, _schema_1$Schema);

    function AnySchema() {
      _classCallCheck(this, AnySchema);

      return _possibleConstructorReturn(this, _getPrototypeOf(AnySchema).apply(this, arguments));
    }

    _createClass(AnySchema, [{
      key: "expected",
      value: function expected() {
        return 'anything';
      }
    }, {
      key: "validate",
      value: function validate() {
        return true;
      }
    }]);

    return AnySchema;
  }(schema.Schema);

  exports.AnySchema = AnySchema;
});
unwrapExports(any);

var array$2 = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var ArraySchema =
  /*#__PURE__*/
  function (_schema_1$Schema) {
    _inherits(ArraySchema, _schema_1$Schema);

    function ArraySchema(_a) {
      var _this;

      _classCallCheck(this, ArraySchema);

      var valueSchema = _a.valueSchema,
          _a$name = _a.name,
          name = _a$name === void 0 ? valueSchema.name : _a$name,
          handlers = tslib_1.__rest(_a, ["valueSchema", "name"]);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(ArraySchema).call(this, Object.assign({}, handlers, {
        name
      })));
      _this._valueSchema = valueSchema;
      return _this;
    }

    _createClass(ArraySchema, [{
      key: "expected",
      value: function expected(utils) {
        return `an array of ${this._valueSchema.expected(utils)}`;
      }
    }, {
      key: "validate",
      value: function validate(value, utils) {
        if (!Array.isArray(value)) {
          return false;
        }

        var invalidValues = [];
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = value[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var subValue = _step.value;
            var subValidateResult = utils.normalizeValidateResult(this._valueSchema.validate(subValue, utils), subValue);

            if (subValidateResult !== true) {
              invalidValues.push(subValidateResult.value);
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return != null) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }

        return invalidValues.length === 0 ? true : {
          value: invalidValues
        };
      }
    }, {
      key: "deprecated",
      value: function deprecated(value, utils) {
        var deprecatedResult = [];
        var _iteratorNormalCompletion2 = true;
        var _didIteratorError2 = false;
        var _iteratorError2 = undefined;

        try {
          for (var _iterator2 = value[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var subValue = _step2.value;
            var subDeprecatedResult = utils.normalizeDeprecatedResult(this._valueSchema.deprecated(subValue, utils), subValue);

            if (subDeprecatedResult !== false) {
              deprecatedResult.push.apply(deprecatedResult, _toConsumableArray(subDeprecatedResult.map(function (_ref) {
                var deprecatedValue = _ref.value;
                return {
                  value: [deprecatedValue]
                };
              })));
            }
          }
        } catch (err) {
          _didIteratorError2 = true;
          _iteratorError2 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
              _iterator2.return();
            }
          } finally {
            if (_didIteratorError2) {
              throw _iteratorError2;
            }
          }
        }

        return deprecatedResult;
      }
    }, {
      key: "forward",
      value: function forward(value, utils) {
        var forwardResult = [];
        var _iteratorNormalCompletion3 = true;
        var _didIteratorError3 = false;
        var _iteratorError3 = undefined;

        try {
          for (var _iterator3 = value[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
            var subValue = _step3.value;
            var subForwardResult = utils.normalizeForwardResult(this._valueSchema.forward(subValue, utils), subValue);
            forwardResult.push.apply(forwardResult, _toConsumableArray(subForwardResult.map(wrapTransferResult)));
          }
        } catch (err) {
          _didIteratorError3 = true;
          _iteratorError3 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
              _iterator3.return();
            }
          } finally {
            if (_didIteratorError3) {
              throw _iteratorError3;
            }
          }
        }

        return forwardResult;
      }
    }, {
      key: "redirect",
      value: function redirect(value, utils) {
        var remain = [];
        var redirect = [];
        var _iteratorNormalCompletion4 = true;
        var _didIteratorError4 = false;
        var _iteratorError4 = undefined;

        try {
          for (var _iterator4 = value[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
            var subValue = _step4.value;
            var subRedirectResult = utils.normalizeRedirectResult(this._valueSchema.redirect(subValue, utils), subValue);

            if ('remain' in subRedirectResult) {
              remain.push(subRedirectResult.remain);
            }

            redirect.push.apply(redirect, _toConsumableArray(subRedirectResult.redirect.map(wrapTransferResult)));
          }
        } catch (err) {
          _didIteratorError4 = true;
          _iteratorError4 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion4 && _iterator4.return != null) {
              _iterator4.return();
            }
          } finally {
            if (_didIteratorError4) {
              throw _iteratorError4;
            }
          }
        }

        return remain.length === 0 ? {
          redirect
        } : {
          redirect,
          remain
        };
      }
    }, {
      key: "overlap",
      value: function overlap(currentValue, newValue) {
        return currentValue.concat(newValue);
      }
    }]);

    return ArraySchema;
  }(schema.Schema);

  exports.ArraySchema = ArraySchema;

  function wrapTransferResult(_ref2) {
    var from = _ref2.from,
        to = _ref2.to;
    return {
      from: [from],
      to
    };
  }
});
unwrapExports(array$2);

var boolean_1 = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var BooleanSchema =
  /*#__PURE__*/
  function (_schema_1$Schema) {
    _inherits(BooleanSchema, _schema_1$Schema);

    function BooleanSchema() {
      _classCallCheck(this, BooleanSchema);

      return _possibleConstructorReturn(this, _getPrototypeOf(BooleanSchema).apply(this, arguments));
    }

    _createClass(BooleanSchema, [{
      key: "expected",
      value: function expected() {
        return 'true or false';
      }
    }, {
      key: "validate",
      value: function validate(value) {
        return typeof value === 'boolean';
      }
    }]);

    return BooleanSchema;
  }(schema.Schema);

  exports.BooleanSchema = BooleanSchema;
});
unwrapExports(boolean_1);

var utils = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  function recordFromArray(array, mainKey) {
    var record = Object.create(null);
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = array[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var value = _step.value;
        var key = value[mainKey]; // istanbul ignore next

        if (record[key]) {
          throw new Error(`Duplicate ${mainKey} ${JSON.stringify(key)}`);
        } // @ts-ignore


        record[key] = value;
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return record;
  }

  exports.recordFromArray = recordFromArray;

  function mapFromArray(array, mainKey) {
    var map = new Map();
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
      for (var _iterator2 = array[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
        var value = _step2.value;
        var key = value[mainKey]; // istanbul ignore next

        if (map.has(key)) {
          throw new Error(`Duplicate ${mainKey} ${JSON.stringify(key)}`);
        }

        map.set(key, value);
      }
    } catch (err) {
      _didIteratorError2 = true;
      _iteratorError2 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
          _iterator2.return();
        }
      } finally {
        if (_didIteratorError2) {
          throw _iteratorError2;
        }
      }
    }

    return map;
  }

  exports.mapFromArray = mapFromArray;

  function createAutoChecklist() {
    var map = Object.create(null);
    return function (id) {
      var idString = JSON.stringify(id);

      if (map[idString]) {
        return true;
      }

      map[idString] = true;
      return false;
    };
  }

  exports.createAutoChecklist = createAutoChecklist;

  function partition(array, predicate) {
    var trueArray = [];
    var falseArray = [];
    var _iteratorNormalCompletion3 = true;
    var _didIteratorError3 = false;
    var _iteratorError3 = undefined;

    try {
      for (var _iterator3 = array[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
        var value = _step3.value;

        if (predicate(value)) {
          trueArray.push(value);
        } else {
          falseArray.push(value);
        }
      }
    } catch (err) {
      _didIteratorError3 = true;
      _iteratorError3 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
          _iterator3.return();
        }
      } finally {
        if (_didIteratorError3) {
          throw _iteratorError3;
        }
      }
    }

    return [trueArray, falseArray];
  }

  exports.partition = partition;

  function isInt(value) {
    return value === Math.floor(value);
  }

  exports.isInt = isInt;

  function comparePrimitive(a, b) {
    if (a === b) {
      return 0;
    }

    var typeofA = typeof a;
    var typeofB = typeof b;
    var orders = ['undefined', 'object', 'boolean', 'number', 'string'];

    if (typeofA !== typeofB) {
      return orders.indexOf(typeofA) - orders.indexOf(typeofB);
    }

    if (typeofA !== 'string') {
      return Number(a) - Number(b);
    }

    return a.localeCompare(b);
  }

  exports.comparePrimitive = comparePrimitive;

  function normalizeDefaultResult(result) {
    return result === undefined ? {} : result;
  }

  exports.normalizeDefaultResult = normalizeDefaultResult;

  function normalizeValidateResult(result, value) {
    return result === true ? true : result === false ? {
      value
    } : result;
  }

  exports.normalizeValidateResult = normalizeValidateResult;

  function normalizeDeprecatedResult(result, value) {
    var doNotNormalizeTrue = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    return result === false ? false : result === true ? doNotNormalizeTrue ? true : [{
      value
    }] : 'value' in result ? [result] : result.length === 0 ? false : result;
  }

  exports.normalizeDeprecatedResult = normalizeDeprecatedResult;

  function normalizeTransferResult(result, value) {
    return typeof result === 'string' || 'key' in result ? {
      from: value,
      to: result
    } : 'from' in result ? {
      from: result.from,
      to: result.to
    } : {
      from: value,
      to: result.to
    };
  }

  exports.normalizeTransferResult = normalizeTransferResult;

  function normalizeForwardResult(result, value) {
    return result === undefined ? [] : Array.isArray(result) ? result.map(function (transferResult) {
      return normalizeTransferResult(transferResult, value);
    }) : [normalizeTransferResult(result, value)];
  }

  exports.normalizeForwardResult = normalizeForwardResult;

  function normalizeRedirectResult(result, value) {
    var redirect = normalizeForwardResult(typeof result === 'object' && 'redirect' in result ? result.redirect : result, value);
    return redirect.length === 0 ? {
      remain: value,
      redirect
    } : typeof result === 'object' && 'remain' in result ? {
      remain: result.remain,
      redirect
    } : {
      redirect
    };
  }

  exports.normalizeRedirectResult = normalizeRedirectResult;
});
unwrapExports(utils);

var choice = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var ChoiceSchema =
  /*#__PURE__*/
  function (_schema_1$Schema) {
    _inherits(ChoiceSchema, _schema_1$Schema);

    function ChoiceSchema(parameters) {
      var _this;

      _classCallCheck(this, ChoiceSchema);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(ChoiceSchema).call(this, parameters));
      _this._choices = utils.mapFromArray(parameters.choices.map(function (choice) {
        return choice && typeof choice === 'object' ? choice : {
          value: choice
        };
      }), 'value');
      return _this;
    }

    _createClass(ChoiceSchema, [{
      key: "expected",
      value: function expected(_ref) {
        var _this2 = this;

        var descriptor = _ref.descriptor;
        var choiceValues = Array.from(this._choices.keys()).map(function (value) {
          return _this2._choices.get(value);
        }).filter(function (choiceInfo) {
          return !choiceInfo.deprecated;
        }).map(function (choiceInfo) {
          return choiceInfo.value;
        }).sort(utils.comparePrimitive).map(descriptor.value);
        var head = choiceValues.slice(0, -2);
        var tail = choiceValues.slice(-2);
        return head.concat(tail.join(' or ')).join(', ');
      }
    }, {
      key: "validate",
      value: function validate(value) {
        return this._choices.has(value);
      }
    }, {
      key: "deprecated",
      value: function deprecated(value) {
        var choiceInfo = this._choices.get(value);

        return choiceInfo && choiceInfo.deprecated ? {
          value
        } : false;
      }
    }, {
      key: "forward",
      value: function forward(value) {
        var choiceInfo = this._choices.get(value);

        return choiceInfo ? choiceInfo.forward : undefined;
      }
    }, {
      key: "redirect",
      value: function redirect(value) {
        var choiceInfo = this._choices.get(value);

        return choiceInfo ? choiceInfo.redirect : undefined;
      }
    }]);

    return ChoiceSchema;
  }(schema.Schema);

  exports.ChoiceSchema = ChoiceSchema;
});
unwrapExports(choice);

var number = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var NumberSchema =
  /*#__PURE__*/
  function (_schema_1$Schema) {
    _inherits(NumberSchema, _schema_1$Schema);

    function NumberSchema() {
      _classCallCheck(this, NumberSchema);

      return _possibleConstructorReturn(this, _getPrototypeOf(NumberSchema).apply(this, arguments));
    }

    _createClass(NumberSchema, [{
      key: "expected",
      value: function expected() {
        return 'a number';
      }
    }, {
      key: "validate",
      value: function validate(value, _utils) {
        return typeof value === 'number';
      }
    }]);

    return NumberSchema;
  }(schema.Schema);

  exports.NumberSchema = NumberSchema;
});
unwrapExports(number);

var integer = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var IntegerSchema =
  /*#__PURE__*/
  function (_number_1$NumberSchem) {
    _inherits(IntegerSchema, _number_1$NumberSchem);

    function IntegerSchema() {
      _classCallCheck(this, IntegerSchema);

      return _possibleConstructorReturn(this, _getPrototypeOf(IntegerSchema).apply(this, arguments));
    }

    _createClass(IntegerSchema, [{
      key: "expected",
      value: function expected() {
        return 'an integer';
      }
    }, {
      key: "validate",
      value: function validate(value, utils$$2) {
        return utils$$2.normalizeValidateResult(_get(_getPrototypeOf(IntegerSchema.prototype), "validate", this).call(this, value, utils$$2), value) === true && utils.isInt(value);
      }
    }]);

    return IntegerSchema;
  }(number.NumberSchema);

  exports.IntegerSchema = IntegerSchema;
});
unwrapExports(integer);

var string = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var StringSchema =
  /*#__PURE__*/
  function (_schema_1$Schema) {
    _inherits(StringSchema, _schema_1$Schema);

    function StringSchema() {
      _classCallCheck(this, StringSchema);

      return _possibleConstructorReturn(this, _getPrototypeOf(StringSchema).apply(this, arguments));
    }

    _createClass(StringSchema, [{
      key: "expected",
      value: function expected() {
        return 'a string';
      }
    }, {
      key: "validate",
      value: function validate(value) {
        return typeof value === 'string';
      }
    }]);

    return StringSchema;
  }(schema.Schema);

  exports.StringSchema = StringSchema;
});
unwrapExports(string);

var schemas = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  tslib_1.__exportStar(alias, exports);

  tslib_1.__exportStar(any, exports);

  tslib_1.__exportStar(array$2, exports);

  tslib_1.__exportStar(boolean_1, exports);

  tslib_1.__exportStar(choice, exports);

  tslib_1.__exportStar(integer, exports);

  tslib_1.__exportStar(number, exports);

  tslib_1.__exportStar(string, exports);
});
unwrapExports(schemas);

var defaults = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.defaultDescriptor = api.apiDescriptor;
  exports.defaultUnknownHandler = leven_1.levenUnknownHandler;
  exports.defaultInvalidHandler = invalid.commonInvalidHandler;
  exports.defaultDeprecatedHandler = common.commonDeprecatedHandler;
});
unwrapExports(defaults);

var normalize$1 = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  exports.normalize = function (options, schemas, opts) {
    return new Normalizer(schemas, opts).normalize(options);
  };

  var Normalizer =
  /*#__PURE__*/
  function () {
    function Normalizer(schemas, opts) {
      _classCallCheck(this, Normalizer);

      // istanbul ignore next
      var _ref = opts || {},
          _ref$logger = _ref.logger,
          logger = _ref$logger === void 0 ? console : _ref$logger,
          _ref$descriptor = _ref.descriptor,
          descriptor = _ref$descriptor === void 0 ? defaults.defaultDescriptor : _ref$descriptor,
          _ref$unknown = _ref.unknown,
          unknown = _ref$unknown === void 0 ? defaults.defaultUnknownHandler : _ref$unknown,
          _ref$invalid = _ref.invalid,
          invalid = _ref$invalid === void 0 ? defaults.defaultInvalidHandler : _ref$invalid,
          _ref$deprecated = _ref.deprecated,
          deprecated = _ref$deprecated === void 0 ? defaults.defaultDeprecatedHandler : _ref$deprecated;

      this._utils = {
        descriptor,
        logger:
        /* istanbul ignore next */
        logger || {
          warn: function warn() {}
        },
        schemas: utils.recordFromArray(schemas, 'name'),
        normalizeDefaultResult: utils.normalizeDefaultResult,
        normalizeDeprecatedResult: utils.normalizeDeprecatedResult,
        normalizeForwardResult: utils.normalizeForwardResult,
        normalizeRedirectResult: utils.normalizeRedirectResult,
        normalizeValidateResult: utils.normalizeValidateResult
      };
      this._unknownHandler = unknown;
      this._invalidHandler = invalid;
      this._deprecatedHandler = deprecated;
      this.cleanHistory();
    }

    _createClass(Normalizer, [{
      key: "cleanHistory",
      value: function cleanHistory() {
        this._hasDeprecationWarned = utils.createAutoChecklist();
      }
    }, {
      key: "normalize",
      value: function normalize(options) {
        var _this = this;

        var normalized = {};
        var restOptionsArray = [options];

        var applyNormalization = function applyNormalization() {
          while (restOptionsArray.length !== 0) {
            var currentOptions = restOptionsArray.shift();

            var transferredOptionsArray = _this._applyNormalization(currentOptions, normalized);

            restOptionsArray.push.apply(restOptionsArray, _toConsumableArray(transferredOptionsArray));
          }
        };

        applyNormalization();

        var _arr = Object.keys(this._utils.schemas);

        for (var _i = 0; _i < _arr.length; _i++) {
          var key = _arr[_i];
          var schema = this._utils.schemas[key];

          if (!(key in normalized)) {
            var defaultResult = utils.normalizeDefaultResult(schema.default(this._utils));

            if ('value' in defaultResult) {
              restOptionsArray.push({
                [key]: defaultResult.value
              });
            }
          }
        }

        applyNormalization();

        var _arr2 = Object.keys(this._utils.schemas);

        for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
          var _key = _arr2[_i2];
          var _schema = this._utils.schemas[_key];

          if (_key in normalized) {
            normalized[_key] = _schema.postprocess(normalized[_key], this._utils);
          }
        }

        return normalized;
      }
    }, {
      key: "_applyNormalization",
      value: function _applyNormalization(options, normalized) {
        var _this2 = this;

        var transferredOptionsArray = [];

        var _utils_1$partition = utils.partition(Object.keys(options), function (key) {
          return key in _this2._utils.schemas;
        }),
            _utils_1$partition2 = _slicedToArray(_utils_1$partition, 2),
            knownOptionNames = _utils_1$partition2[0],
            unknownOptionNames = _utils_1$partition2[1];

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          var _loop = function _loop() {
            var key = _step.value;
            var schema = _this2._utils.schemas[key];
            var value = schema.preprocess(options[key], _this2._utils);
            var validateResult = utils.normalizeValidateResult(schema.validate(value, _this2._utils), value);

            if (validateResult !== true) {
              var invalidValue = validateResult.value;

              var errorMessageOrError = _this2._invalidHandler(key, invalidValue, _this2._utils);

              throw typeof errorMessageOrError === 'string' ? new Error(errorMessageOrError) :
              /* istanbul ignore next*/
              errorMessageOrError;
            }

            var appendTransferredOptions = function appendTransferredOptions(_ref2) {
              var from = _ref2.from,
                  to = _ref2.to;
              transferredOptionsArray.push(typeof to === 'string' ? {
                [to]: from
              } : {
                [to.key]: to.value
              });
            };

            var warnDeprecated = function warnDeprecated(_ref3) {
              var currentValue = _ref3.value,
                  redirectTo = _ref3.redirectTo;
              var deprecatedResult = utils.normalizeDeprecatedResult(schema.deprecated(currentValue, _this2._utils), value,
              /* doNotNormalizeTrue */
              true);

              if (deprecatedResult === false) {
                return;
              }

              if (deprecatedResult === true) {
                if (!_this2._hasDeprecationWarned(key)) {
                  _this2._utils.logger.warn(_this2._deprecatedHandler(key, redirectTo, _this2._utils));
                }
              } else {
                var _iteratorNormalCompletion3 = true;
                var _didIteratorError3 = false;
                var _iteratorError3 = undefined;

                try {
                  for (var _iterator3 = deprecatedResult[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                    var deprecatedValue = _step3.value.value;
                    var pair = {
                      key,
                      value: deprecatedValue
                    };

                    if (!_this2._hasDeprecationWarned(pair)) {
                      var redirectToPair = typeof redirectTo === 'string' ? {
                        key: redirectTo,
                        value: deprecatedValue
                      } : redirectTo;

                      _this2._utils.logger.warn(_this2._deprecatedHandler(pair, redirectToPair, _this2._utils));
                    }
                  }
                } catch (err) {
                  _didIteratorError3 = true;
                  _iteratorError3 = err;
                } finally {
                  try {
                    if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
                      _iterator3.return();
                    }
                  } finally {
                    if (_didIteratorError3) {
                      throw _iteratorError3;
                    }
                  }
                }
              }
            };

            var forwardResult = utils.normalizeForwardResult(schema.forward(value, _this2._utils), value);
            forwardResult.forEach(appendTransferredOptions);
            var redirectResult = utils.normalizeRedirectResult(schema.redirect(value, _this2._utils), value);
            redirectResult.redirect.forEach(appendTransferredOptions);

            if ('remain' in redirectResult) {
              var remainingValue = redirectResult.remain;
              normalized[key] = key in normalized ? schema.overlap(normalized[key], remainingValue, _this2._utils) : remainingValue;
              warnDeprecated({
                value: remainingValue
              });
            }

            var _iteratorNormalCompletion4 = true;
            var _didIteratorError4 = false;
            var _iteratorError4 = undefined;

            try {
              for (var _iterator4 = redirectResult.redirect[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
                var _step4$value = _step4.value,
                    from = _step4$value.from,
                    to = _step4$value.to;
                warnDeprecated({
                  value: from,
                  redirectTo: to
                });
              }
            } catch (err) {
              _didIteratorError4 = true;
              _iteratorError4 = err;
            } finally {
              try {
                if (!_iteratorNormalCompletion4 && _iterator4.return != null) {
                  _iterator4.return();
                }
              } finally {
                if (_didIteratorError4) {
                  throw _iteratorError4;
                }
              }
            }
          };

          for (var _iterator = knownOptionNames[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            _loop();
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return != null) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }

        var _iteratorNormalCompletion2 = true;
        var _didIteratorError2 = false;
        var _iteratorError2 = undefined;

        try {
          for (var _iterator2 = unknownOptionNames[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var key = _step2.value;
            var value = options[key];

            var unknownResult = this._unknownHandler(key, value, this._utils);

            if (unknownResult) {
              var _arr3 = Object.keys(unknownResult);

              for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
                var unknownKey = _arr3[_i3];
                var unknownOption = {
                  [unknownKey]: unknownResult[unknownKey]
                };

                if (unknownKey in this._utils.schemas) {
                  transferredOptionsArray.push(unknownOption);
                } else {
                  Object.assign(normalized, unknownOption);
                }
              }
            }
          }
        } catch (err) {
          _didIteratorError2 = true;
          _iteratorError2 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
              _iterator2.return();
            }
          } finally {
            if (_didIteratorError2) {
              throw _iteratorError2;
            }
          }
        }

        return transferredOptionsArray;
      }
    }]);

    return Normalizer;
  }();

  exports.Normalizer = Normalizer;
});
unwrapExports(normalize$1);

var lib$1 = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  tslib_1.__exportStar(descriptors, exports);

  tslib_1.__exportStar(handlers, exports);

  tslib_1.__exportStar(schemas, exports);

  tslib_1.__exportStar(normalize$1, exports);

  tslib_1.__exportStar(schema, exports);
});
unwrapExports(lib$1);

var hasFlag$3 = function hasFlag(flag, argv) {
  argv = argv || process.argv;
  var terminatorPos = argv.indexOf('--');
  var prefix = /^-{1,2}/.test(flag) ? '' : '--';
  var pos = argv.indexOf(prefix + flag);
  return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
};

var supportsColor$1 = createCommonjsModule(function (module) {
  'use strict';

  var env = process.env;

  var support = function support(level) {
    if (level === 0) {
      return false;
    }

    return {
      level,
      hasBasic: true,
      has256: level >= 2,
      has16m: level >= 3
    };
  };

  var supportLevel = function () {
    if (hasFlag$3('no-color') || hasFlag$3('no-colors') || hasFlag$3('color=false')) {
      return 0;
    }

    if (hasFlag$3('color=16m') || hasFlag$3('color=full') || hasFlag$3('color=truecolor')) {
      return 3;
    }

    if (hasFlag$3('color=256')) {
      return 2;
    }

    if (hasFlag$3('color') || hasFlag$3('colors') || hasFlag$3('color=true') || hasFlag$3('color=always')) {
      return 1;
    }

    if (process.stdout && !process.stdout.isTTY) {
      return 0;
    }

    if (process.platform === 'win32') {
      // Node.js 7.5.0 is the first version of Node.js to include a patch to
      // libuv that enables 256 color output on Windows. Anything earlier and it
      // won't work. However, here we target Node.js 8 at minimum as it is an LTS
      // release, and Node.js 7 is not. Windows 10 build 10586 is the first Windows
      // release that supports 256 colors.
      var osRelease = os.release().split('.');

      if (Number(process.versions.node.split('.')[0]) >= 8 && Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
        return 2;
      }

      return 1;
    }

    if ('CI' in env) {
      if (['TRAVIS', 'CIRCLECI', 'APPVEYOR', 'GITLAB_CI'].some(function (sign) {
        return sign in env;
      }) || env.CI_NAME === 'codeship') {
        return 1;
      }

      return 0;
    }

    if ('TEAMCITY_VERSION' in env) {
      return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
    }

    if ('TERM_PROGRAM' in env) {
      var version = parseInt((env.TERM_PROGRAM_VERSION || '').split('.')[0], 10);

      switch (env.TERM_PROGRAM) {
        case 'iTerm.app':
          return version >= 3 ? 3 : 2;

        case 'Hyper':
          return 3;

        case 'Apple_Terminal':
          return 2;
        // No default
      }
    }

    if (/-256(color)?$/i.test(env.TERM)) {
      return 2;
    }

    if (/^screen|^xterm|^vt100|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
      return 1;
    }

    if ('COLORTERM' in env) {
      return 1;
    }

    if (env.TERM === 'dumb') {
      return 0;
    }

    return 0;
  }();

  if ('FORCE_COLOR' in env) {
    supportLevel = parseInt(env.FORCE_COLOR, 10) === 0 ? 0 : supportLevel || 1;
  }

  module.exports = process && support(supportLevel);
});

var templates$2 = createCommonjsModule(function (module) {
  'use strict';

  var TEMPLATE_REGEX = /(?:\\(u[a-f0-9]{4}|x[a-f0-9]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
  var STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
  var STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
  var ESCAPE_REGEX = /\\(u[0-9a-f]{4}|x[0-9a-f]{2}|.)|([^\\])/gi;
  var ESCAPES = {
    n: '\n',
    r: '\r',
    t: '\t',
    b: '\b',
    f: '\f',
    v: '\v',
    0: '\0',
    '\\': '\\',
    e: '\u001b',
    a: '\u0007'
  };

  function unescape(c) {
    if (c[0] === 'u' && c.length === 5 || c[0] === 'x' && c.length === 3) {
      return String.fromCharCode(parseInt(c.slice(1), 16));
    }

    return ESCAPES[c] || c;
  }

  function parseArguments(name, args) {
    var results = [];
    var chunks = args.trim().split(/\s*,\s*/g);
    var matches;
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = chunks[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var chunk = _step.value;

        if (!isNaN(chunk)) {
          results.push(Number(chunk));
        } else if (matches = chunk.match(STRING_REGEX)) {
          results.push(matches[2].replace(ESCAPE_REGEX, function (m, escape, chr) {
            return escape ? unescape(escape) : chr;
          }));
        } else {
          throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return results;
  }

  function parseStyle(style) {
    STYLE_REGEX.lastIndex = 0;
    var results = [];
    var matches;

    while ((matches = STYLE_REGEX.exec(style)) !== null) {
      var name = matches[1];

      if (matches[2]) {
        var args = parseArguments(name, matches[2]);
        results.push([name].concat(args));
      } else {
        results.push([name]);
      }
    }

    return results;
  }

  function buildStyle(chalk, styles) {
    var enabled = {};
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
      for (var _iterator2 = styles[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
        var layer = _step2.value;
        var _iteratorNormalCompletion3 = true;
        var _didIteratorError3 = false;
        var _iteratorError3 = undefined;

        try {
          for (var _iterator3 = layer.styles[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
            var style = _step3.value;
            enabled[style[0]] = layer.inverse ? null : style.slice(1);
          }
        } catch (err) {
          _didIteratorError3 = true;
          _iteratorError3 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
              _iterator3.return();
            }
          } finally {
            if (_didIteratorError3) {
              throw _iteratorError3;
            }
          }
        }
      }
    } catch (err) {
      _didIteratorError2 = true;
      _iteratorError2 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
          _iterator2.return();
        }
      } finally {
        if (_didIteratorError2) {
          throw _iteratorError2;
        }
      }
    }

    var current = chalk;

    var _arr = Object.keys(enabled);

    for (var _i = 0; _i < _arr.length; _i++) {
      var styleName = _arr[_i];

      if (Array.isArray(enabled[styleName])) {
        if (!(styleName in current)) {
          throw new Error(`Unknown Chalk style: ${styleName}`);
        }

        if (enabled[styleName].length > 0) {
          current = current[styleName].apply(current, enabled[styleName]);
        } else {
          current = current[styleName];
        }
      }
    }

    return current;
  }

  module.exports = function (chalk, tmp) {
    var styles = [];
    var chunks = [];
    var chunk = []; // eslint-disable-next-line max-params

    tmp.replace(TEMPLATE_REGEX, function (m, escapeChar, inverse, style, close, chr) {
      if (escapeChar) {
        chunk.push(unescape(escapeChar));
      } else if (style) {
        var str = chunk.join('');
        chunk = [];
        chunks.push(styles.length === 0 ? str : buildStyle(chalk, styles)(str));
        styles.push({
          inverse,
          styles: parseStyle(style)
        });
      } else if (close) {
        if (styles.length === 0) {
          throw new Error('Found extraneous } in Chalk template literal');
        }

        chunks.push(buildStyle(chalk, styles)(chunk.join('')));
        chunk = [];
        styles.pop();
      } else {
        chunk.push(chr);
      }
    });
    chunks.push(chunk.join(''));

    if (styles.length > 0) {
      var errMsg = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? '' : 's'} (\`}\`)`;
      throw new Error(errMsg);
    }

    return chunks.join('');
  };
});

var isSimpleWindowsTerm = process.platform === 'win32' && !(process.env.TERM || '').toLowerCase().startsWith('xterm'); // `supportsColor.level` → `ansiStyles.color[name]` mapping

var levelMapping = ['ansi', 'ansi', 'ansi256', 'ansi16m']; // `color-convert` models to exclude from the Chalk API due to conflicts and such

var skipModels = new Set(['gray']);
var styles = Object.create(null);

function applyOptions(obj, options) {
  options = options || {}; // Detect level if not set manually

  var scLevel = supportsColor$1 ? supportsColor$1.level : 0;
  obj.level = options.level === undefined ? scLevel : options.level;
  obj.enabled = 'enabled' in options ? options.enabled : obj.level > 0;
}

function Chalk(options) {
  // We check for this.template here since calling `chalk.constructor()`
  // by itself will have a `this` of a previously constructed chalk object
  if (!this || !(this instanceof Chalk) || this.template) {
    var _chalk = {};
    applyOptions(_chalk, options);

    _chalk.template = function () {
      var args = [].slice.call(arguments);
      return chalkTag.apply(null, [_chalk.template].concat(args));
    };

    Object.setPrototypeOf(_chalk, Chalk.prototype);
    Object.setPrototypeOf(_chalk.template, _chalk);
    _chalk.template.constructor = Chalk;
    return _chalk.template;
  }

  applyOptions(this, options);
} // Use bright blue on Windows as the normal blue color is illegible


if (isSimpleWindowsTerm) {
  ansiStyles.blue.open = '\u001B[94m';
}

var _arr = Object.keys(ansiStyles);

var _loop = function _loop() {
  var key = _arr[_i];
  ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), 'g');
  styles[key] = {
    get() {
      var codes = ansiStyles[key];
      return build.call(this, this._styles ? this._styles.concat(codes) : [codes], key);
    }

  };
};

for (var _i = 0; _i < _arr.length; _i++) {
  _loop();
}

ansiStyles.color.closeRe = new RegExp(escapeStringRegexp(ansiStyles.color.close), 'g');

var _arr2 = Object.keys(ansiStyles.color.ansi);

var _loop2 = function _loop2() {
  var model = _arr2[_i2];

  if (skipModels.has(model)) {
    return "continue";
  }

  styles[model] = {
    get() {
      var level = this.level;
      return function () {
        var open = ansiStyles.color[levelMapping[level]][model].apply(null, arguments);
        var codes = {
          open,
          close: ansiStyles.color.close,
          closeRe: ansiStyles.color.closeRe
        };
        return build.call(this, this._styles ? this._styles.concat(codes) : [codes], model);
      };
    }

  };
};

for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
  var _ret = _loop2();

  if (_ret === "continue") continue;
}

ansiStyles.bgColor.closeRe = new RegExp(escapeStringRegexp(ansiStyles.bgColor.close), 'g');

var _arr3 = Object.keys(ansiStyles.bgColor.ansi);

var _loop3 = function _loop3() {
  var model = _arr3[_i3];

  if (skipModels.has(model)) {
    return "continue";
  }

  var bgModel = 'bg' + model[0].toUpperCase() + model.slice(1);
  styles[bgModel] = {
    get() {
      var level = this.level;
      return function () {
        var open = ansiStyles.bgColor[levelMapping[level]][model].apply(null, arguments);
        var codes = {
          open,
          close: ansiStyles.bgColor.close,
          closeRe: ansiStyles.bgColor.closeRe
        };
        return build.call(this, this._styles ? this._styles.concat(codes) : [codes], model);
      };
    }

  };
};

for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
  var _ret2 = _loop3();

  if (_ret2 === "continue") continue;
}

var proto = Object.defineProperties(function () {}, styles);

function build(_styles, key) {
  var builder = function builder() {
    return applyStyle.apply(builder, arguments);
  };

  builder._styles = _styles;
  var self = this;
  Object.defineProperty(builder, 'level', {
    enumerable: true,

    get() {
      return self.level;
    },

    set(level) {
      self.level = level;
    }

  });
  Object.defineProperty(builder, 'enabled', {
    enumerable: true,

    get() {
      return self.enabled;
    },

    set(enabled) {
      self.enabled = enabled;
    }

  }); // See below for fix regarding invisible grey/dim combination on Windows

  builder.hasGrey = this.hasGrey || key === 'gray' || key === 'grey'; // `__proto__` is used because we must return a function, but there is
  // no way to create a function with a different prototype

  builder.__proto__ = proto; // eslint-disable-line no-proto

  return builder;
}

function applyStyle() {
  // Support varags, but simply cast to string in case there's only one arg
  var args = arguments;
  var argsLen = args.length;
  var str = String(arguments[0]);

  if (argsLen === 0) {
    return '';
  }

  if (argsLen > 1) {
    // Don't slice `arguments`, it prevents V8 optimizations
    for (var a = 1; a < argsLen; a++) {
      str += ' ' + args[a];
    }
  }

  if (!this.enabled || this.level <= 0 || !str) {
    return str;
  } // Turns out that on Windows dimmed gray text becomes invisible in cmd.exe,
  // see https://github.com/chalk/chalk/issues/58
  // If we're on Windows and we're dealing with a gray color, temporarily make 'dim' a noop.


  var originalDim = ansiStyles.dim.open;

  if (isSimpleWindowsTerm && this.hasGrey) {
    ansiStyles.dim.open = '';
  }

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = this._styles.slice().reverse()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var code = _step.value;
      // Replace any instances already present with a re-opening code
      // otherwise only the part of the string until said closing code
      // will be colored, and the rest will simply be 'plain'.
      str = code.open + str.replace(code.closeRe, code.open) + code.close; // Close the styling before a linebreak and reopen
      // after next line to fix a bleed issue on macOS
      // https://github.com/chalk/chalk/pull/92

      str = str.replace(/\r?\n/g, `${code.close}$&${code.open}`);
    } // Reset the original `dim` if we changed it to work around the Windows dimmed gray issue

  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  ansiStyles.dim.open = originalDim;
  return str;
}

function chalkTag(chalk, strings) {
  if (!Array.isArray(strings)) {
    // If chalk() was called by itself or with a string,
    // return the string itself as a string.
    return [].slice.call(arguments, 1).join(' ');
  }

  var args = [].slice.call(arguments, 2);
  var parts = [strings.raw[0]];

  for (var i = 1; i < strings.length; i++) {
    parts.push(String(args[i - 1]).replace(/[{}\\]/g, '\\$&'));
    parts.push(String(strings.raw[i]));
  }

  return templates$2(chalk, parts.join(''));
}

Object.defineProperties(Chalk.prototype, styles);
var chalk$2 = Chalk(); // eslint-disable-line new-cap

var supportsColor_1$2 = supportsColor$1;
chalk$2.supportsColor = supportsColor_1$2;

var cliDescriptor = {
  key: function key(_key) {
    return _key.length === 1 ? `-${_key}` : `--${_key}`;
  },
  value: function value(_value) {
    return lib$1.apiDescriptor.value(_value);
  },
  pair: function pair(_ref) {
    var key = _ref.key,
        value = _ref.value;
    return value === false ? `--no-${key}` : value === true ? cliDescriptor.key(key) : value === "" ? `${cliDescriptor.key(key)} without an argument` : `${cliDescriptor.key(key)}=${value}`;
  }
};

var FlagSchema =
/*#__PURE__*/
function (_vnopts$ChoiceSchema) {
  _inherits(FlagSchema, _vnopts$ChoiceSchema);

  function FlagSchema(_ref2) {
    var _this;

    var name = _ref2.name,
        flags = _ref2.flags;

    _classCallCheck(this, FlagSchema);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(FlagSchema).call(this, {
      name,
      choices: flags
    }));
    _this._flags = flags.slice().sort();
    return _this;
  }

  _createClass(FlagSchema, [{
    key: "preprocess",
    value: function preprocess(value, utils) {
      if (typeof value === "string" && value.length !== 0 && this._flags.indexOf(value) === -1) {
        var suggestion = this._flags.find(function (flag) {
          return leven$1(flag, value) < 3;
        });

        if (suggestion) {
          utils.logger.warn([`Unknown flag ${chalk$2.yellow(utils.descriptor.value(value))},`, `did you mean ${chalk$2.blue(utils.descriptor.value(suggestion))}?`].join(" "));
          return suggestion;
        }
      }

      return value;
    }
  }, {
    key: "expected",
    value: function expected() {
      return "a flag";
    }
  }]);

  return FlagSchema;
}(lib$1.ChoiceSchema);

var hasDeprecationWarned;

function normalizeOptions$1(options, optionInfos) {
  var _ref3 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
      logger = _ref3.logger,
      _ref3$isCLI = _ref3.isCLI,
      isCLI = _ref3$isCLI === void 0 ? false : _ref3$isCLI,
      _ref3$passThrough = _ref3.passThrough,
      passThrough = _ref3$passThrough === void 0 ? false : _ref3$passThrough;

  var unknown = !passThrough ? lib$1.levenUnknownHandler : Array.isArray(passThrough) ? function (key, value) {
    return passThrough.indexOf(key) === -1 ? undefined : {
      [key]: value
    };
  } : function (key, value) {
    return {
      [key]: value
    };
  };
  var descriptor = isCLI ? cliDescriptor : lib$1.apiDescriptor;
  var schemas = optionInfosToSchemas(optionInfos, {
    isCLI
  });
  var normalizer = new lib$1.Normalizer(schemas, {
    logger,
    unknown,
    descriptor
  });
  var shouldSuppressDuplicateDeprecationWarnings = logger !== false;

  if (shouldSuppressDuplicateDeprecationWarnings && hasDeprecationWarned) {
    normalizer._hasDeprecationWarned = hasDeprecationWarned;
  }

  var normalized = normalizer.normalize(options);

  if (shouldSuppressDuplicateDeprecationWarnings) {
    hasDeprecationWarned = normalizer._hasDeprecationWarned;
  }

  return normalized;
}

function optionInfosToSchemas(optionInfos, _ref4) {
  var isCLI = _ref4.isCLI;
  var schemas = [];

  if (isCLI) {
    schemas.push(lib$1.AnySchema.create({
      name: "_"
    }));
  }

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = optionInfos[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var optionInfo = _step.value;
      schemas.push(optionInfoToSchema(optionInfo, {
        isCLI,
        optionInfos
      }));

      if (optionInfo.alias && isCLI) {
        schemas.push(lib$1.AliasSchema.create({
          name: optionInfo.alias,
          sourceName: optionInfo.name
        }));
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return schemas;
}

function optionInfoToSchema(optionInfo, _ref5) {
  var isCLI = _ref5.isCLI,
      optionInfos = _ref5.optionInfos;
  var SchemaConstructor;
  var parameters = {
    name: optionInfo.name
  };
  var handlers = {};

  switch (optionInfo.type) {
    case "int":
      SchemaConstructor = lib$1.IntegerSchema;

      if (isCLI) {
        parameters.preprocess = function (value) {
          return Number(value);
        };
      }

      break;

    case "choice":
      SchemaConstructor = lib$1.ChoiceSchema;
      parameters.choices = optionInfo.choices.map(function (choiceInfo) {
        return typeof choiceInfo === "object" && choiceInfo.redirect ? Object.assign({}, choiceInfo, {
          redirect: {
            to: {
              key: optionInfo.name,
              value: choiceInfo.redirect
            }
          }
        }) : choiceInfo;
      });
      break;

    case "boolean":
      SchemaConstructor = lib$1.BooleanSchema;
      break;

    case "flag":
      SchemaConstructor = FlagSchema;
      parameters.flags = optionInfos.map(function (optionInfo) {
        return [].concat(optionInfo.alias || [], optionInfo.description ? optionInfo.name : [], optionInfo.oppositeDescription ? `no-${optionInfo.name}` : []);
      }).reduce(function (a, b) {
        return a.concat(b);
      }, []);
      break;

    case "path":
      SchemaConstructor = lib$1.StringSchema;
      break;

    default:
      throw new Error(`Unexpected type ${optionInfo.type}`);
  }

  if (optionInfo.exception) {
    parameters.validate = function (value, schema, utils) {
      return optionInfo.exception(value) || schema.validate(value, utils);
    };
  } else {
    parameters.validate = function (value, schema, utils) {
      return value === undefined || schema.validate(value, utils);
    };
  }

  if (optionInfo.redirect) {
    handlers.redirect = function (value) {
      return !value ? undefined : {
        to: {
          key: optionInfo.redirect.option,
          value: optionInfo.redirect.value
        }
      };
    };
  }

  if (optionInfo.deprecated) {
    handlers.deprecated = true;
  } // allow CLI overriding, e.g., prettier package.json --tab-width 1 --tab-width 2


  if (isCLI && !optionInfo.array) {
    var originalPreprocess = parameters.preprocess || function (x) {
      return x;
    };

    parameters.preprocess = function (value, schema, utils) {
      return schema.preprocess(originalPreprocess(Array.isArray(value) ? value[value.length - 1] : value), utils);
    };
  }

  return optionInfo.array ? lib$1.ArraySchema.create(Object.assign(isCLI ? {
    preprocess: function preprocess(v) {
      return [].concat(v);
    }
  } : {}, handlers, {
    valueSchema: SchemaConstructor.create(parameters)
  })) : SchemaConstructor.create(Object.assign({}, parameters, handlers));
}

function normalizeApiOptions(options, optionInfos, opts) {
  return normalizeOptions$1(options, optionInfos, opts);
}

function normalizeCliOptions(options, optionInfos, opts) {
  return normalizeOptions$1(options, optionInfos, Object.assign({
    isCLI: true
  }, opts));
}

var optionsNormalizer = {
  normalizeApiOptions,
  normalizeCliOptions
};

var getLast = function getLast(arr) {
  return arr.length > 0 ? arr[arr.length - 1] : null;
};

function locStart$1(node, opts) {
  opts = opts || {}; // Handle nodes with decorators. They should start at the first decorator

  if (!opts.ignoreDecorators && node.declaration && node.declaration.decorators && node.declaration.decorators.length > 0) {
    return locStart$1(node.declaration.decorators[0]);
  }

  if (!opts.ignoreDecorators && node.decorators && node.decorators.length > 0) {
    return locStart$1(node.decorators[0]);
  }

  if (node.__location) {
    return node.__location.startOffset;
  }

  if (node.range) {
    return node.range[0];
  }

  if (typeof node.start === "number") {
    return node.start;
  }

  if (node.loc) {
    return node.loc.start;
  }

  return null;
}

function locEnd$1(node) {
  var endNode = node.nodes && getLast(node.nodes);

  if (endNode && node.source && !node.source.end) {
    node = endNode;
  }

  if (node.__location) {
    return node.__location.endOffset;
  }

  var loc = node.range ? node.range[1] : typeof node.end === "number" ? node.end : null;

  if (node.typeAnnotation) {
    return Math.max(loc, locEnd$1(node.typeAnnotation));
  }

  if (node.loc && !loc) {
    return node.loc.end;
  }

  return loc;
}

var loc = {
  locStart: locStart$1,
  locEnd: locEnd$1
};

var jsTokens = createCommonjsModule(function (module, exports) {
  // Copyright 2014, 2015, 2016, 2017, 2018 Simon Lydell
  // License: MIT. (See LICENSE.)
  Object.defineProperty(exports, "__esModule", {
    value: true
  }); // This regex comes from regex.coffee, and is inserted here by generate-index.js
  // (run `npm run build`).

  exports.default = /((['"])(?:(?!\2|\\).|\\(?:\r\n|[\s\S]))*(\2)?|`(?:[^`\\$]|\\[\s\S]|\$(?!\{)|\$\{(?:[^{}]|\{[^}]*\}?)*\}?)*(`)?)|(\/\/.*)|(\/\*(?:[^*]|\*(?!\/))*(\*\/)?)|(\/(?!\*)(?:\[(?:(?![\]\\]).|\\.)*\]|(?![\/\]\\]).|\\.)+\/(?:(?!\s*(?:\b|[\u0080-\uFFFF$\\'"~({]|[+\-!](?!=)|\.?\d))|[gmiyus]{1,6}\b(?![\u0080-\uFFFF$\\]|\s*(?:[+\-*%&|^<>!=?({]|\/(?![\/*])))))|(0[xX][\da-fA-F]+|0[oO][0-7]+|0[bB][01]+|(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?)|((?!\d)(?:(?!\s)[$\w\u0080-\uFFFF]|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]+\})+)|(--|\+\+|&&|\|\||=>|\.{3}|(?:[+\-\/%&|^]|\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2})=?|[?~.,:;[\](){}])|(\s+)|(^$|[\s\S])/g;

  exports.matchToToken = function (match) {
    var token = {
      type: "invalid",
      value: match[0],
      closed: undefined
    };
    if (match[1]) token.type = "string", token.closed = !!(match[3] || match[4]);else if (match[5]) token.type = "comment";else if (match[6]) token.type = "comment", token.closed = !!match[7];else if (match[8]) token.type = "regex";else if (match[9]) token.type = "number";else if (match[10]) token.type = "name";else if (match[11]) token.type = "punctuator";else if (match[12]) token.type = "whitespace";
    return token;
  };
});
unwrapExports(jsTokens);

var ast = createCommonjsModule(function (module) {
  /*
    Copyright (C) 2013 Yusuke Suzuki <utatane.tea@gmail.com>
  
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
  
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 'AS IS'
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
    DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
    ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  */
  (function () {
    'use strict';

    function isExpression(node) {
      if (node == null) {
        return false;
      }

      switch (node.type) {
        case 'ArrayExpression':
        case 'AssignmentExpression':
        case 'BinaryExpression':
        case 'CallExpression':
        case 'ConditionalExpression':
        case 'FunctionExpression':
        case 'Identifier':
        case 'Literal':
        case 'LogicalExpression':
        case 'MemberExpression':
        case 'NewExpression':
        case 'ObjectExpression':
        case 'SequenceExpression':
        case 'ThisExpression':
        case 'UnaryExpression':
        case 'UpdateExpression':
          return true;
      }

      return false;
    }

    function isIterationStatement(node) {
      if (node == null) {
        return false;
      }

      switch (node.type) {
        case 'DoWhileStatement':
        case 'ForInStatement':
        case 'ForStatement':
        case 'WhileStatement':
          return true;
      }

      return false;
    }

    function isStatement(node) {
      if (node == null) {
        return false;
      }

      switch (node.type) {
        case 'BlockStatement':
        case 'BreakStatement':
        case 'ContinueStatement':
        case 'DebuggerStatement':
        case 'DoWhileStatement':
        case 'EmptyStatement':
        case 'ExpressionStatement':
        case 'ForInStatement':
        case 'ForStatement':
        case 'IfStatement':
        case 'LabeledStatement':
        case 'ReturnStatement':
        case 'SwitchStatement':
        case 'ThrowStatement':
        case 'TryStatement':
        case 'VariableDeclaration':
        case 'WhileStatement':
        case 'WithStatement':
          return true;
      }

      return false;
    }

    function isSourceElement(node) {
      return isStatement(node) || node != null && node.type === 'FunctionDeclaration';
    }

    function trailingStatement(node) {
      switch (node.type) {
        case 'IfStatement':
          if (node.alternate != null) {
            return node.alternate;
          }

          return node.consequent;

        case 'LabeledStatement':
        case 'ForStatement':
        case 'ForInStatement':
        case 'WhileStatement':
        case 'WithStatement':
          return node.body;
      }

      return null;
    }

    function isProblematicIfStatement(node) {
      var current;

      if (node.type !== 'IfStatement') {
        return false;
      }

      if (node.alternate == null) {
        return false;
      }

      current = node.consequent;

      do {
        if (current.type === 'IfStatement') {
          if (current.alternate == null) {
            return true;
          }
        }

        current = trailingStatement(current);
      } while (current);

      return false;
    }

    module.exports = {
      isExpression: isExpression,
      isStatement: isStatement,
      isIterationStatement: isIterationStatement,
      isSourceElement: isSourceElement,
      isProblematicIfStatement: isProblematicIfStatement,
      trailingStatement: trailingStatement
    };
  })();
  /* vim: set sw=4 ts=4 et tw=80 : */

});

var code = createCommonjsModule(function (module) {
  /*
    Copyright (C) 2013-2014 Yusuke Suzuki <utatane.tea@gmail.com>
    Copyright (C) 2014 Ivan Nikulin <ifaaan@gmail.com>
  
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
  
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
    DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
    ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  */
  (function () {
    'use strict';

    var ES6Regex, ES5Regex, NON_ASCII_WHITESPACES, IDENTIFIER_START, IDENTIFIER_PART, ch; // See `tools/generate-identifier-regex.js`.

    ES5Regex = {
      // ECMAScript 5.1/Unicode v7.0.0 NonAsciiIdentifierStart:
      NonAsciiIdentifierStart: /[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B2\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]/,
      // ECMAScript 5.1/Unicode v7.0.0 NonAsciiIdentifierPart:
      NonAsciiIdentifierPart: /[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B2\u08E4-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58\u0C59\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D60-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19D9\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u2E2F\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099\u309A\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA69D\uA69F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2D\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]/
    };
    ES6Regex = {
      // ECMAScript 6/Unicode v7.0.0 NonAsciiIdentifierStart:
      NonAsciiIdentifierStart: /[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B2\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48]|\uD804[\uDC03-\uDC37\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDE00-\uDE11\uDE13-\uDE2B\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF5D-\uDF61]|\uD805[\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDE00-\uDE2F\uDE44\uDE80-\uDEAA]|\uD806[\uDCA0-\uDCDF\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF98]|\uD809[\uDC00-\uDC6E]|[\uD80C\uD840-\uD868\uD86A-\uD86C][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50\uDF93-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD83A[\uDC00-\uDCC4]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D]|\uD87E[\uDC00-\uDE1D]/,
      // ECMAScript 6/Unicode v7.0.0 NonAsciiIdentifierPart:
      NonAsciiIdentifierPart: /[\xAA\xB5\xB7\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B2\u08E4-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58\u0C59\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D60-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1369-\u1371\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA69D\uA69F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2D\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDDFD\uDE80-\uDE9C\uDEA0-\uDED0\uDEE0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF7A\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00-\uDE03\uDE05\uDE06\uDE0C-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE38-\uDE3A\uDE3F\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE6\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48]|\uD804[\uDC00-\uDC46\uDC66-\uDC6F\uDC7F-\uDCBA\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD00-\uDD34\uDD36-\uDD3F\uDD50-\uDD73\uDD76\uDD80-\uDDC4\uDDD0-\uDDDA\uDE00-\uDE11\uDE13-\uDE37\uDEB0-\uDEEA\uDEF0-\uDEF9\uDF01-\uDF03\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3C-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF57\uDF5D-\uDF63\uDF66-\uDF6C\uDF70-\uDF74]|\uD805[\uDC80-\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDB5\uDDB8-\uDDC0\uDE00-\uDE40\uDE44\uDE50-\uDE59\uDE80-\uDEB7\uDEC0-\uDEC9]|\uD806[\uDCA0-\uDCE9\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF98]|\uD809[\uDC00-\uDC6E]|[\uD80C\uD840-\uD868\uD86A-\uD86C][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDED0-\uDEED\uDEF0-\uDEF4\uDF00-\uDF36\uDF40-\uDF43\uDF50-\uDF59\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50-\uDF7E\uDF8F-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99\uDC9D\uDC9E]|\uD834[\uDD65-\uDD69\uDD6D-\uDD72\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD83A[\uDC00-\uDCC4\uDCD0-\uDCD6]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D]|\uD87E[\uDC00-\uDE1D]|\uDB40[\uDD00-\uDDEF]/
    };

    function isDecimalDigit(ch) {
      return 0x30 <= ch && ch <= 0x39; // 0..9
    }

    function isHexDigit(ch) {
      return 0x30 <= ch && ch <= 0x39 || // 0..9
      0x61 <= ch && ch <= 0x66 || // a..f
      0x41 <= ch && ch <= 0x46; // A..F
    }

    function isOctalDigit(ch) {
      return ch >= 0x30 && ch <= 0x37; // 0..7
    } // 7.2 White Space


    NON_ASCII_WHITESPACES = [0x1680, 0x180E, 0x2000, 0x2001, 0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009, 0x200A, 0x202F, 0x205F, 0x3000, 0xFEFF];

    function isWhiteSpace(ch) {
      return ch === 0x20 || ch === 0x09 || ch === 0x0B || ch === 0x0C || ch === 0xA0 || ch >= 0x1680 && NON_ASCII_WHITESPACES.indexOf(ch) >= 0;
    } // 7.3 Line Terminators


    function isLineTerminator(ch) {
      return ch === 0x0A || ch === 0x0D || ch === 0x2028 || ch === 0x2029;
    } // 7.6 Identifier Names and Identifiers


    function fromCodePoint(cp) {
      if (cp <= 0xFFFF) {
        return String.fromCharCode(cp);
      }

      var cu1 = String.fromCharCode(Math.floor((cp - 0x10000) / 0x400) + 0xD800);
      var cu2 = String.fromCharCode((cp - 0x10000) % 0x400 + 0xDC00);
      return cu1 + cu2;
    }

    IDENTIFIER_START = new Array(0x80);

    for (ch = 0; ch < 0x80; ++ch) {
      IDENTIFIER_START[ch] = ch >= 0x61 && ch <= 0x7A || // a..z
      ch >= 0x41 && ch <= 0x5A || // A..Z
      ch === 0x24 || ch === 0x5F; // $ (dollar) and _ (underscore)
    }

    IDENTIFIER_PART = new Array(0x80);

    for (ch = 0; ch < 0x80; ++ch) {
      IDENTIFIER_PART[ch] = ch >= 0x61 && ch <= 0x7A || // a..z
      ch >= 0x41 && ch <= 0x5A || // A..Z
      ch >= 0x30 && ch <= 0x39 || // 0..9
      ch === 0x24 || ch === 0x5F; // $ (dollar) and _ (underscore)
    }

    function isIdentifierStartES5(ch) {
      return ch < 0x80 ? IDENTIFIER_START[ch] : ES5Regex.NonAsciiIdentifierStart.test(fromCodePoint(ch));
    }

    function isIdentifierPartES5(ch) {
      return ch < 0x80 ? IDENTIFIER_PART[ch] : ES5Regex.NonAsciiIdentifierPart.test(fromCodePoint(ch));
    }

    function isIdentifierStartES6(ch) {
      return ch < 0x80 ? IDENTIFIER_START[ch] : ES6Regex.NonAsciiIdentifierStart.test(fromCodePoint(ch));
    }

    function isIdentifierPartES6(ch) {
      return ch < 0x80 ? IDENTIFIER_PART[ch] : ES6Regex.NonAsciiIdentifierPart.test(fromCodePoint(ch));
    }

    module.exports = {
      isDecimalDigit: isDecimalDigit,
      isHexDigit: isHexDigit,
      isOctalDigit: isOctalDigit,
      isWhiteSpace: isWhiteSpace,
      isLineTerminator: isLineTerminator,
      isIdentifierStartES5: isIdentifierStartES5,
      isIdentifierPartES5: isIdentifierPartES5,
      isIdentifierStartES6: isIdentifierStartES6,
      isIdentifierPartES6: isIdentifierPartES6
    };
  })();
  /* vim: set sw=4 ts=4 et tw=80 : */

});

var keyword = createCommonjsModule(function (module) {
  /*
    Copyright (C) 2013 Yusuke Suzuki <utatane.tea@gmail.com>
  
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
  
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
    DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
    ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  */
  (function () {
    'use strict';

    var code$$1 = code;

    function isStrictModeReservedWordES6(id) {
      switch (id) {
        case 'implements':
        case 'interface':
        case 'package':
        case 'private':
        case 'protected':
        case 'public':
        case 'static':
        case 'let':
          return true;

        default:
          return false;
      }
    }

    function isKeywordES5(id, strict) {
      // yield should not be treated as keyword under non-strict mode.
      if (!strict && id === 'yield') {
        return false;
      }

      return isKeywordES6(id, strict);
    }

    function isKeywordES6(id, strict) {
      if (strict && isStrictModeReservedWordES6(id)) {
        return true;
      }

      switch (id.length) {
        case 2:
          return id === 'if' || id === 'in' || id === 'do';

        case 3:
          return id === 'var' || id === 'for' || id === 'new' || id === 'try';

        case 4:
          return id === 'this' || id === 'else' || id === 'case' || id === 'void' || id === 'with' || id === 'enum';

        case 5:
          return id === 'while' || id === 'break' || id === 'catch' || id === 'throw' || id === 'const' || id === 'yield' || id === 'class' || id === 'super';

        case 6:
          return id === 'return' || id === 'typeof' || id === 'delete' || id === 'switch' || id === 'export' || id === 'import';

        case 7:
          return id === 'default' || id === 'finally' || id === 'extends';

        case 8:
          return id === 'function' || id === 'continue' || id === 'debugger';

        case 10:
          return id === 'instanceof';

        default:
          return false;
      }
    }

    function isReservedWordES5(id, strict) {
      return id === 'null' || id === 'true' || id === 'false' || isKeywordES5(id, strict);
    }

    function isReservedWordES6(id, strict) {
      return id === 'null' || id === 'true' || id === 'false' || isKeywordES6(id, strict);
    }

    function isRestrictedWord(id) {
      return id === 'eval' || id === 'arguments';
    }

    function isIdentifierNameES5(id) {
      var i, iz, ch;

      if (id.length === 0) {
        return false;
      }

      ch = id.charCodeAt(0);

      if (!code$$1.isIdentifierStartES5(ch)) {
        return false;
      }

      for (i = 1, iz = id.length; i < iz; ++i) {
        ch = id.charCodeAt(i);

        if (!code$$1.isIdentifierPartES5(ch)) {
          return false;
        }
      }

      return true;
    }

    function decodeUtf16(lead, trail) {
      return (lead - 0xD800) * 0x400 + (trail - 0xDC00) + 0x10000;
    }

    function isIdentifierNameES6(id) {
      var i, iz, ch, lowCh, check;

      if (id.length === 0) {
        return false;
      }

      check = code$$1.isIdentifierStartES6;

      for (i = 0, iz = id.length; i < iz; ++i) {
        ch = id.charCodeAt(i);

        if (0xD800 <= ch && ch <= 0xDBFF) {
          ++i;

          if (i >= iz) {
            return false;
          }

          lowCh = id.charCodeAt(i);

          if (!(0xDC00 <= lowCh && lowCh <= 0xDFFF)) {
            return false;
          }

          ch = decodeUtf16(ch, lowCh);
        }

        if (!check(ch)) {
          return false;
        }

        check = code$$1.isIdentifierPartES6;
      }

      return true;
    }

    function isIdentifierES5(id, strict) {
      return isIdentifierNameES5(id) && !isReservedWordES5(id, strict);
    }

    function isIdentifierES6(id, strict) {
      return isIdentifierNameES6(id) && !isReservedWordES6(id, strict);
    }

    module.exports = {
      isKeywordES5: isKeywordES5,
      isKeywordES6: isKeywordES6,
      isReservedWordES5: isReservedWordES5,
      isReservedWordES6: isReservedWordES6,
      isRestrictedWord: isRestrictedWord,
      isIdentifierNameES5: isIdentifierNameES5,
      isIdentifierNameES6: isIdentifierNameES6,
      isIdentifierES5: isIdentifierES5,
      isIdentifierES6: isIdentifierES6
    };
  })();
  /* vim: set sw=4 ts=4 et tw=80 : */

});

var utils$2 = createCommonjsModule(function (module, exports) {
  /*
    Copyright (C) 2013 Yusuke Suzuki <utatane.tea@gmail.com>
  
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
  
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
    DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
    ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  */
  (function () {
    'use strict';

    exports.ast = ast;
    exports.code = code;
    exports.keyword = keyword;
  })();
  /* vim: set sw=4 ts=4 et tw=80 : */

});

var hasFlag$6 = createCommonjsModule(function (module) {
  'use strict';

  module.exports = function (flag, argv) {
    argv = argv || process.argv;
    var prefix = flag.startsWith('-') ? '' : flag.length === 1 ? '-' : '--';
    var pos = argv.indexOf(prefix + flag);
    var terminatorPos = argv.indexOf('--');
    return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
  };
});

var env$1 = process.env;
var forceColor$1;

if (hasFlag$6('no-color') || hasFlag$6('no-colors') || hasFlag$6('color=false')) {
  forceColor$1 = false;
} else if (hasFlag$6('color') || hasFlag$6('colors') || hasFlag$6('color=true') || hasFlag$6('color=always')) {
  forceColor$1 = true;
}

if ('FORCE_COLOR' in env$1) {
  forceColor$1 = env$1.FORCE_COLOR.length === 0 || parseInt(env$1.FORCE_COLOR, 10) !== 0;
}

function translateLevel$1(level) {
  if (level === 0) {
    return false;
  }

  return {
    level,
    hasBasic: true,
    has256: level >= 2,
    has16m: level >= 3
  };
}

function supportsColor$4(stream) {
  if (forceColor$1 === false) {
    return 0;
  }

  if (hasFlag$6('color=16m') || hasFlag$6('color=full') || hasFlag$6('color=truecolor')) {
    return 3;
  }

  if (hasFlag$6('color=256')) {
    return 2;
  }

  if (stream && !stream.isTTY && forceColor$1 !== true) {
    return 0;
  }

  var min = forceColor$1 ? 1 : 0;

  if (process.platform === 'win32') {
    // Node.js 7.5.0 is the first version of Node.js to include a patch to
    // libuv that enables 256 color output on Windows. Anything earlier and it
    // won't work. However, here we target Node.js 8 at minimum as it is an LTS
    // release, and Node.js 7 is not. Windows 10 build 10586 is the first Windows
    // release that supports 256 colors. Windows 10 build 14931 is the first release
    // that supports 16m/TrueColor.
    var osRelease = os.release().split('.');

    if (Number(process.versions.node.split('.')[0]) >= 8 && Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
      return Number(osRelease[2]) >= 14931 ? 3 : 2;
    }

    return 1;
  }

  if ('CI' in env$1) {
    if (['TRAVIS', 'CIRCLECI', 'APPVEYOR', 'GITLAB_CI'].some(function (sign) {
      return sign in env$1;
    }) || env$1.CI_NAME === 'codeship') {
      return 1;
    }

    return min;
  }

  if ('TEAMCITY_VERSION' in env$1) {
    return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env$1.TEAMCITY_VERSION) ? 1 : 0;
  }

  if (env$1.COLORTERM === 'truecolor') {
    return 3;
  }

  if ('TERM_PROGRAM' in env$1) {
    var version = parseInt((env$1.TERM_PROGRAM_VERSION || '').split('.')[0], 10);

    switch (env$1.TERM_PROGRAM) {
      case 'iTerm.app':
        return version >= 3 ? 3 : 2;

      case 'Apple_Terminal':
        return 2;
      // No default
    }
  }

  if (/-256(color)?$/i.test(env$1.TERM)) {
    return 2;
  }

  if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env$1.TERM)) {
    return 1;
  }

  if ('COLORTERM' in env$1) {
    return 1;
  }

  if (env$1.TERM === 'dumb') {
    return min;
  }

  return min;
}

function getSupportLevel$1(stream) {
  var level = supportsColor$4(stream);
  return translateLevel$1(level);
}

var supportsColor_1$3 = {
  supportsColor: getSupportLevel$1,
  stdout: getSupportLevel$1(process.stdout),
  stderr: getSupportLevel$1(process.stderr)
};

var templates$4 = createCommonjsModule(function (module) {
  'use strict';

  var TEMPLATE_REGEX = /(?:\\(u[a-f\d]{4}|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
  var STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
  var STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
  var ESCAPE_REGEX = /\\(u[a-f\d]{4}|x[a-f\d]{2}|.)|([^\\])/gi;
  var ESCAPES = new Map([['n', '\n'], ['r', '\r'], ['t', '\t'], ['b', '\b'], ['f', '\f'], ['v', '\v'], ['0', '\0'], ['\\', '\\'], ['e', '\u001B'], ['a', '\u0007']]);

  function unescape(c) {
    if (c[0] === 'u' && c.length === 5 || c[0] === 'x' && c.length === 3) {
      return String.fromCharCode(parseInt(c.slice(1), 16));
    }

    return ESCAPES.get(c) || c;
  }

  function parseArguments(name, args) {
    var results = [];
    var chunks = args.trim().split(/\s*,\s*/g);
    var matches;
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = chunks[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var chunk = _step.value;

        if (!isNaN(chunk)) {
          results.push(Number(chunk));
        } else if (matches = chunk.match(STRING_REGEX)) {
          results.push(matches[2].replace(ESCAPE_REGEX, function (m, escape, chr) {
            return escape ? unescape(escape) : chr;
          }));
        } else {
          throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return results;
  }

  function parseStyle(style) {
    STYLE_REGEX.lastIndex = 0;
    var results = [];
    var matches;

    while ((matches = STYLE_REGEX.exec(style)) !== null) {
      var name = matches[1];

      if (matches[2]) {
        var args = parseArguments(name, matches[2]);
        results.push([name].concat(args));
      } else {
        results.push([name]);
      }
    }

    return results;
  }

  function buildStyle(chalk, styles) {
    var enabled = {};
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
      for (var _iterator2 = styles[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
        var layer = _step2.value;
        var _iteratorNormalCompletion3 = true;
        var _didIteratorError3 = false;
        var _iteratorError3 = undefined;

        try {
          for (var _iterator3 = layer.styles[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
            var style = _step3.value;
            enabled[style[0]] = layer.inverse ? null : style.slice(1);
          }
        } catch (err) {
          _didIteratorError3 = true;
          _iteratorError3 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
              _iterator3.return();
            }
          } finally {
            if (_didIteratorError3) {
              throw _iteratorError3;
            }
          }
        }
      }
    } catch (err) {
      _didIteratorError2 = true;
      _iteratorError2 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
          _iterator2.return();
        }
      } finally {
        if (_didIteratorError2) {
          throw _iteratorError2;
        }
      }
    }

    var current = chalk;

    var _arr = Object.keys(enabled);

    for (var _i = 0; _i < _arr.length; _i++) {
      var styleName = _arr[_i];

      if (Array.isArray(enabled[styleName])) {
        if (!(styleName in current)) {
          throw new Error(`Unknown Chalk style: ${styleName}`);
        }

        if (enabled[styleName].length > 0) {
          current = current[styleName].apply(current, enabled[styleName]);
        } else {
          current = current[styleName];
        }
      }
    }

    return current;
  }

  module.exports = function (chalk, tmp) {
    var styles = [];
    var chunks = [];
    var chunk = []; // eslint-disable-next-line max-params

    tmp.replace(TEMPLATE_REGEX, function (m, escapeChar, inverse, style, close, chr) {
      if (escapeChar) {
        chunk.push(unescape(escapeChar));
      } else if (style) {
        var str = chunk.join('');
        chunk = [];
        chunks.push(styles.length === 0 ? str : buildStyle(chalk, styles)(str));
        styles.push({
          inverse,
          styles: parseStyle(style)
        });
      } else if (close) {
        if (styles.length === 0) {
          throw new Error('Found extraneous } in Chalk template literal');
        }

        chunks.push(buildStyle(chalk, styles)(chunk.join('')));
        chunk = [];
        styles.pop();
      } else {
        chunk.push(chr);
      }
    });
    chunks.push(chunk.join(''));

    if (styles.length > 0) {
      var errMsg = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? '' : 's'} (\`}\`)`;
      throw new Error(errMsg);
    }

    return chunks.join('');
  };
});

var chalk$5 = createCommonjsModule(function (module) {
  'use strict';

  var stdoutColor = supportsColor_1$3.stdout;
  var isSimpleWindowsTerm = process.platform === 'win32' && !(process.env.TERM || '').toLowerCase().startsWith('xterm'); // `supportsColor.level` → `ansiStyles.color[name]` mapping

  var levelMapping = ['ansi', 'ansi', 'ansi256', 'ansi16m']; // `color-convert` models to exclude from the Chalk API due to conflicts and such

  var skipModels = new Set(['gray']);
  var styles = Object.create(null);

  function applyOptions(obj, options) {
    options = options || {}; // Detect level if not set manually

    var scLevel = stdoutColor ? stdoutColor.level : 0;
    obj.level = options.level === undefined ? scLevel : options.level;
    obj.enabled = 'enabled' in options ? options.enabled : obj.level > 0;
  }

  function Chalk(options) {
    // We check for this.template here since calling `chalk.constructor()`
    // by itself will have a `this` of a previously constructed chalk object
    if (!this || !(this instanceof Chalk) || this.template) {
      var _chalk = {};
      applyOptions(_chalk, options);

      _chalk.template = function () {
        var args = [].slice.call(arguments);
        return chalkTag.apply(null, [_chalk.template].concat(args));
      };

      Object.setPrototypeOf(_chalk, Chalk.prototype);
      Object.setPrototypeOf(_chalk.template, _chalk);
      _chalk.template.constructor = Chalk;
      return _chalk.template;
    }

    applyOptions(this, options);
  } // Use bright blue on Windows as the normal blue color is illegible


  if (isSimpleWindowsTerm) {
    ansiStyles.blue.open = '\u001B[94m';
  }

  var _arr = Object.keys(ansiStyles);

  var _loop = function _loop() {
    var key = _arr[_i];
    ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), 'g');
    styles[key] = {
      get() {
        var codes = ansiStyles[key];
        return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, key);
      }

    };
  };

  for (var _i = 0; _i < _arr.length; _i++) {
    _loop();
  }

  styles.visible = {
    get() {
      return build.call(this, this._styles || [], true, 'visible');
    }

  };
  ansiStyles.color.closeRe = new RegExp(escapeStringRegexp(ansiStyles.color.close), 'g');

  var _arr2 = Object.keys(ansiStyles.color.ansi);

  var _loop2 = function _loop2() {
    var model = _arr2[_i2];

    if (skipModels.has(model)) {
      return "continue";
    }

    styles[model] = {
      get() {
        var level = this.level;
        return function () {
          var open = ansiStyles.color[levelMapping[level]][model].apply(null, arguments);
          var codes = {
            open,
            close: ansiStyles.color.close,
            closeRe: ansiStyles.color.closeRe
          };
          return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
        };
      }

    };
  };

  for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
    var _ret = _loop2();

    if (_ret === "continue") continue;
  }

  ansiStyles.bgColor.closeRe = new RegExp(escapeStringRegexp(ansiStyles.bgColor.close), 'g');

  var _arr3 = Object.keys(ansiStyles.bgColor.ansi);

  var _loop3 = function _loop3() {
    var model = _arr3[_i3];

    if (skipModels.has(model)) {
      return "continue";
    }

    var bgModel = 'bg' + model[0].toUpperCase() + model.slice(1);
    styles[bgModel] = {
      get() {
        var level = this.level;
        return function () {
          var open = ansiStyles.bgColor[levelMapping[level]][model].apply(null, arguments);
          var codes = {
            open,
            close: ansiStyles.bgColor.close,
            closeRe: ansiStyles.bgColor.closeRe
          };
          return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
        };
      }

    };
  };

  for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
    var _ret2 = _loop3();

    if (_ret2 === "continue") continue;
  }

  var proto = Object.defineProperties(function () {}, styles);

  function build(_styles, _empty, key) {
    var builder = function builder() {
      return applyStyle.apply(builder, arguments);
    };

    builder._styles = _styles;
    builder._empty = _empty;
    var self = this;
    Object.defineProperty(builder, 'level', {
      enumerable: true,

      get() {
        return self.level;
      },

      set(level) {
        self.level = level;
      }

    });
    Object.defineProperty(builder, 'enabled', {
      enumerable: true,

      get() {
        return self.enabled;
      },

      set(enabled) {
        self.enabled = enabled;
      }

    }); // See below for fix regarding invisible grey/dim combination on Windows

    builder.hasGrey = this.hasGrey || key === 'gray' || key === 'grey'; // `__proto__` is used because we must return a function, but there is
    // no way to create a function with a different prototype

    builder.__proto__ = proto; // eslint-disable-line no-proto

    return builder;
  }

  function applyStyle() {
    // Support varags, but simply cast to string in case there's only one arg
    var args = arguments;
    var argsLen = args.length;
    var str = String(arguments[0]);

    if (argsLen === 0) {
      return '';
    }

    if (argsLen > 1) {
      // Don't slice `arguments`, it prevents V8 optimizations
      for (var a = 1; a < argsLen; a++) {
        str += ' ' + args[a];
      }
    }

    if (!this.enabled || this.level <= 0 || !str) {
      return this._empty ? '' : str;
    } // Turns out that on Windows dimmed gray text becomes invisible in cmd.exe,
    // see https://github.com/chalk/chalk/issues/58
    // If we're on Windows and we're dealing with a gray color, temporarily make 'dim' a noop.


    var originalDim = ansiStyles.dim.open;

    if (isSimpleWindowsTerm && this.hasGrey) {
      ansiStyles.dim.open = '';
    }

    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = this._styles.slice().reverse()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var code = _step.value;
        // Replace any instances already present with a re-opening code
        // otherwise only the part of the string until said closing code
        // will be colored, and the rest will simply be 'plain'.
        str = code.open + str.replace(code.closeRe, code.open) + code.close; // Close the styling before a linebreak and reopen
        // after next line to fix a bleed issue on macOS
        // https://github.com/chalk/chalk/pull/92

        str = str.replace(/\r?\n/g, `${code.close}$&${code.open}`);
      } // Reset the original `dim` if we changed it to work around the Windows dimmed gray issue

    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    ansiStyles.dim.open = originalDim;
    return str;
  }

  function chalkTag(chalk, strings) {
    if (!Array.isArray(strings)) {
      // If chalk() was called by itself or with a string,
      // return the string itself as a string.
      return [].slice.call(arguments, 1).join(' ');
    }

    var args = [].slice.call(arguments, 2);
    var parts = [strings.raw[0]];

    for (var i = 1; i < strings.length; i++) {
      parts.push(String(args[i - 1]).replace(/[{}\\]/g, '\\$&'));
      parts.push(String(strings.raw[i]));
    }

    return templates$4(chalk, parts.join(''));
  }

  Object.defineProperties(Chalk.prototype, styles);
  module.exports = Chalk(); // eslint-disable-line new-cap

  module.exports.supportsColor = stdoutColor;
  module.exports.default = module.exports; // For TypeScript
});

var lib$3 = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.shouldHighlight = shouldHighlight;
  exports.getChalk = getChalk;
  exports.default = highlight;

  function _jsTokens() {
    var data = _interopRequireWildcard$$1(jsTokens);

    _jsTokens = function _jsTokens() {
      return data;
    };

    return data;
  }

  function _esutils() {
    var data = _interopRequireDefault$$1(utils$2);

    _esutils = function _esutils() {
      return data;
    };

    return data;
  }

  function _chalk() {
    var data = _interopRequireDefault$$1(chalk$5);

    _chalk = function _chalk() {
      return data;
    };

    return data;
  }

  function _interopRequireDefault$$1(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _interopRequireWildcard$$1(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function getDefs(chalk) {
    return {
      keyword: chalk.cyan,
      capitalized: chalk.yellow,
      jsx_tag: chalk.yellow,
      punctuator: chalk.yellow,
      number: chalk.magenta,
      string: chalk.green,
      regex: chalk.magenta,
      comment: chalk.grey,
      invalid: chalk.white.bgRed.bold
    };
  }

  var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
  var JSX_TAG = /^[a-z][\w-]*$/i;
  var BRACKET = /^[()[\]{}]$/;

  function getTokenType(match) {
    var _match$slice = match.slice(-2),
        _match$slice2 = _slicedToArray(_match$slice, 2),
        offset = _match$slice2[0],
        text = _match$slice2[1];

    var token = (0, _jsTokens().matchToToken)(match);

    if (token.type === "name") {
      if (_esutils().default.keyword.isReservedWordES6(token.value)) {
        return "keyword";
      }

      if (JSX_TAG.test(token.value) && (text[offset - 1] === "<" || text.substr(offset - 2, 2) == "</")) {
        return "jsx_tag";
      }

      if (token.value[0] !== token.value[0].toLowerCase()) {
        return "capitalized";
      }
    }

    if (token.type === "punctuator" && BRACKET.test(token.value)) {
      return "bracket";
    }

    if (token.type === "invalid" && (token.value === "@" || token.value === "#")) {
      return "punctuator";
    }

    return token.type;
  }

  function highlightTokens(defs, text) {
    return text.replace(_jsTokens().default, function () {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var type = getTokenType(args);
      var colorize = defs[type];

      if (colorize) {
        return args[0].split(NEWLINE).map(function (str) {
          return colorize(str);
        }).join("\n");
      } else {
        return args[0];
      }
    });
  }

  function shouldHighlight(options) {
    return _chalk().default.supportsColor || options.forceColor;
  }

  function getChalk(options) {
    var chalk = _chalk().default;

    if (options.forceColor) {
      chalk = new (_chalk().default.constructor)({
        enabled: true,
        level: 1
      });
    }

    return chalk;
  }

  function highlight(code) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (shouldHighlight(options)) {
      var chalk = getChalk(options);
      var defs = getDefs(chalk);
      return highlightTokens(defs, code);
    } else {
      return code;
    }
  }
});
unwrapExports(lib$3);

var lib$2 = createCommonjsModule(function (module, exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.codeFrameColumns = codeFrameColumns;
  exports.default = _default;

  function _highlight() {
    var data = _interopRequireWildcard(lib$3);

    _highlight = function _highlight() {
      return data;
    };

    return data;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  var deprecationWarningShown = false;

  function getDefs(chalk) {
    return {
      gutter: chalk.grey,
      marker: chalk.red.bold,
      message: chalk.red.bold
    };
  }

  var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;

  function getMarkerLines(loc, source, opts) {
    var startLoc = Object.assign({
      column: 0,
      line: -1
    }, loc.start);
    var endLoc = Object.assign({}, startLoc, loc.end);

    var _ref = opts || {},
        _ref$linesAbove = _ref.linesAbove,
        linesAbove = _ref$linesAbove === void 0 ? 2 : _ref$linesAbove,
        _ref$linesBelow = _ref.linesBelow,
        linesBelow = _ref$linesBelow === void 0 ? 3 : _ref$linesBelow;

    var startLine = startLoc.line;
    var startColumn = startLoc.column;
    var endLine = endLoc.line;
    var endColumn = endLoc.column;
    var start = Math.max(startLine - (linesAbove + 1), 0);
    var end = Math.min(source.length, endLine + linesBelow);

    if (startLine === -1) {
      start = 0;
    }

    if (endLine === -1) {
      end = source.length;
    }

    var lineDiff = endLine - startLine;
    var markerLines = {};

    if (lineDiff) {
      for (var i = 0; i <= lineDiff; i++) {
        var lineNumber = i + startLine;

        if (!startColumn) {
          markerLines[lineNumber] = true;
        } else if (i === 0) {
          var sourceLength = source[lineNumber - 1].length;
          markerLines[lineNumber] = [startColumn, sourceLength - startColumn];
        } else if (i === lineDiff) {
          markerLines[lineNumber] = [0, endColumn];
        } else {
          var _sourceLength = source[lineNumber - i].length;
          markerLines[lineNumber] = [0, _sourceLength];
        }
      }
    } else {
      if (startColumn === endColumn) {
        if (startColumn) {
          markerLines[startLine] = [startColumn, 0];
        } else {
          markerLines[startLine] = true;
        }
      } else {
        markerLines[startLine] = [startColumn, endColumn - startColumn];
      }
    }

    return {
      start,
      end,
      markerLines
    };
  }

  function codeFrameColumns(rawLines, loc) {
    var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var highlighted = (opts.highlightCode || opts.forceColor) && (0, _highlight().shouldHighlight)(opts);
    var chalk = (0, _highlight().getChalk)(opts);
    var defs = getDefs(chalk);

    var maybeHighlight = function maybeHighlight(chalkFn, string) {
      return highlighted ? chalkFn(string) : string;
    };

    if (highlighted) rawLines = (0, _highlight().default)(rawLines, opts);
    var lines = rawLines.split(NEWLINE);

    var _getMarkerLines = getMarkerLines(loc, lines, opts),
        start = _getMarkerLines.start,
        end = _getMarkerLines.end,
        markerLines = _getMarkerLines.markerLines;

    var hasColumns = loc.start && typeof loc.start.column === "number";
    var numberMaxWidth = String(end).length;
    var frame = lines.slice(start, end).map(function (line, index) {
      var number = start + 1 + index;
      var paddedNumber = ` ${number}`.slice(-numberMaxWidth);
      var gutter = ` ${paddedNumber} | `;
      var hasMarker = markerLines[number];
      var lastMarkerLine = !markerLines[number + 1];

      if (hasMarker) {
        var markerLine = "";

        if (Array.isArray(hasMarker)) {
          var markerSpacing = line.slice(0, Math.max(hasMarker[0] - 1, 0)).replace(/[^\t]/g, " ");
          var numberOfMarkers = hasMarker[1] || 1;
          markerLine = ["\n ", maybeHighlight(defs.gutter, gutter.replace(/\d/g, " ")), markerSpacing, maybeHighlight(defs.marker, "^").repeat(numberOfMarkers)].join("");

          if (lastMarkerLine && opts.message) {
            markerLine += " " + maybeHighlight(defs.message, opts.message);
          }
        }

        return [maybeHighlight(defs.marker, ">"), maybeHighlight(defs.gutter, gutter), line, markerLine].join("");
      } else {
        return ` ${maybeHighlight(defs.gutter, gutter)}${line}`;
      }
    }).join("\n");

    if (opts.message && !hasColumns) {
      frame = `${" ".repeat(numberMaxWidth + 1)}${opts.message}\n${frame}`;
    }

    if (highlighted) {
      return chalk.reset(frame);
    } else {
      return frame;
    }
  }

  function _default(rawLines, lineNumber, colNumber) {
    var opts = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

    if (!deprecationWarningShown) {
      deprecationWarningShown = true;
      var message = "Passing lineNumber and colNumber is deprecated to @babel/code-frame. Please use `codeFrameColumns`.";

      if (process.emitWarning) {
        process.emitWarning(message, "DeprecationWarning");
      } else {
        var deprecationError = new Error(message);
        deprecationError.name = "DeprecationWarning";
        console.warn(new Error(message));
      }
    }

    colNumber = Math.max(colNumber, 0);
    var location = {
      start: {
        column: colNumber,
        line: lineNumber
      }
    };
    return codeFrameColumns(rawLines, location, opts);
  }
});
unwrapExports(lib$2);

var ConfigError$1 = errors.ConfigError;
var locStart = loc.locStart;
var locEnd = loc.locEnd; // Use defineProperties()/getOwnPropertyDescriptor() to prevent
// triggering the parsers getters.

var ownNames = Object.getOwnPropertyNames;
var ownDescriptor = Object.getOwnPropertyDescriptor;

function getParsers(options) {
  var parsers = {};
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = options.plugins[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var plugin = _step.value;

      if (!plugin.parsers) {
        continue;
      }

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = ownNames(plugin.parsers)[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var name = _step2.value;
          Object.defineProperty(parsers, name, ownDescriptor(plugin.parsers, name));
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return parsers;
}

function resolveParser$1(opts, parsers) {
  parsers = parsers || getParsers(opts);

  if (typeof opts.parser === "function") {
    // Custom parser API always works with JavaScript.
    return {
      parse: opts.parser,
      astFormat: "estree",
      locStart,
      locEnd
    };
  }

  if (typeof opts.parser === "string") {
    if (parsers.hasOwnProperty(opts.parser)) {
      return parsers[opts.parser];
    }
    /* istanbul ignore next */


    {
      try {
        return {
          parse: require(path.resolve(process.cwd(), opts.parser)),
          astFormat: "estree",
          locStart,
          locEnd
        };
      } catch (err) {
        /* istanbul ignore next */
        throw new ConfigError$1(`Couldn't resolve parser "${opts.parser}"`);
      }
    }
  }
}

function parse$2(text, opts) {
  var parsers = getParsers(opts); // Create a new object {parserName: parseFn}. Uses defineProperty() to only call
  // the parsers getters when actually calling the parser `parse` function.

  var parsersForCustomParserApi = Object.keys(parsers).reduce(function (object, parserName) {
    return Object.defineProperty(object, parserName, {
      enumerable: true,

      get() {
        return parsers[parserName].parse;
      }

    });
  }, {});
  var parser = resolveParser$1(opts, parsers);

  try {
    if (parser.preprocess) {
      text = parser.preprocess(text, opts);
    }

    return {
      text,
      ast: parser.parse(text, parsersForCustomParserApi, opts)
    };
  } catch (error) {
    var loc$$1 = error.loc;

    if (loc$$1) {
      var codeFrame = lib$2;
      error.codeFrame = codeFrame.codeFrameColumns(text, loc$$1, {
        highlightCode: true
      });
      error.message += "\n" + error.codeFrame;
      throw error;
    }
    /* istanbul ignore next */


    throw error.stack;
  }
}

var parser = {
  parse: parse$2,
  resolveParser: resolveParser$1
};

var UndefinedParserError = errors.UndefinedParserError;
var getSupportInfo$1 = support.getSupportInfo;
var resolveParser = parser.resolveParser;
var hiddenDefaults = {
  astFormat: "estree",
  printer: {},
  originalText: undefined,
  locStart: null,
  locEnd: null
}; // Copy options and fill in default values.

function normalize(options, opts) {
  opts = opts || {};
  var rawOptions = Object.assign({}, options);
  var supportOptions = getSupportInfo$1(null, {
    plugins: options.plugins,
    showUnreleased: true,
    showDeprecated: true
  }).options;
  var defaults = supportOptions.reduce(function (reduced, optionInfo) {
    return optionInfo.default !== undefined ? Object.assign(reduced, {
      [optionInfo.name]: optionInfo.default
    }) : reduced;
  }, Object.assign({}, hiddenDefaults));

  if (!rawOptions.parser) {
    if (!rawOptions.filepath) {
      var logger = opts.logger || console;
      logger.warn("No parser and no filepath given, using 'babel' the parser now " + "but this will throw an error in the future. " + "Please specify a parser or a filepath so one can be inferred.");
      rawOptions.parser = "babel";
    } else {
      rawOptions.parser = inferParser(rawOptions.filepath, rawOptions.plugins);

      if (!rawOptions.parser) {
        throw new UndefinedParserError(`No parser could be inferred for file: ${rawOptions.filepath}`);
      }
    }
  }

  var parser$$1 = resolveParser(optionsNormalizer.normalizeApiOptions(rawOptions, [supportOptions.find(function (x) {
    return x.name === "parser";
  })], {
    passThrough: true,
    logger: false
  }));
  rawOptions.astFormat = parser$$1.astFormat;
  rawOptions.locEnd = parser$$1.locEnd;
  rawOptions.locStart = parser$$1.locStart;
  var plugin = getPlugin(rawOptions);
  rawOptions.printer = plugin.printers[rawOptions.astFormat];
  var pluginDefaults = supportOptions.filter(function (optionInfo) {
    return optionInfo.pluginDefaults && optionInfo.pluginDefaults[plugin.name];
  }).reduce(function (reduced, optionInfo) {
    return Object.assign(reduced, {
      [optionInfo.name]: optionInfo.pluginDefaults[plugin.name]
    });
  }, {});
  var mixedDefaults = Object.assign({}, defaults, pluginDefaults);
  Object.keys(mixedDefaults).forEach(function (k) {
    if (rawOptions[k] == null) {
      rawOptions[k] = mixedDefaults[k];
    }
  });

  if (rawOptions.parser === "json") {
    rawOptions.trailingComma = "none";
  }

  return optionsNormalizer.normalizeApiOptions(rawOptions, supportOptions, Object.assign({
    passThrough: Object.keys(hiddenDefaults)
  }, opts));
}

function getPlugin(options) {
  var astFormat = options.astFormat;

  if (!astFormat) {
    throw new Error("getPlugin() requires astFormat to be set");
  }

  var printerPlugin = options.plugins.find(function (plugin) {
    return plugin.printers && plugin.printers[astFormat];
  });

  if (!printerPlugin) {
    throw new Error(`Couldn't find plugin for AST format "${astFormat}"`);
  }

  return printerPlugin;
}

function getInterpreter(filepath) {
  if (typeof filepath !== "string") {
    return "";
  }

  var fd;

  try {
    fd = fs.openSync(filepath, "r");
  } catch (err) {
    return "";
  }

  try {
    var liner = new readlines(fd);
    var firstLine = liner.next().toString("utf8"); // #!/bin/env node, #!/usr/bin/env node

    var m1 = firstLine.match(/^#!\/(?:usr\/)?bin\/env\s+(\S+)/);

    if (m1) {
      return m1[1];
    } // #!/bin/node, #!/usr/bin/node, #!/usr/local/bin/node


    var m2 = firstLine.match(/^#!\/(?:usr\/(?:local\/)?)?bin\/(\S+)/);

    if (m2) {
      return m2[1];
    }

    return "";
  } catch (err) {
    // There are some weird cases where paths are missing, causing Jest
    // failures. It's unclear what these correspond to in the real world.
    return "";
  } finally {
    try {
      // There are some weird cases where paths are missing, causing Jest
      // failures. It's unclear what these correspond to in the real world.
      fs.closeSync(fd);
    } catch (err) {// nop
    }
  }
}

function inferParser(filepath, plugins) {
  var filepathParts = normalizePath(filepath).split("/");
  var filename = filepathParts[filepathParts.length - 1].toLowerCase(); // If the file has no extension, we can try to infer the language from the
  // interpreter in the shebang line, if any; but since this requires FS access,
  // do it last.

  var language = getSupportInfo$1(null, {
    plugins
  }).languages.find(function (language) {
    return language.since !== null && (language.extensions && language.extensions.some(function (extension) {
      return filename.endsWith(extension);
    }) || language.filenames && language.filenames.find(function (name) {
      return name.toLowerCase() === filename;
    }) || filename.indexOf(".") === -1 && language.interpreters && language.interpreters.indexOf(getInterpreter(filepath)) !== -1);
  });
  return language && language.parsers[0];
}

var options = {
  normalize,
  hiddenDefaults,
  inferParser
};

function massageAST(ast, options, parent) {
  if (Array.isArray(ast)) {
    return ast.map(function (e) {
      return massageAST(e, options, parent);
    }).filter(function (e) {
      return e;
    });
  }

  if (!ast || typeof ast !== "object") {
    return ast;
  }

  var newObj = {};

  var _arr = Object.keys(ast);

  for (var _i = 0; _i < _arr.length; _i++) {
    var key = _arr[_i];

    if (typeof ast[key] !== "function") {
      newObj[key] = massageAST(ast[key], options, ast);
    }
  }

  if (options.printer.massageAstNode) {
    var result = options.printer.massageAstNode(ast, newObj, parent);

    if (result === null) {
      return undefined;
    }

    if (result) {
      return result;
    }
  }

  return newObj;
}

var massageAst = massageAST;

function concat$1(parts) {
  return {
    type: "concat",
    parts
  };
}

function indent$1(contents) {
  return {
    type: "indent",
    contents
  };
}

function align(n, contents) {
  return {
    type: "align",
    contents,
    n
  };
}

function group(contents, opts) {
  opts = opts || {};

  return {
    type: "group",
    id: opts.id,
    contents: contents,
    break: !!opts.shouldBreak,
    expandedStates: opts.expandedStates
  };
}

function dedentToRoot(contents) {
  return align(-Infinity, contents);
}

function markAsRoot(contents) {
  return align({
    type: "root"
  }, contents);
}

function dedent$1(contents) {
  return align(-1, contents);
}

function conditionalGroup(states, opts) {
  return group(states[0], Object.assign(opts || {}, {
    expandedStates: states
  }));
}

function fill(parts) {
  return {
    type: "fill",
    parts
  };
}

function ifBreak(breakContents, flatContents, opts) {
  opts = opts || {};

  return {
    type: "if-break",
    breakContents,
    flatContents,
    groupId: opts.groupId
  };
}

function lineSuffix$1(contents) {
  return {
    type: "line-suffix",
    contents
  };
}

var lineSuffixBoundary = {
  type: "line-suffix-boundary"
};
var breakParent$1 = {
  type: "break-parent"
};
var trim = {
  type: "trim"
};
var line$2 = {
  type: "line"
};
var softline = {
  type: "line",
  soft: true
};
var hardline$1 = concat$1([{
  type: "line",
  hard: true
}, breakParent$1]);
var literalline = concat$1([{
  type: "line",
  hard: true,
  literal: true
}, breakParent$1]);
var cursor$1 = {
  type: "cursor",
  placeholder: Symbol("cursor")
};

function join$1(sep, arr) {
  var res = [];

  for (var i = 0; i < arr.length; i++) {
    if (i !== 0) {
      res.push(sep);
    }

    res.push(arr[i]);
  }

  return concat$1(res);
}

function addAlignmentToDoc(doc, size, tabWidth) {
  var aligned = doc;

  if (size > 0) {
    // Use indent to add tabs for all the levels of tabs we need
    for (var i = 0; i < Math.floor(size / tabWidth); ++i) {
      aligned = indent$1(aligned);
    } // Use align for all the spaces that are needed


    aligned = align(size % tabWidth, aligned); // size is absolute from 0 and not relative to the current
    // indentation, so we use -Infinity to reset the indentation to 0

    aligned = align(-Infinity, aligned);
  }

  return aligned;
}

var docBuilders = {
  concat: concat$1,
  join: join$1,
  line: line$2,
  softline,
  hardline: hardline$1,
  literalline,
  group,
  conditionalGroup,
  fill,
  lineSuffix: lineSuffix$1,
  lineSuffixBoundary,
  cursor: cursor$1,
  breakParent: breakParent$1,
  ifBreak,
  trim,
  indent: indent$1,
  align,
  addAlignmentToDoc,
  markAsRoot,
  dedentToRoot,
  dedent: dedent$1
};

var ansiRegex = createCommonjsModule(function (module) {
  'use strict';

  module.exports = function (options) {
    options = Object.assign({
      onlyFirst: false
    }, options);
    var pattern = ['[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:[a-zA-Z\\d]*(?:;[a-zA-Z\\d]*)*)?\\u0007)', '(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))'].join('|');
    return new RegExp(pattern, options.onlyFirst ? undefined : 'g');
  };
});

var stripAnsi = function stripAnsi(input) {
  return typeof input === 'string' ? input.replace(ansiRegex(), '') : input;
};

var isFullwidthCodePoint = createCommonjsModule(function (module) {
  'use strict';
  /* eslint-disable yoda */

  module.exports = function (x) {
    if (Number.isNaN(x)) {
      return false;
    } // code points are derived from:
    // http://www.unix.org/Public/UNIDATA/EastAsianWidth.txt


    if (x >= 0x1100 && (x <= 0x115f || // Hangul Jamo
    x === 0x2329 || // LEFT-POINTING ANGLE BRACKET
    x === 0x232a || // RIGHT-POINTING ANGLE BRACKET
    // CJK Radicals Supplement .. Enclosed CJK Letters and Months
    0x2e80 <= x && x <= 0x3247 && x !== 0x303f || // Enclosed CJK Letters and Months .. CJK Unified Ideographs Extension A
    0x3250 <= x && x <= 0x4dbf || // CJK Unified Ideographs .. Yi Radicals
    0x4e00 <= x && x <= 0xa4c6 || // Hangul Jamo Extended-A
    0xa960 <= x && x <= 0xa97c || // Hangul Syllables
    0xac00 <= x && x <= 0xd7a3 || // CJK Compatibility Ideographs
    0xf900 <= x && x <= 0xfaff || // Vertical Forms
    0xfe10 <= x && x <= 0xfe19 || // CJK Compatibility Forms .. Small Form Variants
    0xfe30 <= x && x <= 0xfe6b || // Halfwidth and Fullwidth Forms
    0xff01 <= x && x <= 0xff60 || 0xffe0 <= x && x <= 0xffe6 || // Kana Supplement
    0x1b000 <= x && x <= 0x1b001 || // Enclosed Ideographic Supplement
    0x1f200 <= x && x <= 0x1f251 || // CJK Unified Ideographs Extension B .. Tertiary Ideographic Plane
    0x20000 <= x && x <= 0x3fffd)) {
      return true;
    }

    return false;
  };
});

var emojiRegex = function emojiRegex() {
  // https://mths.be/emoji
  return /\uD83C\uDFF4(?:\uDB40\uDC67\uDB40\uDC62(?:\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67|\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73|\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74)\uDB40\uDC7F|\u200D\u2620\uFE0F)|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC68(?:\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83D\uDC68|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDB0-\uDDB3])|(?:\uD83C[\uDFFB-\uDFFF])\u200D(?:\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDB0-\uDDB3]))|\uD83D\uDC69\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDB0-\uDDB3])|\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66|(?:\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8|\uD83D\uDC69(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2695\u2696\u2708]|\uD83D\uDC68(?:(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|(?:(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)\uFE0F|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF])\u200D[\u2640\u2642]|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDD6-\uDDDD])(?:(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|\u200D[\u2640\u2642])|\uD83D\uDC69\u200D[\u2695\u2696\u2708])\uFE0F|\uD83D\uDC69\u200D\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D\uDC68(?:\u200D(?:(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D[\uDC66\uDC67])|\uD83C[\uDFFB-\uDFFF])|\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08|\uD83D\uDC69\u200D\uD83D\uDC67|\uD83D\uDC69(?:\uD83C[\uDFFB-\uDFFF])\u200D(?:\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDB0-\uDDB3])|\uD83D\uDC69\u200D\uD83D\uDC66|\uD83C\uDDF6\uD83C\uDDE6|\uD83C\uDDFD\uD83C\uDDF0|\uD83C\uDDF4\uD83C\uDDF2|\uD83D\uDC69(?:\uD83C[\uDFFB-\uDFFF])|\uD83C\uDDED(?:\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA])|\uD83C\uDDEC(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE])|\uD83C\uDDEA(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA])|\uD83C\uDDE8(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF])|\uD83C\uDDF2(?:\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF])|\uD83C\uDDF3(?:\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF])|\uD83C\uDDFC(?:\uD83C[\uDDEB\uDDF8])|\uD83C\uDDFA(?:\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF])|\uD83C\uDDF0(?:\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF])|\uD83C\uDDEF(?:\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5])|\uD83C\uDDF8(?:\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF])|\uD83C\uDDEE(?:\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9])|\uD83C\uDDFF(?:\uD83C[\uDDE6\uDDF2\uDDFC])|\uD83C\uDDEB(?:\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7])|\uD83C\uDDF5(?:\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE])|\uD83C\uDDE9(?:\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF])|\uD83C\uDDF9(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF])|\uD83C\uDDE7(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF])|[#\*0-9]\uFE0F\u20E3|\uD83C\uDDF1(?:\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE])|\uD83C\uDDE6(?:\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF])|\uD83C\uDDF7(?:\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC])|\uD83C\uDDFB(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA])|\uD83C\uDDFE(?:\uD83C[\uDDEA\uDDF9])|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u261D\u270A-\u270D]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC70\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDCAA\uDD74\uDD7A\uDD90\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD36\uDDB5\uDDB6\uDDD1-\uDDD5])(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDEEB\uDEEC\uDEF4-\uDEF9]|\uD83E[\uDD10-\uDD3A\uDD3C-\uDD3E\uDD40-\uDD45\uDD47-\uDD70\uDD73-\uDD76\uDD7A\uDD7C-\uDDA2\uDDB0-\uDDB9\uDDC0-\uDDC2\uDDD0-\uDDFF])|(?:[#\*0-9\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u261D\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692-\u2697\u2699\u269B\u269C\u26A0\u26A1\u26AA\u26AB\u26B0\u26B1\u26BD\u26BE\u26C4\u26C5\u26C8\u26CE\u26CF\u26D1\u26D3\u26D4\u26E9\u26EA\u26F0-\u26F5\u26F7-\u26FA\u26FD\u2702\u2705\u2708-\u270D\u270F\u2712\u2714\u2716\u271D\u2721\u2728\u2733\u2734\u2744\u2747\u274C\u274E\u2753-\u2755\u2757\u2763\u2764\u2795-\u2797\u27A1\u27B0\u27BF\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55\u3030\u303D\u3297\u3299]|\uD83C[\uDC04\uDCCF\uDD70\uDD71\uDD7E\uDD7F\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE02\uDE1A\uDE2F\uDE32-\uDE3A\uDE50\uDE51\uDF00-\uDF21\uDF24-\uDF93\uDF96\uDF97\uDF99-\uDF9B\uDF9E-\uDFF0\uDFF3-\uDFF5\uDFF7-\uDFFF]|\uD83D[\uDC00-\uDCFD\uDCFF-\uDD3D\uDD49-\uDD4E\uDD50-\uDD67\uDD6F\uDD70\uDD73-\uDD7A\uDD87\uDD8A-\uDD8D\uDD90\uDD95\uDD96\uDDA4\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA-\uDE4F\uDE80-\uDEC5\uDECB-\uDED2\uDEE0-\uDEE5\uDEE9\uDEEB\uDEEC\uDEF0\uDEF3-\uDEF9]|\uD83E[\uDD10-\uDD3A\uDD3C-\uDD3E\uDD40-\uDD45\uDD47-\uDD70\uDD73-\uDD76\uDD7A\uDD7C-\uDDA2\uDDB0-\uDDB9\uDDC0-\uDDC2\uDDD0-\uDDFF])\uFE0F|(?:[\u261D\u26F9\u270A-\u270D]|\uD83C[\uDF85\uDFC2-\uDFC4\uDFC7\uDFCA-\uDFCC]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66-\uDC69\uDC6E\uDC70-\uDC78\uDC7C\uDC81-\uDC83\uDC85-\uDC87\uDCAA\uDD74\uDD75\uDD7A\uDD90\uDD95\uDD96\uDE45-\uDE47\uDE4B-\uDE4F\uDEA3\uDEB4-\uDEB6\uDEC0\uDECC]|\uD83E[\uDD18-\uDD1C\uDD1E\uDD1F\uDD26\uDD30-\uDD39\uDD3D\uDD3E\uDDB5\uDDB6\uDDB8\uDDB9\uDDD1-\uDDDD])/g;
};

var stringWidth = createCommonjsModule(function (module) {
  'use strict';

  var emojiRegex$$1 = emojiRegex();

  module.exports = function (input) {
    input = input.replace(emojiRegex$$1, '  ');

    if (typeof input !== 'string' || input.length === 0) {
      return 0;
    }

    input = stripAnsi(input);
    var width = 0;

    for (var i = 0; i < input.length; i++) {
      var code = input.codePointAt(i); // Ignore control characters

      if (code <= 0x1F || code >= 0x7F && code <= 0x9F) {
        continue;
      } // Ignore combining characters


      if (code >= 0x300 && code <= 0x36F) {
        continue;
      } // Surrogates


      if (code > 0xFFFF) {
        i++;
      }

      width += isFullwidthCodePoint(code) ? 2 : 1;
    }

    return width;
  };
});

var notAsciiRegex = /[^\x20-\x7F]/;

function isExportDeclaration(node) {
  if (node) {
    switch (node.type) {
      case "ExportDefaultDeclaration":
      case "ExportDefaultSpecifier":
      case "DeclareExportDeclaration":
      case "ExportNamedDeclaration":
      case "ExportAllDeclaration":
        return true;
    }
  }

  return false;
}

function getParentExportDeclaration(path$$1) {
  var parentNode = path$$1.getParentNode();

  if (path$$1.getName() === "declaration" && isExportDeclaration(parentNode)) {
    return parentNode;
  }

  return null;
}

function getPenultimate(arr) {
  if (arr.length > 1) {
    return arr[arr.length - 2];
  }

  return null;
}

function skip(chars) {
  return function (text, index, opts) {
    var backwards = opts && opts.backwards; // Allow `skip` functions to be threaded together without having
    // to check for failures (did someone say monads?).

    if (index === false) {
      return false;
    }

    var length = text.length;
    var cursor = index;

    while (cursor >= 0 && cursor < length) {
      var c = text.charAt(cursor);

      if (chars instanceof RegExp) {
        if (!chars.test(c)) {
          return cursor;
        }
      } else if (chars.indexOf(c) === -1) {
        return cursor;
      }

      backwards ? cursor-- : cursor++;
    }

    if (cursor === -1 || cursor === length) {
      // If we reached the beginning or end of the file, return the
      // out-of-bounds cursor. It's up to the caller to handle this
      // correctly. We don't want to indicate `false` though if it
      // actually skipped valid characters.
      return cursor;
    }

    return false;
  };
}

var skipWhitespace = skip(/\s/);
var skipSpaces = skip(" \t");
var skipToLineEnd = skip(",; \t");
var skipEverythingButNewLine = skip(/[^\r\n]/);

function skipInlineComment(text, index) {
  if (index === false) {
    return false;
  }

  if (text.charAt(index) === "/" && text.charAt(index + 1) === "*") {
    for (var i = index + 2; i < text.length; ++i) {
      if (text.charAt(i) === "*" && text.charAt(i + 1) === "/") {
        return i + 2;
      }
    }
  }

  return index;
}

function skipTrailingComment(text, index) {
  if (index === false) {
    return false;
  }

  if (text.charAt(index) === "/" && text.charAt(index + 1) === "/") {
    return skipEverythingButNewLine(text, index);
  }

  return index;
} // This one doesn't use the above helper function because it wants to
// test \r\n in order and `skip` doesn't support ordering and we only
// want to skip one newline. It's simple to implement.


function skipNewline$1(text, index, opts) {
  var backwards = opts && opts.backwards;

  if (index === false) {
    return false;
  }

  var atIndex = text.charAt(index);

  if (backwards) {
    if (text.charAt(index - 1) === "\r" && atIndex === "\n") {
      return index - 2;
    }

    if (atIndex === "\n" || atIndex === "\r" || atIndex === "\u2028" || atIndex === "\u2029") {
      return index - 1;
    }
  } else {
    if (atIndex === "\r" && text.charAt(index + 1) === "\n") {
      return index + 2;
    }

    if (atIndex === "\n" || atIndex === "\r" || atIndex === "\u2028" || atIndex === "\u2029") {
      return index + 1;
    }
  }

  return index;
}

function hasNewline$1(text, index, opts) {
  opts = opts || {};
  var idx = skipSpaces(text, opts.backwards ? index - 1 : index, opts);
  var idx2 = skipNewline$1(text, idx, opts);
  return idx !== idx2;
}

function hasNewlineInRange(text, start, end) {
  for (var i = start; i < end; ++i) {
    if (text.charAt(i) === "\n") {
      return true;
    }
  }

  return false;
} // Note: this function doesn't ignore leading comments unlike isNextLineEmpty


function isPreviousLineEmpty$1(text, node, locStart) {
  var idx = locStart(node) - 1;
  idx = skipSpaces(text, idx, {
    backwards: true
  });
  idx = skipNewline$1(text, idx, {
    backwards: true
  });
  idx = skipSpaces(text, idx, {
    backwards: true
  });
  var idx2 = skipNewline$1(text, idx, {
    backwards: true
  });
  return idx !== idx2;
}

function isNextLineEmptyAfterIndex(text, index) {
  var oldIdx = null;
  var idx = index;

  while (idx !== oldIdx) {
    // We need to skip all the potential trailing inline comments
    oldIdx = idx;
    idx = skipToLineEnd(text, idx);
    idx = skipInlineComment(text, idx);
    idx = skipSpaces(text, idx);
  }

  idx = skipTrailingComment(text, idx);
  idx = skipNewline$1(text, idx);
  return hasNewline$1(text, idx);
}

function isNextLineEmpty(text, node, locEnd) {
  return isNextLineEmptyAfterIndex(text, locEnd(node));
}

function getNextNonSpaceNonCommentCharacterIndexWithStartIndex(text, idx) {
  var oldIdx = null;

  while (idx !== oldIdx) {
    oldIdx = idx;
    idx = skipSpaces(text, idx);
    idx = skipInlineComment(text, idx);
    idx = skipTrailingComment(text, idx);
    idx = skipNewline$1(text, idx);
  }

  return idx;
}

function getNextNonSpaceNonCommentCharacterIndex(text, node, locEnd) {
  return getNextNonSpaceNonCommentCharacterIndexWithStartIndex(text, locEnd(node));
}

function getNextNonSpaceNonCommentCharacter(text, node, locEnd) {
  return text.charAt(getNextNonSpaceNonCommentCharacterIndex(text, node, locEnd));
}

function hasSpaces(text, index, opts) {
  opts = opts || {};
  var idx = skipSpaces(text, opts.backwards ? index - 1 : index, opts);
  return idx !== index;
}

function setLocStart(node, index) {
  if (node.range) {
    node.range[0] = index;
  } else {
    node.start = index;
  }
}

function setLocEnd(node, index) {
  if (node.range) {
    node.range[1] = index;
  } else {
    node.end = index;
  }
}

var PRECEDENCE = {};
[["|>"], ["||", "??"], ["&&"], ["|"], ["^"], ["&"], ["==", "===", "!=", "!=="], ["<", ">", "<=", ">=", "in", "instanceof"], [">>", "<<", ">>>"], ["+", "-"], ["*", "/", "%"], ["**"]].forEach(function (tier, i) {
  tier.forEach(function (op) {
    PRECEDENCE[op] = i;
  });
});

function getPrecedence(op) {
  return PRECEDENCE[op];
}

var equalityOperators = {
  "==": true,
  "!=": true,
  "===": true,
  "!==": true
};
var multiplicativeOperators = {
  "*": true,
  "/": true,
  "%": true
};
var bitshiftOperators = {
  ">>": true,
  ">>>": true,
  "<<": true
};

function shouldFlatten(parentOp, nodeOp) {
  if (getPrecedence(nodeOp) !== getPrecedence(parentOp)) {
    return false;
  } // ** is right-associative
  // x ** y ** z --> x ** (y ** z)


  if (parentOp === "**") {
    return false;
  } // x == y == z --> (x == y) == z


  if (equalityOperators[parentOp] && equalityOperators[nodeOp]) {
    return false;
  } // x * y % z --> (x * y) % z


  if (nodeOp === "%" && multiplicativeOperators[parentOp] || parentOp === "%" && multiplicativeOperators[nodeOp]) {
    return false;
  } // x * y / z --> (x * y) / z
  // x / y * z --> (x / y) * z


  if (nodeOp !== parentOp && multiplicativeOperators[nodeOp] && multiplicativeOperators[parentOp]) {
    return false;
  } // x << y << z --> (x << y) << z


  if (bitshiftOperators[parentOp] && bitshiftOperators[nodeOp]) {
    return false;
  }

  return true;
}

function isBitwiseOperator(operator) {
  return !!bitshiftOperators[operator] || operator === "|" || operator === "^" || operator === "&";
} // Tests if an expression starts with `{`, or (if forbidFunctionClassAndDoExpr
// holds) `function`, `class`, or `do {}`. Will be overzealous if there's
// already necessary grouping parentheses.


function startsWithNoLookaheadToken(node, forbidFunctionClassAndDoExpr) {
  node = getLeftMost(node);

  switch (node.type) {
    case "FunctionExpression":
    case "ClassExpression":
    case "DoExpression":
      return forbidFunctionClassAndDoExpr;

    case "ObjectExpression":
      return true;

    case "MemberExpression":
      return startsWithNoLookaheadToken(node.object, forbidFunctionClassAndDoExpr);

    case "TaggedTemplateExpression":
      if (node.tag.type === "FunctionExpression") {
        // IIFEs are always already parenthesized
        return false;
      }

      return startsWithNoLookaheadToken(node.tag, forbidFunctionClassAndDoExpr);

    case "CallExpression":
      if (node.callee.type === "FunctionExpression") {
        // IIFEs are always already parenthesized
        return false;
      }

      return startsWithNoLookaheadToken(node.callee, forbidFunctionClassAndDoExpr);

    case "ConditionalExpression":
      return startsWithNoLookaheadToken(node.test, forbidFunctionClassAndDoExpr);

    case "UpdateExpression":
      return !node.prefix && startsWithNoLookaheadToken(node.argument, forbidFunctionClassAndDoExpr);

    case "BindExpression":
      return node.object && startsWithNoLookaheadToken(node.object, forbidFunctionClassAndDoExpr);

    case "SequenceExpression":
      return startsWithNoLookaheadToken(node.expressions[0], forbidFunctionClassAndDoExpr);

    case "TSAsExpression":
      return startsWithNoLookaheadToken(node.expression, forbidFunctionClassAndDoExpr);

    default:
      return false;
  }
}

function getLeftMost(node) {
  if (node.left) {
    return getLeftMost(node.left);
  }

  return node;
}

function getAlignmentSize(value, tabWidth, startIndex) {
  startIndex = startIndex || 0;
  var size = 0;

  for (var i = startIndex; i < value.length; ++i) {
    if (value[i] === "\t") {
      // Tabs behave in a way that they are aligned to the nearest
      // multiple of tabWidth:
      // 0 -> 4, 1 -> 4, 2 -> 4, 3 -> 4
      // 4 -> 8, 5 -> 8, 6 -> 8, 7 -> 8 ...
      size = size + tabWidth - size % tabWidth;
    } else {
      size++;
    }
  }

  return size;
}

function getIndentSize(value, tabWidth) {
  var lastNewlineIndex = value.lastIndexOf("\n");

  if (lastNewlineIndex === -1) {
    return 0;
  }

  return getAlignmentSize( // All the leading whitespaces
  value.slice(lastNewlineIndex + 1).match(/^[ \t]*/)[0], tabWidth);
}

function getPreferredQuote(raw, preferredQuote) {
  // `rawContent` is the string exactly like it appeared in the input source
  // code, without its enclosing quotes.
  var rawContent = raw.slice(1, -1);
  var double = {
    quote: '"',
    regex: /"/g
  };
  var single = {
    quote: "'",
    regex: /'/g
  };
  var preferred = preferredQuote === "'" ? single : double;
  var alternate = preferred === single ? double : single;
  var result = preferred.quote; // If `rawContent` contains at least one of the quote preferred for enclosing
  // the string, we might want to enclose with the alternate quote instead, to
  // minimize the number of escaped quotes.

  if (rawContent.includes(preferred.quote) || rawContent.includes(alternate.quote)) {
    var numPreferredQuotes = (rawContent.match(preferred.regex) || []).length;
    var numAlternateQuotes = (rawContent.match(alternate.regex) || []).length;
    result = numPreferredQuotes > numAlternateQuotes ? alternate.quote : preferred.quote;
  }

  return result;
}

function printString(raw, options, isDirectiveLiteral) {
  // `rawContent` is the string exactly like it appeared in the input source
  // code, without its enclosing quotes.
  var rawContent = raw.slice(1, -1); // Check for the alternate quote, to determine if we're allowed to swap
  // the quotes on a DirectiveLiteral.

  var canChangeDirectiveQuotes = !rawContent.includes('"') && !rawContent.includes("'");
  var enclosingQuote = options.parser === "json" ? '"' : options.__isInHtmlAttribute ? "'" : getPreferredQuote(raw, options.singleQuote ? "'" : '"'); // Directives are exact code unit sequences, which means that you can't
  // change the escape sequences they use.
  // See https://github.com/prettier/prettier/issues/1555
  // and https://tc39.github.io/ecma262/#directive-prologue

  if (isDirectiveLiteral) {
    if (canChangeDirectiveQuotes) {
      return enclosingQuote + rawContent + enclosingQuote;
    }

    return raw;
  } // It might sound unnecessary to use `makeString` even if the string already
  // is enclosed with `enclosingQuote`, but it isn't. The string could contain
  // unnecessary escapes (such as in `"\'"`). Always using `makeString` makes
  // sure that we consistently output the minimum amount of escaped quotes.


  return makeString(rawContent, enclosingQuote, !(options.parser === "css" || options.parser === "less" || options.parser === "scss" || options.embeddedInHtml));
}

function makeString(rawContent, enclosingQuote, unescapeUnnecessaryEscapes) {
  var otherQuote = enclosingQuote === '"' ? "'" : '"'; // Matches _any_ escape and unescaped quotes (both single and double).

  var regex = /\\([\s\S])|(['"])/g; // Escape and unescape single and double quotes as needed to be able to
  // enclose `rawContent` with `enclosingQuote`.

  var newContent = rawContent.replace(regex, function (match, escaped, quote) {
    // If we matched an escape, and the escaped character is a quote of the
    // other type than we intend to enclose the string with, there's no need for
    // it to be escaped, so return it _without_ the backslash.
    if (escaped === otherQuote) {
      return escaped;
    } // If we matched an unescaped quote and it is of the _same_ type as we
    // intend to enclose the string with, it must be escaped, so return it with
    // a backslash.


    if (quote === enclosingQuote) {
      return "\\" + quote;
    }

    if (quote) {
      return quote;
    } // Unescape any unnecessarily escaped character.
    // Adapted from https://github.com/eslint/eslint/blob/de0b4ad7bd820ade41b1f606008bea68683dc11a/lib/rules/no-useless-escape.js#L27


    return unescapeUnnecessaryEscapes && /^[^\\nrvtbfux\r\n\u2028\u2029"'0-7]$/.test(escaped) ? escaped : "\\" + escaped;
  });
  return enclosingQuote + newContent + enclosingQuote;
}

function printNumber(rawNumber) {
  return rawNumber.toLowerCase() // Remove unnecessary plus and zeroes from scientific notation.
  .replace(/^([+-]?[\d.]+e)(?:\+|(-))?0*(\d)/, "$1$2$3") // Remove unnecessary scientific notation (1e0).
  .replace(/^([+-]?[\d.]+)e[+-]?0+$/, "$1") // Make sure numbers always start with a digit.
  .replace(/^([+-])?\./, "$10.") // Remove extraneous trailing decimal zeroes.
  .replace(/(\.\d+?)0+(?=e|$)/, "$1") // Remove trailing dot.
  .replace(/\.(?=e|$)/, "");
}

function getMaxContinuousCount(str, target) {
  var results = str.match(new RegExp(`(${escapeStringRegexp(target)})+`, "g"));

  if (results === null) {
    return 0;
  }

  return results.reduce(function (maxCount, result) {
    return Math.max(maxCount, result.length / target.length);
  }, 0);
}

function getMinNotPresentContinuousCount(str, target) {
  var matches = str.match(new RegExp(`(${escapeStringRegexp(target)})+`, "g"));

  if (matches === null) {
    return 0;
  }

  var countPresent = new Map();
  var max = 0;
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = matches[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var match = _step.value;
      var count = match.length / target.length;
      countPresent.set(count, true);

      if (count > max) {
        max = count;
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  for (var i = 1; i < max; i++) {
    if (!countPresent.get(i)) {
      return i;
    }
  }

  return max + 1;
}

function getStringWidth$1(text) {
  if (!text) {
    return 0;
  } // shortcut to avoid needless string `RegExp`s, replacements, and allocations within `string-width`


  if (!notAsciiRegex.test(text)) {
    return text.length;
  }

  return stringWidth(text);
}

function hasIgnoreComment(path$$1) {
  var node = path$$1.getValue();
  return hasNodeIgnoreComment(node);
}

function hasNodeIgnoreComment(node) {
  return node && node.comments && node.comments.length > 0 && node.comments.some(function (comment) {
    return comment.value.trim() === "prettier-ignore";
  });
}

function matchAncestorTypes(path$$1, types, index) {
  index = index || 0;
  types = types.slice();

  while (types.length) {
    var parent = path$$1.getParentNode(index);
    var type = types.shift();

    if (!parent || parent.type !== type) {
      return false;
    }

    index++;
  }

  return true;
}

function addCommentHelper(node, comment) {
  var comments = node.comments || (node.comments = []);
  comments.push(comment);
  comment.printed = false; // For some reason, TypeScript parses `// x` inside of JSXText as a comment
  // We already "print" it via the raw text, we don't need to re-print it as a
  // comment

  if (node.type === "JSXText") {
    comment.printed = true;
  }
}

function addLeadingComment$1(node, comment) {
  comment.leading = true;
  comment.trailing = false;
  addCommentHelper(node, comment);
}

function addDanglingComment$1(node, comment) {
  comment.leading = false;
  comment.trailing = false;
  addCommentHelper(node, comment);
}

function addTrailingComment$1(node, comment) {
  comment.leading = false;
  comment.trailing = true;
  addCommentHelper(node, comment);
}

function isWithinParentArrayProperty(path$$1, propertyName) {
  var node = path$$1.getValue();
  var parent = path$$1.getParentNode();

  if (parent == null) {
    return false;
  }

  if (!Array.isArray(parent[propertyName])) {
    return false;
  }

  var key = path$$1.getName();
  return parent[propertyName][key] === node;
}

function replaceEndOfLineWith(text, replacement) {
  var parts = [];
  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = text.split("\n")[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var part = _step2.value;

      if (parts.length !== 0) {
        parts.push(replacement);
      }

      parts.push(part);
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
        _iterator2.return();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  return parts;
}

var util$1 = {
  replaceEndOfLineWith,
  getStringWidth: getStringWidth$1,
  getMaxContinuousCount,
  getMinNotPresentContinuousCount,
  getPrecedence,
  shouldFlatten,
  isBitwiseOperator,
  isExportDeclaration,
  getParentExportDeclaration,
  getPenultimate,
  getLast,
  getNextNonSpaceNonCommentCharacterIndexWithStartIndex,
  getNextNonSpaceNonCommentCharacterIndex,
  getNextNonSpaceNonCommentCharacter,
  skip,
  skipWhitespace,
  skipSpaces,
  skipToLineEnd,
  skipEverythingButNewLine,
  skipInlineComment,
  skipTrailingComment,
  skipNewline: skipNewline$1,
  isNextLineEmptyAfterIndex,
  isNextLineEmpty,
  isPreviousLineEmpty: isPreviousLineEmpty$1,
  hasNewline: hasNewline$1,
  hasNewlineInRange,
  hasSpaces,
  setLocStart,
  setLocEnd,
  startsWithNoLookaheadToken,
  getAlignmentSize,
  getIndentSize,
  getPreferredQuote,
  printString,
  printNumber,
  hasIgnoreComment,
  hasNodeIgnoreComment,
  makeString,
  matchAncestorTypes,
  addLeadingComment: addLeadingComment$1,
  addDanglingComment: addDanglingComment$1,
  addTrailingComment: addTrailingComment$1,
  isWithinParentArrayProperty
};

function guessEndOfLine$1(text) {
  var index = text.indexOf("\r");

  if (index >= 0) {
    return text.charAt(index + 1) === "\n" ? "crlf" : "cr";
  }

  return "lf";
}

function convertEndOfLineToChars$2(value) {
  switch (value) {
    case "cr":
      return "\r";

    case "crlf":
      return "\r\n";

    default:
      return "\n";
  }
}

var endOfLine = {
  guessEndOfLine: guessEndOfLine$1,
  convertEndOfLineToChars: convertEndOfLineToChars$2
};

var getStringWidth = util$1.getStringWidth;
var convertEndOfLineToChars$1 = endOfLine.convertEndOfLineToChars;
var concat$2 = docBuilders.concat;
var fill$1 = docBuilders.fill;
var cursor$2 = docBuilders.cursor;
/** @type {{[groupId: PropertyKey]: MODE}} */

var groupModeMap;
var MODE_BREAK = 1;
var MODE_FLAT = 2;

function rootIndent() {
  return {
    value: "",
    length: 0,
    queue: []
  };
}

function makeIndent(ind, options) {
  return generateInd(ind, {
    type: "indent"
  }, options);
}

function makeAlign(ind, n, options) {
  return n === -Infinity ? ind.root || rootIndent() : n < 0 ? generateInd(ind, {
    type: "dedent"
  }, options) : !n ? ind : n.type === "root" ? Object.assign({}, ind, {
    root: ind
  }) : typeof n === "string" ? generateInd(ind, {
    type: "stringAlign",
    n
  }, options) : generateInd(ind, {
    type: "numberAlign",
    n
  }, options);
}

function generateInd(ind, newPart, options) {
  var queue = newPart.type === "dedent" ? ind.queue.slice(0, -1) : ind.queue.concat(newPart);
  var value = "";
  var length = 0;
  var lastTabs = 0;
  var lastSpaces = 0;
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = queue[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var part = _step.value;

      switch (part.type) {
        case "indent":
          flush();

          if (options.useTabs) {
            addTabs(1);
          } else {
            addSpaces(options.tabWidth);
          }

          break;

        case "stringAlign":
          flush();
          value += part.n;
          length += part.n.length;
          break;

        case "numberAlign":
          lastTabs += 1;
          lastSpaces += part.n;
          break;

        /* istanbul ignore next */

        default:
          throw new Error(`Unexpected type '${part.type}'`);
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  flushSpaces();
  return Object.assign({}, ind, {
    value,
    length,
    queue
  });

  function addTabs(count) {
    value += "\t".repeat(count);
    length += options.tabWidth * count;
  }

  function addSpaces(count) {
    value += " ".repeat(count);
    length += count;
  }

  function flush() {
    if (options.useTabs) {
      flushTabs();
    } else {
      flushSpaces();
    }
  }

  function flushTabs() {
    if (lastTabs > 0) {
      addTabs(lastTabs);
    }

    resetLast();
  }

  function flushSpaces() {
    if (lastSpaces > 0) {
      addSpaces(lastSpaces);
    }

    resetLast();
  }

  function resetLast() {
    lastTabs = 0;
    lastSpaces = 0;
  }
}

function trim$1(out) {
  if (out.length === 0) {
    return 0;
  }

  var trimCount = 0; // Trim whitespace at the end of line

  while (out.length > 0 && typeof out[out.length - 1] === "string" && out[out.length - 1].match(/^[ \t]*$/)) {
    trimCount += out.pop().length;
  }

  if (out.length && typeof out[out.length - 1] === "string") {
    var trimmed = out[out.length - 1].replace(/[ \t]*$/, "");
    trimCount += out[out.length - 1].length - trimmed.length;
    out[out.length - 1] = trimmed;
  }

  return trimCount;
}

function fits(next, restCommands, width, options, mustBeFlat) {
  var restIdx = restCommands.length;
  var cmds = [next]; // `out` is only used for width counting because `trim` requires to look
  // backwards for space characters.

  var out = [];

  while (width >= 0) {
    if (cmds.length === 0) {
      if (restIdx === 0) {
        return true;
      }

      cmds.push(restCommands[restIdx - 1]);
      restIdx--;
      continue;
    }

    var x = cmds.pop();
    var ind = x[0];
    var mode = x[1];
    var doc = x[2];

    if (typeof doc === "string") {
      out.push(doc);
      width -= getStringWidth(doc);
    } else {
      switch (doc.type) {
        case "concat":
          for (var i = doc.parts.length - 1; i >= 0; i--) {
            cmds.push([ind, mode, doc.parts[i]]);
          }

          break;

        case "indent":
          cmds.push([makeIndent(ind, options), mode, doc.contents]);
          break;

        case "align":
          cmds.push([makeAlign(ind, doc.n, options), mode, doc.contents]);
          break;

        case "trim":
          width += trim$1(out);
          break;

        case "group":
          if (mustBeFlat && doc.break) {
            return false;
          }

          cmds.push([ind, doc.break ? MODE_BREAK : mode, doc.contents]);

          if (doc.id) {
            groupModeMap[doc.id] = cmds[cmds.length - 1][1];
          }

          break;

        case "fill":
          for (var _i = doc.parts.length - 1; _i >= 0; _i--) {
            cmds.push([ind, mode, doc.parts[_i]]);
          }

          break;

        case "if-break":
          {
            var groupMode = doc.groupId ? groupModeMap[doc.groupId] : mode;

            if (groupMode === MODE_BREAK) {
              if (doc.breakContents) {
                cmds.push([ind, mode, doc.breakContents]);
              }
            }

            if (groupMode === MODE_FLAT) {
              if (doc.flatContents) {
                cmds.push([ind, mode, doc.flatContents]);
              }
            }

            break;
          }

        case "line":
          switch (mode) {
            // fallthrough
            case MODE_FLAT:
              if (!doc.hard) {
                if (!doc.soft) {
                  out.push(" ");
                  width -= 1;
                }

                break;
              }

              return true;

            case MODE_BREAK:
              return true;
          }

          break;
      }
    }
  }

  return false;
}

function printDocToString$1(doc, options) {
  groupModeMap = {};
  var width = options.printWidth;
  var newLine = convertEndOfLineToChars$1(options.endOfLine);
  var pos = 0; // cmds is basically a stack. We've turned a recursive call into a
  // while loop which is much faster. The while loop below adds new
  // cmds to the array instead of recursively calling `print`.

  var cmds = [[rootIndent(), MODE_BREAK, doc]];
  var out = [];
  var shouldRemeasure = false;
  var lineSuffix = [];

  while (cmds.length !== 0) {
    var x = cmds.pop();
    var ind = x[0];
    var mode = x[1];
    var _doc = x[2];

    if (typeof _doc === "string") {
      out.push(_doc);
      pos += getStringWidth(_doc);
    } else {
      switch (_doc.type) {
        case "cursor":
          out.push(cursor$2.placeholder);
          break;

        case "concat":
          for (var i = _doc.parts.length - 1; i >= 0; i--) {
            cmds.push([ind, mode, _doc.parts[i]]);
          }

          break;

        case "indent":
          cmds.push([makeIndent(ind, options), mode, _doc.contents]);
          break;

        case "align":
          cmds.push([makeAlign(ind, _doc.n, options), mode, _doc.contents]);
          break;

        case "trim":
          pos -= trim$1(out);
          break;

        case "group":
          switch (mode) {
            case MODE_FLAT:
              if (!shouldRemeasure) {
                cmds.push([ind, _doc.break ? MODE_BREAK : MODE_FLAT, _doc.contents]);
                break;
              }

            // fallthrough

            case MODE_BREAK:
              {
                shouldRemeasure = false;
                var next = [ind, MODE_FLAT, _doc.contents];
                var rem = width - pos;

                if (!_doc.break && fits(next, cmds, rem, options)) {
                  cmds.push(next);
                } else {
                  // Expanded states are a rare case where a document
                  // can manually provide multiple representations of
                  // itself. It provides an array of documents
                  // going from the least expanded (most flattened)
                  // representation first to the most expanded. If a
                  // group has these, we need to manually go through
                  // these states and find the first one that fits.
                  if (_doc.expandedStates) {
                    var mostExpanded = _doc.expandedStates[_doc.expandedStates.length - 1];

                    if (_doc.break) {
                      cmds.push([ind, MODE_BREAK, mostExpanded]);
                      break;
                    } else {
                      for (var _i2 = 1; _i2 < _doc.expandedStates.length + 1; _i2++) {
                        if (_i2 >= _doc.expandedStates.length) {
                          cmds.push([ind, MODE_BREAK, mostExpanded]);
                          break;
                        } else {
                          var state = _doc.expandedStates[_i2];
                          var cmd = [ind, MODE_FLAT, state];

                          if (fits(cmd, cmds, rem, options)) {
                            cmds.push(cmd);
                            break;
                          }
                        }
                      }
                    }
                  } else {
                    cmds.push([ind, MODE_BREAK, _doc.contents]);
                  }
                }

                break;
              }
          }

          if (_doc.id) {
            groupModeMap[_doc.id] = cmds[cmds.length - 1][1];
          }

          break;
        // Fills each line with as much code as possible before moving to a new
        // line with the same indentation.
        //
        // Expects doc.parts to be an array of alternating content and
        // whitespace. The whitespace contains the linebreaks.
        //
        // For example:
        //   ["I", line, "love", line, "monkeys"]
        // or
        //   [{ type: group, ... }, softline, { type: group, ... }]
        //
        // It uses this parts structure to handle three main layout cases:
        // * The first two content items fit on the same line without
        //   breaking
        //   -> output the first content item and the whitespace "flat".
        // * Only the first content item fits on the line without breaking
        //   -> output the first content item "flat" and the whitespace with
        //   "break".
        // * Neither content item fits on the line without breaking
        //   -> output the first content item and the whitespace with "break".

        case "fill":
          {
            var _rem = width - pos;

            var parts = _doc.parts;

            if (parts.length === 0) {
              break;
            }

            var content = parts[0];
            var contentFlatCmd = [ind, MODE_FLAT, content];
            var contentBreakCmd = [ind, MODE_BREAK, content];
            var contentFits = fits(contentFlatCmd, [], _rem, options, true);

            if (parts.length === 1) {
              if (contentFits) {
                cmds.push(contentFlatCmd);
              } else {
                cmds.push(contentBreakCmd);
              }

              break;
            }

            var whitespace = parts[1];
            var whitespaceFlatCmd = [ind, MODE_FLAT, whitespace];
            var whitespaceBreakCmd = [ind, MODE_BREAK, whitespace];

            if (parts.length === 2) {
              if (contentFits) {
                cmds.push(whitespaceFlatCmd);
                cmds.push(contentFlatCmd);
              } else {
                cmds.push(whitespaceBreakCmd);
                cmds.push(contentBreakCmd);
              }

              break;
            } // At this point we've handled the first pair (context, separator)
            // and will create a new fill doc for the rest of the content.
            // Ideally we wouldn't mutate the array here but coping all the
            // elements to a new array would make this algorithm quadratic,
            // which is unusable for large arrays (e.g. large texts in JSX).


            parts.splice(0, 2);
            var remainingCmd = [ind, mode, fill$1(parts)];
            var secondContent = parts[0];
            var firstAndSecondContentFlatCmd = [ind, MODE_FLAT, concat$2([content, whitespace, secondContent])];
            var firstAndSecondContentFits = fits(firstAndSecondContentFlatCmd, [], _rem, options, true);

            if (firstAndSecondContentFits) {
              cmds.push(remainingCmd);
              cmds.push(whitespaceFlatCmd);
              cmds.push(contentFlatCmd);
            } else if (contentFits) {
              cmds.push(remainingCmd);
              cmds.push(whitespaceBreakCmd);
              cmds.push(contentFlatCmd);
            } else {
              cmds.push(remainingCmd);
              cmds.push(whitespaceBreakCmd);
              cmds.push(contentBreakCmd);
            }

            break;
          }

        case "if-break":
          {
            var groupMode = _doc.groupId ? groupModeMap[_doc.groupId] : mode;

            if (groupMode === MODE_BREAK) {
              if (_doc.breakContents) {
                cmds.push([ind, mode, _doc.breakContents]);
              }
            }

            if (groupMode === MODE_FLAT) {
              if (_doc.flatContents) {
                cmds.push([ind, mode, _doc.flatContents]);
              }
            }

            break;
          }

        case "line-suffix":
          lineSuffix.push([ind, mode, _doc.contents]);
          break;

        case "line-suffix-boundary":
          if (lineSuffix.length > 0) {
            cmds.push([ind, mode, {
              type: "line",
              hard: true
            }]);
          }

          break;

        case "line":
          switch (mode) {
            case MODE_FLAT:
              if (!_doc.hard) {
                if (!_doc.soft) {
                  out.push(" ");
                  pos += 1;
                }

                break;
              } else {
                // This line was forced into the output even if we
                // were in flattened mode, so we need to tell the next
                // group that no matter what, it needs to remeasure
                // because the previous measurement didn't accurately
                // capture the entire expression (this is necessary
                // for nested groups)
                shouldRemeasure = true;
              }

            // fallthrough

            case MODE_BREAK:
              if (lineSuffix.length) {
                cmds.push([ind, mode, _doc]);
                [].push.apply(cmds, lineSuffix.reverse());
                lineSuffix = [];
                break;
              }

              if (_doc.literal) {
                if (ind.root) {
                  out.push(newLine, ind.root.value);
                  pos = ind.root.length;
                } else {
                  out.push(newLine);
                  pos = 0;
                }
              } else {
                pos -= trim$1(out);
                out.push(newLine + ind.value);
                pos = ind.length;
              }

              break;
          }

          break;

        default:
      }
    }
  }

  var cursorPlaceholderIndex = out.indexOf(cursor$2.placeholder);

  if (cursorPlaceholderIndex !== -1) {
    var otherCursorPlaceholderIndex = out.indexOf(cursor$2.placeholder, cursorPlaceholderIndex + 1);
    var beforeCursor = out.slice(0, cursorPlaceholderIndex).join("");
    var aroundCursor = out.slice(cursorPlaceholderIndex + 1, otherCursorPlaceholderIndex).join("");
    var afterCursor = out.slice(otherCursorPlaceholderIndex + 1).join("");
    return {
      formatted: beforeCursor + aroundCursor + afterCursor,
      cursorNodeStart: beforeCursor.length,
      cursorNodeText: aroundCursor
    };
  }

  return {
    formatted: out.join("")
  };
}

var docPrinter = {
  printDocToString: printDocToString$1
};

var traverseDocOnExitStackMarker = {};

function traverseDoc(doc, onEnter, onExit, shouldTraverseConditionalGroups) {
  var docsStack = [doc];

  while (docsStack.length !== 0) {
    var _doc = docsStack.pop();

    if (_doc === traverseDocOnExitStackMarker) {
      onExit(docsStack.pop());
      continue;
    }

    var shouldRecurse = true;

    if (onEnter) {
      if (onEnter(_doc) === false) {
        shouldRecurse = false;
      }
    }

    if (onExit) {
      docsStack.push(_doc);
      docsStack.push(traverseDocOnExitStackMarker);
    }

    if (shouldRecurse) {
      // When there are multiple parts to process,
      // the parts need to be pushed onto the stack in reverse order,
      // so that they are processed in the original order
      // when the stack is popped.
      if (_doc.type === "concat" || _doc.type === "fill") {
        for (var ic = _doc.parts.length, i = ic - 1; i >= 0; --i) {
          docsStack.push(_doc.parts[i]);
        }
      } else if (_doc.type === "if-break") {
        if (_doc.flatContents) {
          docsStack.push(_doc.flatContents);
        }

        if (_doc.breakContents) {
          docsStack.push(_doc.breakContents);
        }
      } else if (_doc.type === "group" && _doc.expandedStates) {
        if (shouldTraverseConditionalGroups) {
          for (var _ic = _doc.expandedStates.length, _i = _ic - 1; _i >= 0; --_i) {
            docsStack.push(_doc.expandedStates[_i]);
          }
        } else {
          docsStack.push(_doc.contents);
        }
      } else if (_doc.contents) {
        docsStack.push(_doc.contents);
      }
    }
  }
}

function mapDoc$1(doc, cb) {
  if (doc.type === "concat" || doc.type === "fill") {
    var parts = doc.parts.map(function (part) {
      return mapDoc$1(part, cb);
    });
    return cb(Object.assign({}, doc, {
      parts
    }));
  } else if (doc.type === "if-break") {
    var breakContents = doc.breakContents && mapDoc$1(doc.breakContents, cb);
    var flatContents = doc.flatContents && mapDoc$1(doc.flatContents, cb);
    return cb(Object.assign({}, doc, {
      breakContents,
      flatContents
    }));
  } else if (doc.contents) {
    var contents = mapDoc$1(doc.contents, cb);
    return cb(Object.assign({}, doc, {
      contents
    }));
  }

  return cb(doc);
}

function findInDoc(doc, fn, defaultValue) {
  var result = defaultValue;
  var hasStopped = false;

  function findInDocOnEnterFn(doc) {
    var maybeResult = fn(doc);

    if (maybeResult !== undefined) {
      hasStopped = true;
      result = maybeResult;
    }

    if (hasStopped) {
      return false;
    }
  }

  traverseDoc(doc, findInDocOnEnterFn);
  return result;
}

function isEmpty(n) {
  return typeof n === "string" && n.length === 0;
}

function isLineNextFn(doc) {
  if (typeof doc === "string") {
    return false;
  }

  if (doc.type === "line") {
    return true;
  }
}

function isLineNext(doc) {
  return findInDoc(doc, isLineNextFn, false);
}

function willBreakFn(doc) {
  if (doc.type === "group" && doc.break) {
    return true;
  }

  if (doc.type === "line" && doc.hard) {
    return true;
  }

  if (doc.type === "break-parent") {
    return true;
  }
}

function willBreak(doc) {
  return findInDoc(doc, willBreakFn, false);
}

function breakParentGroup(groupStack) {
  if (groupStack.length > 0) {
    var parentGroup = groupStack[groupStack.length - 1]; // Breaks are not propagated through conditional groups because
    // the user is expected to manually handle what breaks.

    if (!parentGroup.expandedStates) {
      parentGroup.break = true;
    }
  }

  return null;
}

function propagateBreaks(doc) {
  var alreadyVisitedSet = new Set();
  var groupStack = [];

  function propagateBreaksOnEnterFn(doc) {
    if (doc.type === "break-parent") {
      breakParentGroup(groupStack);
    }

    if (doc.type === "group") {
      groupStack.push(doc);

      if (alreadyVisitedSet.has(doc)) {
        return false;
      }

      alreadyVisitedSet.add(doc);
    }
  }

  function propagateBreaksOnExitFn(doc) {
    if (doc.type === "group") {
      var group = groupStack.pop();

      if (group.break) {
        breakParentGroup(groupStack);
      }
    }
  }

  traverseDoc(doc, propagateBreaksOnEnterFn, propagateBreaksOnExitFn,
  /* shouldTraverseConditionalGroups */
  true);
}

function removeLinesFn(doc) {
  // Force this doc into flat mode by statically converting all
  // lines into spaces (or soft lines into nothing). Hard lines
  // should still output because there's too great of a chance
  // of breaking existing assumptions otherwise.
  if (doc.type === "line" && !doc.hard) {
    return doc.soft ? "" : " ";
  } else if (doc.type === "if-break") {
    return doc.flatContents || "";
  }

  return doc;
}

function removeLines(doc) {
  return mapDoc$1(doc, removeLinesFn);
}

function stripTrailingHardline(doc) {
  // HACK remove ending hardline, original PR: #1984
  if (doc.type === "concat" && doc.parts.length !== 0) {
    var lastPart = doc.parts[doc.parts.length - 1];

    if (lastPart.type === "concat") {
      if (lastPart.parts.length === 2 && lastPart.parts[0].hard && lastPart.parts[1].type === "break-parent") {
        return {
          type: "concat",
          parts: doc.parts.slice(0, -1)
        };
      }

      return {
        type: "concat",
        parts: doc.parts.slice(0, -1).concat(stripTrailingHardline(lastPart))
      };
    }
  }

  return doc;
}

var docUtils = {
  isEmpty,
  willBreak,
  isLineNext,
  traverseDoc,
  findInDoc,
  mapDoc: mapDoc$1,
  propagateBreaks,
  removeLines,
  stripTrailingHardline
};

function flattenDoc(doc) {
  if (doc.type === "concat") {
    var res = [];

    for (var i = 0; i < doc.parts.length; ++i) {
      var doc2 = doc.parts[i];

      if (typeof doc2 !== "string" && doc2.type === "concat") {
        [].push.apply(res, flattenDoc(doc2).parts);
      } else {
        var flattened = flattenDoc(doc2);

        if (flattened !== "") {
          res.push(flattened);
        }
      }
    }

    return Object.assign({}, doc, {
      parts: res
    });
  } else if (doc.type === "if-break") {
    return Object.assign({}, doc, {
      breakContents: doc.breakContents != null ? flattenDoc(doc.breakContents) : null,
      flatContents: doc.flatContents != null ? flattenDoc(doc.flatContents) : null
    });
  } else if (doc.type === "group") {
    return Object.assign({}, doc, {
      contents: flattenDoc(doc.contents),
      expandedStates: doc.expandedStates ? doc.expandedStates.map(flattenDoc) : doc.expandedStates
    });
  } else if (doc.contents) {
    return Object.assign({}, doc, {
      contents: flattenDoc(doc.contents)
    });
  }

  return doc;
}

function printDoc(doc) {
  if (typeof doc === "string") {
    return JSON.stringify(doc);
  }

  if (doc.type === "line") {
    if (doc.literal) {
      return "literalline";
    }

    if (doc.hard) {
      return "hardline";
    }

    if (doc.soft) {
      return "softline";
    }

    return "line";
  }

  if (doc.type === "break-parent") {
    return "breakParent";
  }

  if (doc.type === "trim") {
    return "trim";
  }

  if (doc.type === "concat") {
    return "[" + doc.parts.map(printDoc).join(", ") + "]";
  }

  if (doc.type === "indent") {
    return "indent(" + printDoc(doc.contents) + ")";
  }

  if (doc.type === "align") {
    return doc.n === -Infinity ? "dedentToRoot(" + printDoc(doc.contents) + ")" : doc.n < 0 ? "dedent(" + printDoc(doc.contents) + ")" : doc.n.type === "root" ? "markAsRoot(" + printDoc(doc.contents) + ")" : "align(" + JSON.stringify(doc.n) + ", " + printDoc(doc.contents) + ")";
  }

  if (doc.type === "if-break") {
    return "ifBreak(" + printDoc(doc.breakContents) + (doc.flatContents ? ", " + printDoc(doc.flatContents) : "") + ")";
  }

  if (doc.type === "group") {
    if (doc.expandedStates) {
      return "conditionalGroup(" + "[" + doc.expandedStates.map(printDoc).join(",") + "])";
    }

    return (doc.break ? "wrappedGroup" : "group") + "(" + printDoc(doc.contents) + ")";
  }

  if (doc.type === "fill") {
    return "fill" + "(" + doc.parts.map(printDoc).join(", ") + ")";
  }

  if (doc.type === "line-suffix") {
    return "lineSuffix(" + printDoc(doc.contents) + ")";
  }

  if (doc.type === "line-suffix-boundary") {
    return "lineSuffixBoundary";
  }

  throw new Error("Unknown doc type " + doc.type);
}

var docDebug = {
  printDocToDebug: function printDocToDebug(doc) {
    return printDoc(flattenDoc(doc));
  }
};

var doc = {
  builders: docBuilders,
  printer: docPrinter,
  utils: docUtils,
  debug: docDebug
};

var mapDoc$2 = doc.utils.mapDoc;

function isNextLineEmpty$1(text, node, options) {
  return util$1.isNextLineEmpty(text, node, options.locEnd);
}

function isPreviousLineEmpty$2(text, node, options) {
  return util$1.isPreviousLineEmpty(text, node, options.locStart);
}

function getNextNonSpaceNonCommentCharacterIndex$1(text, node, options) {
  return util$1.getNextNonSpaceNonCommentCharacterIndex(text, node, options.locEnd);
}

var utilShared = {
  getMaxContinuousCount: util$1.getMaxContinuousCount,
  getStringWidth: util$1.getStringWidth,
  getAlignmentSize: util$1.getAlignmentSize,
  getIndentSize: util$1.getIndentSize,
  skip: util$1.skip,
  skipWhitespace: util$1.skipWhitespace,
  skipSpaces: util$1.skipSpaces,
  skipNewline: util$1.skipNewline,
  skipToLineEnd: util$1.skipToLineEnd,
  skipEverythingButNewLine: util$1.skipEverythingButNewLine,
  skipInlineComment: util$1.skipInlineComment,
  skipTrailingComment: util$1.skipTrailingComment,
  hasNewline: util$1.hasNewline,
  hasNewlineInRange: util$1.hasNewlineInRange,
  hasSpaces: util$1.hasSpaces,
  isNextLineEmpty: isNextLineEmpty$1,
  isNextLineEmptyAfterIndex: util$1.isNextLineEmptyAfterIndex,
  isPreviousLineEmpty: isPreviousLineEmpty$2,
  getNextNonSpaceNonCommentCharacterIndex: getNextNonSpaceNonCommentCharacterIndex$1,
  mapDoc: mapDoc$2,
  // TODO: remove in 2.0, we already exposed it in docUtils
  makeString: util$1.makeString,
  addLeadingComment: util$1.addLeadingComment,
  addDanglingComment: util$1.addDanglingComment,
  addTrailingComment: util$1.addTrailingComment
};

var _require$$0$builders = doc.builders;
var concat = _require$$0$builders.concat;
var hardline = _require$$0$builders.hardline;
var breakParent = _require$$0$builders.breakParent;
var indent = _require$$0$builders.indent;
var lineSuffix = _require$$0$builders.lineSuffix;
var join = _require$$0$builders.join;
var cursor = _require$$0$builders.cursor;
var hasNewline = util$1.hasNewline;
var skipNewline = util$1.skipNewline;
var isPreviousLineEmpty = util$1.isPreviousLineEmpty;
var addLeadingComment = utilShared.addLeadingComment;
var addDanglingComment = utilShared.addDanglingComment;
var addTrailingComment = utilShared.addTrailingComment;
var childNodesCacheKey = Symbol("child-nodes");

function getSortedChildNodes(node, options, resultArray) {
  if (!node) {
    return;
  }

  var printer = options.printer,
      locStart = options.locStart,
      locEnd = options.locEnd;

  if (resultArray) {
    if (node && printer.canAttachComment && printer.canAttachComment(node)) {
      // This reverse insertion sort almost always takes constant
      // time because we almost always (maybe always?) append the
      // nodes in order anyway.
      var i;

      for (i = resultArray.length - 1; i >= 0; --i) {
        if (locStart(resultArray[i]) <= locStart(node) && locEnd(resultArray[i]) <= locEnd(node)) {
          break;
        }
      }

      resultArray.splice(i + 1, 0, node);
      return;
    }
  } else if (node[childNodesCacheKey]) {
    return node[childNodesCacheKey];
  }

  var childNodes;

  if (printer.getCommentChildNodes) {
    childNodes = printer.getCommentChildNodes(node);
  } else if (node && typeof node === "object") {
    childNodes = Object.keys(node).filter(function (n) {
      return n !== "enclosingNode" && n !== "precedingNode" && n !== "followingNode";
    }).map(function (n) {
      return node[n];
    });
  }

  if (!childNodes) {
    return;
  }

  if (!resultArray) {
    Object.defineProperty(node, childNodesCacheKey, {
      value: resultArray = [],
      enumerable: false
    });
  }

  childNodes.forEach(function (childNode) {
    getSortedChildNodes(childNode, options, resultArray);
  });
  return resultArray;
} // As efficiently as possible, decorate the comment object with
// .precedingNode, .enclosingNode, and/or .followingNode properties, at
// least one of which is guaranteed to be defined.


function decorateComment(node, comment, options) {
  var locStart = options.locStart,
      locEnd = options.locEnd;
  var childNodes = getSortedChildNodes(node, options);
  var precedingNode;
  var followingNode; // Time to dust off the old binary search robes and wizard hat.

  var left = 0;
  var right = childNodes.length;

  while (left < right) {
    var middle = left + right >> 1;
    var child = childNodes[middle];

    if (locStart(child) - locStart(comment) <= 0 && locEnd(comment) - locEnd(child) <= 0) {
      // The comment is completely contained by this child node.
      comment.enclosingNode = child;
      decorateComment(child, comment, options);
      return; // Abandon the binary search at this level.
    }

    if (locEnd(child) - locStart(comment) <= 0) {
      // This child node falls completely before the comment.
      // Because we will never consider this node or any nodes
      // before it again, this node must be the closest preceding
      // node we have encountered so far.
      precedingNode = child;
      left = middle + 1;
      continue;
    }

    if (locEnd(comment) - locStart(child) <= 0) {
      // This child node falls completely after the comment.
      // Because we will never consider this node or any nodes after
      // it again, this node must be the closest following node we
      // have encountered so far.
      followingNode = child;
      right = middle;
      continue;
    }
    /* istanbul ignore next */


    throw new Error("Comment location overlaps with node location");
  } // We don't want comments inside of different expressions inside of the same
  // template literal to move to another expression.


  if (comment.enclosingNode && comment.enclosingNode.type === "TemplateLiteral") {
    var quasis = comment.enclosingNode.quasis;
    var commentIndex = findExpressionIndexForComment(quasis, comment, options);

    if (precedingNode && findExpressionIndexForComment(quasis, precedingNode, options) !== commentIndex) {
      precedingNode = null;
    }

    if (followingNode && findExpressionIndexForComment(quasis, followingNode, options) !== commentIndex) {
      followingNode = null;
    }
  }

  if (precedingNode) {
    comment.precedingNode = precedingNode;
  }

  if (followingNode) {
    comment.followingNode = followingNode;
  }
}

function attach(comments, ast, text, options) {
  if (!Array.isArray(comments)) {
    return;
  }

  var tiesToBreak = [];
  var locStart = options.locStart,
      locEnd = options.locEnd;
  comments.forEach(function (comment, i) {
    if (options.parser === "json" || options.parser === "json5" || options.parser === "__js_expression" || options.parser === "__vue_expression") {
      if (locStart(comment) - locStart(ast) <= 0) {
        addLeadingComment(ast, comment);
        return;
      }

      if (locEnd(comment) - locEnd(ast) >= 0) {
        addTrailingComment(ast, comment);
        return;
      }
    }

    decorateComment(ast, comment, options);
    var precedingNode = comment.precedingNode,
        enclosingNode = comment.enclosingNode,
        followingNode = comment.followingNode;
    var pluginHandleOwnLineComment = options.printer.handleComments && options.printer.handleComments.ownLine ? options.printer.handleComments.ownLine : function () {
      return false;
    };
    var pluginHandleEndOfLineComment = options.printer.handleComments && options.printer.handleComments.endOfLine ? options.printer.handleComments.endOfLine : function () {
      return false;
    };
    var pluginHandleRemainingComment = options.printer.handleComments && options.printer.handleComments.remaining ? options.printer.handleComments.remaining : function () {
      return false;
    };
    var isLastComment = comments.length - 1 === i;

    if (hasNewline(text, locStart(comment), {
      backwards: true
    })) {
      // If a comment exists on its own line, prefer a leading comment.
      // We also need to check if it's the first line of the file.
      if (pluginHandleOwnLineComment(comment, text, options, ast, isLastComment)) {// We're good
      } else if (followingNode) {
        // Always a leading comment.
        addLeadingComment(followingNode, comment);
      } else if (precedingNode) {
        addTrailingComment(precedingNode, comment);
      } else if (enclosingNode) {
        addDanglingComment(enclosingNode, comment);
      } else {
        // There are no nodes, let's attach it to the root of the ast

        /* istanbul ignore next */
        addDanglingComment(ast, comment);
      }
    } else if (hasNewline(text, locEnd(comment))) {
      if (pluginHandleEndOfLineComment(comment, text, options, ast, isLastComment)) {// We're good
      } else if (precedingNode) {
        // There is content before this comment on the same line, but
        // none after it, so prefer a trailing comment of the previous node.
        addTrailingComment(precedingNode, comment);
      } else if (followingNode) {
        addLeadingComment(followingNode, comment);
      } else if (enclosingNode) {
        addDanglingComment(enclosingNode, comment);
      } else {
        // There are no nodes, let's attach it to the root of the ast

        /* istanbul ignore next */
        addDanglingComment(ast, comment);
      }
    } else {
      if (pluginHandleRemainingComment(comment, text, options, ast, isLastComment)) {// We're good
      } else if (precedingNode && followingNode) {
        // Otherwise, text exists both before and after the comment on
        // the same line. If there is both a preceding and following
        // node, use a tie-breaking algorithm to determine if it should
        // be attached to the next or previous node. In the last case,
        // simply attach the right node;
        var tieCount = tiesToBreak.length;

        if (tieCount > 0) {
          var lastTie = tiesToBreak[tieCount - 1];

          if (lastTie.followingNode !== comment.followingNode) {
            breakTies(tiesToBreak, text, options);
          }
        }

        tiesToBreak.push(comment);
      } else if (precedingNode) {
        addTrailingComment(precedingNode, comment);
      } else if (followingNode) {
        addLeadingComment(followingNode, comment);
      } else if (enclosingNode) {
        addDanglingComment(enclosingNode, comment);
      } else {
        // There are no nodes, let's attach it to the root of the ast

        /* istanbul ignore next */
        addDanglingComment(ast, comment);
      }
    }
  });
  breakTies(tiesToBreak, text, options);
  comments.forEach(function (comment) {
    // These node references were useful for breaking ties, but we
    // don't need them anymore, and they create cycles in the AST that
    // may lead to infinite recursion if we don't delete them here.
    delete comment.precedingNode;
    delete comment.enclosingNode;
    delete comment.followingNode;
  });
}

function breakTies(tiesToBreak, text, options) {
  var tieCount = tiesToBreak.length;

  if (tieCount === 0) {
    return;
  }

  var _tiesToBreak$ = tiesToBreak[0],
      precedingNode = _tiesToBreak$.precedingNode,
      followingNode = _tiesToBreak$.followingNode;
  var gapEndPos = options.locStart(followingNode); // Iterate backwards through tiesToBreak, examining the gaps
  // between the tied comments. In order to qualify as leading, a
  // comment must be separated from followingNode by an unbroken series of
  // gaps (or other comments). Gaps should only contain whitespace or open
  // parentheses.

  var indexOfFirstLeadingComment;

  for (indexOfFirstLeadingComment = tieCount; indexOfFirstLeadingComment > 0; --indexOfFirstLeadingComment) {
    var comment = tiesToBreak[indexOfFirstLeadingComment - 1];
    assert.strictEqual(comment.precedingNode, precedingNode);
    assert.strictEqual(comment.followingNode, followingNode);
    var gap = text.slice(options.locEnd(comment), gapEndPos).trim();

    if (gap === "" || /^\(+$/.test(gap)) {
      gapEndPos = options.locStart(comment);
    } else {
      // The gap string contained something other than whitespace or open
      // parentheses.
      break;
    }
  }

  tiesToBreak.forEach(function (comment, i) {
    if (i < indexOfFirstLeadingComment) {
      addTrailingComment(precedingNode, comment);
    } else {
      addLeadingComment(followingNode, comment);
    }
  });
  tiesToBreak.length = 0;
}

function printComment(commentPath, options) {
  var comment = commentPath.getValue();
  comment.printed = true;
  return options.printer.printComment(commentPath, options);
}

function findExpressionIndexForComment(quasis, comment, options) {
  var startPos = options.locStart(comment) - 1;

  for (var i = 1; i < quasis.length; ++i) {
    if (startPos < getQuasiRange(quasis[i]).start) {
      return i - 1;
    }
  } // We haven't found it, it probably means that some of the locations are off.
  // Let's just return the first one.

  /* istanbul ignore next */


  return 0;
}

function getQuasiRange(expr) {
  if (expr.start !== undefined) {
    // Babel
    return {
      start: expr.start,
      end: expr.end
    };
  } // Flow


  return {
    start: expr.range[0],
    end: expr.range[1]
  };
}

function printLeadingComment(commentPath, print, options) {
  var comment = commentPath.getValue();
  var contents = printComment(commentPath, options);

  if (!contents) {
    return "";
  }

  var isBlock = options.printer.isBlockComment && options.printer.isBlockComment(comment); // Leading block comments should see if they need to stay on the
  // same line or not.

  if (isBlock) {
    return concat([contents, hasNewline(options.originalText, options.locEnd(comment)) ? hardline : " "]);
  }

  return concat([contents, hardline]);
}

function printTrailingComment(commentPath, print, options) {
  var comment = commentPath.getValue();
  var contents = printComment(commentPath, options);

  if (!contents) {
    return "";
  }

  var isBlock = options.printer.isBlockComment && options.printer.isBlockComment(comment); // We don't want the line to break
  // when the parentParentNode is a ClassDeclaration/-Expression
  // And the parentNode is in the superClass property

  var parentNode = commentPath.getNode(1);
  var parentParentNode = commentPath.getNode(2);
  var isParentSuperClass = parentParentNode && (parentParentNode.type === "ClassDeclaration" || parentParentNode.type === "ClassExpression") && parentParentNode.superClass === parentNode;

  if (hasNewline(options.originalText, options.locStart(comment), {
    backwards: true
  })) {
    // This allows comments at the end of nested structures:
    // {
    //   x: 1,
    //   y: 2
    //   // A comment
    // }
    // Those kinds of comments are almost always leading comments, but
    // here it doesn't go "outside" the block and turns it into a
    // trailing comment for `2`. We can simulate the above by checking
    // if this a comment on its own line; normal trailing comments are
    // always at the end of another expression.
    var isLineBeforeEmpty = isPreviousLineEmpty(options.originalText, comment, options.locStart);
    return lineSuffix(concat([hardline, isLineBeforeEmpty ? hardline : "", contents]));
  } else if (isBlock || isParentSuperClass) {
    // Trailing block comments never need a newline
    return concat([" ", contents]);
  }

  return concat([lineSuffix(concat([" ", contents])), !isBlock ? breakParent : ""]);
}

function printDanglingComments(path$$1, options, sameIndent, filter) {
  var parts = [];
  var node = path$$1.getValue();

  if (!node || !node.comments) {
    return "";
  }

  path$$1.each(function (commentPath) {
    var comment = commentPath.getValue();

    if (comment && !comment.leading && !comment.trailing && (!filter || filter(comment))) {
      parts.push(printComment(commentPath, options));
    }
  }, "comments");

  if (parts.length === 0) {
    return "";
  }

  if (sameIndent) {
    return join(hardline, parts);
  }

  return indent(concat([hardline, join(hardline, parts)]));
}

function prependCursorPlaceholder(path$$1, options, printed) {
  if (path$$1.getNode() === options.cursorNode && path$$1.getValue()) {
    return concat([cursor, printed, cursor]);
  }

  return printed;
}

function printComments(path$$1, print, options, needsSemi) {
  var value = path$$1.getValue();
  var printed = print(path$$1);
  var comments = value && value.comments;

  if (!comments || comments.length === 0) {
    return prependCursorPlaceholder(path$$1, options, printed);
  }

  var leadingParts = [];
  var trailingParts = [needsSemi ? ";" : "", printed];
  path$$1.each(function (commentPath) {
    var comment = commentPath.getValue();
    var leading = comment.leading,
        trailing = comment.trailing;

    if (leading) {
      var contents = printLeadingComment(commentPath, print, options);

      if (!contents) {
        return;
      }

      leadingParts.push(contents);
      var text = options.originalText;

      if (hasNewline(text, skipNewline(text, options.locEnd(comment)))) {
        leadingParts.push(hardline);
      }
    } else if (trailing) {
      trailingParts.push(printTrailingComment(commentPath, print, options));
    }
  }, "comments");
  return prependCursorPlaceholder(path$$1, options, concat(leadingParts.concat(trailingParts)));
}

var comments = {
  attach,
  printComments,
  printDanglingComments,
  getSortedChildNodes
};

function FastPath(value) {
  assert.ok(this instanceof FastPath);
  this.stack = [value];
} // The name of the current property is always the penultimate element of
// this.stack, and always a String.


FastPath.prototype.getName = function getName() {
  var s = this.stack;
  var len = s.length;

  if (len > 1) {
    return s[len - 2];
  } // Since the name is always a string, null is a safe sentinel value to
  // return if we do not know the name of the (root) value.

  /* istanbul ignore next */


  return null;
}; // The value of the current property is always the final element of
// this.stack.


FastPath.prototype.getValue = function getValue() {
  var s = this.stack;
  return s[s.length - 1];
};

function getNodeHelper(path$$1, count) {
  var stackIndex = getNodeStackIndexHelper(path$$1.stack, count);
  return stackIndex === -1 ? null : path$$1.stack[stackIndex];
}

function getNodeStackIndexHelper(stack, count) {
  for (var i = stack.length - 1; i >= 0; i -= 2) {
    var value = stack[i];

    if (value && !Array.isArray(value) && --count < 0) {
      return i;
    }
  }

  return -1;
}

FastPath.prototype.getNode = function getNode(count) {
  return getNodeHelper(this, ~~count);
};

FastPath.prototype.getParentNode = function getParentNode(count) {
  return getNodeHelper(this, ~~count + 1);
}; // Temporarily push properties named by string arguments given after the
// callback function onto this.stack, then call the callback with a
// reference to this (modified) FastPath object. Note that the stack will
// be restored to its original state after the callback is finished, so it
// is probably a mistake to retain a reference to the path.


FastPath.prototype.call = function call(callback
/*, name1, name2, ... */
) {
  var s = this.stack;
  var origLen = s.length;
  var value = s[origLen - 1];
  var argc = arguments.length;

  for (var i = 1; i < argc; ++i) {
    var name = arguments[i];
    value = value[name];
    s.push(name, value);
  }

  var result = callback(this);
  s.length = origLen;
  return result;
};

FastPath.prototype.callParent = function callParent(callback, count) {
  var stackIndex = getNodeStackIndexHelper(this.stack, ~~count + 1);
  var parentValues = this.stack.splice(stackIndex + 1);
  var result = callback(this);
  Array.prototype.push.apply(this.stack, parentValues);
  return result;
}; // Similar to FastPath.prototype.call, except that the value obtained by
// accessing this.getValue()[name1][name2]... should be array-like. The
// callback will be called with a reference to this path object for each
// element of the array.


FastPath.prototype.each = function each(callback
/*, name1, name2, ... */
) {
  var s = this.stack;
  var origLen = s.length;
  var value = s[origLen - 1];
  var argc = arguments.length;

  for (var i = 1; i < argc; ++i) {
    var name = arguments[i];
    value = value[name];
    s.push(name, value);
  }

  for (var _i = 0; _i < value.length; ++_i) {
    if (_i in value) {
      s.push(_i, value[_i]); // If the callback needs to know the value of i, call
      // path.getName(), assuming path is the parameter name.

      callback(this);
      s.length -= 2;
    }
  }

  s.length = origLen;
}; // Similar to FastPath.prototype.each, except that the results of the
// callback function invocations are stored in an array and returned at
// the end of the iteration.


FastPath.prototype.map = function map(callback
/*, name1, name2, ... */
) {
  var s = this.stack;
  var origLen = s.length;
  var value = s[origLen - 1];
  var argc = arguments.length;

  for (var i = 1; i < argc; ++i) {
    var name = arguments[i];
    value = value[name];
    s.push(name, value);
  }

  var result = new Array(value.length);

  for (var _i2 = 0; _i2 < value.length; ++_i2) {
    if (_i2 in value) {
      s.push(_i2, value[_i2]);
      result[_i2] = callback(this, _i2);
      s.length -= 2;
    }
  }

  s.length = origLen;
  return result;
};

var fastPath = FastPath;

var normalize$3 = options.normalize;

function printSubtree(path$$1, print, options$$1, printAstToDoc) {
  if (options$$1.printer.embed) {
    return options$$1.printer.embed(path$$1, print, function (text, partialNextOptions) {
      return textToDoc(text, partialNextOptions, options$$1, printAstToDoc);
    }, options$$1);
  }
}

function textToDoc(text, partialNextOptions, parentOptions, printAstToDoc) {
  var nextOptions = normalize$3(Object.assign({}, parentOptions, partialNextOptions, {
    parentParser: parentOptions.parser,
    embeddedInHtml: !!(parentOptions.embeddedInHtml || parentOptions.parser === "html" || parentOptions.parser === "vue" || parentOptions.parser === "angular" || parentOptions.parser === "lwc"),
    originalText: text
  }), {
    passThrough: true
  });
  var result = parser.parse(text, nextOptions);
  var ast = result.ast;
  text = result.text;
  var astComments = ast.comments;
  delete ast.comments;
  comments.attach(astComments, ast, text, nextOptions);
  return printAstToDoc(ast, nextOptions);
}

var multiparser = {
  printSubtree
};

var doc$2 = doc;
var docBuilders$2 = doc$2.builders;
var concat$3 = docBuilders$2.concat;
var hardline$2 = docBuilders$2.hardline;
var addAlignmentToDoc$1 = docBuilders$2.addAlignmentToDoc;
var docUtils$2 = doc$2.utils;
/**
 * Takes an abstract syntax tree (AST) and recursively converts it to a
 * document (series of printing primitives).
 *
 * This is done by descending down the AST recursively. The recursion
 * involves two functions that call each other:
 *
 * 1. printGenerically(), which is defined as an inner function here.
 *    It basically takes care of node caching.
 * 2. callPluginPrintFunction(), which checks for some options, and
 *    ultimately calls the print() function provided by the plugin.
 *
 * The plugin function will call printGenerically() again for child nodes
 * of the current node, which will do its housekeeping, then call the
 * plugin function again, and so on.
 *
 * All the while, these functions pass a "path" variable around, which
 * is a stack-like data structure (FastPath) that maintains the current
 * state of the recursion. It is called "path", because it represents
 * the path to the current node through the Abstract Syntax Tree.
 */

function printAstToDoc(ast, options) {
  var alignmentSize = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
  var printer = options.printer;

  if (printer.preprocess) {
    ast = printer.preprocess(ast, options);
  }

  var cache = new Map();

  function printGenerically(path$$1, args) {
    var node = path$$1.getValue();
    var shouldCache = node && typeof node === "object" && args === undefined;

    if (shouldCache && cache.has(node)) {
      return cache.get(node);
    } // We let JSXElement print its comments itself because it adds () around
    // UnionTypeAnnotation has to align the child without the comments


    var res;

    if (printer.willPrintOwnComments && printer.willPrintOwnComments(path$$1, options)) {
      res = callPluginPrintFunction(path$$1, options, printGenerically, args);
    } else {
      // printComments will call the plugin print function and check for
      // comments to print
      res = comments.printComments(path$$1, function (p) {
        return callPluginPrintFunction(p, options, printGenerically, args);
      }, options, args && args.needsSemi);
    }

    if (shouldCache) {
      cache.set(node, res);
    }

    return res;
  }

  var doc$$2 = printGenerically(new fastPath(ast));

  if (alignmentSize > 0) {
    // Add a hardline to make the indents take effect
    // It should be removed in index.js format()
    doc$$2 = addAlignmentToDoc$1(concat$3([hardline$2, doc$$2]), alignmentSize, options.tabWidth);
  }

  docUtils$2.propagateBreaks(doc$$2);
  return doc$$2;
}

function callPluginPrintFunction(path$$1, options, printPath, args) {
  assert.ok(path$$1 instanceof fastPath);
  var node = path$$1.getValue();
  var printer = options.printer; // Escape hatch

  if (printer.hasPrettierIgnore && printer.hasPrettierIgnore(path$$1)) {
    return options.originalText.slice(options.locStart(node), options.locEnd(node));
  }

  if (node) {
    try {
      // Potentially switch to a different parser
      var sub = multiparser.printSubtree(path$$1, printPath, options, printAstToDoc);

      if (sub) {
        return sub;
      }
    } catch (error) {
      /* istanbul ignore if */
      if (process.env.PRETTIER_DEBUG) {
        throw error;
      } // Continue with current parser

    }
  }

  return printer.print(path$$1, options, printPath, args);
}

var astToDoc = printAstToDoc;

function findSiblingAncestors(startNodeAndParents, endNodeAndParents, opts) {
  var resultStartNode = startNodeAndParents.node;
  var resultEndNode = endNodeAndParents.node;

  if (resultStartNode === resultEndNode) {
    return {
      startNode: resultStartNode,
      endNode: resultEndNode
    };
  }

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = endNodeAndParents.parentNodes[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var endParent = _step.value;

      if (endParent.type !== "Program" && endParent.type !== "File" && opts.locStart(endParent) >= opts.locStart(startNodeAndParents.node)) {
        resultEndNode = endParent;
      } else {
        break;
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = startNodeAndParents.parentNodes[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var startParent = _step2.value;

      if (startParent.type !== "Program" && startParent.type !== "File" && opts.locEnd(startParent) <= opts.locEnd(endNodeAndParents.node)) {
        resultStartNode = startParent;
      } else {
        break;
      }
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
        _iterator2.return();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  return {
    startNode: resultStartNode,
    endNode: resultEndNode
  };
}

function findNodeAtOffset(node, offset, options, predicate, parentNodes) {
  predicate = predicate || function () {
    return true;
  };

  parentNodes = parentNodes || [];
  var start = options.locStart(node, options.locStart);
  var end = options.locEnd(node, options.locEnd);

  if (start <= offset && offset <= end) {
    var _iteratorNormalCompletion3 = true;
    var _didIteratorError3 = false;
    var _iteratorError3 = undefined;

    try {
      for (var _iterator3 = comments.getSortedChildNodes(node, options)[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
        var childNode = _step3.value;
        var childResult = findNodeAtOffset(childNode, offset, options, predicate, [node].concat(parentNodes));

        if (childResult) {
          return childResult;
        }
      }
    } catch (err) {
      _didIteratorError3 = true;
      _iteratorError3 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
          _iterator3.return();
        }
      } finally {
        if (_didIteratorError3) {
          throw _iteratorError3;
        }
      }
    }

    if (predicate(node)) {
      return {
        node: node,
        parentNodes: parentNodes
      };
    }
  }
} // See https://www.ecma-international.org/ecma-262/5.1/#sec-A.5


function isSourceElement(opts, node) {
  if (node == null) {
    return false;
  } // JS and JS like to avoid repetitions


  var jsSourceElements = ["FunctionDeclaration", "BlockStatement", "BreakStatement", "ContinueStatement", "DebuggerStatement", "DoWhileStatement", "EmptyStatement", "ExpressionStatement", "ForInStatement", "ForStatement", "IfStatement", "LabeledStatement", "ReturnStatement", "SwitchStatement", "ThrowStatement", "TryStatement", "VariableDeclaration", "WhileStatement", "WithStatement", "ClassDeclaration", // ES 2015
  "ImportDeclaration", // Module
  "ExportDefaultDeclaration", // Module
  "ExportNamedDeclaration", // Module
  "ExportAllDeclaration", // Module
  "TypeAlias", // Flow
  "InterfaceDeclaration", // Flow, TypeScript
  "TypeAliasDeclaration", // TypeScript
  "ExportAssignment", // TypeScript
  "ExportDeclaration" // TypeScript
  ];
  var jsonSourceElements = ["ObjectExpression", "ArrayExpression", "StringLiteral", "NumericLiteral", "BooleanLiteral", "NullLiteral"];
  var graphqlSourceElements = ["OperationDefinition", "FragmentDefinition", "VariableDefinition", "TypeExtensionDefinition", "ObjectTypeDefinition", "FieldDefinition", "DirectiveDefinition", "EnumTypeDefinition", "EnumValueDefinition", "InputValueDefinition", "InputObjectTypeDefinition", "SchemaDefinition", "OperationTypeDefinition", "InterfaceTypeDefinition", "UnionTypeDefinition", "ScalarTypeDefinition"];

  switch (opts.parser) {
    case "flow":
    case "babel":
    case "typescript":
      return jsSourceElements.indexOf(node.type) > -1;

    case "json":
      return jsonSourceElements.indexOf(node.type) > -1;

    case "graphql":
      return graphqlSourceElements.indexOf(node.kind) > -1;

    case "vue":
      return node.tag !== "root";
  }

  return false;
}

function calculateRange(text, opts, ast) {
  // Contract the range so that it has non-whitespace characters at its endpoints.
  // This ensures we can format a range that doesn't end on a node.
  var rangeStringOrig = text.slice(opts.rangeStart, opts.rangeEnd);
  var startNonWhitespace = Math.max(opts.rangeStart + rangeStringOrig.search(/\S/), opts.rangeStart);
  var endNonWhitespace;

  for (endNonWhitespace = opts.rangeEnd; endNonWhitespace > opts.rangeStart; --endNonWhitespace) {
    if (text[endNonWhitespace - 1].match(/\S/)) {
      break;
    }
  }

  var startNodeAndParents = findNodeAtOffset(ast, startNonWhitespace, opts, function (node) {
    return isSourceElement(opts, node);
  });
  var endNodeAndParents = findNodeAtOffset(ast, endNonWhitespace, opts, function (node) {
    return isSourceElement(opts, node);
  });

  if (!startNodeAndParents || !endNodeAndParents) {
    return {
      rangeStart: 0,
      rangeEnd: 0
    };
  }

  var siblingAncestors = findSiblingAncestors(startNodeAndParents, endNodeAndParents, opts);
  var startNode = siblingAncestors.startNode,
      endNode = siblingAncestors.endNode;
  var rangeStart = Math.min(opts.locStart(startNode, opts.locStart), opts.locStart(endNode, opts.locStart));
  var rangeEnd = Math.max(opts.locEnd(startNode, opts.locEnd), opts.locEnd(endNode, opts.locEnd));
  return {
    rangeStart: rangeStart,
    rangeEnd: rangeEnd
  };
}

var rangeUtil = {
  calculateRange,
  findNodeAtOffset
};

var normalizeOptions = options.normalize;
var guessEndOfLine = endOfLine.guessEndOfLine;
var convertEndOfLineToChars = endOfLine.convertEndOfLineToChars;
var mapDoc = doc.utils.mapDoc;
var printDocToString = doc.printer.printDocToString;
var printDocToDebug = doc.debug.printDocToDebug;
var UTF8BOM = 0xfeff;
var CURSOR = Symbol("cursor");
var PLACEHOLDERS = {
  cursorOffset: "<<<PRETTIER_CURSOR>>>",
  rangeStart: "<<<PRETTIER_RANGE_START>>>",
  rangeEnd: "<<<PRETTIER_RANGE_END>>>"
};

function ensureAllCommentsPrinted(astComments) {
  if (!astComments) {
    return;
  }

  for (var i = 0; i < astComments.length; ++i) {
    if (astComments[i].value.trim() === "prettier-ignore") {
      // If there's a prettier-ignore, we're not printing that sub-tree so we
      // don't know if the comments was printed or not.
      return;
    }
  }

  astComments.forEach(function (comment) {
    if (!comment.printed) {
      throw new Error('Comment "' + comment.value.trim() + '" was not printed. Please report this error!');
    }

    delete comment.printed;
  });
}

function attachComments(text, ast, opts) {
  var astComments = ast.comments;

  if (astComments) {
    delete ast.comments;
    comments.attach(astComments, ast, text, opts);
  }

  ast.tokens = [];
  opts.originalText = opts.parser === "yaml" ? text : text.trimRight();
  return astComments;
}

function coreFormat(text, opts, addAlignmentSize) {
  if (!text || !text.trim().length) {
    return {
      formatted: "",
      cursorOffset: 0
    };
  }

  addAlignmentSize = addAlignmentSize || 0;
  var parsed = parser.parse(text, opts);
  var ast = parsed.ast;
  text = parsed.text;

  if (opts.cursorOffset >= 0) {
    var nodeResult = rangeUtil.findNodeAtOffset(ast, opts.cursorOffset, opts);

    if (nodeResult && nodeResult.node) {
      opts.cursorNode = nodeResult.node;
    }
  }

  var astComments = attachComments(text, ast, opts);
  var doc$$1 = astToDoc(ast, opts, addAlignmentSize);
  var eol = convertEndOfLineToChars(opts.endOfLine);
  var result = printDocToString(opts.endOfLine === "lf" ? doc$$1 : mapDoc(doc$$1, function (currentDoc) {
    return typeof currentDoc === "string" && currentDoc.indexOf("\n") !== -1 ? currentDoc.replace(/\n/g, eol) : currentDoc;
  }), opts);
  ensureAllCommentsPrinted(astComments); // Remove extra leading indentation as well as the added indentation after last newline

  if (addAlignmentSize > 0) {
    var trimmed = result.formatted.trim();

    if (result.cursorNodeStart !== undefined) {
      result.cursorNodeStart -= result.formatted.indexOf(trimmed);
    }

    result.formatted = trimmed + convertEndOfLineToChars(opts.endOfLine);
  }

  if (opts.cursorOffset >= 0) {
    var oldCursorNodeStart;
    var oldCursorNodeText;
    var cursorOffsetRelativeToOldCursorNode;
    var newCursorNodeStart;
    var newCursorNodeText;

    if (opts.cursorNode && result.cursorNodeText) {
      oldCursorNodeStart = opts.locStart(opts.cursorNode);
      oldCursorNodeText = text.slice(oldCursorNodeStart, opts.locEnd(opts.cursorNode));
      cursorOffsetRelativeToOldCursorNode = opts.cursorOffset - oldCursorNodeStart;
      newCursorNodeStart = result.cursorNodeStart;
      newCursorNodeText = result.cursorNodeText;
    } else {
      oldCursorNodeStart = 0;
      oldCursorNodeText = text;
      cursorOffsetRelativeToOldCursorNode = opts.cursorOffset;
      newCursorNodeStart = 0;
      newCursorNodeText = result.formatted;
    }

    if (oldCursorNodeText === newCursorNodeText) {
      return {
        formatted: result.formatted,
        cursorOffset: newCursorNodeStart + cursorOffsetRelativeToOldCursorNode
      };
    } // diff old and new cursor node texts, with a special cursor
    // symbol inserted to find out where it moves to


    var oldCursorNodeCharArray = oldCursorNodeText.split("");
    oldCursorNodeCharArray.splice(cursorOffsetRelativeToOldCursorNode, 0, CURSOR);
    var newCursorNodeCharArray = newCursorNodeText.split("");
    var cursorNodeDiff = lib.diffArrays(oldCursorNodeCharArray, newCursorNodeCharArray);
    var cursorOffset = newCursorNodeStart;
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = cursorNodeDiff[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var entry = _step.value;

        if (entry.removed) {
          if (entry.value.indexOf(CURSOR) > -1) {
            break;
          }
        } else {
          cursorOffset += entry.count;
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return {
      formatted: result.formatted,
      cursorOffset
    };
  }

  return {
    formatted: result.formatted
  };
}

function formatRange(text, opts) {
  var parsed = parser.parse(text, opts);
  var ast = parsed.ast;
  text = parsed.text;
  var range = rangeUtil.calculateRange(text, opts, ast);
  var rangeStart = range.rangeStart;
  var rangeEnd = range.rangeEnd;
  var rangeString = text.slice(rangeStart, rangeEnd); // Try to extend the range backwards to the beginning of the line.
  // This is so we can detect indentation correctly and restore it.
  // Use `Math.min` since `lastIndexOf` returns 0 when `rangeStart` is 0

  var rangeStart2 = Math.min(rangeStart, text.lastIndexOf("\n", rangeStart) + 1);
  var indentString = text.slice(rangeStart2, rangeStart);
  var alignmentSize = util$1.getAlignmentSize(indentString, opts.tabWidth);
  var rangeResult = coreFormat(rangeString, Object.assign({}, opts, {
    rangeStart: 0,
    rangeEnd: Infinity,
    // track the cursor offset only if it's within our range
    cursorOffset: opts.cursorOffset >= rangeStart && opts.cursorOffset < rangeEnd ? opts.cursorOffset - rangeStart : -1
  }), alignmentSize); // Since the range contracts to avoid trailing whitespace,
  // we need to remove the newline that was inserted by the `format` call.

  var rangeTrimmed = rangeResult.formatted.trimRight();
  var rangeLeft = text.slice(0, rangeStart);
  var rangeRight = text.slice(rangeEnd);
  var cursorOffset = opts.cursorOffset;

  if (opts.cursorOffset >= rangeEnd) {
    // handle the case where the cursor was past the end of the range
    cursorOffset = opts.cursorOffset - rangeEnd + (rangeStart + rangeTrimmed.length);
  } else if (rangeResult.cursorOffset !== undefined) {
    // handle the case where the cursor was in the range
    cursorOffset = rangeResult.cursorOffset + rangeStart;
  } // keep the cursor as it was if it was before the start of the range


  var formatted;

  if (opts.endOfLine === "lf") {
    formatted = rangeLeft + rangeTrimmed + rangeRight;
  } else {
    var eol = convertEndOfLineToChars(opts.endOfLine);

    if (cursorOffset >= 0) {
      var parts = [rangeLeft, rangeTrimmed, rangeRight];
      var partIndex = 0;
      var partOffset = cursorOffset;

      while (partIndex < parts.length) {
        var part = parts[partIndex];

        if (partOffset < part.length) {
          parts[partIndex] = parts[partIndex].slice(0, partOffset) + PLACEHOLDERS.cursorOffset + parts[partIndex].slice(partOffset);
          break;
        }

        partIndex++;
        partOffset -= part.length;
      }

      var newRangeLeft = parts[0],
          newRangeTrimmed = parts[1],
          newRangeRight = parts[2];
      formatted = (newRangeLeft.replace(/\n/g, eol) + newRangeTrimmed + newRangeRight.replace(/\n/g, eol)).replace(PLACEHOLDERS.cursorOffset, function (_, index) {
        cursorOffset = index;
        return "";
      });
    } else {
      formatted = rangeLeft.replace(/\n/g, eol) + rangeTrimmed + rangeRight.replace(/\n/g, eol);
    }
  }

  return {
    formatted,
    cursorOffset
  };
}

function format(text, opts) {
  var selectedParser = parser.resolveParser(opts);
  var hasPragma = !selectedParser.hasPragma || selectedParser.hasPragma(text);

  if (opts.requirePragma && !hasPragma) {
    return {
      formatted: text
    };
  }

  if (opts.endOfLine === "auto") {
    opts.endOfLine = guessEndOfLine(text);
  }

  var hasCursor = opts.cursorOffset >= 0;
  var hasRangeStart = opts.rangeStart > 0;
  var hasRangeEnd = opts.rangeEnd < text.length; // get rid of CR/CRLF parsing

  if (text.indexOf("\r") !== -1) {
    var offsetKeys = [hasCursor && "cursorOffset", hasRangeStart && "rangeStart", hasRangeEnd && "rangeEnd"].filter(Boolean).sort(function (aKey, bKey) {
      return opts[aKey] - opts[bKey];
    });

    for (var i = offsetKeys.length - 1; i >= 0; i--) {
      var key = offsetKeys[i];
      text = text.slice(0, opts[key]) + PLACEHOLDERS[key] + text.slice(opts[key]);
    }

    text = text.replace(/\r\n?/g, "\n");

    var _loop = function _loop(_i) {
      var key = offsetKeys[_i];
      text = text.replace(PLACEHOLDERS[key], function (_, index) {
        opts[key] = index;
        return "";
      });
    };

    for (var _i = 0; _i < offsetKeys.length; _i++) {
      _loop(_i);
    }
  }

  var hasUnicodeBOM = text.charCodeAt(0) === UTF8BOM;

  if (hasUnicodeBOM) {
    text = text.substring(1);

    if (hasCursor) {
      opts.cursorOffset++;
    }

    if (hasRangeStart) {
      opts.rangeStart++;
    }

    if (hasRangeEnd) {
      opts.rangeEnd++;
    }
  }

  if (!hasCursor) {
    opts.cursorOffset = -1;
  }

  if (opts.rangeStart < 0) {
    opts.rangeStart = 0;
  }

  if (opts.rangeEnd > text.length) {
    opts.rangeEnd = text.length;
  }

  var result = hasRangeStart || hasRangeEnd ? formatRange(text, opts) : coreFormat(opts.insertPragma && opts.printer.insertPragma && !hasPragma ? opts.printer.insertPragma(text) : text, opts);

  if (hasUnicodeBOM) {
    result.formatted = String.fromCharCode(UTF8BOM) + result.formatted;

    if (hasCursor) {
      result.cursorOffset++;
    }
  }

  return result;
}

var core = {
  formatWithCursor(text, opts) {
    opts = normalizeOptions(opts);
    return format(text, opts);
  },

  parse(text, opts, massage) {
    opts = normalizeOptions(opts);

    if (text.indexOf("\r") !== -1) {
      text = text.replace(/\r\n?/g, "\n");
    }

    var parsed = parser.parse(text, opts);

    if (massage) {
      parsed.ast = massageAst(parsed.ast, opts);
    }

    return parsed;
  },

  formatAST(ast, opts) {
    opts = normalizeOptions(opts);
    var doc$$1 = astToDoc(ast, opts);
    return printDocToString(doc$$1, opts);
  },

  // Doesn't handle shebang for now
  formatDoc(doc$$1, opts) {
    var debug = printDocToDebug(doc$$1);
    opts = normalizeOptions(Object.assign({}, opts, {
      parser: "babel"
    }));
    return format(debug, opts).formatted;
  },

  printToDoc(text, opts) {
    opts = normalizeOptions(opts);
    var parsed = parser.parse(text, opts);
    var ast = parsed.ast;
    text = parsed.text;
    attachComments(text, ast, opts);
    return astToDoc(ast, opts);
  },

  printDocToString(doc$$1, opts) {
    return printDocToString(doc$$1, normalizeOptions(opts));
  }

};

var ignore = createCommonjsModule(function (module) {
  // A simple implementation of make-array
  function make_array(subject) {
    return Array.isArray(subject) ? subject : [subject];
  }

  var REGEX_BLANK_LINE = /^\s+$/;
  var REGEX_LEADING_EXCAPED_EXCLAMATION = /^\\!/;
  var REGEX_LEADING_EXCAPED_HASH = /^\\#/;
  var SLASH = '/';
  var KEY_IGNORE = typeof Symbol !== 'undefined' ? Symbol.for('node-ignore')
  /* istanbul ignore next */
  : 'node-ignore';

  var define = function define(object, key, value) {
    return Object.defineProperty(object, key, {
      value
    });
  };

  var REGEX_REGEXP_RANGE = /([0-z])-([0-z])/g; // Sanitize the range of a regular expression
  // The cases are complicated, see test cases for details

  var sanitizeRange = function sanitizeRange(range) {
    return range.replace(REGEX_REGEXP_RANGE, function (match, from, to) {
      return from.charCodeAt(0) <= to.charCodeAt(0) ? match // Invalid range (out of order) which is ok for gitignore rules but
      //   fatal for JavaScript regular expression, so eliminate it.
      : '';
    });
  }; // > If the pattern ends with a slash,
  // > it is removed for the purpose of the following description,
  // > but it would only find a match with a directory.
  // > In other words, foo/ will match a directory foo and paths underneath it,
  // > but will not match a regular file or a symbolic link foo
  // >  (this is consistent with the way how pathspec works in general in Git).
  // '`foo/`' will not match regular file '`foo`' or symbolic link '`foo`'
  // -> ignore-rules will not deal with it, because it costs extra `fs.stat` call
  //      you could use option `mark: true` with `glob`
  // '`foo/`' should not continue with the '`..`'


  var DEFAULT_REPLACER_PREFIX = [// > Trailing spaces are ignored unless they are quoted with backslash ("\")
  [// (a\ ) -> (a )
  // (a  ) -> (a)
  // (a \ ) -> (a  )
  /\\?\s+$/, function (match) {
    return match.indexOf('\\') === 0 ? ' ' : '';
  }], // replace (\ ) with ' '
  [/\\\s/g, function () {
    return ' ';
  }], // Escape metacharacters
  // which is written down by users but means special for regular expressions.
  // > There are 12 characters with special meanings:
  // > - the backslash \,
  // > - the caret ^,
  // > - the dollar sign $,
  // > - the period or dot .,
  // > - the vertical bar or pipe symbol |,
  // > - the question mark ?,
  // > - the asterisk or star *,
  // > - the plus sign +,
  // > - the opening parenthesis (,
  // > - the closing parenthesis ),
  // > - and the opening square bracket [,
  // > - the opening curly brace {,
  // > These special characters are often called "metacharacters".
  [/[\\^$.|*+(){]/g, function (match) {
    return `\\${match}`;
  }], [// > [abc] matches any character inside the brackets
  // >    (in this case a, b, or c);
  /\[([^\]/]*)($|\])/g, function (match, p1, p2) {
    return p2 === ']' ? `[${sanitizeRange(p1)}]` : `\\${match}`;
  }], [// > a question mark (?) matches a single character
  /(?!\\)\?/g, function () {
    return '[^/]';
  }], // leading slash
  [// > A leading slash matches the beginning of the pathname.
  // > For example, "/*.c" matches "cat-file.c" but not "mozilla-sha1/sha1.c".
  // A leading slash matches the beginning of the pathname
  /^\//, function () {
    return '^';
  }], // replace special metacharacter slash after the leading slash
  [/\//g, function () {
    return '\\/';
  }], [// > A leading "**" followed by a slash means match in all directories.
  // > For example, "**/foo" matches file or directory "foo" anywhere,
  // > the same as pattern "foo".
  // > "**/foo/bar" matches file or directory "bar" anywhere that is directly
  // >   under directory "foo".
  // Notice that the '*'s have been replaced as '\\*'
  /^\^*\\\*\\\*\\\//, // '**/foo' <-> 'foo'
  function () {
    return '^(?:.*\\/)?';
  }]];
  var DEFAULT_REPLACER_SUFFIX = [// starting
  [// there will be no leading '/'
  //   (which has been replaced by section "leading slash")
  // If starts with '**', adding a '^' to the regular expression also works
  /^(?=[^^])/, function startingReplacer() {
    return !/\/(?!$)/.test(this) // > If the pattern does not contain a slash /,
    // >   Git treats it as a shell glob pattern
    // Actually, if there is only a trailing slash,
    //   git also treats it as a shell glob pattern
    ? '(?:^|\\/)' // > Otherwise, Git treats the pattern as a shell glob suitable for
    // >   consumption by fnmatch(3)
    : '^';
  }], // two globstars
  [// Use lookahead assertions so that we could match more than one `'/**'`
  /\\\/\\\*\\\*(?=\\\/|$)/g, // Zero, one or several directories
  // should not use '*', or it will be replaced by the next replacer
  // Check if it is not the last `'/**'`
  function (match, index, str) {
    return index + 6 < str.length // case: /**/
    // > A slash followed by two consecutive asterisks then a slash matches
    // >   zero or more directories.
    // > For example, "a/**/b" matches "a/b", "a/x/b", "a/x/y/b" and so on.
    // '/**/'
    ? '(?:\\/[^\\/]+)*' // case: /**
    // > A trailing `"/**"` matches everything inside.
    // #21: everything inside but it should not include the current folder
    : '\\/.+';
  }], // intermediate wildcards
  [// Never replace escaped '*'
  // ignore rule '\*' will match the path '*'
  // 'abc.*/' -> go
  // 'abc.*'  -> skip this rule
  /(^|[^\\]+)\\\*(?=.+)/g, // '*.js' matches '.js'
  // '*.js' doesn't match 'abc'
  function (match, p1) {
    return `${p1}[^\\/]*`;
  }], // trailing wildcard
  [/(\^|\\\/)?\\\*$/, function (match, p1) {
    var prefix = p1 // '\^':
    // '/*' does not match ''
    // '/*' does not match everything
    // '\\\/':
    // 'abc/*' does not match 'abc/'
    ? `${p1}[^/]+` // 'a*' matches 'a'
    // 'a*' matches 'aa'
    : '[^/]*';
    return `${prefix}(?=$|\\/$)`;
  }], [// unescape
  /\\\\\\/g, function () {
    return '\\';
  }]];
  var POSITIVE_REPLACERS = DEFAULT_REPLACER_PREFIX.concat([// 'f'
  // matches
  // - /f(end)
  // - /f/
  // - (start)f(end)
  // - (start)f/
  // doesn't match
  // - oof
  // - foo
  // pseudo:
  // -> (^|/)f(/|$)
  // ending
  [// 'js' will not match 'js.'
  // 'ab' will not match 'abc'
  /(?:[^*/])$/, // 'js*' will not match 'a.js'
  // 'js/' will not match 'a.js'
  // 'js' will match 'a.js' and 'a.js/'
  function (match) {
    return `${match}(?=$|\\/)`;
  }]], DEFAULT_REPLACER_SUFFIX);
  var NEGATIVE_REPLACERS = DEFAULT_REPLACER_PREFIX.concat([// #24, #38
  // The MISSING rule of [gitignore docs](https://git-scm.com/docs/gitignore)
  // A negative pattern without a trailing wildcard should not
  // re-include the things inside that directory.
  // eg:
  // ['node_modules/*', '!node_modules']
  // should ignore `node_modules/a.js`
  [/(?:[^*])$/, function (match) {
    return `${match}(?=$|\\/$)`;
  }]], DEFAULT_REPLACER_SUFFIX); // A simple cache, because an ignore rule only has only one certain meaning

  var cache = Object.create(null); // @param {pattern}

  var make_regex = function make_regex(pattern, negative, ignorecase) {
    var r = cache[pattern];

    if (r) {
      return r;
    }

    var replacers = negative ? NEGATIVE_REPLACERS : POSITIVE_REPLACERS;
    var source = replacers.reduce(function (prev, current) {
      return prev.replace(current[0], current[1].bind(pattern));
    }, pattern);
    return cache[pattern] = ignorecase ? new RegExp(source, 'i') : new RegExp(source);
  }; // > A blank line matches no files, so it can serve as a separator for readability.


  var checkPattern = function checkPattern(pattern) {
    return pattern && typeof pattern === 'string' && !REGEX_BLANK_LINE.test(pattern) // > A line starting with # serves as a comment.
    && pattern.indexOf('#') !== 0;
  };

  var createRule = function createRule(pattern, ignorecase) {
    var origin = pattern;
    var negative = false; // > An optional prefix "!" which negates the pattern;

    if (pattern.indexOf('!') === 0) {
      negative = true;
      pattern = pattern.substr(1);
    }

    pattern = pattern // > Put a backslash ("\") in front of the first "!" for patterns that
    // >   begin with a literal "!", for example, `"\!important!.txt"`.
    .replace(REGEX_LEADING_EXCAPED_EXCLAMATION, '!') // > Put a backslash ("\") in front of the first hash for patterns that
    // >   begin with a hash.
    .replace(REGEX_LEADING_EXCAPED_HASH, '#');
    var regex = make_regex(pattern, negative, ignorecase);
    return {
      origin,
      pattern,
      negative,
      regex
    };
  };

  var IgnoreBase =
  /*#__PURE__*/
  function () {
    function IgnoreBase() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$ignorecase = _ref.ignorecase,
          ignorecase = _ref$ignorecase === void 0 ? true : _ref$ignorecase;

      _classCallCheck(this, IgnoreBase);

      this._rules = [];
      this._ignorecase = ignorecase;
      define(this, KEY_IGNORE, true);

      this._initCache();
    }

    _createClass(IgnoreBase, [{
      key: "_initCache",
      value: function _initCache() {
        this._cache = Object.create(null);
      } // @param {Array.<string>|string|Ignore} pattern

    }, {
      key: "add",
      value: function add(pattern) {
        this._added = false;

        if (typeof pattern === 'string') {
          pattern = pattern.split(/\r?\n/g);
        }

        make_array(pattern).forEach(this._addPattern, this); // Some rules have just added to the ignore,
        // making the behavior changed.

        if (this._added) {
          this._initCache();
        }

        return this;
      } // legacy

    }, {
      key: "addPattern",
      value: function addPattern(pattern) {
        return this.add(pattern);
      }
    }, {
      key: "_addPattern",
      value: function _addPattern(pattern) {
        // #32
        if (pattern && pattern[KEY_IGNORE]) {
          this._rules = this._rules.concat(pattern._rules);
          this._added = true;
          return;
        }

        if (checkPattern(pattern)) {
          var rule = createRule(pattern, this._ignorecase);
          this._added = true;

          this._rules.push(rule);
        }
      }
    }, {
      key: "filter",
      value: function filter(paths) {
        var _this = this;

        return make_array(paths).filter(function (path$$1) {
          return _this._filter(path$$1);
        });
      }
    }, {
      key: "createFilter",
      value: function createFilter() {
        var _this2 = this;

        return function (path$$1) {
          return _this2._filter(path$$1);
        };
      }
    }, {
      key: "ignores",
      value: function ignores(path$$1) {
        return !this._filter(path$$1);
      } // @returns `Boolean` true if the `path` is NOT ignored

    }, {
      key: "_filter",
      value: function _filter(path$$1, slices) {
        if (!path$$1) {
          return false;
        }

        if (path$$1 in this._cache) {
          return this._cache[path$$1];
        }

        if (!slices) {
          // path/to/a.js
          // ['path', 'to', 'a.js']
          slices = path$$1.split(SLASH);
        }

        slices.pop();
        return this._cache[path$$1] = slices.length // > It is not possible to re-include a file if a parent directory of
        // >   that file is excluded.
        // If the path contains a parent directory, check the parent first
        ? this._filter(slices.join(SLASH) + SLASH, slices) && this._test(path$$1) // Or only test the path
        : this._test(path$$1);
      } // @returns {Boolean} true if a file is NOT ignored

    }, {
      key: "_test",
      value: function _test(path$$1) {
        // Explicitly define variable type by setting matched to `0`
        var matched = 0;

        this._rules.forEach(function (rule) {
          // if matched = true, then we only test negative rules
          // if matched = false, then we test non-negative rules
          if (!(matched ^ rule.negative)) {
            matched = rule.negative ^ rule.regex.test(path$$1);
          }
        });

        return !matched;
      }
    }]);

    return IgnoreBase;
  }(); // Windows
  // --------------------------------------------------------------

  /* istanbul ignore if  */


  if ( // Detect `process` so that it can run in browsers.
  typeof process !== 'undefined' && (process.env && process.env.IGNORE_TEST_WIN32 || process.platform === 'win32')) {
    var filter = IgnoreBase.prototype._filter;
    /* eslint no-control-regex: "off" */

    var make_posix = function make_posix(str) {
      return /^\\\\\?\\/.test(str) || /[^\x00-\x80]+/.test(str) ? str : str.replace(/\\/g, '/');
    };

    IgnoreBase.prototype._filter = function filterWin32(path$$1, slices) {
      path$$1 = make_posix(path$$1);
      return filter.call(this, path$$1, slices);
    };
  }

  module.exports = function (options) {
    return new IgnoreBase(options);
  };
});

/**
 * @param {string} filename
 * @returns {Promise<null | string>}
 */


function getFileContentOrNull(filename) {
  return new Promise(function (resolve, reject) {
    fs.readFile(filename, "utf8", function (error, data) {
      if (error && error.code !== "ENOENT") {
        reject(createError(filename, error));
      } else {
        resolve(error ? null : data);
      }
    });
  });
}
/**
 * @param {string} filename
 * @returns {null | string}
 */


getFileContentOrNull.sync = function (filename) {
  try {
    return fs.readFileSync(filename, "utf8");
  } catch (error) {
    if (error && error.code === "ENOENT") {
      return null;
    }

    throw createError(filename, error);
  }
};

function createError(filename, error) {
  return new Error(`Unable to read ${filename}: ${error.message}`);
}

var getFileContentOrNull_1 = getFileContentOrNull;

/**
 * @param {undefined | string} ignorePath
 * @param {undefined | boolean} withNodeModules
 */


function createIgnorer(ignorePath, withNodeModules) {
  return (!ignorePath ? Promise.resolve(null) : getFileContentOrNull_1(path.resolve(ignorePath))).then(function (ignoreContent) {
    return _createIgnorer(ignoreContent, withNodeModules);
  });
}
/**
 * @param {undefined | string} ignorePath
 * @param {undefined | boolean} withNodeModules
 */


createIgnorer.sync = function (ignorePath, withNodeModules) {
  var ignoreContent = !ignorePath ? null : getFileContentOrNull_1.sync(path.resolve(ignorePath));
  return _createIgnorer(ignoreContent, withNodeModules);
};
/**
 * @param {null | string} ignoreContent
 * @param {undefined | boolean} withNodeModules
 */


function _createIgnorer(ignoreContent, withNodeModules) {
  var ignorer = ignore().add(ignoreContent || "");

  if (!withNodeModules) {
    ignorer.add("node_modules");
  }

  return ignorer;
}

var createIgnorer_1 = createIgnorer;

/**
 * @typedef {{ ignorePath?: string, withNodeModules?: boolean, plugins: object }} FileInfoOptions
 * @typedef {{ ignored: boolean, inferredParser: string | null }} FileInfoResult
 */

/**
 * @param {string} filePath
 * @param {FileInfoOptions} opts
 * @returns {Promise<FileInfoResult>}
 *
 * Please note that prettier.getFileInfo() expects opts.plugins to be an array of paths,
 * not an object. A transformation from this array to an object is automatically done
 * internally by the method wrapper. See withPlugins() in index.js.
 */


function getFileInfo(filePath, opts) {
  return createIgnorer_1(opts.ignorePath, opts.withNodeModules).then(function (ignorer) {
    return _getFileInfo(ignorer, normalizeFilePath(filePath, opts.ignorePath), opts.plugins);
  });
}
/**
 * @param {string} filePath
 * @param {FileInfoOptions} opts
 * @returns {FileInfoResult}
 */


getFileInfo.sync = function (filePath, opts) {
  var ignorer = createIgnorer_1.sync(opts.ignorePath, opts.withNodeModules);
  return _getFileInfo(ignorer, normalizeFilePath(filePath, opts.ignorePath), opts.plugins);
};

function _getFileInfo(ignorer, filePath, plugins) {
  var ignored = ignorer.ignores(filePath);
  var inferredParser = options.inferParser(filePath, plugins) || null;
  return {
    ignored,
    inferredParser
  };
}

function normalizeFilePath(filePath, ignorePath) {
  return ignorePath ? path.relative(path.dirname(ignorePath), filePath) : filePath;
}

var getFileInfo_1 = getFileInfo;

var lodash_uniqby = createCommonjsModule(function (module, exports) {
  /**
   * lodash (Custom Build) <https://lodash.com/>
   * Build: `lodash modularize exports="npm" -o ./`
   * Copyright jQuery Foundation and other contributors <https://jquery.org/>
   * Released under MIT license <https://lodash.com/license>
   * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
   * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
   */

  /** Used as the size to enable large array optimizations. */
  var LARGE_ARRAY_SIZE = 200;
  /** Used as the `TypeError` message for "Functions" methods. */

  var FUNC_ERROR_TEXT = 'Expected a function';
  /** Used to stand-in for `undefined` hash values. */

  var HASH_UNDEFINED = '__lodash_hash_undefined__';
  /** Used to compose bitmasks for comparison styles. */

  var UNORDERED_COMPARE_FLAG = 1,
      PARTIAL_COMPARE_FLAG = 2;
  /** Used as references for various `Number` constants. */

  var INFINITY = 1 / 0,
      MAX_SAFE_INTEGER = 9007199254740991;
  /** `Object#toString` result references. */

  var argsTag = '[object Arguments]',
      arrayTag = '[object Array]',
      boolTag = '[object Boolean]',
      dateTag = '[object Date]',
      errorTag = '[object Error]',
      funcTag = '[object Function]',
      genTag = '[object GeneratorFunction]',
      mapTag = '[object Map]',
      numberTag = '[object Number]',
      objectTag = '[object Object]',
      promiseTag = '[object Promise]',
      regexpTag = '[object RegExp]',
      setTag = '[object Set]',
      stringTag = '[object String]',
      symbolTag = '[object Symbol]',
      weakMapTag = '[object WeakMap]';
  var arrayBufferTag = '[object ArrayBuffer]',
      dataViewTag = '[object DataView]',
      float32Tag = '[object Float32Array]',
      float64Tag = '[object Float64Array]',
      int8Tag = '[object Int8Array]',
      int16Tag = '[object Int16Array]',
      int32Tag = '[object Int32Array]',
      uint8Tag = '[object Uint8Array]',
      uint8ClampedTag = '[object Uint8ClampedArray]',
      uint16Tag = '[object Uint16Array]',
      uint32Tag = '[object Uint32Array]';
  /** Used to match property names within property paths. */

  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
      reIsPlainProp = /^\w*$/,
      reLeadingDot = /^\./,
      rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
  /**
   * Used to match `RegExp`
   * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
   */

  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
  /** Used to match backslashes in property paths. */

  var reEscapeChar = /\\(\\)?/g;
  /** Used to detect host constructors (Safari). */

  var reIsHostCtor = /^\[object .+?Constructor\]$/;
  /** Used to detect unsigned integer values. */

  var reIsUint = /^(?:0|[1-9]\d*)$/;
  /** Used to identify `toStringTag` values of typed arrays. */

  var typedArrayTags = {};
  typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
  typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
  /** Detect free variable `global` from Node.js. */

  var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;
  /** Detect free variable `self`. */

  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;
  /** Used as a reference to the global object. */

  var root = freeGlobal || freeSelf || Function('return this')();
  /** Detect free variable `exports`. */

  var freeExports = 'object' == 'object' && exports && !exports.nodeType && exports;
  /** Detect free variable `module`. */

  var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;
  /** Detect the popular CommonJS extension `module.exports`. */

  var moduleExports = freeModule && freeModule.exports === freeExports;
  /** Detect free variable `process` from Node.js. */

  var freeProcess = moduleExports && freeGlobal.process;
  /** Used to access faster Node.js helpers. */

  var nodeUtil = function () {
    try {
      return freeProcess && freeProcess.binding('util');
    } catch (e) {}
  }();
  /* Node.js helper references. */


  var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
  /**
   * A specialized version of `_.includes` for arrays without support for
   * specifying an index to search from.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */

  function arrayIncludes(array, value) {
    var length = array ? array.length : 0;
    return !!length && baseIndexOf(array, value, 0) > -1;
  }
  /**
   * This function is like `arrayIncludes` except that it accepts a comparator.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @param {Function} comparator The comparator invoked per element.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */


  function arrayIncludesWith(array, value, comparator) {
    var index = -1,
        length = array ? array.length : 0;

    while (++index < length) {
      if (comparator(value, array[index])) {
        return true;
      }
    }

    return false;
  }
  /**
   * A specialized version of `_.some` for arrays without support for iteratee
   * shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} predicate The function invoked per iteration.
   * @returns {boolean} Returns `true` if any element passes the predicate check,
   *  else `false`.
   */


  function arraySome(array, predicate) {
    var index = -1,
        length = array ? array.length : 0;

    while (++index < length) {
      if (predicate(array[index], index, array)) {
        return true;
      }
    }

    return false;
  }
  /**
   * The base implementation of `_.findIndex` and `_.findLastIndex` without
   * support for iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Function} predicate The function invoked per iteration.
   * @param {number} fromIndex The index to search from.
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */


  function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length,
        index = fromIndex + (fromRight ? 1 : -1);

    while (fromRight ? index-- : ++index < length) {
      if (predicate(array[index], index, array)) {
        return index;
      }
    }

    return -1;
  }
  /**
   * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */


  function baseIndexOf(array, value, fromIndex) {
    if (value !== value) {
      return baseFindIndex(array, baseIsNaN, fromIndex);
    }

    var index = fromIndex - 1,
        length = array.length;

    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }

    return -1;
  }
  /**
   * The base implementation of `_.isNaN` without support for number objects.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
   */


  function baseIsNaN(value) {
    return value !== value;
  }
  /**
   * The base implementation of `_.property` without support for deep paths.
   *
   * @private
   * @param {string} key The key of the property to get.
   * @returns {Function} Returns the new accessor function.
   */


  function baseProperty(key) {
    return function (object) {
      return object == null ? undefined : object[key];
    };
  }
  /**
   * The base implementation of `_.times` without support for iteratee shorthands
   * or max array length checks.
   *
   * @private
   * @param {number} n The number of times to invoke `iteratee`.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns the array of results.
   */


  function baseTimes(n, iteratee) {
    var index = -1,
        result = Array(n);

    while (++index < n) {
      result[index] = iteratee(index);
    }

    return result;
  }
  /**
   * The base implementation of `_.unary` without support for storing metadata.
   *
   * @private
   * @param {Function} func The function to cap arguments for.
   * @returns {Function} Returns the new capped function.
   */


  function baseUnary(func) {
    return function (value) {
      return func(value);
    };
  }
  /**
   * Checks if a cache value for `key` exists.
   *
   * @private
   * @param {Object} cache The cache to query.
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function cacheHas(cache, key) {
    return cache.has(key);
  }
  /**
   * Gets the value at `key` of `object`.
   *
   * @private
   * @param {Object} [object] The object to query.
   * @param {string} key The key of the property to get.
   * @returns {*} Returns the property value.
   */


  function getValue(object, key) {
    return object == null ? undefined : object[key];
  }
  /**
   * Checks if `value` is a host object in IE < 9.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
   */


  function isHostObject(value) {
    // Many host objects are `Object` objects that can coerce to strings
    // despite having improperly defined `toString` methods.
    var result = false;

    if (value != null && typeof value.toString != 'function') {
      try {
        result = !!(value + '');
      } catch (e) {}
    }

    return result;
  }
  /**
   * Converts `map` to its key-value pairs.
   *
   * @private
   * @param {Object} map The map to convert.
   * @returns {Array} Returns the key-value pairs.
   */


  function mapToArray(map) {
    var index = -1,
        result = Array(map.size);
    map.forEach(function (value, key) {
      result[++index] = [key, value];
    });
    return result;
  }
  /**
   * Creates a unary function that invokes `func` with its argument transformed.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {Function} transform The argument transform.
   * @returns {Function} Returns the new function.
   */


  function overArg(func, transform) {
    return function (arg) {
      return func(transform(arg));
    };
  }
  /**
   * Converts `set` to an array of its values.
   *
   * @private
   * @param {Object} set The set to convert.
   * @returns {Array} Returns the values.
   */


  function setToArray(set) {
    var index = -1,
        result = Array(set.size);
    set.forEach(function (value) {
      result[++index] = value;
    });
    return result;
  }
  /** Used for built-in method references. */


  var arrayProto = Array.prototype,
      funcProto = Function.prototype,
      objectProto = Object.prototype;
  /** Used to detect overreaching core-js shims. */

  var coreJsData = root['__core-js_shared__'];
  /** Used to detect methods masquerading as native. */

  var maskSrcKey = function () {
    var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
    return uid ? 'Symbol(src)_1.' + uid : '';
  }();
  /** Used to resolve the decompiled source of functions. */


  var funcToString = funcProto.toString;
  /** Used to check objects for own properties. */

  var hasOwnProperty = objectProto.hasOwnProperty;
  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */

  var objectToString = objectProto.toString;
  /** Used to detect if a method is native. */

  var reIsNative = RegExp('^' + funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$');
  /** Built-in value references. */

  var Symbol = root.Symbol,
      Uint8Array = root.Uint8Array,
      propertyIsEnumerable = objectProto.propertyIsEnumerable,
      splice = arrayProto.splice;
  /* Built-in method references for those with the same name as other `lodash` methods. */

  var nativeKeys = overArg(Object.keys, Object);
  /* Built-in method references that are verified to be native. */

  var DataView = getNative(root, 'DataView'),
      Map = getNative(root, 'Map'),
      Promise = getNative(root, 'Promise'),
      Set = getNative(root, 'Set'),
      WeakMap = getNative(root, 'WeakMap'),
      nativeCreate = getNative(Object, 'create');
  /** Used to detect maps, sets, and weakmaps. */

  var dataViewCtorString = toSource(DataView),
      mapCtorString = toSource(Map),
      promiseCtorString = toSource(Promise),
      setCtorString = toSource(Set),
      weakMapCtorString = toSource(WeakMap);
  /** Used to convert symbols to primitives and strings. */

  var symbolProto = Symbol ? Symbol.prototype : undefined,
      symbolValueOf = symbolProto ? symbolProto.valueOf : undefined,
      symbolToString = symbolProto ? symbolProto.toString : undefined;
  /**
   * Creates a hash object.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function Hash(entries) {
    var index = -1,
        length = entries ? entries.length : 0;
    this.clear();

    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  /**
   * Removes all key-value entries from the hash.
   *
   * @private
   * @name clear
   * @memberOf Hash
   */


  function hashClear() {
    this.__data__ = nativeCreate ? nativeCreate(null) : {};
  }
  /**
   * Removes `key` and its value from the hash.
   *
   * @private
   * @name delete
   * @memberOf Hash
   * @param {Object} hash The hash to modify.
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function hashDelete(key) {
    return this.has(key) && delete this.__data__[key];
  }
  /**
   * Gets the hash value for `key`.
   *
   * @private
   * @name get
   * @memberOf Hash
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function hashGet(key) {
    var data = this.__data__;

    if (nativeCreate) {
      var result = data[key];
      return result === HASH_UNDEFINED ? undefined : result;
    }

    return hasOwnProperty.call(data, key) ? data[key] : undefined;
  }
  /**
   * Checks if a hash value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf Hash
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function hashHas(key) {
    var data = this.__data__;
    return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
  }
  /**
   * Sets the hash `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf Hash
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the hash instance.
   */


  function hashSet(key, value) {
    var data = this.__data__;
    data[key] = nativeCreate && value === undefined ? HASH_UNDEFINED : value;
    return this;
  } // Add methods to `Hash`.


  Hash.prototype.clear = hashClear;
  Hash.prototype['delete'] = hashDelete;
  Hash.prototype.get = hashGet;
  Hash.prototype.has = hashHas;
  Hash.prototype.set = hashSet;
  /**
   * Creates an list cache object.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function ListCache(entries) {
    var index = -1,
        length = entries ? entries.length : 0;
    this.clear();

    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  /**
   * Removes all key-value entries from the list cache.
   *
   * @private
   * @name clear
   * @memberOf ListCache
   */


  function listCacheClear() {
    this.__data__ = [];
  }
  /**
   * Removes `key` and its value from the list cache.
   *
   * @private
   * @name delete
   * @memberOf ListCache
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function listCacheDelete(key) {
    var data = this.__data__,
        index = assocIndexOf(data, key);

    if (index < 0) {
      return false;
    }

    var lastIndex = data.length - 1;

    if (index == lastIndex) {
      data.pop();
    } else {
      splice.call(data, index, 1);
    }

    return true;
  }
  /**
   * Gets the list cache value for `key`.
   *
   * @private
   * @name get
   * @memberOf ListCache
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function listCacheGet(key) {
    var data = this.__data__,
        index = assocIndexOf(data, key);
    return index < 0 ? undefined : data[index][1];
  }
  /**
   * Checks if a list cache value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf ListCache
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function listCacheHas(key) {
    return assocIndexOf(this.__data__, key) > -1;
  }
  /**
   * Sets the list cache `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf ListCache
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the list cache instance.
   */


  function listCacheSet(key, value) {
    var data = this.__data__,
        index = assocIndexOf(data, key);

    if (index < 0) {
      data.push([key, value]);
    } else {
      data[index][1] = value;
    }

    return this;
  } // Add methods to `ListCache`.


  ListCache.prototype.clear = listCacheClear;
  ListCache.prototype['delete'] = listCacheDelete;
  ListCache.prototype.get = listCacheGet;
  ListCache.prototype.has = listCacheHas;
  ListCache.prototype.set = listCacheSet;
  /**
   * Creates a map cache object to store key-value pairs.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function MapCache(entries) {
    var index = -1,
        length = entries ? entries.length : 0;
    this.clear();

    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  /**
   * Removes all key-value entries from the map.
   *
   * @private
   * @name clear
   * @memberOf MapCache
   */


  function mapCacheClear() {
    this.__data__ = {
      'hash': new Hash(),
      'map': new (Map || ListCache)(),
      'string': new Hash()
    };
  }
  /**
   * Removes `key` and its value from the map.
   *
   * @private
   * @name delete
   * @memberOf MapCache
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function mapCacheDelete(key) {
    return getMapData(this, key)['delete'](key);
  }
  /**
   * Gets the map value for `key`.
   *
   * @private
   * @name get
   * @memberOf MapCache
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function mapCacheGet(key) {
    return getMapData(this, key).get(key);
  }
  /**
   * Checks if a map value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf MapCache
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function mapCacheHas(key) {
    return getMapData(this, key).has(key);
  }
  /**
   * Sets the map `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf MapCache
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the map cache instance.
   */


  function mapCacheSet(key, value) {
    getMapData(this, key).set(key, value);
    return this;
  } // Add methods to `MapCache`.


  MapCache.prototype.clear = mapCacheClear;
  MapCache.prototype['delete'] = mapCacheDelete;
  MapCache.prototype.get = mapCacheGet;
  MapCache.prototype.has = mapCacheHas;
  MapCache.prototype.set = mapCacheSet;
  /**
   *
   * Creates an array cache object to store unique values.
   *
   * @private
   * @constructor
   * @param {Array} [values] The values to cache.
   */

  function SetCache(values) {
    var index = -1,
        length = values ? values.length : 0;
    this.__data__ = new MapCache();

    while (++index < length) {
      this.add(values[index]);
    }
  }
  /**
   * Adds `value` to the array cache.
   *
   * @private
   * @name add
   * @memberOf SetCache
   * @alias push
   * @param {*} value The value to cache.
   * @returns {Object} Returns the cache instance.
   */


  function setCacheAdd(value) {
    this.__data__.set(value, HASH_UNDEFINED);

    return this;
  }
  /**
   * Checks if `value` is in the array cache.
   *
   * @private
   * @name has
   * @memberOf SetCache
   * @param {*} value The value to search for.
   * @returns {number} Returns `true` if `value` is found, else `false`.
   */


  function setCacheHas(value) {
    return this.__data__.has(value);
  } // Add methods to `SetCache`.


  SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
  SetCache.prototype.has = setCacheHas;
  /**
   * Creates a stack cache object to store key-value pairs.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function Stack(entries) {
    this.__data__ = new ListCache(entries);
  }
  /**
   * Removes all key-value entries from the stack.
   *
   * @private
   * @name clear
   * @memberOf Stack
   */


  function stackClear() {
    this.__data__ = new ListCache();
  }
  /**
   * Removes `key` and its value from the stack.
   *
   * @private
   * @name delete
   * @memberOf Stack
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function stackDelete(key) {
    return this.__data__['delete'](key);
  }
  /**
   * Gets the stack value for `key`.
   *
   * @private
   * @name get
   * @memberOf Stack
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function stackGet(key) {
    return this.__data__.get(key);
  }
  /**
   * Checks if a stack value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf Stack
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function stackHas(key) {
    return this.__data__.has(key);
  }
  /**
   * Sets the stack `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf Stack
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the stack cache instance.
   */


  function stackSet(key, value) {
    var cache = this.__data__;

    if (cache instanceof ListCache) {
      var pairs = cache.__data__;

      if (!Map || pairs.length < LARGE_ARRAY_SIZE - 1) {
        pairs.push([key, value]);
        return this;
      }

      cache = this.__data__ = new MapCache(pairs);
    }

    cache.set(key, value);
    return this;
  } // Add methods to `Stack`.


  Stack.prototype.clear = stackClear;
  Stack.prototype['delete'] = stackDelete;
  Stack.prototype.get = stackGet;
  Stack.prototype.has = stackHas;
  Stack.prototype.set = stackSet;
  /**
   * Creates an array of the enumerable property names of the array-like `value`.
   *
   * @private
   * @param {*} value The value to query.
   * @param {boolean} inherited Specify returning inherited property names.
   * @returns {Array} Returns the array of property names.
   */

  function arrayLikeKeys(value, inherited) {
    // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
    // Safari 9 makes `arguments.length` enumerable in strict mode.
    var result = isArray(value) || isArguments(value) ? baseTimes(value.length, String) : [];
    var length = result.length,
        skipIndexes = !!length;

    for (var key in value) {
      if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && (key == 'length' || isIndex(key, length)))) {
        result.push(key);
      }
    }

    return result;
  }
  /**
   * Gets the index at which the `key` is found in `array` of key-value pairs.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} key The key to search for.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */


  function assocIndexOf(array, key) {
    var length = array.length;

    while (length--) {
      if (eq(array[length][0], key)) {
        return length;
      }
    }

    return -1;
  }
  /**
   * The base implementation of `_.get` without support for default values.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {Array|string} path The path of the property to get.
   * @returns {*} Returns the resolved value.
   */


  function baseGet(object, path$$1) {
    path$$1 = isKey(path$$1, object) ? [path$$1] : castPath(path$$1);
    var index = 0,
        length = path$$1.length;

    while (object != null && index < length) {
      object = object[toKey(path$$1[index++])];
    }

    return index && index == length ? object : undefined;
  }
  /**
   * The base implementation of `getTag`.
   *
   * @private
   * @param {*} value The value to query.
   * @returns {string} Returns the `toStringTag`.
   */


  function baseGetTag(value) {
    return objectToString.call(value);
  }
  /**
   * The base implementation of `_.hasIn` without support for deep paths.
   *
   * @private
   * @param {Object} [object] The object to query.
   * @param {Array|string} key The key to check.
   * @returns {boolean} Returns `true` if `key` exists, else `false`.
   */


  function baseHasIn(object, key) {
    return object != null && key in Object(object);
  }
  /**
   * The base implementation of `_.isEqual` which supports partial comparisons
   * and tracks traversed objects.
   *
   * @private
   * @param {*} value The value to compare.
   * @param {*} other The other value to compare.
   * @param {Function} [customizer] The function to customize comparisons.
   * @param {boolean} [bitmask] The bitmask of comparison flags.
   *  The bitmask may be composed of the following flags:
   *     1 - Unordered comparison
   *     2 - Partial comparison
   * @param {Object} [stack] Tracks traversed `value` and `other` objects.
   * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
   */


  function baseIsEqual(value, other, customizer, bitmask, stack) {
    if (value === other) {
      return true;
    }

    if (value == null || other == null || !isObject(value) && !isObjectLike(other)) {
      return value !== value && other !== other;
    }

    return baseIsEqualDeep(value, other, baseIsEqual, customizer, bitmask, stack);
  }
  /**
   * A specialized version of `baseIsEqual` for arrays and objects which performs
   * deep comparisons and tracks traversed objects enabling objects with circular
   * references to be compared.
   *
   * @private
   * @param {Object} object The object to compare.
   * @param {Object} other The other object to compare.
   * @param {Function} equalFunc The function to determine equivalents of values.
   * @param {Function} [customizer] The function to customize comparisons.
   * @param {number} [bitmask] The bitmask of comparison flags. See `baseIsEqual`
   *  for more details.
   * @param {Object} [stack] Tracks traversed `object` and `other` objects.
   * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
   */


  function baseIsEqualDeep(object, other, equalFunc, customizer, bitmask, stack) {
    var objIsArr = isArray(object),
        othIsArr = isArray(other),
        objTag = arrayTag,
        othTag = arrayTag;

    if (!objIsArr) {
      objTag = getTag(object);
      objTag = objTag == argsTag ? objectTag : objTag;
    }

    if (!othIsArr) {
      othTag = getTag(other);
      othTag = othTag == argsTag ? objectTag : othTag;
    }

    var objIsObj = objTag == objectTag && !isHostObject(object),
        othIsObj = othTag == objectTag && !isHostObject(other),
        isSameTag = objTag == othTag;

    if (isSameTag && !objIsObj) {
      stack || (stack = new Stack());
      return objIsArr || isTypedArray(object) ? equalArrays(object, other, equalFunc, customizer, bitmask, stack) : equalByTag(object, other, objTag, equalFunc, customizer, bitmask, stack);
    }

    if (!(bitmask & PARTIAL_COMPARE_FLAG)) {
      var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
          othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

      if (objIsWrapped || othIsWrapped) {
        var objUnwrapped = objIsWrapped ? object.value() : object,
            othUnwrapped = othIsWrapped ? other.value() : other;
        stack || (stack = new Stack());
        return equalFunc(objUnwrapped, othUnwrapped, customizer, bitmask, stack);
      }
    }

    if (!isSameTag) {
      return false;
    }

    stack || (stack = new Stack());
    return equalObjects(object, other, equalFunc, customizer, bitmask, stack);
  }
  /**
   * The base implementation of `_.isMatch` without support for iteratee shorthands.
   *
   * @private
   * @param {Object} object The object to inspect.
   * @param {Object} source The object of property values to match.
   * @param {Array} matchData The property names, values, and compare flags to match.
   * @param {Function} [customizer] The function to customize comparisons.
   * @returns {boolean} Returns `true` if `object` is a match, else `false`.
   */


  function baseIsMatch(object, source, matchData, customizer) {
    var index = matchData.length,
        length = index,
        noCustomizer = !customizer;

    if (object == null) {
      return !length;
    }

    object = Object(object);

    while (index--) {
      var data = matchData[index];

      if (noCustomizer && data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
        return false;
      }
    }

    while (++index < length) {
      data = matchData[index];
      var key = data[0],
          objValue = object[key],
          srcValue = data[1];

      if (noCustomizer && data[2]) {
        if (objValue === undefined && !(key in object)) {
          return false;
        }
      } else {
        var stack = new Stack();

        if (customizer) {
          var result = customizer(objValue, srcValue, key, object, source, stack);
        }

        if (!(result === undefined ? baseIsEqual(srcValue, objValue, customizer, UNORDERED_COMPARE_FLAG | PARTIAL_COMPARE_FLAG, stack) : result)) {
          return false;
        }
      }
    }

    return true;
  }
  /**
   * The base implementation of `_.isNative` without bad shim checks.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a native function,
   *  else `false`.
   */


  function baseIsNative(value) {
    if (!isObject(value) || isMasked(value)) {
      return false;
    }

    var pattern = isFunction(value) || isHostObject(value) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource(value));
  }
  /**
   * The base implementation of `_.isTypedArray` without Node.js optimizations.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
   */


  function baseIsTypedArray(value) {
    return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[objectToString.call(value)];
  }
  /**
   * The base implementation of `_.iteratee`.
   *
   * @private
   * @param {*} [value=_.identity] The value to convert to an iteratee.
   * @returns {Function} Returns the iteratee.
   */


  function baseIteratee(value) {
    // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
    // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
    if (typeof value == 'function') {
      return value;
    }

    if (value == null) {
      return identity;
    }

    if (typeof value == 'object') {
      return isArray(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
    }

    return property(value);
  }
  /**
   * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names.
   */


  function baseKeys(object) {
    if (!isPrototype(object)) {
      return nativeKeys(object);
    }

    var result = [];

    for (var key in Object(object)) {
      if (hasOwnProperty.call(object, key) && key != 'constructor') {
        result.push(key);
      }
    }

    return result;
  }
  /**
   * The base implementation of `_.matches` which doesn't clone `source`.
   *
   * @private
   * @param {Object} source The object of property values to match.
   * @returns {Function} Returns the new spec function.
   */


  function baseMatches(source) {
    var matchData = getMatchData(source);

    if (matchData.length == 1 && matchData[0][2]) {
      return matchesStrictComparable(matchData[0][0], matchData[0][1]);
    }

    return function (object) {
      return object === source || baseIsMatch(object, source, matchData);
    };
  }
  /**
   * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
   *
   * @private
   * @param {string} path The path of the property to get.
   * @param {*} srcValue The value to match.
   * @returns {Function} Returns the new spec function.
   */


  function baseMatchesProperty(path$$1, srcValue) {
    if (isKey(path$$1) && isStrictComparable(srcValue)) {
      return matchesStrictComparable(toKey(path$$1), srcValue);
    }

    return function (object) {
      var objValue = get(object, path$$1);
      return objValue === undefined && objValue === srcValue ? hasIn(object, path$$1) : baseIsEqual(srcValue, objValue, undefined, UNORDERED_COMPARE_FLAG | PARTIAL_COMPARE_FLAG);
    };
  }
  /**
   * A specialized version of `baseProperty` which supports deep paths.
   *
   * @private
   * @param {Array|string} path The path of the property to get.
   * @returns {Function} Returns the new accessor function.
   */


  function basePropertyDeep(path$$1) {
    return function (object) {
      return baseGet(object, path$$1);
    };
  }
  /**
   * The base implementation of `_.toString` which doesn't convert nullish
   * values to empty strings.
   *
   * @private
   * @param {*} value The value to process.
   * @returns {string} Returns the string.
   */


  function baseToString(value) {
    // Exit early for strings to avoid a performance hit in some environments.
    if (typeof value == 'string') {
      return value;
    }

    if (isSymbol(value)) {
      return symbolToString ? symbolToString.call(value) : '';
    }

    var result = value + '';
    return result == '0' && 1 / value == -INFINITY ? '-0' : result;
  }
  /**
   * The base implementation of `_.uniqBy` without support for iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Function} [iteratee] The iteratee invoked per element.
   * @param {Function} [comparator] The comparator invoked per element.
   * @returns {Array} Returns the new duplicate free array.
   */


  function baseUniq(array, iteratee, comparator) {
    var index = -1,
        includes = arrayIncludes,
        length = array.length,
        isCommon = true,
        result = [],
        seen = result;

    if (comparator) {
      isCommon = false;
      includes = arrayIncludesWith;
    } else if (length >= LARGE_ARRAY_SIZE) {
      var set = iteratee ? null : createSet(array);

      if (set) {
        return setToArray(set);
      }

      isCommon = false;
      includes = cacheHas;
      seen = new SetCache();
    } else {
      seen = iteratee ? [] : result;
    }

    outer: while (++index < length) {
      var value = array[index],
          computed = iteratee ? iteratee(value) : value;
      value = comparator || value !== 0 ? value : 0;

      if (isCommon && computed === computed) {
        var seenIndex = seen.length;

        while (seenIndex--) {
          if (seen[seenIndex] === computed) {
            continue outer;
          }
        }

        if (iteratee) {
          seen.push(computed);
        }

        result.push(value);
      } else if (!includes(seen, computed, comparator)) {
        if (seen !== result) {
          seen.push(computed);
        }

        result.push(value);
      }
    }

    return result;
  }
  /**
   * Casts `value` to a path array if it's not one.
   *
   * @private
   * @param {*} value The value to inspect.
   * @returns {Array} Returns the cast property path array.
   */


  function castPath(value) {
    return isArray(value) ? value : stringToPath(value);
  }
  /**
   * Creates a set object of `values`.
   *
   * @private
   * @param {Array} values The values to add to the set.
   * @returns {Object} Returns the new set.
   */


  var createSet = !(Set && 1 / setToArray(new Set([, -0]))[1] == INFINITY) ? noop : function (values) {
    return new Set(values);
  };
  /**
   * A specialized version of `baseIsEqualDeep` for arrays with support for
   * partial deep comparisons.
   *
   * @private
   * @param {Array} array The array to compare.
   * @param {Array} other The other array to compare.
   * @param {Function} equalFunc The function to determine equivalents of values.
   * @param {Function} customizer The function to customize comparisons.
   * @param {number} bitmask The bitmask of comparison flags. See `baseIsEqual`
   *  for more details.
   * @param {Object} stack Tracks traversed `array` and `other` objects.
   * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
   */

  function equalArrays(array, other, equalFunc, customizer, bitmask, stack) {
    var isPartial = bitmask & PARTIAL_COMPARE_FLAG,
        arrLength = array.length,
        othLength = other.length;

    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
      return false;
    } // Assume cyclic values are equal.


    var stacked = stack.get(array);

    if (stacked && stack.get(other)) {
      return stacked == other;
    }

    var index = -1,
        result = true,
        seen = bitmask & UNORDERED_COMPARE_FLAG ? new SetCache() : undefined;
    stack.set(array, other);
    stack.set(other, array); // Ignore non-index properties.

    while (++index < arrLength) {
      var arrValue = array[index],
          othValue = other[index];

      if (customizer) {
        var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
      }

      if (compared !== undefined) {
        if (compared) {
          continue;
        }

        result = false;
        break;
      } // Recursively compare arrays (susceptible to call stack limits).


      if (seen) {
        if (!arraySome(other, function (othValue, othIndex) {
          if (!seen.has(othIndex) && (arrValue === othValue || equalFunc(arrValue, othValue, customizer, bitmask, stack))) {
            return seen.add(othIndex);
          }
        })) {
          result = false;
          break;
        }
      } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, customizer, bitmask, stack))) {
        result = false;
        break;
      }
    }

    stack['delete'](array);
    stack['delete'](other);
    return result;
  }
  /**
   * A specialized version of `baseIsEqualDeep` for comparing objects of
   * the same `toStringTag`.
   *
   * **Note:** This function only supports comparing values with tags of
   * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
   *
   * @private
   * @param {Object} object The object to compare.
   * @param {Object} other The other object to compare.
   * @param {string} tag The `toStringTag` of the objects to compare.
   * @param {Function} equalFunc The function to determine equivalents of values.
   * @param {Function} customizer The function to customize comparisons.
   * @param {number} bitmask The bitmask of comparison flags. See `baseIsEqual`
   *  for more details.
   * @param {Object} stack Tracks traversed `object` and `other` objects.
   * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
   */


  function equalByTag(object, other, tag, equalFunc, customizer, bitmask, stack) {
    switch (tag) {
      case dataViewTag:
        if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
          return false;
        }

        object = object.buffer;
        other = other.buffer;

      case arrayBufferTag:
        if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
          return false;
        }

        return true;

      case boolTag:
      case dateTag:
      case numberTag:
        // Coerce booleans to `1` or `0` and dates to milliseconds.
        // Invalid dates are coerced to `NaN`.
        return eq(+object, +other);

      case errorTag:
        return object.name == other.name && object.message == other.message;

      case regexpTag:
      case stringTag:
        // Coerce regexes to strings and treat strings, primitives and objects,
        // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
        // for more details.
        return object == other + '';

      case mapTag:
        var convert = mapToArray;

      case setTag:
        var isPartial = bitmask & PARTIAL_COMPARE_FLAG;
        convert || (convert = setToArray);

        if (object.size != other.size && !isPartial) {
          return false;
        } // Assume cyclic values are equal.


        var stacked = stack.get(object);

        if (stacked) {
          return stacked == other;
        }

        bitmask |= UNORDERED_COMPARE_FLAG; // Recursively compare objects (susceptible to call stack limits).

        stack.set(object, other);
        var result = equalArrays(convert(object), convert(other), equalFunc, customizer, bitmask, stack);
        stack['delete'](object);
        return result;

      case symbolTag:
        if (symbolValueOf) {
          return symbolValueOf.call(object) == symbolValueOf.call(other);
        }

    }

    return false;
  }
  /**
   * A specialized version of `baseIsEqualDeep` for objects with support for
   * partial deep comparisons.
   *
   * @private
   * @param {Object} object The object to compare.
   * @param {Object} other The other object to compare.
   * @param {Function} equalFunc The function to determine equivalents of values.
   * @param {Function} customizer The function to customize comparisons.
   * @param {number} bitmask The bitmask of comparison flags. See `baseIsEqual`
   *  for more details.
   * @param {Object} stack Tracks traversed `object` and `other` objects.
   * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
   */


  function equalObjects(object, other, equalFunc, customizer, bitmask, stack) {
    var isPartial = bitmask & PARTIAL_COMPARE_FLAG,
        objProps = keys(object),
        objLength = objProps.length,
        othProps = keys(other),
        othLength = othProps.length;

    if (objLength != othLength && !isPartial) {
      return false;
    }

    var index = objLength;

    while (index--) {
      var key = objProps[index];

      if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
        return false;
      }
    } // Assume cyclic values are equal.


    var stacked = stack.get(object);

    if (stacked && stack.get(other)) {
      return stacked == other;
    }

    var result = true;
    stack.set(object, other);
    stack.set(other, object);
    var skipCtor = isPartial;

    while (++index < objLength) {
      key = objProps[index];
      var objValue = object[key],
          othValue = other[key];

      if (customizer) {
        var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
      } // Recursively compare objects (susceptible to call stack limits).


      if (!(compared === undefined ? objValue === othValue || equalFunc(objValue, othValue, customizer, bitmask, stack) : compared)) {
        result = false;
        break;
      }

      skipCtor || (skipCtor = key == 'constructor');
    }

    if (result && !skipCtor) {
      var objCtor = object.constructor,
          othCtor = other.constructor; // Non `Object` object instances with different constructors are not equal.

      if (objCtor != othCtor && 'constructor' in object && 'constructor' in other && !(typeof objCtor == 'function' && objCtor instanceof objCtor && typeof othCtor == 'function' && othCtor instanceof othCtor)) {
        result = false;
      }
    }

    stack['delete'](object);
    stack['delete'](other);
    return result;
  }
  /**
   * Gets the data for `map`.
   *
   * @private
   * @param {Object} map The map to query.
   * @param {string} key The reference key.
   * @returns {*} Returns the map data.
   */


  function getMapData(map, key) {
    var data = map.__data__;
    return isKeyable(key) ? data[typeof key == 'string' ? 'string' : 'hash'] : data.map;
  }
  /**
   * Gets the property names, values, and compare flags of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the match data of `object`.
   */


  function getMatchData(object) {
    var result = keys(object),
        length = result.length;

    while (length--) {
      var key = result[length],
          value = object[key];
      result[length] = [key, value, isStrictComparable(value)];
    }

    return result;
  }
  /**
   * Gets the native function at `key` of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {string} key The key of the method to get.
   * @returns {*} Returns the function if it's native, else `undefined`.
   */


  function getNative(object, key) {
    var value = getValue(object, key);
    return baseIsNative(value) ? value : undefined;
  }
  /**
   * Gets the `toStringTag` of `value`.
   *
   * @private
   * @param {*} value The value to query.
   * @returns {string} Returns the `toStringTag`.
   */


  var getTag = baseGetTag; // Fallback for data views, maps, sets, and weak maps in IE 11,
  // for data views in Edge < 14, and promises in Node.js.

  if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map && getTag(new Map()) != mapTag || Promise && getTag(Promise.resolve()) != promiseTag || Set && getTag(new Set()) != setTag || WeakMap && getTag(new WeakMap()) != weakMapTag) {
    getTag = function getTag(value) {
      var result = objectToString.call(value),
          Ctor = result == objectTag ? value.constructor : undefined,
          ctorString = Ctor ? toSource(Ctor) : undefined;

      if (ctorString) {
        switch (ctorString) {
          case dataViewCtorString:
            return dataViewTag;

          case mapCtorString:
            return mapTag;

          case promiseCtorString:
            return promiseTag;

          case setCtorString:
            return setTag;

          case weakMapCtorString:
            return weakMapTag;
        }
      }

      return result;
    };
  }
  /**
   * Checks if `path` exists on `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {Array|string} path The path to check.
   * @param {Function} hasFunc The function to check properties.
   * @returns {boolean} Returns `true` if `path` exists, else `false`.
   */


  function hasPath(object, path$$1, hasFunc) {
    path$$1 = isKey(path$$1, object) ? [path$$1] : castPath(path$$1);
    var result,
        index = -1,
        length = path$$1.length;

    while (++index < length) {
      var key = toKey(path$$1[index]);

      if (!(result = object != null && hasFunc(object, key))) {
        break;
      }

      object = object[key];
    }

    if (result) {
      return result;
    }

    var length = object ? object.length : 0;
    return !!length && isLength(length) && isIndex(key, length) && (isArray(object) || isArguments(object));
  }
  /**
   * Checks if `value` is a valid array-like index.
   *
   * @private
   * @param {*} value The value to check.
   * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
   * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
   */


  function isIndex(value, length) {
    length = length == null ? MAX_SAFE_INTEGER : length;
    return !!length && (typeof value == 'number' || reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
  }
  /**
   * Checks if `value` is a property name and not a property path.
   *
   * @private
   * @param {*} value The value to check.
   * @param {Object} [object] The object to query keys on.
   * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
   */


  function isKey(value, object) {
    if (isArray(value)) {
      return false;
    }

    var type = typeof value;

    if (type == 'number' || type == 'symbol' || type == 'boolean' || value == null || isSymbol(value)) {
      return true;
    }

    return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
  }
  /**
   * Checks if `value` is suitable for use as unique object key.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
   */


  function isKeyable(value) {
    var type = typeof value;
    return type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean' ? value !== '__proto__' : value === null;
  }
  /**
   * Checks if `func` has its source masked.
   *
   * @private
   * @param {Function} func The function to check.
   * @returns {boolean} Returns `true` if `func` is masked, else `false`.
   */


  function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
  }
  /**
   * Checks if `value` is likely a prototype object.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
   */


  function isPrototype(value) {
    var Ctor = value && value.constructor,
        proto = typeof Ctor == 'function' && Ctor.prototype || objectProto;
    return value === proto;
  }
  /**
   * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` if suitable for strict
   *  equality comparisons, else `false`.
   */


  function isStrictComparable(value) {
    return value === value && !isObject(value);
  }
  /**
   * A specialized version of `matchesProperty` for source values suitable
   * for strict equality comparisons, i.e. `===`.
   *
   * @private
   * @param {string} key The key of the property to get.
   * @param {*} srcValue The value to match.
   * @returns {Function} Returns the new spec function.
   */


  function matchesStrictComparable(key, srcValue) {
    return function (object) {
      if (object == null) {
        return false;
      }

      return object[key] === srcValue && (srcValue !== undefined || key in Object(object));
    };
  }
  /**
   * Converts `string` to a property path array.
   *
   * @private
   * @param {string} string The string to convert.
   * @returns {Array} Returns the property path array.
   */


  var stringToPath = memoize(function (string) {
    string = toString(string);
    var result = [];

    if (reLeadingDot.test(string)) {
      result.push('');
    }

    string.replace(rePropName, function (match, number, quote, string) {
      result.push(quote ? string.replace(reEscapeChar, '$1') : number || match);
    });
    return result;
  });
  /**
   * Converts `value` to a string key if it's not a string or symbol.
   *
   * @private
   * @param {*} value The value to inspect.
   * @returns {string|symbol} Returns the key.
   */

  function toKey(value) {
    if (typeof value == 'string' || isSymbol(value)) {
      return value;
    }

    var result = value + '';
    return result == '0' && 1 / value == -INFINITY ? '-0' : result;
  }
  /**
   * Converts `func` to its source code.
   *
   * @private
   * @param {Function} func The function to process.
   * @returns {string} Returns the source code.
   */


  function toSource(func) {
    if (func != null) {
      try {
        return funcToString.call(func);
      } catch (e) {}

      try {
        return func + '';
      } catch (e) {}
    }

    return '';
  }
  /**
   * This method is like `_.uniq` except that it accepts `iteratee` which is
   * invoked for each element in `array` to generate the criterion by which
   * uniqueness is computed. The iteratee is invoked with one argument: (value).
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Array
   * @param {Array} array The array to inspect.
   * @param {Function} [iteratee=_.identity]
   *  The iteratee invoked per element.
   * @returns {Array} Returns the new duplicate free array.
   * @example
   *
   * _.uniqBy([2.1, 1.2, 2.3], Math.floor);
   * // => [2.1, 1.2]
   *
   * // The `_.property` iteratee shorthand.
   * _.uniqBy([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
   * // => [{ 'x': 1 }, { 'x': 2 }]
   */


  function uniqBy(array, iteratee) {
    return array && array.length ? baseUniq(array, baseIteratee(iteratee, 2)) : [];
  }
  /**
   * Creates a function that memoizes the result of `func`. If `resolver` is
   * provided, it determines the cache key for storing the result based on the
   * arguments provided to the memoized function. By default, the first argument
   * provided to the memoized function is used as the map cache key. The `func`
   * is invoked with the `this` binding of the memoized function.
   *
   * **Note:** The cache is exposed as the `cache` property on the memoized
   * function. Its creation may be customized by replacing the `_.memoize.Cache`
   * constructor with one whose instances implement the
   * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
   * method interface of `delete`, `get`, `has`, and `set`.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Function
   * @param {Function} func The function to have its output memoized.
   * @param {Function} [resolver] The function to resolve the cache key.
   * @returns {Function} Returns the new memoized function.
   * @example
   *
   * var object = { 'a': 1, 'b': 2 };
   * var other = { 'c': 3, 'd': 4 };
   *
   * var values = _.memoize(_.values);
   * values(object);
   * // => [1, 2]
   *
   * values(other);
   * // => [3, 4]
   *
   * object.a = 2;
   * values(object);
   * // => [1, 2]
   *
   * // Modify the result cache.
   * values.cache.set(object, ['a', 'b']);
   * values(object);
   * // => ['a', 'b']
   *
   * // Replace `_.memoize.Cache`.
   * _.memoize.Cache = WeakMap;
   */


  function memoize(func, resolver) {
    if (typeof func != 'function' || resolver && typeof resolver != 'function') {
      throw new TypeError(FUNC_ERROR_TEXT);
    }

    var memoized = function memoized() {
      var args = arguments,
          key = resolver ? resolver.apply(this, args) : args[0],
          cache = memoized.cache;

      if (cache.has(key)) {
        return cache.get(key);
      }

      var result = func.apply(this, args);
      memoized.cache = cache.set(key, result);
      return result;
    };

    memoized.cache = new (memoize.Cache || MapCache)();
    return memoized;
  } // Assign cache to `_.memoize`.


  memoize.Cache = MapCache;
  /**
   * Performs a
   * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
   * comparison between two values to determine if they are equivalent.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to compare.
   * @param {*} other The other value to compare.
   * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
   * @example
   *
   * var object = { 'a': 1 };
   * var other = { 'a': 1 };
   *
   * _.eq(object, object);
   * // => true
   *
   * _.eq(object, other);
   * // => false
   *
   * _.eq('a', 'a');
   * // => true
   *
   * _.eq('a', Object('a'));
   * // => false
   *
   * _.eq(NaN, NaN);
   * // => true
   */

  function eq(value, other) {
    return value === other || value !== value && other !== other;
  }
  /**
   * Checks if `value` is likely an `arguments` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an `arguments` object,
   *  else `false`.
   * @example
   *
   * _.isArguments(function() { return arguments; }());
   * // => true
   *
   * _.isArguments([1, 2, 3]);
   * // => false
   */


  function isArguments(value) {
    // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
    return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') && (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
  }
  /**
   * Checks if `value` is classified as an `Array` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an array, else `false`.
   * @example
   *
   * _.isArray([1, 2, 3]);
   * // => true
   *
   * _.isArray(document.body.children);
   * // => false
   *
   * _.isArray('abc');
   * // => false
   *
   * _.isArray(_.noop);
   * // => false
   */


  var isArray = Array.isArray;
  /**
   * Checks if `value` is array-like. A value is considered array-like if it's
   * not a function and has a `value.length` that's an integer greater than or
   * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
   * @example
   *
   * _.isArrayLike([1, 2, 3]);
   * // => true
   *
   * _.isArrayLike(document.body.children);
   * // => true
   *
   * _.isArrayLike('abc');
   * // => true
   *
   * _.isArrayLike(_.noop);
   * // => false
   */

  function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction(value);
  }
  /**
   * This method is like `_.isArrayLike` except that it also checks if `value`
   * is an object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an array-like object,
   *  else `false`.
   * @example
   *
   * _.isArrayLikeObject([1, 2, 3]);
   * // => true
   *
   * _.isArrayLikeObject(document.body.children);
   * // => true
   *
   * _.isArrayLikeObject('abc');
   * // => false
   *
   * _.isArrayLikeObject(_.noop);
   * // => false
   */


  function isArrayLikeObject(value) {
    return isObjectLike(value) && isArrayLike(value);
  }
  /**
   * Checks if `value` is classified as a `Function` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a function, else `false`.
   * @example
   *
   * _.isFunction(_);
   * // => true
   *
   * _.isFunction(/abc/);
   * // => false
   */


  function isFunction(value) {
    // The use of `Object#toString` avoids issues with the `typeof` operator
    // in Safari 8-9 which returns 'object' for typed array and other constructors.
    var tag = isObject(value) ? objectToString.call(value) : '';
    return tag == funcTag || tag == genTag;
  }
  /**
   * Checks if `value` is a valid array-like length.
   *
   * **Note:** This method is loosely based on
   * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
   * @example
   *
   * _.isLength(3);
   * // => true
   *
   * _.isLength(Number.MIN_VALUE);
   * // => false
   *
   * _.isLength(Infinity);
   * // => false
   *
   * _.isLength('3');
   * // => false
   */


  function isLength(value) {
    return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
  }
  /**
   * Checks if `value` is the
   * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
   * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an object, else `false`.
   * @example
   *
   * _.isObject({});
   * // => true
   *
   * _.isObject([1, 2, 3]);
   * // => true
   *
   * _.isObject(_.noop);
   * // => true
   *
   * _.isObject(null);
   * // => false
   */


  function isObject(value) {
    var type = typeof value;
    return !!value && (type == 'object' || type == 'function');
  }
  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */


  function isObjectLike(value) {
    return !!value && typeof value == 'object';
  }
  /**
   * Checks if `value` is classified as a `Symbol` primitive or object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
   * @example
   *
   * _.isSymbol(Symbol.iterator);
   * // => true
   *
   * _.isSymbol('abc');
   * // => false
   */


  function isSymbol(value) {
    return typeof value == 'symbol' || isObjectLike(value) && objectToString.call(value) == symbolTag;
  }
  /**
   * Checks if `value` is classified as a typed array.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
   * @example
   *
   * _.isTypedArray(new Uint8Array);
   * // => true
   *
   * _.isTypedArray([]);
   * // => false
   */


  var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
  /**
   * Converts `value` to a string. An empty string is returned for `null`
   * and `undefined` values. The sign of `-0` is preserved.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to process.
   * @returns {string} Returns the string.
   * @example
   *
   * _.toString(null);
   * // => ''
   *
   * _.toString(-0);
   * // => '-0'
   *
   * _.toString([1, 2, 3]);
   * // => '1,2,3'
   */

  function toString(value) {
    return value == null ? '' : baseToString(value);
  }
  /**
   * Gets the value at `path` of `object`. If the resolved value is
   * `undefined`, the `defaultValue` is returned in its place.
   *
   * @static
   * @memberOf _
   * @since 3.7.0
   * @category Object
   * @param {Object} object The object to query.
   * @param {Array|string} path The path of the property to get.
   * @param {*} [defaultValue] The value returned for `undefined` resolved values.
   * @returns {*} Returns the resolved value.
   * @example
   *
   * var object = { 'a': [{ 'b': { 'c': 3 } }] };
   *
   * _.get(object, 'a[0].b.c');
   * // => 3
   *
   * _.get(object, ['a', '0', 'b', 'c']);
   * // => 3
   *
   * _.get(object, 'a.b.c', 'default');
   * // => 'default'
   */


  function get(object, path$$1, defaultValue) {
    var result = object == null ? undefined : baseGet(object, path$$1);
    return result === undefined ? defaultValue : result;
  }
  /**
   * Checks if `path` is a direct or inherited property of `object`.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Object
   * @param {Object} object The object to query.
   * @param {Array|string} path The path to check.
   * @returns {boolean} Returns `true` if `path` exists, else `false`.
   * @example
   *
   * var object = _.create({ 'a': _.create({ 'b': 2 }) });
   *
   * _.hasIn(object, 'a');
   * // => true
   *
   * _.hasIn(object, 'a.b');
   * // => true
   *
   * _.hasIn(object, ['a', 'b']);
   * // => true
   *
   * _.hasIn(object, 'b');
   * // => false
   */


  function hasIn(object, path$$1) {
    return object != null && hasPath(object, path$$1, baseHasIn);
  }
  /**
   * Creates an array of the own enumerable property names of `object`.
   *
   * **Note:** Non-object values are coerced to objects. See the
   * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
   * for more details.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Object
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names.
   * @example
   *
   * function Foo() {
   *   this.a = 1;
   *   this.b = 2;
   * }
   *
   * Foo.prototype.c = 3;
   *
   * _.keys(new Foo);
   * // => ['a', 'b'] (iteration order is not guaranteed)
   *
   * _.keys('hi');
   * // => ['0', '1']
   */


  function keys(object) {
    return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
  }
  /**
   * This method returns the first argument it receives.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Util
   * @param {*} value Any value.
   * @returns {*} Returns `value`.
   * @example
   *
   * var object = { 'a': 1 };
   *
   * console.log(_.identity(object) === object);
   * // => true
   */


  function identity(value) {
    return value;
  }
  /**
   * This method returns `undefined`.
   *
   * @static
   * @memberOf _
   * @since 2.3.0
   * @category Util
   * @example
   *
   * _.times(2, _.noop);
   * // => [undefined, undefined]
   */


  function noop() {} // No operation performed.

  /**
   * Creates a function that returns the value at `path` of a given object.
   *
   * @static
   * @memberOf _
   * @since 2.4.0
   * @category Util
   * @param {Array|string} path The path of the property to get.
   * @returns {Function} Returns the new accessor function.
   * @example
   *
   * var objects = [
   *   { 'a': { 'b': 2 } },
   *   { 'a': { 'b': 1 } }
   * ];
   *
   * _.map(objects, _.property('a.b'));
   * // => [2, 1]
   *
   * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
   * // => [1, 2]
   */


  function property(path$$1) {
    return isKey(path$$1) ? baseProperty(toKey(path$$1)) : basePropertyDeep(path$$1);
  }

  module.exports = uniqBy;
});

var PENDING = 'pending';
var SETTLED = 'settled';
var FULFILLED = 'fulfilled';
var REJECTED = 'rejected';

var NOOP = function NOOP() {};

var isNode = typeof global !== 'undefined' && typeof global.process !== 'undefined' && typeof global.process.emit === 'function';
var asyncSetTimer = typeof setImmediate === 'undefined' ? setTimeout : setImmediate;
var asyncQueue = [];
var asyncTimer;

function asyncFlush() {
  // run promise callbacks
  for (var i = 0; i < asyncQueue.length; i++) {
    asyncQueue[i][0](asyncQueue[i][1]);
  } // reset async asyncQueue


  asyncQueue = [];
  asyncTimer = false;
}

function asyncCall(callback, arg) {
  asyncQueue.push([callback, arg]);

  if (!asyncTimer) {
    asyncTimer = true;
    asyncSetTimer(asyncFlush, 0);
  }
}

function invokeResolver(resolver, promise) {
  function resolvePromise(value) {
    resolve(promise, value);
  }

  function rejectPromise(reason) {
    reject(promise, reason);
  }

  try {
    resolver(resolvePromise, rejectPromise);
  } catch (e) {
    rejectPromise(e);
  }
}

function invokeCallback(subscriber) {
  var owner = subscriber.owner;
  var settled = owner._state;
  var value = owner._data;
  var callback = subscriber[settled];
  var promise = subscriber.then;

  if (typeof callback === 'function') {
    settled = FULFILLED;

    try {
      value = callback(value);
    } catch (e) {
      reject(promise, e);
    }
  }

  if (!handleThenable(promise, value)) {
    if (settled === FULFILLED) {
      resolve(promise, value);
    }

    if (settled === REJECTED) {
      reject(promise, value);
    }
  }
}

function handleThenable(promise, value) {
  var resolved;

  try {
    if (promise === value) {
      throw new TypeError('A promises callback cannot return that same promise.');
    }

    if (value && (typeof value === 'function' || typeof value === 'object')) {
      // then should be retrieved only once
      var then = value.then;

      if (typeof then === 'function') {
        then.call(value, function (val) {
          if (!resolved) {
            resolved = true;

            if (value === val) {
              fulfill(promise, val);
            } else {
              resolve(promise, val);
            }
          }
        }, function (reason) {
          if (!resolved) {
            resolved = true;
            reject(promise, reason);
          }
        });
        return true;
      }
    }
  } catch (e) {
    if (!resolved) {
      reject(promise, e);
    }

    return true;
  }

  return false;
}

function resolve(promise, value) {
  if (promise === value || !handleThenable(promise, value)) {
    fulfill(promise, value);
  }
}

function fulfill(promise, value) {
  if (promise._state === PENDING) {
    promise._state = SETTLED;
    promise._data = value;
    asyncCall(publishFulfillment, promise);
  }
}

function reject(promise, reason) {
  if (promise._state === PENDING) {
    promise._state = SETTLED;
    promise._data = reason;
    asyncCall(publishRejection, promise);
  }
}

function publish(promise) {
  promise._then = promise._then.forEach(invokeCallback);
}

function publishFulfillment(promise) {
  promise._state = FULFILLED;
  publish(promise);
}

function publishRejection(promise) {
  promise._state = REJECTED;
  publish(promise);

  if (!promise._handled && isNode) {
    global.process.emit('unhandledRejection', promise._data, promise);
  }
}

function notifyRejectionHandled(promise) {
  global.process.emit('rejectionHandled', promise);
}
/**
 * @class
 */


function Promise$1(resolver) {
  if (typeof resolver !== 'function') {
    throw new TypeError('Promise resolver ' + resolver + ' is not a function');
  }

  if (this instanceof Promise$1 === false) {
    throw new TypeError('Failed to construct \'Promise\': Please use the \'new\' operator, this object constructor cannot be called as a function.');
  }

  this._then = [];
  invokeResolver(resolver, this);
}

Promise$1.prototype = {
  constructor: Promise$1,
  _state: PENDING,
  _then: null,
  _data: undefined,
  _handled: false,
  then: function then(onFulfillment, onRejection) {
    var subscriber = {
      owner: this,
      then: new this.constructor(NOOP),
      fulfilled: onFulfillment,
      rejected: onRejection
    };

    if ((onRejection || onFulfillment) && !this._handled) {
      this._handled = true;

      if (this._state === REJECTED && isNode) {
        asyncCall(notifyRejectionHandled, this);
      }
    }

    if (this._state === FULFILLED || this._state === REJECTED) {
      // already resolved, call callback async
      asyncCall(invokeCallback, subscriber);
    } else {
      // subscribe
      this._then.push(subscriber);
    }

    return subscriber.then;
  },
  catch: function _catch(onRejection) {
    return this.then(null, onRejection);
  }
};

Promise$1.all = function (promises) {
  if (!Array.isArray(promises)) {
    throw new TypeError('You must pass an array to Promise.all().');
  }

  return new Promise$1(function (resolve, reject) {
    var results = [];
    var remaining = 0;

    function resolver(index) {
      remaining++;
      return function (value) {
        results[index] = value;

        if (! --remaining) {
          resolve(results);
        }
      };
    }

    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];

      if (promise && typeof promise.then === 'function') {
        promise.then(resolver(i), reject);
      } else {
        results[i] = promise;
      }
    }

    if (!remaining) {
      resolve(results);
    }
  });
};

Promise$1.race = function (promises) {
  if (!Array.isArray(promises)) {
    throw new TypeError('You must pass an array to Promise.race().');
  }

  return new Promise$1(function (resolve, reject) {
    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];

      if (promise && typeof promise.then === 'function') {
        promise.then(resolve, reject);
      } else {
        resolve(promise);
      }
    }
  });
};

Promise$1.resolve = function (value) {
  if (value && typeof value === 'object' && value.constructor === Promise$1) {
    return value;
  }

  return new Promise$1(function (resolve) {
    resolve(value);
  });
};

Promise$1.reject = function (reason) {
  return new Promise$1(function (resolve, reject) {
    reject(reason);
  });
};

var pinkie = Promise$1;

var pinkiePromise = typeof Promise === 'function' ? Promise : pinkie;

var arrayUniq = createCommonjsModule(function (module) {
  'use strict'; // there's 3 implementations written in increasing order of efficiency
  // 1 - no Set type is defined

  function uniqNoSet(arr) {
    var ret = [];

    for (var i = 0; i < arr.length; i++) {
      if (ret.indexOf(arr[i]) === -1) {
        ret.push(arr[i]);
      }
    }

    return ret;
  } // 2 - a simple Set type is defined


  function uniqSet(arr) {
    var seen = new Set();
    return arr.filter(function (el) {
      if (!seen.has(el)) {
        seen.add(el);
        return true;
      }

      return false;
    });
  } // 3 - a standard Set type is defined and it has a forEach method


  function uniqSetWithForEach(arr) {
    var ret = [];
    new Set(arr).forEach(function (el) {
      ret.push(el);
    });
    return ret;
  } // V8 currently has a broken implementation
  // https://github.com/joyent/node/issues/8449


  function doesForEachActuallyWork() {
    var ret = false;
    new Set([true]).forEach(function (el) {
      ret = el;
    });
    return ret === true;
  }

  if ('Set' in global) {
    if (typeof Set.prototype.forEach === 'function' && doesForEachActuallyWork()) {
      module.exports = uniqSetWithForEach;
    } else {
      module.exports = uniqSet;
    }
  } else {
    module.exports = uniqNoSet;
  }
});

var arrayUnion = function arrayUnion() {
  return arrayUniq([].concat.apply([], arguments));
};

/*
object-assign
(c) Sindre Sorhus
@license MIT
*/
/* eslint-disable no-unused-vars */

var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
  if (val === null || val === undefined) {
    throw new TypeError('Object.assign cannot be called with null or undefined');
  }

  return Object(val);
}

function shouldUseNative() {
  try {
    if (!Object.assign) {
      return false;
    } // Detect buggy property enumeration order in older V8 versions.
    // https://bugs.chromium.org/p/v8/issues/detail?id=4118


    var test1 = new String('abc'); // eslint-disable-line no-new-wrappers

    test1[5] = 'de';

    if (Object.getOwnPropertyNames(test1)[0] === '5') {
      return false;
    } // https://bugs.chromium.org/p/v8/issues/detail?id=3056


    var test2 = {};

    for (var i = 0; i < 10; i++) {
      test2['_' + String.fromCharCode(i)] = i;
    }

    var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
      return test2[n];
    });

    if (order2.join('') !== '0123456789') {
      return false;
    } // https://bugs.chromium.org/p/v8/issues/detail?id=3056


    var test3 = {};
    'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
      test3[letter] = letter;
    });

    if (Object.keys(Object.assign({}, test3)).join('') !== 'abcdefghijklmnopqrst') {
      return false;
    }

    return true;
  } catch (err) {
    // We don't expect any of the above to throw, but better to be safe.
    return false;
  }
}

var objectAssign = shouldUseNative() ? Object.assign : function (target, source) {
  var from;
  var to = toObject(target);
  var symbols;

  for (var s = 1; s < arguments.length; s++) {
    from = Object(arguments[s]);

    for (var key in from) {
      if (hasOwnProperty.call(from, key)) {
        to[key] = from[key];
      }
    }

    if (getOwnPropertySymbols) {
      symbols = getOwnPropertySymbols(from);

      for (var i = 0; i < symbols.length; i++) {
        if (propIsEnumerable.call(from, symbols[i])) {
          to[symbols[i]] = from[symbols[i]];
        }
      }
    }
  }

  return to;
};

//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var isWindows = process.platform === 'win32'; // JavaScript implementation of realpath, ported from node pre-v6

var DEBUG = process.env.NODE_DEBUG && /fs/.test(process.env.NODE_DEBUG);

function rethrow() {
  // Only enable in debug mode. A backtrace uses ~1000 bytes of heap space and
  // is fairly slow to generate.
  var callback;

  if (DEBUG) {
    var backtrace = new Error();
    callback = debugCallback;
  } else callback = missingCallback;

  return callback;

  function debugCallback(err) {
    if (err) {
      backtrace.message = err.message;
      err = backtrace;
      missingCallback(err);
    }
  }

  function missingCallback(err) {
    if (err) {
      if (process.throwDeprecation) throw err; // Forgot a callback but don't know where? Use NODE_DEBUG=fs
      else if (!process.noDeprecation) {
          var msg = 'fs: missing callback ' + (err.stack || err.message);
          if (process.traceDeprecation) console.trace(msg);else console.error(msg);
        }
    }
  }
}

function maybeCallback(cb) {
  return typeof cb === 'function' ? cb : rethrow();
}

// result is [base_with_slash, base], e.g. ['somedir/', 'somedir']

if (isWindows) {
  var nextPartRe = /(.*?)(?:[\/\\]+|$)/g;
} else {
  var nextPartRe = /(.*?)(?:[\/]+|$)/g;
} // Regex to find the device root, including trailing slash. E.g. 'c:\\'.


if (isWindows) {
  var splitRootRe = /^(?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/][^\\\/]+)?[\\\/]*/;
} else {
  var splitRootRe = /^[\/]*/;
}

var realpathSync$1 = function realpathSync(p, cache) {
  // make p is absolute
  p = path.resolve(p);

  if (cache && Object.prototype.hasOwnProperty.call(cache, p)) {
    return cache[p];
  }

  var original = p,
      seenLinks = {},
      knownHard = {}; // current character position in p

  var pos; // the partial path so far, including a trailing slash if any

  var current; // the partial path without a trailing slash (except when pointing at a root)

  var base; // the partial path scanned in the previous round, with slash

  var previous;
  start();

  function start() {
    // Skip over roots
    var m = splitRootRe.exec(p);
    pos = m[0].length;
    current = m[0];
    base = m[0];
    previous = ''; // On windows, check that the root exists. On unix there is no need.

    if (isWindows && !knownHard[base]) {
      fs.lstatSync(base);
      knownHard[base] = true;
    }
  } // walk down the path, swapping out linked pathparts for their real
  // values
  // NB: p.length changes.


  while (pos < p.length) {
    // find the next part
    nextPartRe.lastIndex = pos;
    var result = nextPartRe.exec(p);
    previous = current;
    current += result[0];
    base = previous + result[1];
    pos = nextPartRe.lastIndex; // continue if not a symlink

    if (knownHard[base] || cache && cache[base] === base) {
      continue;
    }

    var resolvedLink;

    if (cache && Object.prototype.hasOwnProperty.call(cache, base)) {
      // some known symbolic link.  no need to stat again.
      resolvedLink = cache[base];
    } else {
      var stat = fs.lstatSync(base);

      if (!stat.isSymbolicLink()) {
        knownHard[base] = true;
        if (cache) cache[base] = base;
        continue;
      } // read the link if it wasn't read before
      // dev/ino always return 0 on windows, so skip the check.


      var linkTarget = null;

      if (!isWindows) {
        var id = stat.dev.toString(32) + ':' + stat.ino.toString(32);

        if (seenLinks.hasOwnProperty(id)) {
          linkTarget = seenLinks[id];
        }
      }

      if (linkTarget === null) {
        fs.statSync(base);
        linkTarget = fs.readlinkSync(base);
      }

      resolvedLink = path.resolve(previous, linkTarget); // track this, if given a cache.

      if (cache) cache[base] = resolvedLink;
      if (!isWindows) seenLinks[id] = linkTarget;
    } // resolve the link, then start over


    p = path.resolve(resolvedLink, p.slice(pos));
    start();
  }

  if (cache) cache[original] = p;
  return p;
};

var realpath$1 = function realpath(p, cache, cb) {
  if (typeof cb !== 'function') {
    cb = maybeCallback(cache);
    cache = null;
  } // make p is absolute


  p = path.resolve(p);

  if (cache && Object.prototype.hasOwnProperty.call(cache, p)) {
    return process.nextTick(cb.bind(null, null, cache[p]));
  }

  var original = p,
      seenLinks = {},
      knownHard = {}; // current character position in p

  var pos; // the partial path so far, including a trailing slash if any

  var current; // the partial path without a trailing slash (except when pointing at a root)

  var base; // the partial path scanned in the previous round, with slash

  var previous;
  start();

  function start() {
    // Skip over roots
    var m = splitRootRe.exec(p);
    pos = m[0].length;
    current = m[0];
    base = m[0];
    previous = ''; // On windows, check that the root exists. On unix there is no need.

    if (isWindows && !knownHard[base]) {
      fs.lstat(base, function (err) {
        if (err) return cb(err);
        knownHard[base] = true;
        LOOP();
      });
    } else {
      process.nextTick(LOOP);
    }
  } // walk down the path, swapping out linked pathparts for their real
  // values


  function LOOP() {
    // stop if scanned past end of path
    if (pos >= p.length) {
      if (cache) cache[original] = p;
      return cb(null, p);
    } // find the next part


    nextPartRe.lastIndex = pos;
    var result = nextPartRe.exec(p);
    previous = current;
    current += result[0];
    base = previous + result[1];
    pos = nextPartRe.lastIndex; // continue if not a symlink

    if (knownHard[base] || cache && cache[base] === base) {
      return process.nextTick(LOOP);
    }

    if (cache && Object.prototype.hasOwnProperty.call(cache, base)) {
      // known symbolic link.  no need to stat again.
      return gotResolvedLink(cache[base]);
    }

    return fs.lstat(base, gotStat);
  }

  function gotStat(err, stat) {
    if (err) return cb(err); // if not a symlink, skip to the next path part

    if (!stat.isSymbolicLink()) {
      knownHard[base] = true;
      if (cache) cache[base] = base;
      return process.nextTick(LOOP);
    } // stat & read the link if not read before
    // call gotTarget as soon as the link target is known
    // dev/ino always return 0 on windows, so skip the check.


    if (!isWindows) {
      var id = stat.dev.toString(32) + ':' + stat.ino.toString(32);

      if (seenLinks.hasOwnProperty(id)) {
        return gotTarget(null, seenLinks[id], base);
      }
    }

    fs.stat(base, function (err) {
      if (err) return cb(err);
      fs.readlink(base, function (err, target) {
        if (!isWindows) seenLinks[id] = target;
        gotTarget(err, target);
      });
    });
  }

  function gotTarget(err, target, base) {
    if (err) return cb(err);
    var resolvedLink = path.resolve(previous, target);
    if (cache) cache[base] = resolvedLink;
    gotResolvedLink(resolvedLink);
  }

  function gotResolvedLink(resolvedLink) {
    // resolve the link, then start over
    p = path.resolve(resolvedLink, p.slice(pos));
    start();
  }
};

var old = {
  realpathSync: realpathSync$1,
  realpath: realpath$1
};

var fs_realpath = realpath;
realpath.realpath = realpath;
realpath.sync = realpathSync;
realpath.realpathSync = realpathSync;
realpath.monkeypatch = monkeypatch;
realpath.unmonkeypatch = unmonkeypatch;
var origRealpath = fs.realpath;
var origRealpathSync = fs.realpathSync;
var version$2 = process.version;
var ok = /^v[0-5]\./.test(version$2);

function newError(er) {
  return er && er.syscall === 'realpath' && (er.code === 'ELOOP' || er.code === 'ENOMEM' || er.code === 'ENAMETOOLONG');
}

function realpath(p, cache, cb) {
  if (ok) {
    return origRealpath(p, cache, cb);
  }

  if (typeof cache === 'function') {
    cb = cache;
    cache = null;
  }

  origRealpath(p, cache, function (er, result) {
    if (newError(er)) {
      old.realpath(p, cache, cb);
    } else {
      cb(er, result);
    }
  });
}

function realpathSync(p, cache) {
  if (ok) {
    return origRealpathSync(p, cache);
  }

  try {
    return origRealpathSync(p, cache);
  } catch (er) {
    if (newError(er)) {
      return old.realpathSync(p, cache);
    } else {
      throw er;
    }
  }
}

function monkeypatch() {
  fs.realpath = realpath;
  fs.realpathSync = realpathSync;
}

function unmonkeypatch() {
  fs.realpath = origRealpath;
  fs.realpathSync = origRealpathSync;
}

var concatMap = function concatMap(xs, fn) {
  var res = [];

  for (var i = 0; i < xs.length; i++) {
    var x = fn(xs[i], i);
    if (isArray(x)) res.push.apply(res, x);else res.push(x);
  }

  return res;
};

var isArray = Array.isArray || function (xs) {
  return Object.prototype.toString.call(xs) === '[object Array]';
};

var balancedMatch = balanced;

function balanced(a, b, str) {
  if (a instanceof RegExp) a = maybeMatch(a, str);
  if (b instanceof RegExp) b = maybeMatch(b, str);
  var r = range(a, b, str);
  return r && {
    start: r[0],
    end: r[1],
    pre: str.slice(0, r[0]),
    body: str.slice(r[0] + a.length, r[1]),
    post: str.slice(r[1] + b.length)
  };
}

function maybeMatch(reg, str) {
  var m = str.match(reg);
  return m ? m[0] : null;
}

balanced.range = range;

function range(a, b, str) {
  var begs, beg, left, right, result;
  var ai = str.indexOf(a);
  var bi = str.indexOf(b, ai + 1);
  var i = ai;

  if (ai >= 0 && bi > 0) {
    begs = [];
    left = str.length;

    while (i >= 0 && !result) {
      if (i == ai) {
        begs.push(i);
        ai = str.indexOf(a, i + 1);
      } else if (begs.length == 1) {
        result = [begs.pop(), bi];
      } else {
        beg = begs.pop();

        if (beg < left) {
          left = beg;
          right = bi;
        }

        bi = str.indexOf(b, i + 1);
      }

      i = ai < bi && ai >= 0 ? ai : bi;
    }

    if (begs.length) {
      result = [left, right];
    }
  }

  return result;
}

var braceExpansion = expandTop;
var escSlash = '\0SLASH' + Math.random() + '\0';
var escOpen = '\0OPEN' + Math.random() + '\0';
var escClose = '\0CLOSE' + Math.random() + '\0';
var escComma = '\0COMMA' + Math.random() + '\0';
var escPeriod = '\0PERIOD' + Math.random() + '\0';

function numeric(str) {
  return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
}

function escapeBraces(str) {
  return str.split('\\\\').join(escSlash).split('\\{').join(escOpen).split('\\}').join(escClose).split('\\,').join(escComma).split('\\.').join(escPeriod);
}

function unescapeBraces(str) {
  return str.split(escSlash).join('\\').split(escOpen).join('{').split(escClose).join('}').split(escComma).join(',').split(escPeriod).join('.');
} // Basically just str.split(","), but handling cases
// where we have nested braced sections, which should be
// treated as individual members, like {a,{b,c},d}


function parseCommaParts(str) {
  if (!str) return [''];
  var parts = [];
  var m = balancedMatch('{', '}', str);
  if (!m) return str.split(',');
  var pre = m.pre;
  var body = m.body;
  var post = m.post;
  var p = pre.split(',');
  p[p.length - 1] += '{' + body + '}';
  var postParts = parseCommaParts(post);

  if (post.length) {
    p[p.length - 1] += postParts.shift();
    p.push.apply(p, postParts);
  }

  parts.push.apply(parts, p);
  return parts;
}

function expandTop(str) {
  if (!str) return []; // I don't know why Bash 4.3 does this, but it does.
  // Anything starting with {} will have the first two bytes preserved
  // but *only* at the top level, so {},a}b will not expand to anything,
  // but a{},b}c will be expanded to [a}c,abc].
  // One could argue that this is a bug in Bash, but since the goal of
  // this module is to match Bash's rules, we escape a leading {}

  if (str.substr(0, 2) === '{}') {
    str = '\\{\\}' + str.substr(2);
  }

  return expand(escapeBraces(str), true).map(unescapeBraces);
}

function embrace(str) {
  return '{' + str + '}';
}

function isPadded(el) {
  return /^-?0\d/.test(el);
}

function lte(i, y) {
  return i <= y;
}

function gte(i, y) {
  return i >= y;
}

function expand(str, isTop) {
  var expansions = [];
  var m = balancedMatch('{', '}', str);
  if (!m || /\$$/.test(m.pre)) return [str];
  var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
  var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
  var isSequence = isNumericSequence || isAlphaSequence;
  var isOptions = m.body.indexOf(',') >= 0;

  if (!isSequence && !isOptions) {
    // {a},b}
    if (m.post.match(/,.*\}/)) {
      str = m.pre + '{' + m.body + escClose + m.post;
      return expand(str);
    }

    return [str];
  }

  var n;

  if (isSequence) {
    n = m.body.split(/\.\./);
  } else {
    n = parseCommaParts(m.body);

    if (n.length === 1) {
      // x{{a,b}}y ==> x{a}y x{b}y
      n = expand(n[0], false).map(embrace);

      if (n.length === 1) {
        var post = m.post.length ? expand(m.post, false) : [''];
        return post.map(function (p) {
          return m.pre + n[0] + p;
        });
      }
    }
  } // at this point, n is the parts, and we know it's not a comma set
  // with a single entry.
  // no need to expand pre, since it is guaranteed to be free of brace-sets


  var pre = m.pre;
  var post = m.post.length ? expand(m.post, false) : [''];
  var N;

  if (isSequence) {
    var x = numeric(n[0]);
    var y = numeric(n[1]);
    var width = Math.max(n[0].length, n[1].length);
    var incr = n.length == 3 ? Math.abs(numeric(n[2])) : 1;
    var test = lte;
    var reverse = y < x;

    if (reverse) {
      incr *= -1;
      test = gte;
    }

    var pad = n.some(isPadded);
    N = [];

    for (var i = x; test(i, y); i += incr) {
      var c;

      if (isAlphaSequence) {
        c = String.fromCharCode(i);
        if (c === '\\') c = '';
      } else {
        c = String(i);

        if (pad) {
          var need = width - c.length;

          if (need > 0) {
            var z = new Array(need + 1).join('0');
            if (i < 0) c = '-' + z + c.slice(1);else c = z + c;
          }
        }
      }

      N.push(c);
    }
  } else {
    N = concatMap(n, function (el) {
      return expand(el, false);
    });
  }

  for (var j = 0; j < N.length; j++) {
    for (var k = 0; k < post.length; k++) {
      var expansion = pre + N[j] + post[k];
      if (!isTop || isSequence || expansion) expansions.push(expansion);
    }
  }

  return expansions;
}

var minimatch_1 = minimatch;
minimatch.Minimatch = Minimatch$1;
var path$2 = {
  sep: '/'
};

try {
  path$2 = path;
} catch (er) {}

var GLOBSTAR = minimatch.GLOBSTAR = Minimatch$1.GLOBSTAR = {};
var plTypes = {
  '!': {
    open: '(?:(?!(?:',
    close: '))[^/]*?)'
  },
  '?': {
    open: '(?:',
    close: ')?'
  },
  '+': {
    open: '(?:',
    close: ')+'
  },
  '*': {
    open: '(?:',
    close: ')*'
  },
  '@': {
    open: '(?:',
    close: ')'
  } // any single thing other than /
  // don't need to escape / when using new RegExp()

};
var qmark = '[^/]'; // * => any number of characters

var star = qmark + '*?'; // ** when dots are allowed.  Anything goes, except .. and .
// not (^ or / followed by one or two dots followed by $ or /),
// followed by anything, any number of times.

var twoStarDot = '(?:(?!(?:\\\/|^)(?:\\.{1,2})($|\\\/)).)*?'; // not a ^ or / followed by a dot,
// followed by anything, any number of times.

var twoStarNoDot = '(?:(?!(?:\\\/|^)\\.).)*?'; // characters that need to be escaped in RegExp.

var reSpecials = charSet('().*{}+?[]^$\\!'); // "abc" -> { a:true, b:true, c:true }

function charSet(s) {
  return s.split('').reduce(function (set, c) {
    set[c] = true;
    return set;
  }, {});
} // normalizes slashes.


var slashSplit = /\/+/;
minimatch.filter = filter;

function filter(pattern, options) {
  options = options || {};
  return function (p, i, list) {
    return minimatch(p, pattern, options);
  };
}

function ext(a, b) {
  a = a || {};
  b = b || {};
  var t = {};
  Object.keys(b).forEach(function (k) {
    t[k] = b[k];
  });
  Object.keys(a).forEach(function (k) {
    t[k] = a[k];
  });
  return t;
}

minimatch.defaults = function (def) {
  if (!def || !Object.keys(def).length) return minimatch;
  var orig = minimatch;

  var m = function minimatch(p, pattern, options) {
    return orig.minimatch(p, pattern, ext(def, options));
  };

  m.Minimatch = function Minimatch(pattern, options) {
    return new orig.Minimatch(pattern, ext(def, options));
  };

  return m;
};

Minimatch$1.defaults = function (def) {
  if (!def || !Object.keys(def).length) return Minimatch$1;
  return minimatch.defaults(def).Minimatch;
};

function minimatch(p, pattern, options) {
  if (typeof pattern !== 'string') {
    throw new TypeError('glob pattern string required');
  }

  if (!options) options = {}; // shortcut: comments match nothing.

  if (!options.nocomment && pattern.charAt(0) === '#') {
    return false;
  } // "" only matches ""


  if (pattern.trim() === '') return p === '';
  return new Minimatch$1(pattern, options).match(p);
}

function Minimatch$1(pattern, options) {
  if (!(this instanceof Minimatch$1)) {
    return new Minimatch$1(pattern, options);
  }

  if (typeof pattern !== 'string') {
    throw new TypeError('glob pattern string required');
  }

  if (!options) options = {};
  pattern = pattern.trim(); // windows support: need to use /, not \

  if (path$2.sep !== '/') {
    pattern = pattern.split(path$2.sep).join('/');
  }

  this.options = options;
  this.set = [];
  this.pattern = pattern;
  this.regexp = null;
  this.negate = false;
  this.comment = false;
  this.empty = false; // make the set of regexps etc.

  this.make();
}

Minimatch$1.prototype.debug = function () {};

Minimatch$1.prototype.make = make;

function make() {
  // don't do it more than once.
  if (this._made) return;
  var pattern = this.pattern;
  var options = this.options; // empty patterns and comments match nothing.

  if (!options.nocomment && pattern.charAt(0) === '#') {
    this.comment = true;
    return;
  }

  if (!pattern) {
    this.empty = true;
    return;
  } // step 1: figure out negation, etc.


  this.parseNegate(); // step 2: expand braces

  var set = this.globSet = this.braceExpand();
  if (options.debug) this.debug = console.error;
  this.debug(this.pattern, set); // step 3: now we have a set, so turn each one into a series of path-portion
  // matching patterns.
  // These will be regexps, except in the case of "**", which is
  // set to the GLOBSTAR object for globstar behavior,
  // and will not contain any / characters

  set = this.globParts = set.map(function (s) {
    return s.split(slashSplit);
  });
  this.debug(this.pattern, set); // glob --> regexps

  set = set.map(function (s, si, set) {
    return s.map(this.parse, this);
  }, this);
  this.debug(this.pattern, set); // filter out everything that didn't compile properly.

  set = set.filter(function (s) {
    return s.indexOf(false) === -1;
  });
  this.debug(this.pattern, set);
  this.set = set;
}

Minimatch$1.prototype.parseNegate = parseNegate;

function parseNegate() {
  var pattern = this.pattern;
  var negate = false;
  var options = this.options;
  var negateOffset = 0;
  if (options.nonegate) return;

  for (var i = 0, l = pattern.length; i < l && pattern.charAt(i) === '!'; i++) {
    negate = !negate;
    negateOffset++;
  }

  if (negateOffset) this.pattern = pattern.substr(negateOffset);
  this.negate = negate;
} // Brace expansion:
// a{b,c}d -> abd acd
// a{b,}c -> abc ac
// a{0..3}d -> a0d a1d a2d a3d
// a{b,c{d,e}f}g -> abg acdfg acefg
// a{b,c}d{e,f}g -> abdeg acdeg abdeg abdfg
//
// Invalid sets are not expanded.
// a{2..}b -> a{2..}b
// a{b}c -> a{b}c


minimatch.braceExpand = function (pattern, options) {
  return braceExpand(pattern, options);
};

Minimatch$1.prototype.braceExpand = braceExpand;

function braceExpand(pattern, options) {
  if (!options) {
    if (this instanceof Minimatch$1) {
      options = this.options;
    } else {
      options = {};
    }
  }

  pattern = typeof pattern === 'undefined' ? this.pattern : pattern;

  if (typeof pattern === 'undefined') {
    throw new TypeError('undefined pattern');
  }

  if (options.nobrace || !pattern.match(/\{.*\}/)) {
    // shortcut. no need to expand.
    return [pattern];
  }

  return braceExpansion(pattern);
} // parse a component of the expanded set.
// At this point, no pattern may contain "/" in it
// so we're going to return a 2d array, where each entry is the full
// pattern, split on '/', and then turned into a regular expression.
// A regexp is made at the end which joins each array with an
// escaped /, and another full one which joins each regexp with |.
//
// Following the lead of Bash 4.1, note that "**" only has special meaning
// when it is the *only* thing in a path portion.  Otherwise, any series
// of * is equivalent to a single *.  Globstar behavior is enabled by
// default, and can be disabled by setting options.noglobstar.


Minimatch$1.prototype.parse = parse$3;
var SUBPARSE = {};

function parse$3(pattern, isSub) {
  if (pattern.length > 1024 * 64) {
    throw new TypeError('pattern is too long');
  }

  var options = this.options; // shortcuts

  if (!options.noglobstar && pattern === '**') return GLOBSTAR;
  if (pattern === '') return '';
  var re = '';
  var hasMagic = !!options.nocase;
  var escaping = false; // ? => one single character

  var patternListStack = [];
  var negativeLists = [];
  var stateChar;
  var inClass = false;
  var reClassStart = -1;
  var classStart = -1; // . and .. never match anything that doesn't start with .,
  // even when options.dot is set.

  var patternStart = pattern.charAt(0) === '.' ? '' // anything
  // not (start or / followed by . or .. followed by / or end)
  : options.dot ? '(?!(?:^|\\\/)\\.{1,2}(?:$|\\\/))' : '(?!\\.)';
  var self = this;

  function clearStateChar() {
    if (stateChar) {
      // we had some state-tracking character
      // that wasn't consumed by this pass.
      switch (stateChar) {
        case '*':
          re += star;
          hasMagic = true;
          break;

        case '?':
          re += qmark;
          hasMagic = true;
          break;

        default:
          re += '\\' + stateChar;
          break;
      }

      self.debug('clearStateChar %j %j', stateChar, re);
      stateChar = false;
    }
  }

  for (var i = 0, len = pattern.length, c; i < len && (c = pattern.charAt(i)); i++) {
    this.debug('%s\t%s %s %j', pattern, i, re, c); // skip over any that are escaped.

    if (escaping && reSpecials[c]) {
      re += '\\' + c;
      escaping = false;
      continue;
    }

    switch (c) {
      case '/':
        // completely not allowed, even escaped.
        // Should already be path-split by now.
        return false;

      case '\\':
        clearStateChar();
        escaping = true;
        continue;
      // the various stateChar values
      // for the "extglob" stuff.

      case '?':
      case '*':
      case '+':
      case '@':
      case '!':
        this.debug('%s\t%s %s %j <-- stateChar', pattern, i, re, c); // all of those are literals inside a class, except that
        // the glob [!a] means [^a] in regexp

        if (inClass) {
          this.debug('  in class');
          if (c === '!' && i === classStart + 1) c = '^';
          re += c;
          continue;
        } // if we already have a stateChar, then it means
        // that there was something like ** or +? in there.
        // Handle the stateChar, then proceed with this one.


        self.debug('call clearStateChar %j', stateChar);
        clearStateChar();
        stateChar = c; // if extglob is disabled, then +(asdf|foo) isn't a thing.
        // just clear the statechar *now*, rather than even diving into
        // the patternList stuff.

        if (options.noext) clearStateChar();
        continue;

      case '(':
        if (inClass) {
          re += '(';
          continue;
        }

        if (!stateChar) {
          re += '\\(';
          continue;
        }

        patternListStack.push({
          type: stateChar,
          start: i - 1,
          reStart: re.length,
          open: plTypes[stateChar].open,
          close: plTypes[stateChar].close
        }); // negation is (?:(?!js)[^/]*)

        re += stateChar === '!' ? '(?:(?!(?:' : '(?:';
        this.debug('plType %j %j', stateChar, re);
        stateChar = false;
        continue;

      case ')':
        if (inClass || !patternListStack.length) {
          re += '\\)';
          continue;
        }

        clearStateChar();
        hasMagic = true;
        var pl = patternListStack.pop(); // negation is (?:(?!js)[^/]*)
        // The others are (?:<pattern>)<type>

        re += pl.close;

        if (pl.type === '!') {
          negativeLists.push(pl);
        }

        pl.reEnd = re.length;
        continue;

      case '|':
        if (inClass || !patternListStack.length || escaping) {
          re += '\\|';
          escaping = false;
          continue;
        }

        clearStateChar();
        re += '|';
        continue;
      // these are mostly the same in regexp and glob

      case '[':
        // swallow any state-tracking char before the [
        clearStateChar();

        if (inClass) {
          re += '\\' + c;
          continue;
        }

        inClass = true;
        classStart = i;
        reClassStart = re.length;
        re += c;
        continue;

      case ']':
        //  a right bracket shall lose its special
        //  meaning and represent itself in
        //  a bracket expression if it occurs
        //  first in the list.  -- POSIX.2 2.8.3.2
        if (i === classStart + 1 || !inClass) {
          re += '\\' + c;
          escaping = false;
          continue;
        } // handle the case where we left a class open.
        // "[z-a]" is valid, equivalent to "\[z-a\]"


        if (inClass) {
          // split where the last [ was, make sure we don't have
          // an invalid re. if so, re-walk the contents of the
          // would-be class to re-translate any characters that
          // were passed through as-is
          // TODO: It would probably be faster to determine this
          // without a try/catch and a new RegExp, but it's tricky
          // to do safely.  For now, this is safe and works.
          var cs = pattern.substring(classStart + 1, i);

          try {
            RegExp('[' + cs + ']');
          } catch (er) {
            // not a valid class!
            var sp = this.parse(cs, SUBPARSE);
            re = re.substr(0, reClassStart) + '\\[' + sp[0] + '\\]';
            hasMagic = hasMagic || sp[1];
            inClass = false;
            continue;
          }
        } // finish up the class.


        hasMagic = true;
        inClass = false;
        re += c;
        continue;

      default:
        // swallow any state char that wasn't consumed
        clearStateChar();

        if (escaping) {
          // no need
          escaping = false;
        } else if (reSpecials[c] && !(c === '^' && inClass)) {
          re += '\\';
        }

        re += c;
    } // switch

  } // for
  // handle the case where we left a class open.
  // "[abc" is valid, equivalent to "\[abc"


  if (inClass) {
    // split where the last [ was, and escape it
    // this is a huge pita.  We now have to re-walk
    // the contents of the would-be class to re-translate
    // any characters that were passed through as-is
    cs = pattern.substr(classStart + 1);
    sp = this.parse(cs, SUBPARSE);
    re = re.substr(0, reClassStart) + '\\[' + sp[0];
    hasMagic = hasMagic || sp[1];
  } // handle the case where we had a +( thing at the *end*
  // of the pattern.
  // each pattern list stack adds 3 chars, and we need to go through
  // and escape any | chars that were passed through as-is for the regexp.
  // Go through and escape them, taking care not to double-escape any
  // | chars that were already escaped.


  for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
    var tail = re.slice(pl.reStart + pl.open.length);
    this.debug('setting tail', re, pl); // maybe some even number of \, then maybe 1 \, followed by a |

    tail = tail.replace(/((?:\\{2}){0,64})(\\?)\|/g, function (_, $1, $2) {
      if (!$2) {
        // the | isn't already escaped, so escape it.
        $2 = '\\';
      } // need to escape all those slashes *again*, without escaping the
      // one that we need for escaping the | character.  As it works out,
      // escaping an even number of slashes can be done by simply repeating
      // it exactly after itself.  That's why this trick works.
      //
      // I am sorry that you have to see this.


      return $1 + $1 + $2 + '|';
    });
    this.debug('tail=%j\n   %s', tail, tail, pl, re);
    var t = pl.type === '*' ? star : pl.type === '?' ? qmark : '\\' + pl.type;
    hasMagic = true;
    re = re.slice(0, pl.reStart) + t + '\\(' + tail;
  } // handle trailing things that only matter at the very end.


  clearStateChar();

  if (escaping) {
    // trailing \\
    re += '\\\\';
  } // only need to apply the nodot start if the re starts with
  // something that could conceivably capture a dot


  var addPatternStart = false;

  switch (re.charAt(0)) {
    case '.':
    case '[':
    case '(':
      addPatternStart = true;
  } // Hack to work around lack of negative lookbehind in JS
  // A pattern like: *.!(x).!(y|z) needs to ensure that a name
  // like 'a.xyz.yz' doesn't match.  So, the first negative
  // lookahead, has to look ALL the way ahead, to the end of
  // the pattern.


  for (var n = negativeLists.length - 1; n > -1; n--) {
    var nl = negativeLists[n];
    var nlBefore = re.slice(0, nl.reStart);
    var nlFirst = re.slice(nl.reStart, nl.reEnd - 8);
    var nlLast = re.slice(nl.reEnd - 8, nl.reEnd);
    var nlAfter = re.slice(nl.reEnd);
    nlLast += nlAfter; // Handle nested stuff like *(*.js|!(*.json)), where open parens
    // mean that we should *not* include the ) in the bit that is considered
    // "after" the negated section.

    var openParensBefore = nlBefore.split('(').length - 1;
    var cleanAfter = nlAfter;

    for (i = 0; i < openParensBefore; i++) {
      cleanAfter = cleanAfter.replace(/\)[+*?]?/, '');
    }

    nlAfter = cleanAfter;
    var dollar = '';

    if (nlAfter === '' && isSub !== SUBPARSE) {
      dollar = '$';
    }

    var newRe = nlBefore + nlFirst + nlAfter + dollar + nlLast;
    re = newRe;
  } // if the re is not "" at this point, then we need to make sure
  // it doesn't match against an empty path part.
  // Otherwise a/* will match a/, which it should not.


  if (re !== '' && hasMagic) {
    re = '(?=.)' + re;
  }

  if (addPatternStart) {
    re = patternStart + re;
  } // parsing just a piece of a larger pattern.


  if (isSub === SUBPARSE) {
    return [re, hasMagic];
  } // skip the regexp for non-magical patterns
  // unescape anything in it, though, so that it'll be
  // an exact match against a file etc.


  if (!hasMagic) {
    return globUnescape(pattern);
  }

  var flags = options.nocase ? 'i' : '';

  try {
    var regExp = new RegExp('^' + re + '$', flags);
  } catch (er) {
    // If it was an invalid regular expression, then it can't match
    // anything.  This trick looks for a character after the end of
    // the string, which is of course impossible, except in multi-line
    // mode, but it's not a /m regex.
    return new RegExp('$.');
  }

  regExp._glob = pattern;
  regExp._src = re;
  return regExp;
}

minimatch.makeRe = function (pattern, options) {
  return new Minimatch$1(pattern, options || {}).makeRe();
};

Minimatch$1.prototype.makeRe = makeRe;

function makeRe() {
  if (this.regexp || this.regexp === false) return this.regexp; // at this point, this.set is a 2d array of partial
  // pattern strings, or "**".
  //
  // It's better to use .match().  This function shouldn't
  // be used, really, but it's pretty convenient sometimes,
  // when you just want to work with a regex.

  var set = this.set;

  if (!set.length) {
    this.regexp = false;
    return this.regexp;
  }

  var options = this.options;
  var twoStar = options.noglobstar ? star : options.dot ? twoStarDot : twoStarNoDot;
  var flags = options.nocase ? 'i' : '';
  var re = set.map(function (pattern) {
    return pattern.map(function (p) {
      return p === GLOBSTAR ? twoStar : typeof p === 'string' ? regExpEscape(p) : p._src;
    }).join('\\\/');
  }).join('|'); // must match entire pattern
  // ending in a * or ** will make it less strict.

  re = '^(?:' + re + ')$'; // can match anything, as long as it's not this.

  if (this.negate) re = '^(?!' + re + ').*$';

  try {
    this.regexp = new RegExp(re, flags);
  } catch (ex) {
    this.regexp = false;
  }

  return this.regexp;
}

minimatch.match = function (list, pattern, options) {
  options = options || {};
  var mm = new Minimatch$1(pattern, options);
  list = list.filter(function (f) {
    return mm.match(f);
  });

  if (mm.options.nonull && !list.length) {
    list.push(pattern);
  }

  return list;
};

Minimatch$1.prototype.match = match;

function match(f, partial) {
  this.debug('match', f, this.pattern); // short-circuit in the case of busted things.
  // comments, etc.

  if (this.comment) return false;
  if (this.empty) return f === '';
  if (f === '/' && partial) return true;
  var options = this.options; // windows: need to use /, not \

  if (path$2.sep !== '/') {
    f = f.split(path$2.sep).join('/');
  } // treat the test path as a set of pathparts.


  f = f.split(slashSplit);
  this.debug(this.pattern, 'split', f); // just ONE of the pattern sets in this.set needs to match
  // in order for it to be valid.  If negating, then just one
  // match means that we have failed.
  // Either way, return on the first hit.

  var set = this.set;
  this.debug(this.pattern, 'set', set); // Find the basename of the path by looking for the last non-empty segment

  var filename;
  var i;

  for (i = f.length - 1; i >= 0; i--) {
    filename = f[i];
    if (filename) break;
  }

  for (i = 0; i < set.length; i++) {
    var pattern = set[i];
    var file = f;

    if (options.matchBase && pattern.length === 1) {
      file = [filename];
    }

    var hit = this.matchOne(file, pattern, partial);

    if (hit) {
      if (options.flipNegate) return true;
      return !this.negate;
    }
  } // didn't get any hits.  this is success if it's a negative
  // pattern, failure otherwise.


  if (options.flipNegate) return false;
  return this.negate;
} // set partial to true to test if, for example,
// "/a/b" matches the start of "/*/b/*/d"
// Partial means, if you run out of file before you run
// out of pattern, then that's fine, as long as all
// the parts match.


Minimatch$1.prototype.matchOne = function (file, pattern, partial) {
  var options = this.options;
  this.debug('matchOne', {
    'this': this,
    file: file,
    pattern: pattern
  });
  this.debug('matchOne', file.length, pattern.length);

  for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
    this.debug('matchOne loop');
    var p = pattern[pi];
    var f = file[fi];
    this.debug(pattern, p, f); // should be impossible.
    // some invalid regexp stuff in the set.

    if (p === false) return false;

    if (p === GLOBSTAR) {
      this.debug('GLOBSTAR', [pattern, p, f]); // "**"
      // a/**/b/**/c would match the following:
      // a/b/x/y/z/c
      // a/x/y/z/b/c
      // a/b/x/b/x/c
      // a/b/c
      // To do this, take the rest of the pattern after
      // the **, and see if it would match the file remainder.
      // If so, return success.
      // If not, the ** "swallows" a segment, and try again.
      // This is recursively awful.
      //
      // a/**/b/**/c matching a/b/x/y/z/c
      // - a matches a
      // - doublestar
      //   - matchOne(b/x/y/z/c, b/**/c)
      //     - b matches b
      //     - doublestar
      //       - matchOne(x/y/z/c, c) -> no
      //       - matchOne(y/z/c, c) -> no
      //       - matchOne(z/c, c) -> no
      //       - matchOne(c, c) yes, hit

      var fr = fi;
      var pr = pi + 1;

      if (pr === pl) {
        this.debug('** at the end'); // a ** at the end will just swallow the rest.
        // We have found a match.
        // however, it will not swallow /.x, unless
        // options.dot is set.
        // . and .. are *never* matched by **, for explosively
        // exponential reasons.

        for (; fi < fl; fi++) {
          if (file[fi] === '.' || file[fi] === '..' || !options.dot && file[fi].charAt(0) === '.') return false;
        }

        return true;
      } // ok, let's see if we can swallow whatever we can.


      while (fr < fl) {
        var swallowee = file[fr];
        this.debug('\nglobstar while', file, fr, pattern, pr, swallowee); // XXX remove this slice.  Just pass the start index.

        if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
          this.debug('globstar found match!', fr, fl, swallowee); // found a match.

          return true;
        } else {
          // can't swallow "." or ".." ever.
          // can only swallow ".foo" when explicitly asked.
          if (swallowee === '.' || swallowee === '..' || !options.dot && swallowee.charAt(0) === '.') {
            this.debug('dot detected!', file, fr, pattern, pr);
            break;
          } // ** swallows a segment, and continue.


          this.debug('globstar swallow a segment, and continue');
          fr++;
        }
      } // no match was found.
      // However, in partial mode, we can't say this is necessarily over.
      // If there's more *pattern* left, then


      if (partial) {
        // ran out of file
        this.debug('\n>>> no match, partial?', file, fr, pattern, pr);
        if (fr === fl) return true;
      }

      return false;
    } // something other than **
    // non-magic patterns just have to match exactly
    // patterns with magic have been turned into regexps.


    var hit;

    if (typeof p === 'string') {
      if (options.nocase) {
        hit = f.toLowerCase() === p.toLowerCase();
      } else {
        hit = f === p;
      }

      this.debug('string match', p, f, hit);
    } else {
      hit = f.match(p);
      this.debug('pattern match', p, f, hit);
    }

    if (!hit) return false;
  } // Note: ending in / means that we'll get a final ""
  // at the end of the pattern.  This can only match a
  // corresponding "" at the end of the file.
  // If the file ends in /, then it can only match a
  // a pattern that ends in /, unless the pattern just
  // doesn't have any more for it. But, a/b/ should *not*
  // match "a/b/*", even though "" matches against the
  // [^/]*? pattern, except in partial mode, where it might
  // simply not be reached yet.
  // However, a/b/ should still satisfy a/*
  // now either we fell off the end of the pattern, or we're done.


  if (fi === fl && pi === pl) {
    // ran out of pattern and filename at the same time.
    // an exact hit!
    return true;
  } else if (fi === fl) {
    // ran out of file, but still had pattern left.
    // this is ok if we're doing the match as part of
    // a glob fs traversal.
    return partial;
  } else if (pi === pl) {
    // ran out of pattern, still have file left.
    // this is only acceptable if we're on the very last
    // empty segment of a file with a trailing slash.
    // a/* should match a/b/
    var emptyFileEnd = fi === fl - 1 && file[fi] === '';
    return emptyFileEnd;
  } // should be unreachable.


  throw new Error('wtf?');
}; // replace stuff like \* with *


function globUnescape(s) {
  return s.replace(/\\(.)/g, '$1');
}

function regExpEscape(s) {
  return s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
}

var inherits_browser = createCommonjsModule(function (module) {
  if (typeof Object.create === 'function') {
    // implementation from standard node.js 'util' module
    module.exports = function inherits(ctor, superCtor) {
      ctor.super_ = superCtor;
      ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
          value: ctor,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
    };
  } else {
    // old school shim for old browsers
    module.exports = function inherits(ctor, superCtor) {
      ctor.super_ = superCtor;

      var TempCtor = function TempCtor() {};

      TempCtor.prototype = superCtor.prototype;
      ctor.prototype = new TempCtor();
      ctor.prototype.constructor = ctor;
    };
  }
});

var inherits = createCommonjsModule(function (module) {
  try {
    var util$$1 = util;
    if (typeof util$$1.inherits !== 'function') throw '';
    module.exports = util$$1.inherits;
  } catch (e) {
    module.exports = inherits_browser;
  }
});

function posix(path$$1) {
  return path$$1.charAt(0) === '/';
}

function win32(path$$1) {
  // https://github.com/nodejs/node/blob/b3fcc245fb25539909ef1d5eaa01dbf92e168633/lib/path.js#L56
  var splitDeviceRe = /^([a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?([\\\/])?([\s\S]*?)$/;
  var result = splitDeviceRe.exec(path$$1);
  var device = result[1] || '';
  var isUnc = Boolean(device && device.charAt(1) !== ':'); // UNC paths are always absolute

  return Boolean(result[2] || isUnc);
}

var pathIsAbsolute = process.platform === 'win32' ? win32 : posix;
var posix_1 = posix;
var win32_1 = win32;
pathIsAbsolute.posix = posix_1;
pathIsAbsolute.win32 = win32_1;

var alphasort_1 = alphasort$2;
var alphasorti_1 = alphasorti$2;
var setopts_1 = setopts$2;
var ownProp_1 = ownProp$2;
var makeAbs_1 = makeAbs;
var finish_1 = finish;
var mark_1 = mark;
var isIgnored_1 = isIgnored$2;
var childrenIgnored_1 = childrenIgnored$2;

function ownProp$2(obj, field) {
  return Object.prototype.hasOwnProperty.call(obj, field);
}

var Minimatch$3 = minimatch_1.Minimatch;

function alphasorti$2(a, b) {
  return a.toLowerCase().localeCompare(b.toLowerCase());
}

function alphasort$2(a, b) {
  return a.localeCompare(b);
}

function setupIgnores(self, options) {
  self.ignore = options.ignore || [];
  if (!Array.isArray(self.ignore)) self.ignore = [self.ignore];

  if (self.ignore.length) {
    self.ignore = self.ignore.map(ignoreMap);
  }
} // ignore patterns are always in dot:true mode.


function ignoreMap(pattern) {
  var gmatcher = null;

  if (pattern.slice(-3) === '/**') {
    var gpattern = pattern.replace(/(\/\*\*)+$/, '');
    gmatcher = new Minimatch$3(gpattern, {
      dot: true
    });
  }

  return {
    matcher: new Minimatch$3(pattern, {
      dot: true
    }),
    gmatcher: gmatcher
  };
}

function setopts$2(self, pattern, options) {
  if (!options) options = {}; // base-matching: just use globstar for that.

  if (options.matchBase && -1 === pattern.indexOf("/")) {
    if (options.noglobstar) {
      throw new Error("base matching requires globstar");
    }

    pattern = "**/" + pattern;
  }

  self.silent = !!options.silent;
  self.pattern = pattern;
  self.strict = options.strict !== false;
  self.realpath = !!options.realpath;
  self.realpathCache = options.realpathCache || Object.create(null);
  self.follow = !!options.follow;
  self.dot = !!options.dot;
  self.mark = !!options.mark;
  self.nodir = !!options.nodir;
  if (self.nodir) self.mark = true;
  self.sync = !!options.sync;
  self.nounique = !!options.nounique;
  self.nonull = !!options.nonull;
  self.nosort = !!options.nosort;
  self.nocase = !!options.nocase;
  self.stat = !!options.stat;
  self.noprocess = !!options.noprocess;
  self.absolute = !!options.absolute;
  self.maxLength = options.maxLength || Infinity;
  self.cache = options.cache || Object.create(null);
  self.statCache = options.statCache || Object.create(null);
  self.symlinks = options.symlinks || Object.create(null);
  setupIgnores(self, options);
  self.changedCwd = false;
  var cwd = process.cwd();
  if (!ownProp$2(options, "cwd")) self.cwd = cwd;else {
    self.cwd = path.resolve(options.cwd);
    self.changedCwd = self.cwd !== cwd;
  }
  self.root = options.root || path.resolve(self.cwd, "/");
  self.root = path.resolve(self.root);
  if (process.platform === "win32") self.root = self.root.replace(/\\/g, "/"); // TODO: is an absolute `cwd` supposed to be resolved against `root`?
  // e.g. { cwd: '/test', root: __dirname } === path.join(__dirname, '/test')

  self.cwdAbs = pathIsAbsolute(self.cwd) ? self.cwd : makeAbs(self, self.cwd);
  if (process.platform === "win32") self.cwdAbs = self.cwdAbs.replace(/\\/g, "/");
  self.nomount = !!options.nomount; // disable comments and negation in Minimatch.
  // Note that they are not supported in Glob itself anyway.

  options.nonegate = true;
  options.nocomment = true;
  self.minimatch = new Minimatch$3(pattern, options);
  self.options = self.minimatch.options;
}

function finish(self) {
  var nou = self.nounique;
  var all = nou ? [] : Object.create(null);

  for (var i = 0, l = self.matches.length; i < l; i++) {
    var matches = self.matches[i];

    if (!matches || Object.keys(matches).length === 0) {
      if (self.nonull) {
        // do like the shell, and spit out the literal glob
        var literal = self.minimatch.globSet[i];
        if (nou) all.push(literal);else all[literal] = true;
      }
    } else {
      // had matches
      var m = Object.keys(matches);
      if (nou) all.push.apply(all, m);else m.forEach(function (m) {
        all[m] = true;
      });
    }
  }

  if (!nou) all = Object.keys(all);
  if (!self.nosort) all = all.sort(self.nocase ? alphasorti$2 : alphasort$2); // at *some* point we statted all of these

  if (self.mark) {
    for (var i = 0; i < all.length; i++) {
      all[i] = self._mark(all[i]);
    }

    if (self.nodir) {
      all = all.filter(function (e) {
        var notDir = !/\/$/.test(e);
        var c = self.cache[e] || self.cache[makeAbs(self, e)];
        if (notDir && c) notDir = c !== 'DIR' && !Array.isArray(c);
        return notDir;
      });
    }
  }

  if (self.ignore.length) all = all.filter(function (m) {
    return !isIgnored$2(self, m);
  });
  self.found = all;
}

function mark(self, p) {
  var abs = makeAbs(self, p);
  var c = self.cache[abs];
  var m = p;

  if (c) {
    var isDir = c === 'DIR' || Array.isArray(c);
    var slash = p.slice(-1) === '/';
    if (isDir && !slash) m += '/';else if (!isDir && slash) m = m.slice(0, -1);

    if (m !== p) {
      var mabs = makeAbs(self, m);
      self.statCache[mabs] = self.statCache[abs];
      self.cache[mabs] = self.cache[abs];
    }
  }

  return m;
} // lotta situps...


function makeAbs(self, f) {
  var abs = f;

  if (f.charAt(0) === '/') {
    abs = path.join(self.root, f);
  } else if (pathIsAbsolute(f) || f === '') {
    abs = f;
  } else if (self.changedCwd) {
    abs = path.resolve(self.cwd, f);
  } else {
    abs = path.resolve(f);
  }

  if (process.platform === 'win32') abs = abs.replace(/\\/g, '/');
  return abs;
} // Return true, if pattern ends with globstar '**', for the accompanying parent directory.
// Ex:- If node_modules/** is the pattern, add 'node_modules' to ignore list along with it's contents


function isIgnored$2(self, path$$2) {
  if (!self.ignore.length) return false;
  return self.ignore.some(function (item) {
    return item.matcher.match(path$$2) || !!(item.gmatcher && item.gmatcher.match(path$$2));
  });
}

function childrenIgnored$2(self, path$$2) {
  if (!self.ignore.length) return false;
  return self.ignore.some(function (item) {
    return !!(item.gmatcher && item.gmatcher.match(path$$2));
  });
}

var common$4 = {
  alphasort: alphasort_1,
  alphasorti: alphasorti_1,
  setopts: setopts_1,
  ownProp: ownProp_1,
  makeAbs: makeAbs_1,
  finish: finish_1,
  mark: mark_1,
  isIgnored: isIgnored_1,
  childrenIgnored: childrenIgnored_1
};

var sync$1 = globSync;
globSync.GlobSync = GlobSync$1;
var setopts$1 = common$4.setopts;
var ownProp$1 = common$4.ownProp;
var childrenIgnored$1 = common$4.childrenIgnored;
var isIgnored$1 = common$4.isIgnored;

function globSync(pattern, options) {
  if (typeof options === 'function' || arguments.length === 3) throw new TypeError('callback provided to sync glob\n' + 'See: https://github.com/isaacs/node-glob/issues/167');
  return new GlobSync$1(pattern, options).found;
}

function GlobSync$1(pattern, options) {
  if (!pattern) throw new Error('must provide pattern');
  if (typeof options === 'function' || arguments.length === 3) throw new TypeError('callback provided to sync glob\n' + 'See: https://github.com/isaacs/node-glob/issues/167');
  if (!(this instanceof GlobSync$1)) return new GlobSync$1(pattern, options);
  setopts$1(this, pattern, options);
  if (this.noprocess) return this;
  var n = this.minimatch.set.length;
  this.matches = new Array(n);

  for (var i = 0; i < n; i++) {
    this._process(this.minimatch.set[i], i, false);
  }

  this._finish();
}

GlobSync$1.prototype._finish = function () {
  assert(this instanceof GlobSync$1);

  if (this.realpath) {
    var self = this;
    this.matches.forEach(function (matchset, index) {
      var set = self.matches[index] = Object.create(null);

      for (var p in matchset) {
        try {
          p = self._makeAbs(p);
          var real = fs_realpath.realpathSync(p, self.realpathCache);
          set[real] = true;
        } catch (er) {
          if (er.syscall === 'stat') set[self._makeAbs(p)] = true;else throw er;
        }
      }
    });
  }

  common$4.finish(this);
};

GlobSync$1.prototype._process = function (pattern, index, inGlobStar) {
  assert(this instanceof GlobSync$1); // Get the first [n] parts of pattern that are all strings.

  var n = 0;

  while (typeof pattern[n] === 'string') {
    n++;
  } // now n is the index of the first one that is *not* a string.
  // See if there's anything else


  var prefix;

  switch (n) {
    // if not, then this is rather simple
    case pattern.length:
      this._processSimple(pattern.join('/'), index);

      return;

    case 0:
      // pattern *starts* with some non-trivial item.
      // going to readdir(cwd), but not include the prefix in matches.
      prefix = null;
      break;

    default:
      // pattern has some string bits in the front.
      // whatever it starts with, whether that's 'absolute' like /foo/bar,
      // or 'relative' like '../baz'
      prefix = pattern.slice(0, n).join('/');
      break;
  }

  var remain = pattern.slice(n); // get the list of entries.

  var read;
  if (prefix === null) read = '.';else if (pathIsAbsolute(prefix) || pathIsAbsolute(pattern.join('/'))) {
    if (!prefix || !pathIsAbsolute(prefix)) prefix = '/' + prefix;
    read = prefix;
  } else read = prefix;

  var abs = this._makeAbs(read); //if ignored, skip processing


  if (childrenIgnored$1(this, read)) return;
  var isGlobStar = remain[0] === minimatch_1.GLOBSTAR;
  if (isGlobStar) this._processGlobStar(prefix, read, abs, remain, index, inGlobStar);else this._processReaddir(prefix, read, abs, remain, index, inGlobStar);
};

GlobSync$1.prototype._processReaddir = function (prefix, read, abs, remain, index, inGlobStar) {
  var entries = this._readdir(abs, inGlobStar); // if the abs isn't a dir, then nothing can match!


  if (!entries) return; // It will only match dot entries if it starts with a dot, or if
  // dot is set.  Stuff like @(.foo|.bar) isn't allowed.

  var pn = remain[0];
  var negate = !!this.minimatch.negate;
  var rawGlob = pn._glob;
  var dotOk = this.dot || rawGlob.charAt(0) === '.';
  var matchedEntries = [];

  for (var i = 0; i < entries.length; i++) {
    var e = entries[i];

    if (e.charAt(0) !== '.' || dotOk) {
      var m;

      if (negate && !prefix) {
        m = !e.match(pn);
      } else {
        m = e.match(pn);
      }

      if (m) matchedEntries.push(e);
    }
  }

  var len = matchedEntries.length; // If there are no matched entries, then nothing matches.

  if (len === 0) return; // if this is the last remaining pattern bit, then no need for
  // an additional stat *unless* the user has specified mark or
  // stat explicitly.  We know they exist, since readdir returned
  // them.

  if (remain.length === 1 && !this.mark && !this.stat) {
    if (!this.matches[index]) this.matches[index] = Object.create(null);

    for (var i = 0; i < len; i++) {
      var e = matchedEntries[i];

      if (prefix) {
        if (prefix.slice(-1) !== '/') e = prefix + '/' + e;else e = prefix + e;
      }

      if (e.charAt(0) === '/' && !this.nomount) {
        e = path.join(this.root, e);
      }

      this._emitMatch(index, e);
    } // This was the last one, and no stats were needed


    return;
  } // now test all matched entries as stand-ins for that part
  // of the pattern.


  remain.shift();

  for (var i = 0; i < len; i++) {
    var e = matchedEntries[i];
    var newPattern;
    if (prefix) newPattern = [prefix, e];else newPattern = [e];

    this._process(newPattern.concat(remain), index, inGlobStar);
  }
};

GlobSync$1.prototype._emitMatch = function (index, e) {
  if (isIgnored$1(this, e)) return;

  var abs = this._makeAbs(e);

  if (this.mark) e = this._mark(e);

  if (this.absolute) {
    e = abs;
  }

  if (this.matches[index][e]) return;

  if (this.nodir) {
    var c = this.cache[abs];
    if (c === 'DIR' || Array.isArray(c)) return;
  }

  this.matches[index][e] = true;
  if (this.stat) this._stat(e);
};

GlobSync$1.prototype._readdirInGlobStar = function (abs) {
  // follow all symlinked directories forever
  // just proceed as if this is a non-globstar situation
  if (this.follow) return this._readdir(abs, false);
  var entries;
  var lstat;
  var stat;

  try {
    lstat = fs.lstatSync(abs);
  } catch (er) {
    if (er.code === 'ENOENT') {
      // lstat failed, doesn't exist
      return null;
    }
  }

  var isSym = lstat && lstat.isSymbolicLink();
  this.symlinks[abs] = isSym; // If it's not a symlink or a dir, then it's definitely a regular file.
  // don't bother doing a readdir in that case.

  if (!isSym && lstat && !lstat.isDirectory()) this.cache[abs] = 'FILE';else entries = this._readdir(abs, false);
  return entries;
};

GlobSync$1.prototype._readdir = function (abs, inGlobStar) {
  var entries;
  if (inGlobStar && !ownProp$1(this.symlinks, abs)) return this._readdirInGlobStar(abs);

  if (ownProp$1(this.cache, abs)) {
    var c = this.cache[abs];
    if (!c || c === 'FILE') return null;
    if (Array.isArray(c)) return c;
  }

  try {
    return this._readdirEntries(abs, fs.readdirSync(abs));
  } catch (er) {
    this._readdirError(abs, er);

    return null;
  }
};

GlobSync$1.prototype._readdirEntries = function (abs, entries) {
  // if we haven't asked to stat everything, then just
  // assume that everything in there exists, so we can avoid
  // having to stat it a second time.
  if (!this.mark && !this.stat) {
    for (var i = 0; i < entries.length; i++) {
      var e = entries[i];
      if (abs === '/') e = abs + e;else e = abs + '/' + e;
      this.cache[e] = true;
    }
  }

  this.cache[abs] = entries; // mark and cache dir-ness

  return entries;
};

GlobSync$1.prototype._readdirError = function (f, er) {
  // handle errors, and cache the information
  switch (er.code) {
    case 'ENOTSUP': // https://github.com/isaacs/node-glob/issues/205

    case 'ENOTDIR':
      // totally normal. means it *does* exist.
      var abs = this._makeAbs(f);

      this.cache[abs] = 'FILE';

      if (abs === this.cwdAbs) {
        var error = new Error(er.code + ' invalid cwd ' + this.cwd);
        error.path = this.cwd;
        error.code = er.code;
        throw error;
      }

      break;

    case 'ENOENT': // not terribly unusual

    case 'ELOOP':
    case 'ENAMETOOLONG':
    case 'UNKNOWN':
      this.cache[this._makeAbs(f)] = false;
      break;

    default:
      // some unusual error.  Treat as failure.
      this.cache[this._makeAbs(f)] = false;
      if (this.strict) throw er;
      if (!this.silent) console.error('glob error', er);
      break;
  }
};

GlobSync$1.prototype._processGlobStar = function (prefix, read, abs, remain, index, inGlobStar) {
  var entries = this._readdir(abs, inGlobStar); // no entries means not a dir, so it can never have matches
  // foo.txt/** doesn't match foo.txt


  if (!entries) return; // test without the globstar, and with every child both below
  // and replacing the globstar.

  var remainWithoutGlobStar = remain.slice(1);
  var gspref = prefix ? [prefix] : [];
  var noGlobStar = gspref.concat(remainWithoutGlobStar); // the noGlobStar pattern exits the inGlobStar state

  this._process(noGlobStar, index, false);

  var len = entries.length;
  var isSym = this.symlinks[abs]; // If it's a symlink, and we're in a globstar, then stop

  if (isSym && inGlobStar) return;

  for (var i = 0; i < len; i++) {
    var e = entries[i];
    if (e.charAt(0) === '.' && !this.dot) continue; // these two cases enter the inGlobStar state

    var instead = gspref.concat(entries[i], remainWithoutGlobStar);

    this._process(instead, index, true);

    var below = gspref.concat(entries[i], remain);

    this._process(below, index, true);
  }
};

GlobSync$1.prototype._processSimple = function (prefix, index) {
  // XXX review this.  Shouldn't it be doing the mounting etc
  // before doing stat?  kinda weird?
  var exists = this._stat(prefix);

  if (!this.matches[index]) this.matches[index] = Object.create(null); // If it doesn't exist, then just mark the lack of results

  if (!exists) return;

  if (prefix && pathIsAbsolute(prefix) && !this.nomount) {
    var trail = /[\/\\]$/.test(prefix);

    if (prefix.charAt(0) === '/') {
      prefix = path.join(this.root, prefix);
    } else {
      prefix = path.resolve(this.root, prefix);
      if (trail) prefix += '/';
    }
  }

  if (process.platform === 'win32') prefix = prefix.replace(/\\/g, '/'); // Mark this as a match

  this._emitMatch(index, prefix);
}; // Returns either 'DIR', 'FILE', or false


GlobSync$1.prototype._stat = function (f) {
  var abs = this._makeAbs(f);

  var needDir = f.slice(-1) === '/';
  if (f.length > this.maxLength) return false;

  if (!this.stat && ownProp$1(this.cache, abs)) {
    var c = this.cache[abs];
    if (Array.isArray(c)) c = 'DIR'; // It exists, but maybe not how we need it

    if (!needDir || c === 'DIR') return c;
    if (needDir && c === 'FILE') return false; // otherwise we have to stat, because maybe c=true
    // if we know it exists, but not what it is.
  }

  var exists;
  var stat = this.statCache[abs];

  if (!stat) {
    var lstat;

    try {
      lstat = fs.lstatSync(abs);
    } catch (er) {
      if (er && (er.code === 'ENOENT' || er.code === 'ENOTDIR')) {
        this.statCache[abs] = false;
        return false;
      }
    }

    if (lstat && lstat.isSymbolicLink()) {
      try {
        stat = fs.statSync(abs);
      } catch (er) {
        stat = lstat;
      }
    } else {
      stat = lstat;
    }
  }

  this.statCache[abs] = stat;
  var c = true;
  if (stat) c = stat.isDirectory() ? 'DIR' : 'FILE';
  this.cache[abs] = this.cache[abs] || c;
  if (needDir && c === 'FILE') return false;
  return c;
};

GlobSync$1.prototype._mark = function (p) {
  return common$4.mark(this, p);
};

GlobSync$1.prototype._makeAbs = function (f) {
  return common$4.makeAbs(this, f);
};

// Returns a wrapper function that returns a wrapped callback
// The wrapper function should do some stuff, and return a
// presumably different callback function.
// This makes sure that own properties are retained, so that
// decorations and such are not lost along the way.
var wrappy_1 = wrappy;

function wrappy(fn, cb) {
  if (fn && cb) return wrappy(fn)(cb);
  if (typeof fn !== 'function') throw new TypeError('need wrapper function');
  Object.keys(fn).forEach(function (k) {
    wrapper[k] = fn[k];
  });
  return wrapper;

  function wrapper() {
    var args = new Array(arguments.length);

    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }

    var ret = fn.apply(this, args);
    var cb = args[args.length - 1];

    if (typeof ret === 'function' && ret !== cb) {
      Object.keys(cb).forEach(function (k) {
        ret[k] = cb[k];
      });
    }

    return ret;
  }
}

var once_1 = wrappy_1(once);
var strict = wrappy_1(onceStrict);
once.proto = once(function () {
  Object.defineProperty(Function.prototype, 'once', {
    value: function value() {
      return once(this);
    },
    configurable: true
  });
  Object.defineProperty(Function.prototype, 'onceStrict', {
    value: function value() {
      return onceStrict(this);
    },
    configurable: true
  });
});

function once(fn) {
  var f = function f() {
    if (f.called) return f.value;
    f.called = true;
    return f.value = fn.apply(this, arguments);
  };

  f.called = false;
  return f;
}

function onceStrict(fn) {
  var f = function f() {
    if (f.called) throw new Error(f.onceError);
    f.called = true;
    return f.value = fn.apply(this, arguments);
  };

  var name = fn.name || 'Function wrapped with `once`';
  f.onceError = name + " shouldn't be called more than once";
  f.called = false;
  return f;
}

once_1.strict = strict;

var reqs = Object.create(null);
var inflight_1 = wrappy_1(inflight);

function inflight(key, cb) {
  if (reqs[key]) {
    reqs[key].push(cb);
    return null;
  } else {
    reqs[key] = [cb];
    return makeres(key);
  }
}

function makeres(key) {
  return once_1(function RES() {
    var cbs = reqs[key];
    var len = cbs.length;
    var args = slice(arguments); // XXX It's somewhat ambiguous whether a new callback added in this
    // pass should be queued for later execution if something in the
    // list of callbacks throws, or if it should just be discarded.
    // However, it's such an edge case that it hardly matters, and either
    // choice is likely as surprising as the other.
    // As it happens, we do go ahead and schedule it for later execution.

    try {
      for (var i = 0; i < len; i++) {
        cbs[i].apply(null, args);
      }
    } finally {
      if (cbs.length > len) {
        // added more in the interim.
        // de-zalgo, just in case, but don't call again.
        cbs.splice(0, len);
        process.nextTick(function () {
          RES.apply(null, args);
        });
      } else {
        delete reqs[key];
      }
    }
  });
}

function slice(args) {
  var length = args.length;
  var array = [];

  for (var i = 0; i < length; i++) {
    array[i] = args[i];
  }

  return array;
}

//
// 1. Get the minimatch set
// 2. For each pattern in the set, PROCESS(pattern, false)
// 3. Store matches per-set, then uniq them
//
// PROCESS(pattern, inGlobStar)
// Get the first [n] items from pattern that are all strings
// Join these together.  This is PREFIX.
//   If there is no more remaining, then stat(PREFIX) and
//   add to matches if it succeeds.  END.
//
// If inGlobStar and PREFIX is symlink and points to dir
//   set ENTRIES = []
// else readdir(PREFIX) as ENTRIES
//   If fail, END
//
// with ENTRIES
//   If pattern[n] is GLOBSTAR
//     // handle the case where the globstar match is empty
//     // by pruning it out, and testing the resulting pattern
//     PROCESS(pattern[0..n] + pattern[n+1 .. $], false)
//     // handle other cases.
//     for ENTRY in ENTRIES (not dotfiles)
//       // attach globstar + tail onto the entry
//       // Mark that this entry is a globstar match
//       PROCESS(pattern[0..n] + ENTRY + pattern[n .. $], true)
//
//   else // not globstar
//     for ENTRY in ENTRIES (not dotfiles, unless pattern[n] is dot)
//       Test ENTRY against pattern[n]
//       If fails, continue
//       If passes, PROCESS(pattern[0..n] + item + pattern[n+1 .. $])
//
// Caveat:
//   Cache all stats and readdirs results to minimize syscall.  Since all
//   we ever care about is existence and directory-ness, we can just keep
//   `true` for files, and [children,...] for directories, or `false` for
//   things that don't exist.

var glob_1 = glob;
var EE = events.EventEmitter;
var setopts = common$4.setopts;
var ownProp = common$4.ownProp;
var childrenIgnored = common$4.childrenIgnored;
var isIgnored = common$4.isIgnored;

function glob(pattern, options, cb) {
  if (typeof options === 'function') cb = options, options = {};
  if (!options) options = {};

  if (options.sync) {
    if (cb) throw new TypeError('callback provided to sync glob');
    return sync$1(pattern, options);
  }

  return new Glob(pattern, options, cb);
}

glob.sync = sync$1;
var GlobSync = glob.GlobSync = sync$1.GlobSync; // old api surface

glob.glob = glob;

function extend(origin, add) {
  if (add === null || typeof add !== 'object') {
    return origin;
  }

  var keys = Object.keys(add);
  var i = keys.length;

  while (i--) {
    origin[keys[i]] = add[keys[i]];
  }

  return origin;
}

glob.hasMagic = function (pattern, options_) {
  var options = extend({}, options_);
  options.noprocess = true;
  var g = new Glob(pattern, options);
  var set = g.minimatch.set;
  if (!pattern) return false;
  if (set.length > 1) return true;

  for (var j = 0; j < set[0].length; j++) {
    if (typeof set[0][j] !== 'string') return true;
  }

  return false;
};

glob.Glob = Glob;
inherits(Glob, EE);

function Glob(pattern, options, cb) {
  if (typeof options === 'function') {
    cb = options;
    options = null;
  }

  if (options && options.sync) {
    if (cb) throw new TypeError('callback provided to sync glob');
    return new GlobSync(pattern, options);
  }

  if (!(this instanceof Glob)) return new Glob(pattern, options, cb);
  setopts(this, pattern, options);
  this._didRealPath = false; // process each pattern in the minimatch set

  var n = this.minimatch.set.length; // The matches are stored as {<filename>: true,...} so that
  // duplicates are automagically pruned.
  // Later, we do an Object.keys() on these.
  // Keep them as a list so we can fill in when nonull is set.

  this.matches = new Array(n);

  if (typeof cb === 'function') {
    cb = once_1(cb);
    this.on('error', cb);
    this.on('end', function (matches) {
      cb(null, matches);
    });
  }

  var self = this;
  this._processing = 0;
  this._emitQueue = [];
  this._processQueue = [];
  this.paused = false;
  if (this.noprocess) return this;
  if (n === 0) return done();
  var sync = true;

  for (var i = 0; i < n; i++) {
    this._process(this.minimatch.set[i], i, false, done);
  }

  sync = false;

  function done() {
    --self._processing;

    if (self._processing <= 0) {
      if (sync) {
        process.nextTick(function () {
          self._finish();
        });
      } else {
        self._finish();
      }
    }
  }
}

Glob.prototype._finish = function () {
  assert(this instanceof Glob);
  if (this.aborted) return;
  if (this.realpath && !this._didRealpath) return this._realpath();
  common$4.finish(this);
  this.emit('end', this.found);
};

Glob.prototype._realpath = function () {
  if (this._didRealpath) return;
  this._didRealpath = true;
  var n = this.matches.length;
  if (n === 0) return this._finish();
  var self = this;

  for (var i = 0; i < this.matches.length; i++) {
    this._realpathSet(i, next);
  }

  function next() {
    if (--n === 0) self._finish();
  }
};

Glob.prototype._realpathSet = function (index, cb) {
  var matchset = this.matches[index];
  if (!matchset) return cb();
  var found = Object.keys(matchset);
  var self = this;
  var n = found.length;
  if (n === 0) return cb();
  var set = this.matches[index] = Object.create(null);
  found.forEach(function (p, i) {
    // If there's a problem with the stat, then it means that
    // one or more of the links in the realpath couldn't be
    // resolved.  just return the abs value in that case.
    p = self._makeAbs(p);
    fs_realpath.realpath(p, self.realpathCache, function (er, real) {
      if (!er) set[real] = true;else if (er.syscall === 'stat') set[p] = true;else self.emit('error', er); // srsly wtf right here

      if (--n === 0) {
        self.matches[index] = set;
        cb();
      }
    });
  });
};

Glob.prototype._mark = function (p) {
  return common$4.mark(this, p);
};

Glob.prototype._makeAbs = function (f) {
  return common$4.makeAbs(this, f);
};

Glob.prototype.abort = function () {
  this.aborted = true;
  this.emit('abort');
};

Glob.prototype.pause = function () {
  if (!this.paused) {
    this.paused = true;
    this.emit('pause');
  }
};

Glob.prototype.resume = function () {
  if (this.paused) {
    this.emit('resume');
    this.paused = false;

    if (this._emitQueue.length) {
      var eq = this._emitQueue.slice(0);

      this._emitQueue.length = 0;

      for (var i = 0; i < eq.length; i++) {
        var e = eq[i];

        this._emitMatch(e[0], e[1]);
      }
    }

    if (this._processQueue.length) {
      var pq = this._processQueue.slice(0);

      this._processQueue.length = 0;

      for (var i = 0; i < pq.length; i++) {
        var p = pq[i];
        this._processing--;

        this._process(p[0], p[1], p[2], p[3]);
      }
    }
  }
};

Glob.prototype._process = function (pattern, index, inGlobStar, cb) {
  assert(this instanceof Glob);
  assert(typeof cb === 'function');
  if (this.aborted) return;
  this._processing++;

  if (this.paused) {
    this._processQueue.push([pattern, index, inGlobStar, cb]);

    return;
  } //console.error('PROCESS %d', this._processing, pattern)
  // Get the first [n] parts of pattern that are all strings.


  var n = 0;

  while (typeof pattern[n] === 'string') {
    n++;
  } // now n is the index of the first one that is *not* a string.
  // see if there's anything else


  var prefix;

  switch (n) {
    // if not, then this is rather simple
    case pattern.length:
      this._processSimple(pattern.join('/'), index, cb);

      return;

    case 0:
      // pattern *starts* with some non-trivial item.
      // going to readdir(cwd), but not include the prefix in matches.
      prefix = null;
      break;

    default:
      // pattern has some string bits in the front.
      // whatever it starts with, whether that's 'absolute' like /foo/bar,
      // or 'relative' like '../baz'
      prefix = pattern.slice(0, n).join('/');
      break;
  }

  var remain = pattern.slice(n); // get the list of entries.

  var read;
  if (prefix === null) read = '.';else if (pathIsAbsolute(prefix) || pathIsAbsolute(pattern.join('/'))) {
    if (!prefix || !pathIsAbsolute(prefix)) prefix = '/' + prefix;
    read = prefix;
  } else read = prefix;

  var abs = this._makeAbs(read); //if ignored, skip _processing


  if (childrenIgnored(this, read)) return cb();
  var isGlobStar = remain[0] === minimatch_1.GLOBSTAR;
  if (isGlobStar) this._processGlobStar(prefix, read, abs, remain, index, inGlobStar, cb);else this._processReaddir(prefix, read, abs, remain, index, inGlobStar, cb);
};

Glob.prototype._processReaddir = function (prefix, read, abs, remain, index, inGlobStar, cb) {
  var self = this;

  this._readdir(abs, inGlobStar, function (er, entries) {
    return self._processReaddir2(prefix, read, abs, remain, index, inGlobStar, entries, cb);
  });
};

Glob.prototype._processReaddir2 = function (prefix, read, abs, remain, index, inGlobStar, entries, cb) {
  // if the abs isn't a dir, then nothing can match!
  if (!entries) return cb(); // It will only match dot entries if it starts with a dot, or if
  // dot is set.  Stuff like @(.foo|.bar) isn't allowed.

  var pn = remain[0];
  var negate = !!this.minimatch.negate;
  var rawGlob = pn._glob;
  var dotOk = this.dot || rawGlob.charAt(0) === '.';
  var matchedEntries = [];

  for (var i = 0; i < entries.length; i++) {
    var e = entries[i];

    if (e.charAt(0) !== '.' || dotOk) {
      var m;

      if (negate && !prefix) {
        m = !e.match(pn);
      } else {
        m = e.match(pn);
      }

      if (m) matchedEntries.push(e);
    }
  } //console.error('prd2', prefix, entries, remain[0]._glob, matchedEntries)


  var len = matchedEntries.length; // If there are no matched entries, then nothing matches.

  if (len === 0) return cb(); // if this is the last remaining pattern bit, then no need for
  // an additional stat *unless* the user has specified mark or
  // stat explicitly.  We know they exist, since readdir returned
  // them.

  if (remain.length === 1 && !this.mark && !this.stat) {
    if (!this.matches[index]) this.matches[index] = Object.create(null);

    for (var i = 0; i < len; i++) {
      var e = matchedEntries[i];

      if (prefix) {
        if (prefix !== '/') e = prefix + '/' + e;else e = prefix + e;
      }

      if (e.charAt(0) === '/' && !this.nomount) {
        e = path.join(this.root, e);
      }

      this._emitMatch(index, e);
    } // This was the last one, and no stats were needed


    return cb();
  } // now test all matched entries as stand-ins for that part
  // of the pattern.


  remain.shift();

  for (var i = 0; i < len; i++) {
    var e = matchedEntries[i];
    var newPattern;

    if (prefix) {
      if (prefix !== '/') e = prefix + '/' + e;else e = prefix + e;
    }

    this._process([e].concat(remain), index, inGlobStar, cb);
  }

  cb();
};

Glob.prototype._emitMatch = function (index, e) {
  if (this.aborted) return;
  if (isIgnored(this, e)) return;

  if (this.paused) {
    this._emitQueue.push([index, e]);

    return;
  }

  var abs = pathIsAbsolute(e) ? e : this._makeAbs(e);
  if (this.mark) e = this._mark(e);
  if (this.absolute) e = abs;
  if (this.matches[index][e]) return;

  if (this.nodir) {
    var c = this.cache[abs];
    if (c === 'DIR' || Array.isArray(c)) return;
  }

  this.matches[index][e] = true;
  var st = this.statCache[abs];
  if (st) this.emit('stat', e, st);
  this.emit('match', e);
};

Glob.prototype._readdirInGlobStar = function (abs, cb) {
  if (this.aborted) return; // follow all symlinked directories forever
  // just proceed as if this is a non-globstar situation

  if (this.follow) return this._readdir(abs, false, cb);
  var lstatkey = 'lstat\0' + abs;
  var self = this;
  var lstatcb = inflight_1(lstatkey, lstatcb_);
  if (lstatcb) fs.lstat(abs, lstatcb);

  function lstatcb_(er, lstat) {
    if (er && er.code === 'ENOENT') return cb();
    var isSym = lstat && lstat.isSymbolicLink();
    self.symlinks[abs] = isSym; // If it's not a symlink or a dir, then it's definitely a regular file.
    // don't bother doing a readdir in that case.

    if (!isSym && lstat && !lstat.isDirectory()) {
      self.cache[abs] = 'FILE';
      cb();
    } else self._readdir(abs, false, cb);
  }
};

Glob.prototype._readdir = function (abs, inGlobStar, cb) {
  if (this.aborted) return;
  cb = inflight_1('readdir\0' + abs + '\0' + inGlobStar, cb);
  if (!cb) return; //console.error('RD %j %j', +inGlobStar, abs)

  if (inGlobStar && !ownProp(this.symlinks, abs)) return this._readdirInGlobStar(abs, cb);

  if (ownProp(this.cache, abs)) {
    var c = this.cache[abs];
    if (!c || c === 'FILE') return cb();
    if (Array.isArray(c)) return cb(null, c);
  }

  var self = this;
  fs.readdir(abs, readdirCb(this, abs, cb));
};

function readdirCb(self, abs, cb) {
  return function (er, entries) {
    if (er) self._readdirError(abs, er, cb);else self._readdirEntries(abs, entries, cb);
  };
}

Glob.prototype._readdirEntries = function (abs, entries, cb) {
  if (this.aborted) return; // if we haven't asked to stat everything, then just
  // assume that everything in there exists, so we can avoid
  // having to stat it a second time.

  if (!this.mark && !this.stat) {
    for (var i = 0; i < entries.length; i++) {
      var e = entries[i];
      if (abs === '/') e = abs + e;else e = abs + '/' + e;
      this.cache[e] = true;
    }
  }

  this.cache[abs] = entries;
  return cb(null, entries);
};

Glob.prototype._readdirError = function (f, er, cb) {
  if (this.aborted) return; // handle errors, and cache the information

  switch (er.code) {
    case 'ENOTSUP': // https://github.com/isaacs/node-glob/issues/205

    case 'ENOTDIR':
      // totally normal. means it *does* exist.
      var abs = this._makeAbs(f);

      this.cache[abs] = 'FILE';

      if (abs === this.cwdAbs) {
        var error = new Error(er.code + ' invalid cwd ' + this.cwd);
        error.path = this.cwd;
        error.code = er.code;
        this.emit('error', error);
        this.abort();
      }

      break;

    case 'ENOENT': // not terribly unusual

    case 'ELOOP':
    case 'ENAMETOOLONG':
    case 'UNKNOWN':
      this.cache[this._makeAbs(f)] = false;
      break;

    default:
      // some unusual error.  Treat as failure.
      this.cache[this._makeAbs(f)] = false;

      if (this.strict) {
        this.emit('error', er); // If the error is handled, then we abort
        // if not, we threw out of here

        this.abort();
      }

      if (!this.silent) console.error('glob error', er);
      break;
  }

  return cb();
};

Glob.prototype._processGlobStar = function (prefix, read, abs, remain, index, inGlobStar, cb) {
  var self = this;

  this._readdir(abs, inGlobStar, function (er, entries) {
    self._processGlobStar2(prefix, read, abs, remain, index, inGlobStar, entries, cb);
  });
};

Glob.prototype._processGlobStar2 = function (prefix, read, abs, remain, index, inGlobStar, entries, cb) {
  //console.error('pgs2', prefix, remain[0], entries)
  // no entries means not a dir, so it can never have matches
  // foo.txt/** doesn't match foo.txt
  if (!entries) return cb(); // test without the globstar, and with every child both below
  // and replacing the globstar.

  var remainWithoutGlobStar = remain.slice(1);
  var gspref = prefix ? [prefix] : [];
  var noGlobStar = gspref.concat(remainWithoutGlobStar); // the noGlobStar pattern exits the inGlobStar state

  this._process(noGlobStar, index, false, cb);

  var isSym = this.symlinks[abs];
  var len = entries.length; // If it's a symlink, and we're in a globstar, then stop

  if (isSym && inGlobStar) return cb();

  for (var i = 0; i < len; i++) {
    var e = entries[i];
    if (e.charAt(0) === '.' && !this.dot) continue; // these two cases enter the inGlobStar state

    var instead = gspref.concat(entries[i], remainWithoutGlobStar);

    this._process(instead, index, true, cb);

    var below = gspref.concat(entries[i], remain);

    this._process(below, index, true, cb);
  }

  cb();
};

Glob.prototype._processSimple = function (prefix, index, cb) {
  // XXX review this.  Shouldn't it be doing the mounting etc
  // before doing stat?  kinda weird?
  var self = this;

  this._stat(prefix, function (er, exists) {
    self._processSimple2(prefix, index, er, exists, cb);
  });
};

Glob.prototype._processSimple2 = function (prefix, index, er, exists, cb) {
  //console.error('ps2', prefix, exists)
  if (!this.matches[index]) this.matches[index] = Object.create(null); // If it doesn't exist, then just mark the lack of results

  if (!exists) return cb();

  if (prefix && pathIsAbsolute(prefix) && !this.nomount) {
    var trail = /[\/\\]$/.test(prefix);

    if (prefix.charAt(0) === '/') {
      prefix = path.join(this.root, prefix);
    } else {
      prefix = path.resolve(this.root, prefix);
      if (trail) prefix += '/';
    }
  }

  if (process.platform === 'win32') prefix = prefix.replace(/\\/g, '/'); // Mark this as a match

  this._emitMatch(index, prefix);

  cb();
}; // Returns either 'DIR', 'FILE', or false


Glob.prototype._stat = function (f, cb) {
  var abs = this._makeAbs(f);

  var needDir = f.slice(-1) === '/';
  if (f.length > this.maxLength) return cb();

  if (!this.stat && ownProp(this.cache, abs)) {
    var c = this.cache[abs];
    if (Array.isArray(c)) c = 'DIR'; // It exists, but maybe not how we need it

    if (!needDir || c === 'DIR') return cb(null, c);
    if (needDir && c === 'FILE') return cb(); // otherwise we have to stat, because maybe c=true
    // if we know it exists, but not what it is.
  }

  var exists;
  var stat = this.statCache[abs];

  if (stat !== undefined) {
    if (stat === false) return cb(null, stat);else {
      var type = stat.isDirectory() ? 'DIR' : 'FILE';
      if (needDir && type === 'FILE') return cb();else return cb(null, type, stat);
    }
  }

  var self = this;
  var statcb = inflight_1('stat\0' + abs, lstatcb_);
  if (statcb) fs.lstat(abs, statcb);

  function lstatcb_(er, lstat) {
    if (lstat && lstat.isSymbolicLink()) {
      // If it's a symlink, then treat it as the target, unless
      // the target does not exist, then treat it as a file.
      return fs.stat(abs, function (er, stat) {
        if (er) self._stat2(f, abs, null, lstat, cb);else self._stat2(f, abs, er, stat, cb);
      });
    } else {
      self._stat2(f, abs, er, lstat, cb);
    }
  }
};

Glob.prototype._stat2 = function (f, abs, er, stat, cb) {
  if (er && (er.code === 'ENOENT' || er.code === 'ENOTDIR')) {
    this.statCache[abs] = false;
    return cb();
  }

  var needDir = f.slice(-1) === '/';
  this.statCache[abs] = stat;
  if (abs.slice(-1) === '/' && stat && !stat.isDirectory()) return cb(null, false, stat);
  var c = true;
  if (stat) c = stat.isDirectory() ? 'DIR' : 'FILE';
  this.cache[abs] = this.cache[abs] || c;
  if (needDir && c === 'FILE') return cb();
  return cb(null, c, stat);
};

var pify_1 = createCommonjsModule(function (module) {
  'use strict';

  var processFn = function processFn(fn, P, opts) {
    return function () {
      var that = this;
      var args = new Array(arguments.length);

      for (var i = 0; i < arguments.length; i++) {
        args[i] = arguments[i];
      }

      return new P(function (resolve, reject) {
        args.push(function (err, result) {
          if (err) {
            reject(err);
          } else if (opts.multiArgs) {
            var results = new Array(arguments.length - 1);

            for (var i = 1; i < arguments.length; i++) {
              results[i - 1] = arguments[i];
            }

            resolve(results);
          } else {
            resolve(result);
          }
        });
        fn.apply(that, args);
      });
    };
  };

  var pify = module.exports = function (obj, P, opts) {
    if (typeof P !== 'function') {
      opts = P;
      P = Promise;
    }

    opts = opts || {};
    opts.exclude = opts.exclude || [/.+Sync$/];

    var filter = function filter(key) {
      var match = function match(pattern) {
        return typeof pattern === 'string' ? key === pattern : pattern.test(key);
      };

      return opts.include ? opts.include.some(match) : !opts.exclude.some(match);
    };

    var ret = typeof obj === 'function' ? function () {
      if (opts.excludeMain) {
        return obj.apply(this, arguments);
      }

      return processFn(obj, P, opts).apply(this, arguments);
    } : {};
    return Object.keys(obj).reduce(function (ret, key) {
      var x = obj[key];
      ret[key] = typeof x === 'function' && filter(key) ? processFn(x, P, opts) : x;
      return ret;
    }, ret);
  };

  pify.all = pify;
});

var globP = pify_1(glob_1, pinkiePromise).bind(glob_1);

function isNegative(pattern) {
  return pattern[0] === '!';
}

function isString(value) {
  return typeof value === 'string';
}

function assertPatternsInput(patterns) {
  if (!patterns.every(isString)) {
    throw new TypeError('patterns must be a string or an array of strings');
  }
}

function generateGlobTasks(patterns, opts) {
  patterns = [].concat(patterns);
  assertPatternsInput(patterns);
  var globTasks = [];
  opts = objectAssign({
    cache: Object.create(null),
    statCache: Object.create(null),
    realpathCache: Object.create(null),
    symlinks: Object.create(null),
    ignore: []
  }, opts);
  patterns.forEach(function (pattern, i) {
    if (isNegative(pattern)) {
      return;
    }

    var ignore = patterns.slice(i).filter(isNegative).map(function (pattern) {
      return pattern.slice(1);
    });
    globTasks.push({
      pattern: pattern,
      opts: objectAssign({}, opts, {
        ignore: opts.ignore.concat(ignore)
      })
    });
  });
  return globTasks;
}

var globby = function globby(patterns, opts) {
  var globTasks;

  try {
    globTasks = generateGlobTasks(patterns, opts);
  } catch (err) {
    return pinkiePromise.reject(err);
  }

  return pinkiePromise.all(globTasks.map(function (task) {
    return globP(task.pattern, task.opts);
  })).then(function (paths) {
    return arrayUnion.apply(null, paths);
  });
};

var sync = function sync(patterns, opts) {
  var globTasks = generateGlobTasks(patterns, opts);
  return globTasks.reduce(function (matches, task) {
    return arrayUnion(matches, glob_1.sync(task.pattern, task.opts));
  }, []);
};

var generateGlobTasks_1 = generateGlobTasks;

var hasMagic = function hasMagic(patterns, opts) {
  return [].concat(patterns).some(function (pattern) {
    return glob_1.hasMagic(pattern, opts);
  });
};

globby.sync = sync;
globby.generateGlobTasks = generateGlobTasks_1;
globby.hasMagic = hasMagic;

var assert$2 = true;
var buffer_ieee754 = "< 0.9.7";
var buffer = true;
var child_process = true;
var cluster = true;
var console$1 = true;
var constants = true;
var crypto = true;
var _debugger = "< 8";
var dgram = true;
var dns = true;
var domain = true;
var events$1 = true;
var freelist = "< 6";
var fs$2 = true;
var http = true;
var http2 = ">= 8.8";
var https = true;
var _http_server = ">= 0.11";
var _linklist = "< 8";
var module$1 = true;
var net = true;
var os$1 = true;
var path$3 = true;
var perf_hooks = ">= 8.5";
var process$1 = ">= 1";
var punycode = true;
var querystring = true;
var readline$1 = true;
var repl = true;
var stream = true;
var string_decoder = true;
var sys = true;
var timers = true;
var tls = true;
var tty = true;
var url = true;
var util$4 = true;
var v8 = ">= 1";
var vm = true;
var zlib = true;
var core$3 = {
  assert: assert$2,
  buffer_ieee754: buffer_ieee754,
  buffer: buffer,
  child_process: child_process,
  cluster: cluster,
  console: console$1,
  constants: constants,
  crypto: crypto,
  _debugger: _debugger,
  dgram: dgram,
  dns: dns,
  domain: domain,
  events: events$1,
  freelist: freelist,
  fs: fs$2,
  http: http,
  http2: http2,
  https: https,
  _http_server: _http_server,
  _linklist: _linklist,
  module: module$1,
  net: net,
  os: os$1,
  path: path$3,
  perf_hooks: perf_hooks,
  process: process$1,
  punycode: punycode,
  querystring: querystring,
  readline: readline$1,
  repl: repl,
  stream: stream,
  string_decoder: string_decoder,
  sys: sys,
  timers: timers,
  tls: tls,
  tty: tty,
  url: url,
  util: util$4,
  v8: v8,
  vm: vm,
  zlib: zlib
};

var core$4 = Object.freeze({
	assert: assert$2,
	buffer_ieee754: buffer_ieee754,
	buffer: buffer,
	child_process: child_process,
	cluster: cluster,
	console: console$1,
	constants: constants,
	crypto: crypto,
	_debugger: _debugger,
	dgram: dgram,
	dns: dns,
	domain: domain,
	events: events$1,
	freelist: freelist,
	fs: fs$2,
	http: http,
	http2: http2,
	https: https,
	_http_server: _http_server,
	_linklist: _linklist,
	module: module$1,
	net: net,
	os: os$1,
	path: path$3,
	perf_hooks: perf_hooks,
	process: process$1,
	punycode: punycode,
	querystring: querystring,
	readline: readline$1,
	repl: repl,
	stream: stream,
	string_decoder: string_decoder,
	sys: sys,
	timers: timers,
	tls: tls,
	tty: tty,
	url: url,
	util: util$4,
	v8: v8,
	vm: vm,
	zlib: zlib,
	default: core$3
});

var data = ( core$4 && core$3 ) || core$4;

var current = process.versions && process.versions.node && process.versions.node.split('.') || [];

function versionIncluded(specifier) {
  if (specifier === true) {
    return true;
  }

  var parts = specifier.split(' ');
  var op = parts[0];
  var versionParts = parts[1].split('.');

  for (var i = 0; i < 3; ++i) {
    var cur = Number(current[i] || 0);
    var ver = Number(versionParts[i] || 0);

    if (cur === ver) {
      continue; // eslint-disable-line no-restricted-syntax, no-continue
    }

    if (op === '<') {
      return cur < ver;
    } else if (op === '>=') {
      return cur >= ver;
    } else {
      return false;
    }
  }

  return false;
}

var core$2 = {};

for (var mod in data) {
  // eslint-disable-line no-restricted-syntax
  if (Object.prototype.hasOwnProperty.call(data, mod)) {
    core$2[mod] = versionIncluded(data[mod]);
  }
}

var core_1 = core$2;

var caller = function caller() {
  // see https://code.google.com/p/v8/wiki/JavaScriptStackTraceApi
  var origPrepareStackTrace = Error.prepareStackTrace;

  Error.prepareStackTrace = function (_, stack) {
    return stack;
  };

  var stack = new Error().stack;
  Error.prepareStackTrace = origPrepareStackTrace;
  return stack[2].getFileName();
};

var pathParse = createCommonjsModule(function (module) {
  'use strict';

  var isWindows = process.platform === 'win32'; // Regex to split a windows path into three parts: [*, device, slash,
  // tail] windows-only

  var splitDeviceRe = /^([a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?([\\\/])?([\s\S]*?)$/; // Regex to split the tail part of the above into [*, dir, basename, ext]

  var splitTailRe = /^([\s\S]*?)((?:\.{1,2}|[^\\\/]+?|)(\.[^.\/\\]*|))(?:[\\\/]*)$/;
  var win32 = {}; // Function to split a filename into [root, dir, basename, ext]

  function win32SplitPath(filename) {
    // Separate device+slash from tail
    var result = splitDeviceRe.exec(filename),
        device = (result[1] || '') + (result[2] || ''),
        tail = result[3] || ''; // Split the tail into dir, basename and extension

    var result2 = splitTailRe.exec(tail),
        dir = result2[1],
        basename = result2[2],
        ext = result2[3];
    return [device, dir, basename, ext];
  }

  win32.parse = function (pathString) {
    if (typeof pathString !== 'string') {
      throw new TypeError("Parameter 'pathString' must be a string, not " + typeof pathString);
    }

    var allParts = win32SplitPath(pathString);

    if (!allParts || allParts.length !== 4) {
      throw new TypeError("Invalid path '" + pathString + "'");
    }

    return {
      root: allParts[0],
      dir: allParts[0] + allParts[1].slice(0, -1),
      base: allParts[2],
      ext: allParts[3],
      name: allParts[2].slice(0, allParts[2].length - allParts[3].length)
    };
  }; // Split a filename into [root, dir, basename, ext], unix version
  // 'root' is just a slash, or nothing.


  var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
  var posix = {};

  function posixSplitPath(filename) {
    return splitPathRe.exec(filename).slice(1);
  }

  posix.parse = function (pathString) {
    if (typeof pathString !== 'string') {
      throw new TypeError("Parameter 'pathString' must be a string, not " + typeof pathString);
    }

    var allParts = posixSplitPath(pathString);

    if (!allParts || allParts.length !== 4) {
      throw new TypeError("Invalid path '" + pathString + "'");
    }

    allParts[1] = allParts[1] || '';
    allParts[2] = allParts[2] || '';
    allParts[3] = allParts[3] || '';
    return {
      root: allParts[0],
      dir: allParts[0] + allParts[1].slice(0, -1),
      base: allParts[2],
      ext: allParts[3],
      name: allParts[2].slice(0, allParts[2].length - allParts[3].length)
    };
  };

  if (isWindows) module.exports = win32.parse;else
    /* posix */
    module.exports = posix.parse;
  module.exports.posix = posix.parse;
  module.exports.win32 = win32.parse;
});

var parse$4 = path.parse || pathParse;

var nodeModulesPaths = function nodeModulesPaths(start, opts) {
  var modules = opts && opts.moduleDirectory ? [].concat(opts.moduleDirectory) : ['node_modules']; // ensure that `start` is an absolute path at this point,
  // resolving against the process' current working directory

  var absoluteStart = path.resolve(start);

  if (opts && opts.preserveSymlinks === false) {
    try {
      absoluteStart = fs.realpathSync(absoluteStart);
    } catch (err) {
      if (err.code !== 'ENOENT') {
        throw err;
      }
    }
  }

  var prefix = '/';

  if (/^([A-Za-z]:)/.test(absoluteStart)) {
    prefix = '';
  } else if (/^\\\\/.test(absoluteStart)) {
    prefix = '\\\\';
  }

  var paths = [absoluteStart];
  var parsed = parse$4(absoluteStart);

  while (parsed.dir !== paths[paths.length - 1]) {
    paths.push(parsed.dir);
    parsed = parse$4(parsed.dir);
  }

  var dirs = paths.reduce(function (dirs, aPath) {
    return dirs.concat(modules.map(function (moduleDir) {
      return path.join(prefix, aPath, moduleDir);
    }));
  }, []);
  return opts && opts.paths ? dirs.concat(opts.paths) : dirs;
};

var async = function resolve(x, options, callback) {
  var cb = callback;
  var opts = options || {};

  if (typeof opts === 'function') {
    cb = opts;
    opts = {};
  }

  if (typeof x !== 'string') {
    var err = new TypeError('Path must be a string.');
    return process.nextTick(function () {
      cb(err);
    });
  }

  var isFile = opts.isFile || function (file, cb) {
    fs.stat(file, function (err, stat) {
      if (!err) {
        return cb(null, stat.isFile() || stat.isFIFO());
      }

      if (err.code === 'ENOENT' || err.code === 'ENOTDIR') return cb(null, false);
      return cb(err);
    });
  };

  var readFile = opts.readFile || fs.readFile;
  var extensions = opts.extensions || ['.js'];
  var y = opts.basedir || path.dirname(caller());
  opts.paths = opts.paths || [];

  if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
    var res = path.resolve(y, x);
    if (x === '..' || x.slice(-1) === '/') res += '/';

    if (/\/$/.test(x) && res === y) {
      loadAsDirectory(res, opts.package, onfile);
    } else loadAsFile(res, opts.package, onfile);
  } else loadNodeModules(x, y, function (err, n, pkg) {
    if (err) cb(err);else if (n) cb(null, n, pkg);else if (core_1[x]) return cb(null, x);else {
      var moduleError = new Error("Cannot find module '" + x + "' from '" + y + "'");
      moduleError.code = 'MODULE_NOT_FOUND';
      cb(moduleError);
    }
  });

  function onfile(err, m, pkg) {
    if (err) cb(err);else if (m) cb(null, m, pkg);else loadAsDirectory(res, function (err, d, pkg) {
      if (err) cb(err);else if (d) cb(null, d, pkg);else {
        var moduleError = new Error("Cannot find module '" + x + "' from '" + y + "'");
        moduleError.code = 'MODULE_NOT_FOUND';
        cb(moduleError);
      }
    });
  }

  function loadAsFile(x, thePackage, callback) {
    var loadAsFilePackage = thePackage;
    var cb = callback;

    if (typeof loadAsFilePackage === 'function') {
      cb = loadAsFilePackage;
      loadAsFilePackage = undefined;
    }

    var exts = [''].concat(extensions);
    load(exts, x, loadAsFilePackage);

    function load(exts, x, loadPackage) {
      if (exts.length === 0) return cb(null, undefined, loadPackage);
      var file = x + exts[0];
      var pkg = loadPackage;
      if (pkg) onpkg(null, pkg);else loadpkg(path.dirname(file), onpkg);

      function onpkg(err, pkg_, dir) {
        pkg = pkg_;
        if (err) return cb(err);

        if (dir && pkg && opts.pathFilter) {
          var rfile = path.relative(dir, file);
          var rel = rfile.slice(0, rfile.length - exts[0].length);
          var r = opts.pathFilter(pkg, x, rel);
          if (r) return load([''].concat(extensions.slice()), path.resolve(dir, r), pkg);
        }

        isFile(file, onex);
      }

      function onex(err, ex) {
        if (err) return cb(err);
        if (ex) return cb(null, file, pkg);
        load(exts.slice(1), x, pkg);
      }
    }
  }

  function loadpkg(dir, cb) {
    if (dir === '' || dir === '/') return cb(null);

    if (process.platform === 'win32' && /^\w:[/\\]*$/.test(dir)) {
      return cb(null);
    }

    if (/[/\\]node_modules[/\\]*$/.test(dir)) return cb(null);
    var pkgfile = path.join(dir, 'package.json');
    isFile(pkgfile, function (err, ex) {
      // on err, ex is false
      if (!ex) return loadpkg(path.dirname(dir), cb);
      readFile(pkgfile, function (err, body) {
        if (err) cb(err);

        try {
          var pkg = JSON.parse(body);
        } catch (jsonErr) {}

        if (pkg && opts.packageFilter) {
          pkg = opts.packageFilter(pkg, pkgfile);
        }

        cb(null, pkg, dir);
      });
    });
  }

  function loadAsDirectory(x, loadAsDirectoryPackage, callback) {
    var cb = callback;
    var fpkg = loadAsDirectoryPackage;

    if (typeof fpkg === 'function') {
      cb = fpkg;
      fpkg = opts.package;
    }

    var pkgfile = path.join(x, 'package.json');
    isFile(pkgfile, function (err, ex) {
      if (err) return cb(err);
      if (!ex) return loadAsFile(path.join(x, 'index'), fpkg, cb);
      readFile(pkgfile, function (err, body) {
        if (err) return cb(err);

        try {
          var pkg = JSON.parse(body);
        } catch (jsonErr) {}

        if (opts.packageFilter) {
          pkg = opts.packageFilter(pkg, pkgfile);
        }

        if (pkg.main) {
          if (pkg.main === '.' || pkg.main === './') {
            pkg.main = 'index';
          }

          loadAsFile(path.resolve(x, pkg.main), pkg, function (err, m, pkg) {
            if (err) return cb(err);
            if (m) return cb(null, m, pkg);
            if (!pkg) return loadAsFile(path.join(x, 'index'), pkg, cb);
            var dir = path.resolve(x, pkg.main);
            loadAsDirectory(dir, pkg, function (err, n, pkg) {
              if (err) return cb(err);
              if (n) return cb(null, n, pkg);
              loadAsFile(path.join(x, 'index'), pkg, cb);
            });
          });
          return;
        }

        loadAsFile(path.join(x, '/index'), pkg, cb);
      });
    });
  }

  function processDirs(cb, dirs) {
    if (dirs.length === 0) return cb(null, undefined);
    var dir = dirs[0];
    var file = path.join(dir, x);
    loadAsFile(file, undefined, onfile);

    function onfile(err, m, pkg) {
      if (err) return cb(err);
      if (m) return cb(null, m, pkg);
      loadAsDirectory(path.join(dir, x), undefined, ondir);
    }

    function ondir(err, n, pkg) {
      if (err) return cb(err);
      if (n) return cb(null, n, pkg);
      processDirs(cb, dirs.slice(1));
    }
  }

  function loadNodeModules(x, start, cb) {
    processDirs(cb, nodeModulesPaths(start, opts));
  }
};

var sync$3 = function sync(x, options) {
  if (typeof x !== 'string') {
    throw new TypeError('Path must be a string.');
  }

  var opts = options || {};

  var isFile = opts.isFile || function (file) {
    try {
      var stat = fs.statSync(file);
    } catch (e) {
      if (e && (e.code === 'ENOENT' || e.code === 'ENOTDIR')) return false;
      throw e;
    }

    return stat.isFile() || stat.isFIFO();
  };

  var readFileSync = opts.readFileSync || fs.readFileSync;
  var extensions = opts.extensions || ['.js'];
  var y = opts.basedir || path.dirname(caller());
  opts.paths = opts.paths || [];

  if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
    var res = path.resolve(y, x);
    if (x === '..' || x.slice(-1) === '/') res += '/';
    var m = loadAsFileSync(res) || loadAsDirectorySync(res);
    if (m) return m;
  } else {
    var n = loadNodeModulesSync(x, y);
    if (n) return n;
  }

  if (core_1[x]) return x;
  var err = new Error("Cannot find module '" + x + "' from '" + y + "'");
  err.code = 'MODULE_NOT_FOUND';
  throw err;

  function loadAsFileSync(x) {
    if (isFile(x)) {
      return x;
    }

    for (var i = 0; i < extensions.length; i++) {
      var file = x + extensions[i];

      if (isFile(file)) {
        return file;
      }
    }
  }

  function loadAsDirectorySync(x) {
    var pkgfile = path.join(x, '/package.json');

    if (isFile(pkgfile)) {
      try {
        var body = readFileSync(pkgfile, 'UTF8');
        var pkg = JSON.parse(body);

        if (opts.packageFilter) {
          pkg = opts.packageFilter(pkg, x);
        }

        if (pkg.main) {
          if (pkg.main === '.' || pkg.main === './') {
            pkg.main = 'index';
          }

          var m = loadAsFileSync(path.resolve(x, pkg.main));
          if (m) return m;
          var n = loadAsDirectorySync(path.resolve(x, pkg.main));
          if (n) return n;
        }
      } catch (e) {}
    }

    return loadAsFileSync(path.join(x, '/index'));
  }

  function loadNodeModulesSync(x, start) {
    var dirs = nodeModulesPaths(start, opts);

    for (var i = 0; i < dirs.length; i++) {
      var dir = dirs[i];
      var m = loadAsFileSync(path.join(dir, '/', x));
      if (m) return m;
      var n = loadAsDirectorySync(path.join(dir, '/', x));
      if (n) return n;
    }
  }
};

var resolve$1 = createCommonjsModule(function (module, exports) {
  async.core = core_1;

  async.isCore = function isCore(x) {
    return core_1[x];
  };

  async.sync = sync$3;
  exports = async;
  module.exports = async;
});

var addLeadingComment$2 = utilShared.addLeadingComment;
var addTrailingComment$2 = utilShared.addTrailingComment;
var addDanglingComment$2 = utilShared.addDanglingComment;

function handleOwnLineComment(comment, text, options, ast, isLastComment) {
  var precedingNode = comment.precedingNode,
      enclosingNode = comment.enclosingNode,
      followingNode = comment.followingNode;

  if (handleLastFunctionArgComments(text, precedingNode, enclosingNode, followingNode, comment, options) || handleMemberExpressionComments(enclosingNode, followingNode, comment) || handleIfStatementComments(text, precedingNode, enclosingNode, followingNode, comment, options) || handleWhileComments(text, precedingNode, enclosingNode, followingNode, comment, options) || handleTryStatementComments(enclosingNode, precedingNode, followingNode, comment) || handleClassComments(enclosingNode, precedingNode, followingNode, comment) || handleImportSpecifierComments(enclosingNode, comment) || handleForComments(enclosingNode, precedingNode, comment) || handleUnionTypeComments(precedingNode, enclosingNode, followingNode, comment) || handleOnlyComments(enclosingNode, ast, comment, isLastComment) || handleImportDeclarationComments(text, enclosingNode, precedingNode, comment, options) || handleAssignmentPatternComments(enclosingNode, comment) || handleMethodNameComments(text, enclosingNode, precedingNode, comment, options)) {
    return true;
  }

  return false;
}

function handleEndOfLineComment(comment, text, options, ast, isLastComment) {
  var precedingNode = comment.precedingNode,
      enclosingNode = comment.enclosingNode,
      followingNode = comment.followingNode;

  if (handleLastFunctionArgComments(text, precedingNode, enclosingNode, followingNode, comment, options) || handleConditionalExpressionComments(enclosingNode, precedingNode, followingNode, comment, text, options) || handleImportSpecifierComments(enclosingNode, comment) || handleIfStatementComments(text, precedingNode, enclosingNode, followingNode, comment, options) || handleWhileComments(text, precedingNode, enclosingNode, followingNode, comment, options) || handleTryStatementComments(enclosingNode, precedingNode, followingNode, comment) || handleClassComments(enclosingNode, precedingNode, followingNode, comment) || handleLabeledStatementComments(enclosingNode, comment) || handleCallExpressionComments(precedingNode, enclosingNode, comment) || handlePropertyComments(enclosingNode, comment) || handleOnlyComments(enclosingNode, ast, comment, isLastComment) || handleTypeAliasComments(enclosingNode, followingNode, comment) || handleVariableDeclaratorComments(enclosingNode, followingNode, comment)) {
    return true;
  }

  return false;
}

function handleRemainingComment(comment, text, options, ast, isLastComment) {
  var precedingNode = comment.precedingNode,
      enclosingNode = comment.enclosingNode,
      followingNode = comment.followingNode;

  if (handleIfStatementComments(text, precedingNode, enclosingNode, followingNode, comment, options) || handleWhileComments(text, precedingNode, enclosingNode, followingNode, comment, options) || handleObjectPropertyAssignment(enclosingNode, precedingNode, comment) || handleCommentInEmptyParens(text, enclosingNode, comment, options) || handleMethodNameComments(text, enclosingNode, precedingNode, comment, options) || handleOnlyComments(enclosingNode, ast, comment, isLastComment) || handleCommentAfterArrowParams(text, enclosingNode, comment, options) || handleFunctionNameComments(text, enclosingNode, precedingNode, comment, options) || handleTSMappedTypeComments(text, enclosingNode, precedingNode, followingNode, comment) || handleBreakAndContinueStatementComments(enclosingNode, comment)) {
    return true;
  }

  return false;
}

function addBlockStatementFirstComment(node, comment) {
  var body = node.body.filter(function (n) {
    return n.type !== "EmptyStatement";
  });

  if (body.length === 0) {
    addDanglingComment$2(node, comment);
  } else {
    addLeadingComment$2(body[0], comment);
  }
}

function addBlockOrNotComment(node, comment) {
  if (node.type === "BlockStatement") {
    addBlockStatementFirstComment(node, comment);
  } else {
    addLeadingComment$2(node, comment);
  }
} // There are often comments before the else clause of if statements like
//
//   if (1) { ... }
//   // comment
//   else { ... }
//
// They are being attached as leading comments of the BlockExpression which
// is not well printed. What we want is to instead move the comment inside
// of the block and make it leadingComment of the first element of the block
// or dangling comment of the block if there is nothing inside
//
//   if (1) { ... }
//   else {
//     // comment
//     ...
//   }


function handleIfStatementComments(text, precedingNode, enclosingNode, followingNode, comment, options) {
  if (!enclosingNode || enclosingNode.type !== "IfStatement" || !followingNode) {
    return false;
  } // We unfortunately have no way using the AST or location of nodes to know
  // if the comment is positioned before the condition parenthesis:
  //   if (a /* comment */) {}
  // The only workaround I found is to look at the next character to see if
  // it is a ).


  var nextCharacter = util$1.getNextNonSpaceNonCommentCharacter(text, comment, options.locEnd);

  if (nextCharacter === ")") {
    addTrailingComment$2(precedingNode, comment);
    return true;
  } // Comments before `else`:
  // - treat as trailing comments of the consequent, if it's a BlockStatement
  // - treat as a dangling comment otherwise


  if (precedingNode === enclosingNode.consequent && followingNode === enclosingNode.alternate) {
    if (precedingNode.type === "BlockStatement") {
      addTrailingComment$2(precedingNode, comment);
    } else {
      addDanglingComment$2(enclosingNode, comment);
    }

    return true;
  }

  if (followingNode.type === "BlockStatement") {
    addBlockStatementFirstComment(followingNode, comment);
    return true;
  }

  if (followingNode.type === "IfStatement") {
    addBlockOrNotComment(followingNode.consequent, comment);
    return true;
  } // For comments positioned after the condition parenthesis in an if statement
  // before the consequent without brackets on, such as
  // if (a) /* comment */ true,
  // we look at the next character to see if the following node
  // is the consequent for the if statement


  if (enclosingNode.consequent === followingNode) {
    addLeadingComment$2(followingNode, comment);
    return true;
  }

  return false;
}

function handleWhileComments(text, precedingNode, enclosingNode, followingNode, comment, options) {
  if (!enclosingNode || enclosingNode.type !== "WhileStatement" || !followingNode) {
    return false;
  } // We unfortunately have no way using the AST or location of nodes to know
  // if the comment is positioned before the condition parenthesis:
  //   while (a /* comment */) {}
  // The only workaround I found is to look at the next character to see if
  // it is a ).


  var nextCharacter = util$1.getNextNonSpaceNonCommentCharacter(text, comment, options.locEnd);

  if (nextCharacter === ")") {
    addTrailingComment$2(precedingNode, comment);
    return true;
  }

  if (followingNode.type === "BlockStatement") {
    addBlockStatementFirstComment(followingNode, comment);
    return true;
  }

  return false;
} // Same as IfStatement but for TryStatement


function handleTryStatementComments(enclosingNode, precedingNode, followingNode, comment) {
  if (!enclosingNode || enclosingNode.type !== "TryStatement" && enclosingNode.type !== "CatchClause" || !followingNode) {
    return false;
  }

  if (enclosingNode.type === "CatchClause" && precedingNode) {
    addTrailingComment$2(precedingNode, comment);
    return true;
  }

  if (followingNode.type === "BlockStatement") {
    addBlockStatementFirstComment(followingNode, comment);
    return true;
  }

  if (followingNode.type === "TryStatement") {
    addBlockOrNotComment(followingNode.finalizer, comment);
    return true;
  }

  if (followingNode.type === "CatchClause") {
    addBlockOrNotComment(followingNode.body, comment);
    return true;
  }

  return false;
}

function handleMemberExpressionComments(enclosingNode, followingNode, comment) {
  if (enclosingNode && enclosingNode.type === "MemberExpression" && followingNode && followingNode.type === "Identifier") {
    addLeadingComment$2(enclosingNode, comment);
    return true;
  }

  return false;
}

function handleConditionalExpressionComments(enclosingNode, precedingNode, followingNode, comment, text, options) {
  var isSameLineAsPrecedingNode = precedingNode && !util$1.hasNewlineInRange(text, options.locEnd(precedingNode), options.locStart(comment));

  if ((!precedingNode || !isSameLineAsPrecedingNode) && enclosingNode && enclosingNode.type === "ConditionalExpression" && followingNode) {
    addLeadingComment$2(followingNode, comment);
    return true;
  }

  return false;
}

function handleObjectPropertyAssignment(enclosingNode, precedingNode, comment) {
  if (enclosingNode && (enclosingNode.type === "ObjectProperty" || enclosingNode.type === "Property") && enclosingNode.shorthand && enclosingNode.key === precedingNode && enclosingNode.value.type === "AssignmentPattern") {
    addTrailingComment$2(enclosingNode.value.left, comment);
    return true;
  }

  return false;
}

function handleClassComments(enclosingNode, precedingNode, followingNode, comment) {
  if (enclosingNode && (enclosingNode.type === "ClassDeclaration" || enclosingNode.type === "ClassExpression") && enclosingNode.decorators && enclosingNode.decorators.length > 0 && !(followingNode && followingNode.type === "Decorator")) {
    if (!enclosingNode.decorators || enclosingNode.decorators.length === 0) {
      addLeadingComment$2(enclosingNode, comment);
    } else {
      addTrailingComment$2(enclosingNode.decorators[enclosingNode.decorators.length - 1], comment);
    }

    return true;
  }

  return false;
}

function handleMethodNameComments(text, enclosingNode, precedingNode, comment, options) {
  // This is only needed for estree parsers (flow, typescript) to attach
  // after a method name:
  // obj = { fn /*comment*/() {} };
  if (enclosingNode && precedingNode && (enclosingNode.type === "Property" || enclosingNode.type === "MethodDefinition") && precedingNode.type === "Identifier" && enclosingNode.key === precedingNode && // special Property case: { key: /*comment*/(value) };
  // comment should be attached to value instead of key
  util$1.getNextNonSpaceNonCommentCharacter(text, precedingNode, options.locEnd) !== ":") {
    addTrailingComment$2(precedingNode, comment);
    return true;
  } // Print comments between decorators and class methods as a trailing comment
  // on the decorator node instead of the method node


  if (precedingNode && enclosingNode && precedingNode.type === "Decorator" && (enclosingNode.type === "ClassMethod" || enclosingNode.type === "ClassProperty" || enclosingNode.type === "TSAbstractClassProperty" || enclosingNode.type === "TSAbstractMethodDefinition" || enclosingNode.type === "MethodDefinition")) {
    addTrailingComment$2(precedingNode, comment);
    return true;
  }

  return false;
}

function handleFunctionNameComments(text, enclosingNode, precedingNode, comment, options) {
  if (util$1.getNextNonSpaceNonCommentCharacter(text, comment, options.locEnd) !== "(") {
    return false;
  }

  if (precedingNode && enclosingNode && (enclosingNode.type === "FunctionDeclaration" || enclosingNode.type === "FunctionExpression" || enclosingNode.type === "ClassMethod" || enclosingNode.type === "MethodDefinition" || enclosingNode.type === "ObjectMethod")) {
    addTrailingComment$2(precedingNode, comment);
    return true;
  }

  return false;
}

function handleCommentAfterArrowParams(text, enclosingNode, comment, options) {
  if (!(enclosingNode && enclosingNode.type === "ArrowFunctionExpression")) {
    return false;
  }

  var index = utilShared.getNextNonSpaceNonCommentCharacterIndex(text, comment, options);

  if (text.substr(index, 2) === "=>") {
    addDanglingComment$2(enclosingNode, comment);
    return true;
  }

  return false;
}

function handleCommentInEmptyParens(text, enclosingNode, comment, options) {
  if (util$1.getNextNonSpaceNonCommentCharacter(text, comment, options.locEnd) !== ")") {
    return false;
  } // Only add dangling comments to fix the case when no params are present,
  // i.e. a function without any argument.


  if (enclosingNode && ((enclosingNode.type === "FunctionDeclaration" || enclosingNode.type === "FunctionExpression" || enclosingNode.type === "ArrowFunctionExpression" || enclosingNode.type === "ClassMethod" || enclosingNode.type === "ObjectMethod") && enclosingNode.params.length === 0 || (enclosingNode.type === "CallExpression" || enclosingNode.type === "NewExpression") && enclosingNode.arguments.length === 0)) {
    addDanglingComment$2(enclosingNode, comment);
    return true;
  }

  if (enclosingNode && enclosingNode.type === "MethodDefinition" && enclosingNode.value.params.length === 0) {
    addDanglingComment$2(enclosingNode.value, comment);
    return true;
  }

  return false;
}

function handleLastFunctionArgComments(text, precedingNode, enclosingNode, followingNode, comment, options) {
  // Type definitions functions
  if (precedingNode && precedingNode.type === "FunctionTypeParam" && enclosingNode && enclosingNode.type === "FunctionTypeAnnotation" && followingNode && followingNode.type !== "FunctionTypeParam") {
    addTrailingComment$2(precedingNode, comment);
    return true;
  } // Real functions


  if (precedingNode && (precedingNode.type === "Identifier" || precedingNode.type === "AssignmentPattern") && enclosingNode && (enclosingNode.type === "ArrowFunctionExpression" || enclosingNode.type === "FunctionExpression" || enclosingNode.type === "FunctionDeclaration" || enclosingNode.type === "ObjectMethod" || enclosingNode.type === "ClassMethod") && util$1.getNextNonSpaceNonCommentCharacter(text, comment, options.locEnd) === ")") {
    addTrailingComment$2(precedingNode, comment);
    return true;
  }

  if (enclosingNode && enclosingNode.type === "FunctionDeclaration" && followingNode && followingNode.type === "BlockStatement") {
    var functionParamRightParenIndex = function () {
      if (enclosingNode.params.length !== 0) {
        return util$1.getNextNonSpaceNonCommentCharacterIndexWithStartIndex(text, options.locEnd(util$1.getLast(enclosingNode.params)));
      }

      var functionParamLeftParenIndex = util$1.getNextNonSpaceNonCommentCharacterIndexWithStartIndex(text, options.locEnd(enclosingNode.id));
      return util$1.getNextNonSpaceNonCommentCharacterIndexWithStartIndex(text, functionParamLeftParenIndex + 1);
    }();

    if (options.locStart(comment) > functionParamRightParenIndex) {
      addBlockStatementFirstComment(followingNode, comment);
      return true;
    }
  }

  return false;
}

function handleImportSpecifierComments(enclosingNode, comment) {
  if (enclosingNode && enclosingNode.type === "ImportSpecifier") {
    addLeadingComment$2(enclosingNode, comment);
    return true;
  }

  return false;
}

function handleLabeledStatementComments(enclosingNode, comment) {
  if (enclosingNode && enclosingNode.type === "LabeledStatement") {
    addLeadingComment$2(enclosingNode, comment);
    return true;
  }

  return false;
}

function handleBreakAndContinueStatementComments(enclosingNode, comment) {
  if (enclosingNode && (enclosingNode.type === "ContinueStatement" || enclosingNode.type === "BreakStatement") && !enclosingNode.label) {
    addTrailingComment$2(enclosingNode, comment);
    return true;
  }

  return false;
}

function handleCallExpressionComments(precedingNode, enclosingNode, comment) {
  if (enclosingNode && enclosingNode.type === "CallExpression" && precedingNode && enclosingNode.callee === precedingNode && enclosingNode.arguments.length > 0) {
    addLeadingComment$2(enclosingNode.arguments[0], comment);
    return true;
  }

  return false;
}

function handleUnionTypeComments(precedingNode, enclosingNode, followingNode, comment) {
  if (enclosingNode && (enclosingNode.type === "UnionTypeAnnotation" || enclosingNode.type === "TSUnionType")) {
    addTrailingComment$2(precedingNode, comment);
    return true;
  }

  return false;
}

function handlePropertyComments(enclosingNode, comment) {
  if (enclosingNode && (enclosingNode.type === "Property" || enclosingNode.type === "ObjectProperty")) {
    addLeadingComment$2(enclosingNode, comment);
    return true;
  }

  return false;
}

function handleOnlyComments(enclosingNode, ast, comment, isLastComment) {
  // With Flow the enclosingNode is undefined so use the AST instead.
  if (ast && ast.body && ast.body.length === 0) {
    if (isLastComment) {
      addDanglingComment$2(ast, comment);
    } else {
      addLeadingComment$2(ast, comment);
    }

    return true;
  } else if (enclosingNode && enclosingNode.type === "Program" && enclosingNode.body.length === 0 && enclosingNode.directives && enclosingNode.directives.length === 0) {
    if (isLastComment) {
      addDanglingComment$2(enclosingNode, comment);
    } else {
      addLeadingComment$2(enclosingNode, comment);
    }

    return true;
  }

  return false;
}

function handleForComments(enclosingNode, precedingNode, comment) {
  if (enclosingNode && (enclosingNode.type === "ForInStatement" || enclosingNode.type === "ForOfStatement")) {
    addLeadingComment$2(enclosingNode, comment);
    return true;
  }

  return false;
}

function handleImportDeclarationComments(text, enclosingNode, precedingNode, comment, options) {
  if (precedingNode && precedingNode.type === "ImportSpecifier" && enclosingNode && enclosingNode.type === "ImportDeclaration" && util$1.hasNewline(text, options.locEnd(comment))) {
    addTrailingComment$2(precedingNode, comment);
    return true;
  }

  return false;
}

function handleAssignmentPatternComments(enclosingNode, comment) {
  if (enclosingNode && enclosingNode.type === "AssignmentPattern") {
    addLeadingComment$2(enclosingNode, comment);
    return true;
  }

  return false;
}

function handleTypeAliasComments(enclosingNode, followingNode, comment) {
  if (enclosingNode && enclosingNode.type === "TypeAlias") {
    addLeadingComment$2(enclosingNode, comment);
    return true;
  }

  return false;
}

function handleVariableDeclaratorComments(enclosingNode, followingNode, comment) {
  if (enclosingNode && (enclosingNode.type === "VariableDeclarator" || enclosingNode.type === "AssignmentExpression") && followingNode && (followingNode.type === "ObjectExpression" || followingNode.type === "ArrayExpression" || followingNode.type === "TemplateLiteral" || followingNode.type === "TaggedTemplateExpression")) {
    addLeadingComment$2(followingNode, comment);
    return true;
  }

  return false;
}

function handleTSMappedTypeComments(text, enclosingNode, precedingNode, followingNode, comment) {
  if (!enclosingNode || enclosingNode.type !== "TSMappedType") {
    return false;
  }

  if (followingNode && followingNode.type === "TSTypeParameter" && followingNode.name) {
    addLeadingComment$2(followingNode.name, comment);
    return true;
  }

  if (precedingNode && precedingNode.type === "TSTypeParameter" && precedingNode.constraint) {
    addTrailingComment$2(precedingNode.constraint, comment);
    return true;
  }

  return false;
}

function isBlockComment$1(comment) {
  return comment.type === "Block" || comment.type === "CommentBlock";
}

function hasLeadingComment$2(node) {
  var fn = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {
    return true;
  };

  if (node.leadingComments) {
    return node.leadingComments.some(fn);
  }

  if (node.comments) {
    return node.comments.some(function (comment) {
      return comment.leading && fn(comment);
    });
  }

  return false;
}

var comments$3 = {
  handleOwnLineComment,
  handleEndOfLineComment,
  handleRemainingComment,
  hasLeadingComment: hasLeadingComment$2,
  isBlockComment: isBlockComment$1
};

var isBlockComment = comments$3.isBlockComment;
var hasLeadingComment$1 = comments$3.hasLeadingComment;
var _require$$1$builders = doc.builders;
var indent$3 = _require$$1$builders.indent;
var join$3 = _require$$1$builders.join;
var hardline$4 = _require$$1$builders.hardline;
var softline$2 = _require$$1$builders.softline;
var literalline$2 = _require$$1$builders.literalline;
var concat$5 = _require$$1$builders.concat;
var group$2 = _require$$1$builders.group;
var dedentToRoot$1 = _require$$1$builders.dedentToRoot;
var _require$$1$utils = doc.utils;
var mapDoc$3 = _require$$1$utils.mapDoc;
var stripTrailingHardline$1 = _require$$1$utils.stripTrailingHardline;

function embed(path$$1, print, textToDoc, options) {
  var node = path$$1.getValue();
  var parent = path$$1.getParentNode();
  var parentParent = path$$1.getParentNode(1);

  switch (node.type) {
    case "TemplateLiteral":
      {
        var isCss = [isStyledJsx, isStyledComponents, isCssProp, isAngularComponentStyles].some(function (isIt) {
          return isIt(path$$1);
        });

        if (isCss) {
          // Get full template literal with expressions replaced by placeholders
          var rawQuasis = node.quasis.map(function (q) {
            return q.value.raw;
          });
          var placeholderID = 0;
          var text = rawQuasis.reduce(function (prevVal, currVal, idx) {
            return idx == 0 ? currVal : prevVal + "@prettier-placeholder-" + placeholderID++ + "-id" + currVal;
          }, "");
          var doc$$2 = textToDoc(text, {
            parser: "css"
          });
          return transformCssDoc(doc$$2, path$$1, print);
        }
        /*
         * react-relay and graphql-tag
         * graphql`...`
         * graphql.experimental`...`
         * gql`...`
         *
         * This intentionally excludes Relay Classic tags, as Prettier does not
         * support Relay Classic formatting.
         */


        if (isGraphQL(path$$1)) {
          var expressionDocs = node.expressions ? path$$1.map(print, "expressions") : [];
          var numQuasis = node.quasis.length;

          if (numQuasis === 1 && node.quasis[0].value.raw.trim() === "") {
            return "``";
          }

          var parts = [];

          for (var i = 0; i < numQuasis; i++) {
            var templateElement = node.quasis[i];
            var isFirst = i === 0;
            var isLast = i === numQuasis - 1;
            var _text = templateElement.value.cooked; // Bail out if any of the quasis have an invalid escape sequence
            // (which would make the `cooked` value be `null` or `undefined`)

            if (typeof _text !== "string") {
              return null;
            }

            var lines = _text.split("\n");

            var numLines = lines.length;
            var expressionDoc = expressionDocs[i];
            var startsWithBlankLine = numLines > 2 && lines[0].trim() === "" && lines[1].trim() === "";
            var endsWithBlankLine = numLines > 2 && lines[numLines - 1].trim() === "" && lines[numLines - 2].trim() === "";
            var commentsAndWhitespaceOnly = lines.every(function (line) {
              return /^\s*(?:#[^\r\n]*)?$/.test(line);
            }); // Bail out if an interpolation occurs within a comment.

            if (!isLast && /#[^\r\n]*$/.test(lines[numLines - 1])) {
              return null;
            }

            var _doc = null;

            if (commentsAndWhitespaceOnly) {
              _doc = printGraphqlComments(lines);
            } else {
              _doc = stripTrailingHardline$1(textToDoc(_text, {
                parser: "graphql"
              }));
            }

            if (_doc) {
              _doc = escapeTemplateCharacters(_doc, false);

              if (!isFirst && startsWithBlankLine) {
                parts.push("");
              }

              parts.push(_doc);

              if (!isLast && endsWithBlankLine) {
                parts.push("");
              }
            } else if (!isFirst && !isLast && startsWithBlankLine) {
              parts.push("");
            }

            if (expressionDoc) {
              parts.push(concat$5(["${", expressionDoc, "}"]));
            }
          }

          return concat$5(["`", indent$3(concat$5([hardline$4, join$3(hardline$4, parts)])), hardline$4, "`"]);
        }

        var htmlParser = isHtml(path$$1) ? "html" : isAngularComponentTemplate(path$$1) ? "angular" : undefined;

        if (htmlParser) {
          return printHtmlTemplateLiteral(path$$1, print, textToDoc, htmlParser, options.embeddedInHtml);
        }

        break;
      }

    case "TemplateElement":
      {
        /**
         * md`...`
         * markdown`...`
         */
        if (parentParent && parentParent.type === "TaggedTemplateExpression" && parent.quasis.length === 1 && parentParent.tag.type === "Identifier" && (parentParent.tag.name === "md" || parentParent.tag.name === "markdown")) {
          var _text2 = parent.quasis[0].value.raw.replace(/((?:\\\\)*)\\`/g, function (_, backslashes) {
            return "\\".repeat(backslashes.length / 2) + "`";
          });

          var indentation = getIndentation(_text2);
          var hasIndent = indentation !== "";
          return concat$5([hasIndent ? indent$3(concat$5([softline$2, printMarkdown(_text2.replace(new RegExp(`^${indentation}`, "gm"), ""))])) : concat$5([literalline$2, dedentToRoot$1(printMarkdown(_text2))]), softline$2]);
        }

        break;
      }
  }

  function printMarkdown(text) {
    var doc$$2 = textToDoc(text, {
      parser: "markdown",
      __inJsTemplate: true
    });
    return stripTrailingHardline$1(escapeTemplateCharacters(doc$$2, true));
  }
}

function getIndentation(str) {
  var firstMatchedIndent = str.match(/^([^\S\n]*)\S/m);
  return firstMatchedIndent === null ? "" : firstMatchedIndent[1];
}

function uncook(cookedValue) {
  return cookedValue.replace(/([\\`]|\$\{)/g, "\\$1");
}

function escapeTemplateCharacters(doc$$2, raw) {
  return mapDoc$3(doc$$2, function (currentDoc) {
    if (!currentDoc.parts) {
      return currentDoc;
    }

    var parts = [];
    currentDoc.parts.forEach(function (part) {
      if (typeof part === "string") {
        parts.push(raw ? part.replace(/(\\*)`/g, "$1$1\\`") : uncook(part));
      } else {
        parts.push(part);
      }
    });
    return Object.assign({}, currentDoc, {
      parts
    });
  });
}

function transformCssDoc(quasisDoc, path$$1, print) {
  var parentNode = path$$1.getValue();
  var isEmpty = parentNode.quasis.length === 1 && !parentNode.quasis[0].value.raw.trim();

  if (isEmpty) {
    return "``";
  }

  var expressionDocs = parentNode.expressions ? path$$1.map(print, "expressions") : [];
  var newDoc = replacePlaceholders(quasisDoc, expressionDocs);
  /* istanbul ignore if */

  if (!newDoc) {
    throw new Error("Couldn't insert all the expressions");
  }

  return concat$5(["`", indent$3(concat$5([hardline$4, stripTrailingHardline$1(newDoc)])), softline$2, "`"]);
} // Search all the placeholders in the quasisDoc tree
// and replace them with the expression docs one by one
// returns a new doc with all the placeholders replaced,
// or null if it couldn't replace any expression


function replacePlaceholders(quasisDoc, expressionDocs) {
  if (!expressionDocs || !expressionDocs.length) {
    return quasisDoc;
  }

  var expressions = expressionDocs.slice();
  var replaceCounter = 0;
  var newDoc = mapDoc$3(quasisDoc, function (doc$$2) {
    if (!doc$$2 || !doc$$2.parts || !doc$$2.parts.length) {
      return doc$$2;
    }

    var parts = doc$$2.parts;
    var atIndex = parts.indexOf("@");
    var placeholderIndex = atIndex + 1;

    if (atIndex > -1 && typeof parts[placeholderIndex] === "string" && parts[placeholderIndex].startsWith("prettier-placeholder")) {
      // If placeholder is split, join it
      var at = parts[atIndex];
      var placeholder = parts[placeholderIndex];
      var rest = parts.slice(placeholderIndex + 1);
      parts = parts.slice(0, atIndex).concat([at + placeholder]).concat(rest);
    }

    var atPlaceholderIndex = parts.findIndex(function (part) {
      return typeof part === "string" && part.startsWith("@prettier-placeholder");
    });

    if (atPlaceholderIndex > -1) {
      var _placeholder = parts[atPlaceholderIndex];

      var _rest = parts.slice(atPlaceholderIndex + 1);

      var placeholderMatch = _placeholder.match(/@prettier-placeholder-(.+)-id([\s\S]*)/);

      var placeholderID = placeholderMatch[1]; // When the expression has a suffix appended, like:
      // animation: linear ${time}s ease-out;

      var suffix = placeholderMatch[2];
      var expression = expressions[placeholderID];
      replaceCounter++;
      parts = parts.slice(0, atPlaceholderIndex).concat(["${", expression, "}" + suffix]).concat(_rest);
    }

    return Object.assign({}, doc$$2, {
      parts: parts
    });
  });
  return expressions.length === replaceCounter ? newDoc : null;
}

function printGraphqlComments(lines) {
  var parts = [];
  var seenComment = false;
  lines.map(function (textLine) {
    return textLine.trim();
  }).forEach(function (textLine, i, array) {
    // Lines are either whitespace only, or a comment (with poential whitespace
    // around it). Drop whitespace-only lines.
    if (textLine === "") {
      return;
    }

    if (array[i - 1] === "" && seenComment) {
      // If a non-first comment is preceded by a blank (whitespace only) line,
      // add in a blank line.
      parts.push(concat$5([hardline$4, textLine]));
    } else {
      parts.push(textLine);
    }

    seenComment = true;
  }); // If `lines` was whitespace only, return `null`.

  return parts.length === 0 ? null : join$3(hardline$4, parts);
}
/**
 * Template literal in these contexts:
 * <style jsx>{`div{color:red}`}</style>
 * css``
 * css.global``
 * css.resolve``
 */


function isStyledJsx(path$$1) {
  var node = path$$1.getValue();
  var parent = path$$1.getParentNode();
  var parentParent = path$$1.getParentNode(1);
  return parentParent && node.quasis && parent.type === "JSXExpressionContainer" && parentParent.type === "JSXElement" && parentParent.openingElement.name.name === "style" && parentParent.openingElement.attributes.some(function (attribute) {
    return attribute.name.name === "jsx";
  }) || parent && parent.type === "TaggedTemplateExpression" && parent.tag.type === "Identifier" && parent.tag.name === "css" || parent && parent.type === "TaggedTemplateExpression" && parent.tag.type === "MemberExpression" && parent.tag.object.name === "css" && (parent.tag.property.name === "global" || parent.tag.property.name === "resolve");
}
/**
 * Angular Components can have:
 * - Inline HTML template
 * - Inline CSS styles
 *
 * ...which are both within template literals somewhere
 * inside of the Component decorator factory.
 *
 * E.g.
 * @Component({
 *  template: `<div>...</div>`,
 *  styles: [`h1 { color: blue; }`]
 * })
 */


function isAngularComponentStyles(path$$1) {
  return isPathMatch(path$$1, [function (node) {
    return node.type === "TemplateLiteral";
  }, function (node, name) {
    return node.type === "ArrayExpression" && name === "elements";
  }, function (node, name) {
    return node.type === "Property" && node.key.type === "Identifier" && node.key.name === "styles" && name === "value";
  }].concat(getAngularComponentObjectExpressionPredicates()));
}

function isAngularComponentTemplate(path$$1) {
  return isPathMatch(path$$1, [function (node) {
    return node.type === "TemplateLiteral";
  }, function (node, name) {
    return node.type === "Property" && node.key.type === "Identifier" && node.key.name === "template" && name === "value";
  }].concat(getAngularComponentObjectExpressionPredicates()));
}

function getAngularComponentObjectExpressionPredicates() {
  return [function (node, name) {
    return node.type === "ObjectExpression" && name === "properties";
  }, function (node, name) {
    return node.type === "CallExpression" && node.callee.type === "Identifier" && node.callee.name === "Component" && name === "arguments";
  }, function (node, name) {
    return node.type === "Decorator" && name === "expression";
  }];
}
/**
 * styled-components template literals
 */


function isStyledComponents(path$$1) {
  var parent = path$$1.getParentNode();

  if (!parent || parent.type !== "TaggedTemplateExpression") {
    return false;
  }

  var tag = parent.tag;

  switch (tag.type) {
    case "MemberExpression":
      return (// styled.foo``
        isStyledIdentifier(tag.object) || // Component.extend``
        isStyledExtend(tag)
      );

    case "CallExpression":
      return (// styled(Component)``
        isStyledIdentifier(tag.callee) || tag.callee.type === "MemberExpression" && (tag.callee.object.type === "MemberExpression" && ( // styled.foo.attrs({})``
        isStyledIdentifier(tag.callee.object.object) || // Component.extend.attrs({})``
        isStyledExtend(tag.callee.object)) || // styled(Component).attrs({})``
        tag.callee.object.type === "CallExpression" && isStyledIdentifier(tag.callee.object.callee))
      );

    case "Identifier":
      // css``
      return tag.name === "css";

    default:
      return false;
  }
}
/**
 * JSX element with CSS prop
 */


function isCssProp(path$$1) {
  var parent = path$$1.getParentNode();
  var parentParent = path$$1.getParentNode(1);
  return parentParent && parent.type === "JSXExpressionContainer" && parentParent.type === "JSXAttribute" && parentParent.name.type === "JSXIdentifier" && parentParent.name.name === "css";
}

function isStyledIdentifier(node) {
  return node.type === "Identifier" && node.name === "styled";
}

function isStyledExtend(node) {
  return /^[A-Z]/.test(node.object.name) && node.property.name === "extend";
}
/*
 * react-relay and graphql-tag
 * graphql`...`
 * graphql.experimental`...`
 * gql`...`
 * GraphQL comment block
 *
 * This intentionally excludes Relay Classic tags, as Prettier does not
 * support Relay Classic formatting.
 */


function isGraphQL(path$$1) {
  var node = path$$1.getValue();
  var parent = path$$1.getParentNode();
  return hasLanguageComment(node, "GraphQL") || parent && (parent.type === "TaggedTemplateExpression" && (parent.tag.type === "MemberExpression" && parent.tag.object.name === "graphql" && parent.tag.property.name === "experimental" || parent.tag.type === "Identifier" && (parent.tag.name === "gql" || parent.tag.name === "graphql")) || parent.type === "CallExpression" && parent.callee.type === "Identifier" && parent.callee.name === "graphql");
}

function hasLanguageComment(node, languageName) {
  // This checks for a leading comment that is exactly `/* GraphQL */`
  // In order to be in line with other implementations of this comment tag
  // we will not trim the comment value and we will expect exactly one space on
  // either side of the GraphQL string
  // Also see ./clean.js
  return hasLeadingComment$1(node, function (comment) {
    return isBlockComment(comment) && comment.value === ` ${languageName} `;
  });
}

function isPathMatch(path$$1, predicateStack) {
  var stack = path$$1.stack.slice();
  var name = null;
  var node = stack.pop();
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = predicateStack[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var predicate = _step.value;

      if (node === undefined) {
        return false;
      } // skip index/array


      if (typeof name === "number") {
        name = stack.pop();
        node = stack.pop();
      }

      if (!predicate(node, name)) {
        return false;
      }

      name = stack.pop();
      node = stack.pop();
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return true;
}
/**
 *     - html`...`
 *     - HTML comment block
 */


function isHtml(path$$1) {
  var node = path$$1.getValue();
  return hasLanguageComment(node, "HTML") || isPathMatch(path$$1, [function (node) {
    return node.type === "TemplateLiteral";
  }, function (node, name) {
    return node.type === "TaggedTemplateExpression" && node.tag.type === "Identifier" && node.tag.name === "html" && name === "quasi";
  }]);
} // The counter is needed to distinguish nested embeds.


var htmlTemplateLiteralCounter = 0;

function printHtmlTemplateLiteral(path$$1, print, textToDoc, parser, escapeClosingScriptTag) {
  var node = path$$1.getValue();
  var counter = htmlTemplateLiteralCounter;
  htmlTemplateLiteralCounter = htmlTemplateLiteralCounter + 1 >>> 0;

  var composePlaceholder = function composePlaceholder(index) {
    return `PRETTIER_HTML_PLACEHOLDER_${index}_${counter}_IN_JS`;
  };

  var text = node.quasis.map(function (quasi, index, quasis) {
    return index === quasis.length - 1 ? quasi.value.cooked : quasi.value.cooked + composePlaceholder(index);
  }).join("");
  var expressionDocs = path$$1.map(print, "expressions");

  if (expressionDocs.length === 0 && text.trim().length === 0) {
    return "``";
  }

  var placeholderRegex = RegExp(composePlaceholder("(\\d+)"), "g");
  var contentDoc = mapDoc$3(stripTrailingHardline$1(textToDoc(text, {
    parser
  })), function (doc$$2) {
    if (typeof doc$$2 !== "string") {
      return doc$$2;
    }

    var parts = [];
    var components = doc$$2.split(placeholderRegex);

    for (var i = 0; i < components.length; i++) {
      var component = components[i];

      if (i % 2 === 0) {
        if (component) {
          component = uncook(component);

          if (escapeClosingScriptTag) {
            component = component.replace(/<\/(script)\b/gi, "<\\/$1");
          }

          parts.push(component);
        }

        continue;
      }

      var placeholderIndex = +component;
      parts.push(concat$5(["${", group$2(expressionDocs[placeholderIndex]), "}"]));
    }

    return concat$5(parts);
  });
  return group$2(concat$5(["`", indent$3(concat$5([hardline$4, group$2(contentDoc)])), softline$2, "`"]));
}

var embed_1 = embed;

function clean(ast, newObj, parent) {
  ["range", "raw", "comments", "leadingComments", "trailingComments", "extra", "start", "end", "flags"].forEach(function (name) {
    delete newObj[name];
  });

  if (ast.type === "BigIntLiteral") {
    newObj.value = newObj.value.toLowerCase();
  } // We remove extra `;` and add them when needed


  if (ast.type === "EmptyStatement") {
    return null;
  } // We move text around, including whitespaces and add {" "}


  if (ast.type === "JSXText") {
    return null;
  }

  if (ast.type === "JSXExpressionContainer" && ast.expression.type === "Literal" && ast.expression.value === " ") {
    return null;
  } // (TypeScript) Ignore `static` in `constructor(static p) {}`
  // and `export` in `constructor(export p) {}`


  if (ast.type === "TSParameterProperty" && ast.accessibility === null && !ast.readonly) {
    return {
      type: "Identifier",
      name: ast.parameter.name,
      typeAnnotation: newObj.parameter.typeAnnotation,
      decorators: newObj.decorators
    };
  } // (TypeScript) ignore empty `specifiers` array


  if (ast.type === "TSNamespaceExportDeclaration" && ast.specifiers && ast.specifiers.length === 0) {
    delete newObj.specifiers;
  } // (TypeScript) bypass TSParenthesizedType


  if (ast.type === "TSParenthesizedType") {
    return newObj.typeAnnotation;
  } // We convert <div></div> to <div />


  if (ast.type === "JSXOpeningElement") {
    delete newObj.selfClosing;
  }

  if (ast.type === "JSXElement") {
    delete newObj.closingElement;
  } // We change {'key': value} into {key: value}


  if ((ast.type === "Property" || ast.type === "ObjectProperty" || ast.type === "MethodDefinition" || ast.type === "ClassProperty" || ast.type === "TSPropertySignature" || ast.type === "ObjectTypeProperty") && typeof ast.key === "object" && ast.key && (ast.key.type === "Literal" || ast.key.type === "StringLiteral" || ast.key.type === "Identifier")) {
    delete newObj.key;
  }

  if (ast.type === "OptionalMemberExpression" && ast.optional === false) {
    newObj.type = "MemberExpression";
    delete newObj.optional;
  } // Remove raw and cooked values from TemplateElement when it's CSS
  // styled-jsx


  if (ast.type === "JSXElement" && ast.openingElement.name.name === "style" && ast.openingElement.attributes.some(function (attr) {
    return attr.name.name === "jsx";
  })) {
    var templateLiterals = newObj.children.filter(function (child) {
      return child.type === "JSXExpressionContainer" && child.expression.type === "TemplateLiteral";
    }).map(function (container) {
      return container.expression;
    });
    var quasis = templateLiterals.reduce(function (quasis, templateLiteral) {
      return quasis.concat(templateLiteral.quasis);
    }, []);
    quasis.forEach(function (q) {
      return delete q.value;
    });
  } // CSS template literals in css prop


  if (ast.type === "JSXAttribute" && ast.name.name === "css" && ast.value.type === "JSXExpressionContainer" && ast.value.expression.type === "TemplateLiteral") {
    newObj.value.expression.quasis.forEach(function (q) {
      return delete q.value;
    });
  } // Angular Components: Inline HTML template and Inline CSS styles


  var expression = ast.expression || ast.callee;

  if (ast.type === "Decorator" && expression.type === "CallExpression" && expression.callee.name === "Component" && expression.arguments.length === 1) {
    var astProps = ast.expression.arguments[0].properties;
    newObj.expression.arguments[0].properties.forEach(function (prop, index) {
      var templateLiteral = null;

      switch (astProps[index].key.name) {
        case "styles":
          if (prop.value.type === "ArrayExpression") {
            templateLiteral = prop.value.elements[0];
          }

          break;

        case "template":
          if (prop.value.type === "TemplateLiteral") {
            templateLiteral = prop.value;
          }

          break;
      }

      if (templateLiteral) {
        templateLiteral.quasis.forEach(function (q) {
          return delete q.value;
        });
      }
    });
  } // styled-components, graphql, markdown


  if (ast.type === "TaggedTemplateExpression" && (ast.tag.type === "MemberExpression" || ast.tag.type === "Identifier" && (ast.tag.name === "gql" || ast.tag.name === "graphql" || ast.tag.name === "css" || ast.tag.name === "md" || ast.tag.name === "markdown" || ast.tag.name === "html") || ast.tag.type === "CallExpression")) {
    newObj.quasi.quasis.forEach(function (quasi) {
      return delete quasi.value;
    });
  }

  if (ast.type === "TemplateLiteral") {
    // This checks for a leading comment that is exactly `/* GraphQL */`
    // In order to be in line with other implementations of this comment tag
    // we will not trim the comment value and we will expect exactly one space on
    // either side of the GraphQL string
    // Also see ./embed.js
    var hasLanguageComment = ast.leadingComments && ast.leadingComments.some(function (comment) {
      return comment.type === "CommentBlock" && ["GraphQL", "HTML"].some(function (languageName) {
        return comment.value === ` ${languageName} `;
      });
    });

    if (hasLanguageComment || parent.type === "CallExpression" && parent.callee.name === "graphql") {
      newObj.quasis.forEach(function (quasi) {
        return delete quasi.value;
      });
    }
  }
}

var clean_1 = clean;

var detectNewline = createCommonjsModule(function (module) {
  'use strict';

  module.exports = function (str) {
    if (typeof str !== 'string') {
      throw new TypeError('Expected a string');
    }

    var newlines = str.match(/(?:\r?\n)/g) || [];

    if (newlines.length === 0) {
      return null;
    }

    var crlf = newlines.filter(function (el) {
      return el === '\r\n';
    }).length;
    var lf = newlines.length - crlf;
    return crlf > lf ? '\r\n' : '\n';
  };

  module.exports.graceful = function (str) {
    return module.exports(str) || '\n';
  };
});

var build$1 = createCommonjsModule(function (module, exports) {
  'use strict';

  Object.defineProperty(exports, '__esModule', {
    value: true
  });
  exports.extract = extract;
  exports.strip = strip;
  exports.parse = parse;
  exports.parseWithComments = parseWithComments;
  exports.print = print;

  var _detectNewline;

  function _load_detectNewline() {
    return _detectNewline = _interopRequireDefault(detectNewline);
  }

  var _os;

  function _load_os() {
    return _os = os;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }
  /**
   * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   *
   *
   */


  var commentEndRe = /\*\/$/;
  var commentStartRe = /^\/\*\*/;
  var docblockRe = /^\s*(\/\*\*?(.|\r?\n)*?\*\/)/;
  var lineCommentRe = /(^|\s+)\/\/([^\r\n]*)/g;
  var ltrimNewlineRe = /^(\r?\n)+/;
  var multilineRe = /(?:^|\r?\n) *(@[^\r\n]*?) *\r?\n *(?![^@\r\n]*\/\/[^]*)([^@\r\n\s][^@\r\n]+?) *\r?\n/g;
  var propertyRe = /(?:^|\r?\n) *@(\S+) *([^\r\n]*)/g;
  var stringStartRe = /(\r?\n|^) *\* ?/g;

  function extract(contents) {
    var match = contents.match(docblockRe);
    return match ? match[0].trimLeft() : '';
  }

  function strip(contents) {
    var match = contents.match(docblockRe);
    return match && match[0] ? contents.substring(match[0].length) : contents;
  }

  function parse(docblock) {
    return parseWithComments(docblock).pragmas;
  }

  function parseWithComments(docblock) {
    var line = (0, (_detectNewline || _load_detectNewline()).default)(docblock) || (_os || _load_os()).EOL;

    docblock = docblock.replace(commentStartRe, '').replace(commentEndRe, '').replace(stringStartRe, '$1'); // Normalize multi-line directives

    var prev = '';

    while (prev !== docblock) {
      prev = docblock;
      docblock = docblock.replace(multilineRe, `${line}$1 $2${line}`);
    }

    docblock = docblock.replace(ltrimNewlineRe, '').trimRight();
    var result = Object.create(null);
    var comments = docblock.replace(propertyRe, '').replace(ltrimNewlineRe, '').trimRight();
    var match;

    while (match = propertyRe.exec(docblock)) {
      // strip linecomments from pragmas
      var nextPragma = match[2].replace(lineCommentRe, '');

      if (typeof result[match[1]] === 'string' || Array.isArray(result[match[1]])) {
        result[match[1]] = [].concat(result[match[1]], nextPragma);
      } else {
        result[match[1]] = nextPragma;
      }
    }

    return {
      comments,
      pragmas: result
    };
  }

  function print(_ref) {
    var _ref$comments = _ref.comments;
    var comments = _ref$comments === undefined ? '' : _ref$comments;
    var _ref$pragmas = _ref.pragmas;
    var pragmas = _ref$pragmas === undefined ? {} : _ref$pragmas;

    var line = (0, (_detectNewline || _load_detectNewline()).default)(comments) || (_os || _load_os()).EOL;

    var head = '/**';
    var start = ' *';
    var tail = ' */';
    var keys = Object.keys(pragmas);
    var printedObject = keys.map(function (key) {
      return printKeyValues(key, pragmas[key]);
    }).reduce(function (arr, next) {
      return arr.concat(next);
    }, []).map(function (keyValue) {
      return start + ' ' + keyValue + line;
    }).join('');

    if (!comments) {
      if (keys.length === 0) {
        return '';
      }

      if (keys.length === 1 && !Array.isArray(pragmas[keys[0]])) {
        var value = pragmas[keys[0]];
        return `${head} ${printKeyValues(keys[0], value)[0]}${tail}`;
      }
    }

    var printedComments = comments.split(line).map(function (textLine) {
      return `${start} ${textLine}`;
    }).join(line) + line;
    return head + line + (comments ? printedComments : '') + (comments && keys.length ? start + line : '') + printedObject + tail;
  }

  function printKeyValues(key, valueOrArray) {
    return [].concat(valueOrArray).map(function (value) {
      return `@${key} ${value}`.trim();
    });
  }
});
unwrapExports(build$1);

function hasPragma(text) {
  var pragmas = Object.keys(build$1.parse(build$1.extract(text)));
  return pragmas.indexOf("prettier") !== -1 || pragmas.indexOf("format") !== -1;
}

function insertPragma$1(text) {
  var parsedDocblock = build$1.parseWithComments(build$1.extract(text));
  var pragmas = Object.assign({
    format: ""
  }, parsedDocblock.pragmas);
  var newDocblock = build$1.print({
    pragmas,
    comments: parsedDocblock.comments.replace(/^(\s+?\r?\n)+/, "") // remove leading newlines

  }).replace(/(\r\n|\r)/g, "\n"); // normalise newlines (mitigate use of os.EOL by jest-docblock)

  var strippedText = build$1.strip(text);
  var separatingNewlines = strippedText.startsWith("\n") ? "\n" : "\n\n";
  return newDocblock + separatingNewlines + strippedText;
}

var pragma = {
  hasPragma,
  insertPragma: insertPragma$1
};

// Flow annotation comments cannot be split across lines. For example:
//
// (this /*
// : any */).foo = 5;
//
// is not picked up by Flow (see https://github.com/facebook/flow/issues/7050), so
// removing the newline would create a type annotation that the user did not intend
// to create.

var NON_LINE_TERMINATING_WHITE_SPACE = "(?:(?=.)\\s)";
var FLOW_SHORTHAND_ANNOTATION = new RegExp(`^${NON_LINE_TERMINATING_WHITE_SPACE}*:`);
var FLOW_ANNOTATION = new RegExp(`^${NON_LINE_TERMINATING_WHITE_SPACE}*::`);

function hasFlowShorthandAnnotationComment$2(node) {
  // https://flow.org/en/docs/types/comments/
  // Syntax example: const r = new (window.Request /*: Class<Request> */)("");
  return node.extra && node.extra.parenthesized && node.trailingComments && node.trailingComments[0].value.match(FLOW_SHORTHAND_ANNOTATION);
}

function hasFlowAnnotationComment$1(comments) {
  return comments && comments[0].value.match(FLOW_ANNOTATION);
}

function hasNode$1(node, fn) {
  if (!node || typeof node !== "object") {
    return false;
  }

  if (Array.isArray(node)) {
    return node.some(function (value) {
      return hasNode$1(value, fn);
    });
  }

  var result = fn(node);
  return typeof result === "boolean" ? result : Object.keys(node).some(function (key) {
    return hasNode$1(node[key], fn);
  });
}

function hasNakedLeftSide$2(node) {
  return node.type === "AssignmentExpression" || node.type === "BinaryExpression" || node.type === "LogicalExpression" || node.type === "NGPipeExpression" || node.type === "ConditionalExpression" || node.type === "CallExpression" || node.type === "OptionalCallExpression" || node.type === "MemberExpression" || node.type === "OptionalMemberExpression" || node.type === "SequenceExpression" || node.type === "TaggedTemplateExpression" || node.type === "BindExpression" || node.type === "UpdateExpression" && !node.prefix || node.type === "TSAsExpression" || node.type === "TSNonNullExpression";
}

function getLeftSide$1(node) {
  if (node.expressions) {
    return node.expressions[0];
  }

  return node.left || node.test || node.callee || node.object || node.tag || node.argument || node.expression;
}

function getLeftSidePathName$2(path$$1, node) {
  if (node.expressions) {
    return ["expressions", 0];
  }

  if (node.left) {
    return ["left"];
  }

  if (node.test) {
    return ["test"];
  }

  if (node.object) {
    return ["object"];
  }

  if (node.callee) {
    return ["callee"];
  }

  if (node.tag) {
    return ["tag"];
  }

  if (node.argument) {
    return ["argument"];
  }

  if (node.expression) {
    return ["expression"];
  }

  throw new Error("Unexpected node has no left side", node);
}

var utils$4 = {
  getLeftSide: getLeftSide$1,
  getLeftSidePathName: getLeftSidePathName$2,
  hasNakedLeftSide: hasNakedLeftSide$2,
  hasNode: hasNode$1,
  hasFlowShorthandAnnotationComment: hasFlowShorthandAnnotationComment$2,
  hasFlowAnnotationComment: hasFlowAnnotationComment$1
};

var getLeftSidePathName$1 = utils$4.getLeftSidePathName;
var hasNakedLeftSide$1 = utils$4.hasNakedLeftSide;
var hasFlowShorthandAnnotationComment$1 = utils$4.hasFlowShorthandAnnotationComment;

function hasClosureCompilerTypeCastComment(text, path$$1) {
  // https://github.com/google/closure-compiler/wiki/Annotating-Types#type-casts
  // Syntax example: var x = /** @type {string} */ (fruit);
  var n = path$$1.getValue();
  return isParenthesized(n) && (hasTypeCastComment(n) || hasAncestorTypeCastComment(0)); // for sub-item: /** @type {array} */ (numberOrString).map(x => x);

  function hasAncestorTypeCastComment(index) {
    var ancestor = path$$1.getParentNode(index);
    return ancestor && !isParenthesized(ancestor) ? hasTypeCastComment(ancestor) || hasAncestorTypeCastComment(index + 1) : false;
  }

  function hasTypeCastComment(node) {
    return node.comments && node.comments.some(function (comment) {
      return comment.leading && comments$3.isBlockComment(comment) && isTypeCastComment(comment.value);
    });
  }

  function isParenthesized(node) {
    // Closure typecast comments only really make sense when _not_ using
    // typescript or flow parsers, so we take advantage of the babel parser's
    // parenthesized expressions.
    return node.extra && node.extra.parenthesized;
  }

  function isTypeCastComment(comment) {
    var cleaned = comment.trim().split("\n").map(function (line) {
      return line.replace(/^[\s*]+/, "");
    }).join(" ").trim();

    if (!/^@type\s*\{[^]+\}$/.test(cleaned)) {
      return false;
    }

    var isCompletelyClosed = false;
    var unpairedBracketCount = 0;
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = cleaned[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var char = _step.value;

        if (char === "{") {
          if (isCompletelyClosed) {
            return false;
          }

          unpairedBracketCount++;
        } else if (char === "}") {
          if (unpairedBracketCount === 0) {
            return false;
          }

          unpairedBracketCount--;

          if (unpairedBracketCount === 0) {
            isCompletelyClosed = true;
          }
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return unpairedBracketCount === 0;
  }
}

function needsParens(path$$1, options) {
  var parent = path$$1.getParentNode();

  if (!parent) {
    return false;
  }

  var name = path$$1.getName();
  var node = path$$1.getNode(); // If the value of this path is some child of a Node and not a Node
  // itself, then it doesn't need parentheses. Only Node objects (in
  // fact, only Expression nodes) need parentheses.

  if (path$$1.getValue() !== node) {
    return false;
  } // to avoid unexpected `}}` in HTML interpolations


  if (options.__isInHtmlInterpolation && !options.bracketSpacing && endsWithRightBracket(node) && isFollowedByRightBracket(path$$1)) {
    return true;
  } // Only statements don't need parentheses.


  if (isStatement(node)) {
    return false;
  } // Closure compiler requires that type casted expressions to be surrounded by
  // parentheses.


  if (hasClosureCompilerTypeCastComment(options.originalText, path$$1)) {
    return true;
  }

  if ( // Preserve parens if we have a Flow annotation comment, unless we're using the Flow
  // parser. The Flow parser turns Flow comments into type annotation nodes in its
  // AST, which we handle separately.
  options.parser !== "flow" && hasFlowShorthandAnnotationComment$1(path$$1.getValue())) {
    return true;
  } // Identifiers never need parentheses.


  if (node.type === "Identifier") {
    // ...unless those identifiers are embed placeholders. They might be substituted by complex
    // expressions, so the parens around them should not be dropped. Example (JS-in-HTML-in-JS):
    //     let tpl = html`<script> f((${expr}) / 2); </script>`;
    // If the inner JS formatter removes the parens, the expression might change its meaning:
    //     f((a + b) / 2)  vs  f(a + b / 2)
    if (node.extra && node.extra.parenthesized && /^PRETTIER_HTML_PLACEHOLDER_\d+_\d+_IN_JS$/.test(node.name)) {
      return true;
    }

    return false;
  }

  if (parent.type === "ParenthesizedExpression") {
    return false;
  } // Add parens around the extends clause of a class. It is needed for almost
  // all expressions.


  if ((parent.type === "ClassDeclaration" || parent.type === "ClassExpression") && parent.superClass === node && (node.type === "ArrowFunctionExpression" || node.type === "AssignmentExpression" || node.type === "AwaitExpression" || node.type === "BinaryExpression" || node.type === "ConditionalExpression" || node.type === "LogicalExpression" || node.type === "NewExpression" || node.type === "ObjectExpression" || node.type === "ParenthesizedExpression" || node.type === "SequenceExpression" || node.type === "TaggedTemplateExpression" || node.type === "UnaryExpression" || node.type === "UpdateExpression" || node.type === "YieldExpression")) {
    return true;
  } // `export default function` or `export default class` can't be followed by
  // anything after. So an expression like `export default (function(){}).toString()`
  // needs to be followed by a parentheses


  if (parent.type === "ExportDefaultDeclaration") {
    return shouldWrapFunctionForExportDefault(path$$1, options);
  }

  if (parent.type === "Decorator" && parent.expression === node) {
    var hasCallExpression = false;
    var hasMemberExpression = false;
    var current = node;

    while (current) {
      switch (current.type) {
        case "MemberExpression":
          hasMemberExpression = true;
          current = current.object;
          break;

        case "CallExpression":
          if (
          /** @(x().y) */
          hasMemberExpression ||
          /** @(x().y()) */
          hasCallExpression) {
            return true;
          }

          hasCallExpression = true;
          current = current.callee;
          break;

        case "Identifier":
          return false;

        default:
          return true;
      }
    }

    return true;
  }

  if (parent.type === "ArrowFunctionExpression" && parent.body === node && node.type !== "SequenceExpression" && // these have parens added anyway
  util$1.startsWithNoLookaheadToken(node,
  /* forbidFunctionClassAndDoExpr */
  false) || parent.type === "ExpressionStatement" && util$1.startsWithNoLookaheadToken(node,
  /* forbidFunctionClassAndDoExpr */
  true)) {
    return true;
  }

  switch (node.type) {
    case "CallExpression":
      {
        var firstParentNotMemberExpression = parent;
        var i = 0; // tagged templates are basically member expressions from a grammar perspective
        // see https://tc39.github.io/ecma262/#prod-MemberExpression
        // so are typescript's non-null assertions, though there's no grammar to point to

        while (firstParentNotMemberExpression && (firstParentNotMemberExpression.type === "MemberExpression" && firstParentNotMemberExpression.object === path$$1.getParentNode(i - 1) || firstParentNotMemberExpression.type === "TaggedTemplateExpression" || firstParentNotMemberExpression.type === "TSNonNullExpression")) {
          firstParentNotMemberExpression = path$$1.getParentNode(++i);
        }

        if (firstParentNotMemberExpression.type === "NewExpression" && firstParentNotMemberExpression.callee === path$$1.getParentNode(i - 1)) {
          return true;
        }

        if (parent.type === "BindExpression" && parent.callee === node) {
          return true;
        }

        return false;
      }

    case "SpreadElement":
    case "SpreadProperty":
      return parent.type === "MemberExpression" && name === "object" && parent.object === node;

    case "UpdateExpression":
      if (parent.type === "UnaryExpression") {
        return node.prefix && (node.operator === "++" && parent.operator === "+" || node.operator === "--" && parent.operator === "-");
      }

    // else fallthrough

    case "UnaryExpression":
      switch (parent.type) {
        case "UnaryExpression":
          return node.operator === parent.operator && (node.operator === "+" || node.operator === "-");

        case "BindExpression":
          return true;

        case "MemberExpression":
          return name === "object" && parent.object === node;

        case "TaggedTemplateExpression":
          return true;

        case "NewExpression":
        case "CallExpression":
          return name === "callee" && parent.callee === node;

        case "BinaryExpression":
          return parent.operator === "**" && name === "left";

        case "TSNonNullExpression":
          return true;

        default:
          return false;
      }

    case "BinaryExpression":
      {
        if (parent.type === "UpdateExpression") {
          return true;
        }

        var isLeftOfAForStatement = function isLeftOfAForStatement(node) {
          var i = 0;

          while (node) {
            var _parent = path$$1.getParentNode(i++);

            if (!_parent) {
              return false;
            }

            if (_parent.type === "ForStatement" && _parent.init === node) {
              return true;
            }

            node = _parent;
          }

          return false;
        };

        if (node.operator === "in" && isLeftOfAForStatement(node)) {
          return true;
        }
      }
    // fallthrough

    case "TSTypeAssertion":
    case "TSAsExpression":
    case "LogicalExpression":
      switch (parent.type) {
        case "ConditionalExpression":
          return node.type === "TSAsExpression";

        case "CallExpression":
        case "NewExpression":
          return name === "callee" && parent.callee === node;

        case "ClassExpression":
        case "ClassDeclaration":
          return name === "superClass" && parent.superClass === node;

        case "TSTypeAssertion":
        case "TaggedTemplateExpression":
        case "UnaryExpression":
        case "JSXSpreadAttribute":
        case "SpreadElement":
        case "SpreadProperty":
        case "BindExpression":
        case "AwaitExpression":
        case "TSAsExpression":
        case "TSNonNullExpression":
        case "UpdateExpression":
          return true;

        case "MemberExpression":
        case "OptionalMemberExpression":
          return name === "object" && parent.object === node;

        case "AssignmentExpression":
          return parent.left === node && (node.type === "TSTypeAssertion" || node.type === "TSAsExpression");

        case "BinaryExpression":
        case "LogicalExpression":
          {
            if (!node.operator && node.type !== "TSTypeAssertion") {
              return true;
            }

            var po = parent.operator;
            var pp = util$1.getPrecedence(po);
            var no = node.operator;
            var np = util$1.getPrecedence(no);

            if (pp > np) {
              return true;
            }

            if ((po === "||" || po === "??") && no === "&&") {
              return true;
            }

            if (pp === np && name === "right") {
              assert.strictEqual(parent.right, node);
              return true;
            }

            if (pp === np && !util$1.shouldFlatten(po, no)) {
              return true;
            }

            if (pp < np && no === "%") {
              return po === "+" || po === "-";
            } // Add parenthesis when working with bitwise operators
            // It's not stricly needed but helps with code understanding


            if (util$1.isBitwiseOperator(po)) {
              return true;
            }

            return false;
          }

        default:
          return false;
      }

    case "TSParenthesizedType":
      {
        var grandParent = path$$1.getParentNode(1);
        /**
         * const foo = (): (() => void) => (): void => null;
         *                 ^          ^
         */

        if (getUnparenthesizedNode(node).type === "TSFunctionType" && parent.type === "TSTypeAnnotation" && grandParent.type === "ArrowFunctionExpression" && grandParent.returnType === parent) {
          return true;
        }

        if ((parent.type === "TSTypeParameter" || parent.type === "TypeParameter" || parent.type === "TSTypeAliasDeclaration" || parent.type === "TSTypeAnnotation" || parent.type === "TSParenthesizedType" || parent.type === "TSTypeParameterInstantiation") && grandParent.type !== "TSTypeOperator" && grandParent.type !== "TSOptionalType") {
          return false;
        } // Delegate to inner TSParenthesizedType


        if (node.typeAnnotation.type === "TSParenthesizedType" && parent.type !== "TSArrayType") {
          return false;
        }

        return true;
      }

    case "SequenceExpression":
      switch (parent.type) {
        case "ReturnStatement":
          return false;

        case "ForStatement":
          // Although parentheses wouldn't hurt around sequence
          // expressions in the head of for loops, traditional style
          // dictates that e.g. i++, j++ should not be wrapped with
          // parentheses.
          return false;

        case "ExpressionStatement":
          return name !== "expression";

        case "ArrowFunctionExpression":
          // We do need parentheses, but SequenceExpressions are handled
          // specially when printing bodies of arrow functions.
          return name !== "body";

        default:
          // Otherwise err on the side of overparenthesization, adding
          // explicit exceptions above if this proves overzealous.
          return true;
      }

    case "YieldExpression":
      if (parent.type === "UnaryExpression" || parent.type === "AwaitExpression" || parent.type === "TSAsExpression" || parent.type === "TSNonNullExpression") {
        return true;
      }

    // else fallthrough

    case "AwaitExpression":
      switch (parent.type) {
        case "TaggedTemplateExpression":
        case "UnaryExpression":
        case "BinaryExpression":
        case "LogicalExpression":
        case "SpreadElement":
        case "SpreadProperty":
        case "TSAsExpression":
        case "TSNonNullExpression":
        case "BindExpression":
        case "OptionalMemberExpression":
          return true;

        case "MemberExpression":
          return parent.object === node;

        case "NewExpression":
        case "CallExpression":
          return parent.callee === node;

        case "ConditionalExpression":
          return parent.test === node;

        default:
          return false;
      }

    case "ArrayTypeAnnotation":
      return parent.type === "NullableTypeAnnotation";

    case "IntersectionTypeAnnotation":
    case "UnionTypeAnnotation":
      return parent.type === "ArrayTypeAnnotation" || parent.type === "NullableTypeAnnotation" || parent.type === "IntersectionTypeAnnotation" || parent.type === "UnionTypeAnnotation";

    case "NullableTypeAnnotation":
      return parent.type === "ArrayTypeAnnotation";

    case "FunctionTypeAnnotation":
      {
        var ancestor = parent.type === "NullableTypeAnnotation" ? path$$1.getParentNode(1) : parent;
        return ancestor.type === "UnionTypeAnnotation" || ancestor.type === "IntersectionTypeAnnotation" || ancestor.type === "ArrayTypeAnnotation" || // We should check ancestor's parent to know whether the parentheses
        // are really needed, but since ??T doesn't make sense this check
        // will almost never be true.
        ancestor.type === "NullableTypeAnnotation";
      }

    case "StringLiteral":
    case "NumericLiteral":
    case "Literal":
      if (typeof node.value === "string" && parent.type === "ExpressionStatement" && ( // TypeScript workaround for https://github.com/JamesHenry/typescript-estree/issues/2
      // See corresponding workaround in printer.js case: "Literal"
      options.parser !== "typescript" && !parent.directive || options.parser === "typescript" && options.originalText.substr(options.locStart(node) - 1, 1) === "(")) {
        // To avoid becoming a directive
        var _grandParent = path$$1.getParentNode(1);

        return _grandParent.type === "Program" || _grandParent.type === "BlockStatement";
      }

      return parent.type === "MemberExpression" && typeof node.value === "number" && name === "object" && parent.object === node;

    case "AssignmentExpression":
      {
        var _grandParent2 = path$$1.getParentNode(1);

        if (parent.type === "ArrowFunctionExpression" && parent.body === node) {
          return true;
        } else if (parent.type === "ClassProperty" && parent.key === node && parent.computed) {
          return false;
        } else if (parent.type === "TSPropertySignature" && parent.name === node) {
          return false;
        } else if (parent.type === "ForStatement" && (parent.init === node || parent.update === node)) {
          return false;
        } else if (parent.type === "ExpressionStatement") {
          return node.left.type === "ObjectPattern";
        } else if (parent.type === "TSPropertySignature" && parent.key === node) {
          return false;
        } else if (parent.type === "AssignmentExpression") {
          return false;
        } else if (parent.type === "SequenceExpression" && _grandParent2 && _grandParent2.type === "ForStatement" && (_grandParent2.init === parent || _grandParent2.update === parent)) {
          return false;
        } else if (parent.type === "Property" && parent.value === node) {
          return false;
        } else if (parent.type === "NGChainedExpression") {
          return false;
        }

        return true;
      }

    case "ConditionalExpression":
      switch (parent.type) {
        case "TaggedTemplateExpression":
        case "UnaryExpression":
        case "SpreadElement":
        case "SpreadProperty":
        case "BinaryExpression":
        case "LogicalExpression":
        case "NGPipeExpression":
        case "ExportDefaultDeclaration":
        case "AwaitExpression":
        case "JSXSpreadAttribute":
        case "TSTypeAssertion":
        case "TypeCastExpression":
        case "TSAsExpression":
        case "TSNonNullExpression":
        case "OptionalMemberExpression":
          return true;

        case "NewExpression":
        case "CallExpression":
          return name === "callee" && parent.callee === node;

        case "ConditionalExpression":
          return name === "test" && parent.test === node;

        case "MemberExpression":
          return name === "object" && parent.object === node;

        default:
          return false;
      }

    case "FunctionExpression":
      switch (parent.type) {
        case "NewExpression":
        case "CallExpression":
          return name === "callee";
        // Not strictly necessary, but it's clearer to the reader if IIFEs are wrapped in parentheses.

        case "TaggedTemplateExpression":
          return true;
        // This is basically a kind of IIFE.

        default:
          return false;
      }

    case "ArrowFunctionExpression":
      switch (parent.type) {
        case "CallExpression":
          return name === "callee";

        case "NewExpression":
          return name === "callee";

        case "MemberExpression":
          return name === "object";

        case "TSAsExpression":
        case "BindExpression":
        case "TaggedTemplateExpression":
        case "UnaryExpression":
        case "LogicalExpression":
        case "BinaryExpression":
        case "AwaitExpression":
        case "TSTypeAssertion":
          return true;

        case "ConditionalExpression":
          return name === "test";

        default:
          return false;
      }

    case "ClassExpression":
      switch (parent.type) {
        case "NewExpression":
          return name === "callee" && parent.callee === node;

        default:
          return false;
      }

    case "OptionalMemberExpression":
      return parent.type === "MemberExpression";

    case "MemberExpression":
      if (parent.type === "BindExpression" && name === "callee" && parent.callee === node) {
        var object = node.object;

        while (object) {
          if (object.type === "CallExpression") {
            return true;
          }

          if (object.type !== "MemberExpression" && object.type !== "BindExpression") {
            break;
          }

          object = object.object;
        }
      }

      return false;

    case "BindExpression":
      if (parent.type === "BindExpression" && name === "callee" && parent.callee === node || parent.type === "MemberExpression" && name === "object" && parent.object === node || parent.type === "NewExpression" && name === "callee" && parent.callee === node) {
        return true;
      }

      return false;

    case "NGPipeExpression":
      if (parent.type === "NGRoot" || parent.type === "NGMicrosyntaxExpression" || parent.type === "ObjectProperty" || parent.type === "ArrayExpression" || (parent.type === "CallExpression" || parent.type === "OptionalCallExpression") && parent.arguments[name] === node || parent.type === "NGPipeExpression" && name === "right" || parent.type === "MemberExpression" && name === "property" || parent.type === "AssignmentExpression") {
        return false;
      }

      return true;
  }

  return false;
}

function isStatement(node) {
  return node.type === "BlockStatement" || node.type === "BreakStatement" || node.type === "ClassBody" || node.type === "ClassDeclaration" || node.type === "ClassMethod" || node.type === "ClassProperty" || node.type === "ClassPrivateProperty" || node.type === "ContinueStatement" || node.type === "DebuggerStatement" || node.type === "DeclareClass" || node.type === "DeclareExportAllDeclaration" || node.type === "DeclareExportDeclaration" || node.type === "DeclareFunction" || node.type === "DeclareInterface" || node.type === "DeclareModule" || node.type === "DeclareModuleExports" || node.type === "DeclareVariable" || node.type === "DoWhileStatement" || node.type === "ExportAllDeclaration" || node.type === "ExportDefaultDeclaration" || node.type === "ExportNamedDeclaration" || node.type === "ExpressionStatement" || node.type === "ForAwaitStatement" || node.type === "ForInStatement" || node.type === "ForOfStatement" || node.type === "ForStatement" || node.type === "FunctionDeclaration" || node.type === "IfStatement" || node.type === "ImportDeclaration" || node.type === "InterfaceDeclaration" || node.type === "LabeledStatement" || node.type === "MethodDefinition" || node.type === "ReturnStatement" || node.type === "SwitchStatement" || node.type === "ThrowStatement" || node.type === "TryStatement" || node.type === "TSDeclareFunction" || node.type === "TSEnumDeclaration" || node.type === "TSImportEqualsDeclaration" || node.type === "TSInterfaceDeclaration" || node.type === "TSModuleDeclaration" || node.type === "TSNamespaceExportDeclaration" || node.type === "TypeAlias" || node.type === "VariableDeclaration" || node.type === "WhileStatement" || node.type === "WithStatement";
}

function getUnparenthesizedNode(node) {
  return node.type === "TSParenthesizedType" ? getUnparenthesizedNode(node.typeAnnotation) : node;
}

function endsWithRightBracket(node) {
  switch (node.type) {
    case "ObjectExpression":
      return true;

    default:
      return false;
  }
}

function isFollowedByRightBracket(path$$1) {
  var node = path$$1.getValue();
  var parent = path$$1.getParentNode();
  var name = path$$1.getName();

  switch (parent.type) {
    case "NGPipeExpression":
      if (typeof name === "number" && parent.arguments[name] === node && parent.arguments.length - 1 === name) {
        return path$$1.callParent(isFollowedByRightBracket);
      }

      break;

    case "ObjectProperty":
      if (name === "value") {
        var parentParent = path$$1.getParentNode(1);
        return parentParent.properties[parentParent.properties.length - 1] === parent;
      }

      break;

    case "BinaryExpression":
    case "LogicalExpression":
      if (name === "right") {
        return path$$1.callParent(isFollowedByRightBracket);
      }

      break;

    case "ConditionalExpression":
      if (name === "alternate") {
        return path$$1.callParent(isFollowedByRightBracket);
      }

      break;

    case "UnaryExpression":
      if (parent.prefix) {
        return path$$1.callParent(isFollowedByRightBracket);
      }

      break;
  }

  return false;
}

function shouldWrapFunctionForExportDefault(path$$1, options) {
  var node = path$$1.getValue();
  var parent = path$$1.getParentNode();

  if (node.type === "FunctionExpression" || node.type === "ClassExpression") {
    return parent.type === "ExportDefaultDeclaration" || // in some cases the function is already wrapped
    // (e.g. `export default (function() {})();`)
    // in this case we don't need to add extra parens
    !needsParens(path$$1, options);
  }

  if (!hasNakedLeftSide$1(node) || parent.type !== "ExportDefaultDeclaration" && needsParens(path$$1, options)) {
    return false;
  }

  return path$$1.call.apply(path$$1, [function (childPath) {
    return shouldWrapFunctionForExportDefault(childPath, options);
  }].concat(getLeftSidePathName$1(path$$1, node)));
}

var needsParens_1 = needsParens;

var _require$$0$builders$1 = doc.builders;
var concat$6 = _require$$0$builders$1.concat;
var join$4 = _require$$0$builders$1.join;
var line$4 = _require$$0$builders$1.line;

function printHtmlBinding$1(path$$1, options, print) {
  var node = path$$1.getValue();

  if (options.__onHtmlBindingRoot && path$$1.getName() === null) {
    options.__onHtmlBindingRoot(node);
  }

  if (node.type !== "File") {
    return;
  }

  if (options.__isVueForBindingLeft) {
    return path$$1.call(function (functionDeclarationPath) {
      var _functionDeclarationP = functionDeclarationPath.getValue(),
          params = _functionDeclarationP.params;

      return concat$6([params.length > 1 ? "(" : "", join$4(concat$6([",", line$4]), functionDeclarationPath.map(print, "params")), params.length > 1 ? ")" : ""]);
    }, "program", "body", 0);
  }

  if (options.__isVueSlotScope) {
    return path$$1.call(function (functionDeclarationPath) {
      return join$4(concat$6([",", line$4]), functionDeclarationPath.map(print, "params"));
    }, "program", "body", 0);
  }
} // based on https://github.com/prettier/prettier/blob/master/src/language-html/syntax-vue.js isVueEventBindingExpression()


function isVueEventBindingExpression$1(node) {
  switch (node.type) {
    case "MemberExpression":
      switch (node.property.type) {
        case "Identifier":
        case "NumericLiteral":
        case "StringLiteral":
          return isVueEventBindingExpression$1(node.object);
      }

      return false;

    case "Identifier":
      return true;

    default:
      return false;
  }
}

var htmlBinding = {
  isVueEventBindingExpression: isVueEventBindingExpression$1,
  printHtmlBinding: printHtmlBinding$1
};

function preprocess(ast, options) {
  switch (options.parser) {
    case "json":
    case "json5":
    case "json-stringify":
    case "__js_expression":
    case "__vue_expression":
      return Object.assign({}, ast, {
        type: options.parser.startsWith("__") ? "JsExpressionRoot" : "JsonRoot",
        node: ast,
        comments: []
      });

    default:
      return ast;
  }
}

var preprocess_1 = preprocess;

var getParentExportDeclaration$1 = util$1.getParentExportDeclaration;
var isExportDeclaration$1 = util$1.isExportDeclaration;
var shouldFlatten$1 = util$1.shouldFlatten;
var getNextNonSpaceNonCommentCharacter$1 = util$1.getNextNonSpaceNonCommentCharacter;
var hasNewline$2 = util$1.hasNewline;
var hasNewlineInRange$1 = util$1.hasNewlineInRange;
var getLast$3 = util$1.getLast;
var getStringWidth$2 = util$1.getStringWidth;
var printString$1 = util$1.printString;
var printNumber$1 = util$1.printNumber;
var hasIgnoreComment$1 = util$1.hasIgnoreComment;
var skipWhitespace$1 = util$1.skipWhitespace;
var hasNodeIgnoreComment$1 = util$1.hasNodeIgnoreComment;
var getPenultimate$1 = util$1.getPenultimate;
var startsWithNoLookaheadToken$1 = util$1.startsWithNoLookaheadToken;
var getIndentSize$1 = util$1.getIndentSize;
var matchAncestorTypes$1 = util$1.matchAncestorTypes;
var getPreferredQuote$1 = util$1.getPreferredQuote;
var isNextLineEmpty$2 = utilShared.isNextLineEmpty;
var isNextLineEmptyAfterIndex$1 = utilShared.isNextLineEmptyAfterIndex;
var getNextNonSpaceNonCommentCharacterIndex$2 = utilShared.getNextNonSpaceNonCommentCharacterIndex;
var isIdentifierName = utils$2.keyword.isIdentifierNameES5;
var insertPragma = pragma.insertPragma;
var printHtmlBinding = htmlBinding.printHtmlBinding;
var isVueEventBindingExpression = htmlBinding.isVueEventBindingExpression;
var getLeftSide = utils$4.getLeftSide;
var getLeftSidePathName = utils$4.getLeftSidePathName;
var hasNakedLeftSide = utils$4.hasNakedLeftSide;
var hasNode = utils$4.hasNode;
var hasFlowAnnotationComment = utils$4.hasFlowAnnotationComment;
var hasFlowShorthandAnnotationComment = utils$4.hasFlowShorthandAnnotationComment;
var needsQuoteProps = new WeakMap();
var _require$$6$builders = doc.builders;
var concat$4 = _require$$6$builders.concat;
var join$2 = _require$$6$builders.join;
var line$3 = _require$$6$builders.line;
var hardline$3 = _require$$6$builders.hardline;
var softline$1 = _require$$6$builders.softline;
var literalline$1 = _require$$6$builders.literalline;
var group$1 = _require$$6$builders.group;
var indent$2 = _require$$6$builders.indent;
var align$1 = _require$$6$builders.align;
var conditionalGroup$1 = _require$$6$builders.conditionalGroup;
var fill$2 = _require$$6$builders.fill;
var ifBreak$1 = _require$$6$builders.ifBreak;
var breakParent$2 = _require$$6$builders.breakParent;
var lineSuffixBoundary$1 = _require$$6$builders.lineSuffixBoundary;
var addAlignmentToDoc$2 = _require$$6$builders.addAlignmentToDoc;
var dedent$2 = _require$$6$builders.dedent;
var _require$$6$utils = doc.utils;
var willBreak$1 = _require$$6$utils.willBreak;
var isLineNext$1 = _require$$6$utils.isLineNext;
var isEmpty$1 = _require$$6$utils.isEmpty;
var removeLines$1 = _require$$6$utils.removeLines;
var printDocToString$2 = doc.printer.printDocToString;
var uid = 0;

function shouldPrintComma(options, level) {
  level = level || "es5";

  switch (options.trailingComma) {
    case "all":
      if (level === "all") {
        return true;
      }

    // fallthrough

    case "es5":
      if (level === "es5") {
        return true;
      }

    // fallthrough

    case "none":
    default:
      return false;
  }
}

function genericPrint(path$$1, options, printPath, args) {
  var node = path$$1.getValue();
  var needsParens = false;
  var linesWithoutParens = printPathNoParens(path$$1, options, printPath, args);

  if (!node || isEmpty$1(linesWithoutParens)) {
    return linesWithoutParens;
  }

  var parentExportDecl = getParentExportDeclaration$1(path$$1);
  var decorators = [];

  if (node.type === "ClassMethod" || node.type === "ClassPrivateMethod" || node.type === "ClassProperty" || node.type === "TSAbstractClassProperty" || node.type === "ClassPrivateProperty" || node.type === "MethodDefinition" || node.type === "TSAbstractMethodDefinition") {// their decorators are handled themselves
  } else if (node.decorators && node.decorators.length > 0 && // If the parent node is an export declaration and the decorator
  // was written before the export, the export will be responsible
  // for printing the decorators.
  !(parentExportDecl && options.locStart(parentExportDecl, {
    ignoreDecorators: true
  }) > options.locStart(node.decorators[0]))) {
    var shouldBreak = node.type === "ClassExpression" || node.type === "ClassDeclaration" || hasNewlineBetweenOrAfterDecorators(node, options);
    var separator = shouldBreak ? hardline$3 : line$3;
    path$$1.each(function (decoratorPath) {
      var decorator = decoratorPath.getValue();

      if (decorator.expression) {
        decorator = decorator.expression;
      } else {
        decorator = decorator.callee;
      }

      decorators.push(printPath(decoratorPath), separator);
    }, "decorators");

    if (parentExportDecl) {
      decorators.unshift(hardline$3);
    }
  } else if (isExportDeclaration$1(node) && node.declaration && node.declaration.decorators && node.declaration.decorators.length > 0 && // Only print decorators here if they were written before the export,
  // otherwise they are printed by the node.declaration
  options.locStart(node, {
    ignoreDecorators: true
  }) > options.locStart(node.declaration.decorators[0])) {
    // Export declarations are responsible for printing any decorators
    // that logically apply to node.declaration.
    path$$1.each(function (decoratorPath) {
      var decorator = decoratorPath.getValue();
      var prefix = decorator.type === "Decorator" ? "" : "@";
      decorators.push(prefix, printPath(decoratorPath), hardline$3);
    }, "declaration", "decorators");
  } else {
    // Nodes with decorators can't have parentheses, so we can avoid
    // computing pathNeedsParens() except in this case.
    needsParens = needsParens_1(path$$1, options);
  }

  var parts = [];

  if (needsParens) {
    parts.unshift("(");
  }

  parts.push(linesWithoutParens);

  if (needsParens) {
    var _node = path$$1.getValue();

    if (hasFlowShorthandAnnotationComment(_node)) {
      parts.push(" /*");
      parts.push(_node.trailingComments[0].value.trimLeft());
      parts.push("*/");
      _node.trailingComments[0].printed = true;
    }

    parts.push(")");
  }

  if (decorators.length > 0) {
    return group$1(concat$4(decorators.concat(parts)));
  }

  return concat$4(parts);
}

function hasNewlineBetweenOrAfterDecorators(node, options) {
  return hasNewlineInRange$1(options.originalText, options.locStart(node.decorators[0]), options.locEnd(getLast$3(node.decorators))) || hasNewline$2(options.originalText, options.locEnd(getLast$3(node.decorators)));
}

function printDecorators(path$$1, options, print) {
  var node = path$$1.getValue();
  return group$1(concat$4([join$2(line$3, path$$1.map(print, "decorators")), hasNewlineBetweenOrAfterDecorators(node, options) ? hardline$3 : line$3]));
}

function hasPrettierIgnore(path$$1) {
  return hasIgnoreComment$1(path$$1) || hasJsxIgnoreComment(path$$1);
}

function hasJsxIgnoreComment(path$$1) {
  var node = path$$1.getValue();
  var parent = path$$1.getParentNode();

  if (!parent || !node || !isJSXNode(node) || !isJSXNode(parent)) {
    return false;
  } // Lookup the previous sibling, ignoring any empty JSXText elements


  var index = parent.children.indexOf(node);
  var prevSibling = null;

  for (var i = index; i > 0; i--) {
    var candidate = parent.children[i - 1];

    if (candidate.type === "JSXText" && !isMeaningfulJSXText(candidate)) {
      continue;
    }

    prevSibling = candidate;
    break;
  }

  return prevSibling && prevSibling.type === "JSXExpressionContainer" && prevSibling.expression.type === "JSXEmptyExpression" && prevSibling.expression.comments && prevSibling.expression.comments.find(function (comment) {
    return comment.value.trim() === "prettier-ignore";
  });
}
/**
 * The following is the shared logic for
 * ternary operators, namely ConditionalExpression
 * and TSConditionalType
 * @typedef {Object} OperatorOptions
 * @property {() => Array<string | Doc>} beforeParts - Parts to print before the `?`.
 * @property {(breakClosingParen: boolean) => Array<string | Doc>} afterParts - Parts to print after the conditional expression.
 * @property {boolean} shouldCheckJsx - Whether to check for and print in JSX mode.
 * @property {string} conditionalNodeType - The type of the conditional expression node, ie "ConditionalExpression" or "TSConditionalType".
 * @property {string} consequentNodePropertyName - The property at which the consequent node can be found on the main node, eg "consequent".
 * @property {string} alternateNodePropertyName - The property at which the alternate node can be found on the main node, eg "alternate".
 * @property {string} testNodePropertyName - The property at which the test node can be found on the main node, eg "test".
 * @property {boolean} breakNested - Whether to break all nested ternaries when one breaks.
 * @param {FastPath} path - The path to the ConditionalExpression/TSConditionalType node.
 * @param {Options} options - Prettier options
 * @param {Function} print - Print function to call recursively
 * @param {OperatorOptions} operatorOptions
 * @returns Doc
 */


function printTernaryOperator(path$$1, options, print, operatorOptions) {
  var node = path$$1.getValue();
  var testNode = node[operatorOptions.testNodePropertyName];
  var consequentNode = node[operatorOptions.consequentNodePropertyName];
  var alternateNode = node[operatorOptions.alternateNodePropertyName];
  var parts = []; // We print a ConditionalExpression in either "JSX mode" or "normal mode".
  // See tests/jsx/conditional-expression.js for more info.

  var jsxMode = false;
  var parent = path$$1.getParentNode();
  var forceNoIndent = parent.type === operatorOptions.conditionalNodeType; // Find the outermost non-ConditionalExpression parent, and the outermost
  // ConditionalExpression parent. We'll use these to determine if we should
  // print in JSX mode.

  var currentParent;
  var previousParent;
  var i = 0;

  do {
    previousParent = currentParent || node;
    currentParent = path$$1.getParentNode(i);
    i++;
  } while (currentParent && currentParent.type === operatorOptions.conditionalNodeType);

  var firstNonConditionalParent = currentParent || parent;
  var lastConditionalParent = previousParent;

  if (operatorOptions.shouldCheckJsx && (isJSXNode(testNode) || isJSXNode(consequentNode) || isJSXNode(alternateNode) || conditionalExpressionChainContainsJSX(lastConditionalParent))) {
    jsxMode = true;
    forceNoIndent = true; // Even though they don't need parens, we wrap (almost) everything in
    // parens when using ?: within JSX, because the parens are analogous to
    // curly braces in an if statement.

    var wrap = function wrap(doc$$2) {
      return concat$4([ifBreak$1("(", ""), indent$2(concat$4([softline$1, doc$$2])), softline$1, ifBreak$1(")", "")]);
    }; // The only things we don't wrap are:
    // * Nested conditional expressions in alternates
    // * null


    var isNull = function isNull(node) {
      return node.type === "NullLiteral" || node.type === "Literal" && node.value === null;
    };

    parts.push(" ? ", isNull(consequentNode) ? path$$1.call(print, operatorOptions.consequentNodePropertyName) : wrap(path$$1.call(print, operatorOptions.consequentNodePropertyName)), " : ", alternateNode.type === operatorOptions.conditionalNodeType || isNull(alternateNode) ? path$$1.call(print, operatorOptions.alternateNodePropertyName) : wrap(path$$1.call(print, operatorOptions.alternateNodePropertyName)));
  } else {
    // normal mode
    var part = concat$4([line$3, "? ", consequentNode.type === operatorOptions.conditionalNodeType ? ifBreak$1("", "(") : "", align$1(2, path$$1.call(print, operatorOptions.consequentNodePropertyName)), consequentNode.type === operatorOptions.conditionalNodeType ? ifBreak$1("", ")") : "", line$3, ": ", alternateNode.type === operatorOptions.conditionalNodeType ? path$$1.call(print, operatorOptions.alternateNodePropertyName) : align$1(2, path$$1.call(print, operatorOptions.alternateNodePropertyName))]);
    parts.push(parent.type !== operatorOptions.conditionalNodeType || parent[operatorOptions.alternateNodePropertyName] === node ? part : options.useTabs ? dedent$2(indent$2(part)) : align$1(Math.max(0, options.tabWidth - 2), part));
  } // We want a whole chain of ConditionalExpressions to all
  // break if any of them break. That means we should only group around the
  // outer-most ConditionalExpression.


  var maybeGroup = function maybeGroup(doc$$2) {
    return operatorOptions.breakNested ? parent === firstNonConditionalParent ? group$1(doc$$2) : doc$$2 : group$1(doc$$2);
  }; // Break the closing paren to keep the chain right after it:
  // (a
  //   ? b
  //   : c
  // ).call()


  var breakClosingParen = !jsxMode && (parent.type === "MemberExpression" || parent.type === "OptionalMemberExpression") && !parent.computed;
  return maybeGroup(concat$4([].concat(function (testDoc) {
    return (
      /**
       *     a
       *       ? b
       *       : multiline
       *         test
       *         node
       *       ^^ align(2)
       *       ? d
       *       : e
       */
      parent.type === operatorOptions.conditionalNodeType && parent[operatorOptions.alternateNodePropertyName] === node ? align$1(2, testDoc) : testDoc
    );
  }(concat$4(operatorOptions.beforeParts())), forceNoIndent ? concat$4(parts) : indent$2(concat$4(parts)), operatorOptions.afterParts(breakClosingParen))));
}

function getTypeScriptMappedTypeModifier(tokenNode, keyword) {
  if (tokenNode === "+") {
    return "+" + keyword;
  } else if (tokenNode === "-") {
    return "-" + keyword;
  }

  return keyword;
}

function printPathNoParens(path$$1, options, print, args) {
  var n = path$$1.getValue();
  var semi = options.semi ? ";" : "";

  if (!n) {
    return "";
  }

  if (typeof n === "string") {
    return n;
  }

  var htmlBinding$$1 = printHtmlBinding(path$$1, options, print);

  if (htmlBinding$$1) {
    return htmlBinding$$1;
  }

  var parts = [];

  switch (n.type) {
    case "JsExpressionRoot":
      return path$$1.call(print, "node");

    case "JsonRoot":
      return concat$4([path$$1.call(print, "node"), hardline$3]);

    case "File":
      // Print @babel/parser's InterpreterDirective here so that
      // leading comments on the `Program` node get printed after the hashbang.
      if (n.program && n.program.interpreter) {
        parts.push(path$$1.call(function (programPath) {
          return programPath.call(print, "interpreter");
        }, "program"));
      }

      parts.push(path$$1.call(print, "program"));
      return concat$4(parts);

    case "Program":
      // Babel 6
      if (n.directives) {
        path$$1.each(function (childPath) {
          parts.push(print(childPath), semi, hardline$3);

          if (isNextLineEmpty$2(options.originalText, childPath.getValue(), options)) {
            parts.push(hardline$3);
          }
        }, "directives");
      }

      parts.push(path$$1.call(function (bodyPath) {
        return printStatementSequence(bodyPath, options, print);
      }, "body"));
      parts.push(comments.printDanglingComments(path$$1, options,
      /* sameIndent */
      true)); // Only force a trailing newline if there were any contents.

      if (n.body.length || n.comments) {
        parts.push(hardline$3);
      }

      return concat$4(parts);
    // Babel extension.

    case "EmptyStatement":
      return "";

    case "ExpressionStatement":
      // Detect Flow-parsed directives
      if (n.directive) {
        return concat$4([nodeStr(n.expression, options, true), semi]);
      }

      if (options.parser === "__vue_event_binding") {
        var parent = path$$1.getParentNode();

        if (parent.type === "Program" && parent.body.length === 1 && parent.body[0] === n) {
          return concat$4([path$$1.call(print, "expression"), isVueEventBindingExpression(n.expression) ? ";" : ""]);
        }
      } // Do not append semicolon after the only JSX element in a program


      return concat$4([path$$1.call(print, "expression"), isTheOnlyJSXElementInMarkdown(options, path$$1) ? "" : semi]);
    // Babel extension.

    case "ParenthesizedExpression":
      return concat$4(["(", path$$1.call(print, "expression"), ")"]);

    case "AssignmentExpression":
      return printAssignment(n.left, path$$1.call(print, "left"), concat$4([" ", n.operator]), n.right, path$$1.call(print, "right"), options);

    case "BinaryExpression":
    case "LogicalExpression":
    case "NGPipeExpression":
      {
        var _parent = path$$1.getParentNode();

        var parentParent = path$$1.getParentNode(1);
        var isInsideParenthesis = n !== _parent.body && (_parent.type === "IfStatement" || _parent.type === "WhileStatement" || _parent.type === "DoWhileStatement");

        var _parts = printBinaryishExpressions(path$$1, print, options,
        /* isNested */
        false, isInsideParenthesis); //   if (
        //     this.hasPlugin("dynamicImports") && this.lookahead().type === tt.parenLeft
        //   ) {
        //
        // looks super weird, we want to break the children if the parent breaks
        //
        //   if (
        //     this.hasPlugin("dynamicImports") &&
        //     this.lookahead().type === tt.parenLeft
        //   ) {


        if (isInsideParenthesis) {
          return concat$4(_parts);
        } // Break between the parens in unaries or in a member expression, i.e.
        //
        //   (
        //     a &&
        //     b &&
        //     c
        //   ).call()


        if (_parent.type === "UnaryExpression" || (_parent.type === "MemberExpression" || _parent.type === "OptionalMemberExpression") && !_parent.computed) {
          return group$1(concat$4([indent$2(concat$4([softline$1, concat$4(_parts)])), softline$1]));
        } // Avoid indenting sub-expressions in some cases where the first sub-expression is already
        // indented accordingly. We should indent sub-expressions where the first case isn't indented.


        var shouldNotIndent = _parent.type === "ReturnStatement" || _parent.type === "JSXExpressionContainer" && parentParent.type === "JSXAttribute" || n.type !== "NGPipeExpression" && (_parent.type === "NGRoot" && options.parser === "__ng_binding" || _parent.type === "NGMicrosyntaxExpression" && parentParent.type === "NGMicrosyntax" && parentParent.body.length === 1) || n === _parent.body && _parent.type === "ArrowFunctionExpression" || n !== _parent.body && _parent.type === "ForStatement" || _parent.type === "ConditionalExpression" && parentParent.type !== "ReturnStatement" && parentParent.type !== "CallExpression";
        var shouldIndentIfInlining = _parent.type === "AssignmentExpression" || _parent.type === "VariableDeclarator" || _parent.type === "ClassProperty" || _parent.type === "TSAbstractClassProperty" || _parent.type === "ClassPrivateProperty" || _parent.type === "ObjectProperty" || _parent.type === "Property";
        var samePrecedenceSubExpression = isBinaryish(n.left) && shouldFlatten$1(n.operator, n.left.operator);

        if (shouldNotIndent || shouldInlineLogicalExpression(n) && !samePrecedenceSubExpression || !shouldInlineLogicalExpression(n) && shouldIndentIfInlining) {
          return group$1(concat$4(_parts));
        }

        if (_parts.length === 0) {
          return "";
        } // If the right part is a JSX node, we include it in a separate group to
        // prevent it breaking the whole chain, so we can print the expression like:
        //
        //   foo && bar && (
        //     <Foo>
        //       <Bar />
        //     </Foo>
        //   )


        var hasJSX = isJSXNode(n.right);
        var rest = concat$4(hasJSX ? _parts.slice(1, -1) : _parts.slice(1));
        var groupId = Symbol("logicalChain-" + ++uid);
        var chain = group$1(concat$4([// Don't include the initial expression in the indentation
        // level. The first item is guaranteed to be the first
        // left-most expression.
        _parts.length > 0 ? _parts[0] : "", indent$2(rest)]), {
          id: groupId
        });

        if (!hasJSX) {
          return chain;
        }

        var jsxPart = getLast$3(_parts);
        return group$1(concat$4([chain, ifBreak$1(indent$2(jsxPart), jsxPart, {
          groupId
        })]));
      }

    case "AssignmentPattern":
      return concat$4([path$$1.call(print, "left"), " = ", path$$1.call(print, "right")]);

    case "TSTypeAssertion":
      {
        var shouldBreakAfterCast = !(n.expression.type === "ArrayExpression" || n.expression.type === "ObjectExpression");
        var castGroup = group$1(concat$4(["<", indent$2(concat$4([softline$1, path$$1.call(print, "typeAnnotation")])), softline$1, ">"]));
        var exprContents = concat$4([ifBreak$1("("), indent$2(concat$4([softline$1, path$$1.call(print, "expression")])), softline$1, ifBreak$1(")")]);

        if (shouldBreakAfterCast) {
          return conditionalGroup$1([concat$4([castGroup, path$$1.call(print, "expression")]), concat$4([castGroup, group$1(exprContents, {
            shouldBreak: true
          })]), concat$4([castGroup, path$$1.call(print, "expression")])]);
        }

        return group$1(concat$4([castGroup, path$$1.call(print, "expression")]));
      }

    case "OptionalMemberExpression":
    case "MemberExpression":
      {
        var _parent2 = path$$1.getParentNode();

        var firstNonMemberParent;
        var i = 0;

        do {
          firstNonMemberParent = path$$1.getParentNode(i);
          i++;
        } while (firstNonMemberParent && (firstNonMemberParent.type === "MemberExpression" || firstNonMemberParent.type === "OptionalMemberExpression" || firstNonMemberParent.type === "TSNonNullExpression"));

        var shouldInline = firstNonMemberParent && (firstNonMemberParent.type === "NewExpression" || firstNonMemberParent.type === "BindExpression" || firstNonMemberParent.type === "VariableDeclarator" && firstNonMemberParent.id.type !== "Identifier" || firstNonMemberParent.type === "AssignmentExpression" && firstNonMemberParent.left.type !== "Identifier") || n.computed || n.object.type === "Identifier" && n.property.type === "Identifier" && _parent2.type !== "MemberExpression" && _parent2.type !== "OptionalMemberExpression";
        return concat$4([path$$1.call(print, "object"), shouldInline ? printMemberLookup(path$$1, options, print) : group$1(indent$2(concat$4([softline$1, printMemberLookup(path$$1, options, print)])))]);
      }

    case "MetaProperty":
      return concat$4([path$$1.call(print, "meta"), ".", path$$1.call(print, "property")]);

    case "BindExpression":
      if (n.object) {
        parts.push(path$$1.call(print, "object"));
      }

      parts.push(group$1(indent$2(concat$4([softline$1, printBindExpressionCallee(path$$1, options, print)]))));
      return concat$4(parts);

    case "Identifier":
      {
        return concat$4([n.name, printOptionalToken(path$$1), printTypeAnnotation(path$$1, options, print)]);
      }

    case "SpreadElement":
    case "SpreadElementPattern":
    case "RestProperty":
    case "SpreadProperty":
    case "SpreadPropertyPattern":
    case "RestElement":
    case "ObjectTypeSpreadProperty":
      return concat$4(["...", path$$1.call(print, "argument"), printTypeAnnotation(path$$1, options, print)]);

    case "FunctionDeclaration":
    case "FunctionExpression":
      parts.push(printFunctionDeclaration(path$$1, print, options));

      if (!n.body) {
        parts.push(semi);
      }

      return concat$4(parts);

    case "ArrowFunctionExpression":
      {
        if (n.async) {
          parts.push("async ");
        }

        if (shouldPrintParamsWithoutParens(path$$1, options)) {
          parts.push(path$$1.call(print, "params", 0));
        } else {
          parts.push(group$1(concat$4([printFunctionParams(path$$1, print, options,
          /* expandLast */
          args && (args.expandLastArg || args.expandFirstArg),
          /* printTypeParams */
          true), printReturnType(path$$1, print, options)])));
        }

        var dangling = comments.printDanglingComments(path$$1, options,
        /* sameIndent */
        true, function (comment) {
          var nextCharacter = getNextNonSpaceNonCommentCharacterIndex$2(options.originalText, comment, options);
          return options.originalText.substr(nextCharacter, 2) === "=>";
        });

        if (dangling) {
          parts.push(" ", dangling);
        }

        parts.push(" =>");
        var body = path$$1.call(function (bodyPath) {
          return print(bodyPath, args);
        }, "body"); // We want to always keep these types of nodes on the same line
        // as the arrow.

        if (!hasLeadingOwnLineComment(options.originalText, n.body, options) && (n.body.type === "ArrayExpression" || n.body.type === "ObjectExpression" || n.body.type === "BlockStatement" || isJSXNode(n.body) || isTemplateOnItsOwnLine(n.body, options.originalText, options) || n.body.type === "ArrowFunctionExpression" || n.body.type === "DoExpression")) {
          return group$1(concat$4([concat$4(parts), " ", body]));
        } // We handle sequence expressions as the body of arrows specially,
        // so that the required parentheses end up on their own lines.


        if (n.body.type === "SequenceExpression") {
          return group$1(concat$4([concat$4(parts), group$1(concat$4([" (", indent$2(concat$4([softline$1, body])), softline$1, ")"]))]));
        } // if the arrow function is expanded as last argument, we are adding a
        // level of indentation and need to add a softline to align the closing )
        // with the opening (, or if it's inside a JSXExpression (e.g. an attribute)
        // we should align the expression's closing } with the line with the opening {.


        var shouldAddSoftLine = (args && args.expandLastArg || path$$1.getParentNode().type === "JSXExpressionContainer") && !(n.comments && n.comments.length);
        var printTrailingComma = args && args.expandLastArg && shouldPrintComma(options, "all"); // In order to avoid confusion between
        // a => a ? a : a
        // a <= a ? a : a

        var shouldAddParens = n.body.type === "ConditionalExpression" && !startsWithNoLookaheadToken$1(n.body,
        /* forbidFunctionAndClass */
        false);
        return group$1(concat$4([concat$4(parts), group$1(concat$4([indent$2(concat$4([line$3, shouldAddParens ? ifBreak$1("", "(") : "", body, shouldAddParens ? ifBreak$1("", ")") : ""])), shouldAddSoftLine ? concat$4([ifBreak$1(printTrailingComma ? "," : ""), softline$1]) : ""]))]));
      }

    case "MethodDefinition":
    case "TSAbstractMethodDefinition":
      if (n.decorators && n.decorators.length !== 0) {
        parts.push(printDecorators(path$$1, options, print));
      }

      if (n.accessibility) {
        parts.push(n.accessibility + " ");
      }

      if (n.static) {
        parts.push("static ");
      }

      if (n.type === "TSAbstractMethodDefinition") {
        parts.push("abstract ");
      }

      parts.push(printMethod(path$$1, options, print));
      return concat$4(parts);

    case "YieldExpression":
      parts.push("yield");

      if (n.delegate) {
        parts.push("*");
      }

      if (n.argument) {
        parts.push(" ", path$$1.call(print, "argument"));
      }

      return concat$4(parts);

    case "AwaitExpression":
      return concat$4(["await ", path$$1.call(print, "argument")]);

    case "ImportSpecifier":
      if (n.importKind) {
        parts.push(path$$1.call(print, "importKind"), " ");
      }

      parts.push(path$$1.call(print, "imported"));

      if (n.local && n.local.name !== n.imported.name) {
        parts.push(" as ", path$$1.call(print, "local"));
      }

      return concat$4(parts);

    case "ExportSpecifier":
      parts.push(path$$1.call(print, "local"));

      if (n.exported && n.exported.name !== n.local.name) {
        parts.push(" as ", path$$1.call(print, "exported"));
      }

      return concat$4(parts);

    case "ImportNamespaceSpecifier":
      parts.push("* as ");
      parts.push(path$$1.call(print, "local"));
      return concat$4(parts);

    case "ImportDefaultSpecifier":
      return path$$1.call(print, "local");

    case "TSExportAssignment":
      return concat$4(["export = ", path$$1.call(print, "expression"), semi]);

    case "ExportDefaultDeclaration":
    case "ExportNamedDeclaration":
      return printExportDeclaration(path$$1, options, print);

    case "ExportAllDeclaration":
      parts.push("export ");

      if (n.exportKind === "type") {
        parts.push("type ");
      }

      parts.push("* from ", path$$1.call(print, "source"), semi);
      return concat$4(parts);

    case "ExportNamespaceSpecifier":
    case "ExportDefaultSpecifier":
      return path$$1.call(print, "exported");

    case "ImportDeclaration":
      {
        parts.push("import ");

        if (n.importKind && n.importKind !== "value") {
          parts.push(n.importKind + " ");
        }

        var standalones = [];
        var grouped = [];

        if (n.specifiers && n.specifiers.length > 0) {
          path$$1.each(function (specifierPath) {
            var value = specifierPath.getValue();

            if (value.type === "ImportDefaultSpecifier" || value.type === "ImportNamespaceSpecifier") {
              standalones.push(print(specifierPath));
            } else {
              grouped.push(print(specifierPath));
            }
          }, "specifiers");

          if (standalones.length > 0) {
            parts.push(join$2(", ", standalones));
          }

          if (standalones.length > 0 && grouped.length > 0) {
            parts.push(", ");
          }

          if (grouped.length === 1 && standalones.length === 0 && n.specifiers && !n.specifiers.some(function (node) {
            return node.comments;
          })) {
            parts.push(concat$4(["{", options.bracketSpacing ? " " : "", concat$4(grouped), options.bracketSpacing ? " " : "", "}"]));
          } else if (grouped.length >= 1) {
            parts.push(group$1(concat$4(["{", indent$2(concat$4([options.bracketSpacing ? line$3 : softline$1, join$2(concat$4([",", line$3]), grouped)])), ifBreak$1(shouldPrintComma(options) ? "," : ""), options.bracketSpacing ? line$3 : softline$1, "}"])));
          }

          parts.push(" from ");
        } else if (n.importKind && n.importKind === "type" || // import {} from 'x'
        /{\s*}/.test(options.originalText.slice(options.locStart(n), options.locStart(n.source)))) {
          parts.push("{} from ");
        }

        parts.push(path$$1.call(print, "source"), semi);
        return concat$4(parts);
      }

    case "Import":
      return "import";

    case "TSModuleBlock":
    case "BlockStatement":
      {
        var naked = path$$1.call(function (bodyPath) {
          return printStatementSequence(bodyPath, options, print);
        }, "body");
        var hasContent = n.body.find(function (node) {
          return node.type !== "EmptyStatement";
        });
        var hasDirectives = n.directives && n.directives.length > 0;

        var _parent3 = path$$1.getParentNode();

        var _parentParent = path$$1.getParentNode(1);

        if (!hasContent && !hasDirectives && !hasDanglingComments(n) && (_parent3.type === "ArrowFunctionExpression" || _parent3.type === "FunctionExpression" || _parent3.type === "FunctionDeclaration" || _parent3.type === "ObjectMethod" || _parent3.type === "ClassMethod" || _parent3.type === "ClassPrivateMethod" || _parent3.type === "ForStatement" || _parent3.type === "WhileStatement" || _parent3.type === "DoWhileStatement" || _parent3.type === "DoExpression" || _parent3.type === "CatchClause" && !_parentParent.finalizer || _parent3.type === "TSModuleDeclaration")) {
          return "{}";
        }

        parts.push("{"); // Babel 6

        if (hasDirectives) {
          path$$1.each(function (childPath) {
            parts.push(indent$2(concat$4([hardline$3, print(childPath), semi])));

            if (isNextLineEmpty$2(options.originalText, childPath.getValue(), options)) {
              parts.push(hardline$3);
            }
          }, "directives");
        }

        if (hasContent) {
          parts.push(indent$2(concat$4([hardline$3, naked])));
        }

        parts.push(comments.printDanglingComments(path$$1, options));
        parts.push(hardline$3, "}");
        return concat$4(parts);
      }

    case "ReturnStatement":
      parts.push("return");

      if (n.argument) {
        if (returnArgumentHasLeadingComment(options, n.argument)) {
          parts.push(concat$4([" (", indent$2(concat$4([hardline$3, path$$1.call(print, "argument")])), hardline$3, ")"]));
        } else if (n.argument.type === "LogicalExpression" || n.argument.type === "BinaryExpression" || n.argument.type === "SequenceExpression") {
          parts.push(group$1(concat$4([ifBreak$1(" (", " "), indent$2(concat$4([softline$1, path$$1.call(print, "argument")])), softline$1, ifBreak$1(")")])));
        } else {
          parts.push(" ", path$$1.call(print, "argument"));
        }
      }

      if (hasDanglingComments(n)) {
        parts.push(" ", comments.printDanglingComments(path$$1, options,
        /* sameIndent */
        true));
      }

      parts.push(semi);
      return concat$4(parts);

    case "NewExpression":
    case "OptionalCallExpression":
    case "CallExpression":
      {
        var isNew = n.type === "NewExpression";
        var optional = printOptionalToken(path$$1);

        if ( // We want to keep CommonJS- and AMD-style require calls, and AMD-style
        // define calls, as a unit.
        // e.g. `define(["some/lib", (lib) => {`
        !isNew && n.callee.type === "Identifier" && (n.callee.name === "require" || n.callee.name === "define") || // Template literals as single arguments
        n.arguments.length === 1 && isTemplateOnItsOwnLine(n.arguments[0], options.originalText, options) || // Keep test declarations on a single line
        // e.g. `it('long name', () => {`
        !isNew && isTestCall(n, path$$1.getParentNode())) {
          return concat$4([isNew ? "new " : "", path$$1.call(print, "callee"), optional, printFunctionTypeParameters(path$$1, options, print), concat$4(["(", join$2(", ", path$$1.map(print, "arguments")), ")"])]);
        } // Inline Flow annotation comments following Identifiers in Call nodes need to
        // stay with the Identifier. For example:
        //
        // foo /*:: <SomeGeneric> */(bar);
        //
        // Here, we ensure that such comments stay between the Identifier and the Callee.


        var isIdentifierWithFlowAnnotation = n.callee.type === "Identifier" && hasFlowAnnotationComment(n.callee.trailingComments);

        if (isIdentifierWithFlowAnnotation) {
          n.callee.trailingComments[0].printed = true;
        } // We detect calls on member lookups and possibly print them in a
        // special chain format. See `printMemberChain` for more info.


        if (!isNew && isMemberish(n.callee)) {
          return printMemberChain(path$$1, options, print);
        }

        return concat$4([isNew ? "new " : "", path$$1.call(print, "callee"), optional, isIdentifierWithFlowAnnotation ? `/*:: ${n.callee.trailingComments[0].value.substring(2).trim()} */` : "", printFunctionTypeParameters(path$$1, options, print), printArgumentsList(path$$1, options, print)]);
      }

    case "TSInterfaceDeclaration":
      if (isNodeStartingWithDeclare(n, options)) {
        parts.push("declare ");
      }

      parts.push(n.abstract ? "abstract " : "", printTypeScriptModifiers(path$$1, options, print), "interface ", path$$1.call(print, "id"), n.typeParameters ? path$$1.call(print, "typeParameters") : "", " ");

      if (n.extends && n.extends.length) {
        parts.push(group$1(indent$2(concat$4([softline$1, "extends ", (n.extends.length === 1 ? identity$1 : indent$2)(join$2(concat$4([",", line$3]), path$$1.map(print, "extends"))), " "]))));
      }

      parts.push(path$$1.call(print, "body"));
      return concat$4(parts);

    case "ObjectTypeInternalSlot":
      return concat$4([n.static ? "static " : "", "[[", path$$1.call(print, "id"), "]]", printOptionalToken(path$$1), n.method ? "" : ": ", path$$1.call(print, "value")]);

    case "ObjectExpression":
    case "ObjectPattern":
    case "ObjectTypeAnnotation":
    case "TSInterfaceBody":
    case "TSTypeLiteral":
      {
        var propertiesField;

        if (n.type === "TSTypeLiteral") {
          propertiesField = "members";
        } else if (n.type === "TSInterfaceBody") {
          propertiesField = "body";
        } else {
          propertiesField = "properties";
        }

        var isTypeAnnotation = n.type === "ObjectTypeAnnotation";
        var fields = [];

        if (isTypeAnnotation) {
          fields.push("indexers", "callProperties", "internalSlots");
        }

        fields.push(propertiesField);
        var firstProperty = fields.map(function (field) {
          return n[field][0];
        }).sort(function (a, b) {
          return options.locStart(a) - options.locStart(b);
        })[0];

        var _parent4 = path$$1.getParentNode(0);

        var isFlowInterfaceLikeBody = isTypeAnnotation && _parent4 && (_parent4.type === "InterfaceDeclaration" || _parent4.type === "DeclareInterface" || _parent4.type === "DeclareClass") && path$$1.getName() === "body";
        var shouldBreak = n.type === "TSInterfaceBody" || isFlowInterfaceLikeBody || n.type === "ObjectPattern" && _parent4.type !== "FunctionDeclaration" && _parent4.type !== "FunctionExpression" && _parent4.type !== "ArrowFunctionExpression" && _parent4.type !== "AssignmentPattern" && _parent4.type !== "CatchClause" && n.properties.some(function (property) {
          return property.value && (property.value.type === "ObjectPattern" || property.value.type === "ArrayPattern");
        }) || n.type !== "ObjectPattern" && firstProperty && hasNewlineInRange$1(options.originalText, options.locStart(n), options.locStart(firstProperty));
        var separator = isFlowInterfaceLikeBody ? ";" : n.type === "TSInterfaceBody" || n.type === "TSTypeLiteral" ? ifBreak$1(semi, ";") : ",";
        var leftBrace = n.exact ? "{|" : "{";
        var rightBrace = n.exact ? "|}" : "}"; // Unfortunately, things are grouped together in the ast can be
        // interleaved in the source code. So we need to reorder them before
        // printing them.

        var propsAndLoc = [];
        fields.forEach(function (field) {
          path$$1.each(function (childPath) {
            var node = childPath.getValue();
            propsAndLoc.push({
              node: node,
              printed: print(childPath),
              loc: options.locStart(node)
            });
          }, field);
        });
        var separatorParts = [];
        var props = propsAndLoc.sort(function (a, b) {
          return a.loc - b.loc;
        }).map(function (prop) {
          var result = concat$4(separatorParts.concat(group$1(prop.printed)));
          separatorParts = [separator, line$3];

          if ((prop.node.type === "TSPropertySignature" || prop.node.type === "TSMethodSignature" || prop.node.type === "TSConstructSignatureDeclaration") && hasNodeIgnoreComment$1(prop.node)) {
            separatorParts.shift();
          }

          if (isNextLineEmpty$2(options.originalText, prop.node, options)) {
            separatorParts.push(hardline$3);
          }

          return result;
        });

        if (n.inexact) {
          props.push(concat$4(separatorParts.concat(group$1("..."))));
        }

        var lastElem = getLast$3(n[propertiesField]);
        var canHaveTrailingSeparator = !(lastElem && (lastElem.type === "RestProperty" || lastElem.type === "RestElement" || hasNodeIgnoreComment$1(lastElem) || n.inexact));
        var content;

        if (props.length === 0 && !n.typeAnnotation) {
          if (!hasDanglingComments(n)) {
            return concat$4([leftBrace, rightBrace]);
          }

          content = group$1(concat$4([leftBrace, comments.printDanglingComments(path$$1, options), softline$1, rightBrace, printOptionalToken(path$$1)]));
        } else {
          content = concat$4([leftBrace, indent$2(concat$4([options.bracketSpacing ? line$3 : softline$1, concat$4(props)])), ifBreak$1(canHaveTrailingSeparator && (separator !== "," || shouldPrintComma(options)) ? separator : ""), concat$4([options.bracketSpacing ? line$3 : softline$1, rightBrace]), printOptionalToken(path$$1), printTypeAnnotation(path$$1, options, print)]);
        } // If we inline the object as first argument of the parent, we don't want
        // to create another group so that the object breaks before the return
        // type


        var parentParentParent = path$$1.getParentNode(2);

        if (n.type === "ObjectPattern" && _parent4 && shouldHugArguments(_parent4) && _parent4.params[0] === n || shouldHugType(n) && parentParentParent && shouldHugArguments(parentParentParent) && parentParentParent.params[0].typeAnnotation && parentParentParent.params[0].typeAnnotation.typeAnnotation === n) {
          return content;
        }

        return group$1(content, {
          shouldBreak
        });
      }
    // Babel 6

    case "ObjectProperty": // Non-standard AST node type.

    case "Property":
      if (n.method || n.kind === "get" || n.kind === "set") {
        return printMethod(path$$1, options, print);
      }

      if (n.shorthand) {
        parts.push(path$$1.call(print, "value"));
      } else {
        var printedLeft;

        if (n.computed) {
          printedLeft = concat$4(["[", path$$1.call(print, "key"), "]"]);
        } else {
          printedLeft = printPropertyKey(path$$1, options, print);
        }

        parts.push(printAssignment(n.key, printedLeft, ":", n.value, path$$1.call(print, "value"), options));
      }

      return concat$4(parts);
    // Babel 6

    case "ClassMethod":
    case "ClassPrivateMethod":
      if (n.decorators && n.decorators.length !== 0) {
        parts.push(printDecorators(path$$1, options, print));
      }

      if (n.static) {
        parts.push("static ");
      }

      parts = parts.concat(printObjectMethod(path$$1, options, print));
      return concat$4(parts);
    // Babel 6

    case "ObjectMethod":
      return printObjectMethod(path$$1, options, print);

    case "Decorator":
      return concat$4(["@", path$$1.call(print, "expression"), path$$1.call(print, "callee")]);

    case "ArrayExpression":
    case "ArrayPattern":
      if (n.elements.length === 0) {
        if (!hasDanglingComments(n)) {
          parts.push("[]");
        } else {
          parts.push(group$1(concat$4(["[", comments.printDanglingComments(path$$1, options), softline$1, "]"])));
        }
      } else {
        var _lastElem = getLast$3(n.elements);

        var canHaveTrailingComma = !(_lastElem && _lastElem.type === "RestElement"); // JavaScript allows you to have empty elements in an array which
        // changes its length based on the number of commas. The algorithm
        // is that if the last argument is null, we need to force insert
        // a comma to ensure JavaScript recognizes it.
        //   [,].length === 1
        //   [1,].length === 1
        //   [1,,].length === 2
        //
        // Note that getLast returns null if the array is empty, but
        // we already check for an empty array just above so we are safe

        var needsForcedTrailingComma = canHaveTrailingComma && _lastElem === null;
        parts.push(group$1(concat$4(["[", indent$2(concat$4([softline$1, printArrayItems(path$$1, options, "elements", print)])), needsForcedTrailingComma ? "," : "", ifBreak$1(canHaveTrailingComma && !needsForcedTrailingComma && shouldPrintComma(options) ? "," : ""), comments.printDanglingComments(path$$1, options,
        /* sameIndent */
        true), softline$1, "]"])));
      }

      parts.push(printOptionalToken(path$$1), printTypeAnnotation(path$$1, options, print));
      return concat$4(parts);

    case "SequenceExpression":
      {
        var _parent5 = path$$1.getParentNode(0);

        if (_parent5.type === "ExpressionStatement" || _parent5.type === "ForStatement") {
          // For ExpressionStatements and for-loop heads, which are among
          // the few places a SequenceExpression appears unparenthesized, we want
          // to indent expressions after the first.
          var _parts2 = [];
          path$$1.each(function (p) {
            if (p.getName() === 0) {
              _parts2.push(print(p));
            } else {
              _parts2.push(",", indent$2(concat$4([line$3, print(p)])));
            }
          }, "expressions");
          return group$1(concat$4(_parts2));
        }

        return group$1(concat$4([join$2(concat$4([",", line$3]), path$$1.map(print, "expressions"))]));
      }

    case "ThisExpression":
      return "this";

    case "Super":
      return "super";

    case "NullLiteral":
      // Babel 6 Literal split
      return "null";

    case "RegExpLiteral":
      // Babel 6 Literal split
      return printRegex(n);

    case "NumericLiteral":
      // Babel 6 Literal split
      return printNumber$1(n.extra.raw);

    case "BigIntLiteral":
      return concat$4([printNumber$1(n.extra ? n.extra.rawValue : // TypeScript
      n.value), "n"]);

    case "BooleanLiteral": // Babel 6 Literal split

    case "StringLiteral": // Babel 6 Literal split

    case "Literal":
      {
        if (n.regex) {
          return printRegex(n.regex);
        }

        if (typeof n.value === "number") {
          return printNumber$1(n.raw);
        }

        if (typeof n.value !== "string") {
          return "" + n.value;
        } // TypeScript workaround for https://github.com/JamesHenry/typescript-estree/issues/2
        // See corresponding workaround in needs-parens.js


        var grandParent = path$$1.getParentNode(1);
        var isTypeScriptDirective = options.parser === "typescript" && typeof n.value === "string" && grandParent && (grandParent.type === "Program" || grandParent.type === "BlockStatement");
        return nodeStr(n, options, isTypeScriptDirective);
      }

    case "Directive":
      return path$$1.call(print, "value");
    // Babel 6

    case "DirectiveLiteral":
      return nodeStr(n, options);

    case "UnaryExpression":
      parts.push(n.operator);

      if (/[a-z]$/.test(n.operator)) {
        parts.push(" ");
      }

      parts.push(path$$1.call(print, "argument"));
      return concat$4(parts);

    case "UpdateExpression":
      parts.push(path$$1.call(print, "argument"), n.operator);

      if (n.prefix) {
        parts.reverse();
      }

      return concat$4(parts);

    case "ConditionalExpression":
      return printTernaryOperator(path$$1, options, print, {
        beforeParts: function beforeParts() {
          return [path$$1.call(print, "test")];
        },
        afterParts: function afterParts(breakClosingParen) {
          return [breakClosingParen ? softline$1 : ""];
        },
        shouldCheckJsx: true,
        conditionalNodeType: "ConditionalExpression",
        consequentNodePropertyName: "consequent",
        alternateNodePropertyName: "alternate",
        testNodePropertyName: "test",
        breakNested: true
      });

    case "VariableDeclaration":
      {
        var printed = path$$1.map(function (childPath) {
          return print(childPath);
        }, "declarations"); // We generally want to terminate all variable declarations with a
        // semicolon, except when they in the () part of for loops.

        var parentNode = path$$1.getParentNode();
        var isParentForLoop = parentNode.type === "ForStatement" || parentNode.type === "ForInStatement" || parentNode.type === "ForOfStatement" || parentNode.type === "ForAwaitStatement";
        var hasValue = n.declarations.some(function (decl) {
          return decl.init;
        });
        var firstVariable;

        if (printed.length === 1 && !n.declarations[0].comments) {
          firstVariable = printed[0];
        } else if (printed.length > 0) {
          // Indent first var to comply with eslint one-var rule
          firstVariable = indent$2(printed[0]);
        }

        parts = [isNodeStartingWithDeclare(n, options) ? "declare " : "", n.kind, firstVariable ? concat$4([" ", firstVariable]) : "", indent$2(concat$4(printed.slice(1).map(function (p) {
          return concat$4([",", hasValue && !isParentForLoop ? hardline$3 : line$3, p]);
        })))];

        if (!(isParentForLoop && parentNode.body !== n)) {
          parts.push(semi);
        }

        return group$1(concat$4(parts));
      }

    case "TSTypeAliasDeclaration":
      {
        if (n.declare) {
          parts.push("declare ");
        }

        var _printed = printAssignmentRight(n.id, n.typeAnnotation, n.typeAnnotation && path$$1.call(print, "typeAnnotation"), options);

        parts.push("type ", path$$1.call(print, "id"), path$$1.call(print, "typeParameters"), " =", _printed, semi);
        return group$1(concat$4(parts));
      }

    case "VariableDeclarator":
      return printAssignment(n.id, path$$1.call(print, "id"), " =", n.init, n.init && path$$1.call(print, "init"), options);

    case "WithStatement":
      return group$1(concat$4(["with (", path$$1.call(print, "object"), ")", adjustClause(n.body, path$$1.call(print, "body"))]));

    case "IfStatement":
      {
        var con = adjustClause(n.consequent, path$$1.call(print, "consequent"));
        var opening = group$1(concat$4(["if (", group$1(concat$4([indent$2(concat$4([softline$1, path$$1.call(print, "test")])), softline$1])), ")", con]));
        parts.push(opening);

        if (n.alternate) {
          var commentOnOwnLine = hasTrailingComment(n.consequent) && n.consequent.comments.some(function (comment) {
            return comment.trailing && !comments$3.isBlockComment(comment);
          }) || needsHardlineAfterDanglingComment(n);
          var elseOnSameLine = n.consequent.type === "BlockStatement" && !commentOnOwnLine;
          parts.push(elseOnSameLine ? " " : hardline$3);

          if (hasDanglingComments(n)) {
            parts.push(comments.printDanglingComments(path$$1, options, true), commentOnOwnLine ? hardline$3 : " ");
          }

          parts.push("else", group$1(adjustClause(n.alternate, path$$1.call(print, "alternate"), n.alternate.type === "IfStatement")));
        }

        return concat$4(parts);
      }

    case "ForStatement":
      {
        var _body = adjustClause(n.body, path$$1.call(print, "body")); // We want to keep dangling comments above the loop to stay consistent.
        // Any comment positioned between the for statement and the parentheses
        // is going to be printed before the statement.


        var _dangling = comments.printDanglingComments(path$$1, options,
        /* sameLine */
        true);

        var printedComments = _dangling ? concat$4([_dangling, softline$1]) : "";

        if (!n.init && !n.test && !n.update) {
          return concat$4([printedComments, group$1(concat$4(["for (;;)", _body]))]);
        }

        return concat$4([printedComments, group$1(concat$4(["for (", group$1(concat$4([indent$2(concat$4([softline$1, path$$1.call(print, "init"), ";", line$3, path$$1.call(print, "test"), ";", line$3, path$$1.call(print, "update")])), softline$1])), ")", _body]))]);
      }

    case "WhileStatement":
      return group$1(concat$4(["while (", group$1(concat$4([indent$2(concat$4([softline$1, path$$1.call(print, "test")])), softline$1])), ")", adjustClause(n.body, path$$1.call(print, "body"))]));

    case "ForInStatement":
      // Note: esprima can't actually parse "for each (".
      return group$1(concat$4([n.each ? "for each (" : "for (", path$$1.call(print, "left"), " in ", path$$1.call(print, "right"), ")", adjustClause(n.body, path$$1.call(print, "body"))]));

    case "ForOfStatement":
    case "ForAwaitStatement":
      {
        // Babel 7 removed ForAwaitStatement in favor of ForOfStatement
        // with `"await": true`:
        // https://github.com/estree/estree/pull/138
        var isAwait = n.type === "ForAwaitStatement" || n.await;
        return group$1(concat$4(["for", isAwait ? " await" : "", " (", path$$1.call(print, "left"), " of ", path$$1.call(print, "right"), ")", adjustClause(n.body, path$$1.call(print, "body"))]));
      }

    case "DoWhileStatement":
      {
        var clause = adjustClause(n.body, path$$1.call(print, "body"));
        var doBody = group$1(concat$4(["do", clause]));
        parts = [doBody];

        if (n.body.type === "BlockStatement") {
          parts.push(" ");
        } else {
          parts.push(hardline$3);
        }

        parts.push("while (");
        parts.push(group$1(concat$4([indent$2(concat$4([softline$1, path$$1.call(print, "test")])), softline$1])), ")", semi);
        return concat$4(parts);
      }

    case "DoExpression":
      return concat$4(["do ", path$$1.call(print, "body")]);

    case "BreakStatement":
      parts.push("break");

      if (n.label) {
        parts.push(" ", path$$1.call(print, "label"));
      }

      parts.push(semi);
      return concat$4(parts);

    case "ContinueStatement":
      parts.push("continue");

      if (n.label) {
        parts.push(" ", path$$1.call(print, "label"));
      }

      parts.push(semi);
      return concat$4(parts);

    case "LabeledStatement":
      if (n.body.type === "EmptyStatement") {
        return concat$4([path$$1.call(print, "label"), ":;"]);
      }

      return concat$4([path$$1.call(print, "label"), ": ", path$$1.call(print, "body")]);

    case "TryStatement":
      return concat$4(["try ", path$$1.call(print, "block"), n.handler ? concat$4([" ", path$$1.call(print, "handler")]) : "", n.finalizer ? concat$4([" finally ", path$$1.call(print, "finalizer")]) : ""]);

    case "CatchClause":
      if (n.param) {
        var hasComments = n.param.comments && n.param.comments.some(function (comment) {
          return !comments$3.isBlockComment(comment) || comment.leading && hasNewline$2(options.originalText, options.locEnd(comment)) || comment.trailing && hasNewline$2(options.originalText, options.locStart(comment), {
            backwards: true
          });
        });
        var param = path$$1.call(print, "param");
        return concat$4(["catch ", hasComments ? concat$4(["(", indent$2(concat$4([softline$1, param])), softline$1, ") "]) : concat$4(["(", param, ") "]), path$$1.call(print, "body")]);
      }

      return concat$4(["catch ", path$$1.call(print, "body")]);

    case "ThrowStatement":
      return concat$4(["throw ", path$$1.call(print, "argument"), semi]);
    // Note: ignoring n.lexical because it has no printing consequences.

    case "SwitchStatement":
      return concat$4([group$1(concat$4(["switch (", indent$2(concat$4([softline$1, path$$1.call(print, "discriminant")])), softline$1, ")"])), " {", n.cases.length > 0 ? indent$2(concat$4([hardline$3, join$2(hardline$3, path$$1.map(function (casePath) {
        var caseNode = casePath.getValue();
        return concat$4([casePath.call(print), n.cases.indexOf(caseNode) !== n.cases.length - 1 && isNextLineEmpty$2(options.originalText, caseNode, options) ? hardline$3 : ""]);
      }, "cases"))])) : "", hardline$3, "}"]);

    case "SwitchCase":
      {
        if (n.test) {
          parts.push("case ", path$$1.call(print, "test"), ":");
        } else {
          parts.push("default:");
        }

        var consequent = n.consequent.filter(function (node) {
          return node.type !== "EmptyStatement";
        });

        if (consequent.length > 0) {
          var cons = path$$1.call(function (consequentPath) {
            return printStatementSequence(consequentPath, options, print);
          }, "consequent");
          parts.push(consequent.length === 1 && consequent[0].type === "BlockStatement" ? concat$4([" ", cons]) : indent$2(concat$4([hardline$3, cons])));
        }

        return concat$4(parts);
      }
    // JSX extensions below.

    case "DebuggerStatement":
      return concat$4(["debugger", semi]);

    case "JSXAttribute":
      parts.push(path$$1.call(print, "name"));

      if (n.value) {
        var res;

        if (isStringLiteral(n.value)) {
          var raw = rawText(n.value); // Unescape all quotes so we get an accurate preferred quote

          var final = raw.replace(/&apos;/g, "'").replace(/&quot;/g, '"');
          var quote = getPreferredQuote$1(final, options.jsxSingleQuote ? "'" : '"');

          var _escape = quote === "'" ? "&apos;" : "&quot;";

          final = final.slice(1, -1).replace(new RegExp(quote, "g"), _escape);
          res = concat$4([quote, final, quote]);
        } else {
          res = path$$1.call(print, "value");
        }

        parts.push("=", res);
      }

      return concat$4(parts);

    case "JSXIdentifier":
      return "" + n.name;

    case "JSXNamespacedName":
      return join$2(":", [path$$1.call(print, "namespace"), path$$1.call(print, "name")]);

    case "JSXMemberExpression":
      return join$2(".", [path$$1.call(print, "object"), path$$1.call(print, "property")]);

    case "TSQualifiedName":
      return join$2(".", [path$$1.call(print, "left"), path$$1.call(print, "right")]);

    case "JSXSpreadAttribute":
    case "JSXSpreadChild":
      {
        return concat$4(["{", path$$1.call(function (p) {
          var printed = concat$4(["...", print(p)]);
          var n = p.getValue();

          if (!n.comments || !n.comments.length) {
            return printed;
          }

          return concat$4([indent$2(concat$4([softline$1, comments.printComments(p, function () {
            return printed;
          }, options)])), softline$1]);
        }, n.type === "JSXSpreadAttribute" ? "argument" : "expression"), "}"]);
      }

    case "JSXExpressionContainer":
      {
        var _parent6 = path$$1.getParentNode(0);

        var preventInline = _parent6.type === "JSXAttribute" && n.expression.comments && n.expression.comments.length > 0;

        var _shouldInline = !preventInline && (n.expression.type === "ArrayExpression" || n.expression.type === "ObjectExpression" || n.expression.type === "ArrowFunctionExpression" || n.expression.type === "CallExpression" || n.expression.type === "OptionalCallExpression" || n.expression.type === "FunctionExpression" || n.expression.type === "JSXEmptyExpression" || n.expression.type === "TemplateLiteral" || n.expression.type === "TaggedTemplateExpression" || n.expression.type === "DoExpression" || isJSXNode(_parent6) && (n.expression.type === "ConditionalExpression" || isBinaryish(n.expression)));

        if (_shouldInline) {
          return group$1(concat$4(["{", path$$1.call(print, "expression"), lineSuffixBoundary$1, "}"]));
        }

        return group$1(concat$4(["{", indent$2(concat$4([softline$1, path$$1.call(print, "expression")])), softline$1, lineSuffixBoundary$1, "}"]));
      }

    case "JSXFragment":
    case "JSXElement":
      {
        var elem = comments.printComments(path$$1, function () {
          return printJSXElement(path$$1, options, print);
        }, options);
        return maybeWrapJSXElementInParens(path$$1, elem);
      }

    case "JSXOpeningElement":
      {
        var _n = path$$1.getValue();

        var nameHasComments = _n.name && _n.name.comments && _n.name.comments.length > 0; // Don't break self-closing elements with no attributes and no comments

        if (_n.selfClosing && !_n.attributes.length && !nameHasComments) {
          return concat$4(["<", path$$1.call(print, "name"), path$$1.call(print, "typeParameters"), " />"]);
        } // don't break up opening elements with a single long text attribute


        if (_n.attributes && _n.attributes.length === 1 && _n.attributes[0].value && isStringLiteral(_n.attributes[0].value) && !_n.attributes[0].value.value.includes("\n") && // We should break for the following cases:
        // <div
        //   // comment
        //   attr="value"
        // >
        // <div
        //   attr="value"
        //   // comment
        // >
        !nameHasComments && (!_n.attributes[0].comments || !_n.attributes[0].comments.length)) {
          return group$1(concat$4(["<", path$$1.call(print, "name"), path$$1.call(print, "typeParameters"), " ", concat$4(path$$1.map(print, "attributes")), _n.selfClosing ? " />" : ">"]));
        }

        var lastAttrHasTrailingComments = _n.attributes.length && hasTrailingComment(getLast$3(_n.attributes));
        var bracketSameLine = // Simple tags (no attributes and no comment in tag name) should be
        // kept unbroken regardless of `jsxBracketSameLine`
        !_n.attributes.length && !nameHasComments || options.jsxBracketSameLine && ( // We should print the bracket in a new line for the following cases:
        // <div
        //   // comment
        // >
        // <div
        //   attr // comment
        // >
        !nameHasComments || _n.attributes.length) && !lastAttrHasTrailingComments; // We should print the opening element expanded if any prop value is a
        // string literal with newlines

        var _shouldBreak = _n.attributes && _n.attributes.some(function (attr) {
          return attr.value && isStringLiteral(attr.value) && attr.value.value.includes("\n");
        });

        return group$1(concat$4(["<", path$$1.call(print, "name"), path$$1.call(print, "typeParameters"), concat$4([indent$2(concat$4(path$$1.map(function (attr) {
          return concat$4([line$3, print(attr)]);
        }, "attributes"))), _n.selfClosing ? line$3 : bracketSameLine ? ">" : softline$1]), _n.selfClosing ? "/>" : bracketSameLine ? "" : ">"]), {
          shouldBreak: _shouldBreak
        });
      }

    case "JSXClosingElement":
      return concat$4(["</", path$$1.call(print, "name"), ">"]);

    case "JSXOpeningFragment":
    case "JSXClosingFragment":
      {
        var hasComment = n.comments && n.comments.length;
        var hasOwnLineComment = hasComment && !n.comments.every(comments$3.isBlockComment);
        var isOpeningFragment = n.type === "JSXOpeningFragment";
        return concat$4([isOpeningFragment ? "<" : "</", indent$2(concat$4([hasOwnLineComment ? hardline$3 : hasComment && !isOpeningFragment ? " " : "", comments.printDanglingComments(path$$1, options, true)])), hasOwnLineComment ? hardline$3 : "", ">"]);
      }

    case "JSXText":
      /* istanbul ignore next */
      throw new Error("JSXTest should be handled by JSXElement");

    case "JSXEmptyExpression":
      {
        var requiresHardline = n.comments && !n.comments.every(comments$3.isBlockComment);
        return concat$4([comments.printDanglingComments(path$$1, options,
        /* sameIndent */
        !requiresHardline), requiresHardline ? hardline$3 : ""]);
      }

    case "ClassBody":
      if (!n.comments && n.body.length === 0) {
        return "{}";
      }

      return concat$4(["{", n.body.length > 0 ? indent$2(concat$4([hardline$3, path$$1.call(function (bodyPath) {
        return printStatementSequence(bodyPath, options, print);
      }, "body")])) : comments.printDanglingComments(path$$1, options), hardline$3, "}"]);

    case "ClassProperty":
    case "TSAbstractClassProperty":
    case "ClassPrivateProperty":
      {
        if (n.decorators && n.decorators.length !== 0) {
          parts.push(printDecorators(path$$1, options, print));
        }

        if (n.accessibility) {
          parts.push(n.accessibility + " ");
        }

        if (n.static) {
          parts.push("static ");
        }

        if (n.type === "TSAbstractClassProperty") {
          parts.push("abstract ");
        }

        if (n.readonly) {
          parts.push("readonly ");
        }

        var variance = getFlowVariance(n);

        if (variance) {
          parts.push(variance);
        }

        if (n.computed) {
          parts.push("[", path$$1.call(print, "key"), "]");
        } else {
          parts.push(printPropertyKey(path$$1, options, print));
        }

        parts.push(printOptionalToken(path$$1));
        parts.push(printTypeAnnotation(path$$1, options, print));

        if (n.value) {
          parts.push(" =", printAssignmentRight(n.key, n.value, path$$1.call(print, "value"), options));
        }

        parts.push(semi);
        return group$1(concat$4(parts));
      }

    case "ClassDeclaration":
    case "ClassExpression":
      if (isNodeStartingWithDeclare(n, options)) {
        parts.push("declare ");
      }

      parts.push(concat$4(printClass(path$$1, options, print)));
      return concat$4(parts);

    case "TSInterfaceHeritage":
      parts.push(path$$1.call(print, "expression"));

      if (n.typeParameters) {
        parts.push(path$$1.call(print, "typeParameters"));
      }

      return concat$4(parts);

    case "TemplateElement":
      return join$2(literalline$1, n.value.raw.split(/\r?\n/g));

    case "TemplateLiteral":
      {
        var expressions = path$$1.map(print, "expressions");

        var _parentNode = path$$1.getParentNode();

        if (isJestEachTemplateLiteral(n, _parentNode)) {
          var _printed2 = printJestEachTemplateLiteral(n, expressions, options);

          if (_printed2) {
            return _printed2;
          }
        }

        var isSimple = isSimpleTemplateLiteral(n);

        if (isSimple) {
          expressions = expressions.map(function (doc$$2) {
            return printDocToString$2(doc$$2, Object.assign({}, options, {
              printWidth: Infinity
            })).formatted;
          });
        }

        parts.push("`");
        path$$1.each(function (childPath) {
          var i = childPath.getName();
          parts.push(print(childPath));

          if (i < expressions.length) {
            // For a template literal of the following form:
            //   `someQuery {
            //     ${call({
            //       a,
            //       b,
            //     })}
            //   }`
            // the expression is on its own line (there is a \n in the previous
            // quasi literal), therefore we want to indent the JavaScript
            // expression inside at the beginning of ${ instead of the beginning
            // of the `.
            var tabWidth = options.tabWidth;
            var quasi = childPath.getValue();
            var indentSize = getIndentSize$1(quasi.value.raw, tabWidth);
            var _printed3 = expressions[i];

            if (!isSimple) {
              // Breaks at the template element boundaries (${ and }) are preferred to breaking
              // in the middle of a MemberExpression
              if (n.expressions[i].comments && n.expressions[i].comments.length || n.expressions[i].type === "MemberExpression" || n.expressions[i].type === "OptionalMemberExpression" || n.expressions[i].type === "ConditionalExpression") {
                _printed3 = concat$4([indent$2(concat$4([softline$1, _printed3])), softline$1]);
              }
            }

            var aligned = indentSize === 0 && quasi.value.raw.endsWith("\n") ? align$1(-Infinity, _printed3) : addAlignmentToDoc$2(_printed3, indentSize, tabWidth);
            parts.push(group$1(concat$4(["${", aligned, lineSuffixBoundary$1, "}"])));
          }
        }, "quasis");
        parts.push("`");
        return concat$4(parts);
      }
    // These types are unprintable because they serve as abstract
    // supertypes for other (printable) types.

    case "TaggedTemplateExpression":
      return concat$4([path$$1.call(print, "tag"), path$$1.call(print, "typeParameters"), path$$1.call(print, "quasi")]);

    case "Node":
    case "Printable":
    case "SourceLocation":
    case "Position":
    case "Statement":
    case "Function":
    case "Pattern":
    case "Expression":
    case "Declaration":
    case "Specifier":
    case "NamedSpecifier":
    case "Comment":
    case "MemberTypeAnnotation": // Flow

    case "Type":
      /* istanbul ignore next */
      throw new Error("unprintable type: " + JSON.stringify(n.type));
    // Type Annotations for Facebook Flow, typically stripped out or
    // transformed away before printing.

    case "TypeAnnotation":
    case "TSTypeAnnotation":
      if (n.typeAnnotation) {
        return path$$1.call(print, "typeAnnotation");
      }
      /* istanbul ignore next */


      return "";

    case "TSTupleType":
    case "TupleTypeAnnotation":
      {
        var typesField = n.type === "TSTupleType" ? "elementTypes" : "types";
        return group$1(concat$4(["[", indent$2(concat$4([softline$1, printArrayItems(path$$1, options, typesField, print)])), ifBreak$1(shouldPrintComma(options, "all") ? "," : ""), comments.printDanglingComments(path$$1, options,
        /* sameIndent */
        true), softline$1, "]"]));
      }

    case "ExistsTypeAnnotation":
      return "*";

    case "EmptyTypeAnnotation":
      return "empty";

    case "AnyTypeAnnotation":
      return "any";

    case "MixedTypeAnnotation":
      return "mixed";

    case "ArrayTypeAnnotation":
      return concat$4([path$$1.call(print, "elementType"), "[]"]);

    case "BooleanTypeAnnotation":
      return "boolean";

    case "BooleanLiteralTypeAnnotation":
      return "" + n.value;

    case "DeclareClass":
      return printFlowDeclaration(path$$1, printClass(path$$1, options, print));

    case "TSDeclareFunction":
      // For TypeScript the TSDeclareFunction node shares the AST
      // structure with FunctionDeclaration
      return concat$4([n.declare ? "declare " : "", printFunctionDeclaration(path$$1, print, options), semi]);

    case "DeclareFunction":
      return printFlowDeclaration(path$$1, ["function ", path$$1.call(print, "id"), n.predicate ? " " : "", path$$1.call(print, "predicate"), semi]);

    case "DeclareModule":
      return printFlowDeclaration(path$$1, ["module ", path$$1.call(print, "id"), " ", path$$1.call(print, "body")]);

    case "DeclareModuleExports":
      return printFlowDeclaration(path$$1, ["module.exports", ": ", path$$1.call(print, "typeAnnotation"), semi]);

    case "DeclareVariable":
      return printFlowDeclaration(path$$1, ["var ", path$$1.call(print, "id"), semi]);

    case "DeclareExportAllDeclaration":
      return concat$4(["declare export * from ", path$$1.call(print, "source")]);

    case "DeclareExportDeclaration":
      return concat$4(["declare ", printExportDeclaration(path$$1, options, print)]);

    case "DeclareOpaqueType":
    case "OpaqueType":
      {
        parts.push("opaque type ", path$$1.call(print, "id"), path$$1.call(print, "typeParameters"));

        if (n.supertype) {
          parts.push(": ", path$$1.call(print, "supertype"));
        }

        if (n.impltype) {
          parts.push(" = ", path$$1.call(print, "impltype"));
        }

        parts.push(semi);

        if (n.type === "DeclareOpaqueType") {
          return printFlowDeclaration(path$$1, parts);
        }

        return concat$4(parts);
      }

    case "FunctionTypeAnnotation":
    case "TSFunctionType":
      {
        // FunctionTypeAnnotation is ambiguous:
        // declare function foo(a: B): void; OR
        // var A: (a: B) => void;
        var _parent7 = path$$1.getParentNode(0);

        var _parentParent2 = path$$1.getParentNode(1);

        var _parentParentParent = path$$1.getParentNode(2);

        var isArrowFunctionTypeAnnotation = n.type === "TSFunctionType" || !((_parent7.type === "ObjectTypeProperty" || _parent7.type === "ObjectTypeInternalSlot") && !getFlowVariance(_parent7) && !_parent7.optional && options.locStart(_parent7) === options.locStart(n) || _parent7.type === "ObjectTypeCallProperty" || _parentParentParent && _parentParentParent.type === "DeclareFunction");
        var needsColon = isArrowFunctionTypeAnnotation && (_parent7.type === "TypeAnnotation" || _parent7.type === "TSTypeAnnotation"); // Sadly we can't put it inside of FastPath::needsColon because we are
        // printing ":" as part of the expression and it would put parenthesis
        // around :(

        var needsParens = needsColon && isArrowFunctionTypeAnnotation && (_parent7.type === "TypeAnnotation" || _parent7.type === "TSTypeAnnotation") && _parentParent2.type === "ArrowFunctionExpression";

        if (isObjectTypePropertyAFunction(_parent7, options)) {
          isArrowFunctionTypeAnnotation = true;
          needsColon = true;
        }

        if (needsParens) {
          parts.push("(");
        }

        parts.push(printFunctionParams(path$$1, print, options,
        /* expandArg */
        false,
        /* printTypeParams */
        true)); // The returnType is not wrapped in a TypeAnnotation, so the colon
        // needs to be added separately.

        if (n.returnType || n.predicate || n.typeAnnotation) {
          parts.push(isArrowFunctionTypeAnnotation ? " => " : ": ", path$$1.call(print, "returnType"), path$$1.call(print, "predicate"), path$$1.call(print, "typeAnnotation"));
        }

        if (needsParens) {
          parts.push(")");
        }

        return group$1(concat$4(parts));
      }

    case "TSRestType":
      return concat$4(["...", path$$1.call(print, "typeAnnotation")]);

    case "TSOptionalType":
      return concat$4([path$$1.call(print, "typeAnnotation"), "?"]);

    case "FunctionTypeParam":
      return concat$4([path$$1.call(print, "name"), printOptionalToken(path$$1), n.name ? ": " : "", path$$1.call(print, "typeAnnotation")]);

    case "GenericTypeAnnotation":
      return concat$4([path$$1.call(print, "id"), path$$1.call(print, "typeParameters")]);

    case "DeclareInterface":
    case "InterfaceDeclaration":
    case "InterfaceTypeAnnotation":
      {
        if (n.type === "DeclareInterface" || isNodeStartingWithDeclare(n, options)) {
          parts.push("declare ");
        }

        parts.push("interface");

        if (n.type === "DeclareInterface" || n.type === "InterfaceDeclaration") {
          parts.push(" ", path$$1.call(print, "id"), path$$1.call(print, "typeParameters"));
        }

        if (n["extends"].length > 0) {
          parts.push(group$1(indent$2(concat$4([line$3, "extends ", (n.extends.length === 1 ? identity$1 : indent$2)(join$2(concat$4([",", line$3]), path$$1.map(print, "extends")))]))));
        }

        parts.push(" ", path$$1.call(print, "body"));
        return group$1(concat$4(parts));
      }

    case "ClassImplements":
    case "InterfaceExtends":
      return concat$4([path$$1.call(print, "id"), path$$1.call(print, "typeParameters")]);

    case "TSClassImplements":
      return concat$4([path$$1.call(print, "expression"), path$$1.call(print, "typeParameters")]);

    case "TSIntersectionType":
    case "IntersectionTypeAnnotation":
      {
        var types = path$$1.map(print, "types");
        var result = [];
        var wasIndented = false;

        for (var _i = 0; _i < types.length; ++_i) {
          if (_i === 0) {
            result.push(types[_i]);
          } else if (isObjectType(n.types[_i - 1]) && isObjectType(n.types[_i])) {
            // If both are objects, don't indent
            result.push(concat$4([" & ", wasIndented ? indent$2(types[_i]) : types[_i]]));
          } else if (!isObjectType(n.types[_i - 1]) && !isObjectType(n.types[_i])) {
            // If no object is involved, go to the next line if it breaks
            result.push(indent$2(concat$4([" &", line$3, types[_i]])));
          } else {
            // If you go from object to non-object or vis-versa, then inline it
            if (_i > 1) {
              wasIndented = true;
            }

            result.push(" & ", _i > 1 ? indent$2(types[_i]) : types[_i]);
          }
        }

        return group$1(concat$4(result));
      }

    case "TSUnionType":
    case "UnionTypeAnnotation":
      {
        // single-line variation
        // A | B | C
        // multi-line variation
        // | A
        // | B
        // | C
        var _parent8 = path$$1.getParentNode(); // If there's a leading comment, the parent is doing the indentation


        var shouldIndent = _parent8.type !== "TypeParameterInstantiation" && _parent8.type !== "TSTypeParameterInstantiation" && _parent8.type !== "GenericTypeAnnotation" && _parent8.type !== "TSTypeReference" && _parent8.type !== "TSTypeAssertion" && !(_parent8.type === "FunctionTypeParam" && !_parent8.name) && !((_parent8.type === "TypeAlias" || _parent8.type === "VariableDeclarator" || _parent8.type === "TSTypeAliasDeclaration") && hasLeadingOwnLineComment(options.originalText, n, options)); // {
        //   a: string
        // } | null | void
        // should be inlined and not be printed in the multi-line variant

        var shouldHug = shouldHugType(n); // We want to align the children but without its comment, so it looks like
        // | child1
        // // comment
        // | child2

        var _printed4 = path$$1.map(function (typePath) {
          var printedType = typePath.call(print);

          if (!shouldHug) {
            printedType = align$1(2, printedType);
          }

          return comments.printComments(typePath, function () {
            return printedType;
          }, options);
        }, "types");

        if (shouldHug) {
          return join$2(" | ", _printed4);
        }

        var shouldAddStartLine = shouldIndent && !hasLeadingOwnLineComment(options.originalText, n, options);
        var code = concat$4([ifBreak$1(concat$4([shouldAddStartLine ? line$3 : "", "| "])), join$2(concat$4([line$3, "| "]), _printed4)]);
        var hasParens;

        if (n.type === "TSUnionType") {
          var greatGrandParent = path$$1.getParentNode(2);
          var greatGreatGrandParent = path$$1.getParentNode(3);
          hasParens = greatGrandParent && greatGrandParent.type === "TSParenthesizedType" && greatGreatGrandParent && (greatGreatGrandParent.type === "TSUnionType" || greatGreatGrandParent.type === "TSIntersectionType");
        } else {
          hasParens = needsParens_1(path$$1, options);
        }

        if (hasParens) {
          return group$1(concat$4([indent$2(code), softline$1]));
        }

        return group$1(shouldIndent ? indent$2(code) : code);
      }

    case "NullableTypeAnnotation":
      return concat$4(["?", path$$1.call(print, "typeAnnotation")]);

    case "TSNullKeyword":
    case "NullLiteralTypeAnnotation":
      return "null";

    case "ThisTypeAnnotation":
      return "this";

    case "NumberTypeAnnotation":
      return "number";

    case "ObjectTypeCallProperty":
      if (n.static) {
        parts.push("static ");
      }

      parts.push(path$$1.call(print, "value"));
      return concat$4(parts);

    case "ObjectTypeIndexer":
      {
        var _variance = getFlowVariance(n);

        return concat$4([_variance || "", "[", path$$1.call(print, "id"), n.id ? ": " : "", path$$1.call(print, "key"), "]: ", path$$1.call(print, "value")]);
      }

    case "ObjectTypeProperty":
      {
        var _variance2 = getFlowVariance(n);

        var modifier = "";

        if (n.proto) {
          modifier = "proto ";
        } else if (n.static) {
          modifier = "static ";
        }

        return concat$4([modifier, isGetterOrSetter(n) ? n.kind + " " : "", _variance2 || "", printPropertyKey(path$$1, options, print), printOptionalToken(path$$1), isFunctionNotation(n, options) ? "" : ": ", path$$1.call(print, "value")]);
      }

    case "QualifiedTypeIdentifier":
      return concat$4([path$$1.call(print, "qualification"), ".", path$$1.call(print, "id")]);

    case "StringLiteralTypeAnnotation":
      return nodeStr(n, options);

    case "NumberLiteralTypeAnnotation":
      assert.strictEqual(typeof n.value, "number");

      if (n.extra != null) {
        return printNumber$1(n.extra.raw);
      }

      return printNumber$1(n.raw);

    case "StringTypeAnnotation":
      return "string";

    case "DeclareTypeAlias":
    case "TypeAlias":
      {
        if (n.type === "DeclareTypeAlias" || isNodeStartingWithDeclare(n, options)) {
          parts.push("declare ");
        }

        var _printed5 = printAssignmentRight(n.id, n.right, path$$1.call(print, "right"), options);

        parts.push("type ", path$$1.call(print, "id"), path$$1.call(print, "typeParameters"), " =", _printed5, semi);
        return group$1(concat$4(parts));
      }

    case "TypeCastExpression":
      {
        var value = path$$1.getValue(); // Flow supports a comment syntax for specifying type annotations: https://flow.org/en/docs/types/comments/.
        // Unfortunately, its parser doesn't differentiate between comment annotations and regular
        // annotations when producing an AST. So to preserve parentheses around type casts that use
        // the comment syntax, we need to hackily read the source itself to see if the code contains
        // a type annotation comment.
        //
        // Note that we're able to use the normal whitespace regex here because the Flow parser has
        // already deemed this AST node to be a type cast. Only the Babel parser needs the
        // non-line-break whitespace regex, which is why hasFlowShorthandAnnotationComment() is
        // implemented differently.

        var commentSyntax = value && value.typeAnnotation && value.typeAnnotation.range && options.originalText.substring(value.typeAnnotation.range[0]).match(/^\/\*\s*:/);
        return concat$4(["(", path$$1.call(print, "expression"), commentSyntax ? " /*" : "", ": ", path$$1.call(print, "typeAnnotation"), commentSyntax ? " */" : "", ")"]);
      }

    case "TypeParameterDeclaration":
    case "TypeParameterInstantiation":
      {
        var _value = path$$1.getValue();

        var commentStart = _value.range ? options.originalText.substring(0, _value.range[0]).lastIndexOf("/*") : -1; // As noted in the TypeCastExpression comments above, we're able to use a normal whitespace regex here
        // because we know for sure that this is a type definition.

        var _commentSyntax = commentStart >= 0 && options.originalText.substring(commentStart).match(/^\/\*\s*::/);

        if (_commentSyntax) {
          return concat$4(["/*:: ", printTypeParameters(path$$1, options, print, "params"), " */"]);
        }

        return printTypeParameters(path$$1, options, print, "params");
      }

    case "TSTypeParameterDeclaration":
    case "TSTypeParameterInstantiation":
      return printTypeParameters(path$$1, options, print, "params");

    case "TSTypeParameter":
    case "TypeParameter":
      {
        var _parent9 = path$$1.getParentNode();

        if (_parent9.type === "TSMappedType") {
          parts.push("[", path$$1.call(print, "name"));

          if (n.constraint) {
            parts.push(" in ", path$$1.call(print, "constraint"));
          }

          parts.push("]");
          return concat$4(parts);
        }

        var _variance3 = getFlowVariance(n);

        if (_variance3) {
          parts.push(_variance3);
        }

        parts.push(path$$1.call(print, "name"));

        if (n.bound) {
          parts.push(": ");
          parts.push(path$$1.call(print, "bound"));
        }

        if (n.constraint) {
          parts.push(" extends ", path$$1.call(print, "constraint"));
        }

        if (n["default"]) {
          parts.push(" = ", path$$1.call(print, "default"));
        } // Keep comma if the file extension is .tsx and
        // has one type parameter that isn't extend with any types.
        // Because, otherwise formatted result will be invalid as tsx.


        var _grandParent = path$$1.getNode(2);

        if (_parent9.params && _parent9.params.length === 1 && options.filepath && /\.tsx$/i.test(options.filepath) && !n.constraint && _grandParent.type === "ArrowFunctionExpression") {
          parts.push(",");
        }

        return concat$4(parts);
      }

    case "TypeofTypeAnnotation":
      return concat$4(["typeof ", path$$1.call(print, "argument")]);

    case "VoidTypeAnnotation":
      return "void";

    case "InferredPredicate":
      return "%checks";
    // Unhandled types below. If encountered, nodes of these types should
    // be either left alone or desugared into AST types that are fully
    // supported by the pretty-printer.

    case "DeclaredPredicate":
      return concat$4(["%checks(", path$$1.call(print, "value"), ")"]);

    case "TSAbstractKeyword":
      return "abstract";

    case "TSAnyKeyword":
      return "any";

    case "TSAsyncKeyword":
      return "async";

    case "TSBooleanKeyword":
      return "boolean";

    case "TSBigIntKeyword":
      return "bigint";

    case "TSConstKeyword":
      return "const";

    case "TSDeclareKeyword":
      return "declare";

    case "TSExportKeyword":
      return "export";

    case "TSNeverKeyword":
      return "never";

    case "TSNumberKeyword":
      return "number";

    case "TSObjectKeyword":
      return "object";

    case "TSProtectedKeyword":
      return "protected";

    case "TSPrivateKeyword":
      return "private";

    case "TSPublicKeyword":
      return "public";

    case "TSReadonlyKeyword":
      return "readonly";

    case "TSSymbolKeyword":
      return "symbol";

    case "TSStaticKeyword":
      return "static";

    case "TSStringKeyword":
      return "string";

    case "TSUndefinedKeyword":
      return "undefined";

    case "TSUnknownKeyword":
      return "unknown";

    case "TSVoidKeyword":
      return "void";

    case "TSAsExpression":
      return concat$4([path$$1.call(print, "expression"), " as ", path$$1.call(print, "typeAnnotation")]);

    case "TSArrayType":
      return concat$4([path$$1.call(print, "elementType"), "[]"]);

    case "TSPropertySignature":
      {
        if (n.export) {
          parts.push("export ");
        }

        if (n.accessibility) {
          parts.push(n.accessibility + " ");
        }

        if (n.static) {
          parts.push("static ");
        }

        if (n.readonly) {
          parts.push("readonly ");
        }

        if (n.computed) {
          parts.push("[");
        }

        parts.push(printPropertyKey(path$$1, options, print));

        if (n.computed) {
          parts.push("]");
        }

        parts.push(printOptionalToken(path$$1));

        if (n.typeAnnotation) {
          parts.push(": ");
          parts.push(path$$1.call(print, "typeAnnotation"));
        } // This isn't valid semantically, but it's in the AST so we can print it.


        if (n.initializer) {
          parts.push(" = ", path$$1.call(print, "initializer"));
        }

        return concat$4(parts);
      }

    case "TSParameterProperty":
      if (n.accessibility) {
        parts.push(n.accessibility + " ");
      }

      if (n.export) {
        parts.push("export ");
      }

      if (n.static) {
        parts.push("static ");
      }

      if (n.readonly) {
        parts.push("readonly ");
      }

      parts.push(path$$1.call(print, "parameter"));
      return concat$4(parts);

    case "TSTypeReference":
      return concat$4([path$$1.call(print, "typeName"), printTypeParameters(path$$1, options, print, "typeParameters")]);

    case "TSTypeQuery":
      return concat$4(["typeof ", path$$1.call(print, "exprName")]);

    case "TSParenthesizedType":
      {
        return path$$1.call(print, "typeAnnotation");
      }

    case "TSIndexSignature":
      {
        var _parent10 = path$$1.getParentNode();

        return concat$4([n.export ? "export " : "", n.accessibility ? concat$4([n.accessibility, " "]) : "", n.static ? "static " : "", n.readonly ? "readonly " : "", "[", n.parameters ? concat$4(path$$1.map(print, "parameters")) : "", "]: ", path$$1.call(print, "typeAnnotation"), _parent10.type === "ClassBody" ? semi : ""]);
      }

    case "TSTypePredicate":
      return concat$4([path$$1.call(print, "parameterName"), " is ", path$$1.call(print, "typeAnnotation")]);

    case "TSNonNullExpression":
      return concat$4([path$$1.call(print, "expression"), "!"]);

    case "TSThisType":
      return "this";

    case "TSImportType":
      return concat$4([!n.isTypeOf ? "" : "typeof ", "import(", path$$1.call(print, "parameter"), ")", !n.qualifier ? "" : concat$4([".", path$$1.call(print, "qualifier")]), printTypeParameters(path$$1, options, print, "typeParameters")]);

    case "TSLiteralType":
      return path$$1.call(print, "literal");

    case "TSIndexedAccessType":
      return concat$4([path$$1.call(print, "objectType"), "[", path$$1.call(print, "indexType"), "]"]);

    case "TSConstructSignatureDeclaration":
    case "TSCallSignatureDeclaration":
    case "TSConstructorType":
      {
        if (n.type !== "TSCallSignatureDeclaration") {
          parts.push("new ");
        }

        parts.push(group$1(printFunctionParams(path$$1, print, options,
        /* expandArg */
        false,
        /* printTypeParams */
        true)));

        if (n.returnType) {
          var isType = n.type === "TSConstructorType";
          parts.push(isType ? " => " : ": ", path$$1.call(print, "returnType"));
        }

        return concat$4(parts);
      }

    case "TSTypeOperator":
      return concat$4([n.operator, " ", path$$1.call(print, "typeAnnotation")]);

    case "TSMappedType":
      {
        var _shouldBreak2 = hasNewlineInRange$1(options.originalText, options.locStart(n), options.locEnd(n));

        return group$1(concat$4(["{", indent$2(concat$4([options.bracketSpacing ? line$3 : softline$1, n.readonly ? concat$4([getTypeScriptMappedTypeModifier(n.readonly, "readonly"), " "]) : "", printTypeScriptModifiers(path$$1, options, print), path$$1.call(print, "typeParameter"), n.optional ? getTypeScriptMappedTypeModifier(n.optional, "?") : "", ": ", path$$1.call(print, "typeAnnotation"), _shouldBreak2 && options.semi ? ";" : ""])), comments.printDanglingComments(path$$1, options,
        /* sameIndent */
        true), options.bracketSpacing ? line$3 : softline$1, "}"]), {
          shouldBreak: _shouldBreak2
        });
      }

    case "TSMethodSignature":
      parts.push(n.accessibility ? concat$4([n.accessibility, " "]) : "", n.export ? "export " : "", n.static ? "static " : "", n.readonly ? "readonly " : "", n.computed ? "[" : "", path$$1.call(print, "key"), n.computed ? "]" : "", printOptionalToken(path$$1), printFunctionParams(path$$1, print, options,
      /* expandArg */
      false,
      /* printTypeParams */
      true));

      if (n.returnType) {
        parts.push(": ", path$$1.call(print, "returnType"));
      }

      return group$1(concat$4(parts));

    case "TSNamespaceExportDeclaration":
      parts.push("export as namespace ", path$$1.call(print, "id"));

      if (options.semi) {
        parts.push(";");
      }

      return group$1(concat$4(parts));

    case "TSEnumDeclaration":
      if (isNodeStartingWithDeclare(n, options)) {
        parts.push("declare ");
      }

      if (n.modifiers) {
        parts.push(printTypeScriptModifiers(path$$1, options, print));
      }

      if (n.const) {
        parts.push("const ");
      }

      parts.push("enum ", path$$1.call(print, "id"), " ");

      if (n.members.length === 0) {
        parts.push(group$1(concat$4(["{", comments.printDanglingComments(path$$1, options), softline$1, "}"])));
      } else {
        parts.push(group$1(concat$4(["{", indent$2(concat$4([hardline$3, printArrayItems(path$$1, options, "members", print), shouldPrintComma(options, "es5") ? "," : ""])), comments.printDanglingComments(path$$1, options,
        /* sameIndent */
        true), hardline$3, "}"])));
      }

      return concat$4(parts);

    case "TSEnumMember":
      parts.push(path$$1.call(print, "id"));

      if (n.initializer) {
        parts.push(" = ", path$$1.call(print, "initializer"));
      }

      return concat$4(parts);

    case "TSImportEqualsDeclaration":
      if (n.isExport) {
        parts.push("export ");
      }

      parts.push("import ", path$$1.call(print, "id"), " = ", path$$1.call(print, "moduleReference"));

      if (options.semi) {
        parts.push(";");
      }

      return group$1(concat$4(parts));

    case "TSExternalModuleReference":
      return concat$4(["require(", path$$1.call(print, "expression"), ")"]);

    case "TSModuleDeclaration":
      {
        var _parent11 = path$$1.getParentNode();

        var isExternalModule = isLiteral(n.id);
        var parentIsDeclaration = _parent11.type === "TSModuleDeclaration";
        var bodyIsDeclaration = n.body && n.body.type === "TSModuleDeclaration";

        if (parentIsDeclaration) {
          parts.push(".");
        } else {
          if (n.declare === true) {
            parts.push("declare ");
          }

          parts.push(printTypeScriptModifiers(path$$1, options, print));
          var textBetweenNodeAndItsId = options.originalText.slice(options.locStart(n), options.locStart(n.id)); // Global declaration looks like this:
          // (declare)? global { ... }

          var isGlobalDeclaration = n.id.type === "Identifier" && n.id.name === "global" && !/namespace|module/.test(textBetweenNodeAndItsId);

          if (!isGlobalDeclaration) {
            parts.push(isExternalModule || /(^|\s)module(\s|$)/.test(textBetweenNodeAndItsId) ? "module " : "namespace ");
          }
        }

        parts.push(path$$1.call(print, "id"));

        if (bodyIsDeclaration) {
          parts.push(path$$1.call(print, "body"));
        } else if (n.body) {
          parts.push(" ", group$1(path$$1.call(print, "body")));
        } else {
          parts.push(semi);
        }

        return concat$4(parts);
      }

    case "PrivateName":
      return concat$4(["#", path$$1.call(print, "id")]);

    case "TSConditionalType":
      return printTernaryOperator(path$$1, options, print, {
        beforeParts: function beforeParts() {
          return [path$$1.call(print, "checkType"), " ", "extends", " ", path$$1.call(print, "extendsType")];
        },
        afterParts: function afterParts() {
          return [];
        },
        shouldCheckJsx: false,
        conditionalNodeType: "TSConditionalType",
        consequentNodePropertyName: "trueType",
        alternateNodePropertyName: "falseType",
        testNodePropertyName: "checkType",
        breakNested: true
      });

    case "TSInferType":
      return concat$4(["infer", " ", path$$1.call(print, "typeParameter")]);

    case "InterpreterDirective":
      parts.push("#!", n.value, hardline$3);

      if (isNextLineEmpty$2(options.originalText, n, options)) {
        parts.push(hardline$3);
      }

      return concat$4(parts);

    case "NGRoot":
      return concat$4([].concat(path$$1.call(print, "node"), !n.node.comments || n.node.comments.length === 0 ? [] : concat$4([" //", n.node.comments[0].value.trimRight()])));

    case "NGChainedExpression":
      return group$1(join$2(concat$4([";", line$3]), path$$1.map(function (childPath) {
        return hasNgSideEffect(childPath) ? print(childPath) : concat$4(["(", print(childPath), ")"]);
      }, "expressions")));

    case "NGEmptyExpression":
      return "";

    case "NGQuotedExpression":
      return concat$4([n.prefix, ":", n.value]);

    case "NGMicrosyntax":
      return concat$4(path$$1.map(function (childPath, index) {
        return concat$4([index === 0 ? "" : isNgForOf(childPath.getValue(), index, n) ? " " : concat$4([";", line$3]), print(childPath)]);
      }, "body"));

    case "NGMicrosyntaxKey":
      return /^[a-z_$][a-z0-9_$]*(-[a-z_$][a-z0-9_$])*$/i.test(n.name) ? n.name : JSON.stringify(n.name);

    case "NGMicrosyntaxExpression":
      return concat$4([path$$1.call(print, "expression"), n.alias === null ? "" : concat$4([" as ", path$$1.call(print, "alias")])]);

    case "NGMicrosyntaxKeyedExpression":
      {
        var index = path$$1.getName();

        var _parentNode2 = path$$1.getParentNode();

        var shouldNotPrintColon = isNgForOf(n, index, _parentNode2) || (index === 1 && (n.key.name === "then" || n.key.name === "else") || index === 2 && n.key.name === "else" && _parentNode2.body[index - 1].type === "NGMicrosyntaxKeyedExpression" && _parentNode2.body[index - 1].key.name === "then") && _parentNode2.body[0].type === "NGMicrosyntaxExpression";
        return concat$4([path$$1.call(print, "key"), shouldNotPrintColon ? " " : ": ", path$$1.call(print, "expression")]);
      }

    case "NGMicrosyntaxLet":
      return concat$4(["let ", path$$1.call(print, "key"), n.value === null ? "" : concat$4([" = ", path$$1.call(print, "value")])]);

    case "NGMicrosyntaxAs":
      return concat$4([path$$1.call(print, "key"), " as ", path$$1.call(print, "alias")]);

    default:
      /* istanbul ignore next */
      throw new Error("unknown type: " + JSON.stringify(n.type));
  }
}

function isNgForOf(node, index, parentNode) {
  return node.type === "NGMicrosyntaxKeyedExpression" && node.key.name === "of" && index === 1 && parentNode.body[0].type === "NGMicrosyntaxLet" && parentNode.body[0].value === null;
}
/** identify if an angular expression seems to have side effects */


function hasNgSideEffect(path$$1) {
  return hasNode(path$$1.getValue(), function (node) {
    switch (node.type) {
      case undefined:
        return false;

      case "CallExpression":
      case "OptionalCallExpression":
      case "AssignmentExpression":
        return true;
    }
  });
}

function printStatementSequence(path$$1, options, print) {
  var printed = [];
  var bodyNode = path$$1.getNode();
  var isClass = bodyNode.type === "ClassBody";
  path$$1.map(function (stmtPath, i) {
    var stmt = stmtPath.getValue(); // Just in case the AST has been modified to contain falsy
    // "statements," it's safer simply to skip them.

    /* istanbul ignore if */

    if (!stmt) {
      return;
    } // Skip printing EmptyStatement nodes to avoid leaving stray
    // semicolons lying around.


    if (stmt.type === "EmptyStatement") {
      return;
    }

    var stmtPrinted = print(stmtPath);
    var text = options.originalText;
    var parts = []; // in no-semi mode, prepend statement with semicolon if it might break ASI
    // don't prepend the only JSX element in a program with semicolon

    if (!options.semi && !isClass && !isTheOnlyJSXElementInMarkdown(options, stmtPath) && stmtNeedsASIProtection(stmtPath, options)) {
      if (stmt.comments && stmt.comments.some(function (comment) {
        return comment.leading;
      })) {
        parts.push(print(stmtPath, {
          needsSemi: true
        }));
      } else {
        parts.push(";", stmtPrinted);
      }
    } else {
      parts.push(stmtPrinted);
    }

    if (!options.semi && isClass) {
      if (classPropMayCauseASIProblems(stmtPath)) {
        parts.push(";");
      } else if (stmt.type === "ClassProperty") {
        var nextChild = bodyNode.body[i + 1];

        if (classChildNeedsASIProtection(nextChild)) {
          parts.push(";");
        }
      }
    }

    if (isNextLineEmpty$2(text, stmt, options) && !isLastStatement(stmtPath)) {
      parts.push(hardline$3);
    }

    printed.push(concat$4(parts));
  });
  return join$2(hardline$3, printed);
}

function printPropertyKey(path$$1, options, print) {
  var node = path$$1.getNode();
  var parent = path$$1.getParentNode();
  var key = node.key;

  if (options.quoteProps === "consistent" && !needsQuoteProps.has(parent)) {
    var objectHasStringProp = (parent.properties || parent.body || parent.members).some(function (prop) {
      return !prop.computed && prop.key && isStringLiteral(prop.key) && !isStringPropSafeToCoerceToIdentifier(prop, options);
    });
    needsQuoteProps.set(parent, objectHasStringProp);
  }

  if (key.type === "Identifier" && !node.computed && (options.parser === "json" || options.quoteProps === "consistent" && needsQuoteProps.get(parent))) {
    // a -> "a"
    var prop = printString$1(JSON.stringify(key.name), options);
    return path$$1.call(function (keyPath) {
      return comments.printComments(keyPath, function () {
        return prop;
      }, options);
    }, "key");
  }

  if (!node.computed && isStringPropSafeToCoerceToIdentifier(node, options) && (options.quoteProps === "as-needed" || options.quoteProps === "consistent" && !needsQuoteProps.get(parent))) {
    // 'a' -> a
    return path$$1.call(function (keyPath) {
      return comments.printComments(keyPath, function () {
        return key.value;
      }, options);
    }, "key");
  }

  return path$$1.call(print, "key");
}

function printMethod(path$$1, options, print) {
  var node = path$$1.getNode();
  var semi = options.semi ? ";" : "";
  var kind = node.kind;
  var parts = [];

  if (node.type === "ObjectMethod" || node.type === "ClassMethod" || node.type === "ClassPrivateMethod") {
    node.value = node;
  }

  if (node.value.async) {
    parts.push("async ");
  }

  if (!kind || kind === "init" || kind === "method" || kind === "constructor") {
    if (node.value.generator) {
      parts.push("*");
    }
  } else {
    assert.ok(kind === "get" || kind === "set");
    parts.push(kind, " ");
  }

  var key = printPropertyKey(path$$1, options, print);

  if (node.computed) {
    key = concat$4(["[", key, "]"]);
  }

  parts.push(key, concat$4(path$$1.call(function (valuePath) {
    return [printFunctionTypeParameters(valuePath, options, print), group$1(concat$4([printFunctionParams(valuePath, print, options), printReturnType(valuePath, print, options)]))];
  }, "value")));

  if (!node.value.body || node.value.body.length === 0) {
    parts.push(semi);
  } else {
    parts.push(" ", path$$1.call(print, "value", "body"));
  }

  return concat$4(parts);
}

function couldGroupArg(arg) {
  return arg.type === "ObjectExpression" && (arg.properties.length > 0 || arg.comments) || arg.type === "ArrayExpression" && (arg.elements.length > 0 || arg.comments) || arg.type === "TSTypeAssertion" || arg.type === "TSAsExpression" || arg.type === "FunctionExpression" || arg.type === "ArrowFunctionExpression" && ( // we want to avoid breaking inside composite return types but not simple keywords
  // https://github.com/prettier/prettier/issues/4070
  // export class Thing implements OtherThing {
  //   do: (type: Type) => Provider<Prop> = memoize(
  //     (type: ObjectType): Provider<Opts> => {}
  //   );
  // }
  // https://github.com/prettier/prettier/issues/6099
  // app.get("/", (req, res): void => {
  //   res.send("Hello World!");
  // });
  !arg.returnType || !arg.returnType.typeAnnotation || arg.returnType.typeAnnotation.type !== "TSTypeReference") && (arg.body.type === "BlockStatement" || arg.body.type === "ArrowFunctionExpression" || arg.body.type === "ObjectExpression" || arg.body.type === "ArrayExpression" || arg.body.type === "CallExpression" || arg.body.type === "OptionalCallExpression" || arg.body.type === "ConditionalExpression" || isJSXNode(arg.body));
}

function shouldGroupLastArg(args) {
  var lastArg = getLast$3(args);
  var penultimateArg = getPenultimate$1(args);
  return !hasLeadingComment(lastArg) && !hasTrailingComment(lastArg) && couldGroupArg(lastArg) && ( // If the last two arguments are of the same type,
  // disable last element expansion.
  !penultimateArg || penultimateArg.type !== lastArg.type);
}

function shouldGroupFirstArg(args) {
  if (args.length !== 2) {
    return false;
  }

  var firstArg = args[0];
  var secondArg = args[1];
  return (!firstArg.comments || !firstArg.comments.length) && (firstArg.type === "FunctionExpression" || firstArg.type === "ArrowFunctionExpression" && firstArg.body.type === "BlockStatement") && secondArg.type !== "FunctionExpression" && secondArg.type !== "ArrowFunctionExpression" && secondArg.type !== "ConditionalExpression" && !couldGroupArg(secondArg);
}

function isSimpleFlowType(node) {
  var flowTypeAnnotations = ["AnyTypeAnnotation", "NullLiteralTypeAnnotation", "GenericTypeAnnotation", "ThisTypeAnnotation", "NumberTypeAnnotation", "VoidTypeAnnotation", "EmptyTypeAnnotation", "MixedTypeAnnotation", "BooleanTypeAnnotation", "BooleanLiteralTypeAnnotation", "StringTypeAnnotation"];
  return node && flowTypeAnnotations.indexOf(node.type) !== -1 && !(node.type === "GenericTypeAnnotation" && node.typeParameters);
}

function isJestEachTemplateLiteral(node, parentNode) {
  /**
   * describe.each`table`(name, fn)
   * describe.only.each`table`(name, fn)
   * describe.skip.each`table`(name, fn)
   * test.each`table`(name, fn)
   * test.only.each`table`(name, fn)
   * test.skip.each`table`(name, fn)
   *
   * Ref: https://github.com/facebook/jest/pull/6102
   */
  var jestEachTriggerRegex = /^[xf]?(describe|it|test)$/;
  return parentNode.type === "TaggedTemplateExpression" && parentNode.quasi === node && parentNode.tag.type === "MemberExpression" && parentNode.tag.property.type === "Identifier" && parentNode.tag.property.name === "each" && (parentNode.tag.object.type === "Identifier" && jestEachTriggerRegex.test(parentNode.tag.object.name) || parentNode.tag.object.type === "MemberExpression" && parentNode.tag.object.property.type === "Identifier" && (parentNode.tag.object.property.name === "only" || parentNode.tag.object.property.name === "skip") && parentNode.tag.object.object.type === "Identifier" && jestEachTriggerRegex.test(parentNode.tag.object.object.name));
}

function printJestEachTemplateLiteral(node, expressions, options) {
  /**
   * a    | b    | expected
   * ${1} | ${1} | ${2}
   * ${1} | ${2} | ${3}
   * ${2} | ${1} | ${3}
   */
  var headerNames = node.quasis[0].value.raw.trim().split(/\s*\|\s*/);

  if (headerNames.length > 1 || headerNames.some(function (headerName) {
    return headerName.length !== 0;
  })) {
    var parts = [];
    var stringifiedExpressions = expressions.map(function (doc$$2) {
      return "${" + printDocToString$2(doc$$2, Object.assign({}, options, {
        printWidth: Infinity,
        endOfLine: "lf"
      })).formatted + "}";
    });
    var tableBody = [{
      hasLineBreak: false,
      cells: []
    }];

    for (var i = 1; i < node.quasis.length; i++) {
      var row = tableBody[tableBody.length - 1];
      var correspondingExpression = stringifiedExpressions[i - 1];
      row.cells.push(correspondingExpression);

      if (correspondingExpression.indexOf("\n") !== -1) {
        row.hasLineBreak = true;
      }

      if (node.quasis[i].value.raw.indexOf("\n") !== -1) {
        tableBody.push({
          hasLineBreak: false,
          cells: []
        });
      }
    }

    var maxColumnCount = tableBody.reduce(function (maxColumnCount, row) {
      return Math.max(maxColumnCount, row.cells.length);
    }, headerNames.length);
    var maxColumnWidths = Array.from(new Array(maxColumnCount), function () {
      return 0;
    });
    var table = [{
      cells: headerNames
    }].concat(tableBody.filter(function (row) {
      return row.cells.length !== 0;
    }));
    table.filter(function (row) {
      return !row.hasLineBreak;
    }).forEach(function (row) {
      row.cells.forEach(function (cell, index) {
        maxColumnWidths[index] = Math.max(maxColumnWidths[index], getStringWidth$2(cell));
      });
    });
    parts.push("`", indent$2(concat$4([hardline$3, join$2(hardline$3, table.map(function (row) {
      return join$2(" | ", row.cells.map(function (cell, index) {
        return row.hasLineBreak ? cell : cell + " ".repeat(maxColumnWidths[index] - getStringWidth$2(cell));
      }));
    }))])), hardline$3, "`");
    return concat$4(parts);
  }
}
/** @param node {import("estree").TemplateLiteral} */


function isSimpleTemplateLiteral(node) {
  if (node.expressions.length === 0) {
    return false;
  }

  return node.expressions.every(function (expr) {
    // Disallow comments since printDocToString can't print them here
    if (expr.comments) {
      return false;
    } // Allow `x` and `this`


    if (expr.type === "Identifier" || expr.type === "ThisExpression") {
      return true;
    } // Allow `a.b.c`, `a.b[c]`, and `this.x.y`


    if ((expr.type === "MemberExpression" || expr.type === "OptionalMemberExpression") && (expr.property.type === "Identifier" || expr.property.type === "Literal")) {
      var ancestor = expr;

      while (ancestor.type === "MemberExpression" || ancestor.type === "OptionalMemberExpression") {
        ancestor = ancestor.object;

        if (ancestor.comments) {
          return false;
        }
      }

      if (ancestor.type === "Identifier" || ancestor.type === "ThisExpression") {
        return true;
      }

      return false;
    }

    return false;
  });
}

var functionCompositionFunctionNames = new Set(["pipe", // RxJS, Ramda
"pipeP", // Ramda
"pipeK", // Ramda
"compose", // Ramda, Redux
"composeFlipped", // Not from any library, but common in Haskell, so supported
"composeP", // Ramda
"composeK", // Ramda
"flow", // Lodash
"flowRight", // Lodash
"connect", // Redux
"createSelector" // Reselect
]);
var ordinaryMethodNames = new Set(["connect" // GObject, MongoDB
]);

function isFunctionCompositionFunction(node) {
  switch (node.type) {
    case "OptionalMemberExpression":
    case "MemberExpression":
      {
        return isFunctionCompositionFunction(node.property) && !ordinaryMethodNames.has(node.property.name);
      }

    case "Identifier":
      {
        return functionCompositionFunctionNames.has(node.name);
      }

    case "StringLiteral":
    case "Literal":
      {
        return functionCompositionFunctionNames.has(node.value);
      }
  }
}

function printArgumentsList(path$$1, options, print) {
  var node = path$$1.getValue();
  var args = node.arguments;

  if (args.length === 0) {
    return concat$4(["(", comments.printDanglingComments(path$$1, options,
    /* sameIndent */
    true), ")"]);
  } // useEffect(() => { ... }, [foo, bar, baz])


  if (args.length === 2 && args[0].type === "ArrowFunctionExpression" && args[0].params.length === 0 && args[0].body.type === "BlockStatement" && args[1].type === "ArrayExpression" && !args.find(function (arg) {
    return arg.leadingComments || arg.trailingComments;
  })) {
    return concat$4(["(", path$$1.call(print, "arguments", 0), ", ", path$$1.call(print, "arguments", 1), ")"]);
  }

  var anyArgEmptyLine = false;
  var hasEmptyLineFollowingFirstArg = false;
  var lastArgIndex = args.length - 1;
  var printedArguments = path$$1.map(function (argPath, index) {
    var arg = argPath.getNode();
    var parts = [print(argPath)];

    if (index === lastArgIndex) {// do nothing
    } else if (isNextLineEmpty$2(options.originalText, arg, options)) {
      if (index === 0) {
        hasEmptyLineFollowingFirstArg = true;
      }

      anyArgEmptyLine = true;
      parts.push(",", hardline$3, hardline$3);
    } else {
      parts.push(",", line$3);
    }

    return concat$4(parts);
  }, "arguments");
  var maybeTrailingComma = // Dynamic imports cannot have trailing commas
  !(node.callee && node.callee.type === "Import") && shouldPrintComma(options, "all") ? "," : "";

  function allArgsBrokenOut() {
    return group$1(concat$4(["(", indent$2(concat$4([line$3, concat$4(printedArguments)])), maybeTrailingComma, line$3, ")"]), {
      shouldBreak: true
    });
  } // We want to get
  //    pipe(
  //      x => x + 1,
  //      x => x - 1
  //    )
  // here, but not
  //    process.stdout.pipe(socket)


  if (isFunctionCompositionFunction(node.callee) && args.length > 1) {
    return allArgsBrokenOut();
  }

  var shouldGroupFirst = shouldGroupFirstArg(args);
  var shouldGroupLast = shouldGroupLastArg(args);

  if (shouldGroupFirst || shouldGroupLast) {
    var shouldBreak = (shouldGroupFirst ? printedArguments.slice(1).some(willBreak$1) : printedArguments.slice(0, -1).some(willBreak$1)) || anyArgEmptyLine; // We want to print the last argument with a special flag

    var printedExpanded;
    var i = 0;
    path$$1.each(function (argPath) {
      if (shouldGroupFirst && i === 0) {
        printedExpanded = [concat$4([argPath.call(function (p) {
          return print(p, {
            expandFirstArg: true
          });
        }), printedArguments.length > 1 ? "," : "", hasEmptyLineFollowingFirstArg ? hardline$3 : line$3, hasEmptyLineFollowingFirstArg ? hardline$3 : ""])].concat(printedArguments.slice(1));
      }

      if (shouldGroupLast && i === args.length - 1) {
        printedExpanded = printedArguments.slice(0, -1).concat(argPath.call(function (p) {
          return print(p, {
            expandLastArg: true
          });
        }));
      }

      i++;
    }, "arguments");
    var somePrintedArgumentsWillBreak = printedArguments.some(willBreak$1);
    return concat$4([somePrintedArgumentsWillBreak ? breakParent$2 : "", conditionalGroup$1([concat$4([ifBreak$1(indent$2(concat$4(["(", softline$1, concat$4(printedExpanded)])), concat$4(["(", concat$4(printedExpanded)])), somePrintedArgumentsWillBreak ? concat$4([ifBreak$1(maybeTrailingComma), softline$1]) : "", ")"]), shouldGroupFirst ? concat$4(["(", group$1(printedExpanded[0], {
      shouldBreak: true
    }), concat$4(printedExpanded.slice(1)), ")"]) : concat$4(["(", concat$4(printedArguments.slice(0, -1)), group$1(getLast$3(printedExpanded), {
      shouldBreak: true
    }), ")"]), allArgsBrokenOut()], {
      shouldBreak
    })]);
  }

  return group$1(concat$4(["(", indent$2(concat$4([softline$1, concat$4(printedArguments)])), ifBreak$1(maybeTrailingComma), softline$1, ")"]), {
    shouldBreak: printedArguments.some(willBreak$1) || anyArgEmptyLine
  });
}

function printTypeAnnotation(path$$1, options, print) {
  var node = path$$1.getValue();

  if (!node.typeAnnotation) {
    return "";
  }

  var parentNode = path$$1.getParentNode();
  var isDefinite = node.definite || parentNode && parentNode.type === "VariableDeclarator" && parentNode.definite;
  var isFunctionDeclarationIdentifier = parentNode.type === "DeclareFunction" && parentNode.id === node;

  if (isFlowAnnotationComment(options.originalText, node.typeAnnotation, options)) {
    return concat$4([" /*: ", path$$1.call(print, "typeAnnotation"), " */"]);
  }

  return concat$4([isFunctionDeclarationIdentifier ? "" : isDefinite ? "!: " : ": ", path$$1.call(print, "typeAnnotation")]);
}

function printFunctionTypeParameters(path$$1, options, print) {
  var fun = path$$1.getValue();

  if (fun.typeArguments) {
    return path$$1.call(print, "typeArguments");
  }

  if (fun.typeParameters) {
    return path$$1.call(print, "typeParameters");
  }

  return "";
}

function printFunctionParams(path$$1, print, options, expandArg, printTypeParams) {
  var fun = path$$1.getValue();
  var parent = path$$1.getParentNode();
  var paramsField = fun.parameters ? "parameters" : "params";
  var isParametersInTestCall = isTestCall(parent);
  var shouldHugParameters = shouldHugArguments(fun);
  var shouldExpandParameters = expandArg && !(fun[paramsField] && fun[paramsField].some(function (n) {
    return n.comments;
  }));
  var typeParams = printTypeParams ? printFunctionTypeParameters(path$$1, options, print) : "";
  var printed = [];

  if (fun[paramsField]) {
    var lastArgIndex = fun[paramsField].length - 1;
    printed = path$$1.map(function (childPath, index) {
      var parts = [];
      var param = childPath.getValue();
      parts.push(print(childPath));

      if (index === lastArgIndex) {
        if (fun.rest) {
          parts.push(",", line$3);
        }
      } else if (isParametersInTestCall || shouldHugParameters || shouldExpandParameters) {
        parts.push(", ");
      } else if (isNextLineEmpty$2(options.originalText, param, options)) {
        parts.push(",", hardline$3, hardline$3);
      } else {
        parts.push(",", line$3);
      }

      return concat$4(parts);
    }, paramsField);
  }

  if (fun.rest) {
    printed.push(concat$4(["...", path$$1.call(print, "rest")]));
  }

  if (printed.length === 0) {
    return concat$4([typeParams, "(", comments.printDanglingComments(path$$1, options,
    /* sameIndent */
    true, function (comment) {
      return getNextNonSpaceNonCommentCharacter$1(options.originalText, comment, options.locEnd) === ")";
    }), ")"]);
  }

  var lastParam = getLast$3(fun[paramsField]); // If the parent is a call with the first/last argument expansion and this is the
  // params of the first/last argument, we dont want the arguments to break and instead
  // want the whole expression to be on a new line.
  //
  // Good:                 Bad:
  //   verylongcall(         verylongcall((
  //     (a, b) => {           a,
  //     }                     b,
  //   })                    ) => {
  //                         })

  if (shouldExpandParameters) {
    return group$1(concat$4([removeLines$1(typeParams), "(", concat$4(printed.map(removeLines$1)), ")"]));
  } // Single object destructuring should hug
  //
  // function({
  //   a,
  //   b,
  //   c
  // }) {}


  if (shouldHugParameters) {
    return concat$4([typeParams, "(", concat$4(printed), ")"]);
  } // don't break in specs, eg; `it("should maintain parens around done even when long", (done) => {})`


  if (isParametersInTestCall) {
    return concat$4([typeParams, "(", concat$4(printed), ")"]);
  }

  var isFlowShorthandWithOneArg = (isObjectTypePropertyAFunction(parent, options) || isTypeAnnotationAFunction(parent, options) || parent.type === "TypeAlias" || parent.type === "UnionTypeAnnotation" || parent.type === "TSUnionType" || parent.type === "IntersectionTypeAnnotation" || parent.type === "FunctionTypeAnnotation" && parent.returnType === fun) && fun[paramsField].length === 1 && fun[paramsField][0].name === null && fun[paramsField][0].typeAnnotation && fun.typeParameters === null && isSimpleFlowType(fun[paramsField][0].typeAnnotation) && !fun.rest;

  if (isFlowShorthandWithOneArg) {
    if (options.arrowParens === "always") {
      return concat$4(["(", concat$4(printed), ")"]);
    }

    return concat$4(printed);
  }

  var canHaveTrailingComma = !(lastParam && lastParam.type === "RestElement") && !fun.rest;
  return concat$4([typeParams, "(", indent$2(concat$4([softline$1, concat$4(printed)])), ifBreak$1(canHaveTrailingComma && shouldPrintComma(options, "all") ? "," : ""), softline$1, ")"]);
}

function shouldPrintParamsWithoutParens(path$$1, options) {
  if (options.arrowParens === "always") {
    return false;
  }

  if (options.arrowParens === "avoid") {
    var node = path$$1.getValue();
    return canPrintParamsWithoutParens(node);
  } // Fallback default; should be unreachable


  return false;
}

function canPrintParamsWithoutParens(node) {
  return node.params.length === 1 && !node.rest && !node.typeParameters && !hasDanglingComments(node) && node.params[0].type === "Identifier" && !node.params[0].typeAnnotation && !node.params[0].comments && !node.params[0].optional && !node.predicate && !node.returnType;
}

function printFunctionDeclaration(path$$1, print, options) {
  var n = path$$1.getValue();
  var parts = [];

  if (n.async) {
    parts.push("async ");
  }

  parts.push("function");

  if (n.generator) {
    parts.push("*");
  }

  if (n.id) {
    parts.push(" ", path$$1.call(print, "id"));
  }

  parts.push(printFunctionTypeParameters(path$$1, options, print), group$1(concat$4([printFunctionParams(path$$1, print, options), printReturnType(path$$1, print, options)])), n.body ? " " : "", path$$1.call(print, "body"));
  return concat$4(parts);
}

function printObjectMethod(path$$1, options, print) {
  var objMethod = path$$1.getValue();
  var parts = [];

  if (objMethod.async) {
    parts.push("async ");
  }

  if (objMethod.generator) {
    parts.push("*");
  }

  if (objMethod.method || objMethod.kind === "get" || objMethod.kind === "set") {
    return printMethod(path$$1, options, print);
  }

  var key = printPropertyKey(path$$1, options, print);

  if (objMethod.computed) {
    parts.push("[", key, "]");
  } else {
    parts.push(key);
  }

  parts.push(printFunctionTypeParameters(path$$1, options, print), group$1(concat$4([printFunctionParams(path$$1, print, options), printReturnType(path$$1, print, options)])), " ", path$$1.call(print, "body"));
  return concat$4(parts);
}

function printReturnType(path$$1, print, options) {
  var n = path$$1.getValue();
  var returnType = path$$1.call(print, "returnType");

  if (n.returnType && isFlowAnnotationComment(options.originalText, n.returnType, options)) {
    return concat$4([" /*: ", returnType, " */"]);
  }

  var parts = [returnType]; // prepend colon to TypeScript type annotation

  if (n.returnType && n.returnType.typeAnnotation) {
    parts.unshift(": ");
  }

  if (n.predicate) {
    // The return type will already add the colon, but otherwise we
    // need to do it ourselves
    parts.push(n.returnType ? " " : ": ", path$$1.call(print, "predicate"));
  }

  return concat$4(parts);
}

function printExportDeclaration(path$$1, options, print) {
  var decl = path$$1.getValue();
  var semi = options.semi ? ";" : "";
  var parts = ["export "];
  var isDefault = decl["default"] || decl.type === "ExportDefaultDeclaration";

  if (isDefault) {
    parts.push("default ");
  }

  parts.push(comments.printDanglingComments(path$$1, options,
  /* sameIndent */
  true));

  if (needsHardlineAfterDanglingComment(decl)) {
    parts.push(hardline$3);
  }

  if (decl.declaration) {
    parts.push(path$$1.call(print, "declaration"));

    if (isDefault && decl.declaration.type !== "ClassDeclaration" && decl.declaration.type !== "FunctionDeclaration" && decl.declaration.type !== "TSInterfaceDeclaration" && decl.declaration.type !== "DeclareClass" && decl.declaration.type !== "DeclareFunction" && decl.declaration.type !== "TSDeclareFunction") {
      parts.push(semi);
    }
  } else {
    if (decl.specifiers && decl.specifiers.length > 0) {
      var specifiers = [];
      var defaultSpecifiers = [];
      var namespaceSpecifiers = [];
      path$$1.each(function (specifierPath) {
        var specifierType = path$$1.getValue().type;

        if (specifierType === "ExportSpecifier") {
          specifiers.push(print(specifierPath));
        } else if (specifierType === "ExportDefaultSpecifier") {
          defaultSpecifiers.push(print(specifierPath));
        } else if (specifierType === "ExportNamespaceSpecifier") {
          namespaceSpecifiers.push(concat$4(["* as ", print(specifierPath)]));
        }
      }, "specifiers");
      var isNamespaceFollowed = namespaceSpecifiers.length !== 0 && specifiers.length !== 0;
      var isDefaultFollowed = defaultSpecifiers.length !== 0 && (namespaceSpecifiers.length !== 0 || specifiers.length !== 0);
      parts.push(decl.exportKind === "type" ? "type " : "", concat$4(defaultSpecifiers), concat$4([isDefaultFollowed ? ", " : ""]), concat$4(namespaceSpecifiers), concat$4([isNamespaceFollowed ? ", " : ""]), specifiers.length !== 0 ? group$1(concat$4(["{", indent$2(concat$4([options.bracketSpacing ? line$3 : softline$1, join$2(concat$4([",", line$3]), specifiers)])), ifBreak$1(shouldPrintComma(options) ? "," : ""), options.bracketSpacing ? line$3 : softline$1, "}"])) : "");
    } else {
      parts.push("{}");
    }

    if (decl.source) {
      parts.push(" from ", path$$1.call(print, "source"));
    }

    parts.push(semi);
  }

  return concat$4(parts);
}

function printFlowDeclaration(path$$1, parts) {
  var parentExportDecl = getParentExportDeclaration$1(path$$1);

  if (parentExportDecl) {
    assert.strictEqual(parentExportDecl.type, "DeclareExportDeclaration");
  } else {
    // If the parent node has type DeclareExportDeclaration, then it
    // will be responsible for printing the "declare" token. Otherwise
    // it needs to be printed with this non-exported declaration node.
    parts.unshift("declare ");
  }

  return concat$4(parts);
}

function getFlowVariance(path$$1) {
  if (!path$$1.variance) {
    return null;
  } // Babel 7.0 currently uses variance node type, and flow should
  // follow suit soon:
  // https://github.com/babel/babel/issues/4722


  var variance = path$$1.variance.kind || path$$1.variance;

  switch (variance) {
    case "plus":
      return "+";

    case "minus":
      return "-";

    default:
      /* istanbul ignore next */
      return variance;
  }
}

function printTypeScriptModifiers(path$$1, options, print) {
  var n = path$$1.getValue();

  if (!n.modifiers || !n.modifiers.length) {
    return "";
  }

  return concat$4([join$2(" ", path$$1.map(print, "modifiers")), " "]);
}

function printTypeParameters(path$$1, options, print, paramsKey) {
  var n = path$$1.getValue();

  if (!n[paramsKey]) {
    return "";
  } // for TypeParameterDeclaration typeParameters is a single node


  if (!Array.isArray(n[paramsKey])) {
    return path$$1.call(print, paramsKey);
  }

  var grandparent = path$$1.getNode(2);
  var isParameterInTestCall = grandparent != null && isTestCall(grandparent);
  var shouldInline = isParameterInTestCall || n[paramsKey].length === 0 || n[paramsKey].length === 1 && (shouldHugType(n[paramsKey][0]) || n[paramsKey][0].type === "GenericTypeAnnotation" && shouldHugType(n[paramsKey][0].id) || n[paramsKey][0].type === "TSTypeReference" && shouldHugType(n[paramsKey][0].typeName) || n[paramsKey][0].type === "NullableTypeAnnotation");

  if (shouldInline) {
    return concat$4(["<", join$2(", ", path$$1.map(print, paramsKey)), ">"]);
  }

  return group$1(concat$4(["<", indent$2(concat$4([softline$1, join$2(concat$4([",", line$3]), path$$1.map(print, paramsKey))])), ifBreak$1(options.parser !== "typescript" && shouldPrintComma(options, "all") ? "," : ""), softline$1, ">"]));
}

function printClass(path$$1, options, print) {
  var n = path$$1.getValue();
  var parts = [];

  if (n.abstract) {
    parts.push("abstract ");
  }

  parts.push("class");

  if (n.id) {
    parts.push(" ", path$$1.call(print, "id"));
  }

  parts.push(path$$1.call(print, "typeParameters"));
  var partsGroup = [];

  if (n.superClass) {
    var printed = concat$4(["extends ", path$$1.call(print, "superClass"), path$$1.call(print, "superTypeParameters")]); // Keep old behaviour of extends in same line
    // If there is only on extends and there are not comments

    if ((!n.implements || n.implements.length === 0) && (!n.superClass.comments || n.superClass.comments.length === 0)) {
      parts.push(concat$4([" ", path$$1.call(function (superClass) {
        return comments.printComments(superClass, function () {
          return printed;
        }, options);
      }, "superClass")]));
    } else {
      partsGroup.push(group$1(concat$4([line$3, path$$1.call(function (superClass) {
        return comments.printComments(superClass, function () {
          return printed;
        }, options);
      }, "superClass")])));
    }
  } else if (n.extends && n.extends.length > 0) {
    parts.push(" extends ", join$2(", ", path$$1.map(print, "extends")));
  }

  if (n["mixins"] && n["mixins"].length > 0) {
    partsGroup.push(line$3, "mixins ", group$1(indent$2(join$2(concat$4([",", line$3]), path$$1.map(print, "mixins")))));
  }

  if (n["implements"] && n["implements"].length > 0) {
    partsGroup.push(line$3, "implements", group$1(indent$2(concat$4([line$3, join$2(concat$4([",", line$3]), path$$1.map(print, "implements"))]))));
  }

  if (partsGroup.length > 0) {
    parts.push(group$1(indent$2(concat$4(partsGroup))));
  }

  if (n.body && n.body.comments && hasLeadingOwnLineComment(options.originalText, n.body, options)) {
    parts.push(hardline$3);
  } else {
    parts.push(" ");
  }

  parts.push(path$$1.call(print, "body"));
  return parts;
}

function printOptionalToken(path$$1) {
  var node = path$$1.getValue();

  if (!node.optional) {
    return "";
  }

  if (node.type === "OptionalCallExpression" || node.type === "OptionalMemberExpression" && node.computed) {
    return "?.";
  }

  return "?";
}

function printMemberLookup(path$$1, options, print) {
  var property = path$$1.call(print, "property");
  var n = path$$1.getValue();
  var optional = printOptionalToken(path$$1);

  if (!n.computed) {
    return concat$4([optional, ".", property]);
  }

  if (!n.property || isNumericLiteral(n.property)) {
    return concat$4([optional, "[", property, "]"]);
  }

  return group$1(concat$4([optional, "[", indent$2(concat$4([softline$1, property])), softline$1, "]"]));
}

function printBindExpressionCallee(path$$1, options, print) {
  return concat$4(["::", path$$1.call(print, "callee")]);
} // We detect calls on member expressions specially to format a
// common pattern better. The pattern we are looking for is this:
//
// arr
//   .map(x => x + 1)
//   .filter(x => x > 10)
//   .some(x => x % 2)
//
// The way it is structured in the AST is via a nested sequence of
// MemberExpression and CallExpression. We need to traverse the AST
// and make groups out of it to print it in the desired way.


function printMemberChain(path$$1, options, print) {
  // The first phase is to linearize the AST by traversing it down.
  //
  //   a().b()
  // has the following AST structure:
  //   CallExpression(MemberExpression(CallExpression(Identifier)))
  // and we transform it into
  //   [Identifier, CallExpression, MemberExpression, CallExpression]
  var printedNodes = []; // Here we try to retain one typed empty line after each call expression or
  // the first group whether it is in parentheses or not

  function shouldInsertEmptyLineAfter(node) {
    var originalText = options.originalText;
    var nextCharIndex = getNextNonSpaceNonCommentCharacterIndex$2(originalText, node, options);
    var nextChar = originalText.charAt(nextCharIndex); // if it is cut off by a parenthesis, we only account for one typed empty
    // line after that parenthesis

    if (nextChar == ")") {
      return isNextLineEmptyAfterIndex$1(originalText, nextCharIndex + 1, options);
    }

    return isNextLineEmpty$2(originalText, node, options);
  }

  function rec(path$$1) {
    var node = path$$1.getValue();

    if ((node.type === "CallExpression" || node.type === "OptionalCallExpression") && (isMemberish(node.callee) || node.callee.type === "CallExpression" || node.callee.type === "OptionalCallExpression")) {
      printedNodes.unshift({
        node: node,
        printed: concat$4([comments.printComments(path$$1, function () {
          return concat$4([printOptionalToken(path$$1), printFunctionTypeParameters(path$$1, options, print), printArgumentsList(path$$1, options, print)]);
        }, options), shouldInsertEmptyLineAfter(node) ? hardline$3 : ""])
      });
      path$$1.call(function (callee) {
        return rec(callee);
      }, "callee");
    } else if (isMemberish(node)) {
      printedNodes.unshift({
        node: node,
        needsParens: needsParens_1(path$$1, options),
        printed: comments.printComments(path$$1, function () {
          return node.type === "OptionalMemberExpression" || node.type === "MemberExpression" ? printMemberLookup(path$$1, options, print) : printBindExpressionCallee(path$$1, options, print);
        }, options)
      });
      path$$1.call(function (object) {
        return rec(object);
      }, "object");
    } else if (node.type === "TSNonNullExpression") {
      printedNodes.unshift({
        node: node,
        printed: comments.printComments(path$$1, function () {
          return "!";
        }, options)
      });
      path$$1.call(function (expression) {
        return rec(expression);
      }, "expression");
    } else {
      printedNodes.unshift({
        node: node,
        printed: path$$1.call(print)
      });
    }
  } // Note: the comments of the root node have already been printed, so we
  // need to extract this first call without printing them as they would
  // if handled inside of the recursive call.


  var node = path$$1.getValue();
  printedNodes.unshift({
    node,
    printed: concat$4([printOptionalToken(path$$1), printFunctionTypeParameters(path$$1, options, print), printArgumentsList(path$$1, options, print)])
  });
  path$$1.call(function (callee) {
    return rec(callee);
  }, "callee"); // Once we have a linear list of printed nodes, we want to create groups out
  // of it.
  //
  //   a().b.c().d().e
  // will be grouped as
  //   [
  //     [Identifier, CallExpression],
  //     [MemberExpression, MemberExpression, CallExpression],
  //     [MemberExpression, CallExpression],
  //     [MemberExpression],
  //   ]
  // so that we can print it as
  //   a()
  //     .b.c()
  //     .d()
  //     .e
  // The first group is the first node followed by
  //   - as many CallExpression as possible
  //       < fn()()() >.something()
  //   - as many array acessors as possible
  //       < fn()[0][1][2] >.something()
  //   - then, as many MemberExpression as possible but the last one
  //       < this.items >.something()

  var groups = [];
  var currentGroup = [printedNodes[0]];
  var i = 1;

  for (; i < printedNodes.length; ++i) {
    if (printedNodes[i].node.type === "TSNonNullExpression" || printedNodes[i].node.type === "OptionalCallExpression" || printedNodes[i].node.type === "CallExpression" || (printedNodes[i].node.type === "MemberExpression" || printedNodes[i].node.type === "OptionalMemberExpression") && printedNodes[i].node.computed && isNumericLiteral(printedNodes[i].node.property)) {
      currentGroup.push(printedNodes[i]);
    } else {
      break;
    }
  }

  if (printedNodes[0].node.type !== "CallExpression" && printedNodes[0].node.type !== "OptionalCallExpression") {
    for (; i + 1 < printedNodes.length; ++i) {
      if (isMemberish(printedNodes[i].node) && isMemberish(printedNodes[i + 1].node)) {
        currentGroup.push(printedNodes[i]);
      } else {
        break;
      }
    }
  }

  groups.push(currentGroup);
  currentGroup = []; // Then, each following group is a sequence of MemberExpression followed by
  // a sequence of CallExpression. To compute it, we keep adding things to the
  // group until we has seen a CallExpression in the past and reach a
  // MemberExpression

  var hasSeenCallExpression = false;

  for (; i < printedNodes.length; ++i) {
    if (hasSeenCallExpression && isMemberish(printedNodes[i].node)) {
      // [0] should be appended at the end of the group instead of the
      // beginning of the next one
      if (printedNodes[i].node.computed && isNumericLiteral(printedNodes[i].node.property)) {
        currentGroup.push(printedNodes[i]);
        continue;
      }

      groups.push(currentGroup);
      currentGroup = [];
      hasSeenCallExpression = false;
    }

    if (printedNodes[i].node.type === "CallExpression" || printedNodes[i].node.type === "OptionalCallExpression") {
      hasSeenCallExpression = true;
    }

    currentGroup.push(printedNodes[i]);

    if (printedNodes[i].node.comments && printedNodes[i].node.comments.some(function (comment) {
      return comment.trailing;
    })) {
      groups.push(currentGroup);
      currentGroup = [];
      hasSeenCallExpression = false;
    }
  }

  if (currentGroup.length > 0) {
    groups.push(currentGroup);
  } // There are cases like Object.keys(), Observable.of(), _.values() where
  // they are the subject of all the chained calls and therefore should
  // be kept on the same line:
  //
  //   Object.keys(items)
  //     .filter(x => x)
  //     .map(x => x)
  //
  // In order to detect those cases, we use an heuristic: if the first
  // node is an identifier with the name starting with a capital
  // letter or just a sequence of _$. The rationale is that they are
  // likely to be factories.


  function isFactory(name) {
    return /^[A-Z]|^[_$]+$/.test(name);
  } // In case the Identifier is shorter than tab width, we can keep the
  // first call in a single line, if it's an ExpressionStatement.
  //
  //   d3.scaleLinear()
  //     .domain([0, 100])
  //     .range([0, width]);
  //


  function isShort(name) {
    return name.length <= options.tabWidth;
  }

  function shouldNotWrap(groups) {
    var parent = path$$1.getParentNode();
    var isExpression = parent && parent.type === "ExpressionStatement";
    var hasComputed = groups[1].length && groups[1][0].node.computed;

    if (groups[0].length === 1) {
      var firstNode = groups[0][0].node;
      return firstNode.type === "ThisExpression" || firstNode.type === "Identifier" && (isFactory(firstNode.name) || isExpression && isShort(firstNode.name) || hasComputed);
    }

    var lastNode = getLast$3(groups[0]).node;
    return (lastNode.type === "MemberExpression" || lastNode.type === "OptionalMemberExpression") && lastNode.property.type === "Identifier" && (isFactory(lastNode.property.name) || hasComputed);
  }

  var shouldMerge = groups.length >= 2 && !groups[1][0].node.comments && shouldNotWrap(groups);

  function printGroup(printedGroup) {
    var printed = printedGroup.map(function (tuple) {
      return tuple.printed;
    }); // Checks if the last node (i.e. the parent node) needs parens and print
    // accordingly

    if (printedGroup.length > 0 && printedGroup[printedGroup.length - 1].needsParens) {
      return concat$4(["("].concat(_toConsumableArray(printed), [")"]));
    }

    return concat$4(printed);
  }

  function printIndentedGroup(groups) {
    if (groups.length === 0) {
      return "";
    }

    return indent$2(group$1(concat$4([hardline$3, join$2(hardline$3, groups.map(printGroup))])));
  }

  var printedGroups = groups.map(printGroup);
  var oneLine = concat$4(printedGroups);
  var cutoff = shouldMerge ? 3 : 2;
  var flatGroups = groups.slice(0, cutoff).reduce(function (res, group) {
    return res.concat(group);
  }, []);
  var hasComment = flatGroups.slice(1, -1).some(function (node) {
    return hasLeadingComment(node.node);
  }) || flatGroups.slice(0, -1).some(function (node) {
    return hasTrailingComment(node.node);
  }) || groups[cutoff] && hasLeadingComment(groups[cutoff][0].node); // If we only have a single `.`, we shouldn't do anything fancy and just
  // render everything concatenated together.

  if (groups.length <= cutoff && !hasComment) {
    return group$1(oneLine);
  } // Find out the last node in the first group and check if it has an
  // empty line after


  var lastNodeBeforeIndent = getLast$3(shouldMerge ? groups.slice(1, 2)[0] : groups[0]).node;
  var shouldHaveEmptyLineBeforeIndent = lastNodeBeforeIndent.type !== "CallExpression" && lastNodeBeforeIndent.type !== "OptionalCallExpression" && shouldInsertEmptyLineAfter(lastNodeBeforeIndent);
  var expanded = concat$4([printGroup(groups[0]), shouldMerge ? concat$4(groups.slice(1, 2).map(printGroup)) : "", shouldHaveEmptyLineBeforeIndent ? hardline$3 : "", printIndentedGroup(groups.slice(shouldMerge ? 2 : 1))]);
  var callExpressions = printedNodes.map(function (_ref) {
    var node = _ref.node;
    return node;
  }).filter(isCallOrOptionalCallExpression); // We don't want to print in one line if there's:
  //  * A comment.
  //  * 3 or more chained calls.
  //  * Any group but the last one has a hard line.
  // If the last group is a function it's okay to inline if it fits.

  if (hasComment || callExpressions.length >= 3 || printedGroups.slice(0, -1).some(willBreak$1) ||
  /**
   *     scopes.filter(scope => scope.value !== '').map((scope, i) => {
   *       // multi line content
   *     })
   */
  function (lastGroupDoc, lastGroupNode) {
    return isCallOrOptionalCallExpression(lastGroupNode) && willBreak$1(lastGroupDoc);
  }(getLast$3(printedGroups), getLast$3(getLast$3(groups)).node) && callExpressions.slice(0, -1).some(function (n) {
    return n.arguments.some(isFunctionOrArrowExpression);
  })) {
    return group$1(expanded);
  }

  return concat$4([// We only need to check `oneLine` because if `expanded` is chosen
  // that means that the parent group has already been broken
  // naturally
  willBreak$1(oneLine) || shouldHaveEmptyLineBeforeIndent ? breakParent$2 : "", conditionalGroup$1([oneLine, expanded])]);
}

function isCallOrOptionalCallExpression(node) {
  return node.type === "CallExpression" || node.type === "OptionalCallExpression";
}

function isJSXNode(node) {
  return node.type === "JSXElement" || node.type === "JSXFragment";
}

function isEmptyJSXElement(node) {
  if (node.children.length === 0) {
    return true;
  }

  if (node.children.length > 1) {
    return false;
  } // if there is one text child and does not contain any meaningful text
  // we can treat the element as empty.


  var child = node.children[0];
  return isLiteral(child) && !isMeaningfulJSXText(child);
} // Only space, newline, carriage return, and tab are treated as whitespace
// inside JSX.


var jsxWhitespaceChars = " \n\r\t";
var containsNonJsxWhitespaceRegex = new RegExp("[^" + jsxWhitespaceChars + "]");
var matchJsxWhitespaceRegex = new RegExp("([" + jsxWhitespaceChars + "]+)"); // Meaningful if it contains non-whitespace characters,
// or it contains whitespace without a new line.

function isMeaningfulJSXText(node) {
  return isLiteral(node) && (containsNonJsxWhitespaceRegex.test(rawText(node)) || !/\n/.test(rawText(node)));
}

function conditionalExpressionChainContainsJSX(node) {
  return Boolean(getConditionalChainContents(node).find(isJSXNode));
} // If we have nested conditional expressions, we want to print them in JSX mode
// if there's at least one JSXElement somewhere in the tree.
//
// A conditional expression chain like this should be printed in normal mode,
// because there aren't JSXElements anywhere in it:
//
// isA ? "A" : isB ? "B" : isC ? "C" : "Unknown";
//
// But a conditional expression chain like this should be printed in JSX mode,
// because there is a JSXElement in the last ConditionalExpression:
//
// isA ? "A" : isB ? "B" : isC ? "C" : <span className="warning">Unknown</span>;
//
// This type of ConditionalExpression chain is structured like this in the AST:
//
// ConditionalExpression {
//   test: ...,
//   consequent: ...,
//   alternate: ConditionalExpression {
//     test: ...,
//     consequent: ...,
//     alternate: ConditionalExpression {
//       test: ...,
//       consequent: ...,
//       alternate: ...,
//     }
//   }
// }
//
// We want to traverse over that shape and convert it into a flat structure so
// that we can find if there's a JSXElement somewhere inside.


function getConditionalChainContents(node) {
  // Given this code:
  //
  // // Using a ConditionalExpression as the consequent is uncommon, but should
  // // be handled.
  // A ? B : C ? D : E ? F ? G : H : I
  //
  // which has this AST:
  //
  // ConditionalExpression {
  //   test: Identifier(A),
  //   consequent: Identifier(B),
  //   alternate: ConditionalExpression {
  //     test: Identifier(C),
  //     consequent: Identifier(D),
  //     alternate: ConditionalExpression {
  //       test: Identifier(E),
  //       consequent: ConditionalExpression {
  //         test: Identifier(F),
  //         consequent: Identifier(G),
  //         alternate: Identifier(H),
  //       },
  //       alternate: Identifier(I),
  //     }
  //   }
  // }
  //
  // we should return this Array:
  //
  // [
  //   Identifier(A),
  //   Identifier(B),
  //   Identifier(C),
  //   Identifier(D),
  //   Identifier(E),
  //   Identifier(F),
  //   Identifier(G),
  //   Identifier(H),
  //   Identifier(I)
  // ];
  //
  // This loses the information about whether each node was the test,
  // consequent, or alternate, but we don't care about that here- we are only
  // flattening this structure to find if there's any JSXElements inside.
  var nonConditionalExpressions = [];

  function recurse(node) {
    if (node.type === "ConditionalExpression") {
      recurse(node.test);
      recurse(node.consequent);
      recurse(node.alternate);
    } else {
      nonConditionalExpressions.push(node);
    }
  }

  recurse(node);
  return nonConditionalExpressions;
} // Detect an expression node representing `{" "}`


function isJSXWhitespaceExpression(node) {
  return node.type === "JSXExpressionContainer" && isLiteral(node.expression) && node.expression.value === " " && !node.expression.comments;
}

function separatorNoWhitespace(isFacebookTranslationTag, child, childNode, nextNode) {
  if (isFacebookTranslationTag) {
    return "";
  }

  if (childNode.type === "JSXElement" && !childNode.closingElement || nextNode && nextNode.type === "JSXElement" && !nextNode.closingElement) {
    return child.length === 1 ? softline$1 : hardline$3;
  }

  return softline$1;
}

function separatorWithWhitespace(isFacebookTranslationTag, child, childNode, nextNode) {
  if (isFacebookTranslationTag) {
    return hardline$3;
  }

  if (child.length === 1) {
    return childNode.type === "JSXElement" && !childNode.closingElement || nextNode && nextNode.type === "JSXElement" && !nextNode.closingElement ? hardline$3 : softline$1;
  }

  return hardline$3;
} // JSX Children are strange, mostly for two reasons:
// 1. JSX reads newlines into string values, instead of skipping them like JS
// 2. up to one whitespace between elements within a line is significant,
//    but not between lines.
//
// Leading, trailing, and lone whitespace all need to
// turn themselves into the rather ugly `{' '}` when breaking.
//
// We print JSX using the `fill` doc primitive.
// This requires that we give it an array of alternating
// content and whitespace elements.
// To ensure this we add dummy `""` content elements as needed.


function printJSXChildren(path$$1, options, print, jsxWhitespace, isFacebookTranslationTag) {
  var n = path$$1.getValue();
  var children = []; // using `map` instead of `each` because it provides `i`

  path$$1.map(function (childPath, i) {
    var child = childPath.getValue();

    if (isLiteral(child)) {
      var text = rawText(child); // Contains a non-whitespace character

      if (isMeaningfulJSXText(child)) {
        var words = text.split(matchJsxWhitespaceRegex); // Starts with whitespace

        if (words[0] === "") {
          children.push("");
          words.shift();

          if (/\n/.test(words[0])) {
            var next = n.children[i + 1];
            children.push(separatorWithWhitespace(isFacebookTranslationTag, words[1], child, next));
          } else {
            children.push(jsxWhitespace);
          }

          words.shift();
        }

        var endWhitespace; // Ends with whitespace

        if (getLast$3(words) === "") {
          words.pop();
          endWhitespace = words.pop();
        } // This was whitespace only without a new line.


        if (words.length === 0) {
          return;
        }

        words.forEach(function (word, i) {
          if (i % 2 === 1) {
            children.push(line$3);
          } else {
            children.push(word);
          }
        });

        if (endWhitespace !== undefined) {
          if (/\n/.test(endWhitespace)) {
            var _next = n.children[i + 1];
            children.push(separatorWithWhitespace(isFacebookTranslationTag, getLast$3(children), child, _next));
          } else {
            children.push(jsxWhitespace);
          }
        } else {
          var _next2 = n.children[i + 1];
          children.push(separatorNoWhitespace(isFacebookTranslationTag, getLast$3(children), child, _next2));
        }
      } else if (/\n/.test(text)) {
        // Keep (up to one) blank line between tags/expressions/text.
        // Note: We don't keep blank lines between text elements.
        if (text.match(/\n/g).length > 1) {
          children.push("");
          children.push(hardline$3);
        }
      } else {
        children.push("");
        children.push(jsxWhitespace);
      }
    } else {
      var printedChild = print(childPath);
      children.push(printedChild);
      var _next3 = n.children[i + 1];

      var directlyFollowedByMeaningfulText = _next3 && isMeaningfulJSXText(_next3);

      if (directlyFollowedByMeaningfulText) {
        var firstWord = rawText(_next3).trim().split(matchJsxWhitespaceRegex)[0];
        children.push(separatorNoWhitespace(isFacebookTranslationTag, firstWord, child, _next3));
      } else {
        children.push(hardline$3);
      }
    }
  }, "children");
  return children;
} // JSX expands children from the inside-out, instead of the outside-in.
// This is both to break children before attributes,
// and to ensure that when children break, their parents do as well.
//
// Any element that is written without any newlines and fits on a single line
// is left that way.
// Not only that, any user-written-line containing multiple JSX siblings
// should also be kept on one line if possible,
// so each user-written-line is wrapped in its own group.
//
// Elements that contain newlines or don't fit on a single line (recursively)
// are fully-split, using hardline and shouldBreak: true.
//
// To support that case properly, all leading and trailing spaces
// are stripped from the list of children, and replaced with a single hardline.


function printJSXElement(path$$1, options, print) {
  var n = path$$1.getValue();

  if (n.type === "JSXElement" && isEmptyJSXElement(n)) {
    return concat$4([path$$1.call(print, "openingElement"), path$$1.call(print, "closingElement")]);
  }

  var openingLines = n.type === "JSXElement" ? path$$1.call(print, "openingElement") : path$$1.call(print, "openingFragment");
  var closingLines = n.type === "JSXElement" ? path$$1.call(print, "closingElement") : path$$1.call(print, "closingFragment");

  if (n.children.length === 1 && n.children[0].type === "JSXExpressionContainer" && (n.children[0].expression.type === "TemplateLiteral" || n.children[0].expression.type === "TaggedTemplateExpression")) {
    return concat$4([openingLines, concat$4(path$$1.map(print, "children")), closingLines]);
  } // Convert `{" "}` to text nodes containing a space.
  // This makes it easy to turn them into `jsxWhitespace` which
  // can then print as either a space or `{" "}` when breaking.


  n.children = n.children.map(function (child) {
    if (isJSXWhitespaceExpression(child)) {
      return {
        type: "JSXText",
        value: " ",
        raw: " "
      };
    }

    return child;
  });
  var containsTag = n.children.filter(isJSXNode).length > 0;
  var containsMultipleExpressions = n.children.filter(function (child) {
    return child.type === "JSXExpressionContainer";
  }).length > 1;
  var containsMultipleAttributes = n.type === "JSXElement" && n.openingElement.attributes.length > 1; // Record any breaks. Should never go from true to false, only false to true.

  var forcedBreak = willBreak$1(openingLines) || containsTag || containsMultipleAttributes || containsMultipleExpressions;
  var rawJsxWhitespace = options.singleQuote ? "{' '}" : '{" "}';
  var jsxWhitespace = ifBreak$1(concat$4([rawJsxWhitespace, softline$1]), " ");
  var isFacebookTranslationTag = n.openingElement && n.openingElement.name && n.openingElement.name.name === "fbt";
  var children = printJSXChildren(path$$1, options, print, jsxWhitespace, isFacebookTranslationTag);
  var containsText = n.children.filter(function (child) {
    return isMeaningfulJSXText(child);
  }).length > 0; // We can end up we multiple whitespace elements with empty string
  // content between them.
  // We need to remove empty whitespace and softlines before JSX whitespace
  // to get the correct output.

  for (var i = children.length - 2; i >= 0; i--) {
    var isPairOfEmptyStrings = children[i] === "" && children[i + 1] === "";
    var isPairOfHardlines = children[i] === hardline$3 && children[i + 1] === "" && children[i + 2] === hardline$3;
    var isLineFollowedByJSXWhitespace = (children[i] === softline$1 || children[i] === hardline$3) && children[i + 1] === "" && children[i + 2] === jsxWhitespace;
    var isJSXWhitespaceFollowedByLine = children[i] === jsxWhitespace && children[i + 1] === "" && (children[i + 2] === softline$1 || children[i + 2] === hardline$3);
    var isDoubleJSXWhitespace = children[i] === jsxWhitespace && children[i + 1] === "" && children[i + 2] === jsxWhitespace;
    var isPairOfHardOrSoftLines = children[i] === softline$1 && children[i + 1] === "" && children[i + 2] === hardline$3 || children[i] === hardline$3 && children[i + 1] === "" && children[i + 2] === softline$1;

    if (isPairOfHardlines && containsText || isPairOfEmptyStrings || isLineFollowedByJSXWhitespace || isDoubleJSXWhitespace || isPairOfHardOrSoftLines) {
      children.splice(i, 2);
    } else if (isJSXWhitespaceFollowedByLine) {
      children.splice(i + 1, 2);
    }
  } // Trim trailing lines (or empty strings)


  while (children.length && (isLineNext$1(getLast$3(children)) || isEmpty$1(getLast$3(children)))) {
    children.pop();
  } // Trim leading lines (or empty strings)


  while (children.length && (isLineNext$1(children[0]) || isEmpty$1(children[0])) && (isLineNext$1(children[1]) || isEmpty$1(children[1]))) {
    children.shift();
    children.shift();
  } // Tweak how we format children if outputting this element over multiple lines.
  // Also detect whether we will force this element to output over multiple lines.


  var multilineChildren = [];
  children.forEach(function (child, i) {
    // There are a number of situations where we need to ensure we display
    // whitespace as `{" "}` when outputting this element over multiple lines.
    if (child === jsxWhitespace) {
      if (i === 1 && children[i - 1] === "") {
        if (children.length === 2) {
          // Solitary whitespace
          multilineChildren.push(rawJsxWhitespace);
          return;
        } // Leading whitespace


        multilineChildren.push(concat$4([rawJsxWhitespace, hardline$3]));
        return;
      } else if (i === children.length - 1) {
        // Trailing whitespace
        multilineChildren.push(rawJsxWhitespace);
        return;
      } else if (children[i - 1] === "" && children[i - 2] === hardline$3) {
        // Whitespace after line break
        multilineChildren.push(rawJsxWhitespace);
        return;
      }
    }

    multilineChildren.push(child);

    if (willBreak$1(child)) {
      forcedBreak = true;
    }
  }); // If there is text we use `fill` to fit as much onto each line as possible.
  // When there is no text (just tags and expressions) we use `group`
  // to output each on a separate line.

  var content = containsText ? fill$2(multilineChildren) : group$1(concat$4(multilineChildren), {
    shouldBreak: true
  });
  var multiLineElem = group$1(concat$4([openingLines, indent$2(concat$4([hardline$3, content])), hardline$3, closingLines]));

  if (forcedBreak) {
    return multiLineElem;
  }

  return conditionalGroup$1([group$1(concat$4([openingLines, concat$4(children), closingLines])), multiLineElem]);
}

function maybeWrapJSXElementInParens(path$$1, elem) {
  var parent = path$$1.getParentNode();

  if (!parent) {
    return elem;
  }

  var NO_WRAP_PARENTS = {
    ArrayExpression: true,
    JSXAttribute: true,
    JSXElement: true,
    JSXExpressionContainer: true,
    JSXFragment: true,
    ExpressionStatement: true,
    CallExpression: true,
    OptionalCallExpression: true,
    ConditionalExpression: true,
    JsExpressionRoot: true
  };

  if (NO_WRAP_PARENTS[parent.type]) {
    return elem;
  }

  var shouldBreak = matchAncestorTypes$1(path$$1, ["ArrowFunctionExpression", "CallExpression", "JSXExpressionContainer"]);
  return group$1(concat$4([ifBreak$1("("), indent$2(concat$4([softline$1, elem])), softline$1, ifBreak$1(")")]), {
    shouldBreak
  });
}

function isBinaryish(node) {
  return node.type === "BinaryExpression" || node.type === "LogicalExpression" || node.type === "NGPipeExpression";
}

function isMemberish(node) {
  return node.type === "MemberExpression" || node.type === "OptionalMemberExpression" || node.type === "BindExpression" && node.object;
}

function shouldInlineLogicalExpression(node) {
  if (node.type !== "LogicalExpression") {
    return false;
  }

  if (node.right.type === "ObjectExpression" && node.right.properties.length !== 0) {
    return true;
  }

  if (node.right.type === "ArrayExpression" && node.right.elements.length !== 0) {
    return true;
  }

  if (isJSXNode(node.right)) {
    return true;
  }

  return false;
} // For binary expressions to be consistent, we need to group
// subsequent operators with the same precedence level under a single
// group. Otherwise they will be nested such that some of them break
// onto new lines but not all. Operators with the same precedence
// level should either all break or not. Because we group them by
// precedence level and the AST is structured based on precedence
// level, things are naturally broken up correctly, i.e. `&&` is
// broken before `+`.


function printBinaryishExpressions(path$$1, print, options, isNested, isInsideParenthesis) {
  var parts = [];
  var node = path$$1.getValue(); // We treat BinaryExpression and LogicalExpression nodes the same.

  if (isBinaryish(node)) {
    // Put all operators with the same precedence level in the same
    // group. The reason we only need to do this with the `left`
    // expression is because given an expression like `1 + 2 - 3`, it
    // is always parsed like `((1 + 2) - 3)`, meaning the `left` side
    // is where the rest of the expression will exist. Binary
    // expressions on the right side mean they have a difference
    // precedence level and should be treated as a separate group, so
    // print them normally. (This doesn't hold for the `**` operator,
    // which is unique in that it is right-associative.)
    if (shouldFlatten$1(node.operator, node.left.operator)) {
      // Flatten them out by recursively calling this function.
      parts = parts.concat(path$$1.call(function (left) {
        return printBinaryishExpressions(left, print, options,
        /* isNested */
        true, isInsideParenthesis);
      }, "left"));
    } else {
      parts.push(path$$1.call(print, "left"));
    }

    var shouldInline = shouldInlineLogicalExpression(node);
    var lineBeforeOperator = (node.operator === "|>" || node.type === "NGPipeExpression" || node.operator === "|" && options.parser === "__vue_expression") && !hasLeadingOwnLineComment(options.originalText, node.right, options);
    var operator = node.type === "NGPipeExpression" ? "|" : node.operator;
    var rightSuffix = node.type === "NGPipeExpression" && node.arguments.length !== 0 ? group$1(indent$2(concat$4([softline$1, ": ", join$2(concat$4([softline$1, ":", ifBreak$1(" ")]), path$$1.map(print, "arguments").map(function (arg) {
      return align$1(2, group$1(arg));
    }))]))) : "";
    var right = shouldInline ? concat$4([operator, " ", path$$1.call(print, "right"), rightSuffix]) : concat$4([lineBeforeOperator ? softline$1 : "", operator, lineBeforeOperator ? " " : line$3, path$$1.call(print, "right"), rightSuffix]); // If there's only a single binary expression, we want to create a group
    // in order to avoid having a small right part like -1 be on its own line.

    var parent = path$$1.getParentNode();
    var shouldGroup = !(isInsideParenthesis && node.type === "LogicalExpression") && parent.type !== node.type && node.left.type !== node.type && node.right.type !== node.type;
    parts.push(" ", shouldGroup ? group$1(right) : right); // The root comments are already printed, but we need to manually print
    // the other ones since we don't call the normal print on BinaryExpression,
    // only for the left and right parts

    if (isNested && node.comments) {
      parts = comments.printComments(path$$1, function () {
        return concat$4(parts);
      }, options);
    }
  } else {
    // Our stopping case. Simply print the node normally.
    parts.push(path$$1.call(print));
  }

  return parts;
}

function printAssignmentRight(leftNode, rightNode, printedRight, options) {
  if (hasLeadingOwnLineComment(options.originalText, rightNode, options)) {
    return indent$2(concat$4([hardline$3, printedRight]));
  }

  var canBreak = isBinaryish(rightNode) && !shouldInlineLogicalExpression(rightNode) || rightNode.type === "ConditionalExpression" && isBinaryish(rightNode.test) && !shouldInlineLogicalExpression(rightNode.test) || rightNode.type === "StringLiteralTypeAnnotation" || rightNode.type === "ClassExpression" && rightNode.decorators && rightNode.decorators.length || (leftNode.type === "Identifier" || isStringLiteral(leftNode) || leftNode.type === "MemberExpression") && (isStringLiteral(rightNode) || isMemberExpressionChain(rightNode)) && // do not put values on a separate line from the key in json
  options.parser !== "json" && options.parser !== "json5" || rightNode.type === "SequenceExpression";

  if (canBreak) {
    return group$1(indent$2(concat$4([line$3, printedRight])));
  }

  return concat$4([" ", printedRight]);
}

function printAssignment(leftNode, printedLeft, operator, rightNode, printedRight, options) {
  if (!rightNode) {
    return printedLeft;
  }

  var printed = printAssignmentRight(leftNode, rightNode, printedRight, options);
  return group$1(concat$4([printedLeft, operator, printed]));
}

function adjustClause(node, clause, forceSpace) {
  if (node.type === "EmptyStatement") {
    return ";";
  }

  if (node.type === "BlockStatement" || forceSpace) {
    return concat$4([" ", clause]);
  }

  return indent$2(concat$4([line$3, clause]));
}

function nodeStr(node, options, isFlowOrTypeScriptDirectiveLiteral) {
  var raw = rawText(node);
  var isDirectiveLiteral = isFlowOrTypeScriptDirectiveLiteral || node.type === "DirectiveLiteral";
  return printString$1(raw, options, isDirectiveLiteral);
}

function printRegex(node) {
  var flags = node.flags.split("").sort().join("");
  return `/${node.pattern}/${flags}`;
}

function isLastStatement(path$$1) {
  var parent = path$$1.getParentNode();

  if (!parent) {
    return true;
  }

  var node = path$$1.getValue();
  var body = (parent.body || parent.consequent).filter(function (stmt) {
    return stmt.type !== "EmptyStatement";
  });
  return body && body[body.length - 1] === node;
}

function hasLeadingComment(node) {
  return node.comments && node.comments.some(function (comment) {
    return comment.leading;
  });
}

function hasTrailingComment(node) {
  return node.comments && node.comments.some(function (comment) {
    return comment.trailing;
  });
}

function hasLeadingOwnLineComment(text, node, options) {
  if (isJSXNode(node)) {
    return hasNodeIgnoreComment$1(node);
  }

  var res = node.comments && node.comments.some(function (comment) {
    return comment.leading && hasNewline$2(text, options.locEnd(comment));
  });
  return res;
}

function isFlowAnnotationComment(text, typeAnnotation, options) {
  var start = options.locStart(typeAnnotation);
  var end = skipWhitespace$1(text, options.locEnd(typeAnnotation));
  return text.substr(start, 2) === "/*" && text.substr(end, 2) === "*/";
}

function exprNeedsASIProtection(path$$1, options) {
  var node = path$$1.getValue();
  var maybeASIProblem = needsParens_1(path$$1, options) || node.type === "ParenthesizedExpression" || node.type === "TypeCastExpression" || node.type === "ArrowFunctionExpression" && !shouldPrintParamsWithoutParens(path$$1, options) || node.type === "ArrayExpression" || node.type === "ArrayPattern" || node.type === "UnaryExpression" && node.prefix && (node.operator === "+" || node.operator === "-") || node.type === "TemplateLiteral" || node.type === "TemplateElement" || isJSXNode(node) || node.type === "BindExpression" && !node.object || node.type === "RegExpLiteral" || node.type === "Literal" && node.pattern || node.type === "Literal" && node.regex;

  if (maybeASIProblem) {
    return true;
  }

  if (!hasNakedLeftSide(node)) {
    return false;
  }

  return path$$1.call.apply(path$$1, [function (childPath) {
    return exprNeedsASIProtection(childPath, options);
  }].concat(getLeftSidePathName(path$$1, node)));
}

function stmtNeedsASIProtection(path$$1, options) {
  var node = path$$1.getNode();

  if (node.type !== "ExpressionStatement") {
    return false;
  }

  return path$$1.call(function (childPath) {
    return exprNeedsASIProtection(childPath, options);
  }, "expression");
}

function classPropMayCauseASIProblems(path$$1) {
  var node = path$$1.getNode();

  if (node.type !== "ClassProperty") {
    return false;
  }

  var name = node.key && node.key.name; // this isn't actually possible yet with most parsers available today
  // so isn't properly tested yet.

  if ((name === "static" || name === "get" || name === "set") && !node.value && !node.typeAnnotation) {
    return true;
  }
}

function classChildNeedsASIProtection(node) {
  if (!node) {
    return;
  }

  if (node.static || node.accessibility // TypeScript
  ) {
      return false;
    }

  if (!node.computed) {
    var name = node.key && node.key.name;

    if (name === "in" || name === "instanceof") {
      return true;
    }
  }

  switch (node.type) {
    case "ClassProperty":
    case "TSAbstractClassProperty":
      return node.computed;

    case "MethodDefinition": // Flow

    case "TSAbstractMethodDefinition": // TypeScript

    case "ClassMethod":
    case "ClassPrivateMethod":
      {
        // Babel
        var isAsync = node.value ? node.value.async : node.async;
        var isGenerator = node.value ? node.value.generator : node.generator;

        if (isAsync || node.kind === "get" || node.kind === "set") {
          return false;
        }

        if (node.computed || isGenerator) {
          return true;
        }

        return false;
      }

    default:
      /* istanbul ignore next */
      return false;
  }
} // This recurses the return argument, looking for the first token
// (the leftmost leaf node) and, if it (or its parents) has any
// leadingComments, returns true (so it can be wrapped in parens).


function returnArgumentHasLeadingComment(options, argument) {
  if (hasLeadingOwnLineComment(options.originalText, argument, options)) {
    return true;
  }

  if (hasNakedLeftSide(argument)) {
    var leftMost = argument;
    var newLeftMost;

    while (newLeftMost = getLeftSide(leftMost)) {
      leftMost = newLeftMost;

      if (hasLeadingOwnLineComment(options.originalText, leftMost, options)) {
        return true;
      }
    }
  }

  return false;
}

function isMemberExpressionChain(node) {
  if (node.type !== "MemberExpression" && node.type !== "OptionalMemberExpression") {
    return false;
  }

  if (node.object.type === "Identifier") {
    return true;
  }

  return isMemberExpressionChain(node.object);
} // Hack to differentiate between the following two which have the same ast
// type T = { method: () => void };
// type T = { method(): void };


function isObjectTypePropertyAFunction(node, options) {
  return (node.type === "ObjectTypeProperty" || node.type === "ObjectTypeInternalSlot") && node.value.type === "FunctionTypeAnnotation" && !node.static && !isFunctionNotation(node, options);
} // TODO: This is a bad hack and we need a better way to distinguish between
// arrow functions and otherwise


function isFunctionNotation(node, options) {
  return isGetterOrSetter(node) || sameLocStart(node, node.value, options);
}

function isGetterOrSetter(node) {
  return node.kind === "get" || node.kind === "set";
}

function sameLocStart(nodeA, nodeB, options) {
  return options.locStart(nodeA) === options.locStart(nodeB);
} // Hack to differentiate between the following two which have the same ast
// declare function f(a): void;
// var f: (a) => void;


function isTypeAnnotationAFunction(node, options) {
  return (node.type === "TypeAnnotation" || node.type === "TSTypeAnnotation") && node.typeAnnotation.type === "FunctionTypeAnnotation" && !node.static && !sameLocStart(node, node.typeAnnotation, options);
}

function isNodeStartingWithDeclare(node, options) {
  if (!(options.parser === "flow" || options.parser === "typescript")) {
    return false;
  }

  return options.originalText.slice(0, options.locStart(node)).match(/declare[ \t]*$/) || options.originalText.slice(node.range[0], node.range[1]).startsWith("declare ");
}

function shouldHugType(node) {
  if (isSimpleFlowType(node) || isObjectType(node)) {
    return true;
  }

  if (node.type === "UnionTypeAnnotation" || node.type === "TSUnionType") {
    var voidCount = node.types.filter(function (n) {
      return n.type === "VoidTypeAnnotation" || n.type === "TSVoidKeyword" || n.type === "NullLiteralTypeAnnotation" || n.type === "TSNullKeyword";
    }).length;
    var objectCount = node.types.filter(function (n) {
      return n.type === "ObjectTypeAnnotation" || n.type === "TSTypeLiteral" || // This is a bit aggressive but captures Array<{x}>
      n.type === "GenericTypeAnnotation" || n.type === "TSTypeReference";
    }).length;

    if (node.types.length - 1 === voidCount && objectCount > 0) {
      return true;
    }
  }

  return false;
}

function shouldHugArguments(fun) {
  return fun && fun.params && fun.params.length === 1 && !fun.params[0].comments && (fun.params[0].type === "ObjectPattern" || fun.params[0].type === "ArrayPattern" || fun.params[0].type === "Identifier" && fun.params[0].typeAnnotation && (fun.params[0].typeAnnotation.type === "TypeAnnotation" || fun.params[0].typeAnnotation.type === "TSTypeAnnotation") && isObjectType(fun.params[0].typeAnnotation.typeAnnotation) || fun.params[0].type === "FunctionTypeParam" && isObjectType(fun.params[0].typeAnnotation) || fun.params[0].type === "AssignmentPattern" && (fun.params[0].left.type === "ObjectPattern" || fun.params[0].left.type === "ArrayPattern") && (fun.params[0].right.type === "Identifier" || fun.params[0].right.type === "ObjectExpression" && fun.params[0].right.properties.length === 0 || fun.params[0].right.type === "ArrayExpression" && fun.params[0].right.elements.length === 0)) && !fun.rest;
}

function templateLiteralHasNewLines(template) {
  return template.quasis.some(function (quasi) {
    return quasi.value.raw.includes("\n");
  });
}

function isTemplateOnItsOwnLine(n, text, options) {
  return (n.type === "TemplateLiteral" && templateLiteralHasNewLines(n) || n.type === "TaggedTemplateExpression" && templateLiteralHasNewLines(n.quasi)) && !hasNewline$2(text, options.locStart(n), {
    backwards: true
  });
}

function printArrayItems(path$$1, options, printPath, print) {
  var printedElements = [];
  var separatorParts = [];
  path$$1.each(function (childPath) {
    printedElements.push(concat$4(separatorParts));
    printedElements.push(group$1(print(childPath)));
    separatorParts = [",", line$3];

    if (childPath.getValue() && isNextLineEmpty$2(options.originalText, childPath.getValue(), options)) {
      separatorParts.push(softline$1);
    }
  }, printPath);
  return concat$4(printedElements);
}

function hasDanglingComments(node) {
  return node.comments && node.comments.some(function (comment) {
    return !comment.leading && !comment.trailing;
  });
}

function needsHardlineAfterDanglingComment(node) {
  if (!node.comments) {
    return false;
  }

  var lastDanglingComment = getLast$3(node.comments.filter(function (comment) {
    return !comment.leading && !comment.trailing;
  }));
  return lastDanglingComment && !comments$3.isBlockComment(lastDanglingComment);
}

function isLiteral(node) {
  return node.type === "BooleanLiteral" || node.type === "DirectiveLiteral" || node.type === "Literal" || node.type === "NullLiteral" || node.type === "NumericLiteral" || node.type === "RegExpLiteral" || node.type === "StringLiteral" || node.type === "TemplateLiteral" || node.type === "TSTypeLiteral" || node.type === "JSXText";
}

function isStringPropSafeToCoerceToIdentifier(node, options) {
  return isStringLiteral(node.key) && isIdentifierName(node.key.value) && options.parser !== "json" && !(options.parser === "typescript" && node.type === "ClassProperty");
}

function isNumericLiteral(node) {
  return node.type === "NumericLiteral" || node.type === "Literal" && typeof node.value === "number";
}

function isStringLiteral(node) {
  return node.type === "StringLiteral" || node.type === "Literal" && typeof node.value === "string";
}

function isObjectType(n) {
  return n.type === "ObjectTypeAnnotation" || n.type === "TSTypeLiteral";
}

var unitTestRe = /^(skip|[fx]?(it|describe|test))$/; // eg; `describe("some string", (done) => {})`

function isTestCall(n, parent) {
  if (n.type !== "CallExpression") {
    return false;
  }

  if (n.arguments.length === 1) {
    if (isAngularTestWrapper(n) && parent && isTestCall(parent)) {
      return isFunctionOrArrowExpression(n.arguments[0]);
    }

    if (isUnitTestSetUp(n)) {
      return isAngularTestWrapper(n.arguments[0]);
    }
  } else if (n.arguments.length === 2 || n.arguments.length === 3) {
    if ((n.callee.type === "Identifier" && unitTestRe.test(n.callee.name) || isSkipOrOnlyBlock(n)) && (isTemplateLiteral(n.arguments[0]) || isStringLiteral(n.arguments[0]))) {
      // it("name", () => { ... }, 2500)
      if (n.arguments[2] && !isNumericLiteral(n.arguments[2])) {
        return false;
      }

      return (n.arguments.length === 2 ? isFunctionOrArrowExpression(n.arguments[1]) : isFunctionOrArrowExpressionWithBody(n.arguments[1]) && n.arguments[1].params.length <= 1) || isAngularTestWrapper(n.arguments[1]);
    }
  }

  return false;
}

function isSkipOrOnlyBlock(node) {
  return (node.callee.type === "MemberExpression" || node.callee.type === "OptionalMemberExpression") && node.callee.object.type === "Identifier" && node.callee.property.type === "Identifier" && unitTestRe.test(node.callee.object.name) && (node.callee.property.name === "only" || node.callee.property.name === "skip");
}

function isTemplateLiteral(node) {
  return node.type === "TemplateLiteral";
} // `inject` is used in AngularJS 1.x, `async` in Angular 2+
// example: https://docs.angularjs.org/guide/unit-testing#using-beforeall-


function isAngularTestWrapper(node) {
  return (node.type === "CallExpression" || node.type === "OptionalCallExpression") && node.callee.type === "Identifier" && (node.callee.name === "async" || node.callee.name === "inject" || node.callee.name === "fakeAsync");
}

function isFunctionOrArrowExpression(node) {
  return node.type === "FunctionExpression" || node.type === "ArrowFunctionExpression";
}

function isFunctionOrArrowExpressionWithBody(node) {
  return node.type === "FunctionExpression" || node.type === "ArrowFunctionExpression" && node.body.type === "BlockStatement";
}

function isUnitTestSetUp(n) {
  var unitTestSetUpRe = /^(before|after)(Each|All)$/;
  return n.callee.type === "Identifier" && unitTestSetUpRe.test(n.callee.name) && n.arguments.length === 1;
}

function isTheOnlyJSXElementInMarkdown(options, path$$1) {
  if (options.parentParser !== "markdown" && options.parentParser !== "mdx") {
    return false;
  }

  var node = path$$1.getNode();

  if (!node.expression || !isJSXNode(node.expression)) {
    return false;
  }

  var parent = path$$1.getParentNode();
  return parent.type === "Program" && parent.body.length == 1;
}

function willPrintOwnComments(path$$1
/*, options */
) {
  var node = path$$1.getValue();
  var parent = path$$1.getParentNode();
  return (node && (isJSXNode(node) || hasFlowShorthandAnnotationComment(node) || parent && parent.type === "CallExpression" && (hasFlowAnnotationComment(node.leadingComments) || hasFlowAnnotationComment(node.trailingComments))) || parent && (parent.type === "JSXSpreadAttribute" || parent.type === "JSXSpreadChild" || parent.type === "UnionTypeAnnotation" || parent.type === "TSUnionType" || (parent.type === "ClassDeclaration" || parent.type === "ClassExpression") && parent.superClass === node)) && !hasIgnoreComment$1(path$$1);
}

function canAttachComment(node) {
  return node.type && node.type !== "CommentBlock" && node.type !== "CommentLine" && node.type !== "Line" && node.type !== "Block" && node.type !== "EmptyStatement" && node.type !== "TemplateElement" && node.type !== "Import";
}

function printComment$1(commentPath, options) {
  var comment = commentPath.getValue();

  switch (comment.type) {
    case "CommentBlock":
    case "Block":
      {
        if (isIndentableBlockComment(comment)) {
          var printed = printIndentableBlockComment(comment); // We need to prevent an edge case of a previous trailing comment
          // printed as a `lineSuffix` which causes the comments to be
          // interleaved. See https://github.com/prettier/prettier/issues/4412

          if (comment.trailing && !hasNewline$2(options.originalText, options.locStart(comment), {
            backwards: true
          })) {
            return concat$4([hardline$3, printed]);
          }

          return printed;
        }

        var isInsideFlowComment = options.originalText.substr(options.locEnd(comment) - 3, 3) === "*-/";
        return "/*" + comment.value + (isInsideFlowComment ? "*-/" : "*/");
      }

    case "CommentLine":
    case "Line":
      // Print shebangs with the proper comment characters
      if (options.originalText.slice(options.locStart(comment)).startsWith("#!")) {
        return "#!" + comment.value.trimRight();
      }

      return "//" + comment.value.trimRight();

    default:
      throw new Error("Not a comment: " + JSON.stringify(comment));
  }
}

function isIndentableBlockComment(comment) {
  // If the comment has multiple lines and every line starts with a star
  // we can fix the indentation of each line. The stars in the `/*` and
  // `*/` delimiters are not included in the comment value, so add them
  // back first.
  var lines = `*${comment.value}*`.split("\n");
  return lines.length > 1 && lines.every(function (line) {
    return line.trim()[0] === "*";
  });
}

function printIndentableBlockComment(comment) {
  var lines = comment.value.split("\n");
  return concat$4(["/*", join$2(hardline$3, lines.map(function (line, index) {
    return index === 0 ? line.trimRight() : " " + (index < lines.length - 1 ? line.trim() : line.trimLeft());
  })), "*/"]);
}

function rawText(node) {
  return node.extra ? node.extra.raw : node.raw;
}

function identity$1(x) {
  return x;
}

var printerEstree = {
  preprocess: preprocess_1,
  print: genericPrint,
  embed: embed_1,
  insertPragma,
  massageAstNode: clean_1,
  hasPrettierIgnore,
  willPrintOwnComments,
  canAttachComment,
  printComment: printComment$1,
  isBlockComment: comments$3.isBlockComment,
  handleComments: {
    ownLine: comments$3.handleOwnLineComment,
    endOfLine: comments$3.handleEndOfLineComment,
    remaining: comments$3.handleRemainingComment
  }
};

var _require$$0$builders$2 = doc.builders;
var concat$7 = _require$$0$builders$2.concat;
var hardline$5 = _require$$0$builders$2.hardline;
var indent$4 = _require$$0$builders$2.indent;
var join$5 = _require$$0$builders$2.join;

function genericPrint$1(path$$1, options, print) {
  var node = path$$1.getValue();

  switch (node.type) {
    case "JsonRoot":
      return concat$7([path$$1.call(print, "node"), hardline$5]);

    case "ArrayExpression":
      return node.elements.length === 0 ? "[]" : concat$7(["[", indent$4(concat$7([hardline$5, join$5(concat$7([",", hardline$5]), path$$1.map(print, "elements"))])), hardline$5, "]"]);

    case "ObjectExpression":
      return node.properties.length === 0 ? "{}" : concat$7(["{", indent$4(concat$7([hardline$5, join$5(concat$7([",", hardline$5]), path$$1.map(print, "properties"))])), hardline$5, "}"]);

    case "ObjectProperty":
      return concat$7([path$$1.call(print, "key"), ": ", path$$1.call(print, "value")]);

    case "UnaryExpression":
      return concat$7([node.operator === "+" ? "" : node.operator, path$$1.call(print, "argument")]);

    case "NullLiteral":
      return "null";

    case "BooleanLiteral":
      return node.value ? "true" : "false";

    case "StringLiteral":
    case "NumericLiteral":
      return JSON.stringify(node.value);

    case "Identifier":
      return JSON.stringify(node.name);

    default:
      /* istanbul ignore next */
      throw new Error("unknown type: " + JSON.stringify(node.type));
  }
}

function clean$2(node, newNode
/*, parent*/
) {
  delete newNode.start;
  delete newNode.end;
  delete newNode.extra;
  delete newNode.loc;
  delete newNode.comments;

  if (node.type === "Identifier") {
    return {
      type: "StringLiteral",
      value: node.name
    };
  }

  if (node.type === "UnaryExpression" && node.operator === "+") {
    return newNode.argument;
  }
}

var printerEstreeJson = {
  preprocess: preprocess_1,
  print: genericPrint$1,
  massageAstNode: clean$2
};

var CATEGORY_COMMON = "Common"; // format based on https://github.com/prettier/prettier/blob/master/src/main/core-options.js

var commonOptions = {
  bracketSpacing: {
    since: "0.0.0",
    category: CATEGORY_COMMON,
    type: "boolean",
    default: true,
    description: "Print spaces between brackets.",
    oppositeDescription: "Do not print spaces between brackets."
  },
  singleQuote: {
    since: "0.0.0",
    category: CATEGORY_COMMON,
    type: "boolean",
    default: false,
    description: "Use single quotes instead of double quotes."
  },
  proseWrap: {
    since: "1.8.2",
    category: CATEGORY_COMMON,
    type: "choice",
    default: [{
      since: "1.8.2",
      value: true
    }, {
      since: "1.9.0",
      value: "preserve"
    }],
    description: "How to wrap prose.",
    choices: [{
      since: "1.9.0",
      value: "always",
      description: "Wrap prose if it exceeds the print width."
    }, {
      since: "1.9.0",
      value: "never",
      description: "Do not wrap prose."
    }, {
      since: "1.9.0",
      value: "preserve",
      description: "Wrap prose as-is."
    }, {
      value: false,
      deprecated: "1.9.0",
      redirect: "never"
    }, {
      value: true,
      deprecated: "1.9.0",
      redirect: "always"
    }]
  }
};

var CATEGORY_JAVASCRIPT = "JavaScript"; // format based on https://github.com/prettier/prettier/blob/master/src/main/core-options.js

var options$3 = {
  arrowParens: {
    since: "1.9.0",
    category: CATEGORY_JAVASCRIPT,
    type: "choice",
    default: "avoid",
    description: "Include parentheses around a sole arrow function parameter.",
    choices: [{
      value: "avoid",
      description: "Omit parens when possible. Example: `x => x`"
    }, {
      value: "always",
      description: "Always include parens. Example: `(x) => x`"
    }]
  },
  bracketSpacing: commonOptions.bracketSpacing,
  jsxBracketSameLine: {
    since: "0.17.0",
    category: CATEGORY_JAVASCRIPT,
    type: "boolean",
    default: false,
    description: "Put > on the last line instead of at a new line."
  },
  semi: {
    since: "1.0.0",
    category: CATEGORY_JAVASCRIPT,
    type: "boolean",
    default: true,
    description: "Print semicolons.",
    oppositeDescription: "Do not print semicolons, except at the beginning of lines which may need them."
  },
  singleQuote: commonOptions.singleQuote,
  jsxSingleQuote: {
    since: "1.15.0",
    category: CATEGORY_JAVASCRIPT,
    type: "boolean",
    default: false,
    description: "Use single quotes in JSX."
  },
  quoteProps: {
    since: "1.17.0",
    category: CATEGORY_JAVASCRIPT,
    type: "choice",
    default: "as-needed",
    description: "Change when properties in objects are quoted.",
    choices: [{
      value: "as-needed",
      description: "Only add quotes around object properties where required."
    }, {
      value: "consistent",
      description: "If at least one property in an object requires quotes, quote all properties."
    }, {
      value: "preserve",
      description: "Respect the input use of quotes in object properties."
    }]
  },
  trailingComma: {
    since: "0.0.0",
    category: CATEGORY_JAVASCRIPT,
    type: "choice",
    default: [{
      since: "0.0.0",
      value: false
    }, {
      since: "0.19.0",
      value: "none"
    }],
    description: "Print trailing commas wherever possible when multi-line.",
    choices: [{
      value: "none",
      description: "No trailing commas."
    }, {
      value: "es5",
      description: "Trailing commas where valid in ES5 (objects, arrays, etc.)"
    }, {
      value: "all",
      description: "Trailing commas wherever possible (including function arguments)."
    }, {
      value: true,
      deprecated: "0.19.0",
      redirect: "es5"
    }, {
      value: false,
      deprecated: "0.19.0",
      redirect: "none"
    }]
  }
};

var createLanguage = function createLanguage(linguistData, _ref) {
  var extend = _ref.extend,
      override = _ref.override;
  var language = {};

  for (var key in linguistData) {
    var newKey = key === "languageId" ? "linguistLanguageId" : key;
    language[newKey] = linguistData[key];
  }

  if (extend) {
    for (var _key in extend) {
      language[_key] = (language[_key] || []).concat(extend[_key]);
    }
  }

  for (var _key2 in override) {
    language[_key2] = override[_key2];
  }

  return language;
};

var name$1 = "JavaScript";
var type = "programming";
var tmScope = "source.js";
var aceMode = "javascript";
var codemirrorMode = "javascript";
var codemirrorMimeType = "text/javascript";
var color = "#f1e05a";
var aliases = ["js", "node"];
var extensions = [".js", "._js", ".bones", ".es", ".es6", ".frag", ".gs", ".jake", ".jsb", ".jscad", ".jsfl", ".jsm", ".jss", ".mjs", ".njs", ".pac", ".sjs", ".ssjs", ".xsjs", ".xsjslib"];
var filenames = ["Jakefile"];
var interpreters = ["node"];
var languageId = 183;
var javascript = {
  name: name$1,
  type: type,
  tmScope: tmScope,
  aceMode: aceMode,
  codemirrorMode: codemirrorMode,
  codemirrorMimeType: codemirrorMimeType,
  color: color,
  aliases: aliases,
  extensions: extensions,
  filenames: filenames,
  interpreters: interpreters,
  languageId: languageId
};

var javascript$1 = Object.freeze({
	name: name$1,
	type: type,
	tmScope: tmScope,
	aceMode: aceMode,
	codemirrorMode: codemirrorMode,
	codemirrorMimeType: codemirrorMimeType,
	color: color,
	aliases: aliases,
	extensions: extensions,
	filenames: filenames,
	interpreters: interpreters,
	languageId: languageId,
	default: javascript
});

var name$2 = "JSX";
var type$1 = "programming";
var group$3 = "JavaScript";
var extensions$1 = [".jsx"];
var tmScope$1 = "source.js.jsx";
var aceMode$1 = "javascript";
var codemirrorMode$1 = "jsx";
var codemirrorMimeType$1 = "text/jsx";
var languageId$1 = 178;
var jsx = {
  name: name$2,
  type: type$1,
  group: group$3,
  extensions: extensions$1,
  tmScope: tmScope$1,
  aceMode: aceMode$1,
  codemirrorMode: codemirrorMode$1,
  codemirrorMimeType: codemirrorMimeType$1,
  languageId: languageId$1
};

var jsx$1 = Object.freeze({
	name: name$2,
	type: type$1,
	group: group$3,
	extensions: extensions$1,
	tmScope: tmScope$1,
	aceMode: aceMode$1,
	codemirrorMode: codemirrorMode$1,
	codemirrorMimeType: codemirrorMimeType$1,
	languageId: languageId$1,
	default: jsx
});

var name$3 = "TypeScript";
var type$2 = "programming";
var color$1 = "#2b7489";
var aliases$1 = ["ts"];
var extensions$2 = [".ts", ".tsx"];
var tmScope$2 = "source.ts";
var aceMode$2 = "typescript";
var codemirrorMode$2 = "javascript";
var codemirrorMimeType$2 = "application/typescript";
var languageId$2 = 378;
var typescript = {
  name: name$3,
  type: type$2,
  color: color$1,
  aliases: aliases$1,
  extensions: extensions$2,
  tmScope: tmScope$2,
  aceMode: aceMode$2,
  codemirrorMode: codemirrorMode$2,
  codemirrorMimeType: codemirrorMimeType$2,
  languageId: languageId$2
};

var typescript$1 = Object.freeze({
	name: name$3,
	type: type$2,
	color: color$1,
	aliases: aliases$1,
	extensions: extensions$2,
	tmScope: tmScope$2,
	aceMode: aceMode$2,
	codemirrorMode: codemirrorMode$2,
	codemirrorMimeType: codemirrorMimeType$2,
	languageId: languageId$2,
	default: typescript
});

var name$4 = "JSON";
var type$3 = "data";
var tmScope$3 = "source.json";
var group$4 = "JavaScript";
var aceMode$3 = "json";
var codemirrorMode$3 = "javascript";
var codemirrorMimeType$3 = "application/json";
var searchable = false;
var extensions$3 = [".json", ".avsc", ".geojson", ".gltf", ".JSON-tmLanguage", ".jsonl", ".tfstate", ".tfstate.backup", ".topojson", ".webapp", ".webmanifest"];
var filenames$1 = [".arcconfig", ".htmlhintrc", ".tern-config", ".tern-project", "composer.lock", "mcmod.info"];
var languageId$3 = 174;
var json$2 = {
  name: name$4,
  type: type$3,
  tmScope: tmScope$3,
  group: group$4,
  aceMode: aceMode$3,
  codemirrorMode: codemirrorMode$3,
  codemirrorMimeType: codemirrorMimeType$3,
  searchable: searchable,
  extensions: extensions$3,
  filenames: filenames$1,
  languageId: languageId$3
};

var json$3 = Object.freeze({
	name: name$4,
	type: type$3,
	tmScope: tmScope$3,
	group: group$4,
	aceMode: aceMode$3,
	codemirrorMode: codemirrorMode$3,
	codemirrorMimeType: codemirrorMimeType$3,
	searchable: searchable,
	extensions: extensions$3,
	filenames: filenames$1,
	languageId: languageId$3,
	default: json$2
});

var name$5 = "JSON with Comments";
var type$4 = "data";
var group$5 = "JSON";
var tmScope$4 = "source.js";
var aceMode$4 = "javascript";
var codemirrorMode$4 = "javascript";
var codemirrorMimeType$4 = "text/javascript";
var aliases$2 = ["jsonc"];
var extensions$4 = [".sublime-build", ".sublime-commands", ".sublime-completions", ".sublime-keymap", ".sublime-macro", ".sublime-menu", ".sublime-mousemap", ".sublime-project", ".sublime-settings", ".sublime-theme", ".sublime-workspace", ".sublime_metrics", ".sublime_session"];
var filenames$2 = [".babelrc", ".eslintrc.json", ".jscsrc", ".jshintrc", ".jslintrc", "tsconfig.json"];
var languageId$4 = 423;
var jsonWithComments = {
  name: name$5,
  type: type$4,
  group: group$5,
  tmScope: tmScope$4,
  aceMode: aceMode$4,
  codemirrorMode: codemirrorMode$4,
  codemirrorMimeType: codemirrorMimeType$4,
  aliases: aliases$2,
  extensions: extensions$4,
  filenames: filenames$2,
  languageId: languageId$4
};

var jsonWithComments$1 = Object.freeze({
	name: name$5,
	type: type$4,
	group: group$5,
	tmScope: tmScope$4,
	aceMode: aceMode$4,
	codemirrorMode: codemirrorMode$4,
	codemirrorMimeType: codemirrorMimeType$4,
	aliases: aliases$2,
	extensions: extensions$4,
	filenames: filenames$2,
	languageId: languageId$4,
	default: jsonWithComments
});

var name$6 = "JSON5";
var type$5 = "data";
var extensions$5 = [".json5"];
var tmScope$5 = "source.js";
var aceMode$5 = "javascript";
var codemirrorMode$5 = "javascript";
var codemirrorMimeType$5 = "application/json";
var languageId$5 = 175;
var json5 = {
  name: name$6,
  type: type$5,
  extensions: extensions$5,
  tmScope: tmScope$5,
  aceMode: aceMode$5,
  codemirrorMode: codemirrorMode$5,
  codemirrorMimeType: codemirrorMimeType$5,
  languageId: languageId$5
};

var json5$1 = Object.freeze({
	name: name$6,
	type: type$5,
	extensions: extensions$5,
	tmScope: tmScope$5,
	aceMode: aceMode$5,
	codemirrorMode: codemirrorMode$5,
	codemirrorMimeType: codemirrorMimeType$5,
	languageId: languageId$5,
	default: json5
});

var require$$0$21 = ( javascript$1 && javascript ) || javascript$1;

var require$$1$8 = ( jsx$1 && jsx ) || jsx$1;

var require$$2$10 = ( typescript$1 && typescript ) || typescript$1;

var require$$3$3 = ( json$3 && json$2 ) || json$3;

var require$$4$2 = ( jsonWithComments$1 && jsonWithComments ) || jsonWithComments$1;

var require$$5$1 = ( json5$1 && json5 ) || json5$1;

var languages = [createLanguage(require$$0$21, {
  override: {
    since: "0.0.0",
    parsers: ["babel", "flow"],
    vscodeLanguageIds: ["javascript"]
  },
  extend: {
    interpreters: ["nodejs"]
  }
}), createLanguage(require$$0$21, {
  override: {
    name: "Flow",
    since: "0.0.0",
    parsers: ["babel", "flow"],
    vscodeLanguageIds: ["javascript"],
    aliases: [],
    filenames: [],
    extensions: [".js.flow"]
  }
}), createLanguage(require$$1$8, {
  override: {
    since: "0.0.0",
    parsers: ["babel", "flow"],
    vscodeLanguageIds: ["javascriptreact"]
  }
}), createLanguage(require$$2$10, {
  override: {
    since: "1.4.0",
    parsers: ["typescript"],
    vscodeLanguageIds: ["typescript", "typescriptreact"]
  }
}), createLanguage(require$$3$3, {
  override: {
    name: "JSON.stringify",
    since: "1.13.0",
    parsers: ["json-stringify"],
    vscodeLanguageIds: ["json"],
    extensions: [],
    // .json file defaults to json instead of json-stringify
    filenames: ["package.json", "package-lock.json", "composer.json"]
  }
}), createLanguage(require$$3$3, {
  override: {
    since: "1.5.0",
    parsers: ["json"],
    vscodeLanguageIds: ["json"]
  },
  extend: {
    filenames: [".prettierrc"]
  }
}), createLanguage(require$$4$2, {
  override: {
    since: "1.5.0",
    parsers: ["json"],
    vscodeLanguageIds: ["jsonc"]
  },
  extend: {
    filenames: [".eslintrc"]
  }
}), createLanguage(require$$5$1, {
  override: {
    since: "1.13.0",
    parsers: ["json5"],
    vscodeLanguageIds: ["json5"]
  }
})];
var printers = {
  estree: printerEstree,
  "estree-json": printerEstreeJson
};
var languageJs = {
  languages,
  options: options$3,
  printers
};

var index$12 = ["a", "abbr", "acronym", "address", "applet", "area", "article", "aside", "audio", "b", "base", "basefont", "bdi", "bdo", "bgsound", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "command", "content", "data", "datalist", "dd", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "embed", "fieldset", "figcaption", "figure", "font", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "iframe", "image", "img", "input", "ins", "isindex", "kbd", "keygen", "label", "legend", "li", "link", "listing", "main", "map", "mark", "marquee", "math", "menu", "menuitem", "meta", "meter", "multicol", "nav", "nextid", "nobr", "noembed", "noframes", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "picture", "plaintext", "pre", "progress", "q", "rb", "rbc", "rp", "rt", "rtc", "ruby", "s", "samp", "script", "section", "select", "shadow", "slot", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "svg", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "track", "tt", "u", "ul", "var", "video", "wbr", "xmp"];

var htmlTagNames = Object.freeze({
	default: index$12
});

var htmlTagNames$1 = ( htmlTagNames && index$12 ) || htmlTagNames;

function clean$3(ast, newObj, parent) {
  ["raw", // front-matter
  "raws", "sourceIndex", "source", "before", "after", "trailingComma"].forEach(function (name) {
    delete newObj[name];
  });

  if (ast.type === "yaml") {
    delete newObj.value;
  } // --insert-pragma


  if (ast.type === "css-comment" && parent.type === "css-root" && parent.nodes.length !== 0 && ( // first non-front-matter comment
  parent.nodes[0] === ast || (parent.nodes[0].type === "yaml" || parent.nodes[0].type === "toml") && parent.nodes[1] === ast)) {
    /**
     * something
     *
     * @format
     */
    delete newObj.text; // standalone pragma

    if (/^\*\s*@(format|prettier)\s*$/.test(ast.text)) {
      return null;
    }
  }

  if (ast.type === "media-query" || ast.type === "media-query-list" || ast.type === "media-feature-expression") {
    delete newObj.value;
  }

  if (ast.type === "css-rule") {
    delete newObj.params;
  }

  if (ast.type === "selector-combinator") {
    newObj.value = newObj.value.replace(/\s+/g, " ");
  }

  if (ast.type === "media-feature") {
    newObj.value = newObj.value.replace(/ /g, "");
  }

  if (ast.type === "value-word" && (ast.isColor && ast.isHex || ["initial", "inherit", "unset", "revert"].indexOf(newObj.value.replace().toLowerCase()) !== -1) || ast.type === "media-feature" || ast.type === "selector-root-invalid" || ast.type === "selector-pseudo") {
    newObj.value = newObj.value.toLowerCase();
  }

  if (ast.type === "css-decl") {
    newObj.prop = newObj.prop.toLowerCase();
  }

  if (ast.type === "css-atrule" || ast.type === "css-import") {
    newObj.name = newObj.name.toLowerCase();
  }

  if (ast.type === "value-number") {
    newObj.unit = newObj.unit.toLowerCase();
  }

  if ((ast.type === "media-feature" || ast.type === "media-keyword" || ast.type === "media-type" || ast.type === "media-unknown" || ast.type === "media-url" || ast.type === "media-value" || ast.type === "selector-attribute" || ast.type === "selector-string" || ast.type === "selector-class" || ast.type === "selector-combinator" || ast.type === "value-string") && newObj.value) {
    newObj.value = cleanCSSStrings(newObj.value);
  }

  if (ast.type === "selector-attribute") {
    newObj.attribute = newObj.attribute.trim();

    if (newObj.namespace) {
      if (typeof newObj.namespace === "string") {
        newObj.namespace = newObj.namespace.trim();

        if (newObj.namespace.length === 0) {
          newObj.namespace = true;
        }
      }
    }

    if (newObj.value) {
      newObj.value = newObj.value.trim().replace(/^['"]|['"]$/g, "");
      delete newObj.quoted;
    }
  }

  if ((ast.type === "media-value" || ast.type === "media-type" || ast.type === "value-number" || ast.type === "selector-root-invalid" || ast.type === "selector-class" || ast.type === "selector-combinator" || ast.type === "selector-tag") && newObj.value) {
    newObj.value = newObj.value.replace(/([\d.eE+-]+)([a-zA-Z]*)/g, function (match, numStr, unit) {
      var num = Number(numStr);
      return isNaN(num) ? match : num + unit.toLowerCase();
    });
  }

  if (ast.type === "selector-tag") {
    var lowercasedValue = ast.value.toLowerCase();

    if (htmlTagNames$1.indexOf(lowercasedValue) !== -1) {
      newObj.value = lowercasedValue;
    }

    if (["from", "to"].indexOf(lowercasedValue) !== -1) {
      newObj.value = lowercasedValue;
    }
  } // Workaround when `postcss-values-parser` parse `not`, `and` or `or` keywords as `value-func`


  if (ast.type === "css-atrule" && ast.name.toLowerCase() === "supports") {
    delete newObj.value;
  } // Workaround for SCSS nested properties


  if (ast.type === "selector-unknown") {
    delete newObj.value;
  }
}

function cleanCSSStrings(value) {
  return value.replace(/'/g, '"').replace(/\\([^a-fA-F\d])/g, "$1");
}

var clean_1$2 = clean$3;

var _require$$0$builders$3 = doc.builders;
var hardline$7 = _require$$0$builders$3.hardline;
var literalline$3 = _require$$0$builders$3.literalline;
var concat$9 = _require$$0$builders$3.concat;
var markAsRoot$1 = _require$$0$builders$3.markAsRoot;
var mapDoc$4 = doc.utils.mapDoc;

function embed$2(path$$1, print, textToDoc
/*, options */
) {
  var node = path$$1.getValue();

  if (node.type === "yaml") {
    return markAsRoot$1(concat$9(["---", hardline$7, node.value.trim() ? replaceNewlinesWithLiterallines(textToDoc(node.value, {
      parser: "yaml"
    })) : "", "---", hardline$7]));
  }

  return null;

  function replaceNewlinesWithLiterallines(doc$$2) {
    return mapDoc$4(doc$$2, function (currentDoc) {
      return typeof currentDoc === "string" && currentDoc.includes("\n") ? concat$9(currentDoc.split(/(\n)/g).map(function (v, i) {
        return i % 2 === 0 ? v : literalline$3;
      })) : currentDoc;
    });
  }
}

var embed_1$2 = embed$2;

var DELIMITER_MAP = {
  "---": "yaml",
  "+++": "toml"
};

function parse$5(text) {
  var delimiterRegex = Object.keys(DELIMITER_MAP).map(escapeStringRegexp).join("|");
  var match = text.match( // trailing spaces after delimiters are allowed
  new RegExp(`^(${delimiterRegex})[^\\n\\S]*\\n(?:([\\s\\S]*?)\\n)?\\1[^\\n\\S]*(\\n|$)`));

  if (match === null) {
    return {
      frontMatter: null,
      content: text
    };
  }

  var raw = match[0].replace(/\n$/, "");
  var delimiter = match[1];
  var value = match[2];
  return {
    frontMatter: {
      type: DELIMITER_MAP[delimiter],
      value,
      raw
    },
    content: match[0].replace(/[^\n]/g, " ") + text.slice(match[0].length)
  };
}

var frontMatter = parse$5;

function hasPragma$1(text) {
  return pragma.hasPragma(frontMatter(text).content);
}

function insertPragma$3(text) {
  var _parseFrontMatter = frontMatter(text),
      frontMatter$$1 = _parseFrontMatter.frontMatter,
      content = _parseFrontMatter.content;

  return (frontMatter$$1 ? frontMatter$$1.raw + "\n\n" : "") + pragma.insertPragma(content);
}

var pragma$2 = {
  hasPragma: hasPragma$1,
  insertPragma: insertPragma$3
};

var colorAdjusterFunctions = ["red", "green", "blue", "alpha", "a", "rgb", "hue", "h", "saturation", "s", "lightness", "l", "whiteness", "w", "blackness", "b", "tint", "shade", "blend", "blenda", "contrast", "hsl", "hsla", "hwb", "hwba"];

function getAncestorCounter(path$$1, typeOrTypes) {
  var types = [].concat(typeOrTypes);
  var counter = -1;
  var ancestorNode;

  while (ancestorNode = path$$1.getParentNode(++counter)) {
    if (types.indexOf(ancestorNode.type) !== -1) {
      return counter;
    }
  }

  return -1;
}

function getAncestorNode$1(path$$1, typeOrTypes) {
  var counter = getAncestorCounter(path$$1, typeOrTypes);
  return counter === -1 ? null : path$$1.getParentNode(counter);
}

function getPropOfDeclNode$1(path$$1) {
  var declAncestorNode = getAncestorNode$1(path$$1, "css-decl");
  return declAncestorNode && declAncestorNode.prop && declAncestorNode.prop.toLowerCase();
}

function isSCSS$1(parser, text) {
  var hasExplicitParserChoice = parser === "less" || parser === "scss";
  var IS_POSSIBLY_SCSS = /(\w\s*: [^}:]+|#){|@import[^\n]+(url|,)/;
  return hasExplicitParserChoice ? parser === "scss" : IS_POSSIBLY_SCSS.test(text);
}

function isWideKeywords$1(value) {
  return ["initial", "inherit", "unset", "revert"].indexOf(value.toLowerCase()) !== -1;
}

function isKeyframeAtRuleKeywords$1(path$$1, value) {
  var atRuleAncestorNode = getAncestorNode$1(path$$1, "css-atrule");
  return atRuleAncestorNode && atRuleAncestorNode.name && atRuleAncestorNode.name.toLowerCase().endsWith("keyframes") && ["from", "to"].indexOf(value.toLowerCase()) !== -1;
}

function maybeToLowerCase$1(value) {
  return value.includes("$") || value.includes("@") || value.includes("#") || value.startsWith("%") || value.startsWith("--") || value.startsWith(":--") || value.includes("(") && value.includes(")") ? value : value.toLowerCase();
}

function insideValueFunctionNode$1(path$$1, functionName) {
  var funcAncestorNode = getAncestorNode$1(path$$1, "value-func");
  return funcAncestorNode && funcAncestorNode.value && funcAncestorNode.value.toLowerCase() === functionName;
}

function insideICSSRuleNode$1(path$$1) {
  var ruleAncestorNode = getAncestorNode$1(path$$1, "css-rule");
  return ruleAncestorNode && ruleAncestorNode.raws && ruleAncestorNode.raws.selector && (ruleAncestorNode.raws.selector.startsWith(":import") || ruleAncestorNode.raws.selector.startsWith(":export"));
}

function insideAtRuleNode$1(path$$1, atRuleNameOrAtRuleNames) {
  var atRuleNames = [].concat(atRuleNameOrAtRuleNames);
  var atRuleAncestorNode = getAncestorNode$1(path$$1, "css-atrule");
  return atRuleAncestorNode && atRuleNames.indexOf(atRuleAncestorNode.name.toLowerCase()) !== -1;
}

function insideURLFunctionInImportAtRuleNode$1(path$$1) {
  var node = path$$1.getValue();
  var atRuleAncestorNode = getAncestorNode$1(path$$1, "css-atrule");
  return atRuleAncestorNode && atRuleAncestorNode.name === "import" && node.groups[0].value === "url" && node.groups.length === 2;
}

function isURLFunctionNode$1(node) {
  return node.type === "value-func" && node.value.toLowerCase() === "url";
}

function isLastNode$1(path$$1, node) {
  var parentNode = path$$1.getParentNode();

  if (!parentNode) {
    return false;
  }

  var nodes = parentNode.nodes;
  return nodes && nodes.indexOf(node) === nodes.length - 1;
}

function isHTMLTag$1(value) {
  return htmlTagNames$1.indexOf(value.toLowerCase()) !== -1;
}

function isDetachedRulesetDeclarationNode$1(node) {
  // If a Less file ends up being parsed with the SCSS parser, Less
  // variable declarations will be parsed as atrules with names ending
  // with a colon, so keep the original case then.
  if (!node.selector) {
    return false;
  }

  return typeof node.selector === "string" && /^@.+:.*$/.test(node.selector) || node.selector.value && /^@.+:.*$/.test(node.selector.value);
}

function isForKeywordNode$1(node) {
  return node.type === "value-word" && ["from", "through", "end"].indexOf(node.value) !== -1;
}

function isIfElseKeywordNode$1(node) {
  return node.type === "value-word" && ["and", "or", "not"].indexOf(node.value) !== -1;
}

function isEachKeywordNode$1(node) {
  return node.type === "value-word" && node.value === "in";
}

function isMultiplicationNode$1(node) {
  return node.type === "value-operator" && node.value === "*";
}

function isDivisionNode$1(node) {
  return node.type === "value-operator" && node.value === "/";
}

function isAdditionNode$1(node) {
  return node.type === "value-operator" && node.value === "+";
}

function isSubtractionNode$1(node) {
  return node.type === "value-operator" && node.value === "-";
}

function isModuloNode(node) {
  return node.type === "value-operator" && node.value === "%";
}

function isMathOperatorNode$1(node) {
  return isMultiplicationNode$1(node) || isDivisionNode$1(node) || isAdditionNode$1(node) || isSubtractionNode$1(node) || isModuloNode(node);
}

function isEqualityOperatorNode$1(node) {
  return node.type === "value-word" && ["==", "!="].indexOf(node.value) !== -1;
}

function isRelationalOperatorNode$1(node) {
  return node.type === "value-word" && ["<", ">", "<=", ">="].indexOf(node.value) !== -1;
}

function isSCSSControlDirectiveNode$1(node) {
  return node.type === "css-atrule" && ["if", "else", "for", "each", "while"].indexOf(node.name) !== -1;
}

function isSCSSNestedPropertyNode(node) {
  if (!node.selector) {
    return false;
  }

  return node.selector.replace(/\/\*.*?\*\//, "").replace(/\/\/.*?\n/, "").trim().endsWith(":");
}

function isDetachedRulesetCallNode$1(node) {
  return node.raws && node.raws.params && /^\(\s*\)$/.test(node.raws.params);
}

function isTemplatePlaceholderNode$1(node) {
  return node.name.startsWith("prettier-placeholder");
}

function isTemplatePropNode$1(node) {
  return node.prop.startsWith("@prettier-placeholder");
}

function isPostcssSimpleVarNode$1(currentNode, nextNode) {
  return currentNode.value === "$$" && currentNode.type === "value-func" && nextNode && nextNode.type === "value-word" && !nextNode.raws.before;
}

function hasComposesNode$1(node) {
  return node.value && node.value.type === "value-root" && node.value.group && node.value.group.type === "value-value" && node.prop.toLowerCase() === "composes";
}

function hasParensAroundNode$1(node) {
  return node.value && node.value.group && node.value.group.group && node.value.group.group.type === "value-paren_group" && node.value.group.group.open !== null && node.value.group.group.close !== null;
}

function hasEmptyRawBefore$1(node) {
  return node.raws && node.raws.before === "";
}

function isKeyValuePairNode$1(node) {
  return node.type === "value-comma_group" && node.groups && node.groups[1] && node.groups[1].type === "value-colon";
}

function isKeyValuePairInParenGroupNode(node) {
  return node.type === "value-paren_group" && node.groups && node.groups[0] && isKeyValuePairNode$1(node.groups[0]);
}

function isSCSSMapItemNode$1(path$$1) {
  var node = path$$1.getValue(); // Ignore empty item (i.e. `$key: ()`)

  if (node.groups.length === 0) {
    return false;
  }

  var parentParentNode = path$$1.getParentNode(1); // Check open parens contain key/value pair (i.e. `(key: value)` and `(key: (value, other-value)`)

  if (!isKeyValuePairInParenGroupNode(node) && !(parentParentNode && isKeyValuePairInParenGroupNode(parentParentNode))) {
    return false;
  }

  var declNode = getAncestorNode$1(path$$1, "css-decl"); // SCSS map declaration (i.e. `$map: (key: value, other-key: other-value)`)

  if (declNode && declNode.prop && declNode.prop.startsWith("$")) {
    return true;
  } // List as value of key inside SCSS map (i.e. `$map: (key: (value other-value other-other-value))`)


  if (isKeyValuePairInParenGroupNode(parentParentNode)) {
    return true;
  } // SCSS Map is argument of function (i.e. `func((key: value, other-key: other-value))`)


  if (parentParentNode.type === "value-func") {
    return true;
  }

  return false;
}

function isInlineValueCommentNode$1(node) {
  return node.type === "value-comment" && node.inline;
}

function isHashNode$1(node) {
  return node.type === "value-word" && node.value === "#";
}

function isLeftCurlyBraceNode$1(node) {
  return node.type === "value-word" && node.value === "{";
}

function isRightCurlyBraceNode$1(node) {
  return node.type === "value-word" && node.value === "}";
}

function isWordNode$1(node) {
  return ["value-word", "value-atword"].indexOf(node.type) !== -1;
}

function isColonNode$1(node) {
  return node.type === "value-colon";
}

function isMediaAndSupportsKeywords$1(node) {
  return node.value && ["not", "and", "or"].indexOf(node.value.toLowerCase()) !== -1;
}

function isColorAdjusterFuncNode$1(node) {
  if (node.type !== "value-func") {
    return false;
  }

  return colorAdjusterFunctions.indexOf(node.value.toLowerCase()) !== -1;
}

var utils$6 = {
  getAncestorCounter,
  getAncestorNode: getAncestorNode$1,
  getPropOfDeclNode: getPropOfDeclNode$1,
  maybeToLowerCase: maybeToLowerCase$1,
  insideValueFunctionNode: insideValueFunctionNode$1,
  insideICSSRuleNode: insideICSSRuleNode$1,
  insideAtRuleNode: insideAtRuleNode$1,
  insideURLFunctionInImportAtRuleNode: insideURLFunctionInImportAtRuleNode$1,
  isKeyframeAtRuleKeywords: isKeyframeAtRuleKeywords$1,
  isHTMLTag: isHTMLTag$1,
  isWideKeywords: isWideKeywords$1,
  isSCSS: isSCSS$1,
  isLastNode: isLastNode$1,
  isSCSSControlDirectiveNode: isSCSSControlDirectiveNode$1,
  isDetachedRulesetDeclarationNode: isDetachedRulesetDeclarationNode$1,
  isRelationalOperatorNode: isRelationalOperatorNode$1,
  isEqualityOperatorNode: isEqualityOperatorNode$1,
  isMultiplicationNode: isMultiplicationNode$1,
  isDivisionNode: isDivisionNode$1,
  isAdditionNode: isAdditionNode$1,
  isSubtractionNode: isSubtractionNode$1,
  isModuloNode,
  isMathOperatorNode: isMathOperatorNode$1,
  isEachKeywordNode: isEachKeywordNode$1,
  isForKeywordNode: isForKeywordNode$1,
  isURLFunctionNode: isURLFunctionNode$1,
  isIfElseKeywordNode: isIfElseKeywordNode$1,
  hasComposesNode: hasComposesNode$1,
  hasParensAroundNode: hasParensAroundNode$1,
  hasEmptyRawBefore: hasEmptyRawBefore$1,
  isSCSSNestedPropertyNode,
  isDetachedRulesetCallNode: isDetachedRulesetCallNode$1,
  isTemplatePlaceholderNode: isTemplatePlaceholderNode$1,
  isTemplatePropNode: isTemplatePropNode$1,
  isPostcssSimpleVarNode: isPostcssSimpleVarNode$1,
  isKeyValuePairNode: isKeyValuePairNode$1,
  isKeyValuePairInParenGroupNode,
  isSCSSMapItemNode: isSCSSMapItemNode$1,
  isInlineValueCommentNode: isInlineValueCommentNode$1,
  isHashNode: isHashNode$1,
  isLeftCurlyBraceNode: isLeftCurlyBraceNode$1,
  isRightCurlyBraceNode: isRightCurlyBraceNode$1,
  isWordNode: isWordNode$1,
  isColonNode: isColonNode$1,
  isMediaAndSupportsKeywords: isMediaAndSupportsKeywords$1,
  isColorAdjusterFuncNode: isColorAdjusterFuncNode$1
};

var insertPragma$2 = pragma$2.insertPragma;
var printNumber$2 = util$1.printNumber;
var printString$2 = util$1.printString;
var hasIgnoreComment$2 = util$1.hasIgnoreComment;
var hasNewline$3 = util$1.hasNewline;
var isNextLineEmpty$3 = utilShared.isNextLineEmpty;
var _require$$3$builders = doc.builders;
var concat$8 = _require$$3$builders.concat;
var join$6 = _require$$3$builders.join;
var line$5 = _require$$3$builders.line;
var hardline$6 = _require$$3$builders.hardline;
var softline$3 = _require$$3$builders.softline;
var group$6 = _require$$3$builders.group;
var fill$3 = _require$$3$builders.fill;
var indent$5 = _require$$3$builders.indent;
var dedent$3 = _require$$3$builders.dedent;
var ifBreak$2 = _require$$3$builders.ifBreak;
var removeLines$2 = doc.utils.removeLines;
var getAncestorNode = utils$6.getAncestorNode;
var getPropOfDeclNode = utils$6.getPropOfDeclNode;
var maybeToLowerCase = utils$6.maybeToLowerCase;
var insideValueFunctionNode = utils$6.insideValueFunctionNode;
var insideICSSRuleNode = utils$6.insideICSSRuleNode;
var insideAtRuleNode = utils$6.insideAtRuleNode;
var insideURLFunctionInImportAtRuleNode = utils$6.insideURLFunctionInImportAtRuleNode;
var isKeyframeAtRuleKeywords = utils$6.isKeyframeAtRuleKeywords;
var isHTMLTag = utils$6.isHTMLTag;
var isWideKeywords = utils$6.isWideKeywords;
var isSCSS = utils$6.isSCSS;
var isLastNode = utils$6.isLastNode;
var isSCSSControlDirectiveNode = utils$6.isSCSSControlDirectiveNode;
var isDetachedRulesetDeclarationNode = utils$6.isDetachedRulesetDeclarationNode;
var isRelationalOperatorNode = utils$6.isRelationalOperatorNode;
var isEqualityOperatorNode = utils$6.isEqualityOperatorNode;
var isMultiplicationNode = utils$6.isMultiplicationNode;
var isDivisionNode = utils$6.isDivisionNode;
var isAdditionNode = utils$6.isAdditionNode;
var isSubtractionNode = utils$6.isSubtractionNode;
var isMathOperatorNode = utils$6.isMathOperatorNode;
var isEachKeywordNode = utils$6.isEachKeywordNode;
var isForKeywordNode = utils$6.isForKeywordNode;
var isURLFunctionNode = utils$6.isURLFunctionNode;
var isIfElseKeywordNode = utils$6.isIfElseKeywordNode;
var hasComposesNode = utils$6.hasComposesNode;
var hasParensAroundNode = utils$6.hasParensAroundNode;
var hasEmptyRawBefore = utils$6.hasEmptyRawBefore;
var isKeyValuePairNode = utils$6.isKeyValuePairNode;
var isDetachedRulesetCallNode = utils$6.isDetachedRulesetCallNode;
var isTemplatePlaceholderNode = utils$6.isTemplatePlaceholderNode;
var isTemplatePropNode = utils$6.isTemplatePropNode;
var isPostcssSimpleVarNode = utils$6.isPostcssSimpleVarNode;
var isSCSSMapItemNode = utils$6.isSCSSMapItemNode;
var isInlineValueCommentNode = utils$6.isInlineValueCommentNode;
var isHashNode = utils$6.isHashNode;
var isLeftCurlyBraceNode = utils$6.isLeftCurlyBraceNode;
var isRightCurlyBraceNode = utils$6.isRightCurlyBraceNode;
var isWordNode = utils$6.isWordNode;
var isColonNode = utils$6.isColonNode;
var isMediaAndSupportsKeywords = utils$6.isMediaAndSupportsKeywords;
var isColorAdjusterFuncNode = utils$6.isColorAdjusterFuncNode;

function shouldPrintComma$1(options) {
  switch (options.trailingComma) {
    case "all":
    case "es5":
      return true;

    case "none":
    default:
      return false;
  }
}

function genericPrint$2(path$$1, options, print) {
  var node = path$$1.getValue();
  /* istanbul ignore if */

  if (!node) {
    return "";
  }

  if (typeof node === "string") {
    return node;
  }

  switch (node.type) {
    case "yaml":
    case "toml":
      return concat$8([node.raw, hardline$6]);

    case "css-root":
      {
        var nodes = printNodeSequence(path$$1, options, print);

        if (nodes.parts.length) {
          return concat$8([nodes, hardline$6]);
        }

        return nodes;
      }

    case "css-comment":
      {
        if (node.raws.content) {
          return node.raws.content;
        }

        var text = options.originalText.slice(options.locStart(node), options.locEnd(node));
        var rawText = node.raws.text || node.text; // Workaround a bug where the location is off.
        // https://github.com/postcss/postcss-scss/issues/63

        if (text.indexOf(rawText) === -1) {
          if (node.raws.inline) {
            return concat$8(["// ", rawText]);
          }

          return concat$8(["/* ", rawText, " */"]);
        }

        return text;
      }

    case "css-rule":
      {
        return concat$8([path$$1.call(print, "selector"), node.important ? " !important" : "", node.nodes ? concat$8([" {", node.nodes.length > 0 ? indent$5(concat$8([hardline$6, printNodeSequence(path$$1, options, print)])) : "", hardline$6, "}", isDetachedRulesetDeclarationNode(node) ? ";" : ""]) : ";"]);
      }

    case "css-decl":
      {
        var parentNode = path$$1.getParentNode();
        return concat$8([node.raws.before.replace(/[\s;]/g, ""), insideICSSRuleNode(path$$1) ? node.prop : maybeToLowerCase(node.prop), node.raws.between.trim() === ":" ? ":" : node.raws.between.trim(), node.extend ? "" : " ", hasComposesNode(node) ? removeLines$2(path$$1.call(print, "value")) : path$$1.call(print, "value"), node.raws.important ? node.raws.important.replace(/\s*!\s*important/i, " !important") : node.important ? " !important" : "", node.raws.scssDefault ? node.raws.scssDefault.replace(/\s*!default/i, " !default") : node.scssDefault ? " !default" : "", node.raws.scssGlobal ? node.raws.scssGlobal.replace(/\s*!global/i, " !global") : node.scssGlobal ? " !global" : "", node.nodes ? concat$8([" {", indent$5(concat$8([softline$3, printNodeSequence(path$$1, options, print)])), softline$3, "}"]) : isTemplatePropNode(node) && !parentNode.raws.semicolon && options.originalText[options.locEnd(node) - 1] !== ";" ? "" : ";"]);
      }

    case "css-atrule":
      {
        var _parentNode = path$$1.getParentNode();

        return concat$8(["@", // If a Less file ends up being parsed with the SCSS parser, Less
        // variable declarations will be parsed as at-rules with names ending
        // with a colon, so keep the original case then.
        isDetachedRulesetCallNode(node) || node.name.endsWith(":") ? node.name : maybeToLowerCase(node.name), node.params ? concat$8([isDetachedRulesetCallNode(node) ? "" : isTemplatePlaceholderNode(node) && /^\s*\n/.test(node.raws.afterName) ? /^\s*\n\s*\n/.test(node.raws.afterName) ? concat$8([hardline$6, hardline$6]) : hardline$6 : " ", path$$1.call(print, "params")]) : "", node.selector ? indent$5(concat$8([" ", path$$1.call(print, "selector")])) : "", node.value ? group$6(concat$8([" ", path$$1.call(print, "value"), isSCSSControlDirectiveNode(node) ? hasParensAroundNode(node) ? " " : line$5 : ""])) : node.name === "else" ? " " : "", node.nodes ? concat$8([isSCSSControlDirectiveNode(node) ? "" : " ", "{", indent$5(concat$8([node.nodes.length > 0 ? softline$3 : "", printNodeSequence(path$$1, options, print)])), softline$3, "}"]) : isTemplatePlaceholderNode(node) && !_parentNode.raws.semicolon && options.originalText[options.locEnd(node) - 1] !== ";" ? "" : ";"]);
      }
    // postcss-media-query-parser

    case "media-query-list":
      {
        var parts = [];
        path$$1.each(function (childPath) {
          var node = childPath.getValue();

          if (node.type === "media-query" && node.value === "") {
            return;
          }

          parts.push(childPath.call(print));
        }, "nodes");
        return group$6(indent$5(join$6(line$5, parts)));
      }

    case "media-query":
      {
        return concat$8([join$6(" ", path$$1.map(print, "nodes")), isLastNode(path$$1, node) ? "" : ","]);
      }

    case "media-type":
      {
        return adjustNumbers(adjustStrings(node.value, options));
      }

    case "media-feature-expression":
      {
        if (!node.nodes) {
          return node.value;
        }

        return concat$8(["(", concat$8(path$$1.map(print, "nodes")), ")"]);
      }

    case "media-feature":
      {
        return maybeToLowerCase(adjustStrings(node.value.replace(/ +/g, " "), options));
      }

    case "media-colon":
      {
        return concat$8([node.value, " "]);
      }

    case "media-value":
      {
        return adjustNumbers(adjustStrings(node.value, options));
      }

    case "media-keyword":
      {
        return adjustStrings(node.value, options);
      }

    case "media-url":
      {
        return adjustStrings(node.value.replace(/^url\(\s+/gi, "url(").replace(/\s+\)$/gi, ")"), options);
      }

    case "media-unknown":
      {
        return node.value;
      }
    // postcss-selector-parser

    case "selector-root":
      {
        return group$6(concat$8([insideAtRuleNode(path$$1, "custom-selector") ? concat$8([getAncestorNode(path$$1, "css-atrule").customSelector, line$5]) : "", join$6(concat$8([",", insideAtRuleNode(path$$1, ["extend", "custom-selector", "nest"]) ? line$5 : hardline$6]), path$$1.map(print, "nodes"))]));
      }

    case "selector-selector":
      {
        return group$6(indent$5(concat$8(path$$1.map(print, "nodes"))));
      }

    case "selector-comment":
      {
        return node.value;
      }

    case "selector-string":
      {
        return adjustStrings(node.value, options);
      }

    case "selector-tag":
      {
        var _parentNode2 = path$$1.getParentNode();

        var index = _parentNode2 && _parentNode2.nodes.indexOf(node);

        var prevNode = index && _parentNode2.nodes[index - 1];
        return concat$8([node.namespace ? concat$8([node.namespace === true ? "" : node.namespace.trim(), "|"]) : "", prevNode.type === "selector-nesting" ? node.value : adjustNumbers(isHTMLTag(node.value) || isKeyframeAtRuleKeywords(path$$1, node.value) ? node.value.toLowerCase() : node.value)]);
      }

    case "selector-id":
      {
        return concat$8(["#", node.value]);
      }

    case "selector-class":
      {
        return concat$8([".", adjustNumbers(adjustStrings(node.value, options))]);
      }

    case "selector-attribute":
      {
        return concat$8(["[", node.namespace ? concat$8([node.namespace === true ? "" : node.namespace.trim(), "|"]) : "", node.attribute.trim(), node.operator ? node.operator : "", node.value ? quoteAttributeValue(adjustStrings(node.value.trim(), options), options) : "", node.insensitive ? " i" : "", "]"]);
      }

    case "selector-combinator":
      {
        if (node.value === "+" || node.value === ">" || node.value === "~" || node.value === ">>>") {
          var _parentNode3 = path$$1.getParentNode();

          var _leading = _parentNode3.type === "selector-selector" && _parentNode3.nodes[0] === node ? "" : line$5;

          return concat$8([_leading, node.value, isLastNode(path$$1, node) ? "" : " "]);
        }

        var leading = node.value.trim().startsWith("(") ? line$5 : "";
        var value = adjustNumbers(adjustStrings(node.value.trim(), options)) || line$5;
        return concat$8([leading, value]);
      }

    case "selector-universal":
      {
        return concat$8([node.namespace ? concat$8([node.namespace === true ? "" : node.namespace.trim(), "|"]) : "", node.value]);
      }

    case "selector-pseudo":
      {
        return concat$8([maybeToLowerCase(node.value), node.nodes && node.nodes.length > 0 ? concat$8(["(", join$6(", ", path$$1.map(print, "nodes")), ")"]) : ""]);
      }

    case "selector-nesting":
      {
        return node.value;
      }

    case "selector-unknown":
      {
        var ruleAncestorNode = getAncestorNode(path$$1, "css-rule"); // Nested SCSS property

        if (ruleAncestorNode && ruleAncestorNode.isSCSSNesterProperty) {
          return adjustNumbers(adjustStrings(maybeToLowerCase(node.value), options));
        }

        return node.value;
      }
    // postcss-values-parser

    case "value-value":
    case "value-root":
      {
        return path$$1.call(print, "group");
      }

    case "value-comment":
      {
        return concat$8([node.inline ? "//" : "/*", node.value, node.inline ? "" : "*/"]);
      }

    case "value-comma_group":
      {
        var _parentNode4 = path$$1.getParentNode();

        var parentParentNode = path$$1.getParentNode(1);
        var declAncestorProp = getPropOfDeclNode(path$$1);
        var isGridValue = declAncestorProp && _parentNode4.type === "value-value" && (declAncestorProp === "grid" || declAncestorProp.startsWith("grid-template"));
        var atRuleAncestorNode = getAncestorNode(path$$1, "css-atrule");
        var isControlDirective = atRuleAncestorNode && isSCSSControlDirectiveNode(atRuleAncestorNode);
        var printed = path$$1.map(print, "groups");
        var _parts = [];
        var insideURLFunction = insideValueFunctionNode(path$$1, "url");
        var insideSCSSInterpolationInString = false;
        var didBreak = false;

        for (var i = 0; i < node.groups.length; ++i) {
          _parts.push(printed[i]); // Ignore value inside `url()`


          if (insideURLFunction) {
            continue;
          }

          var iPrevNode = node.groups[i - 1];
          var iNode = node.groups[i];
          var iNextNode = node.groups[i + 1];
          var iNextNextNode = node.groups[i + 2]; // Ignore after latest node (i.e. before semicolon)

          if (!iNextNode) {
            continue;
          } // Ignore spaces before/after string interpolation (i.e. `"#{my-fn("_")}"`)


          var isStartSCSSinterpolationInString = iNode.type === "value-string" && iNode.value.startsWith("#{");
          var isEndingSCSSinterpolationInString = insideSCSSInterpolationInString && iNextNode.type === "value-string" && iNextNode.value.endsWith("}");

          if (isStartSCSSinterpolationInString || isEndingSCSSinterpolationInString) {
            insideSCSSInterpolationInString = !insideSCSSInterpolationInString;
            continue;
          }

          if (insideSCSSInterpolationInString) {
            continue;
          } // Ignore colon (i.e. `:`)


          if (isColonNode(iNode) || isColonNode(iNextNode)) {
            continue;
          } // Ignore `@` in Less (i.e. `@@var;`)


          if (iNode.type === "value-atword" && iNode.value === "") {
            continue;
          } // Ignore `~` in Less (i.e. `content: ~"^//* some horrible but needed css hack";`)


          if (iNode.value === "~") {
            continue;
          } // Ignore escape `\`


          if (iNode.value && iNode.value.indexOf("\\") !== -1 && iNextNode && iNextNode.type !== "value-comment") {
            continue;
          } // Ignore escaped `/`


          if (iPrevNode && iPrevNode.value && iPrevNode.value.indexOf("\\") === iPrevNode.value.length - 1 && iNode.type === "value-operator" && iNode.value === "/") {
            continue;
          } // Ignore `\` (i.e. `$variable: \@small;`)


          if (iNode.value === "\\") {
            continue;
          } // Ignore `$$` (i.e. `background-color: $$(style)Color;`)


          if (isPostcssSimpleVarNode(iNode, iNextNode)) {
            continue;
          } // Ignore spaces after `#` and after `{` and before `}` in SCSS interpolation (i.e. `#{variable}`)


          if (isHashNode(iNode) || isLeftCurlyBraceNode(iNode) || isRightCurlyBraceNode(iNextNode) || isLeftCurlyBraceNode(iNextNode) && hasEmptyRawBefore(iNextNode) || isRightCurlyBraceNode(iNode) && hasEmptyRawBefore(iNextNode)) {
            continue;
          } // Ignore css variables and interpolation in SCSS (i.e. `--#{$var}`)


          if (iNode.value === "--" && isHashNode(iNextNode)) {
            continue;
          } // Formatting math operations


          var isMathOperator = isMathOperatorNode(iNode);
          var isNextMathOperator = isMathOperatorNode(iNextNode); // Print spaces before and after math operators beside SCSS interpolation as is
          // (i.e. `#{$var}+5`, `#{$var} +5`, `#{$var}+ 5`, `#{$var} + 5`)
          // (i.e. `5+#{$var}`, `5 +#{$var}`, `5+ #{$var}`, `5 + #{$var}`)

          if ((isMathOperator && isHashNode(iNextNode) || isNextMathOperator && isRightCurlyBraceNode(iNode)) && hasEmptyRawBefore(iNextNode)) {
            continue;
          } // Print spaces before and after addition and subtraction math operators as is in `calc` function
          // due to the fact that it is not valid syntax
          // (i.e. `calc(1px+1px)`, `calc(1px+ 1px)`, `calc(1px +1px)`, `calc(1px + 1px)`)


          if (insideValueFunctionNode(path$$1, "calc") && (isAdditionNode(iNode) || isAdditionNode(iNextNode) || isSubtractionNode(iNode) || isSubtractionNode(iNextNode)) && hasEmptyRawBefore(iNextNode)) {
            continue;
          } // Print spaces after `+` and `-` in color adjuster functions as is (e.g. `color(red l(+ 20%))`)
          // Adjusters with signed numbers (e.g. `color(red l(+20%))`) output as-is.


          var isColorAdjusterNode = (isAdditionNode(iNode) || isSubtractionNode(iNode)) && i === 0 && (iNextNode.type === "value-number" || iNextNode.isHex) && parentParentNode && isColorAdjusterFuncNode(parentParentNode) && !hasEmptyRawBefore(iNextNode);
          var requireSpaceBeforeOperator = iNextNextNode && iNextNextNode.type === "value-func" || iNextNextNode && isWordNode(iNextNextNode) || iNode.type === "value-func" || isWordNode(iNode);
          var requireSpaceAfterOperator = iNextNode.type === "value-func" || isWordNode(iNextNode) || iPrevNode && iPrevNode.type === "value-func" || iPrevNode && isWordNode(iPrevNode); // Formatting `/`, `+`, `-` sign

          if (!(isMultiplicationNode(iNextNode) || isMultiplicationNode(iNode)) && !insideValueFunctionNode(path$$1, "calc") && !isColorAdjusterNode && (isDivisionNode(iNextNode) && !requireSpaceBeforeOperator || isDivisionNode(iNode) && !requireSpaceAfterOperator || isAdditionNode(iNextNode) && !requireSpaceBeforeOperator || isAdditionNode(iNode) && !requireSpaceAfterOperator || isSubtractionNode(iNextNode) || isSubtractionNode(iNode)) && (hasEmptyRawBefore(iNextNode) || isMathOperator && (!iPrevNode || iPrevNode && isMathOperatorNode(iPrevNode)))) {
            continue;
          } // Add `hardline` after inline comment (i.e. `// comment\n foo: bar;`)


          if (isInlineValueCommentNode(iNode)) {
            _parts.push(hardline$6);

            continue;
          } // Handle keywords in SCSS control directive


          if (isControlDirective && (isEqualityOperatorNode(iNextNode) || isRelationalOperatorNode(iNextNode) || isIfElseKeywordNode(iNextNode) || isEachKeywordNode(iNode) || isForKeywordNode(iNode))) {
            _parts.push(" ");

            continue;
          } // At-rule `namespace` should be in one line


          if (atRuleAncestorNode && atRuleAncestorNode.name.toLowerCase() === "namespace") {
            _parts.push(" ");

            continue;
          } // Formatting `grid` property


          if (isGridValue) {
            if (iNode.source && iNextNode.source && iNode.source.start.line !== iNextNode.source.start.line) {
              _parts.push(hardline$6);

              didBreak = true;
            } else {
              _parts.push(" ");
            }

            continue;
          } // Add `space` before next math operation
          // Note: `grip` property have `/` delimiter and it is not math operation, so
          // `grid` property handles above


          if (isNextMathOperator) {
            _parts.push(" ");

            continue;
          } // Be default all values go through `line`


          _parts.push(line$5);
        }

        if (didBreak) {
          _parts.unshift(hardline$6);
        }

        if (isControlDirective) {
          return group$6(indent$5(concat$8(_parts)));
        } // Indent is not needed for import url when url is very long
        // and node has two groups
        // when type is value-comma_group
        // example @import url("verylongurl") projection,tv


        if (insideURLFunctionInImportAtRuleNode(path$$1)) {
          return group$6(fill$3(_parts));
        }

        return group$6(indent$5(fill$3(_parts)));
      }

    case "value-paren_group":
      {
        var _parentNode5 = path$$1.getParentNode();

        if (_parentNode5 && isURLFunctionNode(_parentNode5) && (node.groups.length === 1 || node.groups.length > 0 && node.groups[0].type === "value-comma_group" && node.groups[0].groups.length > 0 && node.groups[0].groups[0].type === "value-word" && node.groups[0].groups[0].value.startsWith("data:"))) {
          return concat$8([node.open ? path$$1.call(print, "open") : "", join$6(",", path$$1.map(print, "groups")), node.close ? path$$1.call(print, "close") : ""]);
        }

        if (!node.open) {
          var _printed = path$$1.map(print, "groups");

          var res = [];

          for (var _i = 0; _i < _printed.length; _i++) {
            if (_i !== 0) {
              res.push(concat$8([",", line$5]));
            }

            res.push(_printed[_i]);
          }

          return group$6(indent$5(fill$3(res)));
        }

        var isSCSSMapItem = isSCSSMapItemNode(path$$1);
        return group$6(concat$8([node.open ? path$$1.call(print, "open") : "", indent$5(concat$8([softline$3, join$6(concat$8([",", line$5]), path$$1.map(function (childPath) {
          var node = childPath.getValue();
          var printed = print(childPath); // Key/Value pair in open paren already indented

          if (isKeyValuePairNode(node) && node.type === "value-comma_group" && node.groups && node.groups[2] && node.groups[2].type === "value-paren_group") {
            printed.contents.contents.parts[1] = group$6(printed.contents.contents.parts[1]);
            return group$6(dedent$3(printed));
          }

          return printed;
        }, "groups"))])), ifBreak$2(isSCSS(options.parser, options.originalText) && isSCSSMapItem && shouldPrintComma$1(options) ? "," : ""), softline$3, node.close ? path$$1.call(print, "close") : ""]), {
          shouldBreak: isSCSSMapItem
        });
      }

    case "value-func":
      {
        return concat$8([node.value, insideAtRuleNode(path$$1, "supports") && isMediaAndSupportsKeywords(node) ? " " : "", path$$1.call(print, "group")]);
      }

    case "value-paren":
      {
        return node.value;
      }

    case "value-number":
      {
        return concat$8([printCssNumber(node.value), maybeToLowerCase(node.unit)]);
      }

    case "value-operator":
      {
        return node.value;
      }

    case "value-word":
      {
        if (node.isColor && node.isHex || isWideKeywords(node.value)) {
          return node.value.toLowerCase();
        }

        return node.value;
      }

    case "value-colon":
      {
        return concat$8([node.value, // Don't add spaces on `:` in `url` function (i.e. `url(fbglyph: cross-outline, fig-white)`)
        insideValueFunctionNode(path$$1, "url") ? "" : line$5]);
      }

    case "value-comma":
      {
        return concat$8([node.value, " "]);
      }

    case "value-string":
      {
        return printString$2(node.raws.quote + node.value + node.raws.quote, options);
      }

    case "value-atword":
      {
        return concat$8(["@", node.value]);
      }

    case "value-unicode-range":
      {
        return node.value;
      }

    case "value-unknown":
      {
        return node.value;
      }

    default:
      /* istanbul ignore next */
      throw new Error(`Unknown postcss type ${JSON.stringify(node.type)}`);
  }
}

function printNodeSequence(path$$1, options, print) {
  var node = path$$1.getValue();
  var parts = [];
  var i = 0;
  path$$1.map(function (pathChild) {
    var prevNode = node.nodes[i - 1];

    if (prevNode && prevNode.type === "css-comment" && prevNode.text.trim() === "prettier-ignore") {
      var childNode = pathChild.getValue();
      parts.push(options.originalText.slice(options.locStart(childNode), options.locEnd(childNode)));
    } else {
      parts.push(pathChild.call(print));
    }

    if (i !== node.nodes.length - 1) {
      if (node.nodes[i + 1].type === "css-comment" && !hasNewline$3(options.originalText, options.locStart(node.nodes[i + 1]), {
        backwards: true
      }) && node.nodes[i].type !== "yaml" && node.nodes[i].type !== "toml" || node.nodes[i + 1].type === "css-atrule" && node.nodes[i + 1].name === "else" && node.nodes[i].type !== "css-comment") {
        parts.push(" ");
      } else {
        parts.push(hardline$6);

        if (isNextLineEmpty$3(options.originalText, pathChild.getValue(), options) && node.nodes[i].type !== "yaml" && node.nodes[i].type !== "toml") {
          parts.push(hardline$6);
        }
      }
    }

    i++;
  }, "nodes");
  return concat$8(parts);
}

var STRING_REGEX = /(['"])(?:(?!\1)[^\\]|\\[\s\S])*\1/g;
var NUMBER_REGEX = /(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g;
var STANDARD_UNIT_REGEX = /[a-zA-Z]+/g;
var WORD_PART_REGEX = /[$@]?[a-zA-Z_\u0080-\uFFFF][\w\-\u0080-\uFFFF]*/g;
var ADJUST_NUMBERS_REGEX = RegExp(STRING_REGEX.source + `|` + `(${WORD_PART_REGEX.source})?` + `(${NUMBER_REGEX.source})` + `(${STANDARD_UNIT_REGEX.source})?`, "g");

function adjustStrings(value, options) {
  return value.replace(STRING_REGEX, function (match) {
    return printString$2(match, options);
  });
}

function quoteAttributeValue(value, options) {
  var quote = options.singleQuote ? "'" : '"';
  return value.includes('"') || value.includes("'") ? value : quote + value + quote;
}

function adjustNumbers(value) {
  return value.replace(ADJUST_NUMBERS_REGEX, function (match, quote, wordPart, number, unit) {
    return !wordPart && number ? (wordPart || "") + printCssNumber(number) + maybeToLowerCase(unit || "") : match;
  });
}

function printCssNumber(rawNumber) {
  return printNumber$2(rawNumber) // Remove trailing `.0`.
  .replace(/\.0(?=$|e)/, "");
}

var printerPostcss = {
  print: genericPrint$2,
  embed: embed_1$2,
  insertPragma: insertPragma$2,
  hasPrettierIgnore: hasIgnoreComment$2,
  massageAstNode: clean_1$2
};

var options$6 = {
  singleQuote: commonOptions.singleQuote
};

var name$7 = "CSS";
var type$6 = "markup";
var tmScope$6 = "source.css";
var aceMode$6 = "css";
var codemirrorMode$6 = "css";
var codemirrorMimeType$6 = "text/css";
var color$2 = "#563d7c";
var extensions$6 = [".css"];
var languageId$6 = 50;
var css$2 = {
  name: name$7,
  type: type$6,
  tmScope: tmScope$6,
  aceMode: aceMode$6,
  codemirrorMode: codemirrorMode$6,
  codemirrorMimeType: codemirrorMimeType$6,
  color: color$2,
  extensions: extensions$6,
  languageId: languageId$6
};

var css$3 = Object.freeze({
	name: name$7,
	type: type$6,
	tmScope: tmScope$6,
	aceMode: aceMode$6,
	codemirrorMode: codemirrorMode$6,
	codemirrorMimeType: codemirrorMimeType$6,
	color: color$2,
	extensions: extensions$6,
	languageId: languageId$6,
	default: css$2
});

var name$8 = "PostCSS";
var type$7 = "markup";
var tmScope$7 = "source.postcss";
var group$7 = "CSS";
var extensions$7 = [".pcss"];
var aceMode$7 = "text";
var languageId$7 = 262764437;
var postcss = {
  name: name$8,
  type: type$7,
  tmScope: tmScope$7,
  group: group$7,
  extensions: extensions$7,
  aceMode: aceMode$7,
  languageId: languageId$7
};

var postcss$1 = Object.freeze({
	name: name$8,
	type: type$7,
	tmScope: tmScope$7,
	group: group$7,
	extensions: extensions$7,
	aceMode: aceMode$7,
	languageId: languageId$7,
	default: postcss
});

var name$9 = "Less";
var type$8 = "markup";
var group$8 = "CSS";
var extensions$8 = [".less"];
var tmScope$8 = "source.css.less";
var aceMode$8 = "less";
var codemirrorMode$7 = "css";
var codemirrorMimeType$7 = "text/css";
var languageId$8 = 198;
var less = {
  name: name$9,
  type: type$8,
  group: group$8,
  extensions: extensions$8,
  tmScope: tmScope$8,
  aceMode: aceMode$8,
  codemirrorMode: codemirrorMode$7,
  codemirrorMimeType: codemirrorMimeType$7,
  languageId: languageId$8
};

var less$1 = Object.freeze({
	name: name$9,
	type: type$8,
	group: group$8,
	extensions: extensions$8,
	tmScope: tmScope$8,
	aceMode: aceMode$8,
	codemirrorMode: codemirrorMode$7,
	codemirrorMimeType: codemirrorMimeType$7,
	languageId: languageId$8,
	default: less
});

var name$10 = "SCSS";
var type$9 = "markup";
var tmScope$9 = "source.scss";
var group$9 = "CSS";
var aceMode$9 = "scss";
var codemirrorMode$8 = "css";
var codemirrorMimeType$8 = "text/x-scss";
var extensions$9 = [".scss"];
var languageId$9 = 329;
var scss = {
  name: name$10,
  type: type$9,
  tmScope: tmScope$9,
  group: group$9,
  aceMode: aceMode$9,
  codemirrorMode: codemirrorMode$8,
  codemirrorMimeType: codemirrorMimeType$8,
  extensions: extensions$9,
  languageId: languageId$9
};

var scss$1 = Object.freeze({
	name: name$10,
	type: type$9,
	tmScope: tmScope$9,
	group: group$9,
	aceMode: aceMode$9,
	codemirrorMode: codemirrorMode$8,
	codemirrorMimeType: codemirrorMimeType$8,
	extensions: extensions$9,
	languageId: languageId$9,
	default: scss
});

var require$$0$23 = ( css$3 && css$2 ) || css$3;

var require$$1$9 = ( postcss$1 && postcss ) || postcss$1;

var require$$2$11 = ( less$1 && less ) || less$1;

var require$$3$4 = ( scss$1 && scss ) || scss$1;

var languages$1 = [createLanguage(require$$0$23, {
  override: {
    since: "1.4.0",
    parsers: ["css"],
    vscodeLanguageIds: ["css"]
  }
}), createLanguage(require$$1$9, {
  override: {
    since: "1.4.0",
    parsers: ["css"],
    vscodeLanguageIds: ["postcss"]
  },
  extend: {
    extensions: [".postcss"]
  }
}), createLanguage(require$$2$11, {
  override: {
    since: "1.4.0",
    parsers: ["less"],
    vscodeLanguageIds: ["less"]
  }
}), createLanguage(require$$3$4, {
  override: {
    since: "1.4.0",
    parsers: ["scss"],
    vscodeLanguageIds: ["scss"]
  }
})];
var printers$1 = {
  postcss: printerPostcss
};
var languageCss = {
  languages: languages$1,
  options: options$6,
  printers: printers$1
};

var _require$$0$builders$4 = doc.builders;
var concat$10 = _require$$0$builders$4.concat;
var join$7 = _require$$0$builders$4.join;
var softline$4 = _require$$0$builders$4.softline;
var hardline$8 = _require$$0$builders$4.hardline;
var line$6 = _require$$0$builders$4.line;
var group$10 = _require$$0$builders$4.group;
var indent$6 = _require$$0$builders$4.indent;
var ifBreak$3 = _require$$0$builders$4.ifBreak; // http://w3c.github.io/html/single-page.html#void-elements

var voidTags = ["area", "base", "br", "col", "embed", "hr", "img", "input", "link", "meta", "param", "source", "track", "wbr"]; // Formatter based on @glimmerjs/syntax's built-in test formatter:
// https://github.com/glimmerjs/glimmer-vm/blob/master/packages/%40glimmer/syntax/lib/generation/print.ts

function print(path$$1, options, print) {
  var n = path$$1.getValue();
  /* istanbul ignore if*/

  if (!n) {
    return "";
  }

  switch (n.type) {
    case "Program":
      {
        return group$10(join$7(softline$4, path$$1.map(print, "body").filter(function (text) {
          return text !== "";
        })));
      }

    case "ElementNode":
      {
        var tagFirstChar = n.tag[0];
        var isLocal = n.tag.indexOf(".") !== -1;
        var isGlimmerComponent = tagFirstChar.toUpperCase() === tagFirstChar || isLocal;
        var hasChildren = n.children.length > 0;
        var isVoid = isGlimmerComponent && !hasChildren || voidTags.indexOf(n.tag) !== -1;
        var closeTagForNoBreak = isVoid ? concat$10([" />", softline$4]) : ">";
        var closeTagForBreak = isVoid ? "/>" : ">";

        var _getParams = function _getParams(path$$1, print) {
          return indent$6(concat$10([n.attributes.length ? line$6 : "", join$7(line$6, path$$1.map(print, "attributes")), n.modifiers.length ? line$6 : "", join$7(line$6, path$$1.map(print, "modifiers")), n.comments.length ? line$6 : "", join$7(line$6, path$$1.map(print, "comments"))]));
        };

        return concat$10([group$10(concat$10(["<", n.tag, _getParams(path$$1, print), n.blockParams.length ? ` as |${n.blockParams.join(" ")}|` : "", ifBreak$3(softline$4, ""), ifBreak$3(closeTagForBreak, closeTagForNoBreak)])), group$10(concat$10([indent$6(join$7(softline$4, [""].concat(path$$1.map(print, "children")))), ifBreak$3(hasChildren ? hardline$8 : "", ""), !isVoid ? concat$10(["</", n.tag, ">"]) : ""]))]);
      }

    case "BlockStatement":
      {
        var pp = path$$1.getParentNode(1);
        var isElseIf = pp && pp.inverse && pp.inverse.body.length === 1 && pp.inverse.body[0] === n && pp.inverse.body[0].path.parts[0] === "if";
        var hasElseIf = n.inverse && n.inverse.body.length === 1 && n.inverse.body[0].type === "BlockStatement" && n.inverse.body[0].path.parts[0] === "if";
        var indentElse = hasElseIf ? function (a) {
          return a;
        } : indent$6;

        if (n.inverse) {
          return concat$10([isElseIf ? concat$10(["{{else ", printPathParams(path$$1, print), "}}"]) : printOpenBlock(path$$1, print), indent$6(concat$10([hardline$8, path$$1.call(print, "program")])), n.inverse && !hasElseIf ? concat$10([hardline$8, "{{else}}"]) : "", n.inverse ? indentElse(concat$10([hardline$8, path$$1.call(print, "inverse")])) : "", isElseIf ? "" : concat$10([hardline$8, printCloseBlock(path$$1, print)])]);
        } else if (isElseIf) {
          return concat$10([concat$10(["{{else ", printPathParams(path$$1, print), "}}"]), indent$6(concat$10([hardline$8, path$$1.call(print, "program")]))]);
        }
        /**
         * I want this boolean to be: if params are going to cause a break,
         * not that it has params.
         */


        var hasParams = n.params.length > 0 || n.hash.pairs.length > 0;

        var _hasChildren = n.program.body.length > 0;

        return concat$10([printOpenBlock(path$$1, print), group$10(concat$10([indent$6(concat$10([softline$4, path$$1.call(print, "program")])), hasParams && _hasChildren ? hardline$8 : softline$4, printCloseBlock(path$$1, print)]))]);
      }

    case "ElementModifierStatement":
    case "MustacheStatement":
      {
        var _pp = path$$1.getParentNode(1);

        var isConcat = _pp && _pp.type === "ConcatStatement";
        return group$10(concat$10([n.escaped === false ? "{{{" : "{{", printPathParams(path$$1, print), isConcat ? "" : softline$4, n.escaped === false ? "}}}" : "}}"]));
      }

    case "SubExpression":
      {
        var params = getParams(path$$1, print);
        var printedParams = params.length > 0 ? indent$6(concat$10([line$6, group$10(join$7(line$6, params))])) : "";
        return group$10(concat$10(["(", printPath(path$$1, print), printedParams, softline$4, ")"]));
      }

    case "AttrNode":
      {
        var isText = n.value.type === "TextNode";

        if (isText && n.value.loc.start.column === n.value.loc.end.column) {
          return concat$10([n.name]);
        }

        var quote = isText ? '"' : "";
        return concat$10([n.name, "=", quote, path$$1.call(print, "value"), quote]);
      }

    case "ConcatStatement":
      {
        return concat$10(['"', group$10(indent$6(join$7(softline$4, path$$1.map(function (partPath) {
          return print(partPath);
        }, "parts").filter(function (a) {
          return a !== "";
        })))), '"']);
      }

    case "Hash":
      {
        return concat$10([join$7(line$6, path$$1.map(print, "pairs"))]);
      }

    case "HashPair":
      {
        return concat$10([n.key, "=", path$$1.call(print, "value")]);
      }

    case "TextNode":
      {
        var leadingSpace = "";
        var trailingSpace = ""; // preserve a space inside of an attribute node where whitespace present, when next to mustache statement.

        var inAttrNode = path$$1.stack.indexOf("attributes") >= 0;

        if (inAttrNode) {
          var parentNode = path$$1.getParentNode(0);

          var _isConcat = parentNode.type === "ConcatStatement";

          if (_isConcat) {
            var parts = parentNode.parts;
            var partIndex = parts.indexOf(n);

            if (partIndex > 0) {
              var partType = parts[partIndex - 1].type;
              var isMustache = partType === "MustacheStatement";

              if (isMustache) {
                leadingSpace = " ";
              }
            }

            if (partIndex < parts.length - 1) {
              var _partType = parts[partIndex + 1].type;

              var _isMustache = _partType === "MustacheStatement";

              if (_isMustache) {
                trailingSpace = " ";
              }
            }
          }
        }

        return n.chars.replace(/^\s+/, leadingSpace).replace(/\s+$/, trailingSpace);
      }

    case "MustacheCommentStatement":
      {
        var dashes = n.value.indexOf("}}") > -1 ? "--" : "";
        return concat$10(["{{!", dashes, n.value, dashes, "}}"]);
      }

    case "PathExpression":
      {
        return n.original;
      }

    case "BooleanLiteral":
      {
        return String(n.value);
      }

    case "CommentStatement":
      {
        return concat$10(["<!--", n.value, "-->"]);
      }

    case "StringLiteral":
      {
        return printStringLiteral(n.value, options);
      }

    case "NumberLiteral":
      {
        return String(n.value);
      }

    case "UndefinedLiteral":
      {
        return "undefined";
      }

    case "NullLiteral":
      {
        return "null";
      }

    /* istanbul ignore next */

    default:
      throw new Error("unknown glimmer type: " + JSON.stringify(n.type));
  }
}
/**
 * Prints a string literal with the correct surrounding quotes based on
 * `options.singleQuote` and the number of escaped quotes contained in
 * the string literal. This function is the glimmer equivalent of `printString`
 * in `common/util`, but has differences because of the way escaped characters
 * are treated in hbs string literals.
 * @param {string} stringLiteral - the string literal value
 * @param {object} options - the prettier options object
 */


function printStringLiteral(stringLiteral, options) {
  var double = {
    quote: '"',
    regex: /"/g
  };
  var single = {
    quote: "'",
    regex: /'/g
  };
  var preferred = options.singleQuote ? single : double;
  var alternate = preferred === single ? double : single;
  var shouldUseAlternateQuote = false; // If `stringLiteral` contains at least one of the quote preferred for
  // enclosing the string, we might want to enclose with the alternate quote
  // instead, to minimize the number of escaped quotes.

  if (stringLiteral.includes(preferred.quote) || stringLiteral.includes(alternate.quote)) {
    var numPreferredQuotes = (stringLiteral.match(preferred.regex) || []).length;
    var numAlternateQuotes = (stringLiteral.match(alternate.regex) || []).length;
    shouldUseAlternateQuote = numPreferredQuotes > numAlternateQuotes;
  }

  var enclosingQuote = shouldUseAlternateQuote ? alternate : preferred;
  var escapedStringLiteral = stringLiteral.replace(enclosingQuote.regex, `\\${enclosingQuote.quote}`);
  return `${enclosingQuote.quote}${escapedStringLiteral}${enclosingQuote.quote}`;
}

function printPath(path$$1, print) {
  return path$$1.call(print, "path");
}

function getParams(path$$1, print) {
  var node = path$$1.getValue();
  var parts = [];

  if (node.params.length > 0) {
    parts = parts.concat(path$$1.map(print, "params"));
  }

  if (node.hash && node.hash.pairs.length > 0) {
    parts.push(path$$1.call(print, "hash"));
  }

  return parts;
}

function printPathParams(path$$1, print) {
  var parts = [];
  parts.push(printPath(path$$1, print));
  parts = parts.concat(getParams(path$$1, print));
  return indent$6(group$10(join$7(line$6, parts)));
}

function printBlockParams(path$$1) {
  var block = path$$1.getValue();

  if (!block.program || !block.program.blockParams.length) {
    return "";
  }

  return concat$10([" as |", block.program.blockParams.join(" "), "|"]);
}

function printOpenBlock(path$$1, print) {
  return group$10(concat$10(["{{#", printPathParams(path$$1, print), printBlockParams(path$$1), softline$4, "}}"]));
}

function printCloseBlock(path$$1, print) {
  return concat$10(["{{/", path$$1.call(print, "path"), "}}"]);
}

function clean$5(ast, newObj) {
  delete newObj.loc; // (Glimmer/HTML) ignore TextNode whitespace

  if (ast.type === "TextNode") {
    if (ast.chars.replace(/\s+/, "") === "") {
      return null;
    }

    newObj.chars = ast.chars.replace(/^\s+/, "").replace(/\s+$/, "");
  }
}

var printerGlimmer = {
  print,
  massageAstNode: clean$5
};

var name$11 = "Handlebars";
var type$10 = "markup";
var group$11 = "HTML";
var aliases$3 = ["hbs", "htmlbars"];
var extensions$10 = [".handlebars", ".hbs"];
var tmScope$10 = "text.html.handlebars";
var aceMode$10 = "handlebars";
var languageId$10 = 155;
var handlebars = {
  name: name$11,
  type: type$10,
  group: group$11,
  aliases: aliases$3,
  extensions: extensions$10,
  tmScope: tmScope$10,
  aceMode: aceMode$10,
  languageId: languageId$10
};

var handlebars$1 = Object.freeze({
	name: name$11,
	type: type$10,
	group: group$11,
	aliases: aliases$3,
	extensions: extensions$10,
	tmScope: tmScope$10,
	aceMode: aceMode$10,
	languageId: languageId$10,
	default: handlebars
});

var require$$0$24 = ( handlebars$1 && handlebars ) || handlebars$1;

var languages$2 = [createLanguage(require$$0$24, {
  override: {
    since: null,
    // unreleased
    parsers: ["glimmer"],
    vscodeLanguageIds: ["handlebars"]
  }
})];
var printers$2 = {
  glimmer: printerGlimmer
};
var languageHandlebars = {
  languages: languages$2,
  printers: printers$2
};

function hasPragma$2(text) {
  return /^\s*#[^\n\S]*@(format|prettier)\s*(\n|$)/.test(text);
}

function insertPragma$5(text) {
  return "# @format\n\n" + text;
}

var pragma$4 = {
  hasPragma: hasPragma$2,
  insertPragma: insertPragma$5
};

var _require$$0$builders$5 = doc.builders;
var concat$11 = _require$$0$builders$5.concat;
var join$8 = _require$$0$builders$5.join;
var hardline$9 = _require$$0$builders$5.hardline;
var line$7 = _require$$0$builders$5.line;
var softline$5 = _require$$0$builders$5.softline;
var group$12 = _require$$0$builders$5.group;
var indent$7 = _require$$0$builders$5.indent;
var ifBreak$4 = _require$$0$builders$5.ifBreak;
var hasIgnoreComment$3 = util$1.hasIgnoreComment;
var isNextLineEmpty$4 = utilShared.isNextLineEmpty;
var insertPragma$4 = pragma$4.insertPragma;

function genericPrint$3(path$$1, options, print) {
  var n = path$$1.getValue();

  if (!n) {
    return "";
  }

  if (typeof n === "string") {
    return n;
  }

  switch (n.kind) {
    case "Document":
      {
        var parts = [];
        path$$1.map(function (pathChild, index) {
          parts.push(concat$11([pathChild.call(print)]));

          if (index !== n.definitions.length - 1) {
            parts.push(hardline$9);

            if (isNextLineEmpty$4(options.originalText, pathChild.getValue(), options)) {
              parts.push(hardline$9);
            }
          }
        }, "definitions");
        return concat$11([concat$11(parts), hardline$9]);
      }

    case "OperationDefinition":
      {
        var hasOperation = options.originalText[options.locStart(n)] !== "{";
        var hasName = !!n.name;
        return concat$11([hasOperation ? n.operation : "", hasOperation && hasName ? concat$11([" ", path$$1.call(print, "name")]) : "", n.variableDefinitions && n.variableDefinitions.length ? group$12(concat$11(["(", indent$7(concat$11([softline$5, join$8(concat$11([ifBreak$4("", ", "), softline$5]), path$$1.map(print, "variableDefinitions"))])), softline$5, ")"])) : "", printDirectives(path$$1, print, n), n.selectionSet ? !hasOperation && !hasName ? "" : " " : "", path$$1.call(print, "selectionSet")]);
      }

    case "FragmentDefinition":
      {
        return concat$11(["fragment ", path$$1.call(print, "name"), n.variableDefinitions && n.variableDefinitions.length ? group$12(concat$11(["(", indent$7(concat$11([softline$5, join$8(concat$11([ifBreak$4("", ", "), softline$5]), path$$1.map(print, "variableDefinitions"))])), softline$5, ")"])) : "", " on ", path$$1.call(print, "typeCondition"), printDirectives(path$$1, print, n), " ", path$$1.call(print, "selectionSet")]);
      }

    case "SelectionSet":
      {
        return concat$11(["{", indent$7(concat$11([hardline$9, join$8(hardline$9, path$$1.call(function (selectionsPath) {
          return printSequence(selectionsPath, options, print);
        }, "selections"))])), hardline$9, "}"]);
      }

    case "Field":
      {
        return group$12(concat$11([n.alias ? concat$11([path$$1.call(print, "alias"), ": "]) : "", path$$1.call(print, "name"), n.arguments.length > 0 ? group$12(concat$11(["(", indent$7(concat$11([softline$5, join$8(concat$11([ifBreak$4("", ", "), softline$5]), path$$1.call(function (argsPath) {
          return printSequence(argsPath, options, print);
        }, "arguments"))])), softline$5, ")"])) : "", printDirectives(path$$1, print, n), n.selectionSet ? " " : "", path$$1.call(print, "selectionSet")]));
      }

    case "Name":
      {
        return n.value;
      }

    case "StringValue":
      {
        if (n.block) {
          return concat$11(['"""', hardline$9, join$8(hardline$9, n.value.replace(/"""/g, "\\$&").split("\n")), hardline$9, '"""']);
        }

        return concat$11(['"', n.value.replace(/["\\]/g, "\\$&").replace(/\n/g, "\\n"), '"']);
      }

    case "IntValue":
    case "FloatValue":
    case "EnumValue":
      {
        return n.value;
      }

    case "BooleanValue":
      {
        return n.value ? "true" : "false";
      }

    case "NullValue":
      {
        return "null";
      }

    case "Variable":
      {
        return concat$11(["$", path$$1.call(print, "name")]);
      }

    case "ListValue":
      {
        return group$12(concat$11(["[", indent$7(concat$11([softline$5, join$8(concat$11([ifBreak$4("", ", "), softline$5]), path$$1.map(print, "values"))])), softline$5, "]"]));
      }

    case "ObjectValue":
      {
        return group$12(concat$11(["{", options.bracketSpacing && n.fields.length > 0 ? " " : "", indent$7(concat$11([softline$5, join$8(concat$11([ifBreak$4("", ", "), softline$5]), path$$1.map(print, "fields"))])), softline$5, ifBreak$4("", options.bracketSpacing && n.fields.length > 0 ? " " : ""), "}"]));
      }

    case "ObjectField":
    case "Argument":
      {
        return concat$11([path$$1.call(print, "name"), ": ", path$$1.call(print, "value")]);
      }

    case "Directive":
      {
        return concat$11(["@", path$$1.call(print, "name"), n.arguments.length > 0 ? group$12(concat$11(["(", indent$7(concat$11([softline$5, join$8(concat$11([ifBreak$4("", ", "), softline$5]), path$$1.call(function (argsPath) {
          return printSequence(argsPath, options, print);
        }, "arguments"))])), softline$5, ")"])) : ""]);
      }

    case "NamedType":
      {
        return path$$1.call(print, "name");
      }

    case "VariableDefinition":
      {
        return concat$11([path$$1.call(print, "variable"), ": ", path$$1.call(print, "type"), n.defaultValue ? concat$11([" = ", path$$1.call(print, "defaultValue")]) : "", printDirectives(path$$1, print, n)]);
      }

    case "TypeExtensionDefinition":
      {
        return concat$11(["extend ", path$$1.call(print, "definition")]);
      }

    case "ObjectTypeExtension":
    case "ObjectTypeDefinition":
      {
        return concat$11([path$$1.call(print, "description"), n.description ? hardline$9 : "", n.kind === "ObjectTypeExtension" ? "extend " : "", "type ", path$$1.call(print, "name"), n.interfaces.length > 0 ? concat$11([" implements ", join$8(determineInterfaceSeparator(options.originalText.substr(options.locStart(n), options.locEnd(n))), path$$1.map(print, "interfaces"))]) : "", printDirectives(path$$1, print, n), n.fields.length > 0 ? concat$11([" {", indent$7(concat$11([hardline$9, join$8(hardline$9, path$$1.call(function (fieldsPath) {
          return printSequence(fieldsPath, options, print);
        }, "fields"))])), hardline$9, "}"]) : ""]);
      }

    case "FieldDefinition":
      {
        return concat$11([path$$1.call(print, "description"), n.description ? hardline$9 : "", path$$1.call(print, "name"), n.arguments.length > 0 ? group$12(concat$11(["(", indent$7(concat$11([softline$5, join$8(concat$11([ifBreak$4("", ", "), softline$5]), path$$1.call(function (argsPath) {
          return printSequence(argsPath, options, print);
        }, "arguments"))])), softline$5, ")"])) : "", ": ", path$$1.call(print, "type"), printDirectives(path$$1, print, n)]);
      }

    case "DirectiveDefinition":
      {
        return concat$11([path$$1.call(print, "description"), n.description ? hardline$9 : "", "directive ", "@", path$$1.call(print, "name"), n.arguments.length > 0 ? group$12(concat$11(["(", indent$7(concat$11([softline$5, join$8(concat$11([ifBreak$4("", ", "), softline$5]), path$$1.call(function (argsPath) {
          return printSequence(argsPath, options, print);
        }, "arguments"))])), softline$5, ")"])) : "", concat$11([" on ", join$8(" | ", path$$1.map(print, "locations"))])]);
      }

    case "EnumTypeExtension":
    case "EnumTypeDefinition":
      {
        return concat$11([path$$1.call(print, "description"), n.description ? hardline$9 : "", n.kind === "EnumTypeExtension" ? "extend " : "", "enum ", path$$1.call(print, "name"), printDirectives(path$$1, print, n), n.values.length > 0 ? concat$11([" {", indent$7(concat$11([hardline$9, join$8(hardline$9, path$$1.call(function (valuesPath) {
          return printSequence(valuesPath, options, print);
        }, "values"))])), hardline$9, "}"]) : ""]);
      }

    case "EnumValueDefinition":
      {
        return concat$11([path$$1.call(print, "description"), n.description ? hardline$9 : "", path$$1.call(print, "name"), printDirectives(path$$1, print, n)]);
      }

    case "InputValueDefinition":
      {
        return concat$11([path$$1.call(print, "description"), n.description ? n.description.block ? hardline$9 : line$7 : "", path$$1.call(print, "name"), ": ", path$$1.call(print, "type"), n.defaultValue ? concat$11([" = ", path$$1.call(print, "defaultValue")]) : "", printDirectives(path$$1, print, n)]);
      }

    case "InputObjectTypeExtension":
    case "InputObjectTypeDefinition":
      {
        return concat$11([path$$1.call(print, "description"), n.description ? hardline$9 : "", n.kind === "InputObjectTypeExtension" ? "extend " : "", "input ", path$$1.call(print, "name"), printDirectives(path$$1, print, n), n.fields.length > 0 ? concat$11([" {", indent$7(concat$11([hardline$9, join$8(hardline$9, path$$1.call(function (fieldsPath) {
          return printSequence(fieldsPath, options, print);
        }, "fields"))])), hardline$9, "}"]) : ""]);
      }

    case "SchemaDefinition":
      {
        return concat$11(["schema", printDirectives(path$$1, print, n), " {", n.operationTypes.length > 0 ? indent$7(concat$11([hardline$9, join$8(hardline$9, path$$1.call(function (opsPath) {
          return printSequence(opsPath, options, print);
        }, "operationTypes"))])) : "", hardline$9, "}"]);
      }

    case "OperationTypeDefinition":
      {
        return concat$11([path$$1.call(print, "operation"), ": ", path$$1.call(print, "type")]);
      }

    case "InterfaceTypeExtension":
    case "InterfaceTypeDefinition":
      {
        return concat$11([path$$1.call(print, "description"), n.description ? hardline$9 : "", n.kind === "InterfaceTypeExtension" ? "extend " : "", "interface ", path$$1.call(print, "name"), printDirectives(path$$1, print, n), n.fields.length > 0 ? concat$11([" {", indent$7(concat$11([hardline$9, join$8(hardline$9, path$$1.call(function (fieldsPath) {
          return printSequence(fieldsPath, options, print);
        }, "fields"))])), hardline$9, "}"]) : ""]);
      }

    case "FragmentSpread":
      {
        return concat$11(["...", path$$1.call(print, "name"), printDirectives(path$$1, print, n)]);
      }

    case "InlineFragment":
      {
        return concat$11(["...", n.typeCondition ? concat$11([" on ", path$$1.call(print, "typeCondition")]) : "", printDirectives(path$$1, print, n), " ", path$$1.call(print, "selectionSet")]);
      }

    case "UnionTypeExtension":
    case "UnionTypeDefinition":
      {
        return group$12(concat$11([path$$1.call(print, "description"), n.description ? hardline$9 : "", group$12(concat$11([n.kind === "UnionTypeExtension" ? "extend " : "", "union ", path$$1.call(print, "name"), printDirectives(path$$1, print, n), n.types.length > 0 ? concat$11([" =", ifBreak$4("", " "), indent$7(concat$11([ifBreak$4(concat$11([line$7, "  "])), join$8(concat$11([line$7, "| "]), path$$1.map(print, "types"))]))]) : ""]))]));
      }

    case "ScalarTypeExtension":
    case "ScalarTypeDefinition":
      {
        return concat$11([path$$1.call(print, "description"), n.description ? hardline$9 : "", n.kind === "ScalarTypeExtension" ? "extend " : "", "scalar ", path$$1.call(print, "name"), printDirectives(path$$1, print, n)]);
      }

    case "NonNullType":
      {
        return concat$11([path$$1.call(print, "type"), "!"]);
      }

    case "ListType":
      {
        return concat$11(["[", path$$1.call(print, "type"), "]"]);
      }

    default:
      /* istanbul ignore next */
      throw new Error("unknown graphql type: " + JSON.stringify(n.kind));
  }
}

function printDirectives(path$$1, print, n) {
  if (n.directives.length === 0) {
    return "";
  }

  return concat$11([" ", group$12(indent$7(concat$11([softline$5, join$8(concat$11([ifBreak$4("", " "), softline$5]), path$$1.map(print, "directives"))])))]);
}

function printSequence(sequencePath, options, print) {
  var count = sequencePath.getValue().length;
  return sequencePath.map(function (path$$1, i) {
    var printed = print(path$$1);

    if (isNextLineEmpty$4(options.originalText, path$$1.getValue(), options) && i < count - 1) {
      return concat$11([printed, hardline$9]);
    }

    return printed;
  });
}

function canAttachComment$1(node) {
  return node.kind && node.kind !== "Comment";
}

function printComment$2(commentPath) {
  var comment = commentPath.getValue();

  if (comment.kind === "Comment") {
    return "#" + comment.value.trimRight();
  }

  throw new Error("Not a comment: " + JSON.stringify(comment));
}

function determineInterfaceSeparator(originalSource) {
  var start = originalSource.indexOf("implements");

  if (start === -1) {
    throw new Error("Must implement interfaces: " + originalSource);
  }

  var end = originalSource.indexOf("{");

  if (end === -1) {
    end = originalSource.length;
  }

  return originalSource.substr(start, end).includes("&") ? " & " : ", ";
}

function clean$6(node, newNode
/*, parent*/
) {
  delete newNode.loc;
  delete newNode.comments;
}

var printerGraphql = {
  print: genericPrint$3,
  massageAstNode: clean$6,
  hasPrettierIgnore: hasIgnoreComment$3,
  insertPragma: insertPragma$4,
  printComment: printComment$2,
  canAttachComment: canAttachComment$1
};

var options$9 = {
  bracketSpacing: commonOptions.bracketSpacing
};

var name$12 = "GraphQL";
var type$11 = "data";
var extensions$11 = [".graphql", ".gql"];
var tmScope$11 = "source.graphql";
var aceMode$11 = "text";
var languageId$11 = 139;
var graphql = {
  name: name$12,
  type: type$11,
  extensions: extensions$11,
  tmScope: tmScope$11,
  aceMode: aceMode$11,
  languageId: languageId$11
};

var graphql$1 = Object.freeze({
	name: name$12,
	type: type$11,
	extensions: extensions$11,
	tmScope: tmScope$11,
	aceMode: aceMode$11,
	languageId: languageId$11,
	default: graphql
});

var require$$0$25 = ( graphql$1 && graphql ) || graphql$1;

var languages$3 = [createLanguage(require$$0$25, {
  override: {
    since: "1.5.0",
    parsers: ["graphql"],
    vscodeLanguageIds: ["graphql"]
  }
})];
var printers$3 = {
  graphql: printerGraphql
};
var languageGraphql = {
  languages: languages$3,
  options: options$9,
  printers: printers$3
};

var json$6 = {"cjkPattern":"[\\u02ea-\\u02eb\\u1100-\\u11ff\\u2e80-\\u2e99\\u2e9b-\\u2ef3\\u2f00-\\u2fd5\\u3000-\\u303f\\u3041-\\u3096\\u3099-\\u309f\\u30a1-\\u30fa\\u30fc-\\u30ff\\u3105-\\u312e\\u3131-\\u318e\\u3190-\\u3191\\u3196-\\u31ba\\u31c0-\\u31e3\\u31f0-\\u321e\\u322a-\\u3247\\u3260-\\u327e\\u328a-\\u32b0\\u32c0-\\u32cb\\u32d0-\\u32fe\\u3300-\\u3370\\u337b-\\u337f\\u33e0-\\u33fe\\u3400-\\u4db5\\u4e00-\\u9fea\\ua960-\\ua97c\\uac00-\\ud7a3\\ud7b0-\\ud7c6\\ud7cb-\\ud7fb\\uf900-\\ufa6d\\ufa70-\\ufad9\\ufe10-\\ufe1f\\ufe30-\\ufe6f\\uff00-\\uffef]|[\\ud840-\\ud868\\ud86a-\\ud86c\\ud86f-\\ud872\\ud874-\\ud879][\\udc00-\\udfff]|\\ud82c[\\udc00-\\udd1e]|\\ud83c[\\ude00\\ude50-\\ude51]|\\ud869[\\udc00-\\uded6\\udf00-\\udfff]|\\ud86d[\\udc00-\\udf34\\udf40-\\udfff]|\\ud86e[\\udc00-\\udc1d\\udc20-\\udfff]|\\ud873[\\udc00-\\udea1\\udeb0-\\udfff]|\\ud87a[\\udc00-\\udfe0]|\\ud87e[\\udc00-\\ude1d]","kPattern":"[\\u1100-\\u11ff\\u3001-\\u3003\\u3008-\\u3011\\u3013-\\u301f\\u302e-\\u3030\\u3037\\u30fb\\u3131-\\u318e\\u3200-\\u321e\\u3260-\\u327e\\ua960-\\ua97c\\uac00-\\ud7a3\\ud7b0-\\ud7c6\\ud7cb-\\ud7fb\\ufe45-\\ufe46\\uff61-\\uff65\\uffa0-\\uffbe\\uffc2-\\uffc7\\uffca-\\uffcf\\uffd2-\\uffd7\\uffda-\\uffdc]","punctuationPattern":"[\\u0021-\\u002f\\u003a-\\u0040\\u005b-\\u0060\\u007b-\\u007e\\u00a1\\u00a7\\u00ab\\u00b6-\\u00b7\\u00bb\\u00bf\\u037e\\u0387\\u055a-\\u055f\\u0589-\\u058a\\u05be\\u05c0\\u05c3\\u05c6\\u05f3-\\u05f4\\u0609-\\u060a\\u060c-\\u060d\\u061b\\u061e-\\u061f\\u066a-\\u066d\\u06d4\\u0700-\\u070d\\u07f7-\\u07f9\\u0830-\\u083e\\u085e\\u0964-\\u0965\\u0970\\u09fd\\u0af0\\u0df4\\u0e4f\\u0e5a-\\u0e5b\\u0f04-\\u0f12\\u0f14\\u0f3a-\\u0f3d\\u0f85\\u0fd0-\\u0fd4\\u0fd9-\\u0fda\\u104a-\\u104f\\u10fb\\u1360-\\u1368\\u1400\\u166d-\\u166e\\u169b-\\u169c\\u16eb-\\u16ed\\u1735-\\u1736\\u17d4-\\u17d6\\u17d8-\\u17da\\u1800-\\u180a\\u1944-\\u1945\\u1a1e-\\u1a1f\\u1aa0-\\u1aa6\\u1aa8-\\u1aad\\u1b5a-\\u1b60\\u1bfc-\\u1bff\\u1c3b-\\u1c3f\\u1c7e-\\u1c7f\\u1cc0-\\u1cc7\\u1cd3\\u2010-\\u2027\\u2030-\\u2043\\u2045-\\u2051\\u2053-\\u205e\\u207d-\\u207e\\u208d-\\u208e\\u2308-\\u230b\\u2329-\\u232a\\u2768-\\u2775\\u27c5-\\u27c6\\u27e6-\\u27ef\\u2983-\\u2998\\u29d8-\\u29db\\u29fc-\\u29fd\\u2cf9-\\u2cfc\\u2cfe-\\u2cff\\u2d70\\u2e00-\\u2e2e\\u2e30-\\u2e49\\u3001-\\u3003\\u3008-\\u3011\\u3014-\\u301f\\u3030\\u303d\\u30a0\\u30fb\\ua4fe-\\ua4ff\\ua60d-\\ua60f\\ua673\\ua67e\\ua6f2-\\ua6f7\\ua874-\\ua877\\ua8ce-\\ua8cf\\ua8f8-\\ua8fa\\ua8fc\\ua92e-\\ua92f\\ua95f\\ua9c1-\\ua9cd\\ua9de-\\ua9df\\uaa5c-\\uaa5f\\uaade-\\uaadf\\uaaf0-\\uaaf1\\uabeb\\ufd3e-\\ufd3f\\ufe10-\\ufe19\\ufe30-\\ufe52\\ufe54-\\ufe61\\ufe63\\ufe68\\ufe6a-\\ufe6b\\uff01-\\uff03\\uff05-\\uff0a\\uff0c-\\uff0f\\uff1a-\\uff1b\\uff1f-\\uff20\\uff3b-\\uff3d\\uff3f\\uff5b\\uff5d\\uff5f-\\uff65]|\\ud800[\\udd00-\\udd02\\udf9f\\udfd0]|\\ud801[\\udd6f]|\\ud802[\\udc57\\udd1f\\udd3f\\ude50-\\ude58\\ude7f\\udef0-\\udef6\\udf39-\\udf3f\\udf99-\\udf9c]|\\ud804[\\udc47-\\udc4d\\udcbb-\\udcbc\\udcbe-\\udcc1\\udd40-\\udd43\\udd74-\\udd75\\uddc5-\\uddc9\\uddcd\\udddb\\udddd-\\udddf\\ude38-\\ude3d\\udea9]|\\ud805[\\udc4b-\\udc4f\\udc5b\\udc5d\\udcc6\\uddc1-\\uddd7\\ude41-\\ude43\\ude60-\\ude6c\\udf3c-\\udf3e]|\\ud806[\\ude3f-\\ude46\\ude9a-\\ude9c\\ude9e-\\udea2]|\\ud807[\\udc41-\\udc45\\udc70-\\udc71]|\\ud809[\\udc70-\\udc74]|\\ud81a[\\ude6e-\\ude6f\\udef5\\udf37-\\udf3b\\udf44]|\\ud82f[\\udc9f]|\\ud836[\\ude87-\\ude8b]|\\ud83a[\\udd5e-\\udd5f]"};

var cjkPattern = json$6.cjkPattern;
var kPattern = json$6.kPattern;
var punctuationPattern$1 = json$6.punctuationPattern;
var getLast$4 = util$1.getLast;
var INLINE_NODE_TYPES$1 = ["liquidNode", "inlineCode", "emphasis", "strong", "delete", "link", "linkReference", "image", "imageReference", "footnote", "footnoteReference", "sentence", "whitespace", "word", "break", "inlineMath"];
var INLINE_NODE_WRAPPER_TYPES$1 = INLINE_NODE_TYPES$1.concat(["tableCell", "paragraph", "heading"]);
var kRegex = new RegExp(kPattern);
var punctuationRegex = new RegExp(punctuationPattern$1);
/**
 * split text into whitespaces and words
 * @param {string} text
 * @return {Array<{ type: "whitespace", value: " " | "\n" | "" } | { type: "word", value: string }>}
 */

function splitText$1(text, options) {
  var KIND_NON_CJK = "non-cjk";
  var KIND_CJ_LETTER = "cj-letter";
  var KIND_K_LETTER = "k-letter";
  var KIND_CJK_PUNCTUATION = "cjk-punctuation";
  var nodes = [];
  (options.proseWrap === "preserve" ? text : text.replace(new RegExp(`(${cjkPattern})\n(${cjkPattern})`, "g"), "$1$2")).split(/([ \t\n]+)/).forEach(function (token, index, tokens) {
    // whitespace
    if (index % 2 === 1) {
      nodes.push({
        type: "whitespace",
        value: /\n/.test(token) ? "\n" : " "
      });
      return;
    } // word separated by whitespace


    if ((index === 0 || index === tokens.length - 1) && token === "") {
      return;
    }

    token.split(new RegExp(`(${cjkPattern})`)).forEach(function (innerToken, innerIndex, innerTokens) {
      if ((innerIndex === 0 || innerIndex === innerTokens.length - 1) && innerToken === "") {
        return;
      } // non-CJK word


      if (innerIndex % 2 === 0) {
        if (innerToken !== "") {
          appendNode({
            type: "word",
            value: innerToken,
            kind: KIND_NON_CJK,
            hasLeadingPunctuation: punctuationRegex.test(innerToken[0]),
            hasTrailingPunctuation: punctuationRegex.test(getLast$4(innerToken))
          });
        }

        return;
      } // CJK character


      appendNode(punctuationRegex.test(innerToken) ? {
        type: "word",
        value: innerToken,
        kind: KIND_CJK_PUNCTUATION,
        hasLeadingPunctuation: true,
        hasTrailingPunctuation: true
      } : {
        type: "word",
        value: innerToken,
        kind: kRegex.test(innerToken) ? KIND_K_LETTER : KIND_CJ_LETTER,
        hasLeadingPunctuation: false,
        hasTrailingPunctuation: false
      });
    });
  });
  return nodes;

  function appendNode(node) {
    var lastNode = getLast$4(nodes);

    if (lastNode && lastNode.type === "word") {
      if (lastNode.kind === KIND_NON_CJK && node.kind === KIND_CJ_LETTER && !lastNode.hasTrailingPunctuation || lastNode.kind === KIND_CJ_LETTER && node.kind === KIND_NON_CJK && !node.hasLeadingPunctuation) {
        nodes.push({
          type: "whitespace",
          value: " "
        });
      } else if (!isBetween(KIND_NON_CJK, KIND_CJK_PUNCTUATION) && // disallow leading/trailing full-width whitespace
      ![lastNode.value, node.value].some(function (value) {
        return /\u3000/.test(value);
      })) {
        nodes.push({
          type: "whitespace",
          value: ""
        });
      }
    }

    nodes.push(node);

    function isBetween(kind1, kind2) {
      return lastNode.kind === kind1 && node.kind === kind2 || lastNode.kind === kind2 && node.kind === kind1;
    }
  }
}

function getOrderedListItemInfo$1(orderListItem, originalText) {
  var _originalText$slice$m = originalText.slice(orderListItem.position.start.offset, orderListItem.position.end.offset).match(/^\s*(\d+)(\.|\))(\s*)/),
      _originalText$slice$m2 = _slicedToArray(_originalText$slice$m, 4),
      numberText = _originalText$slice$m2[1],
      marker = _originalText$slice$m2[2],
      leadingSpaces = _originalText$slice$m2[3];

  return {
    numberText,
    marker,
    leadingSpaces
  };
} // workaround for https://github.com/remarkjs/remark/issues/351
// leading and trailing newlines are stripped by remark


function getFencedCodeBlockValue$2(node, originalText) {
  var text = originalText.slice(node.position.start.offset, node.position.end.offset);
  var leadingSpaceCount = text.match(/^\s*/)[0].length;
  var replaceRegex = new RegExp(`^\\s{0,${leadingSpaceCount}}`);
  var lineContents = text.split("\n");
  var markerStyle = text[leadingSpaceCount]; // ` or ~

  var marker = text.slice(leadingSpaceCount).match(new RegExp(`^[${markerStyle}]+`))[0]; // https://spec.commonmark.org/0.28/#example-104: Closing fences may be indented by 0-3 spaces
  // https://spec.commonmark.org/0.28/#example-93: The closing code fence must be at least as long as the opening fence

  var hasEndMarker = new RegExp(`^\\s{0,3}${marker}`).test(lineContents[lineContents.length - 1].slice(getIndent(lineContents.length - 1)));
  return lineContents.slice(1, hasEndMarker ? -1 : undefined).map(function (x, i) {
    return x.slice(getIndent(i + 1)).replace(replaceRegex, "");
  }).join("\n");

  function getIndent(lineIndex) {
    return node.position.indent[lineIndex - 1] - 1;
  }
}

function mapAst(ast, handler) {
  return function preorder(node, index, parentStack) {
    parentStack = parentStack || [];
    var newNode = Object.assign({}, handler(node, index, parentStack));

    if (newNode.children) {
      newNode.children = newNode.children.map(function (child, index) {
        return preorder(child, index, [newNode].concat(parentStack));
      });
    }

    return newNode;
  }(ast, null, null);
}

var utils$8 = {
  mapAst,
  splitText: splitText$1,
  punctuationPattern: punctuationPattern$1,
  getFencedCodeBlockValue: getFencedCodeBlockValue$2,
  getOrderedListItemInfo: getOrderedListItemInfo$1,
  INLINE_NODE_TYPES: INLINE_NODE_TYPES$1,
  INLINE_NODE_WRAPPER_TYPES: INLINE_NODE_WRAPPER_TYPES$1
};

var _require$$0$builders$7 = doc.builders;
var hardline$11 = _require$$0$builders$7.hardline;
var literalline$5 = _require$$0$builders$7.literalline;
var concat$13 = _require$$0$builders$7.concat;
var markAsRoot$3 = _require$$0$builders$7.markAsRoot;
var mapDoc$6 = doc.utils.mapDoc;
var getFencedCodeBlockValue$1 = utils$8.getFencedCodeBlockValue;

function embed$4(path$$1, print, textToDoc, options) {
  var node = path$$1.getValue();

  if (node.type === "code" && node.lang !== null) {
    // only look for the first string so as to support [markdown-preview-enhanced](https://shd101wyy.github.io/markdown-preview-enhanced/#/code-chunk)
    var langMatch = node.lang.match(/^[A-Za-z0-9_-]+/);
    var lang = langMatch ? langMatch[0] : "";
    var parser = getParserName(lang);

    if (parser) {
      var styleUnit = options.__inJsTemplate ? "~" : "`";
      var style = styleUnit.repeat(Math.max(3, util$1.getMaxContinuousCount(node.value, styleUnit) + 1));
      var doc$$2 = textToDoc(getFencedCodeBlockValue$1(node, options.originalText), {
        parser
      });
      return markAsRoot$3(concat$13([style, node.lang, hardline$11, replaceNewlinesWithLiterallines(doc$$2), style]));
    }
  }

  if (node.type === "yaml") {
    return markAsRoot$3(concat$13(["---", hardline$11, node.value && node.value.trim() ? replaceNewlinesWithLiterallines(textToDoc(node.value, {
      parser: "yaml"
    })) : "", "---"]));
  } // MDX


  switch (node.type) {
    case "importExport":
      return textToDoc(node.value, {
        parser: "babel"
      });

    case "jsx":
      return textToDoc(node.value, {
        parser: "__js_expression"
      });
  }

  return null;

  function getParserName(lang) {
    var supportInfo = support.getSupportInfo(null, {
      plugins: options.plugins
    });
    var language = supportInfo.languages.find(function (language) {
      return language.name.toLowerCase() === lang || language.aliases && language.aliases.indexOf(lang) !== -1 || language.extensions && language.extensions.find(function (ext) {
        return ext.substring(1) === lang;
      });
    });

    if (language) {
      return language.parsers[0];
    }

    return null;
  }

  function replaceNewlinesWithLiterallines(doc$$2) {
    return mapDoc$6(doc$$2, function (currentDoc) {
      return typeof currentDoc === "string" && currentDoc.includes("\n") ? concat$13(currentDoc.split(/(\n)/g).map(function (v, i) {
        return i % 2 === 0 ? v : literalline$5;
      })) : currentDoc;
    });
  }
}

var embed_1$4 = embed$4;

var pragma$6 = createCommonjsModule(function (module) {
  "use strict";

  var pragmas = ["format", "prettier"];

  function startWithPragma(text) {
    var pragma = `@(${pragmas.join("|")})`;
    var regex = new RegExp([`<!--\\s*${pragma}\\s*-->`, `<!--.*\r?\n[\\s\\S]*(^|\n)[^\\S\n]*${pragma}[^\\S\n]*($|\n)[\\s\\S]*\n.*-->`].join("|"), "m");
    var matched = text.match(regex);
    return matched && matched.index === 0;
  }

  module.exports = {
    startWithPragma,
    hasPragma: function hasPragma(text) {
      return startWithPragma(frontMatter(text).content.trimLeft());
    },
    insertPragma: function insertPragma(text) {
      var extracted = frontMatter(text);
      var pragma = `<!-- @${pragmas[0]} -->`;
      return extracted.frontMatter ? `${extracted.frontMatter.raw}\n\n${pragma}\n\n${extracted.content}` : `${pragma}\n\n${extracted.content}`;
    }
  };
});

var getOrderedListItemInfo$2 = utils$8.getOrderedListItemInfo;
var mapAst$1 = utils$8.mapAst;
var splitText$2 = utils$8.splitText; // 0x0 ~ 0x10ffff

var isSingleCharRegex = /^([\u0000-\uffff]|[\ud800-\udbff][\udc00-\udfff])$/;

function preprocess$2(ast, options) {
  ast = restoreUnescapedCharacter(ast, options);
  ast = mergeContinuousTexts(ast);
  ast = transformInlineCode(ast);
  ast = transformIndentedCodeblockAndMarkItsParentList(ast, options);
  ast = markAlignedList(ast, options);
  ast = splitTextIntoSentences(ast, options);
  ast = transformImportExport(ast);
  ast = mergeContinuousImportExport(ast);
  return ast;
}

function transformImportExport(ast) {
  return mapAst$1(ast, function (node) {
    if (node.type !== "import" && node.type !== "export") {
      return node;
    }

    return Object.assign({}, node, {
      type: "importExport"
    });
  });
}

function transformInlineCode(ast) {
  return mapAst$1(ast, function (node) {
    if (node.type !== "inlineCode") {
      return node;
    }

    return Object.assign({}, node, {
      value: node.value.replace(/\s+/g, " ")
    });
  });
}

function restoreUnescapedCharacter(ast, options) {
  return mapAst$1(ast, function (node) {
    return node.type !== "text" ? node : Object.assign({}, node, {
      value: node.value !== "*" && node.value !== "_" && node.value !== "$" && // handle these cases in printer
      isSingleCharRegex.test(node.value) && node.position.end.offset - node.position.start.offset !== node.value.length ? options.originalText.slice(node.position.start.offset, node.position.end.offset) : node.value
    });
  });
}

function mergeContinuousImportExport(ast) {
  return mergeChildren(ast, function (prevNode, node) {
    return prevNode.type === "importExport" && node.type === "importExport";
  }, function (prevNode, node) {
    return {
      type: "importExport",
      value: prevNode.value + "\n\n" + node.value,
      position: {
        start: prevNode.position.start,
        end: node.position.end
      }
    };
  });
}

function mergeChildren(ast, shouldMerge, mergeNode) {
  return mapAst$1(ast, function (node) {
    if (!node.children) {
      return node;
    }

    var children = node.children.reduce(function (current, child) {
      var lastChild = current[current.length - 1];

      if (lastChild && shouldMerge(lastChild, child)) {
        current.splice(-1, 1, mergeNode(lastChild, child));
      } else {
        current.push(child);
      }

      return current;
    }, []);
    return Object.assign({}, node, {
      children
    });
  });
}

function mergeContinuousTexts(ast) {
  return mergeChildren(ast, function (prevNode, node) {
    return prevNode.type === "text" && node.type === "text";
  }, function (prevNode, node) {
    return {
      type: "text",
      value: prevNode.value + node.value,
      position: {
        start: prevNode.position.start,
        end: node.position.end
      }
    };
  });
}

function splitTextIntoSentences(ast, options) {
  return mapAst$1(ast, function (node, index, _ref) {
    var _ref2 = _slicedToArray(_ref, 1),
        parentNode = _ref2[0];

    if (node.type !== "text") {
      return node;
    }

    var value = node.value;

    if (parentNode.type === "paragraph") {
      if (index === 0) {
        value = value.trimLeft();
      }

      if (index === parentNode.children.length - 1) {
        value = value.trimRight();
      }
    }

    return {
      type: "sentence",
      position: node.position,
      children: splitText$2(value, options)
    };
  });
}

function transformIndentedCodeblockAndMarkItsParentList(ast, options) {
  return mapAst$1(ast, function (node, index, parentStack) {
    if (node.type === "code") {
      // the first char may point to `\n`, e.g. `\n\t\tbar`, just ignore it
      var isIndented = /^\n?( {4,}|\t)/.test(options.originalText.slice(node.position.start.offset, node.position.end.offset));
      node.isIndented = isIndented;

      if (isIndented) {
        for (var i = 0; i < parentStack.length; i++) {
          var parent = parentStack[i]; // no need to check checked items

          if (parent.hasIndentedCodeblock) {
            break;
          }

          if (parent.type === "list") {
            parent.hasIndentedCodeblock = true;
          }
        }
      }
    }

    return node;
  });
}

function markAlignedList(ast, options) {
  return mapAst$1(ast, function (node, index, parentStack) {
    if (node.type === "list" && node.children.length !== 0) {
      // if one of its parents is not aligned, it's not possible to be aligned in sub-lists
      for (var i = 0; i < parentStack.length; i++) {
        var parent = parentStack[i];

        if (parent.type === "list" && !parent.isAligned) {
          node.isAligned = false;
          return node;
        }
      }

      node.isAligned = isAligned(node);
    }

    return node;
  });

  function getListItemStart(listItem) {
    return listItem.children.length === 0 ? -1 : listItem.children[0].position.start.column - 1;
  }

  function isAligned(list) {
    if (!list.ordered) {
      /**
       * - 123
       * - 123
       */
      return true;
    }

    var _list$children = _slicedToArray(list.children, 2),
        firstItem = _list$children[0],
        secondItem = _list$children[1];

    var firstInfo = getOrderedListItemInfo$2(firstItem, options.originalText);

    if (firstInfo.leadingSpaces.length > 1) {
      /**
       * 1.   123
       *
       * 1.   123
       * 1. 123
       */
      return true;
    }

    var firstStart = getListItemStart(firstItem);

    if (firstStart === -1) {
      /**
       * 1.
       *
       * 1.
       * 1.
       */
      return false;
    }

    if (list.children.length === 1) {
      /**
       * aligned:
       *
       * 11. 123
       *
       * not aligned:
       *
       * 1. 123
       */
      return firstStart % options.tabWidth === 0;
    }

    var secondStart = getListItemStart(secondItem);

    if (firstStart !== secondStart) {
      /**
       * 11. 123
       * 1. 123
       *
       * 1. 123
       * 11. 123
       */
      return false;
    }

    if (firstStart % options.tabWidth === 0) {
      /**
       * 11. 123
       * 12. 123
       */
      return true;
    }
    /**
     * aligned:
     *
     * 11. 123
     * 1.  123
     *
     * not aligned:
     *
     * 1. 123
     * 2. 123
     */


    var secondInfo = getOrderedListItemInfo$2(secondItem, options.originalText);
    return secondInfo.leadingSpaces.length > 1;
  }
}

var preprocess_1$2 = preprocess$2;

var _require$$0$builders$6 = doc.builders;
var breakParent$3 = _require$$0$builders$6.breakParent;
var concat$12 = _require$$0$builders$6.concat;
var join$9 = _require$$0$builders$6.join;
var line$8 = _require$$0$builders$6.line;
var literalline$4 = _require$$0$builders$6.literalline;
var markAsRoot$2 = _require$$0$builders$6.markAsRoot;
var hardline$10 = _require$$0$builders$6.hardline;
var softline$6 = _require$$0$builders$6.softline;
var ifBreak$5 = _require$$0$builders$6.ifBreak;
var fill$4 = _require$$0$builders$6.fill;
var align$2 = _require$$0$builders$6.align;
var indent$8 = _require$$0$builders$6.indent;
var group$13 = _require$$0$builders$6.group;
var mapDoc$5 = doc.utils.mapDoc;
var printDocToString$3 = doc.printer.printDocToString;
var getFencedCodeBlockValue = utils$8.getFencedCodeBlockValue;
var getOrderedListItemInfo = utils$8.getOrderedListItemInfo;
var splitText = utils$8.splitText;
var punctuationPattern = utils$8.punctuationPattern;
var INLINE_NODE_TYPES = utils$8.INLINE_NODE_TYPES;
var INLINE_NODE_WRAPPER_TYPES = utils$8.INLINE_NODE_WRAPPER_TYPES;
var replaceEndOfLineWith$1 = util$1.replaceEndOfLineWith;
var TRAILING_HARDLINE_NODES = ["importExport"];
var SINGLE_LINE_NODE_TYPES = ["heading", "tableCell", "link"];
var SIBLING_NODE_TYPES = ["listItem", "definition", "footnoteDefinition"];

function genericPrint$4(path$$1, options, print) {
  var node = path$$1.getValue();

  if (shouldRemainTheSameContent(path$$1)) {
    return concat$12(splitText(options.originalText.slice(node.position.start.offset, node.position.end.offset), options).map(function (node) {
      return node.type === "word" ? node.value : node.value === "" ? "" : printLine(path$$1, node.value, options);
    }));
  }

  switch (node.type) {
    case "root":
      if (node.children.length === 0) {
        return "";
      }

      return concat$12([normalizeDoc(printRoot(path$$1, options, print)), TRAILING_HARDLINE_NODES.indexOf(getLastDescendantNode(node).type) === -1 ? hardline$10 : ""]);

    case "paragraph":
      return printChildren(path$$1, options, print, {
        postprocessor: fill$4
      });

    case "sentence":
      return printChildren(path$$1, options, print);

    case "word":
      return node.value.replace(/[*$]/g, "\\$&") // escape all `*` and `$` (math)
      .replace(new RegExp([`(^|${punctuationPattern})(_+)`, `(_+)(${punctuationPattern}|$)`].join("|"), "g"), function (_, text1, underscore1, underscore2, text2) {
        return (underscore1 ? `${text1}${underscore1}` : `${underscore2}${text2}`).replace(/_/g, "\\_");
      });
    // escape all `_` except concating with non-punctuation, e.g. `1_2_3` is not considered emphasis

    case "whitespace":
      {
        var parentNode = path$$1.getParentNode();
        var index = parentNode.children.indexOf(node);
        var nextNode = parentNode.children[index + 1];
        var proseWrap = // leading char that may cause different syntax
        nextNode && /^>|^([-+*]|#{1,6}|[0-9]+[.)])$/.test(nextNode.value) ? "never" : options.proseWrap;
        return printLine(path$$1, node.value, {
          proseWrap
        });
      }

    case "emphasis":
      {
        var _parentNode = path$$1.getParentNode();

        var _index = _parentNode.children.indexOf(node);

        var prevNode = _parentNode.children[_index - 1];
        var _nextNode = _parentNode.children[_index + 1];
        var hasPrevOrNextWord = // `1*2*3` is considered emphais but `1_2_3` is not
        prevNode && prevNode.type === "sentence" && prevNode.children.length > 0 && util$1.getLast(prevNode.children).type === "word" && !util$1.getLast(prevNode.children).hasTrailingPunctuation || _nextNode && _nextNode.type === "sentence" && _nextNode.children.length > 0 && _nextNode.children[0].type === "word" && !_nextNode.children[0].hasLeadingPunctuation;
        var style = hasPrevOrNextWord || getAncestorNode$2(path$$1, "emphasis") ? "*" : "_";
        return concat$12([style, printChildren(path$$1, options, print), style]);
      }

    case "strong":
      return concat$12(["**", printChildren(path$$1, options, print), "**"]);

    case "delete":
      return concat$12(["~~", printChildren(path$$1, options, print), "~~"]);

    case "inlineCode":
      {
        var backtickCount = util$1.getMinNotPresentContinuousCount(node.value, "`");

        var _style = "`".repeat(backtickCount || 1);

        var gap = backtickCount ? " " : "";
        return concat$12([_style, gap, node.value, gap, _style]);
      }

    case "link":
      switch (options.originalText[node.position.start.offset]) {
        case "<":
          {
            var mailto = "mailto:";
            var url = // <hello@example.com> is parsed as { url: "mailto:hello@example.com" }
            node.url.startsWith(mailto) && options.originalText.slice(node.position.start.offset + 1, node.position.start.offset + 1 + mailto.length) !== mailto ? node.url.slice(mailto.length) : node.url;
            return concat$12(["<", url, ">"]);
          }

        case "[":
          return concat$12(["[", printChildren(path$$1, options, print), "](", printUrl(node.url, ")"), printTitle(node.title, options), ")"]);

        default:
          return options.originalText.slice(node.position.start.offset, node.position.end.offset);
      }

    case "image":
      return concat$12(["![", node.alt || "", "](", printUrl(node.url, ")"), printTitle(node.title, options), ")"]);

    case "blockquote":
      return concat$12(["> ", align$2("> ", printChildren(path$$1, options, print))]);

    case "heading":
      return concat$12(["#".repeat(node.depth) + " ", printChildren(path$$1, options, print)]);

    case "code":
      {
        if (node.isIndented) {
          // indented code block
          var alignment = " ".repeat(4);
          return align$2(alignment, concat$12([alignment, concat$12(replaceEndOfLineWith$1(node.value, hardline$10))]));
        } // fenced code block


        var styleUnit = options.__inJsTemplate ? "~" : "`";

        var _style2 = styleUnit.repeat(Math.max(3, util$1.getMaxContinuousCount(node.value, styleUnit) + 1));

        return concat$12([_style2, node.lang || "", hardline$10, concat$12(replaceEndOfLineWith$1(getFencedCodeBlockValue(node, options.originalText), hardline$10)), hardline$10, _style2]);
      }

    case "yaml":
    case "toml":
      return options.originalText.slice(node.position.start.offset, node.position.end.offset);

    case "html":
      {
        var _parentNode2 = path$$1.getParentNode();

        var value = _parentNode2.type === "root" && util$1.getLast(_parentNode2.children) === node ? node.value.trimRight() : node.value;
        var isHtmlComment = /^<!--[\s\S]*-->$/.test(value);
        return concat$12(replaceEndOfLineWith$1(value, isHtmlComment ? hardline$10 : markAsRoot$2(literalline$4)));
      }

    case "list":
      {
        var nthSiblingIndex = getNthListSiblingIndex(node, path$$1.getParentNode());
        var isGitDiffFriendlyOrderedList = node.ordered && node.children.length > 1 && +getOrderedListItemInfo(node.children[1], options.originalText).numberText === 1;
        return printChildren(path$$1, options, print, {
          processor: function processor(childPath, index) {
            var prefix = getPrefix();
            return concat$12([prefix, align$2(" ".repeat(prefix.length), printListItem(childPath, options, print, prefix))]);

            function getPrefix() {
              var rawPrefix = node.ordered ? (index === 0 ? node.start : isGitDiffFriendlyOrderedList ? 1 : node.start + index) + (nthSiblingIndex % 2 === 0 ? ". " : ") ") : nthSiblingIndex % 2 === 0 ? "- " : "* ";
              return node.isAligned ||
              /* workaround for https://github.com/remarkjs/remark/issues/315 */
              node.hasIndentedCodeblock ? alignListPrefix(rawPrefix, options) : rawPrefix;
            }
          }
        });
      }

    case "thematicBreak":
      {
        var counter = getAncestorCounter$1(path$$1, "list");

        if (counter === -1) {
          return "---";
        }

        var _nthSiblingIndex = getNthListSiblingIndex(path$$1.getParentNode(counter), path$$1.getParentNode(counter + 1));

        return _nthSiblingIndex % 2 === 0 ? "***" : "---";
      }

    case "linkReference":
      return concat$12(["[", printChildren(path$$1, options, print), "]", node.referenceType === "full" ? concat$12(["[", node.identifier, "]"]) : node.referenceType === "collapsed" ? "[]" : ""]);

    case "imageReference":
      switch (node.referenceType) {
        case "full":
          return concat$12(["![", node.alt || "", "][", node.identifier, "]"]);

        default:
          return concat$12(["![", node.alt, "]", node.referenceType === "collapsed" ? "[]" : ""]);
      }

    case "definition":
      {
        var lineOrSpace = options.proseWrap === "always" ? line$8 : " ";
        return group$13(concat$12([concat$12(["[", node.identifier, "]:"]), indent$8(concat$12([lineOrSpace, printUrl(node.url), node.title === null ? "" : concat$12([lineOrSpace, printTitle(node.title, options, false)])]))]));
      }

    case "footnote":
      return concat$12(["[^", printChildren(path$$1, options, print), "]"]);

    case "footnoteReference":
      return concat$12(["[^", node.identifier, "]"]);

    case "footnoteDefinition":
      {
        var _nextNode2 = path$$1.getParentNode().children[path$$1.getName() + 1];
        var shouldInlineFootnote = node.children.length === 1 && node.children[0].type === "paragraph" && (options.proseWrap === "never" || options.proseWrap === "preserve" && node.children[0].position.start.line === node.children[0].position.end.line);
        return concat$12(["[^", node.identifier, "]: ", shouldInlineFootnote ? printChildren(path$$1, options, print) : group$13(concat$12([align$2(" ".repeat(options.tabWidth), printChildren(path$$1, options, print, {
          processor: function processor(childPath, index) {
            return index === 0 ? group$13(concat$12([softline$6, softline$6, childPath.call(print)])) : childPath.call(print);
          }
        })), _nextNode2 && _nextNode2.type === "footnoteDefinition" ? softline$6 : ""]))]);
      }

    case "table":
      return printTable(path$$1, options, print);

    case "tableCell":
      return printChildren(path$$1, options, print);

    case "break":
      return /\s/.test(options.originalText[node.position.start.offset]) ? concat$12(["  ", markAsRoot$2(literalline$4)]) : concat$12(["\\", hardline$10]);

    case "liquidNode":
      return concat$12(replaceEndOfLineWith$1(node.value, hardline$10));
    // MDX

    case "importExport":
    case "jsx":
      return node.value;
    // fallback to the original text if multiparser failed

    case "math":
      return concat$12(["$$", hardline$10, node.value ? concat$12([concat$12(replaceEndOfLineWith$1(node.value, hardline$10)), hardline$10]) : "", "$$"]);

    case "inlineMath":
      {
        // remark-math trims content but we don't want to remove whitespaces
        // since it's very possible that it's recognized as math accidentally
        return options.originalText.slice(options.locStart(node), options.locEnd(node));
      }

    case "tableRow": // handled in "table"

    case "listItem": // handled in "list"

    default:
      throw new Error(`Unknown markdown type ${JSON.stringify(node.type)}`);
  }
}

function printListItem(path$$1, options, print, listPrefix) {
  var node = path$$1.getValue();
  var prefix = node.checked === null ? "" : node.checked ? "[x] " : "[ ] ";
  return concat$12([prefix, printChildren(path$$1, options, print, {
    processor: function processor(childPath, index) {
      if (index === 0 && childPath.getValue().type !== "list") {
        return align$2(" ".repeat(prefix.length), childPath.call(print));
      }

      var ali