/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.Installer;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public final class HelpCtxProcessor
implements Environment.Provider {
    private static Help findHelp() {
        return (Help)Lookup.getDefault().lookup(Help.class);
    }

    public Lookup getEnvironment(final DataObject obj) {
        try {
            Class.forName("javax.help.HelpSet");
        }
        catch (ClassNotFoundException ex) {
            return Lookup.EMPTY;
        }
        Installer.log.log(Level.FINE, "creating help context presenter from {0}", obj.getPrimaryFile());
        return Lookups.singleton((Object)new InstanceCookie(){
            private Action instance = null;

            public String instanceName() {
                return obj.getName();
            }

            public Class<?> instanceClass() throws IOException, ClassNotFoundException {
                return Action.class;
            }

            public synchronized Object instanceCreate() throws IOException, ClassNotFoundException {
                if (this.instance != null) {
                    return this.instance;
                }
                try {
                    Document doc = XMLUtil.parse((InputSource)new InputSource(obj.getPrimaryFile().getURL().toString()), (boolean)true, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), (EntityResolver)EntityCatalog.getDefault());
                    Element el = doc.getDocumentElement();
                    if (!el.getNodeName().equals("helpctx")) {
                        throw new IOException();
                    }
                    this.instance = new ShortcutAction(obj, el.getAttribute("id"), Boolean.valueOf(el.getAttribute("showmaster")));
                    if (obj.getPrimaryFile().getAttribute("iconBase") != null) {
                        this.instance.putValue("iconBase", obj.getPrimaryFile().getAttribute("iconBase"));
                    }
                    return this.instance;
                }
                catch (IOException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new IOException(x);
                }
            }
        });
    }

    private static final class ShortcutAction
    extends AbstractAction
    implements HelpCtx.Provider,
    NodeListener,
    ChangeListener {
        private static final RequestProcessor RP = new RequestProcessor(ShortcutAction.class);
        private final DataObject obj;
        private String helpID;
        private boolean showmaster;

        public ShortcutAction(DataObject obj, String helpID, boolean showmaster) {
            Help h;
            this.obj = obj;
            this.helpID = helpID;
            this.showmaster = showmaster;
            this.putValue("noIconInMenu", true);
            Installer.log.log(Level.FINE, "new ShortcutAction: {0} {1} showmaster={2}", new Object[]{obj, helpID, showmaster});
            this.updateText();
            this.updateIcon();
            this.updateEnabled();
            if (obj.isValid()) {
                Node n = obj.getNodeDelegate();
                n.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)n));
            }
            if ((h = HelpCtxProcessor.findHelp()) != null) {
                h.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)h));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Help h = HelpCtxProcessor.findHelp();
            if (h != null) {
                Installer.log.log(Level.FINE, "ShortcutAction.actionPerformed: {0} showmaster={1}", new Object[]{this.helpID, this.showmaster});
                h.showHelp(new HelpCtx(this.helpID), this.showmaster);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("ide.welcome");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateEnabled();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (!this.obj.isValid()) {
                return;
            }
            if (prop == null || prop.equals("name") || prop.equals("displayName")) {
                this.updateText();
            }
            if (prop == null || prop.equals("icon")) {
                this.updateIcon();
            }
        }

        private void updateText() {
            String text = this.obj.isValid() ? this.obj.getNodeDelegate().getDisplayName() : "dead";
            this.putValue("Name", text);
        }

        private void updateIcon() {
            Image icon;
            if (this.obj.isValid() && (icon = this.obj.getNodeDelegate().getIcon(1)) != null) {
                this.putValue("SmallIcon", new ImageIcon(icon));
            }
        }

        private void updateEnabled() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Boolean valid;
                    Help h = HelpCtxProcessor.findHelp();
                    Boolean bl = valid = h == null ? Boolean.FALSE : h.isValidID(ShortcutAction.this.helpID, false);
                    if (valid != null) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ShortcutAction.this.setEnabled(valid);
                            }
                        });
                    }
                    Installer.log.log(Level.FINE, "enabled: xml={0} id={1} enabled={2}", new Object[]{ShortcutAction.this.obj.getPrimaryFile(), ShortcutAction.this.helpID, valid});
                }
            });
        }

        public void nodeDestroyed(NodeEvent ev) {
            this.setEnabled(false);
            this.updateText();
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }
    }
}

