/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.help.HelpSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.HelpConstants;
import org.netbeans.modules.javahelp.Installer;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class AbstractHelp
extends Help
implements HelpConstants {
    private Lookup.Result<HelpSet> helpsets = null;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    protected AbstractHelp() {
    }

    protected final Collection<? extends HelpSet> getHelpSets() {
        if (this.helpsets == null) {
            Installer.log.fine("searching for instances of HelpSet...");
            this.helpsets = Lookup.getDefault().lookupResult(HelpSet.class);
            this.helpsets.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    AbstractHelp.this.helpSetsChanged();
                }
            });
            this.fireChangeEvent();
        }
        Collection c = this.helpsets.allInstances();
        if (Installer.log.isLoggable(Level.FINE)) {
            ArrayList<String> l = new ArrayList<String>(Math.min(1, c.size()));
            for (HelpSet hs : c) {
                l.add(hs.getTitle());
            }
            Installer.log.fine("listing helpsets: " + l);
        }
        return c;
    }

    protected final boolean helpSetsReady() {
        return this.helpsets != null;
    }

    protected final boolean shouldMerge(HelpSet hs) {
        Boolean b = (Boolean)hs.getKeyData((Object)"OpenIDE", "mergeIntoMaster");
        return b == null || b != false;
    }

    protected void helpSetsChanged() {
        Installer.log.fine("helpSetsChanged");
        this.fireChangeEvent();
    }

    @Override
    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    @Override
    public final void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private final void fireChangeEvent() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractHelp.this.fireChangeEvent();
                }
            });
            return;
        }
        Installer.log.fine("Help.stateChanged");
        this.cs.fireChange();
    }
}

