/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorFactory;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class OutputWriter {
    private static int defaultWriteTimeout = 30000;

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(socketChannel, bb, (long)defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long flushChannel(SocketChannel socketChannel, ByteBuffer bb, long writeTimeout) throws IOException {
        if (bb == null || socketChannel == null) {
            if (!SelectorThread.logger().isLoggable(Level.FINE)) return -1L;
            SelectorThread.logger().log(Level.FINE, "Invalid Response State " + bb + "SocketChannel cannot be null." + socketChannel);
            return -1L;
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int nWrite = 0;
        int len = -1;
        long elapsedTime = 0L;
        try {
            while (bb.hasRemaining()) {
                len = socketChannel.write(bb);
                if (len > 0) {
                    attempts = 0;
                    elapsedTime = 0L;
                    nWrite += len;
                    continue;
                }
                ++attempts;
                if (writeSelector == null) {
                    writeSelector = SelectorFactory.getSelector();
                    if (writeSelector == null) continue;
                    key = socketChannel.register(writeSelector, 4);
                }
                long startTime = System.currentTimeMillis();
                if (writeSelector.select(writeTimeout) != 0 || attempts <= 2 || writeTimeout <= 0L || (elapsedTime += System.currentTimeMillis() - startTime) < writeTimeout) continue;
                throw new IOException("Client is busy or timed out");
            }
            Object var14_10 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) return nWrite;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) throw throwable;
            SelectorFactory.selectNowAndReturnSelector(writeSelector);
            throw throwable;
        }
        SelectorFactory.selectNowAndReturnSelector(writeSelector);
        return nWrite;
    }

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb) throws IOException {
        return OutputWriter.flushChannel(socketChannel, bb, (long)defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb, long writeTimeout) throws IOException {
        if (bb == null || socketChannel == null) {
            if (!SelectorThread.logger().isLoggable(Level.FINE)) return -1L;
            SelectorThread.logger().log(Level.FINE, "Invalid Response State " + bb + "SocketChannel cannot be null." + socketChannel);
            return -1L;
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        long totalBytes = 0L;
        for (int i = 0; i < bb.length; ++i) {
            totalBytes += (long)bb[i].remaining();
        }
        long nWrite = 0L;
        long len = -1L;
        long elapsedTime = 0L;
        try {
            while (nWrite < totalBytes) {
                len = socketChannel.write(bb);
                if (len > 0L) {
                    attempts = 0;
                    elapsedTime = 0L;
                    nWrite += len;
                    continue;
                }
                if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                key = socketChannel.register(writeSelector, 4);
                long startTime = System.currentTimeMillis();
                if (writeSelector.select(writeTimeout) != 0 || attempts <= 2 || writeTimeout <= 0L || (elapsedTime += System.currentTimeMillis() - startTime) < writeTimeout) continue;
                throw new IOException("Client is busy or timed out");
            }
            Object var18_12 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) return nWrite;
        }
        catch (Throwable throwable) {
            Object var18_13 = null;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector == null) throw throwable;
            SelectorFactory.selectNowAndReturnSelector(writeSelector);
            throw throwable;
        }
        SelectorFactory.selectNowAndReturnSelector(writeSelector);
        return nWrite;
    }

    public static int getDefaultWriteTimeout() {
        return defaultWriteTimeout;
    }

    public static void setDefaultWriteTimeout(int aDefaultWriteTimeout) {
        defaultWriteTimeout = aDefaultWriteTimeout;
    }
}

