/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Basic;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class ValidBasicType
extends JPAEntityAttributeCheck {
    private static Collection<String> fixedBasicTypes = new TreeSet<String>(Arrays.asList("java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "byte", "char", "short", "int", "long", "float", "double", "java.lang.Float", "java.lang.Double", "java.util.Date", "java.util.Calendar", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "byte[]", "java.lang.Byte[]", "char[]", "java.lang.Character[]"));

    @Override
    public Collection<ErrorDescription> check(JPAProblemContext ctx, HintContext hc, AttributeWrapper attrib) {
        if (!(attrib.getModelElement() instanceof Basic)) {
            return null;
        }
        TreeUtilities treeUtils = ctx.getCompilationInfo().getTreeUtilities();
        Types types = ctx.getCompilationInfo().getTypes();
        TypeMirror attrType = attrib.getType();
        TypeMirror typeSerializable = treeUtils.parseType("java.io.Serializable", ctx.getJavaClass());
        TypeMirror typeEnum = treeUtils.parseType("java.lang.Enum", ctx.getJavaClass());
        TypeMirror typeCollection = treeUtils.parseType("java.util.Collection", ctx.getJavaClass());
        if (types.isAssignable(attrType, typeSerializable) || types.isAssignable(attrType, typeEnum) || types.isAssignable(attrType, typeCollection)) {
            return null;
        }
        for (String typeName : fixedBasicTypes) {
            TypeMirror type = treeUtils.parseType(typeName, ctx.getJavaClass());
            if (type == null || !types.isSameType(attrType, type)) continue;
            return null;
        }
        if (Utilities.hasAnnotation(attrib.getJavaElement(), "javax.persistence.ElementCollection")) {
            return null;
        }
        if (Utilities.hasAnnotation(attrib.getJavaElement(), "javax.persistence.Embedded")) {
            return null;
        }
        Tree elementTree = ctx.getCompilationInfo().getTrees().getTree(attrib.getJavaElement());
        Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), elementTree);
        ErrorDescription error = ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(ValidBasicType.class, (String)"MSG_ValidBasicType"), (Fix[])new Fix[0]);
        return Collections.singleton(error);
    }
}

