/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.megamenu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.megamenu.MegaMenu;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.model.menu.MenuColumn;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Separator;
import org.primefaces.model.menu.Submenu;
import org.primefaces.util.WidgetBuilder;

public class MegaMenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        MegaMenu menu = (MegaMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("MegaMenu", menu.resolveWidgetVar(), clientId).attr("autoDisplay", menu.isAutoDisplay()).attr("activeIndex", menu.getActiveIndex(), Integer.MIN_VALUE);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        UIComponent optionsFacet;
        ResponseWriter writer = context.getResponseWriter();
        MegaMenu menu = (MegaMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-menu ui-menubar ui-megamenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix" : "ui-menu ui-menubar ui-megamenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix " + styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("role", (Object)"menubar", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        if (menu.getElementsCount() > 0) {
            this.encodeRootItems(context, menu);
        }
        if ((optionsFacet = menu.getFacet("options")) != null) {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-menuitem ui-menubar-options ui-widget ui-corner-all", null);
            writer.writeAttribute("role", (Object)"menuitem", null);
            optionsFacet.encodeAll(context);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeRootItems(FacesContext context, MegaMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List elements = menu.getElements();
        for (MenuElement element : elements) {
            if (!element.isRendered()) continue;
            if (element instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, menu, (MenuItem)element);
                writer.endElement("li");
                continue;
            }
            if (element instanceof Submenu) {
                this.encodeRootSubmenu(context, menu, (Submenu)element);
                continue;
            }
            if (!(element instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)element);
        }
    }

    protected void encodeRootSubmenu(FacesContext context, MegaMenu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        String label = submenu.getLabel();
        String style = submenu.getStyle();
        String styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget ui-menuitem ui-corner-all ui-menu-parent" : "ui-widget ui-menuitem ui-corner-all ui-menu-parent " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("role", (Object)"menuitem", null);
        writer.writeAttribute("aria-haspopup", (Object)"true", null);
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-link ui-submenu-link ui-corner-all", null);
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
            writer.endElement("span");
        }
        if (label != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
            writer.writeText((Object)submenu.getLabel(), "value");
            writer.endElement("span");
        }
        this.encodeSubmenuIcon(context, submenu);
        writer.endElement("a");
        if (submenu.getElementsCount() > 0) {
            List submenuElements = submenu.getElements();
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-menu-list ui-corner-all ui-helper-clearfix ui-menu-child ui-shadow", null);
            writer.writeAttribute("role", (Object)"menu", null);
            writer.startElement("table", null);
            writer.startElement("tbody", null);
            writer.startElement("tr", null);
            for (MenuElement submenuElement : submenuElements) {
                if (!submenuElement.isRendered() || !(submenuElement instanceof MenuColumn)) continue;
                this.encodeColumn(context, menu, (MenuColumn)submenuElement);
            }
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
            writer.endElement("ul");
        }
        writer.endElement("li");
    }

    protected void encodeColumn(FacesContext context, MegaMenu menu, MenuColumn column) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        if (column.getStyle() != null) {
            writer.writeAttribute("style", (Object)column.getStyle(), null);
        }
        if (column.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)column.getStyleClass(), null);
        }
        if (column.getElementsCount() > 0) {
            List columnElements = column.getElements();
            for (Object element : columnElements) {
                if (element instanceof MenuElement) {
                    if (!((MenuElement)element).isRendered()) continue;
                    if (element instanceof Submenu) {
                        this.encodeDescendantSubmenu(context, menu, (Submenu)element);
                        continue;
                    }
                    if (!(element instanceof Separator)) continue;
                    this.encodeSubmenuSeparator(context, (Separator)element);
                    continue;
                }
                if (!(element instanceof UIComponent)) continue;
                ((UIComponent)element).encodeAll(context);
            }
        }
        writer.endElement("td");
    }

    protected void encodeDescendantSubmenu(FacesContext context, MegaMenu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        String style = submenu.getStyle();
        String styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget-header ui-corner-all" : "ui-widget-header ui-corner-all " + styleClass;
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        writer.writeAttribute("role", (Object)"menu", null);
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("h3", null);
        if (label != null) {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("h3");
        writer.endElement("li");
        if (submenu.getElementsCount() > 0) {
            List submenuElements = submenu.getElements();
            for (MenuElement submenuElement : submenuElements) {
                if (!submenuElement.isRendered()) continue;
                if (submenuElement instanceof MenuItem) {
                    writer.startElement("li", null);
                    writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                    writer.writeAttribute("role", (Object)"menuitem", null);
                    this.encodeMenuItem(context, menu, (MenuItem)submenuElement);
                    writer.endElement("li");
                    continue;
                }
                if (!(submenuElement instanceof Separator)) continue;
                this.encodeSeparator(context, (Separator)submenuElement);
            }
        }
        writer.endElement("ul");
    }

    protected void encodeSubmenuIcon(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getParent() instanceof MegaMenu ? "ui-icon ui-icon-triangle-1-s" : "ui-icon ui-icon-triangle-1-e";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)icon, null);
        writer.endElement("span");
    }

    protected void encodeSubmenuSeparator(FacesContext context, Separator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-separator ui-state-default ui-corner-all" : "ui-separator ui-state-default ui-corner-all " + styleClass;
        writer.startElement("hr", null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (separator.getTitle() != null) {
            writer.writeAttribute("title", (Object)separator.getTitle(), "title");
        }
        if (separator.getStyle() != null) {
            writer.writeAttribute("style", (Object)separator.getStyle(), "style");
        }
        writer.endElement("hr");
    }
}

