/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.java.hints.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SuspiciousNamesCustomizer
extends JPanel
implements ActionListener,
ListSelectionListener {
    private Preferences prefs;
    private DefaultListModel listModel = new DefaultListModel();
    private JButton addButton;
    private JButton editButton;
    private JList groupList;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton removeButton;

    public SuspiciousNamesCustomizer(Preferences prefs) {
        this.initComponents();
        this.prefs = prefs;
        this.load();
        this.editButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.groupList.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEditRemove();
    }

    private void load() {
        String[] groups;
        String val = this.prefs.get("groups", "x, width|y, height");
        this.prefs.put("groups", val);
        for (String g : groups = val == null ? new String[]{} : val.split(Pattern.quote("|"))) {
            this.listModel.addElement(g);
        }
    }

    private void save() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.listModel.size(); ++i) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(this.listModel.get(i).toString());
        }
        this.prefs.put("groups", sb.toString());
    }

    private void editPerformed() {
        int selIndex = this.groupList.getSelectedIndex();
        if (selIndex == -1) {
            return;
        }
        IdListInputLine il = new IdListInputLine(Bundle.TEXT_EditGroupOfCompatibleNames(), Bundle.CAPTION_EditGroupOfCompatibleNames());
        il.setInputText(this.groupList.getModel().getElementAt(selIndex).toString());
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)il);
        if (res != DialogDescriptor.OK_OPTION) {
            return;
        }
        String normalized = this.normalize(il.getInputText());
        this.listModel.set(selIndex, normalized);
        this.save();
    }

    private void addPerformed() {
        IdListInputLine il = new IdListInputLine(Bundle.TEXT_EditGroupOfCompatibleNames(), Bundle.CAPTION_EditGroupOfCompatibleNames());
        il.setInputText("");
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)il);
        if (res != DialogDescriptor.OK_OPTION) {
            return;
        }
        String normalized = this.normalize(il.getInputText());
        int atIndex = this.listModel.size();
        this.listModel.add(atIndex, normalized);
        this.save();
    }

    private void removePerformed() {
        int selIndex = this.groupList.getSelectedIndex();
        if (selIndex == -1) {
            return;
        }
        int size = this.listModel.size();
        this.listModel.removeElementAt(selIndex);
        this.save();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.editButton) {
            this.editPerformed();
        } else if (src == this.addButton) {
            this.addPerformed();
        } else if (src == this.removeButton) {
            this.removePerformed();
        }
    }

    private String normalize(String text) {
        String[] names = text.split("[, \t;]");
        StringBuilder sb = new StringBuilder();
        for (String s : names) {
            if (s.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private void updateEditRemove() {
        boolean enable = this.groupList.getSelectedIndex() != -1;
        this.editButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.groupList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.jLabel1 = new JLabel();
        this.groupList.setModel(this.listModel);
        this.groupList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.groupList);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SuspiciousNamesCustomizer.class, (String)"SuspiciousNamesCustomizer.addButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(SuspiciousNamesCustomizer.class, (String)"SuspiciousNamesCustomizer.removeButton.text"));
        this.removeButton.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(SuspiciousNamesCustomizer.class, (String)"SuspiciousNamesCustomizer.editButton.text"));
        this.editButton.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SuspiciousNamesCustomizer.class, (String)"SuspiciousNamesCustomizer.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 282, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeButton).addComponent(this.editButton, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, -1, -1, Short.MAX_VALUE))).addComponent(this.jLabel1)).addContainerGap(17, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addGap(18, 18, 18).addComponent(this.removeButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
    }

    private static class IdListInputLine
    extends NotifyDescriptor.InputLine
    implements DocumentListener {
        private NotificationLineSupport nls = this.getNotificationLineSupport();

        public IdListInputLine(String text, String title) {
            super(text, title);
            if (this.nls == null) {
                this.nls = this.createNotificationLineSupport();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            String s = this.textField.getText();
            String[] names = s.split("[, \t;]");
            if (names.length == 0) {
                this.nls.setErrorMessage(Bundle.ERR_NameGroupCantBeEmpty());
                this.setValid(false);
                return;
            }
            for (String check : names) {
                if (Utilities.isJavaIdentifier((String)check)) continue;
                this.nls.setErrorMessage(Bundle.ERR_NotJavaIdentifier(check));
                this.setValid(false);
                return;
            }
            this.setValid(true);
        }
    }
}

