/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.project;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cordova.updatetask.CordovaPlugin;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PluginsPanel
extends JPanel {
    private volatile boolean panelEnabled = true;
    private PluginsListModel selectedPluginsModel;
    private PluginsListModel allPluginsModel;
    private JButton deselectSelectedButton;
    private JLabel generalInfoLabel;
    private JLabel jLabel1;
    private JLabel librariesLabel;
    private JTextField pluginsFilterTextField;
    private JList pluginsList;
    private JScrollPane pluginsScrollPane;
    private JButton selectSelectedButton;
    private JLabel selectedLabel;
    private JScrollPane selectedLibrariesScrollPane;
    private JList selectedPluginsList;

    public PluginsPanel() {
        this.checkUiThread();
        this.initComponents();
    }

    public void init(List<CordovaPlugin> current, List<CordovaPlugin> all) {
        this.checkUiThread();
        this.initComponents();
        this.pluginsFilterTextField.setVisible(false);
        this.selectedPluginsModel = new PluginsListModel(current);
        this.selectedPluginsModel.sortLibraries();
        all.removeAll(current);
        this.allPluginsModel = new PluginsListModel(all);
        this.allPluginsModel.sortLibraries();
        this.initPlugins();
    }

    public List<CordovaPlugin> getSelectedPlugins() {
        return this.selectedPluginsModel.plugins;
    }

    public void lockPanel() {
        this.checkUiThread();
        this.enablePanel(false);
    }

    public void unlockPanel() {
        this.checkUiThread();
        this.enablePanel(true);
    }

    private void checkUiThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Must be run in UI thread");
        }
    }

    private void initPlugins() {
        this.initAllPluginsList();
        this.initSelectedPluginsList();
        this.updateButtonsEnabled();
    }

    private void initAllPluginsList() {
        assert (EventQueue.isDispatchThread());
        this.pluginsList.setModel(this.allPluginsModel);
        this.pluginsList.setSelectionMode(0);
        this.pluginsFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
            }
        });
    }

    private void initSelectedPluginsList() {
        assert (EventQueue.isDispatchThread());
        this.selectedPluginsList.setModel(this.selectedPluginsModel);
        this.selectedPluginsList.setSelectionMode(0);
    }

    private boolean isUpdateRunning() {
        return !this.panelEnabled;
    }

    private void startUpdate() {
        this.lockPanel();
    }

    void finishUpdate() {
        this.unlockPanel();
    }

    private void enablePanel(boolean enabled) {
        assert (EventQueue.isDispatchThread());
        this.panelEnabled = enabled;
        this.pluginsFilterTextField.setEnabled(enabled);
        this.pluginsList.setEnabled(enabled);
        this.selectSelectedButton.setEnabled(enabled);
        this.deselectSelectedButton.setEnabled(enabled);
        this.selectedPluginsList.setEnabled(enabled);
    }

    private void initComponents() {
        this.generalInfoLabel = new JLabel();
        this.librariesLabel = new JLabel();
        this.pluginsFilterTextField = new JTextField();
        this.selectSelectedButton = new JButton();
        this.deselectSelectedButton = new JButton();
        this.selectedLabel = new JLabel();
        this.selectedLibrariesScrollPane = new JScrollPane();
        this.selectedPluginsList = new JList();
        this.pluginsScrollPane = new JScrollPane();
        this.pluginsList = new JList();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.generalInfoLabel, (String)NbBundle.getMessage(PluginsPanel.class, (String)"PluginsPanel.generalInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(PluginsPanel.class, (String)"PluginsPanel.librariesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.selectSelectedButton, (String)NbBundle.getMessage(PluginsPanel.class, (String)"PluginsPanel.selectSelectedButton.text"));
        this.selectSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginsPanel.this.selectSelectedButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deselectSelectedButton, (String)NbBundle.getMessage(PluginsPanel.class, (String)"PluginsPanel.deselectSelectedButton.text"));
        this.deselectSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginsPanel.this.deselectSelectedButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.selectedLabel, (String)NbBundle.getMessage(PluginsPanel.class, (String)"PluginsPanel.selectedLabel.text"));
        this.selectedPluginsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PluginsPanel.this.selectedPluginsListValueChanged(evt);
            }
        });
        this.selectedLibrariesScrollPane.setViewportView(this.selectedPluginsList);
        this.pluginsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PluginsPanel.this.pluginsListValueChanged(evt);
            }
        });
        this.pluginsScrollPane.setViewportView(this.pluginsList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PluginsPanel.class, (String)"PluginsPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.generalInfoLabel, -1, 591, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.librariesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pluginsFilterTextField)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pluginsScrollPane, -2, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectSelectedButton).addComponent(this.deselectSelectedButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedLabel).addComponent(this.selectedLibrariesScrollPane, -2, 0, Short.MAX_VALUE)))).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.deselectSelectedButton, this.selectSelectedButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.generalInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.librariesLabel).addComponent(this.selectedLabel).addComponent(this.pluginsFilterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedLibrariesScrollPane, -1, 285, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.selectSelectedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deselectSelectedButton).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.pluginsScrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, -1, -2)));
    }

    private void selectSelectedButtonActionPerformed(ActionEvent evt) {
        this.selectedPluginsModel.add(this.pluginsList.getSelectedValuesList());
        this.allPluginsModel.remove(this.pluginsList.getSelectedValuesList());
        this.updateButtonsEnabled();
    }

    private void deselectSelectedButtonActionPerformed(ActionEvent evt) {
        this.allPluginsModel.add(this.selectedPluginsList.getSelectedValuesList());
        this.selectedPluginsModel.remove(this.selectedPluginsList.getSelectedValuesList());
        this.updateButtonsEnabled();
    }

    private void pluginsListValueChanged(ListSelectionEvent evt) {
        this.updateButtonsEnabled();
    }

    private void selectedPluginsListValueChanged(ListSelectionEvent evt) {
        this.updateButtonsEnabled();
    }

    private void updateButtonsEnabled() {
        this.selectSelectedButton.setEnabled(this.allPluginsModel.getSize() > 0 && this.pluginsList.getSelectedIndex() != -1 && this.pluginsList.getSelectedIndex() < this.allPluginsModel.getSize());
        this.deselectSelectedButton.setEnabled(this.selectedPluginsModel.getSize() > 0 && this.selectedPluginsList.getSelectedIndex() != -1 && this.selectedPluginsList.getSelectedIndex() < this.selectedPluginsModel.getSize());
    }

    private static final class PluginsListModel
    extends AbstractListModel {
        private static final Comparator<CordovaPlugin> SELECTED_PLUGINS_COMPARATOR = new Comparator<CordovaPlugin>(){

            @Override
            public int compare(CordovaPlugin left, CordovaPlugin right) {
                return left.getName().compareToIgnoreCase(right.getName());
            }
        };
        private final List<CordovaPlugin> plugins;

        public PluginsListModel(List<CordovaPlugin> plugins) {
            this.plugins = plugins;
        }

        @Override
        public int getSize() {
            return this.plugins.size();
        }

        @Override
        public CordovaPlugin getElementAt(int index) {
            return this.plugins.get(index);
        }

        public void fireContentsChanged() {
            this.sortLibraries();
            this.fireContentsChanged(this, 0, this.plugins.size() - 1);
        }

        public void add(List<CordovaPlugin> add) {
            for (CordovaPlugin p : add) {
                if (this.plugins.contains(p)) continue;
                this.plugins.add(p);
            }
            this.sortLibraries();
            this.fireContentsChanged();
        }

        public void remove(List<CordovaPlugin> rem) {
            this.plugins.removeAll(rem);
            this.sortLibraries();
            this.fireContentsChanged();
        }

        private void sortLibraries() {
            Collections.sort(this.plugins, SELECTED_PLUGINS_COMPARATOR);
        }
    }
}

