/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.modules.java.api.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.project.ui.PackageViewFilterNode;
import org.netbeans.modules.java.api.common.queries.MultiModuleGroupQuery;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.PathFinder;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class MultiModuleNodeFactory
implements NodeFactory {
    private static final Logger LOG = Logger.getLogger(MultiModuleNodeFactory.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(MultiModuleNodeFactory.class);
    private final MultiModule sourceModules;
    private final MultiModule testModules;
    private final ProcessorGeneratedSources procGenSrc;
    private final LibrariesSupport libsSupport;

    private MultiModuleNodeFactory(@NullAllowed MultiModule sourceModules, @NullAllowed MultiModule testModules, @NonNull ProcessorGeneratedSources procGenSrc, @NullAllowed LibrariesSupport libsSupport) {
        Parameters.notNull((CharSequence)"procGenSrc", (Object)procGenSrc);
        this.sourceModules = sourceModules;
        this.testModules = testModules;
        this.libsSupport = libsSupport;
        this.procGenSrc = procGenSrc;
    }

    public NodeList<?> createNodes(@NonNull Project project) {
        return new Nodes(project, this.procGenSrc, this.sourceModules, this.testModules, this.libsSupport);
    }

    private static final class ProcessorGeneratedSources
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private static final String PROP_GEN_GROUPS = "generatedGroups";
        private final UpdateHelper helper;
        private final PropertyEvaluator eval;
        private final String sourceOutputProp;
        private final AtomicBoolean listensOnFs;
        private final PropertyChangeSupport listeners;
        private Map<String, SourceGroup> cache;

        ProcessorGeneratedSources(@NonNull UpdateHelper helper, @NonNull PropertyEvaluator eval, @NonNull String processorsSourceOutputProp) {
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"processorsSourceOutputProp", (Object)processorsSourceOutputProp);
            this.helper = helper;
            this.eval = eval;
            this.sourceOutputProp = processorsSourceOutputProp;
            this.listensOnFs = new AtomicBoolean();
            this.listeners = new PropertyChangeSupport(this);
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
        }

        @CheckForNull
        SourceGroup getGeneratedGroups(@NonNull String moduleName) {
            Map<String, SourceGroup> cache = this.getCache();
            return cache.get(moduleName);
        }

        void addPropertyChangeListener(@NonNull PropertyChangeListener l) {
            this.listeners.addPropertyChangeListener(l);
        }

        void removePropertyChangeListener(@NonNull PropertyChangeListener l) {
            this.listeners.removePropertyChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, SourceGroup> getCache() {
            ProcessorGeneratedSources processorGeneratedSources = this;
            synchronized (processorGeneratedSources) {
                if (this.cache != null) {
                    return this.cache;
                }
            }
            File genSrc = Optional.ofNullable(this.eval.getProperty(this.sourceOutputProp)).map(arg_0 -> ((AntProjectHelper)this.helper.getAntProjectHelper()).resolveFile(arg_0)).orElse(null);
            HashMap<String, SourceGroup> m = new HashMap<String, SourceGroup>();
            if (genSrc != null) {
                FileObject genSrcFo;
                if (this.listensOnFs.compareAndSet(false, true)) {
                    FileUtil.addFileChangeListener((FileChangeListener)this, (File)genSrc);
                }
                if ((genSrcFo = FileUtil.toFileObject((File)genSrc)) != null) {
                    Arrays.stream(genSrcFo.getChildren()).filter(FileObject::isFolder).forEach(fo -> {
                        SourceGroup cfr_ignored_0 = m.put(fo.getNameExt(), new APSourceGroup(genSrcFo, (FileObject)fo));
                    });
                }
            }
            ProcessorGeneratedSources processorGeneratedSources2 = this;
            synchronized (processorGeneratedSources2) {
                if (this.cache == null) {
                    this.cache = m;
                    return m;
                }
                return this.cache;
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            this.reset();
        }

        public void fileDeleted(FileEvent fe) {
            this.reset();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.reset();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || this.sourceOutputProp.equals(propName)) {
                this.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            ProcessorGeneratedSources processorGeneratedSources = this;
            synchronized (processorGeneratedSources) {
                this.cache = null;
            }
            this.listeners.firePropertyChange(PROP_GEN_GROUPS, null, null);
        }

        private static final class APSourceGroup
        implements SourceGroup {
            private final FileObject modSrcPathRoot;
            private final FileObject srcPathRoot;

            APSourceGroup(@NonNull FileObject modSrcPathRoot, @NonNull FileObject srcPathRoot) {
                Parameters.notNull((CharSequence)"modSrcPathRoot", (Object)modSrcPathRoot);
                Parameters.notNull((CharSequence)"srcPathRoot", (Object)srcPathRoot);
                this.modSrcPathRoot = modSrcPathRoot;
                this.srcPathRoot = srcPathRoot;
            }

            public FileObject getRootFolder() {
                return this.srcPathRoot;
            }

            public String getName() {
                return this.modSrcPathRoot.getNameExt();
            }

            public String getDisplayName() {
                return NbBundle.getMessage(MultiModuleNodeFactory.class, (String)"MultiModuleNodeFactory.gensrc", (Object)this.getName());
            }

            public Icon getIcon(boolean opened) {
                return null;
            }

            public boolean contains(FileObject file) {
                return true;
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }
        }
    }

    private static final class TestRootNode
    extends SimpleLabelNode {
        private static final String TEST_BADGE = "org/netbeans/modules/java/api/common/project/ui/resources/test-badge.png";

        TestRootNode(@NonNull Node original, String dispName) {
            super(original, dispName);
        }

        public Image getIcon(int type) {
            return this.computeIcon(false, type);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(true, type);
        }

        private Image computeIcon(boolean opened, int type) {
            Image image = opened ? this.getDataFolderNodeDelegate().getOpenedIcon(type) : this.getDataFolderNodeDelegate().getIcon(type);
            image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)TEST_BADGE), (int)4, (int)5);
            return image;
        }

        @NonNull
        private Node getDataFolderNodeDelegate() {
            block3: {
                DataFolder df = (DataFolder)this.getLookup().lookup(DataFolder.class);
                try {
                    if (df.isValid()) {
                        return df.getNodeDelegate();
                    }
                }
                catch (IllegalStateException e) {
                    if (!df.isValid()) break block3;
                    throw e;
                }
            }
            return new AbstractNode(FilterNode.Children.LEAF);
        }
    }

    private static class SimpleLabelNode
    extends FilterNode {
        public SimpleLabelNode(Node original, String dispName) {
            super(original);
            if (dispName != null) {
                this.disableDelegation(12);
                this.setDisplayName(dispName);
            }
        }
    }

    private static class LibrariesSupport {
        private final UpdateHelper helper;
        private final PropertyEvaluator evaluator;
        private final ReferenceHelper refHelper;
        private final ClassPathSupport cs;
        private final List<? extends Action> actions;
        private final List<? extends Action> testActions;

        LibrariesSupport(@NonNull UpdateHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull ReferenceHelper refHelper, @NonNull List<? extends Action> actions, @NonNull List<? extends Action> testActions) {
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
            Parameters.notNull((CharSequence)"refHelper", (Object)refHelper);
            Parameters.notNull((CharSequence)"actions", actions);
            Parameters.notNull((CharSequence)"testActions", testActions);
            this.helper = helper;
            this.evaluator = evaluator;
            this.refHelper = refHelper;
            this.cs = new ClassPathSupport(evaluator, refHelper, helper.getAntProjectHelper(), helper, null);
            this.actions = actions;
            this.testActions = testActions;
        }

        @NonNull
        UpdateHelper getUpdateHelper() {
            return this.helper;
        }

        @NonNull
        PropertyEvaluator getPropertyEvaluator() {
            return this.evaluator;
        }

        @NonNull
        ReferenceHelper getReferenceHelper() {
            return this.refHelper;
        }

        @NonNull
        ClassPathSupport getClassPathSupport() {
            return this.cs;
        }

        @NonNull
        Collection<? extends Action> getActions(boolean tests) {
            return tests ? this.testActions : this.actions;
        }

        private static final class Builder {
            private final List<Action> actions = new ArrayList<Action>();
            private final List<Action> testActions = new ArrayList<Action>();

            Builder() {
            }

            void addActions(boolean tests, Action ... actions) {
                Collections.addAll(tests ? this.testActions : this.actions, actions);
            }

            LibrariesSupport build(@NonNull UpdateHelper helper, @NonNull PropertyEvaluator eval, @NonNull ReferenceHelper refHelper) {
                return new LibrariesSupport(helper, eval, refHelper, this.actions, this.testActions);
            }
        }
    }

    private static final class ModuleChildren
    extends Children.Keys<Key>
    implements PropertyChangeListener {
        private final String moduleName;
        private final Project project;
        private final Sources sources;
        private final MultiModuleGroupQuery groupQuery;
        private final MultiModule srcModule;
        private final MultiModule testModule;
        private final ProcessorGeneratedSources procGenSrc;
        private final LibrariesSupport libsSupport;
        private final RequestProcessor.Task refresh;
        private final AtomicReference<ClassPath> srcPath;
        private final AtomicReference<ClassPath> testPath;

        private ModuleChildren(ModuleKey key) {
            Parameters.notNull((CharSequence)"key", (Object)key);
            this.moduleName = key.getModuleName();
            this.project = key.getProject();
            this.sources = (Sources)this.project.getLookup().lookup(Sources.class);
            this.groupQuery = (MultiModuleGroupQuery)this.project.getLookup().lookup(MultiModuleGroupQuery.class);
            this.srcModule = key.getSourceModules();
            this.testModule = key.getTestModules();
            this.procGenSrc = key.getProcessorGeneratedSources();
            this.libsSupport = key.getLibrariesSupport();
            this.srcPath = new AtomicReference();
            this.testPath = new AtomicReference();
            this.refresh = RP.create(() -> this.setKeys(this.createKeys()));
        }

        protected void addNotify() {
            super.addNotify();
            ClassPath cp = Optional.ofNullable(this.srcModule).map(m -> m.getModuleSources(this.moduleName)).orElse(ClassPath.EMPTY);
            if (this.srcPath.compareAndSet(null, cp)) {
                cp.addPropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.testPath.compareAndSet(null, cp = Optional.ofNullable(this.testModule).map(m -> m.getModuleSources(this.moduleName)).orElse(ClassPath.EMPTY))) {
                cp.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.procGenSrc.addPropertyChangeListener(this);
            this.setKeys(this.createKeys());
        }

        protected void removeNotify() {
            super.removeNotify();
            ClassPath cp = this.srcPath.get();
            if (cp != null && this.srcPath.compareAndSet(cp, null)) {
                cp.removePropertyChangeListener((PropertyChangeListener)this);
            }
            if ((cp = this.testPath.get()) != null && this.testPath.compareAndSet(cp, null)) {
                cp.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.procGenSrc.removePropertyChangeListener(this);
            this.setKeys(Collections.emptySet());
        }

        @NonNull
        protected Node[] createNodes(@NonNull Key key) {
            if (key.isSource()) {
                FilterNode n = new PackageViewFilterNode(key.getSourceGroup(), this.project, key.isGenerated());
                MultiModuleGroupQuery.Result r = this.groupQuery.findModuleInfo(key.getSourceGroup());
                if (r == null) {
                    if (key.isTests()) {
                        n = new TestRootNode((Node)n, null);
                    }
                } else {
                    n = key.isTests() ? new TestRootNode((Node)n, r.getPathFromModule()) : new SimpleLabelNode((Node)n, r.getPathFromModule());
                }
                return new Node[]{n};
            }
            if (this.libsSupport != null) {
                FileObject[] roots = key.getSourceRoots();
                if (roots.length > 0) {
                    ClassPath scp = key.getSourcePath();
                    Lookup lkp = Lookups.fixed((Object[])new Object[]{this.project, scp});
                    if (key.isTests()) {
                        return new Node[]{new LibrariesNode.Builder(this.project, this.libsSupport.getPropertyEvaluator(), this.libsSupport.getUpdateHelper(), this.libsSupport.getReferenceHelper(), this.libsSupport.getClassPathSupport()).setName(NbBundle.getMessage(MultiModuleNodeFactory.class, (String)"CTL_TestLibrariesNode")).addClassPathProperties("run.test.classpath").addModulePathProperties("run.test.modulepath").setModuleInfoBasedPath(ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/compile")).setSourcePath(scp).addLibrariesNodeActions((Action[])this.libsSupport.getActions(true).stream().map(a -> a instanceof ContextAwareAction ? ((ContextAwareAction)a).createContextAwareInstance(lkp) : a).toArray(Action[]::new)).build()};
                    }
                    return new Node[]{new LibrariesNode.Builder(this.project, this.libsSupport.getPropertyEvaluator(), this.libsSupport.getUpdateHelper(), this.libsSupport.getReferenceHelper(), this.libsSupport.getClassPathSupport()).addClassPathProperties("run.classpath").addClassPathIgnoreRefs("build.modules.dir").addModulePathProperties("run.modulepath").addModulePathIgnoreRefs("build.modules.dir").setBootPath(ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/boot")).setModuleInfoBasedPath(ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/compile")).setPlatformProperty("platform.active").setSourcePath(scp).setModuleSourcePath(ClassPath.getClassPath((FileObject)roots[0], (String)"modules/source")).addLibrariesNodeActions((Action[])this.libsSupport.getActions(false).stream().map(a -> a instanceof ContextAwareAction ? ((ContextAwareAction)a).createContextAwareInstance(lkp) : a).toArray(Action[]::new)).build()};
                }
                return new Node[0];
            }
            return new Node[0];
        }

        @NonNull
        private Collection<? extends Key> createKeys() {
            ClassPath sourceP = this.srcPath.get();
            ClassPath testP = this.testPath.get();
            if (sourceP == null || testP == null) {
                return Collections.emptyList();
            }
            HashMap<FileObject, SourceGroup> grpsByRoot = new HashMap<FileObject, SourceGroup>();
            for (SourceGroup g : this.sources.getSourceGroups("java")) {
                grpsByRoot.put(g.getRootFolder(), g);
            }
            Comparator foc = (a, b) -> a.getNameExt().compareTo(b.getNameExt());
            return Stream.concat(Stream.concat(Stream.concat(Arrays.stream(sourceP.getRoots()).sorted(foc).map(fo -> Pair.of((Object)fo, (Object)false)), Arrays.stream(this.testPath.get().getRoots()).sorted(foc).map(fo -> Pair.of((Object)fo, (Object)true))).map(p -> {
                SourceGroup g = (SourceGroup)grpsByRoot.get(p.first());
                return g == null ? null : new Key(g, (Boolean)p.second(), false);
            }), Stream.of(Optional.ofNullable(this.procGenSrc.getGeneratedGroups(this.moduleName)).map(sg -> new Key((SourceGroup)sg, false, true)).orElse(null))).filter(p -> p != null), Stream.of(new Key(sourceP, false), new Key(testP, true))).collect(Collectors.toList());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("roots".equals(propName) || "generatedGroups".equals(propName)) {
                this.refresh.schedule(100);
            }
        }

        private static final class Key {
            private final boolean sources;
            private final boolean tests;
            private final boolean generated;
            private final SourceGroup sg;
            private final ClassPath sourcePath;
            private final FileObject[] sourceRoots;

            Key(@NonNull SourceGroup sg, boolean tests, boolean generated) {
                assert (sg != null);
                this.sources = true;
                this.sg = sg;
                this.sourcePath = null;
                this.sourceRoots = new FileObject[0];
                this.tests = tests;
                this.generated = generated;
            }

            Key(@NonNull ClassPath sourcePath, boolean tests) {
                assert (sourcePath != null);
                this.sources = false;
                this.sg = null;
                this.sourcePath = sourcePath;
                this.sourceRoots = this.sourcePath.getRoots();
                this.tests = tests;
                this.generated = false;
            }

            boolean isSource() {
                return this.sources;
            }

            boolean isTests() {
                return this.tests;
            }

            boolean isGenerated() {
                if (!this.sources) {
                    throw new IllegalStateException("Not a source key.");
                }
                return this.generated;
            }

            @NonNull
            SourceGroup getSourceGroup() {
                if (!this.sources) {
                    throw new IllegalStateException("Not a source key.");
                }
                return this.sg;
            }

            @NonNull
            private ClassPath getSourcePath() {
                if (this.sources) {
                    throw new IllegalStateException("Not a dependency key.");
                }
                return this.sourcePath;
            }

            @NonNull
            private FileObject[] getSourceRoots() {
                if (this.sources) {
                    throw new IllegalStateException("Not a dependency key.");
                }
                return this.sourceRoots;
            }

            public int hashCode() {
                int res = 17;
                res = res * 31 + (this.sources ? 1 : 0);
                res = res * 31 + (this.tests ? 1 : 0);
                res = res * 31 + (this.generated ? 1 : 0);
                res = res * 31 + Optional.ofNullable(this.sg).map(SourceGroup::getRootFolder).map(Object::hashCode).orElse(0);
                res = res * 31 + (this.sourceRoots.length == 0 ? 0 : 1);
                return res;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Key)) {
                    return false;
                }
                Key other = (Key)obj;
                return this.sources == other.sources && this.tests == other.tests && this.generated == other.generated && Key.sgEq(this.sg, other.sg) && (this.sourceRoots.length == 0 ? other.sourceRoots.length == 0 : other.sourceRoots.length != 0);
            }

            private static boolean sgEq(@NullAllowed SourceGroup a, @NullAllowed SourceGroup b) {
                if (a == null) {
                    return b == null;
                }
                if (b == null) {
                    return false;
                }
                FileObject afo = a.getRootFolder();
                FileObject bfo = b.getRootFolder();
                return afo == null ? bfo == null : afo.equals(bfo);
            }
        }
    }

    private static final class ModuleNode
    extends AbstractNode
    implements PropertyChangeListener,
    FileChangeListener,
    FileStatusListener {
        private static final String ICON = "org/netbeans/modules/java/api/common/project/ui/resources/module.png";
        private final Project prj;
        private final MultiModule modules;
        private final MultiModule testModules;
        private final String moduleName;
        private final RequestProcessor.Task annotationChangeTask;
        private ClassPath srcModPath;
        private ClassPath testModPath;
        private Set<? extends File> fosListensOn;
        private Collection<? extends FileObject> fosCache;
        private Collection<? extends Pair<FileSystem, FileStatusListener>> fsListensOn;
        private Action[] actions;
        private volatile boolean iconChanged;
        private volatile boolean nameChanged;

        ModuleNode(@NonNull ModuleKey key) {
            this(key, new DynLkp());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleNode(@NonNull ModuleKey key, @NonNull DynLkp lookup) {
            super((Children)new ModuleChildren(key), (Lookup)lookup);
            this.prj = key.getProject();
            this.modules = key.getSourceModules();
            this.testModules = key.getTestModules();
            this.moduleName = key.getModuleName();
            this.annotationChangeTask = RP.create(this::processAnnotationChange);
            ModuleNode moduleNode = this;
            synchronized (moduleNode) {
                this.fosListensOn = Collections.emptySet();
                this.fsListensOn = Collections.emptySet();
            }
            this.setIconBaseWithExtension(ICON);
            this.setName(this.moduleName);
            lookup.update(new Lookup[]{new ContentLkp(this, key.getProject(), new ModulePathFinder())});
            this.updateFileStatusListeners();
        }

        public String getShortDescription() {
            Collection<? extends FileObject> locs = this.getFileObjects();
            StringBuilder sb = new StringBuilder("<html>");
            boolean cadr = false;
            for (FileObject fileObject : locs) {
                if (cadr) {
                    sb.append("<br>\n");
                } else {
                    cadr = true;
                }
                sb.append(FileUtil.getFileDisplayName((FileObject)fileObject));
            }
            return sb.toString();
        }

        public Image getIcon(int type) {
            Pair<FileSystem, Set<? extends FileObject>> p;
            Image res = super.getIcon(type);
            HashSet<? extends FileObject> fos = new HashSet<FileObject>(this.getFileObjects());
            if (!fos.isEmpty() && (p = ModuleNode.findAnnotableFiles(fos)) != null) {
                res = FileUIUtils.getImageDecorator((FileSystem)((FileSystem)p.first())).annotateIcon(res, type, (Set)p.second());
            }
            return res;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            Pair<FileSystem, Set<? extends FileObject>> p;
            String dn = super.getDisplayName();
            HashSet<? extends FileObject> fos = new HashSet<FileObject>(this.getFileObjects());
            if (!fos.isEmpty() && (p = ModuleNode.findAnnotableFiles(fos)) != null) {
                dn = ((FileSystem)p.first()).getDecorator().annotateName(dn, (Set)p.second());
            }
            return dn;
        }

        public String getHtmlDisplayName() {
            Pair<FileSystem, Set<? extends FileObject>> p;
            String dn = super.getDisplayName();
            HashSet<? extends FileObject> fos = new HashSet<FileObject>(this.getFileObjects());
            if (!fos.isEmpty() && (p = ModuleNode.findAnnotableFiles(fos)) != null) {
                dn = ((FileSystem)p.first()).getDecorator().annotateNameHtml(dn, (Set)p.second());
            }
            if (dn != null && !super.getDisplayName().equals(dn)) {
                return dn;
            }
            return super.getHtmlDisplayName();
        }

        @NonNull
        public Action[] getActions(boolean context) {
            if (context) {
                return super.getActions(context);
            }
            if (this.actions == null) {
                this.actions = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(ToolsAction.class)};
            }
            return this.actions;
        }

        protected void createPasteTypes(@NonNull Transferable t, @NonNull List<PasteType> s) {
            ArrayList<Pair> res = new ArrayList<Pair>();
            for (FileObject fileObject : this.getFileObjects()) {
                if (!fileObject.canWrite()) continue;
                res.add(Pair.of((Object)fileObject, (Object)DataFolder.findFolder((FileObject)fileObject).getNodeDelegate().getPasteTypes(t)));
            }
            switch (res.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Collections.addAll(s, (Object[])((Pair)res.iterator().next()).second());
                    break;
                }
                default: {
                    for (Pair pair : res) {
                        FileObject fo = (FileObject)pair.first();
                        for (PasteType pt : (PasteType[])pair.second()) {
                            FileObject pdir = this.prj.getProjectDirectory();
                            String name = FileUtil.getRelativePath((FileObject)pdir, (FileObject)fo);
                            if (name != null) {
                                name.replace('/', File.separatorChar);
                            } else {
                                name = FileUtil.getFileDisplayName((FileObject)fo);
                            }
                            name = NbBundle.getMessage(MultiModuleNodeFactory.class, (String)"TXT_PasteInto", (Object)name);
                            s.add(new PasteInto(pt, name));
                        }
                    }
                }
            }
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            if ("roots".equals(evt.getPropertyName())) {
                this.reset();
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            this.reset();
        }

        public void fileDataCreated(FileEvent fe) {
            this.reset();
        }

        public void fileDeleted(FileEvent fe) {
            this.reset();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.reset();
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void annotationChanged(FileStatusEvent ev) {
            if (!this.iconChanged && ev.isIconChange() || !this.nameChanged && ev.isNameChange()) {
                for (FileObject fileObject : this.getFileObjects()) {
                    if (!ev.hasChanged(fileObject)) continue;
                    this.iconChanged |= ev.isIconChange();
                    this.nameChanged |= ev.isNameChange();
                    break;
                }
            }
            this.annotationChangeTask.schedule(100);
        }

        private void processAnnotationChange() {
            if (this.iconChanged) {
                this.iconChanged = false;
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (this.nameChanged) {
                this.nameChanged = false;
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            ModuleNode moduleNode = this;
            synchronized (moduleNode) {
                this.fosCache = null;
            }
            this.updateFileStatusListeners();
            this.fireShortDescriptionChange(null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private Collection<? extends FileObject> getFileObjects() {
            ClassPath tmp;
            ClassPath smp;
            Collection<? extends FileObject> res;
            ModuleNode moduleNode = this;
            synchronized (moduleNode) {
                res = this.fosCache;
                smp = this.srcModPath;
                if (smp == null) {
                    this.srcModPath = this.modules == null ? ClassPath.EMPTY : this.modules.getSourceModulePath();
                    smp = this.srcModPath;
                    smp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)smp));
                }
                if ((tmp = this.testModPath) == null) {
                    this.testModPath = this.testModules == null ? ClassPath.EMPTY : this.testModules.getSourceModulePath();
                    tmp = this.testModPath;
                    tmp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)tmp));
                }
            }
            if (res == null) {
                Set newFosListensOn = Stream.concat(smp.entries().stream(), tmp.entries().stream()).map(e -> FileUtil.archiveOrDirForURL((URL)e.getURL())).filter(f -> f != null).map(f -> new File((File)f, this.moduleName)).collect(Collectors.toSet());
                Comparator pathComparator = (a, b) -> a.getPath().compareTo(b.getPath());
                HashSet<FileObject> allLocs = new HashSet<FileObject>();
                ArrayList<? extends FileObject> srcLocs = new ArrayList<FileObject>();
                ArrayList<FileObject> testLocs = new ArrayList<FileObject>();
                for (FileObject loc : smp.findAllResources(this.moduleName)) {
                    if (allLocs.contains(loc) || !loc.isFolder()) continue;
                    srcLocs.add(loc);
                    allLocs.add(loc);
                }
                Collections.sort(srcLocs, pathComparator);
                for (FileObject loc : tmp.findAllResources(this.moduleName)) {
                    if (allLocs.contains(loc) || !loc.isFolder()) continue;
                    testLocs.add(loc);
                    allLocs.add(loc);
                }
                Collections.sort(testLocs, pathComparator);
                srcLocs.addAll(testLocs);
                res = srcLocs;
                ModuleNode moduleNode2 = this;
                synchronized (moduleNode2) {
                    this.fosCache = res;
                    for (File file : this.fosListensOn) {
                        FileUtil.removeFileChangeListener((FileChangeListener)this, (File)file);
                    }
                    for (File file : newFosListensOn) {
                        FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
                    }
                    this.fosListensOn = newFosListensOn;
                }
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFileStatusListeners() {
            HashSet<FileSystem> fileSystems = new HashSet<FileSystem>();
            for (FileObject fileObject : this.getFileObjects()) {
                try {
                    fileSystems.add(fileObject.getFileSystem());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    LOG.log(Level.WARNING, "Ignoring invalid file: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
                }
            }
            ModuleNode moduleNode = this;
            synchronized (moduleNode) {
                for (Pair<FileSystem, FileStatusListener> pair : this.fsListensOn) {
                    ((FileSystem)pair.first()).removeFileStatusListener((FileStatusListener)pair.second());
                }
                ArrayList<? extends Pair<FileSystem, FileStatusListener>> arrayList = new ArrayList<Pair<FileSystem, FileStatusListener>>();
                for (FileSystem fs : fileSystems) {
                    FileStatusListener l = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(l);
                    arrayList.add((Pair<FileSystem, FileStatusListener>)Pair.of((Object)fs, (Object)l));
                }
                this.fsListensOn = arrayList;
            }
        }

        @CheckForNull
        private static Pair<FileSystem, Set<? extends FileObject>> findAnnotableFiles(Collection<? extends FileObject> fos) {
            FileSystem fs = null;
            HashSet<FileObject> toAnnotate = new HashSet<FileObject>();
            for (FileObject fileObject : fos) {
                try {
                    FileSystem tmp = fileObject.getFileSystem();
                    if (fs == null) {
                        fs = tmp;
                        toAnnotate.add(fileObject);
                        continue;
                    }
                    if (!fs.equals(tmp)) continue;
                    toAnnotate.add(fileObject);
                }
                catch (FileStateInvalidException e) {
                    LOG.log(Level.WARNING, "Cannot determine annotations for invalid file: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
                }
            }
            return fs == null ? null : Pair.of(fs, toAnnotate);
        }

        private static final class ModulePathFinder
        implements PathFinder {
            ModulePathFinder() {
            }

            public Node findPath(Node root, Object target) {
                for (Node node : root.getChildren().getNodes(true)) {
                    Node result;
                    PathFinder pf = (PathFinder)node.getLookup().lookup(PathFinder.class);
                    if (pf == null || (result = pf.findPath(node, target)) == null) continue;
                    return result;
                }
                return null;
            }
        }

        private static final class PasteInto
        extends PasteType {
            private final PasteType delegate;
            private final String name;

            PasteInto(@NonNull PasteType delegate, @NonNull String name) {
                this.delegate = delegate;
                this.name = name;
            }

            public HelpCtx getHelpCtx() {
                return this.delegate.getHelpCtx();
            }

            public String getName() {
                return this.name;
            }

            public Transferable paste() throws IOException {
                return this.delegate.paste();
            }
        }

        private static final class ContentLkp
        extends ProxyLookup {
            private final AtomicReference<Pair<InstanceContent, Collection<? extends FileObject>>> fos;
            private final AtomicReference<Pair<InstanceContent, Collection<? extends FileObject>>> dos;
            private final ModuleNode node;

            ContentLkp(@NonNull ModuleNode node, Object ... fixedContent) {
                Parameters.notNull((CharSequence)"node", (Object)node);
                Parameters.notNull((CharSequence)"fixedContent", (Object)fixedContent);
                this.node = node;
                this.fos = new AtomicReference<Pair>(Pair.of((Object)new InstanceContent(), Collections.emptyList()));
                this.dos = new AtomicReference<Pair>(Pair.of((Object)new InstanceContent(), Collections.emptyList()));
                this.setLookups(new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.fos.get().first()), new AbstractLookup((AbstractLookup.Content)this.dos.get().first()), Lookups.fixed((Object[])fixedContent)});
            }

            protected void beforeLookup(Lookup.Template<?> template) {
                Collection newFos;
                Pair<InstanceContent, Collection<? extends FileObject>> p;
                Collection currentFos;
                super.beforeLookup(template);
                Class clz = template.getType();
                if (clz == FileObject.class) {
                    Collection newFos2;
                    Pair<InstanceContent, Collection<? extends FileObject>> p2 = this.fos.get();
                    Collection currentFos2 = (Collection)p2.second();
                    if (currentFos2 != (newFos2 = this.node.getFileObjects())) {
                        ((InstanceContent)p2.first()).set(newFos2, null);
                        this.fos.set((Pair<InstanceContent, Collection<? extends FileObject>>)Pair.of((Object)p2.first(), (Object)newFos2));
                    }
                } else if (clz == DataObject.class && (currentFos = (Collection)(p = this.dos.get()).second()) != (newFos = this.node.getFileObjects())) {
                    ((InstanceContent)p.first()).set(new ArrayList(newFos), (InstanceContent.Convertor)new DObjConvertor());
                }
            }

            private static final class DObjConvertor
            implements InstanceContent.Convertor<FileObject, DataObject> {
                private DObjConvertor() {
                }

                public DataObject convert(FileObject obj) {
                    try {
                        return DataObject.find((FileObject)obj);
                    }
                    catch (DataObjectNotFoundException e) {
                        return null;
                    }
                }

                public Class<? extends DataObject> type(FileObject obj) {
                    return DataObject.class;
                }

                public String id(FileObject obj) {
                    return obj.getPath();
                }

                public String displayName(FileObject obj) {
                    return FileUtil.getFileDisplayName((FileObject)obj);
                }
            }
        }

        private static final class DynLkp
        extends ProxyLookup {
            private DynLkp() {
            }

            void update(Lookup ... lkps) {
                this.setLookups(lkps);
            }
        }
    }

    private static final class ModuleKey {
        private final Project project;
        private final MultiModule sourceModules;
        private final MultiModule testModules;
        private final String moduleName;
        private final ProcessorGeneratedSources procGenSrc;
        private final LibrariesSupport libsSupport;

        ModuleKey(@NonNull Project project, @NonNull String moduleName, @NullAllowed MultiModule sourceModules, @NullAllowed MultiModule testModules, @NonNull ProcessorGeneratedSources procGenSrc, @NullAllowed LibrariesSupport libsSupport) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"moduleName", (Object)moduleName);
            Parameters.notNull((CharSequence)"procGenSrc", (Object)procGenSrc);
            this.project = project;
            this.moduleName = moduleName;
            this.sourceModules = sourceModules;
            this.testModules = testModules;
            this.procGenSrc = procGenSrc;
            this.libsSupport = libsSupport;
        }

        @NonNull
        String getModuleName() {
            return this.moduleName;
        }

        @CheckForNull
        MultiModule getSourceModules() {
            return this.sourceModules;
        }

        @CheckForNull
        MultiModule getTestModules() {
            return this.testModules;
        }

        @NonNull
        Project getProject() {
            return this.project;
        }

        @NonNull
        ProcessorGeneratedSources getProcessorGeneratedSources() {
            return this.procGenSrc;
        }

        @CheckForNull
        LibrariesSupport getLibrariesSupport() {
            return this.libsSupport;
        }

        public int hashCode() {
            return this.moduleName.hashCode();
        }

        public boolean equals(@NullAllowed Object other) {
            if (other == this) {
                return true;
            }
            if (other.getClass() != ModuleKey.class) {
                return false;
            }
            return ((ModuleKey)other).moduleName.equals(this.moduleName);
        }
    }

    private static final class Nodes
    implements NodeList<ModuleKey>,
    PropertyChangeListener {
        private final Project project;
        private final ProcessorGeneratedSources procGenSrc;
        private final MultiModule sourceModules;
        private final MultiModule testModules;
        private final LibrariesSupport libsSupport;
        private final ChangeSupport listeners;

        Nodes(@NonNull Project project, @NonNull ProcessorGeneratedSources procGenSrc, @NullAllowed MultiModule sourceModules, @NullAllowed MultiModule testModules, @NullAllowed LibrariesSupport libsSupport) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"procGenSrc", (Object)procGenSrc);
            this.project = project;
            this.procGenSrc = procGenSrc;
            this.sourceModules = sourceModules;
            this.testModules = testModules;
            this.libsSupport = libsSupport;
            this.listeners = new ChangeSupport((Object)this);
        }

        public List<ModuleKey> keys() {
            return Stream.concat(this.sourceModules == null ? Stream.empty() : this.sourceModules.getModuleNames().stream(), this.testModules == null ? Stream.empty() : this.testModules.getModuleNames().stream()).sorted().distinct().map(name -> new ModuleKey(this.project, (String)name, this.sourceModules, this.testModules, this.procGenSrc, this.libsSupport)).collect(Collectors.toList());
        }

        public void addChangeListener(@NonNull ChangeListener l) {
            this.listeners.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.listeners.removeChangeListener(l);
        }

        public Node node(@NonNull ModuleKey key) {
            return new ModuleNode(key);
        }

        public void addNotify() {
            if (this.sourceModules != null) {
                this.sourceModules.addPropertyChangeListener(this);
            }
            if (this.testModules != null) {
                this.testModules.addPropertyChangeListener(this);
            }
        }

        public void removeNotify() {
            if (this.sourceModules != null) {
                this.sourceModules.removePropertyChangeListener(this);
            }
            if (this.testModules != null) {
                this.testModules.removePropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("modules".equals(evt.getPropertyName())) {
                this.listeners.fireChange();
            }
        }
    }

    public static final class Builder {
        private final UpdateHelper helper;
        private final PropertyEvaluator eval;
        private final ReferenceHelper refHelper;
        private LibrariesSupport.Builder libSupport;
        private MultiModule mods;
        private MultiModule testMods;
        private String procGenSourcesProp;

        private Builder(@NonNull UpdateHelper helper, @NonNull PropertyEvaluator eval, @NonNull ReferenceHelper refHelper) {
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"refHelper", (Object)refHelper);
            this.helper = helper;
            this.eval = eval;
            this.refHelper = refHelper;
            this.procGenSourcesProp = "annotation.processing.source.output";
        }

        @NonNull
        public Builder setSources(@NonNull SourceRoots sourceModules, @NonNull SourceRoots srcRoots) {
            this.mods = MultiModule.getOrCreate(sourceModules, srcRoots);
            return this;
        }

        @NonNull
        public Builder setTests(@NonNull SourceRoots testModules, @NonNull SourceRoots testRoots) {
            this.testMods = MultiModule.getOrCreate(testModules, testRoots);
            return this;
        }

        @NonNull
        public Builder addLibrariesNodes() {
            this.libSupport = new LibrariesSupport.Builder();
            return this;
        }

        @NonNull
        public Builder addLibrariesNodeActions(Action ... actions) {
            if (this.libSupport == null) {
                throw new IllegalStateException("Libraries are not enabled");
            }
            this.libSupport.addActions(false, actions);
            return this;
        }

        @NonNull
        public Builder addTestLibrariesNodeActions(Action ... actions) {
            if (this.libSupport == null) {
                throw new IllegalStateException("Libraries are not enabled");
            }
            this.libSupport.addActions(true, actions);
            return this;
        }

        @NonNull
        public Builder setAnnotationProcessorsGeneratedSourcesProperty(@NonNull String propName) {
            Parameters.notNull((CharSequence)"propName", (Object)propName);
            this.procGenSourcesProp = propName;
            return this;
        }

        @NonNull
        public MultiModuleNodeFactory build() {
            return new MultiModuleNodeFactory(this.mods, this.testMods, new ProcessorGeneratedSources(this.helper, this.eval, this.procGenSourcesProp), this.libSupport == null ? null : this.libSupport.build(this.helper, this.eval, this.refHelper));
        }

        @NonNull
        public static Builder create(@NonNull UpdateHelper helper, @NonNull PropertyEvaluator eval, @NonNull ReferenceHelper refHelper) {
            return new Builder(helper, eval, refHelper);
        }
    }
}

