/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.php.analysis.CodingStandardsFixerParams;
import org.netbeans.modules.php.analysis.commands.Bundle;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.parsers.CodingStandardsFixerReportParser;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class CodingStandardsFixer {
    static final Logger LOGGER = Logger.getLogger(CodingStandardsFixer.class.getName());
    public static final String NAME = "php-cs-fixer";
    public static final String LONG_NAME = "php-cs-fixer.phar";
    static final File XML_LOG = new File(System.getProperty("java.io.tmpdir"), "nb-php-phpcsfixer-log.xml");
    private static final String FIX_COMMAND = "fix";
    private static final String LIST_COMMAND = "list";
    private static final String SELF_UPDATE_COMMAND = "self-update";
    private static final String ANSI_PARAM = "--ansi";
    private static final String HELP_PARAM = "--help";
    private static final String NO_ANSI_PARAM = "--no-ansi";
    private static final String NO_INTERACTION_PARAM = "--no-interaction";
    private static final String VERBOSE_PARAM = "--verbose";
    private static final String DIFF_PARAM = "--diff";
    private static final String DRY_RUN_PARAM = "--dry-run";
    private static final String CONFIG_PARAM = "--config=%s";
    private static final String LEVEL_PARAM = "--level=%s";
    private static final String FIXERS_PARAM = "--fixers=%s";
    private static final String FORMAT_XML_PARAM = "--format=xml";
    private static final List<String> ANALYZE_DEFAULT_PARAMS = Arrays.asList("--no-ansi", "--verbose", "--dry-run", "--diff", "--format=xml", "--no-interaction");
    private static final List<String> DEFAULT_PARAMS = Arrays.asList("--ansi", "--no-interaction");
    @SuppressWarnings(value={"MS_MUTABLE_COLLECTION"}, justification="It is immutable")
    public static final List<String> VERSIONS = Arrays.asList("1", "2");
    @SuppressWarnings(value={"MS_MUTABLE_COLLECTION"}, justification="It is immutable")
    public static final List<String> ALL_LEVEL = Arrays.asList("", "psr0", "psr1", "psr2", "symfony");
    @SuppressWarnings(value={"MS_MUTABLE_COLLECTION"}, justification="It is immutable")
    public static final List<String> ALL_CONFIG = Arrays.asList("", "default", "mangento", "sf23");
    private final String codingStandardsFixerPath;
    private int analyzeGroupCounter = 1;

    private CodingStandardsFixer(String codingStandardsFixerPath) {
        this.codingStandardsFixerPath = codingStandardsFixerPath;
    }

    public static CodingStandardsFixer getDefault() throws InvalidPhpExecutableException {
        String codingStandardsFixerPath = AnalysisOptions.getInstance().getCodingStandardsFixerPath();
        String error = CodingStandardsFixer.validate(codingStandardsFixerPath);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new CodingStandardsFixer(codingStandardsFixerPath);
    }

    public static String validate(String codingStandardsFixerPath) {
        return PhpExecutableValidator.validateCommand((String)codingStandardsFixerPath, (String)Bundle.CodingStandardsFixer_script_label());
    }

    public void startAnalyzeGroup() {
        this.analyzeGroupCounter = 1;
    }

    public Future<Integer> selfUpdate(PhpModule phpModule) {
        return this.runCommand(phpModule, SELF_UPDATE_COMMAND, Bundle.CodingStandardsFixer_script_run(SELF_UPDATE_COMMAND));
    }

    private Future<Integer> runCommand(PhpModule phpModule, String command, String title) {
        return this.runCommand(phpModule, command, title, Collections.emptyList());
    }

    private Future<Integer> runCommand(PhpModule phpModule, String command, String title, List<String> params) {
        PhpExecutable phpcsfixer = this.getExecutable(phpModule, title);
        if (phpcsfixer == null) {
            return null;
        }
        return phpcsfixer.additionalParameters(this.mergeParameters(command, DEFAULT_PARAMS, params)).run(this.getDescriptor(phpModule));
    }

    private List<String> mergeParameters(String command, List<String> defaultParams, List<String> params) {
        ArrayList<String> allParams = new ArrayList<String>(defaultParams.size() + params.size() + 1);
        allParams.add(command);
        allParams.addAll(params);
        allParams.addAll(defaultParams);
        return allParams;
    }

    @CheckForNull
    public List<Result> analyze(CodingStandardsFixerParams params, FileObject file) {
        assert (file.isValid()) : "Invalid file given: " + file;
        try {
            Integer result = this.getExecutable(Bundle.CodingStandardsFixer_analyze(this.analyzeGroupCounter++)).additionalParameters(this.getParameters(params, file)).runAndWait(this.getDescriptor(), "Running coding standards fixer...");
            if (result == null) {
                return null;
            }
            return CodingStandardsFixerReportParser.parse(XML_LOG, file);
        }
        catch (CancellationException ex) {
            return Collections.emptyList();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            UiUtils.processExecutionException((ExecutionException)ex, (String)"CodeAnalysis");
            return null;
        }
    }

    private PhpExecutable getExecutable(PhpModule phpModule, String title) {
        return new PhpExecutable(this.codingStandardsFixerPath).optionsSubcategory("CodeAnalysis").displayName(title);
    }

    private PhpExecutable getExecutable(String title) {
        return new PhpExecutable(this.codingStandardsFixerPath).optionsSubcategory("CodeAnalysis").fileOutput(XML_LOG, "UTF-8", false).redirectErrorStream(false).displayName(title);
    }

    private ExecutionDescriptor getDescriptor(PhpModule phpModule) {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/CodeAnalysis");
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/CodeAnalysis").frontWindowOnError(false).inputVisible(false).preExecution(new Runnable(){

            @Override
            public void run() {
                if (XML_LOG.isFile() && !XML_LOG.delete()) {
                    LOGGER.log(Level.INFO, "Cannot delete log file {0}", XML_LOG.getAbsolutePath());
                }
            }
        });
    }

    private List<String> getParameters(CodingStandardsFixerParams parameters, FileObject file) {
        String options;
        ArrayList<String> params = new ArrayList<String>();
        params.add(FIX_COMMAND);
        params.addAll(ANALYZE_DEFAULT_PARAMS);
        String version = parameters.getVersion();
        if ("1".equals(version)) {
            String config;
            String level = parameters.getLevel();
            if (!StringUtils.isEmpty((String)level)) {
                params.add(String.format(LEVEL_PARAM, level));
            }
            if (!StringUtils.isEmpty((String)(config = parameters.getConfig()))) {
                params.add(String.format(CONFIG_PARAM, config));
            }
        }
        if (!StringUtils.isEmpty((String)(options = parameters.getOptions()))) {
            params.addAll(StringUtils.explode((String)options, (String)" "));
        }
        params.add(FileUtil.toFile((FileObject)file).getAbsolutePath());
        return params;
    }
}

