/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ant;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.debugger.jpda.ant.JPDAStart;
import org.openide.util.RequestProcessor;

public class JPDAConnect
extends Task {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.ant");
    private RequestProcessor rp = new RequestProcessor("JPDAConnect", 1);
    private String host = "localhost";
    private String address;
    private JPDAStart.Sourcepath sourcepath = null;
    private Path modulepath = null;
    private Path classpath = null;
    private Path bootclasspath = null;
    private String listeningCP = null;
    private String name;
    private String transport = "dt_socket";

    public void setHost(String h) {
        this.host = h;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    private String getAddress() {
        return this.address;
    }

    public void addModulepath(Path path) {
        logger.log(Level.FINE, "addModlepath({0})", path);
        if (this.modulepath != null) {
            throw new BuildException("Only one modulepath subelement is supported");
        }
        this.modulepath = path;
    }

    public void addClasspath(Path path) {
        logger.fine("addClasspath(" + path + ")");
        if (this.classpath != null) {
            throw new BuildException("Only one classpath subelement is supported");
        }
        this.classpath = path;
    }

    public void addBootclasspath(Path path) {
        logger.fine("addBootclasspath(" + path + ")");
        if (this.bootclasspath != null) {
            throw new BuildException("Only one bootclasspath subelement is supported");
        }
        this.bootclasspath = path;
    }

    public void addSourcepath(JPDAStart.Sourcepath path) {
        logger.fine("addSourcepath(" + (Object)((Object)path) + ")");
        if (this.sourcepath != null) {
            throw new BuildException("Only one sourcepath subelement is supported");
        }
        this.sourcepath = path;
    }

    public void setListeningcp(String listeningCP) {
        this.listeningCP = listeningCP;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    private String getTransport() {
        return this.transport;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        logger.fine("JPDAConnect.execute ()");
        Path plainSourcepath = null;
        boolean isSourcePathExclusive = false;
        if (this.sourcepath != null) {
            isSourcePathExclusive = this.sourcepath.isExclusive();
            plainSourcepath = this.sourcepath.getPlainPath();
        }
        JPDAStart.verifyPaths(this.getProject(), this.classpath);
        JPDAStart.verifyPaths(this.getProject(), this.modulepath);
        JPDAStart.verifyPaths(this.getProject(), plainSourcepath);
        if (this.name == null) {
            throw new BuildException("name attribute must specify name of this debugging session", this.getLocation());
        }
        if (this.address == null) {
            throw new BuildException("address attribute must specify port number or memory allocation unit name of connection", this.getLocation());
        }
        if (this.transport == null) {
            this.transport = "dt_socket";
        }
        final Object[] lock = new Object[1];
        ClassPath sourcePath = JPDAStart.createSourcePath(this.getProject(), this.modulepath, this.classpath, plainSourcepath, isSourcePathExclusive);
        ClassPath jdkSourcePath = JPDAStart.createJDKSourcePath(this.getProject(), this.bootclasspath);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Create sourcepath:");
            logger.fine("    modulepath : " + this.modulepath);
            logger.fine("    classpath : " + this.classpath);
            logger.fine("    sourcepath : " + plainSourcepath);
            logger.fine("    bootclasspath : " + this.bootclasspath);
            logger.fine("    >> sourcePath : " + sourcePath);
            logger.fine("    >> jdkSourcePath : " + jdkSourcePath);
        }
        final HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("sourcepath", sourcePath);
        properties.put("name", this.getName());
        properties.put("jdksources", jdkSourcePath);
        properties.put("listeningCP", this.listeningCP);
        String workDir = this.getProject().getProperty("work.dir");
        File baseDir = workDir != null ? new File(workDir) : this.getProject().getBaseDir();
        properties.put("baseDir", baseDir);
        logger.fine("JPDAConnect: properties = " + properties);
        Object[] objectArray = lock;
        synchronized (lock) {
            this.rp.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object[] objectArray = lock;
                    synchronized (lock) {
                        try {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("JPDAConnect.execute ().synchronized: host = " + JPDAConnect.this.host + " port = " + JPDAConnect.this.address + " transport = " + JPDAConnect.this.transport);
                            }
                            if (JPDAConnect.this.transport.equals("dt_socket")) {
                                try {
                                    JPDADebugger.attach((String)JPDAConnect.this.host, (int)Integer.parseInt(JPDAConnect.this.address), (Object[])new Object[]{properties});
                                }
                                catch (NumberFormatException e) {
                                    throw new BuildException("address attribute must specify port number for dt_socket connection", JPDAConnect.this.getLocation());
                                }
                            } else {
                                JPDADebugger.attach((String)JPDAConnect.this.address, (Object[])new Object[]{properties});
                            }
                            logger.fine("JPDAConnect.execute ().synchronized end: success");
                        }
                        catch (Throwable e) {
                            logger.fine("JPDAConnect.execute().synchronized end: exception " + e);
                            lock[0] = e;
                        }
                        finally {
                            lock.notify();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                logger.fine("JPDAConnect.execute() end: exception " + e);
                throw new BuildException((Throwable)e);
            }
            if (lock[0] != null) {
                logger.fine("JPDAConnect.execute() end: exception " + lock[0]);
                throw new BuildException((Throwable)lock[0]);
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            if (this.host == null) {
                this.log("Attached JPDA debugger to " + this.address);
            } else {
                this.log("Attached JPDA debugger to " + this.host + ":" + this.address);
            }
            logger.fine("JPDAConnect.execute () end: success");
            return;
        }
    }
}

