/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.merge;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.libs.git.GitRepository;
import org.netbeans.modules.git.ui.merge.MergeRevisionPanel;
import org.netbeans.modules.git.ui.repository.RevisionDialogController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MergeRevision {
    private final MergeRevisionPanel panel;
    private final RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;
    private boolean valid = true;
    private final GitRepository.FastForwardOption ffOption;

    MergeRevision(File repository, File[] roots, String initialRevision, GitRepository.FastForwardOption defaultFFOption) {
        this.ffOption = defaultFFOption;
        this.revisionPicker = new RevisionDialogController(repository, roots, initialRevision);
        this.revisionPicker.setMergingInto("HEAD");
        this.panel = new MergeRevisionPanel(this.revisionPicker.getPanel());
        this.initFFOptions();
    }

    String getRevision() {
        return this.revisionPicker.getRevision().getRevision();
    }

    boolean show() {
        this.okButton = new JButton(NbBundle.getMessage(MergeRevision.class, (String)"LBL_MergeRevision.OKButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(MergeRevision.class, (String)"LBL_MergeRevision.title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx("org.netbeans.modules.git.ui.merge.MergeRevision"), null);
        this.enableRevisionPanel();
        this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "RevisionDialogController.valid") {
                    MergeRevision.this.setValid(Boolean.TRUE.equals(evt.getNewValue()));
                }
            }
        });
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    GitRepository.FastForwardOption getFFOption() {
        if (this.panel.rbFFOptionOnly.isSelected()) {
            return GitRepository.FastForwardOption.FAST_FORWARD_ONLY;
        }
        if (this.panel.rbFFOptionNever.isSelected()) {
            return GitRepository.FastForwardOption.NO_FAST_FORWARD;
        }
        return GitRepository.FastForwardOption.FAST_FORWARD;
    }

    private void enableRevisionPanel() {
        this.setValid(this.valid);
    }

    private void setValid(boolean flag) {
        this.valid = flag;
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
    }

    private void initFFOptions() {
        switch (this.ffOption) {
            case FAST_FORWARD: {
                this.panel.rbFFOption.setSelected(true);
                break;
            }
            case FAST_FORWARD_ONLY: {
                this.panel.rbFFOptionOnly.setSelected(true);
                break;
            }
            case NO_FAST_FORWARD: {
                this.panel.rbFFOptionNever.setSelected(true);
            }
        }
    }
}

