/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.migration.archiver.XMLInputStream;
import org.netbeans.modules.dbschema.util.NameUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class SchemaElementUtil {
    private static FileObject schemaFO = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaElement forName(String name, Object obj) {
        SchemaElement se = SchemaElement.getLastSchema();
        if (se != null && se.getName().getFullName().equals(name) && schemaFO == null) {
            return se;
        }
        Map map = SchemaElement.schemaCache;
        synchronized (map) {
            String tempURL = "";
            if (schemaFO != null) {
                try {
                    tempURL = schemaFO.getURL().toString();
                }
                catch (Exception exc) {
                    Logger.getLogger("global").log(Level.INFO, null, exc);
                }
            }
            if ((se = schemaFO == null ? (SchemaElement)SchemaElement.schemaCache.get(name) : (SchemaElement)SchemaElement.schemaCache.get(name + "#" + tempURL)) != null) {
                return se;
            }
            FileObject fo = null;
            if (schemaFO == null) {
                if (obj instanceof FileObject) {
                    fo = SchemaElementUtil.findResource((FileObject)obj, name);
                } else if (obj instanceof FileObject[]) {
                    FileObject[] sourceRoots = (FileObject[])obj;
                    for (int i = 0; fo == null && i < sourceRoots.length; ++i) {
                        fo = SchemaElementUtil.findResource(sourceRoots[i], name);
                    }
                } else if (obj != null) {
                    throw new UnsupportedOperationException("Cannot lookup schema " + name + " in context of type " + obj.getClass() + " expected FileObject, FileObject[], or null.");
                }
            } else {
                fo = schemaFO;
            }
            if (fo != null && fo.isValid()) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fo);
                    if (dataObject != null) {
                        se = (SchemaElement)dataObject.getCookie(SchemaElement.class);
                    }
                }
                catch (ClassCastException dataObject) {
                }
                catch (DataObjectNotFoundException e) {
                    Logger.getLogger("global").log(Level.INFO, null, e);
                }
                if (se == null) {
                    try {
                        StatusDisplayer.getDefault().setStatusText(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("RetrievingSchema"));
                        InputStream s = fo.getInputStream();
                        XMLInputStream i = new XMLInputStream(s);
                        se = (SchemaElement)i.readObject();
                        if (!se.isCompatibleVersion()) {
                            String message = MessageFormat.format(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("PreviousVersion"), name);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                        }
                        i.close();
                        se.setName(DBIdentifier.create(name));
                        if (schemaFO == null) {
                            SchemaElement.addToCache(se);
                        } else {
                            SchemaElement.schemaCache.put(name + "#" + tempURL, se);
                            SchemaElement.setLastSchema(se);
                        }
                        TableElement[] tables = se.getTables();
                        int size = tables != null ? tables.length : 0;
                        for (int j = 0; j < size; ++j) {
                            tables[j].setDeclaringSchema(se);
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger("global").log(Level.INFO, null, e);
                        StatusDisplayer.getDefault().setStatusText(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("CannotRetrieve"));
                    }
                }
            } else {
                Logger.getLogger("global").log(Level.FINE, ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("SchemaNotFound"));
            }
            return se;
        }
    }

    public static SchemaElement forName(FileObject fo) {
        schemaFO = fo;
        SchemaElement se = SchemaElementUtil.forName(fo.getName(), null);
        schemaFO = null;
        return se;
    }

    private static FileObject findResource(FileObject sourceRoot, String name) {
        return sourceRoot.getFileObject(NameUtil.getSchemaResourceName(name));
    }
}

