/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.actions;

import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.ServerNodeProvider;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;

public class AdministerAction
extends CookieAction {
    private static final Class[] COOKIE_CLASSES = new Class[]{DatabaseServer.class};

    public AdministerAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Utils.getBundle().getString("LBL_AdministerAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AdministerAction.class);
    }

    public boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        return ServerNodeProvider.getDefault().isRegistered();
    }

    protected void performAction(Node[] activatedNodes) {
        DatabaseServer server = (DatabaseServer)activatedNodes[0].getCookie(DatabaseServer.class);
        String path = server.getAdminPath();
        String message = Utils.getBundle().getString("MSG_NoAdminPath");
        PropertiesDialog dialog = new PropertiesDialog(server);
        while (path == null || path.equals("")) {
            if (!Utils.displayConfirmDialog(message)) {
                return;
            }
            if (!dialog.displayDialog(PropertiesDialog.Tab.ADMIN)) {
                return;
            }
            path = server.getAdminPath();
        }
        try {
            server.startAdmin();
        }
        catch (DatabaseException e) {
            Utils.displayError(Utils.getMessage("MSG_ErrorStartingAdminTool", new Object[0]), (Exception)((Object)e));
        }
    }

    protected int mode() {
        return 8;
    }

    protected Class<?>[] cookieClasses() {
        return COOKIE_CLASSES;
    }
}

