/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class SetRemoteCommand
extends GitCommand {
    private final GitRemoteConfig remote;
    private static final String KEY_URL = "url";
    private static final String KEY_PUSHURL = "pushurl";
    private static final String KEY_FETCH = "fetch";
    private static final String KEY_PUSH = "push";

    public SetRemoteCommand(Repository repository, GitClassFactory gitFactory, GitRemoteConfig remoteConfig, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.remote = remoteConfig;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        StoredConfig config = repository.getConfig();
        boolean finished = false;
        try {
            config.unset("remote", this.remote.getRemoteName(), KEY_URL);
            config.unset("remote", this.remote.getRemoteName(), KEY_PUSHURL);
            config.unset("remote", this.remote.getRemoteName(), KEY_FETCH);
            config.unset("remote", this.remote.getRemoteName(), KEY_PUSH);
            RemoteConfig cfg = new RemoteConfig((Config)config, this.remote.getRemoteName());
            for (String uri : this.remote.getUris()) {
                cfg.addURI(new URIish(uri));
            }
            for (String uri : this.remote.getPushUris()) {
                cfg.addPushURI(new URIish(uri));
            }
            for (String spec : this.remote.getFetchRefSpecs()) {
                cfg.addFetchRefSpec(new RefSpec(spec));
            }
            for (String spec : this.remote.getPushRefSpecs()) {
                cfg.addPushRefSpec(new RefSpec(spec));
            }
            cfg.update((Config)config);
            config.save();
            finished = true;
        }
        catch (Exception ex) {
            throw new GitException(ex);
        }
        finally {
            if (!finished) {
                try {
                    if (config instanceof FileBasedConfig) {
                        FileBasedConfig fileConfig = (FileBasedConfig)config;
                        fileConfig.clear();
                    }
                    config.load();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        return "setting up remote: " + this.remote.getRemoteName();
    }
}

