/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.math.BigInteger;
import org.bouncycastle.util.Arrays;

class SSHBuffer {
    private final byte[] buffer;
    private int pos = 0;

    public SSHBuffer(byte[] byArray, byte[] byArray2) {
        this.buffer = byArray2;
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            throw new IllegalArgumentException("magic-number incorrect");
        }
        this.pos += byArray.length;
    }

    public SSHBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    public int readU32() {
        if (this.pos + 4 > this.buffer.length) {
            throw new IllegalArgumentException("4 bytes for U32 exceeds buffer.");
        }
        int n = (this.buffer[this.pos++] & 0xFF) << 24;
        n |= (this.buffer[this.pos++] & 0xFF) << 16;
        n |= (this.buffer[this.pos++] & 0xFF) << 8;
        return n |= this.buffer[this.pos++] & 0xFF;
    }

    public byte[] readString() {
        int n = this.readU32();
        if (n == 0) {
            return new byte[0];
        }
        if (this.pos + n > this.buffer.length) {
            throw new IllegalArgumentException("not enough data for string");
        }
        return Arrays.copyOfRange(this.buffer, this.pos, this.pos += n);
    }

    public byte[] readPaddedString() {
        int n = this.readU32();
        if (n == 0) {
            return new byte[0];
        }
        if (this.pos + n > this.buffer.length) {
            throw new IllegalArgumentException("not enough data for string");
        }
        return Arrays.copyOfRange(this.buffer, this.pos, this.pos += n - (this.buffer[this.pos + n - 1] & 0xFF));
    }

    public BigInteger positiveBigNum() {
        int n = this.readU32();
        if (this.pos + n > this.buffer.length) {
            throw new IllegalArgumentException("not enough data for big num");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, this.pos, byArray, 0, byArray.length);
        this.pos += n;
        return new BigInteger(1, byArray);
    }

    public byte[] getBuffer() {
        return Arrays.clone(this.buffer);
    }

    public boolean hasRemaining() {
        return this.pos < this.buffer.length;
    }
}

