/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.CoroutineIntrinsicLambdaOrigin;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ArrayConstructorTransformer;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.DeepCopyIrTreeWithSymbolsForInliner;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrMemberAccessExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnableBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrReturnableBlockSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/Context;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "arrayConstructorTransformer", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ArrayConstructorTransformer;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "inlineConstructor", "Lorg/jetbrains/kotlin/name/FqName;", "isInlineConstructor", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "needsInlining", "getNeedsInlining", "getFunctionDeclaration", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "inline", "Lorg/jetbrains/kotlin/ir/IrElement;", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "Inliner", "backend.js"})
public final class FunctionInlining
extends IrElementTransformerVoidWithContext {
    private final ArrayConstructorTransformer arrayConstructorTransformer;
    private final FqName inlineConstructor;
    @NotNull
    private final JsIrBackendContext context;

    @NotNull
    public final IrElement inline(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkParameterIsNotNull(irModule, "irModule");
        return (IrElement)irModule.accept(this, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrFunctionAccessExpression irFunctionAccessExpression2 = expression2;
        if (irFunctionAccessExpression2 instanceof IrCall) {
            irFunctionAccessExpression = expression2;
        } else if (irFunctionAccessExpression2 instanceof IrConstructorCall) {
            irFunctionAccessExpression = this.arrayConstructorTransformer.transformConstructorCall((IrConstructorCall)expression2);
        } else {
            return expression2;
        }
        IrFunctionAccessExpression callSite = irFunctionAccessExpression;
        if (!this.getNeedsInlining(callSite.getSymbol().getOwner())) {
            return callSite;
        }
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getConfiguration());
        if (Symbols.Companion.isLateinitIsInitializedPropertyGetter(callSite.getSymbol())) {
            return callSite;
        }
        if (CommonCoroutineCodegenUtilKt.isBuiltInIntercepted(callSite.getDescriptor(), languageVersionSettings)) {
            String string = "Continuation.intercepted is not available with release coroutines";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineUninterceptedOrReturn(callSite.getSymbol().getDescriptor(), languageVersionSettings)) {
            return IrUtilsKt.irCall$default((IrMemberAccessExpression)callSite, this.context.getCoroutineSuspendOrReturn(), false, false, 12, null);
        }
        if (Intrinsics.areEqual(callSite.getSymbol(), this.context.getIntrinsics().getJsCoroutineContext())) {
            return IrUtilsKt.irCall$default((IrMemberAccessExpression)callSite, this.context.getCoroutineGetContextJs(), false, false, 12, null);
        }
        IrFunction callee = this.getFunctionDeclaration(callSite.getSymbol());
        IrElementTransformerVoidKt.transformChildrenVoid(callee, this);
        Iterable $this$map$iv = this.getAllScopes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScopeWithIr scopeWithIr = (ScopeWithIr)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrElement irElement = it.getIrElement();
            collection.add(irElement);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrDeclarationParent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        IrDeclarationParent parent2 = (IrDeclarationParent)CollectionsKt.lastOrNull((List)destination$iv$iv);
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        if (scopeWithIr == null) {
            Intrinsics.throwNpe();
        }
        Inliner inliner = new Inliner(callSite, callee, scopeWithIr, parent2, this.context);
        return inliner.inline();
    }

    private final IrFunction getFunctionDeclaration(IrFunctionSymbol symbol2) {
        IrSimpleFunction irSimpleFunction;
        IrFunction irFunction = symbol2.getOwner();
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        return (irSimpleFunction = (IrSimpleFunction)irFunction) != null && (irSimpleFunction = IrUtilsKt.resolveFakeOverride(irSimpleFunction)) != null ? (IrFunction)irSimpleFunction : symbol2.getOwner();
    }

    private final boolean isInlineConstructor(@NotNull IrFunction $this$isInlineConstructor) {
        return AdditionalIrUtilsKt.hasAnnotation($this$isInlineConstructor.getAnnotations(), this.inlineConstructor);
    }

    private final boolean getNeedsInlining(@NotNull IrFunction $this$needsInlining) {
        return this.isInlineConstructor($this$needsInlining) || $this$needsInlining.isInline() && !$this$needsInlining.isExternal();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public FunctionInlining(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.arrayConstructorTransformer = new ArrayConstructorTransformer(this.context);
        this.inlineConstructor = new FqName("kotlin.native.internal.InlineConstructor");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u000267B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ&\u0010\"\u001a\u0010\u0012\f\u0012\n0$R\u00060\u0000R\u00020%0#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0003H\u0002J\f\u0010.\u001a\u00020,*\u00020\u001eH\u0002J3\u0010/\u001a\u000200\"\n\b\u0000\u00101\u0018\u0001*\u000202*\b\u0012\u0004\u0012\u0002H1032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u00020205H\u0082\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining$Inliner;", "", "callSite", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "currentScope", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/Context;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getCallSite", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getCallee", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "copyIrElement", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/DeepCopyIrTreeWithSymbolsForInliner;", "getCopyIrElement", "()Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/DeepCopyIrTreeWithSymbolsForInliner;", "getCurrentScope", "()Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "getParent", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "substituteMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getSubstituteMap", "()Ljava/util/Map;", "buildParameterToArgument", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining$Inliner$ParameterToArgument;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining;", "evaluateArguments", "Lorg/jetbrains/kotlin/ir/IrStatement;", "inline", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "inlineFunction", "isLambdaCall", "", "irCall", "isInlineParameter", "transform", "", "T", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "transformation", "Lkotlin/Function1;", "ParameterSubstitutor", "ParameterToArgument", "backend.js"})
    private final class Inliner {
        @NotNull
        private final DeepCopyIrTreeWithSymbolsForInliner copyIrElement;
        @NotNull
        private final Map<IrValueParameter, IrExpression> substituteMap;
        @NotNull
        private final IrFunctionAccessExpression callSite;
        @NotNull
        private final IrFunction callee;
        @NotNull
        private final ScopeWithIr currentScope;
        @Nullable
        private final IrDeclarationParent parent;
        @NotNull
        private final JsIrBackendContext context;

        @NotNull
        public final DeepCopyIrTreeWithSymbolsForInliner getCopyIrElement() {
            return this.copyIrElement;
        }

        @NotNull
        public final Map<IrValueParameter, IrExpression> getSubstituteMap() {
            return this.substituteMap;
        }

        @NotNull
        public final IrReturnableBlock inline() {
            return this.inlineFunction(this.callSite, this.callee);
        }

        /*
         * WARNING - void declaration
         */
        private final IrReturnableBlock inlineFunction(IrFunctionAccessExpression callSite, IrFunction callee) {
            void $this$transform$iv;
            IrStatement element$iv;
            Object $this$forEach$iv;
            int n;
            boolean bl;
            Object object;
            IrElement irElement = this.copyIrElement.copy(callee);
            if (irElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
            }
            IrFunction copiedCallee = (IrFunction)irElement;
            List<IrStatement> evaluationStatements = this.evaluateArguments(callSite, copiedCallee);
            IrBody irBody = copiedCallee.getBody();
            if (irBody == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
            }
            List<IrStatement> statements = ((IrBlockBody)irBody).getStatements();
            FunctionDescriptor functionDescriptor = copiedCallee.getDescriptor().getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "copiedCallee.descriptor.original");
            IrReturnableBlockSymbolImpl irReturnableBlockSymbol = new IrReturnableBlockSymbolImpl(functionDescriptor);
            int startOffset = callee.getStartOffset();
            int endOffset = callee.getEndOffset();
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder(this.context, irReturnableBlockSymbol, startOffset, endOffset);
            if (FunctionInlining.this.isInlineConstructor(callee)) {
                IrDeclarationWithName it;
                IrClass constructedClass = IrUtilsKt.getParentAsClass(callee);
                copiedCallee.setParent(constructedClass);
                IrStatement irStatement = statements.get(0);
                if (irStatement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall");
                }
                IrDelegatingConstructorCall delegatingConstructorCall = (IrDelegatingConstructorCall)irStatement;
                object = irBuilder;
                bl = false;
                boolean bl2 = false;
                Object $this$run = object;
                boolean bl3 = false;
                IrConstructorCallImpl irConstructorCallImpl = new IrConstructorCallImpl(startOffset, endOffset, callSite.getType(), delegatingConstructorCall.getSymbol(), delegatingConstructorCall.getDescriptor(), constructedClass.getTypeParameters().size(), 0, ((IrConstructor)delegatingConstructorCall.getSymbol().getOwner()).getValueParameters().size(), null, 256, null);
                boolean bl4 = false;
                n = 0;
                Object $this$apply = irConstructorCallImpl;
                boolean bl5 = false;
                $this$forEach$iv = ((IrConstructor)delegatingConstructorCall.getSymbol().getOwner()).getValueParameters();
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (IrValueParameter)element$iv;
                    boolean bl6 = false;
                    ((IrCallWithIndexedArgumentsBase)$this$apply).putValueArgument(it.getIndex(), delegatingConstructorCall.getValueArgument(it.getIndex()));
                }
                $this$forEach$iv = constructedClass.getTypeParameters();
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (IrTypeParameter)element$iv;
                    boolean bl7 = false;
                    ((IrMemberAccessExpressionBase)$this$apply).putTypeArgument(it.getIndex(), delegatingConstructorCall.getTypeArgument(it.getIndex()));
                }
                Object constructorCall = irConstructorCallImpl;
                IrValueParameter irValueParameter = constructedClass.getThisReceiver();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
                IrValueParameter oldThis = irValueParameter;
                IrVariable newThis = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createTemporaryVariableWithWrappedDescriptor$default(this.currentScope.getScope(), (IrExpression)constructorCall, AdditionalIrUtilsKt.getFqNameSafe(constructedClass).toString() + ".this", false, null, 12, null);
                statements.set(0, newThis);
                this.substituteMap.put(oldThis, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, newThis));
                statements.add(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$run, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, newThis)));
            }
            ParameterSubstitutor transformer = new ParameterSubstitutor();
            object = statements;
            Inliner this_$iv = this;
            boolean $i$f$transform = false;
            Iterable $this$forEachIndexed$iv$iv = (Iterable)$this$transform$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                void it;
                IrElement irElement2;
                void item$iv;
                n = index$iv$iv++;
                boolean bl8 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                $this$forEach$iv = (IrElement)item$iv$iv;
                int i$iv = n2;
                boolean bl9 = false;
                element$iv = (IrStatement)item$iv;
                int n3 = i$iv;
                void var29_38 = $this$transform$iv;
                boolean bl10 = false;
                IrElement irElement3 = irElement2 = (IrElement)it.transform(transformer, null);
                if (irElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
                }
                var29_38.set(n3, (IrStatement)irElement3);
            }
            statements.addAll(0, (Collection<IrStatement>)evaluationStatements);
            boolean isCoroutineIntrinsicCall = CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineUninterceptedOrReturn(callSite.getDescriptor(), CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getConfiguration()));
            object = new IrReturnableBlockImpl(startOffset, endOffset, callSite.getType(), irReturnableBlockSymbol, isCoroutineIntrinsicCall ? CoroutineIntrinsicLambdaOrigin.INSTANCE : null, statements, callee.getSymbol());
            bl = false;
            boolean bl11 = false;
            Object $this$apply = object;
            boolean bl12 = false;
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)$this$apply, new IrElementTransformerVoid(copiedCallee, irBuilder){
                final /* synthetic */ IrFunction $copiedCallee$inlined;
                final /* synthetic */ DeclarationIrBuilder $irBuilder$inlined;
                {
                    this.$copiedCallee$inlined = irFunction;
                    this.$irBuilder$inlined = declarationIrBuilder;
                }

                @NotNull
                public IrExpression visitReturn(@NotNull IrReturn expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    if (Intrinsics.areEqual(expression2.getReturnTargetSymbol(), this.$copiedCallee$inlined.getSymbol())) {
                        return ExpressionHelpersKt.irReturn(this.$irBuilder$inlined, expression2.getValue());
                    }
                    return expression2;
                }
            });
            return (IrReturnableBlock)object;
        }

        private final boolean isLambdaCall(IrFunctionAccessExpression irCall) {
            IrFunction callee = irCall.getSymbol().getOwner();
            IrValueParameter irValueParameter = callee.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                return false;
            }
            IrValueParameter dispatchReceiver = irValueParameter;
            boolean bl = !IrTypeUtilsKt.isKFunction(dispatchReceiver.getType());
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return (IrTypeUtilsKt.isFunction(dispatchReceiver.getType()) || IrTypeUtilsKt.isSuspendFunction(dispatchReceiver.getType())) && Intrinsics.areEqual(callee.getName(), OperatorNameConventions.INVOKE) && irCall.getDispatchReceiver() instanceof IrGetValue;
        }

        private final boolean isInlineParameter(@NotNull IrValueParameter $this$isInlineParameter) {
            return !$this$isInlineParameter.isNoinline() && !IrTypeUtilsKt.isNullable($this$isInlineParameter.getType()) && IrTypeUtilsKt.isFunctionOrKFunction($this$isInlineParameter.getType());
        }

        /*
         * WARNING - void declaration
         */
        private final List<ParameterToArgument> buildParameterToArgument(IrFunctionAccessExpression callSite, IrFunction callee) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            List parameterToArgument = new ArrayList();
            if (callSite.getDispatchReceiver() != null && callee.getDispatchReceiverParameter() != null) {
                Collection collection = parameterToArgument;
                IrValueParameter irValueParameter = callee.getDispatchReceiverParameter();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
                IrExpression irExpression = callSite.getDispatchReceiver();
                if (irExpression == null) {
                    Intrinsics.throwNpe();
                }
                ParameterToArgument parameterToArgument2 = new ParameterToArgument(irValueParameter, irExpression);
                boolean bl2 = false;
                collection.add(parameterToArgument2);
            }
            Iterable $this$map$iv = callSite.getSymbol().getOwner().getValueParameters();
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                IrExpression irExpression = callSite.getValueArgument(it.getIndex());
                collection.add(irExpression);
            }
            List valueArguments = CollectionsKt.toMutableList((List)destination$iv$iv);
            if (callee.getExtensionReceiverParameter() != null) {
                IrExpression irExpression;
                $this$map$iv = parameterToArgument;
                IrValueParameter irValueParameter = callee.getExtensionReceiverParameter();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
                if (callSite.getExtensionReceiver() != null) {
                    irExpression = callSite.getExtensionReceiver();
                    if (irExpression == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    Object t = valueArguments.remove(0);
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    irExpression = (IrExpression)t;
                }
                ParameterToArgument $i$f$map2 = new ParameterToArgument(irValueParameter, irExpression);
                boolean bl4 = false;
                $this$map$iv.add($i$f$map2);
            } else if (callSite.getExtensionReceiver() != null) {
                IrExpression irExpression = callSite.getExtensionReceiver();
                if (irExpression == null) {
                    Intrinsics.throwNpe();
                }
                valueArguments.add(0, irExpression);
            }
            boolean $i$f$map2 = false;
            List parametersWithDefaultToArgument = new ArrayList();
            for (IrValueParameter parameter2 : callee.getValueParameters()) {
                Object object;
                Collection $i$f$mapTo2;
                IrExpression argument = (IrExpression)valueArguments.get(parameter2.getIndex());
                if (argument != null) {
                    $i$f$mapTo2 = parameterToArgument;
                    object = new ParameterToArgument(parameter2, argument);
                    boolean bl5 = false;
                    $i$f$mapTo2.add(object);
                    continue;
                }
                if (parameter2.getDefaultValue() != null) {
                    $i$f$mapTo2 = parametersWithDefaultToArgument;
                    IrExpressionBody irExpressionBody = parameter2.getDefaultValue();
                    if (irExpressionBody == null) {
                        Intrinsics.throwNpe();
                    }
                    object = new ParameterToArgument(parameter2, irExpressionBody.getExpression());
                    boolean bl6 = false;
                    $i$f$mapTo2.add(object);
                    continue;
                }
                if (parameter2.getVarargElementType() != null) {
                    int n = callSite.getStartOffset();
                    int n2 = callSite.getEndOffset();
                    IrType irType = parameter2.getType();
                    IrType irType2 = parameter2.getVarargElementType();
                    if (irType2 == null) {
                        Intrinsics.throwNpe();
                    }
                    IrVarargImpl emptyArray = new IrVarargImpl(n, n2, irType, irType2);
                    object = parameterToArgument;
                    ParameterToArgument parameterToArgument3 = new ParameterToArgument(parameter2, emptyArray);
                    boolean bl7 = false;
                    object.add(parameterToArgument3);
                    continue;
                }
                String message2 = "Incomplete expression: call to " + callee.getDescriptor() + ' ' + "has no argument at index " + parameter2.getIndex();
                throw (Throwable)new Error(message2);
            }
            return CollectionsKt.plus((Collection)parameterToArgument, (Iterable)parametersWithDefaultToArgument);
        }

        private final List<IrStatement> evaluateArguments(IrFunctionAccessExpression callSite, IrFunction callee) {
            List<ParameterToArgument> parameterToArgumentOld = this.buildParameterToArgument(callSite, callee);
            boolean bl = false;
            List evaluationStatements = new ArrayList();
            ParameterSubstitutor substitutor2 = new ParameterSubstitutor();
            Iterable $this$forEach$iv = parameterToArgumentOld;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParameterToArgument it = (ParameterToArgument)element$iv;
                boolean bl2 = false;
                if (it.isInlinableLambdaArgument()) {
                    this.substituteMap.put(it.getParameter(), it.getArgumentExpression());
                    continue;
                }
                if (it.isImmutableVariableLoad()) {
                    this.substituteMap.put(it.getParameter(), it.getArgumentExpression().transform(substitutor2, null));
                    continue;
                }
                IrVariable newVariable = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createTemporaryVariableWithWrappedDescriptor$default(this.currentScope.getScope(), it.getArgumentExpression().transform(substitutor2, null), callee.getSymbol().getOwner().getName().toString(), false, null, 8, null);
                evaluationStatements.add(newVariable);
                IrGetValueImpl getVal = new IrGetValueImpl(this.currentScope.getIrElement().getStartOffset(), this.currentScope.getIrElement().getEndOffset(), newVariable.getType(), (IrValueSymbol)newVariable.getSymbol(), null, 16, null);
                this.substituteMap.put(it.getParameter(), getVal);
            }
            return evaluationStatements;
        }

        @NotNull
        public final IrFunctionAccessExpression getCallSite() {
            return this.callSite;
        }

        @NotNull
        public final IrFunction getCallee() {
            return this.callee;
        }

        @NotNull
        public final ScopeWithIr getCurrentScope() {
            return this.currentScope;
        }

        @Nullable
        public final IrDeclarationParent getParent() {
            return this.parent;
        }

        @NotNull
        public final JsIrBackendContext getContext() {
            return this.context;
        }

        /*
         * WARNING - void declaration
         */
        public Inliner(@NotNull IrFunctionAccessExpression callSite, @NotNull IrFunction callee, @NotNull ScopeWithIr currentScope2, @Nullable IrDeclarationParent parent2, @NotNull JsIrBackendContext context) {
            void $this$associateTo$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(callSite, "callSite");
            Intrinsics.checkParameterIsNotNull(callee, "callee");
            Intrinsics.checkParameterIsNotNull(currentScope2, "currentScope");
            Intrinsics.checkParameterIsNotNull(context, "context");
            this.callSite = callSite;
            this.callee = callee;
            this.currentScope = currentScope2;
            this.parent = parent2;
            this.context = context;
            Inliner inliner = this;
            Inliner inliner2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Inliner $this$run = inliner;
            boolean bl3 = false;
            List<IrTypeParameter> typeParameters2 = $this$run.callee instanceof IrConstructor ? IrUtilsKt.getParentAsClass($this$run.callee).getTypeParameters() : $this$run.callee.getTypeParameters();
            Iterable $this$map$iv = RangesKt.until(0, $this$run.callSite.getTypeArgumentsCount());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to(typeParameters2.get((int)it).getSymbol(), $this$run.callSite.getTypeArgument((int)it));
                collection.add(pair);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                Pair it = (Pair)element$iv$iv;
                boolean bl5 = false;
                Pair pair = it;
                boolean bl6 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map typeArguments2 = destination$iv$iv2;
            Object object = new DeepCopyIrTreeWithSymbolsForInliner($this$run.context, typeArguments2, $this$run.parent);
            inliner2.copyIrElement = object;
            inliner2 = this;
            boolean bl7 = false;
            inliner2.substituteMap = object = (Map)new LinkedHashMap();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining$Inliner$ParameterSubstitutor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining$Inliner;)V", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "element", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "backend.js"})
        private final class ParameterSubstitutor
        extends IrElementTransformerVoid {
            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrExpression irExpression = super.visitGetValue(expression2);
                if (irExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrGetValue");
                }
                IrGetValue newExpression = (IrGetValue)irExpression;
                Map<IrValueParameter, IrExpression> map2 = Inliner.this.getSubstituteMap();
                IrValueDeclaration irValueDeclaration = newExpression.getSymbol().getOwner();
                boolean bl = false;
                IrExpression irExpression2 = map2.get(irValueDeclaration);
                if (irExpression2 == null) {
                    return newExpression;
                }
                IrExpression argument = irExpression2;
                IrElementTransformerVoidKt.transformChildrenVoid(argument, this);
                IrElement irElement = Inliner.this.getCopyIrElement().copy(argument);
                if (irElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                }
                return (IrExpression)irElement;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                if (!Inliner.this.isLambdaCall(expression2)) {
                    return super.visitCall(expression2);
                }
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrGetValue");
                }
                IrGetValue dispatchReceiver = (IrGetValue)irExpression;
                Map<IrValueParameter, IrExpression> map2 = Inliner.this.getSubstituteMap();
                IrValueDeclaration irValueDeclaration = dispatchReceiver.getSymbol().getOwner();
                boolean bl = false;
                IrExpression irExpression2 = map2.get(irValueDeclaration);
                if (irExpression2 == null) {
                    return super.visitCall(expression2);
                }
                IrExpression functionArgument = irExpression2;
                IrValueDeclaration irValueDeclaration2 = dispatchReceiver.getSymbol().getOwner();
                if (!(irValueDeclaration2 instanceof IrValueParameter)) {
                    irValueDeclaration2 = null;
                }
                IrValueParameter irValueParameter = (IrValueParameter)irValueDeclaration2;
                if (irValueParameter != null) {
                    if (irValueParameter.isNoinline()) {
                        return super.visitCall(expression2);
                    }
                }
                if (functionArgument instanceof IrFunctionReference) {
                    void $this$associateTo$iv$iv;
                    Collection<IrValueParameter> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    IrFunction function2 = ((IrFunctionReference)functionArgument).getSymbol().getOwner();
                    List<IrValueParameter> functionParameters = IrUtilsKt.getExplicitParameters(function2);
                    List<Pair<IrValueParameter, IrExpression>> boundFunctionParameters = IrUtilsKt.getArgumentsWithIr((IrMemberAccessExpression)functionArgument);
                    Iterable iterable = boundFunctionParameters;
                    Iterable iterable2 = functionParameters;
                    boolean $i$f$map = false;
                    void var10_13 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo22 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Iterator it;
                        Pair pair = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        IrValueParameter irValueParameter2 = (IrValueParameter)((Pair)((Object)it)).getFirst();
                        collection.add(irValueParameter2);
                    }
                    collection = (List)destination$iv$iv;
                    List unboundFunctionParameters = CollectionsKt.minus(iterable2, (Iterable)collection);
                    Iterable $this$associate$iv = boundFunctionParameters;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                    Iterable $i$f$mapTo22 = $this$associate$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map3 = destination$iv$iv2;
                        Pair it = (Pair)element$iv$iv;
                        boolean bl3 = false;
                        it = TuplesKt.to(it.getFirst(), it.getSecond());
                        bl3 = false;
                        map3.put(it.getFirst(), it.getSecond());
                    }
                    Map boundFunctionParametersMap = destination$iv$iv2;
                    int unboundIndex = 0;
                    Set unboundArgsSet = CollectionsKt.toSet(unboundFunctionParameters);
                    List valueParameters2 = CollectionsKt.drop((Iterable)IrUtilsKt.getArgumentsWithIr(expression2), 1);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    IrCall $this$with = expression2;
                    boolean bl6 = false;
                    IrMemberAccessExpression irMemberAccessExpression = function2 instanceof IrConstructor ? (IrMemberAccessExpression)IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, $this$with.getStartOffset(), $this$with.getEndOffset(), $this$with.getType(), (IrConstructorSymbol)((IrConstructor)function2).getSymbol(), null, 16, null) : (IrMemberAccessExpression)new IrCallImpl($this$with.getStartOffset(), $this$with.getEndOffset(), $this$with.getType(), ((IrFunctionReference)functionArgument).getSymbol());
                    bl5 = false;
                    boolean bl7 = false;
                    IrMemberAccessExpression $this$apply = irMemberAccessExpression;
                    boolean bl8 = false;
                    Iterable $this$forEach$iv22 = functionParameters;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv22) {
                        IrExpression irExpression3;
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl9 = false;
                        if (!unboundArgsSet.contains(it)) {
                            Object v = boundFunctionParametersMap.get(it);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            irExpression3 = (IrExpression)v;
                        } else {
                            int n = unboundIndex;
                            unboundIndex = n + 1;
                            Pair pair = (Pair)CollectionsKt.getOrNull(valueParameters2, n);
                            irExpression3 = pair != null ? (IrExpression)pair.getSecond() : null;
                        }
                        IrExpression argument = irExpression3;
                        IrValueParameter irValueParameter3 = it;
                        if (Intrinsics.areEqual(irValueParameter3, function2.getDispatchReceiverParameter())) {
                            ((IrCallWithIndexedArgumentsBase)$this$apply).setDispatchReceiver(argument);
                            continue;
                        }
                        if (Intrinsics.areEqual(irValueParameter3, function2.getExtensionReceiverParameter())) {
                            ((IrCallWithIndexedArgumentsBase)$this$apply).setExtensionReceiver(argument);
                            continue;
                        }
                        ((IrCallWithIndexedArgumentsBase)$this$apply).putValueArgument(it.getIndex(), argument);
                    }
                    int $this$forEach$iv22 = unboundIndex >= valueParameters2.size() ? 1 : 0;
                    int n = 0;
                    if (_Assertions.ENABLED && $this$forEach$iv22 == 0) {
                        boolean bl10 = false;
                        String string = "Not all arguments of <invoke> are used";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    $this$forEach$iv22 = 0;
                    n = ((IrFunctionReference)functionArgument).getTypeArgumentsCount();
                    while ($this$forEach$iv22 < n) {
                        void index2;
                        ((IrCallWithIndexedArgumentsBase)$this$apply).putTypeArgument((int)index2, ((IrFunctionReference)functionArgument).getTypeArgument((int)index2));
                        ++index2;
                    }
                    IrMemberAccessExpression immediateCall = irMemberAccessExpression;
                    return FunctionInlining.this.visitExpression(super.visitExpression(immediateCall));
                }
                if (!(functionArgument instanceof IrBlock)) {
                    return super.visitCall(expression2);
                }
                IrStatement irStatement = ((IrBlock)functionArgument).getStatements().get(0);
                if (irStatement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                }
                IrFunction functionDeclaration = (IrFunction)irStatement;
                IrReturnableBlock newExpression = Inliner.this.inlineFunction(expression2, functionDeclaration);
                return newExpression.transform(this, null);
            }

            @Override
            @NotNull
            public IrElement visitElement(@NotNull IrElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return (IrElement)element.accept(this, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining$Inliner$ParameterToArgument;", "", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "argumentExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining$Inliner;Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getArgumentExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isImmutableVariableLoad", "", "()Z", "isInlinableLambdaArgument", "getParameter", "()Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.js"})
        private final class ParameterToArgument {
            @NotNull
            private final IrValueParameter parameter;
            @NotNull
            private final IrExpression argumentExpression;

            public final boolean isInlinableLambdaArgument() {
                if (!Inliner.this.isInlineParameter(this.parameter)) {
                    return false;
                }
                if (this.argumentExpression instanceof IrFunctionReference) {
                    return true;
                }
                if (!(this.argumentExpression instanceof IrBlock)) {
                    return false;
                }
                if (Intrinsics.areEqual(((IrBlock)this.argumentExpression).getOrigin(), IrStatementOrigin.LAMBDA.INSTANCE) ^ true && Intrinsics.areEqual(((IrBlock)this.argumentExpression).getOrigin(), IrStatementOrigin.ANONYMOUS_FUNCTION.INSTANCE) ^ true) {
                    return false;
                }
                List<IrStatement> statements = ((IrBlock)this.argumentExpression).getStatements();
                IrStatement irFunction = statements.get(0);
                IrStatement irCallableReference = statements.get(1);
                if (!(irFunction instanceof IrFunction)) {
                    return false;
                }
                return irCallableReference instanceof IrCallableReference;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isImmutableVariableLoad() {
                IrExpression irExpression = this.argumentExpression;
                boolean bl = false;
                boolean bl2 = false;
                IrExpression it = irExpression;
                boolean bl3 = false;
                if (!(it instanceof IrGetValue)) return false;
                IrValueDeclaration irValueDeclaration = ((IrGetValue)it).getSymbol().getOwner();
                boolean bl4 = false;
                boolean bl5 = false;
                IrValueDeclaration it2 = irValueDeclaration;
                boolean bl6 = false;
                if (!(it2 instanceof IrVariable)) return true;
                if (!((IrVariable)it2).isVar()) return true;
                return false;
            }

            @NotNull
            public final IrValueParameter getParameter() {
                return this.parameter;
            }

            @NotNull
            public final IrExpression getArgumentExpression() {
                return this.argumentExpression;
            }

            public ParameterToArgument(@NotNull IrValueParameter parameter2, @NotNull IrExpression argumentExpression) {
                Intrinsics.checkParameterIsNotNull(parameter2, "parameter");
                Intrinsics.checkParameterIsNotNull(argumentExpression, "argumentExpression");
                this.parameter = parameter2;
                this.argumentExpression = argumentExpression;
            }
        }
    }
}

