"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
exports.DEFAULT_SNAP_POSITION_BAND = 1;
function getSnapPosition(value, scale, totalBarsInCluster) {
    if (totalBarsInCluster === void 0) { totalBarsInCluster = 1; }
    var position = scale.scale(value);
    if (position === undefined) {
        return;
    }
    if (scale.bandwidth > 0) {
        var band = scale.bandwidth / (1 - scale.barsPadding);
        var halfPadding = (band - scale.bandwidth) / 2;
        return {
            position: position - halfPadding * totalBarsInCluster,
            band: band * totalBarsInCluster,
        };
    }
    else {
        return {
            position: position,
            band: exports.DEFAULT_SNAP_POSITION_BAND,
        };
    }
}
exports.getSnapPosition = getSnapPosition;
function getCursorLinePosition(chartRotation, chartDimensions, cursorPosition) {
    var left = chartDimensions.left, top = chartDimensions.top, width = chartDimensions.width, height = chartDimensions.height;
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    if (isHorizontalRotated) {
        var crosshairTop = cursorPosition.y + top;
        return {
            left: left,
            width: width,
            top: crosshairTop,
            height: 0,
        };
    }
    else {
        var crosshairLeft = cursorPosition.x + left;
        return {
            top: top,
            left: crosshairLeft,
            width: 0,
            height: height,
        };
    }
}
exports.getCursorLinePosition = getCursorLinePosition;
function getCursorBandPosition(chartRotation, chartDimensions, cursorPosition, snapEnabled, xScale, data, totalBarsInCluster) {
    var top = chartDimensions.top, left = chartDimensions.left, width = chartDimensions.width, height = chartDimensions.height;
    var x = cursorPosition.x, y = cursorPosition.y;
    if (x > width || y > height || x < 0 || y < 0) {
        return;
    }
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    var invertedValue = xScale.invertWithStep(isHorizontalRotated ? x : y, data);
    if (invertedValue == null) {
        return;
    }
    var snappedPosition = getSnapPosition(invertedValue, xScale, totalBarsInCluster);
    if (!snappedPosition) {
        return;
    }
    var position = snappedPosition.position, band = snappedPosition.band;
    if (isHorizontalRotated) {
        return {
            top: top,
            left: left + (snapEnabled ? position : x),
            width: band,
            height: height,
        };
    }
    else {
        return {
            top: top + (snapEnabled ? position : y),
            left: left,
            width: width,
            height: band,
        };
    }
}
exports.getCursorBandPosition = getCursorBandPosition;
function getTooltipPosition(chartDimensions, chartRotation, cursorBandPosition, cursorPosition) {
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    var hPosition = getHorizontalTooltipPosition(cursorPosition.x, cursorBandPosition, chartDimensions, isHorizontalRotated);
    var vPosition = getVerticalTooltipPosition(cursorPosition.y, cursorBandPosition, chartDimensions, isHorizontalRotated);
    var xTranslation = "translateX(" + hPosition.position + "px) translateX(-" + hPosition.offset + "%)";
    var yTranslation = "translateY(" + vPosition.position + "px) translateY(-" + vPosition.offset + "%)";
    return {
        transform: xTranslation + " " + yTranslation,
    };
}
exports.getTooltipPosition = getTooltipPosition;
function getHorizontalTooltipPosition(cursorXPosition, cursorBandPosition, chartDimensions, isHorizontalRotated, padding) {
    if (padding === void 0) { padding = 20; }
    if (isHorizontalRotated) {
        if (cursorXPosition <= chartDimensions.width / 2) {
            return {
                offset: 0,
                position: cursorBandPosition.left + cursorBandPosition.width + padding,
            };
        }
        else {
            return {
                offset: 100,
                position: cursorBandPosition.left - padding,
            };
        }
    }
    else {
        if (cursorXPosition <= chartDimensions.width / 2) {
            return {
                offset: 0,
                position: chartDimensions.left + cursorXPosition,
            };
        }
        else {
            return {
                offset: 100,
                position: chartDimensions.left + cursorXPosition,
            };
        }
    }
}
exports.getHorizontalTooltipPosition = getHorizontalTooltipPosition;
function getVerticalTooltipPosition(cursorYPosition, cursorBandPosition, chartDimensions, isHorizontalRotated, padding) {
    if (padding === void 0) { padding = 20; }
    if (isHorizontalRotated) {
        if (cursorYPosition <= chartDimensions.height / 2) {
            return {
                offset: 0,
                position: cursorYPosition + chartDimensions.top,
            };
        }
        else {
            return {
                offset: 100,
                position: cursorYPosition + chartDimensions.top,
            };
        }
    }
    else {
        if (cursorYPosition <= chartDimensions.height / 2) {
            return {
                offset: 0,
                position: cursorBandPosition.top + cursorBandPosition.height + padding,
            };
        }
        else {
            return {
                offset: 100,
                position: cursorBandPosition.top - padding,
            };
        }
    }
}
exports.getVerticalTooltipPosition = getVerticalTooltipPosition;
//# sourceMappingURL=crosshair_utils.js.map