"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var mobx_1 = require("mobx");
var axis_utils_1 = require("../lib/axes/axis_utils");
var canvas_text_bbox_calculator_1 = require("../lib/axes/canvas_text_bbox_calculator");
var legend_1 = require("../lib/series/legend");
var rendering_1 = require("../lib/series/rendering");
var scales_1 = require("../lib/series/scales");
var series_1 = require("../lib/series/series");
var specs_1 = require("../lib/series/specs");
var tooltip_1 = require("../lib/series/tooltip");
var light_theme_1 = require("../lib/themes/light_theme");
var theme_1 = require("../lib/themes/theme");
var commons_1 = require("../lib/utils/commons");
var dimensions_1 = require("../lib/utils/dimensions");
var interactions_1 = require("../lib/utils/interactions");
var settings_1 = require("../specs/settings");
var annotation_utils_1 = require("./annotation_utils");
var crosshair_utils_1 = require("./crosshair_utils");
var utils_1 = require("./utils");
var ChartStore = /** @class */ (function () {
    function ChartStore() {
        var _this = this;
        this.debug = false;
        this.specsInitialized = mobx_1.observable.box(false);
        this.initialized = mobx_1.observable.box(false);
        this.parentDimensions = {
            width: 0,
            height: 0,
            top: 0,
            left: 0,
        };
        this.chartDimensions = {
            width: 0,
            height: 0,
            top: 0,
            left: 0,
        };
        this.chartTransform = {
            x: 0,
            y: 0,
            rotate: 0,
        };
        this.isBrushing = mobx_1.observable.box(false);
        this.brushExtent = {
            minX: 0,
            minY: 0,
            maxX: 0,
            maxY: 0,
        };
        this.chartRotation = 0; // updated from jsx
        this.chartRendering = 'canvas'; // updated from jsx
        this.chartTheme = light_theme_1.LIGHT_THEME; // updated from jsx
        this.axesSpecs = new Map(); // readed from jsx
        this.axesTicksDimensions = new Map(); // computed
        this.axesPositions = new Map(); // computed
        this.axesVisibleTicks = new Map(); // computed
        this.axesTicks = new Map(); // computed
        this.axesGridLinesPositions = new Map(); // computed
        this.annotationSpecs = new Map(); // read from jsx
        this.annotationDimensions = mobx_1.observable.map(new Map());
        this.seriesSpecs = new Map(); // readed from jsx
        this.legendItems = new Map();
        this.highlightedLegendItemKey = mobx_1.observable.box(null);
        this.selectedLegendItemKey = mobx_1.observable.box(null);
        this.deselectedDataSeries = null;
        this.customSeriesColors = new Map();
        this.seriesColorMap = new Map();
        this.tooltipData = mobx_1.observable.array([], { deep: false });
        this.tooltipType = mobx_1.observable.box(settings_1.DEFAULT_TOOLTIP_TYPE);
        this.tooltipSnap = mobx_1.observable.box(settings_1.DEFAULT_TOOLTIP_SNAP);
        this.tooltipPosition = mobx_1.observable.object({ transform: '' });
        /** cursorPosition is used by tooltip, so this is a way to expose the position for other uses */
        this.rawCursorPosition = mobx_1.observable.object({ x: -1, y: -1 }, undefined, {
            deep: false,
        });
        /** position of the cursor relative to the chart */
        this.cursorPosition = mobx_1.observable.object({ x: -1, y: -1 }, undefined, {
            deep: false,
        });
        this.cursorBandPosition = mobx_1.observable.object({ top: -1, left: -1, height: -1, width: -1 }, undefined, {
            deep: false,
        });
        this.cursorLinePosition = mobx_1.observable.object({ top: -1, left: -1, height: -1, width: -1 }, undefined, {
            deep: false,
        });
        this.geometries = null;
        this.geometriesIndex = new Map();
        this.geometriesIndexKeys = [];
        this.highlightedGeometries = mobx_1.observable.array([], { deep: false });
        this.animateData = false;
        /**
         * Define if the chart can be animated or not depending
         * on the global configuration and on the number of elements per series
         */
        this.canDataBeAnimated = false;
        this.showLegend = mobx_1.observable.box(false);
        this.legendCollapsed = mobx_1.observable.box(false);
        this.showLegendDisplayValue = mobx_1.observable.box(true);
        this.toggleLegendCollapsed = mobx_1.action(function () {
            _this.legendCollapsed.set(!_this.legendCollapsed.get());
            _this.computeChart();
        });
        /**
         * x and y values are relative to the container.
         */
        this.setCursorPosition = mobx_1.action(function (x, y) {
            _this.rawCursorPosition.x = x;
            _this.rawCursorPosition.y = y;
            if (!_this.seriesDomainsAndData || _this.tooltipType.get() === interactions_1.TooltipType.None) {
                return;
            }
            // get positions relative to chart
            var xPos = x - _this.chartDimensions.left;
            var yPos = y - _this.chartDimensions.top;
            // limit cursorPosition to chartDimensions
            // note: to debug and inspect tooltip html, just comment the following ifs
            if (xPos < 0 || xPos >= _this.chartDimensions.width) {
                xPos = -1;
            }
            if (yPos < 0 || yPos >= _this.chartDimensions.height) {
                yPos = -1;
            }
            _this.cursorPosition.x = xPos;
            _this.cursorPosition.y = yPos;
            // hide tooltip if outside chart dimensions
            if (yPos === -1 || xPos === -1) {
                _this.clearTooltipAndHighlighted();
                return;
            }
            // get the cursor position depending on the chart rotation
            var xAxisCursorPosition = interactions_1.getValidXPosition(xPos, yPos, _this.chartRotation, _this.chartDimensions);
            var yAxisCursorPosition = interactions_1.getValidYPosition(xPos, yPos, _this.chartRotation, _this.chartDimensions);
            // only if we have a valid cursor position and the necessary scale
            if (xAxisCursorPosition < 0 || !_this.xScale || !_this.yScales) {
                _this.clearTooltipAndHighlighted();
                return;
            }
            // invert the cursor position to get the scale value
            var xValue = _this.xScale.invertWithStep(xAxisCursorPosition, _this.geometriesIndexKeys);
            // update che cursorBandPosition based on chart configuration
            var isLineAreaOnly = utils_1.isLineAreaOnlyChart(_this.seriesSpecs);
            var updatedCursorBand = crosshair_utils_1.getCursorBandPosition(_this.chartRotation, _this.chartDimensions, _this.cursorPosition, _this.isTooltipSnapEnabled.get(), _this.xScale, _this.geometriesIndexKeys, isLineAreaOnly ? 1 : _this.totalBarsInCluster);
            if (updatedCursorBand === undefined) {
                _this.clearTooltipAndHighlighted();
                return;
            }
            Object.assign(_this.cursorBandPosition, updatedCursorBand);
            var updatedCursorLine = crosshair_utils_1.getCursorLinePosition(_this.chartRotation, _this.chartDimensions, _this.cursorPosition);
            Object.assign(_this.cursorLinePosition, updatedCursorLine);
            var updatedTooltipPosition = crosshair_utils_1.getTooltipPosition(_this.chartDimensions, _this.chartRotation, _this.cursorBandPosition, _this.cursorPosition);
            _this.tooltipPosition.transform = updatedTooltipPosition.transform;
            // get the elements on at this cursor position
            var elements = _this.geometriesIndex.get(xValue);
            // if no element, hide everything
            if (!elements || elements.length === 0) {
                _this.clearTooltipAndHighlighted();
                return;
            }
            // build the tooltip value list
            var xValueInfo = null;
            var oneHighlighted = false;
            var newHighlightedGeometries = [];
            var tooltipValues = elements.reduce(function (acc, indexedGeometry) {
                var specId = indexedGeometry.geometryId.specId;
                var spec = _this.seriesSpecs.get(specId);
                // safe guard check
                if (!spec) {
                    return acc;
                }
                var _a = utils_1.getAxesSpecForSpecId(_this.axesSpecs, spec.groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
                // yScales is ensured by the enclosing if
                var yScale = _this.yScales.get(spec.groupId);
                if (!yScale) {
                    return acc;
                }
                // check if the pointer is on the geometry
                var isHighlighted = false;
                if (rendering_1.isPointOnGeometry(xAxisCursorPosition, yAxisCursorPosition, indexedGeometry)) {
                    isHighlighted = true;
                    oneHighlighted = true;
                    newHighlightedGeometries.push(indexedGeometry);
                }
                // if it's a follow tooltip, and no element is highlighted
                // not add that element into the tooltip list
                if (!isHighlighted && interactions_1.isFollowTooltipType(_this.tooltipType.get())) {
                    return acc;
                }
                // format the tooltip values
                var formattedTooltip = tooltip_1.formatTooltip(indexedGeometry, spec, false, isHighlighted, yAxis);
                // format only one time the x value
                if (!xValueInfo) {
                    xValueInfo = tooltip_1.formatTooltip(indexedGeometry, spec, true, false, xAxis);
                    return __spread([xValueInfo], acc, [formattedTooltip]);
                }
                return __spread(acc, [formattedTooltip]);
            }, []);
            // if there's an annotation rect tooltip & there isn't a single highlighted element, hide
            var annotationTooltip = _this.annotationTooltipState.get();
            var hasRectAnnotationToolip = annotationTooltip && annotationTooltip.annotationType === specs_1.AnnotationTypes.Rectangle;
            if (hasRectAnnotationToolip && !oneHighlighted) {
                _this.clearTooltipAndHighlighted();
                return;
            }
            // check if we already have send out an over/out event on highlighted elements
            if (_this.onElementOverListener &&
                !interactions_1.areIndexedGeometryArraysEquals(newHighlightedGeometries, _this.highlightedGeometries.toJS())) {
                if (newHighlightedGeometries.length > 0) {
                    _this.onElementOverListener(newHighlightedGeometries.map(function (_a) {
                        var value = _a.value;
                        return value;
                    }));
                }
                else {
                    if (_this.onElementOutListener) {
                        _this.onElementOutListener();
                    }
                }
            }
            // update highlighted geometries observer
            _this.highlightedGeometries.replace(newHighlightedGeometries);
            // update tooltip visibility
            if (tooltipValues.length === 0) {
                _this.tooltipData.clear();
            }
            else {
                _this.tooltipData.replace(tooltipValues);
            }
            // TODO move this into the renderer
            if (oneHighlighted) {
                document.body.style.cursor = 'pointer';
            }
            else {
                document.body.style.cursor = 'default';
            }
        });
        this.legendItemTooltipValues = mobx_1.computed(function () {
            // update legend items with value to display
            return tooltip_1.getSeriesTooltipValues(_this.tooltipData);
        });
        this.annotationTooltipState = mobx_1.computed(function () {
            var e_1, _a;
            // get positions relative to chart
            var xPos = _this.rawCursorPosition.x - _this.chartDimensions.left;
            var yPos = _this.rawCursorPosition.y - _this.chartDimensions.top;
            // only if we have a valid cursor position and the necessary scale
            if (!_this.xScale || !_this.yScales) {
                return null;
            }
            var cursorPosition = {
                x: xPos,
                y: yPos,
            };
            var tooltipState = annotation_utils_1.computeAnnotationTooltipState(cursorPosition, _this.annotationDimensions, _this.annotationSpecs, _this.chartRotation, _this.axesSpecs, _this.chartDimensions);
            // If there's a highlighted chart element tooltip value, don't show annotation tooltip
            if (tooltipState && tooltipState.annotationType === specs_1.AnnotationTypes.Rectangle) {
                try {
                    for (var _b = __values(_this.tooltipData), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var tooltipValue = _c.value;
                        if (tooltipValue.isHighlighted) {
                            return null;
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            return tooltipState;
        });
        this.isTooltipVisible = mobx_1.computed(function () {
            return (!_this.isBrushing.get() &&
                _this.tooltipType.get() !== interactions_1.TooltipType.None &&
                _this.cursorPosition.x > -1 &&
                _this.cursorPosition.y > -1 &&
                _this.tooltipData.length > 0);
        });
        this.isCrosshairVisible = mobx_1.computed(function () {
            return (!_this.isBrushing.get() &&
                interactions_1.isCrosshairTooltipType(_this.tooltipType.get()) &&
                _this.cursorPosition.x > -1 &&
                _this.cursorPosition.y > -1);
        });
        this.isTooltipSnapEnabled = mobx_1.computed(function () {
            return (_this.xScale && _this.xScale.bandwidth > 0) || _this.tooltipSnap.get();
        });
        this.clearTooltipAndHighlighted = mobx_1.action(function () {
            // if exist any highlighted geometry, send an out element event
            if (_this.onElementOutListener && _this.highlightedGeometries.length > 0) {
                _this.onElementOutListener();
            }
            // clear highlight geoms
            _this.highlightedGeometries.clear();
            _this.tooltipData.clear();
            document.body.style.cursor = 'default';
        });
        this.setShowLegend = mobx_1.action(function (showLegend) {
            _this.showLegend.set(showLegend);
        });
        this.highlightedLegendItem = mobx_1.computed(function () {
            var key = _this.highlightedLegendItemKey.get();
            return key == null ? null : _this.legendItems.get(key);
        });
        this.selectedLegendItem = mobx_1.computed(function () {
            var key = _this.selectedLegendItemKey.get();
            return key == null ? null : _this.legendItems.get(key);
        });
        this.onLegendItemOver = mobx_1.action(function (legendItemKey) {
            _this.highlightedLegendItemKey.set(legendItemKey);
            if (_this.onLegendItemOverListener) {
                var currentLegendItem = _this.highlightedLegendItem.get();
                var listenerData = currentLegendItem ? currentLegendItem.value : null;
                _this.onLegendItemOverListener(listenerData);
            }
        });
        this.onLegendItemOut = mobx_1.action(function () {
            _this.highlightedLegendItemKey.set(null);
            if (_this.onLegendItemOutListener) {
                _this.onLegendItemOutListener();
            }
        });
        this.onLegendItemClick = mobx_1.action(function (legendItemKey) {
            if (legendItemKey !== _this.selectedLegendItemKey.get()) {
                _this.selectedLegendItemKey.set(legendItemKey);
            }
            else {
                _this.selectedLegendItemKey.set(null);
            }
            if (_this.onLegendItemClickListener) {
                var currentLegendItem = _this.selectedLegendItem.get();
                var listenerData = currentLegendItem ? currentLegendItem.value : null;
                _this.onLegendItemClickListener(listenerData);
            }
        });
        this.onLegendItemPlusClick = mobx_1.action(function () {
            if (_this.onLegendItemPlusClickListener) {
                var currentLegendItem = _this.selectedLegendItem.get();
                var listenerData = currentLegendItem ? currentLegendItem.value : null;
                _this.onLegendItemPlusClickListener(listenerData);
            }
        });
        this.onLegendItemMinusClick = mobx_1.action(function () {
            if (_this.onLegendItemMinusClickListener) {
                var currentLegendItem = _this.selectedLegendItem.get();
                var listenerData = currentLegendItem ? currentLegendItem.value : null;
                _this.onLegendItemMinusClickListener(listenerData);
            }
        });
        this.toggleSingleSeries = mobx_1.action(function (legendItemKey) {
            var legendItem = _this.legendItems.get(legendItemKey);
            if (legendItem) {
                if (utils_1.findDataSeriesByColorValues(_this.deselectedDataSeries, legendItem.value) > -1) {
                    _this.deselectedDataSeries = __spread(_this.legendItems.values()).filter(function (item) { return item.key !== legendItemKey; })
                        .map(function (item) { return item.value; });
                }
                else {
                    _this.deselectedDataSeries = [legendItem.value];
                }
                _this.computeChart();
            }
        });
        this.toggleSeriesVisibility = mobx_1.action(function (legendItemKey) {
            var legendItem = _this.legendItems.get(legendItemKey);
            if (legendItem) {
                _this.deselectedDataSeries = utils_1.updateDeselectedDataSeries(_this.deselectedDataSeries, legendItem.value);
                _this.computeChart();
            }
        });
        this.setSeriesColor = mobx_1.action(function (legendItemKey, color) {
            var legendItem = _this.legendItems.get(legendItemKey);
            if (legendItem) {
                var specId = legendItem.value.specId;
                var spec = _this.seriesSpecs.get(specId);
                if (spec) {
                    if (spec.customSeriesColors) {
                        spec.customSeriesColors.set(legendItem.value, color);
                    }
                    else {
                        var specCustomSeriesColors = new Map();
                        spec.customSeriesColors = specCustomSeriesColors;
                        spec.customSeriesColors.set(legendItem.value, color);
                    }
                }
                _this.computeChart();
            }
        });
        this.onBrushStart = mobx_1.action(function () {
            if (!_this.onBrushEndListener) {
                return;
            }
            _this.isBrushing.set(true);
        });
        this.onBrushEnd = mobx_1.action(function (start, end) {
            if (!_this.onBrushEndListener) {
                return;
            }
            _this.isBrushing.set(false);
            var minValue = start.x < end.x ? start.x : end.x;
            var maxValue = start.x > end.x ? start.x : end.x;
            if (maxValue === minValue) {
                // if 0 size brush, avoid computing the value
                return;
            }
            var min = _this.xScale.invert(minValue - _this.chartDimensions.left);
            var max = _this.xScale.invert(maxValue - _this.chartDimensions.left);
            _this.onBrushEndListener(min, max);
        });
    }
    ChartStore.prototype.handleChartClick = function () {
        if (this.highlightedGeometries.length > 0 && this.onElementClickListener) {
            this.onElementClickListener(this.highlightedGeometries.toJS().map(function (_a) {
                var value = _a.value;
                return value;
            }));
        }
    };
    ChartStore.prototype.resetDeselectedDataSeries = function () {
        this.deselectedDataSeries = null;
    };
    ChartStore.prototype.setOnElementClickListener = function (listener) {
        this.onElementClickListener = listener;
    };
    ChartStore.prototype.setOnElementOverListener = function (listener) {
        this.onElementOverListener = listener;
    };
    ChartStore.prototype.setOnElementOutListener = function (listener) {
        this.onElementOutListener = listener;
    };
    ChartStore.prototype.setOnBrushEndListener = function (listener) {
        this.onBrushEndListener = listener;
    };
    ChartStore.prototype.setOnLegendItemOverListener = function (listener) {
        this.onLegendItemOverListener = listener;
    };
    ChartStore.prototype.setOnLegendItemOutListener = function (listener) {
        this.onLegendItemOutListener = listener;
    };
    ChartStore.prototype.setOnLegendItemClickListener = function (listener) {
        this.onLegendItemClickListener = listener;
    };
    ChartStore.prototype.setOnLegendItemPlusClickListener = function (listener) {
        this.onLegendItemPlusClickListener = listener;
    };
    ChartStore.prototype.setOnLegendItemMinusClickListener = function (listener) {
        this.onLegendItemMinusClickListener = listener;
    };
    ChartStore.prototype.removeElementClickListener = function () {
        this.onElementClickListener = undefined;
    };
    ChartStore.prototype.removeElementOverListener = function () {
        this.onElementOverListener = undefined;
    };
    ChartStore.prototype.removeElementOutListener = function () {
        this.onElementOutListener = undefined;
    };
    ChartStore.prototype.removeOnLegendItemOverListener = function () {
        this.onLegendItemOverListener = undefined;
    };
    ChartStore.prototype.removeOnLegendItemOutListener = function () {
        this.onLegendItemOutListener = undefined;
    };
    ChartStore.prototype.removeOnLegendItemPlusClickListener = function () {
        this.onLegendItemPlusClickListener = undefined;
    };
    ChartStore.prototype.removeOnLegendItemMinusClickListener = function () {
        this.onLegendItemMinusClickListener = undefined;
    };
    ChartStore.prototype.isBrushEnabled = function () {
        if (!this.xScale) {
            return false;
        }
        return this.xScale.type !== "ordinal" /* Ordinal */ && Boolean(this.onBrushEndListener);
    };
    ChartStore.prototype.updateParentDimensions = function (width, height, top, left) {
        var isChanged = false;
        if (width !== this.parentDimensions.width) {
            isChanged = true;
            this.parentDimensions.width = width;
        }
        if (height !== this.parentDimensions.height) {
            isChanged = true;
            this.parentDimensions.height = height;
        }
        if (top !== this.parentDimensions.top) {
            isChanged = true;
            this.parentDimensions.top = top;
        }
        if (left !== this.parentDimensions.left) {
            isChanged = true;
            this.parentDimensions.left = left;
        }
        if (isChanged) {
            this.computeChart();
        }
    };
    ChartStore.prototype.addSeriesSpec = function (seriesSpec) {
        this.seriesSpecs.set(seriesSpec.id, seriesSpec);
    };
    ChartStore.prototype.removeSeriesSpec = function (specId) {
        this.seriesSpecs.delete(specId);
    };
    /**
     * Add an axis spec to the store
     * @param axisSpec an axis spec
     */
    ChartStore.prototype.addAxisSpec = function (axisSpec) {
        this.axesSpecs.set(axisSpec.id, axisSpec);
    };
    ChartStore.prototype.removeAxisSpec = function (axisId) {
        this.axesSpecs.delete(axisId);
    };
    ChartStore.prototype.addAnnotationSpec = function (annotationSpec) {
        if (specs_1.isLineAnnotation(annotationSpec)) {
            var style = annotationSpec.style;
            var mergedLineStyle = theme_1.mergeWithDefaultAnnotationLine(style);
            annotationSpec.style = mergedLineStyle;
        }
        if (specs_1.isRectAnnotation(annotationSpec)) {
            var style = annotationSpec.style;
            var mergedRectStyle = theme_1.mergeWithDefaultAnnotationRect(style);
            annotationSpec.style = mergedRectStyle;
        }
        this.annotationSpecs.set(annotationSpec.annotationId, annotationSpec);
    };
    ChartStore.prototype.removeAnnotationSpec = function (annotationId) {
        this.annotationSpecs.delete(annotationId);
    };
    ChartStore.prototype.computeChart = function () {
        var _this = this;
        this.initialized.set(false);
        // compute only if parent dimensions are computed
        if (this.parentDimensions.width === 0 || this.parentDimensions.height === 0) {
            return;
        }
        // avoid compute if no specs are specified
        if (this.seriesSpecs.size === 0) {
            return;
        }
        // When specs are not initialized, reset selectedDataSeries to null
        if (!this.specsInitialized.get()) {
            this.deselectedDataSeries = null;
        }
        var domainsByGroupId = axis_utils_1.mergeDomainsByGroupId(this.axesSpecs, this.chartRotation);
        // The last argument is optional; if not supplied, then all series will be factored into computations
        // Otherwise, deselectedDataSeries is used to restrict the computation excluding the deselected series
        var seriesDomains = utils_1.computeSeriesDomains(this.seriesSpecs, domainsByGroupId, this.xDomain, this.deselectedDataSeries);
        this.seriesDomainsAndData = seriesDomains;
        // Merge all series spec custom colors with state custom colors map
        var updatedCustomSeriesColors = utils_1.getUpdatedCustomSeriesColors(this.seriesSpecs);
        this.customSeriesColors = new Map(__spread(this.customSeriesColors, updatedCustomSeriesColors));
        // tslint:disable-next-line:no-console
        // console.log({ colors: seriesDomains.seriesColors });
        // tslint:disable-next-line:no-console
        // console.log({ seriesDomains });
        this.seriesColorMap = series_1.getSeriesColorMap(seriesDomains.seriesColors, this.chartTheme.colors, this.customSeriesColors);
        this.legendItems = legend_1.computeLegend(seriesDomains.seriesColors, this.seriesColorMap, this.seriesSpecs, this.chartTheme.colors.defaultVizColor, this.axesSpecs, this.deselectedDataSeries);
        // tslint:disable-next-line:no-console
        // console.log({ legendItems: this.legendItems });
        var xDomain = seriesDomains.xDomain, yDomain = seriesDomains.yDomain, _a = seriesDomains.formattedDataSeries, stacked = _a.stacked, nonStacked = _a.nonStacked;
        // compute how many bar series are clustered
        var totalBarsInCluster = scales_1.countBarsInCluster(stacked, nonStacked).totalBarsInCluster;
        this.totalBarsInCluster = totalBarsInCluster;
        // compute axis dimensions
        var bboxCalculator = new canvas_text_bbox_calculator_1.CanvasTextBBoxCalculator();
        this.axesTicksDimensions.clear();
        this.axesSpecs.forEach(function (axisSpec) {
            var id = axisSpec.id;
            var dimensions = axis_utils_1.computeAxisTicksDimensions(axisSpec, xDomain, yDomain, totalBarsInCluster, bboxCalculator, _this.chartRotation, _this.chartTheme.axes, _this.chartTheme.scales.barsPadding);
            if (dimensions) {
                _this.axesTicksDimensions.set(id, dimensions);
            }
        });
        bboxCalculator.destroy();
        // // compute chart dimensions
        this.chartDimensions = dimensions_1.computeChartDimensions(this.parentDimensions, this.chartTheme, this.axesTicksDimensions, this.axesSpecs, this.showLegend.get() && !this.legendCollapsed.get(), this.legendPosition);
        this.chartTransform = utils_1.computeChartTransform(this.chartDimensions, this.chartRotation);
        this.brushExtent = utils_1.computeBrushExtent(this.chartDimensions, this.chartRotation, this.chartTransform);
        var seriesGeometries = utils_1.computeSeriesGeometries(this.seriesSpecs, seriesDomains.xDomain, seriesDomains.yDomain, seriesDomains.formattedDataSeries, this.seriesColorMap, this.chartTheme, this.chartDimensions, this.chartRotation, this.axesSpecs);
        // tslint:disable-next-line:no-console
        // console.log({ seriesGeometries });
        this.geometries = seriesGeometries.geometries;
        this.xScale = seriesGeometries.scales.xScale;
        this.yScales = seriesGeometries.scales.yScales;
        this.geometriesIndex = seriesGeometries.geometriesIndex;
        this.geometriesIndexKeys = __spread(this.geometriesIndex.keys()).sort(commons_1.compareByValueAsc);
        // // compute visible ticks and their positions
        var axisTicksPositions = axis_utils_1.getAxisTicksPositions(this.chartDimensions, this.chartTheme, this.chartRotation, this.showLegend.get() && !this.legendCollapsed.get(), this.axesSpecs, this.axesTicksDimensions, seriesDomains.xDomain, seriesDomains.yDomain, totalBarsInCluster, this.legendPosition, this.chartTheme.scales.barsPadding);
        // tslint:disable-next-line:no-console
        // console.log({axisTicksPositions});
        this.axesPositions = axisTicksPositions.axisPositions;
        this.axesTicks = axisTicksPositions.axisTicks;
        this.axesVisibleTicks = axisTicksPositions.axisVisibleTicks;
        this.axesGridLinesPositions = axisTicksPositions.axisGridLinesPositions;
        // annotation computations
        var updatedAnnotationDimensions = annotation_utils_1.computeAnnotationDimensions(this.annotationSpecs, this.chartDimensions, this.chartRotation, this.yScales, this.xScale, this.axesSpecs);
        this.annotationDimensions.replace(updatedAnnotationDimensions);
        this.canDataBeAnimated = utils_1.isChartAnimatable(seriesGeometries.geometriesCounts, this.animateData);
        // temporary disabled until
        // https://github.com/elastic/elastic-charts/issues/89 and https://github.com/elastic/elastic-charts/issues/41
        this.canDataBeAnimated = false;
        this.initialized.set(true);
    };
    return ChartStore;
}());
exports.ChartStore = ChartStore;
//# sourceMappingURL=chart_state.js.map