/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.EVP;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class SignerInfoWithPkey
implements ASN1Encodable {
    static final ASN1ObjectIdentifier OID_dsa = new ASN1ObjectIdentifier("1.2.840.10040.4.1");
    static final ASN1ObjectIdentifier OID_sha1 = new ASN1ObjectIdentifier("1.3.14.3.2.26");
    static final ASN1ObjectIdentifier OID_ecdsa_with_SHA1 = new ASN1ObjectIdentifier("1.2.840.10045.4.1");
    static final ASN1ObjectIdentifier OID_rsaEncryption = new ASN1ObjectIdentifier("1.2.840.113549.1.1.1");
    private ASN1Integer version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier digAlgorithm;
    private ASN1Set authenticatedAttributes;
    private AlgorithmIdentifier digEncryptionAlgorithm;
    private ASN1OctetString encryptedDigest;
    private ASN1Set unauthenticatedAttributes;
    private PrivateKey pkey;

    public static SignerInfoWithPkey getInstance(Object o) {
        if (o instanceof SignerInfo) {
            return (SignerInfoWithPkey)o;
        }
        if (o instanceof ASN1Sequence) {
            return new SignerInfoWithPkey((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o.getClass().getName());
    }

    public SignerInfoWithPkey dup() {
        SignerInfoWithPkey copy2 = new SignerInfoWithPkey(this.version, this.issuerAndSerialNumber, this.digAlgorithm, this.authenticatedAttributes, this.digEncryptionAlgorithm, this.encryptedDigest, this.unauthenticatedAttributes);
        copy2.pkey = this.pkey;
        return copy2;
    }

    SignerInfoWithPkey() {
    }

    public SignerInfoWithPkey(ASN1Integer version2, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier digAlgorithm, ASN1Set authenticatedAttributes, AlgorithmIdentifier digEncryptionAlgorithm, ASN1OctetString encryptedDigest, ASN1Set unauthenticatedAttributes) {
        this.version = version2;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.digAlgorithm = digAlgorithm;
        this.authenticatedAttributes = authenticatedAttributes;
        this.digEncryptionAlgorithm = digEncryptionAlgorithm;
        this.encryptedDigest = encryptedDigest;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
    }

    public SignerInfoWithPkey(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = (ASN1Integer)e.nextElement();
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(e.nextElement());
        this.digAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        Object obj = e.nextElement();
        if (obj instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)obj), (boolean)false);
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        } else {
            this.authenticatedAttributes = null;
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(obj);
        }
        this.encryptedDigest = ASN1OctetString.getInstance(e.nextElement());
        this.unauthenticatedAttributes = e.hasMoreElements() ? ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)e.nextElement()), (boolean)false) : null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public ASN1Set getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digAlgorithm;
    }

    public ASN1OctetString getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digEncryptionAlgorithm;
    }

    public ASN1Set getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public void set(X509AuxCertificate x509, PrivateKey pkey, MessageDigest dgst) throws PKCS7Exception {
        boolean dsa = pkey instanceof DSAPrivateKey || pkey instanceof ECPrivateKey;
        this.version = new ASN1Integer(BigInteger.ONE);
        X500Name issuer2 = X500Name.getInstance((Object)x509.getIssuerX500Principal().getEncoded());
        BigInteger serial2 = x509.getSerialNumber();
        this.issuerAndSerialNumber = new IssuerAndSerialNumber(issuer2, serial2);
        this.pkey = pkey;
        this.digAlgorithm = dsa ? new AlgorithmIdentifier(OID_sha1) : new AlgorithmIdentifier(ASN1Registry.nid2obj(EVP.type(dgst)));
        if (pkey instanceof RSAPrivateKey) {
            this.digEncryptionAlgorithm = new AlgorithmIdentifier(OID_rsaEncryption);
        } else if (pkey instanceof DSAPrivateKey) {
            this.digEncryptionAlgorithm = new AlgorithmIdentifier(OID_dsa);
        } else if (pkey instanceof ECPrivateKey) {
            this.digEncryptionAlgorithm = new AlgorithmIdentifier(OID_ecdsa_with_SHA1);
        }
    }

    public ASN1Encodable toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.issuerAndSerialNumber);
        v.add((ASN1Encodable)this.digAlgorithm);
        if (this.authenticatedAttributes != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.authenticatedAttributes));
        }
        v.add((ASN1Encodable)this.digEncryptionAlgorithm);
        v.add((ASN1Encodable)this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.unauthenticatedAttributes));
        }
        return new DLSequence(v);
    }

    public final PrivateKey getPkey() {
        return this.pkey;
    }

    public final void setPkey(PrivateKey newPkey) {
        this.pkey = newPkey;
    }

    public void setAuthenticatedAttributes(ASN1Set authAttr) {
        this.authenticatedAttributes = authAttr;
    }

    public void setUnauthenticatedAttributes(ASN1Set unauthAttr) {
        this.unauthenticatedAttributes = unauthAttr;
    }

    public void setEncryptedDigest(ASN1OctetString encryptedDigest) {
        this.encryptedDigest = encryptedDigest;
    }

    public ASN1Encodable getSignedAttribute(int nid) {
        return SignerInfoWithPkey.getAttribute(this.authenticatedAttributes, nid);
    }

    public ASN1Encodable getAttribute(int nid) {
        return SignerInfoWithPkey.getAttribute(this.unauthenticatedAttributes, nid);
    }

    static ASN1Encodable getAttribute(ASN1Set sk, int nid) {
        ASN1ObjectIdentifier oid2 = ASN1Registry.nid2obj(nid);
        if (oid2 == null || sk == null) {
            return null;
        }
        Enumeration e = sk.getObjects();
        while (e.hasMoreElements()) {
            Attribute xa = Attribute.getInstance(e.nextElement());
            if (!oid2.equals((Object)xa.getAttrType())) continue;
            if (xa.getAttrValues().size() > 0) {
                return xa.getAttrValues().getObjectAt(0);
            }
            return null;
        }
        return null;
    }

    public void addSignedAttribute(int atrType, ASN1Encodable value2) {
        this.authenticatedAttributes = this.addAttribute(this.authenticatedAttributes, atrType, value2);
    }

    public void addAttribute(int atrType, ASN1Encodable value2) {
        this.unauthenticatedAttributes = this.addAttribute(this.unauthenticatedAttributes, atrType, value2);
    }

    private ASN1Set addAttribute(ASN1Set base, int atrType, ASN1Encodable value2) {
        Attribute attr;
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (base == null) {
            base = new DERSet();
        }
        Enumeration e = base.getObjects();
        while (e.hasMoreElements()) {
            attr = Attribute.getInstance(e.nextElement());
            if (ASN1Registry.oid2nid(attr.getAttrType()) == atrType) continue;
            vector.add((ASN1Encodable)attr);
        }
        ASN1ObjectIdentifier ident = ASN1Registry.nid2obj(atrType);
        attr = new Attribute(ident, (ASN1Set)new DERSet(value2));
        vector.add((ASN1Encodable)attr);
        return new DERSet(vector);
    }

    public ASN1Primitive toASN1Primitive() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

