/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.ui.components.JFreeChartDialog;
import org.gephi.ui.components.SimpleHTMLReport;
import org.gephi.ui.utils.ChartsUtils;
import org.gephi.utils.StatisticsUtils;
import org.jfree.chart.JFreeChart;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class GeneralNumberListStatisticsReportUI
extends JPanel
implements AttributeColumnsManipulatorUI,
ManipulatorUI {
    private final Number[] numbers;
    private final String dataName;
    private final String dialogTitle;
    private final BigDecimal[] statistics;
    private JFreeChart boxPlot;
    private JFreeChart scatterPlot;
    private JFreeChart histogram;
    private JFreeChartDialog boxPlotDialog;
    private JFreeChartDialog scatterPlotDialog;
    private JFreeChartDialog histogramDialog;
    private SimpleHTMLReport reportDialog;
    private int histogramDivisions;
    private static final int MIN_HISTOGRAM_DIVISIONS = 1;
    private static final int MAX_HISTOGRAM_DIVISIONS = 50;
    private JButton configureBoxPlotButton;
    private JButton configureHistogramButton;
    private JButton configureScatterPlotButton;
    private JComboBox divisionsComboBox;
    private JLabel divisionsLabel;
    private JSeparator jSeparator1;
    private JButton showReportButton;
    private JCheckBox useLinearRegression;
    private JCheckBox useLinesCheckBox;

    public GeneralNumberListStatisticsReportUI(Number[] numbers, String dataName, String dialogTitle) {
        this.initComponents();
        this.numbers = numbers;
        this.dataName = dataName;
        this.dialogTitle = dialogTitle;
        this.statistics = StatisticsUtils.getAllStatistics((Number[])numbers);
        for (int i = 1; i <= 50; ++i) {
            this.divisionsComboBox.addItem(i);
        }
        this.divisionsComboBox.setSelectedIndex(9);
        this.setChartControlsEnabled(this.statistics != null);
    }

    public void setup(AttributeColumnsManipulator m, GraphModel graphModel, Table table, Column column, DialogControls dialogControls) {
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
    }

    private void setChartControlsEnabled(boolean enabled) {
        this.configureBoxPlotButton.setEnabled(enabled);
        this.configureScatterPlotButton.setEnabled(enabled);
        this.configureHistogramButton.setEnabled(enabled);
        this.useLinearRegression.setEnabled(enabled);
        this.useLinesCheckBox.setEnabled(enabled);
        this.divisionsLabel.setEnabled(enabled);
        this.divisionsComboBox.setEnabled(enabled);
    }

    public void unSetup() {
        if (this.reportDialog != null) {
            this.reportDialog.dispose();
        }
        if (this.boxPlotDialog != null) {
            this.boxPlotDialog.dispose();
        }
        if (this.scatterPlotDialog != null) {
            this.scatterPlotDialog.dispose();
        }
        if (this.histogramDialog != null) {
            this.histogramDialog.dispose();
        }
    }

    public String getDisplayName() {
        return this.dialogTitle;
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return false;
    }

    private void prepareBoxPlot() {
        if (this.boxPlot == null) {
            this.boxPlot = ChartsUtils.buildBoxPlot((Number[])this.numbers, (String)this.dataName);
        }
    }

    private void prepareScatterPlot() {
        if (this.scatterPlot == null) {
            this.scatterPlot = ChartsUtils.buildScatterPlot((Number[])this.numbers, (String)this.dataName, (boolean)this.useLinesCheckBox.isSelected(), (boolean)this.useLinearRegression.isSelected());
        }
    }

    private void prepareHistogram() {
        this.histogram = ChartsUtils.buildHistogram((Number[])this.numbers, (String)this.dataName, (int)this.histogramDivisions);
    }

    private void initComponents() {
        this.configureBoxPlotButton = new JButton();
        this.configureScatterPlotButton = new JButton();
        this.showReportButton = new JButton();
        this.useLinesCheckBox = new JCheckBox();
        this.useLinearRegression = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.configureHistogramButton = new JButton();
        this.divisionsLabel = new JLabel();
        this.divisionsComboBox = new JComboBox();
        this.configureBoxPlotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/datalab/plugin/manipulators/resources/wooden-box.png")));
        this.configureBoxPlotButton.setText(NbBundle.getMessage(GeneralNumberListStatisticsReportUI.class, (String)"GeneralNumberListStatisticsReportUI.configureBoxPlotButton.text"));
        this.configureBoxPlotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralNumberListStatisticsReportUI.this.configureBoxPlotButtonActionPerformed(evt);
            }
        });
        this.configureScatterPlotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/datalab/plugin/manipulators/resources/chart-up.png")));
        this.configureScatterPlotButton.setText(NbBundle.getMessage(GeneralNumberListStatisticsReportUI.class, (String)"GeneralNumberListStatisticsReportUI.configureScatterPlotButton.text_1"));
        this.configureScatterPlotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralNumberListStatisticsReportUI.this.configureScatterPlotButtonActionPerformed(evt);
            }
        });
        this.showReportButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/datalab/plugin/manipulators/resources/application-block.png")));
        this.showReportButton.setText(NbBundle.getMessage(GeneralNumberListStatisticsReportUI.class, (String)"GeneralNumberListStatisticsReportUI.showReportButton.text"));
        this.showReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralNumberListStatisticsReportUI.this.showReportButtonActionPerformed(evt);
            }
        });
        this.useLinesCheckBox.setText(NbBundle.getMessage(GeneralNumberListStatisticsReportUI.class, (String)"GeneralNumberListStatisticsReportUI.useLinesCheckBox.text"));
        this.useLinesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralNumberListStatisticsReportUI.this.useLinesCheckBoxActionPerformed(evt);
            }
        });
        this.useLinearRegression.setText(NbBundle.getMessage(GeneralNumberListStatisticsReportUI.class, (String)"GeneralNumberListStatisticsReportUI.useLinearRegression.text"));
        this.useLinearRegression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralNumberListStatisticsReportUI.this.useLinearRegressionActionPerformed(evt);
            }
        });
        this.configureHistogramButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/datalab/plugin/manipulators/resources/chart.png")));
        this.configureHistogramButton.setText(NbBundle.getMessage(GeneralNumberListStatisticsReportUI.class, (String)"GeneralNumberListStatisticsReportUI.configureHistogramButton.text"));
        this.configureHistogramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralNumberListStatisticsReportUI.this.configureHistogramButtonActionPerformed(evt);
            }
        });
        this.divisionsLabel.setText(NbBundle.getMessage(GeneralNumberListStatisticsReportUI.class, (String)"GeneralNumberListStatisticsReportUI.divisionsLabel.text"));
        this.divisionsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GeneralNumberListStatisticsReportUI.this.divisionsComboBoxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showReportButton).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configureHistogramButton, -1, 163, Short.MAX_VALUE).addComponent(this.configureScatterPlotButton, -1, 163, Short.MAX_VALUE).addComponent(this.configureBoxPlotButton, GroupLayout.Alignment.TRAILING, -1, 163, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.useLinesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useLinearRegression)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.divisionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.divisionsComboBox, -2, -1, -2))))).addContainerGap()).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 393, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.configureBoxPlotButton, -2, 25, -2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configureScatterPlotButton).addComponent(this.useLinesCheckBox).addComponent(this.useLinearRegression)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configureHistogramButton).addComponent(this.divisionsLabel).addComponent(this.divisionsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -1, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showReportButton).addContainerGap()));
    }

    private void configureBoxPlotButtonActionPerformed(ActionEvent evt) {
        this.prepareBoxPlot();
        if (this.boxPlotDialog != null) {
            this.boxPlotDialog.setVisible(true);
        } else {
            this.boxPlotDialog = new JFreeChartDialog(WindowManager.getDefault().getMainWindow(), this.boxPlot.getTitle().getText(), this.boxPlot, 300, 500);
        }
    }

    private void configureScatterPlotButtonActionPerformed(ActionEvent evt) {
        this.prepareScatterPlot();
        if (this.scatterPlotDialog != null) {
            this.scatterPlotDialog.setVisible(true);
        } else {
            this.scatterPlotDialog = new JFreeChartDialog(WindowManager.getDefault().getMainWindow(), this.scatterPlot.getTitle().getText(), this.scatterPlot, 600, 400);
        }
    }

    private void showReportButtonActionPerformed(ActionEvent evt) {
        this.prepareBoxPlot();
        this.prepareScatterPlot();
        if (this.histogram == null) {
            this.prepareHistogram();
        }
        String html = ChartsUtils.getStatisticsReportHTML((String)this.dataName, (BigDecimal[])this.statistics, (JFreeChart)this.boxPlot, (JFreeChart)this.scatterPlot, (JFreeChart)this.histogram, (Dimension)(this.boxPlotDialog != null ? this.boxPlotDialog.getChartSize() : null), (Dimension)(this.scatterPlotDialog != null ? this.scatterPlotDialog.getChartSize() : null), this.histogramDialog != null ? this.histogramDialog.getChartSize() : null);
        if (this.reportDialog != null) {
            this.reportDialog.dispose();
        }
        this.reportDialog = new SimpleHTMLReport(WindowManager.getDefault().getMainWindow(), html);
    }

    private void useLinesCheckBoxActionPerformed(ActionEvent evt) {
        if (this.scatterPlot != null) {
            ChartsUtils.setScatterPlotLinesEnabled((JFreeChart)this.scatterPlot, (boolean)this.useLinesCheckBox.isSelected());
        }
    }

    private void useLinearRegressionActionPerformed(ActionEvent evt) {
        if (this.scatterPlot != null) {
            ChartsUtils.setScatterPlotLinearRegressionEnabled((JFreeChart)this.scatterPlot, (boolean)this.useLinearRegression.isSelected());
        }
    }

    private void divisionsComboBoxItemStateChanged(ItemEvent evt) {
        this.histogramDivisions = this.divisionsComboBox.getSelectedIndex() + 1;
        if (this.histogramDialog != null) {
            this.prepareHistogram();
            this.histogramDialog.setChart(this.histogram);
        }
    }

    private void configureHistogramButtonActionPerformed(ActionEvent evt) {
        this.prepareHistogram();
        if (this.histogramDialog != null) {
            this.histogramDialog.setVisible(true);
        } else {
            this.histogramDialog = new JFreeChartDialog(WindowManager.getDefault().getMainWindow(), this.histogram.getTitle().getText(), this.histogram, 600, 400);
        }
    }
}

