/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.InMemoryPersistedState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.plugins.MetaDataUpgrader;
import org.elasticsearch.transport.TransportService;

public class GatewayMetaState
implements ClusterStateApplier,
CoordinationState.PersistedState {
    protected static final Logger logger = LogManager.getLogger(GatewayMetaState.class);
    private final NodeEnvironment nodeEnv;
    private final MetaStateService metaStateService;
    private final Settings settings;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final TransportService transportService;
    protected Manifest previousManifest;
    protected ClusterState previousClusterState;
    protected boolean incrementalWrite;

    public GatewayMetaState(Settings settings, NodeEnvironment nodeEnv, MetaStateService metaStateService, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader, TransportService transportService, ClusterService clusterService, IndicesService indicesService) throws IOException {
        this.settings = settings;
        this.nodeEnv = nodeEnv;
        this.metaStateService = metaStateService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.upgradeMetaData(metaDataIndexUpgradeService, metaDataUpgrader);
        this.initializeClusterState(ClusterName.CLUSTER_NAME_SETTING.get(settings));
        this.incrementalWrite = false;
    }

    public CoordinationState.PersistedState getPersistedState(Settings settings, ClusterApplierService clusterApplierService) {
        this.applyClusterStateUpdaters();
        if (!DiscoveryNode.isMasterNode(settings)) {
            clusterApplierService.addLowPriorityApplier(this);
            return new InMemoryPersistedState(this.getCurrentTerm(), this.getLastAcceptedState());
        }
        return this;
    }

    private void initializeClusterState(ClusterName clusterName) throws IOException {
        long startNS = System.nanoTime();
        Tuple<Manifest, MetaData> manifestAndMetaData = this.metaStateService.loadFullState();
        this.previousManifest = (Manifest)manifestAndMetaData.v1();
        MetaData metaData = (MetaData)manifestAndMetaData.v2();
        this.previousClusterState = ClusterState.builder(clusterName).version(this.previousManifest.getClusterStateVersion()).metaData(metaData).build();
        logger.debug("took {} to load state", (Object)TimeValue.timeValueMillis((long)TimeValue.nsecToMSec((long)(System.nanoTime() - startNS))));
    }

    public void applyClusterStateUpdaters() {
        assert (this.previousClusterState.nodes().getLocalNode() == null) : "applyClusterStateUpdaters must only be called once";
        assert (this.transportService.getLocalNode() != null) : "transport service is not yet started";
        this.previousClusterState = Function.identity().andThen(ClusterStateUpdaters::addStateNotRecoveredBlock).andThen(state -> ClusterStateUpdaters.setLocalNode(state, this.transportService.getLocalNode())).andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, this.clusterService.getClusterSettings())).andThen(ClusterStateUpdaters::recoverClusterBlocks).apply(this.previousClusterState);
    }

    protected void upgradeMetaData(MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) throws IOException {
        if (this.isMasterOrDataNode()) {
            try {
                Tuple<Manifest, MetaData> metaStateAndData = this.metaStateService.loadFullState();
                Manifest manifest = (Manifest)metaStateAndData.v1();
                MetaData metaData = (MetaData)metaStateAndData.v2();
                AtomicClusterStateWriter writer = new AtomicClusterStateWriter(this.metaStateService, manifest);
                MetaData upgradedMetaData = GatewayMetaState.upgradeMetaData(metaData, metaDataIndexUpgradeService, metaDataUpgrader);
                long globalStateGeneration = !MetaData.isGlobalStateEquals(metaData, upgradedMetaData) ? writer.writeGlobalState("upgrade", upgradedMetaData) : manifest.getGlobalGeneration();
                HashMap<Index, Long> indices = new HashMap<Index, Long>(manifest.getIndexGenerations());
                for (IndexMetaData indexMetaData : upgradedMetaData) {
                    if (metaData.hasIndexMetaData(indexMetaData)) continue;
                    long generation = writer.writeIndex("upgrade", indexMetaData);
                    indices.put(indexMetaData.getIndex(), generation);
                }
                Manifest newManifest = new Manifest(manifest.getCurrentTerm(), manifest.getClusterStateVersion(), globalStateGeneration, indices);
                writer.writeManifestAndCleanup("startup", newManifest);
            }
            catch (Exception e) {
                logger.error("failed to read or upgrade local state, exiting...", (Throwable)e);
                throw e;
            }
        }
    }

    protected boolean isMasterOrDataNode() {
        return DiscoveryNode.isMasterNode(this.settings) || DiscoveryNode.isDataNode(this.settings);
    }

    public MetaData getMetaData() {
        return this.previousClusterState.metaData();
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        if (!this.isMasterOrDataNode()) {
            return;
        }
        if (event.state().blocks().disableStatePersistence()) {
            this.incrementalWrite = false;
            return;
        }
        try {
            if (event.state().term() > this.getCurrentTerm()) {
                this.innerSetCurrentTerm(event.state().term());
            }
            this.updateClusterState(event.state(), event.previousState());
            this.incrementalWrite = true;
        }
        catch (WriteStateException e) {
            logger.warn("Exception occurred when storing new meta data", (Throwable)e);
        }
    }

    @Override
    public long getCurrentTerm() {
        return this.previousManifest.getCurrentTerm();
    }

    @Override
    public ClusterState getLastAcceptedState() {
        assert (this.previousClusterState.nodes().getLocalNode() != null) : "Cluster state is not fully built yet";
        return this.previousClusterState;
    }

    @Override
    public void setCurrentTerm(long currentTerm) {
        try {
            this.innerSetCurrentTerm(currentTerm);
        }
        catch (WriteStateException e) {
            logger.error((Message)new ParameterizedMessage("Failed to set current term to {}", (Object)currentTerm), (Throwable)e);
            e.rethrowAsErrorOrUncheckedException();
        }
    }

    private void innerSetCurrentTerm(long currentTerm) throws WriteStateException {
        Manifest manifest = new Manifest(currentTerm, this.previousManifest.getClusterStateVersion(), this.previousManifest.getGlobalGeneration(), new HashMap<Index, Long>(this.previousManifest.getIndexGenerations()));
        this.metaStateService.writeManifestAndCleanup("current term changed", manifest);
        this.previousManifest = manifest;
    }

    @Override
    public void setLastAcceptedState(ClusterState clusterState) {
        try {
            this.incrementalWrite = this.previousClusterState.term() == clusterState.term();
            this.updateClusterState(clusterState, this.previousClusterState);
        }
        catch (WriteStateException e) {
            logger.error((Message)new ParameterizedMessage("Failed to set last accepted state with version {}", (Object)clusterState.version()), (Throwable)e);
            e.rethrowAsErrorOrUncheckedException();
        }
    }

    protected void updateClusterState(ClusterState newState, ClusterState previousState) throws WriteStateException {
        MetaData newMetaData = newState.metaData();
        AtomicClusterStateWriter writer = new AtomicClusterStateWriter(this.metaStateService, this.previousManifest);
        long globalStateGeneration = this.writeGlobalState(writer, newMetaData);
        Map<Index, Long> indexGenerations = this.writeIndicesMetadata(writer, newState, previousState);
        Manifest manifest = new Manifest(this.previousManifest.getCurrentTerm(), newState.version(), globalStateGeneration, indexGenerations);
        this.writeManifest(writer, manifest);
        this.previousManifest = manifest;
        this.previousClusterState = newState;
    }

    private void writeManifest(AtomicClusterStateWriter writer, Manifest manifest) throws WriteStateException {
        if (!manifest.equals(this.previousManifest)) {
            writer.writeManifestAndCleanup("changed", manifest);
        }
    }

    private Map<Index, Long> writeIndicesMetadata(AtomicClusterStateWriter writer, ClusterState newState, ClusterState previousState) throws WriteStateException {
        Map<Index, Long> previouslyWrittenIndices = this.previousManifest.getIndexGenerations();
        Set<Index> relevantIndices = GatewayMetaState.getRelevantIndices(newState, previousState, previouslyWrittenIndices.keySet());
        HashMap<Index, Long> newIndices = new HashMap<Index, Long>();
        MetaData previousMetaData = this.incrementalWrite ? previousState.metaData() : null;
        List<IndexMetaDataAction> actions = GatewayMetaState.resolveIndexMetaDataActions(previouslyWrittenIndices, relevantIndices, previousMetaData, newState.metaData());
        for (IndexMetaDataAction action : actions) {
            long generation = action.execute(writer);
            newIndices.put(action.getIndex(), generation);
        }
        return newIndices;
    }

    private long writeGlobalState(AtomicClusterStateWriter writer, MetaData newMetaData) throws WriteStateException {
        if (!this.incrementalWrite || !MetaData.isGlobalStateEquals(this.previousClusterState.metaData(), newMetaData)) {
            return writer.writeGlobalState("changed", newMetaData);
        }
        return this.previousManifest.getGlobalGeneration();
    }

    public static Set<Index> getRelevantIndices(ClusterState state, ClusterState previousState, Set<Index> previouslyWrittenIndices) {
        Set<Index> relevantIndices = GatewayMetaState.isDataOnlyNode(state) ? GatewayMetaState.getRelevantIndicesOnDataOnlyNode(state, previousState, previouslyWrittenIndices) : (state.nodes().getLocalNode().isMasterNode() ? GatewayMetaState.getRelevantIndicesForMasterEligibleNode(state) : Collections.emptySet());
        return relevantIndices;
    }

    private static boolean isDataOnlyNode(ClusterState state) {
        return !state.nodes().getLocalNode().isMasterNode() && state.nodes().getLocalNode().isDataNode();
    }

    static MetaData upgradeMetaData(MetaData metaData, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) {
        boolean changed = false;
        MetaData.Builder upgradedMetaData = MetaData.builder(metaData);
        for (IndexMetaData indexMetaData : metaData) {
            IndexMetaData newMetaData;
            changed |= indexMetaData != (newMetaData = metaDataIndexUpgradeService.upgradeIndexMetaData(indexMetaData, Version.CURRENT.minimumIndexCompatibilityVersion()));
            upgradedMetaData.put(newMetaData, false);
        }
        if (GatewayMetaState.applyPluginUpgraders(metaData.getCustoms(), metaDataUpgrader.customMetaDataUpgraders, upgradedMetaData::removeCustom, upgradedMetaData::putCustom)) {
            changed = true;
        }
        if (GatewayMetaState.applyPluginUpgraders(metaData.getTemplates(), metaDataUpgrader.indexTemplateMetaDataUpgraders, upgradedMetaData::removeTemplate, (s, indexTemplateMetaData) -> upgradedMetaData.put((IndexTemplateMetaData)indexTemplateMetaData))) {
            changed = true;
        }
        return changed ? upgradedMetaData.build() : metaData;
    }

    private static <Data> boolean applyPluginUpgraders(ImmutableOpenMap<String, Data> existingData, UnaryOperator<Map<String, Data>> upgrader, Consumer<String> removeData, BiConsumer<String, Data> putData) {
        HashMap<String, Object> existingMap = new HashMap<String, Object>();
        for (ObjectObjectCursor<String, Data> objectObjectCursor : existingData) {
            existingMap.put((String)objectObjectCursor.key, objectObjectCursor.value);
        }
        Map upgradedCustoms = (Map)upgrader.apply(existingMap);
        if (!upgradedCustoms.equals(existingMap)) {
            existingMap.keySet().forEach(removeData);
            for (Map.Entry upgradedCustomEntry : upgradedCustoms.entrySet()) {
                putData.accept((String)upgradedCustomEntry.getKey(), upgradedCustomEntry.getValue());
            }
            return true;
        }
        return false;
    }

    public static List<IndexMetaDataAction> resolveIndexMetaDataActions(Map<Index, Long> previouslyWrittenIndices, Set<Index> relevantIndices, MetaData previousMetaData, MetaData newMetaData) {
        ArrayList<IndexMetaDataAction> actions = new ArrayList<IndexMetaDataAction>();
        for (Index index : relevantIndices) {
            IndexMetaData previousIndexMetaData;
            IndexMetaData newIndexMetaData = newMetaData.getIndexSafe(index);
            IndexMetaData indexMetaData = previousIndexMetaData = previousMetaData == null ? null : previousMetaData.index(index);
            if (!previouslyWrittenIndices.containsKey(index) || previousIndexMetaData == null) {
                actions.add(new WriteNewIndexMetaData(newIndexMetaData));
                continue;
            }
            if (previousIndexMetaData.getVersion() != newIndexMetaData.getVersion()) {
                actions.add(new WriteChangedIndexMetaData(previousIndexMetaData, newIndexMetaData));
                continue;
            }
            actions.add(new KeepPreviousGeneration(index, previouslyWrittenIndices.get(index)));
        }
        return actions;
    }

    private static Set<Index> getRelevantIndicesOnDataOnlyNode(ClusterState state, ClusterState previousState, Set<Index> previouslyWrittenIndices) {
        RoutingNode newRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (newRoutingNode == null) {
            throw new IllegalStateException("cluster state does not contain this node - cannot write index meta state");
        }
        HashSet<Index> indices = new HashSet<Index>();
        for (ShardRouting routing : newRoutingNode) {
            indices.add(routing.index());
        }
        for (IndexMetaData indexMetaData : state.metaData()) {
            boolean isOrWasClosed = indexMetaData.getState().equals((Object)IndexMetaData.State.CLOSE);
            IndexMetaData previousMetaData = previousState.metaData().index(indexMetaData.getIndex());
            if (previousMetaData != null) {
                boolean bl = isOrWasClosed = isOrWasClosed || previousMetaData.getState().equals((Object)IndexMetaData.State.CLOSE);
            }
            if (!previouslyWrittenIndices.contains(indexMetaData.getIndex()) || !isOrWasClosed) continue;
            indices.add(indexMetaData.getIndex());
        }
        return indices;
    }

    private static Set<Index> getRelevantIndicesForMasterEligibleNode(ClusterState state) {
        HashSet<Index> relevantIndices = new HashSet<Index>();
        for (IndexMetaData indexMetaData : state.metaData()) {
            relevantIndices.add(indexMetaData.getIndex());
        }
        return relevantIndices;
    }

    public static class WriteChangedIndexMetaData
    implements IndexMetaDataAction {
        private final IndexMetaData newIndexMetaData;
        private final IndexMetaData oldIndexMetaData;

        WriteChangedIndexMetaData(IndexMetaData oldIndexMetaData, IndexMetaData newIndexMetaData) {
            this.oldIndexMetaData = oldIndexMetaData;
            this.newIndexMetaData = newIndexMetaData;
        }

        @Override
        public Index getIndex() {
            return this.newIndexMetaData.getIndex();
        }

        @Override
        public long execute(AtomicClusterStateWriter writer) throws WriteStateException {
            return writer.writeIndex("version changed from [" + this.oldIndexMetaData.getVersion() + "] to [" + this.newIndexMetaData.getVersion() + "]", this.newIndexMetaData);
        }
    }

    public static class WriteNewIndexMetaData
    implements IndexMetaDataAction {
        private final IndexMetaData indexMetaData;

        WriteNewIndexMetaData(IndexMetaData indexMetaData) {
            this.indexMetaData = indexMetaData;
        }

        @Override
        public Index getIndex() {
            return this.indexMetaData.getIndex();
        }

        @Override
        public long execute(AtomicClusterStateWriter writer) throws WriteStateException {
            return writer.writeIndex("freshly created", this.indexMetaData);
        }
    }

    public static class KeepPreviousGeneration
    implements IndexMetaDataAction {
        private final Index index;
        private final long generation;

        KeepPreviousGeneration(Index index, long generation) {
            this.index = index;
            this.generation = generation;
        }

        @Override
        public Index getIndex() {
            return this.index;
        }

        @Override
        public long execute(AtomicClusterStateWriter writer) {
            return this.generation;
        }
    }

    public static interface IndexMetaDataAction {
        public Index getIndex();

        public long execute(AtomicClusterStateWriter var1) throws WriteStateException;
    }

    static class AtomicClusterStateWriter {
        private static final String FINISHED_MSG = "AtomicClusterStateWriter is finished";
        private final List<Runnable> commitCleanupActions;
        private final List<Runnable> rollbackCleanupActions;
        private final Manifest previousManifest;
        private final MetaStateService metaStateService;
        private boolean finished;

        AtomicClusterStateWriter(MetaStateService metaStateService, Manifest previousManifest) {
            this.metaStateService = metaStateService;
            assert (previousManifest != null);
            this.previousManifest = previousManifest;
            this.commitCleanupActions = new ArrayList<Runnable>();
            this.rollbackCleanupActions = new ArrayList<Runnable>();
            this.finished = false;
        }

        long writeGlobalState(String reason, MetaData metaData) throws WriteStateException {
            assert (!this.finished) : "AtomicClusterStateWriter is finished";
            try {
                this.rollbackCleanupActions.add(() -> this.metaStateService.cleanupGlobalState(this.previousManifest.getGlobalGeneration()));
                long generation = this.metaStateService.writeGlobalState(reason, metaData);
                this.commitCleanupActions.add(() -> this.metaStateService.cleanupGlobalState(generation));
                return generation;
            }
            catch (WriteStateException e) {
                this.rollback();
                throw e;
            }
        }

        long writeIndex(String reason, IndexMetaData metaData) throws WriteStateException {
            assert (!this.finished) : "AtomicClusterStateWriter is finished";
            try {
                Index index = metaData.getIndex();
                Long previousGeneration = this.previousManifest.getIndexGenerations().get(index);
                if (previousGeneration != null) {
                    this.rollbackCleanupActions.add(() -> this.metaStateService.cleanupIndex(index, previousGeneration));
                }
                long generation = this.metaStateService.writeIndex(reason, metaData);
                this.commitCleanupActions.add(() -> this.metaStateService.cleanupIndex(index, generation));
                return generation;
            }
            catch (WriteStateException e) {
                this.rollback();
                throw e;
            }
        }

        long writeManifestAndCleanup(String reason, Manifest manifest) throws WriteStateException {
            assert (!this.finished) : "AtomicClusterStateWriter is finished";
            try {
                long generation = this.metaStateService.writeManifestAndCleanup(reason, manifest);
                this.commitCleanupActions.forEach(Runnable::run);
                this.finished = true;
                return generation;
            }
            catch (WriteStateException e) {
                if (!e.isDirty()) {
                    this.rollback();
                }
                throw e;
            }
        }

        void rollback() {
            this.rollbackCleanupActions.forEach(Runnable::run);
            this.finished = true;
        }
    }
}

