/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.utils.WellKnownText;

public final class GeometryParser {
    private GeometryParser() {
    }

    public static Geometry parse(XContentParser parser, boolean orientation, boolean coerce, boolean ignoreZValue) throws IOException, ParseException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return GeoJson.fromXContent(parser, orientation, coerce, ignoreZValue);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return WellKnownText.fromWKT((String)parser.text());
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }
}

